// DlgProjectProperty.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"		// For FFGetApp().
#include "UtilErr.h"			// For FFErrorBox.
#include "UtilFile.h"			// For FFGetFileDirectory.
#include "UtilStr.h"			// For FFGuidToString.
#include "UtilDlg.h"			// For FFSetDlgItemText.
#include "UtilWin.h"			// For FFSetWindowText.
#include "HiProject.h"			// For FCHiProject.
#include "DynamicDb.h"			// For g_pFileServer.
#include "ProjectCopy.h"		// For FCProjectCopy.
#include "DlgProjectMember.h"	// For CFCDlgProjectMember.
#include "DlgHidocumentList.h"	// For CFCDlgHidocumentList.
#include "DlgProjectProperty.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// 06.03.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#define HPD_MAX_PROJECT_DIR_PATH	(_MAX_PATH - 60)	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiNmFjBoFjCgMiBeC_xHqqkZx_

/////////////////////////////////////////////////////////////////////////////
// CFCDlgProjectProperty _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

static DWORD myKindToTemplate (CFCDlgProjectProperty::DlgKind dlgKind)
{
	// _xZkqqHx_jAfGiLeLiNoMjAkMjHhAiCmMiPoKiNiHiCmGiDhGiDiNiDhAiDgFiDeCjHhAiCmFiDgFiDjDiDhGiDiMiBfLiDgHiCpAjAnIiCoIjBnGiCkGiBeC_xHqqkZx_
	switch (dlgKind)
	{
	case CFCDlgProjectProperty::CREATE:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkMiBeC_xHqqkZx_
	case CFCDlgProjectProperty::SAVE:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJjGlMjBePiCpAiCmCiCkPiCmEjFnLjBlGiBeC_xHqqkZx_
		return IDD_DLG_CREATE_PROJECT;
	default:	// PROPERTY _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiBeC_xHqqkZx_
		return IDD_DLG_PROJECT_PROPERTY;
	}
} // myKindToTemplate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::CFCDlgProjectProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dlgKind	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiNoMjAkMiCmMiOoNjHnOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgProjectProperty::CFCDlgProjectProperty (DlgKind dlgKind, CWnd* pParent /*=NULL*/)
					:	BASE_CLASS(myKindToTemplate(dlgKind), pParent),
						m_dlgKind(dlgKind),					// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAfGiLeLiNoMjAkMjHhAiDfPiDeDiDeBiDiNiDePiCkJiBeI_xHqqkZx_
						m_bCanModify(TRUE),					// _xZkqqHx_jFnCiPfHiJmCjEfMiCkJiBeI_xHqqkZx_
						m_bSpecFilePath(FALSE),				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAjClMjAnKiOhHjCoIiClDiClJiCoJiCkJiBeI_xHqqkZx_
						m_guidEditorUserId(GUID_NULL),		// _xZkqqHx_jFnCiPfHiOnCiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						m_guidCreatorUserId(GUID_NULL),		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
						m_bIsRegisterCreatorUserId(TRUE),	// _xZkqqHx_iNoMiOnCiPoOjFpBiCpAjDgPjIfOiClHiCoJiCkJiBeI_xHqqkZx_
						m_bIsAllowToJoinUsersGroup(TRUE),	// _xZkqqHx_jAfGiLeLiDiGiBfLiDfFiCmMiOkJiMmIjDgPjIfOiCpAiLjGiJmCiClHiCoJiBeI_xHqqkZx_
						m_fdstDate(FDSECTIME(-1)),			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiOjOiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
						m_dwPathError(0),					// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
// 06.04.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
						m_pProjectCopy(NULL)				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDhDiBfLiBeC_xHqqkZx_

{
	//{{AFX_DATA_INIT(CFCDlgProjectProperty)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT

	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNjCiGiCmMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
	m_bProhibitMsg = TRUE;

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiDfOiDeDiDgHiDiLiBhFiDhGiDiNiDfHiDeGiDeOiDgHiCmJjGlMjBePiCpAjFhEiCkPiCmEjFnLjBlGiBhGiCpAjAnNjCoIiBeC_xHqqkZx_
	if (dlgKind == SAVE)	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJjGlMjBePiCpAiCmCiCkPiCmEjFnLjBlGiBeC_xHqqkZx_
		m_wstrWindowTitle.LoadString(IDS_CAPTION_SAVE_PROJECT);
} // CFCDlgProjectProperty::CFCDlgProjectProperty.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgProjectProperty _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjCgMiCmFiDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	project			:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidEditorUserId:_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCpAiKeKiCkNiDiGiBfLiDfFiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iDhGiDiNiDhAiDgFiDeCjFnCiPfHiMkAiMmAiCpAjClCiCnHiCoJiClNiCnPiCmJiOhHjCoIiBeC_xHqqkZx_
 *			hwndParent		:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDlgProc		:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiDhGiDiNiDfGiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJjGlMjBePiCpAiCmCiCkPiCmEjFnLjBlGiBeBiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::Initialize (FCHiProject& project,
										const GUID& guidEditorUserId)
{
//	ASSERT(!m_bForCreation);
	m_wstrTitle = project.GetTitle();							// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	m_guidEditorUserId = guidEditorUserId;						// _xZkqqHx_jFnCiPfHiOnCiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_guidCreatorUserId = project.GetUserId();					// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_wstrCreatorUserName = project.UserIdToUserName(project.GetUserId());	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	m_bIsAllowToJoinUsersGroup = project.GetIsAllowToJoinUsersGroup();		// _xZkqqHx_jAfGiLeLiDiGiBfLiDfFiCmMiOkJiMmIjDgPjIfOiCpAiLjGiJmCiClHiCoJiBeI_xHqqkZx_
	m_wstrFilePath = project.GetFilePath();						// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLiDhAiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	m_wstrDirPath = FFGetFileDirectory(m_wstrFilePath, TRUE);
																// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_fdstDate = project.GetDate();								// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiOjOiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
	m_wstrComment = project.GetComment();						// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	project.GetMemberUserList(m_mpMemberUserList);				// _xZkqqHx_iDiBiDjDiDgPiBfLiCmMiDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	project.GetLimitedUserList(m_stLimitedUserList);			// _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiCnNiCmMjAkHiMmAiDiGiBfLiDfFiBeC_xHqqkZx_
	// _xZkqqHx_iNoMiOnCiPoOjFpBiCpAjDgPjIfOiClHiCoJiCkJiBeIiCmMiDhEiDiJiDePiBeC_xHqqkZx_
	m_bIsRegisterCreatorUserId = (m_guidCreatorUserId != GUID_NULL);			// _xZkqqHx_iNoMiOnCiPoOjFpBiCpAjDgPjIfOiClHiCoJiCkJiBeI_xHqqkZx_

//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDhDiBfLiBeC_xHqqkZx_
	m_pProjectCopy = new FCProjectCopy(project);
//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	switch (m_dlgKind)
	{
	case CREATE:	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkMiBeC_xHqqkZx_
		ASSERT(FALSE);
		break;
	case SAVE:		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmJjGlMjBePiCpAiCmCiCkPiCmEjFnLjBlGiBeC_xHqqkZx_
		// _xZkqqHx_jFnCiPfHiJmCjEfMiCkJiBeI_xHqqkZx_
		m_bCanModify = TRUE;
		break;
	default:		// PROPERTY _xZkqqHx_iDhGiDiNiDhAiDgFiDeCiBeC_xHqqkZx_
					// PROPERTY_UNTITLED, _xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiBeC_xHqqkZx_
		// _xZkqqHx_jFnCiPfHiJmCjEfMiCkJiBeI_xHqqkZx_
		// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfFiCmJjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
		m_bCanModify = project.IsQualifiedToModify(guidEditorUserId);
	}
} // CFCDlgProjectProperty::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwndParent			:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTitle			:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidCreatorUserId	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpCreatorUserName	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfFjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpDirPath			:_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiPiJiKpKjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDlgProc			:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiDhGiDiNiDfGiDfHiDiDiCpAiOhHjCoIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkMiClHiCoJiPoKiNiHiCmMiCnNjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::Initialize (const wchar_t* wcpTitle,			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
										const GUID& guidCreatorUserId,		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
										const wchar_t* wcpCreatorUserName,	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfFjGlMiBeC_xHqqkZx_
										const wchar_t* wcpDirPath)			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiPiJiKpKjCgMiBeC_xHqqkZx_
{
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkMiCmMiPoKiNiHiCmMiCnNiBeC_xHqqkZx_
	ASSERT(m_dlgKind == CREATE);
	m_wstrTitle = wcpTitle;									// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	m_guidEditorUserId = guidCreatorUserId;					// _xZkqqHx_jFnCiPfHiOnCiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_guidCreatorUserId = guidCreatorUserId;				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_wstrCreatorUserName = wcpCreatorUserName;				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	m_bIsAllowToJoinUsersGroup = TRUE;						// _xZkqqHx_jAfGiLeLiDiGiBfLiDfFiCmMiOkJiMmIjDgPjIfOiCpAiLjGiJmCiClHiCoJiBeI_xHqqkZx_
	m_wstrDirPath = wcpDirPath;								// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiPiJiKpKjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	m_fdstDate = FDSECTIME(-1);								// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiOjOiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
	m_wstrComment.erase();									// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
	m_mpMemberUserList.clear();									// _xZkqqHx_iDiBiDjDiDgPiBfLiCmMiDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	m_mpMemberUserList[guidCreatorUserId] = wcpCreatorUserName;
	m_stLimitedUserList.clear();							// _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiCnNiCmMjAkHiMmAiDiGiBfLiDfFiBeC_xHqqkZx_
	m_bCanModify = TRUE;									// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDiGiBfLiDfFiCmJjFnCiPfHiJmCjEfMiCkJiBeI_xHqqkZx_
	// _xZkqqHx_iNoMiOnCiPoOjFpBiCpAjDgPjIfOiClHiCoJiCkJiBeIiCmMiDhEiDiJiDePiBeC_xHqqkZx_
	m_bIsRegisterCreatorUserId = (m_guidCreatorUserId != GUID_NULL);			// _xZkqqHx_iNoMiOnCiPoOjFpBiCpAjDgPjIfOiClHiCoJiCkJiBeI_xHqqkZx_
} // CFCDlgProjectProperty::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::InitializeNew
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkMiClHiCoJiPoKiNiHiCmMiCnNjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::InitializeNew ()
{
	// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIiDhEiDeAiDeDiDiLiCmGiCmIiCoJiCoGiCkEiCmIiDhGiDiNiDfHiDeGiDeOiDgHjGlMiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	WString wstrTitle = FFGetApp()->GetDocString(CDocTemplate::docName);
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiBeCiDeKiDiMiDjDiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiBeC_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCmMiPoKiNiHiCmNiBeBiPoDiImKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrDirPath = g_pFileServer->GetCurrentDirectory();

// 06.01.20 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	g_pFileServer->GetNotProjectPath(wstrDirPath, wstrDirPath);

	WString wstrUniqPath;
	g_pFileServer->MakeUniqTopGroupPath(wstrUniqPath,
										wstrDirPath + L'\\' + wstrTitle,
										L".mdpj");
	FFSplitFileName(NULL, &wstrTitle, NULL, wstrUniqPath);
	// Baseclass_xZkqqHx_iCmMiPiJiKpKiJlLiCpAiOmAiNhDiBeC_xHqqkZx_
	Initialize(	wstrTitle,					// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
				FFGetApp()->GetUserId(),	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
				FFGetApp()->GetUserName(),	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfFjGlMiBeC_xHqqkZx_
				wstrDirPath);				// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiPiJiKpKjCgMiBeC_xHqqkZx_
} // CFCDlgProjectProperty::InitializeNew.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::GetMemberUserListString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiDiKiDfIiDgHiCpAjFlGiOjKjHpBiMgAiOkOiCmFiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCDlgProjectProperty::GetMemberUserListString () const
{
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeBiDiGiBfLiDfFjGlMiCmMjEhKjHpBjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	WString wstrMemberUserList;
	FCHiProject::MemberUserListToString(wstrMemberUserList, m_mpMemberUserList);
	return wstrMemberUserList;
} // CFCDlgProjectProperty::GetMemberUserListString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::GetLimitedUserListString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAkHiMmAiDiGiBfLiDfFiDiKiDfIiDgHiCpAjFlGiOjKjHpBiMgAiOkOiCmFiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkHiMmAiDiGiBfLiDfFiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCDlgProjectProperty::GetLimitedUserListString () const
{
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmMjEhKjHpBjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
	WString wstrLimitedUserList;
	FCHiProject::LimitedUserListToString(wstrLimitedUserList, m_stLimitedUserList);
	return wstrLimitedUserList;
} // CFCDlgProjectProperty::GetLimitedUserListString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::UpdateControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::UpdateControl ()
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiDgMiDfIiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_bProhibitMsg) return;
	m_bProhibitMsg = TRUE;

	WString wstrFilePath;
	WString wstrDirPath;
	if (m_dlgKind == PROPERTY_UNTITLED)
	//----- _xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiCmMiPoKiNiH_xHqqkZx_ -----
	{
		wstrFilePath.LoadString(IDS_MSG_CREATED_NOT_SAVED_FILE);
	} else
	//----- _xZkqqHx_jAfGiLeLiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhGiDiNiDhAiDgFiDeCiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		wstrFilePath = m_wstrFilePath;
		wstrDirPath = m_wstrDirPath;
	}

	DWORD dwFocusCtrlId = 0;
	if (GetFocus() != NULL)
		dwFocusCtrlId = GetFocus()->GetDlgCtrlID();

	if (dwFocusCtrlId != IDC_PJN_EDT_COMMENT)
		FFSetDlgItemText(this, IDC_PJN_EDT_COMMENT, m_wstrComment.c_str());
	if (dwFocusCtrlId != IDC_PJN_EDT_PROJECT_NAME)
		FFSetDlgItemText(this, IDC_PJN_EDT_PROJECT_NAME, m_wstrTitle.c_str());
	if (dwFocusCtrlId != IDC_PJN_EDT_FILE_NAME)
		FFSetDlgItemText(this, IDC_PJN_EDT_FILE_NAME, wstrFilePath.c_str());
	if (dwFocusCtrlId != IDC_PJN_EDT_DIR_NAME)
		FFSetDlgItemText(this, IDC_PJN_EDT_DIR_NAME, wstrDirPath.c_str());
	if (dwFocusCtrlId != IDC_PJN_CHK_INPUT_FILE_NAME)
		CheckDlgButton(IDC_PJN_CHK_INPUT_FILE_NAME, m_bSpecFilePath);
	if (dwFocusCtrlId != IDC_PJN_CHK_REGISTER_USER_ID)
		CheckDlgButton(IDC_PJN_CHK_REGISTER_USER_ID, m_bIsRegisterCreatorUserId);

	if (m_guidCreatorUserId != GUID_NULL && m_bIsRegisterCreatorUserId)
	//----- _xZkqqHx_iNoMjAkMiOnCiPoOjFpBiCpAiLeMjIfOiClDiClJiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoI_xHqqkZx_ -----
		WString wstrGuid0;
		WString wstrGuid1;
		WString wstrGuid2;
		WString wstrGuid3;
		WString wstrGuid4;
		WString wstrGuid5;
		FFGuidToString(wstrGuid1, wstrGuid2, wstrGuid3, wstrGuid4, wstrGuid5, m_guidCreatorUserId);
		wstrGuid0.Format(L"%04X", FFGetGuidCheckCode(m_guidCreatorUserId));
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID0, wstrGuid0.c_str());
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID1, wstrGuid1.c_str());
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID2, wstrGuid2.c_str());
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID3, wstrGuid3.c_str());
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID4, wstrGuid4.c_str());
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID5, wstrGuid5.c_str());
		// _xZkqqHx_iDiGiBfLiDfFjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_NAME, m_wstrCreatorUserName.c_str());
	} else
	//----- _xZkqqHx_iNoMjAkMiOnCiPoOjFpBiCpAiLeMjIfOiClDiClJiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoI_xHqqkZx_ -----
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID0, L"");
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID1, L"");
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID2, L"");
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID3, L"");
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID4, L"");
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_ID5, L"");
		// _xZkqqHx_iDiGiBfLiDfFjGlMiCpAjAnNjCoIiBeC_xHqqkZx_(guest)
		WString wstrUserName;
		wstrUserName.LoadString(IDS_GUEST);
		FFSetDlgItemText(this, IDC_PJN_EDT_USER_NAME, wstrUserName.c_str());
	}
	//-----------------------

	//----- _xZkqqHx_iOjOiKnEiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmJjAnNjCoI_xHqqkZx_ -----
//----- 06.01.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString wstrDateFormat;
//	wstrDateFormat.LoadString(IDS_HP_FORM_DATE_LONG);
//	WString wstrDate = HPCUtilStr::GetLocalDateString(wstrDateFormat.c_str(), m_fdstDate);
//	WString wstrTimeFormat;
//	wstrTimeFormat.LoadString(IDS_HP_FORM_TIME_LONG);
//	WString wstrTime = HPCUtilStr::GetLocalTimeString(wstrTimeFormat.c_str(), m_fdstDate);
//	WString wstrDateTime = wstrDate + L" " + wstrTime;
//	FFSetDlgItemText(this, IDC_PJN_EDT_CREATE_DATE, wstrDateTime.c_str());
//----- 06.01.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString wstrDateTime = TStrToWStr(COleDateTime(FdsecToFiletime(m_fdstDate)).Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
	FFSetDlgItemText(this, IDC_PJN_EDT_CREATE_DATE, wstrDateTime.c_str());
//----- 06.01.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	//-----------------------

	if (dwFocusCtrlId != IDC_PJN_CHK_ARROW_TO_JOIN_USERS_GROUP)
		CheckDlgButton(IDC_PJN_CHK_ARROW_TO_JOIN_USERS_GROUP, m_bIsAllowToJoinUsersGroup);

	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgMiDfIiDgHiDgAiDeGiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	m_bProhibitMsg = FALSE;
} // CFCDlgProjectProperty::UpdateControl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::UpdateVariable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::UpdateVariable ()
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiDgMiDfIiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_bProhibitMsg) return;
	m_bProhibitMsg = TRUE;

	FFGetDlgItemText(this, IDC_PJN_EDT_COMMENT, m_wstrComment);
	FFGetDlgItemText(this, IDC_PJN_EDT_PROJECT_NAME, m_wstrTitle);
	FFGetDlgItemText(this, IDC_PJN_EDT_FILE_NAME, m_wstrFilePath);
	FFGetDlgItemText(this, IDC_PJN_EDT_DIR_NAME, m_wstrDirPath);
	m_bSpecFilePath = IsDlgButtonChecked(IDC_PJN_CHK_INPUT_FILE_NAME);

	m_bIsRegisterCreatorUserId = IsDlgButtonChecked(IDC_PJN_CHK_REGISTER_USER_ID);

	// m_wstrCreatorUserName _xZkqqHx_iCmNiDfCiDjDiDgHiDiNiBfLiDiLiCmJiCoGiCmBiCmEjFmPiNfIiClDiCoKiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
	// m_guidCreatorUserId _xZkqqHx_iCmNiDfCiDjDiDgHiDiNiBfLiDiLiCmJiCoGiCmBiCmEjFmPiNfIiClDiCoKiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
	// m_fdstDate _xZkqqHx_iCmNiDfCiDjDiDgHiDiNiBfLiDiLiCmJiCoGiCmBiCmEjFmPiNfIiClDiCoKiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_

	m_bIsAllowToJoinUsersGroup = IsDlgButtonChecked(IDC_PJN_CHK_ARROW_TO_JOIN_USERS_GROUP);

	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgMiDfIiDgHiDgAiDeGiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	m_bProhibitMsg = FALSE;
} // CFCDlgProjectProperty::UpdateVariable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::UpdateEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::UpdateEnable ()
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiDgMiDfIiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_bProhibitMsg) return;
	m_bProhibitMsg = TRUE;

	if (!m_bCanModify)
	//----- _xZkqqHx_jFnCiPfHiJmCjEfMiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiCpA_xHqqkZx_ReadOnly_xZkqqHx_iCmJiBeC_xHqqkZx_
		((CEdit*)GetDlgItem(IDC_PJN_EDT_PROJECT_NAME))->SetReadOnly(TRUE);
		// _xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDfOiDjDiBhFjAfGiLeLiDiGiBfLiDfFiCmMiOkJiMmIjDgPjIfOiCpAiLjGiJmCiClHiCoJiBhGiCmNiLnGiOhOiBeC_xHqqkZx_
		GetDlgItem(IDC_PJN_CHK_ARROW_TO_JOIN_USERS_GROUP)->EnableWindow(FALSE);
		// _xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDfOiDjDiBhFiNoMjAkMiOnCiPoOjFpBiCpAiLeMjIfOiClDiClJiCoJiCkJiBhGiCmNiLnGiOhOiBeC_xHqqkZx_
		GetDlgItem(IDC_PJN_CHK_REGISTER_USER_ID)->EnableWindow(FALSE);
		// _xZkqqHx_iDfCiDiBiDjDiDgHiCpA_xHqqkZx_ReadOnly_xZkqqHx_iCmJiBeC_xHqqkZx_
		((CEdit*)GetDlgItem(IDC_PJN_EDT_COMMENT))->SetReadOnly(TRUE);
	} else
	//----- _xZkqqHx_jFnCiPfHiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_bSpecFilePath)
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAjClMjAnKiOhHjCoIiClDiClJiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_]_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			((CEdit*)GetDlgItem(IDC_PJN_EDT_DIR_NAME))->SetReadOnly(TRUE);
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhEiDeAiDeDiDiLiOfBiPmG_xHqqkZx_]_xZkqqHx_iDhLiDfOiDjDiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			GetDlgItem(IDC_PJN_BTN_DIR_DIALOG)->EnableWindow(FALSE);
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLjGlM_xHqqkZx_]_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			((CEdit*)GetDlgItem(IDC_PJN_EDT_FILE_NAME))->SetReadOnly(FALSE);
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLjGlMiCmMiDhEiDeAiDeDiDiLiOfBiPmG_xHqqkZx_]_xZkqqHx_iDhLiDfOiDjDiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			GetDlgItem(IDC_PJN_BTN_FILE_DIALOG)->EnableWindow(TRUE);
		} else
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiOkJjDkOiCmFiOhHjCoIiClDiClJiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_]_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			((CEdit*)GetDlgItem(IDC_PJN_EDT_DIR_NAME))->SetReadOnly(FALSE);
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiCmMiDhEiDeAiDeDiDiLiOfBiPmG_xHqqkZx_]_xZkqqHx_iDhLiDfOiDjDiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			GetDlgItem(IDC_PJN_BTN_DIR_DIALOG)->EnableWindow(TRUE);
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLjGlM_xHqqkZx_]_xZkqqHx_iDeHiDgGiDeCiDgCiDgHiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			((CEdit*)GetDlgItem(IDC_PJN_EDT_FILE_NAME))->SetReadOnly(TRUE);
			// [_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLjGlMiCmMiDhEiDeAiDeDiDiLiOfBiPmG_xHqqkZx_]_xZkqqHx_iDhLiDfOiDjDiDfCiDjDiDgHiDiNiBfLiDiLiBeC_xHqqkZx_
			GetDlgItem(IDC_PJN_BTN_FILE_DIALOG)->EnableWindow(FALSE);
		}
		// OK_xZkqqHx_iDhLiDfOiDjDiCmMjHeMiMpIiBeFjGlDiMpIiCpAjAnNjCoIiBeC_xHqqkZx_
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		GetDlgItem(IDOK)->EnableWindow(
//					0 < m_wstrFilePath.length() && m_wstrFilePath.length() < HPD_MAX_PROJECT_DIR_PATH);
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		GetDlgItem(IDOK)->EnableWindow(m_dwPathError == 0);
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		if (m_guidCreatorUserId == GUID_NULL)
		//----- _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgAiDeGiDgCiDeOiDhLiDfOiDjDiBhFiNoMjAkMiOnCiPoOjFpBiCpAiLeMjIfOiClDiClJiCoJiCkJiBhGiCmNiLnGiOhOiBeC_xHqqkZx_
			GetDlgItem(IDC_PJN_CHK_REGISTER_USER_ID)->EnableWindow(FALSE);
		}
	}
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgMiDfIiDgHiDgAiDeGiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	m_bProhibitMsg = FALSE;
} // CFCDlgProjectProperty::UpdateEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::UpdateFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiBeBiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeBiIlNiCkCiCmNiDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCkK_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::UpdateFilePath ()
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiDgMiDfIiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	// UpdateControl _xZkqqHx_iCmM_xHqqkZx_ SetDlgItemText _xZkqqHx_jDjJiCkJiCoHiOmAiNhDiClDiCoKiCoJiCmMiCpAjGgIiCkOiBeC_xHqqkZx_
	if (m_bProhibitMsg) return;
	m_bProhibitMsg = TRUE;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiBeC_xHqqkZx_
	WString wstrDirPath = m_wstrDirPath;
	// _xZkqqHx_iNmFiMoDiCmJiBhF_xHqqkZx_\_xZkqqHx_iBhGiCkKjFhEiCkCiCmEiCkCiCoJiPoKiNiHiCmNiNoNiPjMiBeCiBhF_xHqqkZx_C:\_xZkqqHx_iBhGiCmIiCmHiBeC_xHqqkZx_
	wstrDirPath.TrimRight(L'\\');
	if (!m_wstrTitle.empty() && !wstrDirPath.empty())
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmGiClFiCmEjGlDiMpIiCmIjFlGiOjKiCpA_xHqqkZx_ _ _xZkqqHx_iCmJiBeC_xHqqkZx_
		WString wstrFileName = m_wstrTitle;
		FFFileNameRegal(wstrFileName, L'_');
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMjFlGiOjKjHpBiCpAiNiHjAkMiBeC_xHqqkZx_
		m_wstrFilePath.Format(L"%s\\%s.mdpj", wstrDirPath.c_str(), wstrFileName.c_str());
	}

//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_wstrFilePath.length() < HPD_MAX_PROJECT_DIR_PATH)
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjClHiClDiCkKjAkHiMmAjDoAiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhAiDfIjClHiDgAiDeGiDgCiDeOiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//		m_bPathTooLong = FALSE;
//	} else
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCkKjClHiClHiCkMiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (!m_bPathTooLong)
//		//----- _xZkqqHx_iCnMiClOiDeHiDiJiBfLiPiIjHjNiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhAiDfIjClHiDgAiDeGiDgCiDeOiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
//			m_bPathTooLong = TRUE;
//			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
//			FFErrorBox(IDS_ERR_MSG_FILE_PATH_TOO_LONG);
//		}
//	}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	DWORD dwPathError = g_pFileServer->CheckTopGroupPath(m_wstrFilePath);
	if (dwPathError == 0)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJiDeHiDiJiBfLiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
		m_dwPathError = 0;
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJiDeHiDiJiBfLiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (m_dwPathError == 0)
		//----- _xZkqqHx_iCnMiClOiDeHiDiJiBfLiPiIjHjNiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
			m_dwPathError = dwPathError;
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFErrorBox(dwPathError);
		}
	}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgMiDfIiDgHiDgAiDeGiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	m_bProhibitMsg = FALSE;
} // CFCDlgProjectProperty::UpdateFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::UpdateDirName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.10.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::UpdateDirName ()
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCkKiDgMiDfIiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	// UpdateControl _xZkqqHx_iCmM_xHqqkZx_ SetDlgItemText _xZkqqHx_jDjJiCkJiCoHiOmAiNhDiClDiCoKiCoJiCmMiCpAjGgIiCkOiBeC_xHqqkZx_
	if (m_bProhibitMsg) return;
	m_bProhibitMsg = TRUE;

//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_wstrFilePath.length() < HPD_MAX_PROJECT_DIR_PATH)
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjClHiClDiCkKjAkHiMmAjDoAiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDhAiDfIjClHiDgAiDeGiDgCiDeOiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//		m_bPathTooLong = FALSE;
//	} else
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCkKjClHiClHiCkMiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (!m_bPathTooLong)
//		//----- _xZkqqHx_iCnMiClOiDeHiDiJiBfLiPiIjHjNiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDhAiDfIjClHiDgAiDeGiDgCiDeOiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
//			m_bPathTooLong = TRUE;
//			FFErrorBox(IDS_ERR_MSG_FILE_PATH_TOO_LONG);
//		}
//	}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	DWORD dwPathError = g_pFileServer->CheckTopGroupPath(m_wstrFilePath);
	if (dwPathError == 0)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJiDeHiDiJiBfLiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
		m_dwPathError = 0;
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJiDeHiDiJiBfLiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (m_dwPathError == 0)
		//----- _xZkqqHx_iCnMiClOiDeHiDiJiBfLiPiIjHjNiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
			m_dwPathError = dwPathError;
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFErrorBox(dwPathError);
		}
	}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiCmMiDgGiDeCiDiMiDeOiDgHiDiKjFjEjFkK_xHqqkZx_ -----
	FFSplitFileName(&m_wstrDirPath, NULL, NULL, m_wstrFilePath.c_str());
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiNmFiMoDiCmJjFhEiCkCiCmEiCkCiCoJ_xHqqkZx_'\'_xZkqqHx_iLeMiNiGiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
	m_wstrDirPath.TrimRight(L'\\');

	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDgMiDfIiDgHiDgAiDeGiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	m_bProhibitMsg = FALSE;
} // CFCDlgProjectProperty::UpdateDirName.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgProjectProperty_xZkqqHx_iBeC_xHqqkZx_

void CFCDlgProjectProperty::DoDataExchange (CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgProjectProperty)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_MAP
} // CFCDlgProjectProperty::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCDlgProjectProperty, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgProjectProperty)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_PJN_BTN_DIR_DIALOG, OnPjnBtnDirDialog)
	ON_EN_CHANGE(IDC_PJN_EDT_PROJECT_NAME, OnChangePjnEdtProjectName)
	ON_EN_CHANGE(IDC_PJN_EDT_DIR_NAME, OnChangePjnEdtDirName)
	ON_BN_CLICKED(IDC_PJN_BTN_FILE_DIALOG, OnPjnBtnFileDialog)
	ON_BN_CLICKED(IDC_PJN_CHK_INPUT_FILE_NAME, OnPjnChkInputFileName)
	ON_BN_CLICKED(IDC_PJN_CHK_REGISTER_USER_ID, OnPjnChkRegisterUserId)
	ON_BN_CLICKED(IDC_PJN_CHK_ARROW_TO_JOIN_USERS_GROUP, OnPjnChkArrowToJoinUsersGroup)
	ON_BN_CLICKED(IDC_PJN_BTN_MEMBER_USER_LIST, OnPjnBtnMemberUserList)
	ON_EN_CHANGE(IDC_PJN_EDT_FILE_NAME, OnChangePjnEdtFileName)
	ON_BN_CLICKED(IDC_PJN_BTN_DOCUMENT_LIST, OnPjnBtnDocumentList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgProjectProperty _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgProjectProperty::OnInitDialog ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();
	// EditBox_xZkqqHx_iCkKiDiBiDgCiDfKiBfLiDfHiCmMiDgMiDfIiDgHiCpAiLeOiClBiClHiCmMiCmFiBeBiClBiCoKiCpAjGgIiCkOjFmPjAjEiBeC_xHqqkZx_
	m_bProhibitMsg = FALSE;

	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfOiDeDiDgHiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	if (!m_wstrWindowTitle.IsEmpty())
		FFSetWindowText(this, m_wstrWindowTitle);

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiOjOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	if (m_fdstDate == FDSECTIME(-1))
		m_fdstDate = FFGetCurrentSecTime();

	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDhAiDfIiCmMiNmFiMoDiCmJjFhEiCkCiCmEiCkCiCoJ_xHqqkZx_'\'_xZkqqHx_iLeMiNiGiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
	m_wstrDirPath.TrimRight(L'\\');

//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhAiDfIjClHiDgAiDeGiDgCiDeOiDhEiDiJiDePiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_bPathTooLong = FALSE;
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
	m_dwPathError = 0;
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if (m_dlgKind == CREATE || m_dlgKind == SAVE)
	{
		SetTimer(1, 10000, NULL);
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkMiBeBjGlMjBePiCpAiCmCiCkPiCmEjFnLjBlG_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiBeBiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
		UpdateFilePath();
	}
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControl();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateEnable();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	::FFJustifyWindow(m_hWnd);

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgProjectProperty::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OK_xZkqqHx_iDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnOK ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();

	// _xZkqqHx_jAfGiLeLiNoMjAkMjHhAiCmMiPoKiNiHiCmGiDhGiDiNiDhAiDgFiDeCjHhAiCmFiDgFiDjDiDhGiDiMiBfLiDgHiCpAjAnIiCoIjBnGiCkGiBeC_xHqqkZx_
	if (m_dlgKind == CREATE || m_dlgKind == SAVE)
	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAfGiLeLiNoMjAkMjHhAiDfPiDeDiDeBiDiNiDePiCmMiPoKiNiH_xHqqkZx_ ------
	{
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		// _xZkqqHx_jAfGiLeLiNoMjAkMjHhAiCmMiPoKiNiHiCmNiDhEiDeAiDeDiDiLjGlMiCmGiKpJjBlGiDhEiDeAiDeDiDiLiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//		if (HPD_MAX_PROJECT_DIR_PATH <= m_wstrFilePath.length())
//		//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCkKjClHiClHiCkMiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDeHiDiJiBfLiBhFiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCkKjClHiClHiCkMiCnMiClHiBhGiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
//			FFErrorBox(IDS_ERR_MSG_FILE_PATH_TOO_LONG);
//			return;
//		}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_jAfGiLeLiNoMjAkMjHhAiCmMiPoKiNiHiCmNiDhEiDeAiDeDiDiLjGlMiCmGiKpJjBlGiDhEiDeAiDeDiDiLiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		// _xZkqqHx_iDhAiDfIjGlMiDgAiDeGiDgCiDeOiCmMiDeHiDiJiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
		DWORD dwPathError = g_pFileServer->CheckTopGroupPath(m_wstrFilePath);
		if (dwPathError != 0)
		//----- _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJiDeHiDiJiBfLiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFErrorBox(dwPathError);
			return;
		}
//----- 06.03.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		if (g_pFileServer->IsTopGroupExist(m_wstrFilePath.c_str()))
		//----- _xZkqqHx_iOhHjCoIiCmMiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiCmNjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// "_xZkqqHx_iOhHjCoIiCmMiDhEiDeAiDeDiDiLiCmNiKpJiCmJjBlGiNnNiClFiCmEiCkCiCnMiClH_xHqqkZx_"
			FFErrorBox(IDS_ERR_ERRNO_EEXIST);
			return;
		}
	}
	if (!m_bCanModify)
	//----- _xZkqqHx_jFnCiPfHiJmCjEfMiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnCancel();
	} else
	{
		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::OnOK();
	}
} // CFCDlgProjectProperty::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnTimer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WM_TIMER_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	uIDEvent	:_xZkqqHx_iDfOiDeDiDhNiBfLiDeDiDhIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnTimer (UINT nIDEvent)
{
	if (m_dlgKind == CREATE || m_dlgKind == SAVE)
	{
		m_fdstDate = FFGetCurrentSecTime();
		UpdateControl();
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnTimer(nIDEvent);
} // CFCDlgProjectProperty::OnTimer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiNoNiPjMiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnDestroy ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDestroy();
	// _xZkqqHx_iOjOiMhGjHhAiDfOiDeDiDhNiBfLiCpAiPeJjHlJiBeC_xHqqkZx_
	if (m_dlgKind == CREATE || m_dlgKind == SAVE)
		KillTimer(1);
//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDhDiBfLiBeC_xHqqkZx_
	if (m_pProjectCopy != NULL)
	{
		delete m_pProjectCopy;
		m_pProjectCopy = NULL;
	}
//----- 06.04.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCDlgProjectProperty::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnPjnBtnDirDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiOhHjCoIjHhAiCmMiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pNewjdlg	:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPoOjFpBiNfMjBkCjBmMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			m_hWnd		:_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjBeJjBpAjHhAiCmMiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnPjnBtnDirDialog ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKjDpMjHmNiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	WString wstrDirPath;
	if (g_pFileServer->OnDlgOpenDirectory(wstrDirPath, m_hWnd, m_wstrDirPath.c_str()) == IDOK)
	{
		// _xZkqqHx_jAfGiClFiCkCiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
		m_wstrDirPath = wstrDirPath.c_str();
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiBeBiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
		UpdateFilePath();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		UpdateControl();
//----- 06.03.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateEnable();
//----- 06.03.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
} // CFCDlgProjectProperty::OnPjnBtnDirDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnChangePjnEdtProjectName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhGiDiNiDfHiDeGiDeOiDgHjGlMiBhGiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnChangePjnEdtProjectName ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAjAfGiLeLiNoMjAkMiBeBjGlMjBePiCpAiCmCiCkPiCmEjFnLjBlG_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiBeBiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	if (m_dlgKind == CREATE || m_dlgKind == SAVE)
		UpdateFilePath();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControl();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateEnable();
} // CFCDlgProjectProperty::OnChangePjnEdtProjectName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnChangePjnEdtDirName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiDgGiDeCiDiMiDeOiDgHiDiKiBhGiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnChangePjnEdtDirName ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiBeBiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	UpdateFilePath();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControl();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateEnable();
} // CFCDlgProjectProperty::OnChangePjnEdtDirName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnPjnBtnFileDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiDhAiDfIiOhHjCoIiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnPjnBtnFileDialog ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
	// _xZkqqHx_iDhEiDeAiDeDiDiLjDpMjHmNiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
	// IDS_OPEN_PROJECT = "_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkN_xHqqkZx_"
	WString wstrNewFilePath;
//----- 06.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (g_pFileServer->OnDlgSaveTopGroup(
//				wstrNewFilePath,
//				FFLoadWString(IDS_OPEN_PROJECT),
//				m_wstrFilePath.c_str(),
//				OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
//				L"Dynamic Draw Projects (*.mdpj)|*.mdpj||") == IDOK)
//----- 06.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (g_pFileServer->OnDlgSaveTopGroup(	wstrNewFilePath,
											m_hWnd,
											FFLoadWString(IDS_OPEN_PROJECT),
											m_wstrFilePath.c_str(),
											L"Dynamic Draw Project",
											L".mdpj") == IDOK)
//----- 06.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{
		// _xZkqqHx_jAfGiClFiCkCiDhEiDeAiDeDiDiLiDhAiDfIjGlMiCpAjAnNjCoIiBeC_xHqqkZx_
		m_wstrFilePath = wstrNewFilePath.c_str();
		// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
		UpdateDirName();
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		UpdateControl();
//----- 06.03.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
		UpdateEnable();
//----- 06.03.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
} // CFCDlgProjectProperty::OnPjnBtnFileDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnPjnChkInputFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiOhHjCoIiDgAiDeGiDgCiDeOiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnPjnChkInputFileName ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiBeBiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	UpdateFilePath();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControl();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateEnable();
} // CFCDlgProjectProperty::OnPjnChkInputFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnPjnChkRegisterUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiOnCiPoOjFpBiCpAiLeMjIfOiDgAiDeGiDgCiDeOiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnPjnChkRegisterUserId ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControl();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateEnable();
} // CFCDlgProjectProperty::OnPjnChkRegisterUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnPjnChkArrowToJoinUsersGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAfGiLeLiDiGiBfLiDfFiCmMiOkJiMmIjDgPjIfOiCpAiLjGiJmCiClHiCoJiDgAiDeGiDgCiDeOiDhLiDgCiDeOiDfIiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnPjnChkArrowToJoinUsersGroup ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
} // CFCDlgProjectProperty::OnPjnChkArrowToJoinUsersGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnPjnBtnMemberUserList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDiBiDjDiDgPiBfLiIoKjHjHiDhLiDfOiDjDiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnPjnBtnMemberUserList ()
{
	CFCDlgProjectMember dlg;
	// _xZkqqHx_iDiBiDjDiDgPiBfLiCmMiDiGiBfLiDfF_xHqqkZx_ID->_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
	dlg.m_mpMemberUserList = m_mpMemberUserList;
	// _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiCnNiCmMjAkHiMmAiDiGiBfLiDfFiBeC_xHqqkZx_
	dlg.m_stLimitedUserList = m_stLimitedUserList;
	// _xZkqqHx_jFnCiPfHiJmCjEfMiCkJiBeI_xHqqkZx_
	dlg.m_bCanModify = m_bCanModify;
	// _xZkqqHx_jFnCiPfHiOnCiDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	dlg.m_guidEditorUserId = m_guidEditorUserId;
//----- 06.01.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	dlg.m_hwndParent = m_hWnd;
//	dlg.m_pDlgProc = m_pDlgProc;
//----- 06.01.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	if (dlg.DoModal() == IDOK)
	//----- OK_xZkqqHx_iDhLiDfOiDjDiCmFiPeJjHlJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiBiDjDiDgPiBfLiCmMjFmPiNfIiCpAjElNiJgGiBeC_xHqqkZx_
		m_mpMemberUserList = dlg.m_mpMemberUserList;
		// _xZkqqHx_jDmHiCnNiNjOiCnNiCmMiCnNiCmMjAkHiMmAiDiGiBfLiDfFiBeC_xHqqkZx_
		m_stLimitedUserList = dlg.m_stLimitedUserList;
	}
} // CFCDlgProjectProperty::OnPjnBtnMemberUserList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnChangePjnEdtFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDeAiDeDiDiLjGlMiBhGiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjGlMiBeBiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCkJiCoHiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfOiDeDiDgHiDiLiBeBiIlNiCkCiCmNiDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCkK_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnChangePjnEdtFileName ()
{
	// _xZkqqHx_jFmPjAjEiCmMjCgMiCpAiDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateVariable();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCkJiCoHiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
	UpdateDirName();
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFfMiOkGiCpAjFmPjAjEiCmMjCgMiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	UpdateControl();
//----- 06.03.13 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjHeMiMpIjAkLiCpAjAnNjCoIiBeC_xHqqkZx_
	UpdateEnable();
//----- 06.03.13 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // CFCDlgProjectProperty::OnChangePjnEdtFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgProjectProperty::OnPjnBtnDocumentList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjFlGiPjBiIoKjHjHiBhGiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgProjectProperty::OnPjnBtnDocumentList ()
{
	// _xZkqqHx_jHjKjHpAjFlGiPjBiIoKjHjHiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	CFCDlgHidocumentList dlg;
	dlg.SetProject(*m_pProjectCopy);
	dlg.DoModal();
} // CFCDlgProjectProperty::OnPjnBtnDocumentList.
