#include "stdafx.h"
#include "resource.h"			// IDS_FORM_XXX.
#include "UtilMisc.h"			// FdsecToFiletime.
#include "UtilStr.h"			// FFLoadString.
#include "ProjectCopy.h"		// FCProjectCopy.
#include "HiDocumentRec.h"		// For FCHiDocumentRec.
#include "DocumentRecCopy.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////////////////
// FCDocumentRecCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::FCDocumentRecCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDocumentRecCopy::FCDocumentRecCopy (const FCProjectCopy* pProjectCopy)
				:m_pProjectCopy(pProjectCopy)
{
} // FCDocumentRecCopy::FCDocumentRecCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDocumentRecCopy::operator = (FCHiDocumentRec& rec)
{
	rec.GetValue(	NULL,					// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiImKjChFiBeC_xHqqkZx_
					&m_lSuperDocId,			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
					&m_wstrDocTitle,		// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
					&m_wstrVersion,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
					&m_guidUserId,			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
					&m_fdstDate,			// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
					&m_wstrComment,			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
					&m_bIsLogCommandUserId,	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
					&m_dHtreeScore);		// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
} // FCDocumentRecCopy::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetSuperDocId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCDocumentRecCopy::GetSuperDocId () const
{
	return m_lSuperDocId;			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
} // FCDocumentRecCopy::GetSuperDocId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetDocTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const WString& FCDocumentRecCopy::GetDocTitle () const
{
	return m_wstrDocTitle;			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
} // FCDocumentRecCopy::GetDocTitle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const WString& FCDocumentRecCopy::GetVersion () const
{
	return m_wstrVersion;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
} // FCDocumentRecCopy::GetVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID FCDocumentRecCopy::GetUserId () const
{
	return m_guidUserId;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
} // FCDocumentRecCopy::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetDate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCDocumentRecCopy::GetDate () const
{
	return m_fdstDate;				// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
} // FCDocumentRecCopy::GetDate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const WString& FCDocumentRecCopy::GetComment () const
{
	return m_wstrComment;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
} // FCDocumentRecCopy::GetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetIsLogCommandUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCDocumentRecCopy::GetIsLogCommandUserId () const
{
	return m_bIsLogCommandUserId;	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
} // FCDocumentRecCopy::GetIsLogCommandUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetHtreeScore
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAiDfIiDfCiDeBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCDocumentRecCopy::GetHtreeScore () const
{
	return m_dHtreeScore;			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
} // FCDocumentRecCopy::GetHtreeScore.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocumentRecCopy::GetHintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhBiDjDiDgHiDgFiDeMiDfIiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCDocumentRecCopy::GetHintText () const
{
	// _xZkqqHx_iOjOiKnEiDfGiDePiDgJiDiLiCmMiOjOiKnEiBeC_xHqqkZx_
	COleDateTime otmDate = FdsecToFiletime(GetDate());
	// _xZkqqHx_jHoBiBeG_xHqqkZx_2004_xZkqqHx_jEeO_xHqqkZx_8_xZkqqHx_iMiO_xHqqkZx_19_xZkqqHx_jDpK_xHqqkZx_ 0_xZkqqHx_iOjO_xHqqkZx_15_xZkqqHx_jFkK_xHqqkZx_
	// IDS_FORM_DATE_TIME_LONG = "%#Y_xZkqqHx_jEeO_xHqqkZx_%#m_xZkqqHx_iMiO_xHqqkZx_%#d %#H:%#M"
	WString wstrDate = TStrToWStr(otmDate.Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
	// IDS_FORM_HTREE_PROPERTY_B =
	// _xZkqqHx_iOoNjFmK_xHqqkZx_:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_\r\n
	// _xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_:%s\r\n
	// _xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_:%s\r\n
	// _xZkqqHx_iNoMjAkMjDpKiOjO_xHqqkZx_:%s\r\n
	// _xZkqqHx_iNoMjAkMiOnC_xHqqkZx_:%s\r\n
	// _xZkqqHx_iDfCiDiBiDjDiDgH_xHqqkZx_:%s
	return FormatResString(	IDS_FORM_HTREE_PROPERTY_B,
							GetDocTitle().c_str(),
							GetVersion().c_str(),
							wstrDate.c_str(),
							m_pProjectCopy->UserIdToUserName(GetUserId()).c_str(),
							GetComment().c_str());
} // FCDocumentRecCopy::GetHintText.

//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//BOOL FCDocumentRecCopy::GetIsTemporary () const
//{
//	return FALSE;
//} // FCDocumentRecCopy::GetIsTemporary.
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//////////////////////////////////////////////////////////////////////////////////
// FCDocRecCopyFactory.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocRecCopyFactory::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pProjectCopy	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfCiDhDiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCDocumentRecCopy* FCDocRecCopyFactory::Create (const FCProjectCopy* pProjectCopy) const
{
	return new FCDocumentRecCopy(pProjectCopy);
} // FCDocRecCopyFactory::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCDocRecCopyFactory::Delete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDiMiDfCiBfLiDgIiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDocRecCopy	:_xZkqqHx_iNoNiPjMiClHiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCDocRecCopyFactory::Delete (FCDocumentRecCopy* pDocRecCopy) const
{
	delete pDocRecCopy;
} // FCDocRecCopyFactory::Delete.

