// MolipDraw.cpp : _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDjHhAiDeOiDiJiDfIiCmMiLeAjEfMjCoIiLgAiCpAiNhDiCkCiCnMiClHiBeC_xHqqkZx_
//

#include "stdafx.h"
#ifdef _DEBUG
#include <float.h>				// For _control87.
#endif//_DEBUG
#include <afxpriv.h>			// For WM_HELPPROMPTADDR.
#include <afxadv.h>				// For CRecentFileList.
#include <float.h>				// For DBL_MAX.
#include <algorithm>			// For upper_bound template.
#include "DynamicDb.h"			// For g_pFileServer.
#include "MainFrame.h"
#include "IpFrame.h"
#include "FoundDoc.h"			// For CFCFoundDoc.
#include "DynamicDrawDoc.h"		// For CFCDynamicDrawDoc.
#include "ChipEditorDoc.h"		// For CFCChipEditorDoc.
#include "ArrowEditorDoc.h"		// For CFCArrowEditorDoc.
#include "ChipEditorFrame.h"	// For CFCChipEditorFrame.
#include "ArrowEditorFrame.h"	// For CFCArrowEditorFrame.
#include "DynamicDrawFrame.h"	// For CFCDynamicDrawFrame.
#include "DynamicDrawView.h"	// For CFCDynamicDrawView.
#include "RegData.h"			// For LoadRegColor.
#include "UtilMisc.h"			// For FFGetSmallerItemFromList.
#include "UtilMath.h"			// For _wcstoi64.
#include "UtilErr.h"			// For CFCDDFileException.etc.
#include "UtilWin.h"			// For EnumWinTitle.etc.
#include "UtilStr.h"			// For FormatResString.
#include "UtilDlg.h"			// For SetUnitString.etc.
#include "UtilFile.h"			// For SplitFileName.
#include "UtilPrint.h"			// For FFGetPaperSizeList.
#include "File32.h"				// For FCFile32.
#include "RecentList.h"			// For FCRecentList.
#include "ToolBase.h"			// For GetCurrentTool().
#include "DlgRepairDoc.h"		// For CFCDlgRepairDoc.
#include "ObjWidePoly.h"		// For FCObjWidePoly.
#include "FdbOpenDdFile.h"		// For FCFdbOpenDdFile.
#include "FileConv.h"			// For FCFileConvManager.
#include "PursuerText.h"		// For CFCPursuerText.

#ifdef _DD_PRO
#include "HiProject.h"			// For FCHiProject.
#include "HistDrawDoc.h"		// For CFCHistDrawDoc.
#include "HistViewDoc.h"		// For CFCHistViewDoc.
#include "HistDrawFrame.h"		// For CFCHistDrawFrame.
#include "HistViewFrame.h"		// For CFCHistViewFrame.
#include "WndHistoryTree.h"		// For CFCWndHistoryTree.
#endif//_DD_PRO

#include "DynamicDraw.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class FCHiProject;

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myLoadPophintTextTableFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiDgFiDeMiDfIiDgHiCmMiDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpCommandToPophintText	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID -> _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmN_xHqqkZx_ UNICODE_xZkqqHx_iMgAiOkOiBeC_xHqqkZx_
 *			<id _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID>
 *			_xZkqqHx_iDfCiDhNiDjDiDgIjDoAjHgFiBeFiBeFiBeF_xHqqkZx_
 *			</id>
 *			<id _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID>
 *			_xZkqqHx_iDfCiDhNiDjDiDgIjDoAjHgFiBeFiBeFiBeF_xHqqkZx_
 *			</id>
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myLoadPophintTextTableFile (map<DWORD, WString>& mpCommandToPophintText)
{
	mpCommandToPophintText.clear();
	try
	{
		WString wstrBuff;
		FFLoadTextFile(wstrBuff, FFGetFileDirectory(FFGetMolipExePath()) + L"popup.hix");
		const wchar_t* wcpBuffHead = wstrBuff.c_str();
		for (;;)
		{
			//----- _xZkqqHx_iDfCiDhNiDjDiDgIjAoGjDkKiCnMiCmFiDfIiDeMiDgCiDhG_xHqqkZx_ -----
			for (;;)
			{
				if (*wcpBuffHead == L'\0') break;
				if (wcsncmp(wcpBuffHead, L"<id ", 4) == 0)
				//----- <id _xZkqqHx_iCmFiOgOiCnMiCoJjFjEjFkKiPoKiNiH_xHqqkZx_ -----
				{
					wcpBuffHead += 4;
					break;
				}
				wcpBuffHead++;
			}
			if (*wcpBuffHead == L'\0') break;
			//----- _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiPgPiClH_xHqqkZx_ -----
			WString wstrCommandId;
			for (;;)
			{
				if (*wcpBuffHead == L'\0') FFThrowMiscUnknown();
				if (*wcpBuffHead == L'>')
				//----- > _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
				{
					wcpBuffHead++;
					break;
				}
				wstrCommandId += *wcpBuffHead;
				wcpBuffHead++;
			}
			//----- _xZkqqHx_iOjPiCmMiNhDiCnMiCmFiDfIiDeMiDgCiDhG_xHqqkZx_ -----
			for (;;)
			{
				if (*wcpBuffHead == L'\0') FFThrowMiscUnknown();
				if (*wcpBuffHead == L'\n')
				{
					wcpBuffHead++;
					break;
				}
				wcpBuffHead++;
			}
			//----- </id> _xZkqqHx_iCnMiCmFiCpAjDmHiCnNiPgPiClH_xHqqkZx_ -----
			WString wstrCommandText;
			for (;;)
			{
				if (*wcpBuffHead == L'\0') FFThrowMiscUnknown();
				if (wcsncmp(wcpBuffHead, L"</id>", 5) == 0)
				{
					wcpBuffHead += 5;
					break;
				}
				wstrCommandText += *wcpBuffHead;
				wcpBuffHead++;
			}
			// _xZkqqHx_iNmFiMoDiCmMjGlDiInDjGkBiCmIiJpMiNhDiCoCiLpDjEjCiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
			wstrCommandText.TrimRight();
			DWORD dwCommandId = FFCommandStringToId(WStrToAStr(wstrCommandId));
			if (dwCommandId == DWORD(-1)) FFThrowMiscUnknown();
			// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID -> _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiDgFiDeMiDfIiDgH_xHqqkZx_ _xZkqqHx_iCmJjDgPjIfOiBeC_xHqqkZx_
			mpCommandToPophintText[dwCommandId] = wstrCommandText;
		}
	} catch (CFileException* e)
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiKnGiMfHiCmMiDeHiDiJiBfLiCmMiPoKiNiHiBeBiJlNiCoAiPiIjHjNiClJiClIiClLiCmMiCnMiCnMjHkMiClHiBeC_xHqqkZx_
		e->Delete();
	}
} // myLoadPophintTextTableFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myLoadValidHelpIdFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDjDiDiJiDeDiDjDiDhHiDiLiDhGiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpA_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stValidHelpId	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmN_xHqqkZx_ ASCII_xZkqqHx_iMgAiOkOiBeC_xHqqkZx_
 *			_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID
 *			_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID
 *			_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID
 *				_xZkqqHx_iBeG_xHqqkZx_
 *				_xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myLoadValidHelpIdFile (DWORDSet& stValidHelpId)
{
	stValidHelpId.clear();
	try
	{
		astring astrBuff;
		FFLoadTextFile(astrBuff, FFGetFileDirectory(FFGetMolipExePath()) + L"helpid.hix");
		const char* acpBuffHead = astrBuff.c_str();
		while (*acpBuffHead != '\0')
		{
			//----- _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiPgPiClH_xHqqkZx_ -----
			astring astrCommandId;
			for (;;)
			{
				if (*acpBuffHead == '\0') break;
				if (*acpBuffHead == '\r')
				{
					acpBuffHead += 2;
					break;
				}
				astrCommandId += *acpBuffHead;
				acpBuffHead++;
			}
			if (!astrCommandId.empty())
			{
				const DWORD dwCommandId = FFCommandStringToId(astrCommandId.c_str());
				if (dwCommandId == DWORD(-1)) FFThrowMiscUnknown();
				// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAjDgPjIfOiBeC_xHqqkZx_
				stValidHelpId.insert(dwCommandId);
			}
		}
	} catch (CFileException* e)
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiKnGiMfHiCmMiDeHiDiJiBfLiCmMiPoKiNiHiBeBiJlNiCoAiPiIjHjNiClJiClIiClLiCmMiCnMiCnMjHkMiClHiBeC_xHqqkZx_
		e->Delete();
	}
} // myLoadValidHelpIdFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myLoadHelpMovieTableFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDiLiDhGiDiAiBfLiDhCiBfLiCmMiDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vHelpMovieFile	:_xZkqqHx_iDhHiDiLiDhGiDiAiBfLiDhCiBfLjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *							 (_xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_, _xZkqqHx_iDiAiBfLiDhCiBfLiDfOiDeDiDgHiDiL_xHqqkZx_)_xZkqqHx_iCmMjEhKjHpBiBeC_xHqqkZx_
 *			mpCommandToMovieIndex
 *							:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID -> vHelpMovieFile_xZkqqHx_jEhKjHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCmN_xHqqkZx_ UNICODE_xZkqqHx_iMgAiOkOiBeC_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_	_xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID	_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_	_xZkqqHx_iDfOiDeDiDgHiDiL_xHqqkZx_	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID	_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myLoadHelpMovieTableFile (	vector<WStringPair>& vHelpMovieFile,
										map<DWORD, longSet>& mpCommandToMovieIndex)
{
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//#define _OUT_MOVE_HELP
#ifdef _OUT_MOVE_HELP
	map<WString, WString> mpIdToStr;
#endif//_OUT_MOVE_HELP

	vHelpMovieFile.clear();
	mpCommandToMovieIndex.clear();
	try
	{
		// movie.hix _xZkqqHx_iDhEiDeAiDeDiDiLiCmMjDoAjHgFiBeC_xHqqkZx_
		WString wstrBuff;
		FFLoadTextFile(wstrBuff, FFGetFileDirectory(FFGetMolipExePath()) + L"movie.hix");
		// _xZkqqHx_iDgPiDgCiDhEiDeAjCiGiCmMiPiIjHjNiImKjChFiBeC_xHqqkZx_
		const wchar_t* wcpBuffHead = wstrBuff.c_str();
		// DynamicDraw.exe_xZkqqHx_iCmMiDhAiDfIiBeC_xHqqkZx_
		const WString wstrExeDirPath = FFGetFileDirectory(FFGetMolipExePath());
		for (;;)
		{
			// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmMjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
			WString wstrFileName = wstrExeDirPath;
			for (;*wcpBuffHead != L'\t'; wcpBuffHead++)
			//----- _xZkqqHx_iDfOiDhFiImKjChFiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
			{
				if (*wcpBuffHead == L'\0') FFThrowMiscUnknown();
				wstrFileName += *wcpBuffHead;
			}
			// _xZkqqHx_iLoGjAnIiCoIiDfOiDhFiCpAjBjHiCoJiBeC_xHqqkZx_
			wcpBuffHead++;
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDgHiDiLiCmMjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
			WString wstrFileTitle;
			for (;*wcpBuffHead != L'\t'; wcpBuffHead++)
			//----- _xZkqqHx_iDfOiDhFiImKjChFiCnMiCmFiDiLiBfLiDhG_xHqqkZx_ -----
			{
				if (*wcpBuffHead == L'\0') FFThrowMiscUnknown();
				wstrFileTitle += *wcpBuffHead;
			}
			// _xZkqqHx_iLoGjAnIiCoIiDfOiDhFiCpAjBjHiCoJiBeC_xHqqkZx_
			wcpBuffHead++;
			// (_xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_, _xZkqqHx_iDiAiBfLiDhCiBfLiDfOiDeDiDgHiDiL_xHqqkZx_)_xZkqqHx_iCmMjEhKjHpBiCmJjCmHiJmBiBeC_xHqqkZx_
			vHelpMovieFile.push_back(WStringPair(wstrFileName, wstrFileTitle));
			for (;;)
			{
				// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
				WString wstrCommandId;
				for (;;)
				{
					// _xZkqqHx_iDfOiDhFiImKjChF_xHqqkZx_ OR _xZkqqHx_iJpMiNhD_xHqqkZx_ OR _xZkqqHx_iPeJjCfLiCnMiCmFiDiLiBfLiDhGiBeC_xHqqkZx_
					if (*wcpBuffHead == L'\t') break;
					if (*wcpBuffHead == L'\r') break;
					if (*wcpBuffHead == L'\0') break;
					wstrCommandId += *wcpBuffHead;
					wcpBuffHead++;
				}
#ifdef _OUT_MOVE_HELP
				mpIdToStr[wstrCommandId] += FFFormatString(L"<l !execfile(%s)>%s<>\r\n", wstrFileName.c_str(), wstrFileTitle.c_str());
#else//_OUT_MOVE_HELP
				// _xZkqqHx_iDfCiDhNiDjDiDgIjFlGiOjKjHpBiCkJiCoHiBeBiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
				DWORD dwCommandId = FFCommandStringToId(WStrToAStr(wstrCommandId));
				// _xZkqqHx_jGkCjDgPjIfOiCmMiDfCiDhNiDjDiDgIiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
				if (dwCommandId == DWORD(-1)) FFThrowMiscUnknown();
				// _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID -> vHelpMovieFile_xZkqqHx_jEhKjHpBiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ _xZkqqHx_iCmJjDgPjIfOiBeC_xHqqkZx_
				mpCommandToMovieIndex[dwCommandId].insert(vHelpMovieFile.size() - 1);
#endif//_OUT_MOVE_HELP
				if (*wcpBuffHead == L'\r') break;
				if (*wcpBuffHead == L'\0') break;
				// _xZkqqHx_iLoGjAnIiCoIiDfOiDhFiCpAjBjHiCoJiBeC_xHqqkZx_
				wcpBuffHead++;
			}
			// _xZkqqHx_iJpMiNhDiCmMiPoKiNiHiCmNiBeBiJpMiNhDiCpAjBjHiCoIiOjPiCmMiNhDiCnGiBeC_xHqqkZx_
			if (*wcpBuffHead == L'\r')
				wcpBuffHead += 2;
			// _xZkqqHx_iPeJjCfLiCmMiPoKiNiHiCmNiDiLiBfLiDhGiCpAjElCiCkPiCoJiBeC_xHqqkZx_
			if (*wcpBuffHead == L'\0') break;
		}
	} catch (CFileException* e)
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLiKnGiMfHiCmMiDeHiDiJiBfLiCmMiPoKiNiHiBeBiJlNiCoAiPiIjHjNiClJiClIiClLiCmMiCnMiCnMjHkMiClHiBeC_xHqqkZx_
		e->Delete();
	}

#ifdef _OUT_MOVE_HELP
	CFile file(_T("c:\\tmp\\xxx3.txt"), CFile::modeReadWrite | CFile::modeCreate | CFile::shareDenyNone);
	map<WString, WString>::const_iterator i;
	for (i = mpIdToStr.begin(); i != mpIdToStr.end(); i++)
	{
		CString str;
		str = WStrToTStr((*i).first);
		str += _T("\r\n");
		file.Write((const _TCHAR*)str, str.GetLength());
		str = WStrToTStr((*i).second);
		str += _T("\r\n");
		file.Write((const _TCHAR*)str, str.GetLength());
	}
	file.Close();
#endif//_OUT_MOVE_HELP

} // myLoadHelpMovieTableFile.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDiPoOjFpBiCmFiOgHiCoNiCoKiCoJ_xHqqkZx_ CFCAboutDlg _xZkqqHx_iDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_

class CFCAboutDlg : public CFCDialogBase
{
protected:
typedef CFCDialogBase BASE_CLASS;

public:
	CFCAboutDlg ();

// _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_ _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_
	//{{AFX_DATA(CFCAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard _xZkqqHx_iJlMjBhKiKnGjAjEiCmMiDeJiBfLiDgPiBfLiDiJiDeDiDgIiCpAjAlGjAkMiClFiCnMiClHiBeC_xHqqkZx_
	//{{AFX_VIRTUAL(CFCAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV _xZkqqHx_iCmMiDfEiDhMiBfLiDgH_xHqqkZx_
	//}}AFX_VIRTUAL

// _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_
protected:
	//{{AFX_MSG(CFCAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
}; // class CFCAboutDlg.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	CFCCommandLineInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	/ChipEditor_xZkqqHx_iIpIjAjEjDjJiCpAiJpAiOnPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.07.23 Fukushiro M. _xZkqqHx_iDeJiDhGiDfGiDiHiDjDiOhHjCoIiMgAiOkOiCpAjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
class CFCCommandLineInfo : public CCommandLineInfo
{
protected:
typedef CCommandLineInfo BASE_CLASS;

public:
	CFCCommandLineInfo ();
	virtual void ParseParam (LPCTSTR lpszParam, BOOL bFlag, BOOL bLast);
	virtual void ParseDocRequest ();
	virtual HWND CheckSameDocumentApp () const;

	virtual WORD GetAppMode () const;				// _xZkqqHx_iDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
	virtual HWND GetDrawHwnd () const;				// Editor_xZkqqHx_iMmEiCnBiPgPiClFiMlDiCmM_xHqqkZx_MolipDraw_xZkqqHx_iCmM_xHqqkZx_HWND_xZkqqHx_iBeC_xHqqkZx_
	virtual const FCReqBaseAutoVector& GetDocRequest () const;	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_

public:

protected:
// 06.02.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	WORD				m_appMode;		// _xZkqqHx_iDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_

	FCVar<WORD>			m_wAppMode;		// _xZkqqHx_iDeBiDhGiDiKiOoNjHnOiBeC_xHqqkZx_
	FCVar<WORD>			m_wRunMode;		// _xZkqqHx_iOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
	FCVar<HWND>			m_hwndDraw;		// Editor_xZkqqHx_iMmEiCnBiPgPiClFiMlDiCmM_xHqqkZx_MolipDraw_xZkqqHx_iCmM_xHqqkZx_HWND_xZkqqHx_iBeC_xHqqkZx_
	FCReqBaseAutoVector	m_vDocRequest;	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_

// 06.02.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	WString			m_strTemplatePath;	// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_

	FCVar<SheetID>	m_stidCurrentSheet;	// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	FCVar<mmetol>	m_mmViewCenterX;	// _xZkqqHx_iDhCiDiFiBfL_xHqqkZx_X_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
	FCVar<mmetol>	m_mmViewCenterY;	// _xZkqqHx_iDhCiDiFiBfL_xHqqkZx_Y_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_

// 06.02.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	FCVar<WString>	m_strProjectPath;	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_

	FCVar<long>		m_lHidocumentId;	// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	FCVar<flint>	m_fliSessionIndex;	// _xZkqqHx_jHjKjHpAiImKjChFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_

//----- 03.09.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	BOOL		m_bHidocumentNew;	// _xZkqqHx_jHjKjHpAjFlGiPjBjAfGiLeLiNoMjAkMiBeI_xHqqkZx_
//	BOOL		m_bProjectNew;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjAfGiLeLiNoMjAkMiBeI_xHqqkZx_
//----- 03.09.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	FCVar<WString>	m_strDocRequest;	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
}; // class CFCCommandLineInfo.

static const _TCHAR* FDCO_ARROWEDIT	= _T("arrowedit");
static const _TCHAR* FDCO_CHIPEDIT	= _T("chipedit");
static const _TCHAR* FDCO_CPOSX_	= _T("cposx:");
static const _TCHAR* FDCO_CPOSY_	= _T("cposy:");
static const _TCHAR* FDCO_DID_		= _T("did:");
static const _TCHAR* FDCO_HISTDRAW	= _T("histdraw");
static const _TCHAR* FDCO_HISTVIEW	= _T("histview");
static const _TCHAR* FDCO_HPS_		= _T("hps:");
static const _TCHAR* FDCO_HWND_		= _T("hwnd:");
static const _TCHAR* FDCO_REPAIR	= _T("repair");
static const _TCHAR* FDCO_SHEET_	= _T("sheet:");
static const _TCHAR* FDCO_DREQ_		= _T("dreq:");

static const int FDCO_ARROWEDIT_LEN	= _tcslen(FDCO_ARROWEDIT);
static const int FDCO_CHIPEDIT_LEN	= _tcslen(FDCO_CHIPEDIT);
static const int FDCO_CPOSX__LEN	= _tcslen(FDCO_CPOSX_);
static const int FDCO_CPOSY__LEN	= _tcslen(FDCO_CPOSY_);
static const int FDCO_DID__LEN		= _tcslen(FDCO_DID_);
static const int FDCO_HISTDRAW_LEN	= _tcslen(FDCO_HISTDRAW);
static const int FDCO_HISTVIEW_LEN	= _tcslen(FDCO_HISTVIEW);
static const int FDCO_HPS__LEN		= _tcslen(FDCO_HPS_);
static const int FDCO_HWND__LEN		= _tcslen(FDCO_HWND_);
static const int FDCO_REPAIR_LEN	= _tcslen(FDCO_REPAIR);
static const int FDCO_SHEET__LEN	= _tcslen(FDCO_SHEET_);
static const int FDCO_DREQ__LEN		= _tcslen(FDCO_DREQ_);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCommandLineInfo::CFCCommandLineInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.27 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
CFCCommandLineInfo::CFCCommandLineInfo ()
{
// 06.02.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_appMode = g_->appMode;		// _xZkqqHx_iDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
} // CFCCommandLineInfo::CFCCommandLineInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCommandLineInfo::ParseParam
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ParseCommandLine_xZkqqHx_iKnGjAjEiCmJiCkIiCkCiCmEiBeBiDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmMiJpAjAmNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszParam	:_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmMiIpIjAjEiBeC_xHqqkZx_
 *			bFlag		:_xZkqqHx_iDhEiDiJiDePiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeBiDhAiDiJiDiBiBfLiDfOiCmMiPoKiNiH_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *			bLast		:_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmMiNmFiMoDiCmMiDhEiDiJiDePiBeFiDhAiDiJiDiBiBfLiDfOiCmM_xHqqkZx_
 *						_xZkqqHx_iPoKiNiHiBeB_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmMiMgAiOkO_xHqqkZx_
 *				MolipDraw.exe
 *				MolipDraw.exe -repair
 *				MolipDraw.exe _xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_
 *				MolipDraw.exe -sheet:_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID -cposx:_xZkqqHx_jCiGjAfDiNmAjFfH_xHqqkZx_x -cposy:_xZkqqHx_jCiGjAfDiNmAjFfH_xHqqkZx_y _xZkqqHx_iDhEiDeAiDeDiDiLjGlM_xHqqkZx_
 *				MolipDraw.exe -chipedit -hwnd:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiL_xHqqkZx_
 *				MolipDraw.exe -arrowedit -hwnd:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiL_xHqqkZx_
 *				MolipDraw.exe -dreq:"OPEN_PROJECT(PROJECT_PATH = #c:\\doc\\abc\\abc.mdpj#);OPEN_HIDOCUMENT(HIDOCUMENT_ID = 1);"
 *
 *				MolipDraw.exe -histdraw
 *				MolipDraw.exe -histdraw _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlM_xHqqkZx_
 *				MolipDraw.exe -histdraw -did:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlM_xHqqkZx_
 *				MolipDraw.exe -histdraw -dreq:"OPEN_PROJECT(PROJECT_PATH = #c:\\doc\\abc\\abc.mdpj#);OPEN_HIDOCUMENT(HIDOCUMENT_ID = 1);"
 *
 *				MolipDraw.exe -histview
 *				MolipDraw.exe -histview _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlM_xHqqkZx_
 *				MolipDraw.exe -histview -did:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlM_xHqqkZx_
 *				MolipDraw.exe -histview -did:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID -hps:_xZkqqHx_jHjKjHpAiImKjChFiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlM_xHqqkZx_
 *				MolipDraw.exe -histview -dreq:"OPEN_PROJECT(PROJECT_PATH = #c:\\doc\\abc\\abc.mdpj#);OPEN_HIDOCUMENT(HIDOCUMENT_ID = 1);"
 *
 *			_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJiCmNiBeBjCmKiPoNiDhEiDeAiDeDiDiL_xHqqkZx_(*.mdrw)_xZkqqHx_iCmMiCnNiCkKiOhHjCoIiCmFiCkLiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jCmKiPoNiDhEiDeAiDeDiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCmN_xHqqkZx_CCommandLineInfo::ParseParam_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iJpAjAmNiClDiCoKiCoJiClNiCnPiBeBiClBiClBiCmFiJpAjAmNiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_jCmKiPoNiDhEiDeAiDeDiDiLiCmMiDeBiDeDiDfCiDjDiCpAiDfPiDhFiDiLiDeOiDiKiDgCiDeOjDjJiCmFjClMjAnKiKeKiCkCiClNiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iBhFiDhEiDeAiDeDiDiLjGlMiBhGiCkKjDfJjFhEiClDiCoKiCoJiBeCiDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiCpAiKeKiCkCiClN_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiBeBiBhF_xHqqkZx_-histdraw -hpf _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiBhGiCkKjDfJjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.07.23 Fukushiro M. _xZkqqHx_iDeJiDhGiDfGiDiHiDjDiOhHjCoIiMgAiOkOiCpAjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void CFCCommandLineInfo::ParseParam (LPCTSTR lpszParam, BOOL bFlag, BOOL bLast)
{
//	AfxDebugBreak();
	if (bFlag)
	//----- _xZkqqHx_iDhEiDiJiDeP_xHqqkZx_(/xxx, -xxx)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (_tcsnicmp(lpszParam, FDCO_ARROWEDIT, FDCO_ARROWEDIT_LEN) == 0)
		//----- arrowedit -----
		{
			// _xZkqqHx_iDeBiDhGiDiKiDiCiBfLiDgIiCmMjAnNjCoIiBeCiDeBiDiNiBfLiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeC_xHqqkZx_
			m_wAppMode = FD_APPMODE_ARROWEDITOR;
		} else
		if (_tcsnicmp(lpszParam, FDCO_CHIPEDIT, FDCO_CHIPEDIT_LEN) == 0)
		//----- chipedit -----
		{
			// _xZkqqHx_iDeBiDhGiDiKiDiCiBfLiDgIiCmMjAnNjCoIiBeCiDgAiDgCiDhGiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeC_xHqqkZx_
			m_wAppMode = FD_APPMODE_CHIPEDITOR;
		} else
		if (_tcsnicmp(lpszParam, FDCO_CPOSX_, FDCO_CPOSX__LEN) == 0)
		//----- cposx: -----
		{
			// _xZkqqHx_iDhCiDiFiBfL_xHqqkZx_X_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
			m_mmViewCenterX = ::_tcstod(lpszParam + FDCO_CPOSX__LEN, NULL);
		} else
		if (_tcsnicmp(lpszParam, FDCO_CPOSY_, FDCO_CPOSY__LEN) == 0)
		//----- cposy: -----
		{
			// _xZkqqHx_iDhCiDiFiBfL_xHqqkZx_Y_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
			m_mmViewCenterY = ::_tcstod(lpszParam + FDCO_CPOSY__LEN, NULL);
		} else
		if (_tcsnicmp(lpszParam, FDCO_DID_, FDCO_DID__LEN) == 0)
		//----- did: -----
		{
			// _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			m_lHidocumentId = _tcstol(lpszParam + FDCO_DID__LEN, NULL, 10);
		} else
		if (_tcsnicmp(lpszParam, FDCO_HISTDRAW, FDCO_HISTDRAW_LEN) == 0)
		//----- histdraw -----
		{
			// _xZkqqHx_iDeBiDhGiDiKiDiCiBfLiDgIiCmMjAnNjCoIiBeCiDhBiDfIiDgHiDiKiDgCiDeOiDgIiDiNiBfLiDiCiBfLiDgIiBeC_xHqqkZx_
			m_wAppMode = FD_APPMODE_HISTORICDRAW;
		} else
		if (_tcsnicmp(lpszParam, FDCO_HISTVIEW, FDCO_HISTVIEW_LEN) == 0)
		//----- histview -----
		{
			// _xZkqqHx_iDeBiDhGiDiKiDiCiBfLiDgIiCmMjAnNjCoIiBeCjHjKjHpAiDhCiDiFiBfLiDeBiDiCiBfLiDgIiBeC_xHqqkZx_
			m_wAppMode = FD_APPMODE_HISTORYVIEWER;
		} else

//----- 06.02.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		if (_tcsnicmp(lpszParam, FDCO_HPF_, FDCO_HPF__LEN) == 0)
//		//----- hpf: -----
//		{
//			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
//			m_strProjectPath = (WString)TStrToWStr(lpszParam + FDCO_HPF__LEN);
//		} else
//----- 06.02.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

		if (_tcsnicmp(lpszParam, FDCO_HPS_, FDCO_HPS__LEN) == 0)
		//----- hps: -----
		{
			// _xZkqqHx_jHjKjHpAiImKjChFiBeC_xHqqkZx_
			m_fliSessionIndex = ::_tcstoi64(lpszParam + FDCO_HPS__LEN, NULL, 10);
		} else
		if (_tcsnicmp(lpszParam, FDCO_HWND_, FDCO_HWND__LEN) == 0)
		//----- hwnd: -----
		{
			// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
			m_hwndDraw = (HWND)::_tcstoul(lpszParam + FDCO_HWND__LEN, NULL, 16);
		} else
		if (_tcsnicmp(lpszParam, FDCO_REPAIR, FDCO_REPAIR_LEN) == 0)
		//----- repair -----
		{
			// _xZkqqHx_iOmAiNhDiDiCiBfLiDgIiCmMjAnNjCoIiBeCjFlGiPjBiPeDjFjMiDiCiBfLiDgIiBeC_xHqqkZx_
			m_wRunMode = FD_RUNMODE_REPAIR_DOCUMENT;
		} else
		if (_tcsnicmp(lpszParam, FDCO_SHEET_, FDCO_SHEET__LEN) == 0)
		//----- sheet: -----
		{
			// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
			m_stidCurrentSheet = ::_tcstoul(lpszParam + FDCO_SHEET__LEN, NULL, 10);
		} else
		if (_tcsnicmp(lpszParam, FDCO_DREQ_, FDCO_DREQ__LEN) == 0)
		//----- dreq: -----
		{
			// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
			m_strDocRequest = (WString)TStrToWStr(lpszParam + FDCO_DREQ__LEN);
		} else
		{
			CCommandLineInfo::ParseParam(lpszParam, bFlag, bLast);
		}
	} else
	//----- _xZkqqHx_iDhEiDiJiDePiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		CCommandLineInfo::ParseParam(lpszParam, bFlag, bLast);
	}
} // CFCCommandLineInfo::ParseParam.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCommandLineInfo::ParseDocRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmJiLeMjDpMiClDiCoKiClNiPoOjFpBiBgJiDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiBeBjFlGiPjB_xHqqkZx_ID_xZkqqHx_jDjJiBgKiCpA_xHqqkZx_
 *			_xZkqqHx_jBfDiCmEiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiMgAiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCommandLineInfo::ParseDocRequest ()
{
//----- 06.02.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_nShellCommand == FileNew)
//	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCkKjAfGiLeLiNoMjAkMiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iClBiClBiCmFiCmNiJlNiCoAiClJiClIiBeB_xHqqkZx_m_nShellCommand_xZkqqHx_iCmJ_xHqqkZx_FileNothing_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//		// m_nShellCommand_xZkqqHx_iCmJ_xHqqkZx_FileNothing_xZkqqHx_iCpAjAnNjCoIiClHiCoJiCmGiBeB_xHqqkZx_ProcessShellCommand_xZkqqHx_iKnGjAjEjCiGiCmF_xHqqkZx_
//		// _xZkqqHx_jAfGiLeLiNoMjAkMiCmNiOmAiNhDiClDiCoKiCmIiCkNiCmIiCoJiCkKiBeB_xHqqkZx_InitInstance_xZkqqHx_iKnGjAjEjCiGiCmFiCmNiBeB_xHqqkZx_
//		// OnCmdMsg(ID_FILE_NEW)_xZkqqHx_iCmJiCoGiCmBiCmEiBeBjAfGiLeLiNoMjAkMiCkKiOmAiNhDiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_
//		// _xZkqqHx_jFeLjHhGiCmIiCkCiBeC_xHqqkZx_
//		m_nShellCommand = FileNothing;
//	} else
//	if (m_nShellCommand == FileOpen)
//	//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCkKiDhEiDeAiDeDiDiLiCpAiKeKiCkNiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		DWORD dwRequest = DWORD(-1);
//		switch (FFFileNameToFormat(TStrToWStr(m_strFileName)))
//		{
//		case FD_DTP_STANDARD_FORMAT:	// _xZkqqHx_jCmKiPoNiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdrw)
//		case FD_DTP_PORTABLE_FORMAT:	// _xZkqqHx_iDhMiBfLiDfOiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
//// 05.05.13 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////		case FD_DTP_VIEWER_FORMAT:		// _xZkqqHx_iDhCiDiFiBfLiDeBiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
//		case FD_DTP_WORK_FORMAT:		// _xZkqqHx_iDiPiBfLiDeOiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_
//			dwRequest = ID_DREQ_OPEN_DOCUMENT;
//			break;
//		default:
//			dwRequest = ID_DREQ_IMPORT_FILE;
//			break;
//		}
//		FCReqBase* pReqBase = new FCReqBase(dwRequest);
//		pReqBase->SetDocumentPath(TStrToWStr(m_strFileName));
//		m_vDocRequest.PushBack(pReqBase);
//		m_nShellCommand = FileNothing;
//	}
//
//	if (m_strProjectPath != NoValue)
//	//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhAiDfIiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		FCReqBase* pReqBase = new FCReqBase(ID_DREQ_OPEN_PROJECT);
//		pReqBase->SetProjectPath(m_strProjectPath.Get());
//		m_vDocRequest.PushBack(pReqBase);
//	}
//
//	if (m_lHidocumentId != NoValue)
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
//		FCReqBase* pReqBase = new FCReqBase(ID_DREQ_OPEN_HIDOCUMENT);
//		pReqBase->SetHidocumentId(m_lHidocumentId);
//		if (m_fliSessionIndex != NoValue)
//		//----- _xZkqqHx_jHjKjHpAjFlGiPjBiImKjChFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			pReqBase->SetSessionIndex(m_fliSessionIndex);
//		}
//		m_vDocRequest.PushBack(pReqBase);
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//		if ((m_stidCurrentSheet == NoValue) &&
//			((m_mmViewCenterX == NoValue) || (m_mmViewCenterY == NoValue)))
//		//----- _xZkqqHx_iDfGiBfLiDgHiInKjDkOiBeBiDhCiDiFiBfLiInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jBiAiNoMiImKjChFiCnGiDfIiDeOiDiNiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
//			pReqBase = new FCReqBase(ID_DREQ_SCROLL_TO_SPOT,
//									FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_ANYWAY,
//									FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_BEFORE_TO_AFTER,
//									FCReqBase::IS_SELECT_OBJECT, FALSE,
//									FCReqBase::NONE);
//			m_vDocRequest.PushBack(pReqBase);
//		}
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	} else
//	//----- _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		if (m_fliSessionIndex != NoValue)
//		//----- _xZkqqHx_jHjKjHpAjFlGiPjBiImKjChFiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiInKjDkOiCpAiOhHjCoIiBeC_xHqqkZx_
//			FCReqBase* pReqBase = new FCReqBase(ID_DREQ_MOVE_HISTORY_UNTIL_SESSION);
//			pReqBase->SetSessionIndex(m_fliSessionIndex);
//			m_vDocRequest.PushBack(pReqBase);
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//			if ((m_stidCurrentSheet == NoValue) &&
//				((m_mmViewCenterX == NoValue) || (m_mmViewCenterY == NoValue)))
//			//----- _xZkqqHx_iDfGiBfLiDgHiInKjDkOiBeBiDhCiDiFiBfLiInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//			{
//				// _xZkqqHx_jBiAiNoMiImKjChFiCnGiDfIiDeOiDiNiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
//				pReqBase = new FCReqBase(ID_DREQ_SCROLL_TO_SPOT,
//										FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_ANYWAY,
//										FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_BEFORE_TO_AFTER,
//										FCReqBase::IS_SELECT_OBJECT, FALSE,
//										FCReqBase::NONE);
//				m_vDocRequest.PushBack(pReqBase);
//			}
////----- 05.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//		}
//	}
//
//	if (m_stidCurrentSheet != NoValue ||
//		(m_mmViewCenterX != NoValue && m_mmViewCenterY != NoValue))
//	//----- _xZkqqHx_iDfGiBfLiDgHiInKjDkOiBeBiDhCiDiFiBfLiInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		FCReqBase* pReqBase = new FCReqBase(ID_DREQ_CHANGE_SHEET_ZOOM_CENTER);
//		if (m_stidCurrentSheet != NoValue)
//		{
//			pReqBase->SetSheetId(m_stidCurrentSheet);
//		}
//		if (m_mmViewCenterX != NoValue &&
//			m_mmViewCenterY != NoValue)
//		{
//			pReqBase->SetMmX(m_mmViewCenterX);
//			pReqBase->SetMmY(m_mmViewCenterY);
//		}
//		m_vDocRequest.PushBack(pReqBase);
//	}
//
//	if (m_strDocRequest != NoValue)
//	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		FFInsertDocRequest(m_vDocRequest, -1, m_strDocRequest.Get());
//	}
//
//	if ((m_appMode & FD_APPMODE_MASK) == FD_APPMODE_HISTORYVIEWER ||
//		(m_appMode & FD_APPMODE_MASK) == FD_APPMODE_HISTORICDRAW)
//	//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
//		if (m_vDocRequest.FindRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT) == -1)
//		{
//			FCReqBase* pReqBase = new FCReqBase(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiDfIiDeOiDiNiBfLiDiLiClHiCoJiCkJiBeI_xHqqkZx_
//			pReqBase->SetIsScrollHtreeView(TRUE);
//			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiOkJjDkOiCmFiDfJiBfLiDiAiClHiCoJiCkJiBeI_xHqqkZx_
//			pReqBase->SetIsFitHtreeViewZoom(TRUE);
//			m_vDocRequest.PushBack(pReqBase);
//		}
//	}
//----- 06.02.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (m_strDocRequest != NoValue)
	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDhGiDiKiOoNjHnOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_DynamicDraw_xZkqqHx_iCmJiBeC_xHqqkZx_
		if (m_wAppMode == NoValue)
			m_wAppMode = FD_APPMODE_DYNAMICDRAW;
		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBjFlGiOjKjHpBiCpAiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBjEhKjHpBiCmJjFmPiKlHiBeC_xHqqkZx_
		FFInsertDocRequest(m_vDocRequest, -1, m_strDocRequest.Get());
	} else
	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		WString wstrFilePath;
		FTDocumentFormat df = FD_DTP_NONE;		// _xZkqqHx_iMfOjGlDiClFiBeC_xHqqkZx_
		if (m_nShellCommand == FileOpen)
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCkKiDhEiDeAiDeDiDiLiCpAiKeKiCkNiCmMiPoKiNiH_xHqqkZx_ -----
		{
			wstrFilePath = TStrToWStr(m_strFileName);
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiDhEiDeAiDeDiDiLiKgHjCkDiOhBiCkJiCoHiOoGjDlOiBeC_xHqqkZx_
			df = FFFileNameToFormat(wstrFilePath);

			if (m_wAppMode == NoValue)
			//----- _xZkqqHx_iDeBiDhGiDiKiOoNjHnOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDhEiDeAiDeDiDiLiKgHjCkDiOhBiCkJiCoHiDeBiDhGiDiKiCmMiOoNjHnOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
				switch (df)
				{
				case FD_DTP_TABLE_DATA_FORMAT:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddtb)
				case FD_DTP_PROJECT_FORMAT:		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ (.mdpj)
					// HistoricDraw_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
					m_wAppMode = FD_APPMODE_HISTORICDRAW;
					break;
				case FD_DTP_TABLE_INDEX_FORMAT:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddix)
					// HistoryViewer_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
					m_wAppMode = FD_APPMODE_HISTORYVIEWER;
					break;
				default:						// _xZkqqHx_iClLiCmMjBlMiBeC_xHqqkZx_
					// DynamicDraw_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
					m_wAppMode = FD_APPMODE_DYNAMICDRAW;
				}
			}

			// _xZkqqHx_iDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiCmNiDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCmJjFoCjAlDiBeC_xHqqkZx_
			switch (df)
			{
			case FD_DTP_TABLE_DATA_FORMAT:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddtb)
			case FD_DTP_TABLE_INDEX_FORMAT:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddix)
				wstrFilePath = FFTableToTopDirPath(wstrFilePath);
				df = FD_DTP_PROJECT_FORMAT;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ (.mdpj)
			}
		}

		// _xZkqqHx_iDeBiDhGiDiKiOoNjHnOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_DynamicDraw_xZkqqHx_iCmJiBeC_xHqqkZx_
		if (m_wAppMode == NoValue)
			m_wAppMode = FD_APPMODE_DYNAMICDRAW;

		FCReqBase* pReqBase;
		switch (m_wAppMode.Get())
		{
		case FD_APPMODE_DYNAMICDRAW:	// DynamicDraw_xZkqqHx_iDiCiBfLiDgIiBeC_xHqqkZx_
			switch (df)
			{
			case FD_DTP_STANDARD_FORMAT:	// _xZkqqHx_jCmKiPoNiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdrw)
			case FD_DTP_PORTABLE_FORMAT:	// _xZkqqHx_iDhMiBfLiDfOiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdpf)
			case FD_DTP_WORK_FORMAT:		// _xZkqqHx_iDiPiBfLiDeOiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdwk)
				// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
				pReqBase = new FCReqBase(	ID_DREQ_OPEN_DOCUMENT,
											FCReqBase::DOCUMENT_PATH, wstrFilePath.c_str(),
											FCReqBase::NONE);
				m_vDocRequest.PushBack(pReqBase);
				break;
			case FD_DTP_NONE:				// _xZkqqHx_iMfOjGlDiClFiBeC_xHqqkZx_
			case FD_DTP_PROJECT_FORMAT:		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ (.mdpj)
				break;
			default:
				// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDeDiDjDiDhMiBfLiDgHiClHiCoJiBeC_xHqqkZx_
				pReqBase = new FCReqBase(	ID_DREQ_IMPORT_FILE,
											FCReqBase::DOCUMENT_PATH, wstrFilePath.c_str(),
											FCReqBase::NONE);
				m_vDocRequest.PushBack(pReqBase);
				break;
			}
			if (m_stidCurrentSheet != NoValue ||
				(m_mmViewCenterX != NoValue && m_mmViewCenterY != NoValue))
			//----- _xZkqqHx_iDfGiBfLiDgHiInKjDkOiBeBiDhCiDiFiBfLiInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				pReqBase = new FCReqBase(ID_DREQ_CHANGE_SHEET_ZOOM_CENTER);
				if (m_stidCurrentSheet != NoValue)
					pReqBase->SetSheetId(m_stidCurrentSheet);
				if (m_mmViewCenterX != NoValue &&
					m_mmViewCenterY != NoValue)
				{
					pReqBase->SetMmX(m_mmViewCenterX);
					pReqBase->SetMmY(m_mmViewCenterY);
				}
				m_vDocRequest.PushBack(pReqBase);
			}
			break;
#ifdef _DD_PRO
		case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiDiCiBfLiDgIiBeC_xHqqkZx_
		case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iDiCiBfLiDgIiBeC_xHqqkZx_
			switch (df)
			{
			case FD_DTP_PROJECT_FORMAT:		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ (.mdpj)
				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkNiBeC_xHqqkZx_
				pReqBase = new FCReqBase(	ID_DREQ_OPEN_PROJECT,
											FCReqBase::PROJECT_PATH, wstrFilePath.c_str(),
											FCReqBase::NONE);
				m_vDocRequest.PushBack(pReqBase);
				if (m_lHidocumentId != NoValue)
				//----- _xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
					if (m_fliSessionIndex != NoValue)
						pReqBase = new FCReqBase(	ID_DREQ_OPEN_HIDOCUMENT,
													FCReqBase::HIDOCUMENT_ID, m_lHidocumentId,
													FCReqBase::SESSION_INDEX, m_fliSessionIndex,
													FCReqBase::NONE);
					else
						pReqBase = new FCReqBase(	ID_DREQ_OPEN_HIDOCUMENT,
													FCReqBase::HIDOCUMENT_ID, m_lHidocumentId,
													FCReqBase::NONE);
					m_vDocRequest.PushBack(pReqBase);

					if (m_stidCurrentSheet != NoValue ||
						(m_mmViewCenterX != NoValue && m_mmViewCenterY != NoValue))
					//----- _xZkqqHx_iDfGiBfLiDgHiInKjDkOiBeBiDhCiDiFiBfLiInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
					{
						pReqBase = new FCReqBase(ID_DREQ_CHANGE_SHEET_ZOOM_CENTER);
						if (m_stidCurrentSheet != NoValue)
							pReqBase->SetSheetId(m_stidCurrentSheet);
						if (m_mmViewCenterX != NoValue &&
							m_mmViewCenterY != NoValue)
						{
							pReqBase->SetMmX(m_mmViewCenterX);
							pReqBase->SetMmY(m_mmViewCenterY);
						}
						m_vDocRequest.PushBack(pReqBase);
					} else
					//----- _xZkqqHx_iDfGiBfLiDgHiInKjDkOiBeBiDhCiDiFiBfLiInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
					{
						// _xZkqqHx_jBiAiNoMiImKjChFiCnGiDfIiDeOiDiNiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
						pReqBase = new FCReqBase(	ID_DREQ_SCROLL_TO_SPOT,
													FCReqBase::SCROLL_TO_FRAME, SCROLL_TO_FRAME::SCROLL_ANYWAY,
													FCReqBase::SESSION_DIRECTION, SESSION_DIRECTION::FROM_BEFORE_TO_AFTER,
													FCReqBase::IS_SELECT_OBJECT, FALSE,
													FCReqBase::NONE);
						m_vDocRequest.PushBack(pReqBase);
					}
				}
				break;
			}
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			pReqBase = new FCReqBase(	ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT,
										FCReqBase::IS_SCROLL_HTREE_VIEW, TRUE,		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiDfIiDeOiDiNiBfLiDiLiClHiCoJiCkJiBeI_xHqqkZx_
										FCReqBase::IS_FIT_HTREE_VIEW_ZOOM, TRUE,	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAiOkJjDkOiCmFiDfJiBfLiDiAiClHiCoJiCkJiBeI_xHqqkZx_
										FCReqBase::NONE);
			m_vDocRequest.PushBack(pReqBase);
			break;
#endif//_DD_PRO
		}
	}
	// m_nShellCommand_xZkqqHx_iCmJ_xHqqkZx_FileNothing_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	// m_nShellCommand_xZkqqHx_iCmJ_xHqqkZx_FileNothing_xZkqqHx_iCpAjAnNjCoIiClHiCoJiCmGiBeB_xHqqkZx_ProcessShellCommand_xZkqqHx_iKnGjAjEjCiGiCmF_xHqqkZx_
	// _xZkqqHx_jAfGiLeLiNoMjAkMiBeFjFlGiPjBiDeJiBfLiDhGiDjDiCmNiOmAiNhDiClDiCoKiCmIiCkNiCmIiCoJiCkKiBeB_xHqqkZx_InitInstance_xZkqqHx_iKnGjAjEjCiGiCmFiCmNiBeB_xHqqkZx_
	// OnCmdMsg(ID_FILE_NEW)_xZkqqHx_iCmJiCoGiCmBiCmEiBeBjAfGiLeLiNoMjAkMiCkKiOmAiNhDiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_jFeLjHhGiCmIiCkCiBeC_xHqqkZx_
	m_nShellCommand = FileNothing;
//----- 06.02.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCCommandLineInfo::ParseDocRequest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCommandLineInfo::CheckSameDocumentApp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJjDkPiClGiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjBlGiNnNiClHiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iDgAiDeGiDgCiDeOiClFiCmEiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmNiClLiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDocRequest	:_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGjFlGiPjBiDeBiDhGiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ DD3_xZkqqHx_iCmMiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeCjBlGiNnNiClFiCmIiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			02.10.03 Fukushiro M. _xZkqqHx_jFmPiNfI_xHqqkZx_
 *			03.09.23 Fukushiro M. _xZkqqHx_jFmPiNfI_xHqqkZx_
 *************************************************************************/
HWND CFCCommandLineInfo::CheckSameDocumentApp () const
//----- 02.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (<mdrwpos >_xZkqqHx_iCmFiKpJiCmJiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_DD3_xZkqqHx_jFlGiPjBiCpAiOhHjCoIiClFiCmEiCoAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_)-----
{
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCkJiCoHiBeBjFlGiPjBiDhEiDeAiDeDiDiLiDhAiDfIiBeB_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiDhAiDfIiBeBjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	WString wstrDocumentPath;
	WString wstrProjectPath;
	long lHidocumentId = -1;
	long lIndex;
	lIndex = m_vDocRequest.FindRequest(ID_DREQ_OPEN_DOCUMENT);
	if (lIndex != -1)
	{
		if (!m_vDocRequest.GetAt(lIndex)->IsNullDocumentPath())
			wstrDocumentPath = m_vDocRequest.GetAt(lIndex)->GetDocumentPath();
	}
	lIndex = m_vDocRequest.FindRequest(ID_DREQ_OPEN_PROJECT);
	if (lIndex != -1)
	{
		if (!m_vDocRequest.GetAt(lIndex)->IsNullProjectPath())
			wstrProjectPath = m_vDocRequest.GetAt(lIndex)->GetProjectPath();
	}
	lIndex = m_vDocRequest.FindRequest(ID_DREQ_OPEN_HIDOCUMENT);
	if (lIndex != -1)
	{
		if (!m_vDocRequest.GetAt(lIndex)->IsNullHidocumentId())
			lHidocumentId = m_vDocRequest.GetAt(lIndex)->GetHidocumentId();
	}

	HWND hwndTarget = NULL;
	// _xZkqqHx_iLeOjDkOiMlDiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
	HWND hwndFrom = (AfxGetMainWnd() != NULL) ? AfxGetMainWnd()->GetSafeHwnd() : NULL;
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		if (!wstrDocumentPath.IsEmpty())
		{
			// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
			hwndTarget = FFFindDdDocumentWindow(wstrDocumentPath, hwndFrom);
		}
		break;
#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		if (!wstrProjectPath.IsEmpty())
		{
			// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
			hwndTarget = FFFindHidocumentWindow(wstrProjectPath, lHidocumentId, hwndFrom);
		}
		break;
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		if (!wstrProjectPath.IsEmpty())
		{
			// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
			hwndTarget = FFFindHidocumentWindow(wstrProjectPath, lHidocumentId, hwndFrom);
		}
		break;
#endif//_DD_PRO
	}
	return hwndTarget;
} // CFCCommandLineInfo::CheckSameDocumentApp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCommandLineInfo::GetAppMode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCkJiCoHiOoGjDlOiClFiClNiDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFnEjCgMiCmNiBeBiDgGiDhEiDeIiDiLiDgHiCmMiOmAiNhDiDiCiBfLiDgIiCmGiDfCiDhNiDjDiDgIiDiJiDeDiDjDiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiClFiClNiOmAiNhDiDiCiBfLiDgIiCmMjIfPjHjNjIgBiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD CFCCommandLineInfo::GetAppMode () const
{
	WORD wAppRunMode = m_wAppMode.Get();		// _xZkqqHx_iDeBiDhGiDiKiOoNjHnOiBeC_xHqqkZx_
	// _xZkqqHx_iOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
	if (m_wRunMode != NoValue)
		wAppRunMode |= m_wRunMode.Get();
	return wAppRunMode;
} // CFCCommandLineInfo::GetAppMode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCommandLineInfo::GetDrawHwnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCkJiCoHiOoGjDlOiClFiClNiBeBiClBiCmMiDeBiDhGiDiKiCmMiMmEiCnBiPgPiClFiMlDiCmM_xHqqkZx_
 *			MolipDraw.exe_xZkqqHx_iCmM_xHqqkZx_HWND_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMmEiCnBiPgPiClFiMlDiCmM_xHqqkZx_MolipDraw.exe_xZkqqHx_iCmM_xHqqkZx_HWND_xZkqqHx_iBeCiMmEiCnBiPgPiClFiMlDiCkKiOhHjCoIiClDiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCmIiCkPiCoKiCmO_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HWND CFCCommandLineInfo::GetDrawHwnd () const
{
	return (m_hwndDraw != NoValue) ? m_hwndDraw : NULL;
} // CFCCommandLineInfo::GetDrawHwnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCommandLineInfo::GetDocRequest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCkJiCoHiOoGjDlOiClFiClNiBeBiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmFiOhHjCoIiClDiCoKiClNiBeBiDfGiBfLiDgHiInKjDkOiBeBiDhCiDiFiBfLiInKjDkOiBeB_xHqqkZx_
 *			_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmIiCmHiCpAiCnMiCmGiCnPiCmEiIoKiCmCiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCReqBaseAutoVector& CFCCommandLineInfo::GetDocRequest () const
{
	return m_vDocRequest;
} // CFCCommandLineInfo::GetDocRequest.

/////////////////////////////////////////////////////////////////////////////
// CFCMolipDrawApp

BEGIN_MESSAGE_MAP(CFCMolipDrawApp, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCMolipDrawApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_APP_WIN_EXIT, OnAppWinExit)
	ON_COMMAND(ID_HELP_MOLIP_HOMEPAGE, OnHelpMolipHomepage)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	//}}AFX_MSG_MAP
	// _xZkqqHx_jFfHiPiAiCmMiDhEiDeAiDeDiDiLiKoOjGhLiDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
// 02.09.20 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ (_xZkqqHx_iDhEiDeAiDeDiDiLiDeJiBfLiDhGiDjDiCmFiBeBiNkBiKeKiCkCiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCmGjDkPiClGiDhEiDeIiDiLiDfPiCmMiDhEiDeAiDeDiDiLiCpAjCfEiClFiCmJiNhDiCkJiCmIiCkCiBeC_xHqqkZx_)
//	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// _xZkqqHx_jFfHiPiAiCmMiIpDiNpMiDfKiDgCiDgHiDeBiDgCiDhG_xHqqkZx_ _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_
//	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
//	ON_COMMAND_EX_RANGE(ID_FILE_MRU_FILE1, ID_FILE_MRU_FILE16, OnOpenRecentFile)
// 06.03.25 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	ON_COMMAND(ID_HELP_MOVIE, OnHelpMovie)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCMolipDrawApp _xZkqqHx_iDeOiDiJiDfIiCmMiNfMjChK_xHqqkZx_

CFCMolipDrawApp::CFCMolipDrawApp ()
{
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDfMiBfLiDfIjHhAiDeDiDjDiDfIiDfOiDjDiDfIiBeC_xHqqkZx_
	m_hResInstance = NULL;
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiBeC_xHqqkZx_
	m_pPopHint = new CFCPursuerText();

//----- 05.08.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#ifdef _DEBUG
//	int tmpDbgFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);
//	tmpDbgFlag |= _CRTDBG_CHECK_ALWAYS_DF;
//	_CrtSetDbgFlag(tmpDbgFlag);
//#endif//_DEBUG
//----- 05.08.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // CFCMolipDrawApp::CFCMolipDrawApp.

CFCMolipDrawApp::~CFCMolipDrawApp ()
{
//----- 03.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiBiDiCiDiKiDiKiBfLiDeOiCpAiKlEjCgNiBeC_xHqqkZx_
//	_CrtDumpMemoryLeaks();
//----- 03.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCpAjEgKiKpMiBeC_xHqqkZx_
	m_pPopHint->DestroyWindow();
	delete m_pPopHint;
} // CFCMolipDrawApp::~CFCMolipDrawApp.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_jHeCiIoKiCmM_xHqqkZx_ CFCMolipDrawApp _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_

CFCMolipDrawApp theApp;

// _xZkqqHx_iClBiCmM_xHqqkZx_ ID _xZkqqHx_iCmNiClBiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjDjNiMhGjDeJiCmJiDiGiDgKiBfLiDeOiCmJiCmIiCoJiCoGiCkEiCmJjAlGjAkMiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
// _xZkqqHx_iCoAiClFiBeBjDmBjFmKiCmI_xHqqkZx_ ID _xZkqqHx_iCpAiOhHjCoIiClFiClNiCkCiCmIiCoHiCmOiBeBjFmPiNfIiClFiCmEiCoAiCkJiCnMiCkCiCnMiClJiCpBiBeC_xHqqkZx_

//----- 01.01.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 00.08.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////// {DC96FFA0-119F-11D0-B80C-444553540000}
////static const CLSID clsid =
////{ 0xdc96ffa0, 0x119f, 0x11d0, { 0xb8, 0xc, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };
////----- 00.08.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
////----- 00.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////// {6B73A07D-1F3A-4502-A920-57CFA19DE990}
////static const CLSID clsid =
////{ 0x6b73a07d, 0x1f3a, 0x4502, { 0xa9, 0x20, 0x57, 0xcf, 0xa1, 0x9d, 0xe9, 0x90 } };
////----- 00.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//// {3387DAE0-E325-437f-8512-343E1B1EA608}
//static const CLSID clsid =
//{ 0x3387dae0, 0xe325, 0x437f, { 0x85, 0x12, 0x34, 0x3e, 0x1b, 0x1e, 0xa6, 0x8 } };
////----- 00.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
////----- 00.08.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.01.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// {6B73A07D-1F3A-4502-A920-57CFA19DE990}
static const CLSID clsid = DYNAMIC_DRAW_CLSID;
//----- 01.01.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_jHeCiIoKiCmMiDhGiDiNiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
FCHiProject* g_pProject = NULL;

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiGiBfLiDfFiDfCiBfLiDgIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetResourceInstance
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_DLL_xZkqqHx_iCmMiDeDiDjDiDfIiDfOiDjDiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_DLL_xZkqqHx_iCmMiDeDiDjDiDfIiDfOiDjDiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HINSTANCE CFCMolipDrawApp::GetResourceInstance () const
{
	return m_hResInstance;
} // CFCMolipDrawApp::GetResourceInstance.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetDocString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiMfOiCpAiOkGiClHjDmBjCoIiCmMjFjEjFkKjFlGiOjKjHpBiCpAiOoGjDlOiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	index	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMiMfOiCpAjFfMiClHjFlGiOjKjHpBiCkJiCoHiOoGjDlOiClHiCoJjFjEjFkKjFlGiOjKjHpB_xHqqkZx_
 *					 _xZkqqHx_iCnGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClFiClNjFjEjFkKjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCMolipDrawApp::GetDocString (CDocTemplate::DocStringIndex index) const
{
	//----- _xZkqqHx_jFlGiOjKjHpBiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
	POSITION pos = GetFirstDocTemplatePosition();
	CDocTemplate* pDocTemplate = GetNextDocTemplate(pos);
	CString strDocName;
	if (pDocTemplate->GetDocString(strDocName, index))
	{
		return TStrToWStr(strDocName);
	}
	return L"";
} // CFCMolipDrawApp::GetDocString.

//----- 03.09.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::ReadRecentFileList
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiNmFiLnPiOgHiCoNiCoKiClNiDhEiDeAiDeDiDiLiBhGiCmMiPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::ReadRecentFileList ()
//{
//	if (m_pRecentFileList != NULL)
//		m_pRecentFileList->ReadList();
//} // CFCMolipDrawApp::ReadRecentFileList.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::WriteRecentFileList
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFiNmFiLnPiOgHiCoNiCoKiClNiDhEiDeAiDeDiDiLiBhGiCmMiPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::WriteRecentFileList ()
//{
//	if (m_pRecentFileList != NULL)
//	{
//		// _xZkqqHx_iNmFiLnPiCmMiDiKiDfIiDgHiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiPgPiClFiBeC_xHqqkZx_
//		m_pRecentFileList->WriteList();
////----- 00.06.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		if (::IsWindow(FFGetMainWnd()->GetWnd()->m_hWnd))
////		{
////----- 00.06.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_jDkPiClGiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFjHpBiLjDiBeC_xHqqkZx_
//		FCWinTitleRecVector vWinTtl;
//		::EnumWinTitle(vWinTtl);
//		FCWinTitleRecVector::iterator iWin;
//		for (iWin = vWinTtl.begin(); iWin != vWinTtl.end(); iWin++)
//		{
//			// WM_USER_RECENT_FILE_LIST_UPDATED_xZkqqHx_iCpAjBjHjAeNiBeCiDiKiDfIiDgHiCpAjDmHiCnNjClMiClHiBeC_xHqqkZx_
//			::PostMessage((*iWin).hwndApp, WM_USER_RECENT_FILE_LIST_UPDATED, 0, 0);
//		}
//// 00.06.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////		}
//	}
//} // CFCMolipDrawApp::WriteRecentFileList.
//----- 03.09.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetPaperSizeList
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCmGjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPaperId	:_xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			vPaperSize	:_xZkqqHx_iPgDiBgJiDhMiBfLiDgHiDiMiBfLiDgHiBgKiCmMiPoKiNiHiCmMjHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *						 _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCmMjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
// *			lpDevNames	:DEVNAMES_xZkqqHx_iNfMjBkCjBmMiCpAjAnNjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiCkKiOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	dmPaperSize _xZkqqHx_iCkKiLeLjCoIjCgMiBgJ_xHqqkZx_DMPAPER_XXX_xZkqqHx_iBgKiCmMiCnNiCmFiCkAiCoJiCmIiCoHiBeBiDeBiBfLiDeKiDeDiDhFiCmJ_xHqqkZx_
// *			DEVMODE_xZkqqHx_jEhKjHpBiCpAjFnLjBlGiClHiCoKiCmOiNmPiCnOiCmMiClOiCkKiBeBiDhGiDiKiDjDiDfOiCmJiCoGiCmBiCmEiCmNiLeLjCoIjCgMiKePiCmM_xHqqkZx_
// *			_xZkqqHx_jCgMiCkKiOgHiCoNiCoKiCoJiPoKiNiHiBkGiCkKiCkAiCoJiClNiCnPiBeBjHhAiOiGiDfEiDeDiDfJiCpAjFmKiCmJjFnLjBlGiClFiCmEiCkIiCkNiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCkEiClFiCmIiCkCiCmGiBeBiDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiClFiClNiKmCiLkLiCmGiDiNiBfLiDgIiClFiClNiKmCiLkLiCmF_xHqqkZx_
// *			_xZkqqHx_iDhGiDiKiDjDiDfOiCkKiInJiCmIiCoJiPoKiNiHiBeBjDkPiClGjHhAiOiGiDfEiDeDiDfJiCkKjBeJjBpAiClDiCoKiCmIiCkNiCmIiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iBkGiCgHiCgPiCmMiDhGiDiKiDjDiDfOiCmFiCmNiBeB_xHqqkZx_B4_xZkqqHx_iCmJ_xHqqkZx_2
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static BOOL myGetPaperSizeList (WORDVector& vPaperId,
//								CPointVector& vPaperSize,
//								LPDEVNAMES lpDevNames)
//{
//	// _xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
//	const CString strDevice(((char*)lpDevNames) + lpDevNames->wDeviceOffset);
//	// _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
//	const CString strPort(((char*)lpDevNames) + lpDevNames->wOutputOffset);
//	//----- _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	DWORD dwDataSize = DeviceCapabilities(strDevice, strPort, DC_PAPERS, NULL, NULL);
//	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
//	vPaperId.assign(dwDataSize);
//	// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	DeviceCapabilities(strDevice, strPort, DC_PAPERS, (LPTSTR)vPaperId.begin(), NULL);
//
//	//----- _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	dwDataSize = DeviceCapabilities(strDevice, strPort, DC_PAPERSIZE, NULL, NULL);
//	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
//	vPaperSize.assign(dwDataSize);
//	// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	DeviceCapabilities(strDevice, strPort, DC_PAPERSIZE, (LPTSTR)vPaperSize.begin(), NULL);
//	return TRUE;
//} // myGetPaperSizeList.
//----- 05.05.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.05.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myGetPaperSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMiOhHjCoIiClDiCoKiClNjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCmMjHhAiOiGiDfEiDeDiDfJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptPaperSize	:_xZkqqHx_iPgDiBgJiDhMiBfLiDgHiDiMiBfLiDgHiBgKiCmMjHhAiOiGiDfEiDeDiDfJiCpAjFnEiClHiBeCjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
// *			tcpDevice	:_xZkqqHx_iDhGiDiKiDjDiDfOiDgGiDgPiDeDiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			tcpPort		:_xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnKjBlBiClDiCoKiCmEiCkCiCoJiDhMiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *			dmPaperSize	:_xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_DMPAPER_LETTER_xZkqqHx_iBeB_xHqqkZx_DMPAPER_A4 _xZkqqHx_jDjJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJiCkKiOoGjDlOiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	dmPaperSize _xZkqqHx_iCkKiLeLjCoIjCgMiBgJ_xHqqkZx_DMPAPER_XXX_xZkqqHx_iBgKiCmMiCnNiCmFiCkAiCoJiCmIiCoHiBeBiDeBiBfLiDeKiDeDiDhFiCmJ_xHqqkZx_
// *			DEVMODE_xZkqqHx_jEhKjHpBiCpAjFnLjBlGiClHiCoKiCmOiNmPiCnOiCmMiClOiCkKiBeBiDhGiDiKiDjDiDfOiCmJiCoGiCmBiCmEiCmNiLeLjCoIjCgMiKePiCmM_xHqqkZx_
// *			_xZkqqHx_jCgMiCkKiOgHiCoNiCoKiCoJiPoKiNiHiBkGiCkKiCkAiCoJiClNiCnPiBeBjHhAiOiGiDfEiDeDiDfJiCpAjFmKiCmJjFnLjBlGiClFiCmEiCkIiCkNiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCkEiClFiCmIiCkCiCmGiBeBiDhEiDeAiDeDiDiLiCpAiDfKiBfLiDhFiClFiClNiKmCiLkLiCmGiDiNiBfLiDgIiClFiClNiKmCiLkLiCmF_xHqqkZx_
// *			_xZkqqHx_iDhGiDiKiDjDiDfOiCkKiInJiCmIiCoJiPoKiNiHiBeBjDkPiClGjHhAiOiGiDfEiDeDiDfJiCkKjBeJjBpAiClDiCoKiCmIiCkNiCmIiCoJiBeC_xHqqkZx_
// *			_xZkqqHx_iBkGiCgHiCgPiCmMiDhGiDiKiDjDiDfOiCmFiCmNiBeB_xHqqkZx_B4_xZkqqHx_iCmJ_xHqqkZx_2
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static BOOL myGetPaperSize (CPoint& ptPaperSize, const _TCHAR* tcpDevice, const _TCHAR* tcpPort, short dmPaperSize)
//{
//	//----- _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	DWORD dwDataSize = DeviceCapabilities(tcpDevice, tcpPort, DC_PAPERS, NULL, NULL);
//	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
//	WORDVector vPaperBuff(dwDataSize);
//	// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_jEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	DeviceCapabilities(tcpDevice, tcpPort, DC_PAPERS, (LPTSTR)vPaperBuff.begin(), NULL);
//
//	//----- _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOoGjDlOiClHiCoJ_xHqqkZx_ -----
//	// _xZkqqHx_iDgGiBfLiDfOiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//	dwDataSize = DeviceCapabilities(tcpDevice, tcpPort, DC_PAPERSIZE, NULL, NULL);
//	// _xZkqqHx_iDgGiBfLiDfOiCkKiOoGjDlOiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
//	if (dwDataSize == 0 || dwDataSize == DWORD(-1)) return FALSE;
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiBeC_xHqqkZx_
//	CPointVector vSizeBuff(dwDataSize);
//	// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjEhKjHpBiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
//	DeviceCapabilities(tcpDevice, tcpPort, DC_PAPERSIZE, (LPTSTR)vSizeBuff.begin(), NULL);
//	// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
//	WORDVector::const_iterator i = find(vPaperBuff.begin(), vPaperBuff.end(), dmPaperSize);
//	if (i != vPaperBuff.end())
//	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		ptPaperSize = vSizeBuff[i - vPaperBuff.begin()];
//		return TRUE;
//	}
//	// _xZkqqHx_iClBiClBiCmJiCkNiCoJiClBiCmGiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
//	ASSERT(FALSE);
//	return FALSE;
//} // myGetPaperSize.
//----- 05.05.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::SetPrinterPaperSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhGiDiKiDjDiDfOiCmMjHhAiOiGiDfEiDeDiDfJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dmOrientation	:_xZkqqHx_jHhAiOiGiCmMiMpMiCkLiCpAiOhHjCoIiBeC_xHqqkZx_
 *				_xZkqqHx_iPgD_xHqqkZx_	:DMORIENT_PORTRAIT (=1)
 *				_xZkqqHx_iJkB_xHqqkZx_	:DMORIENT_LANDSCAPE (=2)
 *			ptPaperSize		:_xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAiOhHjCoIiBeCjCfAiImKiCmN_xHqqkZx_0.1mm_xZkqqHx_iBeC_xHqqkZx_
 *			wPaperIdReccomended
 *							:_xZkqqHx_jDkPiClGjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCkKjFkBjAjEiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmJiBeBjHeEjAoGiClFiCmEjBeJjBpAiClHiCoJ_xHqqkZx_
 *							 _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_WORD(-1)_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCkKjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeCiMlLiNnNiCmMiDhGiDiKiDjDiDfOiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiCmJiBeBiOhHjCoIiClDiCoKiClNjHhAiOiGiDfEiDeDiDfJiCkKjDpBiCmCiImIiPoDjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
 *			wPaperIdReccomended _xZkqqHx_iCmGiIoKjChGiClHiCoJjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjHeEjAoGiClHiCoJiBeC_xHqqkZx_
 *			wPaperIdReccomended _xZkqqHx_iCmGiIoKjChGiClHiCoJjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiCoAjCgMiCmMiPkMiClDiCkCjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::SetPrinterPaperSize (short dmOrientation, CPoint ptPaperSize, WORD wPaperIdReccomended)
{
//----- 06.02.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	return TRUE;
//	// _xZkqqHx_iClBiCmMiKnGjAjEiCmMiOmAiNhDiCmJiCmNiOjOiKnEiCkKiCkJiCkJiCoJiBgJiCePiBeEiCfCjFgCiCkNiCoHiCkCiBgKiBeCiPfNiCmBiCmEiBeB_xHqqkZx_
//	// _xZkqqHx_jFlGiPjBiCmMjAnIiCoIjBnGiCkGiCmFiJlNjDhIiCoAiOmAiNhDiClHiCoJiCmGiBeBjAnIiCoIjBnGiCkGiCkKjChIiCkNiCmIiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	// _xZkqqHx_iIoKjDhIjAnNjCoIiClFiCmEiClFiCnMiCkGiCmOiBeBiDeBiDhGiDiKiCkKiPeJjHlJiClHiCoJiCnMiCmFjCgMiCkKjFmPiCoNiCoJiClBiCmGiCmN_xHqqkZx_
//	// _xZkqqHx_jGlDiCkCiCmMiCmFiBeB_xHqqkZx_static_xZkqqHx_iCmFiLeMiJkPiClFiCmEiBeBiInJiCmIiCoJjCgMiCkKjAnNjCoIiClDiCoKiCoJiCmGiCkLiCmMiCnN_xHqqkZx_
//	// _xZkqqHx_iOmAiNhDiClHiCoJiBeC_xHqqkZx_
//
//	static short s_dmOrientation = -1;
//	static CPoint s_ptPaperSize(-1, -1);
//	static WORD s_wPaperIdReccomended = WORD(-1);
//
//	if (s_dmOrientation == dmOrientation &&
//		s_ptPaperSize == ptPaperSize &&
//		s_wPaperIdReccomended == wPaperIdReccomended)
//		return TRUE;
//
//	s_dmOrientation = dmOrientation;
//	s_ptPaperSize = ptPaperSize;
//	s_wPaperIdReccomended = wPaperIdReccomended;
//----- 06.02.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	BOOL bIsSucceed = FALSE;
	PRINTDLG printDlg;
	if (GetPrinterDeviceDefaults(&printDlg) &&
		(printDlg.hDevNames != NULL && printDlg.hDevMode != NULL))
	//----- PRINTDLG_xZkqqHx_iCkKiOoGjDlOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// hDevNames_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		LPDEVNAMES lpDevNames = (LPDEVNAMES)::GlobalLock(printDlg.hDevNames);
		// hDevMode_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		LPDEVMODE lpDevMode = (LPDEVMODE)::GlobalLock(printDlg.hDevMode);
		WORD wPaperId;
		if (FFPaperSizeToId(wPaperId,
							FFGetDeviceName(lpDevNames),
							FFGetPortName(lpDevNames),
							ptPaperSize,
							wPaperIdReccomended))
		//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiGiDfEiDeDiDfJiCkJiCoHjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCkKiOoGiCoIiPgPiClJiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHhAiOiGiCmMiMpMiCkLiCpAjAnNjCoIiBeC_xHqqkZx_
			lpDevMode->dmOrientation = dmOrientation;
			// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			lpDevMode->dmPaperSize = wPaperId;
			lpDevMode->dmPaperLength = 0;
			lpDevMode->dmPaperWidth = 0;
			// _xZkqqHx_jAkMiMpHiCpAjAnNjCoIiBeC_xHqqkZx_
			bIsSucceed = TRUE;
		}
		// _xZkqqHx_iDiNiDgCiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
		::GlobalUnlock(printDlg.hDevNames);
		::GlobalUnlock(printDlg.hDevMode);
	}
	return bIsSucceed;
} // CFCMolipDrawApp::SetPrinterPaperSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhFjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::OutStream (FCUndoArchive& ar)
{
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMiPjBiCkLiPgPiClFiPiIjHjN_xHqqkZx_ -----
//	PRINTDLG printDlg;
//	if (GetPrinterDeviceDefaults(&printDlg))
//	//----- PRINTDLG_xZkqqHx_iCkKiOoGjDlOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		if (printDlg.hDevNames == NULL)
//		{
//			ar << WORD(0);
//		} else
//		{
//			// hDevNames_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//			WORD wLen = WORD(::GlobalSize(printDlg.hDevNames));
//			// hDevNames_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//			ar << wLen;
//			// hDevNames_xZkqqHx_iDeDiDiBiBfLiDfHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//			LPDEVNAMES lpDevNames = (LPDEVNAMES)::GlobalLock(printDlg.hDevNames);
//			ar.Write(lpDevNames, wLen);
//			::GlobalUnlock(printDlg.hDevNames);
//		}
//
//		if (printDlg.hDevMode == NULL)
//		{
//			ar << WORD(0);
//		} else
//		{
//			// hDevMode_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//			WORD wLen = WORD(::GlobalSize(printDlg.hDevMode));
//			// hDevMode_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//			ar << wLen;
//			// hDevMode_xZkqqHx_iDeDiDiBiBfLiDfHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//			LPDEVMODE lpDevMode = (LPDEVMODE)::GlobalLock(printDlg.hDevMode);
//			ar.Write(lpDevMode, wLen);
//			::GlobalUnlock(printDlg.hDevMode);
//		}
//	} else
//	//----- PRINTDLG_xZkqqHx_iCkKiOoGjDlOiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
//	{
//		ar << WORD(0);
//		ar << WORD(0);
//	}
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMiPjBiCkLiPgPiClFiPiIjHjN_xHqqkZx_ -----
	BOOL bIsSaved = FALSE;
	PRINTDLG printDlg;
	if (GetPrinterDeviceDefaults(&printDlg) &&
		(printDlg.hDevNames != NULL && printDlg.hDevMode != NULL))
	//----- PRINTDLG_xZkqqHx_iCkKiOoGjDlOiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// hDevNames_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
		WORD wDevNamesLen = WORD(::GlobalSize(printDlg.hDevNames));
		LPDEVNAMES lpDevNames = (LPDEVNAMES)::GlobalLock(printDlg.hDevNames);

		// hDevMode_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
		WORD wDevModeLen = WORD(::GlobalSize(printDlg.hDevMode));
		LPDEVMODE lpDevMode = (LPDEVMODE)::GlobalLock(printDlg.hDevMode);

		CPoint ptPaperSize;
		if (FFPaperIdToSize(ptPaperSize,
							FFGetDeviceName(lpDevNames),
							FFGetPortName(lpDevNames),
							lpDevMode->dmPaperSize))
		//----- _xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiKiDjDiDfOiCmMjHhAiOiG_xHqqkZx_ID_xZkqqHx_iCkJiCoHjHhAiOiGiDfEiDeDiDfJiCkKiOoGiCoIiPgPiClJiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
			ar << ptPaperSize;
			// hDevNames_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
			ar << wDevNamesLen;
			// hDevNames_xZkqqHx_iDeDiDiBiBfLiDfHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
			ar.Write(lpDevNames, wDevNamesLen);
			// hDevMode_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
			ar << wDevModeLen;
			// hDevMode_xZkqqHx_iDeDiDiBiBfLiDfHiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
			ar.Write(lpDevMode, wDevModeLen);
			// _xZkqqHx_jFnLjBlGiNmPiCnNiCpAjAnNjCoIiBeC_xHqqkZx_
			bIsSaved = TRUE;
		}
		::GlobalUnlock(printDlg.hDevNames);
		::GlobalUnlock(printDlg.hDevMode);
	}
	if (!bIsSaved)
	//----- _xZkqqHx_jGkCjFnLjBlGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		ar << CPoint(0, 0);
		ar << WORD(0);
		ar << WORD(0);
	}
//----- 05.05.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMolipDrawApp::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCpBiCmFiBeBjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhFjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::InStream (FCUndoArchive& ar)
{
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMjDmHiCnNiNjOiCnNiPiIjHjN_xHqqkZx_ -----

	// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	CPoint ptPaperSize;
	ar >> ptPaperSize;

	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	WORD wDevNamesSz;
	ar >> wDevNamesSz;
	if (wDevNamesSz == 0)
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiDfIiDeMiDgCiDhGiClFiCmEiPeJjHlJiBeC_xHqqkZx_
		ar >> wDevNamesSz;
		return;
	}
	HANDLE hDevNames = ::GlobalAlloc(GHND, wDevNamesSz);
	LPDEVNAMES lpDevNames = (LPDEVNAMES)::GlobalLock(hDevNames);
	ar.Read(lpDevNames, wDevNamesSz);
	// _xZkqqHx_jHmMiIoGiCmMiDiNiDgCiDeOiCpAiKeKjFpKiBeC_xHqqkZx_
	::GlobalUnlock(hDevNames);

	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	WORD wDevModeSz;
	ar >> wDevModeSz;
	HANDLE hDevMode = ::GlobalAlloc(GHND, wDevModeSz);
	LPDEVMODE lpDevMode = (LPDEVMODE)::GlobalLock(hDevMode);
	ar.Read(lpDevMode, wDevModeSz);
	// _xZkqqHx_jHhAiOiGiCmMiMpMiCkLiCpAiLeMjIfOiBeC_xHqqkZx_
	short dmOrientation = lpDevMode->dmOrientation;
	// _xZkqqHx_jHhAiOiG_xHqqkZx_ID_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	WORD dmPaperSize = lpDevMode->dmPaperSize;
	// _xZkqqHx_jHmMiIoGiCmMiDiNiDgCiDeOiCpAiKeKjFpKiBeC_xHqqkZx_
	::GlobalUnlock(hDevMode);
	// _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	SelectPrinter(hDevNames, hDevMode);

	// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjAnNjCoIiCpAiOiOiCnNiCoJiBeC_xHqqkZx_ptPaperSize=(0,0)_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_
	// _xZkqqHx_iPiIjHjNiClFiCmIiCkCiBgJ_xHqqkZx_DynamicDraw3.0_xZkqqHx_iCmMiDhEiDeAiDeDiDiLiCpAjFmPiKlHiClFiClNiPoKiNiHiCmIiCmHiBeB_xHqqkZx_
	// ptPaperSize=(0,0)_xZkqqHx_iCmGiCmIiCoJiClBiCmGiCkKiCkAiCoJiBgKiBeC_xHqqkZx_
	if (ptPaperSize != CPoint(0,0) &&
		!SetPrinterPaperSize(dmOrientation, ptPaperSize, dmPaperSize))
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOjHhAiOiGiDfEiDeDiDfJiCkKjAnNjCoIiCmFiCkLiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFfHiPiAiDhGiDiKiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
		SelectPrinter(NULL, NULL);
		// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJjAnNjCoIiCpAiOiOiCnNiCoJiBeC_xHqqkZx_
		SetPrinterPaperSize(dmOrientation, ptPaperSize, dmPaperSize);
	}
} // CFCMolipDrawApp::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::SkipStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBjDjJiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCpBiCmFiBeBjAnNjCoIiClJiClIiCmJjEgKiKpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhFjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.11.28 Fukushiro M. InStreamSub -> SkipStream.
 *************************************************************************/
void CFCMolipDrawApp::SkipStream (FCUndoArchive& ar)
{
//----- 05.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMjDmHiCnNiNjOiCnNiPiIjHjN_xHqqkZx_ -----
//	HANDLE hDevNames = NULL;
//	HANDLE hDevMode = NULL;
//
//	WORD wDevNamesSz;
//	ar >> wDevNamesSz;
//	if (wDevNamesSz != 0)
//	{
//		hDevNames = ::GlobalAlloc(GHND, wDevNamesSz);
//		LPDEVNAMES lpDevNames = (LPDEVNAMES)::GlobalLock(hDevNames);
//		ar.Read(lpDevNames, wDevNamesSz);
//		::GlobalUnlock(hDevNames);
//		::GlobalFree(hDevNames);
//	}
//	WORD wDevModeSz;
//	ar >> wDevModeSz;
//	if (wDevModeSz != 0)
//	{
//		hDevMode = ::GlobalAlloc(GHND, wDevModeSz);
//		LPDEVMODE lpDevMode = (LPDEVMODE)::GlobalLock(hDevMode);
//		ar.Read(lpDevMode, wDevModeSz);
//		::GlobalUnlock(hDevMode);
//		::GlobalFree(hDevMode);
//	}
//----- 05.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMjDmHiCnNiNjOiCnNiPiIjHjN_xHqqkZx_ -----
	// _xZkqqHx_jHhAiOiGiDfEiDeDiDfJiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
	ar.Skip(sizeof(CPoint));
	WORD wDevNamesSz;
	ar >> wDevNamesSz;
	ar.Skip(wDevNamesSz);
	WORD wDevModeSz;
	ar >> wDevModeSz;
	ar.Skip(wDevModeSz);
//----- 05.05.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMolipDrawApp::SkipStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetProfileStringW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetProfileString_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCMolipDrawApp::GetProfileStringW (const wchar_t* lpszSection,
											const wchar_t* lpszEntry,
											const wchar_t* lpszDefault)
{
	return TStrToWStr(GetProfileString(WStrToTStr(lpszSection),
										WStrToTStr(lpszEntry),
										WStrToTStr(lpszDefault)));
} // CFCMolipDrawApp::GetProfileStringW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetProfileIntW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetProfileInt_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
UINT CFCMolipDrawApp::GetProfileIntW (const wchar_t* lpszSection,
									const wchar_t* lpszEntry, int nDefault)
{
	return GetProfileInt(WStrToTStr(lpszSection), WStrToTStr(lpszEntry), nDefault);
} // CFCMolipDrawApp::GetProfileIntW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::WriteProfileIntW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WriteProfileInt_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::WriteProfileIntW (const wchar_t* lpszSection,
									const wchar_t* lpszEntry, int nValue)
{
	return WriteProfileInt(WStrToTStr(lpszSection), WStrToTStr(lpszEntry), nValue);
} // CFCMolipDrawApp::WriteProfileIntW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::WriteProfileStringW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WriteProfileString_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::WriteProfileStringW (const wchar_t* lpszSection,
										const wchar_t* lpszEntry,
										const wchar_t* lpszValue)
{
	return WriteProfileString(WStrToTStr(lpszSection), WStrToTStr(lpszEntry),
								WStrToTStr(lpszValue));
} // CFCMolipDrawApp::WriteProfileStringW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetProfileBinaryW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GetProfileBinary_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::GetProfileBinaryW (	const wchar_t* lpszSection,
											const wchar_t* lpszEntry,
											LPBYTE* ppData,
											UINT* pBytes)
{
	return GetProfileBinary(WStrToTStr(lpszSection),
							WStrToTStr(lpszEntry),
							ppData,
							pBytes);
} // CFCMolipDrawApp::GetProfileBinaryW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::WriteProfileBinaryW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	WriteProfileBinary_xZkqqHx_iKnGjAjEiCmM_xHqqkZx_UNICODE_xZkqqHx_jEmFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::WriteProfileBinaryW (	const wchar_t* lpszSection,
											const wchar_t* lpszEntry,
											LPBYTE pData,
											UINT nBytes)
{
	return WriteProfileBinary(	WStrToTStr(lpszSection),
								WStrToTStr(lpszEntry),
								pData,
								nBytes);
} // CFCMolipDrawApp::WriteProfileBinaryW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetPopHint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCPursuerText* CFCMolipDrawApp::GetPopHint ()
{
	return m_pPopHint;
} // CFCMolipDrawApp::GetPopHint.

//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::RegisterPopHintTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmMiDfOiBfLiDfBiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::RegisterPopHintTarget (HWND hwnd)
{
	GetPopHint()->RegisterPopHintTarget(hwnd);
} // CFCMolipDrawApp::RegisterPopHintTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::UnregisterPopHintTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmMiDfOiBfLiDfBiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCpAiJpAiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::UnregisterPopHintTarget (HWND hwnd)
{
	GetPopHint()->UnregisterPopHintTarget(hwnd);
} // CFCMolipDrawApp::UnregisterPopHintTarget.
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetUserId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFiOkPjFmKjHhAiCmM_xHqqkZx_GUID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	GUID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCRegData::GetIsInhibitSetId_xZkqqHx_iCmMjCgMiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
 *			FCRegData::GetUserId_xZkqqHx_iCkJ_xHqqkZx_GUID_NULL_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
GUID CFCMolipDrawApp::GetUserId () const
{
	if (g_pReg->GetIsInhibitSetId())
		return GUID_NULL;
	else
		return g_pReg->GetUserId();
} // CFCMolipDrawApp::GetUserId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetUserName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiBfLiDfFjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCRegData::GetIsInhibitSetId_xZkqqHx_iCmMjCgMiCpAiNgMjHlGiClFiCmEiBeB_xHqqkZx_
 *			FCRegData::GetUserName_xZkqqHx_iCkJ_xHqqkZx_L""_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCMolipDrawApp::GetUserName () const
{
	if (g_pReg->GetIsInhibitSetId())
// 06.04.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		return WString();
		return FFLoadWString(IDS_GUEST);
	else
		return WString(g_pReg->GetUserName());
} // CFCMolipDrawApp::GetUserName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::AddOnIdleWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OnIdle_xZkqqHx_iOjOiCmJiDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoJiDeFiDeCiDjDiDgIiDeFiCmMiDiKiDfIiDgHiCmJjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmJiCmN_xHqqkZx_WM_USER_ON_IDLE _xZkqqHx_iCkKjBjHjFhEiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::AddOnIdleWindow (HWND hwnd)
{
	// OnIdle_xZkqqHx_iOjOiCmJjCmKjCgNiCpAiOpDiCkPiOoGiCoJiDeFiDeCiDjDiDgIiDeFiDiKiDfIiDgHiBeC_xHqqkZx_
	m_stOnIdleWindow.insert(hwnd);
} // CFCMolipDrawApp::AddOnIdleWindow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::DelOnIdleWindow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	AddOnIdleWindow_xZkqqHx_iCmFjDgPjIfOiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCpAjDgPjIfOiCkJiCoHjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hwnd	:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::DelOnIdleWindow (HWND hwnd)
{
	// OnIdle_xZkqqHx_iOjOiCmJjCmKjCgNiCpAiOpDiCkPiOoGiCoJiDeFiDeCiDjDiDgIiDeFiDiKiDfIiDgHiBeC_xHqqkZx_
	m_stOnIdleWindow.erase(hwnd);
} // CFCMolipDrawApp::DelOnIdleWindow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetPophintText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCmJjBmOiJjOiClHiCoJiDhMiDgCiDhGiDhBiDjDiDgHiCmMiDgFiDeMiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCommandId	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiDgFiDeMiDfIiDgHiBeCjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiLpDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCMolipDrawApp::GetPophintText (DWORD dwCommandId) const
{
	map<DWORD, WString>::const_iterator i;
	i = m_mpCommandToPophintText.find(dwCommandId);
	if (i == m_mpCommandToPophintText.end())
		return L"";
	else
		return (*i).second;
} // CFCMolipDrawApp::GetPophintText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::IsValidHelpId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCkKiDeJiDjDiDiJiDeDiDjDiDhHiDiLiDhGiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCommandId	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::IsValidHelpId (DWORD dwCommandId) const
{
	// _xZkqqHx_jHeMiMpIiCmIiDhHiDiLiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	return (m_stValidHelpId.find(dwCommandId) != m_stValidHelpId.end());
} // CFCMolipDrawApp::IsValidHelpId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetMovieIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDfCiDhNiDjDiDgIiCmJjBmOiJjOiClHiCoJiDhHiDiLiDhGiDiAiBfLiDhCiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwCommandId	:_xZkqqHx_iDfCiDhNiDjDiDgIiCgIiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::GetMovieIndex (longSet& stIndex, DWORD dwCommandId) const
{
	stIndex.clear();
	map<DWORD, longSet>::const_iterator i;
	i = m_mpCommandToMovieIndex.find(dwCommandId);
	if (i != m_mpCommandToMovieIndex.end())
		stIndex = (*i).second;
} // CFCMolipDrawApp::GetMovieIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetMovieFileName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhHiDiLiDhGiDiAiBfLiDhCiBfLiCmMiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDhHiDiLiDhGiDiAiBfLiDhCiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCMolipDrawApp::GetMovieFileName (long lIndex) const
{
	if (m_vHelpMovieFile.size() <= lIndex) return L"";
	return m_vHelpMovieFile[lIndex].first;
} // CFCMolipDrawApp::GetMovieFileName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetMovieTitle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDhHiDiLiDhGiDiAiBfLiDhCiBfLiCmMiDfOiDeDiDgHiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDhHiDiLiDhGiDiAiBfLiDhCiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDgHiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString CFCMolipDrawApp::GetMovieTitle (long lIndex) const
{
	if (m_vHelpMovieFile.size() <= lIndex) return L"";
	return m_vHelpMovieFile[lIndex].second;
} // CFCMolipDrawApp::GetMovieTitle.

//----- 05.11.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::PreDestroyWindow
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFrameWnd::DestroyWindow _xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::PreDestroyWindow ()
//{
//	//----- _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmJiDiBiDgCiDfKiBfLiDfHjBjHjFhE_xHqqkZx_ -----
//	// _xZkqqHx_iClBiCmMiDiBiDgCiDfKiBfLiDfHiCmFiBeBiDeFiDeCiDjDiDgIiDeFiPoOjFpBiCpAiDiMiDfHiDfIiDgHiDiKiCmJjFnLjBlGiClHiCoJiBeC_xHqqkZx_
//	set<HWND>::const_iterator iHwn;
//	for (iHwn = m_stOnIdleWindow.begin(); iHwn != m_stOnIdleWindow.end(); iHwn++)
//		::SendMessage(*iHwn, WM_USER_PRE_DWSTROY_WINDOW, 0, 0);
//} // CFCMolipDrawApp::PreDestroyWindow.
//----- 05.11.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.08.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::AppWinExit
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClHiCnHiCmEiCmM_xHqqkZx_DD_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCMolipDrawApp_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCkKiNoNiPjMiClDiCoKiCmEiCoAjGoCjBoIiCmIiCkCiCoGiCkEiBeB_xHqqkZx_
// *			static_xZkqqHx_iKnGjAjEiCmJiClFiClNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.08.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::AppWinExit ()
//{
//	static BOOL s_bIsHere = FALSE;
//	if (s_bIsHere) return;
//	s_bIsHere = TRUE;
//
//	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFfMiOkGjCiGiCmIiCmHiBeBiDhEiDiMiBfLiDiAiCkK_xHqqkZx_
//	// Enable_xZkqqHx_iCmFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_WC_CLOSE_xZkqqHx_iCpAjBjHiCoHiCmIiCkCiBeC_xHqqkZx_
//	if (!FFGetMainWnd()->GetWnd()->IsWindowEnabled())
//	{
//		s_bIsHere = FALSE;
//		return;
//	}
//
//	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFjHpBiLjDiBeC_xHqqkZx_WM_CLOSE _xZkqqHx_jBePiCmJiNhDiCoNiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	FCWinTitleRecVector vWinTtl;
//	::EnumWinTitle(vWinTtl);
//
////----- 05.08.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iDiBiDeDiDjDiDhEiDiMiBfLiDiAiCmJiPeJjHlJiPiIjHjNiCpAjBjHjAeNiBeCiDfPiDeDiDeBiDiNiDePjFfMiOkGjCiGiCmIiCmHiBeBiDhEiDiMiBfLiDiAiCkK_xHqqkZx_
////	// Enable_xZkqqHx_iCmFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_WC_CLOSE_xZkqqHx_iCpAjBjHiCoHiCmIiCkCiBeC_xHqqkZx_
////	if (AfxGetMainWnd()->IsWindowEnabled())
////		AfxGetMainWnd()->SendMessage(WM_CLOSE);
////	// _xZkqqHx_iPeJjHlJiPiIjHjNiCkKiOlIjEhDiClFiClNiPoKiNiHiCmNiClBiClBiCmFiPiIjHjNiCpAiPeJiCoNiCoJiBeC_xHqqkZx_
////	if (::IsWindow(AfxGetMainWnd()->GetSafeHwnd())) return;
////----- 05.08.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//
//	FFGetMainWnd()->PostMessage(WM_CLOSE);
//	for (;;)
//	{
//		if (FFGetMainWnd()->GetWnd() == NULL) break;
//		if (!::IsWindow(FFGetMainWnd()->GetSafeHwnd())) break;
//		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
//		MSG msg;
//		if (::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
//		{
//			::TranslateMessage(&msg);
//			::DispatchMessage(&msg);
//		}
//	}
//
//
//
//
//
//
//	// _xZkqqHx_iPeJjHlJiPiIjHjNiCkKiOlIjEhDiClFiClNiPoKiNiHiCmNiClBiClBiCmFiPiIjHjNiCpAiPeJiCoNiCoJiBeC_xHqqkZx_
//	if (::IsWindow(AfxGetMainWnd()->GetSafeHwnd())) return;
//
//
//
//
//
//
////----- 05.08.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//
//	FCWinTitleRecVector::iterator iWin;
//	for (iWin = vWinTtl.begin(); iWin != vWinTtl.end(); iWin++)
//	{
//		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCkKjGlDiMpIiCmIiCoHiCmOiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
//		if (!::IsWindow((*iWin).hwndApp)) continue;
//
//		// _xZkqqHx_jAnIiCoIjBnGiCkGjAoGiCkKiDeBiDeDiDfCiDjDiJlLiClDiCoKiCmEiCkCiClNiCoHiBeBiMlDiCmMiDfEiDeDiDfJiCmJjGnPiClHiBeC_xHqqkZx_
//		if (::GetWindowLong((*iWin).hwndApp, GWL_STYLE) & WS_MINIMIZE)
//			(void)::ShowWindow((*iWin).hwndApp, SW_RESTORE);
//		// _xZkqqHx_iDhEiDeIiDeBiDePiDiJiDjDiDgIiDeFiDeCiDjDiDgIiDeFiCpAjAnIiCoIjBnGiCkGiBeC_xHqqkZx_
//		(void)::SetForegroundWindow((*iWin).hwndApp);
//		// ID_APP_WIN_EXIT_xZkqqHx_iCpAjBjHjAeNiBeC_xHqqkZx_
//		::PostMessage((*iWin).hwndApp, WM_COMMAND, ID_APP_WIN_EXIT, 0);
//		break;
//	}
//} // CFCMolipDrawApp::AppWinExit.
//----- 05.08.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.09.23 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetSpecTemplate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	exe_xZkqqHx_iLeOjDkOiOjOiCmJjAnNjCoIiClDiCoKiClNiDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Document::OnNewDocument _xZkqqHx_iCmFjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const wchar_t* CFCMolipDrawApp::GetSpecTemplate () const
//{
//	return m_strSpecTemplate;	// _xZkqqHx_iLeOjDkOiOjOiCmJiDgFiDjDiDhGiDiMiBfLiDgHiOhHjCoIiCmMiPoKiNiHiCmMiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
////	return m_cmdInfo.m_strTemplatePath;
//} // CFCMolipDrawApp::GetSpecTemplate.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::SetSpecTemplate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	exe_xZkqqHx_iLeOjDkOiOjOiCmJjDmHiCnNiNjOiCnOiCnHiCkLiDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTemplate	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Document::OnNewDocument _xZkqqHx_iCmFjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::SetSpecTemplate (const wchar_t* wcpTemplate)
//{
//	m_strSpecTemplate = wcpTemplate;
//} // CFCMolipDrawApp::SetSpecTemplate.
//----- 03.09.23 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 02.09.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::GetCmdInfo
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLeOjDkOiOjOiCmMiDfCiDhNiDjDiDgIiDiJiDeDiDjDiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLeOjDkOiOjOiCmMiDfCiDhNiDjDiDgIiDiJiDeDiDjDiPoOjFpBiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const CFCCommandLineInfo* CFCMolipDrawApp::GetCmdInfo () const
//{
//	return &m_cmdInfo;
//} // CFCMolipDrawApp::GetCmdInfo.
//----- 02.09.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 02.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (<mdrwpos >_xZkqqHx_iCmFiKpJiCmJiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_DD3_xZkqqHx_jFlGiPjBiCpAiOhHjCoIiClFiCmEiCoAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::CheckSameDocumentApp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJjDkPiClGiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjBlGiNnNiClHiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iDgAiDeGiDgCiDeOiClFiCmEiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmNjDeLjAnIiCmIiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cmdInfo	:_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGjFlGiPjBiDeBiDhGiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL CFCMolipDrawApp::CheckSameDocumentApp (const CFCCommandLineInfo& cmdInfo)
////BOOL CFCMolipDrawApp::CheckSameDocumentApp ()
//----- 02.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (<mdrwpos >_xZkqqHx_iCmFiKpJiCmJiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_DD3_xZkqqHx_jFlGiPjBiCpAiOhHjCoIiClFiCmEiCoAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_)-----
//----- 03.09.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::CheckSameDocumentApp
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJjDkPiClGiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjBlGiNnNiClHiCoJiCkJ_xHqqkZx_
// *			_xZkqqHx_iDgAiDeGiDgCiDeOiClFiCmEiBeBjBlGiNnNiClHiCoJiPoKiNiHiCmNiClLiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDocRequest	:_xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGjFlGiPjBiDeBiDhGiDiKiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_ DD3_xZkqqHx_iCmMiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeCjBlGiNnNiClFiCmIiCkC_xHqqkZx_
// *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *			02.10.03 Fukushiro M. _xZkqqHx_jFmPiNfI_xHqqkZx_
// *			03.09.23 Fukushiro M. _xZkqqHx_jFmPiNfI_xHqqkZx_
// *************************************************************************/
//HWND CFCMolipDrawApp::CheckSameDocumentApp (const FCReqBaseAutoVector& vDocRequest)
////----- 02.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (<mdrwpos >_xZkqqHx_iCmFiKpJiCmJiKeKiCkCiCmEiCkCiCoJ_xHqqkZx_DD3_xZkqqHx_jFlGiPjBiCpAiOhHjCoIiClFiCmEiCoAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_)-----
//{
//	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCkJiCoHiBeBjFlGiPjBiDhEiDeAiDeDiDiLiDhAiDfIiBeB_xHqqkZx_
//	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDeAiDeDiDiLiDhAiDfIiBeBjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	WString wstrDocumentPath;
//	WString wstrProjectPath;
//	long lHidocumentId = -1;
//	FCReqBaseAutoVector::const_iterator iRb;
//	for (iRb = vDocRequest.begin(); iRb != vDocRequest.end(); iRb++)
//	{
//		switch ((*iRb)->m_drqRequest)
//		{
//		case ID_DREQ_OPEN_DOCUMENT:
//			if (!(*iRb)->IsNullDocumentPath())
//				wstrDocumentPath = (*iRb)->GetDocumentPath();
//			break;
//		case ID_DREQ_OPEN_PROJECT:
//			if (!(*iRb)->IsNullProjectPath())
//				wstrProjectPath = (*iRb)->GetProjectPath();
//			break;
//		case ID_DREQ_OPEN_HIDOCUMENT:
//			if (!(*iRb)->IsNullHidocumentId())
//				lHidocumentId = (*iRb)->GetHidocumentId();
//			break;
//		}
//	}
//
//	HWND hwndTarget = NULL;
//	// _xZkqqHx_iLeOjDkOiMlDiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
//	HWND hwndFrom = (AfxGetMainWnd() != NULL) ? AfxGetMainWnd()->GetSafeHwnd() : NULL;
//	switch (g_->appMode & FD_APPMODE_MASK)
//	{
//	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
//		if (!wstrDocumentPath.IsEmpty())
//		{
//			// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
//			hwndTarget = FFFindDdDocumentWindow(wstrDocumentPath, hwndFrom);
//		}
//		break;
//	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
//		if (!wstrProjectPath.IsEmpty())
//		{
//			// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
//			hwndTarget = FFFindHidocumentWindow(wstrProjectPath, lHidocumentId, hwndFrom);
//		}
//		break;
//	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
//		if (!wstrProjectPath.IsEmpty())
//		{
//			// _xZkqqHx_jDkPiClGjFlGiPjBiDhEiDeAiDeDiDiLjGlMiCmMiDeFiDeCiDjDiDgIiDeFiCpAjCfEiClHiBeC_xHqqkZx_
//			hwndTarget = FFFindHidocumentWindow(wstrProjectPath, lHidocumentId, hwndFrom);
//		}
//		break;
//	}
//	return hwndTarget;
//
//#ifndef _DEBUG
//		FCSheetCanvasPos* pSCPos = FCSheetCanvasPos::Allocate
//		WM_USER_SET_SHEET_AND_CENTER_L
//_xZkqqHx_jDjJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
//#endif//_DEBUG
//
//} // CFCMolipDrawApp::CheckSameDocumentApp.
//----- 03.09.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCMolipDrawApp _xZkqqHx_iDeOiDiJiDfIiCmMiPiJiKpKiJlL_xHqqkZx_

//----- 04.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myErrorThrow
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	HistoricProject.dll_xZkqqHx_jCiGiCmFiDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiOjOiCmJiBeBiClBiCmMiKnGjAjEiCkK_xHqqkZx_
// *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeCiDeHiDiJiBfLiCpA_xHqqkZx_throw_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iErrNo		:_xZkqqHx_iDeHiDiJiBfLjEnEiNiGiCpAiOhHjCoIiBeC_xHqqkZx__open_xZkqqHx_jDjJiCmFjEkNjAlGiClHiCoJiDeHiDiJiBfLjFmPjAjE_xHqqkZx_
// *						 errno _xZkqqHx_iCmMjCgMiCpAiOhHjCoIiClHiCoJiBeCjCgMiCmMiOhHjCoIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			nErrType	:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeCjCgMiCmMiOhHjCoIiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_
// *						 HPE_ERR_FILE_NONE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			wcpFilePath	:_xZkqqHx_iDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeCiDhEiDeAiDeDiDiLjFhDjGlOiCmM_xHqqkZx_
// *						 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *			lLineNumb	:_xZkqqHx_iDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiNhDjEnEiNiGiCpAiOhHjCoIiBeCjFhDjGlOiCmMiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static void myErrorThrow (int iErrNo, HPTFileErrType nErrType, const wchar_t* wcpFilePath, long lLineNumb)
//{
//	if (wcpFilePath == NULL) wcpFilePath = L"";
//	if (iErrNo != 0)
//	{
//		throw new CFCDDFileException(CFCDDFileException::ErrnoToErrType(iErrNo), wcpFilePath);
//	}
//	if (nErrType != HPE_ERR_FILE_NONE)
//	{
////----- 04.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		wchar_t wcsMsg[HPD_ERR_MAX_STRING];
////		HPCFileException::ErrTypeToMessage(wcsMsg, nErrType);
////		WString wstrMsg;
////		wstrMsg.Format(L"%s:%s:%d", wcsMsg, wcpFilePath, lLineNumb);
////----- 04.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		HPWString wstrErr;
//		HPCFileException::ErrTypeToMessage(wstrErr, nErrType);
//		WString wstrMsg;
//		wstrMsg.Format(L"%s:%s:%d", wstrErr.c_str(), wcpFilePath, lLineNumb);
////----- 04.09.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		// _xZkqqHx_jHjKjHpAiKmHjHjNiDhGiDiNiDfHiDeGiDeOiDgHiDiJiDeDiDhFiDiJiDiKiCmMiDeHiDiJiBfL_xHqqkZx_:%s
//		throw new CFCMiscException(IDS_ERR_MISC_HISTORIC_PROJECT_LIB, wstrMsg.c_str());
//	}
//} // myErrorThrow.
//----- 04.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.01.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myErrorThrow
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	HistoricProject.dll_xZkqqHx_jCiGiCmFiDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiOjOiCmJiBeBiClBiCmMiKnGjAjEiCkK_xHqqkZx_
// *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeCiDeHiDiJiBfLiCpA_xHqqkZx_throw_xZkqqHx_iClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwErrCode	:_xZkqqHx_iDeHiDiJiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_HistoricProject_xZkqqHx_iCmMiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *			wcpFilePath	:_xZkqqHx_iDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeCiDhEiDeAiDeDiDiLjFhDjGlOiCmM_xHqqkZx_
// *						 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
// *			lLineNumb	:_xZkqqHx_iDeHiDiJiBfLiCkKjEkNjAlGiClFiClNiNhDjEnEiNiGiCpAiOhHjCoIiBeCjFhDjGlOiCmMiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static void myErrorThrow (const HPCFileException& exception)
//{
//	HPWString wstrErr;
//	exception.GetErrorMessage(wstrErr);
//	// _xZkqqHx_jHjKjHpAiKmHjHjNiDhGiDiNiDfHiDeGiDeOiDgHiDiJiDeDiDhFiDiJiDiKiCmMiDeHiDiJiBfL_xHqqkZx_:%s
//	throw new CFCMiscException(IDS_ERR_MISC_HISTORIC_PROJECT_LIB, wstrErr.c_str());
//} // myErrorThrow.
//----- 06.01.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 04.10.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 02.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myUnlockProjectCallback
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDiNiDgCiDeOjBfDiJpAiPjMiCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwData	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCmNiBeBjBlMiDeBiDhGiDiKiCkJiCoHiDiNiDgCiDeOiJpAiPjMiCmMjHhGiLiBiCkKiCkAiCmBiClNiPoKiNiHiCmJ_xHqqkZx_
// *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeCiDfCiBfLiDiLiDgPiDgCiDeOiCmNiDhNiDiLiDgAiDfIiDiMiDgCiDgIiCmFiOmAiNhDiClDiCoKiCoJiCmMiCmFiBeB_xHqqkZx_
// *			PostMessage_xZkqqHx_iCpAiOgHiCkEiBeCiMiLiJmKiCpAjBkGjDjKiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.03.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static void myUnlockProjectCallback (DWORD dwData)
//{
//	AfxGetMainWnd()->PostMessage(WM_USER_ACTIVATE_DOCUMENT, 0, LPARAM(FALSE));
//} // myUnlockProjectCallback (DWORD dwData).
//----- 02.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//CMemoryState msOld;

struct myHashFactory
{
	inline static char* Invalid () { return NULL; }
	inline static void Delete (char* v) { free(v); }
	inline static char* New (const char* v) { return _strdup(v); }
};

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::InitInstance
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMjAfGiClFiCkCiDeDiDjDiDfIiDfOiDjDiDfIiCpAiPiJiKpKiJlLiClHiCoJiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiClDiCoKiClNiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiCpAjFnEiClHiBeCiClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::InitInstance ()
{
#if 0
//	msOld.Checkpoint();
	AfxDebugBreak();
	FCFile32 fff(	L"c:\\tmp\\abc",
				FILE_LIST_DIRECTORY,
				FILE_SHARE_READ|FILE_SHARE_DELETE,
				OPEN_EXISTING);


	HANDLE hFile = ::CreateFile("c:\\tmp\\abc",
								FILE_LIST_DIRECTORY,                // _xZkqqHx_iDeBiDeOiDfKiDfIiBgJ_xHqqkZx_ _xZkqqHx_jDmHiCnNiPjBiCkLiBgKiDiCiBfLiDgI_xHqqkZx_
								FILE_SHARE_READ|FILE_SHARE_DELETE,  // _xZkqqHx_iLkEjHeMiDiCiBfLiDgI_xHqqkZx_
								NULL,                               // _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiLeMiPhBiOhB_xHqqkZx_
								OPEN_EXISTING,                      // _xZkqqHx_iNoMjAkMjFpLjGeA_xHqqkZx_
								FILE_FLAG_BACKUP_SEMANTICS,         // _xZkqqHx_iDhEiDeAiDeDiDiLjBkOjAkL_xHqqkZx_
								NULL);                              // _xZkqqHx_iDfCiDhDiBfLiClHiCoJiDhEiDeAiDeDiDiLiCmGjBkOjAkL_xHqqkZx_
	if (hFile == INVALID_HANDLE_VALUE) return FALSE;
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FDTIME fdtm1;
//	FDTIME fdtm2;
//	FDTIME fdtm3;
//	fff.GetFileTime(&fdtm1, &fdtm2, &fdtm3);
//
//	CString str1 = COleDateTime(FdtimeToFiletime(fdtm1)).Format(FFLoadString(IDS_FORM_DATE_TIME));
//	CString str2 = COleDateTime(FdtimeToFiletime(fdtm2)).Format(FFLoadString(IDS_FORM_DATE_TIME));
//	CString str3 = COleDateTime(FdtimeToFiletime(fdtm3)).Format(FFLoadString(IDS_FORM_DATE_TIME));
//
//	fff.Close();
//----- 06.01.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
#endif//0

//----- 05.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	{
//		FCSimpleHash<DWORD, char*, myHashFactory> myhash;
//		myhash.Set(10, myHashFactory::New("Hello"));
//		myhash.Set(3, myHashFactory::New("World"));
//		const char* cpHello = myhash.Get(10);
//		const char* cpWorld = myhash.Get(3);
//		const char* cpNon = myhash.Get(13);
//		DWORD dwId1; myhash.GetFreeId(dwId1);
//		myhash.Set(dwId1, myHashFactory::New("Allold1"));
//		DWORD dwId2; myhash.GetFreeId(dwId2);
//		myhash.Set(dwId2, myHashFactory::New("Allold2"));
//		DWORD dwId3; myhash.GetFreeId(dwId3);
//		myhash.Set(dwId3, myHashFactory::New("Allold3"));
//		DWORD dwId4; myhash.GetFreeId(dwId4);
//		myhash.Set(dwId4, myHashFactory::New("Allold4"));
//		const char* cpHello1 = myhash.Get(dwId1);
//		const char* cpHello2 = myhash.Get(dwId2);
//		const char* cpHello3 = myhash.Get(dwId3);
//		const char* cpHello4 = myhash.Get(dwId4);
//
//		FCSimpleHash<DWORD, long> hash;
//		for (long lC = 0; lC != 5000; lC++)
//		{
//			hash.Set(lC * 10, lC);
//		}
//		for (lC = 0; lC != 5000; lC+= 10)
//		{
//			TRACE(_T("%d %d\n"), lC, hash.Get(lC * 10));
//		}
//	}
//----- 05.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.05.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	vector<long> a;
//	set<long> b;
//	map<long, long> c;
//	wstring d;
//	auto_ptr<char> e;
//
//	a.push_back(100);
//	b.insert(100);
//	c[100] = 200;
//
//	vector<long>::iterator ar = a.begin();
//	set<long>::iterator br = b.begin();
//	map<long, long>::iterator cr = c.begin();
//
//
//	int ia = sizeof(a);
//	int ib = sizeof(b);
//	int ic = sizeof(c);
//	int id = sizeof(d);
//	int ie = sizeof(e);
//
//	int iar = sizeof(ar);
//	int ibr = sizeof(br);
//	int icr = sizeof(cr);
//
//	vector<long>::reverse_iterator arr;
//	set<long>::reverse_iterator brr;
//	map<long, long>::reverse_iterator crr;
//	int iarr = sizeof(arr);
//	int ibrr = sizeof(brr);
//	int icrr = sizeof(crr);
//
//	int ccc = sizeof(allocator<long>);
//
//	struct mm {};
//	int mmm = sizeof(mm);
//	struct nn {
//		mm a;
//		mm b;
//		mm c;
//	};
//	int nnn = sizeof(nn);
//
//	struct SSS {
//		void* _Ptr;
//	};
//
//	SSS* v = (SSS*)&br;
//
//----- 05.05.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	AfxDebugBreak();

//----- 05.12.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	WString wstrA = L"AAA";
//	WString wstrB = wstrA;
//
//	const wstring wstrC = L"AAAA";
//	const wchar_t* wcpx = wstrC.c_str();
//	wstring wstrD = wcpx;
//----- 05.12.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 03.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//MolipDraw.exe -histdraw -dreq:"[REQ_CREATE_PROJECT] [REQ_OPEN_PROJECT] [REQ_CREATE_HIDOCUMENT] [REQ_OPEN_HIDOCUMENT]"
//MolipDraw.exe -histdraw -dreq:"[REQ_OPEN_HIDOCUMENT] [VAL_HIDOCUMENT_ID] [1]"
//----- 03.09.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 05.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	MEMORYSTATUS stat;
//	GlobalMemoryStatus(&stat);
//
//	__int64 i64FreeBytesAvailable;		// _xZkqqHx_iMmEiCnBiPgPiClFjBkEiCkKjHjIjHhAiCmFiCkLiCoJiDgPiDeDiDgHjAjE_xHqqkZx_
//	__int64 i64TotalNumberOfBytes;		// _xZkqqHx_iDgGiDeCiDfIiDeOjBfDjBmMiCmMiDgPiDeDiDgHjAjE_xHqqkZx_
//	BOOL fResult = GetDiskFreeSpaceEx(_T("C:\\"),
//						(PULARGE_INTEGER)&i64FreeBytesAvailable,    // _xZkqqHx_iMmEiCnBiPgPiClFjBkEiCkKjHjIjHhAiCmFiCkLiCoJiDgPiDeDiDgHjAjE_xHqqkZx_
//						(PULARGE_INTEGER)&i64TotalNumberOfBytes,    // _xZkqqHx_iDgGiDeCiDfIiDeOjBfDjBmMiCmMiDgPiDeDiDgHjAjE_xHqqkZx_
//						NULL);
//----- 05.08.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// _xZkqqHx_iDgFiDfIiDgHiBeC_xHqqkZx_
//AfxDebugBreak();
//WORD w1 = CharSetToCodePage(0);
//WORD w2 = CharSetToCodePage(128);
//WORD w3 = CharSetToCodePage(130);
//WORD w4 = CharSetToCodePage(136);
//
//	wchar_t wcc[2] = { 0, 0 };
//	for (wcc[0] = 10; wcc[0] != 0xffff; wcc[0]++)
//	{
//		CString str1 = WStrToTStr(wcc, CP_ACP);
//		CString str2 = WStrToTStr(wcc, w2);
//		if (str1 != str2)
//			AfxDebugBreak();
//
//		WString wstr1 = TStrToWStr(str1, CP_ACP);
//		WString wstr2 = TStrToWStr(str2, w2);
//		if (wstr1 != wstr2)
//			AfxDebugBreak();
//	}
//----- 06.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#ifdef _DEBUG
	// _xZkqqHx_jFiCjDkOiPkMjAjEjDfPiJiJiOfKiCmMiDeHiDiJiBfLiBgJ_xHqqkZx_0_xZkqqHx_iKiEiKnMiCnOiBgKiCpAjHoBiKePiPiIjHjNiClHiCoJiBeC_xHqqkZx_
	_control87(0, _EM_INVALID|_EM_DENORMAL|_EM_ZERODIVIDE|_EM_OVERFLOW|_EM_UNDERFLOW);
#endif//_DEBUG

//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_DLL_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	m_hResInstance = FFLoadLibrary(L"DynamicDrawRes.dll");
	if (m_hResInstance <= (HINSTANCE)HINSTANCE_ERROR)
	//----- DLL_xZkqqHx_iCkKiDiNiBfLiDgIiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeCiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCkKiOgHiCkGiCmIiCkCiClNiCnPiBeBjFlGiOjKjHpBiCpAjClMiPjBiCkLiBeC_xHqqkZx_
		FFErrorBox(L"Cannot load the resource DLL");
		return FALSE;
	}
	// _xZkqqHx_iDiKiDfMiBfLiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	AfxSetResourceHandle(m_hResInstance);

	if (FFLoadWString(IDS_RESOURCE_VERSION) != FCHeaderInf::GetStcAppMajorMinorString())
	//----- _xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_DLL_xZkqqHx_iCmMiDgPiBfLiDfHiDiHiDjDiCmGiDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiBeCiDiKiDfMiBfLiDfI_xHqqkZx_ID_xZkqqHx_iCkKiOgHiCkGiCmIiCkCiClNiCnPiBeBjFlGiOjKjHpBiCpAjClMiPjBiCkLiBeC_xHqqkZx_
		FFErrorBox(L"Incorrect version of resource DLL");
		return FALSE;
	}
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (!AfxSocketInit())
	{
		FFErrorBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// OLE _xZkqqHx_iDiJiDeDiDhFiDiJiDiKiCmMiPiJiKpKiJlL_xHqqkZx_
	if (!AfxOleInit())
	{
		FFErrorBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

//	AfxDebugBreak();

//	// HistoricProject _xZkqqHx_iCmMiPiJiKpKiJlLiPiIjHjNiBeC_xHqqkZx_
//	HPFInitHistoricProject();

	// _xZkqqHx_jFfHiPiAjDeJiCmIiPiJiKpKiJlLiPiIjHjN_xHqqkZx_
	// _xZkqqHx_iCoAiClFiClBiCoKiCoHiCmMiLeAjEfMiCpAiOgHjHhAiClJiClIiBeBiOmAiNhDiDhEiDeAiDeDiDiLiCmMiDfEiDeDiDfJiCpAiPkMiClDiCkN_xHqqkZx_
	// _xZkqqHx_iClFiClNiCkPiCoKiCmOiImIiJlKiCmMjDmBjCoIiCmMiPiJiKpKiJlLiDiLiBfLiDgAiDjDiCmMjCiGiCkJiCoHjFhDjFeLjHhGiCmIiCoAiCmM_xHqqkZx_
	// _xZkqqHx_iCpAiNoNiPjMiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_

#ifdef _AFXDLL
	Enable3dControls();		// _xZkqqHx_iLkEjHeM_xHqqkZx_ DLL _xZkqqHx_iCmMjCiGiCmF_xHqqkZx_ MFC _xZkqqHx_iCpAiOgHjHhAiClHiCoJiPoKiNiHiCmJiCmNiClBiClBiCpAiMmEiCnBiPgPiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
#else
	Enable3dControlsStatic();	// MFC _xZkqqHx_iCmGjAmDjDeJiCmJiDiKiDjDiDeOiClFiCmEiCkCiCoJiPoKiNiHiCmJiCmNiClBiClBiCpAiMmEiCnBiPgPiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
#endif

	// _xZkqqHx_jAnNjCoIiCkKjFnLjBlGiClDiCoKiCoJiJlKiCmMiDiMiDfHiDfIiDgHiDiK_xHqqkZx_ _xZkqqHx_iDeMiBfLiCpAjFmPiNfIiClFiCnMiClHiBeC_xHqqkZx_
	// TODO: _xZkqqHx_iClBiCmMjFlGiOjKjHpBiCpAiBeBiJoPiOnAjGlMiCnMiClNiCmNiPiKjBkOiCmIiCmHjDeLjAnIiCmIiCoAiCmMiCmJ_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiClFiCmEiCkNiClOiClDiCkCiBeC_xHqqkZx_
	SetRegistryKey(WStrToTStr(REG_COMPANY_NAME));

	LoadStdProfileSettings(10);  // _xZkqqHx_jFfHiPiAiCmM_xHqqkZx_ INI _xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDeJiDhGiDfGiDiHiDjDiCpAiDiNiBfLiDgIiClFiCnMiClH_xHqqkZx_ (MRU _xZkqqHx_iCpAiKnMiCnO_xHqqkZx_)

	// DDE_xZkqqHx_iBeB_xHqqkZx_file open _xZkqqHx_iCmIiCmHjFfHiPiAiCmMiDfGiDeGiDiL_xHqqkZx_ _xZkqqHx_iDfCiDhNiDjDiDgIiCmMiDfCiDhNiDjDiDgIiDiJiDeDiDjDiCpAiJpAjAmNiClFiCnMiClHiBeC_xHqqkZx_
	CFCCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	cmdInfo.ParseDocRequest();

	// _xZkqqHx_iDeBiDhGiDiKiDiCiBfLiDgIiCpAiOoGjDlOiBeC_xHqqkZx_
	g_->appMode = cmdInfo.GetAppMode();
	// _xZkqqHx_iLeOjDkOiMlDiCmMiDeFiDeCiDjDiDgIiDeFiCpAiOoGjDlOiBeC_xHqqkZx_Editor_xZkqqHx_iOjOiCmJjHeMiMpIiBeC_xHqqkZx_
	CFCCommonEditorFrame::SetMasterAppFrame(cmdInfo.GetDrawHwnd());

	// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDjHhAiCmMiDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiCpAjDgPjIfOiClFiCnMiClHiBeCiDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgH_xHqqkZx_
	//  _xZkqqHx_iCmNiDgIiDeMiDiFiDiBiDjDiDgHiBeBiDhEiDiMiBfLiDiA_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmGiDhCiDiFiBfLiCpAiMiLiNiHiClHiCoJiClNiCnPiCmJiLeAjEfMiClFiCnMiClHiBeC_xHqqkZx_
	CSingleDocTemplate* pDocTemplate;

	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		pDocTemplate = new CSingleDocTemplate(
			IDR_MAINFRAME,
			RUNTIME_CLASS(CFCDynamicDrawDoc),
			RUNTIME_CLASS(CFCDynamicDrawFrame),   // _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ SDI _xZkqqHx_iDhEiDiMiBfLiDiA_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_
			RUNTIME_CLASS(CFCDynamicDrawView));
		break;
	case FD_APPMODE_CHIPEDITOR:	// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
		pDocTemplate = new CSingleDocTemplate(
			IDR_CHIP_EDIT,
			RUNTIME_CLASS(CFCChipEditorDoc),
			RUNTIME_CLASS(CFCChipEditorFrame),  // _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ SDI _xZkqqHx_iDhEiDiMiBfLiDiA_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_
			RUNTIME_CLASS(CFCDynamicDrawView));
		break;
	case FD_APPMODE_ARROWEDITOR:	// _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
		pDocTemplate = new CSingleDocTemplate(
			IDR_ARROW_EDIT,
			RUNTIME_CLASS(CFCArrowEditorDoc),
			RUNTIME_CLASS(CFCArrowEditorFrame),  // _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ SDI _xZkqqHx_iDhEiDiMiBfLiDiA_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_
			RUNTIME_CLASS(CFCDynamicDrawView));
		break;
#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		pDocTemplate = new CSingleDocTemplate(
			IDR_HIST_DRAW,
			RUNTIME_CLASS(CFCHistDrawDoc),
			RUNTIME_CLASS(CFCHistDrawFrame),   // _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ SDI _xZkqqHx_iDhEiDiMiBfLiDiA_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_
			RUNTIME_CLASS(CFCDynamicDrawView));
		// _xZkqqHx_jHeCiIoKiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
		g_pProject = new FCHiProject;
		break;
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		pDocTemplate = new CSingleDocTemplate(
			IDR_HIST_VIEW,
			RUNTIME_CLASS(CFCHistViewDoc),
			RUNTIME_CLASS(CFCHistViewFrame),   // _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ SDI _xZkqqHx_iDhEiDiMiBfLiDiA_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_
			RUNTIME_CLASS(CFCDynamicDrawView));
		// _xZkqqHx_jHeCiIoKiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
		g_pProject = new FCHiProject;
		break;
#endif//_DD_PRO
	}
	pDocTemplate->SetContainerInfo(IDR_CNTR_INPLACE);
	// IDR_SRVR_INPLACE _xZkqqHx_iCpAiOhHjCoIiClJiClIiBeBiDeDiDjDiDhGiDiMiBfLiDfIjFnCiPfHiCpAiLnGiOhOiClHiCoJiBeC_xHqqkZx_
	pDocTemplate->SetServerInfo(IDR_SRVR_EMBEDDED);
	AddDocTemplate(pDocTemplate);

	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiCmJ_xHqqkZx_ COleTemplateServer _xZkqqHx_iCpAjAnKjBlBiClFiCnMiClHiBeC_xHqqkZx_
	// COleTemplateServer _xZkqqHx_iCmNiDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_ _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
	// _xZkqqHx_iPoOjFpBiCpAiOgHiCmBiCmE_xHqqkZx_ OLE _xZkqqHx_iDfCiDjDiDgFiDgJiCmJjHhGiLiBiClHiCoJjBoDiCoNiCoIiCmJjAfGiLeLiDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_
	// _xZkqqHx_iCpAiNoMjAkMiClFiCnMiClHiBeC_xHqqkZx_
	m_server.ConnectTemplate(clsid, pDocTemplate, TRUE);
		// _xZkqqHx_iDiBiDiC_xHqqkZx_: SDI _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmNiDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmF_xHqqkZx_ /Embedding _xZkqqHx_iCkJ_xHqqkZx_ /Automation
		//       _xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiOjOiClOiCkPiDfEiBfLiDgPiBfL_xHqqkZx_ _xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjDgPjIfOiClFiCnMiClHiBeC_xHqqkZx_

	// DDE Execute open _xZkqqHx_iCpAiOgHjHhAiJmCjEfMiCmJiClFiCnMiClHiBeC_xHqqkZx_
	EnableShellOpen();

	// _xZkqqHx_iImIiJlKiCmMjGoCjBoIiCmMiClNiCnPiBeBjFfHiPiAiCmMiDiMiDfHiDfIiDgHiDiKiPjBiCkLiNjOiCnNiKnGjAjE_xHqqkZx_ RegisterShellFileTypes 
	// _xZkqqHx_iCmNjHjIjHhAiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iBeFiDhEiDeIiDiLiDfPiCmMiDiBiDgKiDiFiBfL_xHqqkZx_[_xZkqqHx_iDhEiDeIiDiLiDfPiDeJiDhGiDfGiDiHiDjD_xHqqkZx_]->[_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiOoNjHnO_xHqqkZx_]_xZkqqHx_iCkJiCoH_xHqqkZx_
	//   Dynamic Draw Document_xZkqqHx_iCmMiDfOiDeDiDhGiCmMjAoAjGlOiCpAjFmPiNfIiClFiCmEiCoAiMlDiCmJjGnPiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iBeFiIoKjEmKiDiGiBfLiDfFiCmFiLeOjDkOiClFiClNiOjOiCmJiBeBiBhFiDfGiDfIiDgFiDiAiDiMiDfHiDfIiDgHiDiKiCmMiNfIjAfGiCmJiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_
	//   REGEDIT_xZkqqHx_iCpAiOgHiCmBiCmEiNfIjAfGiClFiCmEiCkNiClOiClDiCkCiBeCiBhGiCmGiCkCiCkEiMhIiNjAiDiBiDgCiDfKiBfLiDfHiCpAiPgPiClFiCmEiCkLiCnMiClHiBeC_xHqqkZx_
	// _xZkqqHx_iBeFiDhEiDeAiDeDiDiLiCpAjBeJjBpAiClFiCmEiJeFiDhLiDfOiDjDiCmFiBhFiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiKeKiCkNiBhGiDiBiDgKiDiFiBfLiCmJ_xHqqkZx_
	//   Dynamic Draw_xZkqqHx_iCkKiCfBiCmCjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmM_xHqqkZx_HistoricDraw.Project(*.mdpj_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_)_xZkqqHx_iCmM_xHqqkZx_shell_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	g_pReg->RegisterShellFDPrjFileTypes();

	// _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	g_->Initialize();

//----- 06.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (g_pReg->GetCurrentRegVersion() != g_pReg->GetUserRegVersion())
//	//----- Dynamic Draw Pro _xZkqqHx_jBfDjBmMiCpAiCmGiCkIiClFiCmEiBeBiDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// CURRENT_USER_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
//		g_pReg->RegisterCurrentUserDefault(FFGetFileDirectory(FFGetMolipExePath()) + L"init.reg");
//		// _xZkqqHx_iNmFiPiJiCmMiLeOjDkOiCmMiDiMiDfHiDfIiDgHiDiKiLeMjIfOiCpAiPmBiLiOiBeC_xHqqkZx_
//		g_pReg->SetUserRegVersion(g_pReg->GetCurrentRegVersion());
//	}
//----- 06.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (g_pReg->GetCurrentRegVersion(0) != g_pReg->GetUserRegVersion(0))
	//----- Dynamic Draw Pro _xZkqqHx_jBfDjBmMiCpAiCmGiCkIiClFiCmEiBeBiDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// CURRENT_USER_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
		g_pReg->RegisterCurrentUserDefault(FFGetFileDirectory(FFGetMolipExePath()) + L"init.reg");
		// _xZkqqHx_iNmFiPiJiCmMiLeOjDkOiCmMiDiMiDfHiDfIiDgHiDiKiLeMjIfOiCpAiPmBiLiOiBeC_xHqqkZx_
		g_pReg->SetUserRegVersion(0, g_pReg->GetCurrentRegVersion(0));
	}
//----- 06.12.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (g_pReg->GetCurrentRegVersion(1) != g_pReg->GetUserRegVersion(1))
//	//----- Dynamic Draw Pro _xZkqqHx_jBfDjBmMiCpAiCmGiCkIiClFiCmEiBeBiDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// CURRENT_USER_xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
//		g_pReg->RegisterCurrentUserDefault(FFGetFileDirectory(FFGetMolipExePath()) + L"init1.reg");
//		// _xZkqqHx_iNmFiPiJiCmMiLeOjDkOiCmMiDiMiDfHiDfIiDgHiDiKiLeMjIfOiCpAiPmBiLiOiBeC_xHqqkZx_
//		g_pReg->SetUserRegVersion(1, g_pReg->GetCurrentRegVersion(1));
//	}
//----- 06.12.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.06.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.12.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (g_pReg->GetIsFirstExecute())
//	//----- _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmJiKnGiClFiCmEiBeBiDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNmFiPiJiCmMiLeOjDkOiCmMiDiMiDfHiDfIiDgHiDiKiLeMjIfOiCpAiPmBiLiOiBeC_xHqqkZx_
//		g_pReg->SetIsFirstExecute(FALSE);
//		// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
//		FFSendPendingMessage(FD_PMSG_MAIN_WND|FD_PMSG_IF_VISIBLE, WM_USER_FIRST_EXECUTE);
//	}
//----- 06.12.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHiKmCiLkLiCmMjAnNjCoIiCpAjDmHiCnNiNjOiCnNiBeC_xHqqkZx_
	g_pReg->LoadRegColor();
	g_pReg->LoadRegFont();
	g_pReg->LoadRegUnit();

	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiDgFiDeMiDfIiDgHiCmMiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	myLoadPophintTextTableFile(m_mpCommandToPophintText);
	// _xZkqqHx_jHeMiMpIiCmIiDhHiDiLiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	myLoadValidHelpIdFile(m_stValidHelpId);
	// _xZkqqHx_iDhHiDiLiDhGiDiAiBfLiDhCiBfLiCmMiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	myLoadHelpMovieTableFile(m_vHelpMovieFile, m_mpCommandToMovieIndex);
	// _xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCmMiDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiBeC_xHqqkZx_
	m_pPopHint->Create();

	// Dynamic_xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiBfLiCpAiDfIiDfOiBfLiDgHiBeC_xHqqkZx_
	FFStartDbServer();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiCpAiNoMjAkMiBeC_xHqqkZx_
	g_pFileServer = new FCDynamicDb();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiCmJiDiNiDePiDeDiDjDiPoOjFpBiCpAjDgPjIfOiBeC_xHqqkZx_
	g_pFileServer->SetLoginUserName(GetUserName());

//----- 06.12.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.12.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (!cmdInfo.m_bRunEmbedded &&
//		!cmdInfo.m_bRunAutomated &&
//		(DWORD)FCHeaderInf::GetStcAppVersion() != g_pReg->GetRegAppVersion())
//
//	//----- OLE_xZkqqHx_iLeOjDkOiCmFiCmNiCmIiCkNiBeBiKiOiCmCiDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCkK_xHqqkZx_
//	//		_xZkqqHx_iDeKiDiMiDjDiDgHiDiGiBfLiDfFiDiMiDfHiDfIiDgHiDiKiCmMiLeMjIfOiCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMlEiIpGiCmNjFhDjGlOiClOiCkKiBeBiDeDiDjDiDfIiDgHiBfLiDiLjClMiMoDiCmMiPiJiJpBiLeOjDkOiCmMiCnNiBeB_xHqqkZx_
//		// _xZkqqHx_iDeHiDiJiBfLiCkKjEkNjAlGiClFiCmEjHiOiClPiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiLeMjIfOjDjJiCkKiNgMiCkGiCoHiCoKiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiClNiCnPiBeBjAfGiClFiCkC_xHqqkZx_EXE_xZkqqHx_iCmMiPiJiJpBiLeOjDkOiCmMiCnNiBeBiDeBiDhGiDiKiCpAiNmEiLeOjDkOiClHiCoJiBeC_xHqqkZx_
//		// OLE_xZkqqHx_iLeOjDkOiCmMiPoKiNiHiBeB_xHqqkZx_EXE_xZkqqHx_iCmMiDhGiDiNiDfKiDfIiCkKiInJiCmIiCoJiCmMiCmNiCnMiClIiCkCiCmMiCmFiBeB_xHqqkZx_
//		// OLE_xZkqqHx_iLeOjDkOiCmMiPoKiNiHiCmMiCnNiBeBiCoCiCnOiCmIiCkNiNmEiLeOjDkOiCmNjEpAiCkPiCoJiBeC_xHqqkZx_
//
//		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiMlLiNnNiCmMiDgPiBfLiDfHiDiHiDjDiCpAiLeMjIfOiBeC_xHqqkZx_
//		g_pReg->SetRegAppVersion((DWORD)FCHeaderInf::GetStcAppVersion());
//		// _xZkqqHx_jAfGiLeLiNoMjAkMiBeCiClBiCoKiCpAiOmAiNhDiClFiCmIiCkCiCmGiDeHiDiJiBfLiCkKjEkNjAlGiBeC_xHqqkZx_
//		OnCmdMsg(ID_FILE_NEW, 0, NULL, NULL);
//		//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiDeFiDeCiDjDiDgIiDeFiDfIiDfOiDeDiDiLiBjFiDfEiDeDiDfJiCpAiLeMjIfO_xHqqkZx_ -----
//		// _xZkqqHx_jCmKiPoNiOjOiBgJiDeBiDeDiDfCiDjDiCmFiCoAiNmFjBoFiCmFiCoAiCmIiCkCiBgKiCmMiDeFiDeCiDjDiDgIiDeFiImKjChFiBeFiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
//		WINDOWPLACEMENT wp;
//		wp.length = sizeof(wp);
//		(void)FFGetMainWnd()->GetWnd()->GetWindowPlacement(&wp);
//		const CRect rtWin = wp.rcNormalPosition;
//		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiBeC_xHqqkZx_
//		g_pReg->SetAppWinPos(	(DWORD)FFGetMainWnd()->GetWnd()->GetStyle(),
//								CPoint(rtWin.left, rtWin.top),
//							 	CSize(rtWin.Width(), rtWin.Height()));
//		// _xZkqqHx_jDkPiClGiIpIjAjEiCmFiBeBiDeBiDhGiDiKiCpAiNmEiLeOjDkOiClHiCoJiBeC_xHqqkZx_
//		ExecMolipDraw(TStrToWStr(m_lpCmdLine));
//		// _xZkqqHx_jBkGiOjOiPeJjHlJiClHiCoJiBeC_xHqqkZx_
//		return FALSE;
//	}
//----- 06.12.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.12.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// 06.04.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////	if (g_pReg->GetIsFirstExecute())
//	if (g_pReg->GetCurrentRegVersion() != g_pReg->GetUserRegVersion())
//	//----- _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNmFiPiJiCmMiLeOjDkOiCmMiDiMiDfHiDfIiDgHiDiKiLeMjIfOiCpAiPmBiLiOiBeC_xHqqkZx_
//		g_pReg->SetUserRegVersion(g_pReg->GetCurrentRegVersion());
//		// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
//		FFSendPendingMessage(FD_PMSG_MAIN_WND|FD_PMSG_IF_VISIBLE, WM_USER_FIRST_EXECUTE);
//	}
//----- 06.04.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.12.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsFirstExecute())
	//----- _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmJiKnGiClFiCmEiBeBiDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiPiJiCmMiLeOjDkOiCmMiDiMiDfHiDfIiDgHiDiKiLeMjIfOiCpAiPmBiLiOiBeC_xHqqkZx_
		g_pReg->SetIsFirstExecute(FALSE);
		// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiMoDiCmMiNmFiPiJiCmMiLeOjDkOiCmMiPoKiNiHiCmNiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
		FFSendPendingMessage(FD_PMSG_MAIN_WND|FD_PMSG_IF_VISIBLE, WM_USER_FIRST_EXECUTE);
	}
//----- 06.12.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// OLE _xZkqqHx_iDfEiBfLiDgPiBfLiCmGiClFiCmEiLeOjDkOiClDiCoKiCmEiCkCiCoJiCkJiKgNjEeGiClFiCnMiClHiBeC_xHqqkZx_
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		// _xZkqqHx_iOmAiNhDiDiCiBfLiDgIiCmMjAnNjCoIiBeC_xHqqkZx_OLE Embedded_xZkqqHx_iDiCiBfLiDgIiBeC_xHqqkZx_
		g_->appMode = FD_RUNMODE_EMBEDDED | (g_->appMode & ~FD_RUNMODE_MASK);
		// _xZkqqHx_iOmAiNhDiClHiCoJiCmGiClHiCnHiCmEiCmM_xHqqkZx_ OLE _xZkqqHx_iDfEiBfLiDgPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeOiDgHiDiKiCpAjDgPjIfOiClFiCnMiClHiBeC_xHqqkZx_
		// _xZkqqHx_jBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMiCoJiClNiCnPiCmJ_xHqqkZx_ OLE _xZkqqHx_iDiJiDeDiDhFiDiJiDiKiCpAiOgHjHhAiJmCjEfMiCmJiClFiCnMiClHiBeC_xHqqkZx_
		COleTemplateServer::RegisterAll();

		// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkK_xHqqkZx_ /Embedding _xZkqqHx_iCkJ_xHqqkZx_ /Automation _xZkqqHx_iCmFiOmAiNhDiClDiCoKiCmEiCkCiCoJiOjOiCmJiCmN_xHqqkZx_
		// _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeF_xHqqkZx_ _xZkqqHx_iCmNjFfMiOkGiCmFiCkLiCnMiClJiCpBiBeC_xHqqkZx_
		return TRUE;
	}

	// _xZkqqHx_iDfGiDfIiDgFiDiA_xHqqkZx_ _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCpAiPeDjFjMiBeC_xHqqkZx_
	// m_server.UpdateRegistry(OAT_SERVER) _xZkqqHx_iCmNiBeB_xHqqkZx_Admin_xZkqqHx_iImIiKePiCmFiOgHiCkEiCmG_xHqqkZx_
	// _xZkqqHx_iBhFiDfGiDfIiDgFiDiAiDiMiDfHiDfIiDgHiDiKiCmMiNfIjAfGiCmJiOlIjEhDiClFiCnMiClFiClNiBeC_xHqqkZx_REGEDIT_xZkqqHx_iCpAiOgHiCmBiCmEiNfIjAfGiClFiCmEiCkNiClOiClDiCkCiBeCiBhGiCmGiCkCiCkEiMhIiNjAiDiBiDgCiDfKiBfLiDfHiCkKiPgPiCoJiClNiCnPiBeC_xHqqkZx_
	COleObjectFactory::UpdateRegistryAll();

	//----- _xZkqqHx_iDiGiBfLiDfFiPeDjFjMiDiCiBfLiDgIiCmMiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	if (g_->appMode & FD_RUNMODE_REPAIR_DOCUMENT)
	{
		OnFileNew();
		FFPostPendingMessage(FD_PMSG_MAIN_WND, WM_USER_REPAIR_DOCUMENT);
		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiBfLiCmJiDeFiDeCiDjDiDgIiDeFiCpAjDgPjIfOiBeC_xHqqkZx_
		FFSetDbServerHwnd(FFGetMainWnd()->GetSafeHwnd());
		return TRUE;
	}

	if ((g_->appMode & FD_APPMODE_MASK) != FD_APPMODE_HISTORYVIEWER)
	//----- _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKpJiCmJjDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJjDkPiClGiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmMiPiIjHjNiBeC_xHqqkZx_
		HWND hwnd = cmdInfo.CheckSameDocumentApp();
		if (hwnd != NULL)
		//----- _xZkqqHx_iKpJiCmJjDkPiClGjFlGiPjBiCpAiKeKiCkCiCmEiCkCiCoJjDkPiClGiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBjHpBiCmMiDfCiDhDiBfLiCpAiOoGiCoJiBeC_xHqqkZx_
			FCReqBaseAutoVector vDocRequest = cmdInfo.GetDocRequest();
			// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiDeBiDhGiDiKiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiCmJiBeC_xHqqkZx_
			::SetForegroundWindow(hwnd);
			// _xZkqqHx_jBiKiOoIjAoGiDeBiDhGiDiKiCmJiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCpAjBjHjFhEiBeC_xHqqkZx_
			FFSendDocRequest(hwnd, NULL, vDocRequest);
			return FALSE;
		}
	}

	// _xZkqqHx_iDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmFiDgGiDeCiDfIiDhAiDgCiDgA_xHqqkZx_ _xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiClFiCnMiClHiBeC_xHqqkZx_
	// _xZkqqHx_jCmKiPoNiCmNiBeBiDfCiDhNiDjDiDgIiDiJiDeDiDjDiCmJiDhEiDeAiDeDiDiLjGlMiCkKiLeMiPhBiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
	// _xZkqqHx_iImIiJlKiCmMiKnGjAjEiCkJiCoH_xHqqkZx_ CFCFoundDoc::OnNewDocument_xZkqqHx_iBeB_xHqqkZx_
	// CFCFoundDoc::OnOpenDocument_xZkqqHx_iKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiCmMiClOiCkKiBeB_xHqqkZx_
	// ParseDocRequest()_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmE_xHqqkZx_ cmdInfo _xZkqqHx_jCiGiCmM_xHqqkZx_FileNew_xZkqqHx_iBeB_xHqqkZx_FileOpen _xZkqqHx_iCmN_xHqqkZx_
	// _xZkqqHx_iPjMiLiOiClDiCoKiBeBiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmJjFmPiKlHiClDiCoKiCmEiCkCiCoJiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iImIiJlKiCkJiCoHiOmAiNhDiClDiCoKiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iOjGiOmAiPoDiBeBiIpDiNpMjGlNjHnPiCmMiCnNiCkKiImIiJlKiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
	if (!ProcessShellCommand(cmdInfo)) return FALSE;

	// _xZkqqHx_jAfGiLeLiNoMjAkMiCpAiOmAiNhDiBeC_xHqqkZx_ProcessShellCommand_xZkqqHx_iKnGjAjEiCmFjAfGiLeLiNoMjAkMiCkK_xHqqkZx_
	// _xZkqqHx_iClDiCoKiCmIiCkNiCmIiCmBiClNiClNiCnPiBeBiClBiClBiCmFiOmAiNhDiBeC_xHqqkZx_
	// _xZkqqHx_jAfGiLeLiNoMjAkMiCpAiClFiCmIiCkCiCmGiBeB_xHqqkZx_g_pDoc_xZkqqHx_iCkK_xHqqkZx_NULL_xZkqqHx_iCmMiCnMiCnMiBeC_xHqqkZx_
// 06.12.08 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	AfxGetApp()->OnCmdMsg(ID_FILE_NEW, 0, NULL, NULL);
	OnCmdMsg(ID_FILE_NEW, 0, NULL, NULL);

	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiBfLiCmJiDeFiDeCiDjDiDgIiDeFiCpAjDgPjIfOiBeC_xHqqkZx_
	FFSetDbServerHwnd(FFGetMainWnd()->GetSafeHwnd());

	FCReqBaseAutoVector vDocRequest = cmdInfo.GetDocRequest();
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_jFhDjHhGiCmIiDiPiBfLiDeOiCmMiNoNiPjMiBeC_xHqqkZx_
// 06.05.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		CFCDlgRepairDoc::DeleteUnusedWork();
		CFCDlgRepairDoc::DeleteUnusedWork(g_->appMode & FD_APPMODE_MASK);
		// _xZkqqHx_iPeDjFjMjFlGiPjBiCmMiDgAiDeGiDgCiDeOiCmGiPeDjFjMiPiIjHjNiBeC_xHqqkZx_
		CFCDlgRepairDoc::CheckRepairMolipDoc();
		break;

#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		// History Viewer _xZkqqHx_iCkJiCoH_xHqqkZx_Historic Draw _xZkqqHx_iCkKiLeOjDkOiClDiCoKiClNiPoKiNiHiBeB_xHqqkZx_
		// Historic Draw _xZkqqHx_iCpAjAlDiPoNiCmJiLeOjDkOiClFiCmEiCoCiCoHiCmIiCkCiCmG_xHqqkZx_
		// History Viewer _xZkqqHx_iCmM_xHqqkZx_ ActivateDocument _xZkqqHx_iCkKiOmAiNhDiClDiCoKiCmIiCkCiBeC_xHqqkZx_
		// CFCMolipDrawApp::InitInstance _xZkqqHx_iCkJiCoH_xHqqkZx_ LockDocument _xZkqqHx_iCpAiOmAiNhDiClHiCoJiCmG_xHqqkZx_
		// History Viewer _xZkqqHx_iCmF_xHqqkZx_ UnlockDocument _xZkqqHx_iClDiCoKiCmEiCkCiCmIiCkCiDgIiDeMiDiFiDiBiDjDiDgHiCpA_xHqqkZx_
		// LockDocument _xZkqqHx_iClFiCoGiCkEiCmGiClHiCoJiClBiCmGiCmJiCmIiCmBiCmEiClFiCnMiCkCiBeBiDgGiDgCiDgIiDiNiDgCiDeOiCkK_xHqqkZx_
		// _xZkqqHx_jEkNjAlGiClHiCoJiBeC_xHqqkZx_
		// CFCMolipDrawApp::InitInstance _xZkqqHx_iCkJiCoH_xHqqkZx_SetTimer_xZkqqHx_iCmF_xHqqkZx_OnTimer_xZkqqHx_iKnGjAjEiCpAiOmAiNhD_xHqqkZx_
		// _xZkqqHx_iClHiCoJiClBiCmGiCmJiCoGiCmBiCmEiBeB_xHqqkZx_LockDocument _xZkqqHx_iCmMiJmCjEnLiCmJiKnGiCoNiCoHiClI_xHqqkZx_
		// Historic Draw _xZkqqHx_iCpAjAlDiPoNiCmJiLeOjDkOiClDiClJiCoJiBeC_xHqqkZx_
		// LockDocument _xZkqqHx_iCmNiBeB_xHqqkZx_History Viewer _xZkqqHx_jBkEiCkK_xHqqkZx_ ActivateDocument _xZkqqHx_iCkJiCoH_xHqqkZx_
		// UnlockDocument _xZkqqHx_iCpAiOmAiNhDiClHiCoJiCnMiCmFiDfOiDeDiDhNiBfLiCmFjBnCiClNiClJiCoJiBeC_xHqqkZx_

		// _xZkqqHx_jFhDjHhGiCmIiDiPiBfLiDeOiCmMiNoNiPjMiBeC_xHqqkZx_
// 06.05.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		CFCDlgRepairDoc::DeleteUnusedWork();
		CFCDlgRepairDoc::DeleteUnusedWork(g_->appMode & FD_APPMODE_MASK);
		// _xZkqqHx_iPeDjFjMjFlGiPjBiCmMiDgAiDeGiDgCiDeOiCmGiPeDjFjMiPiIjHjNiBeC_xHqqkZx_
		CFCDlgRepairDoc::CheckRepairHistoricDoc();

		if (g_pReg->GetIsOpenUnknown() &&
			vDocRequest.FindRequest(ID_DREQ_OPEN_PROJECT) == -1 &&
			vDocRequest.FindRequest(ID_DREQ_CREATE_PROJECT) == -1)
		//----- _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ ------
		{
			// TMP_xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCmJiDiGiDgKiBfLiDeOiCmIiDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
			FFInsertDocRequest(vDocRequest, -1, ID_DREQ_CREATE_PROJECT);
			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkNiBeC_xHqqkZx_
			FFInsertDocRequest(vDocRequest, -1, ID_DREQ_OPEN_PROJECT);
			// _xZkqqHx_iDiGiDgKiBfLiDeOiCmIjHjKjHpAjFlGiPjBiCpAjAfGiLeLiNoMjAkMiBeC_xHqqkZx_
			FFInsertDocRequest(vDocRequest, -1, ID_DREQ_CREATE_HIDOCUMENT);
			// _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiKeKiCkNiBeC_xHqqkZx_
			FFInsertDocRequest(vDocRequest, -1, ID_DREQ_OPEN_HIDOCUMENT);
			// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
			FFInsertDocRequest(vDocRequest, -1, ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
		}
		break;

	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		break;
#endif//_DD_PRO
	}

	if (vDocRequest.FindRequest(ID_DREQ_OPEN_HIDOCUMENT) == -1)
	//----- _xZkqqHx_iBhFjHjKjHpAjFlGiPjBiCpAiKeKiCkNiBhGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKiPiJiKpKiJlLiClDiCoKiClNiCmMiCmFiBeBjFfMiOkGiCmGiNfIjAfGiCpAiNhDiCkCiCnMiClHiBeC_xHqqkZx_
		m_pMainWnd->ShowWindow(SW_SHOW);
		m_pMainWnd->UpdateWindow();
	} else
	//----- _xZkqqHx_iBhFjHjKjHpAjFlGiPjBiCpAiKeKiCkNiBhGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ ------
	{
		// HistDraw_xZkqqHx_iCmMiPoKiNiHiBeBiDgIiDeMiDiFiDiBiDjDiDgHiCpAiKeKiCkNiCnMiCmFjChIiJiEiCkKiCkAiCoJiCmMiCmFiBeB_xHqqkZx_
		// _xZkqqHx_jHfMiCnPiKeKiCkCiClNiPpDjBnEiCmFjFfMiOkGiCpAiNhDiCkEiBeC_xHqqkZx_
		const BOOL bIsDocumentOpened = g_pDoc->GetIsDocumentOpened();
		g_pDoc->SetIsDocumentOpened(TRUE);
		// _xZkqqHx_iDiBiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKiPiJiKpKiJlLiClDiCoKiClNiCmMiCmFiBeBjFfMiOkGiCmGiNfIjAfGiCpAiNhDiCkCiCnMiClHiBeC_xHqqkZx_
		m_pMainWnd->ShowWindow(SW_SHOW);
		m_pMainWnd->UpdateWindow();
		g_pDoc->SetIsDocumentOpened(bIsDocumentOpened);
	}

	//----- _xZkqqHx_iMlLiNnNiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCpAjFmPiNfIiClHiCoJ_xHqqkZx_ -----
	if (FCRecentList::GetCount() != 0)
	//----- _xZkqqHx_iNmFiLnPiOgHiCoNiCoKiClNjFlGiPjBiCmMiDiKiDfIiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		switch (g_->appMode & FD_APPMODE_MASK)
		{
		case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIjGlMiCkJiCoHiDhAiDfIjFjEjFkKiCpAjFkKjHkDiClHiCoJiBeC_xHqqkZx_
			WString wstrFilePath;
			FCRecentList::Get(0, NULL, NULL, &wstrFilePath);
			WString wstrDirPath = FFGetFileDirectory(wstrFilePath);
			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			FFSetCurrentDirectory(wstrDirPath);
			break;
		  }
#ifdef _DD_PRO
		case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
			WString wstrTopGroup;
			FCRecentList::Get(0, NULL, NULL, &wstrTopGroup);
			// _xZkqqHx_iDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			g_pFileServer->SetCurrentDirectory(FFGetFileDirectory(wstrTopGroup, TRUE));
			break;
		  }
#endif//_DD_PRO
		}
	} else
//----- 06.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_iNmFiLnPiOgHiCoNiCoKiClNjFlGiPjBiCmMiDiKiDfIiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBlGiNnNiClFiCmIiCkCiPoKiNiHiBeBjDeLjAnIiCmIiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClLiCkEiClFiCmIiCkCiCmGiBeBiDeBiDhGiDiKiCmMiDgGiDeCiDiMiDeOiDgHiDiKiCkKjAnNjCoIiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iDgGiDfIiDeOiDgHiDgCiDhGiDhEiDeIiDiLiDfPiBeC_xHqqkZx_
		WString wstrDesktop = FFGetDesktopDirectory();
		switch (g_->appMode & FD_APPMODE_MASK)
		{
		case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			FFSetCurrentDirectory(wstrDesktop);
			break;
		  }
#ifdef _DD_PRO
		case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			g_pFileServer->SetCurrentDirectory(wstrDesktop);
			break;
		  }
#endif//_DD_PRO
		}
	}
//----- 06.05.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (!vDocRequest.empty())
	//----- _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		FFInsertDocRequest(vDocRequest, -1, ID_DREQ_END);
		g_pDoc->PushBackDocRequest(vDocRequest);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest(TRUE);
	}

	// _xZkqqHx_iDgIiDiJiDgCiDeP_xHqqkZx_/_xZkqqHx_iDgIiDiNiDgCiDhG_xHqqkZx_ _xZkqqHx_iDeJiBfLiDhGiDjDiCpAiLjGiJmCiClFiCnMiClH_xHqqkZx_
	m_pMainWnd->DragAcceptFiles();

#ifdef _DD_PRO
	// HistView,HistDraw_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfIiDhMiDgCiDgHjDmHiCnNiPgPiClFiCmMjDhIiCmJ_xHqqkZx_
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMjAnNjCoIiCkKjFmPiNfIiClDiCoKiCmEiClFiCnMiCkEiCmMiCmNiNkCiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDhEiDeAiDeDiDiLiCmFiCmNiCmIiCkNiBeBiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClDiClJiCoJiBeC_xHqqkZx_
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		BYTEVector vStream;
		if (g_pReg->GetPrinterStatus(vStream))
		{
			// _xZkqqHx_jDmHiCnNiPgPiClFiClNiDgGiBfLiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
			CMemFile file;
			file.Attach(&vStream[0], vStream.size());
			InStream(FCUndoArchive(&file, FD_ARCHIVE_LOAD));
		}
		break;
	  }
	}
#endif//_DD_PRO

	return TRUE;
} // CFCMolipDrawApp::InitInstance.

/////////////////////////////////////////////////////////////////////////////
// CFCMolipDrawApp _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJiBeC_xHqqkZx_

int CFCMolipDrawApp::ExitInstance ()
{
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDhIiDfHiDeGiLnPiOjHiLmIjApMiCmMiDfIiDiMiDgCiDgIiCpAiPeJjHlJiClDiClJiCoJiBeC_xHqqkZx_
	FCObjWidePoly::TerminateCalcBezierThread();
//----- 06.03.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

#ifdef _DD_PRO
	// HistView,HistDraw_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiDfIiDhMiDgCiDgHjDmHiCnNiPgPiClFiCmMjDhIiCmJ_xHqqkZx_
	// _xZkqqHx_iDhGiDiKiDjDiDfOiCmMjAnNjCoIiCkKjFmPiNfIiClDiCoKiCmEiClFiCnMiCkEiCmMiCmNiNkCiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBiDhEiDeAiDeDiDiLiCmFiCmNiCmIiCkNiBeBiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClDiClJiCoJiBeC_xHqqkZx_
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		CMemFile file;
		OutStream(FCUndoArchive(&file, FD_ARCHIVE_STORE));
		DWORD dwStreamSize = file.GetLength();
		BYTE* pStream = file.Detach();
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
		g_pReg->SetPrinterStatus(pStream, dwStreamSize);
		::free(pStream);
		break;
	  }
	}
	// _xZkqqHx_jHeCiIoKiCmMiDhGiDiNiDfHiDeGiDeOiDgHiCpAiNoNiPjMiBeC_xHqqkZx_
	if (g_pProject != NULL)
	{
		delete g_pProject;
		g_pProject = NULL;
	}
#endif//_DD_PRO

//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if ((HINSTANCE)HINSTANCE_ERROR < m_hResInstance)
	{
		// _xZkqqHx_iDiKiDfMiBfLiDfI_xHqqkZx_DLL_xZkqqHx_iCpAiJpAjFpKiBeC_xHqqkZx_
		FFFreeLibrary(m_hResInstance);
		m_hResInstance = NULL;
	}
//----- 06.04.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiCpAiPeJjHlJiBeC_xHqqkZx_
	delete g_pFileServer;
	g_pFileServer = NULL;

	// Dynamic_xZkqqHx_iDhEiDeAiDeDiDiLiDfEiBfLiDgPiBfLiCpAiDfIiDgHiDgCiDhGiBeC_xHqqkZx_
	FFStopDbServer();

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return CWinApp::ExitInstance();
} // CFCMolipDrawApp::ExitInstance.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OnAppWinExit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFjBfDiCmEiPeJjHlJiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiDeFiDeCiDjDiDgIiDeFiCpAiPeJjHlJiClDiClJiCoJiBeCiCnMiClIiBeBiOkJjFkKiCmMiDeFiDeCiDjDiDgIiDeFiCmMiPeJjHlJiCpA_xHqqkZx_
 *			_xZkqqHx_iOiOiCnNiCoJiBeCjAkMiMpHiClFiClNiPoKiNiHiCmNiBeBiOjPiCmMiDeFiDeCiDjDiDgIiDeFiCfAiCmCiClOiCkPiCmJ_xHqqkZx_ ID_APP_WIN_EXIT
 *			_xZkqqHx_iCpAjBjHjAeNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiPiIjHjNiCmFiBeBjIeBiNlNjDeJiCmJiPeJjHlJiCkKjAgJiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::OnAppWinExit ()
{
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jIeBjBlBiDfCiBfLiDiLiCmMiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//	static int s_iCount = 0;
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePjFfMiOkGjCiGiCmIiCmHiBeBiDhEiDiMiBfLiDiAiCkK_xHqqkZx_
	// Enable_xZkqqHx_iCmFiCmIiCkCiPoKiNiHiCmNiPeJjHlJiPiIjHjNiCpAjBjHiCoHiCmIiCkCiBeC_xHqqkZx_
	if (!FFGetMainWnd()->GetWnd()->IsWindowEnabled())
		return;
	// _xZkqqHx_iOjPiCmMiDeBiDhGiDiKiCmMiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
	HWND hwndNext = NULL;
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFjHpBiLjDiBeC_xHqqkZx_
	FCWinTitleRecVector vWinTtl;
	::EnumWinTitle(vWinTtl);
	FCWinTitleRecVector::iterator iWin;
	for (iWin = vWinTtl.begin(); iWin != vWinTtl.end(); iWin++)
	{
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCkKjHeMiMpI_xHqqkZx_ _xZkqqHx_iKiOiCmC_xHqqkZx_ _xZkqqHx_iIoBiCkEiDeFiDeCiDjDiDgIiDeFiCmIiCoHiOjPiCnGiBeC_xHqqkZx_
		if (::IsWindow((*iWin).hwndApp) &&
			(*iWin).hwndApp != FFGetMainWnd()->GetSafeHwnd())
		{
			hwndNext = (*iWin).hwndApp;
			break;
		}
	}
	switch (g_->appMode & FD_APPMODE_MASK)
	{
#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_jFnLjBlGiClFiCmEiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_SAVE_AND_EXIT);
		if (hwndNext != NULL)
		//----- _xZkqqHx_iOjPiCmMiDeFiDeCiDjDiDgIiDeFiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iPpAiMiPiOmAiNhDiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_IF_NOT,
//										FCReqBase::RETURN, IDCANCEL,
//										FCReqBase::NONE);
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_jBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiJlLiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_SET_FOREGROUND,
//										FCReqBase::HWND, hwndNext,
//										FCReqBase::NONE);
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iClBiClBiCmFiBeB_xHqqkZx_ID_DREQ_SET_FOREGROUND _xZkqqHx_iCpAiMmEiCpBiCmF_xHqqkZx_
			// hwndNext _xZkqqHx_iCpAiDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiJlLiClFiCmEiCkCiClNiCmMiClOiCkKiBeB_xHqqkZx_
			// hwndNext _xZkqqHx_iCpAiDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiJlLiClHiCoJiCmGiBeB_xHqqkZx_
			// _xZkqqHx_iPkNiClFiOjOiKnEiCpAjChFiCkCiCmEiCkJiCoH_xHqqkZx_ PostMessage _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiCmG_xHqqkZx_
			// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoHiClIjEgKiKpMiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_

			// _xZkqqHx_jBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(	ID_DREQ_POST_MESSAGE,
										FCReqBase::HWND, hwndNext,
										FCReqBase::MESSAGE, WM_COMMAND,
										FCReqBase::WPARAM, ID_APP_WIN_EXIT,
										FCReqBase::NONE);
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iPpAiMiPiOmAiNhDiPeJjCfLiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(ID_DREQ_END_IF);
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		}
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
		break;
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_APP_EXIT);
		if (hwndNext != NULL)
		//----- _xZkqqHx_iOjPiCmMiDeFiDeCiDjDiDgIiDeFiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_jBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiDhEiDeIiDeBiDePiDiJiDjDiDgIiJlLiBeC_xHqqkZx_
//			g_pDoc->PushBackDocRequest(	ID_DREQ_SET_FOREGROUND,
//										FCReqBase::HWND, hwndNext,
//										FCReqBase::NONE);
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iClBiClBiCmFiBeB_xHqqkZx_ID_DREQ_SET_FOREGROUND _xZkqqHx_iCpAiMmEiCpBiCmF_xHqqkZx_
			// hwndNext _xZkqqHx_iCpAiDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiJlLiClFiCmEiCkCiClNiCmMiClOiCkKiBeB_xHqqkZx_
			// hwndNext _xZkqqHx_iCpAiDhEiDeIiDeBiDePiDiJiDeFiDjDiDgIiJlLiClHiCoJiCmGiBeB_xHqqkZx_
			// _xZkqqHx_iPkNiClFiOjOiKnEiCpAjChFiCkCiCmEiCkJiCoH_xHqqkZx_ PostMessage _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiCmG_xHqqkZx_
			// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOpDiCkPiOoGiCoHiClIjEgKiKpMiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_

			// _xZkqqHx_jBlMiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiBeC_xHqqkZx_
			g_pDoc->PushBackDocRequest(	ID_DREQ_POST_MESSAGE,
										FCReqBase::HWND, hwndNext,
										FCReqBase::MESSAGE, WM_COMMAND,
										FCReqBase::WPARAM, ID_APP_WIN_EXIT,
										FCReqBase::NONE);
		}
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
		break;
#endif//_DD_PRO
	case FD_APPMODE_DYNAMICDRAW:	// DynamicDraw_xZkqqHx_iDiCiBfLiDgIiBeC_xHqqkZx_
	case FD_APPMODE_CHIPEDITOR:		// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeC_xHqqkZx_
	case FD_APPMODE_ARROWEDITOR:	// _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiDiCiBfLiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iDiBiDeDiDjDiDhEiDiMiBfLiDiAiCmJiPeJjHlJiPiIjHjNiCpAjBjHjAeNiBeC_xHqqkZx_
		FFGetMainWnd()->SendMessage(WM_CLOSE);
		// _xZkqqHx_iPeJjHlJiPiIjHjNiCkKiOlIjEhDiClFiClNiPoKiNiHiCmNiClBiClBiCmFiPiIjHjNiCpAiPeJiCoNiCoJiBeC_xHqqkZx_
		if (::IsWindow(FFGetMainWnd()->GetSafeHwnd()))
		{
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_jIeBjBlBiDfCiBfLiDiLiCmMiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
//			if (s_iCount == 5000)
//			{
//				s_iCount = 0;
//			} else
//			{
//				s_iCount++;
//				FFGetMainWnd()->PostMessage(WM_COMMAND, ID_APP_WIN_EXIT, 0);
//			}
//----- 06.03.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			return;
		}
		if (hwndNext != NULL)
		//----- _xZkqqHx_iOjPiCmMiDeFiDeCiDjDiDgIiDeFiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jAnIiCoIjBnGiCkGjAoGiCkKiDeBiDeDiDfCiDjDiJlLiClDiCoKiCmEiCkCiClNiCoHiBeBiMlDiCmMiDfEiDeDiDfJiCmJjGnPiClHiBeC_xHqqkZx_
			if (::GetWindowLong(hwndNext, GWL_STYLE) & WS_MINIMIZE)
				(void)::ShowWindow(hwndNext, SW_RESTORE);
			// _xZkqqHx_iDhEiDeIiDeBiDePiDiJiDjDiDgIiDeFiDeCiDjDiDgIiDeFiCpAjAnIiCoIjBnGiCkGiBeC_xHqqkZx_
			(void)::SetForegroundWindow(hwndNext);
			// ID_APP_WIN_EXIT_xZkqqHx_iCpAjBjHjAeNiBeC_xHqqkZx_
			::PostMessage(hwndNext, WM_COMMAND, ID_APP_WIN_EXIT, 0);
		}
		break;
	default:
		FFThrowMiscUnknown();
	}
} // CFCMolipDrawApp::OnAppWinExit.

/////////////////////////////////////////////////////////////////////////////
// CFCMolipDrawApp _xZkqqHx_iDeJiBfLiDgPiBfLiDiJiDeDiDgIiKnGjAjE_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OpenDocumentFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiKeKiCkNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszFileName	:_xZkqqHx_iKeKiCkNiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDgIiDiJiDgCiDePiBjFiDgIiDiNiDgCiDhGiCmFiLeOjDkOiCmMiPoKiNiHiBeB_xHqqkZx_HistDraw_xZkqqHx_iCmFiCkAiCmBiCmEiCoA_xHqqkZx_
 *			MolipDraw_xZkqqHx_iCpAiLeOjDkOiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeCiClBiCmMiKnGjAjEiCmFiClLiCoKiCmJjBmOiJjOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDhFiDiLiDeOiDiKiDgCiDeOiCmFiLeOjDkOiClHiCoJiPoKiNiHiBeBiKpJjBlGiDeBiDhGiDiKiCmJ_xHqqkZx_
 *			_xZkqqHx_iDgIiDiJiDgCiDePiBjFiDgIiDiNiDgCiDhGiCmFiDhEiDeAiDeDiDiLiCpAjHiOiCmGiClFiClNiPoKiNiHiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfPiDhFiDiLiDeOiDiKiDgCiDeOiLeOjDkOiCmMiPoKiNiHiCmNjAfGiLeLiCmJiDeBiDhGiDiKiCkKiLeOjDkOiClDiCoKiCoJiClNiCnP_xHqqkZx_
 *			_xZkqqHx_jGoCjBoIiCmIiCkCiCkKiBeBiDgIiDiJiDgCiDePiBjFiDgIiDiNiDgCiDhGiCmMiPoKiNiHiBeBiKpJjBlGiDeBiDhGiDiKiCmG_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDfOiDeDiDhGiCkKiInJiCmIiCoJiClBiCmGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmO_xHqqkZx_ HistDraw _xZkqqHx_iCmJ_xHqqkZx_ .mdrw _xZkqqHx_iCpAjHiOiCmGiClHiPoKiNiHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CDocument* CFCMolipDrawApp::OpenDocumentFile (LPCTSTR lpszFileName)
{
//----- 06.02.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iMlLiNnNiCmMiDgIiDeMiDiFiDiBiDjDiDgHiCmJiPeDjAlDiDhEiDiJiDePiCkKjHkHiCmBiCmEiCkCiCoJiPoKiNiHiBeBiClBiCmMiCnMiCnM_xHqqkZx_
//	// _xZkqqHx_iPiIjHjNiCpAjBlBiCkPiCoJiCmG_xHqqkZx_OnOpenDocument_xZkqqHx_iCmMjBePiCmJiDfKiBfLiDhFiCmMjGoCiCkCiNiHiCoNiClJiCkKiPgPiCmE_xHqqkZx_
//	// _xZkqqHx_iClFiCnMiCkEiBeCiClBiClBiCmFjFmKiDeFiDeCiDjDiDgIiDeFiCpAiLeOjDkOiClHiCoKiCmOiBeBiClBiCoKiCpAiJpBjEpAiCmFiCkLiCoJiBeC_xHqqkZx_
//	// _xZkqqHx_jFmKiDeFiDeCiDjDiDgIiDeFiCmFiKeKiCkNiCkJiBeI_xHqqkZx_
//	if (g_pDoc != NULL && !g_pDoc->IsClosableTemporaryDocument() &&
//		g_pDoc->GetPathName().CompareNoCase(lpszFileName) != 0)
//	{
//		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpA_xHqqkZx_""_xZkqqHx_iCmFiImNiCnOiBeCiDfIiDhJiBfLiDfIjDpMiCoIiDhEiDeAiDeDiDiLjGlMiCmJjBmOiJjOiBeC_xHqqkZx_
//		WString strParam;
//		strParam.Format(L"\"%s\"", (const wchar_t*)TStrToWStr(lpszFileName));
//		// MolipDraw.exe _xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
//		(void)::ExecMolipDraw(strParam);
//		return NULL;
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
//	return CWinApp::OpenDocumentFile(lpszFileName);
//----- 06.02.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_CHIPEDITOR:		// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
	case FD_APPMODE_ARROWEDITOR:	// _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_jBmOiJjOiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
		return NULL;
	}

	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	const WString wstrFilePathOriginal = TStrToWStr(lpszFileName);
	WString wstrFilePath = wstrFilePathOriginal;
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	switch (g_->appMode & FD_APPMODE_MASK)
//	{
//	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
//	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
//		// _xZkqqHx_iDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiCmNiDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCmJjFoCjAlDiBeC_xHqqkZx_
//		wstrFilePath = FFTableToTopDirPath(wstrFilePath);
//		break;
//	}
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	switch (FFFileNameToFormat(wstrFilePath))
	{
	case FD_DTP_TABLE_DATA_FORMAT:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDgGiBfLiDfOiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddtb)
	case FD_DTP_TABLE_INDEX_FORMAT:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiL_xHqqkZx_ (.ddix)
		// _xZkqqHx_iDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiCmNiDhGiDiNiDfHiDeGiDeOiDgHiDgGiDeCiDiMiDeOiDgHiDiKiCmJjFoCjAlDiBeC_xHqqkZx_
		wstrFilePath = FFTableToTopDirPath(wstrFilePath);
		break;
	}
//----- 06.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iNkBiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCmGjDkPiIoKiCkJiBeI_xHqqkZx_
	BOOL bIsSameAsDocument = FALSE;
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		bIsSameAsDocument = (g_pDoc->GetIsDocumentOpened() &&
							 wstrFilePath.CompareNoCase(TStrToWStr(g_pDoc->GetPathName())) == 0);
		break;
#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		// FD_APPMODE_HISTORYVIEWER(_xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeB_xHqqkZx_)_xZkqqHx_iCmMiPoKiNiHiCmNiBeBjDkPiClGiCmFiCkAiCmBiCmEiCoAjFmKiCmJiKeKiCkNiBeC_xHqqkZx_
		bIsSameAsDocument = (g_pProject->IsProjectOpened() &&
							 wstrFilePath.CompareNoCase(g_pProject->GetFilePath()) == 0);
		break;
#endif//_DD_PRO
	}
	// _xZkqqHx_iNkBiKeKiCkCiCmEiCkCiCoJjFlGiPjBiCmGjDkPiIoKiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (bIsSameAsDocument) return NULL;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiDhEiDeAiDeDiDiLiKgHjCkDiOhBiCkJiCoHiOoGjDlOiBeC_xHqqkZx_
	FTDocumentFormat df = FFFileNameToFormat(wstrFilePath);

	// _xZkqqHx_jDmHiCnNiNjOiCnNiJmCjEfMiCkJiBeI_xHqqkZx_
	BOOL bIsLoadable = FALSE;
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		switch (df)
		{
		case FD_DTP_STANDARD_FORMAT:	// _xZkqqHx_jCmKiPoNiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdrw)
		case FD_DTP_PORTABLE_FORMAT:	// _xZkqqHx_iDhMiBfLiDfOiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdpf)
		case FD_DTP_WORK_FORMAT:		// _xZkqqHx_iDiPiBfLiDeOiDhEiDeIiBfLiDhNiDgCiDgHiCmMjFlGiPjBiBeC_xHqqkZx_(.mdwk)
			// _xZkqqHx_iNkBiCmMjFlGiPjBiCkKjFmCiClGiCoKiCoJiCkJiBeI_xHqqkZx_
			if (g_pDoc->IsClosableTemporaryDocument())
				bIsLoadable = TRUE;
			break;
		}
		break;
#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		switch (df)
		{
		case FD_DTP_PROJECT_FORMAT:		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDgHiDgCiDhGiDgGiDeCiDiMiDeOiDgHiDiK_xHqqkZx_ (.mdpj)
			// _xZkqqHx_iNkBiCmMjFlGiPjBiCkKjFmCiClGiCoKiCoJiCkJiBeI_xHqqkZx_
			if (g_pDoc->IsClosableTemporaryDocument())
				bIsLoadable = TRUE;
			break;
		}
		break;
#endif//_DD_PRO
	}
	if (!bIsLoadable)
	//----- _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmFjDmHiCnNiNjOiCnPiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpA_xHqqkZx_""_xZkqqHx_iCmFiImNiCnOiBeCiDfIiDhJiBfLiDfIjDpMiCoIiDhEiDeAiDeDiDiLjGlMiCmJjBmOiJjOiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCmJiCmNiDeJiDiKiDfHiDgJiDiLiCpAjDgOiClHiClBiCmGiBeC_xHqqkZx_
		// _xZkqqHx_iDgFiBfLiDhFiDiLiDhEiDeAiDeDiDiLiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmFiLeOjDkOiDeBiDhGiDiKiCkKjFmPiCoNiCoJiClNiCnPiBeC_xHqqkZx_
		WString strParam;
		strParam.Format(L"\"%s\"", wstrFilePathOriginal.c_str());
		// MolipDraw.exe _xZkqqHx_iCpAiLeOjDkOiBeC_xHqqkZx_
		(void)::ExecMolipDraw(strParam);
		return NULL;
	}

	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		return CWinApp::OpenDocumentFile(lpszFileName);

#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCpAiKeKiCkNiBeBiCmMiDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(	ID_DREQ_OPEN_PROJECT,
									FCReqBase::PROJECT_PATH, wstrFilePath.c_str(),
									FCReqBase::NONE);
		// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfLiCpAjDkPiKpKiClDiClJiCoJiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT);
		// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeC_xHqqkZx_
		g_pDoc->PushBackDocRequest(ID_DREQ_END);
		// Document_xZkqqHx_jHhGiLiBiCpAiPiIjHjNiBeC_xHqqkZx_
		g_pDoc->ProceedDocRequest();
		break;
#endif//_DD_PRO
	}
	return NULL;
//----- 06.02.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMolipDrawApp::OpenDocumentFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::DoMessageBox
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCpAjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszPrompt
 *			nType
 *			nIDPrompt
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFfMiOkGiClDiCoKiCoJiDiBiDgCiDfKiBfLiDfHiDhLiDgCiDeOiDfIiCmMiMgAiPpDiCpAjFmPiNfIiClHiCoJiClNiCnPiCmJ_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCpAiDeJiBfLiDgPiBfLiDiJiDeDiDgIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.09.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCMolipDrawApp::DoMessageBox (LPCTSTR lpszPrompt, UINT nType, UINT nIDPrompt)
{
	// disable windows for modal dialog
	EnableModeless(FALSE);
	HWND hWndTop;
	HWND hWnd = CWnd::GetSafeOwner_(NULL, &hWndTop);

	// set help context if possible
	DWORD* pdwContext = NULL;
	if (hWnd != NULL)
	{
		// use app-level context or frame level context
		LRESULT lResult = ::SendMessage(hWndTop, WM_HELPPROMPTADDR, 0, 0);
		if (lResult != 0)
			pdwContext = (DWORD*)lResult;
	}
	// for backward compatibility use app context if possible
	if (pdwContext == NULL && this != NULL)
		pdwContext = &m_dwPromptContext;

	DWORD dwOldPromptContext = 0;
	if (pdwContext != NULL)
	{
		// save old prompt context for restoration later
		dwOldPromptContext = *pdwContext;
		if (nIDPrompt != 0)
			*pdwContext = HID_BASE_PROMPT+nIDPrompt;
	}

	// determine icon based on type specified
	if ((nType & MB_ICONMASK) == 0)
	{
		switch (nType & MB_TYPEMASK)
		{
		case MB_OK:
		case MB_OKCANCEL:
			nType |= MB_ICONEXCLAMATION;
			break;

		case MB_YESNO:
		case MB_YESNOCANCEL:
			nType |= MB_ICONEXCLAMATION;
			break;

		case MB_ABORTRETRYIGNORE:
		case MB_RETRYCANCEL:
			// No default icon for these types, since they are rarely used.
			// The caller should specify the icon.
			break;
		}
	}

#ifdef _DEBUG
	if ((nType & MB_ICONMASK) == 0)
		TRACE0("Warning: no icon specified for message box.\n");
#endif

	TCHAR szAppName[_MAX_PATH];
	LPCTSTR pszAppName;
	if (this != NULL)
		pszAppName = m_pszAppName;
	else
	{
		pszAppName = szAppName;
		GetModuleFileName(NULL, szAppName, _MAX_PATH);
	}

//----- 03.09.16 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	int nResult =
//		::MessageBox(hWnd, lpszPrompt, pszAppName, nType);
//----- 03.09.16 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	int nResult =
		::FFMessageBox(TStrToWStr(lpszPrompt), TStrToWStr(pszAppName), nType);
//----- 03.09.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// restore prompt context if possible
	if (pdwContext != NULL)
		*pdwContext = dwOldPromptContext;

	// re-enable windows
	if (hWndTop != NULL)
		::EnableWindow(hWndTop, TRUE);
	EnableModeless(TRUE);

	return nResult;
} // CFCMolipDrawApp::DoMessageBox.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OnIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgIiDiLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMolipDrawApp::OnIdle (LONG lCount)
{
//	TRACE(_T("CFCMolipDrawApp::OnIdle\n"));
	// OnIdle_xZkqqHx_iOjOiCmJjCmKjCgNiCpAiOpDiCkPiOoGiCoJiDeFiDeCiDjDiDgIiDeFiDiKiDfIiDgHiBeC_xHqqkZx_
	// _xZkqqHx_jFeLiClI_xHqqkZx_ PostMessage_xZkqqHx_iCmFiCmNiCmIiCkN_xHqqkZx_SendMessage _xZkqqHx_iCpAiOgHiCkEiClBiCmGiBeC_xHqqkZx_
	// PostMessage _xZkqqHx_iCpAiOgHiCkEiCmG_xHqqkZx_CPU_xZkqqHx_jAoIjHeMjHkGiCkKjClFiCmLiPoDiCkKiCoJiBeC_xHqqkZx_
	set<HWND>::const_iterator iHwn;
	for (iHwn = m_stOnIdleWindow.begin(); iHwn != m_stOnIdleWindow.end(); iHwn++)
		::SendMessage(*iHwn, WM_USER_ON_IDLE, 0, 0);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return CWinApp::OnIdle(lCount);
} // CFCMolipDrawApp::OnIdle.

//----- 03.09.19 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::AddToRecentFileList
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MRU _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_ _xZkqqHx_iDiKiDfIiDgHiCmJ_xHqqkZx_ lpszPathName _xZkqqHx_iCpAjCmHiJmBiClFiCnMiClHiBeCiDeJiBfLiDgPiBfLiDiJiDeDiDgIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpszPathName	:_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::AddToRecentFileList (LPCTSTR lpszPathName)
//{
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	CWinApp::AddToRecentFileList(lpszPathName);
//	// _xZkqqHx_iNmFiLnPiCmMiDhEiDeAiDeDiDiLiDiKiDfIiDgHiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiPgPiClFiBeBjBlMiDeBiDhGiDiKiCmJjCmKjCgNiBeC_xHqqkZx_
//	WriteRecentFileList();
//} // CFCMolipDrawApp::AddToRecentFileList.
//----- 03.09.19 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OnHelpMolipHomepage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhKiBfLiDiAiDhJiBfLiDfHjFfMiOkGiBhGiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::OnHelpMolipHomepage ()
{
	// _xZkqqHx_iDeDiDjDiDfOiBfLiDgMiDgCiDgHiCmJjAnKjBlBiClFiCnMiClHiCkJiBeI_xHqqkZx_
	if (FFMessageBox(IDS_MSG_IS_CONNECT_INTERNET, 0, MB_OKCANCEL) == IDOK)
		ShellExecute(0, _T("open"), FFLoadString(IDS_SUPPORT_URL), NULL, NULL, SW_SHOW);
} // CFCMolipDrawApp::OnHelpMolipHomepage.

// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiOmAiNhDiClHiCoJiClNiCnPiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_
void CFCMolipDrawApp::OnAppAbout ()
{
	CFCAboutDlg aboutDlg;
	aboutDlg.DoModal();
} // CFCMolipDrawApp::OnAppAbout.

//----- 02.08.22 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (Softalive_xZkqqHx_iNeMiNjAiCpA_xHqqkZx_HP_xZkqqHx_iCnGiInKiClH_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OnHelpAdvertise0
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiBhJ_xHqqkZx_ IT_xZkqqHx_iKnGjIeBiCmMiOgEiOjGiCpAiCkIjCfEiClFiCmFiClHiCkJiBeI_xHqqkZx_ _xZkqqHx_iBhKiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.10.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::OnHelpAdvertise0 ()
//{
//	WinHelp(0x10000 + ID_HELP_ADVERTISE_0);
//} // CFCMolipDrawApp::OnHelpAdvertise0.
//----- 02.08.22 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (Softalive_xZkqqHx_iNeMiNjAiCpA_xHqqkZx_HP_xZkqqHx_iCnGiInKiClH_xHqqkZx_)-----

//----- 06.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OnHelpMovie
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDiAiBfLiDhCiBfLiDhHiDiLiDhGiBhGiCkJiCoHiOmAiNhDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMolipDrawApp::OnHelpMovie ()
//{
//	//----- _xZkqqHx_iLeOjDkOiDhAiDiJiDiBiBfLiDfOiCmMjFlGiOjKjHpBiCpAiNoMiCoJ_xHqqkZx_ -----
//	// DynamicDraw.HLP_xZkqqHx_iCmMjBlGiNnNiClHiCoJiDhAiDfIiCpAiOoGiCoIiPgPiClHiBeCiDhAiDfIiNmFiMoDiCmJ_xHqqkZx_"\"_xZkqqHx_iCkKjFhEiCkCiCmEiCkCiCoJiBeC_xHqqkZx_
////----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	WString strDirPath;
////	FFSplitFileName(&strDirPath, NULL, NULL, TStrToWStr(FFGetApp()->m_pszHelpFilePath));
////----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	WString strDirPath = FFGetFileDirectory(TStrToWStr(FFGetApp()->m_pszHelpFilePath));
////----- 03.12.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhAiDiJiDiBiBfLiDfOiNoMjAkMiBeCiDhEiDeAiDeDiDiLjGlMiCmN_xHqqkZx_""_xZkqqHx_iCmFiImNiCnOiBeCiDfIiDhJiBfLiDfIjDpMiCoIiDhEiDeAiDeDiDiLjGlMiCmJjBmOiJjOiBeC_xHqqkZx_
//	WString strHelpPath;
//	strHelpPath.Format(L"%sMolipMovie.HLP", (const wchar_t*)strDirPath);
//	::WinHelp(AfxGetMainWnd()->GetSafeHwnd(), WStrToTStr(strHelpPath), HELP_FINDER, 0);
//} // CFCMolipDrawApp::OnHelpMovie.
//----- 06.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMolipDrawApp::OnFileOpen
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ID_FILE_OPEN _xZkqqHx_iDfCiDhNiDjDiDgIiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBhGiCmFiBeBiNkBiKeKiCkCiCmEiCkCiCoJiDhEiDeAiDeDiDiLiCmGjDkPiClG_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDiLiDfPiCmMiDhEiDeAiDeDiDiLiCpAjCfEiClFiCmJiNhDiCkJiCmIiCkCiClNiCnPiBeBiClBiCmMiKnGjAjEiCpAiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMolipDrawApp::OnFileOpen ()
{
//	AfxDebugBreak();
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAiNoMjAkMiBeC_xHqqkZx_
	FCFdbOpenDdFile dlgFile;
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiDiKiDfIiDgHiCmMiDiMiDfHiDfIiDgHiDiKiCpAjAnNjCoIiBeC_xHqqkZx_
	dlgFile.SetRegName(L"OPEN");
//----- 06.10.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfOiDeDiDgHiDiLjGlMiCmMjAnNjCoIiBeC_xHqqkZx_
	// AFX_IDS_OPENFILE = "_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiKeKiCkN_xHqqkZx_"
	CString	strMsg;
	strMsg.LoadString(AFX_IDS_OPENFILE);
	dlgFile.m_ofn.lpstrTitle = strMsg;
	CString strFilter;
	FFGetFileDialogFilterString(strFilter, FALSE);
	dlgFile.m_ofn.lpstrFilter = strFilter;

	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeCiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	if (dlgFile.DoModal() != IDOK) return;

//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!FFIsFileExist(TStrToWStr(dlgFile.GetPathName())))
//	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// IDS_MSG_FILE_NOT_EXIST_IS_CREATE =
//		// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjBlGiNnNiClFiCnMiClJiCpBiBeCiNoMjAkMiClFiCnMiClHiCkJiBeI_xHqqkZx_
//		if (FFMessageBox(FormatResString(IDS_MSG_FILE_NOT_EXIST_IS_CREATE, 
//									(const wchar_t*)TStrToWStr(dlgFile.GetPathName())),
//						NULL, MB_YESNO) != IDYES)
//		//----- NO _xZkqqHx_iDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			return;
//		}
//		//----- YES _xZkqqHx_iDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
//		// _xZkqqHx_iLpDiCmMiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
//		CFile(dlgFile.GetPathName(),
//			CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite);
//	}
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	switch (FFIsThereFile(dlgFile.GetPathName()))
	{
	case FD_FILE_NOT_EXIST:			// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjBlGiNnNiClFiCmIiCkCiBeC_xHqqkZx_
		// IDS_MSG_FILE_NOT_EXIST_IS_CREATE =
		// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiBhF_xHqqkZx_%s_xZkqqHx_iBhGiCmNjBlGiNnNiClFiCnMiClJiCpBiBeCiNoMjAkMiClFiCnMiClHiCkJiBeI_xHqqkZx_
		if (FFMessageBox(FormatResString(IDS_MSG_FILE_NOT_EXIST_IS_CREATE, 
									(const wchar_t*)dlgFile.GetPathName()),
						NULL, MB_YESNO) != IDYES)
		//----- NO _xZkqqHx_iDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			return;
		}
		//----- YES _xZkqqHx_iDhLiDfOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
		// _xZkqqHx_iLpDiCmMiDhEiDeAiDeDiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
//----- 03.11.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		CFile(dlgFile.GetPathName(),
//				CFile::modeCreate | CFile::modeWrite | CFile::shareDenyWrite);
//----- 03.11.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FCFile32(dlgFile.GetPathName(), 0, 0, CREATE_NEW);
//----- 03.11.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		break;
	case FD_FILE_32:		// 32_xZkqqHx_iDhCiDgCiDgHiDhEiDeAiDeDiDiLiBgJjCmKiPoNiDhEiDeAiDeDiDiLiBgKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
		break;
	default:
		// case FD_FILE_DIRECTORY:	// _xZkqqHx_iDgGiDeCiDiMiDeOiDgHiDiKiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iDhEiDeAiDeDiDiLiMgAiOkOiCkKiIoBiCkCiCnMiClHiBeC_xHqqkZx_
		FFThrowDDFileException(IDS_ERR_FILE_WRONG_FORM, dlgFile.GetPathName());
		break;
	}
//----- 03.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
	OpenDocumentFile(WStrToTStr(dlgFile.GetPathName()));
} // CFCMolipDrawApp::OnFileOpen.


/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDiPoOjFpBiCmFiOgHiCoNiCoKiCoJ_xHqqkZx_ CFCAboutDlg _xZkqqHx_iDfPiDeDiDeBiDiNiDePiBeC_xHqqkZx_

CFCAboutDlg::CFCAboutDlg ()
		: BASE_CLASS(CFCAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CFCAboutDlg)
	//}}AFX_DATA_INIT
} // CFCAboutDlg::CFCAboutDlg.

void CFCAboutDlg::DoDataExchange (CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCAboutDlg)
	//}}AFX_DATA_MAP
} // CFCAboutDlg::DoDataExchange.

BEGIN_MESSAGE_MAP(CFCAboutDlg, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCAboutDlg::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMiPiJiKpKiJlLiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.02 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCAboutDlg::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
//----- 00.12.31 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	FFJustifyWindow(m_hWnd);
//----- 00.12.31 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiDfOiDeDiDgHiDiLjFlGiOjKjHpBiCpAjFmPiNfIiBeC_xHqqkZx_
	// IDS_MSG_VERSION_INFO = "%s _xZkqqHx_iCmMiDgPiBfLiDfHiDiHiDjDiPoOjFpB_xHqqkZx_"
	FFSetWindowText(this, FormatResString(IDS_MSG_VERSION_INFO, ::GetLocalAppName()));
	// _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiDfPiDeDiDeBiDiNiDePjCiGiDfCiDjDiDgHiDiNiBfLiDiLiCmJjFfMiOkGiBeC_xHqqkZx_
	FFSetDlgItemText(this, IDC_ABT_STC_APP_NAME, ::GetLocalAppName());
	// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCpAiDfPiDeDiDeBiDiNiDePjCiGiDfCiDjDiDgHiDiNiBfLiDiLiCmJjFfMiOkGiBeC_xHqqkZx_
	FFSetDlgItemText(this, IDC_ABT_STC_VERSION, FCHeaderInf::GetStcAppVersionString());

	CStatic* pStcIcon = (CStatic*)GetDlgItem(IDC_ABT_STC_APP_ICON);
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// MolipDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		pStcIcon->SetIcon(FFGetApp()->LoadIcon(IDR_MAINFRAME));
		break;
	case FD_APPMODE_CHIPEDITOR:	// _xZkqqHx_iDgAiDgCiDhGiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
		pStcIcon->SetIcon(FFGetApp()->LoadIcon(IDR_CHIP_EDIT));
		break;
	case FD_APPMODE_ARROWEDITOR:	// _xZkqqHx_iDeBiDiNiBfLiDeHiDgGiDeCiDfOiCmMiPoKiNiHiBeC_xHqqkZx_
		pStcIcon->SetIcon(FFGetApp()->LoadIcon(IDR_ARROW_EDIT));
		break;
#ifdef _DD_PRO
	case FD_APPMODE_HISTORICDRAW:	// HistoricDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		pStcIcon->SetIcon(FFGetApp()->LoadIcon(IDR_HIST_DRAW));
		break;
	case FD_APPMODE_HISTORYVIEWER:	// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiDeBiCmMiPoKiNiHiBeC_xHqqkZx_
		pStcIcon->SetIcon(FFGetApp()->LoadIcon(IDR_HIST_VIEW));
		break;
#endif//_DD_PRO
	}
	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCAboutDlg::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetApp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMolipDrawApp* FFGetApp ()
{
	return &theApp;
} // FFGetApp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanBasicOperate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Dynamic Draw_xZkqqHx_iCmMiKoOjGhLjDeJiCmIiDeJiDhJiDiMiBfLiDfGiDiHiDjDiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhBiDfIiDgHiDiKiDgCiDeOiDhCiDiFiBfLiDeBiBeBiDhBiDfIiDgHiDiKiDgCiDeOiDgIiDiNiBfLiCmMiPoKiNiHiBeBiDgIiDeMiDiFiDiBiDjDiDgH_xHqqkZx_
 *			_xZkqqHx_jHhGiLiBiCkKiPiIjHjNiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiDeJiDhJiDiMiBfLiDfGiDiHiDjDjFhDiJmCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanBasicOperate ()
{
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCmMiPiIjHjNiDiLiBfLiDhGjCiGiCmMiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHjHhGiLiBiCkKjAmPiCnMiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCmFiCmNiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
	if (g_pDoc->IsDoingDocRequest()) return FALSE;
	if (g_pDoc->IsThereExcludeDocRequest(ID_DREQ_FLUSH_ALL,
										 ID_DREQ_SYNC_HIVIEW_TO_DOCUMENT,
										 ID_DREQ_END,
										 ID_DREQ_SAVE_SPOT_FILE,
										 ID_DREQ_UPDATE_PROJECT)) return FALSE;
	return TRUE;
} // FFCanBasicOperate.

#ifdef _DD_PRO
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanEditProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkKjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanEditProject ()
{
	if (!FFCanBasicOperate()) return FALSE;
	if (g_pProject == NULL) return FALSE;
	if (!g_pProject->IsProjectOpened()) return FALSE;
	if (!g_pProject->IsQualifiedToModify(FFGetApp()->GetUserId())) return FALSE;
	return TRUE;
} // FFCanEditProject.
#endif//_DD_PRO

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanEditDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiCkKjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanEditDocument ()
{
	if (!FFCanBasicOperate()) return FALSE;
	if (!g_pDoc->GetIsDocumentOpened()) return FALSE;
	if (g_pDoc->IsReadOnly()) return FALSE;
#ifdef _DD_PRO
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiGiBfLiDfFiDiBiDjDiDgPiBfLiCmFiCmNjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
	if (g_pProject != NULL &&
		g_pProject->IsProjectOpened())
	{
		if (!g_pProject->IsQualifiedToModify(FFGetApp()->GetUserId())) return FALSE;
	}
#endif//_DD_PRO
	return TRUE;
} // FFCanEditDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanEditObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanEditObject ()
{
	if (!FFCanEditDocument()) return FALSE;
	// _xZkqqHx_jBePjGmKiCmMiCoKiCoCiBfLiCkKjFnCiPfHiCkJiCmMiCkEiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
	if (g_pDoc->FirstFrontLayerIdx(g_pDoc->GetCurrentLayerIdx(), FDOZ_ON_EDIT) == DWORD(-1)) return FALSE;
	return TRUE;
} // FFCanEditObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanCreateObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiNoMjAkMiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanCreateObject ()
{
	if (!FFCanEditObject()) return FALSE;
	if (g_pDoc->IsOleDocumentsOpened()) return FALSE;
	if (g_pView->GetCurrentTool()->IsEditingText()) return FALSE;
	return TRUE;
} // FFCanCreateObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanEditDocumentEnv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJgFiCmMjClHiClDiBeBjDgPjIfOjAeGjDjJiBeBjFlGiPjBiCmJiLeMjIfOiClDiCoKiCoJiKmCiLkLiCkKjFmPiNfIiJmCjEfMiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanEditDocumentEnv ()
{
	if (!FFCanEditDocument()) return FALSE;
	if (g_pDoc->IsOleDocumentsOpened()) return FALSE;
	if (g_pView->GetCurrentTool()->IsEditingText()) return FALSE;
	return TRUE;
} // FFCanEditDocumentEnv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanEditReadOnlyDocumentEnv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ReadOnly_xZkqqHx_iCmMjFlGiPjBiCkKjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFlGiPjBiCkK_xHqqkZx_ReadOnly_xZkqqHx_iCmMiPoKiNiHiCmFiCoAiBeBiIoKjFjEiPeDjAlDiJmCjEfMiCmIiLeAjEfMiBgJiDiMiDeDiDiEiBfLjFmPiNfIjDjJiBgK_xHqqkZx_
 *			_xZkqqHx_iCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanEditReadOnlyDocumentEnv ()
{
	switch (g_->appMode & FD_APPMODE_MASK)
	{
	case FD_APPMODE_DYNAMICDRAW:	// DynamicDraw_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
	case FD_APPMODE_HISTORYVIEWER:	// HistoryViewer_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
		if (!FFCanBasicOperate()) return FALSE;
		if (!g_pDoc->GetIsDocumentOpened()) return FALSE;
		if (g_pDoc->IsOleDocumentsOpened()) return FALSE;
		if (g_pView->GetCurrentTool()->IsEditingText()) return FALSE;
		break;
	default:
		if (!FFCanEditDocumentEnv()) return FALSE;
	}
	return TRUE;
} // FFCanEditReadOnlyDocumentEnv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanEditSelected
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKjFmPiNfIiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanEditSelected ()
{
	if (!FFCanEditDocument()) return FALSE;
	if (g_pDoc->IsOleDocumentsOpened()) return FALSE;
	if (g_pView->GetCurrentTool()->IsEditingText()) return FALSE;

	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjFjEjFgJiCkKiCkAiCoJiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
	if (g_pView->SelectObjVector().empty()) return FALSE;
// 06.11.21 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkKjBkOiClHiCoJiDiMiDeDiDiEiBfLiCkKiBeBiIoKiCmCiCmFiCoAjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkKjBkOiClHiCoJiDiMiDeDiDiEiBfLiCkKiBeBjBfDiCmEjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	if (!g_pView->CanEditSelectObject()) return FALSE;
	return TRUE;
} // FFCanEditSelected.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanEditText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCkKjFnCiPfHiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFCanEditText ()
{
// 05.10.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	if (!FFCanBasicOperate()) return FALSE;
	return TRUE;
} // FFCanEditText.

//----- 05.10.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCanChangeView
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhCiDiFiBfLiBgJjFfMiOkGjHnOiBgKiCkKjFmPiNfIiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FFCanChangeView ()
//{
//	return (g_pDoc->GetIsDocumentOpened() &&
//			g_pDoc->IsCurrentSheetReady() &&
//			!g_pDoc->IsOleDocumentsOpened() &&
//			!g_pView->GetCurrentTool()->IsEditingText());
//} // FFCanChangeView.
//----- 05.10.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsSheetReady
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfGiBfLiDgHiCkKiBeBjBfDiCmEiPiAjEpFiCkKjAkOiCmBiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iDfGiBfLiDgHiCpAiIpDiNpMiClHiCoJiPoKiNiHiBeBiDfGiBfLiDgHiCpAiInKjDkOiClHiCoJiPoKiNiHiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFIsSheetReady ()
{
	if (!FFCanBasicOperate()) return FALSE;
	if (!g_pDoc->GetIsDocumentOpened()) return FALSE;
	if (g_pDoc->IsOleDocumentsOpened()) return FALSE;
	if (g_pView->GetCurrentTool()->IsEditingText()) return FALSE;
	if (!g_pDoc->IsCurrentSheetReady()) return FALSE;
	return TRUE;
} // FFIsSheetReady.
//----- 05.10.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

static void myGetZoomList (const long*& pZoomList, long& lZoomListCount, DWORD dwCtrlId)
{
	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_ID_VIEW_CMB_ZOOM_xZkqqHx_iCmMiDfJiBfLiDiAiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiIoKjHjHiBeC_xHqqkZx_
	// _xZkqqHx_iDeMiDiDiDjDiDgPiDfI_xHqqkZx_(DynamicDrawView)_xZkqqHx_iCmMiDfJiBfLiDiAiIoKjHjHiBeC_xHqqkZx_
	static long s_ZoomViewDefault[] =
	{
		10,
		25,
		50,
		60,
		70,
		80,
		90,
		100,
		110,
		120,
		130,
		150,
		200,
		400,
		800,
		1600,
		3200,
		6400,
	};

	// _xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmM_xHqqkZx_ID_HTREE_CMB_ZOOM_xZkqqHx_iCmMiDfJiBfLiDiAiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiIoKjHjHiBeC_xHqqkZx_
	// _xZkqqHx_jHjKjHpAiNfMjBkCiDhCiDiFiBfL_xHqqkZx_(CFCWndHistoryTree)_xZkqqHx_iCmMiDfJiBfLiDiAiIoKjHjHiBeC_xHqqkZx_
	static long s_ZoomHtreeDefault[] =
	{
		10,
		25,
		50,
		60,
		70,
		80,
		90,
		100,
		110,
		120,
		130,
		150,
		200,
		400,
		800,
		1600,
		3200,
		6400,
	};

	switch (dwCtrlId)
	{
	case ID_VIEW_CMB_ZOOM:
		pZoomList = s_ZoomViewDefault;
		lZoomListCount = sizeof(s_ZoomViewDefault) / sizeof(s_ZoomViewDefault[0]);
		break;
	case ID_HTREE_CMB_ZOOM:
		pZoomList = s_ZoomHtreeDefault;
		lZoomListCount = sizeof(s_ZoomHtreeDefault) / sizeof(s_ZoomHtreeDefault[0]);
		break;
	default:
		ASSERT(FALSE);
		pZoomList = NULL;
		lZoomListCount = 0;
	}
} // myGetZoomList.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetZoomListValue
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDfJiBfLiDiAiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmJjAnNjCoIiClDiCoKiCoJiDfJiBfLiDiAjCgMiCmMiIoKjHjHiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfJiBfLiDiAjCgMiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCtrlId:_xZkqqHx_iDfJiBfLiDiAiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndex	:_xZkqqHx_iDiKiDfIiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiBeCjCfAiImKiCmN_xHqqkZx_%_xZkqqHx_iBeCiDeDiDjDiDgGiDgCiDeOiDfIiCkKjGlDiMpIiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFGetZoomListValue (DWORD dwCtrlId, long lIndex)
{
	const long* pZoomList;
	long lZoomListCount;
	myGetZoomList(pZoomList, lZoomListCount, dwCtrlId);
	if (lIndex < 0 || lZoomListCount <= lIndex) return -1;
	return pZoomList[lIndex];
} // FFGetZoomListValue.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetZoomListCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDgPiBfLiCmMiDfJiBfLiDiAiDiKiDfIiDgHiDhLiDgCiDeOiDfIiCmJjAnNjCoIiClDiCoKiCoJiDfJiBfLiDiAjCgMiCmMiIoKjHjHiCmM_xHqqkZx_
 *			_xZkqqHx_jAjEiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCtrlId:_xZkqqHx_iDfJiBfLiDiAiCmMiDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfJiBfLiDiAjCgMiCmMjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFGetZoomListCount (DWORD dwCtrlId)
{
	const long* pZoomList;
	long lZoomListCount;
	myGetZoomList(pZoomList, lZoomListCount, dwCtrlId);
	return lZoomListCount;
} // FFGetZoomListCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetLowerZoomValue
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfJiBfLiDiAjCgMiCoGiCoIiBeBiIoKiCmCiPkMiClDiCkCiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lValue	:_xZkqqHx_iMlLiNnNiCmMiDfJiBfLiDiAjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCiDfJiBfLiDiAjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lValue_xZkqqHx_iCmNiBeBiDiKiDfIiDgHiCmMjHhGjBgGiCmGiIoKjChGiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFGetLowerZoomValue (DWORD dwCtrlId, long lValue)
{
	const long* pZoomList;
	long lZoomListCount;
	myGetZoomList(pZoomList, lZoomListCount, dwCtrlId);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const long* pZoomItem = lower_bound(pZoomList, pZoomList + lZoomListCount, lValue);
//	if (pZoomItem == pZoomList) return pZoomList[0];
//	if (pZoomItem == pZoomList + lZoomListCount) return pZoomList[lZoomListCount - 1];
//	pZoomItem--;
//	return *pZoomItem;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return FFGetSmallerItemFromList(lValue, pZoomList, lZoomListCount);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFGetLowerZoomValue.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetUpperZoomValue
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfJiBfLiDiAjCgMiCoGiCoIiBeBiIoKiCmCjBoFiCkLiCkCiDfJiBfLiDiAjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lValue	:_xZkqqHx_iMlLiNnNiCmMiDfJiBfLiDiAjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfGiClFiCkCiDfJiBfLiDiAjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	lValue_xZkqqHx_iCmNiBeBiDiKiDfIiDgHiCmMjHhGjBgGiCmGiIoKjChGiClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FFGetUpperZoomValue (DWORD dwCtrlId, long lValue)
{
	const long* pZoomList;
	long lZoomListCount;
	myGetZoomList(pZoomList, lZoomListCount, dwCtrlId);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const long* pZoomItem = upper_bound(pZoomList, pZoomList + lZoomListCount, lValue);
//	if (pZoomItem == pZoomList + lZoomListCount) return pZoomList[lZoomListCount - 1];
//	return *pZoomItem;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return FFGetLargerItemFromList(lValue, pZoomList, lZoomListCount);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FFGetUpperZoomValue.

