#include "stdafx.h"
#include <algorithm>		// For find template.
#include "resource.h"		// For IDS_STANDARD_UNIT.
#include "UtilFile.h"		// For WriteStream.etc.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/**********************************************************************
 *                      FDM_TRACE _xZkqqHx_iCmMjCoIiLgA_xHqqkZx_
 *
 * FDM_TRACE _xZkqqHx_iCmNiBeBiKnGjAjEiCmMiOmAiNhDiCpAiDgHiDiMiBfLiDfIiClFiBeBiDhEiDeAiDeDiDiLiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 * A_xZkqqHx_iDfOiDeDiDhGiCmG_xHqqkZx_B_xZkqqHx_iDfOiDeDiDhGiCkKiCkAiCoJiBeC_xHqqkZx_
 * A_xZkqqHx_iDfOiDeDiDhGiCmN_xHqqkZx_DdTracer.exe_xZkqqHx_iCmJiDgHiDiMiBfLiDfIiPoOjFpBiCpAjBjHjFhEiClHiCoJiBeCjBkMjDhIiCkKjBkMiCkCiCkKiBeB_xHqqkZx_
 * _xZkqqHx_iPoOjFpBjBjHjFhEiCmJ_xHqqkZx_SendMessage_xZkqqHx_iCpAiOgHiCkEiClNiCnPiBeBiDiBiDgCiDfKiBfLiDfHiKnGjIeBiCmFiIoBiCkCiCkKiPgPiCoJ_xHqqkZx_
 * _xZkqqHx_iJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
 * B_xZkqqHx_iDfOiDeDiDhGiCmNiBeB_xHqqkZx_DynamicDraw.exe_xZkqqHx_jGhLjBmMiCmFiDiNiDePiCpAjFnLjBlGiClHiCoJiBeCjBkMjDhIiCkKjChIiCkCiBeC_xHqqkZx_
 *
 * A_xZkqqHx_iDfOiDeDiDhGiOoIiPiH_xHqqkZx_
 * 1. MkFdmTrace.pl _xZkqqHx_iCmFjBfDiKnGjAjEiCmMiNmFiPiJiCmJ_xHqqkZx_FDM_TRACE _xZkqqHx_iCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 * 2. _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAnNjCoIiCmFiBeB_xHqqkZx__FDTRACE_A _xZkqqHx_iCpAjCoIiLgAiBeC_xHqqkZx_
 * 3. _xZkqqHx_iDhCiDiLiDgIiClHiCoJiBeC_xHqqkZx_
 * 4. DdTracer.exe_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
 * 5. DynamicDraw.exe_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
 * 6. DynamicDraw.exe_xZkqqHx_iCpAjBiAiNoMiClFiCmEiPeJjHlJiBeC_xHqqkZx_
 * 7. DdTracer.exe_xZkqqHx_iCmF_xHqqkZx_Save_xZkqqHx_iDhLiDfOiDjDiCpAiJjPiClFiCmEiDiNiDePiCpAjFnLjBlGiBeC_xHqqkZx_
 *
 * B_xZkqqHx_iDfOiDeDiDhGiOoIiPiH_xHqqkZx_
 * 1. MkFdmTrace.pl _xZkqqHx_iCmFjBfDiKnGjAjEiCmMiNmFiPiJiCmJ_xHqqkZx_FDM_TRACE _xZkqqHx_iCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 * 2. _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMjAnNjCoIiCmFiBeB_xHqqkZx__FDTRACE_B _xZkqqHx_iCpAjCoIiLgAiBeC_xHqqkZx_
 * 3. _xZkqqHx_iDhCiDiLiDgIiClHiCoJiBeC_xHqqkZx_
 * 4. DynamicDraw.exe_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
 * 5. DynamicDraw.exe_xZkqqHx_iCpAjBiAiNoMiClFiCmEiBeBiDiNiDePiCpAjFnLjBlGiClFiPeJjHlJiBeC_xHqqkZx_
 **********************************************************************/
#if defined(_FDTRACE_A)

#include "../DdTracer/DdTracerExport.h"

static DdTracer* GetDdTracer ()
{
	static DdTracer s_ddTracer;
	return &s_ddTracer;
}

static void myTraceS (const _TCHAR* f, long l, const _TCHAR* s)
{
	if (AfxGetMainWnd() == NULL || AfxGetMainWnd()->m_hWnd == NULL)
		return;
	char szBuff[2048];
	if (s != NULL)
		sprintf(szBuff, "%s(%d):%s\n", f, l, s);
	else
		sprintf(szBuff, "%s(%d):\n", f, l);
	GetDdTracer()->Write(szBuff);
} // myTraceS.

void FFTrace (const _TCHAR* f, long l)
{
	myTraceS(f, l, NULL);
} // FFTrace.

void FFTraceM (const _TCHAR* f, long l, const _TCHAR* tcpForm, ...)
{
	_TCHAR szBuff[2048];
	va_list argList;
	va_start(argList, tcpForm);
	_vstprintf(szBuff, tcpForm, argList);
	va_end(argList);
	myTraceS(f, l, szBuff);
}

void FFTraceInc ()
{
}

void FFTraceDec ()
{
}

#elif defined(_FDTRACE_B)

#include <io.h>			// for _tcreat.
#include <sys/stat.h>	// For _S_IREAD,_S_IWRITE.

class FCTrace
{
public:
	FCTrace ();
	~FCTrace ();
	void	Trace (const _TCHAR* f, long l, const _TCHAR* s);
	void	IncIndent ();
	void	DecIndent ();
protected:
	void	Open ();

protected:
	int		m_fhTrace;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgOiDjDiDgIiDiLiBeC_xHqqkZx_
	CString	m_strPath;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiBeCiKgHjCkDiOhB_xHqqkZx_(.txt)_xZkqqHx_iCpAiPjMiCkNiBeC_xHqqkZx_
	int		m_iFileId;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCmMiMoDiCoLiCmJjFhEiCkPiCoJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	int		m_iLine;	// _xZkqqHx_iLeMjDpMiNmPiCnNiNhDjAjEiBeC_xHqqkZx_
	int		m_iIndent;	// _xZkqqHx_iDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_

public:
	FCAutoDeleteCriticalSection m_csAuto;
}; // class FCTrace.

FCTrace::FCTrace ()
{
	// -2 _xZkqqHx_iCpAiPiJiKpKjCgMiCmJiBeC_xHqqkZx_
	m_fhTrace = -2;
	m_iFileId = 0;
	m_iLine = 0;
	m_iIndent = 0;	// _xZkqqHx_iDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
} // FCTrace::FCTrace.

FCTrace::~FCTrace ()
{
	if (0 <= m_fhTrace) _close(m_fhTrace);
	// -3 _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_-2 _xZkqqHx_iCpAjAnNjCoIiClHiCoJiCmGiBeBiDgGiDfIiDgHiDiJiDeOiDfOiOmAiNhDiMoDiCmJ_xHqqkZx_
	// FCTRACE_xZkqqHx_iCkKiOmAiNhDiClDiCoKiBeBiDhEiDeAiDeDiDiLiCmMiPjBiCkLiNjOiCnNiCkKiOmAiNhDiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	m_fhTrace = -3;
} // FCTrace::~FCTrace.

void FCTrace::Trace (const _TCHAR* f, long l, const _TCHAR* s)
{
	if (m_fhTrace == -2 &&
		AfxGetApp() != NULL &&
		AfxGetApp()->m_hInstance != NULL)
	{
		m_fhTrace = -3;
		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiNoMjAkMiBeC_xHqqkZx_
		CFileDialog dlgFile(FALSE, _T(".txt"), _T("DD3_log.txt"),
							OFN_HIDEREADONLY|OFN_NOCHANGEDIR,
							_T("Trace File (*.txt)|*.txt||"));
		// _xZkqqHx_iDfOiDeDiDgHiDiLjGlMiCmMjAnNjCoIiBeC_xHqqkZx_
		dlgFile.m_ofn.lpstrTitle = _T("Trace File");
		// _xZkqqHx_iDhHiDiLiDhGiDhLiDfOiDjDiCpAiPmBiLiOiBeC_xHqqkZx_
		dlgFile.m_ofn.Flags &= ~OFN_SHOWHELP;
		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfPiDeDiDeBiDiNiDePiCpAjFfMiOkGiBeC_xHqqkZx_
		if (dlgFile.DoModal() == IDCANCEL) return;
		m_strPath = dlgFile.GetPathName();
		// _xZkqqHx_iKgHjCkDiOhB_xHqqkZx_.txt_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
		m_strPath.Delete(m_strPath.GetLength() - 4, 4);
		// _xZkqqHx_iDeJiBfLiDhGiDjDiPiIjHjNiBeC_xHqqkZx_
		Open();
	}
	if (10000 < m_iLine)
	{
		// _xZkqqHx_iDeJiBfLiDhGiDjDiPiIjHjNiBeC_xHqqkZx_
		Open();
		m_iLine = 0;
	}
	if (0 <= m_fhTrace)
	{
		_TCHAR szBuff[2048];
		for (int iC = 0; iC != m_iIndent; iC++)
			szBuff[iC] = _T(' ');
		if (s != NULL)
			_stprintf(szBuff + m_iIndent, _T("%s(%d):%s\n"), f, l, s);
		else
			_stprintf(szBuff + m_iIndent, _T("%s(%d):\n"), f, l);
		_write(m_fhTrace, szBuff, _tcslen(szBuff) * sizeof(_TCHAR));
		_commit(m_fhTrace);
		m_iLine++;
	}
} // FCTrace::Trace.

void FCTrace::IncIndent ()
{
	m_iIndent++;
} // FCTrace::IncIndent.

void FCTrace::DecIndent ()
{
	m_iIndent--;
} // FCTrace::DecIndent.

void FCTrace::Open ()
{
	// _xZkqqHx_iKpJjBlGiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
	if (0 <= m_fhTrace)
		_close(m_fhTrace);
	CString strPath;
	m_iFileId++;
	if (m_iFileId & 1)
	{
		strPath = m_strPath + _T("_0.txt");
	} else
	{
		strPath = m_strPath + _T("_1.txt");
	}
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
	m_fhTrace = _tcreat(strPath, _S_IREAD|_S_IWRITE);
	if (m_fhTrace == -1)
		AfxThrowFileException(CFileException::ErrnoToException(errno), -1, strPath);

	_TCHAR szBuff[1024];
	_stprintf(szBuff, _T("ID=%d\n"), m_iFileId);
	_write(m_fhTrace, szBuff, _tcslen(szBuff) * sizeof(_TCHAR));
	_commit(m_fhTrace);
} // FCTrace::Open.

static FCTrace* GetTraceer ()
{
	static FCTrace s_trace;
	return &s_trace;
} // GetTraceer ().

void FFTrace (const _TCHAR* f, long l)
{
	// CriticalSection _xZkqqHx_iCmJjDpMiOlKiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(GetTraceer()->m_csAuto);
	GetTraceer()->TraceS(f, l, NULL);
} // FFTrace.

void FFTraceM (const _TCHAR* f, long l, const _TCHAR* tcpForm, ...)
{
	// CriticalSection _xZkqqHx_iCmJjDpMiOlKiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(GetTraceer()->m_csAuto);
	_TCHAR szBuff[2048];
	va_list argList;
	va_start(argList, tcpForm);
	_vstprintf(szBuff, tcpForm, argList);
	va_end(argList);
	GetTraceer()->TraceS(f, l, szBuff);
}

void FFTraceInc ()
{
	// CriticalSection _xZkqqHx_iCmJjDpMiOlKiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(GetTraceer()->m_csAuto);
	GetTraceer()->IncIndent();
}

void FFTraceDec ()
{
	// CriticalSection _xZkqqHx_iCmJjDpMiOlKiBeC_xHqqkZx_
	FCAutoLeaveCriticalSection atlcs(GetTraceer()->m_csAuto);
	GetTraceer()->DecIndent();
}

#endif // defined(_FDTRACE_B)

//----- 06.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///**********************************************************************
// *                      _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjE_xHqqkZx_
// **********************************************************************/
//
//FCGlobal s_ =
//{
//	FD_APPMODE_DYNAMICDRAW | FD_RUNMODE_NONE,	// _xZkqqHx_iDeBiDhGiDiKiOmAiNhDiDiCiBfLiDgIiBeC_xHqqkZx_
//	0.0,				// Display_xZkqqHx_iCmMjIfPjHjN_xHqqkZx_pixel/mm_xZkqqHx_iCpAjFnLjBlGiBeC_xHqqkZx_
//	0.0,				// Display_xZkqqHx_iCmMjIfPjHjN_xHqqkZx_pixel/mm_xZkqqHx_iCpA_xHqqkZx_HORZRES/HORZSIZE_xZkqqHx_iCmFiOoGjDlOiBeC_xHqqkZx_
//	0.0,				// Display_xZkqqHx_iCmMjIfPjHjN_xHqqkZx_pixel/mm_xZkqqHx_iCpA_xHqqkZx_VERTRES/VERTSIZE_xZkqqHx_iCmFiOoGjDlOiBeC_xHqqkZx_
//	256,				// _xZkqqHx_jEhLjHkGiBeCiPiJiKpKjCgMiCmN_xHqqkZx_256_xZkqqHx_iBeC_xHqqkZx_CFCMainFrame_xZkqqHx_iCmFjAnNjCoIiBeC_xHqqkZx_
//	0.0,				// _xZkqqHx_jEhLjHkGiBeCiPiJiKpKjCgMiCmN_xHqqkZx_g_->dDisplayPPM_xZkqqHx_iBeC_xHqqkZx_CFCMainFrame_xZkqqHx_iCmFjAnNjCoIiBeC_xHqqkZx_
//	FD_ZOOM256_MAX,		// Zoom256_xZkqqHx_jCgMiCmMiNmFjBoFjCgMiBeCiClBiCmMjCgMiCpAiKnMiCnOiBeC_xHqqkZx_
//	0,					// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
//	0,					// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
//	FDDR_NONE,			// _xZkqqHx_jFgAiJoGjAoGiDgGiDgPiDeDiDfIjAnNjCoIiBeC_xHqqkZx_
//	FD_STD_PRECISION,	// _xZkqqHx_iLmIjApMiMhGiOfKiOjOiCmMjFfHiPiAiCmMjClIjDfPiLjHjHkDiBeC_xHqqkZx_
//};
//
//FCGlobal*	g_ = &s_;
//
//// 03.08.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////FCNoValue NoValue;
//
////----------<NOT EXPORT TO VIEWER>-----------
//
//static int myBitsPixel ()
//{
//	// _xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDiCmM_xHqqkZx_HDC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
//	HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
//	// _xZkqqHx_iCfAiDhDiDeOiDfKiDiLiCmMiDhCiDgCiDgHjAjEiCpAiOoGjDlOiBeBiDhCiDgCiDgHiDhNiDgCiDhGiDfEiDeDiDfJiCmMiOfKiPgPiBeC_xHqqkZx_
//	int iBitsPixel = GetDeviceCaps(hAttribDC, BITSPIXEL);
//	// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
//	::DeleteDC(hAttribDC);
//	// _xZkqqHx_iCfAiDhDiDeOiDfKiDiLiCmMiDhCiDgCiDgHjAjEiCpAiOoGjDlOiBeBiDhCiDgCiDgHiDhNiDgCiDhGiDfEiDeDiDfJiCmMiOfKiPgPiBeC_xHqqkZx_
//	return iBitsPixel;
//} // myBitsPixel.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myClipFormat
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DDFile_xZkqqHx_iMgAiOkOiCmMiDeOiDiKiDgCiDhGiDhLiBfLiDgIiDhEiDeIiBfLiDhNiDgCiDgHiCpAiNoMjAkMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpAddText	:_xZkqqHx_jCmHiJmBiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static CLIPFORMAT myClipFormat (const wchar_t* wcpAddText)
//{
//	//----- Molip Draw_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiDhLiBfLiDgIiDfCiDhDiBfLjHhA_xHqqkZx_ Native File Data _xZkqqHx_iCmMiMgAiOkOjGlMiCpAjDgPjIfO_xHqqkZx_ -----
//	WString wstrForm;
//	wstrForm.Format(L"Dynamic Draw %s %s",
//					FCHeaderInf::GetStcFileVersionString(),
//					wcpAddText);
//	return (CLIPFORMAT)::RegisterClipboardFormat(WStrToTStr(wstrForm));
//} // myClipFormat.
//
//// GetDeviceCaps(BITSPIXEL).
//const int	g_nBitsPixel = myBitsPixel();
//// ChipRec_xZkqqHx_iCmM_xHqqkZx_m_pBits_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//const DWORD	g_dwChipBits = (FD_CHIP_BMP_W * FD_CHIP_BMP_H * g_nBitsPixel) / 8;
//// PictArrowRec_xZkqqHx_iCmM_xHqqkZx_m_pBits_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
//const DWORD	g_dwPictArrowBits = (FD_PICT_ARROW_BMP_W * FD_PICT_ARROW_BMP_H * g_nBitsPixel) / 8;
//// Molip Draw_xZkqqHx_iCmMiDeOiDiKiDgCiDhGiDhLiBfLiDgIiDfCiDhDiBfLjHhA_xHqqkZx_ Native File Data _xZkqqHx_iCmMiMgAiOkOjGlMiBeC_xHqqkZx_
//const CLIPFORMAT g_cfDDFile = myClipFormat(L"");
//// g_cfDDFile_xZkqqHx_iCmFiBeB_xHqqkZx_ObjFigure_xZkqqHx_iCkKiCfAiCmCiCmMiCnNjDgPjIfOiCmMiPoKiNiHiCmJiBeBiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
//const CLIPFORMAT g_cfObjFigure = myClipFormat(L"ObjFigure");
//// Dynamic Draw_xZkqqHx_iCmMiDgFiDeMiDfIiDgHiDeOiDiKiDgCiDhGiDhLiBfLiDgIiDfCiDhDiBfLjHhAiBeC_xHqqkZx_
//const CLIPFORMAT g_cfDDText = myClipFormat(L"Text");
//// RTF_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
//const CLIPFORMAT g_cfRTF = (CLIPFORMAT)::RegisterClipboardFormat(CF_RTF);
//// OLE_xZkqqHx_iDgGiBfLiDfOiBeC_xHqqkZx_
//const CLIPFORMAT g_cfEmbeddedObject = (CLIPFORMAT)::RegisterClipboardFormat(CF_EMBEDDEDOBJECT);
//// OLE_xZkqqHx_iDfMiBfLiDfIiBeC_xHqqkZx_
//const CLIPFORMAT g_cfEmbedSource = (CLIPFORMAT)::RegisterClipboardFormat(CF_EMBEDSOURCE);
//// CSV_xZkqqHx_iDgFiDeMiDfIiDgHiBgJ_xHqqkZx_Paste_xZkqqHx_iOjOiCmMiOkPjFmKiCmJiCmMiCnNiOgHjHhAiBgK_xHqqkZx_
//extern const CLIPFORMAT g_cfCsvText = myClipFormat(L"CSV");
//// CSV Unicode_xZkqqHx_iDgFiDeMiDfIiDgHiBgJ_xHqqkZx_Paste_xZkqqHx_iOjOiCmMiOkPjFmKiCmJiCmMiCnNiOgHjHhAiBgK_xHqqkZx_
//extern const CLIPFORMAT g_cfCsvUnicodeText = myClipFormat(L"CSV Unicode");
////----- 05.07.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////// _xZkqqHx_iDiKiDjDiDeOiDfMiBfLiDfIiBeC_xHqqkZx_
////const CLIPFORMAT g_cfLinkSource = (CLIPFORMAT)::RegisterClipboardFormat(CF_LINKSOURCE);
////----- 05.07.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
////--------- _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCmMiDgPiDgCiDeOiDeBiDgCiDhG_xHqqkZx_ ----------
//struct FCGlobalBackup
//{
//	FCEnv*			m_pEnv;				// _xZkqqHx_iKmCiLkLiBeC_xHqqkZx_
//	CFCFoundDoc*	m_pDoc;				// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiBeC_xHqqkZx_
//	CFCMainFrame*		m_pFrame;			// _xZkqqHx_iDhEiDiMiBfLiDiAiBeC_xHqqkZx_
//	CFCDynamicDrawView*	m_pView;			// _xZkqqHx_iDhCiDiFiBfLiBeC_xHqqkZx_
//	FCRegData*		m_pReg;				// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiBeC_xHqqkZx_
//	FCToolManager*	m_pToolManager;		// _xZkqqHx_iDgDiBfLiDiLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
//	FCHiProject*		m_pProject;			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//	FCGlobal*		m_;					// _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiBeC_xHqqkZx_
//}; // struct FCGlobalBackup.
//
//static vector<FCGlobalBackup> s_globalBackup;
//----- 06.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
/////////////////////////////////////////////////////////////////////////////
//// _xZkqqHx_iDePiDiNiBfLiDgPiDiLiKnGjAjEiBeC_xHqqkZx_
//
////----------</NOT EXPORT TO VIEWER>-----------
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGlobal::Initialize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCmMiPiJiKpKiJlLiCpAiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCGlobal::Initialize ()
//{
//	// _xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDiCmM_xHqqkZx_HDC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
//	HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
//	if (hAttribDC == NULL) return;
//
////----- 03.07.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// OS_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiPoOjFpBiOoGjDlOiBeC_xHqqkZx_
////	::GetVersionEx(&s_versionInfo);
////----- 03.07.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//
//	//----- _xZkqqHx_iKgFiOoNiDePiDiNiBfLiDgPiDiLjFmPjAjEiCmMiPiJiKpKiJlL_xHqqkZx_ -----
//
//	// Display_xZkqqHx_iCmMjIfPjHjN_xHqqkZx_mm_xZkqqHx_iCkAiClNiCoIiCmM_xHqqkZx_pixel_xZkqqHx_jAjEiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_LOGPIXELSX_xZkqqHx_iCmFjFnEiCoJjCgMiCmN_xHqqkZx_
//	// Display_xZkqqHx_iCmMiJkBjFpLiMpMiCmMjIfPjHjNiDeDiDjDiDgAiCkAiClNiCoIiCmM_xHqqkZx_pixel_xZkqqHx_jAjEiBeCiCfAiDeDiDjDiDgA_xHqqkZx_ = 25.4mm.
//	// _xZkqqHx_iClBiClBiCmFiCmNiBeB_xHqqkZx_GetDeviceCaps(LOGPIXELSX)_xZkqqHx_iCpAiMlDiCmJiOfKiPgPiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	// _xZkqqHx_iCmIiClKiCmIiCoHiCmOiBeBiDhEiDeIiDjDiDgHiDfPiDeDiDeBiDiNiDePjCiGiCmIiCmHiCmFiCmNiBeB_xHqqkZx_pixel<->point_xZkqqHx_iCmMjFmPiKlHiCmM_xHqqkZx_
//	// _xZkqqHx_iMhGiOfKiCmJiBeB_xHqqkZx_GetDeviceCaps(LOGPIXELSX)_xZkqqHx_iCpAiOgHiCmBiCmEiCkCiCoJiCkJiCoHiCmFiCkAiCoJiBeC_xHqqkZx_
//	// EMF_xZkqqHx_iCmNiBeB_xHqqkZx_GetDeviceCaps(HORZRES) / GetDeviceCaps(HORZSIZE)_xZkqqHx_iCmG_xHqqkZx_
//	// GetDeviceCaps(VERTRES) / GetDeviceCaps(VERTSIZE)_xZkqqHx_iCpAiOgHiCkEiCkKiBeB_xHqqkZx_
//	// _xZkqqHx_iClBiCmMjCgMiCmNjAiFjFlNiBeFjAiCjClMiCmFjAeIiCkCiIoBiCkCiCkKiCkAiCoIiBeBiCnMiClN_xHqqkZx_GetDeviceCaps(LOGPIXELSX)
//	// _xZkqqHx_iCmGiCoAiIoBiCkEiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
//	// GetDeviceCaps(LOGPIXELSX)_xZkqqHx_iCmNiBeBiJoGjGmKiDhGiDiNiDhAiDgFiDeCiCmFiBhFjBoFiCkLiCkCjFlGiOjKiBhGiBeB_xHqqkZx_
//	// _xZkqqHx_iBhFiPkMiClDiCkCjFlGiOjKiBhGiCpAjBeJiCpBiClOiOjOiCoAjFmPiJlLiClHiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
//	dDisplayPPM = (double)GetDeviceCaps(hAttribDC, LOGPIXELSX) / 25.4;
//	// Display_xZkqqHx_iCmMjIfPjHjN_xHqqkZx_mm_xZkqqHx_iCkAiClNiCoIiCmM_xHqqkZx_pixel_xZkqqHx_jAjEiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//	// HORZSIZE	:_xZkqqHx_jFkIjHjNiDgGiDeCiDfIiDhGiDiMiDeDiCmMjFjN_xHqqkZx_ (mm _xZkqqHx_jCfAiImK_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
//	// HORZRES	:_xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDiCmMjFjN_xHqqkZx_ (_xZkqqHx_iDhDiDeOiDfKiDiLjCfAiImK_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
//	dRealDisplayPPMHorz = double(GetDeviceCaps(hAttribDC, HORZRES)) /
//												double(GetDeviceCaps(hAttribDC, HORZSIZE));
//	dRealDisplayPPMVert = double(GetDeviceCaps(hAttribDC, VERTRES)) /
//												double(GetDeviceCaps(hAttribDC, VERTSIZE));
//	// _xZkqqHx_iDfJiBfLiDiAjCgMiCmMjAnNjCoIiBeC_xHqqkZx_
//	lZoom256 = 256;
//	dZoom = ((double)lZoom256 * dDisplayPPM) / 256.0;
//
//	// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
//	::DeleteDC(hAttribDC);
//} // FCGlobal::Initialize.
//
////----------<NOT EXPORT TO VIEWER>-----------
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGlobalBackup
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCpAiDgPiDgCiDeOiDeBiDgCiDhGiClFiCmEiBeB_xHqqkZx_NULL_xZkqqHx_iCmFiPiJiKpKiJlLiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFGlobalBackup ()
//{
//	// _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEjHhAiDfIiDfOiDgCiDeOiCmJjAmPiCnOiBeC_xHqqkZx_
//	s_globalBackup.push_back(FCGlobalBackup());
//	s_globalBackup.back().m_pEnv		= g_pEnv;
//	s_globalBackup.back().m_pDoc		= g_pDoc;
//	s_globalBackup.back().m_pFrame		= g_pFrame;
//	s_globalBackup.back().m_pView		= g_pView;
//	s_globalBackup.back().m_pReg		= g_pReg;
//	s_globalBackup.back().m_pToolManager= g_pToolManager;
//	s_globalBackup.back().m_pProject	= g_pProject;
//	s_globalBackup.back().m_			= g_;
//
//	g_pEnv			= NULL;
//	g_pDoc			= NULL;
//	g_pFrame		= NULL;
//	g_pView			= NULL;
//	g_pReg			= NULL;
//	g_pToolManager	= NULL;
//	g_pProject		= NULL;
//	g_				= NULL;
//} // FFGlobalBackup.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGlobalRestore
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEiCmMiDgPiDgCiDeOiDeBiDgCiDhGiCpAjFjMiLeBiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFGlobalRestore ()
//{
//	// _xZkqqHx_iDePiDiNiBfLiDgPiDiLjFmPjAjEjHhAiDfIiDfOiDgCiDeOiCkJiCoHiOoGiCoIiPgPiClHiBeC_xHqqkZx_
//	g_pEnv		= s_globalBackup.back().m_pEnv;
//	g_pDoc		= s_globalBackup.back().m_pDoc;
//	g_pFrame	= s_globalBackup.back().m_pFrame;
//	g_pView		= s_globalBackup.back().m_pView;
//	g_pReg		= s_globalBackup.back().m_pReg;
//	g_pToolManager= s_globalBackup.back().m_pToolManager;
//	g_pProject	= s_globalBackup.back().m_pProject;
//	g_			= s_globalBackup.back().m_;
//	s_globalBackup.pop_back();
//} // FFGlobalRestore.
//
////----------</NOT EXPORT TO VIEWER>-----------
//----- 06.01.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

///////////////////////////////////////////////////////////////////////////
// WString

WString::WString ()
{
} // WString::WString.

WString::WString (const wchar_t* s) : wstring((s != NULL) ? s : L"")
{
} // WString::WString.

WString::WString (const wchar_t* s, long lCount) : wstring((s != NULL) ? s : L"", lCount)
{
} // WString::WString.

WString::WString (const wchar_t* first, const wchar_t* last)
		: wstring(first, last)
{
} // WString::WString.

WString::WString (long lC, wchar_t wc)
		: wstring(lC, wc)
{
} // WString::WString.

int WString::GetLength () const
{
	return length();
} // WString::GetLength.

BOOL WString::IsEmpty () const
{
	return empty();
} // WString::IsEmpty.

void WString::Empty ()
{
	erase();
} // WString::Empty.

wchar_t WString::GetAt (int nIndex) const
{
	return at(nIndex);
} // WString::GetAt.

void WString::SetAt (int nIndex, wchar_t wc)
{
	at(nIndex) = wc;
} // WString::SetAt.

wchar_t WString::GetFirst () const
{
	return at(0);
} // WString::GetFirst.

void WString::SetFirst (wchar_t wc)
{
	at(0) = wc;
} // WString::SetFirst.

wchar_t WString::GetLast () const
{
	return at(length() - 1);
} // WString::GetLast.

void WString::SetLast (wchar_t wc)
{
	at(length() - 1) = wc;
} // WString::SetLast.

void WString::ChopFirst ()
{
	erase(begin());
} // WString::ChopFirst.

void WString::ChopLast ()
{
	erase(end() - 1);
} // WString::ChopLast.

void WString::ChopFirst (wchar_t wc)
{
	if (GetFirst() == wc)
		ChopFirst();
} // WString::ChopFirst.

void WString::ChopLast (wchar_t wc)
{
	if (GetLast() == wc)
		ChopLast();
} // WString::ChopLast.

WString& WString::UpperCase ()
{
	_wcsupr(begin());
	return *this;
} // WString::UpperCase.

WString& WString::LowerCase ()
{
	_wcslwr(begin());
	return *this;
} // WString::LowerCase.

WString::operator const wchar_t* () const
{
	return c_str();
} // WString::operator.

int WString::CompareNoCase (const wchar_t* lpsz) const
{
	return _wcsicmp(c_str(), lpsz);
} // WString::CompareNoCase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WString::CompareTail
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjHpBiCmGiBeBiClBiCmMjFlGiOjKjHpBiCmMiMoDjElMiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpsz	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	int(this < lpsz) _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	this = "abcde", lpsz = "efg" _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_"cde" < "efg" _xZkqqHx_iCpAjEoEiKhCiBeC_xHqqkZx_
 *			this = "abc", lpsz = "efgh" _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_"abc" < "efgh" _xZkqqHx_iCpAjEoEiKhCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int WString::CompareTail (const wchar_t* lpsz) const
{
	int iStartPos = GetLength() - int(wcslen(lpsz));
	if (iStartPos < 0) iStartPos = 0;
	return wcscmp(c_str() + iStartPos, lpsz);
} // WString::CompareTail.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WString::CompareTailNoCase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFlGiOjKjHpBiCmGiBeBiClBiCmMjFlGiOjKjHpBiCmMiMoDjElMiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpsz	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	int(this < lpsz) _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	this = "abcde", lpsz = "efg" _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_"cde" < "efg" _xZkqqHx_iCpAjEoEiKhCiBeC_xHqqkZx_
 *			this = "abc", lpsz = "efgh" _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_"abc" < "efgh" _xZkqqHx_iCpAjEoEiKhCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int WString::CompareTailNoCase (const wchar_t* lpsz) const
{
	int iStartPos = GetLength() - int(wcslen(lpsz));
	if (iStartPos < 0) iStartPos = 0;
	return _wcsicmp(c_str() + iStartPos, lpsz);
} // WString::CompareTailNoCase.

WString WString::Mid (int nFirst) const
{
	return WString(begin() + nFirst, end());
} // WString::Mid.

WString WString::Mid (int nFirst, int nCount) const
{
	return (WString&)substr(nFirst, nCount);
} // WString::Mid.

WString WString::Left (int nCount) const
{
	return (WString&)substr(0, nCount);
} // WString::Left.

WString WString::Right (int nCount) const
{
	return (WString&)substr(length() - nCount, nCount);
} // WString::Right.

WString WString::SpanExcluding (const wchar_t* lpszCharSet) const
{
	size_type iPos = find_first_of(lpszCharSet);
	if (iPos != WString::npos)
	{
		return WString(c_str(), c_str() + iPos);
	} else
	{
		return *this;
	}
} // WString::SpanExcluding.

WString WString::SpanSame (const wchar_t* wcpStr) const
{
	long lC;
	for (lC = 0; lC < GetLength() &&
				 wcpStr[lC] != L'\0' &&
				 GetAt(lC) == wcpStr[lC]; lC++);
	return Left(lC);
} // WString::SpanSame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WString::CharCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	wc_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJjFlGiOjKiCkKiBeBjFlGiOjKjHpBjCiGiCmJiKpEiCmCiCkAiCoJiCkJjAjEiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wc	:_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.11.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long WString::CharCount (wchar_t wc) const
{
	long lCount = 0;
	for (long lC = 0; lC < GetLength(); lC++)
		if (GetAt(lC) == wc) lCount++;
	return lCount;
} // WString::CharCount.

BOOL WString::Replace (wchar_t chOld, wchar_t chNew)
{
	// _xZkqqHx_iCfAiMmCiCmFiCoAjChFiCkLiKlHiCkGiCkKiCkAiCmBiClNiCkJiBeI_xHqqkZx_
	BOOL bReplace = FALSE;
	size_type nnn = 0;
	for (;;)
	{
		nnn = find(chOld, nnn);
		if (nnn == WString::npos) break;
		at(nnn) = chNew;
		bReplace = TRUE;
		nnn++;
	}
	return bReplace;
} // WString::Replace.

BOOL WString::Replace (const wchar_t* lpszOld, const wchar_t* lpszNew)
{
	// _xZkqqHx_iCfAiMmCiCmFiCoAjChFiCkLiKlHiCkGiCkKiCkAiCmBiClNiCkJiBeI_xHqqkZx_
	BOOL bReplace = FALSE;
	const size_type szOld = wcslen(lpszOld);
	const size_type szNew = wcslen(lpszNew);
	size_type nnn = 0;
	for (;;)
	{
		nnn = find(lpszOld, nnn);
		if (nnn == WString::npos) break;
		replace(nnn, szOld, lpszNew, szNew);
		bReplace = TRUE;
		nnn += szNew;
	}
	return bReplace;
} // WString::Replace.

void WString::TrimLeft ()
{
	WString::iterator i;
	for (i = begin(); i != end(); i++)
	{
		if (*i != L' ' &&
			*i != L'\t' &&
			*i != L'\r' &&
			*i != L'\n') break;
	}
	erase(begin(), i);
} // WString::TrimLeft.

void WString::TrimLeft (wchar_t chTarget)
{
	WString::iterator i;
	for (i = begin(); i != end(); i++)
		if (*i != chTarget) break;
	erase(begin(), i);
} // WString::TrimLeft.

void WString::TrimRight ()
{
	int i;
	for (i = length() - 1; i != -1; i--)
	{
		if (at(i) != L' ' &&
			at(i) != L'\t' &&
			at(i) != L'\r' &&
			at(i) != L'\n') break;
	}
	erase(i + 1);
} // WString::TrimRight.

void WString::TrimRight (wchar_t chTarget)
{
	int i;
	for (i = length() - 1; i != -1; i--)
	{
		if (at(i) != chTarget) break;
	}
	erase(i + 1);
} // WString::TrimRight.

int WString::Find (wchar_t ch) const
{
	size_type n = find(ch);
	return (n != WString::npos) ? n : -1;
} // WString::Find.

int WString::Find (const wchar_t* wcpSub) const
{
	size_type n = find(wcpSub);
	return (n != WString::npos) ? n : -1;
} // WString::Find.

int WString::ReverseFind (wchar_t ch) const
{
	size_type n = rfind(ch);
	return (n != WString::npos) ? n : -1;
} // WString::ReverseFind.

void WString::Insert (int nIndex, wchar_t ch)
{
	insert(nIndex, 1, ch);
} // WString::Insert.

void WString::Insert (int nIndex, const wchar_t* pstr)
{
	insert(nIndex, pstr);
} // WString::Insert.

void WString::Delete (int nIndex, int nCount)
{
	erase(nIndex, nCount);
} // WString::Delete.

void WString::Format (const wchar_t* lpszFormat, ...)
{
	va_list argList;
	va_start(argList, lpszFormat);
	FormatV(lpszFormat, argList);
	va_end(argList);
} // WString::Format.

void WString::Format (DWORD dwId, ...)
{
	WString wstrFormat;
	wstrFormat.LoadString(dwId);
	va_list argList;
	va_start(argList, dwId);
	FormatV(wstrFormat, argList);
	va_end(argList);
} // WString::Format.

void WString::FormatV (const wchar_t* lpszFormat, va_list argList)
{
//	va_start(argList, lpszFormat);
	int iCount = -1;
	for (size_t nnn = 1000; iCount == -1; nnn *= 2)
	{
		resize(nnn);
		iCount = _vsnwprintf(begin(), nnn - 1, lpszFormat, argList);
	}
	resize(iCount);
//	va_end(argList);
} // WString::FormatV.

#ifdef _AFX	// MFC _xZkqqHx_iCpAiOgHiCkEiPoKiNiHiBeC_xHqqkZx_

BOOL WString::LoadString (UINT nID)
{
	CString str;
	if (!str.LoadString(nID)) return FALSE;
	operator = (TStrToWStr(str));
	return TRUE;
} // WString::LoadString.

//----- 06.01.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#else//_AFX
//
//BOOL WString::LoadString (UINT nID)
//{
//	int iLen = 100;
//	TCHARVector vBuff;
//	do
//	{
//		vBuff.resize(iLen);
//		iLen = ::LoadString(HINSTANCE(::GetModuleHandle(NULL)),
//							nID,
//							&vBuff[0],
//							vBuff.size());
//	} while (iLen == vBuff.size());
//	operator = (TStrToWStr(&vBuff[0]));
//	return TRUE;
//} // WString::LoadString.
//----- 06.01.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#endif//_AFX

WString& WString::LoadStringSelf (UINT nID)
{
	LoadString(nID);
	return *this;
} // WString::LoadStringSelf.

BYTEVector& operator << (BYTEVector& vStream, const WString& wstr)
{
	vStream << DWORD(wstr.GetLength());
	FFWriteStream(vStream, wstr.c_str(), wstr.GetLength() * sizeof(wchar_t));
	return vStream;
} // BYTEVector& operator << (BYTEVector& vStream, const WString& wstr);

BYTEVector& operator << (BYTEVector& vStream, WString& wstr)
{
	vStream << DWORD(wstr.GetLength());
	FFWriteStream(vStream, wstr.c_str(), wstr.GetLength() * sizeof(wchar_t));
	return vStream;
} // BYTEVector& operator << (BYTEVector& vStream, WString& wstr);

void FFReadData (WString& wstr, const BYTE*& pStream)
{
	DWORD dwStrLen;
	FFReadData(dwStrLen, pStream);
	if (dwStrLen == 0)
	{
		wstr.Empty();
	} else
	{
		wstr.assign(dwStrLen, L'\0');
		FFReadStream(pStream, &wstr.at(0), dwStrLen * sizeof(wchar_t));
	}
} // void FFReadData (WString& wstr, const BYTE*& pStream);

void FFSkipData (WString* pwstr, const BYTE*& pStream)
{
	DWORD dwStrLen;
	FFReadData(dwStrLen, pStream);
	pStream += (dwStrLen * sizeof(wchar_t));
} // void FFSkipData (WString* pwstr, const BYTE*& pStream);

void FFSkipData (const WString* pwstr, const BYTE*& pStream)
{
	DWORD dwStrLen;
	FFReadData(dwStrLen, pStream);
	pStream += (dwStrLen * sizeof(wchar_t));
} // void FFSkipData (const WString* pwstr, const BYTE*& pStream);

