#ifndef __HString_h
#define __HString_h

#include "../DynamicServer/DynamicServer.h"	// For DsString.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	HString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDkPiClGjFlGiOjKjHpBiCmNjDkPiClGiDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iCmFiKmHjHjNiClHiCoJiBeCjFlGiOjKjHpBiCpAiKgJjEfLiClHiCoJiCnMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKjHpBiCmNiDhBiBfLiDhGiCmJiOpLjEfLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class HString
{
public:
	HString ();
	HString (const HString& hstring);
	HString (const wchar_t* s);
	~HString ();
	DWORD GetLength () const;
	BOOL IsEmpty () const;
	BOOL IsNull () const;
// 05.12.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	TmpString c_str () const;
	DsString c_str () const;
	wchar_t GetAt (DWORD dwIndex) const;
// 05.12.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	operator TmpString () const;
	operator DsString () const;
	operator WString () const;
	wchar_t operator [] (DWORD dwIndex) const;
	void operator = (const HString& hstring);
	void operator = (const wchar_t* s);
	void Set (const HString& hstring);
	void Set (const wchar_t* s);
	void Empty ();

friend bool operator < (const HString& hstr1, const HString& hstr2);
friend bool operator == (const HString& hstr1, const HString& hstr2);
friend bool operator != (const HString& hstr1, const HString& hstr2);

protected:
	DWORD					m_dwDataId;		// _xZkqqHx_iDgGiBfLiDfO_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
}; // class HString.

inline bool operator < (const HString& hstr1, const HString& hstr2) { return (hstr1.m_dwDataId < hstr2.m_dwDataId); }
inline bool operator == (const HString& hstr1, const HString& hstr2) { return (hstr1.m_dwDataId == hstr2.m_dwDataId); }
inline bool operator != (const HString& hstr1, const HString& hstr2) { return (hstr1.m_dwDataId != hstr2.m_dwDataId); }

#endif//__HString_h
