#ifndef __HTreeManager_h
#define __HTreeManager_h

#include "DbLock.h"				// For FCDbReadLock.
#include "HiProject.h"			// For FCHiProject.
#include "RegData.h"			// For FDRegFontType.
#include "ProjectCopy.h"		// For FCProjectCopy.
#include "DocumentRecCopy.h"	// For FCDocumentRecCopy.

class FCHTreeRec;
class FCHiProject;
class FCDbReadLock;
class FCHTreeManager;
class FCDbLockBank;

typedef auto_ptr<FCHTreeRec>	HTreeRecAuto;
typedef map<long, HTreeRecAuto>	DocIdToHTreeRecMap;

#define FD_HTREE_VIEW_GAP	10		// _xZkqqHx_jHjKjHpAiDhCiDiFiBfLiCmMiOpMiImNiCmMiDeNiDiDiDgCiDhGiBeC_xHqqkZx_

enum FTHTViewMode
{
	FDHT_VMODE_NONE = 0,	// _xZkqqHx_jFfMiOkGiCmIiClFiBeC_xHqqkZx_
	FDHT_VMODE_PROJECT,		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	FDHT_VMODE_TREE,		// _xZkqqHx_jHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	FDHT_VMODE_BRANCH,		// _xZkqqHx_iMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
}; // enum FTHTViewMode.

class FCDocRecExtData : public FCDocumentRecCopy
{
protected:
typedef FCDocumentRecCopy BASE_CLASS;

public:
	FCDocRecExtData (const FCProjectCopy* pProjectCopy);
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long			GetSuperDocId () const;			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
//	const WString&	GetDocTitle () const;			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
//	const WString&	GetVersion () const;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//	GUID			GetUserId () const;				// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	FDSECTIME		GetDate () const;				// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
//	const WString&	GetComment () const;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
//	BOOL			GetIsLogCommandUserId () const;	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
//	double			GetHtreeScore () const;			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
//	void			operator = (FCHiDocumentRec& rec);
//	WString			GetHintText (const FCHTreeManager* pHtreeManager) const;
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	const longVector&	GetSubDocumentId () const;		// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCmMiIoKjHjHiBeC_xHqqkZx_
	const CPoint&		GetRootPoint () const;			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMiBeBjDlBjDpMjApMiCmMiOgOjDfPiBeC_xHqqkZx_
	const CPoint&		GetBoxPoint () const;			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMiBeBjHjKjHpAiDhLiDgCiDeOiDfIiCmMiNlGiPoDiBeC_xHqqkZx_
	BOOL				GetIsSubTreeExpanded () const;	// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCmMjFfMiOkGiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_

	void	SetSubDocumentId (long lDocumentId);
	void	SetRootPoint (const CPoint& lgptRoot);			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMiBeBjDlBjDpMjApMiCmMiOgOjDfPiBeC_xHqqkZx_
	void	SetBoxPoint (const CPoint& lgptBox);			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMiBeBjHjKjHpAiDhLiDgCiDeOiDfIiCmMiNlGiPoDiBeC_xHqqkZx_
	void	SetIsSubTreeExpanded (BOOL bIsSubTreeExpanded);	// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCmMjFfMiOkGiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_

protected:
	longVector	m_vSubDocId;			// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCmMiIoKjHjHiBeC_xHqqkZx_
	CPoint		m_ptRoot;				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMiBeBjDlBjDpMjApMiCmMiOgOjDfPiBeC_xHqqkZx_
	CPoint		m_ptBox;				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiCmFiCmMiBeBjHjKjHpAiDhLiDgCiDeOiDfIiCmMiNlGiPoDiBeC_xHqqkZx_
	BOOL		m_bSubTreeExpanded;		// _xZkqqHx_iDfEiDhFiDgDiDiKiBfLiCmMjFfMiOkGiCkKjDfHiKeKiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	long		m_lSuperDocId;			// _xZkqqHx_iPoDiImKjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
//	WString		m_wstrDocTitle;			// _xZkqqHx_jHjKjHpAjFlGiPjBjGlMiBeC_xHqqkZx_
//	WString		m_wstrVersion;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//	GUID		m_guidUserId;			// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	FDSECTIME	m_fdstDate;				// _xZkqqHx_jHjKjHpAjFlGiPjBiNoMjAkMjDpKiBeC_xHqqkZx_UTC_xZkqqHx_iBeC_xHqqkZx_
//	WString		m_wstrComment;			// _xZkqqHx_jHjKjHpAjFlGiPjBiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
//	BOOL		m_bIsLogCommandUserId;	// _xZkqqHx_jFnCiPfHiOnCiPoOjFpBiCmMiDiNiDePiCpAiLeMjIfOiBeC_xHqqkZx_
//	double		m_dHtreeScore;			// _xZkqqHx_jHjKjHpAiDfIiDfCiDeBiBeC_xHqqkZx_
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
}; // class FCDocRecExtData.

class FCDocRecExtDataFactory : public FCDocRecCopyFactory
{
public:
	virtual FCDocumentRecCopy*	Create (const FCProjectCopy* pProjectCopy) const;
	virtual void				Delete (FCDocumentRecCopy* pDocRecCopy) const;
}; // class FCDocRecExtDataFactory.

//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//typedef auto_ptr<FCDocRecExtData>	DocRecExtAuto;
//typedef map<long, DocRecExtAuto>	DocIdToDocRecExtMap;
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCHTreeManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jHjKjHpAjGnIiCpAiKmHjHjNiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCHTreeManager_xZkqqHx_iCmMiJlKiCmJiBeB_xHqqkZx_FCHTreeRec_xZkqqHx_iBgJjHjKjHpAjGnIiCmMiCfAjGhLiCmMiOhNiBgKiCkK_xHqqkZx_
 *			_xZkqqHx_jGnIiNfMjBkCiCpAiNfMjAkMiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCHTreeManager
{
public:
	FCHTreeManager ();
	virtual ~FCHTreeManager ();

	virtual WString	GetProjectPath () const;
// 06.01.30 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	SetProjectPath (const wchar_t* wcpFilePath);
	virtual void	Clear ();
	virtual void	CalcLayout (long lDocId);
	virtual FCHTreeRec*	DocumentIdToHTreeRec (long lDocId);
	virtual long	GetNextDocumentId (long lDocId) const;
	virtual void	EraseDocumentId (long lDocId);

	virtual CPoint	GetMostRightBottom () const;
	virtual void	SetMostRightBottom (CPoint pt);

// 05.08.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	CheckFileUpdated (const longSet& stDocumentId);
// 06.01.30 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	UnlockAll ();
	virtual void	GetTotalTreeDocId (longVector& vDocId, long lDocId);
//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual FCHiProject*	GetProject ();
//	virtual const FCHiProject*	GetProject () const;
//----- 06.01.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	virtual FTHTViewMode GetViewMode () const;
	virtual void	SetViewMode (FTHTViewMode nViewMode);

	virtual const longVector&	GetTopDocumentIdVector () const;

	virtual double	GetZoom (long lDocId);
	virtual void	SetZoom (long lDocId, double dZoom);

	virtual CRect	GetNodeBoxRectInProject (long lDocId);
	virtual CRect	GetExpBoxRectInProject (long lDocId);

	virtual double	GetFontZoom () const;
	virtual void	SetFontZoom (double dZoom);
	virtual void	InitFont (LOGFONT& lf, FDRegFontType nType) const;
	virtual void	InitFont (CFont& font, FDRegFontType nType) const;
	virtual long	GetFontHeight (FDRegFontType nType) const;
	virtual CSize	GetHistBoxSize () const;

	virtual long	GetHtInterBoxX () const;
	virtual long	GetHtInterBoxY () const;
	virtual long	GetHtIntroGapY () const;
	virtual long	GetHtBoxWidthL () const;
	virtual long	GetHtBoxIntroY () const;
	virtual long	GetHtBoxGapY () const;
	virtual long	GetHtLifeWidthH () const;
	virtual long	GetHtArwWidthH () const;
	virtual long	GetHtArwHeight () const;
	virtual long	GetHtLineIntroX () const;
	virtual long	GetHtBoxIconW () const;
	virtual long	GetHtBoxIconH () const;
	virtual long	GetHtHiForkTagGapX () const;
	virtual long	GetHtInterLineX () const;
	virtual long	GetHtInterLineY () const;
	virtual long	GetHtBoxIconMarginL () const;
	virtual long	GetHtBoxIconMarginT () const;
	virtual long	GetHtBoxTextMarginL () const;
	virtual long	GetHtBoxTextMarginT () const;
	virtual long	GetHtBoxTextMarginR () const;
	virtual long	GetHtBoxTextMarginB () const;
	virtual long	GetHtBoxTextLineGap () const;
	virtual long	GetHtBoxTextColumn () const;
	virtual long	GetHtBoxTextLine () const;

	virtual long	CalcTimeViewWidth () const;
	virtual CSize	GetExpBoxSize () const;
	virtual long	GetExpBoxGap () const;

// 06.01.30 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	IsVirtualTableRecordModified (FCHiProject& project) const;
	virtual BOOL	CheckFileUpdatedProject (FCHiProject& project);
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual BOOL	CheckFileUpdatedTree (	const longSet& stDocumentId,
//											const FCDbReadLockVector& vReadLock);
//	virtual BOOL	CheckFileUpdatedBranch (const longSet& stDocumentId,
//											const FCDbReadLockVector& vReadLock);
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual BOOL	CheckFileUpdatedTree (	const longSet& stDocumentId,
											const FCDbLockBank& lockBank);
	virtual BOOL	CheckFileUpdatedBranch (const longSet& stDocumentId,
											const FCDbLockBank& lockBank);
//----- 06.02.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	virtual FCDocRecExtData*	GetDocRecExtData (long lDocId);
	virtual const FCDocRecExtData*	GetDocRecExtData (long lDocId) const;
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL		IsProjectOpened () const;
	virtual long		SubDocumentIdToTopId (long lDocId) const;
	virtual WString		GetProjectTitle () const;
	virtual FDSECTIME	GetProjectDate () const;
	virtual BOOL		GetProjectIsUnknownFile () const;
	virtual GUID		GetProjectUserId () const;
	virtual WString		GetProjectComment () const;
	virtual WString		GetProjectHintText () const;
	virtual WString		UserIdToUserName (const GUID& guidUserId) const;
//----- 06.01.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
// 06.05.29 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	IsProjectUnknownFile () const;

protected:
	virtual void	CalcLayoutProject ();
	virtual CPoint	CalcLayoutProjectSub (long lDocId, const CRect& rtBox);
	virtual void	CalcLayoutTree (long lDocId);
	virtual void	CalcLayoutBranch (long lDocId);

	virtual DocIdToHTreeRecMap&	GetDocIdToHTreeRecMap ();
	virtual const DocIdToHTreeRecMap&	GetDocIdToHTreeRecMap () const;

protected:
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FCHiProject			m_project;					// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//	FCDbReadLock		m_autoLockProjectRead;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDiNiDgCiDeOjHhAjFmPjAjEiBeC_xHqqkZx_
//----- 06.01.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	FCProjectCopy		m_projectCopy;				// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDhDiBfLiBeC_xHqqkZx_
	FCDocRecExtDataFactory	m_factory;				// _xZkqqHx_iDhEiDeAiDeOiDgHiDiKiBfLiBeC_xHqqkZx_

//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	WString				m_wstrProjectTitle;			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
//	FDSECTIME			m_fdstProjectDate;			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMjDpKiOjOiBeC_xHqqkZx_
//	BOOL				m_bProjectIsUnknownFile;	// _xZkqqHx_iIoKiOjOjDeJiDhGiDiNiDfHiDeGiDeOiDgHiCkJiBeI_xHqqkZx_
//	GUID				m_guidProjectUserId;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiNoMjAkMiOnC_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
//	WString				m_wstrProjectComment;		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDfCiDiBiDjDiDgHiBeC_xHqqkZx_
//	GuidToUserNameMap	m_mpUserIdToName;			// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmM_xHqqkZx_UserId->Name_xZkqqHx_iBeC_xHqqkZx_
//----- 06.01.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	CPoint				m_ptMostRightBottom;		// _xZkqqHx_iNmFiJeFiJlKiCmMiNmAjFfHiBeCjGnIiNfMjBkCiCkKjAoIiCnPiCoJjBoFiCkLiClDiBeC_xHqqkZx_
// 06.01.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	DocIdToDocRecExtMap	m_mpDocIdToDocRecExt;		// _xZkqqHx_jFlGiPjB_xHqqkZx_ID->FCDocRecData_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	DocIdToHTreeRecMap	m_mpDocIdToHTreeRec;		// _xZkqqHx_jFlGiPjB_xHqqkZx_ID->FCHTreeRec_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiBeC_xHqqkZx_


	FTHTViewMode		m_nViewMode;				// _xZkqqHx_iDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBeC_xHqqkZx_
	double				m_dFontZoom;				// _xZkqqHx_iDhEiDeIiDjDiDgHiDfJiBfLiDiAiBeC_xHqqkZx_

	longVector			m_vTopDocId;				// _xZkqqHx_iDgHiDgCiDhGiDiMiDhIiDiLiCmMjHjKjHpAjFlGiPjBiCmMiIoKjHjHiBeC_xHqqkZx_
	map<long, double>	m_mpTreeZoom;				// _xZkqqHx_jFlGiPjB_xHqqkZx_ID->_xZkqqHx_iDfJiBfLiDiAiDgFiBfLiDhFiDiLiBgJjHjKjHpAjGnIiNfMjBkCiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBgK_xHqqkZx_
	map<long, double>	m_mpBranchZoom;				// _xZkqqHx_jFlGiPjB_xHqqkZx_ID->_xZkqqHx_iDfJiBfLiDiAiDgFiBfLiDhFiDiLiBgJiMmCjFmKjHjKjHpAiOhNiDfIiDeOiDiKiBfLiDjDiDiCiBfLiDgIiBgK_xHqqkZx_
}; // class FCHTreeManager.

#endif//__HTreeManager_h
