#include "stdafx.h"
#include "UtilStdLib.h"			// For m1_for.
#include "HistViewDoc.h"		// For FFImportSpotFile.
#include "FoundDoc.h"			// For CFCFoundDoc.
#include "HiSummaryTable.h"		// For FCHiSummaryTable.
#include "HiCommandTable.h"		// For FCHiCommandTable.
#include "HiSpotTable.h"		// For FCHiSpotTable.
#include "SearchParser.h"		// For FCSearchParser.
#include "HiProject.h"			// For FCHiProject.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "WndRichEdit.h"		// For CFCWndRichEdit.
#include "HistoryFindInfo.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////
// FCFindBaseInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::FCFindBaseInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo::FCFindBaseInfo ()
{
	m_pSP = NULL;							// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeCiMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	m_bLabelHitting = TRUE;					// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeCiMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
	m_fdstLimitTimeFrom = FDSECTIME_MIN;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	m_fdstLimitTimeUntil = FDSECTIME_MAX;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
} // FCFindBaseInfo::FCFindBaseInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::~FCFindBaseInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCiGjAgHiCkKiLpDiCmFiCkAiCmBiCmEiCoAiBeBiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClHiCoJiNnLiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo::~FCFindBaseInfo ()
{
} // FCFindBaseInfo::~FCFindBaseInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCpAiPiJiKpKiJlLiClHiCoJiBeCiDiBiDjDiDgPiBfLjFmPjAjEiCpAjAnNjCoIiClFiCmEiCkJiCoHiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindBaseInfo::Initialize (const HString& hstrProjectPath)
{
	return TRUE;
} // FCFindBaseInfo::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::IsThereTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindBaseInfo::IsThereTarget () const
{
	return TRUE;
} // FCFindBaseInfo::IsThereTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindBaseInfo::operator = (const FCFindBaseInfo& info)
{
	m_lDocumentId			= info.m_lDocumentId;
	m_fliNextSessionIndex	= info.m_fliNextSessionIndex;
	m_bIsSearchAbove		= info.m_bIsSearchAbove;
	m_bIsSearchSuper		= info.m_bIsSearchSuper;
	m_bIsSearchAboveBranch	= info.m_bIsSearchAboveBranch;
	m_bIsSearchBelow		= info.m_bIsSearchBelow;
	m_bIsSearchBelowBranch	= info.m_bIsSearchBelowBranch;

//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	m_pSP					= info.m_pSP;
	m_mpLabelIdToString		= info.m_mpLabelIdToString;
	m_bLabelHitting			= info.m_bLabelHitting;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	m_fdstLimitTimeFrom		= info.m_fdstLimitTimeFrom;
	m_fdstLimitTimeUntil	= info.m_fdstLimitTimeUntil;
	m_stLimitUserId			= info.m_stLimitUserId;
	m_mpFindRec				= info.m_mpFindRec;
} // FCFindBaseInfo::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::IsNeedIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindBaseInfo::IsNeedIndexFile () const
{
	return (m_pSP != NULL);
} // FCFindBaseInfo::IsNeedIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::Search1SessionAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCkKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate		:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_fliSessionIndex _xZkqqHx_iCmFiOkGiClDiCoKiCoJiDfKiDgCiDfGiDiHiDjDiBeB_xHqqkZx_
 *			_xZkqqHx_jBkGiClP_xHqqkZx_ NextSessionIndex _xZkqqHx_iCkK_xHqqkZx_ fliSessionIndex + 1 _xZkqqHx_iBgA_xHqqkZx_ fliSessionIndex
 *			_xZkqqHx_iCmJiInKiCoJiJnPjCpG_xHqqkZx_(_xZkqqHx_jFmPiNfI_xHqqkZx_)_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_fliSessionIndex _xZkqqHx_iCmFiOkGiClDiCoKiCoJiDfKiDgCiDfGiDiHiDjDiBeB_xHqqkZx_
 *			_xZkqqHx_jBkGiClP_xHqqkZx_ NextSessionIndex _xZkqqHx_iCkK_xHqqkZx_ fliSessionIndex _xZkqqHx_iBgA_xHqqkZx_ fliSessionIndex + 1
 *			_xZkqqHx_iCmJiInKiCoJiJnPjCpG_xHqqkZx_(_xZkqqHx_jFmPiNfI_xHqqkZx_)_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfCiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindBaseInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_pSP != NULL)
	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFjFlGiOjKjHpBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiIoKiCmCjBePiCmMiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjGnPiClHiBeC_xHqqkZx_
		FCStLabelOperateVector vLabelOperate;
		pHistoryIndex->SyncToSessionIndex(	fliSessionIndex,
											vLabelOperate);
		FCStLabelOperateVector::const_iterator iOil;
		for (iOil = vLabelOperate.begin(); iOil != vLabelOperate.end(); iOil++)
		{
			if ((*iOil).m_bIsCreate)
				m_mpLabelIdToString[(*iOil).m_dwLabelId] = (*iOil).m_wstrLabelText;
			else
				m_mpLabelIdToString.erase((*iOil).m_dwLabelId);
		}

		if (!vLabelOperate.empty())
		//----- _xZkqqHx_iDiJiDhIiDiLiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
			m_bLabelHitting = FALSE;
			ObjIdToWStringMap::const_iterator iOl;
			for (iOl = m_mpLabelIdToString.begin();
				 iOl != m_mpLabelIdToString.end(); iOl++)
			{
				// _xZkqqHx_jAnNjCoIjCiGiCmMiDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
				if (m_pSP->IsMatch((*iOl).second))
				{
					// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
					m_bLabelHitting = TRUE;
					break;
				}
			}
		}
	}
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCFindBaseInfo::Search1SessionAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::Search1SessionBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate		:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_fliSessionIndex _xZkqqHx_iCmFiOkGiClDiCoKiCoJiDfKiDgCiDfGiDiHiDjDiBeB_xHqqkZx_
 *			_xZkqqHx_jBkGiClP_xHqqkZx_ NextSessionIndex _xZkqqHx_iCkK_xHqqkZx_ fliSessionIndex + 1 _xZkqqHx_iBgA_xHqqkZx_ fliSessionIndex
 *			_xZkqqHx_iCmJiInKiCoJiJnPjCpG_xHqqkZx_(_xZkqqHx_jFmPiNfI_xHqqkZx_)_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_fliSessionIndex _xZkqqHx_iCmFiOkGiClDiCoKiCoJiDfKiDgCiDfGiDiHiDjDiBeB_xHqqkZx_
 *			_xZkqqHx_jBkGiClP_xHqqkZx_ NextSessionIndex _xZkqqHx_iCkK_xHqqkZx_ fliSessionIndex _xZkqqHx_iBgA_xHqqkZx_ fliSessionIndex + 1
 *			_xZkqqHx_iCmJiInKiCoJiJnPjCpG_xHqqkZx_(_xZkqqHx_jFmPiNfI_xHqqkZx_)_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfCiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindBaseInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_pSP != NULL)
	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFjFlGiOjKjHpBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjAgJiCnPiCoJiBeC_xHqqkZx_
		FCStLabelOperateVector vLabelOperate;
		pHistoryIndex->SyncToSessionIndex(	fliSessionIndex + 1,
											vLabelOperate);
		FCStLabelOperateVector::const_iterator iOil;
		for (iOil = vLabelOperate.begin(); iOil != vLabelOperate.end(); iOil++)
		{
			if ((*iOil).m_bIsCreate)
				m_mpLabelIdToString[(*iOil).m_dwLabelId] = (*iOil).m_wstrLabelText;
			else
				m_mpLabelIdToString.erase((*iOil).m_dwLabelId);
		}

		if (!vLabelOperate.empty())
		//----- _xZkqqHx_iDiJiDhIiDiLiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
			m_bLabelHitting = FALSE;
			ObjIdToWStringMap::const_iterator iOl;
			for (iOl = m_mpLabelIdToString.begin();
				 iOl != m_mpLabelIdToString.end(); iOl++)
			{
				// _xZkqqHx_jAnNjCoIjCiGiCmMiDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
				if (m_pSP->IsMatch((*iOl).second))
				{
					// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
					m_bLabelHitting = TRUE;
					break;
				}
			}
		}
	}
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCFindBaseInfo::Search1SessionBelow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::Search1InterSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pForkData			:_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 7_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindBaseInfo::Search1InterSession (	const FCFindForkData* pForkData,
											FCHiProject* pProject,
											FCHiSummaryTable* pHistoryIndex,
											flint fliNextSessionIndex)
{
} // FCFindBaseInfo::Search1InterSession.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::CanAppendFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCmMjCmHiJmBiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidSessionUser	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindBaseInfo::CanAppendFindRec (	flint fliSessionIndex,
										FDSECTIME fdstSessionTime,
										GUID guidSessionUser) const
{
	// _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNjGlDiPpAiMiPiCmFjFjMiLeBiBeC_xHqqkZx_
	if (!m_bLabelHitting) return FALSE;
	// _xZkqqHx_iOjOiKnEiCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
	if (fdstSessionTime < m_fdstLimitTimeFrom ||
		m_fdstLimitTimeUntil < fdstSessionTime) return FALSE;
	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
	if (!m_stLimitUserId.empty() &&
		m_stLimitUserId.find(guidSessionUser) == m_stLimitUserId.end())
		return FALSE;
	return TRUE;
} // FCFindBaseInfo::CanAppendFindRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindBaseInfo::AppendFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidSessionUser	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindBaseInfo::AppendFindRec (FTHFRecType recType,
									flint fliSessionIndex,
									FDSECTIME fdstSessionTime,
									GUID guidSessionUser,
									const wchar_t* wcpComment,
									long lId)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iOjOiKnEiCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
//	if (fdstSessionTime < m_fdstLimitTimeFrom ||
//		m_fdstLimitTimeUntil < fdstSessionTime) return;
//	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
//	if (!m_stLimitUserId.empty() &&
//		m_stLimitUserId.find(guidSessionUser) == m_stLimitUserId.end())
//		return;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNgJiNjOiCnNiPpAiMiPiCmJiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanAppendFindRec(	fliSessionIndex,
							fdstSessionTime,
							guidSessionUser)) return;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfGiDjDiDePiDiLiCmMiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, 0);
} // FCFindBaseInfo::AppendFindRec.

////////////////////////////////////////////////////////////////////////////
// FCFindObjDynabaseInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_
// 
// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iClOiCkPiCmFiCmIiCkNiBeBiDePiDiLiBfLiDhGiCmMiNfMjBkCiCoAiLeMjIfOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJjDoAiCmMjFjEjFgJiCmMjFnCiPfHiBeBiDePiDiLiBfLiDhGjFjEjFgJiCpAiNoNiPjMiClFiClNiCmGiCkLiCmMiDePiDiLiBfLiDhGiDiBiDjDiDgPiBfL_xHqqkZx_
// _xZkqqHx_iCmMiNoNiPjMiCmIiCmHiCmJjBmOiJjOiClHiCoJiCmJiCmNiBeBiNfMjBkCiCpAiLeMjIfOiClFiCmEiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// 
//                                          
//  _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiElGiEkKiEkKiEkKiElGiEkKiEkKiEkKiElGiEkKiEkKiEkKiEkKiEkK_xHqqkZx_
//            _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_        
//            _xZkqqHx_iEkA_xHqqkZx_ 5_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 9_xZkqqHx_iEkA_xHqqkZx_        
//            _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_        
//          _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_      
//        _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_    
//        _xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 8_xZkqqHx_iEkA_xHqqkZx_    
//        _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_    
//      _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_                          
//    _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_                        
//    _xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_                        
//    _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_                        
// 
// _xZkqqHx_iPoDjAhNiCmMiPoKiNiHiBeB_xHqqkZx_m_stObjectId_xZkqqHx_iBeB_xHqqkZx_m_mpGroupToMember_xZkqqHx_iCmJiCmNiImIiJlKiCmMiPoOjFpBiCkKiLeMjIfOiClDiCoKiCoJiBeC_xHqqkZx_
// 
// m_stObjectId = { 1,2,3,4,5,6,7,8,9 }
// m_mpGroupToMember = { { 3 -> {1,2} }
//                       { 5 -> {3,4} }
//                       { 9 -> {7,8} } }
// 
// 
// _xZkqqHx_iBjMjFjEjFgJ_xHqqkZx_5,6_xZkqqHx_iCpAiNoNiPjMiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//  _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiElGiEkKiEkKiEkKiElGiEkKiEkKiEkKiElGiEkKiEkKiEkKiEkKiEkK_xHqqkZx_
//            _xZkqqHx_iEkBiBgDiEkC_xHqqkZx_  _xZkqqHx_iEkBiBgDiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_        
//            _xZkqqHx_iBeG_xHqqkZx_ 5_xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ 6_xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 9_xZkqqHx_iEkA_xHqqkZx_        
//            _xZkqqHx_iEkEiBgDiEkD_xHqqkZx_  _xZkqqHx_iEkEiBgDiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_        
//          _xZkqqHx_iEkBiBgDiEkIiBgDiEkC_xHqqkZx_      _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_      
//        _xZkqqHx_iEkBiBgDiEkC_xHqqkZx_  _xZkqqHx_iEkBiBgDiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_    
//        _xZkqqHx_iBeG_xHqqkZx_ 3_xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ 4_xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 8_xZkqqHx_iEkA_xHqqkZx_    
//        _xZkqqHx_iEkEiBgDiEkD_xHqqkZx_  _xZkqqHx_iEkEiBgDiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_    
//      _xZkqqHx_iEkBiBgDiEkIiBgDiEkC_xHqqkZx_                          
//    _xZkqqHx_iEkBiBgDiEkC_xHqqkZx_  _xZkqqHx_iEkBiBgDiEkC_xHqqkZx_                        
//    _xZkqqHx_iBeG_xHqqkZx_ 1_xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ 2_xZkqqHx_iBeG_xHqqkZx_                        
//    _xZkqqHx_iEkEiBgDiEkD_xHqqkZx_  _xZkqqHx_iEkEiBgDiEkD_xHqqkZx_                        
// 
// m_stObjectId = { 7,8,9 }
// m_mpGroupToMember = { { 9 -> {7,8} } }
// 
// m_stObjectId _xZkqqHx_iCkJiCoH_xHqqkZx_ 5,6_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
// m_mpGroupToMember _xZkqqHx_iCkJiCoHiBeB_xHqqkZx_5,6_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
// m_mpGroupToMember _xZkqqHx_iCmFiNoNiPjMiClDiCoKiCoJjHhGjBgGiCmM_xHqqkZx_ second _xZkqqHx_iCmMjHhGjBgGiCpA_xHqqkZx_
// m_stObjectId_xZkqqHx_iBeB_xHqqkZx_m_mpGroupToMember _xZkqqHx_iCkJiCoHiNoNiPjMiBeC_xHqqkZx_
// _xZkqqHx_iNoNiPjMiClDiCoKiCoJjHhGjBgGiCkKiCmIiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
// 
// 
// _xZkqqHx_iBjMjFjEjFgJ_xHqqkZx_5_xZkqqHx_iCpAiDePiDiLiBfLiDhGiJpAiPjMiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//  _xZkqqHx_iEkKiEkKiEkKiEkKiElGiEkKiEkKiEkKiElGiEkKiEkKiEkKiElGiEkKiEkKiEkKiElGiEkKiEkKiEkK_xHqqkZx_
//        _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_    
//        _xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 9_xZkqqHx_iEkA_xHqqkZx_    
//        _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_    
//      _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_              _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_  
//    _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_          _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_
//    _xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 8_xZkqqHx_iEkA_xHqqkZx_
//    _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_          _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_
// 
// m_stObjectId = { 1,2,3,4,6,7,8,9 }
// m_mpGroupToMember = { { 3 -> {1,2} }
//                       { 9 -> {7,8} } }
// 
// m_stObjectId _xZkqqHx_iCkJiCoH_xHqqkZx_ 5 _xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
// m_mpGroupToMember _xZkqqHx_iCkJiCoH_xHqqkZx_ { 5 -> {3,4} } _xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
// { 3 -> {1,2} } _xZkqqHx_iCmNiNoNiPjMiClDiCoKiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// 
// 
// _xZkqqHx_iBjMjFjEjFgJ_xHqqkZx_6,9,10_xZkqqHx_iCpAiDePiDiLiBfLiDhGiJlLiClHiCoJiPoKiNiHiBeC_xHqqkZx_
//  _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiElGiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiElGiEkKiEkKiEkKiEkKiEkK_xHqqkZx_
//            _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_              _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_
//            _xZkqqHx_iEkA_xHqqkZx_ 5_xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_11_xZkqqHx_iEkA_xHqqkZx_
//            _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_              _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_
//          _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_      _xZkqqHx_iEkBiEjPiEjPiEjPiEkJiEjPiEjPiEjPiEkC_xHqqkZx_
//        _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_
//        _xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 9_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_10_xZkqqHx_iEkA_xHqqkZx_
//        _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEkGiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_
//      _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_              _xZkqqHx_iEkBiEjPiEkIiEjPiEkC_xHqqkZx_      
//    _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_          _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_  _xZkqqHx_iEkBiEkIiEkC_xHqqkZx_    
//    _xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ 8_xZkqqHx_iEkA_xHqqkZx_    
//    _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_          _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_    
// 
// m_stObjectId = { 1,2,3,4,6,7,8,9,11 }
// m_mpGroupToMember = { { 3 -> {1,2} }
//                       { 9 -> {7,8} }
//                       { 11 -> {6,9} } }
// 
// m_stObjectId _xZkqqHx_iCmJ_xHqqkZx_ 11 _xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
// m_mpGroupToMember _xZkqqHx_iCmJ_xHqqkZx_ { 11 -> {6,9} } _xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
// m_stObjectId_xZkqqHx_iBeB_xHqqkZx_m_mpGroupToMember _xZkqqHx_iCmHiClPiCoHiCmJiCoA_xHqqkZx_
// 10 _xZkqqHx_iCmNjCmHiJmBiClDiCoKiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
// 

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjDynabaseInfo::~FCFindObjDynabaseInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCiGjAgHiCkKiLpDiCmFiCkAiCmBiCmEiCoAiBeBiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClHiCoJiNnLiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindObjDynabaseInfo::~FCFindObjDynabaseInfo ()
{
} // FCFindObjDynabaseInfo::~FCFindObjDynabaseInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindObjDynabaseInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindObjDynabaseInfo* pInfo = (const FCFindObjDynabaseInfo*)&info;

	m_stObjectId			= pInfo->m_stObjectId;
	m_stTopObjectId			= pInfo->m_stTopObjectId;

//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_pSP					= pInfo->m_pSP;
//	m_mpLabelIdToString		= pInfo->m_mpLabelIdToString;
//	m_bLabelHitting			= pInfo->m_bLabelHitting;
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
} // FCFindObjDynabaseInfo::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjDynabaseInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindObjDynabaseInfo::IsNeedCommandFile () const
{
	return TRUE;
} // FCFindObjDynabaseInfo::IsNeedCommandFile.

//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjDynabaseInfo::IsNeedIndexFile
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCFindObjDynabaseInfo::IsNeedIndexFile () const
//{
//	return (m_pSP != NULL);
//} // FCFindObjDynabaseInfo::IsNeedIndexFile.
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjDynabaseInfo::SetTargetObjects
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiPfHiNiHiCpAiBeBiClBiCmMjFjEjFgJiMjPiNpFiPoOjFpBjFmPjAjEiCmJiMjPiNpFjBmOiPnLiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmNiBeBiDePiDiLiBfLiDhGjFjEjFgJiCmFiKeLjBhHiNfMjBkCiCpAiNoMiCmBiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAiMjPiNpFiClHiCoJiNnLiBeBiDePiDiLiBfLiDhGiCmMiDgHiDgCiDhGjFjEjFgJiCmGiMjPiNpFjBmOiPnLjFjEjFgJiCkKjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iMjPiNpFjBmOiPnLjFjEjFgJiCmNiBeBiKfEjEePiCmGiClFiCmEiCmNiBeBjBiAiNoMjFjEjFgJiCpAjBiAiNoMiClHiCoJiClBiCmGiCmFiBeBiOmAiOlPjDeJiCmJ_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIiClDiCoKiClNjFjEjFgJiBeCjBkGiClPjFjEjFgJjFmPiNfIiCmMiMjPiNpFjBmOiPnLiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmNiBhFiOmAiOlPjDeJiCmJjFmPiNfIiClDiCoKiClNjFjEjFgJiBhGiCmMjBmOiPnLiCmJiCmNiKnMiCnMiCoKiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iDgAiDgCiDhGiDhNiDfIiDfOiBfLjFjEjFgJ_xHqqkZx_(FCObjChipMaster)_xZkqqHx_iBeBiDhDiDeOiDgAiDiDjGoOiIpDjFjEjFgJ_xHqqkZx_(FCObjPictArrow)_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iDgFiBfLiDhFiDiLjFjEjFgJ_xHqqkZx_(FCObjTable)_xZkqqHx_iCmGiCkCiCmBiClNiBeBiDePiDiLiBfLiDhGjFjEjFgJ_xHqqkZx_(FCObjGroup)_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_iDfEiDhFiDeOiDiJiDfIjFjEjFgJiCmNiBeBiDePiDiLiBfLiDhGiCmMiJpAiPjMiCmGiCkCiCmBiClNjBiAiNoMiCkKiPgPjHiIiCmIiCkCiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmGiClFiCmEiCnNiCmIiClDiCoKiClIiBeBiClLiCoKiOkJjAgHiCkKiMjPiNpFjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmE_xHqqkZx_ _xZkqqHx_jFjEjFgJiCgEiBeBiCgFiBeBiCgGiBeBiCgHiBeBiCgIiCkKiDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDgHiDgCiDhGjFjEjFgJiCmNiCgIiBeBiMjPiNpFjBmOiPnLjFjEjFgJiCmN_xHqqkZx_ _xZkqqHx_iCgAiBeBiCgBiBeBiCgCiBeBiCgDiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *           _xZkqqHx_iEkBiCgIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *           _xZkqqHx_iEkAiEkBiCgHiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkCiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkAiEkBiCgGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_                _xZkqqHx_iEkAiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkAiEkAiEkBiCgEiEjPiEjPiEjPiEjPiEjPiEkCiEkAiEkBiCgFiEjPiEjPiEjPiEjPiEjPiEkCiEkAiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkAiEkAiEkAiEkBiCgAiEkCiEkBiCgBiEkCiEkAiEkAiEkAiEkBiCgCiEkCiEkBiCgDiEkCiEkAiEkAiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkAiEkAiEkAiEkA_xHqqkZx_  _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkAiEkAiEkAiEkAiEkA_xHqqkZx_  _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkAiEkAiEkAiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkAiEkAiEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkAiEkAiEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkAiEkAiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkAiEkAiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkAiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkAiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkAiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_                _xZkqqHx_iEkAiEkA_xHqqkZx_
 *           _xZkqqHx_iEkAiEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 *			_xZkqqHx_iJlKjAhNiCmJiCkIiCkCiCmE_xHqqkZx_ _xZkqqHx_jFjEjFgJiCgEiBeBiCgFiBeBiCgHiBeBiCgIiCkKiDePiDiLiBfLiDhGjFjEjFgJiBeB_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCgGiCkKiDgAiDgCiDhGiDhNiDfIiDfOiBfLjFjEjFgJiCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iDgHiDgCiDhGjFjEjFgJiCmNiCgIiBeBiMjPiNpFjBmOiPnLjFjEjFgJiCmNiCgGiBeBiCgCiBeBiCgDiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iMjPiNpFjBmOiPnLjFjEjFgJiCpAjEkNiMkJiClHiCoJiDeBiDiLiDfDiDiKiDfJiDiAiCmNiOjPiCmMjCmKiCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeEiOhBiCmMjFjEjFgJiCpAiIoKiCmCiClIiCmCjBfDiCmEjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeEjFjEjFgJiCkKiDePiDiLiBfLiDhGjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiHiBeBiMjPiNpFjBmOiPnLjFjEjFgJiCmJjCmHiJmBjDgPjIfOiClFiCmEiBeBiPeJjHlJiBeC_xHqqkZx_
 *				_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiHiBeBiOhBiCmMjFjEjFgJiIoKiCmCiClIiCmCiCmJiKnGiClFiCmEiCfAiBgAiCfBiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindObjDynabaseInfo::SetTargetObjects (const ObjDynabaseVector& vObj)
{
	struct my
	{
		static void GetChildTop (DWORDSet& stTargetObjId, const FCObjDynabase* pObj)
		{
			if (pObj->Type() != FDOJ_GROUP)
			//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiImIiKePiCmIiCoHiBeBiMjPiNpFjBmOiPnLjFjEjFgJiCmMiMpDjFoCiBeC_xHqqkZx_
				stTargetObjId.insert(pObj->GetObjID());
			} else
			//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOhBjFjEjFgJiCpAiNmEiLeBjDeJiCmJjClCiCnHiCoJiBeC_xHqqkZx_
				for (long lIndex = 0; lIndex != pObj->GetMemberSize(); lIndex++)
					GetChildTop(stTargetObjId, pObj->GetMember(lIndex));
			}
		}
	};
	mdef_const_iterator(ObjDynabaseVector, iObj);
	m1_for (iObj, vObj)
	{
		// _xZkqqHx_iDgHiDgCiDhGjFjEjFgJiDiKiDfIiDgHiCmJjCmHiJmBiBeC_xHqqkZx_
		m_stTopObjectId.insert((*iObj)->GetObjID());
		// _xZkqqHx_iOhBjFjEjFgJiCmMiMjPiNpFjBmOiPnLjFjEjFgJiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		my::GetChildTop(m_stObjectId, *iObj);
	}
} // FCFindObjDynabaseInfo::SetTargetObjects.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjDynabaseInfo::Search1SessionAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindObjDynabaseInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
													FCHiSummaryTable* pHistoryIndex,
													flint fliSessionIndex)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_pSP != NULL)
//	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFjFlGiOjKjHpBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiIoKiCmCjBePiCmMiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjGnPiClHiBeC_xHqqkZx_
//		FCStLabelOperateVector vLabelOperate;
//		pHistoryIndex->SyncToSessionIndex(	fliSessionIndex,
//											vLabelOperate);
//		FCStLabelOperateVector::const_iterator iOil;
//		for (iOil = vLabelOperate.begin(); iOil != vLabelOperate.end(); iOil++)
//		{
//			if ((*iOil).m_bIsCreate)
//				m_mpLabelIdToString[(*iOil).m_dwLabelId] = (*iOil).m_wstrLabelText;
//			else
//				m_mpLabelIdToString.erase((*iOil).m_dwLabelId);
//		}
//
//		if (!vLabelOperate.empty())
//		//----- _xZkqqHx_iDiJiDhIiDiLiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//			m_bLabelHitting = FALSE;
//			ObjIdToWStringMap::const_iterator iOl;
//			for (iOl = m_mpLabelIdToString.begin();
//				 iOl != m_mpLabelIdToString.end(); iOl++)
//			{
//				// _xZkqqHx_jAnNjCoIjCiGiCmMiDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
//				if (m_pSP->IsMatch((*iOl).second))
//				{
//					// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//					m_bLabelHitting = TRUE;
//					break;
//				}
//			}
//		}
//	}
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeC_xHqqkZx_
	BASE_CLASS::Search1SessionAbove(pCmdGate,
									pHistoryIndex,
									fliSessionIndex);
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jGnPiClHjBePiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFjDjJiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
	const FDSECTIME fdstSessionTime = pCmdGate->GetPrevSessionTime();
	const GUID guidSessionUser = pCmdGate->GetPrevSessionUser();

	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjGjGjEpGiCnGiBeC_xHqqkZx_
	pCmdGate->BufferSeek(0, CFile::end);

	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
	FTHFRecType recTypeHit = FDHF_NONE;
	do
	{
		FTGateCmd cmd;
		DWORDSet stInsTopObjId;
		DWORDSet stDelTopObjId;
		DWORDSet stEdtTopObjId;
		DWORDSet stInsObjId;
		DWORDSet stDelObjId;
		DWORDSet stEdtObjId;
		FCLinkMolipInfo linkMolipIns;
		FCLinkMolipInfo linkMolipDel;
		// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
		pCmdGate->RSkipCmd(	cmd,
							stInsTopObjId,
							stDelTopObjId,
							stEdtTopObjId,
							stInsObjId,
							stDelObjId,
							stEdtObjId,
							linkMolipIns,
							linkMolipDel);

		if (recTypeHit == FDHF_NONE)
		//----- _xZkqqHx_jGkCiClOiMjPiNpFiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
			const FTHFRecType recType = IsHitCommandAbove(cmd, stInsObjId, stDelObjId, stEdtObjId, linkMolipIns, linkMolipDel);
			if (recType != FDHF_NONE)
				recTypeHit = recType;
		}
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
		FFErase(m_stObjectId, stDelObjId);
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgHiDgCiDhGjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNiDgHiDgCiDhGjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
		FFErase(m_stTopObjectId, stDelTopObjId);
	} while (pCmdGate->GetBufferPosition() != 0);

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	pCmdGate->DeleteSessionReadBuffer();

	if (recTypeHit != FDHF_NONE)
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendFindRec(recTypeHit, fliSessionIndex + 1, fdstSessionTime, guidSessionUser, L"", 0);
	}
} // FCFindObjDynabaseInfo::Search1SessionAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjDynabaseInfo::Search1SessionBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate		:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_fliSessionIndex _xZkqqHx_iCmFiOkGiClDiCoKiCoJiDfKiDgCiDfGiDiHiDjDiBeB_xHqqkZx_
 *			_xZkqqHx_jBkGiClP_xHqqkZx_ NextSessionIndex _xZkqqHx_iCkK_xHqqkZx_ fliSessionIndex + 1 _xZkqqHx_iBgA_xHqqkZx_ fliSessionIndex
 *			_xZkqqHx_iCmJiInKiCoJiJnPjCpG_xHqqkZx_(_xZkqqHx_jFmPiNfI_xHqqkZx_)_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_fliSessionIndex _xZkqqHx_iCmFiOkGiClDiCoKiCoJiDfKiDgCiDfGiDiHiDjDiBeB_xHqqkZx_
 *			_xZkqqHx_jBkGiClP_xHqqkZx_ NextSessionIndex _xZkqqHx_iCkK_xHqqkZx_ fliSessionIndex _xZkqqHx_iBgA_xHqqkZx_ fliSessionIndex + 1
 *			_xZkqqHx_iCmJiInKiCoJiJnPjCpG_xHqqkZx_(_xZkqqHx_jFmPiNfI_xHqqkZx_)_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionAbove _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1SessionBelow _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfCiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindObjDynabaseInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
													FCHiSummaryTable* pHistoryIndex,
													flint fliSessionIndex)
{
	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjAoGjDkKiCnGiBeC_xHqqkZx_
	pCmdGate->BufferSeek(0, CFile::begin);

	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
	FTHFRecType recTypeHit = FDHF_NONE;
	do
	{
		FTGateCmd cmd;
		DWORDSet stInsTopObjId;
		DWORDSet stDelTopObjId;
		DWORDSet stEdtTopObjId;
		DWORDSet stInsObjId;
		DWORDSet stDelObjId;
		DWORDSet stEdtObjId;
		FCLinkMolipInfo linkMolipIns;
		FCLinkMolipInfo linkMolipDel;
		// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
		pCmdGate->SkipCmd(	cmd,
							stInsTopObjId,
							stDelTopObjId,
							stEdtTopObjId,
							stInsObjId,
							stDelObjId,
							stEdtObjId,
							linkMolipIns,
							linkMolipDel);

		if (recTypeHit == FDHF_NONE)
		//----- _xZkqqHx_jGkCiClOiMjPiNpFiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
			const FTHFRecType recType = IsHitCommandBelow(cmd, stInsObjId, stDelObjId, stEdtObjId, linkMolipIns, linkMolipDel);
			if (recType != FDHF_NONE)
				recTypeHit = recType;
		}
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
		FFErase(m_stObjectId, stDelObjId);
		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgHiDgCiDhGjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNiDgHiDgCiDhGjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
		FFErase(m_stTopObjectId, stDelTopObjId);
	} while (pCmdGate->GetBufferPosition() != pCmdGate->GetBufferLength());

	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	pCmdGate->DeleteSessionReadBuffer();

	if (recTypeHit != FDHF_NONE)
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendFindRec(recTypeHit, fliSessionIndex + 1, pCmdGate->GetPrevSessionTime(), pCmdGate->GetPrevSessionUser(), L"", 0);
	}

//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_pSP != NULL)
//	//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFjFlGiOjKjHpBiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjAgJiCnPiCoJiBeC_xHqqkZx_
//		FCStLabelOperateVector vLabelOperate;
//		pHistoryIndex->SyncToSessionIndex(	fliSessionIndex + 1,
//											vLabelOperate);
//		FCStLabelOperateVector::const_iterator iOil;
//		for (iOil = vLabelOperate.begin(); iOil != vLabelOperate.end(); iOil++)
//		{
//			if ((*iOil).m_bIsCreate)
//				m_mpLabelIdToString[(*iOil).m_dwLabelId] = (*iOil).m_wstrLabelText;
//			else
//				m_mpLabelIdToString.erase((*iOil).m_dwLabelId);
//		}
//
//		if (!vLabelOperate.empty())
//		//----- _xZkqqHx_iDiJiDhIiDiLiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//			m_bLabelHitting = FALSE;
//			ObjIdToWStringMap::const_iterator iOl;
//			for (iOl = m_mpLabelIdToString.begin();
//				 iOl != m_mpLabelIdToString.end(); iOl++)
//			{
//				// _xZkqqHx_jAnNjCoIjCiGiCmMiDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
//				if (m_pSP->IsMatch((*iOl).second))
//				{
//					// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//					m_bLabelHitting = TRUE;
//					break;
//				}
//			}
//		}
//	}
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeC_xHqqkZx_
	BASE_CLASS::Search1SessionBelow(pCmdGate,
									pHistoryIndex,
									fliSessionIndex);
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCFindObjDynabaseInfo::Search1SessionBelow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjDynabaseInfo::AppendFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidSessionUser	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCkKjIeBjBlBiClHiCoJiPoKiNiHiBeBjBfDiCmEiCpAiLeMjIfOiClJiClIiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCmMiNmFiPiJiCmGiNmFiMoDiCpAjEmNiImNiCmGiClFiCmEiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMiLiJmKiCpAjCmHiJmBiClHiCoJiPoKiNiHiBeBiImIiJlKiCmMiCoGiCkEiCmJ_xHqqkZx_ a_xZkqqHx_iBgA_xHqqkZx_i_xZkqqHx_iBeB_xHqqkZx_l_xZkqqHx_iBgA_xHqqkZx_n _xZkqqHx_iCmMiPoKiNiHiCkKiCkAiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_iOmAiNnLiCmNiDfKiDgCiDfGiDiHiDjDiCpAiIoKjFpLiMpMiCnGjIeBjBlBiClFiCmEiMjPiNpFiClHiCoJiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_jEmNiImNiCmMjCiGiBgJ_xHqqkZx_c_xZkqqHx_iBgA_xHqqkZx_g_xZkqqHx_iBeB_xHqqkZx_m_xZkqqHx_iBgKiCnGiCmMjCmHiJmBiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
 *
 *            a _xZkqqHx_iBkI_xHqqkZx_
 *            b _xZkqqHx_iBkI_xHqqkZx_
 *            c _xZkqqHx_iBkIiEkB_xHqqkZx_ From (m_iAreaFlag = -1)
 *            d _xZkqqHx_iBkIiEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_
 *            e _xZkqqHx_iBkIiEkA_xHqqkZx_
 *                _xZkqqHx_iEkA_xHqqkZx_
 *            f _xZkqqHx_iBkIiEkA_xHqqkZx_
 *            g _xZkqqHx_iBkIiEkE_xHqqkZx_ Until (m_iAreaFlag = 1)
 *            h _xZkqqHx_iBkI_xHqqkZx_
 *            i _xZkqqHx_iBkI_xHqqkZx_
 *
 *            l _xZkqqHx_iBkI_xHqqkZx_
 *            m _xZkqqHx_iBkI_xHqqkZx_ Single (m_iAreaFlag = 0)
 *            n _xZkqqHx_iBkI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindObjDynabaseInfo::AppendFindRec (	FTHFRecType recType,
											flint fliSessionIndex,
											FDSECTIME fdstSessionTime,
											GUID guidSessionUser,
											const wchar_t* wcpComment,
											long lId)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNjGlDiPpAiMiPiCmFjFjMiLeBiBeC_xHqqkZx_
//	if (!m_bLabelHitting) return;
////----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//	// _xZkqqHx_iOjOiKnEiCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
//	if (fdstSessionTime < m_fdstLimitTimeFrom ||
//		m_fdstLimitTimeUntil < fdstSessionTime) return;
//	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
//	if (!m_stLimitUserId.empty() &&
//		m_stLimitUserId.find(guidSessionUser) == m_stLimitUserId.end())
//		return;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNgJiNjOiCnNiPpAiMiPiCmJiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanAppendFindRec(	fliSessionIndex,
							fdstSessionTime,
							guidSessionUser)) return;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	map<flint, FindRec>::iterator iIdr;
	iIdr = m_mpFindRec.find(fliSessionIndex - 1);
	if (iIdr != m_mpFindRec.end())
	//----- _xZkqqHx_iIoKiCmCjBePiCmMiDfKiDgCiDfGiDiHiDjDiCmJiDiMiDfCiBfLiDgIiCkKiCkAiCoJiPoKiNiHiBgJ_xHqqkZx_h_xZkqqHx_iBeB_xHqqkZx_n_xZkqqHx_iBgK_xHqqkZx_-----
	{
		if ((*iIdr).second.m_iAreaFlag == 0)
		//----- _xZkqqHx_iIoKiCmCjBePiCmMiDiMiDfCiBfLiDgIiCkKiDfGiDjDiDePiDiLiBgJ_xHqqkZx_m_xZkqqHx_iBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiMiDfCiBfLiDgIiBgJ_xHqqkZx_m_xZkqqHx_iBgKiCpAjEmNiImNiOhHjCoIiCmMiNmFiPiJiCmJjFmPiNfIiBeC_xHqqkZx_
			(*iIdr).second.m_iAreaFlag = -1;
			// _xZkqqHx_iImKjChFiBgJ_xHqqkZx_n_xZkqqHx_iBgKiCmJjEmNiImNiOhHjCoIiCmMiNmFiMoDiCpAjCmHiJmBiBeC_xHqqkZx_
			m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, 1);
		} else
		//----- _xZkqqHx_iIoKiCmCjBePiCmMiDiMiDfCiBfLiDgIiCkKjEmNiImNiCmMiNmFiMoDiBgJ_xHqqkZx_g_xZkqqHx_iBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiMiDfCiBfLiDgIiBgJ_xHqqkZx_g_xZkqqHx_iBgKiCpAiNoNiPjM_xHqqkZx_
			m_mpFindRec.erase(iIdr);
			// _xZkqqHx_iImKjChFiBgJ_xHqqkZx_h_xZkqqHx_iBgKiCmJjEmNiImNiOhHjCoIiCmMiNmFiMoDiCpAjCmHiJmBiBeC_xHqqkZx_
			m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, 1);
		}
		return;
	}
	iIdr = m_mpFindRec.find(fliSessionIndex + 1);
	if (iIdr != m_mpFindRec.end())
	//----- _xZkqqHx_iIoKiCmCiMoDiCmMiDfKiDgCiDfGiDiHiDjDiCmJiDiMiDfCiBfLiDgIiCkKiCkAiCoJiPoKiNiHiBgJ_xHqqkZx_b_xZkqqHx_iBeB_xHqqkZx_l_xZkqqHx_iBgK_xHqqkZx_-----
	{
		if ((*iIdr).second.m_iAreaFlag == 0)
		//----- _xZkqqHx_iIoKiCmCiMoDiCmMiDiMiDfCiBfLiDgIiCkKiDfGiDjDiDePiDiLiBgJ_xHqqkZx_m_xZkqqHx_iBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiMiDfCiBfLiDgIiBgJ_xHqqkZx_m_xZkqqHx_iBgKiCpAjEmNiImNiOhHjCoIiCmMiNmFiMoDiCmJjFmPiNfIiBeC_xHqqkZx_
			(*iIdr).second.m_iAreaFlag = 1;
			// _xZkqqHx_iImKjChFiBgJ_xHqqkZx_l_xZkqqHx_iBgKiCmJjEmNiImNiOhHjCoIiCmMiNmFiPiJiCpAjCmHiJmBiBeC_xHqqkZx_
			m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, -1);
		} else
		//----- _xZkqqHx_iIoKiCmCiMoDiCmMiDiMiDfCiBfLiDgIiCkKjEmNiImNiCmMiNmFiPiJiBgJ_xHqqkZx_c_xZkqqHx_iBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDiMiDfCiBfLiDgIiBgJ_xHqqkZx_c_xZkqqHx_iBgKiCpAiNoNiPjM_xHqqkZx_
			m_mpFindRec.erase(iIdr);
			// _xZkqqHx_iImKjChFiBgJ_xHqqkZx_b_xZkqqHx_iBgKiCmJjEmNiImNiOhHjCoIiCmMiNmFiPiJiCpAjCmHiJmBiBeC_xHqqkZx_
			m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, -1);
		}
		return;
	}
	//----- _xZkqqHx_iIoKiCmCjBePiCmJiCoAiBeBiMoDiCmJiCoAiBeBiDiMiDfCiBfLiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_a_xZkqqHx_iBeB_xHqqkZx_i_xZkqqHx_iBgK_xHqqkZx_-----
	// _xZkqqHx_iDfGiDjDiDePiDiLiCmMiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, 0);
} // FCFindObjDynabaseInfo::AppendFindRec.

////////////////////////////////////////////////////////////////////////////
// FCFindObjectInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjectInfo::~FCFindObjectInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCiGjAgHiCkKiLpDiCmFiCkAiCmBiCmEiCoAiBeBiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClHiCoJiNnLiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindObjectInfo::~FCFindObjectInfo ()
{
} // FCFindObjectInfo::~FCFindObjectInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindObjectInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindObjectInfo* pInfo = (const FCFindObjectInfo*)&info;

	m_bFindCreateObject	= pInfo->m_bFindCreateObject;
	m_bFindDeleteObject	= pInfo->m_bFindDeleteObject;
	m_bFindModifyObject	= pInfo->m_bFindModifyObject;
	m_bFindModifyText	= pInfo->m_bFindModifyText;
} // FCFindObjectInfo::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjectInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindObjectInfo::Duplicate () const
{
	FCFindObjectInfo* pInfo = new FCFindObjectInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindObjectInfo::Duplicate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjectInfo::IsThereTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindObjectInfo::IsThereTarget () const
{
	return !m_stObjectId.empty();
} // FCFindObjectInfo::IsThereTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjectInfo::IsHitCommandAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfCiDhNiDjDiDgIiCpAiDfIiDeMiDgCiDhGiClFiClNiMiLiJmKiCkKiBeBiMjPiNpFiPpAiMiPiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cmd				:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stInsObjId		:_xZkqqHx_jCmHiJmBiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stDelObjId		:_xZkqqHx_iNoNiPjMiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stEdtObjId		:_xZkqqHx_jFmPiNfIiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipIns	:_xZkqqHx_jCmHiJmBiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipDel	:_xZkqqHx_iNoNiPjMiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTHFRecType FCFindObjectInfo::IsHitCommandAbove (	FTGateCmd cmd,
													const DWORDSet& stInsObjId,
													const DWORDSet& stDelObjId,
													const DWORDSet& stEdtObjId,
													const FCLinkMolipInfo& linkMolipIns,
													const FCLinkMolipInfo& linkMolipDel)
{
	// _xZkqqHx_iNoMjAkMiCmGiNoNiPjMiCmMiDeJiDhGiDfGiDiHiDjDiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
	Exchange(m_bFindCreateObject, m_bFindDeleteObject);
	// _xZkqqHx_iDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTHFRecType recType = IsHitCommandBelow(cmd,
											stInsObjId,
											stDelObjId,
											stEdtObjId,
											linkMolipIns,
											linkMolipDel);
	// _xZkqqHx_iNoMjAkMiCmGiNoNiPjMiCmMiDeJiDhGiDfGiDiHiDjDiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
	Exchange(m_bFindCreateObject, m_bFindDeleteObject);
	return recType;
} // FCFindObjectInfo::IsHitCommandAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindObjectInfo::IsHitCommandBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfCiDhNiDjDiDgIiCpAiDfIiDeMiDgCiDhGiClFiClNiMiLiJmKiCkKiBeBiMjPiNpFiPpAiMiPiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cmd				:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stInsObjId		:_xZkqqHx_jCmHiJmBiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stDelObjId		:_xZkqqHx_iNoNiPjMiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stEdtObjId		:_xZkqqHx_jFmPiNfIiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipIns	:_xZkqqHx_jCmHiJmBiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipDel	:_xZkqqHx_iNoNiPjMiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTHFRecType FCFindObjectInfo::IsHitCommandBelow (	FTGateCmd cmd,
													const DWORDSet& stInsObjId,
													const DWORDSet& stDelObjId,
													const DWORDSet& stEdtObjId,
													const FCLinkMolipInfo& linkMolipIns,
													const FCLinkMolipInfo& linkMolipDel)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNjGlDiPpAiMiPiCmFjFjMiLeBiBeC_xHqqkZx_
	if (!m_bLabelHitting)
		return FDHF_NONE;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	switch (cmd)
	{
	case FD_CMD_GROUP:		// _xZkqqHx_iDePiDiLiBfLiDhGiJlLiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_UNGROUP:	// _xZkqqHx_iDePiDiLiBfLiDhGiJpAiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		// _xZkqqHx_iDePiDiLiBfLiDhGiJlLiBeBiDePiDiLiBfLiDhGiJpAiPjMiCmNiBeBjFjEjFgJiNoMjAkMiBeFiNoNiPjMiCkKiCkAiCoJiCmMiClOiCkKiBeB_xHqqkZx_
		// _xZkqqHx_iClBiCoKiCmNiMjPiNpFjBmOiPnLiCmGiCmNiCmIiCoHiCmIiCkCiCmMiCmFiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
		break;
	case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
	case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		if (m_bFindModifyText)
		//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiG_xHqqkZx_ _xZkqqHx_iKiOiCmCjFjEjFgJiDgFiDeMiDfIiDgHjFnCiPfHiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (FFIsIntersect(m_stObjectId, stEdtObjId))
				return FDHF_OBJ_MODIFY;	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiBeC_xHqqkZx_
		}
		break;
	default:
		if (!stDelObjId.empty())
		//----- _xZkqqHx_iNoNiPjMiClDiCoKiClNjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDePiDiLiBfLiDhGiJlLiDfCiDhNiDjDiDgIiImIiKePiCmNiBeBiNoMjAkMiBeFiNoNiPjMiBeFjFnCiPfHiClDiCoKiClN_xHqqkZx_
			// _xZkqqHx_jFjEjFgJiCkKjDkPiOjOiCmJjEkNjAlGiClHiCoJiClBiCmGiCmNjGlDiCkCiBeC_xHqqkZx_
			ASSERT(stInsObjId.empty() && stEdtObjId.empty());
			if (m_bFindDeleteObject)
			//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiG_xHqqkZx_ _xZkqqHx_iKiOiCmCjFjEjFgJiNoNiPjMiCkKiMjPiNpFjBmOiPnLiCmMiPoKiNiH_xHqqkZx_ -----
			{
				if (FFIsIntersect(m_stObjectId, stDelObjId))
					return FDHF_OBJ_MODIFY;	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiBeC_xHqqkZx_
			}
		} else
		if (!stEdtObjId.empty())
		//----- _xZkqqHx_jFnCiPfHiClDiCoKiClNjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDePiDiLiBfLiDhGiJlLiDfCiDhNiDjDiDgIiImIiKePiCmNiBeBiNoMjAkMiBeFiNoNiPjMiBeFjFnCiPfHiClDiCoKiClN_xHqqkZx_
			// _xZkqqHx_jFjEjFgJiCkKjDkPiOjOiCmJjEkNjAlGiClHiCoJiClBiCmGiCmNjGlDiCkCiBeC_xHqqkZx_
			ASSERT(stInsObjId.empty() && stDelObjId.empty());

			if (m_bFindModifyObject)
			//----- _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiG_xHqqkZx_ _xZkqqHx_iKiOiCmCjFjEjFgJjFnCiPfHiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				if (FFIsIntersect(m_stObjectId, stEdtObjId))
					return FDHF_OBJ_MODIFY;	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiBeC_xHqqkZx_
			}
		}
		// _xZkqqHx_iNoMjAkMiClDiCoKiClNjFjEjFgJiBgJ_xHqqkZx_stInsObjId_xZkqqHx_iBgKiCmNiBeBiMjPiNpFiCmMjBmOiPnLiCmGiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	}
	return FDHF_NONE;
} // FCFindObjectInfo::IsHitCommandBelow.

////////////////////////////////////////////////////////////////////////////
// FCFindLinkInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLinkInfo::~FCFindLinkInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCiGjAgHiCkKiLpDiCmFiCkAiCmBiCmEiCoAiBeBiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoNiPjMiClHiCoJiNnLiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindLinkInfo::~FCFindLinkInfo ()
{
} // FCFindLinkInfo::~FCFindLinkInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindLinkInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindLinkInfo* pInfo = (const FCFindLinkInfo*)&info;

	m_bFindCreateLink		= pInfo->m_bFindCreateLink;
	m_bFindDeleteLink		= pInfo->m_bFindDeleteLink;
	m_bFindCreateInterLink	= pInfo->m_bFindCreateInterLink;
	m_bFindDeleteInterLink	= pInfo->m_bFindDeleteInterLink;
} // FCFindLinkInfo::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLinkInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindLinkInfo::Duplicate () const
{
	FCFindLinkInfo* pInfo = new FCFindLinkInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindLinkInfo::Duplicate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLinkInfo::IsThereTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindLinkInfo::IsThereTarget () const
{
	return !m_stTopObjectId.empty();
} // FCFindLinkInfo::IsThereTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLinkInfo::IsHitCommandAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfCiDhNiDjDiDgIiCpAiDfIiDeMiDgCiDhGiClFiClNiMiLiJmKiCkKiBeBiMjPiNpFiPpAiMiPiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cmd				:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stInsObjId		:_xZkqqHx_jCmHiJmBiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stDelObjId		:_xZkqqHx_iNoNiPjMiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stEdtObjId		:_xZkqqHx_jFmPiNfIiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipIns	:_xZkqqHx_jCmHiJmBiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipDel	:_xZkqqHx_iNoNiPjMiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTHFRecType FCFindLinkInfo::IsHitCommandAbove (	FTGateCmd cmd,
												const DWORDSet& stInsObjId,
												const DWORDSet& stDelObjId,
												const DWORDSet& stEdtObjId,
												const FCLinkMolipInfo& linkMolipIns,
												const FCLinkMolipInfo& linkMolipDel)
{
	// _xZkqqHx_iNoMjAkMiCmGiNoNiPjMiCmMiDeJiDhGiDfGiDiHiDjDiCpAjDpMiCoKjBnGiCkGiCoJiBeC_xHqqkZx_
	Exchange(m_bFindCreateLink, m_bFindDeleteLink);
	Exchange(m_bFindCreateInterLink, m_bFindDeleteInterLink);
	// _xZkqqHx_iDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	FTHFRecType recType = IsHitCommandBelow(cmd,
											stInsObjId,
											stDelObjId,
											stEdtObjId,
											linkMolipIns,
											linkMolipDel);
	// _xZkqqHx_iNoMjAkMiCmGiNoNiPjMiCmMiDeJiDhGiDfGiDiHiDjDiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
	Exchange(m_bFindCreateLink, m_bFindDeleteLink);
	Exchange(m_bFindCreateInterLink, m_bFindDeleteInterLink);
	return recType;
} // FCFindLinkInfo::IsHitCommandAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLinkInfo::IsHitCommandBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfCiDhNiDjDiDgIiCpAiDfIiDeMiDgCiDhGiClFiClNiMiLiJmKiCkKiBeBiMjPiNpFiPpAiMiPiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cmd				:_xZkqqHx_iDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stInsObjId		:_xZkqqHx_jCmHiJmBiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stDelObjId		:_xZkqqHx_iNoNiPjMiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stEdtObjId		:_xZkqqHx_jFmPiNfIiClDiCoKiClNjFjEjFgJiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipIns	:_xZkqqHx_jCmHiJmBiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			linkMolipDel	:_xZkqqHx_iNoNiPjMiClDiCoKiClNiDiKiDjDiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTHFRecType FCFindLinkInfo::IsHitCommandBelow (	FTGateCmd cmd,
												const DWORDSet& stInsObjId,
												const DWORDSet& stDelObjId,
												const DWORDSet& stEdtObjId,
												const FCLinkMolipInfo& linkMolipIns,
												const FCLinkMolipInfo& linkMolipDel)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCmJiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmNjGlDiPpAiMiPiCmFjFjMiLeBiBeC_xHqqkZx_
	if (!m_bLabelHitting)
		return FDHF_NONE;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if (linkMolipIns.m_dwLinkId != DWORD(-1))
	//----- _xZkqqHx_iDiKiDjDiDeOiCkKiNoMjAkMiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (m_bFindCreateLink)
		//----- _xZkqqHx_jFjEjFgJiMmCiBfIiCnGiCmMiDiKiDjDiDeOiNoMjAkMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_stTopObjectId.find(linkMolipIns.m_dwObjectIdFrom) != m_stTopObjectId.end() ||
				m_stTopObjectId.find(linkMolipIns.m_dwObjectIdTo) != m_stTopObjectId.end())
			//----- _xZkqqHx_iDiKiDjDiDeOjCfLiCmMjFjEjFgJiCmMiCmHiClPiCoHiCkJiCkKiMjPiNpFjFjEjFgJiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiBeC_xHqqkZx_
				return FDHF_LINK_MODIFY;
			}
		}
		if (m_bFindCreateInterLink)
		//----- _xZkqqHx_jFjEjFgJiKnEiDiKiDjDiDeOiCmMiNoMjAkMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_stTopObjectId.find(linkMolipIns.m_dwObjectIdFrom) != m_stTopObjectId.end() &&
				m_stTopObjectId.find(linkMolipIns.m_dwObjectIdTo) != m_stTopObjectId.end())
			//----- _xZkqqHx_iDiKiDjDiDeOjCfLiCmMjFjEjFgJiCmMjHlMjFpLiCkKiMjPiNpFjFjEjFgJiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiBeC_xHqqkZx_
				return FDHF_LINK_MODIFY;
			}
		}
	}
	if (linkMolipDel.m_dwLinkId != DWORD(-1))
	//----- _xZkqqHx_iDiKiDjDiDeOiCkKiNoNiPjMiClDiCoKiClNiPoKiNiH_xHqqkZx_ -----
	{
		if (m_bFindDeleteLink)
		//----- _xZkqqHx_jFjEjFgJiMmCiBfIiCnGiCmMiDiKiDjDiDeOiNoNiPjMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_stTopObjectId.find(linkMolipDel.m_dwObjectIdFrom) != m_stTopObjectId.end() ||
				m_stTopObjectId.find(linkMolipDel.m_dwObjectIdTo) != m_stTopObjectId.end())
			//----- _xZkqqHx_iDiKiDjDiDeOjCfLiCmMjFjEjFgJiCmMiCmHiClPiCoHiCkJiCkKiMjPiNpFjFjEjFgJiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiBeC_xHqqkZx_
				return FDHF_LINK_MODIFY;
			}
		}
		if (m_bFindDeleteInterLink)
		//----- _xZkqqHx_jFjEjFgJiKnEiDiKiDjDiDeOiCmMiNoNiPjMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_stTopObjectId.find(linkMolipDel.m_dwObjectIdFrom) != m_stTopObjectId.end() &&
				m_stTopObjectId.find(linkMolipDel.m_dwObjectIdTo) != m_stTopObjectId.end())
			//----- _xZkqqHx_iDiKiDjDiDeOjCfLiCmMjFjEjFgJiCmMjHlMjFpLiCkKiMjPiNpFjFjEjFgJiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiBeC_xHqqkZx_
				return FDHF_LINK_MODIFY;
			}
		}
	}
	return FDHF_NONE;
} // FCFindLinkInfo::IsHitCommandBelow.

////////////////////////////////////////////////////////////////////////////
// FCFindLabelInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::~FCFindLabelInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindLabelInfo::~FCFindLabelInfo ()
{
} // FCFindLabelInfo::FCFindLabelInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindLabelInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindLabelInfo* pInfo = (const FCFindLabelInfo*)&info;

	m_bFindCreateLabel	= pInfo->m_bFindCreateLabel;
	m_bFindDeleteLabel	= pInfo->m_bFindDeleteLabel;
	m_bFindTimeLabel	= pInfo->m_bFindTimeLabel;
	m_pLabelSP			= pInfo->m_pLabelSP;
} // FCFindLabelInfo::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindLabelInfo::Duplicate () const
{
	FCFindLabelInfo* pInfo = new FCFindLabelInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindLabelInfo::Duplicate.

//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::IsThereTarget
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCFindLabelInfo::IsThereTarget () const
//{
//	return TRUE;
//} // FCFindLabelInfo::IsThereTarget.
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindLabelInfo::IsNeedCommandFile () const
{
	return FALSE;
} // FCFindLabelInfo::IsNeedCommandFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::IsNeedIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindLabelInfo::IsNeedIndexFile () const
{
	return TRUE;
} // FCFindLabelInfo::IsNeedIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::Search1SessionAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindLabelInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiIoKiCmCjBePiCmMiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjGnPiClHiBeC_xHqqkZx_
	FCStLabelOperateVector vLabelOperate;
	pHistoryIndex->SyncToSessionIndex(	fliSessionIndex,
										vLabelOperate);
	FTHFRecType recTypeHit = FDHF_NONE;
	FCStLabelOperateVector::const_iterator iOil;
	for (iOil = vLabelOperate.begin(); iOil != vLabelOperate.end(); iOil++)
	{
		if (!(*iOil).m_bIsCreate)
		//----- _xZkqqHx_iPoDjFpLiMpMiCmFiBeBiDiJiDhIiDiLjFjEjFgJiNoNiPjMiBgJjBkGiClPiNoMjAkMiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (m_bFindCreateLabel)
			//----- _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiNoMjAkMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
				if (m_pLabelSP->IsMatch((*iOil).m_wstrLabelText))
				{
					recTypeHit = FDHF_LABEL_BEGIN;		// _xZkqqHx_iDiJiDhIiDiLiKeKiOgOiMjPiNpFiBeC_xHqqkZx_
					break;
				}
			}
		} else
		//----- _xZkqqHx_iPoDjFpLiMpMiCmFiBeBiDiJiDhIiDiLjFjEjFgJiNoMjAkMiBgJjBkGiClPiNoNiPjMiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (m_bFindDeleteLabel)
			//----- _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiNoNiPjMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
				if (m_pLabelSP->IsMatch((*iOil).m_wstrLabelText))
				{
					recTypeHit = FDHF_LABEL_END;		// _xZkqqHx_iDiJiDhIiDiLiPeJjHlJiMjPiNpFiBeC_xHqqkZx_
					break;
				}
			}
		}
	}
	if (iOil != vLabelOperate.end())
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendFindRec(recTypeHit, fliSessionIndex + 1, (*iOil).m_fdstTime, (*iOil).m_guidUserId, (*iOil).m_wstrLabelText, 0);
	}
} // FCFindLabelInfo::Search1SessionAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::Search1SessionBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindLabelInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjAgJiCnPiCoJiBeC_xHqqkZx_
	FCStLabelOperateVector vLabelOperate;
	pHistoryIndex->SyncToSessionIndex(	fliSessionIndex + 1,
										vLabelOperate);
	FTHFRecType recTypeHit = FDHF_NONE;
	FCStLabelOperateVector::const_iterator iOil;
	for (iOil = vLabelOperate.begin(); iOil != vLabelOperate.end(); iOil++)
	{
		if ((*iOil).m_bIsCreate)
		//----- _xZkqqHx_iJlKjFpLiMpMiCmFiBeBiDiJiDhIiDiLjFjEjFgJiNoMjAkMiBgJjBkGiClPiNoMjAkMiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (m_bFindCreateLabel)
			//----- _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiNoMjAkMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
				if (m_pLabelSP->IsMatch((*iOil).m_wstrLabelText))
				{
					recTypeHit = FDHF_LABEL_BEGIN;		// _xZkqqHx_iDiJiDhIiDiLiKeKiOgOiMjPiNpFiBeC_xHqqkZx_
					break;
				}
			}
		} else
		//----- _xZkqqHx_iJlKjFpLiMpMiCmFiBeBiDiJiDhIiDiLjFjEjFgJiNoNiPjMiBgJjBkGiClPiNoNiPjMiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (m_bFindDeleteLabel)
			//----- _xZkqqHx_iDiJiDhIiDiLjFjEjFgJiNoNiPjMiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDiJiDhIiDiLjFlGiOjKjHpBiCkKiCfAiCmCiCmFiCoAiDhBiDgCiDgHiClFiClNiPoKiNiHiBeC_xHqqkZx_
				if (m_pLabelSP->IsMatch((*iOil).m_wstrLabelText))
				{
					recTypeHit = FDHF_LABEL_END;		// _xZkqqHx_iDiJiDhIiDiLiPeJjHlJiMjPiNpFiBeC_xHqqkZx_
					break;
				}
			}
		}
	}
	if (iOil != vLabelOperate.end())
	//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendFindRec(recTypeHit, fliSessionIndex + 1, (*iOil).m_fdstTime, (*iOil).m_guidUserId, (*iOil).m_wstrLabelText, 0);
	}
} // FCFindLabelInfo::Search1SessionBelow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindLabelInfo::Search1InterSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pForkData			:_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 7_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindLabelInfo::Search1InterSession (	const FCFindForkData* pForkData,
											FCHiProject* pProject,
											FCHiSummaryTable* pHistoryIndex,
											flint fliNextSessionIndex)
{
	if (m_bFindTimeLabel)
	//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiDiKiDfIiDgHiBeC_xHqqkZx_
		FCIdxToTimeLabelInfoMmap::const_iterator iTml = pForkData->m_mmpTimeLabelList.find(fliNextSessionIndex);
		if (iTml != pForkData->m_mmpTimeLabelList.end())
		//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmJiOjOiKnEiDiJiDhIiDiLiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_pLabelSP->IsMatch(iTml->second.m_wstrLabel))
			//----- _xZkqqHx_iOjOiKnEiDiJiDhIiDiLiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
				AppendFindRec(FDHF_TIME_LABEL, fliNextSessionIndex, iTml->second.m_fdstCreateTime, iTml->second.m_guidUserId, iTml->second.m_wstrLabel, iTml->second.m_lTimeLabelId);
			}
		}
	}
} // FCFindLabelInfo::Search1InterSession.

////////////////////////////////////////////////////////////////////////////
// FCFindDocumentInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDocumentInfo::~FCFindDocumentInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindDocumentInfo::~FCFindDocumentInfo ()
{
} // FCFindDocumentInfo::FCFindDocumentInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindDocumentInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindDocumentInfo* pInfo = (const FCFindDocumentInfo*)&info;
	m_bFindDocument	= pInfo->m_bFindDocument;
	m_bFindHiForkTag= pInfo->m_bFindHiForkTag;
	m_bFindComment	= pInfo->m_bFindComment;
	m_pDocSP		= pInfo->m_pDocSP;
} // FCFindDocumentInfo::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDocumentInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindDocumentInfo::Duplicate () const
{
	FCFindDocumentInfo* pInfo = new FCFindDocumentInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindDocumentInfo::Duplicate.

//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDocumentInfo::IsThereTarget
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCFindDocumentInfo::IsThereTarget () const
//{
//	return TRUE;
//} // FCFindDocumentInfo::IsThereTarget.
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDocumentInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindDocumentInfo::IsNeedCommandFile () const
{
	return FALSE;
} // FCFindDocumentInfo::IsNeedCommandFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDocumentInfo::IsNeedIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindDocumentInfo::IsNeedIndexFile () const
{
	return FALSE;
} // FCFindDocumentInfo::IsNeedIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDocumentInfo::Search1InterSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pForkData			:_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 7_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindDocumentInfo::Search1InterSession (	const FCFindForkData* pForkData,
												FCHiProject* pProject,
												FCHiSummaryTable* pHistoryIndex,
												flint fliNextSessionIndex)
{
	if (m_bFindDocument)
	//----- _xZkqqHx_jHjKjHpAjFlGiPjBiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (pForkData->m_fliSuperSessionIndex == fliNextSessionIndex)
		//----- _xZkqqHx_jHjKjHpAiImKjChFiCkKiDgHiDgCiDhGiCmJjCeCiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jHjKjHpAiImKjChFiCkKiDgHiDgCiDhGiCmJjCeCiClFiCmEiPiJiCnPiCmEjFlGiPjBiPoOjFpBiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
			if (m_pDocSP->IsMatch(pForkData->m_wstrTitle))
			//----- _xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiLiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
				AppendFindRec(FDHF_HISTORY_DOC, fliNextSessionIndex, pForkData->m_fdstCreateTime, pForkData->m_guidUserId, pForkData->m_wstrTitle, 0);
			} else
			if (m_bFindComment)
			//----- _xZkqqHx_iDfCiDiBiDjDiDgHiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				if (m_pDocSP->IsMatch(pForkData->m_wstrComment))
				//----- _xZkqqHx_jFlGiPjBiDfCiDiBiDjDiDgHiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
					AppendFindRec(FDHF_HISTORY_DOC, fliNextSessionIndex, pForkData->m_fdstCreateTime, pForkData->m_guidUserId, pForkData->m_wstrTitle, 0);
				}
			}
		}
	}
	if (m_bFindHiForkTag)
	//----- _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiDiKiDfIiDgHiBeC_xHqqkZx_
		FCIdxToHiForkTagInfoMap::const_iterator iForkTagInfo =
			pForkData->m_mpHiForkTagList.find(fliNextSessionIndex);
		if (iForkTagInfo != pForkData->m_mpHiForkTagList.end())
		//----- _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCmJiDfOiDePiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_pDocSP->IsMatch(iForkTagInfo->second.m_wstrTitle))
			//----- _xZkqqHx_iDfOiDePiDfOiDeDiDgHiDiLiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
				AppendFindRec(FDHF_HI_FORK_TAG, fliNextSessionIndex, iForkTagInfo->second.m_fdstCreateTime, iForkTagInfo->second.m_guidUserId, iForkTagInfo->second.m_wstrTitle, 0);
			} else
			if (m_bFindComment)
			//----- _xZkqqHx_iDfCiDiBiDjDiDgHiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				if (m_pDocSP->IsMatch(iForkTagInfo->second.m_wstrComment))
				//----- _xZkqqHx_iDfOiDePiDfCiDiBiDjDiDgHiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
					AppendFindRec(FDHF_HI_FORK_TAG, fliNextSessionIndex, iForkTagInfo->second.m_fdstCreateTime, iForkTagInfo->second.m_guidUserId, iForkTagInfo->second.m_wstrTitle, 0);
				}
			}
		}
	}
} // FCFindDocumentInfo::Search1InterSession.

////////////////////////////////////////////////////////////////////////////
// FCFindDateBaseInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBaseInfo::~FCFindDateBaseInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindDateBaseInfo::~FCFindDateBaseInfo ()
{
} // FCFindDateBaseInfo::FCFindDateBaseInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindDateBaseInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindDateBaseInfo* pInfo = (const FCFindDateBaseInfo*)&info;

	m_fdstTargetTime = pInfo->m_fdstTargetTime;
} // FCFindDateBaseInfo::operator.

//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBaseInfo::IsThereTarget
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCFindDateBaseInfo::IsThereTarget () const
//{
//	return TRUE;
//} // FCFindDateBaseInfo::IsThereTarget.
//----- 06.02.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBaseInfo::AppendFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidSessionUser	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCFindDateBaseInfo _xZkqqHx_iCmMiMjPiNpFiMiLiJmKiCmNiBeBiIoKiCmCiCmMjHjKjHpAjFlGiPjBiCmFiCfAiCmCiClOiCkPiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiOjOiKnEiCmJiNmFiCoAiLnPiCkCjCgMiCmMiCnNiOgDiClHiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindDateBaseInfo::AppendFindRec (FTHFRecType recType,
										flint fliSessionIndex,
										FDSECTIME fdstSessionTime,
										GUID guidSessionUser,
										const wchar_t* wcpComment,
										long lId)
{
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iOjOiKnEiCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
//	if (fdstSessionTime < m_fdstLimitTimeFrom ||
//		m_fdstLimitTimeUntil < fdstSessionTime) return;
//	// _xZkqqHx_iDiGiBfLiDfF_xHqqkZx_ID_xZkqqHx_iCmJiCoGiCoJiNgJiNjOiCnNiCmMjEmNiImNiKePiCmIiCoHiCmOiDhBiDgCiDgHjBmOiPnLiKePiBeC_xHqqkZx_
//	if (!m_stLimitUserId.empty() &&
//		m_stLimitUserId.find(guidSessionUser) == m_stLimitUserId.end())
//		return;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iNgJiNjOiCnNiPpAiMiPiCmJiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanAppendFindRec(	fliSessionIndex,
							fdstSessionTime,
							guidSessionUser)) return;
//----- 06.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	if (m_mpFindRec.empty())
	//----- _xZkqqHx_iCnMiClOiMjPiNpFiMiLiJmKiCkKjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfGiDjDiDePiDiLiCmMiDiMiDfCiBfLiDgIiCpAjAnNjCoIiBeC_xHqqkZx_
		m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, 0);
	} else
	//----- _xZkqqHx_iKpJiCmJiMjPiNpFiMiLiJmKiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDgPjIfOiNmPiCnNiMjPiNpFiMiLiJmKiCmGiBeBjAfGiClFiCkCiMjPiNpFiMiLiJmKiCpAjEoEiKhCiClHiCoJiBeC_xHqqkZx_
		FDSECTIME fdstLastSessionTime = (*m_mpFindRec.begin()).second.m_fdstSessionTime;
		// _xZkqqHx_jDgPjIfOiNmPiCnNiMiLiJmKiCmGiDfOiBfLiDfBiDgCiDgHiOjOiKnEiCmGiCmMiNlHjFkKiCpAiOfKiPgPiBeC_xHqqkZx_
		FDSECTIME fdstLastDiff = (fdstLastSessionTime < m_fdstTargetTime) ?
									(m_fdstTargetTime - fdstLastSessionTime) :
									(fdstLastSessionTime - m_fdstTargetTime);
		// _xZkqqHx_jAfGiClFiCkCiMiLiJmKiCmGiDfOiBfLiDfBiDgCiDgHiOjOiKnEiCmGiCmMiNlHjFkKiCpAiOfKiPgPiBeC_xHqqkZx_
		FDSECTIME fdstNewDiff = (fdstSessionTime < m_fdstTargetTime) ?
									(m_fdstTargetTime - fdstSessionTime) :
									(fdstSessionTime - m_fdstTargetTime);
		if (fdstNewDiff < fdstLastDiff)
		//----- _xZkqqHx_jAfGiClFiCkCiMiLiJmKiCkKiDfOiBfLiDfBiDgCiDgHiOjOiKnEiCmJiCoGiCoIiLnPiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jDgPjIfOiNmPiCnNiCmMiMiLiJmKiCpAiDeOiDiKiDeBiClFiCmEiBeBjAfGiClFiCkCiMiLiJmKiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			m_mpFindRec.clear();
			m_mpFindRec[fliSessionIndex] = FindRec(recType, fdstSessionTime, guidSessionUser, wcpComment, lId, 0);
		}
	}
} // FCFindDateBaseInfo::AppendFindRec.

////////////////////////////////////////////////////////////////////////////
// FCFindDateAInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateAInfo::~FCFindDateAInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindDateAInfo::~FCFindDateAInfo ()
{
} // FCFindDateAInfo::FCFindDateAInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateAInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindDateAInfo::Duplicate () const
{
	FCFindDateAInfo* pInfo = new FCFindDateAInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindDateAInfo::Duplicate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateAInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindDateAInfo::IsNeedCommandFile () const
{
	return FALSE;
} // FCFindDateAInfo::IsNeedCommandFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateAInfo::IsNeedIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindDateAInfo::IsNeedIndexFile () const
{
	return TRUE;
} // FCFindDateAInfo::IsNeedIndexFile.

//----- 05.11.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateAInfo::Search1SessionAbove
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCFindDateAInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
//											FCHiSummaryTable* pHistoryIndex,
//											flint fliSessionIndex)
//{
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiIoKiCmCjBePiCmMiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjGnPiClHiBeC_xHqqkZx_
//	(void)pHistoryIndex->SkipToSessionIndex(fliSessionIndex);
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiImKjChFiCkKiInKjDkOiClFiCmIiCkCiPoKiNiHiCmFiCoAiBeBiImIiJlKiCmMiPiIjHjNiCkKjFeLjHhGiBeC_xHqqkZx_
//	// _xZkqqHx_iMjPiNpFiCmMiKeKiOgOiOjOiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiInKjDkOiClFiCmIiCkCiJmCjEfMjAkLiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
//
//	GUID guidPrevUserId;
//	FDSECTIME fdstPrevSessionTime;
//	flint fliPrevSessionIndex = pHistoryIndex->SeePrevSessionIndex(&guidPrevUserId, &fdstPrevSessionTime);
//	if (fliPrevSessionIndex != -1)
//	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjAoGjDkKiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
//		AppendFindRec(FDHF_TIME_SIGNAL, fliPrevSessionIndex, fdstPrevSessionTime, guidPrevUserId, L"", 0);
//	}
//} // FCFindDateAInfo::Search1SessionAbove.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateAInfo::Search1SessionBelow
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
// *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCFindDateAInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
//											FCHiSummaryTable* pHistoryIndex,
//											flint fliSessionIndex)
//{
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCmEjAgJiCnPiCoJiBeC_xHqqkZx_
//	(void)pHistoryIndex->SkipToSessionIndex(fliSessionIndex + 1);
//	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiImKjChFiCkKiInKjDkOiClFiCmIiCkCiPoKiNiHiCmFiCoAiBeBiImIiJlKiCmMiPiIjHjNiCkKjFeLjHhGiBeC_xHqqkZx_
//	// _xZkqqHx_iMjPiNpFiCmMiKeKiOgOiOjOiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiInKjDkOiClFiCmIiCkCiJmCjEfMjAkLiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
//
//	GUID guidPrevUserId;
//	FDSECTIME fdstPrevSessionTime;
//	flint fliPrevSessionIndex = pHistoryIndex->SeePrevSessionIndex(&guidPrevUserId, &fdstPrevSessionTime);
//	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjAoGjDkKiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
//		AppendFindRec(FDHF_TIME_SIGNAL, fliPrevSessionIndex, fdstPrevSessionTime, guidPrevUserId, L"", 0);
//	}
//} // FCFindDateAInfo::Search1SessionBelow.
//----- 05.11.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateAInfo::Search1InterSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pForkData			:_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 7_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindDateAInfo::Search1InterSession (	const FCFindForkData* pForkData,
											FCHiProject* pProject,
											FCHiSummaryTable* pHistoryIndex,
											flint fliNextSessionIndex)
{
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiBeBiDfKiDgCiDfGiDiHiDjDiCmJiNiHiCoNiClJiCoJiBeC_xHqqkZx_
// 06.01.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	(void)pHistoryIndex->SkipToSessionIndex(fliNextSessionIndex);
	(void)pHistoryIndex->SeekToSessionIndex(fliNextSessionIndex);
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmMiImKjChFiCkKiInKjDkOiClFiCmIiCkCiPoKiNiHiCmFiCoAiBeBiImIiJlKiCmMiPiIjHjNiCkKjFeLjHhGiBeC_xHqqkZx_
	// _xZkqqHx_iMjPiNpFiCmMiKeKiOgOiOjOiCmNiBeBiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKiInKjDkOiClFiCmIiCkCiJmCjEfMjAkLiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	GUID guidPrevUserId;
	FDSECTIME fdstPrevSessionTime;
	flint fliPrevSessionIndex = pHistoryIndex->SeePrevSessionInfo(guidPrevUserId, fdstPrevSessionTime);
	if (fliPrevSessionIndex != -1)
	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjAoGjDkKiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendFindRec(FDHF_TIME_SIGNAL, fliNextSessionIndex, fdstPrevSessionTime, guidPrevUserId, L"", 0);
	} else
	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjAoGjDkKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFlGiPjBiNoMjAkMiOjOiKnEiBeBiNoMjAkMiOnCiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendFindRec(	FDHF_TIME_SIGNAL,
						fliNextSessionIndex,
						pProject->GetDocumentRec(m_lDocumentId).GetDate(),
						pProject->GetDocumentRec(m_lDocumentId).GetUserId(),
						L"", 0);
	}
} // FCFindDateAInfo::Search1InterSession.

////////////////////////////////////////////////////////////////////////////
// FCFindDateBInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBInfo::~FCFindDateBInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindDateBInfo::~FCFindDateBInfo ()
{
} // FCFindDateBInfo::FCFindDateBInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindDateBInfo::Duplicate () const
{
	FCFindDateBInfo* pInfo = new FCFindDateBInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindDateBInfo::Duplicate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindDateBInfo::IsNeedCommandFile () const
{
	return TRUE;
} // FCFindDateBInfo::IsNeedCommandFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBInfo::IsNeedIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindDateBInfo::IsNeedIndexFile () const
{
	return FALSE;
} // FCFindDateBInfo::IsNeedIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBInfo::Search1SessionAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindDateBInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
	// _xZkqqHx_jGnPiClHjBePiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFjDjJiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
	const FDSECTIME fdstSessionTime = pCmdGate->GetPrevSessionTime();
	const GUID guidSessionUser = pCmdGate->GetPrevSessionUser();
	// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjGnPiClHiBeC_xHqqkZx_
	pCmdGate->SkipSessionPrev();
	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
	AppendFindRec(FDHF_TIME_SIGNAL, fliSessionIndex + 1, fdstSessionTime, guidSessionUser, L"", 0);
} // FCFindDateBInfo::Search1SessionAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindDateBInfo::Search1SessionBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindDateBInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
	// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjAgJiCnPiCoJiBeC_xHqqkZx_
	pCmdGate->SkipSessionNext();
	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
	AppendFindRec(FDHF_TIME_SIGNAL, fliSessionIndex + 1, pCmdGate->GetPrevSessionTime(), pCmdGate->GetPrevSessionUser(), L"", 0);
} // FCFindDateBInfo::Search1SessionBelow.

////////////////////////////////////////////////////////////////////////////
// FCFindTextInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::~FCFindTextInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindTextInfo::~FCFindTextInfo ()
{
} // FCFindTextInfo::FCFindTextInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCpAiPiJiKpKiJlLiClHiCoJiBeCiDiBiDjDiDgPiBfLjFmPjAjEiCpAjAnNjCoIiClFiCmEiCkJiCoHiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrProjectPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiCmJjAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindTextInfo::Initialize (const HString& hstrProjectPath)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	if (!BASE_CLASS::Initialize(hstrProjectPath))
		return FALSE;

	BOOL bSucceed;
	if (m_bNeedToSetText)
	//----- _xZkqqHx_iDgFiDeMiDfIiDgHiCpAjAnNjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgHiDgCiDhGiDePiDiLiBfLiDhGiCpAiOoGjDlOiBeC_xHqqkZx_
		FCDbGroup dbTopGroup = g_pFileServer->GetTopGroup(hstrProjectPath);
		// _xZkqqHx_iDiNiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
		FCDbReadLock dbReadLockProject;
		if (!dbTopGroup.TryLock(dbReadLockProject))
		{
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFErrorBox(FFGetDDErrorMessage());
			return FALSE;
		}
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		FCHiSpotTable spotTable = dbTopGroup.GetSubGroup(m_lDocumentId);
		FCDbReadLock dbReadLockSpot;
		if (!spotTable.TryLock(dbReadLockSpot))
		{
			// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
			FFErrorBox(FFGetDDErrorMessage());
			return FALSE;
		}
		spotTable.UpdateData(dbReadLockSpot);
		FCSpotConstIterator iSpot = spotTable.GetFirstSpot();

		struct my
		{
			my () : pSpotStream(NULL), dwSpotStreamSize(0), mpIdToText(NULL) {}
			static int EnumNewDocumentProc (CFCFoundDoc* pDoc,	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiBeC_xHqqkZx_
											void* pData)		// _xZkqqHx_iDiGiBfLiDfFiDgGiBfLiDfOiBeC_xHqqkZx_
			{
				my* pMy = (my*)pData;
				// _xZkqqHx_iOgOjDfPiDfIiDhMiDgCiDgHiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
				if (!FFImportSpotFile(	pDoc,
										NULL,
										pMy->pSpotStream,
										pMy->dwSpotStreamSize,
										FALSE))
					return 0;
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHjEhKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
				pDoc->GetObjectToTextMap(*pMy->mpIdToText);
				// _xZkqqHx_jAkMiMpHjCgMiCpAjFnEiClHiBeC_xHqqkZx_
				return 1;
			}
			BYTE* pSpotStream;
			DWORD dwSpotStreamSize;
			map<DWORD, WString>* mpIdToText;
		} data;

		// data_xZkqqHx_iCmMiDiBiDjDiDgPiBfLjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
		FC2Ref<BYTE*, DWORD>(data.pSpotStream, data.dwSpotStreamSize) = iSpot.GetSpotStream();
		data.mpIdToText = &m_mpObjectIdToText;
		// _xZkqqHx_jAfGiClFiCkC_xHqqkZx_CFCFoundDoc_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClFiCmEiBeBiDfCiBfLiDiLiDgPiDgCiDeOiCpAiOmAiNhDiBeC_xHqqkZx_
		bSucceed = CFCFoundDoc::EnumNewDocument(my::EnumNewDocumentProc, &data);
		// _xZkqqHx_iDfIiDhMiDgCiDgHiDfIiDgHiDiKiBfLiDiAiCpAiJpAjFpKiBeC_xHqqkZx_
		delete data.pSpotStream;
		// _xZkqqHx_iKpJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiDgFiDeMiDfIiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
		map<DWORD, WString>::const_iterator iIs;
		for (iIs = m_mpObjectIdToText.begin(); iIs != m_mpObjectIdToText.end(); iIs++)
		{
			if (m_pTextSP->IsMatch(iIs->second))
				m_stHitTextId.insert(iIs->first);
		}
		// _xZkqqHx_iDgFiDeMiDfIiDgHjAnNjCoIiCkKjFeLjHhGiCkJiBeI_xHqqkZx_
		m_bNeedToSetText = FALSE;
	}
	// _xZkqqHx_iDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCpAjFfMiOkGiBeC_xHqqkZx_
	if (!bSucceed)
		FFErrorBox(FFGetDDErrorMessage());
	return bSucceed;
} // FCFindTextInfo::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindTextInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindTextInfo* pInfo = (const FCFindTextInfo*)&info;

	m_bNeedToSetText	= pInfo->m_bNeedToSetText;

	m_bTargetInside		= pInfo->m_bTargetInside;		// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmJiMmAiCmBiCmEiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	m_bSearchBeginOfHit	= pInfo->m_bSearchBeginOfHit;	// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiCkKjEkNjAlGiClFiClNiOjOiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	m_bSearchEndOfHit	= pInfo->m_bSearchEndOfHit;		// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiCkKiPmBjGmFiClFiClNiOjOiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	m_stTargetObjectId	= pInfo->m_stTargetObjectId;	// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCmMiPfHiNiHiBeCiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCoAiCkAiCoJiBeCiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClHiCoJiCoAiCmMiCpAiMjPiNpFiBeC_xHqqkZx_

	m_mpObjectIdToText	= pInfo->m_mpObjectIdToText;
	m_stHitTextId		= pInfo->m_stHitTextId;
	m_pTextSP			= pInfo->m_pTextSP;
} // FCFindTextInfo::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindTextInfo::Duplicate () const
{
	FCFindTextInfo* pInfo = new FCFindTextInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindTextInfo::Duplicate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::IsThereTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindTextInfo::IsThereTarget () const
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiCnNiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDfOiBfLiDfBiDgCiDgHiCkKiLpDiCmJiCmIiCoKiCmOiMjPiNpFiClFiCmIiCkCiBeC_xHqqkZx_
	if (m_bTargetInside && m_stTargetObjectId.empty())
		return FALSE;
	return TRUE;
} // FCFindTextInfo::IsThereTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindTextInfo::IsNeedCommandFile () const
{
	return TRUE;
} // FCFindTextInfo::IsNeedCommandFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::IsNeedIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindTextInfo::IsNeedIndexFile () const
{
	return FALSE;
} // FCFindTextInfo::IsNeedIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::SetTargetObjects
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiPfHiNiHiCpAiBeBiClBiCmMjFjEjFgJiMjPiNpFiPoOjFpBjFmPjAjEiCmJiMjPiNpFjBmOiPnLiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCFindObjDynabaseInfo::SetTargetObjects_xZkqqHx_iKnGjAjEiCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindTextInfo::SetTargetObjects (const ObjDynabaseVector& vObj)
{
	struct my
	{
		static void GetChildTop (DWORDSet& stTargetObjId, const FCObjDynabase* pObj)
		{
			if (pObj->Type() != FDOJ_GROUP)
			//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiImIiKePiCmIiCoHiBeBiMjPiNpFjBmOiPnLjFjEjFgJiCmMiMpDjFoCiBeC_xHqqkZx_
				stTargetObjId.insert(pObj->GetObjID());
			} else
			//----- _xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOhBjFjEjFgJiCpAiNmEiLeBjDeJiCmJjClCiCnHiCoJiBeC_xHqqkZx_
				for (long lIndex = 0; lIndex != pObj->GetMemberSize(); lIndex++)
					GetChildTop(stTargetObjId, pObj->GetMember(lIndex));
			}
		}
	};
	mdef_const_iterator(ObjDynabaseVector, iObj);
	m1_for (iObj, vObj)
	{
		// _xZkqqHx_iOhBjFjEjFgJiCmMiMjPiNpFjBmOiPnLjFjEjFgJiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
		my::GetChildTop(m_stTargetObjectId, *iObj);
	}
} // FCFindTextInfo::SetTargetObjects.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::Search1SessionAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindTextInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jGnPiClHjBePiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFjDjJiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
//	const FDSECTIME fdstSessionTime = pCmdGate->GetPrevSessionTime();
//	const GUID guidSessionUser = pCmdGate->GetPrevSessionUser();
//
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
//	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
//	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
//	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjGjGjEpGiCnGiBeC_xHqqkZx_
//	pCmdGate->BufferSeek(0, CFile::end);
//
//	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//	DWORDSet stHitObj;
//	do
//	{
//		// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
//		BOOL bIsTarget = FALSE;
//
//		FTGateCmd cmd;
//		DWORD dwTextObjId;
//		WString wstrText;
//		BYTEVector vCmdQueue;
//		if (m_bTargetInside)
//		//----- _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiCnNiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			DWORDSet stInsTopObjId;
//			DWORDSet stDelTopObjId;
//			DWORDSet stEdtTopObjId;
//			DWORDSet stInsObjId;
//			DWORDSet stDelObjId;
//			DWORDSet stEdtObjId;
//			FCLinkMolipInfo linkMolipIns;
//			FCLinkMolipInfo linkMolipDel;
//			// _xZkqqHx_iDfCiDhNiDjDiDgIiCmMiImKjChFiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
//			const flint fliCommandTop = pCmdGate->GetBufferPosition();
//			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
//			pCmdGate->RSkipCmd(	cmd,
//								stInsTopObjId,
//								stDelTopObjId,
//								stEdtTopObjId,
//								stInsObjId,
//								stDelObjId,
//								stEdtObjId,
//								linkMolipIns,
//								linkMolipDel);
//			switch (cmd)
//			{
//			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				ASSERT(stInsObjId.empty());
//				ASSERT(stDelObjId.empty());
//				ASSERT(!stEdtObjId.empty());
//				if (FFIsIntersect(m_stTargetObjectId, stEdtObjId))
//				//----- _xZkqqHx_jFnCiPfHiClDiCoKiClNjFjEjFgJiCkKiDfOiBfLiDfBiDgCiDgHjFjEjFgJiPfHiNiHiCmGiPgEiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
//					bIsTarget = TRUE;
//					// _xZkqqHx_iDfCiDhNiDjDiDgIiImKjChFiCmJjGnPiClFiCmEiCkIiCkNiBeC_xHqqkZx_
//					pCmdGate->BufferSeek(fliCommandTop, CFile::begin);
//					// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
//					pCmdGate->RSkipTextCmd(	cmd,
//											dwTextObjId,
//											wstrText,
//											vCmdQueue);
//				}
//				break;
//			}
//			// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
//			FFErase(m_stTargetObjectId, stDelObjId);
//		} else
//		//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
//			pCmdGate->RSkipTextCmd(	cmd,
//									dwTextObjId,
//									wstrText,
//									vCmdQueue);
//			switch (cmd)
//			{
//			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
//				bIsTarget = TRUE;
//				break;
//			}
//		}
//		if (bIsTarget)
//		//----- _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			switch (cmd)
//			{
//			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHiIoKjHjHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
//				m_mpObjectIdToText.erase(dwTextObjId);
//				break;
//			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				m_mpObjectIdToText[dwTextObjId] = wstrText;
//				break;
//			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				CFCWndRichEdit::UndoCmdQueue(m_mpObjectIdToText[dwTextObjId], &vCmdQueue[0], vCmdQueue.size());
//				break;
//			}
//			// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//			BOOL bIsHit = FALSE;
//			if (m_bSearchBeginOfHit)
//			//----- _xZkqqHx_iDeMiBfLiDiPiBfLiDgIjEkNjAlGiCpAiMjPiNpF_xHqqkZx_ -----
//			{
//				switch (cmd)
//				{
//				case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_stHitTextId.find(dwTextObjId) != m_stHitTextId.end())
//					//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
//						m_stHitTextId.erase(dwTextObjId);
//						// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//						bIsHit = TRUE;
//					}
//					break;
//				case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//						m_stHitTextId.insert(dwTextObjId);
//					}
//					break;
//				case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//						m_stHitTextId.insert(dwTextObjId);
//					} else
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//					{
//						if (m_stHitTextId.find(dwTextObjId) != m_stHitTextId.end())
//						//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//						{
//							// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
//							m_stHitTextId.erase(dwTextObjId);
//							// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//							bIsHit = TRUE;
//						}
//					}
//					break;
//				}
//			}
//			if (!bIsHit && m_bSearchEndOfHit)
//			//----- _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiPmBjGmFiCpAiMjPiNpF_xHqqkZx_ -----
//			{
//				switch (cmd)
//				{
//				case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
//					m_stHitTextId.erase(dwTextObjId);
//					break;
//				case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//						m_stHitTextId.insert(dwTextObjId);
//						// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//						bIsHit = TRUE;
//					}
//					break;
//				case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						if (m_stHitTextId.find(dwTextObjId) == m_stHitTextId.end())
//						//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkJiCmBiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//						{
//							// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//							m_stHitTextId.insert(dwTextObjId);
//							// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//							bIsHit = TRUE;
//						}
//					} else
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
//						m_stHitTextId.erase(dwTextObjId);
//					}
//					break;
//				}
//			}
//			// _xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//			if (bIsHit)
//				stHitObj.insert(dwTextObjId);
//		}
//	} while (pCmdGate->GetBufferPosition() != 0);
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
//	pCmdGate->DeleteSessionReadBuffer();
//
//	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
//	if (!stHitObj.empty())
//		AppendFindRec(FDHF_TEXT_MODIFY, fliSessionIndex + 1, fdstSessionTime, guidSessionUser, L"", 0);
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----

	// _xZkqqHx_jDkPiClGiDfKiDgCiDfGiDiHiDjDjCiGiCmJiBhFiDgFiDeMiDfIiDgHiNoMjAkMiBhG_xHqqkZx_->_xZkqqHx_iBhFiDgFiDeMiDfIiDgHjFnCiPfHiBhGiCkKjDkPiLiPiClHiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiBeBiIoKiCmCiClIiCmCjGlNjHnPiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiCmGiBeBiNmFiPiJiCmMiBhFiDgFiDeMiDfIiDgHiNoMjAkMiBhGiCmF_xHqqkZx_
	// _xZkqqHx_iNoMjAkMiClDiCoKiClNjFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmEiClFiCnMiCkCiBeBiOmAiNnLiCmJiCmNiDfKiDgCiDfGiDiHiDjDiPeJjHlJiMoDiCmJiDhBiDgCiDgHiClFiCmIiCkC_xHqqkZx_
	// _xZkqqHx_jFjEjFgJiCpAiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClFiCmEiClFiCnMiCkEiClBiCmGiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iOfBiPmGjFjEjFgJiCpAiOgHiCmBiCmEiDgFiDeMiDfIiDgHiNoMjAkMiClFiClNiPoKiNiHiCkKiClBiCoKiCmJiCkAiClNiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiCoGiCkEiCmIiMoLjElLjCgGiCpAjGgIiCkOiClNiCnPiBeBiCfAiDfKiDgCiDfGiDiHiDjDiCpAiKkOjBfDiCmJiPeJjHlJiClFiCmEiCkJiCoHiBeB_xHqqkZx_
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_jGnPiClHjBePiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFjDjJiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
	const FDSECTIME fdstSessionTime = pCmdGate->GetPrevSessionTime();
	const GUID guidSessionUser = pCmdGate->GetPrevSessionUser();

	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjGjGjEpGiCnGiBeC_xHqqkZx_
	pCmdGate->BufferSeek(0, CFile::end);

	// _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiPfHiNiHiBeC_xHqqkZx_
	DWORDSet stCreateTextObj;
	// _xZkqqHx_iNoNiPjMiDgFiDeMiDfIiDgHiPfHiNiHiBeC_xHqqkZx_
	DWORDSet stDeleteTextObj;
	// _xZkqqHx_jFnCiPfHiDgFiDeMiDfIiDgHiPfHiNiHiBeC_xHqqkZx_
	DWORDSet stEditTextObj;
	do
	{
		// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
		BOOL bIsTarget = FALSE;

		FTGateCmd cmd;
		DWORD dwTextObjId;
		WString wstrText;
		BYTEVector vCmdQueue;
		if (m_bTargetInside)
		//----- _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiCnNiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			DWORDSet stDelObjId;
			DWORDSet stEdtObjId;
			// _xZkqqHx_iDfCiDhNiDjDiDgIiCmMiImKjChFiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
			const flint fliCommandTop = pCmdGate->GetBufferPosition();
			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
			pCmdGate->RSkipCmd(	cmd,
								DWORDSet(),
								DWORDSet(),
								DWORDSet(),
								DWORDSet(),
								stDelObjId,
								stEdtObjId,
								FCLinkMolipInfo(),
								FCLinkMolipInfo());
			switch (cmd)
			{
			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				ASSERT(stDelObjId.empty());
				ASSERT(!stEdtObjId.empty());
				if (FFIsIntersect(m_stTargetObjectId, stEdtObjId))
				//----- _xZkqqHx_jFnCiPfHiClDiCoKiClNjFjEjFgJiCkKiDfOiBfLiDfBiDgCiDgHjFjEjFgJiPfHiNiHiCmGiPgEiCmIiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
					bIsTarget = TRUE;
					// _xZkqqHx_iDfCiDhNiDjDiDgIiImKjChFiCmJjGnPiClFiCmEiCkIiCkNiBeC_xHqqkZx_
					pCmdGate->BufferSeek(fliCommandTop, CFile::begin);
					// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
					pCmdGate->RSkipTextCmd(	cmd,
											dwTextObjId,
											wstrText,
											vCmdQueue);
				}
				break;
			}
			// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
			FFErase(m_stTargetObjectId, stDelObjId);
		} else
		//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
			pCmdGate->RSkipTextCmd(	cmd,
									dwTextObjId,
									wstrText,
									vCmdQueue);
			switch (cmd)
			{
			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
				bIsTarget = TRUE;
				break;
			}
		}
		if (bIsTarget)
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			switch (cmd)
			{
			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHiIoKjHjHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
				m_mpObjectIdToText.erase(dwTextObjId);
				// _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOjGjFiPmBiBeC_xHqqkZx_
				// _xZkqqHx_jGkCjDgPjIfOiCmIiCoHiCmOiBeBiNoNiPjMiDgFiDeMiDfIiDgHiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
				if (stCreateTextObj.erase(dwTextObjId) == 0)
					stDeleteTextObj.insert(dwTextObjId);
				break;
			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				m_mpObjectIdToText[dwTextObjId] = wstrText;
				// _xZkqqHx_iNoNiPjMiDgFiDeMiDfIiDgHiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOjGjFiPmBiBeC_xHqqkZx_
				// _xZkqqHx_jGkCjDgPjIfOiCmIiCoHiCmOiBeBjAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
				if (stDeleteTextObj.erase(dwTextObjId) == 0)
					stCreateTextObj.insert(dwTextObjId);
				break;
			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				CFCWndRichEdit::UndoCmdQueue(m_mpObjectIdToText[dwTextObjId], &vCmdQueue[0], vCmdQueue.size());
				// _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jGkCjDgPjIfOiCmIiCoHiCmOiBeBjFnCiPfHiDgFiDeMiDfIiDgHiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
				if (stCreateTextObj.find(dwTextObjId) == stCreateTextObj.end())
					stEditTextObj.insert(dwTextObjId);
				break;
			}
		}
	} while (pCmdGate->GetBufferPosition() != 0);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	pCmdGate->DeleteSessionReadBuffer();

	// _xZkqqHx_jFjEjFgJiCmNiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
	BOOL bIsHit = FALSE;
	mdef_const_iterator(DWORDSet, iId);
	m1_for (iId, stCreateTextObj)
	//----- _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiPfHiNiHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (m_pTextSP->IsMatch(m_mpObjectIdToText[*iId]))
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
			m_stHitTextId.insert(*iId);
			// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiPmBjGmFiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
			if (m_bSearchEndOfHit)
				bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
		}
	}
	m1_for (iId, stDeleteTextObj)
	//----- _xZkqqHx_iNoNiPjMiDgFiDeMiDfIiDgHiPfHiNiHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
		if (m_stHitTextId.erase(*iId) == 1)
		//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiClOiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIjEkNjAlGiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
			if (m_bSearchBeginOfHit)
				bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
		}
	}
	m1_for (iId, stEditTextObj)
	//----- _xZkqqHx_jFnCiPfHiDgFiDeMiDfIiDgHiPfHiNiHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (m_pTextSP->IsMatch(m_mpObjectIdToText[*iId]))
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
			if (m_stHitTextId.insert(*iId).second)
			//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkJiCmBiClNjFjEjFgJiClOiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiPmBjGmFiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
				if (m_bSearchEndOfHit)
					bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
			}
		} else
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
			if (m_stHitTextId.erase(*iId) == 1)
			//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiClOiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIjEkNjAlGiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
				if (m_bSearchBeginOfHit)
					bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
			}
		}
	}

	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
	if (bIsHit)
		AppendFindRec(FDHF_TEXT_MODIFY, fliSessionIndex + 1, fdstSessionTime, guidSessionUser, L"", 0);
//----- 06.04.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCFindTextInfo::Search1SessionAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::Search1SessionBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindTextInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
//----- 06.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
//	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
//	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
//	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
//	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjAoGjDkKiCnGiBeC_xHqqkZx_
//	pCmdGate->BufferSeek(0, CFile::begin);
//
//	// _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNjFjEjFgJiBeC_xHqqkZx_
//	DWORDSet stHitObj;
//	do
//	{
//		// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
//		BOOL bIsTarget = FALSE;
//
//		FTGateCmd cmd;
//		DWORD dwTextObjId;
//		WString wstrText;
//		BYTEVector vCmdQueue;
//
//		if (m_bTargetInside)
//		//----- _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiCnNiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			DWORDSet stInsTopObjId;
//			DWORDSet stDelTopObjId;
//			DWORDSet stEdtTopObjId;
//			DWORDSet stInsObjId;
//			DWORDSet stDelObjId;
//			DWORDSet stEdtObjId;
//			FCLinkMolipInfo linkMolipIns;
//			FCLinkMolipInfo linkMolipDel;
//			// _xZkqqHx_iDfCiDhNiDjDiDgIiCmMiImKjChFiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
//			const flint fliCommandTop = pCmdGate->GetBufferPosition();
//			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
//			pCmdGate->SkipCmd(	cmd,
//								stInsTopObjId,
//								stDelTopObjId,
//								stEdtTopObjId,
//								stInsObjId,
//								stDelObjId,
//								stEdtObjId,
//								linkMolipIns,
//								linkMolipDel);
//			switch (cmd)
//			{
//			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				ASSERT(stInsObjId.empty());
//				ASSERT(stDelObjId.empty());
//				ASSERT(!stEdtObjId.empty());
//				if (FFIsIntersect(m_stTargetObjectId, stEdtObjId))
//				//----- _xZkqqHx_jFnCiPfHiClDiCoKiClNjFjEjFgJiCkKiDfOiBfLiDfBiDgCiDgHjFjEjFgJiPfHiNiHiCmGiPgEiCmIiCoJiPoKiNiH_xHqqkZx_ -----
//				{
//					// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
//					bIsTarget = TRUE;
//					// _xZkqqHx_iDfCiDhNiDjDiDgIiImKjChFiCmJjGnPiClFiCmEiCkIiCkNiBeC_xHqqkZx_
//					pCmdGate->BufferSeek(fliCommandTop, CFile::begin);
//					// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
//					pCmdGate->SkipTextCmd(	cmd,
//											dwTextObjId,
//											wstrText,
//											vCmdQueue);
//				}
//				break;
//			}
//			// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
//			FFErase(m_stTargetObjectId, stDelObjId);
//		} else
//		//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
//			pCmdGate->SkipTextCmd(	cmd,
//									dwTextObjId,
//									wstrText,
//									vCmdQueue);
//			switch (cmd)
//			{
//			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
//				bIsTarget = TRUE;
//				break;
//			}
//		}
//		if (bIsTarget)
//		//----- _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			switch (cmd)
//			{
//			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHiIoKjHjHiCmJjDgPjIfOiBeC_xHqqkZx_
//				m_mpObjectIdToText[dwTextObjId] = wstrText;
//				break;
//			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHiIoKjHjHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
//				m_mpObjectIdToText.erase(dwTextObjId);
//				break;
//			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//				CFCWndRichEdit::RedoCmdQueue(m_mpObjectIdToText[dwTextObjId], &vCmdQueue[0], vCmdQueue.size());
//				break;
//			}
//			// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//			BOOL bIsHit = FALSE;
//			if (m_bSearchBeginOfHit)
//			//----- _xZkqqHx_iDeMiBfLiDiPiBfLiDgIjEkNjAlGiCpAiMjPiNpF_xHqqkZx_ -----
//			{
//				switch (cmd)
//				{
//				case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//						m_stHitTextId.insert(dwTextObjId);
//						// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//						bIsHit = TRUE;
//					}
//					break;
//				case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						if (m_stHitTextId.find(dwTextObjId) == m_stHitTextId.end())
//						//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//						{
//							// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//							m_stHitTextId.insert(dwTextObjId);
//							// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//							bIsHit = TRUE;
//						}
//					} else
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
//						m_stHitTextId.erase(dwTextObjId);
//					}
//					break;
//				case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
//					m_stHitTextId.erase(dwTextObjId);
//					break;
//				}
//			}
//			if (!bIsHit && m_bSearchEndOfHit)
//			//----- _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiPmBjGmFiCpAiMjPiNpF_xHqqkZx_ -----
//			{
//				switch (cmd)
//				{
//				case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//						m_stHitTextId.insert(dwTextObjId);
//					}
//					break;
//				case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_pTextSP->IsMatch(m_mpObjectIdToText[dwTextObjId]))
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//						m_stHitTextId.insert(dwTextObjId);
//					} else
//					//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//					{
//						if (m_stHitTextId.find(dwTextObjId) != m_stHitTextId.end())
//						//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//						{
//							// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
//							m_stHitTextId.erase(dwTextObjId);
//							// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//							bIsHit = TRUE;
//						}
//					}
//					break;
//				case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
//					if (m_stHitTextId.find(dwTextObjId) != m_stHitTextId.end())
//					//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//					{
//						// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
//						m_stHitTextId.erase(dwTextObjId);
//						// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
//						bIsHit = TRUE;
//					}
//					break;
//				}
//			}
//			// _xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
//			if (bIsHit)
//				stHitObj.insert(dwTextObjId);
//		}
//	} while (pCmdGate->GetBufferPosition() != pCmdGate->GetBufferLength());
//	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
//	pCmdGate->DeleteSessionReadBuffer();
//
//	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
//	if (!stHitObj.empty())
//		AppendFindRec(FDHF_TEXT_MODIFY, fliSessionIndex + 1, pCmdGate->GetPrevSessionTime(), pCmdGate->GetPrevSessionUser(), L"", 0);
//----- 06.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----

	// _xZkqqHx_jDkPiClGiDfKiDgCiDfGiDiHiDjDjCiGiCmJiBhFiDgFiDeMiDfIiDgHiNoMjAkMiBhG_xHqqkZx_->_xZkqqHx_iBhFiDgFiDeMiDfIiDgHjFnCiPfHiBhGiCkKjDkPiLiPiClHiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiBeBiIoKiCmCiClIiCmCjGlNjHnPiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiCmGiBeBiNmFiPiJiCmMiBhFiDgFiDeMiDfIiDgHiNoMjAkMiBhGiCmF_xHqqkZx_
	// _xZkqqHx_iNoMjAkMiClDiCoKiClNjFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmEiClFiCnMiCkCiBeBiOmAiNnLiCmJiCmNiDfKiDgCiDfGiDiHiDjDiPeJjHlJiMoDiCmJiDhBiDgCiDgHiClFiCmIiCkC_xHqqkZx_
	// _xZkqqHx_jFjEjFgJiCpAiDhBiDgCiDgHiClFiClNiCmGjElLjCgGiClFiCmEiClFiCnMiCkEiClBiCmGiCkKiCkAiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iOfBiPmGjFjEjFgJiCpAiOgHiCmBiCmEiDgFiDeMiDfIiDgHiNoMjAkMiClFiClNiPoKiNiHiCkKiClBiCoKiCmJiCkAiClNiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiCoGiCkEiCmIiMoLjElLjCgGiCpAjGgIiCkOiClNiCnPiBeBiCfAiDfKiDgCiDfGiDiHiDjDiCpAiKkOjBfDiCmJiPeJjHlJiClFiCmEiCkJiCoHiBeB_xHqqkZx_
	// _xZkqqHx_iDgFiDeMiDfIiDgHiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_

	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjAoGjDkKiCnGiBeC_xHqqkZx_
	pCmdGate->BufferSeek(0, CFile::begin);

	// _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiPfHiNiHiBeC_xHqqkZx_
	DWORDSet stCreateTextObj;
	// _xZkqqHx_iNoNiPjMiDgFiDeMiDfIiDgHiPfHiNiHiBeC_xHqqkZx_
	DWORDSet stDeleteTextObj;
	// _xZkqqHx_jFnCiPfHiDgFiDeMiDfIiDgHiPfHiNiHiBeC_xHqqkZx_
	DWORDSet stEditTextObj;
	do
	{
		// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
		BOOL bIsTarget = FALSE;

		FTGateCmd cmd;
		DWORD dwTextObjId;
		WString wstrText;
		BYTEVector vCmdQueue;

		if (m_bTargetInside)
		//----- _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmMiCnNiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			DWORDSet stInsTopObjId;
//			DWORDSet stDelTopObjId;
//			DWORDSet stEdtTopObjId;
//			DWORDSet stInsObjId;
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			DWORDSet stDelObjId;
			DWORDSet stEdtObjId;
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			FCLinkMolipInfo linkMolipIns;
//			FCLinkMolipInfo linkMolipDel;
//----- 06.04.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDfCiDhNiDjDiDgIiCmMiImKjChFiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
			const flint fliCommandTop = pCmdGate->GetBufferPosition();
			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
			pCmdGate->SkipCmd(	cmd,
								DWORDSet(),
								DWORDSet(),
								DWORDSet(),
								DWORDSet(),
								stDelObjId,
								stEdtObjId,
								FCLinkMolipInfo(),
								FCLinkMolipInfo());
			switch (cmd)
			{
			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
// 06.04.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				ASSERT(stInsObjId.empty());
				ASSERT(stDelObjId.empty());
				ASSERT(!stEdtObjId.empty());
				if (FFIsIntersect(m_stTargetObjectId, stEdtObjId))
				//----- _xZkqqHx_jFnCiPfHiClDiCoKiClNjFjEjFgJiCkKiDfOiBfLiDfBiDgCiDgHjFjEjFgJiPfHiNiHiCmGiPgEiCmIiCoJiPoKiNiH_xHqqkZx_ -----
				{
					// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
					bIsTarget = TRUE;
					// _xZkqqHx_iDfCiDhNiDjDiDgIiImKjChFiCmJjGnPiClFiCmEiCkIiCkNiBeC_xHqqkZx_
					pCmdGate->BufferSeek(fliCommandTop, CFile::begin);
					// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
					pCmdGate->SkipTextCmd(	cmd,
											dwTextObjId,
											wstrText,
											vCmdQueue);
				}
				break;
			}
			// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCkJiCoHiBeBiNoNiPjMiClDiCoKiClNjFjEjFgJiCpAjGjFiPmBiBeC_xHqqkZx_
			FFErase(m_stTargetObjectId, stDelObjId);
		} else
		//----- _xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCpAiMjPiNpFiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
			pCmdGate->SkipTextCmd(	cmd,
									dwTextObjId,
									wstrText,
									vCmdQueue);
			switch (cmd)
			{
			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
				bIsTarget = TRUE;
				break;
			}
		}
		if (bIsTarget)
		//----- _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCmMiPoKiNiH_xHqqkZx_ -----
		{
			switch (cmd)
			{
			case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHiIoKjHjHiCmJjDgPjIfOiBeC_xHqqkZx_
				m_mpObjectIdToText[dwTextObjId] = wstrText;
				// _xZkqqHx_iNoNiPjMiDgFiDeMiDfIiDgHiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOjGjFiPmBiBeC_xHqqkZx_
				// _xZkqqHx_jGkCjDgPjIfOiCmIiCoHiCmOiBeBjAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
				if (stDeleteTextObj.erase(dwTextObjId) == 0)
					stCreateTextObj.insert(dwTextObjId);
				break;
			case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHiIoKjHjHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
				m_mpObjectIdToText.erase(dwTextObjId);
				// _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOjGjFiPmBiBeC_xHqqkZx_
				// _xZkqqHx_jGkCjDgPjIfOiCmIiCoHiCmOiBeBiNoNiPjMiDgFiDeMiDfIiDgHiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
				if (stCreateTextObj.erase(dwTextObjId) == 0)
					stDeleteTextObj.insert(dwTextObjId);
				break;
			case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
				CFCWndRichEdit::RedoCmdQueue(m_mpObjectIdToText[dwTextObjId], &vCmdQueue[0], vCmdQueue.size());
				// _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiCmJjDgPjIfOiNmPiCnNiCmIiCoHiCmOiJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
				// _xZkqqHx_jGkCjDgPjIfOiCmIiCoHiCmOiBeBjFnCiPfHiDgFiDeMiDfIiDgHiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
				if (stCreateTextObj.find(dwTextObjId) == stCreateTextObj.end())
					stEditTextObj.insert(dwTextObjId);
				break;
			}

		}
	} while (pCmdGate->GetBufferPosition() != pCmdGate->GetBufferLength());
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	pCmdGate->DeleteSessionReadBuffer();

	// _xZkqqHx_jFjEjFgJiCmNiDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
	BOOL bIsHit = FALSE;
	mdef_const_iterator(DWORDSet, iId);
	m1_for (iId, stCreateTextObj)
	//----- _xZkqqHx_jAfGiLeLiNoMjAkMiDgFiDeMiDfIiDgHiPfHiNiHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (m_pTextSP->IsMatch(m_mpObjectIdToText[*iId]))
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
			m_stHitTextId.insert(*iId);
			// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIjEkNjAlGiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
			if (m_bSearchBeginOfHit)
				bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
		}
	}
	m1_for (iId, stDeleteTextObj)
	//----- _xZkqqHx_iNoNiPjMiDgFiDeMiDfIiDgHiPfHiNiHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
		if (m_stHitTextId.erase(*iId) == 1)
		//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiClOiCmBiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiPmBjGmFiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
			if (m_bSearchEndOfHit)
				bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
		}
	}
	m1_for (iId, stEditTextObj)
	//----- _xZkqqHx_jFnCiPfHiDgFiDeMiDfIiDgHiPfHiNiHiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		if (m_pTextSP->IsMatch(m_mpObjectIdToText[*iId]))
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCmJjDgPjIfOiBeC_xHqqkZx_
			if (m_stHitTextId.insert(*iId).second)
			//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkJiCmBiClNjFjEjFgJiClOiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIjEkNjAlGiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
				if (m_bSearchBeginOfHit)
					bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
			}
		} else
		//----- _xZkqqHx_jFlGiOjKjHpBiCkKiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHjCiGiCmMiDgFiDeMiDfIiDgHiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
			if (m_stHitTextId.erase(*iId) == 1)
			//----- _xZkqqHx_iClBiCoKiCnMiCmFiDhBiDgCiDgHiClFiCmEiCkCiClNjFjEjFgJiClOiCmBiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiPmBjGmFiCpAiMjPiNpFiClHiCoJiPoKiNiHiCmNiBeBiDhBiDgCiDgHiCmGiClFiCmEiIlFiCkEiBeC_xHqqkZx_
				if (m_bSearchEndOfHit)
					bIsHit = TRUE;	// _xZkqqHx_iDhBiDgCiDgHiClFiClNiCkJiBeI_xHqqkZx_
			}
		}
	}

	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
	if (bIsHit)
		AppendFindRec(FDHF_TEXT_MODIFY, fliSessionIndex + 1, pCmdGate->GetPrevSessionTime(), pCmdGate->GetPrevSessionUser(), L"", 0);
//----- 06.04.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCFindTextInfo::Search1SessionBelow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindTextInfo::Search1InterSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pForkData			:_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 7_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindTextInfo::Search1InterSession (	const FCFindForkData* pForkData,
											FCHiProject* pProject,
											FCHiSummaryTable* pHistoryIndex,
											flint fliNextSessionIndex)
{
	if (m_bSearchBeginOfHit)
	//----- _xZkqqHx_iDeMiBfLiDiPiBfLiDgIjEkNjAlGiCpAiMjPiNpF_xHqqkZx_ -----
	{
		if (fliNextSessionIndex == pForkData->m_fliSuperSessionIndex &&
			pForkData->m_lSuperDocumentId == -1 &&
			!m_stHitTextId.empty())
		//----- _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCmJiCkAiCoIiBeBiPoDiImKjHjKjHpAiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
			AppendFindRec(	FDHF_TEXT_MODIFY,
							fliNextSessionIndex,
							pProject->GetDocumentRec(m_lDocumentId).GetDate(),
							pProject->GetDocumentRec(m_lDocumentId).GetUserId(),
							L"",
							0);
		}
	}
} // FCFindTextInfo::Search1InterSession.

////////////////////////////////////////////////////////////////////////////
// FCFindCharInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindCharInfo::~FCFindCharInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindCharInfo::~FCFindCharInfo ()
{
} // FCFindCharInfo::FCFindCharInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindCharInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCFindCharInfo* pInfo = (const FCFindCharInfo*)&info;

	m_mpObjectIdToCharSelect = pInfo->m_mpObjectIdToCharSelect;
//----- 06.04.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jFlGiOjKjBkOjAkLiCmMjFmPiNfIiCpAjFmPiNfIiCmJiKnMiCnMiClJiCoJiCkJiBeI_xHqqkZx_
	m_bIsFlatChar = pInfo->m_bIsFlatChar;
//----- 06.04.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCFindCharInfo::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindCharInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCFindCharInfo::Duplicate () const
{
	FCFindCharInfo* pInfo = new FCFindCharInfo();
	*pInfo = *this;
	return pInfo;
} // FCFindCharInfo::Duplicate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindCharInfo::IsThereTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindCharInfo::IsThereTarget () const
{
	return !m_mpObjectIdToCharSelect.empty();
} // FCFindCharInfo::IsThereTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindCharInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCFindCharInfo::IsNeedCommandFile () const
{
	return TRUE;
} // FCFindCharInfo::IsNeedCommandFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindCharInfo::Search1SessionAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindCharInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeC_xHqqkZx_
	BASE_CLASS::Search1SessionAbove(pCmdGate,
									pHistoryIndex,
									fliSessionIndex);

	// _xZkqqHx_jGnPiClHjBePiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFjDjJiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
	const FDSECTIME fdstSessionTime = pCmdGate->GetPrevSessionTime();
	const GUID guidSessionUser = pCmdGate->GetPrevSessionUser();

	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjGjGjEpGiCnGiBeC_xHqqkZx_
	pCmdGate->BufferSeek(0, CFile::end);

	// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
	BOOL bIsHit = FALSE;
	do
	{
		FTGateCmd cmd;
		DWORD dwTextObjId;
		WString wstrText;
		BYTEVector vCmdQueue;
		// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjGnPiClHiBeC_xHqqkZx_
		pCmdGate->RSkipTextCmd(	cmd,
								dwTextObjId,
								wstrText,
								vCmdQueue);
		switch (cmd)
		{
		case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			// ID->_xZkqqHx_jFlGiOjKjBeJjBpAiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
			if (m_mpObjectIdToCharSelect.erase(dwTextObjId) == 1)
				bIsHit = TRUE;
			break;
		case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			break;
		case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		  {
			// ID->_xZkqqHx_jFlGiOjKjBeJjBpAiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
			map<DWORD, longRangeVector>::iterator iIdRange = m_mpObjectIdToCharSelect.find(dwTextObjId);
			if (iIdRange != m_mpObjectIdToCharSelect.end())
			{
				// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiDhEiDiJiDgCiDgHiCmFiNfIiCmJiNmFjDeLiJlLiBeC_xHqqkZx_
				CFCWndRichEdit::OptimizeCmdQueue(vCmdQueue, TRUE, m_bIsFlatChar);
				// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpA_xHqqkZx_ longRangeVector _xZkqqHx_iCmJjBmOiClFiCmE_xHqqkZx_Undo_xZkqqHx_iCmFiPfLiCmEiCoJiBeC_xHqqkZx_
				if (CFCWndRichEdit::UndoCmdQueue(iIdRange->second, &vCmdQueue[0], vCmdQueue.size()))
				//----- _xZkqqHx_jBeJjBpAjEmNiImNiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
				{
					bIsHit = TRUE;
					// _xZkqqHx_jBeJjBpAjEmNiImNiCkKiNoNiPjMiClDiCoKiCmEiLpDiCmJiCmIiCmBiClNiPoKiNiHiCmNiBeBjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
					if (iIdRange->second.empty())
						m_mpObjectIdToCharSelect.erase(iIdRange);
				}
			}
			break;
		  }
		}
		// _xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_(bIsHit == TRUE)_xZkqqHx_iCmFiCkAiCmBiCmEiCoA_xHqqkZx_
		// _xZkqqHx_iDiLiBfLiDhGiCpAjElCiCkPiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjCiGiCmJ_xHqqkZx_ FD_CMD_CREATE1_RICH_TEXT _xZkqqHx_iCmG_xHqqkZx_
		// FD_CMD_MODIFY_ABC_RICH_TEXT _xZkqqHx_iCkKiKnMiCnMiCoKiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_
		// _xZkqqHx_iDiLiBfLiDhGiCpAiNmFiMoDiCnMiCmFiPiIjHjNiClFiCmIiCkCiCmG_xHqqkZx_ m_mpObjectIdToCharSelect.erase()_xZkqqHx_iCkK_xHqqkZx_
		// _xZkqqHx_jAlDiClFiCkNiNhDiCoNiCoKiCmIiCkCiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	} while (pCmdGate->GetBufferPosition() != 0);
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	pCmdGate->DeleteSessionReadBuffer();

	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
	if (bIsHit)
		AppendFindRec(FDHF_CHAR_MODIFY, fliSessionIndex + 1, fdstSessionTime, guidSessionUser, L"", 0);
} // FCFindCharInfo::Search1SessionAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindCharInfo::Search1SessionBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindCharInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
											FCHiSummaryTable* pHistoryIndex,
											flint fliSessionIndex)
{
	// _xZkqqHx_iDiMiDfCiBfLiDgIiImKjChFiCpAiMjPiNpFiBeC_xHqqkZx_
	const DWORD dwRecordIndex = pCmdGate->PrimaryIdToIndex(fliSessionIndex);
	// _xZkqqHx_iDgPiDgCiDhEiDeAiCpAjHhAiInDiClFiBeBiOhHjCoIiClDiCoKiClNiDiMiDfCiBfLiDgIiCmMiDgGiBfLiDfOiCpAiOmKiClHiBeC_xHqqkZx_
	pCmdGate->CreateSessionReadBuffer(dwRecordIndex);
	// _xZkqqHx_iMlLiNnNiImKjChFiCmNjAoGjDkKiCnGiBeC_xHqqkZx_
	pCmdGate->BufferSeek(0, CFile::begin);

	// _xZkqqHx_iDfCiDhNiDjDiDgIjBmOiPnLiCmMjFjEjFgJiCmNiDfOiBfLiDfBiDgCiDgHiCkJiBeI_xHqqkZx_
	BOOL bIsHit = FALSE;
	do
	{
		FTGateCmd cmd;
		DWORD dwTextObjId;
		WString wstrText;
		BYTEVector vCmdQueue;
		// _xZkqqHx_iCfAiDfCiDhNiDjDiDgIjAgJiCnPiCoJiBeC_xHqqkZx_
		pCmdGate->SkipTextCmd(	cmd,
								dwTextObjId,
								wstrText,
								vCmdQueue);
		switch (cmd)
		{
		case FD_CMD_CREATE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoMjAkMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			break;
		case FD_CMD_DELETE1_RICH_TEXT:		// _xZkqqHx_iCfAjFjEjFgJiCmMiDiKiDgCiDgAiDgFiDeMiDfIiDgHiNoNiPjMiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			// ID->_xZkqqHx_jFlGiOjKjBeJjBpAiDgFiBfLiDhFiDiLiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
			if (m_mpObjectIdToCharSelect.erase(dwTextObjId) == 1)
				bIsHit = TRUE;
			break;
		case FD_CMD_MODIFY_ABC_RICH_TEXT:	// _xZkqqHx_iCfAjFjEjFgJiDgFiDeMiDfIiDgHjFmPiNfIiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		  {
			// ID->_xZkqqHx_jFlGiOjKjBeJjBpAiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
			map<DWORD, longRangeVector>::iterator iIdRange = m_mpObjectIdToCharSelect.find(dwTextObjId);
			if (iIdRange != m_mpObjectIdToCharSelect.end())
			{
				// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpAiDhEiDiJiDgCiDgHiCmFiNfIiCmJiNmFjDeLiJlLiBeC_xHqqkZx_
				CFCWndRichEdit::OptimizeCmdQueue(vCmdQueue, TRUE, m_bIsFlatChar);
				// _xZkqqHx_iDfCiDhNiDjDiDgIiDeMiDiFiBfLiCpA_xHqqkZx_ longRangeVector _xZkqqHx_iCmJjBmOiClFiCmE_xHqqkZx_Redo_xZkqqHx_iCmFiPfLiCmEiCoJiBeC_xHqqkZx_
				if (CFCWndRichEdit::RedoCmdQueue(iIdRange->second, &vCmdQueue[0], vCmdQueue.size()))
				//----- _xZkqqHx_jBeJjBpAjEmNiImNiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiH_xHqqkZx_ -----
				{
					bIsHit = TRUE;
					// _xZkqqHx_jBeJjBpAjEmNiImNiCkKiNoNiPjMiClDiCoKiCmEiLpDiCmJiCmIiCmBiClNiPoKiNiHiCmNiBeBjDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
					if (iIdRange->second.empty())
						m_mpObjectIdToCharSelect.erase(iIdRange);
				}
			}
			break;
		  }
		}
		// _xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_(bIsHit == TRUE)_xZkqqHx_iCmFiCkAiCmBiCmEiCoA_xHqqkZx_
		// _xZkqqHx_iDiLiBfLiDhGiCpAjElCiCkPiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjCiGiCmJ_xHqqkZx_ FD_CMD_CREATE1_RICH_TEXT _xZkqqHx_iCmG_xHqqkZx_
		// FD_CMD_MODIFY_ABC_RICH_TEXT _xZkqqHx_iCkKiKnMiCnMiCoKiCoJiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_
		// _xZkqqHx_iDiLiBfLiDhGiCpAiNmFiMoDiCnMiCmFiPiIjHjNiClFiCmIiCkCiCmG_xHqqkZx_ m_mpObjectIdToCharSelect.erase()_xZkqqHx_iCkK_xHqqkZx_
		// _xZkqqHx_jAlDiClFiCkNiNhDiCoNiCoKiCmIiCkCiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeC_xHqqkZx_
	} while (pCmdGate->GetBufferPosition() != pCmdGate->GetBufferLength());
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDgPiDgCiDhEiDeAiCpAiJpAjFpKiClHiCoJiBeC_xHqqkZx_
	pCmdGate->DeleteSessionReadBuffer();

	// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
	if (bIsHit)
		AppendFindRec(FDHF_CHAR_MODIFY, fliSessionIndex + 1, pCmdGate->GetPrevSessionTime(), pCmdGate->GetPrevSessionUser(), L"", 0);

	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeC_xHqqkZx_
	BASE_CLASS::Search1SessionBelow(pCmdGate,
									pHistoryIndex,
									fliSessionIndex);
} // FCFindCharInfo::Search1SessionBelow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFindCharInfo::Search1InterSession
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pForkData			:_xZkqqHx_iDhEiDeIiBfLiDeOiDhEiDeAiDeDiDiLiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliNextSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmMiCoGiCkEiCmJiBeBiDfKiDgCiDfGiDiHiDjDiCkK_xHqqkZx_ [0 - 6] _xZkqqHx_iCmMjHjKjHpAiCmMiDfAiBfLiDfIiCpAiNgMiCkGiCmEiCnNiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCkK_xHqqkZx_NextSession=4_xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			_xZkqqHx_iPoDjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 3_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 2_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 1_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 0_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKjFpLiMjPiNpFiCmJiCkIiCkCiCmEiBeB_xHqqkZx_Search1InterSession _xZkqqHx_iCmNiBeB_xHqqkZx_
 *			fliNextSessionIndex = 4_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 5_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 6_xZkqqHx_iBeB_xHqqkZx_
 *			fliNextSessionIndex = 7_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iCmMiMhGiCfDiJpBiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *              _xZkqqHx_iEkBiEjPiEjPiEjPiEkC_xHqqkZx_
 *              _xZkqqHx_iEkA_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *              _xZkqqHx_iEkEiEjPiEkGiEjPiEkDiEjP_xHqqkZx_ NextSession = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 0
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 1
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 2
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 3
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 4 _xZkqqHx_iBkJiMjPiNpFiKeKiOgOiImKjChF_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 4   _xZkqqHx_iBfA_xHqqkZx_
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 5
 *                  _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 6
 *                  _xZkqqHx_iEkA_xHqqkZx_       Session = 6
 *                  _xZkqqHx_iBkE_xHqqkZx_  _xZkqqHx_iEjPiEjP_xHqqkZx_ NextSession = 7
 *
 *			_xZkqqHx_jFjEjFgJjFmPiNfIiBeBiDiKiDjDiDeOjFmPiNfIiBeBiOjOiNiPiCmIiCmHiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmJiKnMiCnMiCoKiCoJiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFkKiKpCiDfOiDePiCmNiBeBiDfKiDgCiDfGiDiHiDjDiCmMiDeDiDjDiDfOiBfLiDgPiDiLiBeBjBkGiClPiPoDjAhNiCmM_xHqqkZx_
 *			NextSession _xZkqqHx_jFjEjFkKiCmJiKnMiCnMiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_Search1InterSession_xZkqqHx_iKnGjAjEiCmFiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFindCharInfo::Search1InterSession (	const FCFindForkData* pForkData,
											FCHiProject* pProject,
											FCHiSummaryTable* pHistoryIndex,
											flint fliNextSessionIndex)
{
	if (fliNextSessionIndex == pForkData->m_fliSuperSessionIndex &&
		pForkData->m_lSuperDocumentId == -1 &&
		!m_mpObjectIdToCharSelect.empty())
	//----- _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCmJiCkAiCoIiBeBiPoDiImKjHjKjHpAiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiBeC_xHqqkZx_
		AppendFindRec(	FDHF_CHAR_MODIFY,
						fliNextSessionIndex,
						pProject->GetDocumentRec(m_lDocumentId).GetDate(),
						pProject->GetDocumentRec(m_lDocumentId).GetUserId(),
						L"",
						0);
	}
} // FCFindCharInfo::Search1InterSession.

////////////////////////////////////////////////////////////////////////////
// FCTimeIndexFile _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::FCTimeIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vector<FCTimeIndexFile>_xZkqqHx_iCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeIndexFile::FCTimeIndexFile ()
				:m_fdstFirstSessionTime(0),
				m_fdstLastSessionTime(0)
{
} // FCTimeIndexFile::FCTimeIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::FCTimeIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	timeIndexFile	:_xZkqqHx_iOfBiPmGiClHiCoJiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vector<FCTimeIndexFile>_xZkqqHx_iCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeIndexFile::FCTimeIndexFile (const FCTimeIndexFile& timeIndexFile)
				:m_fdstFirstSessionTime(0),
				m_fdstLastSessionTime(0)
{
	// _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiKeKiCkCiCmEiCkJiCoHiBeB_xHqqkZx_vector_xZkqqHx_iDfEiDeDiDfJiCmMjFmPiNfIiCmNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	if (timeIndexFile.IsFileOpened())
		FFThrowMiscUnknown();
} // FCTimeIndexFile::FCTimeIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::~FCTimeIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTimeIndexFile::~FCTimeIndexFile ()
{
	Close();
} // FCTimeIndexFile::~FCTimeIndexFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::Open
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiKeKiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsSave		:_xZkqqHx_iPjBiCkLiNjOiCnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjDmHiCnNiPgPiClFiCmMiCnNiCmMiPoKiNiHiCmN_xHqqkZx_
 *						 FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDhGiDjDiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCTimeIndexFile::Open (const wchar_t* wcpFilePath, BOOL bIsSave)
{
	if (bIsSave)
		return m_file.Open(	WStrToTStr(wcpFilePath),
							CFile::modeCreate | CFile::modeReadWrite | CFile::shareExclusive);
	else
		return m_file.Open(	WStrToTStr(wcpFilePath),
							CFile::modeRead | CFile::shareDenyNone);
} // FCTimeIndexFile::Open.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::Close
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAjFmCiClGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTimeIndexFile::Close ()
{
	if (IsFileOpened())
		m_file.Close();
} // FCTimeIndexFile::Close.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::UpdateData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiNmFiPiJiCmMjFnCiPfHiOjOiKnEiCmGiNmFiMoDiCmMjFnCiPfHiOjOiKnEiCpAjDmHiCnNiPgPiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iDiBiDjDiDgPiBfLjFmPjAjEiCmJiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTimeIndexFile::UpdateData ()
{
	m_fdstFirstSessionTime = SeeSessionTime(0);
	m_fdstLastSessionTime = SeeSessionTime(GetCount() - 1);
} // FCTimeIndexFile::UpdateData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::GetFirstSessionTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UpdateData_xZkqqHx_iKnGjAjEiCmFiLeMjIfOiClFiClNiBeBiNmFiPiJiCmMjFnCiPfHiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMjFnCiPfHiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCTimeIndexFile::GetFirstSessionTime () const
{
	return m_fdstFirstSessionTime;
} // FCTimeIndexFile::GetFirstSessionTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::GetLastSessionTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UpdateData_xZkqqHx_iKnGjAjEiCmFiLeMjIfOiClFiClNiBeBiNmFiMoDiCmMjFnCiPfHiOjOiKnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMjFnCiPfHiOjOiKnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCTimeIndexFile::GetLastSessionTime () const
{
	return m_fdstLastSessionTime;
} // FCTimeIndexFile::GetLastSessionTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::IsFileOpened
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCTimeIndexFile::IsFileOpened () const
{
	return (m_file.m_hFile != CFile::hFileNull);
} // FCTimeIndexFile::IsFileOpened.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::GetFilePath
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDhAiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCTimeIndexFile::GetFilePath () const
{
	return TStrToWStr(m_file.GetFilePath());
} // FCTimeIndexFile::GetFilePath.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::See
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmMiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeCiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmN_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiPgPiClJiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCTimeIndexFile::See (FDSECTIME* fdstSessionTime, long* lDocumentId, flint* fliSessionIndex)
{
	const flint fliCurrentIndex = GetCurrentIndex();
	BOOL bSucceed = Read(fdstSessionTime, lDocumentId, fliSessionIndex);
	SetCurrentIndex(fliCurrentIndex);
	return bSucceed;
} // FCTimeIndexFile::See.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::See
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmMiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmNiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	timeIndexRec:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeFjFlGiPjB_xHqqkZx_ID_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			lIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiPgPiClJiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCTimeIndexFile::See (FCTimeIndexRec& timeIndexRec, flint fliIndex)
{
	const flint fliCurrentIndex = GetCurrentIndex();
	SetCurrentIndex(fliIndex);
	BOOL bSucceed = Read(&timeIndexRec.first, &timeIndexRec.second, &timeIndexRec.third);
	SetCurrentIndex(fliCurrentIndex);
	return bSucceed;
} // FCTimeIndexFile::See.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::SeeSessionTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmNiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeCjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FDSECTIME(-1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FDSECTIME FCTimeIndexFile::SeeSessionTime (flint fliIndex)
{
	const flint fliCurrentIndex = GetCurrentIndex();
	SetCurrentIndex(fliIndex);
	FDSECTIME fdstSessionTime;
	if (m_file.Read(&fdstSessionTime, sizeof(fdstSessionTime)) != sizeof(FDSECTIME))
		return FDSECTIME(-1);
	SetCurrentIndex(fliCurrentIndex);
	return fdstSessionTime;
} // FCTimeIndexFile::SeeSessionTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::Read
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmMiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeCiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpA_xHqqkZx_
 *			_xZkqqHx_iOjPiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiPgPiClJiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCTimeIndexFile::Read (FDSECTIME* fdstSessionTime, long* lDocumentId, flint* fliSessionIndex)
{
	FDSECTIME fdstTmp;
	long lTmp;
	flint fliTmp;
	if (m_file.Read(&fdstTmp, sizeof(fdstTmp)) != sizeof(fdstTmp))
		return FALSE;
	if (m_file.Read(&lTmp, sizeof(lTmp)) != sizeof(lTmp))
		return FALSE;
	if (m_file.Read(&fliTmp, sizeof(fliTmp)) != sizeof(fliTmp))
		return FALSE;
	if (fdstSessionTime != NULL)
		*fdstSessionTime = fdstTmp;
	if (lDocumentId != NULL)
		*lDocumentId = lTmp;
	if (fliSessionIndex != NULL)
		*fliSessionIndex = fliTmp;
	return TRUE;
} // FCTimeIndexFile::Read.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::Read
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmMiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeCiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpA_xHqqkZx_
 *			_xZkqqHx_iOjPiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	timeIndexRec:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeFjFlGiPjB_xHqqkZx_ID_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiPgPiClJiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCTimeIndexFile::Read (FCTimeIndexRec& timeIndexRec)
{
	return Read(&timeIndexRec.first, &timeIndexRec.second, &timeIndexRec.third);
} // FCTimeIndexFile::Read.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::RRead
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClMjBePiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmMiPoOjFpBiCpAjDmHiCnNiPgPiClHiBeCiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpA_xHqqkZx_
 *			_xZkqqHx_jBePiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAjFnEiClHiBeCjFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiPgPiClJiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeBjDmHiCnNiPgPiClJiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCTimeIndexFile::RRead (FDSECTIME* fdstSessionTime, long* lDocumentId, flint* fliSessionIndex)
{
	const flint fliCurrentIndex = GetCurrentIndex();
	if (fliCurrentIndex == 0)
		return FALSE;
	SetCurrentIndex(fliCurrentIndex - 1);
	if (!Read(fdstSessionTime, lDocumentId, fliSessionIndex))
		return FALSE;
	SetCurrentIndex(fliCurrentIndex - 1);
	return TRUE;
} // FCTimeIndexFile::RRead.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::Write
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJiPoOjFpBiCpAiPjBiCkLiNjOiCnOiBeCiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpA_xHqqkZx_
 *			_xZkqqHx_iOjPiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lDocumentId		:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTimeIndexFile::Write (const FDSECTIME& fdstSessionTime, const long& lDocumentId, const flint& fliSessionIndex)
{
	m_file.Write(&fdstSessionTime, sizeof(fdstSessionTime));
	m_file.Write(&lDocumentId, sizeof(lDocumentId));
	m_file.Write(&fliSessionIndex, sizeof(fliSessionIndex));
} // FCTimeIndexFile::Write.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::Write
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJiPoOjFpBiCpAiPjBiCkLiNjOiCnOiBeCiMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpA_xHqqkZx_
 *			_xZkqqHx_iOjPiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	timeIndexRec:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeFjFlGiPjB_xHqqkZx_ID_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTimeIndexFile::Write (const FCTimeIndexRec& timeIndexRec)
{
	Write(timeIndexRec.first, timeIndexRec.second, timeIndexRec.third);
} // FCTimeIndexFile::Write.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::GetCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCTimeIndexFile::GetCount ()
{
	return m_file.GetLength() / (sizeof(FDSECTIME) + sizeof(long) + sizeof(flint));
} // FCTimeIndexFile::GetCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::GetCurrentIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
flint FCTimeIndexFile::GetCurrentIndex ()
{
	return m_file.GetPosition() / (sizeof(FDSECTIME) + sizeof(long) + sizeof(flint));
} // FCTimeIndexFile::GetCurrentIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTimeIndexFile::SetCurrentIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliIndex	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTimeIndexFile::SetCurrentIndex (flint fliIndex)
{
	m_file.Seek(fliIndex * (sizeof(FDSECTIME) + sizeof(long) + sizeof(flint)), CFile::begin);
} // FCTimeIndexFile::SetCurrentIndex.

////////////////////////////////////////////////////////////////////////////
// FCMakeTimeIndexInfo _xZkqqHx_iDiBiDjDiDgPiBfLiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::FCMakeTimeIndexInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCMakeTimeIndexInfo::FCMakeTimeIndexInfo ()
					:m_bThereIsTarget(TRUE),
					 m_bIsTopOfTop(TRUE),
					 m_fdstPrevTime(FDSECTIME_MIN)
{
} // FCMakeTimeIndexInfo::FCMakeTimeIndexInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::~FCMakeTimeIndexInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCMakeTimeIndexInfo::~FCMakeTimeIndexInfo ()
{
	m_file.Close();
} // FCMakeTimeIndexInfo::~FCMakeTimeIndexInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCpAjFkBiOmKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	info	:_xZkqqHx_jFkBiOmKiMlDiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCMakeTimeIndexInfo::operator = (const FCFindBaseInfo& info)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::operator =(info);
	const FCMakeTimeIndexInfo* pInfo = (const FCMakeTimeIndexInfo*)&info;

	m_wstrWorkDirPath = pInfo->m_wstrWorkDirPath;
	m_bThereIsTarget = pInfo->m_bThereIsTarget;
	m_bIsTopOfTop = pInfo->m_bIsTopOfTop;
	// m_fdstPrevTime _xZkqqHx_iCmNjFkBiOmKiClFiCmIiCkCiBeC_xHqqkZx_
} // FCMakeTimeIndexInfo::operator.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::Duplicate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMjFkBiOmKiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFkBiOmKiNoMjAkMiClFiClNiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCFindBaseInfo* FCMakeTimeIndexInfo::Duplicate () const
{
	FCMakeTimeIndexInfo* pInfo = new FCMakeTimeIndexInfo();
	*pInfo = *this;
	return pInfo;
} // FCMakeTimeIndexInfo::Duplicate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::IsThereTarget
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFjBmOiPnLiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCMakeTimeIndexInfo::IsThereTarget () const
{
	return m_bThereIsTarget;
} // FCMakeTimeIndexInfo::IsThereTarget.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::IsNeedCommandFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCkKjFeLjHhGiCmIiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCMakeTimeIndexInfo::IsNeedCommandFile () const
{
	return TRUE;
} // FCMakeTimeIndexInfo::IsNeedCommandFile.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::Search1SessionAbove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiPoDiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiPoDiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCMakeTimeIndexInfo::Search1SessionAbove (	FCHiCommandTable* pCmdGate,
												FCHiSummaryTable* pHistoryIndex,
												flint fliSessionIndex)
{
	FFThrowMiscUnknown();
} // FCMakeTimeIndexInfo::Search1SessionAbove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::Search1SessionBelow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiCfAiDfKiDgCiDfGiDiHiDjDiJlKiCpAiMjPiNpFiClHiCoJiBeCiDfKiDgCiDfGiDiHiDjDiCmNiCfAiCmCiJlKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdGate			:_xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pHistoryIndex		:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *								 _xZkqqHx_iOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			fliSessionIndex	:_xZkqqHx_iMlLiNnNiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCMakeTimeIndexInfo::Search1SessionBelow (	FCHiCommandTable* pCmdGate,
												FCHiSummaryTable* pHistoryIndex,
												flint fliSessionIndex)
{
	if (m_bIsTopOfTop)
	//----- _xZkqqHx_iNmFiPoDiImKjHjKjHpAiCmMiBeBiNmFiPiJiCmMiDfKiDgCiDfGiDiHiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_bIsTopOfTop = FALSE;
		// _xZkqqHx_iIoKjEnEiNmFiPiJiCmMiPoOjFpBiCpAjCmHiJmBiBeCiClBiCoKiCpAjAnNjCoIiClFiCmIiCkCiCmGiBeB_xHqqkZx_
		// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiIoKjEnEiNmFiPiJiCmMiPoOjFpBiCkKjElCiCkPiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		// _xZkqqHx_jCeBiClFiBeBjBfDjFlGiPjBiCmMjAoGjDkKiCmFiPoOjFpBjCmHiJmBiCpAiClFiCmEiClFiCnMiCkEiCmGiBeBjHjKjHpAjFkKiKpCiMlDiCmG_xHqqkZx_
		// _xZkqqHx_jFkKiKpCjAoGiCmFiDeDiDjDiDgGiDgCiDeOiDfIiCmJiPgEiCmIiCoIiCkKiPgPjHiIiCmEiClFiCnMiCkEiBeC_xHqqkZx_
		AppendFindRec(FDHF_NONE, fliSessionIndex, pCmdGate->GetPrevSessionTime(), pCmdGate->GetPrevSessionUser(), L"", 0);
	}
	// _xZkqqHx_iCfAiDfKiDgCiDfGiDiHiDjDjAgJiCnPiCoJiBeC_xHqqkZx_
	pCmdGate->SkipSessionNext();
	// _xZkqqHx_iPoOjFpBiCpAjCmHiJmBiBeC_xHqqkZx_
	AppendFindRec(FDHF_NONE, fliSessionIndex + 1, pCmdGate->GetPrevSessionTime(), pCmdGate->GetPrevSessionUser(), L"", 0);
} // FCMakeTimeIndexInfo::Search1SessionBelow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCMakeTimeIndexInfo::AppendFindRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiMiLiJmKiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliSessionIndex	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fdstSessionTime	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guidSessionUser	:_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCFindDateBaseInfo _xZkqqHx_iCmMiMjPiNpFiMiLiJmKiCmNiBeBiIoKiCmCiCmMjHjKjHpAjFlGiPjBiCmFiCfAiCmCiClOiCkPiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCmMiOjOiKnEiCmJiNmFiCoAiLnPiCkCjCgMiCmMiCnNiOgDiClHiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCMakeTimeIndexInfo::AppendFindRec (FTHFRecType recType,
										flint fliSessionIndex,
										FDSECTIME fdstSessionTime,
										GUID guidSessionUser,
										const wchar_t* wcpComment,
										long lId)
{
	if (fdstSessionTime < m_fdstPrevTime)
	//----- _xZkqqHx_jBePiJpBjDmHiCnNiPgPiClFiClNiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCoGiCoIiJnPiLiOiCmJjGnPiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiMoDjFpLiInKjDkOiClFiCkJiPiIjHjNiClFiCmIiCkCiCmMiCmFiPlIiPiHiCmFiCkAiCoJiCmNiClIiCmIiCmMiClOiCkKiBeB_xHqqkZx_
		// _xZkqqHx_iPjBiCkLiNjOiCnNiCpAiClHiCoJ_xHqqkZx_PC_xZkqqHx_iClCiCmGiCmMiDfOiDeDiDhNiBfLiCmMiIoBiCkCiCmFiOjOiKnEiCkKjBePiMoDiClHiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmNiDhGiDiJiDeDiDhNiDiKiBfLiDeMiBfLiCmGiClFiCmEiOgHiCkEiClNiCnPiBeBjAoCjBmOiCmJiPlIiPiHiCmF_xHqqkZx_
		// _xZkqqHx_iCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iPlIiPiHiCmJiCmIiCoJiCoGiCkEiBeBiClBiClBiCmFjFoCjAlDiClHiCoJiBeCjAlDiClFiCkCjCgMiCmFiCmNiCmIiCkCiCkKiBeB_xHqqkZx_
		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmGiClFiCmEiOgHiCkEiCmJiCmNjGoCjBoIiCmIiCkCiBeC_xHqqkZx_
		fdstSessionTime = m_fdstPrevTime;
	}
	// _xZkqqHx_jBePiJpBiCmMiDfKiDgCiDfGiDiHiDjDiOjOiKnEiCpAiLeMjIfOiBeC_xHqqkZx_
	m_fdstPrevTime = fdstSessionTime;

	// _xZkqqHx_iNgJiNjOiCnNiPpAiMiPiCmJiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!CanAppendFindRec(	fliSessionIndex,
							fdstSessionTime,
							guidSessionUser))
	{
		// _xZkqqHx_iPoDiMmAiCmMiOjOiKnEiCpAjClEiCkGiCoJiPoKiNiHiCmNiDfOiBfLiDfBiDgCiDgHjGlDiClFiBeC_xHqqkZx_
		if (m_fdstLimitTimeUntil < fdstSessionTime)
			m_bThereIsTarget = FALSE;
		return;
	}

	if (!m_file.IsFileOpened())
	//----- _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCkKjFmCiClGiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		WString wstrFilePath;
		wstrFilePath.Format(L"%s\\%ld%s", m_wstrWorkDirPath.c_str(), m_lDocumentId, FD_FILE_EXT_TIME_INDEX);
		if (!m_file.Open(wstrFilePath, TRUE))
			return;
	}
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiCmJiBeBiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBhLjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBhLiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ _xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	m_file.Write(fdstSessionTime, m_lDocumentId, fliSessionIndex);
} // FCMakeTimeIndexInfo::AppendFindRec.

