#ifndef __HistoryFindInfo_h
#define __HistoryFindInfo_h

//----- 06.02.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#include "HiProject.h"		// For FCHiProject.
//#include "HiForkTable.h"	// For FCIdxToTimeLabelInfoMmap,etc.
//----- 06.02.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
#include "HistoryFind.h"	// For FDHF_NONE.etc.

class FCFindForkData;
class FCSearchParser;
class FCHiProject;
class FCHiCommandTable;
class FCHiSummaryTable;
struct FCLinkMolipInfo;
enum FTGateCmd;
enum FTHFRecType;

// 06.02.21 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//typedef map<DWORD, WString> ObjIdToWStringMap;

//----- 06.04.17 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_jHjKjHpAiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiKgHjCkDiOhBiBeC_xHqqkZx_
#define FD_FILE_EXT_TIME_INDEX	L".idx"
//----- 06.04.17 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindBaseInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiPoOjFpBiCpAiLeMjIfOiClHiCoJiKoOjCoKiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindBaseInfo
{
public:
	FCFindBaseInfo ();
	virtual ~FCFindBaseInfo ();
	virtual BOOL Initialize (const HString& hstrProjectPath);
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const = 0;
	virtual BOOL IsThereTarget () const;
	virtual BOOL IsNeedCommandFile () const = 0;
	virtual BOOL IsNeedIndexFile () const;
	virtual void Search1SessionAbove (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1SessionBelow (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1InterSession (	const FCFindForkData* pForkData,
										FCHiProject* pProject,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
protected:
	virtual BOOL CanAppendFindRec (	flint fliSessionIndex,
									FDSECTIME fdstSessionTime,
									GUID guidSessionUser) const;
	virtual void AppendFindRec (FTHFRecType recType,
								flint fliSessionIndex,
								FDSECTIME fdstSessionTime,
								GUID guidSessionUser,
								const wchar_t* wcpComment,
								long lId);

public:
	struct FindRec
	{
		FindRec (	FTHFRecType recType = FDHF_NONE,
					FDSECTIME fdstSessionTime = -1,
					const GUID& guidSessionUser = GUID_NULL,
					const wchar_t* wcpComment = L"",
					long lId = 0,
					int iAreaFlag = 0)
		:	m_recType(recType),
			m_fdstSessionTime(fdstSessionTime),
			m_guidSessionUser(guidSessionUser),
			m_wstrComment(wcpComment),
			m_lId(lId),
			m_iAreaFlag(iAreaFlag) {}

		FTHFRecType	m_recType;
		FDSECTIME	m_fdstSessionTime;
		GUID		m_guidSessionUser;
		WString		m_wstrComment;
		long		m_lId;
		int			m_iAreaFlag;		// _xZkqqHx_jEmNiImNiOhHjCoIiDhEiDiJiDePiBeCiClBiCmMiDiMiDfCiBfLiDgIiCmMiDfKiDgCiDfGiDiHiDjDiDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
										// A_xZkqqHx_iCmGiClFiCmEiBeB_xHqqkZx_[A,A]_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ 0_xZkqqHx_iBeB_xHqqkZx_[A,X]_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_[X,A]_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ 1_xZkqqHx_iBeC_xHqqkZx_
	};
public:

	long		m_lDocumentId;			// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjHjKjHpAjFlGiPjBiBeC_xHqqkZx_
	flint		m_fliNextSessionIndex;	// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiBeC_xHqqkZx_

	BOOL		m_bIsSearchAbove;		// _xZkqqHx_jBePjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL		m_bIsSearchSuper;		// _xZkqqHx_iPoDiImKjHjKjHpAiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL		m_bIsSearchAboveBranch;	// _xZkqqHx_jBePjFpLiCmMjBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL		m_bIsSearchBelow;		// _xZkqqHx_iMoDjFpLiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL		m_bIsSearchBelowBranch;	// _xZkqqHx_jBlMiCmMiOhNiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_

//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	FCSearchParser*		m_pSP;					// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeCiMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	ObjIdToWStringMap	m_mpLabelIdToString;	// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeCiMjPiNpFiClDiCoKiCoJiDiJiDhIiDiLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	BOOL				m_bLabelHitting;		// _xZkqqHx_iDiJiDhIiDiLiNgJiNjOiCnNjHhAiBeCiMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//----- 06.03.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	FDSECTIME	m_fdstLimitTimeFrom;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	FDSECTIME	m_fdstLimitTimeUntil;	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiCmMiNgJiNjOiCnNiBeC_xHqqkZx_
	set<GUID>	m_stLimitUserId;		// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiDiGiBfLiDfFiCmMiNgJiNjOiCnNiBeC_xHqqkZx_

	map<flint, FindRec>	m_mpFindRec;	// _xZkqqHx_iMjPiNpFiMiLiJmKiBeC_xHqqkZx_
}; // class FCFindBaseInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindObjDynabaseInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeCiKoOjGhLiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindObjDynabaseInfo : public FCFindBaseInfo
{
protected:
typedef FCFindBaseInfo BASE_CLASS;

public:
	virtual ~FCFindObjDynabaseInfo ();
	virtual void operator = (const FCFindBaseInfo& info);
	virtual BOOL IsNeedCommandFile () const;
// 06.03.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL IsNeedIndexFile () const;

	virtual void SetTargetObjects (const ObjDynabaseVector& vObj);

	virtual void Search1SessionAbove (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1SessionBelow (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);

protected:
	virtual void AppendFindRec (FTHFRecType recType,
								flint fliSessionIndex,
								FDSECTIME fdstSessionTime,
								GUID guidSessionUser,
								const wchar_t* wcpComment,
								long lId);
	virtual FTHFRecType IsHitCommandAbove (	FTGateCmd cmd,
											const DWORDSet& stInsObjId,
											const DWORDSet& stDelObjId,
											const DWORDSet& stEdtObjId,
											const FCLinkMolipInfo& linkMolipIns,
											const FCLinkMolipInfo& linkMolipDel) = 0;
	virtual FTHFRecType IsHitCommandBelow (	FTGateCmd cmd,
											const DWORDSet& stInsObjId,
											const DWORDSet& stDelObjId,
											const DWORDSet& stEdtObjId,
											const FCLinkMolipInfo& linkMolipIns,
											const FCLinkMolipInfo& linkMolipDel) = 0;


public:
	DWORDSet				m_stObjectId;			// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCmMiPfHiNiHiBeCiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCoAiCkAiCoJiBeCiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClHiCoJiCoAiCmMiCpAiMjPiNpFiBeC_xHqqkZx_
	DWORDSet				m_stTopObjectId;		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCmMiPfHiNiHiBeCiDgHiDgCiDhGjFjEjFgJiBeC_xHqqkZx_

//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	FCSearchParser*			m_pSP;					// _xZkqqHx_iMjPiNpFiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
//	ObjIdToWStringMap		m_mpLabelIdToString;	// _xZkqqHx_iMjPiNpFiClDiCoKiCoJiDiJiDhIiDiLiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
//	BOOL					m_bLabelHitting;		// _xZkqqHx_iMlLiNnNiCmMiMjPiNpFiImKjChFiCkKiDiJiDhIiDiLiMjPiNpFiPpAiMiPiCmJiDhBiDgCiDgHjCiGiCkJiBeI_xHqqkZx_
//----- 06.03.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
}; // class FCFindObjDynabaseInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindObjectInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindObjectInfo : public FCFindObjDynabaseInfo
{
protected:
typedef FCFindObjDynabaseInfo BASE_CLASS;

public:
	virtual ~FCFindObjectInfo ();
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const;
// 06.02.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL IsThereTarget () const;

protected:
	virtual FTHFRecType IsHitCommandAbove (	FTGateCmd cmd,
											const DWORDSet& stInsObjId,
											const DWORDSet& stDelObjId,
											const DWORDSet& stEdtObjId,
											const FCLinkMolipInfo& linkMolipIns,
											const FCLinkMolipInfo& linkMolipDel);
	virtual FTHFRecType IsHitCommandBelow (	FTGateCmd cmd,
											const DWORDSet& stInsObjId,
											const DWORDSet& stDelObjId,
											const DWORDSet& stEdtObjId,
											const FCLinkMolipInfo& linkMolipIns,
											const FCLinkMolipInfo& linkMolipDel);

public:
	BOOL	m_bFindCreateObject;	// _xZkqqHx_jFjEjFgJiCmMjAfGiLeLiNoMjAkMiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL	m_bFindDeleteObject;	// _xZkqqHx_jFjEjFgJiCmMiNoNiPjMiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL	m_bFindModifyObject;	// _xZkqqHx_jFjEjFgJiCmMjFmPiNfIiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL	m_bFindModifyText;		// _xZkqqHx_jFjEjFgJiCmMiDgFiDeMiDfIiDgHjFmPiNfIiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
}; // class FCFindObjectInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindLinkInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindLinkInfo : public FCFindObjDynabaseInfo
{
protected:
typedef FCFindObjDynabaseInfo BASE_CLASS;

public:
	virtual ~FCFindLinkInfo ();
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const;
// 06.02.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL IsThereTarget () const;

protected:
	virtual FTHFRecType IsHitCommandAbove (	FTGateCmd cmd,
											const DWORDSet& stInsObjId,
											const DWORDSet& stDelObjId,
											const DWORDSet& stEdtObjId,
											const FCLinkMolipInfo& linkMolipIns,
											const FCLinkMolipInfo& linkMolipDel);
	virtual FTHFRecType IsHitCommandBelow (	FTGateCmd cmd,
											const DWORDSet& stInsObjId,
											const DWORDSet& stDelObjId,
											const DWORDSet& stEdtObjId,
											const FCLinkMolipInfo& linkMolipIns,
											const FCLinkMolipInfo& linkMolipDel);

public:
	BOOL	m_bFindCreateLink;
	BOOL	m_bFindDeleteLink;
	BOOL	m_bFindCreateInterLink;
	BOOL	m_bFindDeleteInterLink;
}; // class FCFindLinkInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindLabelInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiJiDhIiDiLiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindLabelInfo : public FCFindBaseInfo
{
protected:
typedef FCFindBaseInfo BASE_CLASS;

public:
	virtual ~FCFindLabelInfo ();
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const;
	virtual BOOL IsNeedCommandFile () const;
	virtual BOOL IsNeedIndexFile () const;
	virtual void Search1SessionAbove (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1SessionBelow (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1InterSession (	const FCFindForkData* pForkData,
										FCHiProject* pProject,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);

public:
	BOOL	m_bFindCreateLabel;
	BOOL	m_bFindDeleteLabel;
	BOOL	m_bFindTimeLabel;
	FCSearchParser*	m_pLabelSP;
}; // class FCFindLabelInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindDocumentInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiBeBjHjKjHpAjFkKiKpCiDfOiDePiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindDocumentInfo : public FCFindBaseInfo
{
protected:
typedef FCFindBaseInfo BASE_CLASS;

public:
	virtual ~FCFindDocumentInfo ();
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const;
	virtual BOOL IsNeedCommandFile () const;
	virtual BOOL IsNeedIndexFile () const;
	virtual void Search1InterSession (	const FCFindForkData* pForkData,
										FCHiProject* pProject,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);

public:
	BOOL	m_bFindDocument;
	BOOL	m_bFindHiForkTag;
	BOOL	m_bFindComment;
	FCSearchParser*	m_pDocSP;
}; // class FCFindDocumentInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindDateBaseInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindDateBaseInfo : public FCFindBaseInfo
{
protected:
typedef FCFindBaseInfo BASE_CLASS;

public:
	virtual ~FCFindDateBaseInfo ();
	virtual void operator = (const FCFindBaseInfo& info);

protected:
	virtual void AppendFindRec (FTHFRecType recType,
								flint fliSessionIndex,
								FDSECTIME fdstSessionTime,
								GUID guidSessionUser,
								const wchar_t* wcpComment,
								long lId);

public:
	FDSECTIME	m_fdstTargetTime;	// _xZkqqHx_iMjPiNpFiClHiCoJiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
}; // class FCFindDateBaseInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindDateAInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeCiDeDiDjDiDgGiDgCiDeOiDfIiCmMiCnNiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindDateAInfo : public FCFindDateBaseInfo
{
protected:
typedef FCFindDateBaseInfo BASE_CLASS;

public:
	virtual ~FCFindDateAInfo ();
	virtual FCFindBaseInfo* Duplicate () const;
	virtual BOOL IsNeedCommandFile () const;
	virtual BOOL IsNeedIndexFile () const;
	virtual void Search1InterSession (	const FCFindForkData* pForkData,
										FCHiProject* pProject,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
}; // class FCFindDateAInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindDateBInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpKiOjOiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeCiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCpAiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindDateBInfo : public FCFindDateBaseInfo
{
protected:
typedef FCFindDateBaseInfo BASE_CLASS;

public:
	virtual ~FCFindDateBInfo ();
	virtual FCFindBaseInfo* Duplicate () const;
	virtual BOOL IsNeedCommandFile () const;
	virtual BOOL IsNeedIndexFile () const;
	virtual void Search1SessionAbove (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1SessionBelow (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
}; // class FCFindDateBInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindTextInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHjFjEjFgJiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindTextInfo : public FCFindBaseInfo
{
protected:
typedef FCFindBaseInfo BASE_CLASS;

public:
	virtual ~FCFindTextInfo ();
	virtual BOOL Initialize (const HString& hstrProjectPath);
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const;
	virtual BOOL IsThereTarget () const;
	virtual BOOL IsNeedCommandFile () const;
	virtual BOOL IsNeedIndexFile () const;
	virtual void SetTargetObjects (const ObjDynabaseVector& vObj);

	virtual void Search1SessionAbove (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1SessionBelow (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1InterSession (	const FCFindForkData* pForkData,
										FCHiProject* pProject,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);

public:
	BOOL				m_bNeedToSetText;		// _xZkqqHx_iPiJiKpKiJlLiOjOiCmJ_xHqqkZx_ID->_xZkqqHx_iDgFiDeMiDfIiDgHiDgFiBfLiDhFiDiLiCpAjAnNjCoIiClHiCoJjFeLjHhGiCkKiCkAiCoJiCkJiBeI_xHqqkZx_
	BOOL				m_bTargetInside;		// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFjEjFgJiCmJiMmAiCmBiCmEiDgFiDeMiDfIiDgHiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL				m_bSearchBeginOfHit;	// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiCkKjEkNjAlGiClFiClNiOjOiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	BOOL				m_bSearchEndOfHit;		// _xZkqqHx_iDeMiBfLiDiPiBfLiDgIiCkKiPmBjGmFiClFiClNiOjOiCpAiMjPiNpFiClHiCoJiCkJiBeI_xHqqkZx_
	DWORDSet			m_stTargetObjectId;		// _xZkqqHx_iMjPiNpFjBmOiPnLiCmMjFjEjFgJiCmMiPfHiNiHiBeCiDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiBfLiCmMiPoKiNiHiCoAiCkAiCoJiBeCiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClHiCoJiCoAiCmMiCpAiMjPiNpFiBeC_xHqqkZx_
	map<DWORD, WString>	m_mpObjectIdToText;		// ID->_xZkqqHx_iDgFiDeMiDfIiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	DWORDSet			m_stHitTextId;			// _xZkqqHx_iMlLiNnNiDgFiDeMiDfIiDgHiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJjFjEjFgJiBeC_xHqqkZx_
	FCSearchParser*		m_pTextSP;				// _xZkqqHx_iMjPiNpFiClHiCoJiDeMiBfLiDiPiBfLiDgIjFlGiOjKjHpBiBeC_xHqqkZx_
}; // class FCFindTextInfo.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCFindCharInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjFmPiNfIiMjPiNpFiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCFindCharInfo : public FCFindBaseInfo
{
protected:
typedef FCFindBaseInfo BASE_CLASS;

public:
	virtual ~FCFindCharInfo ();
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const;
	virtual BOOL IsThereTarget () const;
	virtual BOOL IsNeedCommandFile () const;

	virtual void Search1SessionAbove (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1SessionBelow (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1InterSession (	const FCFindForkData* pForkData,
										FCHiProject* pProject,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);

public:
	map<DWORD, longRangeVector>	m_mpObjectIdToCharSelect;		// ID->_xZkqqHx_jFlGiOjKjBeJjBpAiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	BOOL						m_bIsFlatChar;					// _xZkqqHx_jFlGiOjKjBkOjAkLiCmMjFmPiNfIiCpAjFmPiNfIiCmJiKnMiCnMiClJiCoJiCkJiBeI_xHqqkZx_
}; // class FCFindCharInfo.

//----- 06.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMiCfAiDiMiDfCiBfLiDgIiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
typedef FC3Fold<FDSECTIME, long, flint> FCTimeIndexRec;
//----- 06.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCTimeIndexFile
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmMjDmHiCnNiPgPiClFiBeFiPjBiCkLiNjOiCnNiCpAiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *			_xZkqqHx_jFnCiPfHiOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCmNiBeBiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiDfKiDgCiDfGiDiHiDjDiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeBjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeBiDfKiDgCiDfGiDiHiDjDiImKjChF_xHqqkZx_ _xZkqqHx_iCpAiOoGiCoIiPgPiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAiCfAiDiMiDfCiBfLiDgIiCmGiClFiCmEiDeDiDjDiDgGiDgCiDeOiDfIiJlLiClFiClNiCoAiCmMiBeC_xHqqkZx_
 *
 *			[FDSECTIME][long][flint]_xZkqqHx_iBeFiBeFiBeF_xHqqkZx_[FDSECTIME][long][flint]
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCTimeIndexFile
{
public:
	FCTimeIndexFile ();
	FCTimeIndexFile (const FCTimeIndexFile& timeIndexFile);
	~FCTimeIndexFile ();
	BOOL	Open (const wchar_t* wcpFilePath, BOOL bIsSave);
	void	Close ();
	void	UpdateData ();
	FDSECTIME	GetFirstSessionTime () const;
	FDSECTIME	GetLastSessionTime () const;
	BOOL	IsFileOpened () const;
	WString	GetFilePath () const;
// 06.04.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BOOL	See (FDSECTIME& fdstSessionTime, long& lDocumentId, flint& fliSessionIndex);
	BOOL	See (FDSECTIME* fdstSessionTime, long* lDocumentId, flint* fliSessionIndex);
	BOOL	See (FCTimeIndexRec& timeIndexRec, flint fliIndex);
	FDSECTIME	SeeSessionTime (flint fliIndex);
// 06.04.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BOOL	Read (FDSECTIME& fdstSessionTime, long& lDocumentId, flint& fliSessionIndex);
	BOOL	Read (FDSECTIME* fdstSessionTime, long* lDocumentId, flint* fliSessionIndex);
	BOOL	Read (FCTimeIndexRec& timeIndexRec);
// 06.04.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BOOL	RRead (FDSECTIME& fdstSessionTime, long& lDocumentId, flint& fliSessionIndex);
	BOOL	RRead (FDSECTIME* fdstSessionTime, long* lDocumentId, flint* fliSessionIndex);
	void	Write (const FDSECTIME& fdstSessionTime, const long& lDocumentId, const flint& fliSessionIndex);
	void	Write (const FCTimeIndexRec& timeIndexRec);
	flint	GetCount ();
	flint	GetCurrentIndex ();
	void	SetCurrentIndex (flint fliIndex);
protected:
	CFile		m_file;
	FDSECTIME	m_fdstFirstSessionTime;
	FDSECTIME	m_fdstLastSessionTime;
}; // class FCTimeIndexFile.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCMakeTimeIndexInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiDeDiDjDiDgGiDgCiDeOiDfIiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.04.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCMakeTimeIndexInfo : public FCFindBaseInfo
{
protected:
typedef FCFindBaseInfo BASE_CLASS;

public:
	FCMakeTimeIndexInfo ();
	virtual ~FCMakeTimeIndexInfo ();
	virtual void operator = (const FCFindBaseInfo& info);
	virtual FCFindBaseInfo* Duplicate () const;
	virtual BOOL IsThereTarget () const;
	virtual BOOL IsNeedCommandFile () const;

	virtual void Search1SessionAbove (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);
	virtual void Search1SessionBelow (	FCHiCommandTable* pCmdGate,
										FCHiSummaryTable* pHistoryIndex,
										flint fliSessionIndex);

protected:
	virtual void AppendFindRec (FTHFRecType recType,
								flint fliSessionIndex,
								FDSECTIME fdstSessionTime,
								GUID guidSessionUser,
								const wchar_t* wcpComment,
								long lId);

public:
	WString			m_wstrWorkDirPath;		// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiNoMjAkMjHhAiDiPiBfLiDeOiDgGiDeCiDiMiDeOiDgHiDiKiBeC_xHqqkZx_
	BOOL			m_bThereIsTarget;		// _xZkqqHx_iDfOiBfLiDfBiDgCiDgHiCkKiOgDiCmBiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	BOOL			m_bIsTopOfTop;			// _xZkqqHx_iNmFiPoDiImKjFlGiPjBiCmMiNmFiPiJiCmMiDfKiDgCiDfGiDiHiDjDiCkJiBeI_xHqqkZx_
	FCTimeIndexFile	m_file;					// _xZkqqHx_iPjBiCkLiNjOiCnNjHhAiDeDiDjDiDgGiDgCiDeOiDfIiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
	FDSECTIME		m_fdstPrevTime;			// _xZkqqHx_jBePiJpBjDmHiCnNiPgPiClFiClNiDfKiDgCiDfGiDiHiDjDiOjOiKnEiBeC_xHqqkZx_
}; // class FCMakeTimeIndexInfo.

#endif//__HistoryFindInfo_h
