// ListCtrlHidocument.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include <algorithm>			// For find template.
#include "resource.h"			// For IDI_XX.
#include "UtilWin.h"			// For FFInsertColumn.
#include "UtilStr.h"			// For FFLoadWString.
#include "UtilMisc.h"			// For FdtimeToFiletime.
#include "ProjectCopy.h"		// For FCProjectCopy.
#include "DocumentRecCopy.h"	// For FCDocumentRecCopy.
#include "DynamicDb.h"			// For FCDynamicDb.
#include "ListCtrlHidocument.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCListCtrlHidocument

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::CFCListCtrlHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCListCtrlHidocument::CFCListCtrlHidocument ()
{
	// _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	// _xZkqqHx_jBmOiPnLiCmMiDhGiDiNiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
	m_pProject = NULL;
	// _xZkqqHx_iDfMiBfLiDgHiCmJiOgHiCmBiCmEiCkCiCoJiDeKiDiJiDiAiBeC_xHqqkZx_
	m_lSortColumn = 1;
	// _xZkqqHx_iLhEjFpLiMpMiCnGiCmMiDfMiBfLiDgHiCkJiBeI_xHqqkZx_
	m_lSortReverse = 0;
	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_lSelDocumentId = -1;
} // CFCListCtrlHidocument::CFCListCtrlHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::~CFCListCtrlHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCListCtrlHidocument::~CFCListCtrlHidocument ()
{
} // CFCListCtrlHidocument::~CFCListCtrlHidocument.

BEGIN_MESSAGE_MAP(CFCListCtrlHidocument, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCListCtrlHidocument)
	ON_NOTIFY_REFLECT(NM_CLICK, OnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDblclk)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnclick)
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnItemchanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCListCtrlHidocument _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::Initialize ()
{
	// _xZkqqHx_jBfDiDeKiDiJiDiAjBeJjBpAiCmMiKgHjCkDiDfIiDfOiDeDiDiLiCpAjAnNjCoIiBeC_xHqqkZx_
	SetExtendedStyle(GetExtendedStyle()|LVS_EX_FULLROWSELECT);

	// _xZkqqHx_iDhHiDgCiDfPiDeDiDiBiBfLiDfHiDiKiDfIiDgHiBeC_xHqqkZx_
	m_imageHeadList.Create(10, 10, ILC_MASK, 2, 2);
	m_imageHeadList.Add(AfxGetApp()->LoadIcon(IDI_SORT_MARK));		// Image 0.
	m_imageHeadList.Add(AfxGetApp()->LoadIcon(IDI_SORT_REV_MARK));	// Image 1.
	// _xZkqqHx_iDhHiDgCiDfPjHhAiDeDiDiBiBfLiDfHiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	CHeaderCtrl* pHdrCtrl= GetHeaderCtrl();
	pHdrCtrl->SetImageList(&m_imageHeadList);

	//----- _xZkqqHx_iDeKiDiJiDiAiCmMjAnNjCoI_xHqqkZx_ -----
	CRect rect;
	GetClientRect(rect);
	// IDS_DOCUMENT_ID = "_xZkqqHx_jFlGiPjB_xHqqkZx_ID"
	// IDS_DOCUMENT_NAME = "_xZkqqHx_jFlGiPjBjGlM_xHqqkZx_"
	// IDS_VERSION = "_xZkqqHx_iDgPiBfLiDfHiDiHiDjD_xHqqkZx_"
	// IDS_LAST_UPDATE_TIME = "_xZkqqHx_iNfIjAfGjDpKiOjO_xHqqkZx_"
	long lRectWidth = rect.Width() - 24;
	long lWidth0 = lRectWidth * 1 / 18;
	long lWidth1 = (lRectWidth - lWidth0) / 2;
	long lWidth2 = (lRectWidth - lWidth0 - lWidth1) * 3 / 10;
	long lWidth3 = lRectWidth - lWidth0 - lWidth1 - lWidth2;
	FFInsertColumn(this, 0, FFLoadWString(IDS_DOCUMENT_ID), LVCFMT_LEFT, lWidth0);
	FFInsertColumn(this, 1, FFLoadWString(IDS_DOCUMENT_NAME), LVCFMT_LEFT, lWidth1);
	FFInsertColumn(this, 2, FFLoadWString(IDS_VERSION), LVCFMT_LEFT, lWidth2);
	FFInsertColumn(this, 3, FFLoadWString(IDS_LAST_UPDATE_TIME), LVCFMT_LEFT, lWidth3);
} // CFCListCtrlHidocument::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::SetHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiCmMjHjKjHpAjFlGiPjBiCpAiDiKiDfIiDgHiCmJjAnNjCoIiBeFjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pProject	:_xZkqqHx_jBmOiPnLiCmGiCmIiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stDocId		:_xZkqqHx_jBmOiPnLiCmGiCmIiCoJjHjKjHpAjFlGiPjBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::SetHidocument (const FCProjectCopy& projectCopy, const longSet& stDocId)
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_lSelDocumentId = -1;
	m_pProject = &projectCopy;
	m_stDocumentId = stDocId;
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();
} // CFCListCtrlHidocument::SetHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::SetHidocumentAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhGiDiNiDfHiDeGiDeOiDgHiCmMjBfDiCmEiCmMjHjKjHpAjFlGiPjBiCpAiDiKiDfIiDgHiCmJjAnNjCoIiBeFjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pProject	:_xZkqqHx_jBmOiPnLiCmGiCmIiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::SetHidocumentAll (const FCProjectCopy& projectCopy)
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_lSelDocumentId = -1;
	m_pProject = &projectCopy;
	m_stDocumentId.clear();
	// _xZkqqHx_iDgGiBfLiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
	long lDocId;
	const FCDocumentRecCopy* pDocRec;
	for (pDocRec = m_pProject->GetFirstHidocumentRec(lDocId);
		 lDocId != -1;
		 pDocRec = m_pProject->GetNextHidocumentRec(lDocId))
	{
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iJlMiCmMjHjKjHpAjFlGiPjBiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (pDocRec->GetIsTemporary()) continue;
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		m_stDocumentId.insert(lDocId);
	}
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();
} // CFCListCtrlHidocument::SetAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::GetSelectedHidocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCListCtrlHidocument::GetSelectedHidocumentId () const
{
	return m_lSelDocumentId;	// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
} // CFCListCtrlHidocument::GetSelectedHidocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::SetSelectedHidocumentId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiClDiCoKiCoJiCnHiCkLjFlGiPjBiCmM_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::SetSelectedHidocumentId (long lDocId)
{
//----- 04.11.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAjBmOiPnLiCmJjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (m_stDocumentId.find(lDocId) == m_stDocumentId.end()) return;
//----- 04.11.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jBeJjBpAjBmOiPnLiCmJjGlDiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iCmJiBeC_xHqqkZx_
	if (m_stDocumentId.find(lDocId) == m_stDocumentId.end())
		lDocId = -1;
	if (m_lSelDocumentId == lDocId) return;
	long lSelectedLineOld = -1;
	long lSelectedLineNew = -1;
	for (long lLine = 0; lLine < GetItemCount(); lLine++)
	{
		if (long(GetItemData(lLine)) == m_lSelDocumentId)
			lSelectedLineOld = lLine;
		else
		if (long(GetItemData(lLine)) == lDocId)
			lSelectedLineNew = lLine;
	}
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjBeJjBpAiBeFjEpBjBeJjBpAiCpAjAnNjCoIiBeC_xHqqkZx_
	if (lSelectedLineNew != -1)
	{
		SetItemState(lSelectedLineNew, LVIS_SELECTED, LVIS_SELECTED);
		RedrawItems(lSelectedLineNew, lSelectedLineNew);
	}
	if (lSelectedLineOld != -1)
	{
		SetItemState(lSelectedLineOld, 0, LVIS_SELECTED);
		RedrawItems(lSelectedLineOld, lSelectedLineOld);
	}
	m_lSelDocumentId = lDocId;
} // CFCListCtrlHidocument::SetSelectedHidocumentId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::AddHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCpAiBeBiMpDjFoCiIoKjHjHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::AddHidocument (long lDocId)
{
	longSet stDocId;
	stDocId.insert(lDocId);
	AddHidocument(stDocId);
} // CFCListCtrlHidocument::AddHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::AddHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCpAiBeBiMpDjFoCiIoKjHjHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::AddHidocument (const longSet& stDocId)
{
	BOOL bUpdate = FALSE;
	// _xZkqqHx_iMpDjFoCiIoKjHjHiCmJjCmHiJmBiBeC_xHqqkZx_
	longSet::const_iterator i;
	for (i = stDocId.begin(); i != stDocId.end(); i++)
	{
		if (m_stDocumentId.find(*i) == m_stDocumentId.end())
		//----- _xZkqqHx_iMpDjFoCjCiGiCmJiCnMiClOjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			bUpdate = TRUE;
			m_stDocumentId.insert(*i);
		}
	}
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	if (bUpdate) UpdateRegisteredList();
} // CFCListCtrlHidocument::AddHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::DelHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCpAiBeBiMpDjFoCiIoKjHjHiCkJiCoHjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::DelHidocument (long lDocId)
{
	longSet stDocId;
	stDocId.insert(lDocId);
	DelHidocument(stDocId);
} // CFCListCtrlHidocument::DelHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::DelHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjHjKjHpAjFlGiPjBiCpAiBeBiMpDjFoCiIoKjHjHiCkJiCoHjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stDocId	:_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::DelHidocument (const longSet& stDocId)
{
	if (stDocId.find(m_lSelDocumentId) != stDocId.end())
	//----- _xZkqqHx_jBeJjBpAjCiGiCmMjFlGiPjBiCkKjGjFiPmBiClDiCoKiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// m_lSelDocumentId = -1 _xZkqqHx_iCmGiClFiCmEiClFiCnMiCkEiCmGiBeBjHjKjHpAiDhCiDiFiBfLiCmMjFfMiOkGiDiCiBfLiDgIiCkK_xHqqkZx_
		// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhCiDiFiBfLiCmJjGnPiCmBiCmEiClFiCnMiCkEiCmMiCmFiBeBiOjPiCmMiMpDjFoCiCpAjBeJjBpAiClDiClJiCoJiBeC_xHqqkZx_

		// _xZkqqHx_iCfAiBeEiMlLiNnNiCmMiDiKiDfIiDgHjFfMiOkGiPiHiCmJiBeBjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMjEhKjHpBiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iCfBiBeEjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmMjEhKjHpBjCiGiCmJiCkIiCkPiCoJiBeB_xHqqkZx_m_lSelDocumentId _xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iCfCiBeEiCfBiCmMiImKjChFiCkJiCoHjHhGjBgGiCpAiMoDjFpLiCmJiMjPiNpFiClFiBeB_xHqqkZx_stDocId_xZkqqHx_iCmJiKnMiCnMiCoKiCmIiCkCjHhGjBgGiCpAjCfEiClHiBeC_xHqqkZx_
		// _xZkqqHx_iCfDiBeEiKnMiCnMiCoKiCmIiCkCjHhGjBgGiCkKiMkJiCmCiCkJiCoKiCmOiBeBiClLiCoKiCpA_xHqqkZx_ m_lSelDocumentId _xZkqqHx_iCmJjAnNjCoIiBeC_xHqqkZx_
		// _xZkqqHx_iCfEiBeEiKnMiCnMiCoKiCmIiCkCjHhGjBgGiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiBeBiCfBiBgAiCfDiCpAjBePjFpLiCmJiMjPiNpFiBeC_xHqqkZx_
		longVector vDocId;
		for (long lLine = 0; lLine < GetItemCount(); lLine++)
			vDocId.push_back(long(GetItemData(lLine)));
		long lNewSelDocumentId = -1;
		longVector::const_iterator iId = find(vDocId.begin(), vDocId.end(), m_lSelDocumentId);
		for (iId++; iId != vDocId.end(); iId++)
		{
			if (stDocId.find(*iId) == stDocId.end())
			{
				lNewSelDocumentId = *iId;
				break;
			}
		}
		if (lNewSelDocumentId == -1)
		{
			iId = find(vDocId.begin(), vDocId.end(), m_lSelDocumentId);
			while (iId != vDocId.begin())
			{
				iId--;
				if (stDocId.find(*iId) == stDocId.end())
				{
					lNewSelDocumentId = *iId;
					break;
				}
			}
		}
		m_lSelDocumentId = lNewSelDocumentId;
		if (GetParent() != NULL)
			GetParent()->PostMessage(WM_USER_LCH_DOC_SELCHANGED, (WPARAM)GetDlgCtrlID(), (LPARAM)m_lSelDocumentId);
	}

	BOOL bUpdate = FALSE;
	// _xZkqqHx_iMpDjFoCiIoKjHjHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
	longSet::const_iterator i;
	for (i = stDocId.begin(); i != stDocId.end(); i++)
	{
		if (m_stDocumentId.find(*i) != m_stDocumentId.end())
		//----- _xZkqqHx_iMpDjFoCjCiGiCmJjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			bUpdate = TRUE;
			m_stDocumentId.erase(*i);
		}
	}
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	if (bUpdate) UpdateRegisteredList();
} // CFCListCtrlHidocument::DelHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::DelHidocumentAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMpDjFoCiIoKjHjHiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::DelHidocumentAll ()
{
	if (!m_stDocumentId.empty())
	{
		// _xZkqqHx_iMpDjFoCiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
		m_stDocumentId.clear();
		if (m_lSelDocumentId != -1)
		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjFlGiPjBiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			m_lSelDocumentId = -1;
			if (GetParent() != NULL)
				GetParent()->PostMessage(WM_USER_LCH_DOC_SELCHANGED, (WPARAM)GetDlgCtrlID(), (LPARAM)m_lSelDocumentId);
		}
		// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
		UpdateRegisteredList();
	}
} // CFCListCtrlHidocument::DelHidocumentAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::GetHidocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMpDjFoCiCmMjHjKjHpAjFlGiPjBiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stDocId	:_xZkqqHx_jHjKjHpAjFlGiPjBiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::GetHidocument (longSet& stDocId) const
{
	stDocId = m_stDocumentId;
} // CFCListCtrlHidocument::GetHidocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::UpdateRegisteredList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::UpdateRegisteredList ()
{
	// _xZkqqHx_iDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	DeleteAllItems();

	//----- _xZkqqHx_iDeKiDiJiDiAiCmJiDfMiBfLiDgHiCpAiOkGiClHiDeBiDeDiDfCiDjDiCpAjAnNjCoI_xHqqkZx_ -----
	CHeaderCtrl* pHdrCtrl= GetHeaderCtrl();
	long lC;
	for (lC = 0; lC < pHdrCtrl->GetItemCount(); lC++)
	{
		HD_ITEM curItem;
		if (lC == m_lSortColumn)
		//----- _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCmMiPoKiNiH_xHqqkZx_ -----
		{
			curItem.mask= HDI_IMAGE | HDI_FORMAT;
			curItem.iImage= m_lSortReverse;
			curItem.fmt= HDF_LEFT | HDF_IMAGE | HDF_STRING | HDF_BITMAP_ON_RIGHT;
		} else
		//----- _xZkqqHx_iDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			curItem.mask= HDI_FORMAT;
			curItem.fmt= HDF_LEFT | HDF_STRING;
		}
		pHdrCtrl->SetItem(lC, &curItem);
	}
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiBeBjHjKjHpAjFlGiPjBiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_pProject == NULL || m_stDocumentId.empty()) return;

	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiCkJiCoHjHeMiMpIiCmIjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	// _xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHjCiGiCmJiCmNjFlGiPjBiCmMiNmFiPeJiNfIjAfGiOjOiKnEiCmNiLeMjIfOiClDiCoKiCmEiCkCiCmIiCkCiCmMiCmFiBeB_xHqqkZx_
	// _xZkqqHx_jFlGiPjBiCmMiDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiNfIjAfGiOjOiKnEiCpAiOoGjDlOiClFiCmEiBeBiDgOiDgCiDfGiDiFjEhKjHpBiCmJjFnLjBlGiBeC_xHqqkZx_

	// [_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID -> _xZkqqHx_iNfIjAfGiOjOiKnE_xHqqkZx_]_xZkqqHx_iDgOiDgCiDfGiDiFjEhKjHpBiBeC_xHqqkZx_
	map<long, FDTIME> mpIdToTime;
	// _xZkqqHx_iDgGiBfLiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
	longSet::const_iterator iId;
	for (iId = m_stDocumentId.begin(); iId != m_stDocumentId.end(); iId++)
	{
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_iJlMiCmMjHjKjHpAjFlGiPjBiCmMiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (m_pProject->GetDocumentRec(*iId)->GetIsTemporary()) continue;
//----- 06.01.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDhEiDeAiDeDiDiLiCmMiNfIjAfGiOjOiKnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FDTIME fdtmLastUpdate = 0;
//		g_pFileServer->GetFileTime(	NULL, NULL, &fdtmLastUpdate,
//									m_pProject->GetDocumentFileAtom(*iId, FDHI_COMMAND_TABLE_ID));
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FDTIME fdtmLastUpdate = g_pFileServer->GetLastModifiedFdtime(
							FCTableName(HString(m_pProject->GetFilePath()), *iId, FDHI_COMMAND_TABLE_ID));
//----- 06.01.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iNmFiMoDiCmJiPjBiCkLiNjOiCnNiCkKiClDiCoKiClNiOjOiKnEiCpAjAnNjCoIiBeC_xHqqkZx_
		mpIdToTime[*iId] = fdtmLastUpdate;
	}

	// [_xZkqqHx_jHjKjHpAjFlGiPjB_xHqqkZx_ID -> _xZkqqHx_iNfIjAfGiOjOiKnE_xHqqkZx_]_xZkqqHx_iDgOiDgCiDfGiDiFjEhKjHpBiCmNiBeBjHjKjHpAjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmFiDfMiBfLiDgHiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCpAiBeBiOhHjCoIiClDiCoKiClNiDfMiBfLiDgHiDeKiDiJiDiAiCmFiDfMiBfLiDgHiClFiClNiCoAiCmMiCpAiBeB_xHqqkZx_
	// _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_jEhKjHpBiBhF_xHqqkZx_vDocId_xZkqqHx_iBhGiCmJjFnLjBlGiClHiCoJiBeC_xHqqkZx_

	map<long, FDTIME>::const_iterator iIt;
	longVector vDocId;
	switch (m_lSortColumn)
	{
	case 1:	// _xZkqqHx_jFlGiPjBiDfOiDeDiDgHiDiLiBeC_xHqqkZx_
	  {
		multimap<WString, long> mpStrToId;
		multimap<WString, long>::const_iterator iSi;
		for (iIt = mpIdToTime.begin(); iIt != mpIdToTime.end(); iIt++)
			mpStrToId.insert(pair<WString, long>(m_pProject->GetDocumentRec((*iIt).first)->GetDocTitle(), (*iIt).first));
		for (iSi = mpStrToId.begin(); iSi != mpStrToId.end(); iSi++)
			vDocId.push_back((*iSi).second);
		break;
	  }
	case 2:	// _xZkqqHx_jFlGiPjBiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	  {
		multimap<WString, long> mpStrToId;
		multimap<WString, long>::const_iterator iSi;
		for (iIt = mpIdToTime.begin(); iIt != mpIdToTime.end(); iIt++)
			mpStrToId.insert(pair<WString, long>(m_pProject->GetDocumentRec((*iIt).first)->GetVersion(), (*iIt).first));
		for (iSi = mpStrToId.begin(); iSi != mpStrToId.end(); iSi++)
			vDocId.push_back((*iSi).second);
		break;
	  }
	case 3:	// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
	  {
		multimap<FDTIME, long> mpTimeToId;
		multimap<FDTIME, long>::const_iterator iSi;
		for (iIt = mpIdToTime.begin(); iIt != mpIdToTime.end(); iIt++)
			mpTimeToId.insert(pair<FDTIME, long>((*iIt).second, (*iIt).first));
		for (iSi = mpTimeToId.begin(); iSi != mpTimeToId.end(); iSi++)
			vDocId.push_back((*iSi).second);
		break;
	  }
	default:	// case 0:	// _xZkqqHx_jFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	  {
		for (iIt = mpIdToTime.begin(); iIt != mpIdToTime.end(); iIt++)
			vDocId.push_back((*iIt).first);
		break;
	  }
	}
	// _xZkqqHx_iLhEiPiHiCmMiPoKiNiHiCmNiBeBiDiKiDgPiBfLiDfIiClHiCoJiBeC_xHqqkZx_
	if (m_lSortColumn != -1 && m_lSortReverse == 1)
		reverse(vDocId.begin(), vDocId.end());

	// _xZkqqHx_iDfMiBfLiDgHiNmPiCnNiCmMjFlGiPjB_xHqqkZx_ID_xZkqqHx_jEhKjHpBiBhF_xHqqkZx_vDocId_xZkqqHx_iBhGiCmMiPiHiCmJiBeBiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJ_xHqqkZx_
	// _xZkqqHx_iDiMiDfCiBfLiDgIiNhDiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_

	long lSelLine = -1;
	for (lC = 0; lC < vDocId.size(); lC++)
	{
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCmIiCoHiCmOiBeBjBeJjBpAiNhDiCpAjAnNjCoIiBeC_xHqqkZx_
		if (vDocId[lC] == m_lSelDocumentId)
			lSelLine = lC;
		const FCDocumentRecCopy* pDocRec = m_pProject->GetDocumentRec(vDocId[lC]);
		WString wstrTime = TStrToWStr(COleDateTime(FdtimeToFiletime(mpIdToTime[vDocId[lC]])).
										Format(FFLoadString(IDS_FORM_DATE_TIME_LONG)));
		FFInsertItem(this, lC, FFFormatString(L"%d", vDocId[lC]));
		FFSetItemText(this, lC, 1, pDocRec->GetDocTitle());
		FFSetItemText(this, lC, 2, pDocRec->GetVersion());
		FFSetItemText(this, lC, 3, wstrTime);
		SetItemData(lC, DWORD(vDocId[lC]));
	}
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
	if (lSelLine != -1)
		SetItemState(lSelLine, LVIS_SELECTED, LVIS_SELECTED);
} // CFCListCtrlHidocument::UpdateRegisteredList.

/////////////////////////////////////////////////////////////////////////////
// CFCListCtrlHidocument _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::OnClick
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNiAjGnKiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::OnClick (NMHDR* pNMHDR, LRESULT* pResult)
{
	NMITEMACTIVATE* pItem = (NMITEMACTIVATE*)pNMHDR;
	// _xZkqqHx_jAfGiClFiCkCjFlGiPjB_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	long lNewSelDocumentId = -1;
	if (pItem->iItem != -1)
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		lNewSelDocumentId = long(GetItemData(pItem->iItem));
	}
	if (m_lSelDocumentId != lNewSelDocumentId)
	//----- _xZkqqHx_jAfGiClFiCkCjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiClBiCoKiCnMiCmFiCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_lSelDocumentId = lNewSelDocumentId;
		if (GetParent() != NULL)
			GetParent()->PostMessage(WM_USER_LCH_DOC_SELCHANGED, (WPARAM)GetDlgCtrlID(), (LPARAM)m_lSelDocumentId);
	}

	*pResult = 0;
} // CFCListCtrlHidocument::OnClick.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::OnDblclk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNiAjGnKiCkKiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::OnDblclk (NMHDR* pNMHDR, LRESULT* pResult)
{
	NMITEMACTIVATE* pItem = (NMITEMACTIVATE*)pNMHDR;
	if (GetParent() != NULL)
		GetParent()->PostMessage(WM_USER_LCH_ITEM_DBLCLK, (WPARAM)GetDlgCtrlID(), (LPARAM)m_lSelDocumentId);
	*pResult = 0;
} // CFCListCtrlHidocument::OnDblclk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::OnColumnclick
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiJiDiAiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::OnColumnclick (NMHDR* pNMHDR, LRESULT* pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// _xZkqqHx_iMlLiNnNiDfMiBfLiDgHjCiGiCmMiDeKiDiJiDiAiCpAiDeOiDiKiDgCiDeOiClFiClNiPoKiNiHiCmNiBeBiDfMiBfLiDgHiCpAiLhEiPiHiCmJiBeC_xHqqkZx_
	if (m_lSortColumn == pNMListView->iSubItem)
	{
		// _xZkqqHx_iDfMiBfLiDgHiCmJiOgHiCmBiCmEiCkCiCoJiDeKiDiJiDiAiBeC_xHqqkZx_
		m_lSortReverse = !m_lSortReverse;
	} else
	{
		// _xZkqqHx_iDfMiBfLiDgHiCmJiOgHiCmBiCmEiCkCiCoJiDeKiDiJiDiAiBeC_xHqqkZx_
		m_lSortColumn = pNMListView->iSubItem;
		// _xZkqqHx_iLhEjFpLiMpMiCnGiCmMiDfMiBfLiDgHiCkJiBeI_xHqqkZx_
		m_lSortReverse = 0;
	}
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFlGiPjBiCmMiIoKjHjHiCpAiNmEjFfMiOkGiClHiCoJiBeC_xHqqkZx_
	UpdateRegisteredList();

	*pResult = 0;
} // CFCListCtrlHidocument::OnColumnclick.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCListCtrlHidocument::OnItemchanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiPpDjBnEiCkKjFmPiNfIiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeMiBfLiDhLiBfLiDgIiCmJiCoGiCoJjBeJjBpAjFmPiNfIiCmFiCmN_xHqqkZx_ NM_CLICK _xZkqqHx_iCkKjBjHiCoHiCoKiCmIiCkCiClNiCnPiBeB_xHqqkZx_
 *			_xZkqqHx_iClBiClBiCmFjBeJjBpAiPpDjBnEiCpAjElLjCgGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCListCtrlHidocument::OnItemchanged (NMHDR* pNMHDR, LRESULT* pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjBeJjBpAiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
	if (0 <= pNMListView->iItem &&
		pNMListView->uChanged & LVIF_STATE &&
		pNMListView->uNewState & LVIS_SELECTED)
	{
		// _xZkqqHx_jBeJjBpAiClDiCoKiClNjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		if (m_lSelDocumentId != long(GetItemData(pNMListView->iItem)))
		//----- _xZkqqHx_jAfGiClFiCkCjFlGiPjB_xHqqkZx_ID_xZkqqHx_iCkKiClBiCoKiCnMiCmFiCmGiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
		{
			m_lSelDocumentId = long(GetItemData(pNMListView->iItem));
			if (GetParent() != NULL)
				GetParent()->PostMessage(WM_USER_LCH_DOC_SELCHANGED, (WPARAM)GetDlgCtrlID(), (LPARAM)m_lSelDocumentId);
		}
	}
	*pResult = 0;
} // CFCListCtrlHidocument::OnItemchanged.
