// MatrixControl.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#if defined(_IME_ON)
#include <imm.h>			// For IMN_SETOPENSTATUS.
#endif // defined(_IME_ON)
#include "DynamicDraw.h"
#include "RegData.h"		// For InitRegFont.
// 06.11.03 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilErr.h"		// For FFThrowMiscUnknown.
#include "UtilMisc.h"		// For FFWheelDeltaToScrollCount.
#include "UtilWin.h"		// For CloseImeStatus.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "MatrixControl.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FDMC_MIN_ITEM_W		48	// ITEM_xZkqqHx_iCmMjFjNiCmMiNmFjCoBjCgMiBeC_xHqqkZx_
#define FDMC_MIN_ITEM_H		62	// FDMC_MIN_ITEM_H + FDMC_SPACE_Y_xZkqqHx_iCmN_xHqqkZx_16_xZkqqHx_iCmMjEhLjAjEiBeC_xHqqkZx_

// _xZkqqHx_jDgPjIfOjGlMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
LPCTSTR CFCMatrixControl::m_lpszClassName = NULL;

/////////////////////////////////////////////////////////////////////////////
// CFCMatrixControl

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::CFCMatrixControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMatrixControl::CFCMatrixControl ()
{
	//----- _xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEjFmPjAjE_xHqqkZx_ -----
	m_lIndexA = -1;				// Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_lIndexB = -1;				// Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_lColumnCount = 0;			// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
// 06.11.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_lItemLine = 0;			// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNhDjAjEiBeC_xHqqkZx_
	m_lItemW = 0;				// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiJkBiDfEiDeDiDfJiBeC_xHqqkZx_
	m_lItemH = 0;				// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiPgDiDfEiDeDiDfJiBeC_xHqqkZx_
	m_wndpMsgWnd = NULL;		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiOpDiCkPiOoGiCoIjAoGiCmM_xHqqkZx_CWnd.
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_bIs1StOnSize = TRUE;		// _xZkqqHx_iNmFiPiJiCmMiDiKiDfEiDeDiDfJiCkJiBeI_xHqqkZx_
	// _xZkqqHx_iDfOiDeDiDhNiBfL_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_0_xZkqqHx_iCmIiCoHiDfOiDeDiDhNiBfLjCoCiOhOjCiGiBeC_xHqqkZx_
	m_dwTimer = 0;
// 06.11.05 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	m_lTextHeight = 0;			// _xZkqqHx_iDgFiDeMiDfIiDgHiNiCiBeC_xHqqkZx_
} // CFCMatrixControl::CFCMatrixControl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::~CFCMatrixControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMatrixControl::~CFCMatrixControl ()
{
} // CFCMatrixControl::~CFCMatrixControl.

BEGIN_MESSAGE_MAP(CFCMatrixControl, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCMatrixControl)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_CONTEXTMENU()
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	ON_WM_KEYDOWN()
	ON_WM_GETDLGCODE()
	ON_WM_MOUSEWHEEL()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_INITMENUPOPUP()
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(ID_RBTN_ITEM_BEGIN_MARK, ID_RBTN_ITEM_END_MARK, OnRbtnItemAny)
	ON_MESSAGE(WM_IME_NOTIFY, OnImeNotify)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCMatrixControl _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmJiMiLiCnBjFhEiCkPiCoHiCoKiClNiOhBiDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwExStyle	:_xZkqqHx_iKgHjCkDiDeFiDeCiDjDiDgIiDeFiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwStyle		:Window_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMyStyle	:_xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFjDmGiOkJiCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rt		:_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pParentWnd	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			nID			:_xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ ID _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pContext	:_xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wndpMsgWnd	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHiCoIiCmCiCkPiCoJiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_NULL_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_
 *						 Parent_xZkqqHx_iCnGjBjHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jAlDiPoNiPeJjHlJ_xHqqkZx_
 *			FALSE	:_xZkqqHx_iInJiPoNiPeJjHlJ_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::Create (	DWORD dwExStyle,
								DWORD dwStyle,
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
								DWORD dwMyStyle,
								const RECT& rt,
								CWnd* pParentWnd,
								UINT nID,
								CCreateContext* pContext,
								CWnd* wndpMsgWnd)
{
	m_wndpMsgWnd = wndpMsgWnd;
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_bIs1StOnSize = TRUE;

	//----- _xZkqqHx_iDeOiDiJiDfIiCpAjDgPjIfO_xHqqkZx_._xZkqqHx_iBgJ_xHqqkZx_MoveInn_xZkqqHx_iOjOiCmM_xHqqkZx_)_xZkqqHx_iDeKiBfLiDfMiDiLiCmNjFhDjHhG_xHqqkZx_ -----
	if (m_lpszClassName == NULL)
	{
    	m_lpszClassName = ::AfxRegisterWndClass(CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
								FFGetApp()->LoadStandardCursor(IDC_ARROW));
	}

	if (CreateEx(	dwExStyle,
					m_lpszClassName,
					_T(""),
					dwStyle,
					rt,
					pParentWnd,
					nID))
	{
//----- 06.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		long lScroll;
//		if (GetIndexA() < 0)
//			lScroll = 0;
//		else
//			lScroll = 2 * (GetIndexA() / m_lColumnCount);
//
//		SCROLLINFO	oSCInfo;
//		GetScrollInfo(SB_VERT, &oSCInfo);
//		const long lScrMax	= oSCInfo.nMax;
//		const long lScrPage= oSCInfo.nPage;
//
//		if (lScrMax - lScrPage + 1 < lScroll)
//		{
//			lScroll = lScrMax - lScrPage + 1;
//		}
//		SetScrollPos(SB_VERT, lScroll);
//----- 06.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iMmFjHeMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
		m_dwMyStyle = dwMyStyle;
		// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiBeBiDfPiDhOiBfLiDePiDiLiBfLiDhGiCpAjCmHiJmBiBeC_xHqqkZx_
		if (!GetIsGroupStyle())
			m_vGroup.push_back(FCMCGroupData(0, DWORD(-1)));

		//----- _xZkqqHx_iDgFiDeMiDfIiDgHiNiCiCpAiMhGiOfK_xHqqkZx_ -----
		// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
		CClientDC dc(this);
		// _xZkqqHx_jFfMiOkGjHhAiDhEiDeIiDjDiDgHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
		CFont font;
		g_pReg->InitRegFont(font, FDFT_MATRIX_TITLE);
		dc.SelectObject(&font);
		//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiNiCiClDiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
		TEXTMETRIC tmMetrics;
		dc.GetTextMetrics(&tmMetrics);
		m_lTextHeight = tmMetrics.tmAscent + tmMetrics.tmDescent;

//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// CalcItemMatrix_xZkqqHx_iCmMjBePiCmJiDfIiDeOiDiNiBfLiDiLiImKjChFiCpAiOhHjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
		SetScrollPos(SB_VERT, 0);
		// _xZkqqHx_iJlMiDfIiDeOiDiNiBfLiDiLiDfEiDeDiDfJiCpAjAnNjCoIiBeCiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAjFfMiOkGiClDiClJiBeB_xHqqkZx_
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCpAiMiIjCoIiClHiCoJiClNiCnPiBeC_xHqqkZx_
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		CalcItemMatrix();
		UpdateScrollSize(FALSE);

		// _xZkqqHx_iDeBiDeDiDgFiDiAiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
		UpdateItemSize();

		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDfEiDeDiDfJiCpAjGhLiMhGiOfKiBeC_xHqqkZx_
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		CalcItemMatrix();
		UpdateScrollSize(FALSE);
//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		return TRUE;
	}
	return FALSE;
} // CFCMatrixControl::Create.

//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 06.11.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
/////*************************************************************************
//// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::ClearContents
//// *
//// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
//// *
//// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//// *************************************************************************/
////void CFCMatrixControl::ClearContents ()
////{
////// 06.11.01 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
////	m_vGroup.clear();		// _xZkqqHx_iDePiDiLiBfLiDhGiBeC_xHqqkZx_
////
////	m_vItem.clear();		// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDgGiBfLiDfOiCmGiPpDjBnEiBeC_xHqqkZx_
////	m_lIndexA = -1;			// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	m_lIndexB = -1;			// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
////	m_lColumnCount = 0;		// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
////// 06.11.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//////	m_lItemLine = 0;		// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNhDjAjEiBeC_xHqqkZx_
////	m_lItemW = 0;			// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiJkBiDfEiDeDiDfJiBeC_xHqqkZx_
////	m_lItemH = 0;			// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiPgDiDfEiDeDiDfJiBeC_xHqqkZx_
////	// _xZkqqHx_iDfOiDeDiDhNiBfLiJnCjDkOjCiGiCmIiCoHiCmOjCoCiOhOiBeC_xHqqkZx_
////	if (m_dwTimer != 0) (void)KillTimer(m_dwTimer);
////	m_dwTimer = 0;			// _xZkqqHx_iDfOiDeDiDhNiBfL_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_0_xZkqqHx_iCmIiCoHiDfOiDeDiDhNiBfLjCoCiOhOjCiGiBeC_xHqqkZx_
////} // CFCMatrixControl::ClearContents.
////----- 06.11.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::ClearContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::ClearContents ()
{
// 06.11.01 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	m_vGroup.clear();		// _xZkqqHx_iDePiDiLiBfLiDhGiBeC_xHqqkZx_

	m_vItem.clear();		// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDgGiBfLiDfOiCmGiPpDjBnEiBeC_xHqqkZx_
	m_lIndexA = -1;			// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_lIndexB = -1;			// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_lColumnCount = 0;		// _xZkqqHx_jAiFjFlNjFpLiMpMiCmMiDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
// 06.11.01 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_lItemLine = 0;		// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNhDjAjEiBeC_xHqqkZx_
	m_lItemW = 0;			// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiJkBiDfEiDeDiDfJiBeC_xHqqkZx_
	m_lItemH = 0;			// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiPgDiDfEiDeDiDfJiBeC_xHqqkZx_
	// _xZkqqHx_iDfOiDeDiDhNiBfLiJnCjDkOjCiGiCmIiCoHiCmOjCoCiOhOiBeC_xHqqkZx_
	if (m_dwTimer != 0) (void)KillTimer(m_dwTimer);
	m_dwTimer = 0;			// _xZkqqHx_iDfOiDeDiDhNiBfL_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_0_xZkqqHx_iCmIiCoHiDfOiDeDiDhNiBfLjCoCiOhOjCiGiBeC_xHqqkZx_
} // CFCMatrixControl::ClearContents.
//----- 07.01.20 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetIsSingleSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCmMjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::GetIsSingleSelect () const
{
	return FALSE;
} // CFCMatrixControl::GetIsSingleSelect.
//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.11.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetIsGroupStyle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDhNiDgHiDiKiDgCiDeOiDfIiCkKiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiKgFiDeBiDeDiDgFiDiAiCmNiDePiDiLiBfLiDhG_xHqqkZx_
 *			_xZkqqHx_jCfAiImKiCmFiCnMiCmGiCnPiCmEjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::GetIsGroupStyle () const
{
	return ((m_dwMyStyle & FDGMC_STYLE_GROUP) == FDGMC_STYLE_GROUP);
} // CFCMatrixControl::GetIsGroupStyle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetColumnCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDgHiDiKiDgCiDeOiDfIiCmMiDeKiDiJiDiAjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgHiDiKiDgCiDeOiDfIiCmMiDeKiDiJiDiAjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetColumnCount () const
{
	return m_lColumnCount;
} // CFCMatrixControl::GetColumnCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::AddGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwGroupData	:_xZkqqHx_iDePiDiLiBfLiDhGiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmFiCmNjHjIjHhAjFhDiJmCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiBeBiDePiDiLiBfLiDhGiCmGiClFiCmEiNmFiMoDiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::AddGroup (DWORD dwGroupData)
{
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (!GetIsGroupStyle())
		FFThrowMiscUnknown();
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmJjBmOiJjOiClHiCoJiDiGiDgKiBfLiDeO_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	const DWORD dwUniqID = GetGroupUniqID(dwGroupData);
	// _xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMjDfHiKeKiPoOjFpBiCpAiOoGjDlOiBeC_xHqqkZx_
	map<DWORD, FCUniqIDAndExpanded>::iterator i;
	i = m_mpGroupDataToExpandedRec.find(dwGroupData);
	if (i != m_mpGroupDataToExpandedRec.end())
	//----- _xZkqqHx_jDfHiKeKiPoOjFpBiCkKjDgPjIfOiNmPiCnNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiGiDgKiBfLiDeO_xHqqkZx_ID_xZkqqHx_iCkKiInJiCmIiCoJiPoKiNiHiCmNiBeB_xHqqkZx_
		// _xZkqqHx_iImIjBePjDgPjIfOiClDiCoKiCmEiCkCiClNiDePiDiLiBfLiDhGiCmGiBgJjDkPiClGiDgGiBfLiDfOiClOiCkKiBgKiIoBiCkEiBeC_xHqqkZx_
		// _xZkqqHx_iClLiCmMiPoKiNiHiBeBjDfHiKeKiPoOjFpBiCmNiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		if (i->second.m_dwUniqID != dwUniqID)
			m_mpGroupDataToExpandedRec.erase(i);
	}
	// _xZkqqHx_iDePiDiLiBfLiDhGiDgGiBfLiDfOjEhKjHpBiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
	long lGroupIndex = (long)m_vGroup.size();
	m_vGroup.push_back(FCMCGroupData(0, dwGroupData));
	return lGroupIndex;
} // CFCMatrixControl::AddGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::AddItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmJiBeBiDeBiDeDiDgFiDiAiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjCmHiJmBiClHiCoJiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwData		:_xZkqqHx_jCmHiJmBiClHiCoJiDeBiDeDiDgFiDiAiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::AddItem (long lGroupIndex, DWORD dwData)
{
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_0_xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (!GetIsGroupStyle() && lGroupIndex != 0)
		FFThrowMiscUnknown();
	// lGroupIndex_xZkqqHx_iCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_[First, Last)_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	long lIndexBegin;
	long lIndexEnd;
	GetGroupItemIndex(lIndexBegin, lIndexEnd, lGroupIndex);
	// lGroupIndex_xZkqqHx_iCmMiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmGiClFiCmEjCmHiJmBiBeC_xHqqkZx_
	InsertItem(lGroupIndex, lIndexEnd, dwData);
	return lIndexEnd;
} // CFCMatrixControl::AddItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::InsertItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmJiDeBiDeDiDgFiDiAiCpAjBhNjDpMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjBhNjDpMiClHiCoJiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndex		:_xZkqqHx_jBhNjDpMiClHiCoJiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwData		:_xZkqqHx_jBhNjDpMiClHiCoJiDeBiDeDiDgFiDiAiCmMiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	lIndex_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiImKjChFiCmNiBeB_xHqqkZx_lGroupIndex_xZkqqHx_iCmJjBkOiClFiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::InsertItem (long lGroupIndex, long lIndex, DWORD dwData)
{
	ASSERT(lIndex <= m_vItem.size());
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_0_xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (!GetIsGroupStyle() && lGroupIndex != 0)
		FFThrowMiscUnknown();

	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeBiDeDiDgFiDiAiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
	m_vGroup[lGroupIndex].lItemCount++;
	// _xZkqqHx_iDeBiDeDiDgFiDiAjEhKjHpBiCmJjBhNjDpMiBeC_xHqqkZx_
	m_vItem.insert(m_vItem.begin() + lIndex, FCMCItemData(0, dwData));
	if (lIndex <= m_lIndexA)
	//----- _xZkqqHx_jBeJjBpAiImKjChFiCkKjBhNjDpMiImKjChFiCoGiCoIiMoDiCoLiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiImKjChFiCoAiJmBiOfKiBeC_xHqqkZx_
		m_lIndexA++;
		// _xZkqqHx_jBeJjBpAiImKjChFjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		PostSelChangeMessage();
	}
	// _xZkqqHx_jBeJjBpAjEmNiImNiCmM_xHqqkZx_B_xZkqqHx_iCkKjBhNjDpMiImKjChFiCoGiCoIiMoDiCoLiCmMiPoKiNiHiCmNiJmBiOfKiBeC_xHqqkZx_
	if (lIndex <= m_lIndexB) m_lIndexB++;
} // CFCMatrixControl::InsertItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::DeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjBhNjDpMiClHiCoJiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndex		:_xZkqqHx_jBhNjDpMiClHiCoJiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	lIndex_xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiImKjChFiCmNiBeB_xHqqkZx_lGroupIndex_xZkqqHx_iCmJjBkOiClFiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::DeleteItem (long lGroupIndex, long lIndex)
{
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_0_xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (!GetIsGroupStyle() && lGroupIndex != 0)
		FFThrowMiscUnknown();

	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeBiDeDiDgFiDiAiDeKiDeFiDjDiDfOiCpAiMlIiOfKiBeC_xHqqkZx_
	m_vGroup[lGroupIndex].lItemCount--;
	// _xZkqqHx_iDeBiDeDiDgFiDiAjEhKjHpBiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
	m_vItem.erase(m_vItem.begin() + lIndex);
	if (lIndex <= m_lIndexA)
	//----- _xZkqqHx_jBeJjBpAiImKjChFiCkKjBhNjDpMiImKjChFiCoGiCoIiMoDiCoLiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiImKjChFiCoAiMlIiOfKiBeC_xHqqkZx_
		m_lIndexA--;
		// _xZkqqHx_jBeJjBpAiImKjChFjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
		PostSelChangeMessage();
	}
	// _xZkqqHx_jBeJjBpAjEmNiImNiCmM_xHqqkZx_B_xZkqqHx_iCkKjBhNjDpMiImKjChFiCoGiCoIiMoDiCoLiCmMiPoKiNiHiCmNiMlIiOfKiBeC_xHqqkZx_
	if (lIndex <= m_lIndexB) m_lIndexB--;
} // CFCMatrixControl::DeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupItemIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_[First, Last)_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpA_xHqqkZx_
 *			_xZkqqHx_iOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndexBegin	:_xZkqqHx_iKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			lIndexEnd	:_xZkqqHx_iPeJjCfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::GetGroupItemIndex (	long& lIndexBegin,
											long& lIndexEnd,
											long lGroupIndex) const
{
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_0_xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (!GetIsGroupStyle() && lGroupIndex != 0)
		FFThrowMiscUnknown();
	// _xZkqqHx_iNmFiPiJiCmMiDePiDiLiBfLiDhGiCkJiCoH_xHqqkZx_lGroupIndex_xZkqqHx_iCnMiCmFiDiLiBfLiDhGiClFiCmEiJmBiOfKiClHiCoJiBeC_xHqqkZx_
	lIndexBegin = 0;
	long lC;
	for (lC = 0; lC != lGroupIndex; lC++)
		lIndexBegin += GetGroupItemCount(lC);
	lIndexEnd = lIndexBegin + GetGroupItemCount(lGroupIndex);
} // CFCMatrixControl::GetGroupItemIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGlobalItemRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiMlEjDfPiCkJiCoHiCmMiNmAjFfHiCmFiCmMiLoJiMgAiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFfMiOkGiPoDiCmMiNmAjFfHiCmFiCmNiCmIiCkNiBeBiMlEjDfPiCkJiCoHiCmMiNmAjFfHiCmFiCmMiLoJiMgAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiBeBiDePiDiLiBfLiDhGiCkKiPpEiCnMiCoKiCmEiCkCiCoJiPoKiNiHiCoAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iOmAiNnLiCmMiMlEjDfP_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iBkL_xHqqkZx_ _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkCiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiMlEjDfPiCkJiCoHiCmMiNmAjFfH_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_ _xZkqqHx_iEkAiEkAiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iBkB_xHqqkZx_ _xZkqqHx_iEjPiEkI_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iBkB_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iBkB_xHqqkZx_
 *          _xZkqqHx_iEkAjFfMiOkGjHmMiIoGiEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkIiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCMatrixControl::GetGlobalItemRect (long lIndex) const
{
	if (lIndex < 0 || GetItemCount() <= lIndex)
		return CRect(0, 0, 0, 0);
	long lY;		// _xZkqqHx_iKoOjDfPiNmAjFfHiCmM_xHqqkZx_Y_xZkqqHx_jCgMiBeC_xHqqkZx_
	long lLine;		// _xZkqqHx_iKoOjDfPiNmAjFfHiCkJiCoHiDeBiDeDiDgFiDiAiCnMiCmFiCmMiNhDjAjEiBeC_xHqqkZx_
	long lColumn;	// _xZkqqHx_iKoOjDfPiNmAjFfHiCkJiCoHiDeBiDeDiDgFiDiAiCnMiCmFiCmMjHpBjAjEiBeC_xHqqkZx_
	if (GetIsGroupStyle())
	//----- _xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjBkOiClHiCoJiDePiDiLiBfLiDhGiCpAiOoGjDlOiBeC_xHqqkZx_
		const long lGroupIndex = ItemIndexToGroupIndex(lIndex);
		// lGroupIndex_xZkqqHx_iCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_[First, Last)_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
		long lIndexBegin;
		long lIndexEnd;
		GetGroupItemIndex(lIndexBegin, lIndexEnd, lGroupIndex);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiLoJiMgAiCmJiDhHiDgCiDfPiCpAiJmBiOfKiClFiCmEiKoOjDfPiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
		lY = GetGlobalGroupRect(lGroupIndex).top + GetTotalGroupHeaderHeight();
		// _xZkqqHx_iNhDjAjEiCmGjHpBjAjEiCpAiOfKiPgPiBeC_xHqqkZx_
		lLine = (lIndex - lIndexBegin) / GetColumnCount();
		lColumn = (lIndex - lIndexBegin) % GetColumnCount();
	} else
	//----- _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		lY = 0;
		// _xZkqqHx_jBgGjClMiCmJiNhDjAjEiCmGjHpBjAjEiCpAiOfKiPgPiBeC_xHqqkZx_
		lLine = lIndex / GetColumnCount();
		lColumn = lIndex % GetColumnCount();
	}
	// _xZkqqHx_iKoOjDfPiNmAjFfHiCmGiNhDjAjEiBeFjHpBjAjEiCkJiCoHiDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
	CRect rtItem;
	rtItem.top = lY + (lLine * GetTotalItemHeight());
	rtItem.bottom = rtItem.top + GetTotalItemHeight();
	rtItem.left = lColumn * GetTotalItemWidth();
	rtItem.right = rtItem.left + GetTotalItemWidth();
	return rtItem;
} // CFCMatrixControl::GetGlobalItemRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupItemLines
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJiDeBiDeDiDgFiDiAiCmMiBeBiNhDjAjEiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNhDjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiPpEiCnNiNjOiCnNiCpAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetGroupItemLines (long lGroupIndex) const
{
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_0_xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (!GetIsGroupStyle() && lGroupIndex != 0)
		FFThrowMiscUnknown();

	// _xZkqqHx_iDePiDiLiBfLiDhGjDfHiKeKjCiGiCmMiPoKiNiHiCpAiNgMjHlGiClFiCmEiMhGiOfKiBeC_xHqqkZx_
	// _xZkqqHx_iNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMiNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOfKiPgPiClFiBeBiBhLiCfAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (GetIsGroupExpanded(lGroupIndex))
//		return ((GetGroupItemCount(lGroupIndex) - 1) / GetColumnCount()) + 1;
//	else
//		return 0;
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetIsGroupExpanded(lGroupIndex))
	//----- _xZkqqHx_jDfHiKeKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		long lLine = GetGroupItemCount(lGroupIndex) / GetColumnCount();
		long lColumn = GetGroupItemCount(lGroupIndex) % GetColumnCount();
		if (lColumn != 0)
			lLine++;
		return lLine;
	} else
	//----- _xZkqqHx_jEpBjDfHiKeKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return 0;
	}
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::GetGroupItemLines.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::ItemIndexToGroupIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCkKjBkOiClHiCoJiDePiDiLiBfLiDhGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::ItemIndexToGroupIndex (long lIndex) const
{
	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeBiDeDiDgFiDiAjAjEiCpAiNmFiPiJiCkJiCoHiJmBiOfKiClFiCmEjClCiCnHiCoJiBeC_xHqqkZx_
	long lC;
	for (lC = 0; lC != GetGroupCount(); lC++)
	{
		if (lIndex < GetGroupItemCount(lC)) return lC;
		lIndex -= GetGroupItemCount(lC);
	}
	FFThrowMiscUnknown();
	return -1;
} // CFCMatrixControl::ItemIndexToGroupIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGlobalGroupRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFfMiOkGiPoDiCmMiNmAjFfHiCmFiCmNiCmIiCkNiBeBiMlEjDfPiCkJiCoHiCmMiNmAjFfHiCmFiCmMiLoJiMgAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iOmAiNnLiCmMiMlEjDfP_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iBkL_xHqqkZx_ _xZkqqHx_iEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkCiEjPiEkG_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkAiMlEjDfPiCkJiCoHiCmMiNmAjFfH_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEkH_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iEjPiEjPiEjPiEkC_xHqqkZx_ _xZkqqHx_iEkAiEkAiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkB_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iBkB_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
 *           _xZkqqHx_iEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBkB_xHqqkZx_ _xZkqqHx_iEjPiEkI_xHqqkZx_
 *          _xZkqqHx_iEkAjFfMiOkGjHmMiIoGiEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkIiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCMatrixControl::GetGlobalGroupRect (long lGroupIndex) const
{
	struct my
	{
		my (long lGroupIndex) : m_lGroupIndex(lGroupIndex), m_rtGroup(0,0,0,0) {}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumGroupConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			bIsExpanded			:_xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexBegin		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
		 *								 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexEnd		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineBegin	:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiNhDiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineEnd		:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiNhDiBhLiCfAiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtGroup				:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										BOOL bIsExpanded,
										long lItemIndexBegin,
										long lItemIndexEnd,
										long lVisibleLineBegin,
										long lVisibleLineEnd,
										const CRect& rtGroup,
										void* pData)
		{
			my* pMy = (my*)pData;
			if (pMy->m_lGroupIndex == lGroupIndex)
			//----- _xZkqqHx_jGnKjFfHiDePiDiLiBfLiDhGiCmJjCeCiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDePiDiLiBfLiDhGiLoJiMgAiCpAiLeMjIfOiBeC_xHqqkZx_
				pMy->m_rtGroup = rtGroup;
				return 1;
			} else
			{
				return 0;
			}
		}
		const long m_lGroupIndex;
		CRect m_rtGroup;
	} data(lGroupIndex);
	// _xZkqqHx_iDePiDiLiBfLiDhGiCpAjHpBiLjDiClFiCmE_xHqqkZx_EnumGroupConstProc_xZkqqHx_iCpAiDfCiBfLiDiLiBeCiDfEiDeDiDfJiMhGiOfKiBeC_xHqqkZx_
	EnumGroupConst(my::EnumGroupConstProc, 0, &data);
	// _xZkqqHx_iDePiDiLiBfLiDhGiLoJiMgAiCpAjFnEiClHiBeC_xHqqkZx_
	return data.m_rtGroup;
} // CFCMatrixControl::GetGlobalGroupRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlEjDfPiCkJiCoHiCmMiNmAjFfHiCmFiCmNiCmIiCkNiBeBjFfMiOkGiPoDiCmMiNmAjFfHiCmFiCmMiLoJiMgAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iOmAiNnLiCmMiMlEjDfP_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iBkL_xHqqkZx_ _xZkqqHx_iEkFiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_   _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkGiEkHiEjPiEkG_xHqqkZx_ _xZkqqHx_jFfMiOkGjHmMiIoGiCmFiCmMiNmAjFfH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkBiEjPiEkC_xHqqkZx_ _xZkqqHx_iEkAiEkAiEjPiEkJ_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkAiEkA_xHqqkZx_  _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_ _xZkqqHx_iEkEiEjPiEkD_xHqqkZx_  _xZkqqHx_iBkB_xHqqkZx_ _xZkqqHx_iEjPiEkI_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iBkB_xHqqkZx_ 
 *          _xZkqqHx_iEkA_xHqqkZx_         _xZkqqHx_iBkB_xHqqkZx_ 
 *          _xZkqqHx_iEkAjFfMiOkGjHmMiIoGiEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkAiEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEkIiEkH_xHqqkZx_
 *          _xZkqqHx_iEkA_xHqqkZx_          _xZkqqHx_iEkA_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CRect CFCMatrixControl::GetGroupRect (long lIndex) const
{
	// _xZkqqHx_iMlEjDfPiCkJiCoHiCmMiLoJiMgAiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtGroup = GetGlobalGroupRect(lIndex);
	if (rtGroup.IsRectNull())
		return rtGroup;
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiBgJiNmAjFfHjCgMiBgKiCmMiOoGjDlOiBeC_xHqqkZx_
	long lScrollY = GetScrollPos(SB_VERT);
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiCpAiIpIiCkNiBeC_xHqqkZx_
	rtGroup -= CSize(0, lScrollY);
	return rtGroup;
} // CFCMatrixControl::GetGroupRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GroupDataToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiDgGiBfLiDfOiCkJiCoHiDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwGroupData	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiDgGiBfLiDfOiCkKiNmFiPiJiCmJiMkJiCmCiCkJiCmBiClNiImKjChFiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *			_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GroupDataToIndex (DWORD dwGroupData) const
{
	for (long lIndex = 0; lIndex < GetGroupCount(); lIndex++)
		if (GetGroupData(lIndex) == dwGroupData) return lIndex;
	return -1;
} // CFCMatrixControl::GroupDataToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetGroupCount () const
{
	return (long)m_vGroup.size();
} // CFCMatrixControl::GetGroupCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiDePiDiLiBfLiDhGiDgGiBfLiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDgGiBfLiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCMatrixControl::GetGroupData (long lGroupIndex) const
{
	return m_vGroup[lGroupIndex].dwData;
} // CFCMatrixControl::GetGroupData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupItemCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetGroupItemCount (long lGroupIndex) const
{
	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeBiDeDiDgFiDiAiDeKiDeFiDjDiDfOiBeC_xHqqkZx_
	return m_vGroup[lGroupIndex].lItemCount;
} // CFCMatrixControl::GetGroupItemCount.

//----- 06.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//WORD CFCMatrixControl::GetGroupState (long lGroupIndex) const
//{
//	return m_vGroup[lGroupIndex].wState;
//} // CFCMatrixControl::GetGroupState.
//
//void CFCMatrixControl::SetGroupState (long lGroupIndex, WORD wState)
//{
//	m_vGroup[lGroupIndex].wState = wState;
//} // CFCMatrixControl::GetGroupState.
//----- 06.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetIsGroupExpanded
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDfHiKeKjCiGiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDfHiKeKjCiGiCkJiCmHiCkEiCkJiCmMiPoOjFpBiCmNiBeB_xHqqkZx_m_vGroup_xZkqqHx_iCmGiCmNjFmKiCmJjFnLjBlGiClHiCoJiBeC_xHqqkZx_
 *			m_vGroup_xZkqqHx_iCmNiBeBiDePiDiLiBfLiDhGiCoCiDeBiDeDiDgFiDiAiCmMjFmPiNfIiCpAjElNiJgGiClDiClJiCoJjDhIiCmJiNoNiPjMiBeFjCmHiJmB_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCoJiCmMiCmFiBeB_xHqqkZx_m_vGroup_xZkqqHx_iCmJjDfHiKeKiPoOjFpBiCpAiLeMiPhBiClHiCoJiCmGiBeBjFmPiNfIiCmMjDhIiCmJiPiJiKpKiJlL_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiCkKiNoNiPjMiBjFjCmHiJmBiCmFjFjMiKiIiClFiClNiPoKiNiHiBeBiImIjBePiCmMiDePiDiLiBfLiDhGiCmGjDkPiIoKiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiClNiCnPiCmJiBeBiDiGiDgKiBfLiDeO_xHqqkZx_ID_xZkqqHx_iCpAiLeMiJkPiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::GetIsGroupExpanded (long lGroupIndex) const
{
	map<DWORD, FCUniqIDAndExpanded>::const_iterator i;
	// _xZkqqHx_iDePiDiLiBfLiDhGiDgGiBfLiDfO_xHqqkZx_->_xZkqqHx_jDfHiKeKiPoOjFpBiCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	i = m_mpGroupDataToExpandedRec.find(GetGroupData(lGroupIndex));
	if (i == m_mpGroupDataToExpandedRec.end())
		return TRUE;
	return i->second.m_bIsExpanded;
} // CFCMatrixControl::GetIsGroupExpanded.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetIsGroupExpanded
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMjDfHiKeKiPpDjBnEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsExpanded	:_xZkqqHx_jDfHiKeKjCiGiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::SetIsGroupExpanded (long lGroupIndex, BOOL bIsExpanded)
{
	const DWORD dwGroupData = GetGroupData(lGroupIndex);
	const DWORD dwUniqID = GetGroupUniqID(dwGroupData);
	// _xZkqqHx_iDePiDiLiBfLiDhGiDgGiBfLiDfO_xHqqkZx_->_xZkqqHx_jDfHiKeKiPoOjFpBiCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	m_mpGroupDataToExpandedRec[dwGroupData] = FCUniqIDAndExpanded(dwUniqID, bIsExpanded);

	if (!bIsExpanded)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGiCpAiPpEiNjOiCnOiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlLiNnNiCmMjBeJjBpAiCkKiBeBiPpEiNjOiCnMiCoKiClNiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
		long lSelectFirst = GetIndexA();
		long lSelectLast = GetIndexB();
		if (lSelectFirst != -1)
		{
			if (lSelectLast < lSelectFirst) Exchange(lSelectLast, lSelectFirst);
			if (CalcIsBelongToReducedGroup(lSelectFirst, lSelectLast + 1))
			//----- _xZkqqHx_jBeJjBpAjEmNiImNiCmMiIoKjFjEiCkKiPpEiCnMiCoKiClNiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jBeJjBpAiCpAiJpAiPjMiBeC_xHqqkZx_
				SetIndexAB(-1, -1, FALSE, FALSE);
				// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
				SetAllSelectionMark(FALSE);
			}
		}
	}
} // CFCMatrixControl::SetIsGroupExpanded.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupUniqID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiDiGiDgKiBfLiDeOiCmI_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwGroupData	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiGiDgKiBfLiDeO_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiDfIiDgHiDeBiCmFiDePiDiLiBfLiDhGiCmMjDfHiKeKiCmGiPpEiNjOiCnNiCpAiLeMiJkPiClHiCoJiNnLiBeBiDgAiDgCiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_iPpDjBnEiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiBeBiDePiDiLiBfLiDhGiCkKjBlGjBlBiClFiCmEiCkCiCoJiCkJiNoNiPjMiClDiCoKiClNiCkJ_xHqqkZx_
 *			_xZkqqHx_iCpAiOkPjFmKiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCmFiOkPjFmKiClHiCoJiCmGiBeBiDePiDiLiBfLiDhGiCkKiNoNiPjMiClDiCoKiClNiMoDiCmJjDkPiClG_xHqqkZx_ID_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iIoBiCkEiDePiDiLiBfLiDhGiCkKiNoMjAkMiClDiCoKiCmEiCoAiLoGjFmKiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDiGiDgKiBfLiDeO_xHqqkZx_ID_xZkqqHx_iCpAjHhAiInDiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCMatrixControl::GetGroupUniqID (DWORD dwGroupData) const
{
	return dwGroupData;
} // CFCMatrixControl::GetGroupUniqID.
//----- 06.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::EnumGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCpAiCePiCkJiCoHiPiHiCmJjHpBiLjDiClFiCmEiBeBiOhHjCoIiClDiCoKiClNiDhGiDiNiDfGiDfHiDiDiCpAiDfCiBfLiDiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	proc	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lOffsetY:_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCmMiIpIjAjEiCmJjDgOiCoJiNmAjFfHiPoOjFpBiCmMiDeJiDhEiDfKiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCmMiIpIjAjEiCmJjDgOiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMiDhGiDiNiDfGiDfHiDiDiDfCiBfLiDiLiCkKjFnEiClHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCMatrixControl::EnumGroup (FPEnumGroupProc proc, long lOffsetY, void* pData)
{
	return EnumGroupConst((FPEnumGroupConstProc)proc, lOffsetY, pData);
} // CFCMatrixControl::EnumGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::EnumGroupConst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCpAiCePiCkJiCoHiPiHiCmJjHpBiLjDiClFiCmEiBeBiOhHjCoIiClDiCoKiClNiDhGiDiNiDfGiDfHiDiDiCpAiDfCiBfLiDiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	proc	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lOffsetY:_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCmMiIpIjAjEiCmJjDgOiCoJiNmAjFfHiPoOjFpBiCmMiDeJiDhEiDfKiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData	:_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCmMiIpIjAjEiCmJjDgOiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMiDhGiDiNiDfGiDfHiDiDiDfCiBfLiDiLiCkKjFnEiClHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCMatrixControl::EnumGroupConst (FPEnumGroupConstProc proc, long lOffsetY, void* pData) const
{
	// _xZkqqHx_iDePiDiLiBfLiDhGjBfDjBmMiCmMiBeBiJeFiNmAjFfHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiJeFjCfLiBeBiDeBiDeDiDgFiDiAiJeFjCfLiCmMiCkEiClPjBoFiCkLiCkCjFpLiCkKiDePiDiLiBfLiDhGiJeFjCfLiCmGiCmIiCoJiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(&rtClient);
	if (rtClient.right < GetColumnCount() * GetTotalItemWidth())
		rtClient.right = GetColumnCount() * GetTotalItemWidth();

	// _xZkqqHx_iKoOjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
	long lTopY = lOffsetY;
	// _xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long lItemIndexBegin = 0;
	// _xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFiBeBiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJ_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiNhDiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	long lVisibleLineBegin = 0;

	long lGroupIndex;
	for (lGroupIndex = 0; lGroupIndex != GetGroupCount(); lGroupIndex++)
	{
		// _xZkqqHx_jDfHiKeKjCiGiCkJiBeI_xHqqkZx_
		const BOOL bIsExpanded = GetIsGroupExpanded(lGroupIndex);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiBeE_xHqqkZx_
		const long lItemIndexEnd = lItemIndexBegin + GetGroupItemCount(lGroupIndex);
		// _xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiCmMiCnNiCmFiCmMiDePiDiLiBfLiDhGiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMiNhDiDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiBeE_xHqqkZx_
		const long lVisibleLineEnd = lVisibleLineBegin + GetGroupItemLines(lGroupIndex);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiJlKiNmAjFfHiBeC_xHqqkZx_
		const long lBottomY = lTopY +
							GetTotalGroupHeaderHeight() +
							(GetGroupItemLines(lGroupIndex) * GetTotalItemHeight());
		// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
		int iReturn = (*proc)(	this,
								lGroupIndex,
								bIsExpanded,
								lItemIndexBegin,
								lItemIndexEnd,
								lVisibleLineBegin,
								lVisibleLineEnd,
								CRect(0, lTopY, rtClient.right, lBottomY),
								pData);
		// _xZkqqHx_jFnEjCgMiBeJiBiBiCePiCmMiPoKiNiHiCmNiBeBjHpBiLjDiPiIjHjNiCpAjCiGjCgGiBeC_xHqqkZx_
		if (iReturn != 0)
			return iReturn;
		lTopY = lBottomY;
		lItemIndexBegin = lItemIndexEnd;
		lVisibleLineBegin = lVisibleLineEnd;
	}
	return 0;
} // CFCMatrixControl::EnumGroupConst.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::EnumItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCkJiCoHiPiHiCmJjHpBiLjDiClFiCmEiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCpAiDfCiBfLiDiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	proc		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lGroupTopY	:lGroupIndexBegin_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDePiDiLiBfLiDhGiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lGroupIndexBegin
 *						:_xZkqqHx_jHpBiLjDiCpAiKeKiOgOiClHiCoJiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lGroupIndexEnd
 *						:_xZkqqHx_jHpBiLjDiCpAiPeJjHlJiClHiCoJiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData		:_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCmMiIpIjAjEiCmJjDgOiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMiDhGiDiNiDfGiDfHiDiDiDfCiBfLiDiLiCkKjFnEiClHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjHpBiLjDiCmNiBeBjDfHiKeKiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiCnNiCmJjBmOiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCmJiKnGiClFiCmEiCmNjGkCjDfHiKeKiCmMiDePiDiLiBfLiDhGiCoAjHpBiLjDjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCMatrixControl::EnumItem (	FPEnumItemProc proc,
									long lGroupTopY,
									long lGroupIndexBegin,
									long lGroupIndexEnd,
									void* pData)
{
	return EnumItemConst((FPEnumItemConstProc)proc,
						lGroupTopY,
						lGroupIndexBegin,
						lGroupIndexEnd,
						pData);
} // CFCMatrixControl::EnumItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::EnumItemConst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCkJiCoHiPiHiCmJjHpBiLjDiClFiCmEiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCpAiDfCiBfLiDiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	proc		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lGroupTopY	:lGroupIndexBegin_xZkqqHx_iCmFiOhHjCoIiClDiCoKiCoJiDePiDiLiBfLiDhGiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lGroupIndexBegin
 *						:_xZkqqHx_jHpBiLjDiCpAiKeKiOgOiClHiCoJiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lGroupIndexEnd
 *						:_xZkqqHx_jHpBiLjDiCpAiPeJjHlJiClHiCoJiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pData		:_xZkqqHx_iDhGiDiNiDfGiDfHiDiDiCmMiIpIjAjEiCmJjDgOiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMiDhGiDiNiDfGiDfHiDiDiDfCiBfLiDiLiCkKjFnEiClHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCmNiBeB_xHqqkZx_[_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_A_xZkqqHx_iCmMiDhHiDgCiDfP_xHqqkZx_],[_xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_A-0],[_xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_A-1]_xZkqqHx_iBgD_xHqqkZx_
 *			[_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_B_xZkqqHx_iCmMiDhHiDgCiDfP_xHqqkZx_],[_xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_A-0],[_xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_A-1]_xZkqqHx_iBgD_xHqqkZx_
 *			_xZkqqHx_iCmMiPiHiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjHpBiLjDiCmNiBeBjDfHiKeKiClDiCoKiClNiDePiDiLiBfLiDhGiCmMiCnNiCmJjBmOiClFiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCmJiKnGiClFiCmEiCmNjGkCjDfHiKeKiCmMiDePiDiLiBfLiDhGiCoAjHpBiLjDjBmOiPnLiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCMatrixControl::EnumItemConst (	FPEnumItemConstProc proc,
										long lGroupTopY,
										long lGroupIndexBegin,
										long lGroupIndexEnd,
										void* pData) const
{
	if (!GetIsGroupStyle())
	//----- _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		lGroupIndexBegin = 0;
		lGroupIndexEnd = 1;
	}

	// _xZkqqHx_iDePiDiLiBfLiDhGjBfDjBmMiCmMiBeBiJeFiNmAjFfHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiJeFjCfLiBeBiDeBiDeDiDgFiDiAiJeFjCfLiCmMiCkEiClPjBoFiCkLiCkCjFpLiCkKiDePiDiLiBfLiDhGiJeFjCfLiCmGiCmIiCoJiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(&rtClient);
	if (rtClient.right < GetColumnCount() * GetTotalItemWidth())
		rtClient.right = GetColumnCount() * GetTotalItemWidth();

	// lGroupIndexBegin_xZkqqHx_iCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCmM_xHqqkZx_[First, Last)_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	long lIndexBegin;
	long lIndexEnd;
	GetGroupItemIndex(lIndexBegin, lIndexEnd, lGroupIndexBegin);
	long lGroupIndex;
	for (lGroupIndex = lGroupIndexBegin;
		 lGroupIndex != lGroupIndexEnd && lGroupIndex != GetGroupCount();
		 lGroupIndex++)
	{
		if (GetIsGroupStyle())
		//----- _xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCpAiOhHjCoIiClFiCmEiDfCiBfLiDiLiDgPiDgCiDeOiCpAiOmAiNhDiBeC_xHqqkZx_
			int iReturn = (*proc)(this,
								lGroupIndex,
								-1,
								CRect(0, lGroupTopY, rtClient.right, lGroupTopY + GetTotalGroupHeaderHeight()),
								pData);
			// _xZkqqHx_jFnEjCgMiBeJiBiBiCePiCmMiPoKiNiHiCmNiBeBjHpBiLjDiPiIjHjNiCpAjCiGjCgGiBeC_xHqqkZx_
			if (iReturn != 0)
				return iReturn;
			lGroupTopY += GetTotalGroupHeaderHeight();
			lIndexEnd = lIndexBegin + GetGroupItemCount(lGroupIndex);
		}

		if (GetIsGroupExpanded(lGroupIndex))
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjDfHiKeKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			CRect rtItem(0, 0, 0, 0);
			for (long lItemIndex = lIndexBegin; lItemIndex != lIndexEnd; lItemIndex++)
			//----- _xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCpAiDiLiBfLiDhG_xHqqkZx_ -----
			{
				// _xZkqqHx_jBmOiPnLiDePiDiLiBfLiDhGiCmMiKoOjDfPiCkJiCoHiCmMiBeBiNhDjAjEiCmGjHpBjAjEiCpAiOfKiPgPiBeC_xHqqkZx_
				const long lLine = (lItemIndex - lIndexBegin) / GetColumnCount();
				const long lColumn = (lItemIndex - lIndexBegin) % GetColumnCount();
				// _xZkqqHx_iDePiDiLiBfLiDhGiKoOjDfPiCkJiCoHiCmMiLoJiMgAiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
				rtItem.left = lColumn * GetTotalItemWidth();
				rtItem.top =  lLine * GetTotalItemHeight();
				rtItem.right = rtItem.left + GetTotalItemWidth();
				rtItem.bottom = rtItem.top + GetTotalItemHeight();
				// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiCpAiOmAiNhDiBeC_xHqqkZx_
				int iReturn = (*proc)(	this,
										lGroupIndex,
										lItemIndex,
										rtItem + CSize(0, lGroupTopY),
										pData);
				// _xZkqqHx_jFnEjCgMiBeJiBiBiCePiCmMiPoKiNiHiCmNiBeBjHpBiLjDiPiIjHjNiCpAjCiGjCgGiBeC_xHqqkZx_
				if (iReturn != 0)
					return iReturn;
			}
			lGroupTopY += rtItem.bottom;
		}
		lIndexBegin = lIndexEnd;
	}
	return 0;
} // CFCMatrixControl::EnumItemConst.

//----- 06.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//long CFCMatrixControl::PointToGroupHeaderIndex (const CPoint& point) const
//{
//	struct my
//	{
//		my (CPoint point, long	lHeaderHeight) :m_point(point),
//												m_lHeaderHeight(lHeaderHeight) {}
//		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
//										long lGroupIndex,
//										BOOL bIsExpanded,
//										long lItemIndexBegin,
//										long lItemIndexEnd,
//										long lVisibleLineBegin,
//										long lVisibleLineEnd,
//										const CRect& rtGroup,
//										void* pData)
//		{
//			my* pMy = (my*)pData;
//			CRect rtHeader(rtGroup);
//			rtHeader.bottom = rtHeader.top + pMy->m_lHeaderHeight;
//			if (rtHeader.PtInRect(pMy->m_point))
//			{
//				pMy->m_lIndex = lGroupIndex;
//				return 1;
//			} else
//			if (pMy->m_point.y < rtHeader.top)
//			{
//				return 2;
//			} else
//			{
//				return 0;
//			}
//		}
//		const CPoint	m_point;
//		const long		m_lHeaderHeight;
//		long	m_lIndex;
//	} data(point, GetTotalGroupHeaderHeight());
//
//	// _xZkqqHx_iDfEiDeDiDfJiMhGiOfKiBeC_xHqqkZx_
//	if (EnumGroupConst(my::EnumGroupConstProc, -GetScrollPos(SB_VERT), &data) != 1)
//		return -1;
//	return data.m_lIndex;
//} // CFCMatrixControl::PointToGroupHeaderIndex.
//----- 06.11.10 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::PointToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiNmAjFfHiCkKjBkOiClHiCoJiDePiDiLiBfLiDhGiCmGiDeBiDeDiDgFiDiAiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lGroupIndex	:_xZkqqHx_iDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			lItemIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeCiDhMiDeDiDjDiDgHiCkK_xHqqkZx_
 *						 _xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCmJjBkOiClHiCoJiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			point		:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHiCkKiDePiDiLiBfLiDhGiDhHiDgCiDfPiIlNiCkCiCmNiDeBiDeDiDgFiDiAiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::PointToIndex (long& lGroupIndex,
									 long& lItemIndex,
									 const CPoint& point) const
{
	struct my
	{
		my (CPoint point) : m_point(point) {}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumGroupConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			bIsExpanded			:_xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexBegin		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
		 *								 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexEnd		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineBegin	:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiNhDiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineEnd		:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiNhDiBhLiCfAiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtGroup				:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										BOOL bIsExpanded,
										long lItemIndexBegin,
										long lItemIndexEnd,
										long lVisibleLineBegin,
										long lVisibleLineEnd,
										const CRect& rtGroup,
										void* pData)
		{
			my* pMy = (my*)pData;
			if (rtGroup.PtInRect(pMy->m_point))
			//----- _xZkqqHx_iDePiDiLiBfLiDhGiLoJiMgAjCiGiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmGiNmAjFfHiCpAiLeMjIfOiClFiCmEiCfAiCpAjFnEiClHiBeC_xHqqkZx_
				pMy->m_lGroupIndex = lGroupIndex;
				pMy->m_rtGroup = rtGroup;
				return 1;
			} else
			{
				return 0;
			}
		}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumItemConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumItemConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDeBiDeDiDgFiDiAiCkKjBkOiClHiCoJiDePiDiLiBfLiDhGiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *								 _xZkqqHx_jBmOiPnLiCkKiDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtItem				:_xZkqqHx_iClBiCmMiDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumItemConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumItemConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumItemConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumItemConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										long lItemIndex,
										const CRect& rtItem,
										void* pData)
		{
			my* pMy = (my*)pData;
			if (rtItem.PtInRect(pMy->m_point))
			//----- _xZkqqHx_iDhHiDgCiDfPiBeFiDeBiDeDiDgFiDiAiLoJiMgAjCiGiCmJiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiLeMjIfOiClFiCmEiCfAiCpAjFnEiClHiBeC_xHqqkZx_
				pMy->m_lGroupIndex = lGroupIndex;
				pMy->m_lItemIndex = lItemIndex;
				return 1;
			} else
			{
				return 0;
			}
		}
		const CPoint	m_point;		// _xZkqqHx_jClCiCnHiCoJiCnHiCkLiNmAjFfHiBeC_xHqqkZx_
		long			m_lGroupIndex;	// _xZkqqHx_iDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiBgJjFnEjCgMiBgK_xHqqkZx_
		long			m_lItemIndex;	// _xZkqqHx_iDePiDiLiBfLiDhGiDeDiDjDiDgGiDgCiDeOiDfIiBgJjFnEjCgMiBgK_xHqqkZx_
		CRect			m_rtGroup;		// _xZkqqHx_iDePiDiLiBfLiDhGiLoJiMgAiBgJjFnEjCgMiBgK_xHqqkZx_
	} data(point);

	// _xZkqqHx_iCnMiClIiBeBiDePiDiLiBfLiDhGiCmMiLoJiMgAjDoAiCkJiCpAiMhGiOfKiBeC_xHqqkZx_
	if (EnumGroupConst(	my::EnumGroupConstProc,
						-GetScrollPos(SB_VERT),
						&data) != 1)
		return FALSE;
	// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmIiCoHiBeBiClLiCmMiDePiDiLiBfLiDhGiCmMiCmHiCmMiDeBiDeDiDgFiDiAjDoAiCkJiMhGiOfKiBeC_xHqqkZx_
	if (EnumItemConst(	my::EnumItemConstProc,
						data.m_rtGroup.top,
						data.m_lGroupIndex,
						data.m_lGroupIndex + 1,
						&data) != 1)
		return FALSE;
	lGroupIndex = data.m_lGroupIndex;
	lItemIndex = data.m_lItemIndex;
	return TRUE;
} // CFCMatrixControl::PointToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::PointToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJoGjGmKiPoDiCmMiDhMiDeDiDjDiDgHiNmAjFfHiCpAiDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	point	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeCiDhMiDeDiDjDiDgHiCkKiDeBiDeDiDgFiDiAiPoDiCmJjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::PointToIndex (const CPoint& point) const
{
//----- 06.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiBgJiNmAjFfHjCgMiBgKiCmMiOoGjDlOiBeC_xHqqkZx_
//	long lScrollY = (GetTotalItemHeight() / 2) * GetScrollPos(SB_VERT);
//	// _xZkqqHx_jFoCjAlDiMoDiCmMiDhMiDeDiDjDiDgHiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
//	long lPointX = point.x - FDMC_MARGIN_X;	// _xZkqqHx_jFfMiOkGiNlGiCmMiDeNiDiDiDgCiDhGiCpAiPjMiLiOiBeC_xHqqkZx_
//	long lPointY = point.y - FDMC_MARGIN_Y;	// _xZkqqHx_jFfMiOkGiPoDiCmMiDeNiDiDiDgCiDhGiCpAiPjMiLiOiBeC_xHqqkZx_
//	if (lPointX < 0) return -1;
//	if (lPointY < 0) return -1;
//	// X_xZkqqHx_jFpLiMpMiCmMiDhMiDeDiDjDiDgHiCnMiCmFiCmMiDeBiDeDiDgFiDiAjAjEiCpAiMhGiOfKiBeC_xHqqkZx_
//	long lCH = lPointX / GetTotalItemWidth();
//	if (m_lColumnCount <= lCH) return -1;
//	// Y_xZkqqHx_jFpLiMpMiCmMiDhMiDeDiDjDiDgHiCnMiCmFiCmMiDeBiDeDiDgFiDiAjAjEiCpAiMhGiOfKiBeC_xHqqkZx_
//	long lCV = (lPointY + lScrollY) / GetTotalItemHeight();
//	// _xZkqqHx_iDhMiDeDiDjDiDgHiCnMiCmFiCmMiDeBiDeDiDgFiDiAjAjEiCpAiJmBiOfKiClHiCoJiBeC_xHqqkZx_
//	long lIndex = lCV * m_lColumnCount + lCH;
//	if (lIndex < 0 || GetItemCount() <= lIndex) return -1;
//	return lIndex;
//----- 06.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lGroupIndex;
	long lItemIndex;
	if (!PointToIndex(lGroupIndex, lItemIndex, point))
		return -1;
	return lItemIndex;
//----- 06.11.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::PointToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::IndexToVisibleLineColumn
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiCmMiCnNiCmMiDhNiDgHiDiKiDgCiDeOiDfIjCiGiCmFiBeBiOhHjCoIiClDiCoKiClNiDeBiDeDiDgFiDiAiCmMiNhDiCmG_xHqqkZx_
 *			_xZkqqHx_jHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lLine		:_xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			lColumn		:_xZkqqHx_jHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *			lItemIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	REGAL_INDEX	:_xZkqqHx_jHeMiMpIiCmIiDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *			OVER_INDEX	:_xZkqqHx_iNmFiMoDiCmMiJmCiOiLiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCoGiCoIiJlKiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *			HIDDEN_INDEX:_xZkqqHx_jFhDiJmCiOiLiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHoBiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			lItemIndex = 23_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			lLine = 7, lColumn = 1, _xZkqqHx_jFnEjCgM_xHqqkZx_ = REGAL_INDEX_xZkqqHx_iBeC_xHqqkZx_
 *			lItemIndex = 8_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			_xZkqqHx_jFnEjCgM_xHqqkZx_ = HIDDEN_INDEX_xZkqqHx_iBeC_xHqqkZx_
 *
 *                 _xZkqqHx_iCeP_xHqqkZx_    _xZkqqHx_iCfA_xHqqkZx_    _xZkqqHx_iCfB_xHqqkZx_    
 *             _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *             _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *           _xZkqqHx_iCePiEkAiEkB_xHqqkZx_-0_xZkqqHx_iEkCiEkB_xHqqkZx_-1_xZkqqHx_iEkCiEkB_xHqqkZx_-2_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfAiEkAiEkB_xHqqkZx_-3_xZkqqHx_iEkCiEkB_xHqqkZx_-4_xZkqqHx_iEkCiEkB_xHqqkZx_-5_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfBiEkAiEkB_xHqqkZx_-6_xZkqqHx_iEkC_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkD_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *             _xZkqqHx_iEkAiBhL_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgB_xHqqkZx_     _xZkqqHx_iEkAiBkJiDeBiDeDiDgFiDiAiCpA_xHqqkZx_4_xZkqqHx_iCmCiKnMiCnOiBeC_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *             _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgC_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *           _xZkqqHx_iCfCiEkAiEkB_xHqqkZx_11_xZkqqHx_iEkCiEkB_xHqqkZx_12_xZkqqHx_iEkCiEkB_xHqqkZx_13_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfDiEkAiEkB_xHqqkZx_14_xZkqqHx_iEkCiEkB_xHqqkZx_15_xZkqqHx_iEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkD_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *             _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgD_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *           _xZkqqHx_iCfEiEkAiEkB_xHqqkZx_16_xZkqqHx_iEkCiEkB_xHqqkZx_17_xZkqqHx_iEkCiEkB_xHqqkZx_18_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfFiEkAiEkB_xHqqkZx_19_xZkqqHx_iEkCiEkB_xHqqkZx_20_xZkqqHx_iEkCiEkB_xHqqkZx_21_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfGiEkAiEkB_xHqqkZx_22_xZkqqHx_iEkCiEkB_xHqqkZx_23_xZkqqHx_iEkCiEkB_xHqqkZx_24_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *             _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMatrixControl::FTIndexTo CFCMatrixControl::IndexToVisibleLineColumn (
																long& lLine,
																long& lColumn,
																long lItemIndex) const
{
	if (lItemIndex < 0)
		FFThrowMiscUnknown();

	struct my
	{
		my (long lCurItemIndex) : m_lCurItemIndex(lCurItemIndex) {}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumGroupConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			bIsExpanded			:_xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexBegin		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
		 *								 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexEnd		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineBegin	:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiNhDiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineEnd		:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiNhDiBhLiCfAiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtGroup				:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										BOOL bIsExpanded,
										long lItemIndexBegin,
										long lItemIndexEnd,
										long lVisibleLineBegin,
										long lVisibleLineEnd,
										const CRect& rtGroup,
										void* pData)
		{
			my* pMy = (my*)pData;
//----- 06.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (lItemIndexBegin <= pMy->m_lCurItemIndex &&
//				pMy->m_lCurItemIndex < lItemIndexEnd)
//----- 06.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if (pMy->m_lCurItemIndex < lItemIndexEnd)
//----- 06.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			//----- _xZkqqHx_iOhHjCoIiDeBiDeDiDgFiDiAiCkKiClBiCmMiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iKgFiDePiDiLiBfLiDhGiPoOjFpBiCpAiLeMjIfOiClFiCmEiCfAiCpAjFnEiClHiBeC_xHqqkZx_
				pMy->m_bIsExpanded = bIsExpanded;
				pMy->m_lItemIndexBegin = lItemIndexBegin;
				pMy->m_lVisibleLineBegin = lVisibleLineBegin;
				return 1;
			} else
			{
				return 0;
			}
		}
		const long m_lCurItemIndex;	// _xZkqqHx_jBmOiPnLiCmMiDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		BOOL m_bIsExpanded;			// _xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiBeIiBgJjFnEjCgMiBgK_xHqqkZx_
		long m_lItemIndexBegin;		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiKeKiOgOiDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiBgJjFnEjCgMiBgK_xHqqkZx_
		long m_lVisibleLineBegin;	// _xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiDhNiDgHiDiKiDgCiDeOiDfIiPoDiCmFiCmMiNhDjAjEiBgJjFnEjCgMiBgK_xHqqkZx_
	} data(lItemIndex);

	// _xZkqqHx_iDePiDiLiBfLiDhGiCpAjHpBiLjDiClFiCmE_xHqqkZx_EnumGroupConstProc_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	if (EnumGroupConst(my::EnumGroupConstProc, 0, &data) != 1)
		return OVER_INDEX;
	// _xZkqqHx_jBmOiPnLiCmMiDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCmIiCoHiCmO_xHqqkZx_ HIDDEN_INDEX _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (!data.m_bIsExpanded)
		return HIDDEN_INDEX;
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiJmCiOiLiDeBiDeDiDgFiDiAiDhNiDgHiDiKiDgCiDeOiDfIiPoDiCmFiCmMiNhDjAjEiCmGjHpBjAjEiCpAiMhGiOfKiBeC_xHqqkZx_
	lLine = data.m_lVisibleLineBegin + ((lItemIndex - data.m_lItemIndexBegin) / GetColumnCount());
	lColumn = (lItemIndex - data.m_lItemIndexBegin) % GetColumnCount();
	return REGAL_INDEX;
} // CFCMatrixControl::IndexToVisibleLineColumn.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::VisibleLineColumnToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiCmMiCnNiCmMiDhNiDgHiDiKiDgCiDeOiDfIjCiGiCmFiCmMiNhDiCmGjHpBiCpAiOhHjCoIiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lItemIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
*			lLine		:_xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lColumn		:_xZkqqHx_jHpBiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	REGAL_INDEX	:_xZkqqHx_jHeMiMpIiCmIiDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *			OVER_INDEX	:_xZkqqHx_iNmFiMoDiCmMiJmCiOiLiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCoGiCoIiJlKiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *			INTERVAL_INDEX
 *						:_xZkqqHx_iDePiDiLiBfLiDhGiKnEiMiEjFjEjFkKiCmMiDeDiDjDiDgGiDgCiDeOiDfIjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHoBiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			lLine = 6, lColumn = 2_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			lItemIndex = 21, _xZkqqHx_jFnEjCgM_xHqqkZx_ = REGAL_INDEX_xZkqqHx_iBeC_xHqqkZx_
 *			lLine = 2, lColumn = 1_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			_xZkqqHx_jFnEjCgM_xHqqkZx_ = INTERVAL_INDEX_xZkqqHx_iBeC_xHqqkZx_
 *
 *                 _xZkqqHx_iCeP_xHqqkZx_    _xZkqqHx_iCfA_xHqqkZx_    _xZkqqHx_iCfB_xHqqkZx_    
 *             _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *             _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *           _xZkqqHx_iCePiEkAiEkB_xHqqkZx_-0_xZkqqHx_iEkCiEkB_xHqqkZx_-1_xZkqqHx_iEkCiEkB_xHqqkZx_-2_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfAiEkAiEkB_xHqqkZx_-3_xZkqqHx_iEkCiEkB_xHqqkZx_-4_xZkqqHx_iEkCiEkB_xHqqkZx_-5_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfBiEkAiEkB_xHqqkZx_-6_xZkqqHx_iEkC_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkD_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *             _xZkqqHx_iEkAiBhL_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgB_xHqqkZx_     _xZkqqHx_iEkAiBkJiDeBiDeDiDgFiDiAiCpA_xHqqkZx_4_xZkqqHx_iCmCiKnMiCnOiBeC_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *             _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgC_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *           _xZkqqHx_iCfCiEkAiEkB_xHqqkZx_11_xZkqqHx_iEkCiEkB_xHqqkZx_12_xZkqqHx_iEkCiEkB_xHqqkZx_13_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfDiEkAiEkB_xHqqkZx_14_xZkqqHx_iEkCiEkB_xHqqkZx_15_xZkqqHx_iEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkD_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *             _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgD_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *             _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *           _xZkqqHx_iCfEiEkAiEkB_xHqqkZx_16_xZkqqHx_iEkCiEkB_xHqqkZx_17_xZkqqHx_iEkCiEkB_xHqqkZx_18_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfFiEkAiEkB_xHqqkZx_19_xZkqqHx_iEkCiEkB_xHqqkZx_20_xZkqqHx_iEkCiEkB_xHqqkZx_21_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *           _xZkqqHx_iCfGiEkAiEkB_xHqqkZx_22_xZkqqHx_iEkCiEkB_xHqqkZx_23_xZkqqHx_iEkCiEkB_xHqqkZx_24_xZkqqHx_iEkCiEkA_xHqqkZx_
 *             _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *             _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCMatrixControl::FTIndexTo CFCMatrixControl::VisibleLineColumnToIndex (
														long& lItemIndex,
														long lLine,
														long lColumn) const
{
	if (lLine < 0 || lColumn < 0 || GetColumnCount() <= lColumn)
		FFThrowMiscUnknown();

	struct my
	{
		my (long lCurLine) : m_lCurLine(lCurLine) {}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumGroupConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			bIsExpanded			:_xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexBegin		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
		 *								 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexEnd		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineBegin	:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiNhDiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineEnd		:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiNhDiBhLiCfAiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtGroup				:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										BOOL bIsExpanded,
										long lItemIndexBegin,
										long lItemIndexEnd,
										long lVisibleLineBegin,
										long lVisibleLineEnd,
										const CRect& rtGroup,
										void* pData)
		{
			my* pMy = (my*)pData;
//----- 06.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (lVisibleLineBegin <= pMy->m_lCurLine &&
//				pMy->m_lCurLine < lVisibleLineEnd)
//----- 06.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if (pMy->m_lCurLine < lVisibleLineEnd)
//----- 06.11.15 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			//----- _xZkqqHx_iOhHjCoIiNhDiCkKiClBiCmMiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJiCmGjElLjCgGiClDiCoKiClNiOjOjDfPiCmFiBeBiDePiDiLiBfLiDhGiCmN_xHqqkZx_
				// _xZkqqHx_jDfHiKeKjCiGiBgJ_xHqqkZx_bIsExpanded=TRUE_xZkqqHx_iBgKiCmGjElLiCoJiBeC_xHqqkZx_
				pMy->m_lItemIndexBegin = lItemIndexBegin;
				pMy->m_lItemIndexEnd = lItemIndexEnd;
				pMy->m_lVisibleLineBegin = lVisibleLineBegin;
				return 1;
			} else
			{
				return 0;
			}
		}
		const long m_lCurLine;		// _xZkqqHx_jClCiCnHiCoJiNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		long m_lItemIndexBegin;		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiKeKiOgOiDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiBgJjFnEjCgMiBgK_xHqqkZx_
		long m_lItemIndexEnd;		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiPeJjHlJiDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiBgJjFnEjCgMiBgK_xHqqkZx_
		long m_lVisibleLineBegin;	// _xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiDhNiDgHiDiKiDgCiDeOiDfIiPoDiCmFiCmMiNhDiDeDiDjDiDgGiDgCiDeOiDfIiBgJjFnEjCgMiBgK_xHqqkZx_
	} data(lLine);
	// _xZkqqHx_iDePiDiLiBfLiDhGiCpAjHpBiLjDiClFiCmE_xHqqkZx_EnumGroupConstProc_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	// _xZkqqHx_iOhHjCoIiNhDiCkKiCmHiCmMiDePiDiLiBfLiDhGiCmJiCoAiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_OVER_INDEX_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (EnumGroupConst(my::EnumGroupConstProc, 0, &data) != 1)
		return OVER_INDEX;
	// _xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiMhGiOfKiBeC_xHqqkZx_
	const long lCurItemIndex = data.m_lItemIndexBegin +
						(lLine - data.m_lVisibleLineBegin) * GetColumnCount() + lColumn;
	// _xZkqqHx_iOfKiPgPiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCkKiBeBiDePiDiLiBfLiDhGiCmMiPeJjCfLiDeBiDeDiDgFiDiAiCpA_xHqqkZx_
	// _xZkqqHx_jClEiCkGiCoJiPoKiNiHiCmN_xHqqkZx_ INTERVAL_INDEX _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (data.m_lItemIndexEnd <= lCurItemIndex)
		return INTERVAL_INDEX;

	lItemIndex = lCurItemIndex;
	return REGAL_INDEX;
} // CFCMatrixControl::VisibleLineColumnToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetFirstVisibleItemIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiDhNiDgHiDiKiDgCiDeOiDfIiPoDiCmFiCmMiBeBiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *			_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeBiNmFiPiJiCmMiJmCiOiLiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmN_xHqqkZx_ 11 _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiBhL_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiBhL_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgB_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgC_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_11_xZkqqHx_iEkCiEkB_xHqqkZx_12_xZkqqHx_iEkCiEkB_xHqqkZx_13_xZkqqHx_iEkCiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_14_xZkqqHx_iEkCiEkB_xHqqkZx_15_xZkqqHx_iEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkD_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgD_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_16_xZkqqHx_iEkCiEkB_xHqqkZx_17_xZkqqHx_iEkCiEkB_xHqqkZx_18_xZkqqHx_iEkCiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *          _xZkqqHx_iBeG_xHqqkZx_                  _xZkqqHx_iBeG_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetFirstVisibleItemIndex () const
{
	struct my
	{
		my () : m_lItemIndexBegin(-1) {}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumGroupConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			bIsExpanded			:_xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexBegin		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
		 *								 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexEnd		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineBegin	:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiNhDiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineEnd		:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiNhDiBhLiCfAiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtGroup				:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										BOOL bIsExpanded,
										long lItemIndexBegin,
										long lItemIndexEnd,
										long lVisibleLineBegin,
										long lVisibleLineEnd,
										const CRect& rtGroup,
										void* pData)
		{
			my* pMy = (my*)pData;
			if (bIsExpanded && lItemIndexBegin != lItemIndexEnd)
			//----- _xZkqqHx_jDfHiKeKiClDiCoKiBeBiDeBiDeDiDgFiDiAiCpAiKnMiCnOiDePiDiLiBfLiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				pMy->m_lItemIndexBegin = lItemIndexBegin;
				return 1;
			} else
			{
				return 0;
			}
		}
		long m_lItemIndexBegin;
	} data;
	// _xZkqqHx_iDePiDiLiBfLiDhGiCpAjHpBiLjDiClFiCmE_xHqqkZx_EnumGroupConstProc_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	EnumGroupConst(my::EnumGroupConstProc, 0, &data);
	return data.m_lItemIndexBegin;
} // CFCMatrixControl::GetFirstVisibleItemIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetLastVisibleItemIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiDhNiDgHiDiKiDgCiDeOiDfIiPoDiCmFiCmMiBeBiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
 *			_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHoBiCmFiCmNiBeBiNmFiMoDiCmMiJmCiOiLiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmN_xHqqkZx_ 15 _xZkqqHx_iCmFiCkAiCoJiBeC_xHqqkZx_
 *
 *          _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
 *          _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgA_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_-0_xZkqqHx_iEkCiEkB_xHqqkZx_-1_xZkqqHx_iEkCiEkB_xHqqkZx_-2_xZkqqHx_iEkCiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_-3_xZkqqHx_iEkCiEkB_xHqqkZx_-4_xZkqqHx_iEkCiEkB_xHqqkZx_-5_xZkqqHx_iEkCiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_-6_xZkqqHx_iEkC_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkD_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgB_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_-7_xZkqqHx_iEkCiEkB_xHqqkZx_-8_xZkqqHx_iEkCiEkB_xHqqkZx_-9_xZkqqHx_iEkCiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_10_xZkqqHx_iEkC_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkD_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiBhM_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgC_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_11_xZkqqHx_iEkCiEkB_xHqqkZx_12_xZkqqHx_iEkCiEkB_xHqqkZx_13_xZkqqHx_iEkCiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkDiEkEiEjPiEkDiEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkB_xHqqkZx_14_xZkqqHx_iEkCiEkB_xHqqkZx_15_xZkqqHx_iEkC_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkAiEkEiEjPiEkDiEkEiEjPiEkD_xHqqkZx_      _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiBhL_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgD_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkFiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkH_xHqqkZx_
 *          _xZkqqHx_iEkAiBhL_xHqqkZx_ _xZkqqHx_iDePiDiLiBfLiDhGiCgE_xHqqkZx_     _xZkqqHx_iEkA_xHqqkZx_
 *          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetLastVisibleItemIndex () const
{
	struct my
	{
		my () : m_lItemIndexLast(-1) {}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumGroupConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			bIsExpanded			:_xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexBegin		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
		 *								 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexEnd		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineBegin	:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiNhDiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineEnd		:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiNhDiBhLiCfAiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtGroup				:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										BOOL bIsExpanded,
										long lItemIndexBegin,
										long lItemIndexEnd,
										long lVisibleLineBegin,
										long lVisibleLineEnd,
										const CRect& rtGroup,
										void* pData)
		{
			my* pMy = (my*)pData;
			if (bIsExpanded && lItemIndexBegin != lItemIndexEnd)
			//----- _xZkqqHx_jDfHiKeKiClDiCoKiBeBiDeBiDeDiDgFiDiAiCpAiKnMiCnOiDePiDiLiBfLiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				pMy->m_lItemIndexLast = lItemIndexEnd - 1;
			}
			return 0;
		}
		long m_lItemIndexLast;
	} data;
	// _xZkqqHx_iDePiDiLiBfLiDhGiCpAjHpBiLjDiClFiCmE_xHqqkZx_EnumGroupConstProc_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	EnumGroupConst(my::EnumGroupConstProc, 0, &data);
	return data.m_lItemIndexLast;
} // CFCMatrixControl::GetLastVisibleItemIndex.

//----- 06.11.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//long CFCMatrixControl::GetFirstVisibleItemIndex (long lColumn) const
//{
//	struct my
//	{
//		my (long lColumn) : m_lColumn(lColumn), m_lItemIndexBegin(-1) {}
//		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
//										long lGroupIndex,
//										BOOL bIsExpanded,
//										long lItemIndexBegin,
//										long lItemIndexEnd,
//										long lVisibleLineBegin,
//										long lVisibleLineEnd,
//										const CRect& rtGroup,
//										void* pData)
//		{
//			my* pMy = (my*)pData;
//			if (bIsExpanded && lItemIndexBegin != lItemIndexEnd)
//			//----- _xZkqqHx_jDfHiKeKiClDiCoKiBeBiDeBiDeDiDgFiDiAiCpAiKnMiCnOiDePiDiLiBfLiDhGiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				const long lItemCount = lItemIndexEnd - lItemIndexBegin;
//				if (pMy->m_lColumn < lItemCount)
//				{
//					pMy->m_lItemIndexBegin = lItemIndexBegin + pMy->m_lColumn;
//					return 1;
//				}
//			}
//			return 0;
//		}
//		const long	m_lColumn;
//		long m_lItemIndexBegin;
//	} data(lColumn);
//	EnumGroupConst(my::EnumGroupConstProc, 0, &data);
//	return data.m_lItemIndexBegin;
//} // CFCMatrixControl::GetFirstVisibleItemIndex.
//
//long CFCMatrixControl::GetLastVisibleItemIndex (long lColumn) const
//{
//	struct my
//	{
//		my (long lColumn) : m_lColumn(lColumn), m_lItemIndexLast(-1) {}
//		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
//										long lGroupIndex,
//										BOOL bIsExpanded,
//										long lItemIndexBegin,
//										long lItemIndexEnd,
//										long lVisibleLineBegin,
//										long lVisibleLineEnd,
//										const CRect& rtGroup,
//										void* pData)
//		{
//			my* pMy = (my*)pData;
//			if (bIsExpanded && lItemIndexBegin != lItemIndexEnd)
//			//----- _xZkqqHx_jDfHiKeKiClDiCoKiBeBiDeBiDeDiDgFiDiAiCpAiKnMiCnOiDePiDiLiBfLiDhGiCmMiPoKiNiH_xHqqkZx_ -----
//			{
//				// a = (ItemCount - Column - 1) / ColumnCount;
//				// index = a * ColumnCount + Column;
//				//
//				// _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
//				// _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
//				// _xZkqqHx_iBkAiBkBiBkA_xHqqkZx_
//				// _xZkqqHx_iDeBiDeDiDgFiDiAjAjEiCkK_xHqqkZx_11_xZkqqHx_iBeB_xHqqkZx_Column=1_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
//				// 11 - 1 - 1 = 9
//				// 9 / 4 = 2
//				// 2 * 4 + 1 = 9
//				//
//				// _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
//				// _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
//				// _xZkqqHx_iBkAiBkAiBkB_xHqqkZx_
//				// _xZkqqHx_iDeBiDeDiDgFiDiAjAjEiCkK_xHqqkZx_11_xZkqqHx_iBeB_xHqqkZx_Column=2_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
//				// 11 - 2 - 1 = 8
//				// 8 / 4 = 2
//				// 2 * 4 + 2 = 10
//				//
//				// _xZkqqHx_iBkAiBkAiBkAiBkA_xHqqkZx_
//				// _xZkqqHx_iBkAiBkAiBkBiBkA_xHqqkZx_
//				// _xZkqqHx_iBkAiBkA_xHqqkZx_
//				// _xZkqqHx_iDeBiDeDiDgFiDiAjAjEiCkK_xHqqkZx_10_xZkqqHx_iBeB_xHqqkZx_Column=2_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
//				// 10 - 2 - 1 = 7
//				// 7 / 4 = 1
//				// 1 * 4 + 2 = 6
//				//
//				const long lItemCount = lItemIndexEnd - lItemIndexBegin;
//				if (pMy->m_lColumn < lItemCount)
//				{
//					const long lLineCount = (lItemCount - pMy->m_lColumn - 1) / pControl->GetColumnCount();
//					pMy->m_lItemIndexLast = lLineCount * pControl->GetColumnCount() + pMy->m_lColumn;
//				}
//			}
//			return 0;
//		}
//		const long	m_lColumn;
//		long m_lItemIndexLast;
//	} data(lColumn);
//	EnumGroupConst(my::EnumGroupConstProc, 0, &data);
//	return data.m_lItemIndexLast;
//} // CFCMatrixControl::GetLastVisibleItemIndex.
//----- 06.11.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.11.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetItemCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetItemCount () const
{
	return long(m_vItem.size());
} // CFCMatrixControl::GetItemCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::AddItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiDeBiDeDiDgFiDiAiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwData	:_xZkqqHx_jBhNjDpMiClHiCoJiDgGiBfLiDfOjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::AddItem (DWORD dwData)
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_vItem.push_back(FCMCItemData(0, dwData));
//	return long(m_vItem.size()) - 1;
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (GetIsGroupStyle())
		FFThrowMiscUnknown();
	return AddItem(0L, dwData);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::AddItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::InsertItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiImKjChFiCmJiDeBiDeDiDgFiDiAiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwData	:_xZkqqHx_jBhNjDpMiClHiCoJiDgGiBfLiDfOjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBhNjDpMiMoDiBeBjAfGiLeLiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkK_xHqqkZx_lIndex_xZkqqHx_iCmJiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::InsertItem (long lIndex, DWORD dwData)
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	ASSERT(lIndex <= m_vItem.size());
//	m_vItem.insert(m_vItem.begin() + lIndex, FCMCItemData(0, dwData));
//	if (lIndex <= m_lIndexA)
//	{
//		m_lIndexA++;
//		PostSelChangeMessage();
//	}
//	if (lIndex <= m_lIndexB) m_lIndexB++;
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (GetIsGroupStyle())
		FFThrowMiscUnknown();
	InsertItem(0L, lIndex, dwData);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::InsertItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::DeleteItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::DeleteItem (long lIndex)
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_vItem.erase(m_vItem.begin() + lIndex);
//	if (lIndex <= m_lIndexA)
//	{
//		m_lIndexA--;
//		PostSelChangeMessage();
//	}
//	if (lIndex <= m_lIndexB) m_lIndexB--;
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
	if (GetIsGroupStyle())
		FFThrowMiscUnknown();
	DeleteItem(0L, lIndex);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::DeleteItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::DeleteAllItems
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiDeBiDeDiDgFiDiAiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::DeleteAllItems ()
{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiDeOiDiKiDeBiBeC_xHqqkZx_
	if (GetIsGroupStyle())
		m_vGroup.clear();		// _xZkqqHx_iDePiDiLiBfLiDhGiBeC_xHqqkZx_
	else
		m_vGroup[0].lItemCount = 0;	// _xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAjAjEiCpAiCePiCmJiBeC_xHqqkZx_
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	m_vItem.clear();
//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_lIndexA != -1)
	//----- _xZkqqHx_jBeJjBpAiCkKjFmPiNfIiClDiCoKiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_lIndexA = -1;				// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAiCkKjFmPiNfIiClDiCoKiCoJiPoKiNiHiCmNjCmKjCgNiBeC_xHqqkZx_
		PostSelChangeMessage();		// _xZkqqHx_jBeJjBpAiImKjChFjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
	}
//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	m_lIndexA = -1;				// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
	m_lIndexB = -1;				// _xZkqqHx_jBeJjBpAiClDiCoKiClN_xHqqkZx_Item_xZkqqHx_iCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
} // CFCMatrixControl::DeleteAllItems.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetItemData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmMiDgGiBfLiDfOjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD CFCMatrixControl::GetItemData (long lIndex) const
{
	ASSERT(lIndex < m_vItem.size());
	return m_vItem[lIndex].dwData;
} // CFCMatrixControl::GetItemData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetCurSel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCfAjDmGjBeJjBpAiCmMiOjOiCmJiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeBjBeJjBpAiDeBiDeDiDgFiDiAiCmNiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetCurSel () const
{
	return GetIndexA();
} // CFCMatrixControl::GetCurSel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetCurSel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAiClDiCoKiCmEiCkCiCoJiDeBiDeDiDgFiDiAiCmMjBeJjBpAiCpAiJpAiPjMiClFiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmMiDeBiDeDiDgFiDiAiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCjDkPiOjOiCmJiMlLiNnNiCmM_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCoAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lSel	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bScroll	:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAiCkKiMkJiCkGiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiClHiCoJiPoKiNiH_xHqqkZx_
 *					 _xZkqqHx_iCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bPostMessage:_xZkqqHx_jFmPiNfIjCmKjCgNiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCfAjDmGjBeJjBpAiCmMiOjOiCmJiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeBjBeJjBpAiDeBiDeDiDgFiDiAiCmNiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::SetCurSel (long lSel, BOOL bScroll, BOOL bPostMessage)
{
	// _xZkqqHx_jAfGiClFiCkCjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	if (!SetIndexAB(lSel, lSel, bScroll, bPostMessage)) return FALSE;
	// Create_xZkqqHx_jBePiCmMiPoKiNiHiBeC_xHqqkZx_
	if (GetSafeHwnd() == NULL) return TRUE;
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	SetAllSelectionMark(FALSE);
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
	if (0 <= lSel) SetSelectionMark(lSel);
	// _xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	SendRgnRedraw();
	return TRUE;
} // CFCMatrixControl::SetCurSel.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetSelect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjEmNiImNiCpAjBfDiCmEjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_A_xZkqqHx_iBeBiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_B
 *			_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndexA	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexB	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_B_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bScroll	:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAiCkKiMkJiCkGiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiClHiCoJiPoKiNiH_xHqqkZx_
 *					 _xZkqqHx_iCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bPostMessage:_xZkqqHx_jFmPiNfIjCmKjCgNiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMjBeJjBpAiCpAjBfDiCmEiJpAiPjMiClFiBeB_xHqqkZx_[lIndexA, lIndexB]_xZkqqHx_iCmMjEmNiImNiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::SetSelect (long lIndexA, long lIndexB, BOOL bScroll, BOOL bPostMessage)
{
	// _xZkqqHx_jAfGiClFiCkCjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	if (!SetIndexAB(lIndexA, lIndexB, bScroll, bPostMessage)) return FALSE;
	// Create_xZkqqHx_jBePiCmMiPoKiNiHiBeC_xHqqkZx_
	if (GetSafeHwnd() == NULL) return TRUE;
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
	SetAllSelectionMark(FALSE);
	long lFirst = GetIndexA();
	long lLast = GetIndexB();
	if (lLast < lFirst) Exchange(lLast, lFirst);
	// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiBeC_xHqqkZx_
	for (long lIndex = lFirst; lIndex <= lLast; lIndex++)
		SetSelectionMark(lIndex);
	// _xZkqqHx_jFmPiNfIiClDiCoKiClNiDeBiDeDiDgFiDiAiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	SendRgnRedraw();
	return TRUE;
} // CFCMatrixControl::SetSelect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetItemRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rtItem	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			nIndex		:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPgDjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLjHmKiCpAiJmBjGkBiClFiCmEiMhGiOfKiClHiCoJiBgJiJkBjFpLiMpMiCmNiDfIiDeOiDiNiBfLiDiL_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkCiClNiCnPjGlDiOiLiClFiCmEiCoGiCkCiBgK_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::GetItemRect (CRect& rtItem, long lIndex) const
{
//----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (lIndex < 0 || GetItemCount() <= lIndex)
//	{
//		rtItem.SetRect(0, 0, 0, 0);
//		return;
//	}
//
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiBgJiNmAjFfHjCgMiBgKiCmMiOoGjDlOiBeC_xHqqkZx_
//	long lScrollY	= (GetTotalItemHeight() / 2) * GetScrollPos(SB_VERT);
//
//	long lCH = lIndex % m_lColumnCount;
//	long lCV = lIndex / m_lColumnCount;
//	long lX = FDMC_MARGIN_X + lCH * GetTotalItemWidth();
//	long lY = FDMC_MARGIN_Y + lCV * GetTotalItemHeight() - lScrollY;
//	rtItem.SetRect(lX, lY, lX + GetItemWidth(), lY + GetItemHeight());
//----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	rtItem = GetGlobalItemRect(lIndex);
	if (rtItem.IsRectNull()) return;
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiBgJiNmAjFfHjCgMiBgKiCmMiOoGjDlOiBeC_xHqqkZx_
	long lScrollY = GetScrollPos(SB_VERT);
	rtItem -= CSize(0, lScrollY);
//----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::GetItemRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetTextHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiNiCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetTextHeight () const
{
	return m_lTextHeight;
} // CFCMatrixControl::GetTextHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetTotalTextHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDgFiDeMiDfIiDgHjHmMiIoGiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDgFiDeMiDfIiDgHjHmMiIoGiCmMiNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetTotalTextHeight () const
{
	return GetTextHeight() + (2 * FDMC_TEXT_MARGIN);
} // CFCMatrixControl::GetTotalTextHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupHeaderHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMiNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCkJiCmHiCkEiCkJiCpAiNgMjHlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetGroupHeaderHeight () const
{
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiCePiBeC_xHqqkZx_
	if (GetIsGroupStyle())
		return GetTextHeight() + (2 * FDMC_GROUP_MARGIN);
	else
		return 0;
} // CFCMatrixControl::GetGroupHeaderHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetTotalGroupHeaderHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiBfLiDfOiDiLiCmMiDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgHiBfLiDfOiDiLiCmMiDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMiNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetTotalGroupHeaderHeight () const
{
	// _xZkqqHx_jEpBiDePiDiLiBfLiDhGiDfIiDfOiDeDiDiLiCmMiPoKiNiHiCmNiCePiBeC_xHqqkZx_
	if (GetIsGroupStyle())
		return GetGroupHeaderHeight() + FDMC_SPACE_Y;
	else
		return 0;
} // CFCMatrixControl::GetTotalGroupHeaderHeight.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetItemWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetItemWidth () const
{
	return m_lItemW;
} // CFCMatrixControl::GetItemWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetItemHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetItemHeight () const
{
	return m_lItemH;
} // CFCMatrixControl::GetItemHeight.

//----- 06.11.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetTotalItemWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFgAiJoGjHmMiIoGiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetTotalItemWidth () const
{
	return GetItemWidth() + FDMC_SPACE_X;
} // CFCMatrixControl::GetTotalItemWidth.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetTotalItemHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFgAiJoGjHmMiIoGiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNiCiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	MatrixControl.h_xZkqqHx_iCmMiJpAjAoAiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetTotalItemHeight () const
{
	return GetItemHeight() + FDMC_SPACE_Y;
} // CFCMatrixControl::GetTotalItemHeight.
//----- 06.11.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::UpdateItemSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiDfEiDeDiDfJiCpAiNmEiMhGiOfKiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::UpdateItemSize ()
{
	// _xZkqqHx_iCnMiClOiDhEiDeIiDjDiDgHiNiCiCkKiMhGiOfKiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (GetTextHeight() == 0) return;
	// _xZkqqHx_iMmFjCoIiDeBiDeDiDgFiDiAiDfEiDeDiDfJiDfIiDfOiDeDiDiLiCmFiKpJiCmJiMhGiOfKiNmPiCnNiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if ((m_dwMyStyle & FDGMC_STYLE_FIXED_ITEM_SIZE) == FDGMC_STYLE_FIXED_ITEM_SIZE &&
		m_lItemW != 0)
		return;
	// _xZkqqHx_iDiMiDfCiDiBiDjDiDgIiClDiCoKiClNiDeBiDeDiDgFiDiAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	long lItemW;
	long lItemH;
	ItemSize(lItemW, lItemH);
	const long lMinItemW = lItemW + (2 * FDMC_EDGE_W);
	const long lMinItemH = lItemH + GetTotalTextHeight() + (2 * FDMC_EDGE_W);
	if ((m_dwMyStyle & FDGMC_STYLE_FIXED_ITEM_SIZE) == FDGMC_STYLE_FIXED_ITEM_SIZE)
	//----- _xZkqqHx_iMmFjCoIiDeBiDeDiDgFiDiAiDfEiDeDiDfJiDfIiDfOiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_lItemW = lMinItemW;
		m_lItemH = lMinItemH;
	} else
	//----- _xZkqqHx_iJmCjFmPiDeBiDeDiDgFiDiAiDfEiDeDiDfJiDfIiDfOiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiPjMiCkCiClNjHeMiMpIiJoGjGmKiCpAiOoGjDlOiBeC_xHqqkZx_
		CRect rtClient;
		GetClientRect(&rtClient);
		// _xZkqqHx_iDiMiDfCiDiBiDjDiDgIiDfEiDeDiDfJiCkJiCoHiDeKiDiJiDiAjAjEiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		long lColumnCount = rtClient.Width() / (lItemW + (2 * FDMC_EDGE_W) + FDMC_SPACE_X);
		if (lColumnCount == 0) lColumnCount = 1;
		// _xZkqqHx_iDeKiDiJiDiAjAjEiCkJiCoHiBeBiDeBiDeDiDgFiDiAiCmMjFjNiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
		m_lItemW = (rtClient.Width() / lColumnCount) - FDMC_SPACE_X;
		m_lItemH = lItemH + GetTotalTextHeight() + (2 * FDMC_EDGE_W);
		// _xZkqqHx_iNmFjCoBiCmMiDfEiDeDiDfJiCpAiJlKiJpBiCoHiCmIiCkCiCoGiCkEiCmJjFoCjAlDiBeC_xHqqkZx_
		// rtClient_xZkqqHx_iCmJiCoGiCmBiCmEiCmNiBeB_xHqqkZx_m_lItemW_xZkqqHx_iCkKjFiJiCmJiCmIiCoJiCmMiCmFiBeBiImIiJlKiCmMiPiIjHjNiCmNiPgEjHhGiBeC_xHqqkZx_
		if (m_lItemW < lMinItemW)
			m_lItemW = lMinItemW;
		if (m_lItemH < lMinItemH)
			m_lItemH = lMinItemH;
	}
} // CFCMatrixControl::UpdateItemSize.

//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::UpdateItemSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiPoOjFpBiCkKjFmPiNfIiClDiCoKiClNiPoKiNiHiCmJiBeBiNmEiMhGiOfKiBjFjFgAiJoGiClHiCoJiInHiCmJ_xHqqkZx_
// *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bUpdateWindow	:_xZkqqHx_iJoGjGmKjCiGjAgHiCpAiDfIiDeOiDiNiBfLiDiLiBjFiNmEjFgAiJoGiClHiCoJiCkJiBeI_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmNiDeBiDeDiDgFiDiAjCmHiJmBiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////void CFCMatrixControl::UpdateItemSize ()
//void CFCMatrixControl::UpdateItemSize (BOOL bUpdateWindow)
//{
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
//	CalcItemMatrix();
//// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
//	if (bUpdateWindow)
//		Invalidate();
//} // CFCMatrixControl::UpdateItemSize.
//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::UpdateScrollSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiPoOjFpBiCkKjFmPiNfIiClDiCoKiClNiPoKiNiHiCmJiBeBiDeBiDeDiDgFiDiAiCmMjEhKjChFiCmGiDfIiDeOiDiNiBfLiDiL_xHqqkZx_
 *			_xZkqqHx_iDfEiDeDiDfJiCpAiNmEiMhGiOfKiBjFjFgAiJoGiClHiCoJiInHiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bUpdateWindow	:_xZkqqHx_iJoGjGmKjCiGjAgHiCpAiDfIiDeOiDiNiBfLiDiLiBjFiNmEjFgAiJoGiClHiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmKiPoNiCmNiDeBiDeDiDgFiDiAjCmHiJmBiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeKiDiJiDiAjAjEiCmIiCmHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::UpdateScrollSize (BOOL bUpdateWindow)
{
	//----- _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDfEiDeDiDfJiCpAjAnNjCoI_xHqqkZx_ -----

	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiPjMiCkCiClNjHeMiMpIiJoGjGmKiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(&rtClient);
	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjHpBiBeFiNhDjAjEiCpAiMhGiOfK_xHqqkZx_ -----
	m_lColumnCount = rtClient.Width() / GetTotalItemWidth();
	if (m_lColumnCount == 0) m_lColumnCount = 1;

	// m_lColumnCount _xZkqqHx_iCmG_xHqqkZx_ m_lTextHeight _xZkqqHx_iCkKiMiIiCnMiCoKiCmO_xHqqkZx_ GetGlobalGroupRect _xZkqqHx_iCkKiMhGiOfKiJmCjEfMiBeC_xHqqkZx_
	long lScrMax = 0;
	if (GetGroupCount() != 0)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iNmFiMoDiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtLastGroup = GetGlobalGroupRect(GetGroupCount() - 1);
		lScrMax = rtLastGroup.bottom;
	}

	// lScrPage = 0 _xZkqqHx_iCmJiCmIiCoJiCmGiBeB_xHqqkZx_WS_VSCROLL_xZkqqHx_iDfOiDeDiDhGiCkKiPmBjGmFiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_lScrPage _xZkqqHx_iCmMiNmFjCoBjCgMiCpA_xHqqkZx_10_xZkqqHx_iCmJiClHiCoJiBeC_xHqqkZx_
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	const long lScrPage = rtClient.Height();
	const long lScrPage = (rtClient.Height() < 10) ? 10 : rtClient.Height();

	long lScrPos  = GetScrollPos(SB_VERT);
	if (lScrMax - lScrPage + 1 < lScrPos)
		lScrPos = lScrMax - lScrPage + 1;
	if (lScrPos < 0) lScrPos = 0;

//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (GetStyle() & WS_VSCROLL)
	//----- _xZkqqHx_jAiCjClMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (lScrMax < lScrPage)
			lScrMax = lScrPage;
	}
//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jAiCjClMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	SCROLLINFO	oSCInfo;
	oSCInfo.cbSize	= sizeof(oSCInfo);
	oSCInfo.fMask	= SIF_ALL;
	oSCInfo.nMin	= 0;
	oSCInfo.nMax	= lScrMax;
	oSCInfo.nPage	= lScrPage;
	oSCInfo.nPos	= lScrPos;
	SetScrollInfo(SB_VERT, &oSCInfo);

	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	oSCInfo.cbSize	= sizeof(oSCInfo);
	oSCInfo.fMask	= SIF_ALL;
	if (GetStyle() & WS_HSCROLL)
	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiNoMjAkMiClHiCoJiCmMiCmNiBeBiDhNiDeFiDfIiDhKiDeDiBfLiDiLiCmMiJkBiDfIiDeOiDiNiBfLiDiLiCpA_xHqqkZx_
		// _xZkqqHx_iDeMiDiDiDgCiDgAiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_WM_HSCROLL _xZkqqHx_iCmNiBeBiJkBiDfIiDeOiDiNiBfLiDiLiJmCjEfMiCmIiDeFiDeCiDjDiDgIiDeFiCmF_xHqqkZx_
		// _xZkqqHx_iCmIiCkPiCoKiCmOjBjHjFhEiClDiCoKiCmIiCkCiCnNiClNiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iJmCjDkOiIoGiCmGiDhJiBfLiDfHiCkKjDjJiClFiCkCiDfEiDeDiDfJiCpAjHfOiCkGiCmEiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiLkNjAkHjDeJiCmJjAlGjAkMiClDiClJiCoJiBeC_xHqqkZx_
		oSCInfo.nMin	= 0;
		oSCInfo.nMax	= 100;
		oSCInfo.nPage	= 100;
		oSCInfo.nPos	= 0;
	} else
	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJmCjDkOiIoGiCoGiCoIiDhJiBfLiDfHiCkKjBoFiCkLiCkCiDfEiDeDiDfJiCpAjHfOiCkGiCmEiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMjAlGjAkMiCpAjGgIiCkOiBeC_xHqqkZx_
		oSCInfo.nMin	= 0;
		oSCInfo.nMax	= 100;
		oSCInfo.nPage	= 101;
		oSCInfo.nPos	= 0;
	}
	SetScrollInfo(SB_HORZ, &oSCInfo);

// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	if (bUpdateWindow)
		Invalidate();
} // CFCMatrixControl::UpdateScrollSize.
//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::ItemDataToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiBfLiDfOiCpAiOjNiCmCiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwData	:_xZkqqHx_iDgGiBfLiDfOjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDkPiClGiDgGiBfLiDfOjCgMiCpAiOjNiCmCiDeBiDeDiDgFiDiAiCkKjDpBiCmCiImIiPoDiCkAiCoJiPoKiNiHiCmNiBeBiNmFiPiJiCmM_xHqqkZx_
 *			_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::ItemDataToIndex (DWORD dwData) const
{
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
		if (GetItemData(lIndex) == dwData) return lIndex;
	return -1;
} // CFCMatrixControl::ItemDataToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetAllSelectionMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiDeBiDeDiDgFiDiAiCmMjBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsSet	:_xZkqqHx_jBeJjBpAiCmIiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeBjBeJjBpAiJpAiPjMiCmIiCoH_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::SetAllSelectionMark (BOOL bIsSet)
{
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
		SetSelectionMark(lIndex, bIsSet);
} // CFCMatrixControl::SetAllSelectionMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::IsSelectionMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCkKjBeJjBpAjCiGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::IsSelectionMark (long lIndex) const
{
	return (GetItemState(lIndex) & FDMC_FLAG_SELECT) ? TRUE : FALSE;
} // CFCMatrixControl::IsSelectionMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetSelectionMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDeBiDeDiDgFiDiAiCmMjBeJjBpAiDhNiBfLiDeOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSet	:_xZkqqHx_jBeJjBpAiCmIiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeBjBeJjBpAiJpAiPjMiCmIiCoH_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::SetSelectionMark (long lIndex, BOOL bSet)
{
	if (bSet)
	{
		if (!IsSelectionMark(lIndex))
		{
			SetItemState(lIndex, GetItemState(lIndex) | FDMC_FLAG_SELECT);
			SetRedrawMark(lIndex);
		}
	} else
	{
		if (IsSelectionMark(lIndex))
		{
			SetItemState(lIndex, GetItemState(lIndex) & ~FDMC_FLAG_SELECT);
			SetRedrawMark(lIndex);
		}
	}
} // CFCMatrixControl::SetSelectionMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OffsetScroll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiImKjChFiCkJiCoHiBeBiOhHjCoIiClDiCoKiClNjHmKiClOiCkPiDfIiDeOiDiNiBfLiDiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lScroll			:_xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			bUpdateWindow	:_xZkqqHx_iJoGjGmKjCiGjAgHiCpAiDfIiDeOiDiNiBfLiDiLiBjFiNmEjFgAiJoGiClHiCoJiCkJiBeI_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiCkKiPoDiJlKiCmMiMmAiKeFiCpAiCmNiCnNiPgPiClDiCmIiCkCiCoGiCkEiCmJjClCjAkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void CFCMatrixControl::OffsetScroll (long lScroll)
void CFCMatrixControl::OffsetScroll (long lScroll, BOOL bUpdateWindow)
{
	SCROLLINFO	oSCInfo;
	GetScrollInfo(SB_VERT, &oSCInfo);
	const long lScrPos	= oSCInfo.nPos;
	const long lScrMax	= oSCInfo.nMax;
	const long lScrPage= oSCInfo.nPage;

	long lScrValue = lScroll;
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCkKjBoFiCkLiClHiCkMiCoJiBeFiPkMiClDiClHiCkMiCoJiPoKiNiHiCpAjFoCjAlDiBeC_xHqqkZx_
	if (lScrPos - lScroll < 0)
	{
		lScrValue = lScrPos;
	} else if (lScrMax - lScrPage + 1 < lScrPos - lScroll)
	{
		lScrValue = lScrPos - (lScrMax - lScrPage + 1);
	}
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (lScrValue)
	if (lScrValue != 0)
	{
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
		SetScrollPos(SB_VERT, lScrPos - lScrValue);
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		if (bUpdateWindow)
		//----- _xZkqqHx_iNmEjFgAiJoGiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.11.10 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjCgMiCpAiOmAiNnLiCmMiNmAjFfHjCgMiCmJjClMiClFiCmEiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
// 06.11.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			ScrollWindow(0, (GetTotalItemHeight() / 2) * lScrValue);
			ScrollWindow(0, lScrValue);
			// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiCmFiPmBiCkGiClNjFjEjFkKiCpAjBkGiOjOiNmEjFgAiJoGiBeC_xHqqkZx_
			UpdateWindow();
		}
	}
} // CFCMatrixControl::OffsetScroll.

//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetPixelOf1Scroll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OffsetScroll_xZkqqHx_iKnGjAjEiCmFiOhHjCoIiClDiCoKiCoJiCfAiDfIiDeOiDiNiBfLiDiLiCmFiDfIiDeOiDiNiBfLiDiLiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iDhDiDeOiDfKiDiLjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDfKiDiLjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetPixelOf1Scroll () const
{
	return 1;
} // CFCMatrixControl::GetPixelOf1Scroll.
//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetGroupName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiDgGiBfLiDfOiCmMiDePiDiLiBfLiDhGjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwGroupData	:_xZkqqHx_iDePiDiLiBfLiDhGiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CFCMatrixControl::GetGroupName (DWORD dwGroupData) const
{
	return L"";
} // CFCMatrixControl::GetGroupName.

//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::ItemSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiDfEiDeDiDfJiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lW	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
// *			lH	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
// *			lFrW:_xZkqqHx_jFfMiOkGiDhEiDiMiBfLiDiAiCmMjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
// *			lFrH:_xZkqqHx_jFfMiOkGiDhEiDiMiBfLiDiAiCmMiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iKgFjCoIjAjEiCmN_xHqqkZx_ MatrixControl.h _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMatrixControl::ItemSize (long& lW, long& lH, long lFrW, long lFrH) const
//{
//	/*---------------------------------------------------------
//	 *------- _xZkqqHx_iDhAiDfOiBfLiDjDiCmMjFmAiCnBjAjEiCpAiMiIjCoI_xHqqkZx_(N) ------
//	 * EW * n + SPACE_X * (n - 1) + MARGIN_X * 2 <= WIDTH
//	 * (EW + SPACE_X) * n - SPACE_X + MARGIN_X * 2 <= WIDTH
//	 * (EW + SPACE_X) * n <= WIDTH + SPACE_X - MARGIN_X * 2
//	 * n <= (WIDTH + SPACE_X - MARGIN_X * 2) / (EW + SPACE_X)
//	 * n <= (WIDTH + 2 * MARGIN_X - MARGIN_X * 2) / (EW + SPACE_X)
//	 * n <= WIDTH / (EW + SPACE_X)
//	 *
//	 *------- EW_xZkqqHx_iCpAjFoCjAlD_xHqqkZx_(NEW_EW) ------
//	 * N = WIDTH / (NEW_EW + SPACE_X)
//	 * N * (NEW_EW + SPACE_X) = WIDTH
//	 * N * NEW_EW + N * SPACE_X = WIDTH
//	 * N * NEW_EW = WIDTH - N * SPACE_X
//	 * NEW_EW = (WIDTH - N * SPACE_X) / N
//	 * NEW_EW = WIDTH / N - SPACE_X
//	 *--------------------------------------------------------*/
//	long lItemNum = lFrW / (FDMC_MIN_ITEM_W + FDMC_SPACE_X);
//	if (lItemNum == 0) lItemNum = 1;
//	lW = lFrW / lItemNum - FDMC_SPACE_X;
//	lH = FDMC_MIN_ITEM_H;
//} // CFCMatrixControl::ItemSize.
//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::ItemSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDiMiDfCiDiBiDjDiDgIiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lW	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			lH	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNiCiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::ItemSize (long& lW, long& lH) const
{
#define FD_EW	40	// _xZkqqHx_iDeDiDiBiBfLiDfHjHmMiIoGjFjN_xHqqkZx_(_xZkqqHx_iKoOiPiAjCgM_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
#define FD_EH	40	// _xZkqqHx_iDeDiDiBiBfLiDfHjHmMiIoGiNiCiClDiBeC_xHqqkZx_
	lW = FD_EW;
	lH = FD_EH;
} // CFCMatrixControl::ItemSize.
//----- 06.11.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.11.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::CalcItemMatrix
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAjFmAiCnBiCmMiNhDiBeFjHpBiCpAiNmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//void CFCMatrixControl::CalcItemMatrix ()
//{
////----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiPjMiCkCiClNjHeMiMpIiJoGjGmKiCpAiOoGjDlOiBeC_xHqqkZx_
////	CRect rtClient;
////	GetClientRect(&rtClient);
////	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjHpBiBeFiNhDjAjEiCpAiMhGiOfK_xHqqkZx_ -----
////	m_lColumnCount = rtClient.right / GetItemWidth();
////	if (m_lColumnCount == 0) m_lColumnCount = 1;
//////----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//////	m_lItemLine = GetItemCount() / m_lColumnCount + 1;	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNhDjAjEiBeC_xHqqkZx_
//////	const long lScrMax  = m_lItemLine * 2 - 1;
//////----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
////	long lItemLine = GetItemCount() / m_lColumnCount + 1;	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNhDjAjEiBeC_xHqqkZx_
////	const long lScrMax  = lItemLine * 2 - 1;
//////----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
////	const long lScrPage = 2 * rtClient.bottom / GetTotalItemHeight();
////	long lScrPos  = GetScrollPos(SB_VERT);
////	if (lScrMax - lScrPage + 1 < lScrPos)
////		lScrPos = lScrMax - lScrPage + 1;
////	if (lScrPos < 0) lScrPos = 0;
////
////	//----- _xZkqqHx_jAiCjClMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
////	SCROLLINFO	oSCInfo;
////	oSCInfo.cbSize	= sizeof(oSCInfo);
////	oSCInfo.fMask	= SIF_ALL;
////	oSCInfo.nMin	= 0;
////	oSCInfo.nMax	= lScrMax;
////	oSCInfo.nPage	= lScrPage;
////	oSCInfo.nPos	= lScrPos;
////	SetScrollInfo(SB_VERT, &oSCInfo);
////
////	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
////	oSCInfo.cbSize	= sizeof(oSCInfo);
////	oSCInfo.fMask	= SIF_ALL;
////	if (GetStyle() & WS_HSCROLL)
////	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
////	{
////		// _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiNoMjAkMiClHiCoJiCmMiCmNiBeBiDhNiDeFiDfIiDhKiDeDiBfLiDiLiCmMiJkBiDfIiDeOiDiNiBfLiDiLiCpA_xHqqkZx_
////		// _xZkqqHx_iDeMiDiDiDgCiDgAiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_WM_HSCROLL _xZkqqHx_iCmNiBeBiJkBiDfIiDeOiDiNiBfLiDiLiJmCjEfMiCmIiDeFiDeCiDjDiDgIiDeFiCmF_xHqqkZx_
////		// _xZkqqHx_iCmIiCkPiCoKiCmOjBjHjFhEiClDiCoKiCmIiCkCiCnNiClNiCkCiBeC_xHqqkZx_
////		// _xZkqqHx_iJmCjDkOiIoGiCmGiDhJiBfLiDfHiCkKjDjJiClFiCkCiDfEiDeDiDfJiCpAjHfOiCkGiCmEiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiLkNjAkHjDeJiCmJjAlGjAkMiClDiClJiCoJiBeC_xHqqkZx_
////		oSCInfo.nMin	= 0;
////		oSCInfo.nMax	= 100;
////		oSCInfo.nPage	= 100;
////		oSCInfo.nPos	= 0;
////	} else
////	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
////	{
////		// _xZkqqHx_iJmCjDkOiIoGiCoGiCoIiDhJiBfLiDfHiCkKjBoFiCkLiCkCiDfEiDeDiDfJiCpAjHfOiCkGiCmEiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMjAlGjAkMiCpAjGgIiCkOiBeC_xHqqkZx_
////		oSCInfo.nMin	= 0;
////		oSCInfo.nMax	= 100;
////		oSCInfo.nPage	= 101;
////		oSCInfo.nPos	= 0;
////	}
////	SetScrollInfo(SB_HORZ, &oSCInfo);
////----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiPjMiCkCiClNjHeMiMpIiJoGjGmKiCpAiOoGjDlOiBeC_xHqqkZx_
//	CRect rtClient;
//	GetClientRect(&rtClient);
//	//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCmMjHpBiBeFiNhDjAjEiCpAiMhGiOfK_xHqqkZx_ -----
//	m_lColumnCount = rtClient.Width() / GetTotalItemWidth();
//	if (m_lColumnCount == 0) m_lColumnCount = 1;
//
//	// m_lColumnCount _xZkqqHx_iCmG_xHqqkZx_ m_lTextHeight _xZkqqHx_iCkKiMiIiCnMiCoKiCmO_xHqqkZx_ GetGlobalGroupRect _xZkqqHx_iCkKiMhGiOfKiJmCjEfMiBeC_xHqqkZx_
//	long lScrMax = 0;
//	if (GetGroupCount() != 0)
//	//----- _xZkqqHx_iDePiDiLiBfLiDhGiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iNmFiMoDiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
//		CRect rtLastGroup = GetGlobalGroupRect(GetGroupCount() - 1);
//		lScrMax = rtLastGroup.bottom;
//	}
//	const long lScrPage = rtClient.Height();
//	long lScrPos  = GetScrollPos(SB_VERT);
//	if (lScrMax - lScrPage + 1 < lScrPos)
//		lScrPos = lScrMax - lScrPage + 1;
//	if (lScrPos < 0) lScrPos = 0;
//
////----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	if (GetStyle() & WS_VSCROLL)
//	//----- _xZkqqHx_jAiCjClMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		if (lScrMax < lScrPage)
//			lScrMax = lScrPage;
//	}
////----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//
//	//----- _xZkqqHx_jAiCjClMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
//	SCROLLINFO	oSCInfo;
//	oSCInfo.cbSize	= sizeof(oSCInfo);
//	oSCInfo.fMask	= SIF_ALL;
//	oSCInfo.nMin	= 0;
//	oSCInfo.nMax	= lScrMax;
//	oSCInfo.nPage	= lScrPage;
//	oSCInfo.nPos	= lScrPos;
//	SetScrollInfo(SB_VERT, &oSCInfo);
//
//	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiPiJiKpKiJlL_xHqqkZx_ -----
//	oSCInfo.cbSize	= sizeof(oSCInfo);
//	oSCInfo.fMask	= SIF_ALL;
//	if (GetStyle() & WS_HSCROLL)
//	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiNoMjAkMiClHiCoJiCmMiCmNiBeBiDhNiDeFiDfIiDhKiDeDiBfLiDiLiCmMiJkBiDfIiDeOiDiNiBfLiDiLiCpA_xHqqkZx_
//		// _xZkqqHx_iDeMiDiDiDgCiDgAiClDiClJiCoJiClNiCnPiBeC_xHqqkZx_WM_HSCROLL _xZkqqHx_iCmNiBeBiJkBiDfIiDeOiDiNiBfLiDiLiJmCjEfMiCmIiDeFiDeCiDjDiDgIiDeFiCmF_xHqqkZx_
//		// _xZkqqHx_iCmIiCkPiCoKiCmOjBjHjFhEiClDiCoKiCmIiCkCiCnNiClNiCkCiBeC_xHqqkZx_
//		// _xZkqqHx_iJmCjDkOiIoGiCmGiDhJiBfLiDfHiCkKjDjJiClFiCkCiDfEiDeDiDfJiCpAjHfOiCkGiCmEiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiLkNjAkHjDeJiCmJjAlGjAkMiClDiClJiCoJiBeC_xHqqkZx_
//		oSCInfo.nMin	= 0;
//		oSCInfo.nMax	= 100;
//		oSCInfo.nPage	= 100;
//		oSCInfo.nPos	= 0;
//	} else
//	//----- _xZkqqHx_jAiFjFlNiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iJmCjDkOiIoGiCoGiCoIiDhJiBfLiDfHiCkKjBoFiCkLiCkCiDfEiDeDiDfJiCpAjHfOiCkGiCmEiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMjAlGjAkMiCpAjGgIiCkOiBeC_xHqqkZx_
//		oSCInfo.nMin	= 0;
//		oSCInfo.nMax	= 100;
//		oSCInfo.nPage	= 101;
//		oSCInfo.nPos	= 0;
//	}
//	SetScrollInfo(SB_HORZ, &oSCInfo);
////----- 06.11.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // CFCMatrixControl::CalcItemMatrix.
//----- 06.11.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::CalcIsBelongToReducedGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiA_xHqqkZx_[lItemIndexBegin, lItemIndexEnd) _xZkqqHx_iCmMiIoKjFjEiCkKiBeBiPpEiNjOiCnMiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lItemIndexBegin	:_xZkqqHx_jClCiCnHiCoJiDeBiDeDiDgFiDiAjEmNiImNiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lItemIndexEnd	:_xZkqqHx_jClCiCnHiCoJiDeBiDeDiDgFiDiAjEmNiImNiCmMiNmFiMoD_xHqqkZx_+_xZkqqHx_iCfAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPpEiNjOiCnMiCoKiClNiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::CalcIsBelongToReducedGroup (long lItemIndexBegin, long lItemIndexEnd) const
{
//----- 06.11.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const long lSelectFirst = lItemIndexBegin;
//	const long lSelectLast = lItemIndexEnd - 1;
//	if (lSelectLast < lSelectFirst)
//		FFThrowMiscUnknown();
//	long lIndexFirst = 0;
//	long lGroupIndex;
//	for (lGroupIndex = 0; lGroupIndex != GetGroupCount(); lGroupIndex++)
//	//----- _xZkqqHx_jBfDiDePiDiLiBfLiDhGiCpAiDiLiBfLiDhG_xHqqkZx_ -----
//	{
//		if (GetGroupItemCount(lGroupIndex) != 0 &&
//			!GetIsGroupExpanded(lGroupIndex))
//		//----- _xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCkKjBlGiNnNiClFiBeBiDePiDiLiBfLiDhGiCkKiPpEiCnMiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			long lIndexLast = lIndexFirst + GetGroupItemCount(lGroupIndex) - 1;
//			long lDummy;
//			// _xZkqqHx_jClCiCnHiCoJiDeBiDeDiDgFiDiAiCmGiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCmJiPgEiCmIiCoIiCkKiCkAiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
//			if (LinearOverlap(lDummy, lDummy, lSelectFirst, lSelectLast, lIndexFirst, lIndexLast))
//				return TRUE;
//		}
//		lIndexFirst += GetGroupItemCount(lGroupIndex);
//	}
//	return FALSE;
//----- 06.11.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (lItemIndexEnd <= lItemIndexBegin)
		FFThrowMiscUnknown();
	struct my
	{
		my (long lSelectFirst, long lSelectLast) :	m_lSelectFirst(lSelectFirst),
													m_lSelectLast(lSelectLast) {}
		/*************************************************************************
		 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumGroupConstProc
		 *
		 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl			:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lGroupIndex			:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDePiDiLiBfLiDhGiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			bIsExpanded			:_xZkqqHx_iDePiDiLiBfLiDhGiCkKjDfHiKeKjCiGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexBegin		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiPiJiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_
		 *								 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lItemIndexEnd		:_xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiNmFiMoDiCmMiDeBiDeDiDgFiDiAiCmM_xHqqkZx_
		 *								 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBhLiCfAiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineBegin	:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiPiJiCmMiNhDiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			lVisibleLineEnd		:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiNmFiMoDiCmMiNhDiBhLiCfAiCmMiBeBiJmCiOiLiDeBiDeDiDgFiDiA_xHqqkZx_
		 *								 _xZkqqHx_iBgJjDfHiKeKjCiGiCmMiDePiDiLiBfLiDhGiBgKiCmMiCnNiCmFjBfDjBmMiCmFiCmM_xHqqkZx_
		 *								 _xZkqqHx_iNhDiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
		 *			rtGroup				:_xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
		 *								 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
		 *								 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		 *			pData				:EnumGroupConst_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
		 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumGroupConst_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
		 *
		 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
		 *************************************************************************/
		static int EnumGroupConstProc (	const CFCMatrixControl* pControl,
										long lGroupIndex,
										BOOL bIsExpanded,
										long lItemIndexBegin,
										long lItemIndexEnd,
										long lVisibleLineBegin,
										long lVisibleLineEnd,
										const CRect& rtGroup,
										void* pData)
		{
			my* pMy = (my*)pData;
			if (lItemIndexBegin != lItemIndexEnd && !bIsExpanded)
			//----- _xZkqqHx_iDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCkKjBlGiNnNiClFiBeBiDePiDiLiBfLiDhGiCkKiPpEiCnMiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jClCiCnHiCoJiDeBiDeDiDgFiDiAiCmGiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiDeBiDeDiDgFiDiAiCmJiPgEiCmIiCoIiCkKiCkAiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
				long lDummy;
				if (::LinearOverlap(lDummy, lDummy,
									pMy->m_lSelectFirst, pMy->m_lSelectLast,
									lItemIndexBegin, long(lItemIndexEnd - 1)))
					return 1;
			}
			return 0;
		}
		const long m_lSelectFirst;
		const long m_lSelectLast;
	} data(lItemIndexBegin, lItemIndexEnd - 1);
	// _xZkqqHx_iDePiDiLiBfLiDhGiCpAjHpBiLjDiClFiCmE_xHqqkZx_EnumGroupConstProc_xZkqqHx_iCpAiDfCiBfLiDiLiClHiCoJiBeC_xHqqkZx_
	if (EnumGroupConst(my::EnumGroupConstProc, 0, &data) == 1)
		return TRUE;
	return FALSE;
//----- 06.11.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::CalcIsBelongToReducedGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::IsFrontOfRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiNmAjFfHiCkKiBeBiLoJiMgAiCmMjBePjElMiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rt	:_xZkqqHx_iLoJiMgAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pt	:_xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLoJiMgAiCmMjBePjElMiCmJiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCkKiDhNiDgHiDiKiDgCiDeOiDfIiPpDiCmJjFmAiCnEiPoKiNiHiCmNiBeBjBePjElMiCmNiLoJiMgAiNlGjBkEiClOiCkKiBeB_xHqqkZx_
 *			_xZkqqHx_iDiKiDfIiDgHiPpDiCmJjFmAiCnEiPoKiNiHiCmNiBeBjBePjElMiCmNiLoJiMgAiPoDjBkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::IsFrontOfRect (const CRect& rt, const CPoint& pt) const
{
	return (pt.x < (rt.left + rt.right) / 2);
} // CFCMatrixControl::IsFrontOfRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::PostSelChangeMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjAeNjAoGiDeFiDeCiDjDiDgIiDeFiCmJiBeBiDeBiDeDiDgFiDiAiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::PostSelChangeMessage ()
{
	if (m_wndpMsgWnd != NULL)
	{
		m_wndpMsgWnd->PostMessage(WM_USER_MTRX_SELCHANGED,
								(WPARAM)GetDlgCtrlID(), (LPARAM)GetIndexA());
	} else if (GetParent() != NULL)
	{
		GetParent()->PostMessage(WM_USER_MTRX_SELCHANGED,
								(WPARAM)GetDlgCtrlID(), (LPARAM)GetIndexA());
	}
} // CFCMatrixControl::PostSelChangeMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::PostLBtnDblClkMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjBjHjAeNjAoGiDeFiDeCiDjDiDgIiDeFiCmJiBeBiDeBiDeDiDgFiDiAiCkKiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClDiCoKiClN_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::PostLBtnDblClkMessage ()
{
	if (m_wndpMsgWnd != NULL)
	{
		m_wndpMsgWnd->PostMessage(WM_USER_MTRX_LBTN_DBLCLKED,
								(WPARAM)GetDlgCtrlID(), (LPARAM)GetIndexA());
	} else if (GetParent() != NULL)
	{
		GetParent()->PostMessage(WM_USER_MTRX_LBTN_DBLCLKED,
								(WPARAM)GetDlgCtrlID(), (LPARAM)GetIndexA());
	}
} // CFCMatrixControl::PostLBtnDblClkMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetIndexA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeBjBeJjBpAiDeBiDeDiDgFiDiAiCmNiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetIndexA () const
{
	return m_lIndexA;
} // CFCMatrixControl::GetIndexA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetIndexB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeBjBeJjBpAiDeBiDeDiDgFiDiAiCmNiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCMatrixControl::GetIndexB () const
{
	return m_lIndexB;
} // CFCMatrixControl::GetIndexB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetIndexAB
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndexA	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lIndexB	:_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_B_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bScroll	:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAiCkKiMkJiCkGiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiClHiCoJiPoKiNiH_xHqqkZx_
 *					 _xZkqqHx_iCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bPostMessage:_xZkqqHx_jFmPiNfIjCmKjCgNiDiBiDgCiDfKiBfLiDfHiCpAiDhMiDfIiDgHiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiCmFiCkLiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmGiBeBjBeJjBpAiDeBiDeDiDgFiDiAiCmNiInJiCmIiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::SetIndexAB (long lIndexA, long lIndexB, BOOL bScroll, BOOL bPostMessage)
{
//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jCfAjDmGjBeJjBpAiDiCiBfLiDgIiCmMiPoKiNiHiCmNiBeB_xHqqkZx_lIndexA == lIndexB _xZkqqHx_iCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (GetIsSingleSelect() && lIndexA != lIndexB)
		FFThrowMiscUnknown();
//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	if (lIndexA < -1 || GetItemCount() <= lIndexA) return FALSE;
	if (lIndexB < -1 || GetItemCount() <= lIndexB) return FALSE;

//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_jAfGiClFiCkCiCmMjBeJjBpAiCkKiBeBiPpEiNjOiCnMiCoKiClNiDePiDiLiBfLiDhGiCmJiKnMiCnMiCoKiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
	if (lIndexA != -1)
	{
		long lSelectFirst = lIndexA;
		long lSelectLast = lIndexB;
		if (lSelectFirst != -1)
		{
			if (lSelectLast < lSelectFirst) Exchange(lSelectLast, lSelectFirst);
			//----- _xZkqqHx_jBeJjBpAjEmNiImNiCmMiIoKjFjEiCkKiPpEiCnMiCoKiClNiDePiDiLiBfLiDhGiCmJjBkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
			if (CalcIsBelongToReducedGroup(lSelectFirst, lSelectLast + 1))
				return FALSE;
		}
	}
//----- 06.11.08 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jAfGiClFiCkCjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lIndexA = lIndexA;
	m_lIndexB = lIndexB;
	// Create_xZkqqHx_jBePiCmMiPoKiNiHiBeC_xHqqkZx_
	if (GetSafeHwnd() == NULL) return TRUE;
	if (bPostMessage)
	{
		PostSelChangeMessage();
	}
	if (!bScroll || lIndexA == -1) return TRUE;
	CRgn rgnOld;
	CRgn rgnNew;
	CRect rItem;
// 06.11.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	long lScroll;
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiPjMiCkCiClNjHeMiMpIiJoGjGmKiCpAiOoGjDlOiBeC_xHqqkZx_
	CRect rtClient;
	GetClientRect(&rtClient);
	//----- _xZkqqHx_jAfGiClFiCkC_xHqqkZx_Item_xZkqqHx_iCkKjFfMiOkGiClDiCoKiCoJiCoGiCkEiCmJiDfIiDeOiDiNiBfLiDiLiCpAjAkHiMoE_xHqqkZx_ -----
	long lOffset;
	GetItemRect(rItem, lIndexA);
	if (rItem.top < rtClient.top)
	{
		lOffset = rtClient.top - rItem.top;
//----- 06.11.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		lScroll = lOffset / (GetTotalItemHeight() / 2);
//		if (lOffset % (GetTotalItemHeight() / 2)) lScroll++;
//----- 06.11.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		OffsetScroll(lOffset);
		OffsetScroll(lOffset, TRUE);
	} else if (rtClient.bottom < rItem.bottom)
	{
// 06.11.04 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		lOffset = rItem.bottom - rtClient.bottom;
		lOffset = -(rItem.bottom - rtClient.bottom);
//----- 06.11.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		lScroll = -(lOffset / (GetTotalItemHeight() / 2));
//		if (lOffset % (GetTotalItemHeight() / 2)) lScroll--;
//----- 06.11.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		OffsetScroll(lOffset);
		OffsetScroll(lOffset, TRUE);
	}
	return TRUE;
} // CFCMatrixControl::SetIndexAB.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::IsOnSelectedItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhNiDeFiDfIiImKjChFiCmMiDeBiDeDiDgFiDiAiCkKjBeJjBpAjCiGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ptMsc	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAjCiGiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::IsOnSelectedItem (const CPoint& ptMsc) const
{
	long lIndex = PointToIndex(ptMsc);
	if (lIndex < 0) return FALSE;
	return IsSelectionMark(lIndex) ? TRUE : FALSE;
} // CFCMatrixControl::IsOnSelectedItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::IsCutMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCkKiDeKiDgCiDgHjCiGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDgCiDgHjCiGiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::IsCutMark (long lIndex) const
{
	return (GetItemState(lIndex) & FDMC_FLAG_CUT) ? TRUE : FALSE;
} // CFCMatrixControl::IsCutMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetCutMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDeBiDeDiDgFiDiAiCmMiDeKiDgCiDgHiDhNiBfLiDeOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSet	:_xZkqqHx_iDeKiDgCiDgHiCmIiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeKiDgCiDgHiJpAiPjMiCmIiCoH_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::SetCutMark (long lIndex, BOOL bSet)
{
	if (bSet)
		SetItemState(lIndex, GetItemState(lIndex) | FDMC_FLAG_CUT);
	else
		SetItemState(lIndex, GetItemState(lIndex) & ~FDMC_FLAG_CUT);
} // CFCMatrixControl::SetCutMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::IsRedrawMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCkKiNmEjFgAiJoGiDhNiBfLiDeOjAnNjCoIjCiGiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiDhNiBfLiDeOjAnNjCoIjCiGiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::IsRedrawMark (long lIndex) const
{
	return (GetItemState(lIndex) & FDMC_FLAG_REDRAW) ? TRUE : FALSE;
} // CFCMatrixControl::IsRedrawMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetRedrawMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDeBiDeDiDgFiDiAiCmMiNmEjFgAiJoGiDhNiBfLiDeOiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bSet	:_xZkqqHx_iNmEjFgAiJoGiDhNiBfLiDeOjAnNjCoIiCmIiCoH_xHqqkZx_ TRUE_xZkqqHx_iBeBiNmEjFgAiJoGiDhNiBfLiDeOiJpAiPjMiCmIiCoH_xHqqkZx_ FALSE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::SetRedrawMark (long lIndex, BOOL bSet)
{
	if (bSet)
		SetItemState(lIndex, GetItemState(lIndex) | FDMC_FLAG_REDRAW);
	else
		SetItemState(lIndex, GetItemState(lIndex) & ~FDMC_FLAG_REDRAW);
} // CFCMatrixControl::SetRedrawMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::RgnRedraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiDhNiBfLiDeOiCmMjFhEiCkCiClNiDeBiDeDiDgFiDiAiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::SendRgnRedraw ()
{
	CRgn rgn1;
	rgn1.CreateRectRgn(0,0,0,0);
	CRgn rgn2;
	BOOL bRedraw = FALSE;
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
	{
		if (IsRedrawMark(lIndex))
		{
			bRedraw = TRUE;
			CRect rtItem;
			GetItemRect(rtItem, lIndex);
			rgn2.CreateRectRgn(rtItem.left, rtItem.top,
								rtItem.right, rtItem.bottom);
			rgn1.CombineRgn(&rgn1, &rgn2, RGN_OR);
			rgn2.DeleteObject();
		}
	}
	if (bRedraw)
		RedrawWindow(NULL, &rgn1, RDW_INVALIDATE | RDW_UPDATENOW);
} // CFCMatrixControl::SendRgnRedraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::GetItemState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD CFCMatrixControl::GetItemState (long lIndex) const
{
	return m_vItem[lIndex].wState;
} // CFCMatrixControl::GetItemState.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::SetItemState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeBiDeDiDgFiDiAiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wState	:_xZkqqHx_iPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::SetItemState (long lIndex, WORD wState)
{
	m_vItem[lIndex].wState = wState;
} // CFCMatrixControl::SetItemState.

//----- 06.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnPaintSubProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OnPaint_xZkqqHx_iDfEiDhFiKnGjAjEiBeC_xHqqkZx_EnumItem_xZkqqHx_iKnGjAjEiCmMiDfCiBfLiDiLiDgPiDgCiDeOiDhGiDiNiDfGiDfHiDiDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pControl	:CFCMatrixControl_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lGroupIndex	:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDeBiDeDiDgFiDiAiCkKjBkOiClHiCoJiDePiDiLiBfLiDhGiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lItemIndex	:_xZkqqHx_jHpBiLjDjBmOiPnLiCmMiDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_jBmOiPnLiCkKiDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMiPoKiNiHiCmN_xHqqkZx_ -1 _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			rtItem		:_xZkqqHx_iClBiCmMiDeBiDeDiDgFiDiAiCmMiLoJiMgAiNmAjFfHiCpAiOhHjCoIiBeCiDePiDiNiBfLiDgPiDiL_xHqqkZx_
 *						 _xZkqqHx_iNmAjFfHiCmJiBeB_xHqqkZx_EnumItem_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClN_xHqqkZx_
 *						 _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiCpAiJmBiOfKiClFiClNjCgMiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			pData		:EnumItem_xZkqqHx_iKnGjAjEiCmMiIpIjAjEiCmFiOhHjCoIiClDiCoKiClNiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	0 _xZkqqHx_iCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAiMhAjBlBiBeC_xHqqkZx_0_xZkqqHx_iImIiKePiCpAjFnEiClHiPoKiNiHiCmNjHpBiLjDiCpAjCiGjCgGiBeC_xHqqkZx_
 *			_xZkqqHx_jFnEjCgMiCmN_xHqqkZx_EnumItem_xZkqqHx_iKnGjAjEiCmMjFnEjCgMiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCMatrixControl::OnPaintSubProc (	CFCMatrixControl* pControl,
										long lGroupIndex,
										long lItemIndex,
										const CRect& rtItem,
										void* pData)
{
	CDC* pDC = NULL;
	FCAutoDC* pAtDC = NULL;
	FC2Ref<CDC*, FCAutoDC*>(pDC, pAtDC) = *((FC2Fold<CDC*, FCAutoDC*>*)pData);
	CRect rtClient;
	pControl->GetClientRect(&rtClient);
	// _xZkqqHx_jFgAiJoGjBmOiPnLiDeBiDeDiDgFiDiAiCkKiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCoGiCoIiJlKiCmJ_xHqqkZx_
	// _xZkqqHx_iCkAiCoJiPoKiNiHiCmNjFgAiJoGiPiIjHjNiCpAiPeJjHlJiBeC_xHqqkZx_
	if (rtClient.bottom < rtItem.top)
		return 1;
	// _xZkqqHx_jFgAiJoGjBmOiPnLiDeBiDeDiDgFiDiAiCkKiDeOiDiJiDeDiDeBiDjDiDgHjHmMiIoGiCmGiPgEiCmIiCoHiCmIiCkC_xHqqkZx_
	// _xZkqqHx_iPoKiNiHiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
	if ((rtItem & rtClient).IsRectNull()) return 0;

	// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiOmAiNnLiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
	CRect rtItemInner(rtItem);
	rtItemInner.DeflateRect(FDMC_SPACE_X / 2, FDMC_SPACE_Y / 2);
	if (lItemIndex == -1)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPjFgAiJoGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jEhHiMgJiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
		pAtDC->FillRect(rtItemInner,
						FCAtBrush(g_pReg->GetOptiRegColor(FDCL_MATRIX_GROUP_BACKGROUND)));
		// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtGroupText(rtItemInner);
		rtGroupText.left = rtItemInner.left + rtItemInner.Height() + FDMC_GROUP_MARGIN;
		// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
		pAtDC->SetTextColor(g_pReg->GetOptiRegColor(FDCL_MATRIX_GROUP_TEXT));
		// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiBeC_xHqqkZx_
		pAtDC->DrawText(pControl->GetGroupName(pControl->GetGroupData(lGroupIndex)),
						CP_ACP,
						rtGroupText,
						DT_SINGLELINE|DT_LEFT|DT_VCENTER);
		// _xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMiOpMiImNiLoJiMgAiCpAjFgAiJoGiBeC_xHqqkZx_
		pAtDC->DrawEdge(rtItemInner,
						1,
						g_pReg->GetOptiRegColor(FDCL_MATRIX_LIGHT),
						g_pReg->GetOptiRegColor(FDCL_MATRIX_SHADOW));
		// _xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiCmMjDfHiKeKiDhLiDfOiDjDjHmMiIoGiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtExtImage(rtItemInner);
		rtExtImage.right = rtItemInner.left + rtItemInner.Height();
		rtExtImage.DeflateRect(FDMC_GROUP_MARGIN, FDMC_GROUP_MARGIN);
		CPoint ptCross[6];
		//----- _xZkqqHx_iImIiJlKiCmNiBhLiBgJiBhMiBgKiLeMiNiG_xHqqkZx_ -----
		ptCross[0].x = rtExtImage.left;
		ptCross[0].y = (rtExtImage.top + rtExtImage.bottom) / 2;
		ptCross[1].x = rtExtImage.right;
		ptCross[1].y = ptCross[0].y;
		ptCross[2].x = (rtExtImage.left + rtExtImage.right) / 2;
		ptCross[2].y = rtExtImage.top;
		ptCross[3].x = ptCross[2].x;
		ptCross[3].y = rtExtImage.bottom;
		//----- _xZkqqHx_iImIiJlKiCmNjDfHiKeKiDhLiDfOiDjDiCmGiDgFiDeMiDfIiDgHiCmMiLkLiKeFjApM_xHqqkZx_ -----
		ptCross[4].x = rtItemInner.left + rtItemInner.Height();
		ptCross[4].y = rtItemInner.top + 1;
		ptCross[5].x = ptCross[4].x;
		ptCross[5].y = rtItemInner.bottom - 1;

		FCAtPen penLight(PS_SOLID, 1, g_pReg->GetOptiRegColor(FDCL_MATRIX_LIGHT));
		FCAtPen penShadow(PS_SOLID, 1, g_pReg->GetOptiRegColor(FDCL_MATRIX_SHADOW));

		if (pControl->GetIsGroupExpanded(lGroupIndex))
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjDfHiKeKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iBhMiLeMiNiGiCmMiImDjApMiCmMjFgAiJoG_xHqqkZx_ -----
			pAtDC->SetObject(penShadow);
			pAtDC->MoveTo(ptCross[0]);
			pAtDC->LineTo(ptCross[1]);
			pAtDC->MoveTo(ptCross[4]);
			pAtDC->LineTo(ptCross[5]);
			//----- _xZkqqHx_iBhMiLeMiNiGiCmMjGlOjApMiCmMjFgAiJoG_xHqqkZx_ -----
			pAtDC->SetObject(penLight);
			pAtDC->MoveTo(ptCross[0] + CSize(1,1));
			pAtDC->LineTo(ptCross[1] + CSize(1,1));
		} else
		//----- _xZkqqHx_iDePiDiLiBfLiDhGjEpBjDfHiKeKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iBhLiLeMiNiGiCmMiImDjApMiCmMjFgAiJoG_xHqqkZx_ -----
			pAtDC->SetObject(penShadow);
			pAtDC->MoveTo(ptCross[0]);
			pAtDC->LineTo(ptCross[1]);
			pAtDC->MoveTo(ptCross[2]);
			pAtDC->LineTo(ptCross[3]);
			pAtDC->MoveTo(ptCross[4]);
			pAtDC->LineTo(ptCross[5]);
			//----- _xZkqqHx_iBhLiLeMiNiGiCmMjGlOjApMiCmMjFgAiJoG_xHqqkZx_ -----
			pAtDC->SetObject(penLight);
			pAtDC->MoveTo(ptCross[0] + CSize(1,1));
			pAtDC->LineTo(ptCross[1] + CSize(1,1));
			pAtDC->MoveTo(ptCross[2] + CSize(1,1));
			pAtDC->LineTo(ptCross[3] + CSize(1,1));
		}
	} else
	//----- _xZkqqHx_iDeBiDeDiDgFiDiAjFgAiJoGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDiBiBfLiDfHjHmMiIoGiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtItemImage(rtItemInner);
		rtItemImage.DeflateRect(FDMC_EDGE_W, FDMC_EDGE_W);
		rtItemImage.bottom -= pControl->GetTotalTextHeight();
		// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDgFiDeMiDfIiDgHjHmMiIoGiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtItemText(rtItemInner);
		rtItemText.DeflateRect(FDMC_EDGE_W, FDMC_EDGE_W);
		rtItemText.top = rtItemImage.bottom;
		rtItemText.DeflateRect(FDMC_TEXT_MARGIN, FDMC_TEXT_MARGIN);

		//----- Item_xZkqqHx_iCmMiOgMiLpHiCmMiNmAjFfHiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
		if (pDC->RectVisible(rtItem))
		{
			// _xZkqqHx_iDhAiDfOiBfLiDjDiCmJiCoGiCoJjDgIiCoIiCmCiCnEiClFiCmMjHmMiIoGiBeC_xHqqkZx_
			// _xZkqqHx_iDhAiDfOiBfLiDjDjFgAiJoGiBeC_xHqqkZx_
			pControl->DrawItem(lItemIndex, pControl->GetItemData(lItemIndex), &rtItemImage, pDC);
			// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			pAtDC->SetTextColor(g_pReg->GetOptiRegColor(FDCL_MATRIX_TEXT));
			// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiBeC_xHqqkZx_
			pAtDC->DrawText(pControl->GetName(pControl->GetItemData(lItemIndex)),
							CP_ACP,
							rtItemText,
							DT_SINGLELINE|DT_LEFT|DT_VCENTER);
			// _xZkqqHx_iDeHiDgCiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
			pAtDC->DrawEdge(rtItemInner,
							-1,
							g_pReg->GetOptiRegColor(FDCL_MATRIX_LIGHT),
							g_pReg->GetOptiRegColor(FDCL_MATRIX_SHADOW));
			if (pControl->IsSelectionMark(lItemIndex))
			//----- _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjBeJjBpAiPpDjBnEiCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCmMiLoJiMgAiCpAiOfKiPgPiBeC_xHqqkZx_
				CRect rtSelRect = rtItemInner;
				rtSelRect.DeflateRect(FDMC_EDGE_W, FDMC_EDGE_W);
				// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
				FCAutoDC atDCSub(pDC, FALSE, 0, 0);
				//----- _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ -----
				atDCSub.SetPen(PS_SOLID, 2, g_pReg->GetOptiRegColor(FDCL_MATRIX_SELECTION));
				atDCSub.MoveTo(rtSelRect.left, rtSelRect.top);
				atDCSub.LineTo(rtSelRect.right, rtSelRect.top);
				atDCSub.LineTo(rtSelRect.right, rtSelRect.bottom);
				atDCSub.LineTo(rtSelRect.left, rtSelRect.bottom);
				atDCSub.LineTo(rtSelRect.left, rtSelRect.top);
			}
		}
	}
	return 0;
} // CFCMatrixControl::OnPaintSubProc.
//----- 06.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// CFCMatrixControl _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnLButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPpDjBnEjDjJiCpAiOkGiClHiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCjFkIjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnLButtonDown (UINT nFlags, CPoint point)
{
	TRACE(_T("CFCMatrixControl::OnLButtonDown\n"));
	// _xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	if (GetFocus() != this) (void)SetFocus();

//----- 06.11.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
//	OnMsEvent(GetCurrentMessage()->message, point, nFlags);
//----- 06.11.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lGroupIndex;
	long lItemIndex;
	if (PointToIndex(lGroupIndex, lItemIndex, point) &&
		lItemIndex == -1)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPjCiGiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ ------
	{
		SetIsGroupExpanded(lGroupIndex, !GetIsGroupExpanded(lGroupIndex));
		UpdateScrollSize(TRUE);
	} else
	//----- _xZkqqHx_iDePiDiLiBfLiDhGiDhHiDgCiDfPiKePiCpAiDeOiDiKiDgCiDeOiCmMiPoKiNiH_xHqqkZx_ ------
	{
		TRACE(_T("CFCMatrixControl::OnLButtonDown A\n"));
		// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
		OnMsEvent(GetCurrentMessage()->message, point, nFlags);
	}
//----- 06.11.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

} // CFCMatrixControl::OnLButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnLButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCkKjHkDiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPpDjBnEjDjJiCpAiOkGiClHiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCjFkIjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnLButtonUp (UINT nFlags, CPoint point)
{
	TRACE(_T("CFCMatrixControl::OnLButtonUp\n"));
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
	OnMsEvent(GetCurrentMessage()->message, point, nFlags);
} // CFCMatrixControl::OnLButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnLButtonDblClk
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiNlGiDhLiDfOiDjDiCpAiDfPiDhFiDiLiDeOiDiKiDgCiDeOiClFiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPpDjBnEjDjJiCpAiOkGiClHiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCjFkIjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnLButtonDblClk (UINT nFlags, CPoint point)
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
	OnMsEvent(GetCurrentMessage()->message, point, nFlags);
} // CFCMatrixControl::OnLButtonDblClk.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnRButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiJeFiDhLiDfOiDjDiCpAiJjPiClFiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPpDjBnEjDjJiCpAiOkGiClHiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCjFkIjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnRButtonDown (UINT nFlags, CPoint point)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnRButtonDown(nFlags, point);
	// _xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	if (GetFocus() != this) (void)SetFocus();
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
	OnMsEvent(GetCurrentMessage()->message, point, nFlags);
} // CFCMatrixControl::OnRButtonDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnRButtonUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiJeFiDhLiDfOiDjDiCpAjHkDiClFiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPpDjBnEjDjJiCpAiOkGiClHiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCjFkIjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnRButtonUp (UINT nFlags, CPoint point)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnRButtonUp(nFlags, point);
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
	OnMsEvent(GetCurrentMessage()->message, point, nFlags);
} // CFCMatrixControl::OnRButtonUp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnMouseMove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiCkKiInKjDkOiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiClNiDeMiBfLiCmMiPpDjBnEjDjJiCpAiOkGiClHiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiBeCjFkIjHjNiNmAjFfHiMgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnMouseMove (UINT nFlags, CPoint point)
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
	OnMsEvent(GetCurrentMessage()->message, point, nFlags);
} // CFCMatrixControl::OnMouseMove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnContextMenu
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiBeBiIlNiCkCiCmNiDiBiDgKiDiFiBfLiDeMiBfLiCmJiCoGiCmBiCmEiLeOjDkOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJeFiDhLiDfOiDjDiDeOiDiKiDgCiDeOiCmFiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pWnd	:_xZkqqHx_iJeFiDhLiDfOiDjDiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			point	:_xZkqqHx_iDeOiDiKiDgCiDeOiClFiClNiNmAjFfHiBgJiDfIiDeOiDiKiBfLiDjDiNmAjFfHiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnContextMenu (CWnd* pWnd, CPoint point)
{
	// _xZkqqHx_iDiBiDgCiDfKiBfLiDfHiPiIjHjNiBeC_xHqqkZx_
	OnMsEvent(GetCurrentMessage()->message, point, 0);
} // CFCMatrixControl::OnContextMenu.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnKeyDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiCkKiJjPiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnKeyDown (UINT nChar, UINT nRepCnt, UINT nFlags)
{
//----- 06.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDeDiDgFiDiAiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
//	if (GetItemCount() == 0) return;
//	long lIndexA = GetIndexA();
//	if (lIndexA == -1) lIndexA = 0;
//	long lIndexB = GetIndexB();
//	if (lIndexB == -1) lIndexB = 0;
//	long lNewIdx;
//	switch (nChar)
//	{
//	case VK_LEFT:
//		lNewIdx = lIndexA - 1;
//		break;
//	case VK_UP:
//		lNewIdx = lIndexA - m_lColumnCount;
//		break;
//	case VK_RIGHT:
//		lNewIdx = lIndexA + 1;
//		break;
//	case VK_DOWN:
//		lNewIdx = lIndexA + m_lColumnCount;
//		break;
//	case VK_PRIOR:
//	  {
//		CRect rtClient;
//		GetClientRect(&rtClient);
//		lNewIdx = GetIndexA() - (rtClient.Height() / GetItemHeight()) * m_lColumnCount;
//		break;
//	  }
//	case VK_NEXT:
//	  {
//		CRect rtClient;
//		GetClientRect(&rtClient);
//		lNewIdx = GetIndexA() + (rtClient.Height() / GetItemHeight()) * m_lColumnCount;
//		break;
//	  }
//	default:
//		OnKyEvent(GetCurrentMessage()->message, nChar, nFlags);
//		return;
//	}
//	if (lNewIdx < 0) lNewIdx = 0;
//	if (GetItemCount() <= lNewIdx) lNewIdx = GetItemCount() - 1;
//	// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiCmMiPoKiNiHiCmNjEmNiImNjBeJjBpAiBeC_xHqqkZx_
//	if (GetKeyState(VK_SHIFT) < 0)
//		SetSelect(lNewIdx, lIndexB, TRUE, TRUE);
//	else
//		SetCurSel(lNewIdx, TRUE, TRUE);
//----- 06.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFpLiMpMiDeMiBfLiCmG_xHqqkZx_PageUp/Down_xZkqqHx_iCmMiCnNiCmJiNgJiCoJiBeC_xHqqkZx_
	switch (nChar)
	{
	case VK_LEFT:
	case VK_UP:
	case VK_RIGHT:
	case VK_DOWN:
	case VK_PRIOR:
	case VK_NEXT:
		break;
	default:
		OnKyEvent(GetCurrentMessage()->message, nChar, nFlags);
		return;
	}
	long lIndexNewA;
	long lLine;
	long lColumn;
	if (GetIndexA() != -1 &&
		IndexToVisibleLineColumn(lLine, lColumn, GetIndexA()) == REGAL_INDEX)
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJiBgJ_xHqqkZx_IndexA_xZkqqHx_iCkKjHeMiMpIiBgKiPoKiNiH_xHqqkZx_ ----
	{
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNiCiClDiCkJiCoH_xHqqkZx_1_xZkqqHx_iDhJiBfLiDfHiCmMiInKjDkOjHmKiCpAiOfKiPgPiBeC_xHqqkZx_
		CRect rtClient;
		GetClientRect(&rtClient);
		long lPageMove = (rtClient.Height() / GetTotalItemHeight()) / 2;
		if (lPageMove == 0) lPageMove = 1;
		for (;;)
		{
			switch (nChar)
			{
			case VK_LEFT:	// _xZkqqHx_iNlGiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				lColumn--;
				break;
			case VK_UP:		// _xZkqqHx_iPoDiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				lLine--;
				break;
			case VK_RIGHT:	// _xZkqqHx_iJeFiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				lColumn++;
				break;
			case VK_DOWN:	// _xZkqqHx_iJlKiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				lLine++;
				break;
			case VK_PRIOR:	// PageUp_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				lLine -= lPageMove;
				lPageMove = 1;
				break;
			case VK_NEXT:	// PageDown_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				lLine += lPageMove;
				lPageMove = 1;
				break;
			}
			if (lColumn == -1)
			//----- _xZkqqHx_iMhGiOfKiCmFjHpBiCkKiDeBiDjDiDfPiBfLiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				lLine--;
				lColumn = GetColumnCount() - 1;
			} else
			if (lColumn == GetColumnCount())
			//----- _xZkqqHx_iMhGiOfKiCmFjHpBiCkKiDeJiBfLiDgPiBfLiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				lLine++;
				lColumn = 0;
			}
			if (lLine < 0)
			//----- _xZkqqHx_iMhGiOfKiCmFiNhDiCkKiDeBiDjDiDfPiBfLiClFiClNiPoKiNiH_xHqqkZx_ -----
			{
				lIndexNewA = -1;
				break;
			}
			// _xZkqqHx_iJmCiOiLiDeBiDeDiDgFiDiAiCmMiCnNiCmMiDhNiDgHiDiKiDgCiDeOiDfIjCiGiCmFiCmMiNhDiCmGjHpBiCpAiOhHjCoIiClFiCmEiBeB_xHqqkZx_
			// _xZkqqHx_iDeBiDeDiDgFiDiAiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
			// lLine_xZkqqHx_iCmMiDeJiBfLiDgPiBfLiCmNiClBiClBiCmFiMjPiPgPiCmFiCkLiCoJiBeC_xHqqkZx_
			FTIndexTo indexTo = VisibleLineColumnToIndex(lIndexNewA, lLine, lColumn);
			if (indexTo == REGAL_INDEX)
				break;
			if (indexTo != INTERVAL_INDEX)
			//----- _xZkqqHx_iDePiDiLiBfLiDhGiKnEiMiEiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
			{
				lIndexNewA = -1;
				break;
			}
		}
		if (lIndexNewA == -1)
		//----- _xZkqqHx_jAfGiClFiCkCjBeJjBpAiImKjChFiCkKiMhGiOfKiCmFiCkLiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			switch (nChar)
			{
			case VK_PRIOR:	// PageUp_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				// _xZkqqHx_iNmFiPiJiCmMiJmCiOiLiDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
				lIndexNewA = GetFirstVisibleItemIndex();
				break;
			case VK_NEXT:	// PageDown_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				// _xZkqqHx_iNmFiMoDiCmMiJmCiOiLiDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
				lIndexNewA = GetLastVisibleItemIndex();
				break;
			}
		}
	} else
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCmIiCkCiBgJ_xHqqkZx_IndexA_xZkqqHx_iCkKjGlDiMpIiBgKiPoKiNiH_xHqqkZx_ ----
	{
		switch (nChar)
		{
		case VK_LEFT:	// _xZkqqHx_iNlGiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
		case VK_UP:		// _xZkqqHx_iPoDiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
		case VK_PRIOR:	// PageUp_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iNmFiMoDiCmMiJmCiOiLiDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
			lIndexNewA = GetLastVisibleItemIndex();
			break;
		case VK_RIGHT:	// _xZkqqHx_iJeFiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
		case VK_DOWN:	// _xZkqqHx_iJlKiDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
		case VK_NEXT:	// PageDown_xZkqqHx_iDeMiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iNmFiPiJiCmMiJmCiOiLiDeBiDeDiDgFiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
			lIndexNewA = GetFirstVisibleItemIndex();
			break;
		}
	}
	if (lIndexNewA != -1)
	//----- _xZkqqHx_jAfGiClFiCkCjBeJjBpAiImKjChFiCkKiMhGiOfKiCmFiCkLiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFkBjAjEjBeJjBpAiDiCiBfLiDgIiBjFiDfGiDhEiDgHiDeMiBfLiCmMiPoKiNiHiCmNjEmNiImNjBeJjBpAiBeC_xHqqkZx_
		if (!GetIsSingleSelect() && GetKeyState(VK_SHIFT) < 0)
		{
			long lIndexNewB = (GetIndexB() == -1) ? lIndexNewA : GetIndexB();
			SetSelect(lIndexNewA, lIndexNewB, TRUE, TRUE);
		} else
		{
			SetCurSel(lIndexNewA, TRUE, TRUE);
		}
	}
//----- 06.11.08 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // CFCMatrixControl::OnKeyDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiOjOiCmJiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnPaint ()
{
	// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	CPaintDC dc(this);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(&dc, FALSE, 0, 0);

	// _xZkqqHx_iNmEjFgAiJoGjHmMiIoGiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	CRect rtClipBox;
	dc.GetClipBox(rtClipBox);
	// _xZkqqHx_jFfMiOkGjHhAiDhEiDeIiDjDiDgHiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
	FCAtFont font;
// 06.11.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	g_pReg->InitRegFont(*font.Get(), FDFT_WND_MATRIX);
	g_pReg->InitRegFont(*font.Get(), FDFT_MATRIX_TITLE);
	atDC.SetObject(font);
	atDC.SetBkMode(TRANSPARENT);	// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiOjOiCmJjDkHiJnPiCmJiBeC_xHqqkZx_
//----- 06.11.05 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgFiDeMiDfIiDgHjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
//	atDC.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
//----- 06.11.05 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jEhHiMgJiCpAjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
	atDC.FillRect(rtClipBox, FCAtBrush(g_pReg->GetOptiRegColor(FDCL_MATRIX_BACKGROUND)));

//----- 06.11.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiNiCiClDiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//	TEXTMETRIC tmMetrics;
//	dc.GetTextMetrics(&tmMetrics);
//	long lFontH = tmMetrics.tmAscent + tmMetrics.tmDescent;
//----- 06.11.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
//	{
//		// _xZkqqHx_iNmEjFgAiJoGiDhNiDfIiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
//		SetRedrawMark(lIndex, FALSE);
//		//----- Item_xZkqqHx_iCmMiOgMiLpHiCmMiNmAjFfHiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//		CRect rtItem;
//		GetItemRect(rtItem, lIndex);
//		long lX = rtItem.left;
//		long lY = rtItem.top;
//		if (dc.RectVisible(rtItem))
//		{
//			// _xZkqqHx_iDhAiDfOiBfLiDjDiCmJiCoGiCoJjDgIiCoIiCmCiCnEiClFiCmMjHmMiIoGiBeC_xHqqkZx_
//			rtItem.SetRect(lX + FDMC_EDGE_W + 3, lY + FDMC_EDGE_W + 3,
//							lX + GetItemWidth() - FDMC_EDGE_W - 3,
//							lY + GetItemHeight() - FDMC_EDGE_W - lFontH - 3);
//			// _xZkqqHx_iDhAiDfOiBfLiDjDjFgAiJoGiBeC_xHqqkZx_
//			DrawItem(lIndex, GetItemData(lIndex), &rtItem, &dc);
//			// _xZkqqHx_iDhAiDfOiBfLiDjDjGlMiCpAjFfMiOkGiClHiCoJiDgFiDeMiDfIiDgHjHmMiIoGiCpAjAnNjCoIiBeC_xHqqkZx_
//			rtItem.SetRect(lX + FDMC_EDGE_W + 3,
//							lY + GetItemHeight() - FDMC_EDGE_W - lFontH - 2,
//							lX + GetItemWidth() - FDMC_EDGE_W - 3,
//							lY + GetItemHeight() - FDMC_EDGE_W - 3);
//			// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiBeC_xHqqkZx_
//			atDC.DrawText(GetName(GetItemData(lIndex)), CP_ACP, &rtItem, DT_LEFT);
//			// _xZkqqHx_iDeHiDgCiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
//			rtItem.SetRect(lX, lY, lX + GetItemWidth(), lY + GetItemHeight());
//			atDC.DrawEdge(&rtItem, EDGE_SUNKEN, BF_RECT);
//			if (IsSelectionMark(lIndex))
//			{
//				CRect rtSelRect = rtItem;
//				rtSelRect.DeflateRect(FDMC_EDGE_W, FDMC_EDGE_W);
//				// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
//				FCAutoDC atDCSub(&dc, FALSE, 0, 0);
//				atDCSub.SetPen(PS_SOLID, 2, ::GetSysColor(COLOR_HIGHLIGHT));
//				atDCSub.MoveTo(rtSelRect.left, rtSelRect.top);
//				atDCSub.LineTo(rtSelRect.right, rtSelRect.top);
//				atDCSub.LineTo(rtSelRect.right, rtSelRect.bottom);
//				atDCSub.LineTo(rtSelRect.left, rtSelRect.bottom);
//				atDCSub.LineTo(rtSelRect.left, rtSelRect.top);
//			}
//		}
//	}
//----- 06.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.11.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	struct my
//	{
//		my (CDC& dc, FCAutoDC& atDC) : m_dc(dc), m_atDC(atDC) {}
//		static int EnumItemProc (CFCMatrixControl* pControl,
//								long lGroupIndex,
//								long lItemIndex,
//								const CRect& rtItem,
//								void* pData)
//		{
//			my* pMy = (my*)pData;
//			// _xZkqqHx_iNmEjFgAiJoGiDhNiDfIiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
//			pControl->SetRedrawMark(lItemIndex, FALSE);
//			//----- Item_xZkqqHx_iCmMiOgMiLpHiCmMiNmAjFfHiCpAiLiBiCnPiCoJ_xHqqkZx_ -----
//			long lX = rtItem.left;
//			long lY = rtItem.top;
//			if (pMy->m_dc.RectVisible(rtItem))
//			{
//				// _xZkqqHx_iDhAiDfOiBfLiDjDiCmJiCoGiCoJjDgIiCoIiCmCiCnEiClFiCmMjHmMiIoGiBeC_xHqqkZx_
//				CRect rtFrame(	lX + FDMC_EDGE_W + 3,
//								lY + FDMC_EDGE_W + 3,
//								lX + pControl->GetItemWidth() - FDMC_EDGE_W - 3,
//								lY + pControl->GetItemHeight() - FDMC_EDGE_W - lFontH - 3);
//				// _xZkqqHx_iDhAiDfOiBfLiDjDjFgAiJoGiBeC_xHqqkZx_
//				pControl->DrawItem(lItemIndex, pControl->GetItemData(lItemIndex), &rtFrame, &pMy->m_dc);
//				// _xZkqqHx_iDhAiDfOiBfLiDjDjGlMiCpAjFfMiOkGiClHiCoJiDgFiDeMiDfIiDgHjHmMiIoGiCpAjAnNjCoIiBeC_xHqqkZx_
//				rtFrame.SetRect(lX + FDMC_EDGE_W + 3,
//								lY + pControl->GetItemHeight() - FDMC_EDGE_W - lFontH - 2,
//								lX + pControl->GetItemWidth() - FDMC_EDGE_W - 3,
//								lY + pControl->GetItemHeight() - FDMC_EDGE_W - 3);
//				// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiBeC_xHqqkZx_
//				pMy->m_atDC.DrawText(pControl->GetName(pControl->GetItemData(lItemIndex)), CP_ACP, &rtFrame, DT_LEFT);
//				// _xZkqqHx_iDeHiDgCiDfHiCpAjFgAiJoGiBeC_xHqqkZx_
//				rtFrame.SetRect(lX, lY, lX + pControl->GetItemWidth(), lY + pControl->GetItemHeight());
//				pMy->m_atDC.DrawEdge(&rtFrame, EDGE_SUNKEN, BF_RECT);
//				if (pControl->IsSelectionMark(lItemIndex))
//				{
//					CRect rtSelRect = rtFrame;
//					rtSelRect.DeflateRect(FDMC_EDGE_W, FDMC_EDGE_W);
//					// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
//					FCAutoDC atDCSub(&pMy->m_dc, FALSE, 0, 0);
//					atDCSub.SetPen(PS_SOLID, 2, ::GetSysColor(COLOR_HIGHLIGHT));
//					atDCSub.MoveTo(rtSelRect.left, rtSelRect.top);
//					atDCSub.LineTo(rtSelRect.right, rtSelRect.top);
//					atDCSub.LineTo(rtSelRect.right, rtSelRect.bottom);
//					atDCSub.LineTo(rtSelRect.left, rtSelRect.bottom);
//					atDCSub.LineTo(rtSelRect.left, rtSelRect.top);
//				}
//			}
//		}
//		CDC&		m_dc;
//		FCAutoDC&	m_atDC;
//	} data(dc, atDC);
//----- 06.11.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jBfDiCmEiCmMiNmEjFgAiJoGiDhNiDfIiDeOiCpAiJpAiPjMiBeC_xHqqkZx_
	for (long lIndex = 0; lIndex < GetItemCount(); lIndex++)
		SetRedrawMark(lIndex, FALSE);
	// _xZkqqHx_iDeBiDeDiDgFiDiAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
	if (GetGroupCount() != 0)
		EnumItem(OnPaintSubProc,
				-GetScrollPos(SB_VERT),
				0,
				-1,
				&(FC2Fold<CDC*, FCAutoDC*>(&dc, &atDC)));
//----- 06.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jFgAiJoGjHhAiDiBiDgCiDfKiBfLiDfHiCmGiClFiCmE_xHqqkZx_ CWnd::OnPaint() _xZkqqHx_iCpAiMmEiCnBiPgPiClFiCmEiCmNiCkCiCkPiCnMiClJiCpB_xHqqkZx_
} // CFCMatrixControl::OnPaint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnSetFocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpMjHmNiDhEiDeIiBfLiDeKiDfIiCpAiOpDiCkPiOoGiCmBiClNiMoDiBeBiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDiBiDjDiDgPiKnGjAjEiCkKiMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pOldWnd	:_xZkqqHx_iClBiCmMiDeFiDeCiDjDiDgIiDeFiCmJiDhEiDeIiBfLiDeKiDfIiCpAiPpHiCmBiClNiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnSetFocus (CWnd* pOldWnd)
{
	// IME_xZkqqHx_iCpAjFmCiClGiCoJiBeC_xHqqkZx_
	::CloseImeStatus(m_hWnd);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSetFocus(pOldWnd);
} // CFCMatrixControl::OnSetFocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnKillFocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpMjHmNiDhEiDeIiBfLiDeKiDfIiCpAiOlIiCkEjClMjBePiCmJiBeBiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkJiCoHiClBiCmMiDiBiDjDiDgPiKnGjAjEiCkK_xHqqkZx_
 *			_xZkqqHx_iMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pNewWnd	:_xZkqqHx_jAfGiClNiCmJiDhEiDeIiBfLiDeKiDfIiCpAjDlOiCoJiDeFiDeCiDjDiDgIiDeFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnKillFocus (CWnd* pNewWnd)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnKillFocus(pNewWnd);
} // CFCMatrixControl::OnKillFocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCmMiDfEiDeDiDfJiCkKjFmPiNfIiClDiCoKiClNiMoDiBeBiDhEiDiMiBfLiDiAiDiPiBfLiDeOiCkJiCoHiClBiCmM_xHqqkZx_
 *			_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCkKiMmEiCnBiPgPiClDiCoKiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiCmMiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			cx		:_xZkqqHx_jAfGiClFiCkCjFjNiCpAiOhHjCoIiBeC_xHqqkZx_
 *			cy		:_xZkqqHx_jAfGiClFiCkCiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnSize (UINT nType, int cx, int cy)
{
	BASE_CLASS::OnSize(nType, cx, cy);
//----- 06.11.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCpAiPjMiCkCiClNjHeMiMpIiJoGjGmKiCpAiOoGjDlOiBeC_xHqqkZx_
//	CRect rtClient;
//	GetClientRect(&rtClient);
//	if (m_bIs1StOnSize)
//	// _xZkqqHx_iNmFiPiJiCmMiDiKiDfEiDeDiDfJiCmMiPoKiNiHiBeC_xHqqkZx_
//	{
//		m_bIs1StOnSize = FALSE;
//		// _xZkqqHx_iNmFiPiJiCmMiDiKiDfEiDeDiDfJiCmFiDeBiDeDiDgFiDiAiCmMjBoFiCkLiClDiCpAiMiIjCoIiClHiCoJiBeC_xHqqkZx_
//		ItemSize(m_lItemW, m_lItemH, rtClient.right, rtClient.bottom);
//	}
//----- 06.11.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDeBiDeDiDgFiDiAiDfEiDeDiDfJiCpAiMhGiOfKiBeC_xHqqkZx_
	UpdateItemSize();
//----- 06.11.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
// 06.11.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	CalcItemMatrix();
	UpdateScrollSize(FALSE);
} // CFCMatrixControl::OnSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnVScroll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAiCjClMjFpLiMpMiCmMiDfIiDeOiDiNiBfLiDiLiDgPiBfLiCkKjBiAiNoMiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nPos	:_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiImKjChFiCpAiOhHjCoIiBeCjCgMiCkKjGlDiMpIiCmMiPoKiNiHiCkKiCkAiCoJiCmMiCmFjCiNiInDiBeC_xHqqkZx_
 *			pScrollBar:_xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDgPiBfLiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.04 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnVScroll (UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// nPos_xZkqqHx_iCmN_xHqqkZx_SB_THUMBPOSITION_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_SB_THUMBTRACK_xZkqqHx_iCmMiOjOiCmMiCnNjHeMiMpIiBeC_xHqqkZx_

	long lNewPos;
	SCROLLINFO	oSCInfo;
	GetScrollInfo(SB_VERT, &oSCInfo);
	long lScrPos	= oSCInfo.nPos;
	long lScrMax	= oSCInfo.nMax;
	long lScrPage	= oSCInfo.nPage;
	switch (nSBCode)
	{
	case SB_BOTTOM:
		// _xZkqqHx_iIoKjEnEiJlKiCnMiCmFiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		TRACE(_T("SB_BOTTOM\n"));
		lNewPos	= lScrMax - lScrPage + 1;
		break;
	case SB_ENDSCROLL:
		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiPeJjHlJiBeC_xHqqkZx_
		TRACE(_T("SB_ENDSCROLL\n"));
		lNewPos	= lScrPos;
		break;
	case SB_LINEDOWN:
		// 1 _xZkqqHx_iNhDiJlKiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		TRACE(_T("SB_LINEDOWN\n"));
		lNewPos	= lScrPos + 1;
		break;
	case SB_LINEUP:
		// 1 _xZkqqHx_iNhDiPoDiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		TRACE(_T("SB_LINEUP\n"));
		lNewPos	= lScrPos - 1;
		break;
	case SB_PAGEDOWN:
		// 1 _xZkqqHx_iDhJiBfLiDfHiJlKiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		TRACE(_T("SB_PAGEDOWN\n"));
		lNewPos	= lScrPos + lScrPage;
		break;
	case SB_PAGEUP:
		// 1 _xZkqqHx_iDhJiBfLiDfHiPoDiCnGiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		TRACE(_T("SB_PAGEUP\n"));
		lNewPos	= lScrPos - lScrPage;
		break;
	case SB_THUMBPOSITION:
		// _xZkqqHx_jAoCjBmOiImKjChFiCnGiDfIiDeOiDiNiBfLiDiLiBeCiMlLiNnNiImKjChFiCmN_xHqqkZx_ nPos _xZkqqHx_iCmFjCpBiLjPiBeC_xHqqkZx_
		TRACE(_T("SB_THUMBPOSITION\n"));
		lNewPos	= nPos;
		break;
	case SB_THUMBTRACK:
		// _xZkqqHx_iOhHjCoIiImKjChFiCnGiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ _xZkqqHx_iDhLiDgCiDeOiDfIiCpAiDgIiDiJiDgCiDePiBeCiMlLiNnNiImKjChFiCmN_xHqqkZx_ nPos _xZkqqHx_iCmFjCpBiLjPiBeC_xHqqkZx_
		TRACE(_T("SB_THUMBTRACK\n"));
		lNewPos	= nPos;
		break;
	case SB_TOP:
		// _xZkqqHx_iIoKjEnEiPoDiCnMiCmFiDfIiDeOiDiNiBfLiDiLiBeC_xHqqkZx_
		TRACE(_T("SB_TOP\n"));
		lNewPos	= 0;
		break;
	}
// 06.11.10 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	OffsetScroll(lScrPos - lNewPos);
	OffsetScroll(lScrPos - lNewPos, TRUE);
	BASE_CLASS::OnVScroll(nSBCode, nPos, pScrollBar);
} // CFCMatrixControl::OnVScroll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnGetDlgCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkKiPiIjHjNiClHiCoJjDpMjHmNiCmMiDfOiDeDiDhGiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_ 
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.26 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
UINT CFCMatrixControl::OnGetDlgCode ()
{
	// _xZkqqHx_jFpLiMpMiDeMiBfLiCpAiPiIjHjNiClHiCoJiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_
	return DLGC_WANTARROWS | BASE_CLASS::OnGetDlgCode();
} // CFCMatrixControl::OnGetDlgCode.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnTimer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfOiDeDiDhNiBfLiDeDiDhIiDjDiDgHiCmJiCoGiCmBiCmEiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nIDEvent	:_xZkqqHx_iDfOiDeDiDhNiBfL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnTimer (UINT nIDEvent)
{
	// _xZkqqHx_iDfOiDeDiDhNiBfLiDeDiDhIiDjDiDgHiPiIjHjNiKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	if (nIDEvent == m_dwTimer)
		TimerEvent(nIDEvent);
	else
		BASE_CLASS::OnTimer(nIDEvent);
		// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
} // CFCMatrixControl::OnTimer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnImeNotify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IME_xZkqqHx_iCmM_xHqqkZx_On/Off_xZkqqHx_iCpAjAnIiCoIjBnGiCkGiCoJiCmGiCkLiCmIiCmHiCkKjCmKjCgNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_jCmKjCgNiCmMjDoAjHgFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCMatrixControl::OnImeNotify (WPARAM wParam, LPARAM lParam)
{
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (WindowsMe_xZkqqHx_iCmFiNmFiPiJiCmMiLeOjDkOiOjOiCmMiCnNjDpKjGhLiMoKjDpMjHmNiOjOiCmJ_xHqqkZx_IME_xZkqqHx_iCkKjFfMiOkGiClDiCoKiCmIiCkC_xHqqkZx_)-----
//#if defined(_IME_ON)
//	if (wParam == IMN_SETOPENSTATUS)
//	{
//		// IME_xZkqqHx_iCpAjFmCiClGiCoJiBeC_xHqqkZx_
//		::CloseImeStatus(m_hWnd);
//	}
//#endif // defined(_IME_ON)
//	return 1;
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (WindowsMe_xZkqqHx_iCmFiNmFiPiJiCmMiLeOjDkOiOjOiCmMiCnNjDpKjGhLiMoKjDpMjHmNiOjOiCmJ_xHqqkZx_IME_xZkqqHx_iCkKjFfMiOkGiClDiCoKiCmIiCkC_xHqqkZx_)-----
#if defined(_IME_ON)
	if (wParam == IMN_SETOPENSTATUS)
	{
		// IME_xZkqqHx_iCpAjFmCiClGiCoJiBeC_xHqqkZx_
		::CloseImeStatus(m_hWnd);
		return 1;
	}
#endif // defined(_IME_ON)
	return Default();
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (WindowsMe_xZkqqHx_iCmFiNmFiPiJiCmMiLeOjDkOiOjOiCmMiCnNjDpKjGhLiMoKjDpMjHmNiOjOiCmJ_xHqqkZx_IME_xZkqqHx_iCkKjFfMiOkGiClDiCoKiCmIiCkC_xHqqkZx_)-----
} // CFCMatrixControl::OnImeNotify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnRbtnItemAny
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiBhFiDeBiDeDiDgFiDiAiCmM_xHqqkZx_XX_xZkqqHx_iBhGiCmMiCkCiClIiCoKiCkJiCoHiCkJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCMatrixControl::OnRbtnItemAny (UINT nCmdID)
{
	OnCmEvent(GetCurrentMessage()->wParam);
} // CFCMatrixControl::OnRbtnItemAny.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCMatrixControl::OnMouseWheel
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgFiDiKiDhNiDeFiDfIiCmM_xHqqkZx_wheel_xZkqqHx_iCkKiJpBjDfNiClFiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFlags	:_xZkqqHx_jDkPiOjOiCmJiJjPiClDiCoKiCmEiCkCiCoJiDeMiBfLiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			zDelta	:_xZkqqHx_iJpBjDfNiLjHjHkDiCpAiOhHiOkGiBeC_xHqqkZx_zDelta _xZkqqHx_jCgMiCmN_xHqqkZx_ WHEEL_DELTA (_xZkqqHx_jCgM_xHqqkZx_ 120)
 *					 _xZkqqHx_iCmMjEhLjAjEiCnMiClNiCmNjGpBjAjEiCmJiClFiCnMiClHiBeC_xHqqkZx_
 *			pt		:_xZkqqHx_iDeKiBfLiDfMiDiLiCmM_xHqqkZx_ xy _xZkqqHx_iNmAjFfHiCpAiOhHjCoIiBeCiDeFiDeCiDjDiDgIiDeFiCmMiNlGiPoDiLpHiCpAiMlEjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDeFiDfIiDhKiDeDiBfLiDiLiDfIiDeOiDiNiBfLiDiLiCkKjHeMiMpIiCmIiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iImIiKePiCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jGlDiMpIiCmIiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCMatrixControl::OnMouseWheel (UINT nFlags, short zDelta, CPoint pt)
{
	// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLjHmKiCpAiOfKiPgPiBeC_xHqqkZx_
	int nToScroll = FFWheelDeltaToScrollCount(zDelta);
	//----- _xZkqqHx_iPgDiDfIiDeOiDiNiBfLiDiL_xHqqkZx_ -----
	SCROLLINFO oSCInfo;
	GetScrollInfo(SB_VERT, &oSCInfo);
	int nScrPos  = oSCInfo.nPos;
	int nScrDelt = int(oSCInfo.nPage) / 20;
	if (nScrDelt <= 0) nScrDelt = 1;
	int nNewPos = nScrPos + nToScroll * nScrDelt;
	SendMessage(WM_VSCROLL, MAKELONG(SB_THUMBPOSITION, nNewPos), 0);
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::OnMouseWheel(nFlags, zDelta, pt);
} // CFCMatrixControl::OnMouseWheel.

