#include "stdafx.h"
#include "resource.h"		// For ProObjLine.h.
#include "FoundDoc.h"		// g_pDoc.
#include "LinkManager.h"	// For LinkManager.
#include "UtilMisc.h"			// For RotateConv.
#include "UtilMath.h"		// For mmroundoff.
#include "UtilBezier.h"		// For FCMmPolyBezier.
#include "ProObjLine.h"		// For CFCProObjLine.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "ObjLine.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::FCObjLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
FCObjLine::FCObjLine ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// m_mmptFrom_xZkqqHx_iCmN_xHqqkZx_double_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	TRACE(_T("%d %d\n"), sizeof(BASE_CLASS), offsetof(FCObjLine, m_mmptFrom));
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjLine, m_mmptFrom));
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	memset(&m_mmptFrom, 0, sizeof(FCObjLine) - offsetof(FCObjLine, m_mmptFrom));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	m_mmptFrom = mmroundoff(DBLPoint(0, 0));
	m_mmptTo = mmroundoff(DBLPoint(1,1));
} // FCObjLine::FCObjLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_LINE) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjLine::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjLine::Type () const
{
	return FDOJ_LINE;
} // FCObjLine::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect FCObjLine::GetResizeFrame () const
{
	DBLRect mmrtResize(m_mmptFrom, m_mmptTo);
	mmrtResize.NormalizeRect();
	return mmrtResize;
} // FCObjLine::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjLine* trgp = static_cast<const FCObjLine*>(objp);
	return (memcmp(&m_mmptFrom, &trgp->m_mmptFrom,
				sizeof(FCObjLine) - offsetof(FCObjLine, m_mmptFrom)) == 0);
} // FCObjLine::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjLine::OutStream (FCUndoArchive& ar)
void FCObjLine::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_mmptFrom;
	ar << m_mmptTo;
} // FCObjLine::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FCObjLine::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	ar >> m_mmptFrom;
	ar >> m_mmptTo;
} // FCObjLine::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	: PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		: _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *************************************************************************/
void FCObjLine::CreatePropertyPage (CPropertyPageVector& vPropPage,
											const ObjDynabaseVector& vSelect)
{
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
	ObjDynabaseVector::const_iterator i;
	for (i = vSelect.begin(); i != vSelect.end(); i++)
		if (!(*i)->IsKindOf(FDOJ_LINE)) return;
	vPropPage.push_back(new CFCProObjLine());
} // FCObjLine::CreatePropertyPage.

//----- 01.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetIsOpenPolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLine::GetIsOpenPolygon () const
//{
//	return TRUE;
//} // FCObjLine::GetIsOpenPolygon.
//----- 01.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 99.12.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::NewObjPolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAjIfPjHjNiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vlgptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
// *			lgdElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHiCmMjAlIjDhI_xHqqkZx_._xZkqqHx_jClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_
// *			lgrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
// *			iClipSize	:lgrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	lgptpPoly_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.21 Fukushiro M. Vector_xZkqqHx_iMfOiCmJjFmPiNfIiBeC_xHqqkZx_
// *************************************************************************/
//void FCObjLine::NewObjPolygon (CPointVector& vlgptPoly,
//								BOOL& bIsClose, double lgdElemLen,
//								const CRect lgrtaClip[], int iClipSize) const
//{
//	vlgptPoly.push_back(mm2lg(m_mmptFrom));
//	vlgptPoly.push_back(mm2lg(m_mmptTo));
//	bIsClose = FALSE;
//} // FCObjLine::NewObjPolygon.
//----- 99.12.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::IsClosePolygon
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::IsClosePolygon () const
{
	return FALSE;
} // FCObjLine::IsClosePolygon.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiOmAiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	: _xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	: mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmpPoint_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.21 Fukushiro M. Vector_xZkqqHx_iMfOiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCObjLine::NewObjPolygonForDraw (DBLPointVector& vmmptPoly,
								mmetol mmElemLen,
								const DBLRect mmrtaClip[], int iClipSize) const
{
	vmmptPoly.clear();
	vmmptPoly.push_back(m_mmptFrom);
	vmmptPoly.push_back(m_mmptTo);
} // FCObjLine::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLine::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
	polyBezier.clear();
	polyBezier.SetIsBezier(TRUE);
	polyBezier.push_back(m_mmptFrom);
	polyBezier.push_back(m_mmptFrom);
	polyBezier.push_back(m_mmptTo);
	polyBezier.push_back(m_mmptTo);
} // FCObjLine::NewObjBezierForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetEdgePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFmCiClGiClNjAhNiMgAiCmMiPoKiNiHiCmNiBeBjCgMiCmN_xHqqkZx_DBLPoint(0,0)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLine::GetEdgePoint (DBLPoint& mmptF, DBLPoint& mmptB) const
{
	mmptF = m_mmptFrom;
	mmptB = m_mmptTo;
} // FCObjLine::GetEdgePoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetMolipPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMiNmAjFfHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iOoGjDlOiClHiCoJ_xHqqkZx_MOLIP_xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			lTerminalIdx:MOLIP_xZkqqHx_iCmMiDfOiBfLiDhOiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MOLIP_xZkqqHx_iNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmNiBeBjFjEjFgJiCmMjCiGjAfDiNmAjFfHiCpAiOkGiClFiBeBjBfDiCmEiCmMjFjEjFgJiCkK_xHqqkZx_
 *			_xZkqqHx_iOjNiCmBiCmEiCkCiCoJiDhMiDeDiDjDiDgHiCmFiCkAiCoJiBeCiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCkK_xHqqkZx_0_xZkqqHx_iImIiPoDiCmMiDhMiDeDiDjDiDgHiCmN_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiClCiCmGiCmJiOjNiCmBiCmEiCkCiCoJjAjEiCkKiInJiCmIiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iNfIiCmJiBeBiKgFiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDiCiDiKiDhGiCmNiBeBjFkBjAjEiCmMiDfOiBfLiDhOiDgJiDiLiDhMiDeDiDjDiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iOjNiCmCiClBiCmGiCkKiPgPjHiIiCoJiBeCiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx = 0 _xZkqqHx_iCmMiDhMiDeDiDjDiDgHiCkKiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID _xZkqqHx_iCmMjAlDiOkOiCmIiDiCiDiKiDhGiImKjChFiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_ID _xZkqqHx_iCkK_xHqqkZx_ 1_xZkqqHx_iImIiPoDiCmM_xHqqkZx_
 *			_xZkqqHx_iDhMiDeDiDjDiDgHiCmNiBeBiDiKiDjDiDeOiOjOiCmMjFoCiPjFjDeJiCmIiDiCiDiKiDhGiImKjChFiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCkK_xHqqkZx_ 0 _xZkqqHx_iClFiCkJjGlDiCkCiDiCiDiKiDhGiCmFiCmNiBeBiDfOiBfLiDhOiDgJiDiL_xHqqkZx_Idx _xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jCgMiCmNjGlDiOiLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.01.28 Fukushiro M. _xZkqqHx_jHlMjCfLiCmMiKnEiCmJiDiCiDiKiDhGiCpAjCmHiJmBiBeCiClBiCmMiDiCiDiKiDhGiCmN_xHqqkZx_
 *								-1_xZkqqHx_iDiCiDiKiDhGiCmGjDkPiClGiImKjChFiCmJiCkAiCoJiCkKiBeB_xHqqkZx_-1_xZkqqHx_iDiCiDiKiDhGiCpA_xHqqkZx_
 *								_xZkqqHx_iLoGjFmKiClHiCoJiPiIjHjNiCkKjBlNiCkCiClNiCnPiBeBjFmKjDhCjCiGiKnEiCmJ_xHqqkZx_
 *								_xZkqqHx_jDfPiDiCiDiKiDhGiCpAjCmHiJmBiClFiClNiBeC_xHqqkZx_
 *************************************************************************/
DBLPoint FCObjLine::GetMolipPos (long lMolipID, long lTerminalIdx) const
{
	DBLPoint mmpt;
	switch (lMolipID)
	{
	case -1:	// _xZkqqHx_jCiGjAfDiDiCiDiKiDhGiBeC_xHqqkZx_
	case 1:		// _xZkqqHx_jCiGiKnEjDfPiBeC_xHqqkZx_
		mmpt.SetPoint((m_mmptFrom.x + m_mmptTo.x) / 2.0,
						(m_mmptFrom.y + m_mmptTo.y) / 2.0);
		break;
	case 0:		// _xZkqqHx_iKeKiOgOjDfPiBeC_xHqqkZx_
		if (lTerminalIdx == 1)
		//----- _xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_ 1 _xZkqqHx_iOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			DBLPoint mmptOffset = m_mmptTo - m_mmptFrom;
			if (almost0(mmptOffset))
				mmptOffset.SetPoint(1.0, 1.0);
			mmpt = m_mmptFrom +
					FD_TERMINAL_DISTANCE * mmptOffset / mmptOffset.Len();
		} else
		//----- _xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_ 1 _xZkqqHx_iImIiKePiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			mmpt = m_mmptFrom;
		}
		break;
	case 2:		// _xZkqqHx_iPeJjHlJjDfPiBeC_xHqqkZx_
		if (lTerminalIdx == 1)
		//----- _xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_ 1 _xZkqqHx_iOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			DBLPoint mmptOffset = m_mmptFrom - m_mmptTo;
			if (almost0(mmptOffset))
				mmptOffset.SetPoint(1.0, 1.0);
			mmpt = m_mmptTo +
					FD_TERMINAL_DISTANCE * mmptOffset / mmptOffset.Len();
		} else
		//----- _xZkqqHx_iDfOiBfLiDhOiDgJiDiL_xHqqkZx_ 1 _xZkqqHx_iImIiKePiOhHjCoIiCmMiPoKiNiH_xHqqkZx_ -----
		{
			mmpt = m_mmptTo;
		}
		break;
	}
	return mmpt;
} // FCObjLine::GetMolipPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetMolipCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MOLIP_xZkqqHx_iBgJiDiKiDjDiDeOiCpAjCkDiCoJiCmGiCkLjDjJiCmJiOgHjHhAiBgKiCmMjAjEiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID -1 _xZkqqHx_iCmMjAjEiCmNiDeKiDeFiDjDiDgHiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.01.28 Fukushiro M. _xZkqqHx_jHlMjCfLiCmMiKnEiCmJiDiCiDiKiDhGiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
long FCObjLine::GetMolipCount () const
{
	// _xZkqqHx_iKeKiOgOjDfPiCmGiPeJjHlJjDfPiCmGjCiGiKnEjDfPiCkKiDiCiDiKiDhGiBeC_xHqqkZx_
	return 3;
} // FCObjLine::GetMolipCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetFrontEdgeMolipId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iBeCiKeKiOgOjDfPiDiCiDiKiDhGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjLine::GetFrontEdgeMolipId () const
{
	return 0;
} // FCObjLine::GetFrontEdgeMolipId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetBackEdgeMolipId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiDiCiDiKiDhGiCmM_xHqqkZx_ID_xZkqqHx_iBeCiPeJjHlJjDfPiDiCiDiKiDhGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_-1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjLine::GetBackEdgeMolipId () const
{
	return 2;
} // FCObjLine::GetBackEdgeMolipId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetMolipTerminalCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDiCiDiKiDhGiCmMiBeBiDfOiBfLiDhOiDgJiDiLjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipId	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfOiBfLiDhOiDgJiDiLjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmMiDiCiDiKiDhGiCmJiCmNiBeBiIoKiCmCiImIiPoDiCmMiDiCiDiKiDhGiImKjChFiCkKjBlGiNnNiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCoHiCmMiDiCiDiKiDhGiImKjChFiCpAiDiCiDiKiDhGiDfOiBfLiDhOiDgJiDiLiDhMiDeDiDjDiDgHiBgJiDfOiBfLiDhOiDgJiDiLiBgK_xHqqkZx_
 *			_xZkqqHx_iCmGiMmEiCnEiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiKnGjAjEiCmFiCmNiBeBiOhHjCoIiCmMiDiCiDiKiDhGiCmJjBlGiNnNiClHiCoJiDfOiBfLiDhOiDgJiDiLiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iCnJiCmGiCpBiCmHiCmMiDiCiDiKiDhGiCmFiCmNiBeBiDfOiBfLiDhOiDgJiDiLjAjEiCmN_xHqqkZx_ 1 _xZkqqHx_iMmCiBeC_xHqqkZx_
 *			_xZkqqHx_iDfOiBfLiDhOiDgJiDiLiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ = 0 _xZkqqHx_iCmMiDfOiBfLiDhOiDgJiDiLiCkKiBeBiClLiCmMiDiCiDiKiDhGiCmM_xHqqkZx_
 *			_xZkqqHx_jAlDiOkOiCmIiDiCiDiKiDhGiImKjChFiCmFiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCObjLine::GetMolipTerminalCount (long lMolipId) const
{
	//----- _xZkqqHx_jCfLjDfPiCmMiDiCiDiKiDhGiCmMiPoKiNiHiCmN_xHqqkZx_ _xZkqqHx_iDfOiBfLiDhOiDgJiDiLiCkKiCfBiMmC_xHqqkZx_ -----
	if (lMolipId == 0 || lMolipId == 2)
		return 2;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::GetMolipTerminalCount(lMolipId);
} // FCObjLine::GetMolipTerminalCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::CanRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiJpBjDfNiKhAiCpAjAnNjCoIiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::CanRotate () const
{
	return TRUE;
} // FCObjLine::CanRotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetAngleLinkStandardPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiIoKjCoIiMfOiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiClNiCnPiCmJiBeBiKhAjDhIiMhGiOfKiCmMiKoOiPiAiCmGiCmIiCoJjDfPiCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA		:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMjDfP_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdG	:_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiDiCiDiKiDhG_xHqqkZx_G_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRecExcept	:_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeO_xHqqkZx_AG_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_M_xZkqqHx_iCmMiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_iKoOiPiAjApM_xHqqkZx_AM_xZkqqHx_iCpAiOfKiPgPiClHiCoJiClNiCnPiCmMjDfP_xHqqkZx_M_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iKoOjGhLjDeJiCmJiCmNjDfP_xHqqkZx_A_xZkqqHx_iCmGjDfP_xHqqkZx_H_xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiKoOiPiAiCmJiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCkKiCkAiCoJiPoKiNiHiCmNiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiImKjChFiCpAjDfP_xHqqkZx_H_xZkqqHx_iCmGiClFiCmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			pRecExcept _xZkqqHx_iCmNiBeBiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAiMjPiNpFiClHiCoJiNnLiBeBjGlDiOiLiClHiCoJiDiKiDjDiDeO_xHqqkZx_
 *			_xZkqqHx_iCmGiClFiCmEjHfOiCkGiCoHiCoKiCoJiBeCjBlNiKhAjApMjFjEjFgJiImIiKePiCmMiPoKiNiHiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCObjLine::GetAngleLinkStandardPosition (const DBLPoint& mmptA,
												  long lMolipIdG,
												  const FCLinkRec* pRecExcept) const
{
	// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhGiBeBiPeJjHlJjDfPiDiCiDiKiDhGiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_Superlcass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	if (lMolipIdG != 0 && lMolipIdG != 2)
		return BASE_CLASS::GetAngleLinkStandardPosition(mmptA, lMolipIdG, pRecExcept);
	long lMolipIdH = (lMolipIdG == 0) ? 2 : 0;
	// _xZkqqHx_iDiKiDjDiDeOjAoGjFjEjFgJ_xHqqkZx_R_xZkqqHx_iCmMiDiCiDiKiDhGiNmAjFfH_xHqqkZx_H_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	DBLPoint mmptH = GetMolipPos(lMolipIdH);
	// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
	const FCLinkRec* pLinkRec =
			g_pDoc->LinkManager()->Get1stAngleLinkIn(GetObjID(), lMolipIdH, pRecExcept);
	if (pLinkRec != NULL)
	{
		// _xZkqqHx_jFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
		FCObjDynabase* pObjS = g_pDoc->ObjID2Object(pLinkRec->m_mlpFrom.dwObjID);
		mmptH = pObjS->GetMolipPos(pLinkRec->m_mlpFrom.lMolipId);
	}
	if (abouteq(mmptA, mmptH))
	{
		// _xZkqqHx_jBmOiPnLiDiCiDiKiDhGiCkJiCoHjAiFjFlNiJeFjFpLiMpMiCmJiJlMjBhKiCmM_xHqqkZx_2_xZkqqHx_jEnEjGnKiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
		mmptH = mmptA + DBLPoint(10, 0);
	}
	return mmptH;
} // FCObjLine::GetAngleLinkStandardPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetAngleLinkStandardSign
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiIoKjCoIiMfOiDiCiDiKiDhGiKnEiDiKiDjDiDeOiCmMiClNiCnPiCmJiBeBiInKjDkOiKhAjDhI_xHqqkZx_(m_mmptOffset.x)_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jFpLiMpMiCpAiMhGiOfKiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *			LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptA		:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMjDfP_xHqqkZx_A_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdG	:_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiDiCiDiKiDhG_xHqqkZx_G_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pRecExcept	:_xZkqqHx_iDiCiDiKiDhGiKnEiDiKiDjDiDeO_xHqqkZx_AG_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDjFpLiMpMiCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeCjFiJjFpLiMpMiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	LinkManager.mdrw _xZkqqHx_iCmM_xHqqkZx_CalcNewMovingAngle_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *			_xZkqqHx_iInKjDkOiKhAjDhI_xHqqkZx_(m_mmptOffset.x)_xZkqqHx_iCmMjFpLiMpMiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iKoOjGhLjDeJiCmJiCmNjDfP_xHqqkZx_A_xZkqqHx_iCmGjDfP_xHqqkZx_H_xZkqqHx_iCmMiImKjChFiKnGiMfHiCpAiKoOiPiAiCmJiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCkKiCkAiCoJiPoKiNiHiCmNiBeBiClLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiCmMiImKjChFiCpAjDfP_xHqqkZx_H_xZkqqHx_iCmGiClFiCmEiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *			pRecExcept _xZkqqHx_iCmNiBeBiKhAjDhIiIoKjCoIiMfOiDiKiDjDiDeOiCpAiMjPiNpFiClHiCoJiNnLiBeBjGlDiOiLiClHiCoJiDiKiDjDiDeO_xHqqkZx_
 *			_xZkqqHx_iCmGiClFiCmEjHfOiCkGiCoHiCoKiCoJiBeCjBlNiKhAjApMjFjEjFgJiImIiKePiCmMiPoKiNiHiCmJjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
short FCObjLine::GetAngleLinkStandardSign (const DBLPoint& mmptA,
										  long lMolipIdG,
										  const FCLinkRec* pRecExcept) const
{
	// _xZkqqHx_iOhHjCoIiCmMiDiCiDiKiDhGiCkKiKeKiOgOjDfPiDiCiDiKiDhGiBeBiPeJjHlJjDfPiDiCiDiKiDhGiImIiKePiCmMiPoKiNiHiCmNiBeB_xHqqkZx_Superlcass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	if (lMolipIdG != 0 && lMolipIdG != 2)
		return BASE_CLASS::GetAngleLinkStandardSign(mmptA, lMolipIdG, pRecExcept);
	return 1;
} // FCObjLine::GetAngleLinkStandardSign.

//----- 01.08.21 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::IsLinkable
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCmJiDiKiDjDiDeOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipID	:_xZkqqHx_iDiKiDjDiDeOiCpAjCkDiCoJiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
// *			bLinkOut	:_xZkqqHx_iDiCiDiKiDhGiCkKiDiKiDjDiDeOiMlDiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeB_xHqqkZx_
// *						 _xZkqqHx_iDiKiDjDiDeOjAoGiCmIiCoHiCmO_xHqqkZx_ FALSE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_iDiKiDjDiDeOiJmCjEfM_xHqqkZx_
// *			FALSE	:_xZkqqHx_iDiKiDjDiDeOjFhDiJmCjEfM_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLine::IsLinkable (long lMolipID, BOOL bLinkOut) const
//{
//	if (lMolipID == -1)
//	// _xZkqqHx_iBhMiCfAiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
//	{
//		return TRUE;
//	} else if (lMolipID == 1)
//	// _xZkqqHx_jCiGiKnEjDfPiCmMiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
//	{
//		// _xZkqqHx_iDiKiDjDiDeOiDeBiDeFiDgHiCmNiDiKiDjDiDeOiJmCiBeBiDiKiDjDiDeOiDeDiDjDiCmNiDiKiDjDiDeOjFhDiJmCiBeC_xHqqkZx_
//		return bLinkOut;
//	} else
//	// _xZkqqHx_jHlMjCfLiCmMiDiCiDiKiDhGiCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiBeC_xHqqkZx_
//	{
//		return TRUE;
//	}
//} // FCObjLine::IsLinkable.
//----- 01.08.21 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 99.06.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::IsResizable
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClH_xHqqkZx_.
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
// *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
// *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfM_xHqqkZx_
// *			FALSE	: _xZkqqHx_iDiKiDfEiDeDiDfJjFhDiJmCjEfM_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	IsResizable_xZkqqHx_iCmNjAfEiPgEiCmJiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
// *			_xZkqqHx_jFjNiCePiCmMjApMiCmJiJkBjFpLiMpMiDiKiDfEiDeDiDfJiBgJiIlNiCkCiCmNiLhEiBgKiCkKiJmCjEfMiCmIiOgEjHgMiClOiCmBiClNiCkKiBeB_xHqqkZx_
// *			Undo_xZkqqHx_iCkKiMpIiCkJiCmIiCkCiInH_xHqqkZx_ _xZkqqHx_iMkJjClMiClFiClNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iDiKiDfEiDeDiDfJiMgAiOkOiCpAiMkJjClMiClFiBeC_xHqqkZx_
// *************************************************************************/
//BOOL FCObjLine::IsResizable (BOOL bXPosi, BOOL bYPosi,
//								const DBLRect& mmrtNew) const
//{
//	// _xZkqqHx_iPgDiBeFiJkBiCmGiCoAiCePiCmJiCmIiCoJiDiKiDfEiDeDiDfJiCmNiLjGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
//	if (mmrtNew.Width() == 0.0 && mmrtNew.Height() == 0.0) return FALSE;
//	if (m_mmptFrom.x == m_mmptTo.x)
//	// _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiHiBeC_xHqqkZx_
//	{
//		// _xZkqqHx_jAiCjClMjApMiCpAiPgDiCmJiKgHiPgLiClBiCmGiCmMiCnNiCkKiCgOiCgKiBeC_xHqqkZx_
//		if (mmrtNew.Width() == 0.0) return TRUE;
//		return FALSE;
//	} else
//	if (m_mmptFrom.y == m_mmptTo.y)
//	// _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiHiBeC_xHqqkZx_
//	{
//		// _xZkqqHx_jAiFjFlNjApMiCpAiJkBiCmJiKgHiPgLiClBiCmGiCmMiCnNiCkKiCgOiCgKiBeC_xHqqkZx_
//		if (mmrtNew.Height() == 0.0) return TRUE;
//		return FALSE;
//	} else
//	// _xZkqqHx_iOmOjApMiCmMiPoKiNiHiBeC_xHqqkZx_
//	{
//		// _xZkqqHx_iPgDiBeFiJkBjFpLiMpMiCmGiCoAiCePiCmJiCmIiCoHiCkPiCoKiCmOiCgOiCgKiBeC_xHqqkZx_
//		if (mmrtNew.Width() != 0.0 && mmrtNew.Height() != 0.0) return TRUE;
//		return FALSE;
//	}
//} // FCObjLine::IsResizable.
//----- 99.06.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::CanBeTextObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDfIiDeOjFjEjFgJiCmGiClFiCmEiOgHiCkGiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOgHiCkGiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiOgHiCkGiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::CanBeTextObject () const
{
	return FALSE;
} // FCObjLine::CanBeTextObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetPoints
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptFrom	:_xZkqqHx_iKeKiOgOjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmptTo		:_xZkqqHx_iPeJjHlJjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLine::GetPoints (DBLPoint& mmptFrom, DBLPoint& mmptTo) const
{
	mmptFrom = m_mmptFrom;
	mmptTo = m_mmptTo;
} // FCObjLine::GetPoints.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetFromEndX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjLine::GetFromEndX () const
{
	return m_mmptFrom.x;
} // FCObjLine::GetFromEndX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetFromEndY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjLine::GetFromEndY () const
{
	return m_mmptFrom.y;
} // FCObjLine::GetFromEndY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetToEndX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjLine::GetToEndX () const
{
	return m_mmptTo.x;
} // FCObjLine::GetToEndX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::GetToEndY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjLine::GetToEndY () const
{
	return m_mmptTo.y;
} // FCObjLine::GetToEndY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLine::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjLine::CopySelf(pObj);
} // FCObjLine::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLine::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjLine::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// m_mmptFrom_xZkqqHx_iCmN_xHqqkZx_mmetol_xZkqqHx_iMfOiCpAiOgHiCkEiCmMiCmFiBeB_xHqqkZx_8_xZkqqHx_iCmMjEhLjAjEiCmFiDeBiDiJiDeDiDjDiDiBiDjDiDgHiCkKjDpMiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjLine, m_mmptFrom));
	FCObjLine* pLin = reinterpret_cast<FCObjLine*>(pObj);
	memcpy(&pLin->m_mmptFrom, &m_mmptFrom, sizeof(FCObjLine) - offsetof(FCObjLine, m_mmptFrom));
} // FCObjLine::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::MoveMolip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDiCiDiKiDhGiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipID	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *			mmptOffset	:_xZkqqHx_iInKjDkOiLjHjHkDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmMiNmEiMhGiOfKiCmNiClFiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjLine::MoveMolip (long lMolipID, const DBLPoint& mmptOffset)
{
	// _xZkqqHx_iInKjDkOjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (mmptOffset.IsNull()) return;
	switch (lMolipID)
	{
//----- 01.08.15 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case -1:	// _xZkqqHx_jCiGjAfDiDiCiDiKiDhGiCmMiInKjDkOiBeC_xHqqkZx_
//		Move(mmptOffset.x, mmptOffset.y);
//		break;
//----- 01.08.15 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case 0:		// _xZkqqHx_iKeKiOgOjDfPiCmMiInKjDkOiBeC_xHqqkZx_
		m_mmptFrom += mmptOffset;
		break;
//----- 01.08.21 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case 1:		// _xZkqqHx_jCiGiKnEjDfPiCmMiInKjDkOiBeC_xHqqkZx_
		m_mmptFrom += mmptOffset;
		m_mmptTo += mmptOffset;
		break;
//----- 01.08.21 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	case 2:		// _xZkqqHx_iPeJjHlJjDfPiCmMiInKjDkOiBeC_xHqqkZx_
		m_mmptTo += mmptOffset;
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::MoveMolip(lMolipID, mmptOffset);
} // FCObjLine::MoveMolip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiInKjDkOiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmDX	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_X_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *			mmDY	: _xZkqqHx_iInKjDkOjHmKiBgJ_xHqqkZx_Y_xZkqqHx_jFpLiMpMiBgK_xHqqkZx_
 *************************************************************************/
void FCObjLine::Move (mmetol mmDX, mmetol mmDY)
{
	m_mmptFrom.x += mmDX;
	m_mmptFrom.y += mmDY;
	m_mmptTo.x += mmDX;
	m_mmptTo.y += mmDY;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Move(mmDX, mmDY);
} // FCObjLine::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::Resize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClDiCoKiCoJiOjOiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bXPosi	: X_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			bYPosi	: Y_xZkqqHx_jFpLiMpMiCmMjElNjDfN_xHqqkZx_
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *			mmrtNew	: _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNmAjFfH_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.27 Fukushiro M. _xZkqqHx_jFjN_xHqqkZx_(_xZkqqHx_iNiC_xHqqkZx_)_xZkqqHx_iCePiBkIjFjN_xHqqkZx_(_xZkqqHx_iNiC_xHqqkZx_)_xZkqqHx_iCePiCmMiDiKiDfEiDeDiDfJiCpAiJmCjEfMiCmJiBeC_xHqqkZx_
 *								_xZkqqHx_iDgAiDgCiDhGjDgPjIfOiClFiClNiPgDjApMiBeFiJkBjApMiCmMiDiKiDfEiDeDiDfJjHhAiBeC_xHqqkZx_
 *************************************************************************/
void FCObjLine::Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld)
{
	if (!bXPosi) Exchange(m_mmptFrom.x, m_mmptTo.x);
	if (!bYPosi) Exchange(m_mmptFrom.y, m_mmptTo.y);

	if (m_mmptFrom.x < m_mmptTo.x)
	//----- From_xZkqqHx_iCkKiNlGiBeB_xHqqkZx_To_xZkqqHx_iCkKiJeFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFrom.x = mmrtNew.left;
		m_mmptTo.x = mmrtNew.right;
	} else if (m_mmptTo.x < m_mmptFrom.x)
	//----- To_xZkqqHx_iCkKiNlGiBeB_xHqqkZx_From_xZkqqHx_iCkKiJeFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFrom.x = mmrtNew.right;
		m_mmptTo.x = mmrtNew.left;
	} else
	//----- From_xZkqqHx_iBeB_xHqqkZx_To_xZkqqHx_iCkKiPgDiCmJjFmAiCnEiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFrom.x = mmrtNew.left;
		m_mmptTo.x = mmrtNew.left;
	}
	if (m_mmptFrom.y < m_mmptTo.y)
	//----- From_xZkqqHx_iCkKiPoDiBeB_xHqqkZx_To_xZkqqHx_iCkKiJlKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFrom.y = mmrtNew.top;
		m_mmptTo.y = mmrtNew.bottom;
	} else if (m_mmptTo.y < m_mmptFrom.y)
	//----- To_xZkqqHx_iCkKiPoDiBeB_xHqqkZx_From_xZkqqHx_iCkKiJlKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFrom.y = mmrtNew.bottom;
		m_mmptTo.y = mmrtNew.top;
	} else
	//----- From_xZkqqHx_iBeB_xHqqkZx_To_xZkqqHx_iCkKiJkBiCmJjFmAiCnEiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFrom.y = mmrtNew.top;
		m_mmptTo.y = mmrtNew.top;
	}
//	CalcOuterFrame();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Resize(bXPosi, bYPosi, mmrtNew, mmrtOld);
} // FCObjLine::Resize.

//----- 99.12.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::Resize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmFiCmMiDiKiDfEiDeDiDfJjDjJiCmFiOmAiNhDiClDiCoKiCoJiBeCiNiCjBkMiCmJjDkOiNoMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptOrig	:_xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiMlEjDfP_xHqqkZx_
// *			dptMagnif	:_xZkqqHx_iDiKiDfEiDeDiDfJiCmMjEhLjHkG_xHqqkZx_
// *			mmptOrigNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiMlEjDfP_xHqqkZx_
// *************************************************************************/
//void FCObjLine::Resize (const DBLPoint& mmptOrig, const DBLPoint& dptMagnif,
//						const DBLPoint& mmptOrigNew)
//{
//	m_mmptFrom = dptMagnif * (m_mmptFrom - mmptOrig) + mmptOrigNew;
//	m_mmptTo = dptMagnif * (m_mmptTo - mmptOrig) + mmptOrigNew;
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::Resize(mmptOrig, dptMagnif, mmptOrigNew);
//} // FCObjLine::Resize.
//----- 99.12.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::Rotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAiJpBjDfNiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR		:_xZkqqHx_iJpBjDfNiClDiClJiCoJiKhAjDhIiBeC_xHqqkZx_-2.0 < dR < 2.0.
 *			mmCX	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmCY	:_xZkqqHx_iJpBjDfNiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.26 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
// 05.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjLine::Rotate (double dR, mmetol mmCX, mmetol mmCY)
void FCObjLine::Rotate (double dR, const DBLPoint& mmptCenter)
{
	// _xZkqqHx_iJpBjDfNiCkKiCePiCmIiCoHiCmOjFjMiLeBiBeC_xHqqkZx_
	if (dR == 0.0) return;
	// _xZkqqHx_iJpBjDfNjFmPiKlHiCmM_xHqqkZx_Sin,Cos_xZkqqHx_iCpAiOfKiPgPiBeC_xHqqkZx_
	const double dSinR = sin(dR * M_PI);
	const double dCosR = cos(dR * M_PI);
	// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiJpBjDfNiBeC_xHqqkZx_
	RotateConv(m_mmptFrom, dSinR, dCosR, mmptCenter.x, mmptCenter.y);
	RotateConv(m_mmptTo, dSinR, dCosR, mmptCenter.x, mmptCenter.y);
//----- 99.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
//	CalcResizeFrame();
//	CalcOuterFrame();
//----- 99.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Rotate(dR, mmptCenter);
//----- 99.06.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjLine::Rotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::SetFromEndX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmEndX	:_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGiNmAjFfHjCgMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::SetFromEndX (mmetol mmEndX)
{
	if (m_mmptFrom.x == mmEndX) return FALSE;
	m_mmptFrom.x = mmEndX;
	return TRUE;
} // FCObjLine::SetFromEndX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::SetFromEndY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmEndY	:_xZkqqHx_iKeKiOgOjDfPiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGiNmAjFfHjCgMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::SetFromEndY (mmetol mmEndY)
{
	if (m_mmptFrom.y == mmEndY) return FALSE;
	m_mmptFrom.y = mmEndY;
	return TRUE;
} // FCObjLine::SetFromEndY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::SetToEndX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmEndX	:_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGiNmAjFfHjCgMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::SetToEndX (mmetol mmEndX)
{
	if (m_mmptTo.x == mmEndX) return FALSE;
	m_mmptTo.x = mmEndX;
	return TRUE;
} // FCObjLine::SetToEndX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjLine::SetToEndY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmEndY	:_xZkqqHx_iPeJjHlJjDfPiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDkPiClGiNmAjFfHjCgMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ TRUE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjLine::SetToEndY (mmetol mmEndY)
{
	if (m_mmptTo.y == mmEndY) return FALSE;
	m_mmptTo.y = mmEndY;
	return TRUE;
} // FCObjLine::SetToEndY.
