#ifndef __ObjPoly_h
#define __ObjPoly_h

/**********************************************************
 *                 _xZkqqHx_iBhJiDgOiDjDiDeLiDiKiBfLiLeMjGeAiBhK_xHqqkZx_
 *      a               _xZkqqHx_jEhKjHpB_xHqqkZx_(Array)
 *      b               _xZkqqHx_jIfPjHjNiMfO_xHqqkZx_(Bool)
 *      by              unsigned char(BYte)
 *      c               char(Char)
 *      cb              _xZkqqHx_jFlGiOjKjAjE_xHqqkZx_(Count of Byte)
 *      cr              _xZkqqHx_jAeG_xHqqkZx_(Color Reference value)
 *      cx,cy           short_xZkqqHx_iMfO_xHqqkZx_[_xZkqqHx_iNmAjFfH_xHqqkZx_(x,y)_xZkqqHx_iCmMiDeKiDeFiDjDiDfO_xHqqkZx_](Count of X,Y)
 *      dw              unsigned long_xZkqqHx_iMfO_xHqqkZx_(Double Word)
 *      fn              _xZkqqHx_iKnGjAjE_xHqqkZx_(FuNction)
 *      h               _xZkqqHx_iDgOiDjDiDgIiDiL_xHqqkZx_(Handle)
 *      i               int(Integer)
 *      l               long(Long)
 *      m               _xZkqqHx_iDeOiDiJiDfIiDiBiDjDiDgP_xHqqkZx_(data Member of a class)
 *      n               short_xZkqqHx_iIlNiCkCiCmN_xHqqkZx_int
 *      p               _xZkqqHx_iDhMiDeDiDjDiDfOiMfO_xHqqkZx_(Pointer)
 *      s               _xZkqqHx_jFlGiOjKjHpB_xHqqkZx_(String)
 *      sz              0_xZkqqHx_iCmFiPeJiCoNiCoJjFlGiOjKjHpB_xHqqkZx_(String terminated with Zero)
 *      tm              _xZkqqHx_iDgFiDeMiDfIiDgHjAkBjGeA_xHqqkZx_(Text Metric)
 *      w               unsigned short(Word)
 *      x,y             short_xZkqqHx_iMfOiNmAjFfHjCgM_xHqqkZx_
 ********************************************************/

#include "ObjFigure.h"	// Superclass.
#include "PolyJoint.h"	// For FCPolyJoint.

//;----- <EXPORT TO SDK> -----;

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCObjFigure

class FCPolyJoint;
class FCUndoArchive;
class CFCProObjPoly;
class FCToolPolyArrow;
template<class SUPER> class FCToolArrowTmpl;
class FCToolPoly;
class FCToolBezier;
class FCToolWidePoly;
class FCToolWideBezier;
class CFCArrowEditorDoc;

// _xZkqqHx_iDiKiDjDiDeOiInKjDkOiOjOiCmMjIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiBeC_xHqqkZx_m_byLinkMoveType _xZkqqHx_iCmMiOoNjHnOiBeC_xHqqkZx_
enum
{
	FDOP_LMTYPE_NONE = 0,	// _xZkqqHx_iDiKiDjDiDeOiDiCiDiKiDhGiInKjDkOiCmJjElKiCkEjBlMiCmMjIeBiMiLjDfPiInKjDkOiCmNjGlDiCkCiBeC_xHqqkZx_
	FDOP_LMTYPE_AXIS,		// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCpAiMiLiCnEiOlCjApMiCpAjCiGjAfDiCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
	FDOP_LMTYPE_SAMEHV,		// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGjAiFjFlNiBeFjAiCjClMiCmIjIeBiMiLjDfPiCkKiInKjDkOiClHiCoJiBeC_xHqqkZx_
};

// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmMiDiKiDjDiDeOiInKjDkOiOjOiCmMiBeBjHnHiCmMjIeBiMiLjDfPiCmMiInKjDkOiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
enum
{
	FDOP_LMSTYL_NONE = 0,	// _xZkqqHx_jHnHiCmMjIeBiMiLjDfPiCpAiInKjDkOiClFiCmIiCkCiBeC_xHqqkZx_
	FDOP_LMSTYL_MOVE_HORZ,	// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChHjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
	FDOP_LMSTYL_MOVE_VERT,	// _xZkqqHx_iKeKiOgOjDfPiBeFiPeJjHlJjDfPiCmGiChIjFpLiMpMiCmJjDkPiClGiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
};

//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///////////////////////////////////////////////////////////////////////////
//// CommandGate_xZkqqHx_iCmMiDfCiDhNiDjDiDgIiCmJiOgHjHhAiClHiCoJiNfMjBkCjBmMiBeC_xHqqkZx_
//
//struct FCPolyLinkRec
//{
//	WORD	wMask;
//	WORD	wLinkMoveType;
//	BOOL	bIsOpenPolyJoint;
//	WORD	wBgnLinkMoveStyle;
//	WORD	wEndLinkMoveStyle;
//}; // struct FCPolyLinkRec.
//
//#define FDFP_LINKMOVETYPE		WORD(1L << 0)
//#define FDFP_ISOPENPOLYJOINT	WORD(1L << 1)
//#define FDFP_BGNLINKMOVESTYLE	WORD(1L << 2)
//#define FDFP_ENDLINKMOVESTYLE	WORD(1L << 3)
//----- 05.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//;------ </EXPORT TO SDK> -----;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCObjPoly
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBlNiKhAjApMiCmMjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.29 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCObjPoly : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;

public:
	/*----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	FCObjPoly ();
	virtual BOOL	IsKindOf (FTObjectType nType) const;

	/*----- _xZkqqHx_iOmAjBmMiJlLiJmCjEfMiCmIiDeOiDiJiDfIiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	virtual FTObjectType	Type () const;

	/*----- Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	virtual DBLRect	GetResizeFrame () const;
	virtual DBLRect	GetOuterFrame () const;

	/*----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	virtual BOOL	IsEqual (const FCObjDynabase* objp) const;
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	OutStream (FCUndoArchive& ar);
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutBezier);
	virtual void	InStream (FCUndoArchive& ar);
	virtual void	CreatePropertyPage (CPropertyPageVector& vPropPage,
										const ObjDynabaseVector& vSelect);

	/*----- _xZkqqHx_iKePiMgAiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	virtual BOOL	IsClosePolygon () const;
	virtual void	NewObjPolygonForDraw (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const;
	virtual void	NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const;

	virtual void	GetEdgePoint (DBLPoint& mmptF, DBLPoint& mmptB) const;

	/*----- _xZkqqHx_jFkBjAjEiCmMiDiCiDiKiDhGiCpAiOjNiCmC_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	virtual DBLPoint	GetMolipPos (long lMolipId, long lTerminalIdx = 0) const;
	virtual long	GetMolipCount () const;
//----- 05.05.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual long	GetFrontEdgeMolipId () const;
	virtual long	GetBackEdgeMolipId () const;
//----- 05.05.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	virtual long	GetMolipTerminalCount (long lMolipId) const;

	/*----- _xZkqqHx_jFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClHiCoKiCmOjHmHiCkC_xHqqkZx_ -----*/
	virtual BOOL	CanRotate () const;
// 05.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	CalcResizeFrameSelf ();
	virtual void	CalcResizeFrame ();

	virtual DBLPoint	GetAngleLinkStandardPosition (const DBLPoint& mmptA,
													  long lMolipIdG,
													  const FCLinkRec* pRecExcept) const;
	virtual short		GetAngleLinkStandardSign (const DBLPoint& mmptA,
													  long lMolipIdG,
													  const FCLinkRec* pRecExcept) const;

	virtual ~FCObjPoly ();

	/*----- FCObjPoly_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	virtual void	DeleteJoint (long lP);
	virtual void	DeleteJoint (long lIdx, long lSz);
	virtual void	InsertJoint (long lInsert, const FCPolyJoint& polyJoint);
	virtual void	InsertJoint (long lInsert, const FCPolyJoint aoJoint[], long lJoint);
	virtual void	SetJoint (long lPointSize, const DBLPoint* mmptpPoint);
	virtual void	SetJoint (long lJointSize, const FCPolyJoint* pjpJoint);

	virtual const FCPolyJoint*	GetJoints () const;
	virtual FCPolyJoint&		GetJoint (long l) const;
	virtual long				GetJointSize () const;

//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual short	GetJointType (long lIndex) const;
	virtual mmetol	GetPivotX (long lIndex) const;
	virtual mmetol	GetPivotY (long lIndex) const;
	virtual mmetol	GetPrevPullX (long lIndex) const;
	virtual mmetol	GetPrevPullY (long lIndex) const;
	virtual mmetol	GetNextPullX (long lIndex) const;
	virtual mmetol	GetNextPullY (long lIndex) const;
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	static long	JointIDtoMolipID (long lJointID);
	static long	MolipIDToJointID (long lMolipID);

	/*----- FCObjPoly_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----*/
	virtual BOOL	CanSetOpenPolyJoint () const;
	virtual BOOL	GetIsOpenPolyJoint () const;

friend class FCHiCommandTable;
friend class CFCProObjPoly;
friend class FCToolPolyArrow;
friend class FCToolArrowTmpl<FCToolPoly>;
friend class FCToolArrowTmpl<FCToolBezier>;
friend class FCToolArrowTmpl<FCToolWidePoly>;
friend class FCToolArrowTmpl<FCToolWideBezier>;
friend class CFCArrowEditorDoc;

	//----- FCObjPoly_xZkqqHx_iCmM_xHqqkZx_Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	SetJointType (long lIndex, short nType);
	virtual void	SetPivotX (long lIndex, mmetol mm);
	virtual void	SetPivotY (long lIndex, mmetol mm);
	virtual void	SetPrevPullX (long lIndex, mmetol mm);
	virtual void	SetPrevPullY (long lIndex, mmetol mm);
	virtual void	SetNextPullX (long lIndex, mmetol mm);
	virtual void	SetNextPullY (long lIndex, mmetol mm);
//----- 05.04.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	virtual BOOL	SetIsOpenPolyJoint (BOOL bOpen);
	virtual WORD	GetLinkMoveType () const;
	virtual BOOL	SetLinkMoveType (WORD wType);
	virtual WORD	GetBgnLinkMoveStyle () const;
	virtual BOOL	SetBgnLinkMoveStyle (WORD wStyle);
	virtual WORD	GetEndLinkMoveStyle () const;
	virtual BOOL	SetEndLinkMoveStyle (WORD wStyle);

protected:
	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	Copy (FCObjDynabase* pObj) const;
	virtual void	CopySelf (FCObjDynabase* pObj) const;

	//----- _xZkqqHx_jFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClHiCoKiCmOjHmHiCkC_xHqqkZx_ -----
	virtual void	MoveMolip (long lMolipID, const DBLPoint& mmptOffset);
	virtual void	Move (mmetol mmDX, mmetol mmDY);
	virtual void	Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld);
	virtual void	Rotate (double dR, const DBLPoint& mmptCenter);
	virtual void	JointUpdated ();
// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual mmetol	CalcOptimumElemLen () const;

protected:
	DBLRect		m_mmrtResize;		// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiA_xHqqkZx_.
	union {
		WORD		m_wLinkMoveStream;	// _xZkqqHx_iDfIiDgHiDiKiBfLiDiAjHhAiBeC_xHqqkZx_
		struct {
			WORD	m_byLinkMoveType	: 8;	// _xZkqqHx_iDiKiDjDiDeOiInKjDkOiOjOiCmMjIeBiMiLjDfPiNmEjEhKjChFjFpLjGeAiBeC_xHqqkZx_
			WORD	m_byBgnMoveStyle	: 4;	// _xZkqqHx_iKeKiOgOjDfPiInKjDkOiOjOiCmMjHnHjAnKjDfPiCmMiInKjDkOiMgAiOkOiBeC_xHqqkZx_
			WORD	m_byEndMoveStyle	: 4;	// _xZkqqHx_iPeJjHlJjDfPiInKjDkOiOjOiCmMjHnHjAnKjDfPiCmMiInKjDkOiMgAiOkOiBeC_xHqqkZx_
		};
	};
	BOOL			m_bIsOpenPolyJoint;	// _xZkqqHx_iKeKiLmIjApMiCkJiBeI_xHqqkZx_
	long			m_lJoint;			// _xZkqqHx_jIeBiMiLjDfPiCmMjAjEiBeC_xHqqkZx_
	FCPolyJoint*	m_pJoint;			// _xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
}; // class FCObjPoly.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::JointIDtoMolipID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCkJiCoHiDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lJointID	:_xZkqqHx_jIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P245_xZkqqHx_iOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCObjPoly::JointIDtoMolipID (long lJointID)
{
	return lJointID * 2;
} // FCObjPoly::JointIDtoMolipID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjPoly::MolipIDToJointID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iCkJiCoHjIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lMolipID	:_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfP_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P245_xZkqqHx_iOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline long FCObjPoly::MolipIDToJointID (long lMolipID)
{
//----- 02.08.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (MolipSDK_xZkqqHx_iCmF_xHqqkZx_ASSERT_xZkqqHx_iCkKjDkOiNoMiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJ_xHqqkZx_)-----
//	// _xZkqqHx_jCiGiKnEjDfPiDiCiDiKiDhGiCmNjIeBiMiLjDfPiCmFiCmNiCmIiCkCiCkJiCoHiDfPiDiBiBeC_xHqqkZx_
//	ASSERT((lMolipID & 1) == 0);
//----- 02.08.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (MolipSDK_xZkqqHx_iCmF_xHqqkZx_ASSERT_xZkqqHx_iCkKjDkOiNoMiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJ_xHqqkZx_)-----
#ifdef _DEBUG
	// _xZkqqHx_jCiGiKnEjDfPiDiCiDiKiDhGiCmNjIeBiMiLjDfPiCmFiCmNiCmIiCkCiCkJiCoHiDfPiDiBiBeC_xHqqkZx_
	if ((lMolipID & 1) != 0) DebugBreak();
#endif _DEBUG
//----- 02.08.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (MolipSDK_xZkqqHx_iCmF_xHqqkZx_ASSERT_xZkqqHx_iCkKjDkOiNoMiClFiCmIiCkCiPoKiNiHiCkKiCkAiCoJ_xHqqkZx_)-----
	return lMolipID / 2;
} // FCObjPoly::MolipIDToJointID.

//----------</NOT EXPORT TO VIEWER>-----------

#endif//__ObjPoly_h
