#include "stdafx.h"
#include "resource.h"			// For ProObjRoundRect.h.
#include "DynamicDrawView.h"	// For g_pView.
#include "ProObjRoundRect.h"	// For CFCProObjRoundRect.
#include "UtilRect.h"			// For GetRoundRectPolygon.
#include "UtilBezier.h"			// For FCMmPolyBezier.
#include "UndoArchive.h"		// For FCUndoArchive.
#include "RichText.h"			// For GetRichText().
#include "ObjRoundRect.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::FCObjRoundRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
FCObjRoundRect::FCObjRoundRect ()
{
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// memcmp_xZkqqHx_iCmFiDeJiDhFiDfHiDeGiDeOiDgHjEoEiKhCiCpAiClHiCoJiClNiCnPiBeBiNfMjBkCjBmMiDeNiDiDiDgCiDhGiCoAjBfDiCmEiCePiCmFjGiEiCnPiCoJiBeC_xHqqkZx_
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjRoundRect, m_nRoundType));
	memset(&m_nRoundType, 0, sizeof(FCObjRoundRect) - offsetof(FCObjRoundRect, m_nRoundType));
//----- 01.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	m_nRoundType	= FDOR_SAME_SIZE;
	m_mmRoundX		= 2.0;
	m_mmRoundY		= 2.0;
} // FCObjRoundRect::FCObjRoundRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL FCObjRoundRect::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_ROUND_RECT) return TRUE;
	return BASE_CLASS::IsKindOf(nType);
} // FCObjRoundRect::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType FCObjRoundRect::Type () const
{
	return FDOJ_ROUND_RECT;
} // FCObjRoundRect::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::IsEqual
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjDkPiOgNiCkKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiKkOjBfDiCmJjDjJiClFiCkCiCmMiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkNiBeBiLeAjEfMjDeJiCmJjDjJiClFiCkCiClBiCmGiCpAjClCiCnHiCoJiBeCjHoBiCkGiCmOiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmNjEoEiKhCiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	objp	:_xZkqqHx_jEoEiKhCjAoGiDeJiDhFiDfHiDeGiDeOiDgH_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jDjJiClFiCkCiPoKiNiHiBeB_xHqqkZx_ FALSE  :_xZkqqHx_iIoBiCkEiPoKiNiH_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCnMiClI_xHqqkZx_BASE_CLASS_xZkqqHx_iCmMjEoEiKhCiCpAiClHiCoJiBeCiClLiCmMiOjPiCmJiOkJjFkKiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCpA_xHqqkZx_
 *			_xZkqqHx_jEoEiKhCiClHiCoJiBeC_xHqqkZx_ObjDynabase::IsEqual_xZkqqHx_iCmFiDeOiDiJiDfIiCmMiMfOiCpAjEoEiKhCiClHiCoJiCmMiCmFiBeB_xHqqkZx_
 *			BASE_CLASS::IsEqual_xZkqqHx_iCkK_xHqqkZx_TRUE_xZkqqHx_iCmMiPoKiNiHiCmNiMfOiCmNjDjJiClFiCkCiCmGiClFiCmEiCoGiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCObjRoundRect::IsEqual (const FCObjDynabase* objp) const
{
	if (!BASE_CLASS::IsEqual(objp)) return FALSE;
	const FCObjRoundRect* trgp = static_cast<const FCObjRoundRect*>(objp);
	return (memcmp(&m_nRoundType, &trgp->m_nRoundType,
				sizeof(FCObjRoundRect) - offsetof(FCObjRoundRect, m_nRoundType)) == 0);
} // FCObjRoundRect::IsEqual.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCObjRoundRect::OutStream (FCUndoArchive& ar)
void FCObjRoundRect::OutStream (FCUndoArchive& ar, BOOL bIsOutBezier)
{
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	BASE_CLASS::OutStream(ar);
	BASE_CLASS::OutStream(ar, bIsOutBezier);
	ar << m_nRoundType;		// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiKhAiCmMjFmPiMgAjFpLiOkOiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
	ar << m_mmRoundX;		// _xZkqqHx_iKhAiCmMiCfDjFkKiCmMiCfAiJhOiCmMjElMiMgBiBgJiChHjFpLiMpMiBgKiBeC_xHqqkZx_
	ar << m_mmRoundY;		// _xZkqqHx_iKhAiCmMiCfDjFkKiCmMiCfAiJhOiCmMjElMiMgBiBgJiChIjFpLiMpMiBgKiBeC_xHqqkZx_
} // FCObjRoundRect::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_FCUndoArchive_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::InStream (FCUndoArchive& ar)
{
	BASE_CLASS::InStream(ar);
	ar >> m_nRoundType;		// _xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiKhAiCmMjFmPiMgAjFpLiOkOiCmMiDfOiDeDiDhGiBeC_xHqqkZx_
	ar >> m_mmRoundX;		// _xZkqqHx_iKhAiCmMiCfDjFkKiCmMiCfAiJhOiCmMjElMiMgBiBgJiChHjFpLiMpMiBgKiBeC_xHqqkZx_
	ar >> m_mmRoundY;		// _xZkqqHx_iKhAiCmMiCfDjFkKiCmMiCfAiJhOiCmMjElMiMgBiBgJiChIjFpLiMpMiBgKiBeC_xHqqkZx_
} // FCObjRoundRect::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiMmFjHeMiCmM_xHqqkZx_PropertyPage_xZkqqHx_iCpAiNoMjAkMiBeFiPiJiKpKiJlLiClFiBeBiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	: PropertyPage_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiInHiCmMiDiKiDfIiDgHiBeC_xHqqkZx_
 *			vSelect		: _xZkqqHx_jBeJjBpAjFjEjFgJiCmMiPfHiNiH_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::CreatePropertyPage (CPropertyPageVector& vPropPage,
											const ObjDynabaseVector& vSelect)
{
	BASE_CLASS::CreatePropertyPage(vPropPage, vSelect);
	ObjDynabaseVector::const_iterator i;
	for (i = vSelect.begin(); i != vSelect.end(); i++)
		if (!(*i)->IsKindOf(FDOJ_ROUND_RECT)) return;
	vPropPage.push_back(new CFCProObjRoundRect());
} // FCObjRoundRect::CreatePropertyPage.

//----- 01.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::GetIsOpenPolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCkKiKeKiCkCiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjRoundRect::GetIsOpenPolygon () const
//{
//	return FALSE;
//} // FCObjRoundRect::GetIsOpenPolygon.
//----- 01.03.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 99.12.31 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::NewObjPolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAjIfPjHjNiNmAjFfHiCmFiNoMjAkMiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vlgptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
// *			bIsClose	: _xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
// *			lgdElemLen	: _xZkqqHx_jClIjDfPiNmAjFfHiCmMjAlIjDhI_xHqqkZx_._xZkqqHx_jClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_
// *			lgrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
// *			iClipSize	: lgrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	lgptpPoly_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
// *************************************************************************/
//void FCObjRoundRect::NewObjPolygon (CPointVector& vlgptPoly,
//								BOOL& bIsClose, double lgdElemLen,
//								const CRect lgrtaClip[], int iClipSize) const
//{
//	//----- _xZkqqHx_iKhAiCmMiKnLiClDiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmMjFoCjAlDiPiIjHjN_xHqqkZx_ -----
//	double mmRoundX, mmRoundY;
//	if (m_mmHAxisX < m_mmRoundX)
//		mmRoundX = m_mmHAxisX;
//	else
//		mmRoundX = m_mmRoundX;
//
//	if (m_mmVAxisY < m_mmRoundY)
//		mmRoundY = m_mmVAxisY;
//	else
//		mmRoundY = m_mmRoundY;
//
//	::GetRoundRectPolygon(vlgptPoly,
//						g_->dZoom * m_mmptCenter.x, g_->dZoom * m_mmptCenter.y,
//						g_->dZoom * m_mmHAxisX, g_->dZoom * m_mmVAxisY,
//						g_->dZoom * mmRoundX, g_->dZoom * mmRoundY,
//						g_->dZoom * m_mmVAxisX, m_dAngle,
//						g_->dZoom * m_mmptCenter.x, g_->dZoom * m_mmptCenter.y);
//	bIsClose = TRUE;
//} // FCObjRoundRect::NewObjPolygon.
//----- 99.12.31 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::IsClosePolygon
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	NewObjPolygon_xZkqqHx_iCkKjFnEiClHiDhMiDiKiDfDiDjDiCkKjFmCiClGiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCObjRoundRect::IsClosePolygon () const
//{
//	return TRUE;
//} // FCObjRoundRect::IsClosePolygon.
//----- 01.11.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::NewObjPolygonForDraw
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	: _xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClH_xHqqkZx_.
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	: _xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiH_xHqqkZx_.
 *			iClipSize	: mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	mmElemLen_xZkqqHx_iCmNiBeBjClIjDfPiNmAjFfHiCpAiMhGiOfKiClHiCoJiOjOiCmJiBeBjHnHiCoIiNiHiCkEjClIjDfPiCmGjClIjDfPiCmM_xHqqkZx_
 *			_xZkqqHx_iKnEiCmMiLjHjHkDiCmMjGnKiImAiCpAiOkGiClHiBeC_xHqqkZx_mmElemLen_xZkqqHx_iCmMjCgMiCkKiPkMiClDiCkCiCnJiCmHjClIjDfPiKnEiCmM_xHqqkZx_
 *			_xZkqqHx_iLjHjHkDiCmNiLlHiCnMiCoIjAhNiMgAiCmMjAlIjDhIiCmNiMpMiPoDiClHiCoJiCkKiBeBiCoGiCoIjBlNiCkNiCmMiMhGiOfKiOjOiKnEiCmG_xHqqkZx_
 *			_xZkqqHx_iCoGiCoIjBlNiCkNiCmMiDiBiDiCiDiKiCpAjFeLjHhGiCmGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptpPoly_xZkqqHx_iCmN_xHqqkZx_delete[]_xZkqqHx_iCmFiKeKjFpKiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_.
 *************************************************************************/
void FCObjRoundRect::NewObjPolygonForDraw (	DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const
{
	//----- _xZkqqHx_iKhAiCmMiKnLiClDiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmMjFoCjAlDiPiIjHjN_xHqqkZx_ -----
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	double mmRoundX, mmRoundY;
//	if (m_mmHAxisX < m_mmRoundX)
//		mmRoundX = m_mmHAxisX;
//	else
//		mmRoundX = m_mmRoundX;
//
//	if (m_mmVAxisY < m_mmRoundY)
//		mmRoundY = m_mmVAxisY;
//	else
//		mmRoundY = m_mmRoundY;
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const double mmRoundX = GetRealRoundX();
	const double mmRoundY = GetRealRoundY();
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (mmElemLen < 0)
	//----- _xZkqqHx_iNmFjDeLjCgMiCpAiMhGiOfKiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKhAiCmM_xHqqkZx_10_xZkqqHx_jFkKiCmM_xHqqkZx_1 _xZkqqHx_iCpAiKoOiPiAiCmJiBeC_xHqqkZx_
		mmElemLen = (mmRoundX + mmRoundY) / 10.0;
		// _xZkqqHx_jFfHiPiAjCgMiCkKiPkMiClDiCkCiPoKiNiHiCmNiBeBjFfHiPiAjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
		if (FFGetStdElemLen() < mmElemLen)
			mmElemLen = FFGetStdElemLen();
	}
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	::GetRoundRectPolygon(	vmmptPoly, m_mmptCenter.x, m_mmptCenter.y,
							m_mmHAxisX, m_mmVAxisY, mmRoundX, mmRoundY,
							m_mmVAxisX, m_dAngle, m_mmptCenter.x, m_mmptCenter.y,
							mmElemLen);
} // FCObjRoundRect::NewObjPolygonForDraw.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::NewObjPolygonForResize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjHhAiCmMiDhMiDiKiDiJiDeDiDjDiNoMjAkMiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vmmptPoly	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			bIsClose	:_xZkqqHx_jAhNiMgAiCkK_xHqqkZx_CLOSE_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_TRUE,OPEN_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmElemLen	:_xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiJpAjBjMjDhIiCpAiOhHjCoIiBeCjClIjDfPiNmAjFfHiKnEiCmMiLjHjHkDiCmM_xHqqkZx_
 *						 _xZkqqHx_jGnKiImAiCpAiOkGiClHiBeCjFiJiCmMiPoKiNiHiCmNiNmFjDeLjCgMiCpAiOkJjDkOjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			mmrtaClip	:_xZkqqHx_jFgAiJoGiBgJiMhGiOfKiBgKjHmMiIoGiCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iClipSize	:mmrtaClip_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiOjOiCmMiDhEiDiMiBfLiDiAjFgAiJoGiCmGiBeBjFjEjFgJiDfEiDeDiDfJiMhGiOfKiOjOiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDePiDiLiBfLiDhGjFjEjFgJiCmMiCoGiCkEiCmJjFkBjAjEiCmMjFjEjFgJiCmMiPfHiNiHiCmMiPoKiNiHiBeB_xHqqkZx_DBL_MAX_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iLoGjAnIiCoHiCoKiClNjFkBjAjEiCmMiDhMiDiKiDiJiDeDiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::NewObjPolygonForResize (DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const
{
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAjIfPjHjNiNmAjFfHiMgOiCmFiOoGjDlOiBeC_xHqqkZx_
//	DBLRect mmrtClient;
//	g_pView->GetClientRectMM(mmrtClient);
//	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiDiKiBfLiDfHiDiHiDjDiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
//	// _xZkqqHx_iKhAiCmMiKnLiCkCiLoJiMgAiCmNiDiKiDfEiDeDiDfJiCkKjAlDiKgNiCmJiCmFiCkLiCmIiCkCiClNiCnPiBeBjCmKiPoNiCmMiLoJiMgAiCmMiDhMiDiKiDiJiDeDiDjDiCpAiOgHiCkEiBeC_xHqqkZx_
//	BASE_CLASS::NewObjPolygon(vmmptPoly, CalcElementLengthForResize(),
//								&mmrtClient, 1);
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iKhAiCmMiKnLiCkCiLoJiMgAiCmNiDiKiDfEiDeDiDfJiCkKjAlDiKgNiCmJiCmFiCkLiCmIiCkCiClNiCnPiBeBjCmKiPoNiCmMiLoJiMgAiCmMiDhMiDiKiDiJiDeDiDjDiCpAiOgHiCkEiBeC_xHqqkZx_
	BASE_CLASS::NewObjPolygonForDraw(vmmptPoly, mmElemLen, mmrtaClip, iClipSize);
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCObjRoundRect::NewObjPolygonForResize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::NewObjBezierForDraw
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiLnPiOjHiDhIiDfHiDeGiLmIjApMiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	polyBezier	: _xZkqqHx_iDhIiDfHiDeGiLmIjApMjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFjEjFgJjFgAiJoGjDjJiCmJjHjIjHhAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::NewObjBezierForDraw (FCMmPolyBezier& polyBezier) const
{
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iKhAiCmMiKnLiClDiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmMjFoCjAlDiPiIjHjN_xHqqkZx_ -----
//	double mmRoundX, mmRoundY;
//	if (m_mmHAxisX < m_mmRoundX)
//		mmRoundX = m_mmHAxisX;
//	else
//		mmRoundX = m_mmRoundX;
//
//	if (m_mmVAxisY < m_mmRoundY)
//		mmRoundY = m_mmVAxisY;
//	else
//		mmRoundY = m_mmRoundY;
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	FFGetRoundRectBezier(polyBezier,
						m_mmptCenter,
						m_mmHAxisX,
						m_mmVAxisY,
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//						mmRoundX,
//						mmRoundY,
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
						GetRealRoundX(),
						GetRealRoundY(),
//----- 06.12.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
						m_mmVAxisX,
						m_dAngle,
						m_mmptCenter);
} // FCObjRoundRect::NewObjBezierForDraw.

//----- 06.12.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::CalcArea
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMjGmKjAmPiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGmKjAmPiBeCjFlNjFpLiDhOiDiKiDiBiBfLiDgHiDiL_xHqqkZx_(mm^2)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jGmKjAmPiCmNiKfEiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
double FCObjRoundRect::CalcArea () const
{
	//
	// "_xZkqqHx_iKnLiKhAiLoJiMgAiCmMjGmKjAmPiMhGiOfK_xHqqkZx_.mdpf"_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
	//
	//----- _xZkqqHx_iKhAiCmMiKnLiClDiCkKjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmMjFoCjAlDiPiIjHjN_xHqqkZx_ -----
	const double mmRoundX = GetRealRoundX();
	const double mmRoundY = GetRealRoundY();
	const mmetol mmHAxisX = fabs(GetHAxisX());	// _xZkqqHx_jAhNiMgAiCmMjAiFjFlNiOlCiCmMjBoFiCkLiClDiBeCjFiJiCoAiCkAiCoIiBeC_xHqqkZx_
	const mmetol mmVAxisY = GetVAxisY();		// _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmM_xHqqkZx_Y_xZkqqHx_jAkMjFkKiBeCjAlDiCmMiCnNiBeC_xHqqkZx_

	// _xZkqqHx_jGmKjAmP_xHqqkZx_Ax2_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
	const double dA = 4.0 * mmRoundY * (mmHAxisX - mmRoundX);
	// _xZkqqHx_jGmKjAmP_xHqqkZx_Bx2_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
	const double dB = 4.0 * mmRoundX * (mmVAxisY - mmRoundY);
	// _xZkqqHx_jGmKjAmP_xHqqkZx_C_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
	const double dC = 4.0 * (mmHAxisX - mmRoundX) * (mmVAxisY - mmRoundY);
	// _xZkqqHx_jBmIiJhOiCmMjGmKjAmP_xHqqkZx_(D)_xZkqqHx_iCpAiMhGiOfKiBeC_xHqqkZx_
	const double dD = mmRoundX * mmRoundY * M_PI;
	return dA + dB + dC + dD;
} // FCObjRoundRect::CalcArea.
//----- 06.12.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::CalcResizeFrameSelf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKhAiCmMiKnLiCnNiCpAiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCmMiMhGiOfKiCmJiKnMiCnPiCoJiPoKiNiHiBeBiKhAiCkKiDiKiDfEiDeDiDfJiOjOiCmJ_xHqqkZx_
// *			_xZkqqHx_jFmPiMgAiClFiCmIiCkCiDiCiBfLiDgIiCmFiCmNiBeBiDiKiDfEiDeDiDfJiMoDiCmMiDhEiDiMiBfLiDiAiDfEiDeDiDfJiCkKiLlGiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
// *			_xZkqqHx_iClBiCoKiCpAjGgIiCkOiInHiBeB_xHqqkZx_FCObjRect_xZkqqHx_iCmMiDhEiDiMiBfLiDiAiCpAiClLiCmMiCnMiCnMiNmMjHhAiClHiCoJiCoGiCkEiCmJiClFiClNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkMiBeC_xHqqkZx_
// *************************************************************************/
//void FCObjRoundRect::CalcResizeFrameSelf ()
//{
//	DBLPointVector	vmmptPoint;
//	// _xZkqqHx_jAgFiDeOiDiJiDfIiCmMiDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//	BASE_CLASS::NewObjPolygon(vmmptPoint, FFGetStdElemLen(), NULL, 0);
//	// _xZkqqHx_jClIjDfPiNmAjFfHiCmJiKePjAnKiClHiCoJiLoJiMgAiCpAiLiBiCnPiCoJ_xHqqkZx_.
//	::FFCalcFrame(m_mmrtResize, vmmptPoint.size(), vmmptPoint.begin());
//	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
//	if (GetRichText() != NULL)
//	{
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		vmmptPoint.clear();
////		// _xZkqqHx_iDhMiDiKiDfDiDjDiCmMjClIjDfPiNmAjFfHjEhKjHpBiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
////// 01.07.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//////		NewObjPolygon(vmmptPoint, FFGetStdElemLen(), NULL, 0);
////		NewObjPolygonForText(vmmptPoint, FFGetStdElemLen(), NULL, 0);
////		GetRichText()->CalcTextLayout(NULL, vmmptPoint.begin(), vmmptPoint.size());
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiNmEjEhKjChFiBeC_xHqqkZx_
//		GetRichText()->CalcTextLayout(NULL, this);
////----- 05.03.02 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//	}
//} // FCObjRoundRect::CalcResizeFrameSelf.
//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

short FCObjRoundRect::GetRoundType () const
{
	return m_nRoundType;
} // FCObjRoundRect::GetRoundType.

mmetol FCObjRoundRect::GetRoundX () const
{
	return m_mmRoundX;
} // FCObjRoundRect::GetRoundX.

mmetol FCObjRoundRect::GetRoundY () const
{
	return m_mmRoundY;
} // FCObjRoundRect::GetRoundY.

//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::GetRealRoundX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmMiKhAiCmMiKnLiClD_xHqqkZx_(X_xZkqqHx_jFpLiMpM_xHqqkZx_)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmMiKhAiCmMiKnLiClD_xHqqkZx_(X_xZkqqHx_jFpLiMpM_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKhAiCmMiKnLiClDiCkKiBeBiLoJiMgAiCmJjBmOiClFiCmEjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmMjFoCjAlDiCpAiClFiClNjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjRoundRect::GetRealRoundX () const
{
	return (GetHAxisX() < GetRoundX()) ? GetHAxisX() : GetRoundX();
} // FCObjRoundRect::GetRealRoundX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::GetRealRoundY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmMiKhAiCmMiKnLiClD_xHqqkZx_(Y_xZkqqHx_jFpLiMpM_xHqqkZx_)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmMiKhAiCmMiKnLiClD_xHqqkZx_(Y_xZkqqHx_jFpLiMpM_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iKhAiCmMiKnLiClDiCkKiBeBiLoJiMgAiCmJjBmOiClFiCmEjBoFiCkLiClHiCkMiCoJiPoKiNiHiCmMjFoCjAlDiCpAiClFiClNjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
mmetol FCObjRoundRect::GetRealRoundY () const
{
	return (GetVAxisY() < GetRoundY()) ? GetVAxisY() : GetRoundY();
} // FCObjRoundRect::GetRealRoundY.
//----- 06.12.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::SetRoundType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAiCmMiDfOiDeDiDhGiCpAjAnNjCoI_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nRoundType	: _xZkqqHx_iKhAiCmMiDfOiDeDiDhG_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::SetRoundType (SHORT nRoundType)
{
	if (m_nRoundType == nRoundType) return;
	m_nRoundType = nRoundType;
// 99.12.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	::JustDid();
} // FCObjRoundRect::SetRoundType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::SetRoundX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAiCmMiDfEiDeDiDfJiCpAjAnNjCoI_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmX	: _xZkqqHx_iKhAiCmMiKnLiClD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::SetRoundX (mmetol mmX)
{
	if (m_mmRoundX == mmX) return;
	m_mmRoundX = mmX;
// 99.12.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	::JustDid();
} // FCObjRoundRect::SetRoundX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::SetRoundY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAiCmMiDfEiDeDiDfJiCpAjAnNjCoI_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmY	: _xZkqqHx_iKhAiCmMiKnLiClD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::SetRoundY (mmetol mmY)
{
	if (m_mmRoundY == mmY) return;
	m_mmRoundY = mmY;
// 99.12.02 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	::JustDid();
} // FCObjRoundRect::SetRoundY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::Copy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIpIjAjEiCmMjFjEjFgJiCmJjBkOjAkLiCpAiDfCiDhDiBfLiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	: _xZkqqHx_jBkOjAkLiCpAiDfCiDhDiBfLiClDiCoKiCoJjFjEjFgJ_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::Copy (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Copy(pObj);
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	FCObjRoundRect::CopySelf(pObj);
} // FCObjRoundRect::Copy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::CopySelf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmJjBkOiClHiCoJjBkOjAkLiCmMiCnNiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDfCiDhDiBfLjAoGiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::CopySelf (FCObjDynabase* pObj) const
{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFjGlDiCkPiCoKiCmOjFkBiOmKiClJiClIjFjMiLeBiBeC_xHqqkZx_
	if (!pObj->IsKindOf(FCObjRoundRect::Type())) return;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	ASSERT(ALIGNMENT8(sizeof(BASE_CLASS)) == offsetof(FCObjRoundRect, m_nRoundType));
	FCObjRoundRect* pRRect = reinterpret_cast<FCObjRoundRect*>(pObj);
	memcpy(&pRRect->m_nRoundType, &m_nRoundType,
			sizeof(FCObjRoundRect) - offsetof(FCObjRoundRect, m_nRoundType));
} // FCObjRoundRect::CopySelf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCObjRoundRect::ResizeNoChangeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ObjRect::Resize_xZkqqHx_jHhAiDfEiDhFiKnGjAjEiBeCjDpBiCmCiCmM_xHqqkZx_Resize_xZkqqHx_iKnGjAjEiCkJiCoHiLkEjCmKiCmF_xHqqkZx_
 *			_xZkqqHx_iOgHiCkEiClNiCnPiCmJiNoMjAkMiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDfEiDeDiDfJiPiIjHjNiCpAiNhDiCkEiCkKiBeB_xHqqkZx_m_mmrtResize_xZkqqHx_jFmPjAjEiCmMjFmPiNfIiCmNiNhDiCoNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptOrig	:_xZkqqHx_iDiKiDfEiDeDiDfJjBePiCmMiMlEjDfP_xHqqkZx_
 *			dptMagnif	:_xZkqqHx_iDiKiDfEiDeDiDfJiCmMjEoEjHkG_xHqqkZx_
 *			mmptOrigNew	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiMlEjDfP_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.01 Fukushiro M. Resize_xZkqqHx_iKnGjAjEiCkJiCoHjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void FCObjRoundRect::ResizeNoChangeFrame (	const DBLPoint& mmptOrig,
											const DBLPoint& dptMagnif,
											const DBLPoint& mmptOrigNew)
{
	switch (m_nRoundType)
	{
	case FDOR_SAME_RATIO:
		m_mmRoundX *= fabs(dptMagnif.x);
		m_mmRoundY *= fabs(dptMagnif.y);
		break;
	case FDOR_SAME_SIZE:
		break;
	}
	BASE_CLASS::ResizeNoChangeFrame(mmptOrig, dptMagnif, mmptOrigNew);
} // FCObjRoundRect::Resize.

