#ifndef __ObjTable_h
#define __ObjTable_h

#include "ObjGroup.h"	// Superclass.

//;----- <EXPORT TO SDK> -----;

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS FCObjGroup

//;------ </EXPORT TO SDK> -----;

class FCUndoArchive;
class FCObjTextRect;
class FCObjLine;
class FCHiCommandTable;

#define FD_OBJ_TABLE_MIN_CELL_WIDTH		mmetol(0.1)
#define FD_OBJ_TABLE_MIN_CELL_HEIGHT	mmetol(0.1)

//;----- <EXPORT TO SDK> -----;

// _xZkqqHx_iNhDiBeBjHpBiCmMiNfMjBkCjBmMiBeC_xHqqkZx_
struct FCLineColumn : public pair<long, long>
{
	FCLineColumn (long lLine = -1, long lColumn = -1) : pair<long, long>(lLine, lColumn) {}
	long GetLineIndex () const { return first; }
	long GetColumnIndex () const { return second; }
	void Set (long lLine, long lColumn) { first = lLine; second = lColumn; }
	void SetLineIndex (long lLine) { first = lLine; }
	void SetColumnIndex (long lColumn) { second = lColumn; }
	void IncHorz (long lColumnCount) { second++; if (lColumnCount == second) { first++; second = 0; } }
	void IncVert (long lLineCount) { first++; if (lLineCount == first) { second++; first = 0; } }
}; // struct FCLineColumn.

// _xZkqqHx_iMhCjApMiCpAiBeBjAlDjGmKiBgJiOlCjFpLiMpMiBgKiCkJiCoHiCnNiClNiPoKiNiHiCmMiNmAjFfHiBeBiJkBiCkJiCoHiCnNiClNiPoKiNiHiCmMiNmAjFfHiBeC_xHqqkZx_
struct FCFrontSide : public pair<long, long>
{
	FCFrontSide (long lFrontIndex = -1, long lSideIndex = -1) : pair<long, long>(lFrontIndex, lSideIndex) {}
	long GetFrontIndex () const { return first; }
	long GetSideIndex () const { return second; }
	void Set (long lFrontIndex, long lSideIndex) { first = lFrontIndex; second = lSideIndex; }
	void SetFrontIndex (long lFront) { first = lFront; }
	void SetSideIndex (long lSide) { second = lSide; }
	void IncHorz (long lFrontCount) { first++; if (lFrontCount == first) { second++; first = 0; } }
	void IncVert (long lSideCount) { second++; if (lSideCount == second) { first++; second = 0; } }
}; // struct FCFrontSide.

//;------ </EXPORT TO SDK> -----;

class FCObjTable : public SUPER_CLASS
{
protected:
typedef SUPER_CLASS BASE_CLASS;
typedef BASE_CLASS::BASE_CLASS BASE_BASE_CLASS;

public:
	//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	FCObjTable ();
	virtual BOOL	IsKindOf (FTObjectType nType) const;

	//----- _xZkqqHx_iOmAjBmMiJlLiJmCjEfMiCmIiDeOiDiJiDfIiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual FTObjectType	Type () const;

	//----- Subclass_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	OnDraw (CDC* pDC, BOOL bIsMono);

	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual BOOL	IsEqual (const FCObjDynabase* objp) const;
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	OutStream (FCUndoArchive& ar);
	virtual void	OutStream (FCUndoArchive& ar, BOOL bIsOutBezier);
	virtual void	InStream (FCUndoArchive& ar);

	//----- _xZkqqHx_iKePiMgAiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
//----- 05.06.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	NewObjPolygonForResize (DBLPointVector& vmmptPoly,
											mmetol mmElemLen,
											const DBLRect mmrtaClip[],
											int iClipSize) const;
//----- 05.06.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// 05.07.25 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual BOOL	CanRotate () const;

	//----- _xZkqqHx_jFkBjAjEiCmMiDiCiDiKiDhGiCpAiOjNiCmC_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
// 05.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual BOOL	IsLineMolip (long lMolipId) const;

	//----- _xZkqqHx_jFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClHiCoKiCmOjHmHiCkC_xHqqkZx_ -----
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	GetIsResizableHorz (mmetol mmWidth) const;
//	virtual BOOL	GetIsResizableVert (mmetol mmHeight) const;
//----- 05.06.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

// 05.02.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	CalcResizeFrameSelf ();

//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual WORD	GetMemberResizeHorzByText (const FCObjDynabase* pObj) const;
//	virtual WORD	GetMemberResizeVertByText (const FCObjDynabase* pObj) const;
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual WORD	GetMemberFixResizeByText (const FCObjDynabase* pObj) const;
//----- 05.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual BOOL	GetIsMemberShortenByText (const FCObjDynabase* pObj) const;
	virtual void	AdjustObjectSize (	FCObjDynabase* pTextObj,
										double dRatioHorz,
										double dRatioVert,
										const DBLPoint& mmptFixPoint);

//----- 05.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//----- 06.11.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	virtual BOOL	CanCopyText () const;
//	virtual void	CopyText () const;
//----- 06.11.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.07.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual BOOL	CanGetText () const;
	virtual BOOL	GetText (WString& wstr, BOOL bIs2CR = FALSE, BOOL bIsCutLastCR = FALSE) const;
//----- 06.11.16 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
// 06.11.21 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	SetText (const wchar_t* wcpText);

// 06.11.17 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	PasteOverAs (const FCObjFigure& objFig, DWORD dwPasteAttr);

	virtual ~FCObjTable ();

public:
	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
	virtual void	InitTable ();
	virtual void	InitTable (long lLineCount, long lColumnCount);
	virtual void	DuplicateLine (	ObjDynabaseVector& vNewCell,
									ObjDynabaseVector& vNewHorzRuled,
									ObjDynabaseVector& vNewVertRuled,
									long lLineIndex,
									BOOL bRegisterObjId) const;
	virtual void	DuplicateColumn (	ObjDynabaseVector& vNewCell,
										ObjDynabaseVector& vNewVertRuled,
										ObjDynabaseVector& vNewHorzRuled,
										long lColumnIndex,
										BOOL bRegisterObjId) const;

	virtual mmetol	InsertLine (const ObjDynabaseVector& vAppendCell,
								const ObjDynabaseVector& vAppendHorzRuled,
								const ObjDynabaseVector& vAppendVertRuled,
								long lLineIndex,
								mmetol mmHeight);

	virtual mmetol	InsertColumn (	const ObjDynabaseVector& vAppendCell,
									const ObjDynabaseVector& vAppendVertRuled,
									const ObjDynabaseVector& vAppendHorzRuled,
									long lColumnIndex,
									mmetol mmWidth);

	virtual void	DeleteLine (ObjDynabaseVector& vRemoveCell,
								ObjDynabaseVector& vRemoveHorzRuled,
								ObjDynabaseVector& vRemoveVertRuled,
								long lLineIndex);
	virtual void	DeleteColumn (	ObjDynabaseVector& vRemoveCell,
									ObjDynabaseVector& vRemoveVertRuled,
									ObjDynabaseVector& vRemoveHorzRuled,
									long lColumnIndex);


	virtual long	GetLineCount () const;
	virtual long	GetColumnCount () const;
	virtual mmetol	GetLineHeight (long lLineIndex) const;
	virtual mmetol	GetColumnWidth (long lColumnIndex) const;
	virtual void	SetLineHeight (long lLineIndex, mmetol mmWidth);
	virtual void	SetColumnWidth (long lColumnIndex, mmetol mmWidth);

	virtual mmetol	GetCellTopCoord (long lLineIndex) const;
	virtual mmetol	GetCellLeftCoord (long lColumnIndex) const;

	virtual BOOL	GetHorzRuledY (mmetol& mmY, long lFrontIndex) const;
	virtual BOOL	GetVertRuledX (mmetol& mmX, long lFrontIndex) const;

	virtual void	CalcLineTopBottomArray (vector< pair<mmetol, mmetol> >& vTopBottom) const;
	virtual void	CalcColumnLeftRightArray (vector< pair<mmetol, mmetol> >& vLeftRight) const;
	virtual void	GetCellFrameRuled (	set<FCFrontSide>* stLeftRuledIndex,
										set<FCFrontSide>* stTopRuledIndex,
										set<FCFrontSide>* stRightRuledIndex,
										set<FCFrontSide>* stBottomRuledIndex,
										const FCLineColumn& cellIndex) const;

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
	virtual FCObjTextRect*			GetCell (const FCLineColumn& cellIndex);
	virtual const FCObjTextRect*	GetCell (const FCLineColumn& cellIndex) const;
	virtual FCObjLine*				GetRuled (BOOL bIsHorz, const FCFrontSide& ruledIndex);
	virtual const FCObjLine*		GetRuled (BOOL bIsHorz, const FCFrontSide& ruledIndex) const;

	virtual void 	SetCell (const FCLineColumn& cellIndex, FCObjTextRect* pCell);
	virtual void 	SetRuled (BOOL bIsHorz, const FCFrontSide& ruledIndex, FCObjLine* pRuled);

	virtual void	GetIncludedRuled (	set<FCFrontSide> &stHorzRuled,
										set<FCFrontSide>& stVertRuled,
										const FCLineColumn& cellIndexFrom,
										const FCLineColumn& cellIndexUntil) const;
	virtual long	GetCellBlock (	const FCLineColumn& cellIndex,
									FCLineColumn* pCellIndexFrom = NULL,
									FCLineColumn* pCellIndexUntil = NULL) const;
	virtual FCLineColumn	GetCellBlockFrom (const FCLineColumn& cellIndex) const;
	virtual FCLineColumn	GetCellBlockUntil (const FCLineColumn& cellIndex) const;

	virtual void	GetFinalCellBlock (	FCLineColumn& cellIndexFrom,
										FCLineColumn& cellIndexUntil,
										const FCLineColumn& cellIndexFromFirst,
										const FCLineColumn& cellIndexUntilFirst) const;
	virtual void	GetIncludedCell (	set<FCLineColumn>& stCellIndex,
										const FCLineColumn& cellIndexFrom,
										const FCLineColumn& cellIndexUntil) const;
	virtual void	GetRealCell (set<FCLineColumn>& stRealCellIndex,
								 set<FCLineColumn> stVirtualCellIndex) const;

	virtual BOOL	GetCellIndex (FCLineColumn& cellIndex, const FCObjDynabase* pCell) const;

	static void		OnTableProperties (	DWORD dwTitleId,
										BOOL bIsToolInside,
										FCObjTable* pTable,
										const set<FCLineColumn>* stCellId,
										const set<FCFrontSide>* stHorzRuledId,
										const set<FCFrontSide>* stVertRuledId,
										DWORD dwFrontPage = 0);

friend class FCHiCommandTable;
protected:
	//----- _xZkqqHx_jBkOjAkLiCpAiOjNiCmCjBfDiCmEiCmM_xHqqkZx_Subclass_xZkqqHx_iCkKiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkC_xHqqkZx_ -----
	virtual void	Copy (FCObjDynabase* pObj) const;
	virtual void	CopySelf (FCObjDynabase* pObj) const;

//----- 05.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_jFeLjHhGiCmJiJjOiClGiCmEiDeDiDjDiDhGiDiKiDiBiDjDiDgHiClHiCoKiCmOjHmHiCkC_xHqqkZx_ -----
	virtual void	Move (mmetol mmDX, mmetol mmDY);
	virtual void	Resize (BOOL bXPosi, BOOL bYPosi, const DBLRect& mmrtNew, const DBLRect& mmrtOld);
// 05.03.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual void	Rotate (double dR, mmetol mmCX, mmetol mmCY);
	virtual void	Rotate (double dR, const DBLPoint& mmptCenter);
//----- 05.02.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 05.06.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	virtual void	OutSizeStream (BYTEVector& vBuff, BOOL bXPosi, BOOL bYPosi) const;
	virtual void	InSizeStream (const BYTE*& pBuff);
//----- 05.06.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_iClBiCmMiDeOiDiJiDfIiMmFjHeMiCmMiKnGjAjE_xHqqkZx_ -----
	virtual void	LayoutCellRuled ();
// 05.02.16 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	virtual void	EraseObjGroup (const longSet& stMemberIndex);
	virtual void	MemberArrayToObjArray (vector<ObjDynabaseVector>& vvObj, const vector<longVector>& vvMemberIndex) const;
	virtual void	ObjArrayToMemberArray (vector<longVector>& vvMemberIndex, const vector<ObjDynabaseVector>& vvObj) const;
	virtual mmetol	GetCellWidthMin (const FCLineColumn& cellIndex) const;
	virtual mmetol	GetCellHeightMin (const FCLineColumn& cellIndex) const;

// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual BOOL	CalcNewColumnWidth (mmetolVector& vNewColumnWidth, mmetol mmNewWidth) const;
	virtual void	CalcNewColumnWidth (mmetolVector& vNewColumnWidth, mmetol mmNewWidth) const;
	virtual void	CalcColumnMinMax (mmetol& mmMin, mmetol& mmMax, long lColumnIndex) const;
// 05.06.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	virtual BOOL	CalcNewLineHeight (mmetolVector& vNewLineHeight, mmetol mmNewHeight) const;
	virtual void	CalcNewLineHeight (mmetolVector& vNewLineHeight, mmetol mmNewHeight) const;
	virtual void	CalcLineMinMax (mmetol& mmMin, mmetol& mmMax, long lLineIndex) const;

// 05.08.02 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	virtual void	AdjustObjectSize (const DBLPoint& mmptFixPoint);


protected:
	DBLPoint	m_mmptLeftTop;			// _xZkqqHx_iNlGiPoDiNmAjFfHiBeCjAgFiCmMiDePiDiLiBfLiDhGjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCkK_xHqqkZx_
										// _xZkqqHx_iOhBjFjEjFgJiCmJiImLjBlGiClFiCmEjFmPiJlLiClHiCoJiCmMiCmFiBeBiClBiClBiCmFiLeMiJkPiBeC_xHqqkZx_
	//----- _xZkqqHx_jGhLjHiIiCmN_xHqqkZx_vector_xZkqqHx_iCpAiOgHiCoNiClIjEhKjHpBiCmFiNoMiCoIiClNiCkCiCkK_xHqqkZx_ -----
	//		_xZkqqHx_jEhKjHpBiCpAiOgHiCkEiCmGjBoFjFmPiCmIiCmMiCmFiBeB_xHqqkZx_vector _xZkqqHx_iCmFjBoDjHhA_xHqqkZx_ -----
	mmetolVector			m_vLineHeight;	// _xZkqqHx_iNhDiCmMiNiCiClDjEhKjHpBiBeC_xHqqkZx_
	mmetolVector			m_vColumnWidth;	// _xZkqqHx_jHpBiCmMjFjNjEhKjHpBiBeC_xHqqkZx_
	vector<ObjDynabaseVector>	m_vvCell;		// _xZkqqHx_iDfKiDiLiCmMjFjEjFgJjEhKjHpBiBeC_xHqqkZx_
	vector<ObjDynabaseVector>	m_vvHorzRuled;	// _xZkqqHx_jAiFjFlNiMhCjApMiCmMjFjEjFgJjEhKjHpBiBeC_xHqqkZx_
	vector<ObjDynabaseVector>	m_vvVertRuled;	// _xZkqqHx_jAiCjClMiMhCjApMiCmMjFjEjFgJjEhKjHpBiBeC_xHqqkZx_
}; // class FCObjTable.

#endif//__ObjTable_h
