#ifndef __PolyJoint_h
#define __PolyJoint_h

template<class T> class FCPolyBezier;
typedef FCPolyBezier<DBLPoint> FCMmPolyBezier;
struct FCBezierControls;
typedef vector<FCBezierControls> FCBezierControlsVector;

/**********************************************************************
 * class FCPolyJoint
 **********************************************************************/

//;----- <EXPORT TO SDK> -----;

// _xZkqqHx_iDhIiDfHiDeHiLmIjApMiCmMjDfPiCmMiOoNjHnOiBeC_xHqqkZx_
enum
{
	FDJT_NONE		= 0x00,
	FDJT_PRE_PULL_0	= 0x01,	// _xZkqqHx_jBePiIpIjDfPiCkKjGlDiClFiBeC_xHqqkZx_
	FDJT_PST_PULL_0	= 0x04,	// _xZkqqHx_iMoDiIpIjDfPiCkKjGlDiClFiBeC_xHqqkZx_
	FDJT_BTH_PULL_0	= 0x05,	// _xZkqqHx_jBePiMoDiIpIjDfPiCkKjGlDiClFiBeC_xHqqkZx_
	FDJT_SHARP		= 0x10,	// _xZkqqHx_jBePiIpIjDfPiCmGiMoDiIpIjDfPiCmNjEpBjDkPiKpKiBeC_xHqqkZx_
	FDJT_ROUND		= 0x20	// _xZkqqHx_jBePiIpIjDfPiCmGiMoDiIpIjDfPiCmNjDkPiKpKiBeC_xHqqkZx_
};

//;----- </EXPORT TO SDK> -----;

struct JointSeq
{
	JointSeq () :lStart(0), lSize(0) {}
	JointSeq (long l0, long l1) :lStart(l0), lSize(l1) {}
	void Set (long l0, long l1) {lStart = l0; lSize = l1;}
	long lStart;
	long lSize;
}; // struct JointSeq.

//----------<NOT EXPORT TO VIEWER>-----------
typedef vector<JointSeq> JointSeqVector;
//----------</NOT EXPORT TO VIEWER>-----------

class FCUndoArchive;

//;----- <EXPORT TO SDK> -----;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCPolyJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhIiDfHiDeHiLmIjApMiCmMjIeBiMiLjDfPiCpAjFfMiClHiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCPolyJoint
{
//;----- </EXPORT TO SDK> -----;

public:
	FCPolyJoint ();
	FCPolyJoint (short nType, DBLPoint mmptPivot,
				DBLPoint mmptPrev, DBLPoint mmptNext);

	short		GetJointType () const;
	DBLPoint	GetPivotPoint () const;
	DBLPoint	GetPrevPullPoint () const;
	DBLPoint	GetNextPullPoint () const;

	mmetol		GetPivotX () const;
	mmetol		GetPivotY () const;
	mmetol		GetPrevPullX () const;
	mmetol		GetPrevPullY () const;
	mmetol		GetNextPullX () const;
	mmetol		GetNextPullY () const;

	DBLRect		GetPrevChar1Rect () const;
	DBLRect		GetPrevChar2Rect () const;
	DBLRect		GetNextChar1Rect () const;
	DBLRect		GetNextChar2Rect () const;

//----------<NOT EXPORT TO VIEWER>-----------

	void	SetJointType (short nType);
	void	MovePivot (const DBLPoint& mmptMov);
	void	SetPivotX (mmetol mm);
	void	SetPivotY (mmetol mm);
	void	MovePrev (const DBLPoint& mmptMov);
	void	SetPrevPullX (mmetol mm);
	void	SetPrevPullY (mmetol mm);
	void	MoveNext (const DBLPoint& mmptMov);
	void	SetNextPullX (mmetol mm);
	void	SetNextPullY (mmetol mm);
	void	SetAutoPrevPull (const DBLPoint& mmpt);
	void	SetAutoNextPull (const DBLPoint& mmpt);

// 05.09.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	void	DrawPivotMark (CDC* pDC) const;
	void	DrawPullMark (CDC* pDC) const;
	BOOL	IsHitPrevPull (const DBLPoint& mmpt) const;
	BOOL	IsHitNextPull (const DBLPoint& mmpt) const;

	CRect	GetPrevPullRgn () const;
	CRect	GetNextPullRgn () const;

//----------</NOT EXPORT TO VIEWER>-----------

	void	OutStream (FCUndoArchive& ar) const;
	void	InStream (FCUndoArchive& ar);

//;----- <EXPORT TO SDK> -----;
public:
	short		m_nType;
	DBLPoint	m_mmptPivot;	// _xZkqqHx_iDeKiDgJiDiBjDfP_xHqqkZx_.
	DBLPoint	m_mmptPrev;		// _xZkqqHx_jBePiIpIjDfP_xHqqkZx_(_xZkqqHx_iDeKiDgJiDiBjDfPiCkJiCoHiCmMjBiKjBmOiNmAjFfH_xHqqkZx_).
	DBLPoint	m_mmptNext;		// _xZkqqHx_iMoDiIpIjDfP_xHqqkZx_(_xZkqqHx_iDeKiDgJiDiBjDfPiCkJiCoHiCmMjBiKjBmOiNmAjFfH_xHqqkZx_).
}; // class FCPolyJoint.

//;----- </EXPORT TO SDK> -----;

inline BOOL almosteq (const FCPolyJoint& a, const FCPolyJoint& b)
{
	return (a.m_nType == b.m_nType) &&
			almosteq(a.m_mmptPivot, b.m_mmptPivot) &&
			almosteq(a.m_mmptPrev, b.m_mmptPrev) &&
			almosteq(a.m_mmptNext, b.m_mmptNext);
} // almosteq.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCPolyJointVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCPolyJoint_xZkqqHx_iCmMiPfHiNiHiCpAjFfMiClHiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.24 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCPolyJointVector : public vector<FCPolyJoint>
{
protected:
typedef vector<FCPolyJoint> BASE_CLASS;

public:
	FCPolyJointVector ();
	FCPolyJointVector (long lSize, const FCPolyJoint *pJoint, BOOL bIsOpen);
	void	SetOpenStatus (BOOL bIsOpen);
	BOOL	IsOpen () const;
	void	GetAffected (JointSeq& jntSeq, long idx) const;
	void	GetAffected (JointSeqVector& vJntSeq,
						const longVector &vIdx) const;
	long	FindHitPivot (const CPoint& lgptMsc) const;
// 05.09.07 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	void	DrawPivotMark (CDC* pDC) const;
	void	DeleteJoints (const longVector& vIdx);
	void	operator = (const FCPolyJointVector& vPJ);
protected:
	BOOL	m_bIsOpen;
}; // class FCPolyJointVector.

//----------<NOT EXPORT TO VIEWER>-----------
extern void ReversePolyJoint (FCPolyJoint aPolyJoint[], long lSize);
//----------</NOT EXPORT TO VIEWER>-----------

extern void FFControlConv (	FCMmPolyBezier& polyBezier,
							const FCPolyJoint* pPolyJoint,
							long lJointSize,
							BOOL bIsOpenPoly);
extern void FFControlConv (	FCBezierControlsVector& vControls,
							const FCPolyJoint* pPolyJoint,
							long lJointSize,
							BOOL bIsOpenPoly);
extern void FFControlConv (	FCPolyJointVector& vPolyJoint,
							const FCBezierControls* pControls,
							long lControlSize,
							BOOL bIsOpenPoly);

// 06.12.04 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
extern void FFCalcFrame (DBLRect& mmrt, long lCount, const FCPolyJoint joints[]);

#endif//__PolyJoint_h
