#include "stdafx.h"
#include "UtilCoord.h"			// For mm2lg.etc.
#include "UtilMisc.h"				// For ResizePolygon.
#include "UtilGraph.h"			// For FCEditDraw.
#include "RegData.h"			// For g_pReg.
#include "DynamicDrawView.h"	// For g_pView.
#include "ObjDynabase.h"			// For FCObjDynabase.
#include "ResizeWork.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::FCResizeWork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCResizeWork::FCResizeWork ()
{
} // FCResizeWork::FCResizeWork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::~FCResizeWork
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCResizeWork::~FCResizeWork ()
{
} // FCResizeWork::~FCResizeWork.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::OnResizeFirst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiBeBiDiKiDfEiDeDiDfJiCmMiNmFiPiJiCmMiDfIiDgFiDgCiDhGiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P222,P230
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fncCallback	:_xZkqqHx_iDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
 *			ojpTarget	:_xZkqqHx_iDfOiBfLiDfBiDgCiDgHjFjEjFgJiCpAjAnNjCoIiBeCiDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiKnGjAjEiCmJjDgOiClDiCoKiCoJiBeC_xHqqkZx_
 *			pDC			:CDC_xZkqqHx_iBeC_xHqqkZx_
 *			nHandle		:_xZkqqHx_iDhNiDeFiDfIiCmFjFjEjFgJiCmMiCmHiClBiCkKiDeOiDiKiDgCiDeOiClDiCoKiClNiCkJiCpAiOkGiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.28 Fukushiro M. work_xZkqqHx_iCpAiOgHiCmBiClNiMgAiCmJjBoFjFjNjFmPiNfI_xHqqkZx_.
 *			98.10.10 Fukushiro M. ObjDynabase_xZkqqHx_iCkJiCoH_xHqqkZx_Tool_xZkqqHx_iCnGiInKjDkO_xHqqkZx_.
 *			99.04.22 Fukushiro M. Tool_xZkqqHx_iCkJiCoHjDmGjHkHiClFiClNiDeOiDiJiDfIiCnGiBeC_xHqqkZx_
 *			99.05.25 Fukushiro M. _xZkqqHx_iDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiKnGjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *								  _xZkqqHx_jApMjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiCkKjFjNiBgJiNiCiClDiBgKiCePiCpA_xHqqkZx_
 *								  _xZkqqHx_jFhDiJmCiCmGiClHiCoJiClNiCnPiBeBiDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiKnGjAjEiCpA_xHqqkZx_
 *								  _xZkqqHx_jDmGiOkJiCmJjDgOiClHiOgEjHgMiCmJiClFiClNiBeC_xHqqkZx_
 *************************************************************************/
void FCResizeWork::OnResizeFirst (ResizeCheckCallback fncCallback,
								const FCObjDynabase* ojpTarget, CDC* pDC,
								short nHandle)
{
	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiDgAiDeGiDgCiDeOiKnGjAjEiCmGiIpIjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	m_fncResizeCheck = fncCallback;
	m_ojpTarget = ojpTarget;

	m_mmrtFrameOrig = ojpTarget->GetResizeFrame();
	m_mmrtFrame = m_mmrtFrameOrig;
	m_vLimitLine.clear();
	m_mmDummyX = (m_mmrtFrameOrig.left + m_mmrtFrameOrig.right) / 2.0;
	m_mmDummyY = (m_mmrtFrameOrig.top + m_mmrtFrameOrig.bottom) / 2.0;

	//----- _xZkqqHx_iDeOiDiKiDgCiDeOiClDiCoKiClNiDiKiDfEiDeDiDfJiDhMiDeDiDjDiDgHiCmJiJjOiClGiCmEiBeB_xHqqkZx_
	//		_xZkqqHx_iDhMiDeDiDjDiDfOjFmPjAjE_xHqqkZx_ mmpMoveX,mmpMoveY _xZkqqHx_iCpA_xHqqkZx_
	//		mmrtFrame _xZkqqHx_iCmMjDeLjAnIiCmIjFmPjAjE_xHqqkZx_ (left,,,,)_xZkqqHx_iCmJiDhMiDeDiDjDiDgHiClHiCoJ_xHqqkZx_ -----
	if (nHandle & FD_RPT_H_LEFT)
	{
		m_mmpMoveX = &m_mmrtFrame.left;
		m_mmpMoveX_ = &m_mmrtFrame.right;
	} else if (nHandle & FD_RPT_H_RIGHT)
	{
		m_mmpMoveX = &m_mmrtFrame.right;
		m_mmpMoveX_ = &m_mmrtFrame.left;
	} else // if (nHandle & FD_RPT_H_CENTER)
	{
		m_mmpMoveX = &m_mmDummyX;
		m_mmpMoveX_ = &m_mmDummyX;
	}
	if (nHandle & FD_RPT_V_TOP)
	{
		m_mmpMoveY = &m_mmrtFrame.top;
		m_mmpMoveY_ = &m_mmrtFrame.bottom;
	} else if (nHandle & FD_RPT_V_BOTTOM)
	{
		m_mmpMoveY = &m_mmrtFrame.bottom;
		m_mmpMoveY_ = &m_mmrtFrame.top;
	} else // if (nHandle & FD_RPT_V_CENTER)
	{
		m_mmpMoveY = &m_mmDummyY;
		m_mmpMoveY_ = &m_mmDummyY;
	}
	// _xZkqqHx_iMmFjCoIiDhMiDeDiDjDiDgHiBeC_xHqqkZx_
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (g_pReg->GetIsFixHorzCenterResize())
	if (g_pReg->GetResizeFixPosition() & FD_RPT_H_CENTER)
	//----- _xZkqqHx_jAiFjFlNjFpLiMpMiDiKiDfEiDeDiDfJiCpAjFjEjFgJjCiGjAfDiCmJiDiKiDfEiDeDiDfJiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFix.x = m_mmDummyX;
	} else
	//----- _xZkqqHx_jAiFjFlNjFpLiMpMiDiKiDfEiDeDiDfJiCpAjCmKiPoNiCmJiDiKiDfEiDeDiDfJiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFix.x = *m_mmpMoveX_;
		m_mmpMoveX_ = &m_mmDummyX;
	}
// 05.05.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (g_pReg->GetIsFixVertCenterResize())
	if (g_pReg->GetResizeFixPosition() & FD_RPT_V_CENTER)
	//----- _xZkqqHx_jAiCjClMjFpLiMpMiDiKiDfEiDeDiDfJiCpAjFjEjFgJjCiGjAfDiCmJiDiKiDfEiDeDiDfJiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFix.y = m_mmDummyY;
	} else
	//----- _xZkqqHx_jAiCjClMjFpLiMpMiDiKiDfEiDeDiDfJiCpAjCmKiPoNiCmJiDiKiDfEiDeDiDfJiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		m_mmptFix.y = *m_mmpMoveY_;
		m_mmpMoveY_ = &m_mmDummyY;
	}

	// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiCmMiPiJiKpKjCgMiBeC_xHqqkZx_
	m_mmptMoveOrig = DBLPoint(*m_mmpMoveX, *m_mmpMoveY);
	/*----- m_vLineLimit_xZkqqHx_iCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----*/
	DBLPoint mmptMov(*m_mmpMoveX, *m_mmpMoveY);
	m_vLimitLine.push_back(DBLLine(m_mmptFix, mmptMov));
	if (!m_vLimitLine.back().IsVertical() && !m_vLimitLine.back().IsHorizontal())
	//----- _xZkqqHx_iNmFiPiJiCmMjAkHiMmAjApMiCkKjAiCjApMiCmFiCoAjAiFjFlNjApMiCmFiCoAiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMmFjCoIjDfPiCpAjCmKiCoIiBeBiKiOiCmCjClMjApM_xHqqkZx_(_xZkqqHx_iInKjDkOjDfP_xHqqkZx_-_xZkqqHx_iMmFjCoIjDfP_xHqqkZx_)_xZkqqHx_iCmJjAiCjClMiCmIjApMiCpAjAkHiMmAjApMiCmJjCmHiJmBiBeC_xHqqkZx_
		DBLPoint mmptDif = mmptMov - m_mmptFix;
		mmptMov.x = m_mmptFix.x + mmptDif.y;
		mmptMov.y = m_mmptFix.y - mmptDif.x;
		m_vLimitLine.push_back(DBLLine(m_mmptFix, mmptMov));
	}
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	ojpTarget->NewObjPolygonForResize(m_vmmptPoly);
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAjIfPjHjNiNmAjFfHiMgOiCmFiOoGjDlOiBeC_xHqqkZx_
	DBLRect mmrtClient;
	g_pView->GetClientRectMM(mmrtClient);
	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAiDiKiBfLiDfHiDiHiDjDiCmGiClFiCmEjAnNjCoIiBeC_xHqqkZx_
	ojpTarget->NewObjPolygonForResize(	m_vmmptPoly,
										CalcElementLengthForResize(ojpTarget),
										&mmrtClient, 1);
//----- 05.03.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	m_vlgptPoly.assign(m_vmmptPoly.size());
	FFResizePolygon(m_vlgptPoly.begin(), m_vlgptPoly.size(), m_vmmptPoly.begin(),
					m_mmrtFrameOrig, TRUE, TRUE, m_mmrtFrameOrig);
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_ojpTarget->GetStdPenWeight()));
	eDraw.Polyline(m_vlgptPoly.begin(), m_vlgptPoly.size());
} // OnResizeFirst.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	OnResizeNext
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiBeBiDiKiDfEiDeDiDfJiCmM_xHqqkZx_2_xZkqqHx_jEnEjGnKiImIiNhOiCmMiDfIiDgFiDgCiDhGiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P222,P230
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		: CDC*
 *			nFlags	: _xZkqqHx_iDeMiBfLiCmMiPpDjBnE_xHqqkZx_
 *			mmptMsc	: _xZkqqHx_iDhNiDeFiDfIiCmMiNmAjFfHiCpAiOpDiCkPiOoGiCoIiBeBjFmPiKlHiMoDiCmMiNmAjFfHiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiClN_xHqqkZx_.
 *			FALSE	: _xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiCmEiCkCiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.28 Fukushiro M. work_xZkqqHx_iCpAiOgHiCmBiClNiMgAiCmJjBoFjFjNjFmPiNfI_xHqqkZx_.
 *			98.10.10 Fukushiro M. ObjDynabase_xZkqqHx_iCkJiCoH_xHqqkZx_Tool_xZkqqHx_iCnGiInKjDkO_xHqqkZx_.
 *			99.04.22 Fukushiro M. Tool_xZkqqHx_iCkJiCoHjDmGjHkHiClFiClNiDeOiDiJiDfIiCnGiBeC_xHqqkZx_
 *			99.05.25 Fukushiro M. _xZkqqHx_iDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiKnGjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *								  _xZkqqHx_jApMjFjEjFgJiCmMiDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiCkKjFjNiBgJiNiCiClDiBgKiCePiCpA_xHqqkZx_
 *								  _xZkqqHx_jFhDiJmCiCmGiClHiCoJiClNiCnPiBeBiDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiKnGjAjEiCpA_xHqqkZx_
 *								  _xZkqqHx_jDmGiOkJiCmJjDgOiClHiOgEjHgMiCmJiClFiClNiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCResizeWork::OnResizeNext (CDC* pDC, UINT nFlags, const DBLPoint& mmptMsc)
{
	//----- _xZkqqHx_iDhNiDeFiDfIiImKjChFiCmJiDfIiDgJiDgCiDhGjFmPiKlH_xHqqkZx_ -----
	DBLPoint mmptCur = mmptMsc;
	FFLimitMP(mmptCur, nFlags, m_mmptFix, &m_vLimitLine.at(0), m_vLimitLine.size());
	// m_mmrtFrame_xZkqqHx_iCpAiDgPiDgCiDeOiDeBiDgCiDhG_xHqqkZx_.
	DBLRect	mmrtFramePrev = m_mmrtFrame;
	//----- mmpMove_xZkqqHx_iCmJiDhNiDeFiDfIiNmAjFfHiCpAjBoDjDpMiClHiCoJiClBiCmGiCmFiBeB_xHqqkZx_
	//		mmrtFrame_xZkqqHx_iCmMjDeLjAnIiCmIjFmPjAjEiCmJjCgMiCkKjBoDjDpMiClDiCoKiCoJ_xHqqkZx_ -----
	*m_mmpMoveX = mmptCur.x;
	*m_mmpMoveY = mmptCur.y;
	*m_mmpMoveX_ = m_mmptFix.x - (mmptCur.x - m_mmptFix.x);
	*m_mmpMoveY_ = m_mmptFix.y - (mmptCur.y - m_mmptFix.y);

	//----- mmpMove_xZkqqHx_iCkK_xHqqkZx_Center_xZkqqHx_iCmMiOjOiBeB_xHqqkZx_mmpMove_xZkqqHx_iCmJjDeLjAnIiCmIjCgMiCpAjAnNjCoIiClHiCoJ_xHqqkZx_ -----
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_mmDummyX = (m_mmrtFrameOrig.left + m_mmrtFrameOrig.right) / 2.0;
//	m_mmDummyY = (m_mmrtFrameOrig.top + m_mmrtFrameOrig.bottom) / 2.0;
//----- 05.05.01 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfEiDeDiDfJjFmPiNfIjGlDiClFiCmIiCoHiCmOjFjMiLeB_xHqqkZx_.
	if (m_mmrtFrame == mmrtFramePrev) return FALSE;
	//----- _xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCkJiCmHiCkEiCkJjClCiCnHiCoJ_xHqqkZx_ -----
	DBLRect	mmrtFrame = m_mmrtFrame;
	mmrtFrame.NormalizeRect();
	// _xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiCpAiDgAiDeGiDgCiDeOiClHiCoJiBeC_xHqqkZx_
	if (!(*m_fncResizeCheck)(m_ojpTarget,
							m_mmrtFrame.left <= m_mmrtFrame.right,
							m_mmrtFrame.top <= m_mmrtFrame.bottom, mmrtFrame))
	{
		m_mmrtFrame = mmrtFramePrev;
		return FALSE;
	}
	//----- _xZkqqHx_jBePiJpBiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiPmBiLiO_xHqqkZx_ -----
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_ojpTarget->GetStdPenWeight()));
	eDraw.Polyline(m_vlgptPoly.begin(), m_vlgptPoly.size());
	//----- _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAjFfMiOkG_xHqqkZx_ -----
	mmrtFrame = m_mmrtFrame;
	mmrtFrame.NormalizeRect();
	FFResizePolygon(m_vlgptPoly.begin(), m_vlgptPoly.size(), m_vmmptPoly.begin(),
					m_mmrtFrameOrig,
					m_mmrtFrame.left <= m_mmrtFrame.right,
					m_mmrtFrame.top <= m_mmrtFrame.bottom, mmrtFrame);
	eDraw.Polyline(m_vlgptPoly.begin(), m_vlgptPoly.size());

	return TRUE;
} // FCResizeWork::OnResizeNext.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::OnResizeEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SelectTool_xZkqqHx_iCmJiCoGiCmBiCmEiBeBiDiKiDfEiDeDiDfJiCmMiNmFiMoDiCmMiDfIiDgFiDgCiDhGiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P222,P230
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bXPosi	:X_xZkqqHx_jFpLiMpMiCmJjElNjBmOiCmMiDiKiDfEiDeDiDfJiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			bYPosi	:Y_xZkqqHx_jFpLiMpMiCmJjElNjBmOiCmMiDiKiDfEiDeDiDfJiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			mmrtResized:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNlGiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiClN_xHqqkZx_.
 *			FALSE	: _xZkqqHx_iDiKiDfEiDeDiDfJiClDiCoKiCmEiCkCiCmIiCkC_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.09.28 Fukushiro M. work_xZkqqHx_iCpAiOgHiCmBiClNiMgAiCmJjBoFjFjNjFmPiNfI_xHqqkZx_.
 *			98.10.10 Fukushiro M. ObjDynabase_xZkqqHx_iCkJiCoH_xHqqkZx_Tool_xZkqqHx_iCnGiInKjDkO_xHqqkZx_.
 *			99.04.22 Fukushiro M. Tool_xZkqqHx_iCkJiCoHjDmGjHkHiClFiClNiDeOiDiJiDfIiCnGiBeC_xHqqkZx_
 *************************************************************************/
BOOL FCResizeWork::OnResizeEnd (CDC* pDC, BOOL& bXPosi, BOOL& bYPosi,
								DBLRect& mmrtResized)
{
	//----- _xZkqqHx_jBePiJpBiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiPmBiLiO_xHqqkZx_ -----
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_ojpTarget->GetStdPenWeight()));
	eDraw.Polyline(m_vlgptPoly.begin(), m_vlgptPoly.size());
	// _xZkqqHx_jFgAiJoGjHhAiCmJiKgNjFnLiClFiCmEiCkCiClNjEhKjHpBiCpAiJpAjFpKiBeC_xHqqkZx_
	m_vmmptPoly.clear();
	m_vlgptPoly.clear();
	// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	bXPosi = m_mmrtFrame.left <= m_mmrtFrame.right;
	bYPosi = m_mmrtFrame.top <= m_mmrtFrame.bottom;
	// mmrtResized_xZkqqHx_iCmMjCgMiCmNiBeB_xHqqkZx_TRUE,FALSE_xZkqqHx_iCmJiKnGiCoNiCoHiClIjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	mmrtResized = m_mmrtFrame;
	mmrtResized.NormalizeRect();
	// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMjBoFiCkLiClDiCkKjFmPiCoNiCoHiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (m_mmrtFrame == m_mmrtFrameOrig) return FALSE;
	//----- _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiInKjDkOjHmKiCmMiBeBiLoJiMgAiCmJjBmOiClHiCoJjEoEjHkGiCpAiMhGiOfK_xHqqkZx_ -----
//----- 00.09.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_dMoveRatioX = *m_mmpMoveX - m_mmptMoveOrig.x;
//	m_dMoveRatioX /= m_mmrtFrameOrig.Width();
//	m_dMoveRatioY = *m_mmpMoveY - m_mmptMoveOrig.y;
//	m_dMoveRatioY /= m_mmrtFrameOrig.Height();
//----- 00.09.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// 00.09.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (m_mmrtFrameOrig.Width() != 0.0)
	if (!almost0(m_mmrtFrameOrig.Width()))
	{
		m_dMoveRatioX = *m_mmpMoveX - m_mmptMoveOrig.x;
		m_dMoveRatioX /= m_mmrtFrameOrig.Width();
	} else
	{
		m_dMoveRatioX = 0.0;
	}
// 00.09.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (m_mmrtFrameOrig.Height() != 0.0)
	if (!almost0(m_mmrtFrameOrig.Height()))
	{
		m_dMoveRatioY = *m_mmpMoveY - m_mmptMoveOrig.y;
		m_dMoveRatioY /= m_mmrtFrameOrig.Height();
	} else
	{
		m_dMoveRatioY = 0.0;
	}
//----- 00.09.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 00.04.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
//	bXPosi = m_mmrtFrame.left <= m_mmrtFrame.right;
//	bYPosi = m_mmrtFrame.top <= m_mmrtFrame.bottom;
//	mmrtResized = m_mmrtFrame;
//	mmrtResized.NormalizeRect();
//----- 00.04.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	return TRUE;
} // FCResizeWork::OnResizeEnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::DrawCurFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjDhCjCiGiCmFiBeBiMlLiNnNiCmMiDiKiDfEiDeDiDfJiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCResizeWork::DrawCurFrame (CDC* pDC) const
{
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, mm2lg(m_ojpTarget->GetStdPenWeight()));
	eDraw.Polyline(const_cast<CPoint*>(m_vlgptPoly.begin()), m_vlgptPoly.size());
} // FCResizeWork::DrawCurFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::SetResizeCheck
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOjHhAiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fncCallback	:_xZkqqHx_iDiKiDfEiDeDiDfJiDgAiDeGiDgCiDeOiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OnResizeFirst_xZkqqHx_iCmFjAnNjCoIiClDiCoKiClNiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAjFmPiNfIiClHiCoJiInHiCmMiKnGjAjEiBeC_xHqqkZx_
 *			ToolLine_xZkqqHx_iCmFjFjNiBgJiNiCiClDiBgKiCePiCmMjFjEjFgJiCpAiNoMjAkMiClHiCoJiClNiCnPiCmJiClBiCmMiKnGjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCResizeWork::SetResizeCheck (ResizeCheckCallback fncCallback)
{
	// _xZkqqHx_iDiKiDfEiDeDiDfJiJmCjEfMiDgAiDeGiDgCiDeOiKnGjAjEiCpAjAnNjCoIiBeC_xHqqkZx_
	m_fncResizeCheck = fncCallback;
} // FCResizeWork::SetResizeCheck.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::AddLimitLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjDfPiCmMjAkHiMmAjApMiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmLine	:_xZkqqHx_jAkHiMmAjApMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	OnResizeFirst_xZkqqHx_iCmFiPiJiKpKiJlLiClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_OnResizeFirst_xZkqqHx_iCmMiMoDiCmJiOmAiNhDiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCResizeWork::AddLimitLine (const DBLLine& mmLine)
{
	m_vLimitLine.push_back(mmLine);
} // FCResizeWork::AddLimitLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::GetMovePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCResizeWork::GetMovePoint () const
{
	return DBLPoint(*m_mmpMoveX, *m_mmpMoveY);
} // FCResizeWork::GetMovePoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::GetFixPoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCResizeWork::GetFixPoint () const
{
	return m_mmptFix;
} // FCResizeWork::GetFixPoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::CalcResize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	OnResizeFirst _xZkqqHx_iBgA_xHqqkZx_ OnResizeEnd_xZkqqHx_iCmFiMhGiOfKiClDiCoKiClNiDiKiDfEiDeDiDfJiPoOjFpBiCpAiMlDiCmJiBeB_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiClNiLoJiMgAiCpAiDiKiDfEiDeDiDfJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmrtResized	:_xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiNlGiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmrtFrame	:_xZkqqHx_iDiKiDfEiDeDiDfJiClHiCoJjBePiCmMiNmAjFfHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			bIsResizableHorz	:_xZkqqHx_jAiFjFlNjFpLiMpMiDiKiDfEiDeDiDfJiCmMiJmCiBeFjFhDiJmCiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			bIsResizableVert	:_xZkqqHx_jAiCjClMjFpLiMpMiDiKiDfEiDeDiDfJiCmMiJmCiBeFjFhDiJmCiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCResizeWork::CalcResize (DBLRect& mmrtResized, const DBLRect& mmrtFrame)
{
	m_mmrtFrame = mmrtFrame;
	// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiCpAiBeBjEoEjHkGiCnEiCpBiInKjDkOiClHiCoJiBeC_xHqqkZx_
	const mmetol mmMoveX = mmrtFrame.Width() * m_dMoveRatioX;
	const mmetol mmMoveY = mmrtFrame.Height() * m_dMoveRatioY;
	*m_mmpMoveX += mmMoveX;
	*m_mmpMoveY += mmMoveY;
	*m_mmpMoveX_ -= mmMoveX;
	*m_mmpMoveY_ -= mmMoveY;
	// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
	mmrtResized = m_mmrtFrame;
} // FCResizeWork::CalcResize.

//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void FCResizeWork::CalcResize (	DBLRect& mmrtResized,
//								const DBLRect& mmrtFrame,
//								BOOL bIsResizableHorz,
//								BOOL bIsResizableVert)
//{
//	m_mmrtFrame = mmrtFrame;
//	// _xZkqqHx_iInKjDkOiDhMiDeDiDjDiDgHiCpAiBeBjEoEjHkGiCnEiCpBiInKjDkOiClHiCoJiBeC_xHqqkZx_
//	const mmetol mmMoveX = bIsResizableHorz ? mmrtFrame.Width() * m_dMoveRatioX : 0.0;
//	const mmetol mmMoveY = bIsResizableVert ? mmrtFrame.Height() * m_dMoveRatioY : 0.0;
//	*m_mmpMoveX += mmMoveX;
//	*m_mmpMoveY += mmMoveY;
//	*m_mmpMoveX_ -= mmMoveX;
//	*m_mmpMoveY_ -= mmMoveY;
//	// _xZkqqHx_iDiKiDfEiDeDiDfJiMoDiCmMiPoOjFpBiCpAjAnNjCoIiBeC_xHqqkZx_
//	mmrtResized = m_mmrtFrame;
//} // FCResizeWork::CalcResize.
//----- 05.06.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDfEiDeDiDfJjCiGiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const DBLRect& FCResizeWork::GetResizeFrame () const
{
	return m_mmrtFrame;		// _xZkqqHx_iMlLiNnNiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
} // FCResizeWork::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::GetResizeFrameOrg
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiDeJiDiKiDfHiDgJiDiLiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const DBLRect& FCResizeWork::GetResizeFrameOrg () const
{
	return m_mmrtFrameOrig;	// _xZkqqHx_jGhLjHiIiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
} // FCResizeWork::GetResizeFrameOrg.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCResizeWork::CalcElementLengthForResize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiDiKiDfEiDeDiDfJiOjOiCmJ_xHqqkZx_NewObjPolygon_xZkqqHx_iCmMiIpIjAjE_xHqqkZx_'mmElemLen'_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	mmElemLen_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			05.03.03 Fukushiro M. FCObjDynabase_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
mmetol FCResizeWork::CalcElementLengthForResize (const FCObjDynabase* pObj) const
{
	//----- _xZkqqHx_iDfJiBfLiDiAiCmGjAhNiMgAiCmMjBoFiCkLiClDiNgMjHlGiClFiCmE_xHqqkZx_ElemLen_xZkqqHx_iCpAiMiIjCoI_xHqqkZx_ ----
	// _xZkqqHx_jAhNiMgAiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
	DBLRect mmrtFrame = pObj->GetResizeFrame();
	DBLRect mmrtClient;
	// _xZkqqHx_iJoGjGmKiCmMjFgAiJoGjHmMiIoGiCpAjIfPjHjNiNmAjFfHiMgOiCmFiOoGjDlOiBeC_xHqqkZx_
	g_pView->GetClientRectMM(mmrtClient);
	//----- _xZkqqHx_jAhNiMgAiCpAiJoGjGmK_xHqqkZx_1/4_xZkqqHx_iCmJiNeMiClAiClNiOjOiCmJ_xHqqkZx_4pixel_xZkqqHx_iCmMiJpAjBjMjDhIiCkKiCkAiCoJiCoGiCkEiCmJ_xHqqkZx_mmElemLen_xZkqqHx_iCpAjClCjAkO_xHqqkZx_ -----
	double dRatio = 10.0;
	if (!mmrtFrame.IsRectEmpty() && !mmrtClient.IsRectEmpty())
	//----- 0_xZkqqHx_iKiEiCoIiCpAjGgIiCkOiClNiCnPiBeBiLoJiMgAiCkKjFjNiBeFiNiCiClDiCmGiCoA_xHqqkZx_0_xZkqqHx_iImIiKePiCmMiPoKiNiHiCmMiCnNiMhGiOfK_xHqqkZx_ -----
	{
		double dRatioX = mmrtClient.Width() / mmrtFrame.Width();
		double dRatioY = mmrtClient.Height() / mmrtFrame.Height();
		dRatio = (dRatioX < dRatioY) ? dRatioY : dRatioX;
		dRatio /= 4.0;
		// _xZkqqHx_jFjNiBeFiNiCiClDiCkKjEpBiPoNiCmJiPkMiClDiCkCjAhNiMgAiCmF_xHqqkZx_mmElemLen_xZkqqHx_iCkKiPkMiClDiCkNiCmIiCoIiClHiCkMiCoJiCmMiCpAjGgIiCkOiBeC_xHqqkZx_
		if (10.0 < dRatio) dRatio = 10.0;
	}
	mmetol mmElemLen = lg2mm(g_->lgdPrecision);
	if (1.0 < dRatio) mmElemLen /= dRatio;
	return mmElemLen;
} // FCResizeWork::CalcElementLengthForResize.
