/*************************************************************************
 * <_xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_>	SearchParser.cpp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	HistFind_xZkqqHx_jHhAiMjPiNpFjFlGiOjKjHpBiCmMiJpAjAmNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iBhJ_xHqqkZx_ _xZkqqHx_iJiJiOfKiOhBjDjJiCmMjAoAjGlO_xHqqkZx_ _xZkqqHx_iBhK_xHqqkZx_
 *			& , AND	:AND_xZkqqHx_iJiJiOfKiOhBiBeCiMjPiNpFiPpAiMiPiCmMjIfPjHjNjAmPiBeC_xHqqkZx_
 *			| , OR	:OR_xZkqqHx_iJiJiOfKiOhBiBeCiMjPiNpFiPpAiMiPiCmMjIfPjHjNjIgBiBeC_xHqqkZx_
 *			!		:NOT_xZkqqHx_iJiJiOfKiOhBiBeC_xHqqkZx_
 *			( )		:_xZkqqHx_jFfNiJlPjHeEjAoGiOhHjCoIiBeCiClBiCoKiCmFiImNiCnMiCoKiClNiOkOiCmMjFfNiJlPiCkKjHeEjAoGiClDiCoKiCoJiBeC_xHqqkZx_
 *			/ /		:_xZkqqHx_iClBiCoKiCmFiImNiCnMiCoKiClNjEmNiImNiCmNiBeBiMjPiNpFjFlGiOjKjHpBiCmGiClFiCmEiIlFiCoNiCoKiCoJiBeC_xHqqkZx_
 *			\		:_xZkqqHx_iDeHiDfIiDfAiBfLiDhGiDfCiBfLiDgIiBeCiClBiCmMiLeMiNiGiCmMiOjPiCmMjFlGiOjKiCmNiBeBjGlDiPpAiMiPiCmJ_xHqqkZx_
 *					 _xZkqqHx_iMjPiNpFjFlGiOjKjHpBiCmMiIoKjFjEiCmGiClFiCmEiIlFiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iBhJ_xHqqkZx_ _xZkqqHx_iJiJiOfKiOhBiCmMjHeEjAoGiPiHiImK_xHqqkZx_ _xZkqqHx_iBhK_xHqqkZx_
 *			AND_xZkqqHx_iJiJiOfKiOhB_xHqqkZx_ == OR_xZkqqHx_iJiJiOfKiOhB_xHqqkZx_ < NOT_xZkqqHx_iJiJiOfKiOhB_xHqqkZx_
 *			AND_xZkqqHx_iJiJiOfKiOhBiCmG_xHqqkZx_OR_xZkqqHx_iJiJiOfKiOhBiCmNiBeBiOkOjCiGiCmFiNlGiCkJiCoHiPgPiMlLiClFiClNiPiHiCmJjHeEjAoGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iBhJ_xHqqkZx_ _xZkqqHx_iMjPiNpFiOkOiCmMjHoB_xHqqkZx_ _xZkqqHx_iBhK_xHqqkZx_
 *			_xZkqqHx_iBeFjAlDiLeLjFfMiMlLiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iBjL_xHqqkZx_ HELLO
 *			_xZkqqHx_iBjL_xHqqkZx_ /HELLO/
 *			_xZkqqHx_iBjL_xHqqkZx_ (/HELLO/)
 *			_xZkqqHx_iBjL_xHqqkZx_ /HELLO/ AND /world/
 *			_xZkqqHx_iBjL_xHqqkZx_ (/HELLO/ OR /BYE/) AND /WORLD/
 *			_xZkqqHx_iBjL_xHqqkZx_ /HELLO\//
 *			_xZkqqHx_iBhO_xHqqkZx_ HELLO AND world   _xZkqqHx_iBkGiCfAjCfAiMoKiCmGiClFiCmEiIlFiCoNiCoKiCoJiClNiCnPiDeHiDiJiBfLiCmNiPgPiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iBhO_xHqqkZx_ (HELLO)
 *			_xZkqqHx_iBhO_xHqqkZx_ /HELLO\/
 *
 *			_xZkqqHx_iBhJ_xHqqkZx_ _xZkqqHx_jChFiKlHiOkOiBhK_xHqqkZx_
 *			/ /		:_xZkqqHx_iClBiCoKiCmFiImNiCnMiCoKiClNjEmNiImNiCmNiBeBjChFiKlHjFlGiOjKjHpBiCmGiClFiCmEiIlFiCoNiCoKiCoJiBeC_xHqqkZx_
 *			\		:_xZkqqHx_iDeHiDfIiDfAiBfLiDhGiDfCiBfLiDgIiBeCiClBiCmMiLeMiNiGiCmMiOjPiCmMjFlGiOjKiCmNiBeBjGlDiPpAiMiPiCmJ_xHqqkZx_
 *					 _xZkqqHx_jChFiKlHjFlGiOjKjHpBiCmMiIoKjFjEiCmGiClFiCmEiIlFiCoNiCoKiCoJiBeC_xHqqkZx_
 *			$		:_xZkqqHx_iMoDjFpLiOfBiPmGjHhAjFmPjAjEiBeC_xHqqkZx_$1,$2,..$9,$10,$11...
 *
 *			_xZkqqHx_iBhJ_xHqqkZx_ _xZkqqHx_iDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiL_xHqqkZx_ _xZkqqHx_iBhK_xHqqkZx_
 *			_xZkqqHx_iDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_vTokenTbl _xZkqqHx_iCmMiClBiCmGiBeCjFlGiOjKjHpBiBgJ_xHqqkZx_WString_xZkqqHx_iBgKiCmMjEhKjHpBiCmFiCkAiCoJiBeC_xHqqkZx_
 *			m_vTokenTbl[i] (FDTKN_NONE <= i < FDTKN_END_OF) _xZkqqHx_iCmNiBeBiJiJiOfKiOhBjDjJiCmM_xHqqkZx_
 *			_xZkqqHx_iKpJjCoIiCmMiDgHiBfLiDeOiDjDiCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			m_vTokenTbl[j] (FDTKN_END_OF <= j) _xZkqqHx_iCmNiBeBiMjPiNpFiOkOjCiGiCmJiPgPiMlLiClFiClNjCfAiMoKiCkK_xHqqkZx_
 *			_xZkqqHx_jDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iBhJ_xHqqkZx_ _xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeO_xHqqkZx_ _xZkqqHx_iBhK_xHqqkZx_
 *			_xZkqqHx_iDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_vTokenStk _xZkqqHx_iCmMiClBiCmGiBeC_xHqqkZx_short_xZkqqHx_iCmMjEhKjHpBiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiOkOiCmMiDgHiBfLiDeOiDjDiCpAiLhEiDhMiBfLiDiJiDjDiDgIiMgAiOkOiCmFjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiOkOiCkK_xHqqkZx_  (A&B)|C  _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJiCmN_xHqqkZx_  A B & C |  _xZkqqHx_iCkKjFnLjBlGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iBhJ_xHqqkZx_ _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiDgFiBfLiDhFiDiL_xHqqkZx_ _xZkqqHx_iBhK_xHqqkZx_
 *			_xZkqqHx_iDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_vRegExObjTbl _xZkqqHx_iCmMiClBiCmGiBeC_xHqqkZx_FmRegExpNFA* _xZkqqHx_iCmMjEhKjHpBiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiLiCmMjCfAiMoKiDgHiBfLiDeOiDjDiCmJjBmOiJjOiClFiClNjAlDiLeLjFfMiMlLiCpAjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/

#include "stdafx.h"
#include "DynamicDraw.h"		// For IDS_XXX.
// 01.03.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//#include "../FmRegExp/RegExpNFA.h" // For RegExpNFA.
#include "../FmRegExp/FmRegExpNFAW.h" // For FmRegExpNFA.
#include "UtilStr.h"		// For FormatResString.
#include "UtilErr.h"		// For FFMessageBox.
// 01.04.19 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "WCharStr.h"		// For FCWCharStr.
#include "SearchToken.h"	// For FCSearchToken.
#include "SearchParser.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FDSP_WCH_END	0xffff

//////////////////////////////////////////////////////////////////////////
// FCSearchParser_xZkqqHx_iDeOiDiJiDfIiCmMiDiBiDjDiDgPiKnGjAjE_xHqqkZx_
//////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::FCSearchParser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSearchParser::FCSearchParser ()
{
	Clear();
} // FCSearchParser::FCSearchParser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::~FCSearchParser
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSearchParser::~FCSearchParser ()
{
	Clear();
} // FCSearchParser::~FCSearchParser.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjFjEiPpDjBnEiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiLiBeBiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOjDjJiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSearchParser::Clear ()
{
	// _xZkqqHx_jAlDiLeLjFfMiMlLiCkJiCmHiCkEiCkJiBeI_xHqqkZx_
	m_bRegExp = FALSE;
	// _xZkqqHx_jBoFjFlGiOjKjFmPiKlHiClHiCoJiCkJiCmHiCkEiCkJiBeI_xHqqkZx_
	m_bCnvUpper = FALSE;
	// _xZkqqHx_iDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	m_vTokenTbl.clear();
	FCSearchToken::ReqInit(m_vTokenTbl);
	// _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	RegExPVector::iterator iRx;
	for (iRx = m_vRegExObjTbl.begin(); iRx != m_vRegExObjTbl.end(); iRx++)
		if (*iRx != NULL) FmfDelete(*iRx);
	m_vRegExObjTbl.clear();
	// _xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiBeC_xHqqkZx_
	m_vTokenStk.clear();
	// _xZkqqHx_jChFiKlHiMoDiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
	m_vReplace.clear();
	// _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiBeC_xHqqkZx_
	m_vAfterRef.clear();
} // FCSearchParser::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::ParseSearch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiMgAiOkOiCmMiMjPiNpFiOkOiCpAjDmBiOoKiCmIiMgAiOkOiCmJjFmPiKlHiClFiBeBjFnLjBlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpExp		:_xZkqqHx_iMjPiNpFiOkOiCpAjHfOiCkGiCoJiBeC_xHqqkZx_
 *			bRegExp		:_xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			bCnvUpper	:_xZkqqHx_jBfDiCmEiCmMjFlGiOjKiCpAjBoFjFlGiOjKiCmJjFmPiKlHiCpAiClHiCoJiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			bMultiWord	:_xZkqqHx_jFkBjAjEjCfAiMoKiMjPiNpFiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			bOrOpeOnly	:OR_xZkqqHx_iJiJiOfKiOhBiCmMiCnNiLjGiJmCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCjChFiKlHjFmPiKlHiCmMiPoKiNiHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::ParseSearch (	const wchar_t* wcpExp,
									BOOL bRegExp,
									BOOL bCnvUpper,
									BOOL bMultiWord,
									BOOL bOrOpeOnly)
{
	// _xZkqqHx_jDoAjFjEjFmPjAjEiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	Clear();
	// _xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCkJiCmHiCkEiCkJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_bRegExp = bRegExp;
	// _xZkqqHx_jBoFjFlGiOjKjFmPiKlHiClHiCoJiCkJiCmHiCkEiCkJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_bCnvUpper = bCnvUpper;
//----- 01.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_jChFiKlHjFlGiOjKjHpBiCpAiJpAjAmN_xHqqkZx_ -----
//	if (!ParseReplace(wcpRep))
//	{
//		// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
//		// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
//		FFMessageBox(FormatResString(IDS_ERR_MSG_WRONG_FORMULA,
//										wcpRep));
//		return FALSE;
//	}
//----- 01.01.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	if (!IsRegExp())
	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiCmFiCmNjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.01.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (IsCnvUpper())
//		//----- _xZkqqHx_jBoFjFlGiOjKjFmPiKlHiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			WString wcExp(wcpExp);
//			// wcExp_xZkqqHx_iCmMjCiGiCpAjBoFjFlGiOjKiCmJiPjBiCkLiKlHiCkGiCoJiBeC_xHqqkZx_
//			_wcsupr(wcExp.begin());
//			wcpExp = wcExp.c_str();
//			// _xZkqqHx_iMjPiNpFiOkOiCpAiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCnGiLhEiDhMiBfLiDiJiDjDiDgIjFmPiKlHiBeC_xHqqkZx_
//			if (!ParseExpression(wcpExp, bMultiWord, bOrOpeOnly)) return FALSE;
//		} else
//		{
//			// _xZkqqHx_iMjPiNpFiOkOiCpAiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCnGiLhEiDhMiBfLiDiJiDjDiDgIjFmPiKlHiBeC_xHqqkZx_
//			if (!ParseExpression(wcpExp, bMultiWord, bOrOpeOnly)) return FALSE;
//		}
//----- 05.01.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iMjPiNpFiOkOiCpAiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCnGiLhEiDhMiBfLiDiJiDjDiDgIjFmPiKlHiBeC_xHqqkZx_
		if (!ParseExpression(wcpExp, bMultiWord, bOrOpeOnly)) return FALSE;
//----- 05.01.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiDjDiCmMiDeHiDfIiDfAiBfLiDhGiDfCiBfLiDgIiCpAjFmPiKlHiClHiCoJ_xHqqkZx_ -----
		const wchar_t wcEndCode = L'\0';
		for (int iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
		//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
		{
			WString strOut;
			const wchar_t* wcpStr = m_vTokenTbl[iC].c_str();
			if (!FFConvertStr(strOut, wcpStr, &wcEndCode, 1)) return FALSE;
			if (IsCnvUpper()) _wcsupr(strOut.begin());
			m_vTokenTbl[iC] = strOut;
		}
		return TRUE;
	} else
	{
		// _xZkqqHx_iMjPiNpFiOkOiCpAiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCnGiLhEiDhMiBfLiDiJiDjDiDgIjFmPiKlHiBeC_xHqqkZx_
		if (!ParseExpression(wcpExp, bMultiWord, bOrOpeOnly)) return FALSE;
		//----- _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiDgFiBfLiDhFiDiLiNoMjAkM_xHqqkZx_ -----
		// _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiDgFiBfLiDhFiDiLiCpAiDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiLiDfEiDeDiDfJjFkKiCmMiLpDiCmFjGjOiClNiClHiBeC_xHqqkZx_
		m_vRegExObjTbl.assign(m_vTokenTbl.size());
		// _xZkqqHx_iPkMjFlGiOjKiBeFjBoFjFlGiOjKjFmPiKlHiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		WORD wFlags;
		if (bCnvUpper)	// _xZkqqHx_jBoFjFlGiOjKiCmJjFmPiKlHiCmMiPoKiNiHiBeC_xHqqkZx_
			wFlags = DREX_EXP_TO_UPCASE;	// _xZkqqHx_jAlDiLeLjFfMiMlLjDoAjFjEjFlGiOjKjHpBiCpAjBoFjFlGiOjKiCnGiBeC_xHqqkZx_
		else
			wFlags = DREX_EXP_NONE;			// _xZkqqHx_jAlDiLeLjFfMiMlLjDoAjFjEjFlGiOjKjHpBiCmNjFmPiKlHiClFiCmIiCkCiBeC_xHqqkZx_

		for (int i = FDTKN_END_OF; i < m_vTokenTbl.size(); i++)
		{
			// _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHjAlGjAkMiBeC_xHqqkZx_
			FmRegExpNFA* pRegEx = FmfCreate();
			// _xZkqqHx_iMjPiNpFiOkOiBgJiDgHiBfLiDeOiDjDjFlGiOjKjHpBiBgKiCmMiDhMiDeDiDjDiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
			const wchar_t* wcpHead = m_vTokenTbl[i].c_str();
			// _xZkqqHx_iMjPiNpFiOkOiCpAjAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiCmJjAnNjCoIiBeC_xHqqkZx_
			if (!pRegEx->SetExpression(wcpHead, wFlags))
			{
				// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
				FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpHead);
				FmfDelete(pRegEx);
				return FALSE;
			}
			// _xZkqqHx_jAlDiLeLjFfMiMlLiDeJiDhFiDfHiDeGiDeOiDgHiDgFiBfLiDhFiDiLiCmMjAnNjCoIiBeC_xHqqkZx_
			m_vRegExObjTbl[i] = pRegEx;
		}
		return TRUE;
	}
} // FCSearchParser::ParseSearch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::ParseReplace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jChFiKlHiMoDjFlGiOjKjHpBiCpAjFfNiJlPiClFiBeBiJpAiOnPiClFiCoCiClHiCkCiMgAiOkOiCmFjFnLjBlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpStr	:_xZkqqHx_jChFiKlHiMoDjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::ParseReplace (const wchar_t* wcpStr)
{
	// _xZkqqHx_jChFiKlHiMoDjFlGiOjKjHpBiCpAiPmBiLiOiBeC_xHqqkZx_
	m_vReplace.clear();
	// _xZkqqHx_iNmFiPiJiCmMiLpDjEjCiBeFiDfOiDhFjDjJiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
	FFSkipSpace(wcpStr);
	wchar_t wcEndCode = L'\0';	// _xZkqqHx_iPeJjHlJjFlGiOjKiBeC_xHqqkZx_
//----- 05.07.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (*wcpStr == FDST_CHR_SLASH)
//	//----- _xZkqqHx_iDfIiDiJiDgCiDfGiDiF_xHqqkZx_ '/' _xZkqqHx_iCmFiOgOiCnMiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		wcEndCode = FDST_CHR_SLASH;
//		wcpStr++;
//	}
//----- 05.07.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	switch (*wcpStr)
	{
	case L'/':
	case L'"':
	case L'\'':
		wcEndCode = *wcpStr;
		wcpStr++;
		break;
	}
//----- 05.07.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	if (!IsRegExp())
	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiCmFiCmNjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		WString strOut;
		// _xZkqqHx_iDeHiDfIiDfAiBfLiDhGiDfCiBfLiDgIiCpAjFmPiKlHiBeC_xHqqkZx_
		if (!FFConvertStr(strOut, wcpStr, &wcEndCode, 1))
		{
			// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
			// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
			FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
			return FALSE;
		}
		// _xZkqqHx_iClLiCmMiCnMiCnMiDfCiDhDiBfLiBeC_xHqqkZx_
		m_vReplace.insert(m_vReplace.begin(), strOut.begin(), strOut.end());
		m_vReplace.push_back(L'\0');
	} else
	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		const wchar_t wcaEndCode[] = { L'$', wcEndCode };
		const int iEncodeSz = sizeof(wcaEndCode) / sizeof(wcaEndCode[0]);
		WString strOut;
		for (;;)
		{
			// _xZkqqHx_iDeHiDfIiDfAiBfLiDhGiDfCiBfLiDgIiCpAjFmPiKlHiBeC_xHqqkZx_
			if (!FFConvertStr(strOut, wcpStr, wcaEndCode, iEncodeSz))
			{
				// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
				FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
				return FALSE;
			}
			// _xZkqqHx_jFmPiKlHjFlGiOjKjHpBiCpAjCmHiJmBiBeC_xHqqkZx_
			m_vReplace.insert(m_vReplace.end(), strOut.begin(), strOut.end());
			// _xZkqqHx_jFlGiOjKjHpB_xHqqkZx_ $ _xZkqqHx_iImIiKePiBgJiPeJjHlJiDfCiBfLiDgIiBgKiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
			if (*wcpStr != L'$') break;
			//----- '$'_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			m_vReplace.push_back(FDSP_WCH_END);
			wcpStr++;
			wchar_t idx = (wchar_t)wcstol(wcpStr, (wchar_t**)&wcpStr, 10);
			// $0_xZkqqHx_iCmNiCkAiCoIjDlOiCmIiCkCiBeCiCnMiClNiBeB_xHqqkZx_$a_xZkqqHx_jDjJiCoAiBeC_xHqqkZx_
			if (idx == 0)
			{
				// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
				// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
				FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
				return FALSE;
			}
			m_vReplace.push_back(idx);
		}
		m_vReplace.push_back(L'\0');
	}
	return TRUE;
} // FCSearchParser::ParseReplace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkKiDhNiDgCiDgAiClHiCoJiCkJiCmMiDgFiDfIiDgHiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTarget:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgFiDeMiDfIiDgHjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeBiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeBiDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCfKiCkCjFlGiOjKjHpBiCmMiPoKiNiHiCmNiBeBiClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmFiPiIjHjNiClFiClNjFpLiCkKjHmHiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	Parse_xZkqqHx_iKnGjAjEiCmFiBeB_xHqqkZx_bCnvUpper_xZkqqHx_iCpAiOhHjCoIiClFiCmEiCkCiCmEiCoAiBeBjDoAjFjEiCmF_xHqqkZx_wcpTarget_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_jBoFjFlGiOjKiCmJjFmPiKlHiClFiCmEjEoEiKhCiClHiCoJjGpDiCmFiCmNiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_jBoFjFlGiOjKiCmFjEoEiKhCiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_IsMatch_xZkqqHx_iCpAiOmAiNhDiClHiCoJjBePiCmJiBeBiKePjFjEiCmF_xHqqkZx_
 *			wcpTarget_xZkqqHx_iCpAjBoFjFlGiOjKiCmJjFmPiKlHiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCSearchParser::IsMatch (const wchar_t* wcpTarget)
{
	// _xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmMiOmKiClFiCpAiNoMjAkMiBeC_xHqqkZx_
	shortVector	vTokenStk = m_vTokenStk;
	// _xZkqqHx_iDhBiDgCiDgHiDgFiBfLiDhFiDiLiCpAiNoMjAkMiClFiBeBiDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiLiCmGjDkPiDfEiDeDiDfJiCmM_xHqqkZx_-1_xZkqqHx_iCpAiKiEiCoIjAfFiCoJiBeC_xHqqkZx_
	shortVector vIsHitTbl;
	vIsHitTbl.assign(m_vTokenTbl.size(), -1);
	return Evaluate(vTokenStk, vIsHitTbl, wcpTarget);
} // FCSearchParser::IsMatch.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::GetMatchingPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJiMjPiNpFiOkOiCmJiDhBiDgCiDgHiClHiCoJiMmCiPiKjBfDiCmEiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vHitRange	:_xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTarget	:_xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vHitRange_xZkqqHx_iCmMjAjEiCkK_xHqqkZx_ FDMAX_TEXT_HIT _xZkqqHx_iCpAiJhKiCkGiCoJiCmGiBeBiMjPiNpFiCpAjDhCjCiGiCmFiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSearchParser::GetMatchingPos (longRangeVector& vHitRange, const wchar_t* wcpTarget)
{
//----- 01.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const wchar_t* wcpHead = wcpTarget;
//	if (IsRegExp())
//	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		wchar_t wcCharPrev = L'\0';
//		while (*wcpHead != L'\0' && vHitRange.size() < FDMAX_TEXT_HIT)
//		//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKiPeJjHlJiClHiCoJiCkJiBeBiDhBiDgCiDgHiImKjChFiCkKiLeLjCoIjAjEiCpAjClEiCkGiCoJiCnMiCmF_xHqqkZx_ -----
//		{
//			int iC;
//			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
//			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
//			{
//				const wchar_t* wcpTop = wcpHead;
//				// _xZkqqHx_iMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//				if (m_vRegExObjTbl[iC]->IsMatch(wcCharPrev, wcpHead))
//				{
//					// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_wcCharPrev, wcpHead_xZkqqHx_iCmNiOjPiCmMiImKjChFiCnGiInKjDkOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
//					vHitRange.push_back(FClongRange(wcpTop - wcpTarget,
//													wcpHead - wcpTarget));
//					break;
//				}
//			}
//			if (iC == m_vTokenTbl.size())
//			{
//				// _xZkqqHx_iOjPiCmMjFlGiOjKiCnGjBjHiCoJiBeC_xHqqkZx_
//				wcCharPrev = *wcpHead;
//				wcpHead++;
//			}
//		}
//	} else
//	//----- _xZkqqHx_jCmKiPoNiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		while (*wcpHead != L'\0' && vHitRange.size() < FDMAX_TEXT_HIT)
//		//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKiPeJjHlJiClHiCoJiCkJiBeBiDhBiDgCiDgHiImKjChFiCkKiLeLjCoIjAjEiCpAjClEiCkGiCoJiCnMiCmF_xHqqkZx_ -----
//		{
//			int iC;
//			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
//			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
//			{
//				// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//				if (wcsncmp(m_vTokenTbl[iC].c_str(), wcpHead,
//							m_vTokenTbl[iC].length()) == 0)
//				{
//					// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//					vHitRange.push_back(
//						FClongRange(wcpHead - wcpTarget,
//									(wcpHead - wcpTarget) + m_vTokenTbl[iC].length()));
//					wcpHead += m_vTokenTbl[iC].length();
//					break;
//				}
//			}
//			if (iC == m_vTokenTbl.size())
//			{
//				// _xZkqqHx_iOjPiCmMjFlGiOjKiCnGjBjHiCoJiBeC_xHqqkZx_
//				wcpHead++;
//			}
//		}
//	}
//----- 01.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	const wchar_t* wcpHead = wcpTarget;
	const wchar_t* wcpFrom;
	const wchar_t* wcpTo;
	while (GetNextMatchingPos(wcpFrom, wcpTo, wcpTarget, wcpHead))
	{
		// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_wcpFrom, wcpTo, wcLastChar_xZkqqHx_iCmNiOjPiCmMiImKjChFiCnGiInKjDkOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
		vHitRange.push_back(FClongRange(wcpFrom - wcpTarget, wcpTo - wcpTarget));
		wcpHead = wcpTo;
	}
//----- 01.01.21 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCSearchParser::GetMatchingPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::GetNextMatchingPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJiMjPiNpFiOkOiCmJiDhBiDgCiDgHiClHiCoJiNmFiPiJiCmMiMmCiPiKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_iMoDjFpLiCmJiMjPiNpFiCpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFrom		:_xZkqqHx_iDhBiDgCiDgHjEmNiImNiCmMiNmFiPiJiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTo		:_xZkqqHx_iDhBiDgCiDgHjEmNiImNiCmMiNmFiMoDiCmMiOjPiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTop		:_xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCmMiDgPiDgCiDhEiDeAiDgHiDgCiDhGiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpHead		:_xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCmMiMjPiNpFiKeKiOgOiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpTop = "ABCDEFG", wcpHead = "CDEFG" _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_"C"_xZkqqHx_iCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jCfEiClFiOgOiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::GetNextMatchingPos (const wchar_t*& wcpFrom, const wchar_t*& wcpTo,
									const wchar_t* wcpTop, const wchar_t* wcpHead)
{
//----- 01.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiBeC_xHqqkZx_
//	m_vAfterRef.clear();
//	if (IsRegExp())
//	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iMjPiNpFjHhAiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOoGjDlOiBeC_xHqqkZx_
//		wchar_t wcCharPrev;
//		if (wcpTop == wcpHead)
//			wcCharPrev = L'\0';
//		else
//			wcCharPrev = *(wcpHead - 1);
//		while (*wcpHead != L'\0')
//		//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKiPeJjHlJiClHiCoJiCnMiCmF_xHqqkZx_ -----
//		{
//			const wchar_t* wcpNext = wcpHead;
//			int iC;
//			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
//			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//				if (m_vRegExObjTbl[iC]->IsMatch(wcCharPrev, wcpNext))
//				{
//					// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_wcCharPrev, wcpNext_xZkqqHx_iCmNiOjPiCmMiImKjChFiCnGiInKjDkOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
//					wcpFrom = wcpHead;
//					wcpTo = wcpNext;
//					//----- _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiCpAiOoGjDlO_xHqqkZx_ -----
//					long lRefSize = m_vRegExObjTbl[iC]->GetMatchStrSize();
//					for (long lRefC = 0; lRefC < lRefSize; lRefC++)
//					{
//						const wchar_t* wcpRefFrom;
//						const wchar_t* wcpRefTo;
//						m_vRegExObjTbl[iC]->GetMatchStr(wcpRefFrom, wcpRefTo, lRefC);
//						m_vAfterRef.push_back(WString(wcpRefFrom, wcpRefTo));
//					}
//					return TRUE;
//				}
//			}
//			// _xZkqqHx_iOjPiCmMjFlGiOjKiCnGjBjHiCoJiBeC_xHqqkZx_
//			wcCharPrev = *wcpHead;
//			wcpHead++;
//		}
//	} else
//	//----- _xZkqqHx_jCmKiPoNiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		while (*wcpHead != L'\0')
//		//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKiPeJjHlJiClHiCoJiCnMiCmF_xHqqkZx_ -----
//		{
//			int iC;
//			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
//			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
//			{
//				// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//				if (wcsncmp(m_vTokenTbl[iC].c_str(), wcpHead,
//							m_vTokenTbl[iC].length()) == 0)
//				{
//					// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//					wcpFrom = wcpHead;
//					wcpTo = wcpHead + m_vTokenTbl[iC].length();
//					return TRUE;
//				}
//			}
//			// _xZkqqHx_iOjPiCmMjFlGiOjKiCnGjBjHiCoJiBeC_xHqqkZx_
//			wcpHead++;
//		}
//	}
//	return FALSE;
//----- 01.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	while (*wcpHead != L'\0')
	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKiPeJjHlJiClHiCoJiCnMiCmF_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiPiIjHjNiBeC_xHqqkZx_
		const wchar_t* wcpNext = GetMatchingPos(wcpTop, wcpHead);
		if (wcpNext != NULL)
		//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
			wcpFrom = wcpHead;
			wcpTo = wcpNext;
			return TRUE;
		}
		wcpHead++;
	}
	return FALSE;
//----- 01.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCSearchParser::GetNextMatchingPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::GetPrevMatchingPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJiMjPiNpFiOkOiCmJiDhBiDgCiDgHiClHiCoJiNmFiPiJiCmMiMmCiPiKiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jBePjFpLiCmJiMjPiNpFiCpAiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFrom		:_xZkqqHx_iDhBiDgCiDgHjEmNiImNiCmMiNmFiPiJiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTo		:_xZkqqHx_iDhBiDgCiDgHjEmNiImNiCmMiNmFiMoDiCmMiOjPiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wcpTop		:_xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCmMiDgPiDgCiDhEiDeAiDgHiDgCiDhGiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpHead		:_xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCmMiMjPiNpFiKeKiOgOiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpTop = "ABCDEFG", wcpHead = "CDEFG" _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_"B"_xZkqqHx_iCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jCfEiClFiOgOiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::GetPrevMatchingPos (const wchar_t*& wcpFrom, const wchar_t*& wcpTo,
									const wchar_t* wcpTop, const wchar_t* wcpHead)
{
//----- 01.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiBeC_xHqqkZx_
//	m_vAfterRef.clear();
//	if (IsRegExp())
//	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		while (wcpHead != wcpTop)
//		//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKjAoGjDkKiCmJjCeCiClHiCoJiCnMiCmF_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//			wcpHead--;
//			//----- _xZkqqHx_iMjPiNpFjHhAiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOoGjDlO_xHqqkZx_ -----
//			wchar_t wcCharPrev;
//			if (wcpTop == wcpHead)
//				wcCharPrev = L'\0';
//			else
//				wcCharPrev = *(wcpHead - 1);
//			const wchar_t* wcpNext = wcpHead;
//			int iC;
//			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
//			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
//			{
//				// _xZkqqHx_iMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//				if (m_vRegExObjTbl[iC]->IsMatch(wcCharPrev, wcpNext))
//				{
//					// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_wcCharPrev, wcpNext_xZkqqHx_iCmNiOjPiCmMiImKjChFiCnGiInKjDkOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
//					wcpFrom = wcpHead;
//					wcpTo = wcpNext;
//					//----- _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiCpAiOoGjDlO_xHqqkZx_ -----
//					long lRefSize = m_vRegExObjTbl[iC]->GetMatchStrSize();
//					for (long lRefC = 0; lRefC < lRefSize; lRefC++)
//					{
//						const wchar_t* wcpRefFrom;
//						const wchar_t* wcpRefTo;
//						m_vRegExObjTbl[iC]->GetMatchStr(wcpRefFrom, wcpRefTo, lRefC);
//						m_vAfterRef.push_back(WString(wcpRefFrom, wcpRefTo));
//					}
//					return TRUE;
//				}
//			}
//		}
//	} else
//	//----- _xZkqqHx_jCmKiPoNiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		while (wcpHead != wcpTop)
//		//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKjAoGjDkKiCmJjCeCiClHiCoJiCnMiCmF_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iOjPiCmMjFlGiOjKiCnGjBjHiCoJiBeC_xHqqkZx_
//			wcpHead--;
//			int iC;
//			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
//			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
//			{
//				// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//				if (wcsncmp(m_vTokenTbl[iC].c_str(), wcpHead,
//							m_vTokenTbl[iC].length()) == 0)
//				{
//					// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
//					wcpFrom = wcpHead;
//					wcpTo = wcpHead + m_vTokenTbl[iC].length();
//					return TRUE;
//				}
//			}
//		}
//	}
//	return FALSE;
//----- 01.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	while (wcpHead != wcpTop)
	//----- _xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCkKjAoGjDkKiCmJjCeCiClHiCoJiCnMiCmF_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiKeKiOgOiImKjChFiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
		wcpHead--;
		// _xZkqqHx_iMjPiNpFiPiIjHjNiBeC_xHqqkZx_
		const wchar_t* wcpNext = GetMatchingPos(wcpTop, wcpHead);
		if (wcpNext != NULL)
		//----- _xZkqqHx_iMjPiNpFiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDhBiDgCiDgHiImKjChFiCpAiLeMjIfOiBeC_xHqqkZx_
			wcpFrom = wcpHead;
			wcpTo = wcpNext;
			return TRUE;
		}
	}
	return FALSE;
//----- 01.01.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCSearchParser::GetPrevMatchingPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::GetMatchingPos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJiMjPiNpFiOkOiCmJiDhBiDgCiDgHiClFiClNjEmNiImNiCpAjFnEiClHiBeCiMoDjFpLiOfBiPmGiDgPiDgCiDhEiDeA_xHqqkZx_
 *			_xZkqqHx_iCoAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTop		:_xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCmMiDgPiDgCiDhEiDeAiDgHiDgCiDhGiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpHead		:_xZkqqHx_iMjPiNpFjBmOiPnLiDgFiDeMiDfIiDgHiCmMiMjPiNpFiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiDhBiDgCiDgHjEmNiImNiCmMiOjPiCmMiImKjChFiBeCiDhBiDgCiDgHiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	wcpTop = "ABCDEFG", wcpHead = "CDEFG", "CDE" _xZkqqHx_iCmJiDhBiDgCiDgH_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiHiBeB_xHqqkZx_
 *			"FG"_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FCSearchParser::GetMatchingPos (const wchar_t* wcpTop, const wchar_t* wcpHead)
{
	// _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiBeC_xHqqkZx_
	m_vAfterRef.clear();
	// _xZkqqHx_iMjPiNpFiImKjChFiCkKiNmFiMoDiCmIiCoHjFjMiLeBiBeC_xHqqkZx_
	if (*wcpHead == L'\0') return NULL;
	if (IsRegExp())
	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFjHhAiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOoGjDlOiBeC_xHqqkZx_
		wchar_t wcCharPrev;
		if (wcpTop == wcpHead)
			wcCharPrev = L'\0';
		else
			wcCharPrev = *(wcpHead - 1);
		int iC;
		for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
		//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
		{
			// _xZkqqHx_iMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
			if (m_vRegExObjTbl[iC]->IsMatch(wcCharPrev, wcpHead))
			{
				// wcCharPrev, wcpHead_xZkqqHx_iCmNiOjPiCmMiImKjChFiCnGiInKjDkOiClFiCmEiCkCiCoJiBeC_xHqqkZx_
				//----- _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiCpAiOoGjDlO_xHqqkZx_ -----
				long lRefSize = m_vRegExObjTbl[iC]->GetMatchStrSize();
				for (long lRefC = 0; lRefC < lRefSize; lRefC++)
				{
					const wchar_t* wcpRefFrom;
					const wchar_t* wcpRefTo;
					m_vRegExObjTbl[iC]->GetMatchStr(wcpRefFrom, wcpRefTo, lRefC);
					m_vAfterRef.push_back(WString(wcpRefFrom, wcpRefTo));
				}
				return wcpHead;
			}
		}
	} else
	//----- _xZkqqHx_jCmKiPoNiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
	{
//----- 05.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		int iC;
//		for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
//		//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//			if (wcsncmp(m_vTokenTbl[iC].c_str(), wcpHead,
//						m_vTokenTbl[iC].length()) == 0)
//			{
//				return wcpHead + m_vTokenTbl[iC].length();
//			}
//		}
//----- 05.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		if (IsCnvUpper())
		//----- _xZkqqHx_jBoFjFlGiOjKjFmPiKlHiBgJjBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClJiClIjEoEiKhCiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			int iC;
			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
			{
				// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
				if (_wcsnicmp(	m_vTokenTbl[iC].c_str(), wcpHead,
								m_vTokenTbl[iC].length()) == 0)
				{
					return wcpHead + m_vTokenTbl[iC].length();
				}
			}
		} else
		//----- _xZkqqHx_jBoFjFlGiOjKjFmPiKlHjGlDiClFiBgJjBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmEjEoEiKhCiBgKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			int iC;
			for (iC = FDTKN_END_OF; iC < m_vTokenTbl.size(); iC++)
			//----- _xZkqqHx_jBfDiCmEiCmMjFlGiOjKjHpBiDgHiBfLiDeOiCmJjBmOiClFiCmE_xHqqkZx_ -----
			{
				// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
				if (wcsncmp(m_vTokenTbl[iC].c_str(), wcpHead,
							m_vTokenTbl[iC].length()) == 0)
				{
					return wcpHead + m_vTokenTbl[iC].length();
				}
			}
		}
//----- 05.07.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
	return NULL;
} // FCSearchParser::GetMatchingPos.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::GetReplaceText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jChFiKlHiMoDiCmMjFlGiOjKjHpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str	:_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSearchParser::GetReplaceText (WString& str) const
{
	// _xZkqqHx_iIpIjAjEiCpAiLpDiCmJiBeC_xHqqkZx_
	str.erase();
	// _xZkqqHx_jAnNjCoIiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_vReplace.empty()) return;
	if (!IsRegExp())
	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiCmFiCmNjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iClLiCmMiCnMiCnMiDfCiDhDiBfLiBeC_xHqqkZx_
		str += m_vReplace.begin();
	} else
	//----- _xZkqqHx_jAlDiLeLjFfMiMlLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		const wchar_t* wcpStr = m_vReplace.begin();
		for (;;)
		{
			if (*wcpStr == L'\0')
			//----- '\0'_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				break;
			} else
			if (*wcpStr == FDSP_WCH_END)
			//----- '$n'_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				wcpStr++;
				// *wcpStr_xZkqqHx_iCmJ_xHqqkZx_ 'n'_xZkqqHx_iCkKjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
				if (*wcpStr - 1 < m_vAfterRef.size())
				//----- _xZkqqHx_iMoDjFpLiOfBiPmGjFlGiOjKjHpBiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
				{
					str += m_vAfterRef[*wcpStr - 1];
				}
			} else
			//----- _xZkqqHx_jCmKiPoNiCmMjFlGiOjKiCmMiPoKiNiH_xHqqkZx_ -----
			{
				str += *wcpStr;
			}
			wcpStr++;
		}
	}
} // FCSearchParser::GetReplaceText.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::IsRegExp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::IsRegExp () const
{
	return m_bRegExp;
} // FCSearchParser::IsRegExp.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::IsCnvUpper
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCoJiOkOiCkKjBoFjFlGiOjKiCmJjFmPiKlHiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBoFjFlGiOjKjFmPiKlHiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::IsCnvUpper () const
{
	return m_bCnvUpper;
} // FCSearchParser::IsCnvUpper.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::ParseExpression
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiOkOjFlGiOjKjHpBiCkJiCoHiCfAiCmCiCmMiOkOiCpAiOoGiCoIiPgPiClFiCmEiBeBiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJjAmPiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpStr		:_xZkqqHx_iMjPiNpFiOkOjFlGiOjKjHpBiCpAjHfOiCkGiCoJiBeCiOkOiCpAiOoGiCoIiPgPiClFiClNiMoDiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			bMultiWord	:_xZkqqHx_jFkBjAjEjCfAiMoKiMjPiNpFiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *			bOrOpeOnly	:OR_xZkqqHx_iJiJiOfKiOhBiCmMiCnNiLjGiJmCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCjChFiKlHjFmPiKlHiCmMiPoKiNiHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOkOiCmGiCmNiBeBiImIiJlKiCmMiCkCiClIiCoKiCkJiBeC_xHqqkZx_
 *			_xZkqqHx_iBeFiNiA_xHqqkZx_ _xZkqqHx_iCmGiClLiCoKiCmJjBlBiCkN_xHqqkZx_ _xZkqqHx_iCfBiNiAiJiJiOfKiOhBiBhLiNiA_xHqqkZx_ _xZkqqHx_iCmM_xHqqkZx_0_xZkqqHx_iMmCiImIiPoDiCmMjIeBjBlBiBeC_xHqqkZx_
 *			_xZkqqHx_iNiAiCmMjAoAjGlOiCmNiBeB_xHqqkZx_ParseItem_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::ParseExpression (const wchar_t*& wcpStr, BOOL bMultiWord, BOOL bOrOpeOnly)
{
	if (bMultiWord) return ParseMultiExpression(wcpStr, bOrOpeOnly);
	// _xZkqqHx_jCfAiMoKiDgHiBfLiDeOiDjDiCpAjElCiCkLiPgPiClHiBeC_xHqqkZx_
	FCSearchToken token;
	token.ExtractWordToken(wcpStr, m_vTokenTbl);
	if (token.IsWord())
	//----- _xZkqqHx_jCfAiMoKiDgHiBfLiDeOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jCfAiMoKiCmMiDgHiBfLiDeOiDjDiCpAiDfIiDfOiDgCiDeOiCnGjAmPiCnOiBeC_xHqqkZx_
		m_vTokenStk.push_back(token);
	} else
	//----- _xZkqqHx_iKnEiIoBiCmBiClNiDgHiBfLiDeOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
		FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
		return FALSE;
	}
	return TRUE;
} // FCSearchParser::ParseExpression.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::ParseMultiExpression
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiOkOjFlGiOjKjHpBiCkJiCoHiCfAiCmCiCmMiOkOiCpAiOoGiCoIiPgPiClFiCmEiBeBiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJjAmPiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpStr		:_xZkqqHx_iMjPiNpFiOkOjFlGiOjKjHpBiCpAjHfOiCkGiCoJiBeCiOkOiCpAiOoGiCoIiPgPiClFiClNiMoDiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			bOrOpeOnly	:OR_xZkqqHx_iJiJiOfKiOhBiCmMiCnNiLjGiJmCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCjChFiKlHjFmPiKlHiCmMiPoKiNiHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOkOiCmGiCmNiBeBiImIiJlKiCmMiCkCiClIiCoKiCkJiBeC_xHqqkZx_
 *			_xZkqqHx_iBeFiNiA_xHqqkZx_ _xZkqqHx_iCmGiClLiCoKiCmJjBlBiCkN_xHqqkZx_ _xZkqqHx_iCfBiNiAiJiJiOfKiOhBiBhLiNiA_xHqqkZx_ _xZkqqHx_iCmM_xHqqkZx_0_xZkqqHx_iMmCiImIiPoDiCmMjIeBjBlBiBeC_xHqqkZx_
 *			_xZkqqHx_iNiAiCmMjAoAjGlOiCmNiBeB_xHqqkZx_ParseItem_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::ParseMultiExpression (const wchar_t*& wcpStr, BOOL bOrOpeOnly)
{
	FCSearchToken token;
	// _xZkqqHx_iCfAiNiAiCpAiOoGiCoIiPgPiClFiCmEiDfIiDfOiDgCiDeOiCmJjAmPiCnOiBeC_xHqqkZx_
	if (!ParseItem(wcpStr, bOrOpeOnly)) return FALSE;
	for (;;)
	{
		// _xZkqqHx_iJeFiKiHiMmKiPgPiMlLiCmJjEpFiCkGiCmEiDhHiDgCiDfPiImKjChFiCpAjFnLjBlGiBeC_xHqqkZx_
		const wchar_t* wcpTmp = wcpStr;
		// _xZkqqHx_iJeFiDgHiBfLiDeOiDjDiCpAjElCiCkLiPgPiClHiBeC_xHqqkZx_
		token.ExtractRToken(wcpStr);
		// _xZkqqHx_iOkOiCmMiPeJjCfLiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
		if (token == FDTKN_NONE) break;

		if (token == FDTKN_RIGHT_PARE)
		//----- _xZkqqHx_iJeFiKiHiMmKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iOkOjFlGiOjKiDhMiDeDiDjDiDfOiCmMiImKjChFiCpAiJeFiKiHiMmKiCnMiCmFjGnPiClHiBeC_xHqqkZx_
			wcpStr = wcpTmp;
			break;
		}
		if (token.IsOperator2())
		//----- _xZkqqHx_iCfBiNiAiJiJiOfKiOhBiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jChFiKlHjFmPiKlHiCmMiPoKiNiHiCmNiBeB_xHqqkZx_OR_xZkqqHx_iCmMiCnNiCgOiCgKiBeC_xHqqkZx_
			if (bOrOpeOnly && token != FDTKN_OR)
			{
				// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
				FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
				return FALSE;
			}
			// _xZkqqHx_iCfBiNiAiJiJiOfKiOhBiCmMiOjPiCmMiNiAiCpAiDfIiDfOiDgCiDeOiCnGjAmPiCnOiBeC_xHqqkZx_
			if (!ParseItem(wcpStr, bOrOpeOnly)) return FALSE;
			// _xZkqqHx_iCfBiNiAiJiJiOfKiOhBiCmMiOjPiCmMiNiAiCpAiDfIiDfOiDgCiDeOiCnGjAmPiCnOiBeC_xHqqkZx_
			m_vTokenStk.push_back(token);
		} else
		//----- _xZkqqHx_iClLiCmMjBlMiCmMiDgHiBfLiDeOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
			FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
			return FALSE;
		}
	}
	return TRUE;
} // FCSearchParser::ParseMultiExpression.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::ParseItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiOkOjFlGiOjKjHpBiCkJiCoHiCfAiCmCiCmMiNiAiCpAiOoGiCoIiPgPiClFiCmEiBeBiDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJjAmPiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpStr	:_xZkqqHx_iMjPiNpFiOkOjFlGiOjKjHpBiCpAjHfOiCkGiCoJiBeCiNiAiCpAiOoGiCoIiPgPiClFiClNiMoDiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			bOrOpeOnly	:OR_xZkqqHx_iJiJiOfKiOhBiCmMiCnNiLjGiJmCiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeCjChFiKlHjFmPiKlHiCmMiPoKiNiHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNiAiCmGiCmNiBeBiImIiJlKiCmMiCkCiClIiCoKiCkJiBeC_xHqqkZx_
 *			_xZkqqHx_iBeFjCfAiMoKiBeC_xHqqkZx_
 *			_xZkqqHx_iBeF_xHqqkZx_( )_xZkqqHx_iCmFiImNiCnMiCoKiClNiOkOiBeC_xHqqkZx_
 *			_xZkqqHx_iBeFjCfAiNiAiJiJiOfKiOhBiBhLiNiAiBeC_xHqqkZx_
 *			_xZkqqHx_iOkOiCmMjAoAjGlOiCmNiBeB_xHqqkZx_ParseMultiExpression_xZkqqHx_iKnGjAjEiCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::ParseItem (const wchar_t*& wcpStr, BOOL bOrOpeOnly)
{
	FCSearchToken token;
	// _xZkqqHx_iNlGiDgHiBfLiDeOiDjDiCpAjElCiCkLiPgPiClHiBeC_xHqqkZx_
	token.ExtractLToken(wcpStr, m_vTokenTbl);
	if (token.IsOperator1())
	//----- _xZkqqHx_jCfAiNiAiJiJiOfKiOhBiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jChFiKlHjFmPiKlHiCmMiPoKiNiHiCmNiBeB_xHqqkZx_OR_xZkqqHx_iCmMiCnNiCgOiCgKiBeC_xHqqkZx_
		if (bOrOpeOnly)
		{
			// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
			FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
			return FALSE;
		}
		// _xZkqqHx_iOjPiCmMiCfAiDgHiBfLiDeOiDjDiCpAiDfIiDfOiDgCiDeOiCnGjAmPiCnOiBeC_xHqqkZx_
		if (!ParseItem(wcpStr, bOrOpeOnly)) return FALSE;
		// _xZkqqHx_iClDiCmBiCkLiCmMjCfAiNiAiJiJiOfKiOhBiCpAiDfIiDfOiDgCiDeOiCnGjAmPiCnOiBeC_xHqqkZx_
		m_vTokenStk.push_back(token);
	} else if (token == FDTKN_LEFT_PARE)
	//----- _xZkqqHx_iNlGiKiHiMmKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iKiHiMmKjCiGiCmMiOkOiCpAiDfIiDfOiDgCiDeOiCnGjAmPiCnOiBeC_xHqqkZx_
		if (!ParseMultiExpression(wcpStr, bOrOpeOnly)) return FALSE;
		// _xZkqqHx_iOjPiCmMiJeFiDgHiBfLiDeOiDjDiCpAjElCiCkLiPgPiClHiBeC_xHqqkZx_
		token.ExtractRToken(wcpStr);
		if (token != FDTKN_RIGHT_PARE)
		//----- _xZkqqHx_iOjPiCmMiJeFiDgHiBfLiDeOiDjDiCkKiJeFiKiHiMmKiCmFiCmIiCkPiCoKiCmOiDeHiDiJiBfL_xHqqkZx_ -----
		{
			// IDS_ERR_MSG_UNMATCH_PARENTHESIS = "_xZkqqHx_iKiHiMmKiCmMjBmOiJjOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
			FFErrorBox(IDS_ERR_MSG_UNMATCH_PARENTHESIS, wcpStr);
			return FALSE;
		}
	} else if (token.IsWord())
	//----- _xZkqqHx_jCfAiMoKiDgHiBfLiDeOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jCfAiMoKiCmMiDgHiBfLiDeOiDjDiCpAiDfIiDfOiDgCiDeOiCnGjAmPiCnOiBeC_xHqqkZx_
		m_vTokenStk.push_back(token);
	} else
	//----- _xZkqqHx_iKnEiIoBiCmBiClNiDgHiBfLiDeOiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// IDS_ERR_MSG_WRONG_FORMULA = "_xZkqqHx_iOkOiCmJiMoLiCoIiCkKiCkAiCoIiCnMiClH_xHqqkZx_ :%s"
		FFErrorBox(IDS_ERR_MSG_WRONG_FORMULA, wcpStr);
		return FALSE;
	}
	return TRUE;
} // FCSearchParser::ParseItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::Evaluate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IsMatch_xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeCiMjPiNpFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTokenStk	:_xZkqqHx_iDgHiBfLiDeOiDjDiCmMiDfIiDfOiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vIsHitTbl	:_xZkqqHx_iDhBiDgCiDgHiMiLiJmKiCmMiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTarget	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	-1	:_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *			0	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ FALSE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			1	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ TRUE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vTokenStk_xZkqqHx_iCmNiBeBiMjPiNpFiOkOiCmMiDgHiBfLiDeOiDjDiCpAiLhEiDhMiBfLiDiJiDjDiDgIiMgAiOkOiCmFjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiOkOiCkK_xHqqkZx_  (A&B)|C  _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJiCmN_xHqqkZx_  A B & C |  _xZkqqHx_iCkKjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAiBeBiMoDiCoLiCkJiCoHiIoKiCmCiClIiCmC_xHqqkZx_pop_xZkqqHx_iClFiBeBjFfNiJlPiClFiCmEiCkCiCkNiBeC_xHqqkZx_
 *			vIsHitTbl_xZkqqHx_iCmNiBeBiDgHiBfLiDeOiDjDiCmMjAjEiCmGjDkPiClGiDfEiDeDiDfJiCmMjEhKjHpBiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiDgHiBfLiDeOiDjDiCmMiMjPiNpFiMiLiJmKiCpAjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiPoDiCmMjFlGiOjKiDgHiBfLiDeOiDjD_xHqqkZx_"A"_xZkqqHx_iCmMiMjPiNpFiCmMiMiLiJmKiCmN_xHqqkZx_
 *			vIsHitTbl["A"]_xZkqqHx_iCmJjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeCiMjPiNpFiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeBiDeBiDjDiDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCSearchParser::Evaluate (shortVector& vTokenStk, shortVector& vIsHitTbl,
								const wchar_t* wcpTarget)
{
	if (vTokenStk.size() <= 0) return -1;
	short nToken = vTokenStk.back();
	vTokenStk.pop_back();
	switch (nToken)
	{
	case FDTKN_NOT:		// NOT. _xZkqqHx_jCfAiNiAiJiJiOfKiOhB_xHqqkZx_ : A kind of Operator1.
		return EvalNot(vTokenStk, vIsHitTbl, wcpTarget);
	case FDTKN_AND:		// AND. _xZkqqHx_iCfBiNiAiJiJiOfKiOhB_xHqqkZx_ : A kind of Operator2.
		return EvalAnd(vTokenStk, vIsHitTbl, wcpTarget);
	case FDTKN_OR:		// OR.  _xZkqqHx_iCfBiNiAiJiJiOfKiOhB_xHqqkZx_ : A kind of Operator2.
		return EvalOr(vTokenStk, vIsHitTbl, wcpTarget);
	default:
		// _xZkqqHx_jCfAiMoKiDgHiBfLiDeOiDjDiCmFiCmIiCkCiCmIiCoHiCmOiDeHiDiJiBfLiBeC_xHqqkZx_
		if (nToken < FDTKN_END_OF) return -1;
		// _xZkqqHx_jClCiNlIjFhDjHhGiBgJiDgHiBfLiDeOiDjDiDfIiDeMiDgCiDhGiCmMiCnNiBgKiCmMiPoKiNiHiCmN_xHqqkZx_ 0(FALSE) _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
		if (wcpTarget == NULL) return 0;

		if (vIsHitTbl[nToken] < 0)
		//----- _xZkqqHx_jGkCiClOiDhBiDgCiDgHiDgAiDeGiDgCiDeOiClDiCoKiCmEiCkCiCmIiCkCjCfAiMoKiCmMiPoKiNiH_xHqqkZx_ -----
		{
			wchar_t wcCharPrev = L'\0';
			const wchar_t* wcpHead = wcpTarget;
			vIsHitTbl[nToken] = 0;
			if (IsRegExp())
			//----- _xZkqqHx_jAlDiLeLjFfMiMlLiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
			{
				const wchar_t* wcpTmp;
				while (vIsHitTbl[nToken] == 0)
				{
					// _xZkqqHx_iPeJjHlJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
					if (*wcpHead == L'\0') break;
					// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
					wcpTmp = wcpHead;
					if (m_vRegExObjTbl[nToken]->IsMatch(wcCharPrev, wcpTmp))
						vIsHitTbl[nToken] = 1;
					// _xZkqqHx_iOjPiCmMjFlGiOjKiCnGjBjHiCoJiBeC_xHqqkZx_
					wcCharPrev = *wcpHead;
					wcpHead++;
				}
			} else
			//----- _xZkqqHx_jCmKiPoNiMjPiNpFiCmMiPoKiNiH_xHqqkZx_ -----
			{
				while (vIsHitTbl[nToken] == 0)
				{
					// _xZkqqHx_iPeJjHlJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
					if (*wcpHead == L'\0') break;
					// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
//----- 05.01.07 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//					if (wcsncmp(m_vTokenTbl[nToken].c_str(), wcpHead, m_vTokenTbl[nToken].length()) == 0)
//						vIsHitTbl[nToken] = 1;
//----- 05.01.07 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
					if (IsCnvUpper())
					//----- _xZkqqHx_jBoFjFlGiOjKjFmPiKlHiBgJjBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClJiClIjEoEiKhCiBgKiCmMiPoKiNiH_xHqqkZx_ -----
					{
						if (_wcsnicmp(m_vTokenTbl[nToken].c_str(), wcpHead, m_vTokenTbl[nToken].length()) == 0)
							vIsHitTbl[nToken] = 1;
					} else
					//----- _xZkqqHx_jBoFjFlGiOjKjFmPiKlHjGlDiClFiBgJjBoFjFlGiOjKiBeFiPkMjFlGiOjKiCpAiLoGjFmKiClFiCmEjEoEiKhCiBgKiCmMiPoKiNiH_xHqqkZx_ -----
					{
						if (wcsncmp(m_vTokenTbl[nToken].c_str(), wcpHead, m_vTokenTbl[nToken].length()) == 0)
							vIsHitTbl[nToken] = 1;
					}
//----- 05.01.07 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
					// _xZkqqHx_iOjPiCmMjFlGiOjKiCnGjBjHiCoJiBeC_xHqqkZx_
					wcpHead++;
				}
			}
		}
		return vIsHitTbl[nToken];
	}
} // FCSearchParser::Evaluate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::EvalNot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IsMatch_xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_NOT_xZkqqHx_iDeJiDhJiDiMiBfLiDfOiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTokenStk	:_xZkqqHx_iDgHiBfLiDeOiDjDiCmMiDfIiDfOiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vIsHitTbl	:_xZkqqHx_iDhBiDgCiDgHiMiLiJmKiCmMiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTarget	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	-1	:_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *			0	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ FALSE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			1	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ TRUE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vTokenStk_xZkqqHx_iCmNiBeBiMjPiNpFiOkOiCmMiDgHiBfLiDeOiDjDiCpAiLhEiDhMiBfLiDiJiDjDiDgIiMgAiOkOiCmFjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiOkOiCkK_xHqqkZx_  (A&B)|C  _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJiCmN_xHqqkZx_  A B & C |  _xZkqqHx_iCkKjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAiBeBiMoDiCoLiCkJiCoHiIoKiCmCiClIiCmC_xHqqkZx_pop_xZkqqHx_iClFiBeBjFfNiJlPiClFiCmEiCkCiCkNiBeC_xHqqkZx_
 *			vIsHitTbl_xZkqqHx_iCmNiBeBiDgHiBfLiDeOiDjDiCmMjAjEiCmGjDkPiClGiDfEiDeDiDfJiCmMjEhKjHpBiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiDgHiBfLiDeOiDjDiCmMiMjPiNpFiMiLiJmKiCpAjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiPoDiCmMjFlGiOjKiDgHiBfLiDeOiDjD_xHqqkZx_"A"_xZkqqHx_iCmMiMjPiNpFiCmMiMiLiJmKiCmN_xHqqkZx_
 *			vIsHitTbl["A"]_xZkqqHx_iCmJjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeCiMjPiNpFiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeBiDeBiDjDiDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCSearchParser::EvalNot (shortVector& vTokenStk, shortVector& vIsHitTbl,
							const wchar_t* wcpTarget)
{
	// _xZkqqHx_jBoGiCfAiNiAiCmMjFfNiJlPiMiLiJmKiCpAiOoGjDlOiBeC_xHqqkZx_
	int iArg0 = Evaluate(vTokenStk, vIsHitTbl, wcpTarget);
	// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmNiDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
	if (iArg0 < 0) return iArg0;
	// _xZkqqHx_jBoGiCfAiNiAiCmMjFfNiJlPiMiLiJmKiCmMiLhEiCpAjFnEiClHiBeC_xHqqkZx_
	return !iArg0;
} // FCSearchParser::EvalNot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::EvalAnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IsMatch_xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_AND_xZkqqHx_iDeJiDhJiDiMiBfLiDfOiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTokenStk	:_xZkqqHx_iDgHiBfLiDeOiDjDiCmMiDfIiDfOiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vIsHitTbl	:_xZkqqHx_iDhBiDgCiDgHiMiLiJmKiCmMiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTarget	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	-1	:_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *			0	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ FALSE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			1	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ TRUE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vTokenStk_xZkqqHx_iCmNiBeBiMjPiNpFiOkOiCmMiDgHiBfLiDeOiDjDiCpAiLhEiDhMiBfLiDiJiDjDiDgIiMgAiOkOiCmFjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiOkOiCkK_xHqqkZx_  (A&B)|C  _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJiCmN_xHqqkZx_  A B & C |  _xZkqqHx_iCkKjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAiBeBiMoDiCoLiCkJiCoHiIoKiCmCiClIiCmC_xHqqkZx_pop_xZkqqHx_iClFiBeBjFfNiJlPiClFiCmEiCkCiCkNiBeC_xHqqkZx_
 *			vIsHitTbl_xZkqqHx_iCmNiBeBiDgHiBfLiDeOiDjDiCmMjAjEiCmGjDkPiClGiDfEiDeDiDfJiCmMjEhKjHpBiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiDgHiBfLiDeOiDjDiCmMiMjPiNpFiMiLiJmKiCpAjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiPoDiCmMjFlGiOjKiDgHiBfLiDeOiDjD_xHqqkZx_"A"_xZkqqHx_iCmMiMjPiNpFiCmMiMiLiJmKiCmN_xHqqkZx_
 *			vIsHitTbl["A"]_xZkqqHx_iCmJjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeCiMjPiNpFiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeBiDeBiDjDiDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCSearchParser::EvalAnd (shortVector& vTokenStk, shortVector& vIsHitTbl,
							const wchar_t* wcpTarget)
{
	// _xZkqqHx_jBoGiCfAiNiAiCmMjFfNiJlPiMiLiJmKiCpAiOoGjDlOiBeC_xHqqkZx_
	int iArg0 = Evaluate(vTokenStk, vIsHitTbl, wcpTarget);
	// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmNiDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
	if (iArg0 < 0) return iArg0;
	// _xZkqqHx_jBoGiCfAiNiAiCmMjFfNiJlPiMiLiJmKiCkK_xHqqkZx_ FALSE _xZkqqHx_iCmIiCoHiCmOiBeBjBoGiCfBiNiAiCmNiDgHiBfLiDeOiDjDiCpAjBjHiCoJiClOiCkPiBeC_xHqqkZx_
	if (iArg0 == 0)
	{
		(void)Evaluate(vTokenStk, vIsHitTbl, NULL);
		return iArg0;
	}
	// _xZkqqHx_jBoGiCfBiNiAiCmMjFfNiJlPiMiLiJmK_xHqqkZx_ _xZkqqHx_iBiB_xHqqkZx_ AND_xZkqqHx_iCmMjFfNiJlPiMiLiJmKiBeC_xHqqkZx_
	return Evaluate(vTokenStk, vIsHitTbl, wcpTarget);
} // FCSearchParser::EvalAnd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::EvalOr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	IsMatch_xZkqqHx_iCmMiDfEiDhFiKnGjAjEiBeC_xHqqkZx_OR_xZkqqHx_iDeJiDhJiDiMiBfLiDfOiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTokenStk	:_xZkqqHx_iDgHiBfLiDeOiDjDiCmMiDfIiDfOiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vIsHitTbl	:_xZkqqHx_iDhBiDgCiDgHiMiLiJmKiCmMiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpTarget	:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	-1	:_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiBeC_xHqqkZx_
 *			0	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ FALSE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *			1	:_xZkqqHx_jFfNiJlPiMiLiJmKiCkK_xHqqkZx_ TRUE _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vTokenStk_xZkqqHx_iCmNiBeBiMjPiNpFiOkOiCmMiDgHiBfLiDeOiDjDiCpAiLhEiDhMiBfLiDiJiDjDiDgIiMgAiOkOiCmFjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iMjPiNpFiOkOiCkK_xHqqkZx_  (A&B)|C  _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_
 *			_xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJiCmN_xHqqkZx_  A B & C |  _xZkqqHx_iCkKjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCpAiBeBiMoDiCoLiCkJiCoHiIoKiCmCiClIiCmC_xHqqkZx_pop_xZkqqHx_iClFiBeBjFfNiJlPiClFiCmEiCkCiCkNiBeC_xHqqkZx_
 *			vIsHitTbl_xZkqqHx_iCmNiBeBiDgHiBfLiDeOiDjDiCmMjAjEiCmGjDkPiClGiDfEiDeDiDfJiCmMjEhKjHpBiCmFiCkAiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiDgHiBfLiDeOiDjDiCmMiMjPiNpFiMiLiJmKiCpAjFnLjBlGiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiPoDiCmMjFlGiOjKiDgHiBfLiDeOiDjD_xHqqkZx_"A"_xZkqqHx_iCmMiMjPiNpFiCmMiMiLiJmKiCmN_xHqqkZx_
 *			vIsHitTbl["A"]_xZkqqHx_iCmJjFnLjBlGiClDiCoKiCmEiCkCiCoJiBeCiMjPiNpFiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_iDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 1_xZkqqHx_iBeBiDeBiDjDiDhBiDgCiDgHiCmMiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.21 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCSearchParser::EvalOr (shortVector& vTokenStk, shortVector& vIsHitTbl,
							const wchar_t* wcpTarget)
{
	// _xZkqqHx_jBoGiCfAiNiAiCmMjFfNiJlPiMiLiJmKiCpAiOoGjDlOiBeC_xHqqkZx_
	int iArg0 = Evaluate(vTokenStk, vIsHitTbl, wcpTarget);
	// _xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmNiDeHiDiJiBfLiDfCiBfLiDgIiCpAjFnEiClHiBeC_xHqqkZx_
	if (iArg0 < 0) return iArg0;
	// _xZkqqHx_jBoGiCfAiNiAiCmMjFfNiJlPiMiLiJmKiCkK_xHqqkZx_ TRUE _xZkqqHx_iCmIiCoHiCmOiBeBjBoGiCfBiNiAiCmNiDgHiBfLiDeOiDjDiCpAjBjHiCoJiClOiCkPiBeC_xHqqkZx_
	if (iArg0 == 1)
	{
		(void)Evaluate(vTokenStk, vIsHitTbl, NULL);
		return iArg0;
	}
	// _xZkqqHx_jBoGiCfBiNiAiCmMjFfNiJlPiMiLiJmK_xHqqkZx_ _xZkqqHx_iBiB_xHqqkZx_ OR_xZkqqHx_iCmMjFfNiJlPiMiLiJmKiBeC_xHqqkZx_
	return Evaluate(vTokenStk, vIsHitTbl, wcpTarget);
} // FCSearchParser::EvalOr.

#if 0
// _xZkqqHx_jClHiCkCjFlGiOjKjHpBiBgJiLjAjBoFiCmIiDhEiDeAiDeDiDiLjDjJiBgKiCmMiPoKiNiHiCmNiBeBiClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmF_xHqqkZx_
// _xZkqqHx_iCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCkKiDhNiDgCiDgAiClHiCoJiCkJiCmMiDgFiDfIiDgHiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpTarget:_xZkqqHx_iMjPiNpFjBmOiPnLiCmMiDgFiDeMiDfIiDgHjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jClHiCkCjFlGiOjKjHpBiBgJiLjAjBoFiCmIiDhEiDeAiDeDiDiLjDjJiBgKiCmMiPoKiNiHiCmNiBeBiClBiCmMiDeBiDiLiDfDiDiKiDfJiDiAiCmF_xHqqkZx_
 *			_xZkqqHx_iCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::IsMatch (const wchar_t* wcpTarget)
{
	const int iSize = m_vTokenTbl.size();
	// _xZkqqHx_iDhBiDgCiDgHiDgFiBfLiDhFiDiLiCmJiDgHiBfLiDeOiDjDiDgFiBfLiDhFiDiLiCmGjDkPiDfEiDeDiDfJiCmM_xHqqkZx_FALSE_xZkqqHx_iCpAiKiEiCoIjAfFiCoJiBeC_xHqqkZx_
	shortVector vIsHitTbl;
	vIsHitTbl.assign(iSize, FALSE);
	wchar_t wcCharPrev = L'\0';
	const wchar_t* wcpTmp;
	const wchar_t* wcpHead = wcpTarget;
	for (;;)
	{
		// _xZkqqHx_iPeJjHlJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		if (*wcpHead == L'\0') break;
		// _xZkqqHx_jBfDiCmEiCmMiMjPiNpFjHhGjBgGiCkKiDhBiDgCiDgHiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
		BOOL bHitAll = TRUE;
		for (int iC = FDTKN_END_OF; iC < iSize; iC++)
		{
			// _xZkqqHx_jGkCiClOiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiMjPiNpFjHhGjBgGiCmJiCmCiCkCiCmEjClCiCnHiCoJiBeC_xHqqkZx_
			if (!vIsHitTbl[iC])
			{
				wcpTmp = wcpHead;
				if (m_vRegExObjTbl[iC]->IsMatch(wcCharPrev, wcpTmp))
					vIsHitTbl[iC] = TRUE;
				else
					bHitAll = FALSE;
			}
		}
		// _xZkqqHx_jBfDiCmEiCmMiMjPiNpFjHhGjBgGiCkKiDhBiDgCiDgHiClFiClNiPoKiNiHiCmNiBeBiMjPiNpFjBmOiPnLiCkKjDhCjCiGiCmFiCoAiPeJjHlJiBeC_xHqqkZx_
		if (bHitAll) break;
		wcCharPrev = *wcpHead;
		wcpHead++;
	}
	return CalcTokenStack(vIsHitTbl);
} // FCSearchParser::IsMatch (const wchar_t* wcpTarget).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSearchParser::CalcTokenStack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOiCmJiPfNiCmBiCmEiBeBiDhBiDgCiDgHiDgFiBfLiDhFiDiLiCmM_xHqqkZx_ TRUE / FALSE_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vIsHitTbl	:_xZkqqHx_iKgFjCfAiMoKiDgHiBfLiDeOiDjDiCkKiDhBiDgCiDgHiClFiClNiCkJiCmHiCkEiCkJiCmMiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMhGiOfKiMiLiJmKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSearchParser::CalcTokenStack (const shortVector& vIsHitTbl) const
{
	BOOLVector	vBoolStk;
	shortVector::const_iterator iStk;
	BOOL bV;
	for (iStk = m_vTokenStk.begin(); iStk != m_vTokenStk.end(); iStk++)
	{
		switch (*iStk)
		{
		case FDTKN_NOT:
			vBoolStk.back() = !vBoolStk.back();
			break;

		case FDTKN_AND:
			bV = vBoolStk.back();
			vBoolStk.pop_back();
			vBoolStk.back() &= bV;
			break;

		case FDTKN_OR:
			bV = vBoolStk.back();
			vBoolStk.pop_back();
			vBoolStk.back() |= bV;
			break;

		default: // _xZkqqHx_iDgHiBfLiDeOiDjDiDfIiDfOiDgCiDeOjCiGiCmJiCmNiDeJiDhJiDiMiBfLiDfOiImIiKePiCmNjCfAiMoKiCmMiCnNiBeC_xHqqkZx_
			vBoolStk.push_back(vIsHitTbl[*iStk]);
		}
	}
	return vBoolStk.back();
} // FCSearchParser::CalcTokenStack.
#endif//0

