#include "stdafx.h"
#include <algorithm>		// For find template.
#include "DynamicDraw.h"
#include "LayerManager.h"	// For FCLayerManager.
#include "ZOrder.h"			// For FCZOrder.
#include "ObjDynabase.h"		// For FCObjDynabase.
#include "UtilStr.h"		// For GetResString.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "NewFDObjAny.h"	// For NewFDObjAny.
#include "SheetManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::FCSheetManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSheetManager::FCSheetManager ()
{
	Initialize();
} // FCSheetManager::FCSheetManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::~FCSheetManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCSheetManager::~FCSheetManager ()
{
	Clear();
} // FCSheetManager::~FCSheetManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDiCpAiPiJiKpKiJlLiClHiCoJiBeCiNmFiPoDiImKiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiBeBjCiGiKnE_xHqqkZx_
 *			_xZkqqHx_iDiMiDeDiDiEiBfLiCmMiDgGiDhEiDeIiDiLiDgHjCgMiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::Initialize ()
{
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	Clear();
//	CString strName;
//	// "_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
//	strName.Format(_T("%s1"), ::GetResWString(IDS_UNTITLED_SHEET));
//	FCLayerManager* pLayerMgr = new FCLayerManager(strName, m_mpObjToLZHash,
//													m_vBottomLayer, m_vTopLayer);
//	//----- _xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1_xZkqqHx_iCpAjBhNjDpM_xHqqkZx_ -----
//	// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
//	strName.Format(_T("%s1"), ::GetResWString(IDS_UNTITLED_LAYER));
//	pLayerMgr->InsertLayer(1, strName, FDOZ_ON_ALL);
//	pLayerMgr->SetCurrentLayerIdx(1);
//	m_vSheet.push_back(pLayerMgr);
//	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
//	m_stidCurrentSheet = 0;
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	Clear();
	// "_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
	WString strName;
// 03.07.12 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	strName.Format(L"%s1", ::GetResWString(IDS_UNTITLED_SHEET));
	strName.Format(L"%s1", (const wchar_t*)FFLoadWString(IDS_UNTITLED_SHEET));
	// _xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfI_xHqqkZx_ = 0_xZkqqHx_iBeBiDfGiBfLiDgH_xHqqkZx_ID = 0 _xZkqqHx_iCmFiDfGiBfLiDgHjBhNjDpMiBeC_xHqqkZx_
	SheetID stidNew;
	InsertSheet(stidNew, strName, 0, 0);
	//----- _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_0_xZkqqHx_iCmJiDiMiDeDiDiEiBfL_xHqqkZx_1_xZkqqHx_iCpAjBhNjDpM_xHqqkZx_ -----
	// "_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1"_xZkqqHx_iBeC_xHqqkZx_
// 03.07.12 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	strName.Format(L"%s1", ::GetResWString(IDS_UNTITLED_LAYER));
	strName.Format(L"%s1", (const wchar_t*)FFLoadWString(IDS_UNTITLED_LAYER));
	GetSheet(0)->InsertLayer(1, strName, FDOZ_ON_ALL);
	GetSheet(0)->SetCurrentLayerIdx(1);
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
	m_stidCurrentSheet = 0;
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCSheetManager::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiNoNiPjMiPiIjHjNiCmNiClJiClIiBeBiDfGiBfLiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::Clear ()
{
	//----- _xZkqqHx_jBfDiCmEiCmMiDfGiBfLiDgHiCpAiDeOiDiKiDeB_xHqqkZx_ -----
	LayerManagerPVector::iterator iZb;
	for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++)
		if (*iZb != NULL) delete *iZb;
	m_vSheet.clear();
	m_vFreqSheet.clear();
	// _xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_mpObjToLZHash.clear();
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vBottomLayer.clear();
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vTopLayer.clear();
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
	m_stidCurrentSheet = 0;
} // FCSheetManager::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::DeleteAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiNoNiPjMiPiIjHjNiCpAiOmAiNhDiClFiBeBiDfGiBfLiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::DeleteAll ()
{
	//----- _xZkqqHx_jBfDiCmEiCmMiDfGiBfLiDgHiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	LayerManagerPVector::iterator iZb;
	for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++)
		if (*iZb != NULL)
		{
			(*iZb)->DeleteAll();
			delete *iZb;
		}
	m_vSheet.clear();
	m_vFreqSheet.clear();
	// _xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_mpObjToLZHash.clear();
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	ObjDynabaseVector::iterator iObj;
	for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
	{
		// Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkK_xHqqkZx_
		// _xZkqqHx_iCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiClNiCnPiBeB_xHqqkZx_(*iObj)->Terminate() _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
		delete *iObj;
	}
	m_vBottomLayer.clear();
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
	{
		// Molip_xZkqqHx_iCpA_xHqqkZx_OLE_xZkqqHx_iCmGiClFiCmEiDhJiBfLiDfIiDgHiClFiClNjAoGiCmMiDeBiDhGiDiKiCkJiCoHiBeB_xHqqkZx_Molip_xZkqqHx_iNmEjFnCiPfHiCkK_xHqqkZx_
		// _xZkqqHx_iCmFiCkLiCmIiCkNiCmIiCmBiCmEiClFiCnMiCkEiClNiCnPiBeB_xHqqkZx_(*iObj)->Terminate() _xZkqqHx_iCpAiOmAiNhDiClFiCmIiCkCiBeC_xHqqkZx_
		delete *iObj;
	}
	m_vTopLayer.clear();
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
	m_stidCurrentSheet = 0;
} // FCSheetManager::DeleteAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdar		:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOutObject:_xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void FCSheetManager::OutStream (FCUndoArchive& fdar, BOOL bIsOutObject) const
void FCSheetManager::OutStream (FCUndoArchive& fdar, BOOL bIsOutObject, BOOL bIsOutBezier) const
{
	if (bIsOutObject)
	//----- _xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDfGiBfLiDgHiCpAiPgPjHmN_xHqqkZx_ -----
		FDSheetIDVector::const_iterator iSheetID;
		// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		fdar << long(m_vFreqSheet.size());
		for (iSheetID = m_vFreqSheet.begin(); iSheetID != m_vFreqSheet.end(); iSheetID++)
		{
			fdar.Write(&(*iSheetID), sizeof(*iSheetID));
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			m_vSheet[*iSheetID]->OutStream(fdar, bIsOutObject);
			m_vSheet[*iSheetID]->OutStream(fdar, bIsOutObject, bIsOutBezier);
		}
		//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
		ObjDynabaseVector::const_iterator iObj;
		// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		fdar << (DWORD)m_vBottomLayer.size();
		for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
		{
			fdar << (BYTE)((*iObj)->Type());
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			(*iObj)->OutStream(fdar);
			(*iObj)->OutStream(fdar, bIsOutBezier);
		}
		//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
		// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		fdar << (DWORD)m_vTopLayer.size();
		for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
		{
			fdar << (BYTE)((*iObj)->Type());
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			(*iObj)->OutStream(fdar);
			(*iObj)->OutStream(fdar, bIsOutBezier);
		}
	} else
	//----- _xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClFiCmIiCkCiBgJiDgFiDjDiDhGiDiMiBfLiDgHjDjJiBgKiPoKiNiH_xHqqkZx_ -----
	{
		// OutStream_xZkqqHx_iKnGjAjEiCmGjDkPiClGiMgAiOkOiCmFiDhEiDeAiDeDiDiLiCpAiPgPjHmNiBeCjFjEjFgJjAjE_xHqqkZx_=0_xZkqqHx_iCpAiPgPjHmNiBeC_xHqqkZx_
		// _xZkqqHx_iOoFiCmJiDiMiDeDiDiEiBfLiNfMjBkCiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_

		//----- _xZkqqHx_iDfGiBfLiDgHiCpAiPgPjHmN_xHqqkZx_ -----
		// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		fdar << long(1);
		fdar.Write(&(m_vFreqSheet[0]), sizeof(m_vFreqSheet[0]));
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		m_vSheet[m_vFreqSheet[0]]->OutStream(fdar, bIsOutObject);
		m_vSheet[m_vFreqSheet[0]]->OutStream(fdar, bIsOutObject, bIsOutBezier);

		//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
		// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		fdar << DWORD(0);
		//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
		// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
		fdar << DWORD(0);
	}
} // FCSheetManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdar	:_xZkqqHx_jDpMjHmNiMlDiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::InStream (FCUndoArchive& fdar)
{
	// _xZkqqHx_iPiJiKpKiJlLiBeCiDfCiDjDiDfIiDgHiDiJiDeOiDfOiCmF_xHqqkZx_Initialize_xZkqqHx_iClDiCoKiCoJiCmMiCmFiBeBiClBiCoKiCkKjFeLjAhLiBeC_xHqqkZx_
	Clear();
	//----- _xZkqqHx_iDfGiBfLiDgHiCpAjDpMjHmN_xHqqkZx_ -----
	long lSheet;
	SheetID stid;
	// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
// 03.04.29 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ( )
//	ar >> lSheet;
	fdar >> lSheet;
	while (0 < lSheet--)
	{
// 03.04.29 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ( )
//		ar.Read(&stid, sizeof(stid));
		fdar.Read(&stid, sizeof(stid));
		m_vFreqSheet.push_back(stid);
		FCLayerManager* pRecSheet = new FCLayerManager(TRUE, L"", m_mpObjToLZHash,
														m_vBottomLayer, m_vTopLayer);
// 03.04.29 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ( )
//		pRecSheet->InStream(ar);
		pRecSheet->InStream(fdar);
		if (m_vSheet.size() <= stid)
			m_vSheet.resize(stid + 1, NULL);
		m_vSheet[stid] = pRecSheet;
	}
	FCLayerManager* pTopSheet = m_vSheet[m_vFreqSheet.front()];
	DWORD dwTopLayer = pTopSheet->GetLayerSize() - 1;
// 03.04.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	FCUndoArchive fdar(ar);
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAjDpMjHmN_xHqqkZx_ -----
	DWORD dwObjSz;
	DWORD dwObjC;
	BYTE byType;
	FCObjDynabase* pObj;
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	fdar >> dwObjSz;
	for (dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
	{
		fdar >> byType;
		pObj = NewFDObjAny(FTObjectType(byType));
		pObj->InStream(fdar);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
		pObj->RegisterObjForceID();
		// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
		pTopSheet->AppendToLZOrder(0, pObj);
	}
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	fdar >> dwObjSz;
	for (dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
	{
		fdar >> byType;
		pObj = NewFDObjAny(FTObjectType(byType));
		pObj->InStream(fdar);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
		pObj->RegisterObjForceID();
		// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
		pTopSheet->AppendToLZOrder(dwTopLayer, pObj);
	}

//----- 01.08.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iNmFiPiJiCmMiDfGiBfLiDgHiCmM_xHqqkZx_ID_xZkqqHx_iCpAiDeKiDiMiDjDiDgHiCmJjAnNjCoIiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeBjDmHiCnNiNjOiCpBiClO_xHqqkZx_
	// _xZkqqHx_jFlGiPjBiCmM_xHqqkZx_ SheetID = 0 _xZkqqHx_iCmMiDfGiBfLiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmJjHiOiClPiCoJiBeC_xHqqkZx_
	SetCurrentSheetId(SheetIndexToID(0));
//----- 01.08.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCSheetManager::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::InTopBottomSheetStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKgFiDfGiBfLiDgHjGlMiCmGiBeBiNmFiPoDiImKiDiMiDeDiDiEiBfLiBeFiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiBeB_xHqqkZx_
 *			_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCkJiCoHjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNiMlDiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::InTopBottomSheetStream (FCUndoArchive& ar)
{
	// _xZkqqHx_iPiJiKpKiJlLiBeCiDfCiDjDiDfIiDgHiDiJiDeOiDfOiCmF_xHqqkZx_Initialize_xZkqqHx_iClDiCoKiCoJiCmMiCmFiBeBiClBiCoKiCkKjFeLjAhLiBeC_xHqqkZx_
	Clear();
	//----- _xZkqqHx_iDfGiBfLiDgHiCpAjDpMjHmN_xHqqkZx_ -----
	long lSheet;
	SheetID stid;
	// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
	ar >> lSheet;
	while (0 < lSheet--)
	{
		ar >> stid;
		m_vFreqSheet.push_back(stid);
		FCLayerManager* pRecSheet = new FCLayerManager(FALSE, L"", m_mpObjToLZHash,
														m_vBottomLayer, m_vTopLayer);
		// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAjDpMjHmNiBeC_xHqqkZx_
		ar.ReadString(pRecSheet->GetName());
		if (m_vSheet.size() <= stid)
			m_vSheet.resize(stid + 1, NULL);
		m_vSheet[stid] = pRecSheet;
	}
	FCLayerManager* pTopSheet = m_vSheet[m_vFreqSheet.front()];
	DWORD dwTopLayer = pTopSheet->GetLayerSize() - 1;
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAjDpMjHmN_xHqqkZx_ -----
	DWORD dwObjSz;
	DWORD dwObjC;
	BYTE byType;
	FCObjDynabase* pObj;
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> dwObjSz;
	for (dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
	{
		ar >> byType;
		pObj = NewFDObjAny(FTObjectType(byType));
		pObj->InStream(ar);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
		pObj->RegisterObjForceID();
		// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
		pTopSheet->AppendToLZOrder(0, pObj);
	}
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> dwObjSz;
	for (dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
	{
		ar >> byType;
		pObj = NewFDObjAny(FTObjectType(byType));
		pObj->InStream(ar);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
		pObj->RegisterObjForceID();
		// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
		pTopSheet->AppendToLZOrder(dwTopLayer, pObj);
	}
	// _xZkqqHx_iNmFiPiJiCmMiDfGiBfLiDgHiCmM_xHqqkZx_ID_xZkqqHx_iCpAiDeKiDiMiDjDiDgHiCmJjAnNjCoIiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeBjDmHiCnNiNjOiCpBiClO_xHqqkZx_
	// _xZkqqHx_jFlGiPjBiCmM_xHqqkZx_ SheetID = 0 _xZkqqHx_iCmMiDfGiBfLiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmJjHiOiClPiCoJiBeC_xHqqkZx_
	SetCurrentSheetId(SheetIndexToID(0));
} // FCSheetManager::InTopBottomSheetStream.

//----- 03.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::OutStreamTemplate
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHjHhAiCmMiDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fdar	:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	OutStream_xZkqqHx_iKnGjAjEiCmGjDkPiClGiMgAiOkOiCmFiDhEiDeAiDeDiDiLiCpAiPgPjHmNiBeCjFjEjFgJjAjE_xHqqkZx_=0_xZkqqHx_iCpAiPgPjHmNiBeC_xHqqkZx_
// *			_xZkqqHx_iOoFiCmJiDiMiDeDiDiEiBfLiNfMjBkCiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.11.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCSheetManager::OutStreamTemplate (FCUndoArchive& fdar) const
//{
//	//----- _xZkqqHx_iDfGiBfLiDgHiCpAiPgPjHmN_xHqqkZx_ -----
//	// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//	fdar << long(1);
//	fdar.Write(&(m_vFreqSheet[0]), sizeof(m_vFreqSheet[0]));
//	m_vSheet[m_vFreqSheet[0]]->OutStreamTemplate(fdar);
//
//	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
//	// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//	fdar << DWORD(0);
//	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
//	// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//	fdar << DWORD(0);
//} // FCSheetManager::OutStreamTemplate.
//----- 03.06.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfGiBfLiDgHiBgJiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLayerManager* FCSheetManager::GetSheet (SheetID stid) const
{
	return m_vSheet[stid];
} // FCSheetManager::GetSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetFrontSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDfGiBfLiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNmFiPiJiCmMiDfGiBfLiDgHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCLayerManager* FCSheetManager::GetFrontSheet () const
{
	if (GetSheetIndexSize() == 0) return NULL;
	return GetSheet(SheetIndexToID(0));
} // FCSheetManager::GetFrontSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::IsEmpty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjCiGiCmJjFjEjFgJiCkKiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjCiGiCmJjFjEjFgJiCkKiIoKiCmCiCoAjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSheetManager::IsEmpty () const
{
	return m_mpObjToLZHash.empty();
} // FCSheetManager::IsEmpty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::InsertSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_jBhNjDpMiImKjChFiCpAiOhHjCoIiBeCjBhNjDpMiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCkKiClBiCmMjCgMiBeC_xHqqkZx_
 *			tcpName		:_xZkqqHx_jBhNjDpMiClHiCoJiDfGiBfLiDgHiCmMjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiImKjChFiCmJjBhNjDpMiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//BOOL FCSheetManager::InsertSheet (SheetID stid, const wchar_t* tcpName)
//{
//	FCLayerManager* pLayerMgr = new FCLayerManager(tcpName, m_mpObjToLZHash, m_vBottomLayer, m_vTopLayer);
//	m_vSheet.insert(&m_vSheet[stid], pLayerMgr);
//	return (stid == m_stidCurrentSheet);
//} // FCSheetManager::InsertSheet.
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
void FCSheetManager::InsertSheet (SheetID& stidNew, const wchar_t* tcpName, SheetID stid, DWORD dwIdx)
{
	stidNew = stid;
	// _xZkqqHx_jAfGiLeLiNoMjAkMiClHiCoJiDiMiDfCiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
	if (stidNew == FD_SHEET_UNSPECIFY)
		stidNew = GetFreeSheetID();
	// _xZkqqHx_jAfGiLeLiNoMjAkMiClHiCoJiDiMiDfCiBfLiDgIiCpAjBhNjDpMiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	if (dwIdx == DWORD(-1))
		m_vFreqSheet.push_back(stidNew);
	else
		m_vFreqSheet.insert(m_vFreqSheet.begin() + dwIdx, stidNew);
	// _xZkqqHx_iDfGiBfLiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	if (m_vSheet.size() <= stidNew)
		m_vSheet.resize(stidNew + 1, NULL);
	m_vSheet[stidNew] = new FCLayerManager(TRUE, tcpName, m_mpObjToLZHash, m_vBottomLayer, m_vTopLayer);
} // FCSheetManager::InsertSheet.
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::DeleteSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
//----- 01.03.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCpAiNoNiPjMiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
//----- 01.03.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//BOOL FCSheetManager::DeleteSheet (SheetID stid)
//{
//	delete m_vSheet[stid];
//	m_vSheet.erase(&m_vSheet[stid]);
////----- 01.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	return (stid == m_stidCurrentSheet);
////----- 01.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	BOOL bCurrent = (stid == m_stidCurrentSheet);
//	if (GetSheetSize() <= m_stidCurrentSheet) m_stidCurrentSheet--;
//	return bCurrent;
////----- 01.03.18 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCSheetManager::DeleteSheet.
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
void FCSheetManager::DeleteSheet (SheetID stid)
{
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DWORD dwIdx = SheetIDToIndex(stid);
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
	m_vFreqSheet.erase(m_vFreqSheet.begin() + dwIdx);
	// _xZkqqHx_jDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
	delete m_vSheet[stid];
	m_vSheet[stid] = NULL;
} // FCSheetManager::DeleteSheet.
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::ModifySheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDfGiBfLiDgHiCmMiPoOjFpBiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_jFmPiNfIiClHiCoJiDfGiBfLiDgHiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpName		:_xZkqqHx_jFmPiNfIiMoDiCmMiDfGiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::ModifySheet (SheetID stid, const wchar_t* tcpName)
{
	GetSheet(stid)->SetName(tcpName);
} // FCSheetManager::ModifySheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::SetCurrentSheetId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::SetCurrentSheetId (SheetID stid)
{
	m_stidCurrentSheet = stid;
} // FCSheetManager::SetCurrentSheetId.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::ReOrderSheet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCmMiPiHjEnEiCpAjFmAiCnHjBnGiCkGiCoJiBeCiNmFiPoDiImKiDfGiBfLiDgHiBeBiNmFiJlKiImKiDfGiBfLiDgHiCmN_xHqqkZx_
 *			_xZkqqHx_jBmOiPnLiCmJiCmIiCoHiCmIiCkCiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_
 *			_xZkqqHx_jDpMiCoKjBnGiCkGiCmMjEmNiImNiCmNiBeB_xHqqkZx_[dwFirstIdx, dwLastIdx]
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFirstIdx		:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJiDfGiBfLiDgHiCmMiNmFiPiJiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwlastidx		:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJiDfGiBfLiDgHiCmMiNmFiMoDiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stidaNewOrder	:_xZkqqHx_jFmAiCnHjBnGiCkGiCoJjBePiCmMiDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiBeB_xHqqkZx_
 *							 _xZkqqHx_jAfGiClFiCkCiDfGiBfLiDgHiPiHiCmJjFmAiCnHiClNjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::ReOrderSheet (DWORD dwFirstIdx, DWORD dwLastIdx, const SheetID stidaNewOrder[])
{
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	LayerManagerPVector vSheetTable = m_vSheet;
//	DWORD dwSize = dwLastIdx + 1 - dwFirstIdx;
//	for (DWORD dwCount = 0; dwCount < dwSize; dwCount++)
//	{
//		m_vSheet[dwFirstIdx + dwCount] = vSheetTable[stidaNewOrder[dwCount]];
////----- 00.12.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////		if (m_stidCurrentSheet == stidaNewOrder[dwCount])
////			m_stidCurrentSheet = dwFirstIdx + dwCount;
////----- 00.12.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	}
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDiKiDfIiDgHiCkJiCoHjGjFiPmBiBeC_xHqqkZx_
	m_vFreqSheet.erase(m_vFreqSheet.begin() + dwFirstIdx,
						m_vFreqSheet.begin() + dwLastIdx + 1);
	// _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiDiKiDfIiDgHiCmJjAfGiClFiCkCiPiHiPjIiCpAjBhNjDpMiBeC_xHqqkZx_
	m_vFreqSheet.insert(m_vFreqSheet.begin() + dwFirstIdx,
						stidaNewOrder,
						stidaNewOrder + (dwLastIdx + 1 - dwFirstIdx));
//----- 01.03.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCSheetManager::ReOrderSheet.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetCurrentSheetId
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SheetID FCSheetManager::GetCurrentSheetId () const
{
	return m_stidCurrentSheet;
} // FCSheetManager::GetCurrentSheetId.

//----- 01.03.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetSheetSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjCiGiCmMiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjAjEiBgJiDfGiBfLiDgHjAjEiBgKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//DWORD FCSheetManager::GetSheetSize () const
//{
//	return m_vSheet.size();
//} // FCSheetManager::GetSheetSize.
//----- 01.03.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetSheetInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strName		:_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			stid	:_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCSheetManager::GetSheetInfo (WString& wstrName, SheetID stid) const
{
	wstrName = GetSheet(stid)->GetName();
} // FCSheetManager::GetSheetInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetFreqSheetVector
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMjFfMiOkGiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMjFfMiOkGiDiKiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FDSheetIDVector& FCSheetManager::GetFreqSheetVector () const
{
	return m_vFreqSheet;
} // FCSheetManager::GetFreqSheetVector.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetFreeSheetID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SheetID_xZkqqHx_iCmMiLpDiCkCiCmEiCkCiCoJ_xHqqkZx_ID_xZkqqHx_iCpAjCfEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iLpDiCkCiCmEiCkCiCoJ_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SheetID FCSheetManager::GetFreeSheetID () const
{
	SheetID stid;
	for	(stid = 0; stid < GetSheetIDSize(); stid++)
		if (GetSheet(stid) == NULL) break;
	return stid;
} // FCSheetManager::GetFreeSheetID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::SheetIDToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAiDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid	:_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCSheetManager::SheetIDToIndex (SheetID stid) const
{
	FDSheetIDVector::const_iterator iId;
	iId	= find(m_vFreqSheet.begin(), m_vFreqSheet.end(), stid);
	if (iId == m_vFreqSheet.end()) return DWORD(-1);
	return DWORD(iId - m_vFreqSheet.begin());
} // FCSheetManager::SheetIDToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::SheetIndexToID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIndex	:_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SheetID FCSheetManager::SheetIndexToID (DWORD dwIndex) const
{
	return m_vFreqSheet.at(dwIndex);
} // FCSheetManager::SheetIndexToID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetSheetIDSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMiDfEiDeDiDfJiBgJjBkGiClPiDfGiBfLiDgHiDiMiDfCiBfLiDgIiDiKiDfIiDgHiCmMiDfEiDeDiDfJiBgKiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SheetID FCSheetManager::GetSheetIDSize () const
{
	return m_vSheet.size();
} // FCSheetManager::GetSheetIDSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetSheetIndexSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCSheetManager::GetSheetIndexSize () const
{
	return m_vFreqSheet.size();
} // FCSheetManager::GetSheetIndexSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::ObjDynabaseToSIdLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkJiCoHiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmG_xHqqkZx_LZOrder_xZkqqHx_iCpAiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stid		:_xZkqqHx_jFjEjFgJiCkKjBkOiClHiCoJiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 FD_SHEET_UNSPECIFY_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			lzorder		:_xZkqqHx_jFjEjFgJiCkKjBkOiClHiCoJiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_
 *						 LAST_LAYER_ORDER_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_iMjPiNpFiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			stidStart	:_xZkqqHx_iMjPiNpFiCpAiKeKiOgOiClHiCoJiDfGiBfLiDgHiCpAiOhHjCoIiBeCjFjEjFgJiCkKiNmFiPoDiImKiDiMiDeDiDiEiBfLiBeB_xHqqkZx_
 *						 _xZkqqHx_iIlNiCkCiCmNiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmJjBkOiClHiCoJiPoKiNiHiBeBjBfDiCmEiCmMiDfGiBfLiDgHiCmJ_xHqqkZx_
 *						 _xZkqqHx_iLkEjCmKiCmJiMkJiCmCiCkJiCmBiCmEiClFiCnMiCkEiCmMiCmFiBeBiMjPiNpFiKeKiOgOiDfGiBfLiDgHiCmMiOhHjCoIiCkK_xHqqkZx_
 *						 _xZkqqHx_jFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmM_xHqqkZx_stid, lzorder_xZkqqHx_iCmMjCgMiCmNjFnLiPnIiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSheetManager::ObjDynabaseToSIdLZOrder (SheetID& stid, FCLayerZOrder& lzorder,
										const FCObjDynabase* pObj, SheetID stidStart) const
{
	// _xZkqqHx_iCnMiClIiBeBiMjPiNpFjHeEjAoGiDfGiBfLiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
	stid = stidStart;
	lzorder = GetSheet(stid)->ObjDynabaseToLZOrder(pObj);
	if (lzorder != LAST_LAYER_ORDER) return TRUE;
	//---- _xZkqqHx_jHeEjAoGiDfGiBfLiDgHiImIiKePiCpAiDiLiBfLiDhGiClFiCmEiMjPiNpF_xHqqkZx_ -----
	for (DWORD dwSheetIdx = 0; dwSheetIdx < GetSheetIndexSize(); dwSheetIdx++)
	{
		stid = SheetIndexToID(dwSheetIdx);
		// _xZkqqHx_jHeEjAoGiDfGiBfLiDgHiCmIiCoHiBeBiMjPiNpFiNmPiCnNiCmIiCmMiCmFiOjPiCmMiDiLiBfLiDhGiCnGiBeC_xHqqkZx_
		if (stid == stidStart) continue;
		lzorder = GetSheet(stid)->ObjDynabaseToLZOrder(pObj);
		if (lzorder != LAST_LAYER_ORDER) return TRUE;
	}
	return FALSE;
} // FCSheetManager::ObjDynabaseToSIdLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::CallForAllObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMjFjEjFgJiCmJjBmOiClFiCmEiBeBiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	func	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			data	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCkK_xHqqkZx_FALSE_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCkK_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClFiClNiPoKiNiHiCmNiBeBiClLiClBiCmFiPiIjHjNiCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCSheetManager::CallForAllObject (FuncForAllObject func, void* data) const
{
	// _xZkqqHx_iNmFiPiJiCmNiKgFiDfGiBfLiDgHiCmMjBfDiDiMiDeDiDiEiBfLiCmMiChJiDeJiBfLiDfPiBfLiCpAiOoGjDlOiClFiCmEiCkCiClNiCkKiBeB_xHqqkZx_
	// _xZkqqHx_iClBiCmMjFpLjGeAiClOiCmGiNmFiPoDiImKiBeFiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCkKiJlNjDhIiCoAiMmEiCnBiPgPiClDiCoKiCoJiBeC_xHqqkZx_
	LayerManagerPVector::const_iterator iZb;
	for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++)
	{
		if (*iZb != NULL)
		{
			if (!(*iZb)->CallForAllObject(func, data)) return FALSE;
		}
	}
	ObjDynabaseVector::const_iterator iObj;
	for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
	{
		if (!(*func)(*iObj, data)) return FALSE;
	}
	for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
	{
		if (!(*func)(*iObj, data)) return FALSE;
	}
	return TRUE;
} // FCSheetManager::CallForAllObject.

///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::GetSheetSize
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjCiGiCmMiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDjAjEiBgJiDfGiBfLiDgHjAjEiBgKiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//DWORD FCSheetManager::GetSheetSize () const
//{
//	return m_vSheet.size();
//} // FCSheetManager::GetSheetSize.

//----------<NOT EXPORT TO VIEWER>-----------

//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////////////////////////////////////////////////////////////////////////////////
//// _xZkqqHx_iImIiJlKiCmMiKnGjAjEiCmMiDhNiDeOiDiNjDfHiKeKiCmMiCfAjHoBiBeC_xHqqkZx_
//// 
//// /*************************************************************************
////  * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::IsUsedSColor
////  *
////  * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDiDfGiBfLiDgHiJlKiCmMjBfDiCmEiCmMjFjEjFgJiCmJjBmOiClFiCmEiBeBiOhHjCoIiCmM_xHqqkZx_SColor_xZkqqHx_iCkKiOgHiCoNiCoKiCmEiCkCiCoJiCkJ_xHqqkZx_
////  *			_xZkqqHx_iCmHiCkEiCkJiCpAjGoCiCkCiNiHiCoNiClJiCoJiBeC_xHqqkZx_
////  *
////  * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	val	:SColorID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
////  *
////  * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKiCmCiCmFiCoAiOgHiCoNiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
////  *
////  * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
////  *************************************************************************/
//// BOOL FCSheetManager::IsUsedSColor (SColorID val) const
//// {
////     //----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiMjPiNlI_xHqqkZx_ -----
////     LayerManagerPVector::const_iterator iZb;
////     for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++)
////     {
////         if (!(*iZb)->IsUsedSColor(val)) return TRUE;
////     }
////     //----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiMjPiNlI_xHqqkZx_ -----
////     ObjDynabaseVector::const_iterator iObj;
////     for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
////     {
////         if (!(*iObj)->IsUsedSColor(val)) return TRUE;
////     }
////     //----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiMjPiNlI_xHqqkZx_ -----
////     for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
////     {
////         if (!(*iObj)->IsUsedSColor(val)) return TRUE;
////     }
////     return FALSE;
//// }
//// 
////////////////////////////////////////////////////////////////////////////////
//
//#define MYISUSED(x) \
//BOOL FCSheetManager::IsUsed##x (x##ID val) const \
//{ \
//	LayerManagerPVector::const_iterator iZb; \
//	for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++) \
//	{ \
//		if (*iZb != NULL && (*iZb)->IsUsed##x(val)) return TRUE; \
//	} \
//	ObjDynabaseVector::const_iterator iObj; \
//	for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++) \
//	{ \
//		if ((*iObj)->IsUsed##x(val)) return TRUE; \
//	} \
//	for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++) \
//	{ \
//		if ((*iObj)->IsUsed##x(val)) return TRUE; \
//	} \
//	return FALSE; \
//} \
//
//MYISUSED(SColor)
//MYISUSED(EmfImage)
//MYISUSED(BrushRegister)
//MYISUSED(PenRegister)
//MYISUSED(PenStyle)
//MYISUSED(SFont)
//MYISUSED(PictArrow)
//
//#undef MYISUSED
//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----------</NOT EXPORT TO VIEWER>-----------

//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCSheetManager::PictArrowFrameModified
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiCmMiDhEiDiMiBfLiDiAiCkKjFmPiNfIiClDiCoKiClNiClBiCmGiCpAjCmKjCgNiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	paid	:_xZkqqHx_jFmPiNfIiClDiCoKiClNjGoOiIpDiCmMiCgIiCgDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCSheetManager::PictArrowFrameModified (PictArrowID paid)
//{
//} // FCSheetManager::PictArrowFrameModified.
//----- 05.04.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
