// StcWideLine.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilBezier.h"		// For FFCalcWideWidthArray.
#include "StcWideLine.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCStcWideLine

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcWideLine::CFCStcWideLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcWideLine::CFCStcWideLine ()
{
	m_mmWidthL = 0;
	m_mmWidthR = 0;
	m_nWidthSlopeF = 0;
	m_nWidthSlopeB = 0;
} // CFCStcWideLine::CFCStcWideLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcWideLine::~CFCStcWideLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCStcWideLine::~CFCStcWideLine ()
{
} // CFCStcWideLine::~CFCStcWideLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcWideLine::SetWidthL
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcWideLine::SetWidthL (mmetol mmWidthL)
{
	m_mmWidthL = mmWidthL;
} // CFCStcWideLine::SetWidthL.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcWideLine::SetWidthR
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjNiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcWideLine::SetWidthR (mmetol mmWidthR)
{
	m_mmWidthR = mmWidthR;
} // CFCStcWideLine::SetWidthR.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcWideLine::SetSlope
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMfIiOmOjHkGiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcWideLine::SetSlope (short nWidthSlopeF, short nWidthSlopeB)
{
	m_nWidthSlopeF = nWidthSlopeF;
	m_nWidthSlopeB = nWidthSlopeB;
} // CFCStcWideLine::SetSlope.

BEGIN_MESSAGE_MAP(CFCStcWideLine, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCStcWideLine)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCStcWideLine _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCStcWideLine::OnPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFgAiJoGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCStcWideLine::OnPaint ()
{
	CPaintDC dc(this);	// _xZkqqHx_jFgAiJoGjHhAiCmMiDgGiDgPiDeDiDfI_xHqqkZx_ _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
	CRect lgrtClient;
	GetClientRect(&lgrtClient);
	long lVH = lgrtClient.Height();
//----- 01.04.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	mmetol mmWidth = (m_mmWidthL + m_mmWidthR) / 2.0;
//	if (almost0(mmWidth))
//	{
//		return;
//	}
//	double dRatio = (real(lVH) / 2.0) / mmWidth;
//	double dWidthL = dRatio * m_mmWidthL;
//	if (lVH < dWidthL) dWidthL = lVH;
//	double dWidthR = dRatio * m_mmWidthR;
//	if (lVH < dWidthR) dWidthR = lVH;
//----- 01.04.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	double dWidthL = g_->dDisplayPPM * m_mmWidthL;
	if (lVH < dWidthL) dWidthL = lVH;
	double dWidthR = g_->dDisplayPPM * m_mmWidthR;
	if (lVH < dWidthR) dWidthR = lVH;
//----- 01.04.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	mmetolVector vmmW;
	DBLPointVector vmmptPoly;
	vmmptPoly.push_back(DBLPoint(10, lVH / 2));
	vmmptPoly.push_back(DBLPoint(lgrtClient.Width() - 10, lVH / 2));
	FFCalcWideWidthArray(vmmW, vmmptPoly, BYTEVector(vmmptPoly.size(), FALSE), 2.0, dWidthL / 2.0, dWidthR / 2.0,
						m_nWidthSlopeF, m_nWidthSlopeB);

	// _xZkqqHx_jEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_GetBkColor_xZkqqHx_iCmNjBmKjGnKiBeC_xHqqkZx_
	CBrush brush(::GetSysColor(COLOR_3DFACE));
	// _xZkqqHx_jEhHiMgJiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
	dc.FillRect(lgrtClient, &brush);

	CBrush* pBrushOld = dc.SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
	CPen* pPenOld = dc.SelectObject(CPen::FromHandle((HPEN)GetStockObject(BLACK_PEN)));
	long lC;
	CPointVector vPoly;
	vPoly.push_back(CPoint(vmmptPoly[0].x, vmmptPoly[0].y - vmmW[0]));
	for (lC = 1; lC < vmmptPoly.size(); lC++)
		vPoly.push_back(CPoint(vmmptPoly[lC].x, vmmptPoly[lC].y - vmmW[lC]));
	for (lC = vmmptPoly.size() - 1; 0 <= lC; lC--)
		vPoly.push_back(CPoint(vmmptPoly[lC].x, vmmptPoly[lC].y + vmmW[lC]));
	vPoly.push_back(CPoint(vmmptPoly[0].x, vmmptPoly[0].y - vmmW[0]));
	dc.Polygon(vPoly.begin(), vPoly.size());
	dc.SelectObject(pBrushOld);
	dc.SelectObject(pPenOld);
} // CFCStcWideLine::OnPaint.
