#ifndef __TextOut_h
#define __TextOut_h

class FCAutoDC;

//;----- <EXPORT TO SDK> -----;

//----- FCTextLineInfo::m_dwMask -----
#define FDTL_FLAG_STARTINDENT	(0x00000001 << 0)
#define FDTL_FLAG_RIGHTINDENT	(0x00000001 << 1)
#define FDTL_FLAG_OFFSET		(0x00000001 << 2)
#define FDTL_FLAG_TABSTOPS		(0x00000001 << 3)
#define FDTL_FLAG_ALIGNMENT		(0x00000001 << 4)
#define FDTL_FLAG_LINEAFTER		(0x00000001 << 5)
#define FDTL_FLAG_UNUSED		(0x00000001 << 31)

#define FDTL_FLAG_ALL			(FDTL_FLAG_STARTINDENT|FDTL_FLAG_RIGHTINDENT|FDTL_FLAG_OFFSET| \
								 FDTL_FLAG_TABSTOPS|FDTL_FLAG_ALIGNMENT|FDTL_FLAG_LINEAFTER)

//----- FCTextLineInfo::m_byAlignment_xZkqqHx_iBeB_xHqqkZx_
//		FCEditLine::m_byAlignment_xZkqqHx_iBeB_xHqqkZx_FCStatLine::m_byAlignment_xZkqqHx_iLkEjCmK_xHqqkZx_ -----
#define FDRC_AL_NONE		0x00	// _xZkqqHx_jGlDiMpIiBeC_xHqqkZx_
#define FDRC_AL_LEFT		0x01	// _xZkqqHx_iNlGjEhKjChFiBeC_xHqqkZx_
#define FDRC_AL_CENTER		0x02	// _xZkqqHx_jCiGiJjLjEhKjChFiBeC_xHqqkZx_
#define FDRC_AL_RIGHT		0x03	// _xZkqqHx_iJeFjEhKjChFiBeC_xHqqkZx_
#define FDRC_AL_LEFTRIGHT	0x04	// _xZkqqHx_jHlMjCfLjBlFiCkGiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCTextLineInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNhDiPoOjFpBiCpAiLeMjIfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCTextLineInfo
{
	DWORD		dwMask;				// _xZkqqHx_jHeMiMpIiDiBiDjDiDgPjFmPjAjEiCmMiDhNiDfIiDeOiBeC_xHqqkZx_
	mmetol		mmStartIndent;		// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	mmetol		mmRightIndent;		// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgHiBeC_xHqqkZx_
	mmetol		mmOffset;			// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgHiBgJjAoGjDkKiNhDiCmJjBmOiClHiCoJiDeJiDhEiDfKiDgCiDgHjCgMiBgK_xHqqkZx_
	mmetolVector mmvTabs;			// _xZkqqHx_iDfOiDhFjEhKjHpBiBeC_xHqqkZx_
	BYTE		byAlignment;		// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgHiBgJiNlGjCiGiJjLiJeFiKpBiClJiBgK_xHqqkZx_
	BYTE		byDummy;
	short		nTwipLineAfter;		// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmM_xHqqkZx_TWIPS_xZkqqHx_jAjEiBeC_xHqqkZx_

//;----- </EXPORT TO SDK> -----;

	// _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_
	void		OutStream (BYTEVector& vStream) const;
	void		InStream (const BYTE*& pData);
//;----- <EXPORT TO SDK> -----;
}; // struct FCTextLineInfo.
//;----- </EXPORT TO SDK> -----;

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCUTLeftRight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCTextOut_xZkqqHx_iCmMiDiBiDjDiDgPjFmPjAjEjHhAiBeCiDhEiDeIiDjDiDgHiCmMiNlGiJeFiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCUTLeftRight
{
	FCUTLeftRight (mmetol l, mmetol r);
	mmetol mmLeft;
	mmetol mmRight;
}; // struct FCUTLeftRight.

typedef vector<FCUTLeftRight>	LeftRightVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCTextOut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCmMiIpDiNpMiCpAiBeBiCnMiCmGiCnPiCmEiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCTextOut
{
public:
	FCTextOut (double dAngle, const DBLPoint& mmptCenter);
	void	ClearText ();
	void	StockChar (wchar_t wChar, mmetol mmX, mmetol mmLeft, mmetol mmRight,
						mmetol mmY, mmetol mmHeight,
						BYTE byUnderline, BYTE byStrikeOut,
						SFontID foid, WORD wOffset);

	void	FlushText (FCAutoDC& atDC, mmetol mmX, WORD wCodePage);
	static void	DrawLineHorz (FCAutoDC& atDC, long lLineL, long lLineR,
								long lLineW, long lLineY);

protected:
	void	FlushText1By1 (FCAutoDC& atDC, WORD wCodePage);
	void	TextOut (FCAutoDC& atDC, long lgX, long lgY,
						const WString& str, WORD wCodePage, LPINT lpDxWidths);
	void	DrawLine (FCAutoDC& atDC, mmetol mmWidth, mmetol mmOffset);
	void	DrawLines (FCAutoDC& atDC);

protected:
	double			m_dAngle;		// _xZkqqHx_iJpBjDfNjFmPiKlHiCmMiKhAjDhIiBeC_xHqqkZx_
	double			m_dSin;			// _xZkqqHx_iJpBjDfNjFmPiKlHiCmMiDfEiDeDiDjDiBeC_xHqqkZx_
	double			m_dCos;			// _xZkqqHx_iJpBjDfNjFmPiKlHiCmMiDfCiDfEiDeDiDjDiBeC_xHqqkZx_
	DBLPoint		m_mmptCenter;	// _xZkqqHx_iJpBjDfNjFmPiKlHiCmMjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
	LeftRightVector	m_vTextLR;		// _xZkqqHx_jFlGiOjKiCmMiNlGiNmAjFfHiCmGiJeFiNmAjFfHiBeC_xHqqkZx_
	doubleVector	m_vTextX;		// _xZkqqHx_iKgFjFlGiOjKiCmMiChHiNmAjFfHiBeC_xHqqkZx_
	WCharVector		m_vChar;		// _xZkqqHx_iIpDiNpMiClHiCoJiDgFiDeMiDfIiDgHiBeC_xHqqkZx_

	mmetol			m_mmY;			// _xZkqqHx_iDgFiDeMiDfIiDgHjFgAiJoGiCmMiPoDiNmAjFfHiBeC_xHqqkZx_
	mmetol			m_mmHeight;		// _xZkqqHx_iDgFiDeMiDfIiDgHiNiCiBeC_xHqqkZx_
	BYTE			m_byUnderline;	// _xZkqqHx_iJlKjApMiCmMiOoNjHnOiBeC_xHqqkZx_
	BYTE			m_byStrikeOut;	// _xZkqqHx_iOoGiPmBiClFjApMiCmMiOoNjHnOiBeC_xHqqkZx_
	SFontID			m_foid;			// _xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WORD			m_wOffset;		// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHiOhHjCoIiBeC_xHqqkZx_

}; // class FCTextOut.

//----------<NOT EXPORT TO VIEWER>-----------
extern void FFCopy (FCTextLineInfo& tli, const PARAFORMAT& pf);
extern void FFCopy (PARAFORMAT& pf, const FCTextLineInfo& tli);
extern BOOL operator == (const FCTextLineInfo& tli1, const FCTextLineInfo& tli2);
extern BOOL operator != (const FCTextLineInfo& tli1, const FCTextLineInfo& tli2);

//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
extern void FFOverwrite (FCTextLineInfo& tli1, const FCTextLineInfo& tli2, DWORD dwMask);
extern void operator |= (FCTextLineInfo& tli1, const FCTextLineInfo& tli2);
extern void operator &= (FCTextLineInfo& tli1, const FCTextLineInfo& tli2);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----------</NOT EXPORT TO VIEWER>-----------

#endif//__TextOut_h
