#include "stdafx.h"
#include "DynamicDraw.h"		// For PrtBaseCreate.h.
#include "NewFDObjAny.h"		// For NewFDObjAny.
#include "UtilStr.h"			// For GetResString.
#include "UtilGraph.h"			// For FCEditDraw.
// 06.11.26 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "UtilMath.h"			// For mmroundoff.
#include "CommonDrawFrame.h"	// For GetCurChip.
#include "DynamicDrawView.h"	// For g_pView.
#include "FoundDoc.h"			// For g_pDoc.
#include "UndoArchive.h"		// For FCUndoArchive.
#include "ObjDynabase.h"			// For FCObjDynabase.
#include "ObjChipMaster.h"		// For FCObjChipMaster.
#include "PrtBaseCreate.h"		// For CFCPrtBaseCreate.
#include "ToolBaseCreate.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::FCToolBaseCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCToolBaseCreate::FCToolBaseCreate ()
{
	m_pInsideObject = NULL;	// _xZkqqHx_jDoAjFjEjFjEjFgJiBeC_xHqqkZx_
} // FCToolBaseCreate::FCToolBaseCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::OnViewCreate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCDynamicDrawView::OnCreate_xZkqqHx_iCkJiCoH_xHqqkZx_Call.Tool_xZkqqHx_iCmMiPiJiKpKiJlL_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::OnViewCreate ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnViewCreate();
	// _xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCpAiNoMjAkMiBeC_xHqqkZx_
	m_pInsideObject = CreateInsideObject();
} // FCToolBaseCreate::OnViewCreate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::OnViewDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CFCDynamicDrawView::OnDestroy_xZkqqHx_iCkJiCoH_xHqqkZx_Call.Tool_xZkqqHx_iCmMiPeJjHlJiPiIjHjN_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::OnViewDestroy ()
{
	if (m_pInsideObject != NULL)
	{
		delete m_pInsideObject;
		m_pInsideObject = NULL;
	}
	// Baseclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnViewDestroy();
} // FCToolBaseCreate::OnViewDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::GetInsideObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAlGjAkMiCmJiOgHjHhAiClDiCoKiCoJjDoAjFjEiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDoAjFjEiDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDhMiDeDiDjDiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjFjEjFgJiCpAiOgHiCmBiCmEiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmMjFgAiJoGiCoCjFjEjFgJiCmMjAlGjAkMiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCToolBaseCreate::GetInsideObject () const
{
	return m_pInsideObject;
} // FCToolBaseCreate::GetInsideObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::CreateInsideObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjFjEjFjEjFgJiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDoAjFjEjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCObjDynabase* FCToolBaseCreate::CreateInsideObject ()
{
	return NULL;
} // FCToolBaseCreate::CreateInsideObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_FCUndoArchive_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsOutObjectInfo:_xZkqqHx_jFjEjFgJiPoOjFpBiCpAiPgPjHmNiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *							 _xZkqqHx_iNmFiMoDiCmJiNoMiCoHiCoKiClNjFjEjFgJiCmMiDiKiDfIiDgHiCmIiCmHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::OutStream (FCUndoArchive& ar, BOOL bIsOutObjectInfo)
{
	// Baseclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OutStream(ar, bIsOutObjectInfo);
//----- 05.07.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_pInsideObject != NULL)
	//----- _xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jFjEjFgJiDfOiDeDiDhGiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << BYTE(m_pInsideObject->Type());
// 06.06.23 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		m_pInsideObject->OutStream(ar);
		m_pInsideObject->OutStream(ar, FALSE);
	} else
	//----- _xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		ar << BYTE(-1);
	}
//----- 05.07.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMjPiNpFiCmMiPiHiPjIiBeC_xHqqkZx_
	ar << short(m_vReferenceOrder.size());
	shortVector::const_iterator iT;
	for (iT = m_vReferenceOrder.begin(); iT != m_vReferenceOrder.end(); iT++)
		ar << *iT;
	//----- _xZkqqHx_iNmFiMoDiCmJiNoMiCoHiCoKiClNjFjEjFgJiCmMiLeMjIfO_xHqqkZx_ -----
	if (bIsOutObjectInfo)
	//----- _xZkqqHx_jFjEjFgJiCpAiPgPjHmNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ar << long(m_vLastObj.size());
		FCObjMemRecVector::const_iterator iRec;
		for (iRec = m_vLastObj.begin(); iRec != m_vLastObj.end(); iRec++)
			ar.Write(iRec, sizeof(*iRec));
	} else
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	//----- _xZkqqHx_jFjEjFgJiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiCmIiCmHiBeBjFjEjFgJiCpAiPgPjHmNiClFiCmIiCkCiPoKiNiHiCmNiBeBiNmFiMoDiCmJiNoMiCoHiCoKiClN_xHqqkZx_
		// _xZkqqHx_jFjEjFgJiCoAiPgPjHmNiClFiCmIiCkCiBeC_xHqqkZx_
		ar << long(0);
	}
//----- 06.04.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBaseCreate::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCkJiCoHiDgDiBfLiDiLiCmMjBkOjAkLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_FCUndoArchive_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::InStream (FCUndoArchive& ar)
{
	// Baseclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::InStream(ar);
//----- 05.07.15 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_pInsideObject != NULL)
	//----- _xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jDoAjFjEjFjEjFgJiCpAiNoNiPjMiBeCjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiCkKiBeBjDgPjIfOiDgFiBfLiDhFiDiLiCmN_xHqqkZx_
		// _xZkqqHx_jFmKjDhCiDiKiDfKiDgCiDgHiClDiCoKiCoJiCmMiCmFiBeBiClBiClBiCmF_xHqqkZx_Unregister_xZkqqHx_iClHiCoJjFeLjHhGiCmNiCmIiCkCiBeC_xHqqkZx_
		delete m_pInsideObject;
		m_pInsideObject = NULL;
	}
	// _xZkqqHx_jFjEjFgJiDfOiDeDiDhGiCpAjDpMjHmNiBeC_xHqqkZx_
	BYTE byType;
	ar >> byType;
	if (byType != BYTE(-1))
	{
		m_pInsideObject = NewFDObjAny(FTObjectType(byType));
		m_pInsideObject->InStream(ar);
	}
//----- 05.07.15 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMjPiNpFiCmMiPiHiPjIiBeC_xHqqkZx_
	short nSz;
	ar >> nSz;
	m_vReferenceOrder.assign(nSz);
	for (short nC = 0; nC < nSz; nC++)
		ar >> m_vReferenceOrder[nC];
	//----- _xZkqqHx_iNmFiMoDiCmJiNoMiCoHiCoKiClNjFjEjFgJiCmMiLeMjIfO_xHqqkZx_ -----
	long lSz;
	ar >> lSz;
	m_vLastObj.assign(lSz);
	for (long lC = 0; lC < lSz; lC++)
		ar.Read(&m_vLastObj[lC], sizeof(m_vLastObj[lC]));
} // FCToolBaseCreate::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::InitContents
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmM_xHqqkZx_InitContents_xZkqqHx_iOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCToolBaseCreate_xZkqqHx_iCmM_xHqqkZx_GetLastCreateObj()_xZkqqHx_jHhAiCmJiNoMjAkMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::InitContents ()
{
	// _xZkqqHx_iNoMjAkMiMlDiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiMjPiNpFiPiHiBeC_xHqqkZx_
	m_vReferenceOrder.clear();
	m_vReferenceOrder.push_back(FDBC_REFO_SELECT_OBJ);	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
	m_vReferenceOrder.push_back(FDBC_REFO_CHIP_OBJ);	// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
	m_vReferenceOrder.push_back(FDBC_REFO_LAST_OBJ);	// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
	m_vReferenceOrder.push_back(FDBC_REFO_INSIDE_OBJ);	// _xZkqqHx_jDoAjFjEjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iNmFiMoDiCmJiNoMiCoHiCoKiClNjFjEjFgJiCmMiLeMjIfOiBeC_xHqqkZx_
	m_vLastObj.clear();
} // FCToolBaseCreate::InitContents.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::CanToolselfProperty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiOkJjAgHiCmMiDhGiDiNiDhAiDgFiDeCiDfPiDeDiDeBiDiNiDePiCkKjFfMiOkGiCmFiCkLiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiCmFiCkLiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBaseCreate::CanToolselfProperty () const
{
// 06.02.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return TRUE;
	return FFCanEditDocumentEnv();
} // FCToolBaseCreate::CanToolselfProperty.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
	// _xZkqqHx_iMlLiNnNiCmMiDeKiBfLiDfMiDiLiPoOjFpBiBeCiClBiCoKiCmFiDhNiDeFiDfIiInKjDkOiOjOiCmJiDhNiBfLiDeOjFfMiOkGiClDiCoKiCoJiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NOT_MOLIP;
} // FCToolBaseCreate::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::CanSelectTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBaseCreate::CanSelectTool () const
{
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
//	if (!FFCanCreateObject()) return FALSE;
//	return TRUE;
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
	// _xZkqqHx_jFjEjFgJiCkKjFnCiPfHiJmCjEfMiCmFiCmNjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeC_xHqqkZx_
	// _xZkqqHx_iDgFiDeMiDfIiDgHjFnCiPfHjCiGiCmJiCoAjBeJjBpAiCmFiCkLiCoJiCoGiCkEiCmJiBeB_xHqqkZx_FFCanCreateObject _xZkqqHx_iCpAiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
	if (!FFCanEditObject()) return FALSE;
	return TRUE;
//----- 02.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFnCiPfHiMkAiCpAjBfDjFjEjGjFiPmB_xHqqkZx_->Undo->_xZkqqHx_jBlNiKhAjApMiDgDiBfLiDiLiCpAjBeJjBpA_xHqqkZx_->Redo->_xZkqqHx_jBlNiKhAjApMiCpAiNoMjAkMiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
} // FCToolBaseCreate::CanSelectTool.

//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::CanLockStatus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKiDiNiDgCiDeOiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiNiDgCiDeOiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDgKiDiFiBfLiCoCiDgDiBfLiDiLiDgPiBfLiCmMiDiNiDgCiDeOiDfCiDhNiDjDiDgIiCmMjFfMiOkGiPoDiCmMjGoCjBoIiBeC_xHqqkZx_
 *			_xZkqqHx_jDoAjFjEjDeJiCmJiCmN_xHqqkZx_SetLockStatus_xZkqqHx_iCmFjAnNjCoIiJmCjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBaseCreate::CanLockStatus () const
{
	return TRUE;
} // FCToolBaseCreate::CanLockStatus.
//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 00.03.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::SetWhichReferObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiNoMjAkMiMlDiCmJiClHiCoJiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAiCmHiClBiCkJiCoHiCmGiCoJiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iTmpl	:_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBaseCreate::SetWhichReferObj (FTWhichTmpl iTmpl)
//{
//	// _xZkqqHx_iNoMjAkMiCmMiMlDiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiOoNjHnOiBeC_xHqqkZx_
//	m_iWhichTmpl = iTmpl;
//} // FCToolBaseCreate::SetWhichReferObj.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::GetWhichReferObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiNoMjAkMiMlDiCmJiClHiCoJiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAiCmHiClBiCkJiCoHiCmGiCoJiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMlDiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCToolBaseCreate::FTWhichTmpl FCToolBaseCreate::GetWhichReferObj () const
//{
//	// _xZkqqHx_iNoMjAkMiCmMiMlDiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiOoNjHnOiBeC_xHqqkZx_
//	return m_iWhichTmpl;
//} // FCToolBaseCreate::GetWhichReferObj.
//----- 00.03.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::GetReferenceOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMjPiNpFiPiHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMjPiNpFiPiHiCmMjEhKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const shortVector& FCToolBaseCreate::GetReferenceOrder () const
{
	return m_vReferenceOrder;
} // FCToolBaseCreate::GetReferenceOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::SetReferenceOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMjPiNpFiPiHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vOrder	:_xZkqqHx_iMjPiNpFiPiHiCmMjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::SetReferenceOrder (const shortVector& vOrder)
{
	m_vReferenceOrder = vOrder;
} // FCToolBaseCreate::SetReferenceOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::GetReferenceString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iTmpl	:_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiOoNiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlMjBePiCmMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FCToolBaseCreate::GetReferenceString (FTWhichTmpl iTmpl)
{
	switch (iTmpl)
	{
	case FDBC_REFO_INSIDE_OBJ:
		return GetResWString(IDS_REFER_INSIDE_OBJ);	// "_xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_"
	case FDBC_REFO_LAST_OBJ:
		return GetResWString(IDS_REFER_LAST_OBJ);	// "_xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_"
	case FDBC_REFO_CHIP_OBJ:
		return GetResWString(IDS_REFER_CHIP_OBJ);	// "_xZkqqHx_jBeJjBpAjCiGiCmMiDgAiDgCiDhGjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_"
	case FDBC_REFO_SELECT_OBJ:
		return GetResWString(IDS_REFER_SELECT_OBJ);	// "_xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_"
	}
	return NULL;
} // FCToolBaseCreate::GetReferenceString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::CreatePropertyPage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiDhJiBfLiDfHiCpAiNoMjAkMiClFiBeBjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vPropPage	:_xZkqqHx_iDhJiBfLiDfHiCpAjDgPjIfOiClHiCoJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::CreatePropertyPage (CPropertyPageVector& vPropPage)
{
	vPropPage.push_back(new CFCPrtBaseCreate);
} // FCToolBaseCreate::CreatePropertyPage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::GetReferenceObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiNoMjAkMjHhAiCmMiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	ToolChip_xZkqqHx_iCmNiBeBiDgAiDgCiDhGiCmMjBeJjBpAiPpDjBnEiCmJiCoGiCmBiCmEiInJiCmIiCoJiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJ_xHqqkZx_
 *			_xZkqqHx_iCpAiOjNiCmCiBeC_xHqqkZx_ToolChip_xZkqqHx_iOkJjAgHiCmNjDoAjFjEiCmJiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAiOjNiClNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmMiDfIiDgHiDiKiBfLiDiAjDpMiPgPjHmNiPiIjHjNiCmJjBmOiJjOiClFiCmIiCkCiCkK_xHqqkZx_
 *			ToolCreate_xZkqqHx_iCmMiClNiCnPiCmJiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCpAjCpBiLjPiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMjGlFiPiCiCpAiJpAiPmBiClHiCoJiClNiCnPiCmJiClBiCmMiKnGjAjEiCpAiNoMiCmBiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.01.18 Fukushiro M. ToolCreate_xZkqqHx_iCoGiCoIiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
const FCObjDynabase* FCToolBaseCreate::GetReferenceObject ()
{
	shortVector::const_iterator iT;
	for (iT = m_vReferenceOrder.begin(); iT != m_vReferenceOrder.end(); iT++)
	{
		const FCObjDynabase* pObjTmpl = NULL;
		switch (*iT)
		{
		case FDBC_REFO_SELECT_OBJ:	// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
		  {
			ObjDynabaseVector::const_iterator iObj;
			for (iObj = g_pView->SelectObjVector().begin();
				 iObj != g_pView->SelectObjVector().end(); iObj++)
			{
				if (IsValidReference(*iObj))
				//----- _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmGiClFiCmEjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
				{
					pObjTmpl = *iObj;
					break;
				}
			}
			break;
		  }
		case FDBC_REFO_CHIP_OBJ:	// _xZkqqHx_iDgAiDgCiDhGjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
//----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (FFCommonDrawFrame() != NULL && FFCommonDrawFrame()->GetCurChipId() != FD_CHIP_UNSPECIFY)
//				pObjTmpl = g_pEnv->GetChipRec(FFCommonDrawFrame()->GetCurChipId())->m_objpChipMaster;
//----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if (FFCommonDrawFrame() != NULL && FFCommonDrawFrame()->GetCurChipId() != FD_CHIP_UNSPECIFY)
			{
				FCObjChipMaster* pChip = (FCObjChipMaster*)g_pEnv->GetChipRec(FFCommonDrawFrame()->GetCurChipId())->m_objpChipMaster;
				if (pChip->GetChipKind() == FDCM_OBJECT_CHIP)
				//----- _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhG_xHqqkZx_ -----
				{
					// _xZkqqHx_iDgAiDgCiDhGjCiGiCmMiDiBiDjDiDgPiBfLiCpAiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmJiOgHiCkGiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
					for (long lIdx = 0; lIdx < pChip->GetMemberSize(); lIdx++)
					{
						if (IsValidReference(pChip->GetMember(lIdx)))
						//----- _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmGiClFiCmEjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
						{
							pObjTmpl = pChip->GetMember(lIdx);
							break;
						}
					}
				} else
				//----- _xZkqqHx_jFkBiNiHjFjEjFgJiDgAiDgCiDhG_xHqqkZx_ -----
				{
					pObjTmpl = pChip;
				}
			}
//----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			break;
		case FDBC_REFO_LAST_OBJ:	// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			pObjTmpl = GetLastCreateObj();
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			for (;;)
			{
				// _xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClDiCoKiClNjFjEjFgJiCpAiMjPiNpFiBeC_xHqqkZx_
				pObjTmpl = GetLastCreateObj(pObjTmpl);
				// _xZkqqHx_jFjEjFgJiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
				if (pObjTmpl == NULL) break;
				// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCkKjHeMiMpIiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
				if (IsValidReference(pObjTmpl)) break;
			}
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			break;
		case FDBC_REFO_INSIDE_OBJ:	// _xZkqqHx_jDoAjFjEjFjEjFgJiCpAiMlDiCmJiClHiCoJiBeC_xHqqkZx_
			pObjTmpl = (FCObjDynabase*)GetInsideObject();
			break;
		}
		// _xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCkKjHeMiMpIiCmIiCoHiCmOjFnEiClHiBeC_xHqqkZx_
		if (IsValidReference(pObjTmpl)) return pObjTmpl;
	}
	return NULL;
} // FCToolBaseCreate::GetReferenceObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::IsValidReference
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiBeBiDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmGiClFiCmEjAlDiClFiCkCiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiMpDjFoCjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiKnEiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBaseCreate::IsValidReference (const FCObjDynabase* pObj) const
{
	if (pObj == NULL) return FALSE;
	if (GetInsideObject() == NULL) return FALSE;
	return (pObj->Type() == ((FCObjDynabase*)GetInsideObject())->Type());
} // FCToolBaseCreate::IsValidReference.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::SetLastCreateObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClFiClNjFjEjFgJiCmMiPoOjFpBiCpAiLeMjIfOiClHiCoJiBeCiMoDiCmFjFjEjFgJiNoMjAkMiClHiCoJiOjOiCmM_xHqqkZx_
 *			_xZkqqHx_iDiKiDhEiDeAiDiMiDjDiDfIjFjEjFgJiCmJiOgHjHhAiClHiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iLeMjIfOiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::SetLastCreateObj (const FCObjDynabase* pObj)
{
	if (FD_MAX_LASTOBJ_MEMORY <= m_vLastObj.size())
		m_vLastObj.erase(m_vLastObj.begin());
	m_vLastObj.push_back(FCObjMemRec(pObj->Type(), pObj->GetObjID()));
} // FCToolBaseCreate::SetLastCreateObj.

//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::GetLastCreateObj
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClFiClNjFjEjFgJiCmMiPoOjFpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const FCObjDynabase* FCToolBaseCreate::GetLastCreateObj ()
//{
//	const FCObjDynabase* pObj = NULL;
//	while (!m_vLastObj.empty())
//	{
//		// _xZkqqHx_jFjEjFgJiCgIiCgDiCkJiCoHjFjEjFgJiCpAiMjPiNpFiBeC_xHqqkZx_
//		pObj = g_pDoc->ObjID2Object(m_vLastObj.back().dwObjID);
//		// _xZkqqHx_jBePiJpBiNoMjAkMiCmMjFjEjFgJiCmMiMfOiCmGiIoKjChGiClHiCoJiCmIiCoHiBeBjBePiJpBjFjEjFgJiCmGjCgGjCoIiBeC_xHqqkZx_
//		if (pObj != NULL && pObj->Type() == m_vLastObj.back().objType) break;
//		 m_vLastObj.pop_back();
//	}
//	return pObj;
//} // FCToolBaseCreate::GetLastCreateObj.
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::GetLastCreateObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiMoDiCmJiNoMjAkMiClFiClNjFjEjFgJiCmMiPoOjFpBiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pPrevObj	:_xZkqqHx_iIoKiCmCjBePiCmMjFjEjFgJiCpAiOhHjCoIiBeCiClBiCmMjFjEjFgJiCoGiCoIiImIjBePiCmMjFjEjFgJiCpA_xHqqkZx_
 *						 _xZkqqHx_iMjPiNpFiClHiCoJiBeCiNmFiMoDiCkJiCoHiMjPiNpFiClHiCoJiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCObjDynabase* FCToolBaseCreate::GetLastCreateObj (const FCObjDynabase* pPrevObj)
{
	long lIndex = (long)m_vLastObj.size() - 1;
	if (pPrevObj != NULL)
	{
		for (; lIndex != -1; lIndex--)
		{
			// _xZkqqHx_jFjEjFgJiCgIiCgDiCkJiCoHjFjEjFgJiCpAiMjPiNpFiBeC_xHqqkZx_
			const FCObjDynabase* pObj = g_pDoc->ObjID2Object(m_vLastObj[lIndex].dwObjID);
			if (pObj == pPrevObj)
			{
				lIndex--;
				break;
			}
		}
	}
	for (; lIndex != -1; lIndex--)
	{
		// _xZkqqHx_jFjEjFgJiCgIiCgDiCkJiCoHjFjEjFgJiCpAiMjPiNpFiBeC_xHqqkZx_
		const FCObjDynabase* pObj = g_pDoc->ObjID2Object(m_vLastObj[lIndex].dwObjID);
		// _xZkqqHx_jBePiJpBiNoMjAkMiCmMjFjEjFgJiCmMiMfOiCmGiIoKjChGiClHiCoJiCmIiCoHiBeBjBePiJpBjFjEjFgJiCmGjCgGjCoIiBeC_xHqqkZx_
		if (pObj != NULL && pObj->Type() == m_vLastObj[lIndex].objType)
			return pObj;
		// _xZkqqHx_jGlDiMpIiCmIjFjEjFgJiCmIiCmMiCmFiNoNiPjMiClHiCoJiBeC_xHqqkZx_
		m_vLastObj.erase(m_vLastObj.begin() + lIndex);
	}
	return NULL;
} // FCToolBaseCreate::GetLastCreateObj.
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBaseCreate::InitInsideObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCpAiDgGiDhEiDeIiDiLiDgHjAnNjCoIiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iNjFiCmMiDfMiDiKiDgCiDgIiDhJiDjDiCpAjAnNjCoIiBeCjFmCiClGiClNjFjEjFgJiCmNjDoAjFjEiCpAjEjCiDhFiDiJiDfGiCmFjDgIiCoIiCmCiCnEiClFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBaseCreate::InitInsideObject (FCObjDynabase* pObj)
{
	if (pObj->IsKindOf(FDOJ_FIGURE))
	//----- _xZkqqHx_jAhNiMgAiMgOjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCObjFigure* pFig = (FCObjFigure*)pObj;
		//----- _xZkqqHx_iDhJiDjDiCmJiNjFjAeGjFjN_xHqqkZx_0.5mm_xZkqqHx_iCpAjAnNjCoI_xHqqkZx_ -----
		pFig->SetPenRegister(FD_PEN_REGISTER_UNUSE);
		pFig->SetPenStyle(FD_PEN_STYLE_SOLID);
		pFig->SetPenWeight(mmroundoff(0.5));
		pFig->SetPenBackSColor(FD_S_COLOR_BLACK);
		if (pFig->IsClosePolygon())
		//----- _xZkqqHx_jFmCiClGiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iDhFiDiJiDfGiCmJjEjCjAeGjDgIiCoIiCmCiCnEiClFiCpAjAnNjCoI_xHqqkZx_ -----
			pFig->SetBrushRegister(FD_BRUSH_REGISTER_UNUSE);
			pFig->SetBrushForeSColor(FD_S_COLOR_UNUSE);
			pFig->SetBrushPattern(FD_PATTERN_UNUSE);
			pFig->SetBrushBackSColor(FD_S_COLOR_WHITE);
		} else
		//----- _xZkqqHx_iKeKiCkCiClNjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iDhFiDiJiDfGiCmJjDkHjGlOiCpAjAnNjCoI_xHqqkZx_ -----
			pFig->SetBrushRegister(FD_BRUSH_REGISTER_UNUSE);
			pFig->SetBrushForeSColor(FD_S_COLOR_UNUSE);
			pFig->SetBrushPattern(FD_PATTERN_UNUSE);
			pFig->SetBrushBackSColor(FD_S_COLOR_UNUSE);
		}
	}
} // FCToolBaseCreate::InitInsideObject.
//----- 06.11.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

