#include "stdafx.h"
#include "DynamicDraw.h"
#include "UtilMisc.h"			// For FFSetCapture.etc.
#include "UtilBezier.h"			// For FCBezierControls.
#include "UtilGraph.h"			// For FCEditDraw.
#include "LinkManager.h"		// For FDPA_HIT_XXX.
#include "DynamicDrawView.h"	// For g_pView.
// 06.10.16 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
#include "ObjPoly.h"			// For FCObjPoly.
#include "ToolBasePolyEdit.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


////////////////////////// FCToolBasePolyEdit ///////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	View_xZkqqHx_iCmFjBeJjBpAjCiGiCmMjFjEjFgJiCpAjBfDiCmE_xHqqkZx_m_vPolyLine_xZkqqHx_iCnGjAnNjCoIiClHiCoJiBeCiLmIjApMjFjEjFgJiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiCkKiCkAiCoJiClNiCnPiBeBjCfAiCmIiCoJ_xHqqkZx_ ObjDynabaseVector _xZkqqHx_iCmFiCmNiPiIjHjNiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBjDmBiOoKiCmIiDhIiDeOiDfOiBfL_xHqqkZx_ JointSelInfoVector _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::Select (CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiCpAiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
	SetHitXXX(XXX_JOINT, InvalidValueXXX(XXX_JOINT));
} // FCToolBasePolyEdit::Select.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::DrawSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiCmMiDeKiDgJiDiBjDfPiDhNiBfLiDeOiCmGiBeBjBeJjBpAjCiGjIeBiMiLjDfPiCmMiIpIjApMiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
{
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjApMjFjEjFgJiCmMiBeBjBfDiCmEiCmMjIeBiMiLjDfPiCpAjFgAiJoG_xHqqkZx_ ------
//	long lLineIndex;
//	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
//	{
//		if (GetLineObject(lLineIndex) == pObj)
//		//----- _xZkqqHx_iIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjDfPiCpAjFgAiJoGiBeC_xHqqkZx_
//			long lJointIndex;
//			for (lJointIndex = 0;
//				 lJointIndex != GetJointCount(lLineIndex);
//				 lJointIndex++)
//				FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(lLineIndex, lJointIndex)).GetLeftTop()));
//			break;
//		}
//	}
//	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ ------
//	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//	vector<longPair> vSelectedJoint;
//	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//	{
//		if (GetLineObject(iIdx->first) == pObj)
//			DrawJointSelectMark(pDC, *iIdx);
//	}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FCEditDraw eDraw(pDC, 0);
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjApMjFjEjFgJiCmMiBeBjBfDiCmEiCmMjIeBiMiLjDfPiCpAjFgAiJoG_xHqqkZx_ ------
	long lLineIndex;
	for (lLineIndex = 0; lLineIndex != GetLineCount(); lLineIndex++)
	{
		if (GetLineObject(lLineIndex) == pObj)
		//----- _xZkqqHx_iIpIjAjEiCmFiOhHjCoIiClDiCoKiClNjApMjFjEjFgJiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBfDiCmEiCmMjIeBiMiLjDfPiCpAjFgAiJoGiBeC_xHqqkZx_
			long lJointIndex;
			for (lJointIndex = 0;
				 lJointIndex != GetJointCount(lLineIndex);
				 lJointIndex++)
				eDraw.UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, longPair(lLineIndex, lJointIndex)).GetLeftTop()));
			break;
		}
	}
	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoG_xHqqkZx_ ------
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vSelectedJoint;
	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
	vector<longPair>::const_iterator iIdx;
	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
	{
		if (GetLineObject(iIdx->first) == pObj)
		{
			// _xZkqqHx_jFgAiJoGiNmPiCnNiCmMjIeBiMiLjDfPiCpAiPmBiLiOiBeC_xHqqkZx_
			eDraw.UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
			// _xZkqqHx_jBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
			DrawJointSelectMark(pDC, *iIdx);
		}
	}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBasePolyEdit::DrawSelectMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::CanObjectAlignObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjAkOjHpBiCkKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jAkOjHpBiCmMiDfOiDeDiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_ToolBase.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmIiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBasePolyEdit::CanObjectAlignObj (FTAlignType nType) const
{
	switch (nType)
	{
	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPjAjEiCkK_xHqqkZx_2_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
		return (2 <= GetSelectedXXX(XXX_JOINT));
	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPjAjEiCkK_xHqqkZx_3_xZkqqHx_iImIiPoDiCmIiCoHiCmOjAfOiBeC_xHqqkZx_
		return (3 <= GetSelectedXXX(XXX_JOINT));
	}
	return FALSE;
} // FCToolBasePolyEdit::CanObjectAlignObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::OnObjectAlignObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjAkOjHpBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_jAkOjHpBiCmMiDfOiDeDiDhGiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_ToolBase.h_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::OnObjectAlignObj (FTAlignType nType)
{
	CClientDC dc(g_pView);
	g_pView->OnPrepareDC(&dc, NULL);
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vSelectedJoint;
	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);

//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//	vector<longPair>::const_iterator iIdx;
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		DrawJointSelectMark(&dc, *iIdx);
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	vector<longPair>::const_iterator iIdx;
	vector<longPair> vMoveJoint;
	DBLPointVector vmmptMove;
	switch (nType)
	{
	case FDAT_ALIGN_V_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
	case FDAT_ALIGN_H_CENTER:	// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
	  {
		//----- _xZkqqHx_iKoOiPiAiCmGiCmIiCoJjIeBiMiLjDfPiCmMiDhMiDiKiDfDiDjDiBeFjIeBiMiLjDfPiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOoGjDlO_xHqqkZx_ -----
		// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
		longPair stdJointIndex = GetLastSelectedXXX(XXX_JOINT);
		// _xZkqqHx_iKoOiPiAjIeBiMiLjDfPiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmNiBeBiNmFiPiJiCmMjIeBiMiLjDfPiCpAiOgHiCkEiBeC_xHqqkZx_
		if (find(vSelectedJoint.begin(), vSelectedJoint.end(), stdJointIndex) == vSelectedJoint.end())
			stdJointIndex = vSelectedJoint.front();
		//----- _xZkqqHx_iKgFjIeBiMiLjDfPiCmMiInKjDkOjHmKiCpAiOfKiPgP_xHqqkZx_ -----
		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
		{
			// _xZkqqHx_iKoOiPiAjDfPiCmIiCoHiCmOiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
			if (*iIdx != stdJointIndex)
			{
				// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
				DBLPoint mmptMove = GetFrameRectXXX(XXX_JOINT, stdJointIndex).GetLeftTop() - GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop();
				if (nType == FDAT_ALIGN_V_CENTER)
					mmptMove.y = 0.0;		// _xZkqqHx_jCiGiJjLiCmJiJkBjAkOjHpBiBeC_xHqqkZx_
				else
					mmptMove.x = 0.0;		// _xZkqqHx_jCiGiJjLiCmJiPgDjAkOjHpBiBeC_xHqqkZx_
				// _xZkqqHx_jIeBiMiLjDfPiCmMiJlMiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
				SetJointPoint(*iIdx, GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop() + mmptMove);
				vMoveJoint.push_back(*iIdx);
				vmmptMove.push_back(mmptMove);
			}
		}
		break;
	  }
	case FDAT_SAME_GAP_V:		// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
	case FDAT_SAME_GAP_H:		// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
	  {
		multimap<mmetol, longPair> mmpPosToJoint;
		//------ _xZkqqHx_iCnMiClIiBeBiDhNiDiLiDgAiDhNiDgCiDhGiCpAjHjIjHhAiClFiCmEiKoOiPiAiImKjChFiCmMiPkMiClDiCkCiPiHiCmJjFjEjFgJiCpAjFmAiCnHiCoJ_xHqqkZx_ -----
		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
		{
			if (nType == FDAT_SAME_GAP_V)	// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
				mmpPosToJoint.insert(pair<mmetol, longPair>(GetFrameRectXXX(XXX_JOINT, *iIdx).top, *iIdx));
			else	// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
				mmpPosToJoint.insert(pair<mmetol, longPair>(GetFrameRectXXX(XXX_JOINT, *iIdx).left, *iIdx));
		}
		const mmetol mmA0 = mmpPosToJoint.begin()->first;
		const mmetol mmAn = mmpPosToJoint.rbegin()->first;
		const mmetol mmGap = (mmAn - mmA0) / (mmpPosToJoint.size() - 1);
		multimap<mmetol, longPair>::iterator idll = mmpPosToJoint.begin();
		long lC;
		for (idll++, lC = 1; lC != mmpPosToJoint.size() - 1; idll++, lC++)
		{
			mmetol mmNewA = mmA0 + (lC * mmGap);
			DBLPoint mmptMove(0,0);
			if (nType == FDAT_SAME_GAP_V)	// _xZkqqHx_iPgDiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
				mmptMove.y = mmNewA - GetFrameRectXXX(XXX_JOINT, idll->second).top;
			else	// _xZkqqHx_iJkBiCmJiKnEiKhFiLmPjDjJiBeC_xHqqkZx_
				mmptMove.x = mmNewA - GetFrameRectXXX(XXX_JOINT, idll->second).left;
			// _xZkqqHx_jIeBiMiLjDfPiCmMiJlMiImKjChFiCpAiInKjDkOiBeC_xHqqkZx_
			SetJointPoint(idll->second, GetFrameRectXXX(XXX_JOINT, idll->second).GetLeftTop() + mmptMove);
			vMoveJoint.push_back(idll->second);
			vmmptMove.push_back(mmptMove);
		}
		break;
	  }
	}
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		DrawJointSelectMark(&dc, *iIdx);
//----- 05.09.07 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_jIeBiMiLjDfPiCpAiInKjDkOiBeC_xHqqkZx_
	MoveXXX(XXX_JOINT, vMoveJoint, vmmptMove);
} // FCToolBasePolyEdit::OnObjectAlignObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::IsObjectCommandEnable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ ID_OBJECT_XXX _xZkqqHx_iCmMjCoIjAkLjDeJiCmIjHeMiMpIiBeFjGlDiMpIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCmdID	:_xZkqqHx_iDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHeMiMpIiCmMiPoKiNiH_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBasePolyEdit::IsObjectCommandEnable (DWORD dwCmdID) const
{
	switch (dwCmdID)
	{
	case ID_OBJECT_PROPERTIES:
	case ID_OBJECT_PUT_RTF_OBJ:

	case ID_OBJECT_ALIGN_V_CENTER:
	case ID_OBJECT_ALIGN_H_CENTER:
	case ID_OBJECT_SAME_GAP_V:
	case ID_OBJECT_SAME_GAP_H:
		return TRUE;

	case ID_OBJECT_ALIGN_V_LEFT:
	case ID_OBJECT_ALIGN_V_RIGHT:
	case ID_OBJECT_ALIGN_H_TOP:
	case ID_OBJECT_ALIGN_H_BOTTOM:
	case ID_OBJECT_SAME_DIST_V:
	case ID_OBJECT_SAME_DIST_H:
	case ID_OBJECT_SAME_SIZE_X:
	case ID_OBJECT_SAME_SIZE_Y:
		return FALSE;

	default:
		return BASE_CLASS::IsObjectCommandEnable(dwCmdID);
	}
} // FCToolBasePolyEdit::IsObjectCommandEnable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::InvalidValueXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGlDiMpIiCmIjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jGlDiMpIiCmIjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
longPair FCToolBasePolyEdit::InvalidValueXXX (XXX_Joint) const
{
	return longPair(-1, -1);
} // FCToolBasePolyEdit::InvalidValueXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::SelectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiDiKiDfIiDgHiCmJjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::SelectXXX (XXX_Joint, longPair xxx, CDC* pDC)
{
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
//	if (pDC != NULL) DrawJointSelectMark(pDC, xxx);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (pDC != NULL)
	{
		// _xZkqqHx_jFgAiJoGiNmPiCnNiCmMjIeBiMiLjDfPiCpAiPmBiLiOiBeC_xHqqkZx_
		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, xxx).GetLeftTop()));
		// _xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFgAiJoGiBeC_xHqqkZx_
		DrawJointSelectMark(pDC, xxx);
	}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::SelectXXX(XXX_JOINT, xxx, pDC);
} // FCToolBasePolyEdit::SelectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::UnselectXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiBeBjBeJjBpAiPpDjBnEiCkJiCoHiKeKjFpKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pXxx:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeCjBfDiCmEiJpAiPjMiClHiCoJiPoKiNiHiCmN_xHqqkZx_InvalidValueXXX()_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeCjFgAiJoGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::UnselectXXX (XXX_Joint, longPair xxx, CDC* pDC)
{
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::UnselectXXX(XXX_JOINT, xxx, pDC);
	if (pDC != NULL)
	//----- _xZkqqHx_jFgAiJoGiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (xxx == InvalidValueXXX(XXX_JOINT))
		//----- _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
			vector<longPair> vSelectedJoint;
			GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
			// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
			vector<longPair>::const_iterator iIdx;
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//				DrawJointSelectMark(pDC, *iIdx);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
			{
				// _xZkqqHx_jIeBiMiLjDfPiCpAjFgAiJoGiBeC_xHqqkZx_
				FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
				// _xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
				DrawJointSelectMark(pDC, *iIdx);
			}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		} else
		//----- _xZkqqHx_iOhHjCoIiClDiCoKiClN_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjBeJjBpAiJpAiPjMiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// _xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//			DrawJointSelectMark(pDC, xxx);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// _xZkqqHx_jIeBiMiLjDfPiCpAjFgAiJoGiBeC_xHqqkZx_
			FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, xxx).GetLeftTop()));
			// _xZkqqHx_jIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
			DrawJointSelectMark(pDC, xxx);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	}
} // FCToolBasePolyEdit::UnselectXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::CanMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiInKjDkOiCmFiCkLiCoJiCkJiCmHiCkEiCkJjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iInKjDkOiCmFiCkLiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolBasePolyEdit::CanMoveXXX (XXX_Joint) const
{
	// _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
	return FFCanEditObject();
} // FCToolBasePolyEdit::CanMoveXXX.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::DrawFirstImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiPiJiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::DrawFirstImageXXX (XXX_Joint, CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vSelectedJoint;
	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);

//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iInKjDkOjCiGjIeBiMiLjDfPiCmMiBeBiDeJiDiKiDfHiDgJiDiLiImKjChFiBeC_xHqqkZx_
	m_vMovingJointOrig.clear();
//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	vector<longPair>::const_iterator iIdx;
	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
	{
		// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAiPmBiLiOiBeC_xHqqkZx_
		DrawJointSelectMark(pDC, *iIdx);
		// _xZkqqHx_iClBiClBiCmFiCmNjIeBiMiLjDfPiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
		// RedrawMovingImageXXX _xZkqqHx_iCmJiCoGiCmBiCmEiNmFiPiJiCmJiPmBiLiOiPiIjHjNiCkKiClDiCoKiCoJiCmMiCmFiBeB_xHqqkZx_
		// _xZkqqHx_iLhEiCmJjFfMiOkGiPpDjBnEiCmGiCmIiCoJiBeCiInKjDkOiMlDiCmMjIeBiMiLjDfPiCpAjFfMiOkGiPpDjBnEiCmJjFnLiCmCiClNiCnPiBeC_xHqqkZx_
//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iInKjDkOjCiGjIeBiMiLjDfPiCmMiBeBiDeJiDiKiDfHiDgJiDiLiImKjChFiCpAiKgPiCkGiCmEiCkIiCkNiBeC_xHqqkZx_
		m_vMovingJointOrig.push_back(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop());
//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiCoJiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
	DrawSelectedBezier(pDC);
} // FCToolBasePolyEdit::DrawFirstImageXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::RedrawMovingImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMove:XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiInKjDkOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	mmptMove=(0,0)_xZkqqHx_iCkKiOhHjCoIiClDiCoKiClNiPoKiNiHiCmNiBeBjFfMiOkGjFgAiJoGiCmMiCnNiCpAiNhDiCkEiBeC_xHqqkZx_
 *			Tool::OnDraw _xZkqqHx_iCmFiCmMjFgAiJoGiPiIjHjNjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::RedrawMovingImageXXX (XXX_Joint, const DBLPoint& mmptMove, CDC* pDC)
{
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vSelectedJoint;
	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);

	vector<longPair>::const_iterator iIdx;
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	longSet::const_iterator iLdx;
	if (!mmptMove.IsNull())
	//----- _xZkqqHx_iInKjDkOiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAiPmBiLiOiBeC_xHqqkZx_
		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
			FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));

		//----- _xZkqqHx_jBePiJpBjFgAiJoGiClFiClNiLmIjApMiCpAiPmBiLiO_xHqqkZx_ -----
		DrawSelectedBezier(pDC);

		//----- _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCpAiClHiCnHiCmE_xHqqkZx_mmptMove_xZkqqHx_iClOiCkPiInKjDkO_xHqqkZx_ -----
		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
			SetJointPoint(*iIdx, GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop() + mmptMove);

// 06.12.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
	}

	//----- _xZkqqHx_iJgFiLlPiCpAiOpDiCkPiClNiLmIjApMiCpAjFgAiJoG_xHqqkZx_ -----
	DrawSelectedBezier(pDC);

	// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
} // FCToolBasePolyEdit::RedrawMovingImageXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::DrawLastImageXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmFiMoDiCmMiDeDiDiBiBfLiDfHiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	DrawFirstImageXXX_xZkqqHx_iBeB_xHqqkZx_RedrawMovingImageXXX_xZkqqHx_iBeB_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmN_xHqqkZx_
 *			_xZkqqHx_iDfKiDgCiDgHiBeC_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiInKjDkOiCmMiPoKiNiHiCpAiNgMiCkGiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCfAiBeE_xHqqkZx_DrawFirstImageXXX _xZkqqHx_iCmFiNmFiPiJiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfBiBeE_xHqqkZx_RedrawMovingImageXXX _xZkqqHx_iCmNiBeBiDhNiDeFiDfIiInKjDkOiOjOiCmJiBeBiInKjDkOjBePiCmMjFnCiPfHjApMiCpA_xHqqkZx_
 *				_xZkqqHx_iPmBiLiOiClFiBeBiOhHjCoIiLjHjHkDiClOiCkPiLjHjHkDiCpAiInKjDkOiBeBiInKjDkOiMoDiCmMjFnCiPfHjApMiCpAjFgAiJoGiBeC_xHqqkZx_
 *			_xZkqqHx_iCfCiBeE_xHqqkZx_DrawLastImageXXX _xZkqqHx_iCmFiNmFiMoDiCmMjFnCiPfHjApMiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::DrawLastImageXXX (XXX_Joint, CDC* pDC)
{
	// _xZkqqHx_iClBiCmMiKnGjAjEiCkKiLpDiCmFiCoAjGhHiCmHiCmMiPoKiNiHiCmNjAlDiPoNiCmJjFgAiJoGiClDiCoKiCoJiCkKiBeB_xHqqkZx_
	// _xZkqqHx_iCgAiCpAjAiCjClMiCmJiPoDiCmJiInKjDkOiClFiClNiPoKiNiHiCmJiCmNiDfDiDhOiCkKiOgDiCmBiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	//
	//    _xZkqqHx_iBkA_xHqqkZx_
	//    _xZkqqHx_iEkA_xHqqkZx_
	//    _xZkqqHx_iEkA_xHqqkZx_
	//    _xZkqqHx_iEkA_xHqqkZx_
	//    _xZkqqHx_iEkA_xHqqkZx_
	//  _xZkqqHx_iBkKiEkA_xHqqkZx_
	//  _xZkqqHx_iCgAiBkAiEjPiEjPiEjPiEjPiEjPiBkA_xHqqkZx_
	//
	// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
	vector<longPair> vSelectedJoint;
	GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
	// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAiPmBiLiOiBeC_xHqqkZx_
	vector<longPair>::const_iterator iIdx;
	for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
		FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
	//----- _xZkqqHx_jBePiJpBjFgAiJoGiClFiClNiLmIjApMiCpAiPmBiLiO_xHqqkZx_ -----
	DrawSelectedBezier(pDC);

//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iInKjDkOjCiGjIeBiMiLjDfPiCmMiBeBiDeJiDiKiDfHiDgJiDiLiImKjChFiBeC_xHqqkZx_
	m_vMovingJointOrig.clear();
//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolBasePolyEdit::DrawLastImageXXX.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::OnDrawState (CDC* pDC, int iState)
{
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (iState)
//	{
//	case STATE_MOVING_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		if (m_iCursorNew != FDPA_HIT_NONE &&
////			m_iCursorNew != FDPA_HIT_NOT_MOLIP)
////		//----- _xZkqqHx_iDiCiDiKiDhGiPoDiDhBiDgCiDgHiCmMiPoKiNiH_xHqqkZx_ -----
////		{
////			// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
////			RedrawMovingImageXXX(XXX_JOINT, DBLPoint(0,0), pDC);
////		} else
////		{
////			// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
////			BASE_CLASS::OnDrawState(pDC, iState);
////		}
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	  {
//		// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
//		vector<longPair> vSelectedJoint;
//		GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
//		vector<longPair>::const_iterator iIdx;
//		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
//		{
//			// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
//			DrawJointSelectMark(pDC, *iIdx);
//			// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//			FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//		}
//	  }
//		// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//		BASE_CLASS::OnDrawState(pDC, iState);
////----- 06.12.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		{
//			const FCAutoBackup<DBLPoint> backupCnv(m_mmptCnv, m_mmrtLastFrame.GetLeftTop());
//			// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//			BASE_CLASS::OnDrawState(pDC, STATE_IDLE);
//			return;
//		}
//		break;
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDrawState(pDC, iState);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_MOVING_XXX:			// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOjCiGiBeC_xHqqkZx_
	  {
		// ToolBase::OnDraw_xZkqqHx_jCiGiCmM_xHqqkZx_DrawSelectMark_xZkqqHx_iCmJiCoGiCmBiCmEiBeB_xHqqkZx_
		// _xZkqqHx_jBeJjBpAjCiGiCmMjBlNiKhAjApMjFjEjFgJiCmMjBeJjBpAiDhNiBfLiDeOiCmNjBfDiCmEjFgAiJoGiClDiCoKiCoJiBeC_xHqqkZx_
		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiCmNiBeBjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCmNjEpBjFfMiOkGiPpDjBnEiCmIiCmMiCmF_xHqqkZx_
		// _xZkqqHx_jHfMiCnPjFgAiJoGiClFiCmEiCkIiCkCiCmEiLhEiCmJiPiIjHjNiClDiClJiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_

		// _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJ_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOoGjDlOiBeC_xHqqkZx_
		vector<longPair> vSelectedJoint;
		GetSelectedXXX(XXX_JOINT, &vSelectedJoint);
		vector<longPair>::const_iterator iIdx;
		for (iIdx = vSelectedJoint.begin(); iIdx != vSelectedJoint.end(); iIdx++)
		{
			// _xZkqqHx_jBeJjBpAjCiGiCmMjIeBiMiLjDfPiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
			// _xZkqqHx_iInKjDkOjCiGiCmNiBeBjBeJjBpAiDhNiBfLiDeOiCmNjEpBjFfMiOkGiPpDjBnEiCmJiCkAiCoJiClNiCnPiLhEiPiIjHjNiBeC_xHqqkZx_
			DrawJointSelectMark(pDC, *iIdx);
			// FCToolSelectTmpl::OnDrawState _xZkqqHx_iCmFjFgAiJoGiClDiCoKiCoJiClNiCnPiBeC_xHqqkZx_
			// _xZkqqHx_iClBiClBiCmFiCmNjIeBiMiLjDfPiCmNjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
		}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iInKjDkOjCiGjIeBiMiLjDfPiCmMiBeBiDeJiDiKiDfHiDgJiDiLiImKjChFiCpAjFgAiJoGiBeC_xHqqkZx_
		DBLPointVector::const_iterator iPt;
		for (iPt = m_vMovingJointOrig.begin();
			 iPt != m_vMovingJointOrig.end(); iPt++)
		{
			FCEditDraw(pDC, 0).UnselMark(mm2lg(*iPt));
		}
//----- 06.12.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 06.12.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//			// _xZkqqHx_iInKjDkOjCiGiCmMjIeBiMiLjDfPiCpAjFfMiOkGiBeC_xHqqkZx_
//			FCEditDraw(pDC, 0).UnselMark(mm2lg(GetFrameRectXXX(XXX_JOINT, *iIdx).GetLeftTop()));
//----- 06.12.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		break;
	  }
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
//----- 06.12.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolBasePolyEdit::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolBasePolyEdit.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolBasePolyEdit::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//		if (FFCanEditObject())
//		//----- _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
//		{
//			switch (iEvent)
//			{
//			case WM_KEYDOWN:		// _xZkqqHx_iDeMiBfLiDfPiDeFiDjDiBeC_xHqqkZx_
//				// _xZkqqHx_iDeKiBfLiDfMiDiLiDeMiBfLiCmIiCoHiCmOiBeBiDfIiDgJiDgCiDhGiInKjDkOiBeCiBgJiJlMjBhKiDeMiBfLiCmFiCoAjBoFiPoEjFhGiBgK_xHqqkZx_
//				if (m_dwChar == VK_LEFT || m_dwChar == VK_UP ||
//					m_dwChar == VK_RIGHT || m_dwChar == VK_DOWN)
//					iNextState = STATE_DO_MOVE_JOINT_SNAP;	// _xZkqqHx_jIeBiMiLjDfPiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//				break;
//			}
//		}
//		break;
//	case BASE_CLASS::STATE_PRE_UNSEL_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiJpAiPjMjBePiBeC_xHqqkZx_
//		switch (iEvent)
//		{
//		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
//			// _xZkqqHx_jBeJjBpAjFjEjFgJjFnCiPfHiJmCjEfMiCmIiCoHiCmOiBeBiOjPiCnGiBeC_xHqqkZx_
//			if (FFCanEditSelected())
//				iNextState = STATE_START_MOVE_JOINT;	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//			break;
//		}
//		break;
//	case BASE_CLASS::STATE_CLRSEL_SEL_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPmBiLiOjCmHiJmBiBeC_xHqqkZx_
//		switch (iEvent)
//		{
//		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
//			// _xZkqqHx_jBeJjBpAjFjEjFgJjFnCiPfHiJmCjEfMiCmIiCoHiCmOiBeBiOjPiCnGiBeC_xHqqkZx_
//			if (FFCanEditSelected())
//				iNextState = STATE_START_MOVE_JOINT;	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//			break;
//		}
//		break;
//	case STATE_START_MOVE_JOINT:	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//		iNextState = STATE_MOVING_JOINT;		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case BASE_CLASS::STATE_MOVING_XXX:		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
//			iNextState = STATE_MOVING_JOINT;		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//			break;
//		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
//			if (IsControl())
//				iNextState = STATE_RE_LINK;		// _xZkqqHx_iDiKiDjDiDeOjFhEjBnGiCkGiBeC_xHqqkZx_
//			else
//				iNextState = STATE_STOP_MOVE_JOINT;	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
//			break;
//		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
//			if (!IsControl())
//				iNextState = STATE_STOP_MOVE_JOINT;	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
//			break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		case WM_RBUTTONUP:	// _xZkqqHx_iJeFiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			if (m_dwJointLinkKind != 0)
			//----- _xZkqqHx_iDiKiDjDiDeOjFhEiCkPjBnGiCkGiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
			{
				iNextState = STATE_WAIT_CONTEXT_MENU_JOINT;	// _xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPjBnCiClPiBeC_xHqqkZx_
				break;
			}
		}
		break;
	case STATE_WAIT_CONTEXT_MENU_JOINT:	// _xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPjBnCiClPiBeC_xHqqkZx_
		switch (iEvent)
		{
//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

		case WM_CONTEXTMENU:	// _xZkqqHx_iDfCiDjDiDgFiDeMiDfIiDgHiDiBiDgKiDiFiBfLiBeC_xHqqkZx_
			iNextState = STATE_CONTEXT_MENU_JOINT;	// _xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_CONTEXT_MENU_JOINT:	// _xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_COMMAND:	// _xZkqqHx_iDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			iNextState = STATE_JOINT_LINK_COMMAND;	// _xZkqqHx_jIeBiMiLjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_JOINT_LINK_COMMAND:	// _xZkqqHx_jIeBiMiLjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
// 05.09.03 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		iNextState = STATE_RE_LINK;			// _xZkqqHx_iDiKiDjDiDeOjFhEjBnGiCkGiBeC_xHqqkZx_
		iNextState = BASE_CLASS::STATE_STOP_MOVE_XXX;	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_RE_LINK:			// _xZkqqHx_iDiKiDjDiDeOjFhEjBnGiCkGiBeC_xHqqkZx_
//		iNextState = STATE_STOP_MOVE_JOINT;	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
//		break;
//	case STATE_STOP_MOVE_JOINT:		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
//		iNextState = BASE_CLASS::STATE_EXIT_SELECT_XXX;		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjBeJjBpAiPgPiMpLiBeC_xHqqkZx_
//		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case BASE_CLASS::STATE_CANCEL_ENCLOSE_XXX:		// XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHjFoPiImNiDeMiDiDiDjDiDfKiDiLiBeC_xHqqkZx_
		iNextState = STATE_CHECK_EXIT_TOOL_BY_BUTTON;		// _xZkqqHx_iDhNiDeFiDfIiDhLiDfOiDjDiCmJiCoGiCoJiDgDiBfLiDiLiPeJjHlJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_DO_MOVE_JOINT_SNAP:	// _xZkqqHx_jIeBiMiLjDfPiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//		iNextState = STATE_IDLE;			// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
//		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolBasePolyEdit::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_START_MOVE_JOINT:	// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//		StateStartMoveJoint(pDC);
//		break;
//	case STATE_MOVING_JOINT:		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOjCiGiBeC_xHqqkZx_
//		StateMovingJoint(pDC);
//		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	case STATE_CONTEXT_MENU_JOINT:	// _xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
		StateContextMenuJoint(pDC);
		break;
	case STATE_JOINT_LINK_COMMAND:	// _xZkqqHx_jIeBiMiLjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
		StateJointLinkCommand(pDC);
		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	case STATE_RE_LINK:				// _xZkqqHx_iDiKiDjDiDeOjFhEjBnGiCkGiBeC_xHqqkZx_
//		StateReLink(pDC);
//		break;
//	case STATE_STOP_MOVE_JOINT:		// _xZkqqHx_jIeBiMiLjDfPiInKjDkOiPeJjHlJiBeC_xHqqkZx_
//		StateStopMoveJoint(pDC);
//		break;
//	case STATE_DO_MOVE_JOINT_SNAP:	// _xZkqqHx_jIeBiMiLjDfPiDfIiDgJiDgCiDhGiInKjDkOiBeC_xHqqkZx_
//		StateDoMoveJointSnap(pDC);
//		break;
//----- 05.09.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case STATE_WAIT_CONTEXT_MENU_JOINT:	// _xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPjBnCiClPiBeC_xHqqkZx_
		StateWaitContextMenuJoint(pDC);
		break;
//----- 06.10.12 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolBasePolyEdit::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateStartMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjCfLiInKjDkOiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::StateStartMoveXXX (XXX_Joint, CDC* pDC)
{
	TRACE(_T("StateStartMoveXXX\r\n"));
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::StateStartMoveXXX(XXX_JOINT, pDC);
	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiDiKiDjDiDeOiDhBiDgCiDgHiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_dwJointLinkKind = 0;
	if (IsOpenLine(GetHitXXX(XXX_JOINT).first) &&
		(GetHitXXX(XXX_JOINT).second == 0 ||
		 GetHitXXX(XXX_JOINT).second == GetJointCount(GetHitXXX(XXX_JOINT).first) - 1))
	//----- _xZkqqHx_iDhNiDeFiDfIiDhBiDgCiDgHiClFiClNjApMiCkKiKeKiCkCiCmEiCkCiCoJiBeBiKiOiCmCjCfLjDfPiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhIiDfHiDeGiLmIjApMiCmMjAkHiMoEjDfPiCpAiOoGjDlOiBeC_xHqqkZx_
		FCBezierControls bc;
		GetBezierControls(	bc,
							GetHitXXX(XXX_JOINT).first,
							GetHitXXX(XXX_JOINT).second,
							GetHitXXX(XXX_JOINT).second == 0);
		// _xZkqqHx_jClMjApMiCmMiPoKiNiHiCmNiBeBjClMjApMiJiEjClHjApMiCpAiInKjDkOjApMiCmJjCmHiJmBiBeC_xHqqkZx_
		if (bc.IsLine())
			m_mmlnvAry.push_back(DBLLine(bc.A(), bc.D()));
	}
} // FCToolBasePolyEdit::StateStartMoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateMovingXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjCfLiInKjDkOjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::StateMovingXXX (XXX_Joint, CDC* pDC)
{
	TRACE(_T("StateMovingXXX\r\n"));
	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NONE;
	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiDiKiDjDiDeOiDhBiDgCiDgHiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_dwJointLinkKind = 0;

	DBLPoint mmptHitPos;
	if (IsControl() &&
		IsOpenLine(GetHitXXX(XXX_JOINT).first) &&
		GetSelectedXXX(XXX_JOINT) == 1 &&
		(GetHitXXX(XXX_JOINT).second == 0 ||
		 GetHitXXX(XXX_JOINT).second == GetJointCount(GetHitXXX(XXX_JOINT).first) - 1))
	//----- _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiCpAiJjPiClFiCmIiCkKiCoHiDhNiDeFiDfIjBiAiNoMiBeBjCfAjDmGiCmMjCfLjDfPiInKjDkOiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMjPiNpFiCpAiDhAiDfIiClHiCoJiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
		FTMolipSet stIgnore;
		stIgnore.insert(FCMolipRec(GetLineObject(GetHitXXX(XXX_JOINT).first)->GetObjID(), -1));
		// _xZkqqHx_iDiCiDiKiDhGiMjPiNpFiBeCiDiKiDjDiDeOjAoGiCkKiOkJjFkKiOkJjAgHiCmIiCoHiCmOiMjPiNpFjGlDiOiLiBeC_xHqqkZx_
		m_iCursorNew = FCLinkManager::GetHitOnMolipLine(m_pHitMolipObj, m_lHitMolip,
														mmptHitPos, m_mmptMsc,
														m_dwFlags, m_mmptCnv,
														m_mmlnvAry.begin(), m_mmlnvAry.size(),
														&stIgnore);
	}
	if (m_iCursorNew != FDPA_HIT_NONE &&
		m_iCursorNew != FDPA_HIT_NOT_MOLIP)
	//----- _xZkqqHx_iDiCiDiKiDhGiPoDiDhBiDgCiDgHiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDiCiDiKiDhGiPoDiDhBiDgCiDgHiCmMiPoKiNiHiCmNiBeBiDhNiDeFiDfIiNmAjFfHiCpAiDiCiDiKiDhGiNmAjFfHiCmJjFoCjAlDiBeC_xHqqkZx_
		switch (m_iCursorNew)
		{
		case FDPA_HIT_POINT_MOLIP:	// _xZkqqHx_jDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
			m_dwJointLinkKind = FDLM_LINK_ON_COORD;
			break;
		case FDPA_HIT_LINE_MOLIP:	// _xZkqqHx_jApMiDiCiDiKiDhGiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
			m_dwJointLinkKind = FDLM_LINK_ON_RATIO;
			break;
		default:					// FDPA_HIT_POL_MOLIP(_xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_)
			m_dwJointLinkKind = FDLM_LINK_ON_ANGLE;
		}
		if (!almosteq(m_mmrtLastFrame.GetLeftTop(), mmptHitPos))
		//----- _xZkqqHx_jBePiJpBiCmG_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNmAjFfHiCkKjFmPiJlLiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
			const DBLPoint mmptMove = mmptHitPos - m_mmrtLastFrame.GetLeftTop();
			// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
			RedrawMovingImageXXX(XXX_JOINT, mmptMove, pDC);
			// m_mmrtLastFrame_xZkqqHx_iCmJiInKjDkOiMoDiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
			m_mmrtLastFrame.SetRect(mmptHitPos, mmptHitPos);

			//----- _xZkqqHx_iInKjDkO_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiCmGiJeFiJlKiCmMiCfBiMmCiPiKiCpAjFfMiOkG_xHqqkZx_ -----
//----- 06.02.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			FFGetMainWnd()->MoveRulerMMK(m_mmrtLastFrame.GetLeftTop(),
//										m_mmrtLastFrame.GetRightBottom());
//----- 06.02.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// _xZkqqHx_iNmFiPiJiCmMiImKjChFiBeBiInKjDkOiMoDiCmMiImKjChFiCpAjFfMiOkGiBeC_xHqqkZx_
			FFGetMainWnd()->MoveRulerMMK(m_mmrtFirstFrame.GetLeftTop(),
										 m_mmrtLastFrame.GetLeftTop());
//----- 06.02.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
	} else
	//----- _xZkqqHx_iDiCiDiKiDhGiPoDiDhBiDgCiDgHiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::StateMovingXXX(XXX_JOINT, pDC);
	}

	// BASE_CLASS::StateIdle_xZkqqHx_iCmFiCmMiBeBiDeKiBfLiDfMiDiLiImKjChFjFfMiOkGiCmJjEpFiCkGiCmEiBeB_xHqqkZx_m_mmptMsc = m_mmrtLastFrame_xZkqqHx_iCmJiBeC_xHqqkZx_
// 06.02.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	const DBLPoint mmptMscBak = m_mmptMsc;
	const DBLPoint mmptCnvBak = m_mmptCnv;
	m_mmptCnv = m_mmrtLastFrame.GetLeftTop();
	// _xZkqqHx_iDeKiBfLiDfMiDiLjFfMiOkGiBeCiInKjDkOjHmKiCkKiCePiCmFiCoAiBeBiDiKiDjDiDeOiMgAiOkOjFmPiNfIiCmMjFfMiOkGiCmMjFeLjHhGiCkKiCkAiCoJiClNiCnPjFeLjHhGiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
	// m_mmptCnv_xZkqqHx_iCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
	m_mmptCnv = mmptCnvBak;
} // FCToolBasePolyEdit::StateMovingXXX.

//----- 06.10.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateStopMoveXXX
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMjCfLiInKjDkOiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolBasePolyEdit::StateStopMoveXXX (XXX_Joint, CDC* pDC)
//{
//	TRACE(_T("StateStopMoveXXX\r\n"));
//	WORD wLinkKindA = m_dwJointLinkKind & 0xffff;
//	//----- _xZkqqHx_jBeJjBpAiClDiCoKiCmEiCkCiCoJjIeBiMiLjDfPiCpAiDgAiDeGiDgCiDeO_xHqqkZx_ -----
//	if (wLinkKindA == FDLM_LINK_ON_ANGLE &&
//		IsOpenLine(GetHitXXX(XXX_JOINT).first) &&
//		GetSelectedXXX(XXX_JOINT) == 1 &&
//		(GetHitXXX(XXX_JOINT).second == 0 ||
//		 GetHitXXX(XXX_JOINT).second == GetJointCount(GetHitXXX(XXX_JOINT).first) - 1))
//	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
//	{
//		ASSERT(	m_pHitMolipObj != NULL &&
//				m_iCursorNew != FDPA_HIT_NONE &&
//				m_iCursorNew != FDPA_HIT_NOT_MOLIP);
//		FCBezierControls bc;
//		GetBezierControls(	bc,
//							GetHitXXX(XXX_JOINT).first,
//							GetHitXXX(XXX_JOINT).second,
//							GetHitXXX(XXX_JOINT).second == 0);
//		mmetol mmArrowAutoGap;
////----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////		if (GetHitXXX(XXX_JOINT).second == 0)
////			mmArrowAutoGap = g_pReg->GetFrontArrowAutoGap();
////		else
////			mmArrowAutoGap = g_pReg->GetBackArrowAutoGap();
////----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//		if (GetHitXXX(XXX_JOINT).second == 0)
//			mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetFrontArrowAutoGap() : 0.0;
//		else
//			mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetBackArrowAutoGap() : 0.0;
////----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//		if (m_pHitMolipObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lHitMolip))
//		{
//			// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiInKjDkOjHmKiCpAiMhGiOfKiBeC_xHqqkZx_
//			const DBLPoint mmptMove = bc.A() - m_mmrtLastFrame.GetLeftTop();
//			// _xZkqqHx_iInKjDkOjCiGiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDeDiDiBiBfLiDfHiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//			RedrawMovingImageXXX(XXX_JOINT, mmptMove, pDC);
//			// m_mmrtLastFrame_xZkqqHx_iCmJiInKjDkOiMoDiCmM_xHqqkZx_XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiNlGiPoDiNmAjFfHiCpAiLeMjIfOiBeC_xHqqkZx_
//			m_mmrtLastFrame.SetRect(bc.A(), bc.A());
//		}
//	}
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::StateStopMoveXXX(XXX_JOINT, pDC);
//} // FCToolBasePolyEdit::StateStopMoveXXX.
//----- 06.10.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateDoMoveXXX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	XXX_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiInKjDkOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	ToolBasePolyEdit2.mdpf_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::StateDoMoveXXX (XXX_Joint, CDC* pDC)
{
	TRACE(_T("FCToolBasePolyEdit::StateDoMoveXXX\r\n"));

//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_FCLinkManager::ReLink_xZkqqHx_iCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClFiBeB_xHqqkZx_
//	// BASE_CLASS::StateDoMoveXXX_xZkqqHx_iCmFiCoAiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiCmMiCmFiBeB_xHqqkZx_
//	// _xZkqqHx_jBfDjBmMiCpAiLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmFiImNiCkEiBeC_xHqqkZx_
//	g_pDoc->SessionBegin();
//
//	if (m_dwJointLinkKind != 0)
//	//----- _xZkqqHx_iDiKiDjDiDeOjFhEiCkPjBnGiCkGiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
//	{
//		ASSERT(	m_pHitMolipObj != NULL &&
//				m_iCursorNew != FDPA_HIT_NONE &&
//				m_iCursorNew != FDPA_HIT_NOT_MOLIP);
//
//		FCMolipRec linkFrom(m_pHitMolipObj->GetObjID(), m_lHitMolip);
//		FTMolipSet stLinkTo;
//		stLinkTo.insert(FCMolipRec(GetLineObject(GetHitXXX(XXX_JOINT).first)->GetObjID(),
//						JointIDtoMolipID(GetHitXXX(XXX_JOINT).second)));
//		WORD wLinkKindA = m_dwJointLinkKind & 0xffff;
//		WORD wLinkKindB = m_dwJointLinkKind >> 16;
//		FCLinkManager::ReLink(linkFrom, stLinkTo, wLinkKindA);
//		FCLinkManager::ReLink(stLinkTo, linkFrom, wLinkKindB);
//	}
//	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::StateDoMoveXXX(XXX_JOINT, pDC);
//
//	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
//	g_pDoc->SessionEnd();
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiKeKiOgOiBeC_xHqqkZx_FCLinkManager::ReLink_xZkqqHx_iCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClFiBeB_xHqqkZx_
	// BASE_CLASS::StateDoMoveXXX_xZkqqHx_iCmFiCoAiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiCmMiCmFiBeB_xHqqkZx_
	// _xZkqqHx_jBfDjBmMiCpAiLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmFiImNiCkEiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	if (m_dwJointLinkKind != 0)
	//----- _xZkqqHx_iDiKiDjDiDeOjFhEiCkPjBnGiCkGiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		ASSERT(	m_pHitMolipObj != NULL &&
				m_iCursorNew != FDPA_HIT_NONE &&
				m_iCursorNew != FDPA_HIT_NOT_MOLIP);

		longSet stJointIndex;
		stJointIndex.insert(GetHitXXX(XXX_JOINT).second);
		// _xZkqqHx_iInKjDkOjBePiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		AppendJointMovedRgn(GetHitXXX(XXX_JOINT).first, stJointIndex);

		ObjDynabaseSet stRedrawObj;
		const FCObjDynabase* pObjH = GetLineObject(GetHitXXX(XXX_JOINT).first);
		const FCObjDynabase* pObjK = m_pHitMolipObj;
		const long lMolipIdH = JointIDtoMolipID(GetHitXXX(XXX_JOINT).second);
		const long lMolipIdK = m_lHitMolip;
		// _xZkqqHx_jAfGiClFiCkCiDiKiDjDiDeOiCmMiDiKiDjDiDeOiMlDiBeC_xHqqkZx_ToolBasePolyEdit2.mdpf _xZkqqHx_jCiGiCmM_xHqqkZx_K_xZkqqHx_iBeC_xHqqkZx_
		FCMolipRec molipK(pObjK->GetObjID(), lMolipIdK);
		// _xZkqqHx_jAfGiClFiCkCiDiKiDjDiDeOiCmMiDiKiDjDiDeOjAoGiBeC_xHqqkZx_ToolBasePolyEdit2.mdpf _xZkqqHx_jCiGiCmM_xHqqkZx_H_xZkqqHx_iBeC_xHqqkZx_
		FCMolipRec molipH(pObjH->GetObjID(), lMolipIdH);
		const WORD wLinkKindFore = m_dwJointLinkKind & 0xffff;
		const WORD wLinkKindBack = m_dwJointLinkKind >> 16;
		if (wLinkKindBack != 0)
		//----- _xZkqqHx_jBgPjFpLiMpMiDiKiDjDiDeOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMiDfAiBfLiDfI_xHqqkZx_E_xZkqqHx_iBeC_xHqqkZx_
			DWORDSet stLinkId;
			g_pDoc->LinkManager()->FindLinkByFrom(stLinkId, molipH);
			DWORDSet::const_iterator iId;
			for (iId = stLinkId.begin(); iId != stLinkId.end(); iId++)
			{
				// _xZkqqHx_iDiKiDjDiDeOiCpAiNoNiPjMiBeC_xHqqkZx_
				g_pDoc->CmdDelete1Link(stRedrawObj, *iId);
			}
		}
		ASSERT(wLinkKindFore != 0);

		// _xZkqqHx_jFjEjFgJ_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJjBfDiCmEiCmMiDiKiDjDiDeOiCpAiOoGjDlOiBeC_xHqqkZx_
		map<DWORD, DBLPoint> mpIdToOffset;
		DWORDSet stAffected;
		g_pDoc->LinkManager()->GetAffectedByTo(stAffected, FCMolipRec(molipH.dwObjID, -1));
		//----- _xZkqqHx_iDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCmMiCkEiClPiBeBiKhAjDhIiIoKjCoIiDiKiDjDiDeOiCmMiPoOjFpBiCpAiLeMiJkP_xHqqkZx_ -----
		DWORDSet::const_iterator iMi;
		for (iMi = stAffected.begin(); iMi != stAffected.end(); iMi++)
		{
			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iMi);
			if (pRec->m_wLinkKind == FDLM_LINK_ON_ANGLE)
			//----- _xZkqqHx_iKhAjDhIiIoKjCoIiDiCiDiKiDhGiCmMiPoKiNiH_xHqqkZx_ -----
			{
				if (pRec->m_mlpTo != molipH)
				//----- _xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhG_xHqqkZx_ != _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_H -----
				{
					// _xZkqqHx_iDiCiDiKiDhGiKnEiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
					mpIdToOffset[*iMi] = pRec->m_mmptOffset;	// _xZkqqHx_iDiKiDjDiDeOiMlDiCkJiCoHiDiKiDjDiDeOjAoGiCnGiCmMiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_
				}
			}
		}
		for (iMi = stAffected.begin(); iMi != stAffected.end(); iMi++)
		{
			const FCLinkRec* pRec = g_pDoc->LinkManager()->LinkIDtoLinkRec(*iMi);
			// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_H_xZkqqHx_iCmJiDiKiDjDiDeOiDeDiDjDiClHiCoJiDiKiDjDiDeOiCpAiNoNiPjMiBeC_xHqqkZx_
			if (pRec->m_mlpTo == molipH)
				g_pDoc->CmdDelete1Link(stRedrawObj, *iMi);
		}
		// _xZkqqHx_iPiHjFpLiMpMiDiKiDjDiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
		const DWORD dwLinkIdKH = g_pDoc->CmdAppend1Link(stRedrawObj, molipK, molipH, wLinkKindFore);
		// _xZkqqHx_iDiKiDjDiDeOiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLPoint mmptOffset = CalcLinkOffsetWhenMoveJoint(pObjH, lMolipIdH, pObjK, lMolipIdK, m_mmrtLastFrame.GetLeftTop(), wLinkKindFore);
		// _xZkqqHx_iDiKiDjDiDeOiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAiPeDjAlDiBeC_xHqqkZx_
		g_pDoc->CmdModify1LinkOffset(dwLinkIdKH, mmptOffset);
		// _xZkqqHx_iDiKiDjDiDeOjFhEiCkPjBnGiCkGjBePiCmMiDeJiDhEiDfKiDgCiDgHjCgMiCpAjBlMiCmMiDiKiDjDiDeOiCmJjAnNjCoIiBeC_xHqqkZx_
		map<DWORD, DBLPoint>::const_iterator iIo;
		for (iIo = mpIdToOffset.begin(); iIo != mpIdToOffset.end(); iIo++)
			g_pDoc->CmdModify1LinkOffset((*iIo).first, (*iIo).second);
		// _xZkqqHx_iDiKiDjDiDeOiMlDiCkKiInKjDkOiClFiClNiCmGiClFiCmEiBeBiJgFiLlPiCpAiOpDiCkPiCoJiKgFiDiCiDiKiDhGiCpAiInKjDkOiBeC_xHqqkZx_
		g_pDoc->LinkManager()->MovedNotify(pObjK);
		if (wLinkKindBack != 0)
		//----- _xZkqqHx_jBgPjFpLiMpMiDiKiDjDiDeOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iLhEjFpLiMpMiDiKiDjDiDeOiCpAiNoMjAkMiBeC_xHqqkZx_
			g_pDoc->CmdAppend1Link(stRedrawObj, molipH, molipK, wLinkKindBack);
		}

		//----- _xZkqqHx_iNmEjFgAiJoGjFjEjFgJiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		if (!stRedrawObj.empty())
			g_pView->AppendToLastRgn(stRedrawObj);

		// _xZkqqHx_iInKjDkOiMoDiDiKiBfLiDfHiDiHiDjDiCpAjAnNjCoIiBeC_xHqqkZx_
		AppendJointMovedRgn(GetHitXXX(XXX_JOINT).first, stJointIndex);
	} else
	{
		// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
		BASE_CLASS::StateDoMoveXXX(XXX_JOINT, pDC);
	}
	// _xZkqqHx_iLeMjIfOiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
	// _xZkqqHx_jFjEjFgJiCmMjBkOjAkLjFmPiNfIiCpAiDgDiBfLiDiLiCmJjCmKjCgNiClHiCoJiBeC_xHqqkZx_
	OnSelectObjModified();
	// _xZkqqHx_iDiKiBfLiDfHiDiHiDjDiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
//----- 06.10.13 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iDeKiDgJiDiBjDfPiCmMiDiKiDjDiDeOiDhBiDgCiDgHiCpAiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
	m_dwJointLinkKind = 0;
} // FCToolBasePolyEdit::StateDoMoveXXX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateContextMenuJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::StateContextMenuJoint (CDC* pDC)
{
	TRACE(_T("FCToolBasePolyEdit::StateContextMenuJoint\r\n"));
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCpAiDhMiDgCiDhGiDeBiDgCiDhGiBeCiDiBiDgKiDiFiBfLiPeJjHlJiOjOiCmJiDhMiDgCiDhGiDeBiDgCiDhGiPeJjHlJiDfCiDhNiDjDiDgIiCpAjBjHjAeNiBeC_xHqqkZx_
	PopupLinkMenu();
} // FCToolBasePolyEdit::StateContextMenuJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateJointLinkCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jIeBiMiLjDfPiDiKiDjDiDeOiDfCiDhNiDjDiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.09.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::StateJointLinkCommand (CDC* pDC)
{
	TRACE(_T("FCToolBasePolyEdit::StateJointLinkCommand\r\n"));
	// _xZkqqHx_iDiKiDjDiDeOiOoNiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dwJointLinkKind = CommandToLinkKind(m_dwCommand, m_lHitMolip == -1);
} // FCToolBasePolyEdit::StateJointLinkCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::StateWaitContextMenuJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiDiBiDgKiDiFiBfL_xHqqkZx___xZkqqHx_jIeBiMiLjDfPjBnCiClPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolBasePolyEdit::StateWaitContextMenuJoint (CDC* pDC)
{
	TRACE(_T("FCToolBasePolyEdit::StateWaitContextMenuJoint\r\n"));
} // FCToolBasePolyEdit::StateWaitContextMenuJoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::CommandToLinkKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PopupLinkMenu_xZkqqHx_iCmMiDiBiDgKiDiFiBfLiCkJiCoHiDiKiDjDiDeOiOoNiCpAiOoGjDlOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwCommand			:_xZkqqHx_jCkDiCoJiDiKiDjDiDeOiCmMiOoNjHnOiCpAiOkGiClHiDfCiDhNiDjDiDgI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsCenterMolipFrom	:_xZkqqHx_iDiKiDjDiDeOiMlDiCmMiDiCiDiKiDhGiCkKjCiGjAfDiDiCiDiKiDhGiCkJiBeIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiOoNiBeCiDiKiDjDiDeOiCpAiNoMjAkMiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ WORD(0)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiMlDiBeBiDiKiDjDiDeOjAoGiDiCiDiKiDhGiCkKjCiGjAfDiDiCiDiKiDhGiCkJiCmHiCkEiCkJiCpAiOhHjCoIiClHiCoJ_xHqqkZx_
 *			CommandToLinkKind_xZkqqHx_iKnGjAjEiCmJjBmOiClFiCmEiBeBiDiKiDjDiDeOiMlDiDiCiDiKiDhGiCmMiCnNiOhHjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiCmNiBeBiDgDiBfLiDiLiCmMiOoNjHnOiCmJiCoGiCmBiCmEjFmPiCoNiCoJiClNiCnPiBeBiDgDiBfLiDiL_xHqqkZx_
 *			_xZkqqHx_iCmJiClBiCmMiKnGjAjEiCmMiDgGiDhEiDeIiDiLiDgHiPiIjHjNiCpAiNhDiCoNiClJiCoJiClBiCmGiCmFiBeBiDgDiBfLiDiLiClCiCmGiCmM_xHqqkZx_
 *			_xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiOhHjCoIiCpAjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOoNjHnOiCkKjFmPiCoNiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCToolBasePolyEdit::CommandToLinkKind (DWORD dwCommand, BOOL bIsCenterMolipFrom)
{
	return CommandToLinkKindBoth(dwCommand, bIsCenterMolipFrom, FALSE);
} // FCToolBasePolyEdit::CommandToLinkKind.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolBasePolyEdit::CalcLinkOffsetWhenMoveJoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	ToolBasePolyEdit2.mdpf _xZkqqHx_iCmJiCkIiCkCiCmEiBeBjFjEjFgJ_xHqqkZx_H_xZkqqHx_iCmMjIeBiMiLjDfP_xHqqkZx_H_xZkqqHx_iCpAiInKjDkOiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDiCiDiKiDhG_xHqqkZx_K_xZkqqHx_iCmJiDiKiDjDiDeOiClHiCoJiBgJiDiKiDjDiDeOjFpLiMpMiCmN_xHqqkZx_K->H_xZkqqHx_iBgKiPoKiNiHiCmMiBeBiDiKiDjDiDeO_xHqqkZx_K->H_xZkqqHx_iCmM_xHqqkZx_
 *			_xZkqqHx_jDeLjAnIiCmIiDeJiDhEiDfKiDgCiDgHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObjH		:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMjFjEjFgJ_xHqqkZx_H_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdH	:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_H_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObjK		:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMjFjEjFgJ_xHqqkZx_K_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lMolipIdK	:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmMiDiCiDiKiDhG_xHqqkZx_K_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptH		:_xZkqqHx_iInKjDkOiMoDiCmM_xHqqkZx_H_xZkqqHx_iCmMiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wLinkKind	:ToolBasePolyEdit2.mdpf _xZkqqHx_iCmM_xHqqkZx_K->H_xZkqqHx_iCmMiDiKiDjDiDeOiOoNiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiDhEiDfKiDgCiDgHjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.10.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DBLPoint FCToolBasePolyEdit::CalcLinkOffsetWhenMoveJoint (	const FCObjDynabase* pObjH,
															long lMolipIdH,
															const FCObjDynabase* pObjK,
															long lMolipIdK,
															const DBLPoint& mmptH,
															WORD wLinkKind) const
{
	DBLPoint mmptOffset;
	if (wLinkKind == FDLM_LINK_ON_ANGLE)
	//----- mmptOffset_xZkqqHx_iCmNiKoOiPiAjApMiCmJjBmOiClHiCoJiKhAjDhIiCmGiLjHjHkD_xHqqkZx_ -----
	{
		mmptOffset.x = 0.0;
		if (lMolipIdH == pObjH->GetFrontEdgeMolipId())
			mmptOffset.y = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetFrontArrowAutoGap() : 0.0;
		else
		if (lMolipIdH == pObjH->GetBackEdgeMolipId())
			mmptOffset.y = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetBackArrowAutoGap() : 0.0;
		else
			mmptOffset.y = 0.0;
	} else
	{
		// _xZkqqHx_iDiCiDiKiDhG_xHqqkZx_K_xZkqqHx_iCmMiNmAjFfHiCpAiOoGjDlOiBeC_xHqqkZx_
		const DBLPoint mmptK = pObjK->GetMolipPos(lMolipIdK);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_K_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOoGjDlOiBeC_xHqqkZx_
		const DBLRect mmrtK = pObjK->GetResizeFrame();
		mmptOffset = FCLinkRec::CalcNewOffset(mmptK, mmrtK, mmptH, wLinkKind);
	}
	return mmptOffset;
} // FCToolBasePolyEdit::CalcLinkOffsetWhenMoveJoint.

