#ifndef __FCToolBezierArrow_h
#define __FCToolBezierArrow_h

#include "UtilBezier.h"		// For FCBezierControls.
#include "ToolBezier.h"		// For FCToolBezier.
#include "ToolArrowTmpl.h"	// For FCToolArrowTmpl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::InitNewObject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiClFiClNjFjEjFgJiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPiJiKpKiJlLiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<>
void FCToolArrowTmpl<FCToolBezier>::InitNewObject (FCObjDynabase* pObj) const
{
	// Superclass_xZkqqHx_jBkOjAkLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	BASE_CLASS::InitNewObject(pObj);
	// _xZkqqHx_jFjEjFgJiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	FCObjPoly* pPoly = (FCObjPoly*)pObj;
	if (m_pBgnHitObj != NULL || m_pEndHitObj != NULL)
		pPoly->SetLinkMoveType(FDOP_LMTYPE_AXIS);
	const long lJointSz = pPoly->GetJointSize();

	// ToolPolyArrow.mdrw _xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
	// _xZkqqHx_iKeKiOgOjDfPiBeBiPeJjHlJjDfPiCpAiInKjDkOiBeC_xHqqkZx_
	if (m_iBgnHitOn == FDPA_HIT_POL_MOLIP && m_dwBgnLinkKind == FDLM_LINK_ON_ANGLE)
	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
	{
		if (abouteq(m_mmptBgnHitPos, pPoly->GetJoint(0).m_mmptPivot))
		{
			FCBezierControls bc;
			bc.A() = pPoly->GetJoint(0).m_mmptPivot;
			bc.B() = pPoly->GetJoint(0).m_mmptPivot + pPoly->GetJoint(0).m_mmptNext;
			bc.C() = pPoly->GetJoint(1).m_mmptPivot + pPoly->GetJoint(1).m_mmptPrev;
			bc.D() = pPoly->GetJoint(1).m_mmptPivot;
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (m_pBgnHitObj->CalcMolipCrossedControlPoint(bc, g_pReg->GetFrontArrowAutoGap(), m_lBgnHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			const mmetol mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetFrontArrowAutoGap() : 0.0;
			if (m_pBgnHitObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lBgnHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				// _xZkqqHx_iDhDiDhLiDgCiDgHiBeBjBePiIpIjDfPiBeBiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
				pPoly->GetJoint(0).m_mmptPivot = bc.A();
				pPoly->GetJoint(0).m_mmptNext = bc.B() - bc.A();
				pPoly->GetJoint(1).m_mmptPrev = bc.C() - bc.D();
			}
		}
	}
	if (m_iEndHitOn == FDPA_HIT_POL_MOLIP && m_dwEndLinkKind == FDLM_LINK_ON_ANGLE)
	//----- _xZkqqHx_jApMiDiCiDiKiDhGiCmMjCiGiJjLjDfPiDiCiDiKiDhGiCmJiDhBiDgCiDgH_xHqqkZx_ -----
	{
		if (abouteq(m_mmptEndHitPos, pPoly->GetJoint(lJointSz - 1).m_mmptPivot))
		{
			FCBezierControls bc;
			bc.A() = pPoly->GetJoint(lJointSz - 1).m_mmptPivot;
			bc.B() = pPoly->GetJoint(lJointSz - 1).m_mmptPivot + pPoly->GetJoint(lJointSz - 1).m_mmptPrev;
			bc.C() = pPoly->GetJoint(lJointSz - 2).m_mmptPivot + pPoly->GetJoint(lJointSz - 2).m_mmptNext;
			bc.D() = pPoly->GetJoint(lJointSz - 2).m_mmptPivot;
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			if (m_pEndHitObj->CalcMolipCrossedControlPoint(bc, g_pReg->GetBackArrowAutoGap(), m_lEndHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			const mmetol mmArrowAutoGap = g_pReg->GetIsArrowAutoGap() ? g_pReg->GetBackArrowAutoGap() : 0.0;
			if (m_pEndHitObj->CalcMolipCrossedControlPoint(bc, mmArrowAutoGap, m_lEndHitMolip))
//----- 06.10.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			{
				// _xZkqqHx_iDhDiDhLiDgCiDgHiBeBjBePiIpIjDfPiBeBiMoDiIpIjDfPiCpAjAnNjCoIiBeC_xHqqkZx_
				pPoly->GetJoint(lJointSz - 1).m_mmptPivot = bc.A();
				pPoly->GetJoint(lJointSz - 1).m_mmptPrev = bc.B() - bc.A();
				pPoly->GetJoint(lJointSz - 2).m_mmptNext = bc.C() - bc.D();
			}
		}
	}
} // FCToolArrowTmpl<FCToolBezier>::InitNewObject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolArrowTmpl<SUPER>::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<>
HCURSOR FCToolArrowTmpl<FCToolBezier>::GetDefaultIdleCursor () const
{
//----- 05.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_bControlInvert)
//		return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_BEZIER_ARROW);
//	else
//		return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_BEZILINE);
//----- 05.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_BEZIER_ARROW);
//----- 05.04.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolArrowTmpl<FCToolBezier>::GetDefaultIdleCursor.

#endif//__FCToolBezierArrow_h
