#include "stdafx.h"
#include "DynamicDraw.h"
#include <math.h>				// For sin, cos.
#include "FrameWnd.h"			// For FFGetMainWnd().
#include "DynamicDrawView.h"	// For AppendToLastRgn. etc..
#include "FoundDoc.h"			// For g_pDoc.
#include "ObjDynabase.h"			// For GetResizeFrame.
#include "UtilCoord.h"			// For mm2lg.etc.
#include "UtilMisc.h"			// For HitTest.
#include "UtilErr.h"			// For FFThrowMiscUnknown.
#include "UtilGraph.h"			// For FCEditDraw.
#include "UtilStr.h"			// For FFLoadWString.
#include "RegData.h"			// For GetOptiRegColor.
#include "LinkManager.h"		// For g_pDoc->LinkManager().
#include "PursuerText.h"		// For CFCPursuerText.
#include "ToolRotate.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// 02.12.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//FCToolRotate	g_toolRotate;

#define FDRT_EACH_CROSS_LEN 10
#define FDRT_ALL_CROSS_LEN 100

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDynamicDrawView::mySnapR
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCpA_xHqqkZx_0.05_xZkqqHx_iNiPiCnNiCmFiDfIiDgJiDgCiDhGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR	:_xZkqqHx_jFmPiKlHiClHiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiKlHiMoDiCmMiKhAjDhIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static double mySnapR (double dR)
{
	if (!g_pReg->GetIsSnap()) return dR;
// 05.04.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	dR = double(D2L(dR / 0.05)) * 0.05;
	dR = double(D2L(dR / g_pReg->GetSnapAngle())) * g_pReg->GetSnapAngle();
	return dR;
} // mySnapR.

/////////////////////////////////////////////////////////////////////////
// FCRotElem _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::FCRotElem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCRotElem::FCRotElem ()
{
	m_dAngle = 0.0;				// _xZkqqHx_iJpBjDfNiKhAjDhIiBeC_xHqqkZx_
	m_mmptCenter.SetPoint(0,0);	// _xZkqqHx_iJpBjDfNiCmMjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
	m_mmHalfWidth = 0.0;		// _xZkqqHx_iJpBjDfNjBePiLoJiMgAiCmMjFjN_xHqqkZx_/2_xZkqqHx_iBeC_xHqqkZx_
	m_mmHalfHeight = 0.0;		// _xZkqqHx_iJpBjDfNjBePiLoJiMgAiCmMiNiC_xHqqkZx_/2_xZkqqHx_iBeC_xHqqkZx_
} // FCRotElem::FCRotElem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::FCRotElem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPiJiKpKiJlLjHhAiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCRotElem::FCRotElem (const FCObjDynabase* pObj)
{
	Init(pObj);
} // FCRotElem::FCRotElem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::Init
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPiJiKpKiJlLjHhAiCmMjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRotElem::Init (const FCObjDynabase* pObj)
{
	DBLRect mmrtInn = pObj->GetResizeFrame();
	m_dAngle = 0.0;
	m_mmptCenter	= mmrtInn.CenterPoint();
	m_mmHalfWidth	= mmrtInn.Width() / 2.0;
	m_mmHalfHeight	= mmrtInn.Height() / 2.0;
} // FCRotElem::Init.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::Update
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjCgMiCmFiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCRotElem::Update (const FCObjDynabase* pObj)
{
	DBLRect mmrtInn = pObj->GetResizeFrame();
	DBLPoint mmptCenter	= mmrtInn.CenterPoint();
	mmetol mmHalfWidth	= mmrtInn.Width() / 2.0;
	mmetol mmHalfHeight	= mmrtInn.Height() / 2.0;
	// _xZkqqHx_jCgMiCmJjFmPiNfIiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (almosteq(m_mmptCenter, mmptCenter) &&
		almosteq(m_mmHalfWidth, mmHalfWidth) &&
		almosteq(m_mmHalfHeight, mmHalfHeight)) return FALSE;
	m_mmptCenter	= mmptCenter;
	m_mmHalfWidth	= mmHalfWidth;
	m_mmHalfHeight	= mmHalfHeight;
	return TRUE;
} // FCRotElem::Update.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::Rotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCpAjCiGjAfDiCmJiJpBjDfNjFmPiKlHiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dRot		:_xZkqqHx_iJpBjDfNiClHiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmptCenter	:_xZkqqHx_iJpBjDfNiClHiCoJjCiGjAfDiNmAjFfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRotElem::Rotate (double dRot, const DBLPoint& mmptCenter)
{
	::RotateConv(m_mmptCenter, sin(dRot * M_PI), cos(dRot * M_PI), mmptCenter);
	m_dAngle = ::RegulateAngle(m_dAngle + dRot);
} // FCRotElem::Rotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::Move
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiLjHjHkDiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptMove	:_xZkqqHx_iInKjDkOiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRotElem::Move (const DBLPoint& mmptMove)
{
	m_mmptCenter += mmptMove;
} // FCRotElem::Move.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::Calc4RotMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNiDhNiBfLiDeOiCfDjDfPiCmMiNmAjFfHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpta	:_xZkqqHx_iCfDjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeCiOpDiCkPiOoGiCoJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRot	:_xZkqqHx_iNkBiCmMiKhAjDhIiCmJiJmBiOfKiClHiCoJiKhAjDhIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCRotElem::Calc4RotMark (DBLPoint mmpta[], double dRot) const
{
	const double dSin = sin((m_dAngle + dRot) * M_PI);
	const double dCos = cos((m_dAngle + dRot) * M_PI);
	// _xZkqqHx_iKgFiDhNiBfLiDeOiCmMiOmAiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptHorz = DBLPoint(m_mmHalfWidth, 0.0).RotatePoint(dSin, dCos);
	DBLPoint mmptVert = DBLPoint(0.0, m_mmHalfHeight).RotatePoint(dSin, dCos);
	//----- _xZkqqHx_jFjEjFgJiCpAiImNiCnOiJpBjDfNjHhAiDhNiBfLiDeOiCpAiMhGiOfK_xHqqkZx_ -----
	mmpta[0] = m_mmptCenter - mmptHorz - mmptVert;	// _xZkqqHx_iNlGiPoDiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
	mmpta[1] = m_mmptCenter + mmptHorz - mmptVert;	// _xZkqqHx_iJeFiPoDiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
	mmpta[2] = m_mmptCenter + mmptHorz + mmptVert;	// _xZkqqHx_iJeFiJlKiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
	mmpta[3] = m_mmptCenter - mmptHorz + mmptVert;	// _xZkqqHx_iNlGiJlKiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
} // FCRotElem::Calc4RotMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCRotElem::Calc5RotMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNiDhNiBfLiDeOiCfDjDfPiCmMiNmAjFfHiCpAiMhGiOfKiClHiCoJiBeCiCfEjDfPjGnKiCmNiCfAjDfPjGnKiCmGjDkPiClGiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lgpta	:_xZkqqHx_iCfEjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeCiOpDiCkPiOoGiCoJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRot	:_xZkqqHx_iNkBiCmMiKhAjDhIiCmJiJmBiOfKiClHiCoJiKhAjDhIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDfPiCmMjAjEiCpAjFnEiClHiBeCiNmFjBoFiCmFiCoAiCfEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOoFiCmJjFgAiJoGjHhAiCmJiOgHjHhAiClHiCoJiBeCiClBiCmMiClNiCnPiBeBiCfEjDfPjGnKiCkKjFeLjHhGiBeC_xHqqkZx_
 *			_xZkqqHx_jDkPiClGiNmAjFfHiCmMiPoKiNiHiCmNiBeBiClLiCmMjDfPiCmNiPmIjHkKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.03.11 Fukushiro M. _xZkqqHx_jCgMiCpAjFnEiClHiCoGiCkEiCmJiNfIjAfGiBeC_xHqqkZx_
 *************************************************************************/
int FCRotElem::Calc5RotMark (CPoint lgpta[], double dRot) const
{
	const double dSin = sin((m_dAngle + dRot) * M_PI);
	const double dCos = cos((m_dAngle + dRot) * M_PI);
	// _xZkqqHx_iKgFiDhNiBfLiDeOiCmMiOmAiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptHorz = DBLPoint(m_mmHalfWidth, 0.0).RotatePoint(dSin, dCos);
	DBLPoint mmptVert = DBLPoint(0.0, m_mmHalfHeight).RotatePoint(dSin, dCos);
	//----- _xZkqqHx_jFjEjFgJiCpAiImNiCnOiJpBjDfNjHhAiDhNiBfLiDeOiCpAiMhGiOfK_xHqqkZx_ -----
	CPoint lgptaMy[4];
	lgptaMy[0] = mm2lg(m_mmptCenter - mmptHorz - mmptVert);	// _xZkqqHx_iNlGiPoDiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
	lgptaMy[1] = mm2lg(m_mmptCenter + mmptHorz - mmptVert);	// _xZkqqHx_iJeFiPoDiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
	lgptaMy[2] = mm2lg(m_mmptCenter + mmptHorz + mmptVert);	// _xZkqqHx_iJeFiJlKiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
	lgptaMy[3] = mm2lg(m_mmptCenter - mmptHorz + mmptVert);	// _xZkqqHx_iNlGiJlKiDhNiBfLiDeOiCmMiNmAjFfHiBeC_xHqqkZx_
	//----- _xZkqqHx_jDkPiClGjCgMiCpAiNgMjHlGiClFiCmIiCkKiCoHiBeBjFnEiClFjHhAjFmPjAjEiCmJjCgMiCpAjBoDjDpM_xHqqkZx_ -----
	int iCount = 0;
	lgpta[iCount++] = lgptaMy[0];
	if (lgptaMy[1] != lgptaMy[0]) lgpta[iCount++] = lgptaMy[1];
	if (lgptaMy[2] != lgptaMy[1]) lgpta[iCount++] = lgptaMy[2];
	if (lgptaMy[3] != lgptaMy[2] &&
		lgptaMy[3] != lgptaMy[0]) lgpta[iCount++] = lgptaMy[3];
	if (iCount == 4) lgpta[iCount++] = lgptaMy[0];
	return iCount;
} // FCRotElem::Calc5RotMark.

/////////////////////////////////////////////////////////////////////////
// FCToolRotate _xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::FCToolRotate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 05.06.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//FCToolRotate::FCToolRotate () : BASE_CLASS(FDOZ_ON_EDIT)
FCToolRotate::FCToolRotate ()
{
} // FCToolRotate::FCToolRotate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::OnSelectObjModified
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiCmFjBeJjBpAjCiGiCmMjFjEjFgJiCkKiBeBiDgDiBfLiDiLiImIiKePiCmMiPoKiPiKiCmFiPeDjAlDiClDiCoKiClNiPoKiNiHiCmJ_xHqqkZx_
 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeCjFnCiPfHjHhAiDhNiBfLiDeOiCmMiNmEjFgAiJoGiCmMjFeLjHhGiCmNjGlDiCkCiBgJjFmKjDhCiMmEiCmOiCoKiCoJiInHiBgKiBeC_xHqqkZx_
 *			_xZkqqHx_iDgDiBfLiDiLjCiGiCmJjFjEjFgJiCmMjBkOjAkLiCpAiOmKiClFiOjNiCmBiCmEiCkCiCoJiPoKiNiHiCmNiBeBjFjEjFgJiCmJiNiHiCoNiClJiCmE_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDhGiDiNiDhAiDgFiDeCiCmFjFjEjFgJiCmMjBkOjAkLiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::OnSelectObjModified ()
{
	BOOL bModified = FALSE;
	FTRotElemMap::iterator iEm;
	for (iEm = m_mpRotElem.begin(); iEm != m_mpRotElem.end(); iEm++)
		if ((*iEm).second.Update((*iEm).first)) bModified = TRUE;
	if (bModified)
	//----- _xZkqqHx_iIoKiCmCiCmFiCoAiBeBjBeJjBpAjFjEjFgJiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBfDiCmEiCmMjBeJjBpAjCiGjAhNiMgAiCmMiJpBjDfNiKoOiPiAiKhAjDhIiCpA_xHqqkZx_0_xZkqqHx_iCmJiDiKiDfKiDgCiDgHiBeC_xHqqkZx_
		for (iEm = m_mpRotElem.begin(); iEm != m_mpRotElem.end(); iEm++)
			(*iEm).second.m_dAngle = 0.0;
		// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiCmMjCiGjAfDiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
		CalcAllCenter();
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSelectObjModified();
} // FCToolRotate::OnSelectObjModified.

//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::OnDraw
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
// *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCToolRotate::OnDraw (CDC* pDC)
////void FCToolRotate::OnDraw (CDC* pDC, const DBLRect* pmmrtRgn, long lRgnSize)
//{
//	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOjFgAiJoGiBeC_xHqqkZx_
//	DrawAllRotMark(pDC);
//	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
//	switch (GetCurrentState())
//	{
//	case STATE_EACH_ROTING:			// _xZkqqHx_iMmCjFmKiJpBjDfNjCiGiBeC_xHqqkZx_
//	  {
//		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//		FCEditDraw eDraw(pDC, 0);
//		CPoint lgpta4[5];
//		// _xZkqqHx_iJpBjDfNiMoDiCmMiCfDjDfPiCpAiMhGiOfKiClFiBeBjFgAiJoGiBeC_xHqqkZx_
//		int iCount = m_HitEachElem.Calc5RotMark(lgpta4, m_dMoveR);
//		eDraw.Polyline(lgpta4, iCount);
//		break;
//	  }
//	case STATE_ALL_ROTING:			// _xZkqqHx_jBfDjBmMiJpBjDfNjCiGiBeC_xHqqkZx_
//		// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOjFgAiJoGiBeC_xHqqkZx_
//		DrawAllRotMark(pDC, m_dMoveR);
//		break;
//	}
//	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
//	BASE_CLASS::OnDraw(pDC);
//} // FCToolRotate::OnDraw.
//----- 06.12.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::Select
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiClDiCoKiClNiCmGiCkLiBeBiDfCiBfLiDiLiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	: CDC*
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::Select (CDC* pDC)
{
	//----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	m_dAllAngle = 0.0;		// _xZkqqHx_jBfDjBmMiJpBjDfNiCmMiKhAjDhIiBeC_xHqqkZx_BASE_CLASS::Select_xZkqqHx_iCkJiCoHiMmEiCmOiCoKiCoJ_xHqqkZx_
							// OnDraw_xZkqqHx_iCmFiOgHjHhAiClDiCoKiCoJiClNiCnPiBeBjAoGiCmJiPiJiKpKiJlLiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	m_pHitEachObj = NULL;	// _xZkqqHx_iMmCjFmKiJpBjDfNiCmMiDhBiDgCiDgHjFjEjFgJiBeC_xHqqkZx_
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::Select(pDC);
} // FCToolRotate::Select.

//----- 05.06.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::CanSelectTool
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDgDiBfLiDiLiCkKjBeJjBpAiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeJjBpAiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCToolRotate::CanSelectTool () const
//{
//	// _xZkqqHx_jFjEjFgJiCkKjFnCiPfHiJmCjEfMiCmFiCmNjGlDiCkCiPoKiNiHiCmNjFhDiJmCiBeCiBeC_xHqqkZx_
//	if (!FFCanEditObject()) return FALSE;
//	return TRUE;
//} // FCToolRotate::CanSelectTool.
//----- 05.06.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::DrawSelectMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMjFfMiOkGiOjOiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBgJjEpBjFfMiOkGiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jFfMiOkGiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::DrawSelectMark (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFjEjFgJiCkKjHiIiCmIiCkCiPoKiNiHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	ASSERT(m_mpRotElem.find(pObj) != m_mpRotElem.end());
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	FCRotElem& elem = m_mpRotElem[pObj];
	// _xZkqqHx_jCiGjAfDjDfPiCmMjIfPjHjNiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	CPoint lgptCntr = mm2lg(elem.m_mmptCenter);
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jCiGjAfDjDfPiCmJiPfMjFlGiOjKiCpAjFgAiJoGiBeC_xHqqkZx_
//	eDraw.Line(&CPoint(lgptCntr.x, lgptCntr.y - FDRT_EACH_CROSS_LEN), 
//				&CPoint(lgptCntr.x, lgptCntr.y + FDRT_EACH_CROSS_LEN));
//	eDraw.Line(&CPoint(lgptCntr.x - FDRT_EACH_CROSS_LEN, lgptCntr.y), 
//				&CPoint(lgptCntr.x + FDRT_EACH_CROSS_LEN, lgptCntr.y));
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jCiGjAfDjDfPiCmJiBhOjFlGiOjKiCpAjFgAiJoGiBeC_xHqqkZx_
	eDraw.Line(	&CPoint(lgptCntr.x - FDRT_EACH_CROSS_LEN, lgptCntr.y - FDRT_EACH_CROSS_LEN), 
				&CPoint(lgptCntr.x + FDRT_EACH_CROSS_LEN, lgptCntr.y + FDRT_EACH_CROSS_LEN));
	eDraw.Line(	&CPoint(lgptCntr.x - FDRT_EACH_CROSS_LEN, lgptCntr.y + FDRT_EACH_CROSS_LEN), 
				&CPoint(lgptCntr.x + FDRT_EACH_CROSS_LEN, lgptCntr.y - FDRT_EACH_CROSS_LEN));
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iKgFiDhNiBfLiDeOiImKjChFiCmJiLoJiMgAiCpAjFgAiJoG_xHqqkZx_ -----
	// _xZkqqHx_iKgFiDhNiBfLiDeOiCmMjIfPjHjNiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	CPoint lgpta[5];
	int iCount = elem.Calc5RotMark(lgpta);
	if (iCount == 5) iCount--;
	for (int iC = 0; iC < iCount; iC++)
		eDraw.GeneralMark(lgpta[iC]);
} // FCToolRotate::DrawSelectMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::OnAppendSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::AppendSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::OnAppendSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFjEjFgJiCkKjHiIiCoJiPoKiNiHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	ASSERT(m_mpRotElem.find(pObj) == m_mpRotElem.end());
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDeLiDeDiDgIjApMiCpAiPmBiLiOiBeC_xHqqkZx_
	if (pDC != NULL) DrawAllRotMark(pDC);
	// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
	m_mpRotElem[pObj] = FCRotElem(pObj);
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiCmMjCiGjAfDiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
	CalcAllCenter();
	// _xZkqqHx_jFfMiOkGiClFiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (pDC == NULL) return;
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDeLiDeDiDgIjApMiCpAjFfMiOkGiBeC_xHqqkZx_
	DrawAllRotMark(pDC);
	// _xZkqqHx_jFjEjFgJiCmMjBeJjBpAiDhNiBfLiDeOiCpAjFfMiOkGiBeC_xHqqkZx_
	DrawSelectMark(pDC, pObj);
} // FCToolRotate::OnAppendSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::OnRemoveSelectObj
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCpAjEpBjBeJjBpAiPpDjBnEiCmJiClHiCoJiBeCiDgDiBfLiDiLiCkKjDmGiOkJiCmMiDgFiBfLiDhFiDiLiCmF_xHqqkZx_
 *			_xZkqqHx_jBeJjBpAjFjEjFgJiCpAiKmHjHjNiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiClLiClBiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iJoGjGmKjFfMiOkGiCpAjEpBjBeJjBpAiPpDjBnEiCmJjFmPiNfIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiBeCjFfMiOkGjFmPiNfIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *			pObj:_xZkqqHx_jBeJjBpAiClHiCoJjFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	CFCDynamicDrawView::RemoveSelectObj_xZkqqHx_iCkJiCoHiCmMjAoKjHhAiKnGjAjEiBeC_xHqqkZx_
 *			CFCDynamicDrawView_xZkqqHx_iCmMjBeJjBpAiDgFiBfLiDhFiDiLiCmNjFmPiNfIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::OnRemoveSelectObj (CDC* pDC, FCObjDynabase* pObj)
{
	// _xZkqqHx_jDgPjIfOiNmPiCnNjFjEjFgJiCkKjHiIiCmIiCkCiPoKiNiHiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	ASSERT(m_mpRotElem.find(pObj) != m_mpRotElem.end());
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDeLiDeDiDgIjApMiCpAiPmBiLiOiBeC_xHqqkZx_
	if (pDC != NULL) DrawAllRotMark(pDC);
	// _xZkqqHx_jFfMiOkGiClHiCoJiPoKiNiHiCmNjBeJjBpAiDhNiBfLiDeOiCpAjEpBjFfMiOkGiBeC_xHqqkZx_
	if (pDC != NULL) DrawSelectMark(pDC, pObj);
	// _xZkqqHx_jDgPjIfOiCpAjGjFiPmBiBeC_xHqqkZx_
	m_mpRotElem.erase(pObj);
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiCmMjCiGjAfDiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
	CalcAllCenter();
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDeLiDeDiDgIjApMiCpAjFfMiOkGiBeC_xHqqkZx_
	if (pDC != NULL) DrawAllRotMark(pDC);
} // FCToolRotate::OnRemoveSelectObj.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::CanHandle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjFjEjFgJiCkKiClBiCmMiDgDiBfLiDiLiCmFiIlFiCkGiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBjFhDiJmCjEfMiCmMiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolRotate::CanHandle (const FCObjDynabase* pObj) const
{
	// pObj _xZkqqHx_iCkKiBeBjFnCiPfHiJmCjEfMiCmIiDiMiDeDiDiEiBfLiCmJjBkOiClDiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (!g_pDoc->CanDoOnObject(pObj, FDOZ_ON_EDIT)) return FALSE;
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	return BASE_CLASS::CanHandle(pObj);
} // FCToolRotate::CanHandle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::CalcAllCenter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNiPiIjHjNiCmMiInHiCmMjCiGjAfDiNmAjFfHiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	m_mmptAllCenter_xZkqqHx_iCpAiNfIjAfGiClHiCoJiBeCiCnMiClNiBeBjFjEjFgJiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ m_dAllAngle
 *			_xZkqqHx_iCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::CalcAllCenter ()
{
	// _xZkqqHx_jFjEjFgJiCkKiCfBiMmCiImIiPoDiCmFiCmIiCkCiCmGjBfDjBmMiJpBjDfNiCmNiCmIiCkCiBeC_xHqqkZx_
	if (m_mpRotElem.empty())
	{
		// _xZkqqHx_jBeJjBpAjCiGiCmMjFjEjFgJiCkKiLpDiCmJiCmIiCmBiClNiOjOiCmNiBeBjBfDjBmMiCmMiJpBjDfNiKhAjDhIiCoAiCePiCmJiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		m_dAllAngle = 0.0;		// _xZkqqHx_jBfDjBmMiJpBjDfNiCmMiKhAjDhIiBeC_xHqqkZx_
		return;
	}
	FTRotElemMap::const_iterator iEm = m_mpRotElem.begin(); 
	// _xZkqqHx_iNmFiPiJiCmMiLoJiMgAjCiGjAfDiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	DBLRect mmrtOut((*iEm).second.m_mmptCenter, (*iEm).second.m_mmptCenter);
	// _xZkqqHx_jBfDjFjEjFgJiCmMjCiGjAfDjDfPiCmJiKePjAnKiClHiCoJiDhEiDiMiBfLiDiAiCpAiOfKiPgPiBeC_xHqqkZx_
	for (; iEm != m_mpRotElem.end(); iEm++)
	{
		::SmallerOrLarger(mmrtOut.left, mmrtOut.right, (*iEm).second.m_mmptCenter.x);
		::SmallerOrLarger(mmrtOut.top, mmrtOut.bottom, (*iEm).second.m_mmptCenter.y);
	}
	// _xZkqqHx_jBfDjBmMiJpBjDfNiCmMjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
//----- 00.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	m_mmptAllCenter.x = (mmrtOut.left + mmrtOut.right) / 2.0;
//	m_mmptAllCenter.y = (mmrtOut.top + mmrtOut.bottom) / 2.0;
//----- 00.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	m_mmptAllCenter = mmrtOut.CenterPoint();
//----- 00.03.11 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::CalcAllCenter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::Calc4RotMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiCmMiJpBjDfNiDhNiBfLiDeOiCfDjDfPiCmMiNmAjFfHiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpta	:_xZkqqHx_iCfDjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeCiOpDiCkPiOoGiCoJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRot	:_xZkqqHx_iNkBiCmMiKhAjDhIiCmJiJmBiOfKiClHiCoJiKhAjDhIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iImIiJlKiCmNiBeB_xHqqkZx_m_dAllAngle + dRot = 0.0 _xZkqqHx_iCmMiPoKiNiHiCmMjHoBiBeC_xHqqkZx_
 *
 *                            mmpta[3]
 *                             _xZkqqHx_iEkL_xHqqkZx_
 *                             _xZkqqHx_iEkL_xHqqkZx_
 *                             _xZkqqHx_iEkL_xHqqkZx_  m_mmptAllCenter
 *                             _xZkqqHx_iEkL_xHqqkZx_  _xZkqqHx_iBfO_xHqqkZx_
 *                             _xZkqqHx_iEkLiBfO_xHqqkZx_
 *        mmpta[2] _xZkqqHx_iEkKiEkKiEkKiEkKiEkKiEkKiElEiEkKiEkKiEkKiEkKiEkKiEkK_xHqqkZx_ mmpta[0]
 *                             _xZkqqHx_iEkL_xHqqkZx_
 *                             _xZkqqHx_iEkL_xHqqkZx_
 *                             _xZkqqHx_iEkL_xHqqkZx_
 *                             _xZkqqHx_iEkL_xHqqkZx_
 *                             _xZkqqHx_iEkL_xHqqkZx_
 *                            mmpta[1]
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::Calc4RotMark (DBLPoint mmpta[], double dRot) const
{
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKiCfBiMmCiImIiPoDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
//	if (m_mpRotElem.size() < 2) FFThrowMiscUnknown();
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKiCfAiMmCiImIiPoDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (m_mpRotElem.empty()) FFThrowMiscUnknown();
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	const mmetol mmCrossLen = lg2mm(FDRT_ALL_CROSS_LEN);
	const double dSin = sin((m_dAllAngle + dRot) * M_PI);
	const double dCos = cos((m_dAllAngle + dRot) * M_PI);
	// _xZkqqHx_iKgFiDhNiBfLiDeOiCmMiOmAiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	const DBLPoint mmptHorz = DBLPoint(mmCrossLen, 0.0).RotatePoint(dSin, dCos);
	const DBLPoint mmptVert = DBLPoint(0.0, mmCrossLen).RotatePoint(dSin, dCos);
	mmpta[0] = m_mmptAllCenter + mmptHorz;
	mmpta[1] = m_mmptAllCenter + mmptVert;
	mmpta[2] = m_mmptAllCenter - mmptHorz;
	mmpta[3] = m_mmptAllCenter - mmptVert;
} // FCToolRotate::Calc4RotMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::CheckHitEachRotMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCiBfIiCmMjFjEjFgJiCmMiJpBjDfNjHhAiDhNiBfLiDeOiPoDiCmJiDhNiDeFiDfIiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_HitEachElem_xZkqqHx_iBeB_xHqqkZx_m_dHitEachAngle _xZkqqHx_iCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolRotate::CheckHitEachRotMark ()
{
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmMjIfPjHjNiNmAjFfHiCpAiMhGiOfKiBeC_xHqqkZx_
//	const CPoint lgptMsc = mm2lg(m_mmptMsc);
//	// _xZkqqHx_iDhNiDeFiDfIiCkKjBeJjBpAjCiGiCmMiCkCiClIiCoKiCkJiCmMjFjEjFgJiCmMiJpBjDfNiDhNiBfLiDeOiPoDiCmFiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJjClCiCnHiCoJiBeC_xHqqkZx_
//	FTRotElemMap::const_iterator iEm;
//	for (iEm = m_mpRotElem.begin(); iEm != m_mpRotElem.end(); iEm++)
//	{
//		const FCRotElem& elem = (*iEm).second;
//		// _xZkqqHx_iJpBjDfNiMoDiCmMiCfDjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
//		DBLPoint mmpta4[4];
//		elem.Calc4RotMark(mmpta4);
//		// _xZkqqHx_iCfDjDfPiCmMiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//		for (int i = 0; i != 4; i++)
//			if (::HitTest(mm2lg(mmpta4[i]), lgptMsc))
//			{
//				m_HitEachElem = elem;
//				m_dHitEachAngle = ::ArcTan(mmpta4[i] - elem.m_mmptCenter);
//				return TRUE;
//			}
//	}
//	// _xZkqqHx_iDhBiDgCiDgHiClFiCmIiCkJiCmBiClNiBeC_xHqqkZx_
//	return FALSE;
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	m_pHitEachObj = NULL;
	m_HitEachElem = FCRotElem();
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClHiCoJjFnCiPfHiDgOiDjDiDgIiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	set<FCHandleId> stIds;
	CheckHitHandle(stIds, m_mmptMsc);
	// _xZkqqHx_iDgOiDjDiDgIiDiLiCkKiIoKiCmCiCoAiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (stIds.empty()) return FALSE;
	// _xZkqqHx_jBfDjBmMiDgOiDjDiDgIiDiLiCmMiCnNiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if ((*stIds.rbegin()).first == -1) return FALSE;
	// _xZkqqHx_jFjEjFgJiCpAiOoGjDlOiBeC_xHqqkZx_
	m_pHitEachObj = g_pDoc->ObjID2Object((*stIds.rbegin()).first);
	m_HitEachElem = m_mpRotElem[m_pHitEachObj];
	// _xZkqqHx_iJpBjDfNiMoDiCmMiCfDjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
	DBLPoint mmpta4[4];
	m_HitEachElem.Calc4RotMark(mmpta4);
	m_dHitEachAngle = ::ArcTan(mmpta4[(*stIds.rbegin()).second] - m_HitEachElem.m_mmptCenter);
	return TRUE;
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::CheckHitEachRotMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::CheckHitAllRotMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMjFjEjFgJiCmMiJpBjDfNjHhAiDhNiBfLiDeOjApMiPoDiCmJiDhNiDeFiDfIiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPjFmPjAjE_xHqqkZx_ m_dHitAllAngle _xZkqqHx_iCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolRotate::CheckHitAllRotMark ()
{
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKiCfBiMmCiImIiPoDiCmFiCmIiCkCiCmGjBfDjBmMiJpBjDfNiCmNiCmIiCkCiBeC_xHqqkZx_
//	if (m_mpRotElem.size() < 2) return FALSE;
//	// _xZkqqHx_iCnMiClIiBeBiDhNiDeFiDfIiNmAjFfHiCpAjBfDjBmMiJpBjDfNiKhAjFkKiLhEiJpBjDfNiClHiCoJiBeC_xHqqkZx_
//	DBLPoint mmptMsc = m_mmptMsc;
//	::RotateConv(mmptMsc, sin(-m_dAllAngle * M_PI), cos(-m_dAllAngle * M_PI),
//				 m_mmptAllCenter);
//	CPoint lgptMsc = mm2lg(mmptMsc);
//
//	// _xZkqqHx_jBfDjBmMiJpBjDfNiCmMjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
//	CPoint lgptCenter = mm2lg(m_mmptAllCenter);
//	if (::HitTest1(lgptCenter.y, lgptMsc.y))
//	{
//		if (lgptCenter.x <= lgptMsc.x &&
//							lgptMsc.x <= lgptCenter.x + FDRT_ALL_CROSS_LEN)
//		//----- _xZkqqHx_iCePjDhIiOlCiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			m_dHitAllAngle = m_dAllAngle;
//			return TRUE;
//		}
//		if (lgptCenter.x - FDRT_ALL_CROSS_LEN <= lgptMsc.x &&
//												 lgptMsc.x <= lgptCenter.x)
//		//----- _xZkqqHx_iCfAiCfHiCePjDhIiOlCiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			m_dHitAllAngle = ::RegulateAngle(m_dAllAngle + 1.0);
//			return TRUE;
//		}
//	}
//	if (::HitTest1(lgptCenter.x, lgptMsc.x))
//	{
//		if (lgptCenter.y <= lgptMsc.y &&
//							lgptMsc.y <= lgptCenter.y + FDRT_ALL_CROSS_LEN)
//		//----- _xZkqqHx_iCfIiCePjDhIiOlCiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			m_dHitAllAngle = ::RegulateAngle(m_dAllAngle + 0.5);
//			return TRUE;
//		}
//		if (lgptCenter.y - FDRT_ALL_CROSS_LEN <= lgptMsc.y &&
//												 lgptMsc.y <= lgptCenter.y)
//		//----- _xZkqqHx_iCfBiCfGiCePjDhIiOlCiCmJiDhBiDgCiDgHiClFiClNiPoKiNiH_xHqqkZx_ -----
//		{
//			m_dHitAllAngle = ::RegulateAngle(m_dAllAngle + 1.5);
//			return TRUE;
//		}
//	}
//	return FALSE;
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClHiCoJjFnCiPfHiDgOiDjDiDgIiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	set<FCHandleId> stIds;
	CheckHitHandle(stIds, m_mmptMsc);
	// _xZkqqHx_iDgOiDjDiDgIiDiLiCkKiIoKiCmCiCoAiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (stIds.empty()) return FALSE;
	// _xZkqqHx_jBfDjBmMiDgOiDjDiDgIiDiLiCkKiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if ((*stIds.begin()).first != -1) return FALSE;
	switch ((*stIds.begin()).second)
	{
	case 0:		// 0_xZkqqHx_jDhIiDiJiDeDiDjDiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dHitAllAngle = m_dAllAngle;
		break;
	case 1:		// 90_xZkqqHx_jDhIiDiJiDeDiDjDiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dHitAllAngle = ::RegulateAngle(m_dAllAngle + 0.5);
		break;
	case 2:		// 180_xZkqqHx_jDhIiDiJiDeDiDjDiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dHitAllAngle = ::RegulateAngle(m_dAllAngle + 1.0);
		break;
	default:	// 270_xZkqqHx_jDhIiDiJiDeDiDjDiCmJiDhBiDgCiDgHiBeC_xHqqkZx_
		m_dHitAllAngle = ::RegulateAngle(m_dAllAngle + 1.5);
		break;
	}
	return TRUE;
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::CheckHitAllRotMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::CheckHitAllRotCenter
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMjFjEjFgJiCmMiJpBjDfNjHhAiDhNiBfLiDeOjCiGjAfDiPoDiCmJiDhNiDeFiDfIiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhBiDgCiDgHiClFiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCToolRotate::CheckHitAllRotCenter ()
{
	// _xZkqqHx_iMlLiNnNiCmMiDhNiDeFiDfIiNmAjFfHiCmJiDhBiDgCiDgHiClHiCoJjFnCiPfHiDgOiDjDiDgIiDiLiCpAjClCiCnHiCoJiBeC_xHqqkZx_
	set<FCHandleId> stIds;
	CheckHitHandle(stIds, m_mmptMsc);
	// _xZkqqHx_iDgOiDjDiDgIiDiLiCkKiIoKiCmCiCoAiDhBiDgCiDgHiClFiCmEiCkCiCmIiCkCiPoKiNiHiCmN_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
	if (stIds.empty()) return FALSE;
	// _xZkqqHx_jBfDjBmMiDgOiDjDiDgIiDiLiCmMjCiGjAfDiCmNiBeB_xHqqkZx_(-1, -1, 0, 0)_xZkqqHx_iCmIiCmMiCmF_xHqqkZx_stIds_xZkqqHx_iCmM_xHqqkZx_
	// _xZkqqHx_iNmFiPiJiCmJjHiIiCoJiCmNiClIiBeC_xHqqkZx_
	// _xZkqqHx_jBfDjBmMiDgOiDjDiDgIiDiLiCmMjCiGjAfDiCkKiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
	return ((*stIds.begin()).first == -1 &&
			(*stIds.begin()).second == -1);
} // FCToolRotate::CheckHitAllRotCenter.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::DrawAllRotMark
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNjHhAiCmMiDeLiDeDiDgIiPfMiOjKjApMiCpAjFgAiJoGiBgJiPmBiLiOiBgKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dRot	:_xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCmJiJmBiOfKiClHiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::DrawAllRotMark (CDC* pDC, double dRot) const
{
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKiCfBiMmCiImIiPoDiCmFiCmIiCkCiCmGjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
//	if (m_mpRotElem.size() < 2) return;
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKiCfAiMmCiImIiPoDiCmFiCmIiCkCiCmGjFgAiJoGiClFiCmIiCkCiBeC_xHqqkZx_
	if (m_mpRotElem.empty()) return;
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	const mmetol mmCrossLen = lg2mm(FDRT_ALL_CROSS_LEN);
//	const double dSin = sin((m_dAllAngle + dRot) * M_PI);
//	const double dCos = cos((m_dAllAngle + dRot) * M_PI);
//	// _xZkqqHx_iKgFiDhNiBfLiDeOiCmMiOmAiNmAjFfHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
//	DBLPoint mmptHorz = DBLPoint(mmCrossLen, 0.0).RotatePoint(dSin, dCos);
//	DBLPoint mmptVert = DBLPoint(0.0, mmCrossLen).RotatePoint(dSin, dCos);
//	//----- _xZkqqHx_iDhNiBfLiDeOiCpAiMhGiOfK_xHqqkZx_ -----
//	CPoint lgpta[4];
//	lgpta[0] = mm2lg(m_mmptAllCenter + mmptHorz);
//	lgpta[1] = mm2lg(m_mmptAllCenter - mmptHorz);
//	lgpta[2] = mm2lg(m_mmptAllCenter + mmptVert);
//	lgpta[3] = mm2lg(m_mmptAllCenter - mmptVert);
//	// _xZkqqHx_iDeLiDeDiDgIjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
//	FCEditDraw eDraw(pDC, 0);
//	// _xZkqqHx_iDeLiDeDiDgIiPfMiOjKjApMiCpAjFgAiJoGiBeC_xHqqkZx_
//	eDraw.Line(&lgpta[0], &lgpta[1]);
//	eDraw.Line(&lgpta[2], &lgpta[3]);
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iCfDjDfPiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
	DBLPoint mmpta[4];
	Calc4RotMark(mmpta, dRot);
	//----- _xZkqqHx_iDhNiBfLiDeOiCpAiMhGiOfK_xHqqkZx_ -----
	CPoint lgpta[4];
	mm2lg(lgpta, mmpta, 4);
	// _xZkqqHx_iDeLiDeDiDgIjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	// _xZkqqHx_iDeLiDeDiDgIiPfMiOjKjApMiCpAjFgAiJoGiBeC_xHqqkZx_
	eDraw.Line(&lgpta[0], &lgpta[2]);
	eDraw.Line(&lgpta[1], &lgpta[3]);
//----- 05.06.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::DrawAllRotMark.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::GetDefaultIdleCursor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	StateIdle_xZkqqHx_iCmFiDgGiDhEiDeIiDiLiDgHiCmJiOgHiCoNiCoKiCoJiDeKiBfLiDfMiDiLiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jFfHiPiAiCmMiDeKiBfLiDfMiDiLiCmMiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.07.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HCURSOR FCToolRotate::GetDefaultIdleCursor () const
{
	return FFGetApp()->LoadCursor(IDC_CURSOR_TOOL_ROTATE);
} // FCToolRotate::GetDefaultIdleCursor.

//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::OnDrawState
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	View_xZkqqHx_iCmM_xHqqkZx_OnDraw_xZkqqHx_iCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC		:_xZkqqHx_jFfMiOkGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pmmrtRgn:_xZkqqHx_iDiKiBfLiDfHiDiHiDjDjEhKjHpBiCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lRgnSize:pmmrtRgn_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::OnDrawState (CDC* pDC, int iState)
{
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOjFgAiJoGiBeC_xHqqkZx_
	DrawAllRotMark(pDC);
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_EACH_ROTING:			// _xZkqqHx_iMmCjFmKiJpBjDfNjCiGiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
		FCEditDraw eDraw(pDC, 0);
		CPoint lgpta4[5];
		// _xZkqqHx_iJpBjDfNiMoDiCmMiCfDjDfPiCpAiMhGiOfKiClFiBeBjFgAiJoGiBeC_xHqqkZx_
		int iCount = m_HitEachElem.Calc5RotMark(lgpta4, m_dMoveR);
		eDraw.Polyline(lgpta4, iCount);
		break;
	  }
	case STATE_ALL_ROTING:			// _xZkqqHx_jBfDjBmMiJpBjDfNjCiGiBeC_xHqqkZx_
		// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOjFgAiJoGiBeC_xHqqkZx_
		DrawAllRotMark(pDC, m_dMoveR);
		break;
	}
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnDrawState(pDC, iState);
} // FCToolRotate::OnDrawState.
//----- 06.12.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::TransFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMiIjCoIjAkLjHeMiMmAiDeJiBfLiDgHiDhNiDgHiDjDiCmMjBeKiInKiCpAjFnEiClHiBeC_xHqqkZx_ToolPoly.mdrw_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iEvent	:_xZkqqHx_iDeDiDhIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBeKiInKiMoDiCmMiPpDjBnEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FCToolRotate::TransFDA (int iState, int iEvent)
{
	// _xZkqqHx_iInKiNhDjAoGiPpDjBnEiBeC_xHqqkZx_
	int iNextState = STATE_NONE;	// _xZkqqHx_iPpDjBnEjGlDiClFiBeC_xHqqkZx_
	// FDA_xZkqqHx_iCmMiMlLiNnNiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_IDLE:				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_LBUTTONDOWN:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDfPiDeFiDjDiBeC_xHqqkZx_
			if (FFCanEditObject())
			//----- _xZkqqHx_jFjEjFgJjFnCiPfHiJmCjEfMiCmMiPoKiNiH_xHqqkZx_ -----
			{
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmFiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
//				if (CheckHitEachRotMark())
//					iNextState = STATE_ENTER_EACH_ROT;		// _xZkqqHx_iMmCjFmKiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
//				else
//				if (CheckHitAllRotCenter())
//					iNextState = STATE_START_MOVE_ALL_ROT;	// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiKeKiOgOiBeC_xHqqkZx_
//				else
//				if (CheckHitAllRotMark())
//					iNextState = STATE_ENTER_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				// _xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCmFiCmMiDhBiDgCiDgHiPpDjBnEiCpAjClCiCnHiCoJiBeC_xHqqkZx_
				// _xZkqqHx_jBfDjBmMiJpBjDfNiCpAjHeEjAoGiClFiCmEjClCiCnHiCoJjFeLjHhGiCkKiCkAiCoJiBeCiMmCjFmKiJpBjDfNiCmNiDgOiDjDiDgIiDiLiCkKiCfDiCmC_xHqqkZx_
				// _xZkqqHx_iCkAiCoJiCkKiBeBjBfDjBmMiJpBjDfNiCmNjCiGjAfDiCkKiCfAiCmCiCmIiCmMiCmF_xHqqkZx_
				// _xZkqqHx_jCiGjAfDiCmGiMmCjFmKiJpBjDfNiCmMiDgOiDjDiDgIiDiLiCkKiIoKjChGiClFiClNiPoKiNiHiBeBjBfDjBmMiJpBjDfNjCiGjAfDiCpA_xHqqkZx_
				// _xZkqqHx_jHeEjAoGiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
				if (CheckHitAllRotCenter())
					iNextState = STATE_START_MOVE_ALL_ROT;	// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiKeKiOgOiBeC_xHqqkZx_
				else
				if (CheckHitAllRotMark())
					iNextState = STATE_ENTER_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
				else
				if (CheckHitEachRotMark())
					iNextState = STATE_ENTER_EACH_ROT;		// _xZkqqHx_iMmCjFmKiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			}
			break;
		}
		break;
	case STATE_ENTER_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_START_EACH_ROT;		// _xZkqqHx_iMmCjFmKiJpBjDfNiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_EXIT_EACH_ROT;		// _xZkqqHx_iMmCjFmKiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_START_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_EACH_ROTING;			// _xZkqqHx_iMmCjFmKiJpBjDfNjCiGiBeC_xHqqkZx_
		break;
	case STATE_EACH_ROTING:			// _xZkqqHx_iMmCjFmKiJpBjDfNjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_EACH_ROTING;			// _xZkqqHx_iMmCjFmKiJpBjDfNjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_EACH_ROT;		// _xZkqqHx_iMmCjFmKiJpBjDfNiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_EXIT_EACH_ROT;		// _xZkqqHx_iMmCjFmKiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_EXIT_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
		iNextState = STATE_IDLE;				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	case STATE_ENTER_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_START_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNiKeKiOgOiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_EXIT_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_START_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_ALL_ROTING;			// _xZkqqHx_jBfDjBmMiJpBjDfNjCiGiBeC_xHqqkZx_
		break;
	case STATE_ALL_ROTING:			// _xZkqqHx_jBfDjBmMiJpBjDfNjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_ALL_ROTING;			// _xZkqqHx_jBfDjBmMiJpBjDfNjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_EXIT_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
		break;
	case STATE_EXIT_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
		iNextState = STATE_IDLE;				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;

	case STATE_START_MOVE_ALL_ROT:	// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		iNextState = STATE_MOVING_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOjCiGiBeC_xHqqkZx_
		break;
	case STATE_MOVING_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOjCiGiBeC_xHqqkZx_
		switch (iEvent)
		{
		case WM_MOUSEMOVE:	// _xZkqqHx_iDhNiDeFiDfIiInKjDkOiBeC_xHqqkZx_
			iNextState = STATE_MOVING_ALL_ROT;		// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOjCiGiBeC_xHqqkZx_
			break;
		case WM_LBUTTONUP:	// _xZkqqHx_iNlGiDhLiDfOiDjDiDeBiDgCiDhGiBeC_xHqqkZx_
			iNextState = STATE_STOP_MOVE_ALL_ROT;	// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiPeJjHlJiBeC_xHqqkZx_
			break;
		}
		break;
	case STATE_STOP_MOVE_ALL_ROT:	// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		iNextState = STATE_IDLE;				// _xZkqqHx_jBnCiClPiBeC_xHqqkZx_
		break;
	}
	// _xZkqqHx_iPpDjBnEjBeKiInKjGlDiClFiCmMiPoKiNiHiCmNiDfIiBfLiDhAiBfLiDeOiDiJiDfIiCmMiPpDjBnEjBeKiInKiCpAiMmEiCnBiPgPiClHiBeC_xHqqkZx_
	if (iNextState == STATE_NONE)
		iNextState = BASE_CLASS::TransFDA(iState, iEvent);
	return iNextState;
} // FCToolRotate::TransFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateFDA
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPpDjBnEiCmJiJjOiClGiClNiPiIjHjNiCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	iState	:_xZkqqHx_iMlLiNnNiCmMiPpDjBnEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pDC		:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateFDA (int iState, CDC* pDC)
{
	// FDA_xZkqqHx_iCmMiOjPiCmMiPpDjBnEiBeC_xHqqkZx_
	switch (iState)
	{
	case STATE_ENTER_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
		StateEnterEachRot(pDC);
		break;
	case STATE_START_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNiKeKiOgOiBeC_xHqqkZx_
		StateStartEachRot(pDC);
		break;
	case STATE_EACH_ROTING:			// _xZkqqHx_iMmCjFmKiJpBjDfNjCiGiBeC_xHqqkZx_
		StateEachRoting(pDC);
		break;
	case STATE_STOP_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNiPeJjHlJiBeC_xHqqkZx_
		StateStopEachRot(pDC);
		break;
	case STATE_EXIT_EACH_ROT:		// _xZkqqHx_iMmCjFmKiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
		StateExitEachRot(pDC);
		break;
	case STATE_ENTER_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNjDpMiMpLiBeC_xHqqkZx_
		StateEnterAllRot(pDC);
		break;
	case STATE_START_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiKeKiOgOiBeC_xHqqkZx_
		StateStartAllRot(pDC);
		break;
	case STATE_ALL_ROTING:			// _xZkqqHx_jBfDjBmMiJpBjDfNjCiGiBeC_xHqqkZx_
		StateAllRoting(pDC);
		break;
	case STATE_STOP_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiPeJjHlJiBeC_xHqqkZx_
		StateStopAllRot(pDC);
		break;
	case STATE_EXIT_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiPgPiMpLiBeC_xHqqkZx_
		StateExitAllRot(pDC);
		break;
//----- 05.06.27 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	case STATE_START_MOVE_ALL_ROT:	// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiKeKiOgOiBeC_xHqqkZx_
		StateStartMoveAllRot(pDC);
		break;
	case STATE_MOVING_ALL_ROT:		// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOjCiGiBeC_xHqqkZx_
		StateMovingAllRot(pDC);
		break;
	case STATE_STOP_MOVE_ALL_ROT:	// _xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiPeJjHlJiBeC_xHqqkZx_
		StateStopMoveAllRot(pDC);
		break;
//----- 05.06.27 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	default:
		BASE_CLASS::StateFDA(iState, pDC);
	}
} // FCToolRotate::StateFDA.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateIdle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBnCiClPiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateIdle (CDC* pDC)
{
	TRACE(_T("StateIdle\r\n"));
	// _xZkqqHx_jFjEjFgJiCmMiMmCjFmKiJpBjDfNjApMiBeBiBeFjBfDjBmMiJpBjDfNjApMiCmMiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoKiCmOiDeKiBfLiDfMiDiLjAnNjCoIiBeC_xHqqkZx_
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (CheckHitEachRotMark() || CheckHitAllRotMark())
//		::FFSetCurCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEALL));
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (CheckHitEachRotMark() || CheckHitAllRotMark())
		SetIdleCursor(FFGetApp()->LoadStandardCursor(IDC_SIZEALL));
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGiBeC_xHqqkZx_
//	FFGetMainWnd()->MoveRulerMMK(1, m_mmptMsc);
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_iDhBiDgCiDgHiDeKiBfLiDfMiDiLiCpAjGlDiMpIiCmJiClHiCoJiBeC_xHqqkZx_
	m_iCursorNew = FDPA_HIT_NONE;
	// _xZkqqHx_iDiLiBfLiDiJiBfLiDhNiDeFiDfIiDhNiBfLiDeKiBfLjFfMiOkGjDjJiBeC_xHqqkZx_
	BASE_CLASS::StateIdle(pDC);
//----- 01.07.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::StateIdle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateEnterEachRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKiJpBjDfNjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateEnterEachRot (CDC* pDC)
{
	TRACE(_T("StateEnterEachRot\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJiKhAjDhIjFfMiOkG_xHqqkZx_ -----
	double dAngle = ::RegulateAngle(m_HitEachElem.m_dAngle);
	WString strMsg;
	strMsg.Format(L"ANG:%f ROT:%f", dAngle, 0);
	FFGetMainWnd()->SetStatusBarText(strMsg);

//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRotateObjectHint())
	{
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmJiDiKiDfEiDeDiDfJiPoOjFpBiCpAjFfMiOkGiBeC_xHqqkZx_
		// --------[0-2]--------\r\n
		// _xZkqqHx_jFjEjFgJiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f\r\n
		// -------[0-360]-------\r\n
		// _xZkqqHx_jFjEjFgJiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f
		WString wstrHint;
		wstrHint.Format(FFLoadWString(IDS_FORM_EACH_ROTATE_HINT).c_str(),
						m_pHitEachObj->GetAngle(),
						dAngle,
						0.0,
						0.0,
						180.0 * m_pHitEachObj->GetAngle(),
						180.0 * dAngle,
						0.0,
						0.0);
		FFGetApp()->GetPopHint()->SetTargetInfo(wstrHint);
		FFGetApp()->GetPopHint()->OnShow();
	}
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::StateEnterEachRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateStartEachRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKiJpBjDfNiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateStartEachRot (CDC* pDC)
{
	TRACE(_T("StateStartEachRot\r\n"));
	m_dMoveR = 0.0;		// _xZkqqHx_iJpBjDfNiPiIjHjNjCiGiCmMiBeBiMlLiNnNiCmMiJpBjDfNjHmKiBeC_xHqqkZx_
//----- 05.08.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgDiBfLiDiLiCmMiPeDjAlDjApMjDjJiCpAiPmBiLiOiBeC_xHqqkZx_
//	OnDraw(pDC);
//----- 05.08.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	// _xZkqqHx_iCfDjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
	CPoint lgpta4[5];
	const int iCount = m_HitEachElem.Calc5RotMark(lgpta4, m_dMoveR);
	eDraw.Polyline(lgpta4, iCount);
} // FCToolRotate::StateStartEachRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateEachRoting
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKiJpBjDfNjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateEachRoting (CDC* pDC)
{
	TRACE(_T("StateEachRoting\r\n"));

	// _xZkqqHx_iKhAjDhIiInKjDkOjHmKiCpAiMhGiOfK_xHqqkZx_(_xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCkJiCoHiPiJiKpKiKhAjDhIiCpAiIpIiCkCiCmEiInKjDkOiKhAjDhIiCpAiOfKiPgP_xHqqkZx_)
	double dMoveR =
			::ArcTan(m_mmptMsc - m_HitEachElem.m_mmptCenter) - m_dHitEachAngle;
	// _xZkqqHx_iInKjDkOjHmKiCpAiJmBiOfKiClFiClNiKhAjDhIiCmJiDfIiDgJiDgCiDhGiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
	double dAngle = mySnapR(m_HitEachElem.m_dAngle + dMoveR);
	// _xZkqqHx_iInKjDkOjHmKiCpA_xHqqkZx_ 0 _xZkqqHx_iImIiPoD_xHqqkZx_ 2 _xZkqqHx_jGkCjGjOiCmJjAlDiLeLiJlLiBeC_xHqqkZx_
	dMoveR = ::RegulateAngle(dAngle - m_HitEachElem.m_dAngle);
	// _xZkqqHx_iInKjDkOjHmKiCmJjFmPiJlLjGlDiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_dMoveR == dMoveR) return;

	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	CPoint lgpta4[5];
	// _xZkqqHx_jBePiJpBiCmMiCfDjDfPiCpAiMhGiOfKiClFiBeBiPmBiLiOiBeC_xHqqkZx_
	int iCount = m_HitEachElem.Calc5RotMark(lgpta4, m_dMoveR);
	eDraw.Polyline(lgpta4, iCount);

	// _xZkqqHx_jAfGiClFiCkCiInKjDkOjHmKiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dMoveR = dMoveR;

	// _xZkqqHx_iJpBjDfNiMoDiCmMiCfDjDfPiCpAiMhGiOfKiClFiBeBjFgAiJoGiBeC_xHqqkZx_
	iCount = m_HitEachElem.Calc5RotMark(lgpta4, m_dMoveR);
	eDraw.Polyline(lgpta4, iCount);

	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJiKhAjDhIjFfMiOkG_xHqqkZx_ -----
	dAngle = ::RegulateAngle(m_HitEachElem.m_dAngle + m_dMoveR);
	WString strMsg;
	strMsg.Format(L"ANG:%f ROT:%f", dAngle, m_dMoveR);
	FFGetMainWnd()->SetStatusBarText(strMsg);

//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRotateObjectHint())
	{
		double dObjAngle = ::RegulateAngle(m_pHitEachObj->GetAngle() + m_dMoveR);
		double dMoveR_ = (m_dMoveR == 0.0) ? 0.0 : m_dMoveR - 2.0;
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmJiDiKiDfEiDeDiDfJiPoOjFpBiCpAjFfMiOkGiBeC_xHqqkZx_
		// --------[0-2]--------\r\n
		// _xZkqqHx_jFjEjFgJiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f\r\n
		// -------[0-360]-------\r\n
		// _xZkqqHx_jFjEjFgJiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f
		WString wstrHint;
		wstrHint.Format(FFLoadWString(IDS_FORM_EACH_ROTATE_HINT).c_str(),
						dObjAngle,
						dAngle,
						m_dMoveR,
						dMoveR_,
						180.0 * dObjAngle,
						180.0 * dAngle,
						180.0 * m_dMoveR,
						180.0 * dMoveR_);
		FFGetApp()->GetPopHint()->SetTargetInfo(wstrHint);
		FFGetApp()->GetPopHint()->OnShow();
	}
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::StateEachRoting.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateStopEachRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKiJpBjDfNiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateStopEachRot (CDC* pDC)
{
	TRACE(_T("StateStopEachRot\r\n"));
	// _xZkqqHx_iPeDjAlDjApMjFgAiJoGjHhAiDeOiDiJiDfIiCpAiNoMjAkMiBeC_xHqqkZx_
	FCEditDraw eDraw(pDC, 0);
	CPoint lgpta4[5];
	// _xZkqqHx_jBePiJpBiCmMiCfDjDfPiCpAiMhGiOfKiClFiBeBiPmBiLiOiBeC_xHqqkZx_
	const int iCount = m_HitEachElem.Calc5RotMark(lgpta4, m_dMoveR);
	eDraw.Polyline(lgpta4, iCount);

//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgDiBfLiDiLiCmMiPeDjAlDjApMjDjJiCpAiPmBiLiOiBeC_xHqqkZx_
	OnDraw(pDC);
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// _xZkqqHx_iInKjDkOjHmKiCkKiCePiCmFiCmIiCkCiCmIiCoHiCmOiJpBjDfNiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
	if (m_dMoveR != 0.0)
	{
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
		g_pDoc->SessionBegin();

		// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
		FTMolipSet setMolip;
		FTRotElemMap::iterator iEm;
		for (iEm = m_mpRotElem.begin(); iEm != m_mpRotElem.end(); iEm++)
		{
			if ((*iEm).first->CanRotate())
			//----- _xZkqqHx_jFjEjFgJiCkKiJpBjDfNiJmCjEfMiCmIiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
				g_pView->AppendToLastRgn((*iEm).first);
				// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
				g_pDoc->CmdRotate1Obj((*iEm).first, m_dMoveR, (*iEm).second.m_mmptCenter);
				// _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
				setMolip.insert(FCMolipRec((*iEm).first->GetObjID(), -1));
				// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
				g_pView->AppendToLastRgn((*iEm).first);
				// _xZkqqHx_iKhAjDhIiCpAiNfIjAfGiBeC_xHqqkZx_
				(*iEm).second.m_dAngle += m_dMoveR;
			}
		}
		// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
		g_pDoc->LinkManager()->MovedNotify(setMolip);
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
//----- 05.06.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeCiClBiClBiCmF_xHqqkZx_OnSelectObjModified _xZkqqHx_iCpA_xHqqkZx_
		// _xZkqqHx_iOmAiNhDiClHiCoJiCmGiBeBiJpBjDfNiKhAjDhIiCkKiCePiCmJiDiKiDfKiDgCiDgHiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiBeB_xHqqkZx_
		// ResetEditHandleList_xZkqqHx_iCmMiCnNiOmAiNhDiBeC_xHqqkZx_
		ResetEditHandleList();
//----- 05.06.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
	// _xZkqqHx_iDgDiBfLiDiLiCmMiPeDjAlDjApMjDjJiCpAjFgAiJoGiBeC_xHqqkZx_
	OnDraw(pDC);
	// _xZkqqHx_iNmEjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolRotate::StateStopEachRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateExitEachRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMmCjFmKiJpBjDfNiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateExitEachRot (CDC* pDC)
{
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRotateObjectHint())
	{
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCpAjEpBjFfMiOkGiCmJiBeC_xHqqkZx_
		FFGetApp()->GetPopHint()->OnHide();
	}
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	TRACE(_T("StateExitEachRot\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
	::FFReleaseCapture();
} // FCToolRotate::StateExitEachRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateEnterAllRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNjDpMiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateEnterAllRot (CDC* pDC)
{
	TRACE(_T("StateEnterAllRot\r\n"));
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJiKhAjDhIjFfMiOkG_xHqqkZx_ -----
	double dAngle = ::RegulateAngle(m_dAllAngle);
	WString strMsg;
	strMsg.Format(L"ANG:%f ROT:%f", dAngle, 0.0);
	FFGetMainWnd()->SetStatusBarText(strMsg);

//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRotateObjectHint())
	{
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmJiDiKiDfEiDeDiDfJiPoOjFpBiCpAjFfMiOkGiBeC_xHqqkZx_
		// --------[0-2]--------\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f\r\n
		// -------[0-360]-------\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f
		WString wstrHint;
		wstrHint.Format(FFLoadWString(IDS_FORM_ALL_ROTATE_HINT).c_str(),
						dAngle,
						0.0,
						0.0,
						180.0 * dAngle,
						0.0,
						0.0);
		FFGetApp()->GetPopHint()->SetTargetInfo(wstrHint);
		FFGetApp()->GetPopHint()->OnShow();
	}
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::StateEnterAllRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateStartAllRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateStartAllRot (CDC* pDC)
{
	TRACE(_T("StateStartAllRot\r\n"));
	m_dMoveR = 0.0;		// _xZkqqHx_iJpBjDfNiPiIjHjNjCiGiCmMiBeBiMlLiNnNiCmMiJpBjDfNjHmKiBeC_xHqqkZx_
//----- 05.08.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDgDiBfLiDiLiCmMiPeDjAlDjApMjDjJiCpAiPmBiLiOiBeC_xHqqkZx_
//	OnDraw(pDC);
//----- 05.08.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOjFgAiJoGiBeC_xHqqkZx_
// 05.08.02 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	DrawAllRotMark(pDC);
	DrawAllRotMark(pDC, m_dMoveR);
} // FCToolRotate::StateStartAllRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateAllRoting
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNjCiGiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateAllRoting (CDC* pDC)
{
	TRACE(_T("StateAllRoting\r\n"));
	// _xZkqqHx_iKhAjDhIiInKjDkOjHmKiCpAiMhGiOfK_xHqqkZx_(_xZkqqHx_iMlLiNnNiCmMiKhAjDhIiCkJiCoHiPiJiKpKiKhAjDhIiCpAiIpIiCkCiCmEiInKjDkOiKhAjDhIiCpAiOfKiPgP_xHqqkZx_)
	double dMoveR = ::ArcTan(m_mmptMsc - m_mmptAllCenter) - m_dHitAllAngle;
	// _xZkqqHx_iInKjDkOjHmKiCpAiJmBiOfKiClFiClNiKhAjDhIiCmJiDfIiDgJiDgCiDhGiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
	double dAngle = mySnapR(m_dAllAngle + dMoveR);
	// _xZkqqHx_iInKjDkOjHmKiCpA_xHqqkZx_ 0 _xZkqqHx_iImIiPoD_xHqqkZx_ 2 _xZkqqHx_jGkCjGjOiCmJjAlDiLeLiJlLiBeC_xHqqkZx_
	dMoveR = ::RegulateAngle(dAngle - m_dAllAngle);
	// _xZkqqHx_iInKjDkOjHmKiCmJjFmPiJlLjGlDiCkPiCoKiCmOjFjMiLeBiBeC_xHqqkZx_
	if (m_dMoveR == dMoveR) return;

	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOiPmBiLiOiBeC_xHqqkZx_
	DrawAllRotMark(pDC, m_dMoveR);

	// _xZkqqHx_jAfGiClFiCkCiInKjDkOjHmKiCpAjAnNjCoIiBeC_xHqqkZx_
	m_dMoveR = dMoveR;

	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOjFgAiJoGiBeC_xHqqkZx_
	DrawAllRotMark(pDC, m_dMoveR);

	//----- _xZkqqHx_iDfIiDgFiBfLiDfOiDfIiDgPiBfLiCmJiKhAjDhIjFfMiOkG_xHqqkZx_ -----
	dAngle = ::RegulateAngle(m_dAllAngle + m_dMoveR);
	WString strMsg;
	strMsg.Format(L"ANG:%f ROT:%f", dAngle, m_dMoveR);
	FFGetMainWnd()->SetStatusBarText(strMsg);

//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRotateObjectHint())
	{
		double dMoveR_ = (m_dMoveR == 0.0) ? 0.0 : m_dMoveR - 2.0;
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmJiDiKiDfEiDeDiDfJiPoOjFpBiCpAjFfMiOkGiBeC_xHqqkZx_
		// --------[0-2]--------\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f\r\n
		// -------[0-360]-------\r\n
		// _xZkqqHx_iDgDiBfLiDiLiKhAjDhI_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_: %f\r\n
		// _xZkqqHx_iInKjDkOiKhA_xHqqkZx_(-): %f
		WString wstrHint;
		wstrHint.Format(FFLoadWString(IDS_FORM_ALL_ROTATE_HINT).c_str(),
						dAngle,
						m_dMoveR,
						dMoveR_,
						180.0 * dAngle,
						180.0 * m_dMoveR,
						180.0 * dMoveR_);
		FFGetApp()->GetPopHint()->SetTargetInfo(wstrHint);
		FFGetApp()->GetPopHint()->OnShow();
	}
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::StateAllRoting.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateStopAllRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateStopAllRot (CDC* pDC)
{
	TRACE(_T("StateStopAllRot\r\n"));
	// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOiPmBiLiOiBeC_xHqqkZx_
	DrawAllRotMark(pDC, m_dMoveR);
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgDiBfLiDiLiCmMiPeDjAlDjApMjDjJiCpAiPmBiLiOiBeC_xHqqkZx_
	OnDraw(pDC);
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iInKjDkOjHmKiCkKiCePiCmFiCmIiCkCiCmIiCoHiCmOiJpBjDfNiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
	if (m_dMoveR != 0.0)
	{
		const double dMoveSinR = sin(m_dMoveR * M_PI);
		const double dMoveCosR = cos(m_dMoveR * M_PI);

		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiKeKiOgOiBeC_xHqqkZx_
		g_pDoc->SessionBegin();

		// _xZkqqHx_iInKjDkOiClFiClNiDiCiDiKiDhGiPfHiNiHiBeC_xHqqkZx_
		FTMolipSet setMolip;
		FTRotElemMap::iterator iEm;
		for (iEm = m_mpRotElem.begin(); iEm != m_mpRotElem.end(); iEm++)
		{
			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
			g_pView->AppendToLastRgn((*iEm).first);
//----- 05.06.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
//			g_pDoc->CmdRotate1Obj((*iEm).first, m_dMoveR, m_mmptAllCenter);
//			// _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
//			setMolip.insert(FCMolipRec((*iEm).first->GetObjID(), -1));
//			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
//			g_pView->AppendToLastRgn((*iEm).first);
//			// _xZkqqHx_iDiPiBfLiDeOiCmMiJpBjDfNiPiIjHjNiBeC_xHqqkZx_
//			(*iEm).second.Rotate(m_dMoveR, m_mmptAllCenter);
//----- 05.06.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if ((*iEm).first->CanRotate())
			//----- _xZkqqHx_jFjEjFgJiCkKiJpBjDfNiJmCjEfMiCmIiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iJpBjDfNiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
				g_pDoc->CmdRotate1Obj((*iEm).first, m_dMoveR, m_mmptAllCenter);
				// _xZkqqHx_iDiPiBfLiDeOiCmMiJpBjDfNiPiIjHjNiBeC_xHqqkZx_
				(*iEm).second.Rotate(m_dMoveR, m_mmptAllCenter);
			} else
			//----- _xZkqqHx_jFjEjFgJiCkKiJpBjDfNjFhDiJmCjEfMiCmIiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iInKjDkOiLjHjHkDiCpAiOfKiPgPiBeC_xHqqkZx_
				DBLPoint mmptCenter = (*iEm).first->GetResizeFrame().CenterPoint();
				::RotateConv(mmptCenter, dMoveSinR, dMoveCosR, m_mmptAllCenter.x, m_mmptAllCenter.y);
				DBLPoint mmptMove = mmptCenter - (*iEm).first->GetResizeFrame().CenterPoint();
				// _xZkqqHx_iInKjDkOiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
				g_pDoc->CmdMove1Obj((*iEm).first, mmptMove);
				// _xZkqqHx_iDiPiBfLiDeOiCmMiInKjDkOiPiIjHjNiBeC_xHqqkZx_
				(*iEm).second.Move(mmptMove);
			}
			// _xZkqqHx_iInKjDkOiClFiClNjIeBiMiLjDfPiDiCiDiKiDhGiCpAjAnNjCoIiBeC_xHqqkZx_
			setMolip.insert(FCMolipRec((*iEm).first->GetObjID(), -1));
			// _xZkqqHx_iMmFjHeMiDiKiBfLiDfHiDiHiDjDiCmJjCmHiJmBiBeC_xHqqkZx_
			g_pView->AppendToLastRgn((*iEm).first);
//----- 05.06.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
		// _xZkqqHx_jFjEjFgJiCmMiDiKiDfEiDeDiDfJiCpAjCmKjCgNiBeCjDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiBeC_xHqqkZx_
		g_pDoc->LinkManager()->MovedNotify(setMolip);
		// _xZkqqHx_iDfCiDhNiDjDiDgIiDfKiDgCiDfGiDiHiDjDiCmMiPeJjHlJiBeC_xHqqkZx_
		g_pDoc->SessionEnd();
//----- 05.06.06 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_jBfDjBmMiJpBjDfNiKhAjDhIiCpAiNfIjAfGiBeC_xHqqkZx_
		m_dAllAngle = ::RegulateAngle(m_dAllAngle + m_dMoveR);
		// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeCiClBiClBiCmF_xHqqkZx_OnSelectObjModified _xZkqqHx_iCpA_xHqqkZx_
		// _xZkqqHx_iOmAiNhDiClHiCoJiCmGiBeBiJpBjDfNiKhAjDhIiCkKiCePiCmJiDiKiDfKiDgCiDgHiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiBeB_xHqqkZx_
		// ResetEditHandleList_xZkqqHx_iCmMiCnNiOmAiNhDiBeC_xHqqkZx_
		ResetEditHandleList();
//----- 05.06.06 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	}
//----- 05.06.06 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_jBfDjBmMiJpBjDfNiKhAjDhIiCpAiNfIjAfGiBeC_xHqqkZx_
//	m_dAllAngle = ::RegulateAngle(m_dAllAngle + m_dMoveR);
//----- 05.06.06 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDgDiBfLiDiLiCmMiPeDjAlDjApMjDjJiCpAjFgAiJoGiBeC_xHqqkZx_
	OnDraw(pDC);
	// _xZkqqHx_iNmEjFgAiJoGiPiIjHjNiBeC_xHqqkZx_
	g_pView->SendRgnRedraw();
} // FCToolRotate::StateStopAllRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateExitAllRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNiPgPiMpLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateExitAllRot (CDC* pDC)
{
	TRACE(_T("StateExitAllRot\r\n"));
	// _xZkqqHx_iDhNiDeFiDfIiCmMjFnPiKgMiCpAiJpAiPjMiBeC_xHqqkZx_
	::FFReleaseCapture();
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupRotateObjectHint())
	{
		// _xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCpAjEpBjFfMiOkGiCmJiBeC_xHqqkZx_
		FFGetApp()->GetPopHint()->OnHide();
	}
//----- 05.08.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
} // FCToolRotate::StateExitAllRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateStartMoveAllRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiKeKiOgOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateStartMoveAllRot (CDC* pDC)
{
	//----- _xZkqqHx_jAiFjFlNiBeFjAiCjClMjApMiCpAiInKjDkOjApMiCmJjAnNjCoI_xHqqkZx_ -----
	m_mmlnvAry.clear();
	m_mmlnvAry.push_back(DBLLine(m_mmptAllCenter, m_mmptAllCenter + DBLPoint(10,0)));
	m_mmlnvAry.push_back(DBLLine(m_mmptAllCenter, m_mmptAllCenter + DBLPoint(0,10)));
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiCgOiCgNiBeC_xHqqkZx_
	g_pView->SetAutoScroll(TRUE);
	// OnLButtonUp_xZkqqHx_iCnMiCmFiClBiCmM_xHqqkZx_Window_xZkqqHx_iCmJiDeDiDhIiDjDiDgHiBeC_xHqqkZx_
	::FFSetCapture(g_pView->m_hWnd);
} // FCToolRotate::StateStartMoveAllRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateMovingAllRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOjCiGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateMovingAllRot (CDC* pDC)
{
	if (!almosteq(m_mmptAllCenter, m_mmptCnv))
	//----- _xZkqqHx_iNmAjFfHiCkKiInKjDkOiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOiPmBiLiOiBeC_xHqqkZx_
		DrawAllRotMark(pDC);
		// _xZkqqHx_jBfDjBmMiJpBjDfNiCmMjCiGjAfDiNmAjFfHiCmJiBeBjFmPiKlHiMoDiDhNiDeFiDfIiNmAjFfHiCpAjAnNjCoIiBeC_xHqqkZx_
		m_mmptAllCenter = m_mmptCnv;
		// _xZkqqHx_jBfDjBmMiJpBjDfNjHhAiDhNiBfLiDeOjFgAiJoGiBeC_xHqqkZx_
		DrawAllRotMark(pDC);
	}
} // FCToolRotate::StateMovingAllRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::StateStopMoveAllRot
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBfDjBmMiJpBjDfNiInKjDkOiPeJjHlJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::StateStopMoveAllRot (CDC* pDC)
{
	// _xZkqqHx_iOkJjDkOiDfIiDeOiDiNiBfLiDiLiBgJiJoGjGmKiCpAiCmNiCnNiPgPiClFiClNiOjOiBgKiCpAiDeJiDhEiBeC_xHqqkZx_
	g_pView->SetAutoScroll(FALSE);
	::FFReleaseCapture();	// LButtonDown_xZkqqHx_iCmJiCoGiCmBiCmEiOgOiCnMiCmBiClNiDhNiDeFiDfIiCmM_xHqqkZx_
							// _xZkqqHx_jFnPiKgMiCpAiJpAiPjMiClFiCnMiClHiBeC_xHqqkZx_
	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiBeC_xHqqkZx_
	ResetEditHandleList();
} // FCToolRotate::StateStopMoveAllRot.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCToolRotate::ResetEditHandleList
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiNmEjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCToolRotate::ResetEditHandleList ()
{
	// _xZkqqHx_jFnCiPfHiDgOiDjDiDgIiDiLiDiKiDfIiDgHiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	ClearEditHandleList();
	// _xZkqqHx_jBeJjBpAjCiGiCmMiMmCiBfIiCmMjFjEjFgJiCmMiJpBjDfNiDhNiBfLiDeOiCpAjDgPjIfOiBeC_xHqqkZx_
	FTRotElemMap::const_iterator iEm;
	for (iEm = m_mpRotElem.begin(); iEm != m_mpRotElem.end(); iEm++)
	{
		// _xZkqqHx_iJpBjDfNiMoDiCmMiCfDjDfPiCpAiMhGiOfKiBeC_xHqqkZx_
		DBLPoint mmpta4[4];
		(*iEm).second.Calc4RotMark(mmpta4);
		// _xZkqqHx_iCfDjDfPiCmMiCkCiClIiCoKiCkJiCmJiDhBiDgCiDgHiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
		for (int i = 0; i != 4; i++)
		{
			// _xZkqqHx_jFjEjFgJiJpBjDfNiDhNiBfLiDeOiCpAjDgPjIfOiBeC_xHqqkZx_ID=(_xZkqqHx_jFjEjFgJ_xHqqkZx_ID, _xZkqqHx_iJpBjDfNiDhNiBfLiDeO_xHqqkZx_index, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
			AddEditHandle(	mmpta4[i],
							FCHandleId((*iEm).first->GetObjID(), i, 0, 0));
		}
	}

//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jFjEjFgJiCkKiCfBiMmCiImIiPoDiCmFiCmIiCkCiCmGjBfDjBmMiJpBjDfNiCmNiCmIiCkCiBeC_xHqqkZx_
//	if (m_mpRotElem.size() < 2) return;
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jFjEjFgJiCkKiCfAiMmCiImIiPoDiCmFiCmIiCkCiCmGjBfDjBmMiJpBjDfNiCmNiCmIiCkCiBeC_xHqqkZx_
	if (m_mpRotElem.empty()) return;
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jBfDjBmMiCmMiJpBjDfNjHhAiDgOiDjDiDgIiDiLiCmMjCiGjAfDiCpAjDgPjIfO_xHqqkZx_ -----
	// _xZkqqHx_jBfDjBmMiJpBjDfNiDgOiDjDiDgIiDiLjCiGjAfDiCpAjDgPjIfOiBeC_xHqqkZx_ID=(-1, -1, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
	AddEditHandle(m_mmptAllCenter, FCHandleId(-1, -1, 0, 0));

	//----- _xZkqqHx_jBfDjBmMiCmMiJpBjDfNjHhAiDgOiDjDiDgIiDiLiCpAjDgPjIfO_xHqqkZx_ -----

	// _xZkqqHx_iImIiJlKiCmMjBfDjBmMiJpBjDfNiDgOiDjDiDgIiDiLiCmMiCfDjDfPiNmAjFfHiCpAiOfKiPgPiBeC_xHqqkZx_
	//    3
	//    |
	// 2--+--0
	//    |
	//    1
	DBLPoint mmpta4[4];
	Calc4RotMark(mmpta4, 0.0);
	for (int i = 0; i != 4; i++)
	{
		// _xZkqqHx_jBfDjBmMiJpBjDfNiDhNiBfLiDeOiCpAjDgPjIfOiBeC_xHqqkZx_ID=(-1, _xZkqqHx_iJpBjDfNiDhNiBfLiDeO_xHqqkZx_index, 0, 0)_xZkqqHx_iBeC_xHqqkZx_
		AddEditHandle(	DBLShortLine(m_mmptAllCenter, mmpta4[i]),
						FCHandleId(-1, i, 0, 0));
	}
} // FCToolRotate::ResetEditHandleList.

