#include "stdafx.h"
//#include "FoundDoc.h"			// For g_pDoc.
#include "resource.h"			// For IDS_ERR_MSG_UNEXPECTED_EOF.
#include "UtilErr.h"			// For CFCMiscException.
// 06.01.06 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "HIFSFile.h"			// For CFCHIFSFile.
// 06.02.11 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "DynamicDb.h"		// For g_pFileServer.
#include "UndoArchive.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const long FD_READ_WRITE_BYTE_SIZE = 0x10000;	// 64KByte.
//static const long FD_READ_WRITE_BYTE_SIZE = 0x10;	// 64KByte.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCUndoArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jGhLjHiIiBeBiDgGiBfLiDfOiCmMiNlHjFkKiCpAiIlDiPgLiClHiCoJiInHiCmJjFeLjHhGiCmIiDiNiDePiDgGiBfLiDfOiCpAiPeFiCkEiInHiCmJ_xHqqkZx_
 *			_xZkqqHx_iNoMiCmBiClNiKnGjAjEiBeCiNkBiCmNiNlHjFkKiCpAiIlDiPgLiClFiCmEiDfCiDhNiDjDiDgIiCmJiLeMjIfOiClHiCoJiClBiCmGiCmN_xHqqkZx_
 *			_xZkqqHx_iClFiCmIiCkCiCmMiCmFiBeBiClBiCmMiDeOiDiJiDfIiCmNjFhDjHhGiBeC_xHqqkZx_
 *			_xZkqqHx_iClNiClOiBeBiCkAiClPiClBiClPiCmJiOgHiCmBiCmEiClFiCnMiCmBiCmEiCkCiCoJiCmMiCmGiBeBiMoDiBfIiDgGiBfLiDfOiIlDiPgLiCkK_xHqqkZx_
 *			_xZkqqHx_jFjMiKiIiClHiCoJiJmCjEfMjAkLiCoAiCkAiCoJiCmMiCmFiBeBiOgDiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.02 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::FCUndoArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmJiOgHiCkEiDhEiDeAiDeDiDiLjGlMiBeC_xHqqkZx_
 *			iMode	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmMiDiCiBfLiDgIiBeC_xHqqkZx_
 *			pDoc	:Document_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iPjBiCkLiNjOiCnNiCmFjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFiPkMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			vpLog	:_xZkqqHx_iDiNiDePiCpAiCmGiCoJiClNiCnPiCmMiDhIiDeOiDfOiBfLiBeC_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiDiNiDePiCpAiCmGiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiBeB_xHqqkZx_CFile_xZkqqHx_iBeB_xHqqkZx_CArchive_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CMemoryException_xZkqqHx_iBeB_xHqqkZx_CArchiveException_xZkqqHx_iBeB_xHqqkZx_CFileException
 *			_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmMjHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCUndoArchive::FCUndoArchive (	const wchar_t* wcpFilePath,
								int iMode,
								CDocument* pDoc,
// 05.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								BOOL bIsForceFlat,
								long lUndoBuffSizeMin,
								long lUndoBuffSizeMax)
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								WORDVector* vpLog)
			:	m_bIsOwnFile(FALSE),
				m_bIsOwnArchive(FALSE),
				m_pFile(NULL),
				m_pArchive(NULL),
				m_lPosition(0),
				m_lUndoBuffSizeMin(0),
				m_lUndoBuffSizeMax(0),
				m_lUndoBuffCurPos(0),
				m_callback(NULL),
				m_dwCallbackData(0)
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_bIsInterupt(FALSE),
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_vpLog(NULL)
{
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	Initialize(wcpFilePath, iMode, pDoc, bIsForceFlat, lUndoBuffSizeMin, lUndoBuffSizeMax, vpLog);
	Initialize(wcpFilePath, iMode, pDoc, lUndoBuffSizeMin, lUndoBuffSizeMax);
} // FCUndoArchive::FCUndoArchive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::FCUndoArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	filep	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmJiOgHiCkE_xHqqkZx_CFile.
 *			iMode	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmMiDiCiBfLiDgIiBeC_xHqqkZx_
 *			pDoc	:Document_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iPjBiCkLiNjOiCnNiCmFjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFiPkMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			vpLog	:_xZkqqHx_iDiNiDePiCpAiCmGiCoJiClNiCnPiCmMiDhIiDeOiDfOiBfLiBeC_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiDiNiDePiCpAiCmGiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiBeB_xHqqkZx_CArchive_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CMemoryException_xZkqqHx_iBeB_xHqqkZx_CArchiveException_xZkqqHx_iBeB_xHqqkZx_CFileException
 *			_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmMjHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCUndoArchive::FCUndoArchive (	CFile* filep,
								int iMode,
								CDocument* pDoc,
// 05.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								BOOL bIsForceFlat,
								long lUndoBuffSizeMin,
								long lUndoBuffSizeMax)
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								WORDVector* vpLog)
			:	m_bIsOwnFile(FALSE),
				m_bIsOwnArchive(FALSE),
				m_pFile(NULL),
				m_pArchive(NULL),
				m_lPosition(0),
				m_lUndoBuffSizeMin(0),
				m_lUndoBuffSizeMax(0),
				m_lUndoBuffCurPos(0),
				m_callback(NULL),
				m_dwCallbackData(0)
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_bIsInterupt(FALSE),
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_vpLog(NULL)
{
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	Initialize(filep, iMode, pDoc, bIsForceFlat, lUndoBuffSizeMin, lUndoBuffSizeMax, vpLog);
	Initialize(filep, iMode, pDoc, lUndoBuffSizeMin, lUndoBuffSizeMax);
} // FCUndoArchive::FCUndoArchive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::FCUndoArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arc	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmJiOgHiCkE_xHqqkZx_CArchive_xZkqqHx_iBeC_xHqqkZx_
 *			lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFiPkMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			vpLog	:_xZkqqHx_iDiNiDePiCpAiCmGiCoJiClNiCnPiCmMiDhIiDeOiDfOiBfLiBeC_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiDiNiDePiCpAiCmGiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCUndoArchive::FCUndoArchive (	CArchive& arc,
								long lUndoBuffSizeMin,
								long lUndoBuffSizeMax)
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								WORDVector* vpLog)
			:	m_bIsOwnFile(FALSE),
				m_bIsOwnArchive(FALSE),
				m_pFile(NULL),
				m_pArchive(NULL),
				m_lPosition(0),
				m_lUndoBuffSizeMin(0),
				m_lUndoBuffSizeMax(0),
				m_lUndoBuffCurPos(0),
				m_callback(NULL),
				m_dwCallbackData(0)
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_bIsInterupt(FALSE),
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_vpLog(NULL)
{
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	Initialize(arc, lUndoBuffSizeMin, lUndoBuffSizeMax, vpLog);
	Initialize(arc, lUndoBuffSizeMin, lUndoBuffSizeMax);
} // FCUndoArchive::FCUndoArchive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::FCUndoArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_SDK_xZkqqHx_iCnGiCmM_xHqqkZx_Export_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCUndoArchive::FCUndoArchive ()
			:	m_bIsOwnFile(FALSE),
				m_bIsOwnArchive(FALSE),
				m_pFile(NULL),
				m_pArchive(NULL),
				m_lPosition(0),
				m_lUndoBuffSizeMin(0),
				m_lUndoBuffSizeMax(0),
				m_lUndoBuffCurPos(0),
				m_callback(NULL),
				m_dwCallbackData(0)
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_bIsInterupt(FALSE),
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//				m_vpLog(NULL)
{
} // FCUndoArchive::FCUndoArchive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wcpFilePath	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmJiOgHiCkEiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDgNiBfLiDhNiDiLiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			iMode	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmMiDiCiBfLiDgIiBeC_xHqqkZx_
 *			pDoc	:Document_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iPjBiCkLiNjOiCnNiCmFjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFiPkMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			vpLog	:_xZkqqHx_iDiNiDePiCpAiCmGiCoJiClNiCnPiCmMiDhIiDeOiDfOiBfLiBeC_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiDiNiDePiCpAiCmGiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmF_xHqqkZx_CFile_xZkqqHx_iBeB_xHqqkZx_CArchive_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CMemoryException_xZkqqHx_iBeB_xHqqkZx_CArchiveException_xZkqqHx_iBeB_xHqqkZx_CFileException
 *			_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmMjHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Initialize (const wchar_t* wcpFilePath,
								int iMode,
								CDocument* pDoc,
								long lUndoBuffSizeMin,
								long lUndoBuffSizeMax)
{
	BOOL bOpen;
// 06.01.06 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	CFCHIFSFile* pFile = new CFCHIFSFile();
	CFile* pFile = new CFile();
	if (iMode == FD_ARCHIVE_STORE)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCnGiDfIiDgHiDeBiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		bOpen = pFile->Open(wcpFilePath,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////							GENERIC_WRITE,
////							FILE_SHARE_READ,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//							CREATE_ALWAYS, NULL, NULL);
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		bOpen = pFile->Open(WStrToTStr(wcpFilePath), CFile::modeCreate | CFile::modeWrite | CFile::shareExclusive);
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} else
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCkJiCoHiDiNiBfLiDgIiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		bOpen = pFile->Open(wcpFilePath,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////							GENERIC_READ,
////							FILE_SHARE_READ,
////----- 05.10.27 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//							OPEN_EXISTING, NULL, NULL);
//----- 06.01.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		bOpen = pFile->Open(WStrToTStr(wcpFilePath), CFile::modeRead | CFile::shareDenyNone);
	}
	if (!bOpen)
	//----- _xZkqqHx_iDhEiDeAiDeDiDiLiDeJiBfLiDhGiDjDiCmJiOlIjEhDiClFiClNiPoKiNiH_xHqqkZx_ -----
	{
		delete pFile;
		FFThrowDDFileException(IDS_ERR_ERRNO_EACCES, wcpFilePath);
	}
	m_bIsOwnFile = TRUE;
	m_bIsOwnArchive = TRUE;
	m_pFile = pFile;
	int iArcMode = (iMode == FD_ARCHIVE_STORE) ? CArchive::store : CArchive::load;
	m_pArchive = new CArchive(m_pFile, iArcMode);
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMjAnNjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iCmMiPgPjHmNiCmMiClNiCnPiBeC_xHqqkZx_
	m_pArchive->m_pDocument = pDoc;
	// m_bForceFlat_xZkqqHx_iCmMjAnNjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iCmMiPgPjHmNiCmMiClNiCnPiBeC_xHqqkZx_
	m_pArchive->m_bForceFlat = TRUE;
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
	m_lPosition = 0;
	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lUndoBuffSizeMin = lUndoBuffSizeMin;
	m_lUndoBuffSizeMax = lUndoBuffSizeMax;
	m_lUndoBuffCurPos = 0;
	m_callback = NULL;
	m_dwCallbackData = 0;
} // FCUndoArchive::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	filep	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmJiOgHiCkE_xHqqkZx_CFile.
 *			iMode	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmMiDiCiBfLiDgIiBeC_xHqqkZx_
 *			pDoc	:Document_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iPjBiCkLiNjOiCnNiCmFjHjIjHhAiClDiCoKiCoJiBeC_xHqqkZx_
 *			lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFiPkMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			vpLog	:_xZkqqHx_iDiNiDePiCpAiCmGiCoJiClNiCnPiCmMiDhIiDeOiDfOiBfLiBeC_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiDiNiDePiCpAiCmGiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiBeB_xHqqkZx_CArchive_xZkqqHx_iDeOiDiJiDfIiDeJiDhFiDfHiDeGiDeOiDgHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDeHiDiJiBfLiOjOiCmJiBeB_xHqqkZx_CMemoryException_xZkqqHx_iBeB_xHqqkZx_CArchiveException_xZkqqHx_iBeB_xHqqkZx_CFileException
 *			_xZkqqHx_iCmMiCkCiClIiCoKiCkJiCmMjHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Initialize (CFile* filep,
								int iMode,
								CDocument* pDoc,
// 05.05.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								BOOL bIsForceFlat,
								long lUndoBuffSizeMin,
								long lUndoBuffSizeMax)
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								WORDVector* vpLog)
{
	m_bIsOwnFile = FALSE;
	m_bIsOwnArchive = TRUE;
	int iArcMode = (iMode == FD_ARCHIVE_STORE) ? CArchive::store : CArchive::load;
	m_pFile = filep;
	m_pArchive = new CArchive(m_pFile, iArcMode);
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCmMjAnNjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iCmMiPgPjHmNiCmMiClNiCnPiBeC_xHqqkZx_
	m_pArchive->m_pDocument = pDoc;
	// m_bForceFlat_xZkqqHx_iCmMjAnNjCoIiBeC_xHqqkZx_OLE_xZkqqHx_iCmMiPgPjHmNiCmMiClNiCnPiBeC_xHqqkZx_
// 05.05.28 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_pArchive->m_bForceFlat = bIsForceFlat;
	m_pArchive->m_bForceFlat = TRUE;
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
	m_lPosition = 0;
	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lUndoBuffSizeMin = lUndoBuffSizeMin;
	m_lUndoBuffSizeMax = lUndoBuffSizeMax;
	m_lUndoBuffCurPos = 0;
	m_callback = NULL;
	m_dwCallbackData = 0;
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_bIsInterupt = FALSE;
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_vpLog = vpLog;
//	if (m_vpLog != NULL) m_vpLog->clear();
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	SetIsInterupt(FALSE);
} // FCUndoArchive::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	arc	:_xZkqqHx_iDgGiBfLiDfOiCmMiDfIiDgHiDeBiBeFiDiNiBfLiDgIiCmJiOgHiCkE_xHqqkZx_CArchive_xZkqqHx_iBeC_xHqqkZx_
 *			lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFiPkMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKiOoGiCoIiCkGiCoJjCgMiCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
// *			vpLog	:_xZkqqHx_iDiNiDePiCpAiCmGiCoJiClNiCnPiCmMiDhIiDeOiDfOiBfLiBeC_xHqqkZx_NULL_xZkqqHx_iCmMiPoKiNiHiCmNiDiNiDePiCpAiCmGiCoHiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Initialize (CArchive& arc,
								long lUndoBuffSizeMin,
								long lUndoBuffSizeMax)
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//								WORDVector* vpLog)
{
	m_bIsOwnFile = FALSE;
	m_bIsOwnArchive = FALSE;
	m_pFile = arc.GetFile();
	m_pArchive = &arc;
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
	m_lPosition = 0;
	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_lUndoBuffSizeMin = lUndoBuffSizeMin;
	m_lUndoBuffSizeMax = lUndoBuffSizeMax;
	m_lUndoBuffCurPos = 0;
	m_callback = NULL;
	m_dwCallbackData = 0;
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_bIsInterupt = FALSE;
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	m_vpLog = vpLog;
//	if (m_vpLog != NULL) m_vpLog->clear();
//----- 05.05.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	SetIsInterupt(FALSE);
} // FCUndoArchive::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Terminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBfDiCmEiCmMiPpDjBnEiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_Terminate_xZkqqHx_iCmMiMoDiBeBiNmEiCnB_xHqqkZx_Initialize_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiClFiCmEiOgHiCkEiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Terminate ()
{
	Close();
	if (m_bIsOwnArchive)
	{
		delete m_pArchive;
	}
	m_pArchive = NULL;
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
	m_lPosition = 0;
	m_bIsOwnArchive = FALSE;

	if (m_bIsOwnFile)
	{
		delete m_pFile;
	}
	m_pFile = NULL;
	m_bIsOwnFile = FALSE;
} // FCUndoArchive::Terminate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::~FCUndoArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CArchive_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiPiKjHeMiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCUndoArchive::~FCUndoArchive ()
{
	Terminate();
} // FCUndoArchive::~FCUndoArchive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Close
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiDeOiDiNiBfLiDfJiClFiBeB_xHqqkZx_CFile_xZkqqHx_iCnGiDgGiBfLiDfOiCpAiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFile_xZkqqHx_iBeB_xHqqkZx_CArchive_xZkqqHx_iCpAiPiKjHeMiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_Close_xZkqqHx_iCpAiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmNiNoNiPjMiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *			Close_xZkqqHx_iMoDiCoAiBeB_xHqqkZx_GetArchive_xZkqqHx_iCpAiOgHjHhAiClHiCoJiClBiCmGiCmNiJmCjEfMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Close ()
{
	// _xZkqqHx_iKpJiCmJjFmCiClGiCmEiCkCiCoJiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!IsOpened()) return;

	Flush();
	if (m_bIsOwnArchive)
	{
		m_pArchive->Close();
	}
	if (m_bIsOwnFile)
	{
		m_pFile->Close();
	}

//----- 03.04.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDfEiDeDiDfJiCpAjAnNjCoIiBeC_xHqqkZx_
	m_vUndoBuff.clear();
	m_lUndoBuffSizeMin = 0;
	m_lUndoBuffSizeMax = 0;
	m_lUndoBuffCurPos = 0;
	m_callback = NULL;
	m_dwCallbackData = 0;
// 03.06.28 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_bIsInterupt = FALSE;
//----- 03.04.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_vpLog = NULL;
} // FCUndoArchive::Close.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::ResetUndoBuffer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiDiKiDfKiDgCiDgHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFiPkMjCgMiCpAiOhHjCoIiBeCiClBiCmMjCgMiCpA_xHqqkZx_
 *								 _xZkqqHx_iJnPiCkMiCmEjDmHiCnNiNjOiCnMiCoKiCmEiImIiNhOiCmNiBeB_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkK_xHqqkZx_
 *								 _xZkqqHx_iClBiCoKiCoGiCoIiPkMiClDiCkNiCmIiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFjBoFjCgMiCpAiOhHjCoIiBeCiClBiCoKiCoGiCoI_xHqqkZx_
 *								 _xZkqqHx_jBoFiCkLiCkNiCmIiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	Undo_xZkqqHx_jFkKiCmNiLpDiCmJiClDiCoKiCoJiBeC_xHqqkZx_Redo_xZkqqHx_jFkKiCmNiMlDiCmMiCnMiCnMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::ResetUndoBuffer (long lUndoBuffSizeMin,
									 long lUndoBuffSizeMax)
{
	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmM_xHqqkZx_Undo_xZkqqHx_jFkKiCpA_xHqqkZx_0_xZkqqHx_iCmJiBeC_xHqqkZx_Redo_xZkqqHx_jFkKiBgJ_xHqqkZx_Read_xZkqqHx_jFkKiBgKiCmNiOgDiClFiCmEiCkIiCkNiBeC_xHqqkZx_
	m_vUndoBuff.erase(m_vUndoBuff.begin(), m_vUndoBuff.begin() + m_lUndoBuffCurPos);
	m_lUndoBuffCurPos = 0;
	m_lUndoBuffSizeMin = lUndoBuffSizeMin;
	m_lUndoBuffSizeMax = lUndoBuffSizeMax;
} // FCUndoArchive::ResetUndoBuffer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetUndoBufferSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjAnNjCoIiClDiCoKiCmEiCkCiCoJ_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFjBoFjCgMiBeBiNmFiPkMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lUndoBuffSizeMin	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFiPkMjCgMiCpAjFnEiClHiBeCiClBiCmMjCgMiCpA_xHqqkZx_
 *								 _xZkqqHx_iJnPiCkMiCmEjDmHiCnNiNjOiCnMiCoKiCmEiImIiNhOiCmNiBeB_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkK_xHqqkZx_
 *								 _xZkqqHx_iClBiCoKiCoGiCoIiPkMiClDiCkNiCmIiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *			lUndoBuffSizeMax	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFjBoFjCgMiCpAjFnEiClHiBeCiClBiCoKiCoGiCoI_xHqqkZx_
 *								 _xZkqqHx_jBoFiCkLiCkNiCmIiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::GetUndoBufferSize (long& lUndoBuffSizeMin,
										long& lUndoBuffSizeMax) const
{
	lUndoBuffSizeMin = m_lUndoBuffSizeMin;
	lUndoBuffSizeMax = m_lUndoBuffSizeMax;
} // FCUndoArchive::GetUndoBufferSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetPosition
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCUndoArchive::GetPosition () const
{
	return m_lPosition;
} // FCUndoArchive::GetPosition.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Document_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	CArchive_xZkqqHx_iDiBiDjDiDgPiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CDocument* FCUndoArchive::GetDocument ()
{
	return m_pArchive->m_pDocument;
} // FCUndoArchive::GetDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::SetDocument
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDoc	:Document_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	CArchive_xZkqqHx_iDiBiDjDiDgPiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::SetDocument (CDocument* pDoc)
{
	m_pArchive->m_pDocument = pDoc;
} // FCUndoArchive::SetDocument.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetIsForceFlat
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CArchive::m_bForceFlat _xZkqqHx_iCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	m_bForceFlat _xZkqqHx_iCmMjCgMiBeC_xHqqkZx_OLE_xZkqqHx_jFkBiNiHiDhEiDeAiDeDiDiLiCpAiLeMjIfOiClHiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	m_bForceFlat _xZkqqHx_iCmNiBeB_xHqqkZx_OLE_xZkqqHx_jFkBiNiHiDhEiDeAiDeDiDiLiCmFiCkAiCoJiPoKiNiHiCmJiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeB_xHqqkZx_
 *			_xZkqqHx_jCmKiPoNiCmMiDhEiDeAiDeDiDiLiCmFiCkAiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *			m_bForceFlat _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeB_xHqqkZx_CClientItem (OLE_xZkqqHx_jFjEjFgJ_xHqqkZx_)_xZkqqHx_jCiGiCmM_xHqqkZx_
 *			OLE_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCmMiDgGiBfLiDfOiCmNiBeBjFkBiNiHiDhEiDeAiDeDiDiLiCmMjFmKiPoKiPiKiCkJiCoHjDmHiCnNiPjBiCkL_xHqqkZx_
 *			_xZkqqHx_iClDiCoKiCoJiBeCjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDfIiDgHiDiKiBfLiDiAiCmMiNkBjDmHiCnNiPjBiCkLiClFiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiPiKiCmFjDmHiCnNiPjBiCkLiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iCmCiCnMiCoIiBeB_xHqqkZx_m_bForceFlat _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_OLE_xZkqqHx_jFjEjFgJiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCmNjFhDjIeBjBlBiBeBjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeBiDfIiDgHiDiKiBfLiDiAiCkK_xHqqkZx_
 *			_xZkqqHx_jIeBjBlBiCmGiCmIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCUndoArchive::GetIsForceFlat () const
{
	return m_pArchive->m_bForceFlat;
} // FCUndoArchive::GetIsForceFlat.

//----- 05.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::SetIsForceFlat
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CArchive::m_bForceFlat _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bForceFlat	:m_bForceFlat _xZkqqHx_iCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_OLE_xZkqqHx_jFkBiNiHiDhEiDeAiDeDiDiLiCpA_xHqqkZx_
// *						 _xZkqqHx_iLeMjIfOiClHiCoJiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJpAjAoAiCmNiBeB_xHqqkZx_GetIsForceFlat_xZkqqHx_iCnGiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCUndoArchive::SetIsForceFlat (BOOL bForceFlat)
//{
//	m_pArchive->m_bForceFlat = bForceFlat;
//} // FCUndoArchive::SetIsForceFlat.
//----- 05.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::IsOpened
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CArchive_xZkqqHx_iCkKiDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeJiBfLiDhGiDjDiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCUndoArchive::IsOpened () const
{
	return (m_pArchive != NULL &&
			m_pArchive->GetFile() != NULL);
} // FCUndoArchive::IsOpened.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Flush
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCnGiDgPiDgCiDhEiDeAiCpAiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	CArchive_xZkqqHx_iDiBiDjDiDgPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Flush ()
{
	// _xZkqqHx_iClBiCmMiDhEiDiJiDgCiDfGiDiFiCmNjHiIiCmEiCmNiCnMiClIiCkCiBeC_xHqqkZx_
//	AfxDebugBreak();

	// _xZkqqHx_iKpJiCmJ_xHqqkZx_ Close_xZkqqHx_iClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiBeB_xHqqkZx_GetFile() == NULL_xZkqqHx_iBeC_xHqqkZx_
	if (IsOpened() && m_pArchive->IsStoring())
	//----- _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCkKjFnLjBlGjHhAiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiDhEiDiJiDgCiDfGiDiFiBeC_xHqqkZx_
		m_pArchive->Flush();
//----- 06.02.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jDoAjFjEiCmFiNoMjAkMiClFiClNiDhEiDeAiDeDiDiLiCmMiPoKiNiHiCmNiBeBiDhEiDiJiDgCiDfGiDiFiClHiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iDgPiDgCiDeOiDeBiDgCiDhGiNlHjFkKiDhEiDeAiDeDiDiLiCpAiNoMjAkMiClFiCmIiCkCiBeC_xHqqkZx_
//		if (m_bIsOwnFile)
//		{
//			if (!g_pFileServer->FlushAll())
//				FFThrowMiscException(g_pFileServer->GetErrorMessage());
//		}
//----- 06.02.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	}
} // FCUndoArchive::Flush.

//----- 03.04.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ( )-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::operator << (const CObject& obj)
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCmMiPjBiCkLiNjOiCnNiCpAiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	obj	:CObject_xZkqqHx_iMfOiDgGiBfLiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCUndoArchive& FCUndoArchive::operator << (const CObject& obj)
//{
//	ASSERT(m_vpLog == NULL);
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iPjBiCkLiNjOiCnNjBePiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
////	m_pArchive->Flush();
////	DWORD dwPos0 = m_pArchive->GetFile()->GetPosition();
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	*m_pArchive << &obj;
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_iPjBiCkLiNjOiCnNiMoDiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
////	m_pArchive->Flush();
////	DWORD dwPos1 = m_pArchive->GetFile()->GetPosition();
////	// _xZkqqHx_iDfEiDeDiDfJiCpAiLeMjIfOiBeC_xHqqkZx_
////	if (m_vpLog != NULL) m_vpLog->push_back(dwPos1 - dwPos0);
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	return *this;
//} // FCUndoArchive::operator << (const CObject& obj).
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::operator >> (CObject& obj)
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCmMjDmHiCnNiNjOiCnNiCpAiNhDiCkEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	obj	:CObject_xZkqqHx_iMfOiDgGiBfLiDfOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCUndoArchive& FCUndoArchive::operator >> (CObject& obj)
//{
//	ASSERT(m_vpLog == NULL);
//	CObject* objp = &obj;
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jDmHiCnNiNjOiCnNjBePiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
////	DWORD dwPos0 = m_pArchive->GetFile()->GetPosition();
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	*m_pArchive >> objp;
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////	// _xZkqqHx_jDmHiCnNiNjOiCnNiMoDiCmMiDhEiDeAiDeDiDiLiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
////	DWORD dwPos1 = m_pArchive->GetFile()->GetPosition();
////	// _xZkqqHx_iDfEiDeDiDfJiCpAiLeMjIfOiBeC_xHqqkZx_
////	if (m_vpLog != NULL) m_vpLog->push_back(dwPos1 - dwPos0);
////----- 03.04.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//	return *this;
//} // FCUndoArchive::operator >> (CObject& obj).
//----- 03.04.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ( )-----

//----- 03.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::operator << (const CObject* pObj)
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCUndoArchive& FCUndoArchive::operator << (const CObject* pObj)
//{
//	ASSERT(m_vpLog == NULL);
//	*m_pArchive << pObj;
//	return *this;
//} // FCUndoArchive::operator << (const CObject* pObj).
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::operator >> (CObject*& pObj)
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCUndoArchive& FCUndoArchive::operator >> (CObject*& pObj)
//{
//	ASSERT(m_vpLog == NULL);
//	ASSERT(m_lUndoBuffCurPos == m_vUndoBuff.size());
//	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmJiDfCiDhDiBfLiCpAiOoGiCoKiCmIiCkCiClNiCnPiBeBiLpDiCmJiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	m_vUndoBuff.clear();
//	*m_pArchive >> pObj;
//	return *this;
//} // FCUndoArchive::operator >> (CObject*& pObj).
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::operator >> (const CObject*& pObj)
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
// *
// * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//FCUndoArchive& FCUndoArchive::operator >> (const CObject*& pObj)
//{
//	ASSERT(m_vpLog == NULL);
//	ASSERT(m_lUndoBuffCurPos == m_vUndoBuff.size());
//	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmJiDfCiDhDiBfLiCpAiOoGiCoKiCmIiCkCiClNiCnPiBeBiLpDiCmJiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
//	m_vUndoBuff.clear();
//	*m_pArchive >> pObj;
//	return *this;
//} // FCUndoArchive::operator >> (const CObject*& pObj).
//
//----- 03.05.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
//----- 03.04.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ( )-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Write
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjClHiClDiCmMiDfIiDgHiDiKiBfLiDiAiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCmMjAoGjDkKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
 *			lSize	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiCmNiBeBjHfMiCnPiPjBiCkLiNjOiCpBiCmFiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Write (const void* pData, long lSize)
{
// 03.06.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_pArchive->Write(pData, lSize);
	WriteToArchive((const BYTE*)pData, lSize);
// 05.05.24 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	if (m_vpLog != NULL) m_vpLog->push_back(lSize);
} // FCUndoArchive::Write.

//----- 03.04.28 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ( )-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Read
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjClHiClDiCmMiDfIiDgHiDiKiBfLiDiAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	data	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCpAiOpDiCkPiOoGiCoJjAoGjDkKiDeBiDgIiDiMiDfIiBeC_xHqqkZx_
// *			size	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiCmNiBeBjHfMiCnPjDmHiCnNiNjOiCpBiCmFiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCUndoArchive::Read (void* data, long size)
//{
//	m_pArchive->Read(data, size);
//	if (m_vpLog != NULL) m_vpLog->push_back(size);
//} // FCUndoArchive::Read.
//----- 03.04.28 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ( )-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Read
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjClHiClDiCmMiDfIiDgHiDiKiBfLiDiAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCpAiOpDiCkPiOoGiCoJjAoGjDkKiDeBiDgIiDiMiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSize	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pError	:_xZkqqHx_iDeHiDiJiBfLiBgJjDmHiCnNiNjOiCnNiDgGiBfLiDfOjClHiCkKiOhHjCoIiCoGiCoIjCfKiCkCiPoKiNiHiCmIiCmHiBgKiCpA_xHqqkZx_
 *					 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *					 NULL _xZkqqHx_iCmMiPoKiNiHiCmNjHoBiKePiCpAjEkNjAlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmJjDmHiCnNiNjOiCpBiClOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiCmNiBeBjHfMiCnPjDmHiCnNiNjOiCpBiCmFiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCUndoArchive::Read (void* pData, long lSize, CException** pError)
{
	BYTE* bypData = (BYTE*)pData;
	long lBuffSize = lSize;

	// 1. Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmJ_xHqqkZx_Redo_xZkqqHx_jFkKiCkKjBlGiNnNiClHiCoJiPoKiNiHiCmNiBeBiClLiCoKiCpAjDfNjBjHiBeC_xHqqkZx_
	//    _xZkqqHx_iClBiCmMiPiIjHjNiCmNiBeB_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiOgHiCoNiCmIiCkCiPoKiNiHiCoAiNhDiCkEiBeC_xHqqkZx_
	//    _xZkqqHx_jDhCjCiGiCmF_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiOgHiCoNiCmIiCkCiPiIjHjNiCmJjAnIiCoIjBnGiCkGiClNiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
	// 2. 1._xZkqqHx_iCmFjBkLiCoIiCmIiCkCiPoKiNiHiCmNiBeB_xHqqkZx_CArchive_xZkqqHx_iCkJiCoHiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	// 3. _xZkqqHx_iOoGiCoIiPgPiClFiClNjFkKiCmFiBeBjFeLjHhGiCmIiClOiCkP_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmJiDfCiDhDiBfLiBeC_xHqqkZx_

	// _xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiDfEiDeDiDfJiBeC_xHqqkZx_
	DWORD dwReadSize = 0;

	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmJ_xHqqkZx_Redo_xZkqqHx_jFkKiCkKjBlGiNnNiClHiCoJiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
	long lRedoSize = m_vUndoBuff.size() - m_lUndoBuffCurPos;
	if (lRedoSize != 0)
	//----- Redo_xZkqqHx_jFkKiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (lBuffSize < lRedoSize) lRedoSize = lBuffSize;
		memcpy(bypData, m_vUndoBuff.begin() + m_lUndoBuffCurPos, lRedoSize);
		m_lUndoBuffCurPos += lRedoSize;
		bypData += lRedoSize;
		lBuffSize -= lRedoSize;
		dwReadSize += lRedoSize;
	}
	// _xZkqqHx_jFhDjBkLjFkKiCpA_xHqqkZx_CArchive_xZkqqHx_iCkJiCoHiOoGiCoIiPgPiClHiBeC_xHqqkZx_
// 03.06.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	lBuffSize = m_pArchive->Read(bypData, lBuffSize);
	lBuffSize = ReadFromArchive(bypData, lBuffSize);

	dwReadSize += lBuffSize;

	//-----------------------------
	// _xZkqqHx_iDfAiBfLiDfIiCfAiBeC_xHqqkZx_
	// m_lUndoBuffSizeMin = 10
	// m_lUndoBuffSizeMax = 20
	// m_vUndoBuff.size() = 18
	// lBuffSize = 11
	//-----------------------------
	// _xZkqqHx_iDfAiBfLiDfIiCfBiBeC_xHqqkZx_
	// m_lUndoBuffSizeMin = 10
	// m_lUndoBuffSizeMax = 20
	// m_vUndoBuff.size() = 18
	// lBuffSize = 9
	//-----------------------------
	// _xZkqqHx_iDfAiBfLiDfIiCfCiBeC_xHqqkZx_
	// m_lUndoBuffSizeMin = 10
	// m_lUndoBuffSizeMax = 20
	// m_vUndoBuff.size() = 13
	// lBuffSize = 6
	//-----------------------------

	if (lBuffSize != 0 && m_lUndoBuffSizeMin != 0)
	//----- Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiDfEiDeDiDfJiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		if (m_lUndoBuffSizeMax < m_vUndoBuff.size() + lBuffSize)
		//----- _xZkqqHx_iDgPiDgCiDhEiDeAiCkKiNmFjBoFjCgMiCpAiIoMiCoKiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (m_lUndoBuffSizeMin < lBuffSize)
			//----- _xZkqqHx_iDgPiDgCiDhEiDeAiNmFiPkMjCgMiCoGiCoI_xHqqkZx_CArchive_xZkqqHx_iCkJiCoHjDfNjBjHiClFiClNjFkKiCkKjBoFiCkLiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCpAjAfGiClFiCkCjFkKiCmFjBfDiCmEjDpMiCoKiKlHiCkGiCmEiClFiCnMiCkEiBeC_xHqqkZx_
				m_vUndoBuff.resize(m_lUndoBuffSizeMin);
				memcpy(m_vUndoBuff.begin(), bypData + lBuffSize - m_lUndoBuffSizeMin, m_lUndoBuffSizeMin);
			} else
			//----- _xZkqqHx_iDgPiDgCiDhEiDeAiNmFiPkMjCgMiCoGiCoI_xHqqkZx_CArchive_xZkqqHx_iCkJiCoHjDfNjBjHiClFiClNjFkKiCkKiPkMiClDiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iPfNjHiI_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAjCiGiCmJiCkAiCmBiClNiCoAiCmMiCpAiBeBjFeLjHhGiCmIiClOiCkPiNoNiCmBiCmEjAfGiClFiCkNjFoCiPfLiBeC_xHqqkZx_
				long lEraseSize = (m_vUndoBuff.size() + lBuffSize) - m_lUndoBuffSizeMin;
				m_vUndoBuff.erase(m_vUndoBuff.begin(), m_vUndoBuff.begin() + lEraseSize);
				m_vUndoBuff.insert(m_vUndoBuff.end(), bypData, bypData + lBuffSize);
			}
		} else
		//----- _xZkqqHx_iDgPiDgCiDhEiDeAiCkKiNmFjBoFjCgMiCpAiIoMiCoKiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCnGiLeMjIfOiBeC_xHqqkZx_
			m_vUndoBuff.insert(m_vUndoBuff.end(), bypData, bypData + lBuffSize);
		}
		// _xZkqqHx_iDgPiDgCiDhEiDeAiMlLiNnNiImKjChFiCpAjClCjAkOiClFiCmE_xHqqkZx_Redo_xZkqqHx_jFkKiCpAiCePiCmJiBeC_xHqqkZx_
		m_lUndoBuffCurPos = m_vUndoBuff.size();
	}

	if (lSize != dwReadSize)
	//----- _xZkqqHx_jDmHiCnNiNjOiCnNiCkKjHfMjCoIiClDiCoKiCmEiCkCiClNiDfEiDeDiDfJiCmGiOmAiNnLiCmJjDmHiCnNiNjOiCnMiCoKiClNiDgGiBfLiDfOiDfEiDeDiDfJiCkKiInJiCmIiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jHfMiKpKiClFiCmIiCkC_xHqqkZx_EOF_xZkqqHx_iCkKjEkNjAlGiClFiCnMiClFiClNiBeC_xHqqkZx_
		CException* pErr = new CFCMiscException(IDS_ERR_MSG_UNEXPECTED_EOF);
		if (pError != NULL)
		{
			*pError = pErr;
		} else
		{
			throw pErr;
		}
	}
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
	m_lPosition += dwReadSize;
	return dwReadSize;
} // FCUndoArchive::Read.
//----- 03.04.28 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ( )-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Skip
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjClHiClDiCmMiDfIiDgHiDiKiBfLiDiAiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lSize	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pError	:_xZkqqHx_iDeHiDiJiBfLiBgJjDmHiCnNiNjOiCnNiDgGiBfLiDfOjClHiCkKiOhHjCoIiCoGiCoIjCfKiCkCiPoKiNiHiCmIiCmHiBgKiCpA_xHqqkZx_
 *					 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *					 NULL _xZkqqHx_iCmMiPoKiNiHiCmNjHoBiKePiCpAjEkNjAlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iOmAiNnLiCmJiDfIiDeMiDgCiDhGiClFiClNiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjClHiCmNiBeBjHfMiCnPjDmHiCnNiNjOiCpBiCmFiCkIiCkNjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCUndoArchive::Skip (long lSize, CException** pError)
{
	BYTE byaDummy[FD_READ_WRITE_BYTE_SIZE];
	DWORD dwDataSize = 0;
	for (;;)
	{
		if (lSize < FD_READ_WRITE_BYTE_SIZE)
		{
			dwDataSize += Read(byaDummy, lSize, pError);
			break;
		}
		DWORD dwReadSize = Read(byaDummy, FD_READ_WRITE_BYTE_SIZE, pError);
		dwDataSize += dwReadSize;
		lSize -= dwReadSize;
		if (dwReadSize != FD_READ_WRITE_BYTE_SIZE) break;
	}
	return dwDataSize;
} // FCUndoArchive::Skip.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::WriteString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBjClHiCkK_xHqqkZx_WORD(2Byte)_xZkqqHx_iCmJiOpLiCnMiCoJjFlGiOjKjHpBiCmMiPgPjHmNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::WriteString (const WString& str)
{
	*m_pArchive << WORD(str.length());
	Write(str.c_str(), str.length() * sizeof(wchar_t));
} // FCUndoArchive::WriteString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::ReadString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBjClHiCkK_xHqqkZx_WORD(2Byte)_xZkqqHx_iCmJiOpLiCnMiCoJjFlGiOjKjHpBiCmMjDpMjHmNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str	:_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			pError	:_xZkqqHx_iDeHiDiJiBfLiBgJjDmHiCnNiNjOiCnNiDgGiBfLiDfOjClHiCkKiOhHjCoIiCoGiCoIjCfKiCkCiPoKiNiHiCmIiCmHiBgKiCpA_xHqqkZx_
 *					 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *					 NULL _xZkqqHx_iCmMiPoKiNiHiCmNjHoBiKePiCpAjEkNjAlGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::ReadString (WString& str, CException** pError)
{
	WORD wLen;
// 03.04.28 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ( )
//	*m_pArchive >> wLen;
	if (Read(&wLen, sizeof(wLen), pError) != sizeof(wLen)) return;
	WCharVector wvBuff(wLen);
	Read(wvBuff.begin(), wLen * sizeof(wchar_t), pError);
	wvBuff.push_back(L'\0');
	str = wvBuff.begin();
} // FCUndoArchive::WriteString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Undo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKpJiCmJjDmHiCnNiNjOiCpBiClOiDgGiBfLiDfOiCpAiBeBiOhHjCoIiCmMiDfEiDeDiDfJjFkKjGnPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lSize	:_xZkqqHx_jGnPiClHiDgGiBfLiDfOjHmKiCpAiOhHjCoIiBeC_xHqqkZx_-1_xZkqqHx_iCpAiOhHjCoIiClHiCoJiCmGiBeBiDgPiDgCiDhEiDeAjCiGiCmM_xHqqkZx_
 *					 _xZkqqHx_jBfDiCmEiCpAjGnPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	lSize_xZkqqHx_iCmNiBeB_xHqqkZx_lUndoBuffSizeMin _xZkqqHx_iCpAiJhKiCkGiCmEiCmNiCmIiCoHiCmIiCkCiBeCiCnMiClNiBeB_xHqqkZx_
 *			Undo_xZkqqHx_iCpAiPgEiCmLiCmEiBeB_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCkKjBkLiCoIiCmIiCkNiCmIiCoJiClBiCmGiCoAiDfPiDiBiBeC_xHqqkZx_
 *			Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNmFiPkMjCgMiCmNiBeB_xHqqkZx_Undo_xZkqqHx_iCmMiDfEiDeDiDfJiCpAjBhKjCoIiClFiCmEiBeBiClLiCoKiCoGiCoI_xHqqkZx_
 *			_xZkqqHx_jBoFiCkLiCkCjCgMiCpAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FCUndoArchive::Undo (long lSize)
{
	if (lSize == -1)
		lSize = m_lUndoBuffCurPos;
	if (m_lUndoBuffSizeMin < lSize) return FALSE;
	if (m_lUndoBuffCurPos < lSize) return FALSE;
	// _xZkqqHx_iDgPiDgCiDhEiDeAiMlLiNnNiImKjChFiCpAjClCjAkOiClFiCmE_xHqqkZx_Redo_xZkqqHx_jFkKiCmJ_xHqqkZx_lSize_xZkqqHx_iJmBiOfKiBeC_xHqqkZx_
	m_lUndoBuffCurPos -= lSize;
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
	m_lPosition -= lSize;
	return TRUE;
} // FCUndoArchive::Undo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::Undo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDgGiBfLiDfOiCpA_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmJjGnPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmJjGnPiClHiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSize	:_xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	Undo (long lSize) _xZkqqHx_iCmGiInJiCmIiCoIiBeB_xHqqkZx_lUndoBuffSizeMax = 0 _xZkqqHx_iCmFiCkAiCmBiCmEiCoA_xHqqkZx_
 *			_xZkqqHx_jDkOiNoMiClHiCoJiBeCjGnPiClFiClNiDgGiBfLiDfOiCmNiBeBiOmAiNnLiCmJjDmHiCnNiPgPiClDiCoKiClNiDgGiBfLiDfOiCmG_xHqqkZx_
 *			_xZkqqHx_iInJiCmIiCmBiCmEiCkCiCmEiCoAjDkOiNoMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::Undo (const void* pData, long lSize)
{
	// Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmM_xHqqkZx_Undo_xZkqqHx_jFkKiCpA_xHqqkZx_0_xZkqqHx_iCmJiBeC_xHqqkZx_
	m_vUndoBuff.erase(m_vUndoBuff.begin(), m_vUndoBuff.begin() + m_lUndoBuffCurPos);
	m_lUndoBuffCurPos = 0;
	m_vUndoBuff.insert(m_vUndoBuff.begin(), (BYTE*)pData, (BYTE*)pData + lSize);
	// _xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmEiCkJiCoHjDmHiCnNiNjOiCnMiCoKiClN_xHqqkZx_/_xZkqqHx_iPjBiCkLiNjOiCnMiCoKiClNiBeBiMlLiNnNiImKjChFiBeC_xHqqkZx_
	m_lPosition -= lSize;
} // FCUndoArchive::Undo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetUndoCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Undo_xZkqqHx_jFkKiCmMjBoFiCkLiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Undo_xZkqqHx_jFkKiCmMjBoFiCkLiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_20_xZkqqHx_iDgPiDeDiDgH_xHqqkZx_Undo_xZkqqHx_jFkKiCkKiCkAiCoJiPoKiNiHiCmNiBeB_xHqqkZx_20_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCUndoArchive::GetUndoCount () const
{
	return m_lUndoBuffCurPos;
} // FCUndoArchive::GetUndoCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetRedoCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Redo_xZkqqHx_jFkKiCmMjBoFiCkLiClDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Redo_xZkqqHx_jFkKiCmMjBoFiCkLiClDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	_xZkqqHx_jHoBiCkGiCmOiBeB_xHqqkZx_20_xZkqqHx_iDgPiDeDiDgH_xHqqkZx_Redo_xZkqqHx_jFkKiCkKiCkAiCoJiPoKiNiHiCmNiBeB_xHqqkZx_20_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCUndoArchive::GetRedoCount () const
{
	return (m_vUndoBuff.size() - m_lUndoBuffCurPos);
} // FCUndoArchive::GetRedoCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetBufferCount
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Redo/Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCmMiNiHiMhGiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCUndoArchive::GetBufferCount () const
{
	return m_vUndoBuff.size();
} // FCUndoArchive::GetBufferCount.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCiGiCmJiCkAiCoJiBeB_xHqqkZx_CArchive_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	CArchive_xZkqqHx_iDeJiDhFiDfHiDeGiDeOiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CArchive* FCUndoArchive::GetArchive ()
{
	return m_pArchive;
} // FCUndoArchive::GetArchive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::SetCallback
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCmMjDmHiCnNiNjOiCnNiBeFiPjBiCkLiPgPiClFiCmMiBeBiIoKjCoIiDgPiDeDiDgHiClCiCmGiCmJiMmEiCnBiPgPiClF_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	callback	:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwData		:_xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCmJjDgOiClDiCoKiCoJiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::SetCallback (FTCallbackUndoArchive callback, DWORD dwCallbackData)
{
	m_callback = callback;
	m_dwCallbackData = dwCallbackData;
} // FCUndoArchive::SetCallback.

//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::GetIsInterupt
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnN_xHqqkZx_/_xZkqqHx_iPjBiCkLiPgPiClFjCoCiOhOiDhEiDiJiDePiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCoCiOhOiPpDjBnEiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL FCUndoArchive::GetIsInterupt ()
//{
//	// m_bIsInterupt _xZkqqHx_iCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiCmJjDpMiOlKiBeC_xHqqkZx_
//	EnterCriticalSection(&m_csIsInterupt.cs);
//	// _xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//	BOOL bIsInterupt = m_bIsInterupt;
//	// m_bIsInterupt _xZkqqHx_iCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiCkJiCoHjBnOiOlKiBeC_xHqqkZx_
//	LeaveCriticalSection(&m_csIsInterupt.cs);
//	return bIsInterupt;
//} // FCUndoArchive::GetIsInterupt.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::SetIsInterupt
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnN_xHqqkZx_/_xZkqqHx_iPjBiCkLiPgPiClFjCoCiOhOiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsInterupt	:_xZkqqHx_jCoCiOhOiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCUndoArchive::SetIsInterupt (BOOL bIsInterupt)
//{
//	// m_bIsInterupt _xZkqqHx_iCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiCmJjDpMiOlKiBeC_xHqqkZx_
//	EnterCriticalSection(&m_csIsInterupt.cs);
//	// _xZkqqHx_jAnNjCoIiBeC_xHqqkZx_
//	m_bIsInterupt = bIsInterupt;
//	// m_bIsInterupt _xZkqqHx_iCmMiDeOiDiKiDgFiDeCiDeKiDiLiDfKiDeOiDfGiDiHiDjDiCkJiCoHjBnOiOlKiBeC_xHqqkZx_
//	LeaveCriticalSection(&m_csIsInterupt.cs);
//} // FCUndoArchive::SetIsInterupt.
//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


void FCUndoArchive::WriteObject (const CDocItem* pObj)
{
//----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	ASSERT(FALSE);
//----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (GetBufferCount() != 0) FFThrowMiscUnknown();
	*GetArchive() << pObj;
//----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
};

void FCUndoArchive::ReadObject (CDocItem*& pObj)
{
//----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	ASSERT(FALSE);
//----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	long lUndoBuffSizeMin;
	long lUndoBuffSizeMax;
	GetUndoBufferSize(lUndoBuffSizeMin, lUndoBuffSizeMax);
	// ar _xZkqqHx_iCkJiCoH_xHqqkZx_ CArchive _xZkqqHx_iCpAiOoGiCoIiPgPiClFiCmEiOgHiCkEiClNiCnPiBeB_xHqqkZx_Undo_xZkqqHx_iDgPiDgCiDhEiDeAiCpAiLpDiCmJiClHiCoJiBeC_xHqqkZx_
	ResetUndoBuffer(0, 0);
	// Redo_xZkqqHx_iDgPiDgCiDhEiDeAiCmNiLpDiCmFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	if (GetBufferCount() != 0) FFThrowMiscUnknown();
	*GetArchive() >> pObj;
	// _xZkqqHx_iDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiMlDiCmJjGnPiClHiBeC_xHqqkZx_
	ResetUndoBuffer(lUndoBuffSizeMin, lUndoBuffSizeMax);
//----- 05.05.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
};

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::WriteToArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiCmM_xHqqkZx_CArchive_xZkqqHx_iCmJiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_iPjBiCkLiNjOiCnOiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSize	:pData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBoFiCkLiCmIiDgGiBfLiDfOiCmMiPjBiCkLiPgPiClFiCpAiIoKjCoIiDfEiDeDiDfJiCmJjFkKiKiEiClFiCmEiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jDhCjCiGiCmFjFmKiDhGiDiNiDfKiDfIiCkJiCoHjCoCiOhOiOhHiOkGiCkKiCkAiCmBiClNiPoKiNiHiBeBjHoBiKePiCpA_xHqqkZx_
 *			_xZkqqHx_jEkNjAlGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCUndoArchive::WriteToArchive (const BYTE* pData, long lSize)
{
	for (;;)
	{
//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jCoCiOhOiOhHjCoIiCmIiCoHiPeJjHlJiBeC_xHqqkZx_
//		if (GetIsInterupt()) break;
//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		if (m_callback != NULL)
			(*m_callback)(this, m_dwCallbackData);
		if (lSize < FD_READ_WRITE_BYTE_SIZE)
		{
			m_pArchive->Write(pData, lSize);
			break;
		}
		m_pArchive->Write(pData, FD_READ_WRITE_BYTE_SIZE);
		pData += FD_READ_WRITE_BYTE_SIZE;
		lSize -= FD_READ_WRITE_BYTE_SIZE;
	}
} // FCUndoArchive::WriteToArchive.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCUndoArchive::ReadFromArchive
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiCmM_xHqqkZx_CArchive_xZkqqHx_iCkJiCoHiDgGiBfLiDfOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_jDmHiCnNiNjOiCnOiDgGiBfLiDfOiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lSize	:pData_xZkqqHx_iCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCpBiClOiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jBoFiCkLiCmIiDgGiBfLiDfOiCmMjDmHiCnNiNjOiCnNiCpAiIoKjCoIiDfEiDeDiDfJiCmJjFkKiKiEiClFiCmEjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *			_xZkqqHx_jDhCjCiGiCmFjFmKiDhGiDiNiDfKiDfIiCkJiCoHjCoCiOhOiOhHiOkGiCkKiCkAiCmBiClNiPoKiNiHiBeBjHoBiKePiCpA_xHqqkZx_
 *			_xZkqqHx_jEkNjAlGiClDiClJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FCUndoArchive::ReadFromArchive (BYTE* pData, long lSize)
{
	DWORD dwDataSize = 0;
	for (;;)
	{
//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//		// _xZkqqHx_jCoCiOhOiOhHjCoIiCmIiCoHiPeJjHlJiBeC_xHqqkZx_
//		if (GetIsInterupt()) break;
//----- 03.06.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
		if (m_callback != NULL)
			(*m_callback)(this, m_dwCallbackData);
		if (lSize < FD_READ_WRITE_BYTE_SIZE)
		{
			dwDataSize += m_pArchive->Read(pData, lSize);
			break;
		}
		DWORD dwReadSize = m_pArchive->Read(pData, FD_READ_WRITE_BYTE_SIZE);
		dwDataSize += dwReadSize;
		pData += dwReadSize;
		lSize -= dwReadSize;
		if (dwReadSize != FD_READ_WRITE_BYTE_SIZE) break;
//		Sleep(100);
	}
	return dwDataSize;
} // FCUndoArchive::ReadFromArchive.

