#ifndef __UtilErr_h
#define __UtilErr_h

#include "resource.h"	// For IDS_ERR_FILE_UNKNOWN.

class CFCDDFileException : public CFileException
{
	DECLARE_DYNCREATE(CFCDDFileException)

public:
	CFCDDFileException (DWORD dwCode = IDS_ERR_FILE_UNKNOWN, const wchar_t* wcpFilePath = NULL);
	virtual BOOL GetErrorMessage (LPTSTR lpszError, UINT nMaxError, PUINT pnHelpContext = NULL);
	DWORD	m_dwErrCode;
}; // class CFCDDFileException.

class CFCMiscException : public CException
{
	DECLARE_DYNCREATE(CFCMiscException)

public:
	CFCMiscException ();
	CFCMiscException (DWORD dwMessageId, ...);
	virtual BOOL GetErrorMessage (LPTSTR lpszError, UINT nMaxError, PUINT pnHelpContext = NULL);
	virtual DWORD GetMessageId () const;

friend void FFThrowMiscExceptionCode (DWORD dwMessageId);
friend void FFThrowMiscException (DWORD dwMessageId, ...);
friend void FFThrowMiscException (const wchar_t* wcpMessage);
friend void FFThrowMiscLastError ();
friend void FFThrowMiscUserException (DWORD dwMessageId, const wchar_t* wcpMessage);

protected:
	DWORD		m_dwMessageId;
	WString		m_strMsg;
}; // class CFCMiscException.

//----- 06.02.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
extern void		FFResetDDError ();
extern void		FFSetDDErrorCodeMessage (DWORD dwErrCode, const wchar_t* wcpErrMessage);
extern void		FFSetDDError (DWORD dwMessageId, ...);
extern DWORD	FFGetDDErrorCode ();
extern WString	FFGetDDErrorMessage ();
//----- 06.02.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

extern WString FFGetErrorMessage (	CException* pE,
									PUINT pnHelpContext = NULL);
extern DWORD FFGetErrorCode (CException* pE);
extern void FFThrowFileException (int cause, LONG lOsError = -1,
									const wchar_t* lpszFileName = NULL);
extern void FFThrowDDFileException (DWORD dwCode = IDS_ERR_FILE_UNKNOWN,
									const wchar_t* wcpFilePath = NULL);

extern void FFThrowMiscExceptionCode (DWORD dwMessageId);
extern void FFThrowMiscException (DWORD dwMessageId, ...);
extern void FFThrowMiscException (const wchar_t* wcpMessage);
extern void FFThrowMiscLastError ();
extern void FFThrowMiscUserException (DWORD dwMessageId, const wchar_t* wcpMessage);

// _xZkqqHx_iDhEiDeIiDjDiDgHiDeHiDiJiBfLiDiBiDgCiDfKiBfLiDfHiCmMjFfMiOkGiCmJjBmOiJjOiClFiCmEiBeBiDfEiDeDiDfJiOhHjCoIiCpAiJmCjEfMiCmJiClFiClNiBeC_xHqqkZx_
extern int FFMessageBox (DWORD dwText,
						DWORD dwCaption = 0, DWORD dwType = MB_OK,
						CSize szTextBox = CSize(0,0));
extern int FFMessageBox (const wchar_t* wcpText,
						const wchar_t* wcpCaption = NULL,
						DWORD dwType = MB_OK, CSize szTextBox = CSize(0,0));

extern BOOL	FFMakeDdSlideFile (const wchar_t* wcpScenario, const wchar_t* wcpDdSlideFile);
extern int	FFImageMessageBox (const wchar_t* wcpDdSlideFile);

//----- 06.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//extern void FFErrorBox (FTIsShowErrorMessageBox errboxShow, DWORD dwFormatId, ...);
//extern void FFErrorBoxV (FTIsShowErrorMessageBox errboxShow, DWORD dwFormatId, va_list argList);
//extern void FFErrorBox (FTIsShowErrorMessageBox errboxShow,
//						const wchar_t* wcpText, CSize szTextBox = CSize(0,0));
//----- 06.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
extern void FFErrorBox (DWORD dwFormatId, ...);
extern void FFErrorBoxV (DWORD dwFormatId, va_list argList);
extern void FFErrorBox (const wchar_t* wcpText, CSize szTextBox = CSize(0,0));
//----- 06.04.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

extern void FFDebugTrace (const wchar_t* wcpFormat, ...);

extern void FFReleaseTrace (const wchar_t* wcpFormat, ...);
extern void FFReleaseTraceMessage (const wchar_t* wcpMessage);
extern void FFReleaseOutputOn ();

// _xZkqqHx_jGkCjCoIiLgAiDeHiDiJiBfLiBeC_xHqqkZx_
#define FFThrowMiscUnknown()	{ AfxDebugBreak(); FFThrowMiscException(IDS_ERR_MISC_UNKNOWN, (const wchar_t*)TStrToWStr(__FILE__), __LINE__); }

// 06.04.22 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//#define FFErrBoxMiscUnknown()	FFErrorBox(FD_ERRBOX_SHOW, IDS_ERR_MISC_UNKNOWN, (const wchar_t*)TStrToWStr(__FILE__), __LINE__)
#define FFErrBoxMiscUnknown()	FFErrorBox(IDS_ERR_MISC_UNKNOWN, (const wchar_t*)TStrToWStr(__FILE__), __LINE__)

#endif//__UtilErr_h
