// UtilFont.cpp

#include "stdafx.h"
#include "resource.h"		// For IDS_xx.
//----------<NOT EXPORT TO VIEWER>-----------
#include "RegData.h"		// For FCRegData.
//----------</NOT EXPORT TO VIEWER>-----------
#include "UtilCoord.h"		// For mm2lg.etc.
#include "UtilStr.h"		// For FFExtractUntil.
#include "UtilFile.h"		// For BYTEVector <<.
#include "UtilWin.h"		// For FFNotifyPendingMessage.
#include "UtilFont.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//------------------------------------------------------------------------
// FTBoldItalicMap
// WORD _xZkqqHx_iCmMiJlKiImK_xHqqkZx_8Bit_xZkqqHx_iCmNiBeBiDhEiDeIiDjDiDgHiCkK_xHqqkZx_Italic_xZkqqHx_iCkJiCmHiCkEiCkJiBeBiPoDiImK_xHqqkZx_8Bit_xZkqqHx_iCmN_xHqqkZx_Bold_xZkqqHx_iCkJiCmHiCkEiCkJiBeC_xHqqkZx_
// _xZkqqHx_iDhEiDeIiDjDiDgHiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeIiDjDiDgHiCmMiPoOjFpBiCmJiKoOiCmDiCkCiCmEjAnNjCoIiBeC_xHqqkZx_
// DWORD _xZkqqHx_iCmMiJlKiImK_xHqqkZx_16Bit_xZkqqHx_iCmNiBeBiDhEiDeIiDjDiDgHiCkK_xHqqkZx_Italic_xZkqqHx_iCkJiCmHiCkEiCkJiBeBiPoDiImK_xHqqkZx_16Bit_xZkqqHx_iCmN_xHqqkZx_Weight_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
// _xZkqqHx_iDhEiDeIiDjDiDgHiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJjAjEjCgM_xHqqkZx_(LOGFONT)_xZkqqHx_iCmJiKoOiCmDiCkCiCmEjAnNjCoIiBeC_xHqqkZx_
// WORD _xZkqqHx_iCkK_xHqqkZx_ 1,1 _xZkqqHx_iClOiCkJiCoHiCmGiMlOiCmBiCmEiBeB_xHqqkZx_DWORD _xZkqqHx_iCkK_xHqqkZx_ FW_BOLD, 1 _xZkqqHx_iCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
//-------------------------------------------------------------------------
typedef map<WORD, DWORD> FTBoldItalicMap;

// TrueType_xZkqqHx_iCmFiCmNiCmIiCkCiDhEiDeIiDjDiDgHiCkKiOgHiCoNiCoKiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJiClNiCnPjFeLjHhGiBeC_xHqqkZx_
// _xZkqqHx_iDeDiDjDiDfIiDgHiBfLiDiLiClDiCoKiCmEiCkCiCmIiCkCiDhEiDeIiDjDiDgHiCpAiLeMjIfOiClHiCoJjFmPjAjEiBeC_xHqqkZx_
static set<FCErrFontInfo> s_stErrFontInfo;

// _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmM_xHqqkZx_LOGFONT_xZkqqHx_iBeCjAoCjBmOjBlGiNnNiClHiCoJiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
static LOGFONT s_logFontStd =
{
	0,
	0,
	0,
	0,
	FW_NORMAL,
	FALSE,
	FALSE,
	FALSE,
	0,		// _xZkqqHx_iDiKiDfMiBfLiDfIiCkJiCoHiOoGjDlOiBeC_xHqqkZx_
	OUT_DEFAULT_PRECIS,
	CLIP_DEFAULT_PRECIS,
	DEFAULT_QUALITY,
	0,		// _xZkqqHx_iDiKiDfMiBfLiDfIiCkJiCoHiOoGjDlOiBeC_xHqqkZx_
	_T(""),	// _xZkqqHx_iDiKiDfMiBfLiDfIiCkJiCoHiOoGjDlOiBeC_xHqqkZx_
}; // LOGFONT s_logFontStd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFontCharInfo::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vStream	:_xZkqqHx_iPgPjHmNjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFontCharInfo::OutStream (BYTEVector& vStream) const
{
	vStream << dwMask;
	vStream << mmHeight;
	vStream << wWeight;
	vStream << byItalic;
	vStream << byUnderline;
	vStream << byStrikeOut;
	vStream << byCharSet;
	vStream << byPitchAndFamily;
	vStream << wOffset;
	vStream << nCharAfter;
	vStream << crColor;
	//---- FaceName_xZkqqHx_iCpAiPgPjHmN_xHqqkZx_ -----
	DWORD dwSize = wcslen(szFaceName);
	::WriteVSizeU(vStream, dwSize);
	FFWriteStream(vStream, szFaceName, dwSize * sizeof(wchar_t));
} // FCFontCharInfo::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCFontCharInfo::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiCkJiCoHjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_jDpMjHmNiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCFontCharInfo::InStream (const BYTE*& pData)
{
	::FFReadData(dwMask, pData);
	::FFReadData(mmHeight, pData);
	::FFReadData(wWeight, pData);
	::FFReadData(byItalic, pData);
	::FFReadData(byUnderline, pData);
	::FFReadData(byStrikeOut, pData);
	::FFReadData(byCharSet, pData);
	::FFReadData(byPitchAndFamily, pData);
	::FFReadData(wOffset, pData);
	::FFReadData(nCharAfter, pData);
	::FFReadData(crColor, pData);
	//---- FaceName_xZkqqHx_iCpAjDpMjHmN_xHqqkZx_ -----
	const DWORD dwSize = ::ReadVSizeU(pData);
	FFReadStream(pData, szFaceName, dwSize * sizeof(wchar_t));
	szFaceName[dwSize] = L'\0';
} // FCFontCharInfo::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumFontFamExProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumFontFamiliesEx_xZkqqHx_iCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpelfe		:logical-font data
 *			lpntme		:physical-font data
 *			FontType	:type of font
 *			lParam		:application-defined data
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	The return value must be a nonzero value to continue enumeration;
 *			to stop enumeration, the return value must be zero.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			00.11.15 Fukushiro M. RegData.cpp_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
static int CALLBACK myEnumFontFamExProc (
  ENUMLOGFONTEX *lpelfe,    // logical-font data
  NEWTEXTMETRICEX *lpntme,  // physical-font data
  DWORD FontType,           // type of font
  LPARAM lParam             // application-defined data
)
{
	LOGFONT& lf = *((LOGFONT*)lParam);
	lf.lfCharSet = lpelfe->elfLogFont.lfCharSet;
	lf.lfPitchAndFamily = lpelfe->elfLogFont.lfPitchAndFamily;
	_tcscpy(lf.lfFaceName, lpelfe->elfLogFont.lfFaceName);
	// _xZkqqHx_iMhAjBlBiClFiCmE_xHqqkZx_Enum_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
	return 0;
} // myEnumFontFamExProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumTrueTypeFontProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumFontFamiliesEx_xZkqqHx_iCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_TrueType_xZkqqHx_iCmMiDhEiDeIiDjDiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpelfe		:logical-font data
 *			lpntme		:physical-font data
 *			FontType	:type of font
 *			lParam		:application-defined data
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	The return value must be a nonzero value to continue enumeration;
 *			to stop enumeration, the return value must be zero.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FFGetStdFont _xZkqqHx_jHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.11.15 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static int CALLBACK myEnumTrueTypeFontProc (
  ENUMLOGFONTEX *lpelfe,    // logical-font data
  NEWTEXTMETRICEX *lpntme,  // physical-font data
  DWORD FontType,           // type of font
  LPARAM lParam             // application-defined data
)
{
	if (FontType & TRUETYPE_FONTTYPE)
	{
		LOGFONT& lf = *((LOGFONT*)lParam);
		lf.lfCharSet = lpelfe->elfLogFont.lfCharSet;
		lf.lfPitchAndFamily = lpelfe->elfLogFont.lfPitchAndFamily;
		_tcscpy(lf.lfFaceName, lpelfe->elfLogFont.lfFaceName);
		// _xZkqqHx_iMhAjBlBiClFiCmE_xHqqkZx_Enum_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
		return 0;
	} else
	{
		// _xZkqqHx_iMhAjBlBiClFiCmE_xHqqkZx_Enum_xZkqqHx_iBeC_xHqqkZx_
		return 1;
	}
} // myEnumTrueTypeFontProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetStdFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const LOGFONT& FFGetStdFont ()
{
	if (s_logFontStd.lfFaceName[0] == L'\0')
	{
		// _xZkqqHx_iDgGiDeCiDfIiDhGiDiMiDeDiCmM_xHqqkZx_HDC_xZkqqHx_iCpAiNoMjAkMiBeC_xHqqkZx_
		HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
		if (hAttribDC == NULL) s_logFontStd;

		//----- _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiPiJiKpKiJlL_xHqqkZx_ -----
		WString strFont;
		// _xZkqqHx_iDiKiDfMiBfLiDfIiCkJiCoHiBeB_xHqqkZx_Charset_xZkqqHx_iCmG_xHqqkZx_Facename_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		strFont.LoadString(IDS_STANDARD_FONT);
		const long lCharset = wcstol(::FFExtractUntil(strFont, L"\n"), NULL, 10);
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		LOGFONT lf = {0};
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// memset _xZkqqHx_iCmFiPiJiKpKiJlLiClHiCoJiClBiCmGiBeC_xHqqkZx_ = {0} _xZkqqHx_iCmFiCmNiCkEiCnMiCkNiPiJiKpKiJlLiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCmBiClNiBeC_xHqqkZx_
		LOGFONT lf;
		memset(&lf, 0, sizeof(lf));
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		lf.lfCharSet = lCharset;
		_tcscpy(lf.lfFaceName, WStrToTStr(::FFExtractUntil(strFont, L"\n")));
		// _xZkqqHx_iDiKiDfMiBfLiDfIiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeIiDjDiDgHiCpAiDfGiDfIiDgFiDiAiCkJiCoHiMjPiNpFiBeCiMkJiCmCiCkJiCmBiClNiPoKiNiHiCmN_xHqqkZx_s_logFontStd_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		EnumFontFamiliesEx(hAttribDC, &lf, FONTENUMPROC(myEnumFontFamExProc), LPARAM(&s_logFontStd), 0);
		if (s_logFontStd.lfFaceName[0] == L'\0')
		//----- _xZkqqHx_iDiKiDfMiBfLiDfIiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeIiDjDiDgHiCkKiBeBiDfGiDfIiDgFiDiAjCiGiCmJiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			//----- DEFAULT_GUI_FONT_xZkqqHx_iCmM_xHqqkZx_LOGFONT_xZkqqHx_iBeCjAoCjBmOjBlGiNnNiClHiCoJiDhEiDeIiDjDiDgHiBeC_xHqqkZx_-----
			CFont font;
			font.CreateStockObject(DEFAULT_GUI_FONT);
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			LOGFONT lfGuiFont = {0};
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			// memset _xZkqqHx_iCmFiPiJiKpKiJlLiClHiCoJiClBiCmGiBeC_xHqqkZx_ = {0} _xZkqqHx_iCmFiCmNiCkEiCnMiCkNiPiJiKpKiJlLiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCmBiClNiBeC_xHqqkZx_
			LOGFONT lfGuiFont;
			memset(&lfGuiFont, 0, sizeof(lfGuiFont));
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			font.GetLogFont(&lfGuiFont);
			// lfGuiFont_xZkqqHx_iCkK_xHqqkZx_TrueType_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_TrueType_xZkqqHx_iCmMiPoKiNiHiCmNiBeB_xHqqkZx_s_logFontStd_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			EnumFontFamiliesEx(hAttribDC, &lfGuiFont, FONTENUMPROC(myEnumTrueTypeFontProc), LPARAM(&s_logFontStd), 0);
			if (s_logFontStd.lfFaceName[0] == L'\0')
			//----- lfGuiFont_xZkqqHx_iCkK_xHqqkZx_TrueType_xZkqqHx_iCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//				LOGFONT lfTrueType = {0};
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
				// memset _xZkqqHx_iCmFiPiJiKpKiJlLiClHiCoJiClBiCmGiBeC_xHqqkZx_ = {0} _xZkqqHx_iCmFiCmNiCkEiCnMiCkNiPiJiKpKiJlLiCmFiCkLiCmIiCkCiPoKiNiHiCkKiCkAiCmBiClNiBeC_xHqqkZx_
				LOGFONT lfTrueType;
				memset(&lfTrueType, 0, sizeof(lfTrueType));
//----- 06.05.22 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
				lfTrueType.lfCharSet = lCharset;
				// _xZkqqHx_iDfEiDhMiBfLiDgHiClDiCoKiCmEiCkCiCoJiDhEiDeIiDjDiDgHiCkJiCoH_xHqqkZx_TrueType_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
				EnumFontFamiliesEx(hAttribDC, &lfTrueType, FONTENUMPROC(myEnumTrueTypeFontProc), LPARAM(&s_logFontStd), 0);
				//----- _xZkqqHx_iDiKiDfMiBfLiDfIiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiDhEiDeIiDjDiDgHiCkKiBeBiDfGiDfIiDgFiDiAjCiGiCmJiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
				if (s_logFontStd.lfFaceName[0] == L'\0')
				{
	//----- 02.08.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (TrueType_xZkqqHx_iCmFiCmNiCmIiCkCiDhEiDeIiDjDiDgHiCkKiOgHiCoNiCoKiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJ_xHqqkZx_)-----
	//				// DEFAULT_GUI_FONT_xZkqqHx_iCpAjFfHiPiAiDhEiDeIiDjDiDgHiCmJjAnNjCoIiBeC_xHqqkZx_
	//				s_logFontStd = lfGuiFont;
	//----- 02.08.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (TrueType_xZkqqHx_iCmFiCmNiCmIiCkCiDhEiDeIiDjDiDgHiCkKiOgHiCoNiCoKiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJ_xHqqkZx_)-----
					// ANSI Charset_xZkqqHx_iCpAiOhHjCoIiBeCiCnMiClIiMkJiCmCiCkJiCoJiCmFiClFiCoFiCkEiBeC_xHqqkZx_
					lfTrueType.lfCharSet = ANSI_CHARSET;
					// _xZkqqHx_iDfEiDhMiBfLiDgHiClDiCoKiCmEiCkCiCoJiDhEiDeIiDjDiDgHiCkJiCoH_xHqqkZx_TrueType_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
					EnumFontFamiliesEx(hAttribDC, &lfTrueType, FONTENUMPROC(myEnumTrueTypeFontProc), LPARAM(&s_logFontStd), 0);
					//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCkKiBeBiDfGiDfIiDgFiDiAjCiGiCmJiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
					if (s_logFontStd.lfFaceName[0] == _T('\0'))
					{
						// Default Charset_xZkqqHx_iCpAiOhHjCoIiBeCjBfDiCmEiCmMiDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeCjFeLiClIiMkJiCmCiCkJiCoJiBeC_xHqqkZx_
						lfTrueType.lfCharSet = DEFAULT_CHARSET;
						// _xZkqqHx_iDfEiDhMiBfLiDgHiClDiCoKiCmEiCkCiCoJiDhEiDeIiDjDiDgHiCkJiCoH_xHqqkZx_TrueType_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_
						EnumFontFamiliesEx(hAttribDC, &lfTrueType, FONTENUMPROC(myEnumTrueTypeFontProc), LPARAM(&s_logFontStd), 0);
						//----- _xZkqqHx_iDhEiDeIiDjDiDgHiCkKiBeBiDfGiDfIiDgFiDiAjCiGiCmJiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
						if (s_logFontStd.lfFaceName[0] == _T('\0'))
						{
							// DEFAULT_GUI_FONT_xZkqqHx_iCpAjFfHiPiAiDhEiDeIiDjDiDgHiCmJjAnNjCoIiBeC_xHqqkZx_
							s_logFontStd = lfGuiFont;
						}
					}
	//----- 02.08.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (TrueType_xZkqqHx_iCmFiCmNiCmIiCkCiDhEiDeIiDjDiDgHiCkKiOgHiCoNiCoKiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJ_xHqqkZx_)-----
				}
			}
		}
		// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
		::DeleteDC(hAttribDC);
	}

	return s_logFontStd;
} // FFGetStdFont.

//----- 03.07.09 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetStdFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLjHhAiCmMiDgGiDhEiDeIiDiLiDgHiDhEiDeIiDjDiDgHiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dbptHeight	:_xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCpAiOhHjCoIiBeCiDhMiDeDiDjDiDgHjCfAiImKiBeC_xHqqkZx_
 *			lfEscapement:_xZkqqHx_iDhEiDeIiDjDiDgHiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDhEiDeIiDjDiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			01.02.06 Fukushiro M. _xZkqqHx_jCfAiImKiCpA_xHqqkZx_long _xZkqqHx_iCkJiCoH_xHqqkZx_ dbptHeight_xZkqqHx_iCnGiBeC_xHqqkZx_
 *************************************************************************/
const LOGFONT& FFGetStdFont (dblpnt dbptHeight, long lfEscapement)
{
	// const LOGFONT& _xZkqqHx_iCpAjFnEiClHiClNiCnPiBeB_xHqqkZx_static_xZkqqHx_jFmPjAjEiBeC_xHqqkZx_
	static LOGFONT tmp;
	tmp = FFGetStdFont();
	tmp.lfHeight = -labs(pnt2lg(dbptHeight, g_->dDisplayPPM));
	tmp.lfEscapement = lfEscapement;
	tmp.lfOrientation = lfEscapement;
	return tmp;
} // FFGetStdFont.
//----- 03.07.09 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCreateFontIndirect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiPiJiKpKiJlLiBeCiDhEiDeIiDjDiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiCmNiDfGiDfIiDgFiDiAiDhEiDeIiDjDiDgHiCmF_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	font	:_xZkqqHx_iPiJiKpKiJlLiClHiCoJiDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			logFont	:_xZkqqHx_iPiJiKpKiJlLjHhAiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCreateFontIndirect (CFont& font, const LOGFONT& logFont)
{
//----- 02.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhHiDgCiDfPiCpAiPjBjBnGiCkGiCmEiBeBjAlIjDhIiCpAiNiCiCnPiCoJ_xHqqkZx_)-----
//	if (!font.CreateFontIndirect(&logFont))
//	{
//		// _xZkqqHx_iNiCiClDiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
//		LOGFONT tmp = FFGetStdFont();
//		tmp.lfHeight = logFont.lfHeight;
//		(void)font.CreateFontIndirect(&tmp);
//	}
//----- 02.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhHiDgCiDfPiCpAiPjBjBnGiCkGiCmEiBeBjAlIjDhIiCpAiNiCiCnPiCoJ_xHqqkZx_)-----
	if (g_->eDrawWhich == FDDR_METAFILE || g_->eDrawWhich == FDDR_ENHANCED_METAFILE)
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		LOGFONT lfCopy = logFont;
		// LOGFONT::lfWidth _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
		FFSetLogFontWidth(lfCopy);
		if (!font.CreateFontIndirect(&lfCopy))
		{
			// _xZkqqHx_iNiCiClDiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
			LOGFONT tmp = FFGetStdFont();
			tmp.lfHeight = lfCopy.lfHeight;
			// LOGFONT::lfWidth _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			FFSetLogFontWidth(tmp);
			(void)font.CreateFontIndirect(&tmp);
		}
	} else
	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (!font.CreateFontIndirect(&logFont))
		{
			// _xZkqqHx_iNiCiClDiCpAiNiHiCoNiClJiCoJiBeC_xHqqkZx_
			LOGFONT tmp = FFGetStdFont();
			tmp.lfHeight = logFont.lfHeight;
			(void)font.CreateFontIndirect(&tmp);
		}
	}
//----- 02.11.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhHiDgCiDfPiCpAiPjBjBnGiCkGiCmEiBeBjAlIjDhIiCpAiNiCiCnPiCoJ_xHqqkZx_)-----
} // FFCreateFontIndirect.

//----- 02.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhHiDgCiDfPiCpAiPjBjBnGiCkGiCmEiBeBjAlIjDhIiCpAiNiCiCnPiCoJ_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	FCFontWidthKey
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMjFjN_xHqqkZx_(LOGFONT::lfWidth)_xZkqqHx_iCpAiBeBiDhEiDeIiDjDiDgHiPoOjFpBiCkJiCoHiIpIiCkLiPgPiClH_xHqqkZx_
 *			_xZkqqHx_iClNiCnPiCmMiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCmMiDeMiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.11.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct FCFontWidthKey
{
	FCFontWidthKey (const LOGFONT& lf) :
		m_lFontHeight(lf.lfHeight),
		m_lWeight(lf.lfWeight),
		m_byItalic(lf.lfItalic),
		m_byCharSet(lf.lfCharSet),
		m_byPitchAndFamily(lf.lfPitchAndFamily),
		dummy1(0)
		{
			_tcscpy(m_szFaceName, lf.lfFaceName);
		}

	long	m_lFontHeight;
	long	m_lWeight;
	BYTE	m_byItalic;
	BYTE	m_byCharSet;
	BYTE	m_byPitchAndFamily;
	BYTE	dummy1;
	_TCHAR	m_szFaceName[LF_FACESIZE];
}; // struct FCFontWidthKey.

inline bool operator < (const FCFontWidthKey& v1, const FCFontWidthKey& v2)
{
	if (v1.m_lFontHeight < v2.m_lFontHeight) return true;
	if (v1.m_lFontHeight > v2.m_lFontHeight) return false;

	if (v1.m_lWeight < v2.m_lWeight) return true;
	if (v1.m_lWeight > v2.m_lWeight) return false;

	if (v1.m_byItalic < v2.m_byItalic) return true;
	if (v1.m_byItalic > v2.m_byItalic) return false;

	if (v1.m_byCharSet < v2.m_byCharSet) return true;
	if (v1.m_byCharSet > v2.m_byCharSet) return false;

	if (v1.m_byPitchAndFamily < v2.m_byPitchAndFamily) return true;
	if (v1.m_byPitchAndFamily > v2.m_byPitchAndFamily) return false;

	if (_tcscmp(v1.m_szFaceName, v2.m_szFaceName) < 0) return true;
	return false;
} // bool operator <.

typedef map<FCFontWidthKey, long> FCFontWidthKeyToWidthMap;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumFontWidthProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FFSetLogFontWidth_xZkqqHx_iKnGjAjEjCiGiCmMiBeB_xHqqkZx_EnumFontFamiliesEx_xZkqqHx_jHhA_xHqqkZx_Callback_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHpBiLjDiClDiCoKiClNiDhEiDeIiDjDiDgHiCmM_xHqqkZx_lfWidth_xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pLogFont	:LOGFONT_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam		:lfWidth_xZkqqHx_iCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jHpBiLjDiCpAjCoCiOhOiClHiCoJiPoKiNiHiCmN_xHqqkZx_ 0_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.11.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static int CALLBACK myEnumFontWidthProc (const ENUMLOGFONTEX* pLogFont,
										 const NEWTEXTMETRICEX* pTm, DWORD FontType, LPARAM lParam)
{
	long* lfWidth = (long*)lParam;
	*lfWidth = pTm->ntmTm.tmAveCharWidth;
	return 0;
} // myEnumFontWidthProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSetLogFontWidth
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LOGFONT _xZkqqHx_iCmM_xHqqkZx_ lfWidth _xZkqqHx_iCmJiBeB_xHqqkZx_LOGFONT_xZkqqHx_iCmMiPoOjFpBiCpAiMlDiCmJjCgMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	logFont	:_xZkqqHx_jCgMiCpAiOhHjCoIiBeC_xHqqkZx_lfWidth_xZkqqHx_iCmMjCgMiCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	LOGFONT::lfWidth _xZkqqHx_iCmNiBeBjGhLjHiI_xHqqkZx_ 0 _xZkqqHx_iCmFiCkCiCkCiCmMiClOiCkKiBeBiJoGjGmKiCmMiPgDiJkBjEoEiCkK_xHqqkZx_3:4_xZkqqHx_iCmF_xHqqkZx_
 *			_xZkqqHx_iCmIiCkCiPoKiNiHiBeBiKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmFjDfMiCoIjFhEiCkPiClNjFlGiOjKiCkKiBeBiJkBiCmJjAeMiPgLiClDiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJiBeCiClBiCoKiCpAjGgIiCkOiClNiCnPiBeB_xHqqkZx_lfWidth _xZkqqHx_iCoAjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.11.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFSetLogFontWidth (LOGFONT& logFont)
{
	// _xZkqqHx_iMjPiNpFiNmPiCnNiCmM_xHqqkZx_ lfWidth _xZkqqHx_iCpAjDgPjIfOiClFiCmEiCkIiCkNjFmPjAjEiBeC_xHqqkZx_
	static FCFontWidthKeyToWidthMap mpFontKeyToWidth;

	// logFont _xZkqqHx_iCkJiCoHiBeB_xHqqkZx_FCFontWidthKey_xZkqqHx_jFmPjAjEiCpAiNoMjAkMiBeC_xHqqkZx_
	FCFontWidthKey fontWidthKey(logFont);

	// _xZkqqHx_jDgPjIfOiNmPiCnNjFmPjAjEiCkJiCoHiMjPiNpFiBeC_xHqqkZx_
	FCFontWidthKeyToWidthMap::iterator iFw = mpFontKeyToWidth.find(fontWidthKey);
	if (iFw != mpFontKeyToWidth.end())
	//----- _xZkqqHx_iKpJiCmJiDhEiDeIiDjDiDgHiCmM_xHqqkZx_Width _xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		logFont.lfWidth = (*iFw).second;
	} else
	//----- _xZkqqHx_jGkCiClOiDhEiDeIiDjDiDgHiCmM_xHqqkZx_Width _xZkqqHx_iCkKjDgPjIfOiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		CFont font;
		if (font.CreateFontIndirect(&logFont))
		{
			CDC dc;
			dc.CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
			CFont* pOldFont = dc.SelectObject(&font);
			TEXTMETRIC tmMetrics;
			dc.GetTextMetrics(&tmMetrics);
			logFont.lfWidth = tmMetrics.tmAveCharWidth;
			dc.SelectObject(pOldFont);
			mpFontKeyToWidth[fontWidthKey] = logFont.lfWidth;
		}
	}
} // FFSetLogFontWidth.
//----- 02.11.03 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iKgHjCkDiDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhHiDgCiDfPiCpAiPjBjBnGiCkGiCmEiBeBjAlIjDhIiCpAiNiCiCnPiCoJ_xHqqkZx_)-----


//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MY_CHARFORMAT_xZkqqHx_iCkJiCoH_xHqqkZx_FCFontCharInfo_xZkqqHx_iCnGjCgMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
// *			cf	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
////----- 01.02.16 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jDoAjFjEiCmFiDfCiDhNiDjDiDgIiCpAjEkNiNhDiClHiCoJiJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
//// *
////----- 01.02.16 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFCopy (FCFontCharInfo& fci, const MY_CHARFORMAT& cf)
//{
//	memset(&fci, 0, sizeof(fci));
//	if (cf.dwMask & CFM_SIZE)
//	{
//		fci.dwMask |= FDFI_FLAG_HEIGHT;
//		fci.mmHeight = tw2mm(cf.yHeight);
//	}
//	if (cf.dwMask & CFM_BOLD)
//	{
//		fci.dwMask |= FDFI_FLAG_WEIGHT;
//		fci.wWeight = (cf.dwEffects & CFE_BOLD) ? FW_BOLD : FW_NORMAL;
//	}
//	if (cf.dwMask & CFM_ITALIC)
//	{
//		fci.dwMask |= FDFI_FLAG_ITALIC;
//		fci.byItalic = (cf.dwEffects & CFE_ITALIC) ? TRUE : FALSE;
//	}
//	if (cf.dwMask & CFM_UNDERLINE)
//	{
//		fci.dwMask |= FDFI_FLAG_UNDERLINE;
//		fci.byUnderline = (cf.dwEffects & CFE_UNDERLINE) ? TRUE : FALSE;
//	}
//	if (cf.dwMask & CFM_STRIKEOUT)
//	{
//		fci.dwMask |= FDFI_FLAG_STRIKEOUT;
//		fci.byStrikeOut = (cf.dwEffects & CFE_STRIKEOUT) ? TRUE : FALSE;
//	}
//	if (cf.dwMask & CFM_CHARSET)
//	{
//		fci.dwMask |= FDFI_FLAG_CHARSET;
//		fci.byCharSet = cf.bCharSet;
//	}
//	if (cf.dwMask & CFM_FACE)
//	{
//		fci.dwMask |= FDFI_FLAG_FACENAME;
//		fci.byPitchAndFamily = cf.bPitchAndFamily;
//		wcscpy(fci.szFaceName, TStrToWStr(cf.szFaceName));
//	}
//	if (cf.dwMask & CFM_OFFSET)
//	{
//		fci.dwMask |= FDFI_FLAG_OFFSET;
//		fci.wOffset = FDUFChrSupSubOffset(FDFI_OFST_NORMALSCRIPT, cf.yOffset);
//	}
//	if (cf.dwMask & CFM_COLOR)
//	{
//		fci.dwMask |= FDFI_FLAG_COLORREF;
//		fci.crColor = cf.crTextColor;
//	}
//	// _xZkqqHx_iNmFiCoAiLnPiCkCjAeGiCpAjCfEiClHiBeC_xHqqkZx_BOLD -> wWeight _xZkqqHx_iCmMjFmPiKlHiCmJjBmOiJjOiBeC_xHqqkZx_
//	FFGetNearest(fci);
//} // FFCopy.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCFontCharInfo_xZkqqHx_iCkJiCoH_xHqqkZx_MY_CHARFORMAT_xZkqqHx_iCnGjCgMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cf	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
// *			fci	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FFCopy (MY_CHARFORMAT& cf, const FCFontCharInfo& fci)
//{
//	memset(&cf, 0, sizeof(cf));
//	cf.cbSize = sizeof(cf);
//
//	if (fci.dwMask & FDFI_FLAG_HEIGHT)
//	{
//		cf.dwMask |= CFM_SIZE;
//		cf.yHeight = mm2tw(fci.mmHeight);
//		// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCkKjFiJiClOiCmGiDeHiDiJiBfLiBeC_xHqqkZx_
//		ASSERT(0 < fci.mmHeight);
//	}
//	if (fci.dwMask & FDFI_FLAG_WEIGHT)
//	{
//		cf.dwMask |= CFM_BOLD;
//		if (FW_NORMAL < fci.wWeight) cf.dwEffects |= CFE_BOLD;
//	}
//	if (fci.dwMask & FDFI_FLAG_ITALIC)
//	{
//		cf.dwMask |= CFM_ITALIC;
//		if (fci.byItalic) cf.dwEffects |= CFE_ITALIC;
//	}
//	if (fci.dwMask & FDFI_FLAG_UNDERLINE)
//	{
//		cf.dwMask |= CFM_UNDERLINE;
//		if (fci.byUnderline) cf.dwEffects |= CFE_UNDERLINE;
//	}
//	if (fci.dwMask & FDFI_FLAG_STRIKEOUT)
//	{
//		cf.dwMask |= CFM_STRIKEOUT;
//		if (fci.byStrikeOut) cf.dwEffects |= CFE_STRIKEOUT;
//	}
//	if (fci.dwMask & FDFI_FLAG_CHARSET)
//	{
//		cf.dwMask |= CFM_CHARSET;
//		cf.bCharSet = fci.byCharSet;
//	}
//	if (fci.dwMask & FDFI_FLAG_FACENAME)
//	{
//		cf.dwMask |= CFM_FACE;
//		cf.bPitchAndFamily = fci.byPitchAndFamily;
//		_tcscpy(cf.szFaceName, WStrToTStr(fci.szFaceName));
//	}
//	if (fci.dwMask & FDFI_FLAG_OFFSET)
//	{
//		cf.dwMask |= CFM_OFFSET;
//		cf.yOffset = FDUFChrOffset(fci.wOffset);
//	}
//	if (fci.dwMask & FDFI_FLAG_COLORREF)
//	{
//		cf.dwMask |= CFM_COLOR;
//// 01.02.16 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////		cf.crTextColor = g_pEnv->scid2cref(fci.crColor);
//		cf.crTextColor = fci.crColor;
//	}
//} // FFCopy.
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CHARFORMATW_xZkqqHx_jFmPjAjEiCpA_xHqqkZx_CHARFORMATA_xZkqqHx_jFmPjAjEiCnGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cfa	:CHARFORMATA_xZkqqHx_jFmPjAjE_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			cfw	:CHARFORMATW_xZkqqHx_jFmPjAjE_xHqqkZx_ _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (CHARFORMATA& cfa, const CHARFORMATW& cfw)
{
	cfa.cbSize		= sizeof(cfa);
	cfa.dwMask		= cfw.dwMask;
	cfa.dwEffects	= cfw.dwEffects;
	cfa.yHeight		= cfw.yHeight;
	cfa.yOffset		= cfw.yOffset;
	cfa.crTextColor	= cfw.crTextColor;
	cfa.bCharSet	= cfw.bCharSet;
	cfa.bPitchAndFamily = cfw.bPitchAndFamily;
	strcpy(cfa.szFaceName, WStrToAStr(cfw.szFaceName));
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CHARFORMATA_xZkqqHx_jFmPjAjEiCpA_xHqqkZx_CHARFORMATW_xZkqqHx_jFmPjAjEiCnGjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cfw	:CHARFORMATA_xZkqqHx_jFmPjAjE_xHqqkZx_ _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			cfa	:CHARFORMATW_xZkqqHx_jFmPjAjE_xHqqkZx_ _xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.06.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (CHARFORMATW& cfw, const CHARFORMATA& cfa)
{
	cfw.cbSize		= sizeof(cfw);
	cfw.dwMask		= cfa.dwMask;
	cfw.dwEffects	= cfa.dwEffects;
	cfw.yHeight		= cfa.yHeight;
	cfw.yOffset		= cfa.yOffset;
	cfw.crTextColor	= cfa.crTextColor;
	cfw.bCharSet	= cfa.bCharSet;
	cfw.bPitchAndFamily = cfa.bPitchAndFamily;
	wcscpy(cfw.szFaceName, AStrToWStr(cfa.szFaceName));
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CHARFORMATW_xZkqqHx_iCkJiCoH_xHqqkZx_FCFontCharInfo_xZkqqHx_iCnGjCgMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			cf	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (FCFontCharInfo& fci, const CHARFORMATW& cf)
{
	memset(&fci, 0, sizeof(fci));
	if (cf.dwMask & CFM_SIZE)
	{
		fci.dwMask |= FDFI_FLAG_HEIGHT;
		fci.mmHeight = tw2mm(cf.yHeight);
	}
	if (cf.dwMask & CFM_BOLD)
	{
		fci.dwMask |= FDFI_FLAG_WEIGHT;
		fci.wWeight = (cf.dwEffects & CFE_BOLD) ? FW_BOLD : FW_NORMAL;
	}
	if (cf.dwMask & CFM_ITALIC)
	{
		fci.dwMask |= FDFI_FLAG_ITALIC;
		fci.byItalic = (cf.dwEffects & CFE_ITALIC) ? TRUE : FALSE;
	}
	if (cf.dwMask & CFM_UNDERLINE)
	{
		fci.dwMask |= FDFI_FLAG_UNDERLINE;
		fci.byUnderline = (cf.dwEffects & CFE_UNDERLINE) ? TRUE : FALSE;
	}
	if (cf.dwMask & CFM_STRIKEOUT)
	{
		fci.dwMask |= FDFI_FLAG_STRIKEOUT;
		fci.byStrikeOut = (cf.dwEffects & CFE_STRIKEOUT) ? TRUE : FALSE;
	}
	if (cf.dwMask & CFM_CHARSET)
	{
		fci.dwMask |= FDFI_FLAG_CHARSET;
		fci.byCharSet = cf.bCharSet;
	}
	if (cf.dwMask & CFM_FACE)
	{
		fci.dwMask |= FDFI_FLAG_FACENAME;
		fci.byPitchAndFamily = cf.bPitchAndFamily;
		wcscpy(fci.szFaceName, cf.szFaceName);
	}
	if (cf.dwMask & CFM_OFFSET)
	{
		fci.dwMask |= FDFI_FLAG_OFFSET;
		fci.wOffset = FDUFChrSupSubOffset(FDFI_OFST_NORMALSCRIPT, cf.yOffset);
	}
	if (cf.dwMask & CFM_COLOR)
	{
		fci.dwMask |= FDFI_FLAG_COLORREF;
		fci.crColor = cf.crTextColor;
	}
	// _xZkqqHx_iNmFiCoAiLnPiCkCjAeGiCpAjCfEiClHiBeC_xHqqkZx_BOLD -> wWeight _xZkqqHx_iCmMjFmPiKlHiCmJjBmOiJjOiBeC_xHqqkZx_
//----- 06.11.22 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if ((fci.dwMask & FDFI_FLAG_WEIGHT) &&
		(fci.dwMask & FDFI_FLAG_ITALIC) &&
		(fci.dwMask & FDFI_FLAG_CHARSET) &&
		(fci.dwMask & FDFI_FLAG_FACENAME))
//----- 06.11.22 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		FFGetNearest(fci);
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCFontCharInfo_xZkqqHx_iCkJiCoH_xHqqkZx_CHARFORMATW_xZkqqHx_iCnGjCgMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cf	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fci	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (CHARFORMATW& cf, const FCFontCharInfo& fci)
{
	memset(&cf, 0, sizeof(cf));
	cf.cbSize = sizeof(cf);

	if (fci.dwMask & FDFI_FLAG_HEIGHT)
	{
		cf.dwMask |= CFM_SIZE;
		cf.yHeight = mm2tw(fci.mmHeight);
		// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCkKjFiJiClOiCmGiDeHiDiJiBfLiBeC_xHqqkZx_
		ASSERT(0 < fci.mmHeight);
	}
	if (fci.dwMask & FDFI_FLAG_WEIGHT)
	{
		cf.dwMask |= CFM_BOLD;
		if (FW_NORMAL < fci.wWeight) cf.dwEffects |= CFE_BOLD;
	}
	if (fci.dwMask & FDFI_FLAG_ITALIC)
	{
		cf.dwMask |= CFM_ITALIC;
		if (fci.byItalic) cf.dwEffects |= CFE_ITALIC;
	}
	if (fci.dwMask & FDFI_FLAG_UNDERLINE)
	{
		cf.dwMask |= CFM_UNDERLINE;
		if (fci.byUnderline) cf.dwEffects |= CFE_UNDERLINE;
	}
	if (fci.dwMask & FDFI_FLAG_STRIKEOUT)
	{
		cf.dwMask |= CFM_STRIKEOUT;
		if (fci.byStrikeOut) cf.dwEffects |= CFE_STRIKEOUT;
	}
	if (fci.dwMask & FDFI_FLAG_CHARSET)
	{
		cf.dwMask |= CFM_CHARSET;
		cf.bCharSet = fci.byCharSet;
	}
	if (fci.dwMask & FDFI_FLAG_FACENAME)
	{
		cf.dwMask |= CFM_FACE;
		cf.bPitchAndFamily = fci.byPitchAndFamily;
		wcscpy(cf.szFaceName, fci.szFaceName);
	}
	if (fci.dwMask & FDFI_FLAG_OFFSET)
	{
		cf.dwMask |= CFM_OFFSET;
		cf.yOffset = FDUFChrOffset(fci.wOffset);
	}
	if (fci.dwMask & FDFI_FLAG_COLORREF)
	{
		cf.dwMask |= CFM_COLOR;
		cf.crTextColor = fci.crColor;
	}
} // FFCopy.
//----- 02.06.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	FCFontCharInfo_xZkqqHx_iCkJiCoH_xHqqkZx_LOGFONT_xZkqqHx_iCnGjCgMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lf	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fci	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCpAiNoMjAkMiClHiCoJiCmMiCmJiPfMjFkKiCmIiPoOjFpBiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDgGiDhEiDeIiDiLiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (LOGFONT& lf, const FCFontCharInfo& fci, double dZoom)
{
	// _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDhEiDeIiDjDiDgHiCmFiPiJiKpKiJlLiBeC_xHqqkZx_
	lf = FFGetStdFont();
	if (fci.dwMask & FDFI_FLAG_HEIGHT)
	{
		if (fci.dwMask & FDFI_FLAG_OFFSET &&
			FDUFChrSupSub(fci.wOffset) != FDFI_OFST_NORMALSCRIPT)
		{
			lf.lfHeight = -mm2lg(fci.mmHeight * FDFR_SMALL_RATIO, dZoom);
		} else
		{
			lf.lfHeight = -mm2lg(fci.mmHeight, dZoom);
		}
		// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCkKjFiJiClOiCmGiDeHiDiJiBfLiBeC_xHqqkZx_
		ASSERT(0 < fci.mmHeight);
	}
	if (fci.dwMask & FDFI_FLAG_WEIGHT)
	{
		lf.lfWeight	= fci.wWeight;
	}
	if (fci.dwMask & FDFI_FLAG_ITALIC)
	{
		lf.lfItalic = fci.byItalic;
	}
	if (fci.dwMask & FDFI_FLAG_UNDERLINE)
	{
		lf.lfUnderline = fci.byUnderline;
	}
	if (fci.dwMask & FDFI_FLAG_STRIKEOUT)
	{
		lf.lfStrikeOut = fci.byStrikeOut;
	}
	if (fci.dwMask & FDFI_FLAG_CHARSET)
	{
		lf.lfCharSet = fci.byCharSet;
	}
	if (fci.dwMask & FDFI_FLAG_FACENAME)
	{
		lf.lfPitchAndFamily = fci.byPitchAndFamily;
		::_tcscpy(lf.lfFaceName, WStrToTStr(fci.szFaceName));
	}
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCopy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LOGFONT_xZkqqHx_iCkJiCoH_xHqqkZx_FCFontCharInfo_xZkqqHx_iCnGjCgMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lf	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCpAiNoMjAkMiClHiCoJiCmMiCmJiPfMjFkKiCmIiPoOjFpBiCkKjGlDiCkCiPoKiNiHiCmNiBeBiDgGiDhEiDeIiDiLiDgHiCmM_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiPoOjFpBiCpAiOgHiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCopy (FCFontCharInfo& fci, const LOGFONT& lf, double dZoom)
{
	fci.dwMask = 0;
	fci.dwMask |= FDFI_FLAG_HEIGHT;
	fci.mmHeight = fabs(lg2mm(lf.lfHeight, dZoom));

	fci.dwMask |= FDFI_FLAG_WEIGHT;
	fci.wWeight = lf.lfWeight;

	fci.dwMask |= FDFI_FLAG_ITALIC;
	fci.byItalic = lf.lfItalic;

	fci.dwMask |= FDFI_FLAG_UNDERLINE;
	fci.byUnderline = lf.lfUnderline;

	fci.dwMask |= FDFI_FLAG_STRIKEOUT;
	fci.byStrikeOut = lf.lfStrikeOut;

	fci.dwMask |= FDFI_FLAG_CHARSET;
	fci.byCharSet = lf.lfCharSet;

	fci.dwMask |= FDFI_FLAG_FACENAME;
	fci.byPitchAndFamily = lf.lfPitchAndFamily;
	::wcscpy(fci.szFaceName, TStrToWStr(lf.lfFaceName));
} // FFCopy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFOverwrite
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	fci2_xZkqqHx_iCkJiCoHiBeBjAnNjCoIiClDiCoKiCmEiCkCiCoJjCgMiCmMiCnN_xHqqkZx_fci1_xZkqqHx_iCmJiPoDiPjBiCkLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci1	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fcp2	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwMask	:_xZkqqHx_iDfCiDhDiBfLiJmCjEfMiCmIiDiBiDjDiDgPiBfLiCmMiDhNiDfIiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFOverwrite (FCFontCharInfo& fci1, const FCFontCharInfo& fci2, DWORD dwMask)
{
	if (fci2.dwMask & FDFI_FLAG_HEIGHT && dwMask & FDFI_FLAG_HEIGHT)
	{
		fci1.dwMask |= FDFI_FLAG_HEIGHT;
		fci1.mmHeight = fci2.mmHeight;
		// _xZkqqHx_iDhEiDeIiDjDiDgHiNiCiCkKjFiJiClOiCmGiDeHiDiJiBfLiBeC_xHqqkZx_
		ASSERT(0 < fci2.mmHeight);
	}
	if (fci2.dwMask & FDFI_FLAG_WEIGHT && dwMask & FDFI_FLAG_WEIGHT)
	{
		fci1.dwMask |= FDFI_FLAG_WEIGHT;
		fci1.wWeight = fci2.wWeight;
	}
	if (fci2.dwMask & FDFI_FLAG_ITALIC && dwMask & FDFI_FLAG_ITALIC)
	{
		fci1.dwMask |= FDFI_FLAG_ITALIC;
		fci1.byItalic = fci2.byItalic;
	}
	if (fci2.dwMask & FDFI_FLAG_UNDERLINE && dwMask & FDFI_FLAG_UNDERLINE)
	{
		fci1.dwMask |= FDFI_FLAG_UNDERLINE;
		fci1.byUnderline = fci2.byUnderline;
	}
	if (fci2.dwMask & FDFI_FLAG_STRIKEOUT && dwMask & FDFI_FLAG_STRIKEOUT)
	{
		fci1.dwMask |= FDFI_FLAG_STRIKEOUT;
		fci1.byStrikeOut = fci2.byStrikeOut;
	}
	if (fci2.dwMask & FDFI_FLAG_CHARSET && dwMask & FDFI_FLAG_CHARSET)
	{
		fci1.dwMask |= FDFI_FLAG_CHARSET;
		fci1.byCharSet = fci2.byCharSet;
	}
	if (fci2.dwMask & FDFI_FLAG_FACENAME && dwMask & FDFI_FLAG_FACENAME)
	{
		fci1.dwMask |= FDFI_FLAG_FACENAME;
		fci1.byPitchAndFamily = fci2.byPitchAndFamily;
		wcscpy(fci1.szFaceName, fci2.szFaceName);
	}
	if (fci2.dwMask & FDFI_FLAG_OFFSET && dwMask & FDFI_FLAG_OFFSET)
	{
		fci1.dwMask |= FDFI_FLAG_OFFSET;
		fci1.wOffset = fci2.wOffset;
	}
	if (fci2.dwMask & FDFI_FLAG_CHARAFTER && dwMask & FDFI_FLAG_CHARAFTER)
	{
		fci1.dwMask |= FDFI_FLAG_CHARAFTER;
		fci1.nCharAfter = fci2.nCharAfter;
	}
	if (fci2.dwMask & FDFI_FLAG_COLORREF && dwMask & FDFI_FLAG_COLORREF)
	{
		fci1.dwMask |= FDFI_FLAG_COLORREF;
		fci1.crColor = fci2.crColor;
	}
} // FFOverwrite.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	|=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	fci2_xZkqqHx_iCkJiCoHiBeBjAnNjCoIiClDiCoKiCmEiCkCiCoJjCgMiCmMiCnN_xHqqkZx_fci1_xZkqqHx_iCmJiPoDiPjBiCkLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci1	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fci2	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void operator |= (FCFontCharInfo& fci1, const FCFontCharInfo& fci2)
{
	FFOverwrite(fci1, fci2, FDFI_FLAG_ALL);
} // operator |=.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	&=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	fci1_xZkqqHx_jCiGiCmFiBeB_xHqqkZx_fci2_xZkqqHx_jCiGiCmMjCgMiCmGjDkPiClGjCgMiCpAiOjNiCmCjHhGjBgGiCmMiCnNiOgDiClFiCmEiBeBiClLiCoKiImIiKeP_xHqqkZx_
 *			_xZkqqHx_iCmNiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci1	:_xZkqqHx_iDfCiDhDiBfLjAoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			fci2	:_xZkqqHx_iDfCiDhDiBfLiMlDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMiDhEiDeIiDjDiDgHjBkOjAkLiCmM_xHqqkZx_AND_xZkqqHx_iCpAiCmGiCoJiPoKiNiHiCmJiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHoBiCkGiCmOiBeBjFkBjAjEiCmMjFlGiOjKiCmMiLkEjCmKiCmMjBkOjAkLiCpAiOoGjDlOiClHiCoJiPoKiNiHiBeBiNmFiPiJiCmMjFlGiOjKiCmM_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDjDiDgHjBkOjAkLiCpA_xHqqkZx_ fci1 _xZkqqHx_iCmJjAnNjCoIiClFiBeBiClLiCmMiMoDiCmMjFlGiOjKiCmMiDhEiDeIiDjDiDgHjBkOjAkLiCmN_xHqqkZx_
 *			fci1 &= _xZkqqHx_iCmF_xHqqkZx_AND_xZkqqHx_iCpAiOoGiCmBiCmEiCkCiCkNiBeC_xHqqkZx_
 *			_xZkqqHx_jFlGiOjKiCmJiCmNiBeBjFfHiPiAiDhEiDeIiDjDiDgHiCmMiPoKiNiHiCmGjEpBjFfHiPiAiDhEiDeIiDjDiDgHiCmMiPoKiNiHiCkKiCkAiCoJiClNiCnPiBeB_xHqqkZx_
 *			&= _xZkqqHx_iCmN_xHqqkZx_ FDFI_FLAG_UNUSED _xZkqqHx_iDhEiDiJiDePiCkKjHeMiMpIiCmIiPoKiNiHiCmJiCmMiCnNiJiJiOfKiClHiCoJiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void operator &= (FCFontCharInfo& fci1, const FCFontCharInfo& fci2)
{
//----- 05.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (!(fci2.dwMask & FDFI_FLAG_HEIGHT) || fci1.mmHeight != fci2.mmHeight)
//		fci1.dwMask &= ~FDFI_FLAG_HEIGHT;
//
//	if (!(fci2.dwMask & FDFI_FLAG_WEIGHT) || fci1.wWeight != fci2.wWeight)
//		fci1.dwMask &= ~FDFI_FLAG_WEIGHT;
//
//	if (!(fci2.dwMask & FDFI_FLAG_ITALIC) || fci1.byItalic != fci2.byItalic)
//		fci1.dwMask &= ~FDFI_FLAG_ITALIC;
//
//	if (!(fci2.dwMask & FDFI_FLAG_UNDERLINE) || fci1.byUnderline != fci2.byUnderline)
//		fci1.dwMask &= ~FDFI_FLAG_UNDERLINE;
//
//	if (!(fci2.dwMask & FDFI_FLAG_STRIKEOUT) || fci1.byStrikeOut != fci2.byStrikeOut)
//		fci1.dwMask &= ~FDFI_FLAG_STRIKEOUT;
//
//	if (!(fci2.dwMask & FDFI_FLAG_CHARSET) || fci1.byCharSet != fci2.byCharSet)
//		fci1.dwMask &= ~FDFI_FLAG_CHARSET;
//
//	if (!(fci2.dwMask & FDFI_FLAG_FACENAME) ||
//		fci1.byPitchAndFamily != fci2.byPitchAndFamily ||
//		wcscmp(fci1.szFaceName, fci2.szFaceName) != 0)
//		fci1.dwMask &= ~FDFI_FLAG_FACENAME;
//
//	if (!(fci2.dwMask & FDFI_FLAG_OFFSET) || fci1.wOffset != fci2.wOffset)
//		fci1.dwMask &= ~FDFI_FLAG_OFFSET;
//
//	if (!(fci2.dwMask & FDFI_FLAG_CHARAFTER) || fci1.nCharAfter != fci2.nCharAfter)
//		fci1.dwMask &= ~FDFI_FLAG_CHARAFTER;
//
//	if (!(fci2.dwMask & FDFI_FLAG_COLORREF) || fci1.crColor != fci2.crColor)
//		fci1.dwMask &= ~FDFI_FLAG_COLORREF;
//----- 05.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if ((fci1.dwMask & FDFI_FLAG_UNUSED) == FDFI_FLAG_UNUSED &&
		(fci2.dwMask & FDFI_FLAG_UNUSED) != FDFI_FLAG_UNUSED)
	//----- fci1_xZkqqHx_iCkKjGlDiMpIiCmF_xHqqkZx_fci2_xZkqqHx_iCkKjHeMiMpIiCmIiPoKiNiH_xHqqkZx_ -----
	{
		fci1 = fci2;
	} else
	if ((fci1.dwMask & FDFI_FLAG_UNUSED) != FDFI_FLAG_UNUSED &&
		(fci2.dwMask & FDFI_FLAG_UNUSED) == FDFI_FLAG_UNUSED)
	//----- fci1_xZkqqHx_iCkKjHeMiMpIiCmF_xHqqkZx_fci2_xZkqqHx_iCkKjGlDiMpIiCmIiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iJlNiCoAiClFiCmIiCkCiBeC_xHqqkZx_
	} else
	//----- fci1_xZkqqHx_iBeB_xHqqkZx_fci2_xZkqqHx_iCmGiCoAiCmJiCkKjHeMiMpIiBeBiIlNiCkCiCmNiCmGiCoAiCmJjGlDiMpIiCmIiPoKiNiH_xHqqkZx_ -----
	{
		if (!(fci2.dwMask & FDFI_FLAG_HEIGHT) || !almosteq(fci1.mmHeight, fci2.mmHeight))
			fci1.dwMask &= ~FDFI_FLAG_HEIGHT;

		if (!(fci2.dwMask & FDFI_FLAG_WEIGHT) || fci1.wWeight != fci2.wWeight)
			fci1.dwMask &= ~FDFI_FLAG_WEIGHT;

		if (!(fci2.dwMask & FDFI_FLAG_ITALIC) || fci1.byItalic != fci2.byItalic)
			fci1.dwMask &= ~FDFI_FLAG_ITALIC;

		if (!(fci2.dwMask & FDFI_FLAG_UNDERLINE) || fci1.byUnderline != fci2.byUnderline)
			fci1.dwMask &= ~FDFI_FLAG_UNDERLINE;

		if (!(fci2.dwMask & FDFI_FLAG_STRIKEOUT) || fci1.byStrikeOut != fci2.byStrikeOut)
			fci1.dwMask &= ~FDFI_FLAG_STRIKEOUT;

		if (!(fci2.dwMask & FDFI_FLAG_CHARSET) || fci1.byCharSet != fci2.byCharSet)
			fci1.dwMask &= ~FDFI_FLAG_CHARSET;

		if (!(fci2.dwMask & FDFI_FLAG_FACENAME) ||
			fci1.byPitchAndFamily != fci2.byPitchAndFamily ||
			wcscmp(fci1.szFaceName, fci2.szFaceName) != 0)
			fci1.dwMask &= ~FDFI_FLAG_FACENAME;

		if (!(fci2.dwMask & FDFI_FLAG_OFFSET) || fci1.wOffset != fci2.wOffset)
			fci1.dwMask &= ~FDFI_FLAG_OFFSET;

		if (!(fci2.dwMask & FDFI_FLAG_CHARAFTER) || fci1.nCharAfter != fci2.nCharAfter)
			fci1.dwMask &= ~FDFI_FLAG_CHARAFTER;

		if (!(fci2.dwMask & FDFI_FLAG_COLORREF) || fci1.crColor != fci2.crColor)
			fci1.dwMask &= ~FDFI_FLAG_COLORREF;
	}
//----- 05.06.30 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // operator &=.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	==
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiPoOjFpBiCmMiIoKjChGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL operator == (const FCFontCharInfo& fci1, const FCFontCharInfo& fci2)
{
	if (fci1.dwMask != fci2.dwMask) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_HEIGHT && fci1.mmHeight != fci2.mmHeight) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_WEIGHT && fci1.wWeight != fci2.wWeight) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_ITALIC && fci1.byItalic != fci2.byItalic) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_UNDERLINE && fci1.byUnderline != fci2.byUnderline) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_STRIKEOUT && fci1.byStrikeOut != fci2.byStrikeOut) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_CHARSET && fci1.byCharSet != fci2.byCharSet) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_OFFSET && fci1.wOffset != fci2.wOffset) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_CHARAFTER && fci1.nCharAfter != fci2.nCharAfter) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_COLORREF && fci1.crColor != fci2.crColor) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_FACENAME && fci1.byPitchAndFamily != fci2.byPitchAndFamily) return FALSE;
	if (fci1.dwMask & FDFI_FLAG_FACENAME && wcscmp(fci1.szFaceName, fci2.szFaceName) != 0) return FALSE;
	return TRUE;
} // operator ==.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	!=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiPoOjFpBiCmMjFhDiIoKjChGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL operator != (const FCFontCharInfo& fci1, const FCFontCharInfo& fci2)
{
	return !(fci1 == fci2);
} // operator !=.

//----- 01.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumFontWeightProc
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetCurCharInfo_xZkqqHx_iKnGjAjEjCiGiCmMiBeB_xHqqkZx_EnumFontFamiliesEx_xZkqqHx_jHhA_xHqqkZx_Callback_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *			_xZkqqHx_jHpBiLjDiClDiCoKiClN_xHqqkZx_CharSet_xZkqqHx_iCpAiBeB_xHqqkZx_setCharSet_xZkqqHx_iCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pLogFont	:LOGFONT_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *			lParam		:BYTESet*_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//static int CALLBACK myEnumFontWeightProc (const ENUMLOGFONTEX* pLogFont,
//										 const NEWTEXTMETRICEX* pTm, DWORD, LPARAM lParam)
//{
//	vector<LOGFONT>* vLogfont = (vector<LOGFONT>*)lParam;
//	vLogfont->push_back(pLogFont->elfLogFont);
//	return 1;
//} // myEnumFontWeightProc.
//----- 01.04.17 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetNearest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_FCFontCharInfo_xZkqqHx_iCmJiNmFiCoAiLnPiCkCiDhEiDeIiDjDiDgHiPoOjFpBiCpAiLeBiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci		:_xZkqqHx_iMjPiNpFiClHiCoJiDhEiDeIiDjDiDgHiPoOjFpBiCpAiOhHjCoIiBeCjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			vCharSet:_xZkqqHx_jBeJiCnBjDlOiCoJ_xHqqkZx_Charset_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iIlNiCkCiCmNiLpDiCmMiPoKiNiHiCmN_xHqqkZx_
 *					 fci.byCharset _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
 *			fciStd	:_xZkqqHx_iMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmMiKoOiPiAiDhEiDeIiDjDiDgHiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkC_xHqqkZx_
 *					 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	PC_xZkqqHx_jCiGiCmJjBlGiNnNiClHiCoJiDhEiDeIiDjDiDgHiCkJiCoHiMjPiNpFiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetNearest (FCFontCharInfo& fci, const WORDVector* vCharSet, const FCFontCharInfo* fciStd)
{
	ASSERT(fci.dwMask & FDFI_FLAG_WEIGHT);
	ASSERT(fci.dwMask & FDFI_FLAG_ITALIC);
	ASSERT(fci.dwMask & FDFI_FLAG_CHARSET);
	ASSERT(fci.dwMask & FDFI_FLAG_FACENAME);

	HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	//----- fci_xZkqqHx_iCmJjAnNjCoIiClDiCoKiClNiDhEiDeIiDjDiDgHiCmMjDkPiOoNiIoKjHjHiCpAiOoGiCoIiPgPiClH_xHqqkZx_ -----
	DWORDSet stWeightItalic;
	// vCharSet_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmGiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	if (vCharSet != NULL && !vCharSet->empty())
		fci.byCharSet = FFCollectWeightItalic(stWeightItalic, *vCharSet, fci.szFaceName);
	else
		FFCollectWeightItalic(stWeightItalic, fci.byCharSet, fci.szFaceName);
	if (stWeightItalic.empty())
	//----- _xZkqqHx_jDkPiOoNiIoKjHjHiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
	{
		if (fciStd != NULL)
		//----- _xZkqqHx_iKoOiPiAiDhEiDeIiDjDiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			fci.wWeight = fciStd->wWeight;
			fci.byItalic = fciStd->byItalic;
			fci.byCharSet = fciStd->byCharSet;
			fci.byPitchAndFamily = fciStd->byPitchAndFamily;
			wcscpy(fci.szFaceName, fciStd->szFaceName);
			// _xZkqqHx_iNmEiCnBjDkPiOoNiIoKjHjHiCpAiMjPiNpFiBeC_xHqqkZx_
			FFCollectWeightItalic(stWeightItalic, fci.byCharSet, fci.szFaceName);
		} else
		//----- _xZkqqHx_iKoOiPiAiDhEiDeIiDjDiDgHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
//----- 06.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			// _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiDhEiDeIiDjDiDgHjGlMiCmGiBeBiOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiCmMjBgHiCnNiNiHiCoNiClJiCmFiMjPiNpFiBeC_xHqqkZx_
//			fci.byPitchAndFamily = FFGetStdFont().lfPitchAndFamily;
//			wcscpy(fci.szFaceName, TStrToWStr(FFGetStdFont().lfFaceName));
//			// _xZkqqHx_iNmEiCnBjDkPiOoNiIoKjHjHiCpAiMjPiNpFiBeC_xHqqkZx_
//			// vCharSet_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmGiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
//			if (vCharSet != NULL && !vCharSet->empty())
//				fci.byCharSet = FFCollectWeightItalic(stWeightItalic, *vCharSet, fci.szFaceName);
//			else
//				FFCollectWeightItalic(stWeightItalic, fci.byCharSet, fci.szFaceName);
//----- 06.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			if (fci.szFaceName[0] == L'@')
			//----- _xZkqqHx_jDpKjGhLiMoKiCmM_xHqqkZx_@_xZkqqHx_jFhEiCkLiDhEiDeIiDjDiDgH_xHqqkZx_(_xZkqqHx_iPgDiPjBiCkLjHhA_xHqqkZx_)_xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiDhEiDeIiDjDiDgHjGlMiCmGiBeBiOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiCmMjBgHiCnNiNiHiCoNiClJiCmFiMjPiNpFiBeC_xHqqkZx_
				fci.byPitchAndFamily = FFGetStdFont().lfPitchAndFamily;
				// _xZkqqHx_jDkKiCmJ_xHqqkZx_ @ _xZkqqHx_iCkKjFhEiCkNiCoGiCkEiBeB_xHqqkZx_szFaceName+1 _xZkqqHx_iCmJiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
				wcscpy(fci.szFaceName + 1, TStrToWStr(FFGetStdFont().lfFaceName));
				// _xZkqqHx_iNmEiCnBjDkPiOoNiIoKjHjHiCpAiMjPiNpFiBeC_xHqqkZx_
				// vCharSet_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmGiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
				if (vCharSet != NULL && !vCharSet->empty())
					fci.byCharSet = FFCollectWeightItalic(stWeightItalic, *vCharSet, fci.szFaceName);
				else
					FFCollectWeightItalic(stWeightItalic, fci.byCharSet, fci.szFaceName);
			}
			if (stWeightItalic.empty())
			//----- _xZkqqHx_jDkPiOoNiIoKjHjHiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiCmMiDhEiDeIiDjDiDgHjGlMiCmGiBeBiOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiCmMjBgHiCnNiNiHiCoNiClJiCmFiMjPiNpFiBeC_xHqqkZx_
				fci.byPitchAndFamily = FFGetStdFont().lfPitchAndFamily;
				wcscpy(fci.szFaceName, TStrToWStr(FFGetStdFont().lfFaceName));
				// _xZkqqHx_iNmEiCnBjDkPiOoNiIoKjHjHiCpAiMjPiNpFiBeC_xHqqkZx_
				// vCharSet_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmGiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
				if (vCharSet != NULL && !vCharSet->empty())
					fci.byCharSet = FFCollectWeightItalic(stWeightItalic, *vCharSet, fci.szFaceName);
				else
					FFCollectWeightItalic(stWeightItalic, fci.byCharSet, fci.szFaceName);
			}
//----- 06.11.24 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
			if (stWeightItalic.empty())
			//----- _xZkqqHx_jDkPiOoNiIoKjHjHiCkKjGlDiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiClOiCkPiCmFiMjPiNpFiBeC_xHqqkZx_
				LOGFONT logFont;
				memset(&logFont, 0, sizeof(logFont));
				// vCharSet_xZkqqHx_iCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmGiOhHjCoIiClDiCoKiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
				if (vCharSet != NULL && !vCharSet->empty())
					FFFindFirstFont(logFont, *vCharSet);
				else
					FFFindFirstFont(logFont, fci.byCharSet);
				if (logFont.lfFaceName[0] != _T('\0'))
				//---- _xZkqqHx_iDhEiDeIiDjDiDgHiCkKiMkJiCmCiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
				{
					// Charset_xZkqqHx_iCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
					fci.byCharSet = logFont.lfCharSet;
					// _xZkqqHx_iDhEiDeIiDjDiDgHjGlMiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
					fci.byPitchAndFamily = logFont.lfPitchAndFamily;
					wcscpy(fci.szFaceName, TStrToWStr(logFont.lfFaceName));
				} else
				{
					// _xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiCmMiDhEiDeIiDjDiDgHiCkKiIoKiCmCiCoAjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_
					// _xZkqqHx_jFlGiOjKiDfKiDgCiDgHiCoAjFfHiPiAiDhEiDeIiDjDiDgHiCmFiPiJiKpKiJlLiClFiCmEiClFiCnMiCkEiBeC_xHqqkZx_
					fci.byCharSet = FFGetStdFont().lfCharSet;
				}
				// _xZkqqHx_iNmEiCnBjDkPiOoNiIoKjHjHiCpAiMjPiNpFiBeC_xHqqkZx_
				FFCollectWeightItalic(stWeightItalic, fci.byCharSet, fci.szFaceName);
			}
		}
	}
	if (!stWeightItalic.empty())
	//----- _xZkqqHx_jDkPiOoNiIoKjHjHiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iIoKjHjHiCpAiDiLiBfLiDhGiClFiCmEiBeBiNmFiCoAiLnPiCkCiDhEiDeIiDjDiDgHiCpAjBeJiCnE_xHqqkZx_ -----
		DWORDSet::iterator iWt = stWeightItalic.begin();
		// _xZkqqHx_iDhMiDeDiDjDiDgHiCpAiMhGiOfKiBeC_xHqqkZx_Weight_xZkqqHx_iCmMiNlHiCmJiBeB_xHqqkZx_Italic_xZkqqHx_iCmMiIoBiCkCiCmN_xHqqkZx_1000_xZkqqHx_iCpAiJmBiOfKiBeC_xHqqkZx_
		long lPointMin = labs(long(FDUFWeight(*iWt)) - long(fci.wWeight));
		if (FDUFItalic(*iWt) != fci.byItalic) lPointMin += 1000;
		DWORD dwMinWI = *iWt;
		for (iWt++; iWt != stWeightItalic.end(); iWt++)
		{
			long lPoint = labs(long(FDUFWeight(*iWt)) - long(fci.wWeight));
			if (FDUFItalic(*iWt) != fci.byItalic) lPoint += 1000;
			if (lPoint < lPointMin)
			{
				dwMinWI = *iWt;
				lPointMin = lPoint;
			}
		}
		// _xZkqqHx_iNmFiCoAiLnPiCkCiDhEiDeIiDjDiDgHiCmMiBeB_xHqqkZx_Weight_xZkqqHx_iCmGiDeDiDfOiDiKiDgCiDeOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
		fci.wWeight = FDUFWeight(dwMinWI);
		fci.byItalic =FDUFItalic(dwMinWI);
	}
	// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
	::DeleteDC(hAttribDC);
} // FFGetNearest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumFirstFontProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetCurCharInfo_xZkqqHx_iKnGjAjEjCiGiCmMiBeB_xHqqkZx_EnumFontFamiliesEx_xZkqqHx_jHhA_xHqqkZx_Callback_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static int CALLBACK myEnumFirstFontProc (const ENUMLOGFONTEX* pLogFont,
										 const NEWTEXTMETRICEX* pTm, DWORD FontType, LPARAM lParam)
{
	// _xZkqqHx_iDeBiDeFiDgHiDiJiDeDiDjDiDhEiDeIiDjDiDgHiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!(FontType & TRUETYPE_FONTTYPE)) return 1;
	LOGFONT* pLf = (LOGFONT*)lParam;
	if (pLf->lfFaceName[0] == _T('\0') || pLf->lfFaceName[0] == _T('@'))
		*pLf = pLogFont->elfLogFont;
	return 1;
} // myEnumFirstFontProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFindFirstFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiCmMiDhEiDeIiDjDiDgHiCpAiMjPiNpFiClFiBeBiNmFiPiJiCmJiMkJiCmCiCkJiCmBiClNiDhEiDeIiDjDiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFFindFirstFont (LOGFONT& lf, BYTE byCharSet)
{
	HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	memset(&lf, 0, sizeof(lf));
	lf.lfCharSet = byCharSet;
	lf.lfPitchAndFamily = 0;		// Must be 0 for EnumFontFamiliesEx.
	// _xZkqqHx_iIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	::EnumFontFamiliesEx(hAttribDC, &lf, FONTENUMPROC(myEnumFirstFontProc),
						LPARAM(&lf), 0);
	// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
	::DeleteDC(hAttribDC);
	// _xZkqqHx_iDhEiDeIiDjDiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	return lf.lfFaceName[0] != _T('\0');
} // FFFindFirstFont.

//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFFindFirstFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiCmMiDhEiDeIiDjDiDgHiCpAiMjPiNpFiClFiBeBiNmFiPiJiCmJiMkJiCmCiCkJiCmBiClNiDhEiDeIiDjDiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lf	:LOGFONT_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			vCharSet	:Charset_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCkKiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFFindFirstFont (LOGFONT& lf, const WORDVector& vCharSet)
{
	ASSERT(!vCharSet.empty());
	HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	WORDVector::const_iterator iSt;
	for (iSt = vCharSet.begin(); iSt != vCharSet.end(); iSt++)
	{
		memset(&lf, 0, sizeof(lf));
		lf.lfCharSet = *iSt;
		lf.lfPitchAndFamily = 0;		// Must be 0 for EnumFontFamiliesEx.
		// _xZkqqHx_iIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
		::EnumFontFamiliesEx(hAttribDC, &lf, FONTENUMPROC(myEnumFirstFontProc),
							LPARAM(&lf), 0);
		// _xZkqqHx_iDhEiDeIiDjDiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ _xZkqqHx_iPeJjHlJiBeC_xHqqkZx_
		if (lf.lfFaceName[0] != _T('\0')) break;
	}
	// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
	::DeleteDC(hAttribDC);
	// _xZkqqHx_iDhEiDeIiDjDiDgHiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoKiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	return lf.lfFaceName[0] != _T('\0');
} // FFFindFirstFont.
//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----

//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	==
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiPoOjFpBiCkKiIoKjChGiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL operator == (const MY_CHARFORMAT& cf1, const MY_CHARFORMAT& cf2)
//{
//	if (cf1.cbSize != cf2.cbSize) return FALSE;
//	if (cf1.dwMask != cf2.dwMask) return FALSE;
//	if (cf1.dwEffects != cf2.dwEffects) return FALSE;
//	if (cf1.yHeight != cf2.yHeight) return FALSE;
//	if (cf1.yOffset != cf2.yOffset) return FALSE;
//	if (cf1.crTextColor != cf2.crTextColor) return FALSE;
//	if (cf1.bCharSet != cf2.bCharSet) return FALSE;
//	if (cf1.bPitchAndFamily != cf2.bPitchAndFamily) return FALSE;
//	if (_tcscmp(cf1.szFaceName, cf2.szFaceName) != 0) return FALSE;
//	return TRUE;
//} // operator ==.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	!=
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiPoOjFpBiCmMjFhDiIoKjChGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//BOOL operator != (const MY_CHARFORMAT& cf1, const MY_CHARFORMAT& cf2)
//{
//	return !(cf1 == cf2);
//} // operator !=.
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	==
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiPoOjFpBiCkKiIoKjChGiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL operator == (const CHARFORMATW& cf1, const CHARFORMATW& cf2)
{
	if (cf1.cbSize != cf2.cbSize) return FALSE;
	if (cf1.dwMask != cf2.dwMask) return FALSE;
	if (cf1.dwEffects != cf2.dwEffects) return FALSE;
	if (cf1.yHeight != cf2.yHeight) return FALSE;
	if (cf1.yOffset != cf2.yOffset) return FALSE;
	if (cf1.crTextColor != cf2.crTextColor) return FALSE;
	if (cf1.bCharSet != cf2.bCharSet) return FALSE;
	if (cf1.bPitchAndFamily != cf2.bPitchAndFamily) return FALSE;
	if (wcscmp(cf1.szFaceName, cf2.szFaceName) != 0) return FALSE;
	return TRUE;
} // operator ==.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	!=
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiPoOjFpBiCmMjFhDiIoKjChGiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL operator != (const CHARFORMATW& cf1, const CHARFORMATW& cf2)
{
	return !(cf1 == cf2);
} // operator !=.
//----- 02.09.10 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (SJIS_xZkqqHx_iCmJiCmIiCkC_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKjHpBiCmMjDfMiCoIjFhEiCkPiCpAiJmCjEfMiCmJiClHiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFWeightItalicToStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Weight & Italic_xZkqqHx_iCmMjAjEjCgMiCpAjFlGiOjKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str		:_xZkqqHx_jFmPiKlHiMoDjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *			dwWeightItalic	:_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeFiDeGiDeDiDgH_xHqqkZx_&_xZkqqHx_iDeDiDfOiDiKiDgCiDeOiCpAiOhHjCoIiBeC_xHqqkZx_
 *				_xZkqqHx_iJlKiImK_xHqqkZx_16Bit_xZkqqHx_iCmNiBeBiDhEiDeIiDjDiDgHiCkK_xHqqkZx_Italic_xZkqqHx_iCkJiCmHiCkEiCkJiBeBiPoDiImK_xHqqkZx_16Bit_xZkqqHx_iCmN_xHqqkZx_Weight_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	str_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FFWeightItalicToStr (WString& str, DWORD dwWeightItalic)
{
#define MYWEIGHT(x) \
	case FW_##x: \
		str.LoadString(IDS_FONT_WEIGHT_##x); \
		break; \

	switch (FDUFWeight(dwWeightItalic))
	{
	MYWEIGHT(THIN)
	MYWEIGHT(ULTRALIGHT)
	MYWEIGHT(LIGHT)
	MYWEIGHT(REGULAR)
	MYWEIGHT(MEDIUM)
	MYWEIGHT(SEMIBOLD)
	MYWEIGHT(BOLD)
	MYWEIGHT(ULTRABOLD)
	MYWEIGHT(HEAVY)
	default:
		str.LoadString(IDS_UNKNOWN);
	}

	if (FDUFItalic(dwWeightItalic))
	//----- _xZkqqHx_iDeDiDfOiDiKiDgCiDeOjBmMiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (FDUFWeight(dwWeightItalic) == FW_REGULAR)
		//----- _xZkqqHx_jFiBjCmKiCmMjBlOiClDiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// "_xZkqqHx_jFiBjCmK_xHqqkZx_ _xZkqqHx_iOmOjBmM_xHqqkZx_"_xZkqqHx_iCmGiCmNiCmIiCoHiClIiBeBjCfAiCmJ_xHqqkZx_"_xZkqqHx_iOmOjBmM_xHqqkZx_"_xZkqqHx_iCmGiClHiCoJiBeC_xHqqkZx_
			str.LoadString(IDS_FONT_ITALIC);
		} else
		{
			str += L' ';
			str += FFLoadWString(IDS_FONT_ITALIC);
		}
	}
	return str;

#undef MYWEIGHT
} // FFWeightItalicToStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFStrToWeightItalic
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiCpA_xHqqkZx_Weight & Italic_xZkqqHx_iCmMjAjEjCgMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wWeight	:_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeFiDeGiDeDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *			bItalic	:_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeDiDfOiDiKiDgCiDeOjBmMiCpAjFnEiClHiBeC_xHqqkZx_
 *			tcpStr	:_xZkqqHx_iDhEiDeIiDjDiDgHiOhHjCoIiCmMjFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Weight & Italic_xZkqqHx_iCmMjAjEjCgMiBeC_xHqqkZx_
 *			_xZkqqHx_iJlKiImK_xHqqkZx_16Bit_xZkqqHx_iCmNiBeBiDhEiDeIiDjDiDgHiCkK_xHqqkZx_Italic_xZkqqHx_iCkJiCmHiCkEiCkJiBeBiPoDiImK_xHqqkZx_16Bit_xZkqqHx_iCmN_xHqqkZx_Weight_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
 *			_xZkqqHx_iDeHiDiJiBfLiCmMiPoKiNiHiCmN_xHqqkZx_ DWORD(-1)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD FFStrToWeightItalic (const wchar_t* tcpStr)
{
#define MYWEIGHT(x,y) \
	if (wcscmp(FFLoadWString(IDS_FONT_WEIGHT_##x), y) == 0) \
		wWeight = FW_##x; \
	else \

	// _xZkqqHx_jBlOiClDiCmNjFiBjCmKiBeBiDeDiDfOiDiKiDgCiDeOiCmFiCmNjGlDiCkCiBeBiCpAiDgGiDhEiDeIiDiLiDgHiCmGiClFiCmEiPiJiKpKiJlLiBeC_xHqqkZx_
	WORD wWeight = FW_REGULAR;
	BOOL bItalic = FALSE;
	for (;;)
	{
		// _xZkqqHx_iLpDjEjCiCpAiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		while (*tcpStr == L' ' || *tcpStr == L'\t') tcpStr++;
		// _xZkqqHx_jFlGiOjKjHpBiCkKiLpDiCmIiCoHiCmOiPeJjHlJiBeC_xHqqkZx_
		if (*tcpStr == L'\0') break;
		//----- _xZkqqHx_iLpDjEjCiCmFiLoGjAnIiCoHiCoKiClNjFlGiOjKjHpBiCpAjElCiCkLiPgPiClH_xHqqkZx_ -----
		const wchar_t* tcpHead = tcpStr;
		for (;;)
		{
			if (*tcpStr == L' ' || *tcpStr == L'\t' || *tcpStr == L'\0') break;
			tcpStr++;
		}
		WString str(tcpHead, tcpStr);
		MYWEIGHT(THIN,str.c_str())
		MYWEIGHT(ULTRALIGHT,str.c_str())
		MYWEIGHT(LIGHT,str.c_str())
		MYWEIGHT(REGULAR,str.c_str())
		MYWEIGHT(MEDIUM,str.c_str())
		MYWEIGHT(SEMIBOLD,str.c_str())
		MYWEIGHT(BOLD,str.c_str())
		MYWEIGHT(ULTRABOLD,str.c_str())
		MYWEIGHT(HEAVY,str.c_str())
		if (wcscmp(FFLoadWString(IDS_FONT_ITALIC), str.c_str()) == 0)
			bItalic = TRUE;
		else
			return DWORD(-1);
	}
	return FDUFWeightItalic(wWeight, bItalic);

#undef MYWEIGHT
} // FFStrToWeightItalic.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myEnumWeightItalicProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SetCurCharInfo_xZkqqHx_iKnGjAjEjCiGiCmMiBeB_xHqqkZx_EnumFontFamiliesEx_xZkqqHx_jHhA_xHqqkZx_Callback_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *			_xZkqqHx_jHpBiLjDiClDiCoKiClNiDhEiDeIiDjDiDgHiCmMjBlOiClDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJiCfAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static int CALLBACK myEnumWeightItalicProc (const ENUMLOGFONTEX* pLogFont,
										 const NEWTEXTMETRICEX* pTm, DWORD FontType, LPARAM lParam)
{
	// _xZkqqHx_iDeBiDeFiDgHiDiJiDeDiDjDiDhEiDeIiDjDiDgHiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!(FontType & TRUETYPE_FONTTYPE)) return 1;

	FTBoldItalicMap* mpBoldItalic = (FTBoldItalicMap*)lParam;
	//----- wBoldItalic_xZkqqHx_iCmNiBeBiPoDiImK_xHqqkZx_16Bit_xZkqqHx_iCkK_xHqqkZx_bBold_xZkqqHx_iBeBiJlKiImK_xHqqkZx_16Bit_xZkqqHx_iCmN_xHqqkZx_bItalic -----
	WORD wBoldItalic = 0;
	if (pTm->ntmTm.ntmFlags & NTM_ITALIC)
		wBoldItalic |= 0x0001;	// Italic = _xZkqqHx_iJlKiImK_xHqqkZx_8Bit_xZkqqHx_iCkK_xHqqkZx_1_xZkqqHx_iBeC_xHqqkZx_
	if (pTm->ntmTm.ntmFlags & NTM_BOLD)
		wBoldItalic |= 0x0100;	// Bold = _xZkqqHx_iPoDiImK_xHqqkZx_8Bit_xZkqqHx_iCkK_xHqqkZx_1_xZkqqHx_iBeC_xHqqkZx_
	(*mpBoldItalic)[wBoldItalic] = FDUFWeightItalic(pLogFont->elfLogFont.lfWeight,
														pLogFont->elfLogFont.lfItalic);
	return 1;
} // myEnumWeightItalicProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCollectWeightItalic
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgHiCmMjBlOiClD_xHqqkZx_/_xZkqqHx_iDeDiDfOiDiKiDgCiDeOiIoKjHjHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stWeightItalic	:_xZkqqHx_iDhEiDeIiDjDiDgHiCmMjBlOiClD_xHqqkZx_/_xZkqqHx_iDeDiDfOiDiKiDgCiDeOiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *			wCharSet	:_xZkqqHx_iDhEiDeIiDjDiDgHiCmM_xHqqkZx_CharSet_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpFontName	:_xZkqqHx_iDhEiDeIiDjDiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCollectWeightItalic (DWORDSet& stWeightItalic, WORD wCharSet, const wchar_t* tcpFontName)
{
	HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	LOGFONT logFont;
	memset(&logFont, 0, sizeof(logFont));
	logFont.lfCharSet = wCharSet;
	logFont.lfPitchAndFamily = 0;		// Must be 0 for EnumFontFamiliesEx.
	_tcscpy(logFont.lfFaceName, WStrToTStr(tcpFontName));

	FTBoldItalicMap mpBoldItalic;
	// _xZkqqHx_iIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	::EnumFontFamiliesEx(hAttribDC, &logFont, FONTENUMPROC(myEnumWeightItalicProc),
						LPARAM(&mpBoldItalic), 0);
	// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
	::DeleteDC(hAttribDC);

	// mpBoldItalic _xZkqqHx_iCmM_xHqqkZx_first_xZkqqHx_iCmMiPoDiImK_xHqqkZx_1Byte_xZkqqHx_iCmN_xHqqkZx_bIsBold_xZkqqHx_iBeBiJlKiImK_xHqqkZx_1Byte_xZkqqHx_iCmN_xHqqkZx_bIsItalic_xZkqqHx_iBeC_xHqqkZx_
	// second_xZkqqHx_iCmM_xHqqkZx_DWORD_xZkqqHx_iCmNiBeB_xHqqkZx_UtilFont_xZkqqHx_iCpAiOfBiPmGiBeC_xHqqkZx_
	//----- _xZkqqHx_jFiBjCmKiCmMiDhEiDeIiDjDiDgHiCkKjHeMiCoJiPoKiNiHiCmNiBeBiOmOjBmMiBeBjBlOiOjKiBeBjBlOiOjKiOmOjBmMiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
	if (mpBoldItalic.find(0x0000) != mpBoldItalic.end())
	//----- _xZkqqHx_jFiBjCmKiDhEiDeIiDjDiDgHiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iOmOjBmMiCmMiNoMjAkMiBeC_xHqqkZx_
		// _xZkqqHx_jFiBjCmKiDhEiDeIiDjDiDgHiCmM_xHqqkZx_Weight_xZkqqHx_iCpAjHjIjHhAiBeC_xHqqkZx_FW_REGULAR _xZkqqHx_iCmGiCmNiMmAiCoHiCmIiCkCiClNiCnPiBeC_xHqqkZx_
		if (mpBoldItalic.find(0x0001) == mpBoldItalic.end())
			mpBoldItalic[0x0001] = mpBoldItalic[0x0000] | 0x00000001;
		// _xZkqqHx_jBlOiOjKiCmMiNoMjAkMiBeC_xHqqkZx_
		if (mpBoldItalic.find(0x0100) == mpBoldItalic.end())
			mpBoldItalic[0x0100] = (DWORD(FW_BOLD) << 16) | 0x00000000;
		// _xZkqqHx_jBlOiOjKiOmOjBmMiCmMiNoMjAkMiBeC_xHqqkZx_
		if (mpBoldItalic.find(0x0101) == mpBoldItalic.end())
			mpBoldItalic[0x0101] = (DWORD(FW_BOLD) << 16) | 0x00000001;
	}
	//----- _xZkqqHx_jBlOiOjKiCmMiDhEiDeIiDjDiDgHiCkKjHeMiCoJiPoKiNiHiCmNiBeBjBlOiOjKiOmOjBmMiCpAiNoMjAkMiClHiCoJ_xHqqkZx_ -----
	if (mpBoldItalic.find(0x0100) != mpBoldItalic.end())
	//----- _xZkqqHx_jBlOiOjKiDhEiDeIiDjDiDgHiCkKjHeMiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBlOiOjKiOmOjBmMiCmMiNoMjAkMiBeC_xHqqkZx_
		// _xZkqqHx_jBlOiOjKiDhEiDeIiDjDiDgHiCmM_xHqqkZx_Weight_xZkqqHx_iCpAjHjIjHhAiBeC_xHqqkZx_FW_BOLD _xZkqqHx_iCmGiCmNiMmAiCoHiCmIiCkCiClNiCnPiBeC_xHqqkZx_
		if (mpBoldItalic.find(0x0101) == mpBoldItalic.end())
			mpBoldItalic[0x0001] = mpBoldItalic[0x0100] | 0x00000001;
	}
	//----- stWeightItalic_xZkqqHx_iCnGjCgMiCpAiDfCiDhDiBfL_xHqqkZx_ -----
	stWeightItalic.clear();
	FTBoldItalicMap::iterator iBi;
	for (iBi = mpBoldItalic.begin(); iBi != mpBoldItalic.end(); iBi++)
		stWeightItalic.insert((*iBi).second);
} // FFCollectWeightItalic.

//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCollectWeightItalic
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgHiCmMjBlOiClD_xHqqkZx_/_xZkqqHx_iDeDiDfOiDiKiDgCiDeOiIoKjHjHiCpAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	stWeightItalic	:_xZkqqHx_iDhEiDeIiDjDiDgHiCmMjBlOiClD_xHqqkZx_/_xZkqqHx_iDeDiDfOiDiKiDgCiDeOiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *			vCharSet		:_xZkqqHx_iDhEiDeIiDjDiDgHiCmM_xHqqkZx_CharSet_xZkqqHx_iCmMiPfHiNiHiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpFontName		:_xZkqqHx_iDhEiDeIiDjDiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iIoKjChGiClFiClN_xHqqkZx_CharSet_xZkqqHx_iCmMjHhGjBgGiCpAjFnEiClHiBeCiCmHiCoKiCoAiIoKjChGiClFiCmIiCkCiPoKiNiHiCmNiNmFiPiJiCmMjHhGjBgGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FFCollectWeightItalic (DWORDSet& stWeightItalic, const WORDVector& vCharSet,
							const wchar_t* tcpFontName)
{
	ASSERT(!vCharSet.empty());
	WORDVector::const_iterator iSt;
	for (iSt = vCharSet.begin(); iSt != vCharSet.end(); iSt++)
	{
		FFCollectWeightItalic(stWeightItalic, BYTE(*iSt), tcpFontName);
		// stWeightItalic _xZkqqHx_iCkKjAnNjCoIiClDiCoKiClNiPoKiNiHiCmNiPeJjHlJiBeC_xHqqkZx_
		if (!stWeightItalic.empty()) return *iSt;
	}
	return *vCharSet.begin();
} // FFCollectWeightItalic.
//----- 02.08.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (Times New Roman _xZkqqHx_iCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmM_xHqqkZx_B_xZkqqHx_iCpAjBeJjBpAiClFiCmEiBeBiDgFiDeMiDfIiDgH_xHqqkZx_"_xZkqqHx_iCkAiCkCiCkE_xHqqkZx_"_xZkqqHx_iCpAiBhFiDgFiDeMiDfIiDgHiCmGiClFiCmEjDfMiCoIjFhEiCkPiBhGiClHiCoJiCmGiCkEiCnMiCkNiCkCiCkJiCmIiCkCiBeC_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFUnicodeToSubset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfCiBfLiDgIiCkKiBeB_xHqqkZx_UNICODE_xZkqqHx_iCmMiCmHiCmMiDfEiDhFiDfKiDgCiDgHiCmJiCkAiClNiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDfKiDgCiDgHiBeC_xHqqkZx_MSDN_xZkqqHx_iCmM_xHqqkZx_Unicode Subset Bitfields _xZkqqHx_iCpAiOfBiPmGiBeCiCmHiCmM_xHqqkZx_
 *			_xZkqqHx_iDfEiDhFiDfKiDgCiDgHiCmJiCoAjDjGiCmEiCmNiCnMiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int FFUnicodeToSubset (wchar_t wChar)
{
// 02.08.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (FFIsStdFontChar_xZkqqHx_iCmFiBeBiJpMiNhDiDfCiBfLiDgIiCkK_xHqqkZx_Basic Latin _xZkqqHx_iCmGjEeGiOkPiClDiCoKiCoJiCoGiCkEiCmJ_xHqqkZx_)
//	if (0x0020 <= wChar && wChar <= 0x007e) return  0;   // Basic Latin .
	if (0x0000 <= wChar && wChar <= 0x007e) return  0;   // Basic Latin .
	if (0x00a0 <= wChar && wChar <= 0x00ff) return  1;   // Latin-1 Supplement .
	if (0x0100 <= wChar && wChar <= 0x017f) return  2;   // Latin Extended-A .
	if (0x0180 <= wChar && wChar <= 0x024f) return  3;   // Latin Extended-B .
	if (0x0250 <= wChar && wChar <= 0x02af) return  4;   // IPA Extensions .
	if (0x02b0 <= wChar && wChar <= 0x02ff) return  5;   // Spacing Modifier Letters .
	if (0x0300 <= wChar && wChar <= 0x036f) return  6;   // Combining Diacritical Marks .
	if (0x0370 <= wChar && wChar <= 0x03ff) return  7;   // Basic Greek .
	if (0x0400 <= wChar && wChar <= 0x04ff) return  9;   // Cyrillic .
	if (0x0530 <= wChar && wChar <= 0x058f) return 10;   // Armenian .
	if (0x0590 <= wChar && wChar <= 0x05ff) return 11;   // Basic Hebrew .
	if (0x0600 <= wChar && wChar <= 0x06ff) return 13;   // Basic Arabic .
	if (0x0700 <= wChar && wChar <= 0x074f) return 71;   // Syriac .
	if (0x0780 <= wChar && wChar <= 0x07bf) return 72;   // Thaana .
	if (0x0900 <= wChar && wChar <= 0x097f) return 15;   // Devanagari .
	if (0x0980 <= wChar && wChar <= 0x09ff) return 16;   // Bengali .
	if (0x0a00 <= wChar && wChar <= 0x0a7f) return 17;   // Gurmukhi .
	if (0x0a80 <= wChar && wChar <= 0x0aff) return 18;   // Gujarati .
	if (0x0b00 <= wChar && wChar <= 0x0b7f) return 19;   // Oriya .
	if (0x0b80 <= wChar && wChar <= 0x0bff) return 20;   // Tamil .
	if (0x0c00 <= wChar && wChar <= 0x0c7f) return 21;   // Telugu .
	if (0x0c80 <= wChar && wChar <= 0x0cff) return 22;   // Kannada .
	if (0x0d00 <= wChar && wChar <= 0x0d7f) return 23;   // Malayalam .
	if (0x0d80 <= wChar && wChar <= 0x0dff) return 73;   // Sinhala .
	if (0x0e00 <= wChar && wChar <= 0x0e7f) return 24;   // Thai .
	if (0x0e80 <= wChar && wChar <= 0x0eff) return 25;   // Lao .
	if (0x0f00 <= wChar && wChar <= 0x0fcf) return 70;   // Tibetan .
	if (0x1000 <= wChar && wChar <= 0x109f) return 74;   // Myanmar .
	if (0x10a0 <= wChar && wChar <= 0x10ff) return 26;   // Basic Georgian .
	if (0x1100 <= wChar && wChar <= 0x11ff) return 28;   // Hangul Jamo .
	if (0x1200 <= wChar && wChar <= 0x12bf) return 75;   // Ethiopic .
	if (0x13a0 <= wChar && wChar <= 0x13ff) return 76;   // Cherokee .
	if (0x1400 <= wChar && wChar <= 0x14df) return 77;   // Canadian Aboriginal Syllabics .
	if (0x1680 <= wChar && wChar <= 0x169f) return 78;   // Ogham .
	if (0x16a0 <= wChar && wChar <= 0x16ff) return 79;   // Runic .
	if (0x1780 <= wChar && wChar <= 0x17ff) return 80;   // Khmer .
	if (0x1800 <= wChar && wChar <= 0x18af) return 81;   // Mongolian .
	if (0x1e00 <= wChar && wChar <= 0x1eff) return 29;   // Latin Extended Additional .
	if (0x1f00 <= wChar && wChar <= 0x1fff) return 30;   // Greek Extended .
	if (0x2000 <= wChar && wChar <= 0x206f) return 31;   // General Punctuation .
	if (0x2070 <= wChar && wChar <= 0x209f) return 32;   // Subscripts and Superscripts .
	if (0x20a0 <= wChar && wChar <= 0x20cf) return 33;   // Currency Symbols .
	if (0x20d0 <= wChar && wChar <= 0x20ff) return 34;   // Combining Diacritical Marks for Symbols .
	if (0x2100 <= wChar && wChar <= 0x214f) return 35;   // Letter-like Symbols .
	if (0x2150 <= wChar && wChar <= 0x218f) return 36;   // Number Forms .
	if (0x2190 <= wChar && wChar <= 0x21ff) return 37;   // Arrows .
	if (0x2200 <= wChar && wChar <= 0x22ff) return 38;   // Mathematical Operators .
	if (0x2300 <= wChar && wChar <= 0x23ff) return 39;   // Miscellaneous Technical .
	if (0x2400 <= wChar && wChar <= 0x243f) return 40;   // Control Pictures .
	if (0x2440 <= wChar && wChar <= 0x245f) return 41;   // Optical Character Recognition .
	if (0x2460 <= wChar && wChar <= 0x24ff) return 42;   // Enclosed Alphanumerics .
	if (0x2500 <= wChar && wChar <= 0x257f) return 43;   // Box Drawing .
	if (0x2580 <= wChar && wChar <= 0x259f) return 44;   // Block Elements .
	if (0x25a0 <= wChar && wChar <= 0x25ff) return 45;   // Geometric Shapes .
	if (0x2600 <= wChar && wChar <= 0x26ff) return 46;   // Miscellaneous Dingbats .
	if (0x2700 <= wChar && wChar <= 0x27bf) return 47;   // Dingbats .
	if (0x2800 <= wChar && wChar <= 0x28ff) return 82;   // Braille .
	if (0x3000 <= wChar && wChar <= 0x303f) return 48;   // "Chinese, Japanese, and Korean (CJK) Symbols and Punctuation ".
	if (0x3040 <= wChar && wChar <= 0x309f) return 49;   // Hiragana .
	if (0x30a0 <= wChar && wChar <= 0x30ff) return 50;   // Katakana .
	if (0x3100 <= wChar && wChar <= 0x312f) return 51;   // Bopomofo .
	if (0x3130 <= wChar && wChar <= 0x318f) return 52;   // Hangul Compatibility Jamo .
	if (0x3190 <= wChar && wChar <= 0x319f) return 53;   // CJK Miscellaneous .
	if (0x3200 <= wChar && wChar <= 0x32ff) return 54;   // Enclosed CJK Letters and Months .
	if (0x3300 <= wChar && wChar <= 0x33ff) return 55;   // CJK Compatibility .
	if (0x4e00 <= wChar && wChar <= 0x9fff) return 59;   // CJK Unified Ideographs .
	if (0xa000 <= wChar && wChar <= 0xa48c) return 83;   // Yi .
	if (0xac00 <= wChar && wChar <= 0xd7a3) return 56;   // Hangul .
	if (0xd800 <= wChar && wChar <= 0xdfff) return 57;   // Surrogates  .
	if (0xe000 <= wChar && wChar <= 0xf8ff) return 60;   // Private Use Area .
	if (0xf900 <= wChar && wChar <= 0xfaff) return 61;   // CJK Compatibility Ideographs .
	if (0xfb00 <= wChar && wChar <= 0xfb4f) return 62;   // Alphabetic Presentation Forms .
	if (0xfb50 <= wChar && wChar <= 0xfdff) return 63;   // Arabic Presentation Forms-A .
	if (0xfe20 <= wChar && wChar <= 0xfe2f) return 64;   // Combining Half Marks .
	if (0xfe30 <= wChar && wChar <= 0xfe4f) return 65;   // CJK Compatibility Forms .
	if (0xfe50 <= wChar && wChar <= 0xfe6f) return 66;   // Small Form Variants .
	if (0xfe70 <= wChar && wChar <= 0xfefe) return 67;   // Arabic Presentation Forms-B .
	if (0xff00 <= wChar && wChar <= 0xffef) return 68;   // Halfwidth and Fullwidth Forms .
	if (0xfff0 <= wChar && wChar <= 0xfffd) return 69;   // Specials .
	return -1;
} // FFUnicodeToSubset.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCharsetToName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfKiDgCiDgHiDfCiBfLiDgIiCpAjFlGiOjKiDfKiDgCiDgHjGlMiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FFCharsetToName (WORD wCharset)
{
	static map<WORD, WString> s_mpCharsetToName;
	if (s_mpCharsetToName.empty())
	{
		WString strCharsetToName;
		strCharsetToName.LoadString(IDS_CHARSET_TO_NAME);
		while (!strCharsetToName.IsEmpty())
		{
			WORD wCharset = wcstol(::FFExtractUntil(strCharsetToName, L"\n"), NULL, 10);
			WString strName = ::FFExtractUntil(strCharsetToName, L"\n");
			s_mpCharsetToName[wCharset] = strName;
		}
	}
	return s_mpCharsetToName[wCharset].c_str();
} // FFCharsetToName.

//----- 02.08.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----

//------ s_wUnicodeToCharsetTable ------
//
// _xZkqqHx_iDgDiBfLiDiLiBhF_xHqqkZx_\src\UnisetToCharset_xZkqqHx_iBhGiCmFiNoMjAkMiBeC_xHqqkZx_
//
// UNICODE_xZkqqHx_jFlGiOjK_xHqqkZx_ -> Charset _xZkqqHx_iCnGiCmMjEhKjHpBiBeC_xHqqkZx_
// UNICODE_xZkqqHx_jFlGiOjKiCpAiDfEiDhMiBfLiDgHiClHiCoJ_xHqqkZx_Charset_xZkqqHx_iCmNiBeB_xHqqkZx_BIT_xZkqqHx_iCmJ_xHqqkZx_1_xZkqqHx_iCkKjHkHiCmCiBeC_xHqqkZx_
// BIT_xZkqqHx_iDhEiDeCiBfLiDiLiDgIiCmNiImIiJlKiBeC_xHqqkZx_
//
//	+=====+===================================
//	| BIT | Charset
//	+=====+===================================
//	|  0  |	  0		// _xZkqqHx_iJhAiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  1  |	  2		// _xZkqqHx_iDfGiDjDiDhLiDiLiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  2  |	128		// _xZkqqHx_jDpKjGhLiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  3  |	129		// _xZkqqHx_iDgOiDjDiDePiDiLiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  4  |	130		// _xZkqqHx_iKnIiNjBiMoK_xHqqkZx_(Johab)_xZkqqHx_iBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  5  |	134		// _xZkqqHx_iKmIjBmMiOjKjCiGiNjBiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  6  |	136		// _xZkqqHx_jEmJjBmMiOjKjCiGiNjBiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  7  |	161		// _xZkqqHx_iDeNiDiKiDfGiDeBiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  8  |	162		// _xZkqqHx_iDgHiDiLiDfCiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	|  9  |	163		// _xZkqqHx_iDhIiDgHiDgJiDiAiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	| 10  |	177		// _xZkqqHx_iDhHiDhFiDiJiDeDiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	| 11  |	178		// _xZkqqHx_iDeBiDiJiDhCiDeBiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	| 12  |	186		// _xZkqqHx_iDgPiDiLiDgHiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	| 13  |	204		// _xZkqqHx_iDeMiDiKiDiLiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	| 14  |	222		// _xZkqqHx_iDfOiDeDiMoKiBeC_xHqqkZx_
//	+-----+-----------------------------------
//	| 15  |	238		// _xZkqqHx_jCiGiJjLiDiIiBfLiDiNiDgCiDhAiMlOiMoKiBeC_xHqqkZx_
//	+=====+===================================
static WORD s_wUnicodeToCharsetTable[0x10001] =
{
	/*    0-   f */	0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   10-  1f */	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   20-  2f */	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   30-  3f */	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   40-  4f */	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   50-  5f */	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   60-  6f */	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   70-  7f */	0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
	/*   80-  8f */	0x5c, 0xd793, 0x4010, 0xd010, 0x4000, 0x0, 0x4000, 0x4000, 0xd080, 0x4000, 0x5680, 0x4000, 0x5480, 0x4783, 0x4780, 0x4783,
	/*   90-  9f */	0xd783, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf080, 0x4000, 0x5680, 0x4000, 0x5480, 0x4783, 0x4780, 0x5480,
	/*   a0-  af */	0xff83, 0x71b, 0x1f03, 0x1f83, 0xbbbb, 0xf83, 0xbf83, 0xbfff, 0x9fbf, 0xbf83, 0x31b, 0xbf83, 0xbf83, 0xbf9b, 0xbf9b, 0x1f43,
	/*   b0-  bf */	0xbfff, 0xbfff, 0x1f9b, 0x1f9b, 0x9f1f, 0xbf83, 0xbf9f, 0xbffb, 0x9f1b, 0x1f1b, 0x31b, 0xbf83, 0x1f1b, 0x1f9b, 0x1f1b, 0x71b,
	/*   c0-  cf */	0x303, 0x8303, 0x8303, 0x103, 0x9303, 0x1303, 0x131b, 0x8303, 0x303, 0x9303, 0x303, 0x8303, 0x103, 0x8303, 0x8303, 0x303,
	/*   d0-  df */	0x1b, 0x303, 0x103, 0x9303, 0x8303, 0x1103, 0x9303, 0x9f7f, 0x131b, 0x303, 0x8303, 0x303, 0x9303, 0x8003, 0x1b, 0x931b,
	/*   e0-  ef */	0xb23, 0x8323, 0x8b03, 0x103, 0x9303, 0x1303, 0x131b, 0x8b03, 0xb23, 0x9b23, 0xb23, 0x8b03, 0x123, 0x8323, 0x8b03, 0xb03,
	/*   f0-  ff */	0x1b, 0x303, 0x123, 0x9323, 0x8b03, 0x1103, 0x9303, 0x9f7f, 0x131b, 0xb23, 0x8323, 0xb03, 0x9b23, 0x8003, 0x1b, 0x303,
	/*  100- 10f */	0x1000, 0x1020, 0x8200, 0x8200, 0x9000, 0x9000, 0x9000, 0x9000, 0x0, 0x0, 0x0, 0x0, 0x9000, 0x9000, 0x8000, 0x8000,
	/*  110- 11f */	0x8200, 0x8218, 0x1000, 0x1020, 0x0, 0x0, 0x1000, 0x1000, 0x9000, 0x9000, 0x8000, 0x8020, 0x0, 0x0, 0x100, 0x100,
	/*  120- 12f */	0x0, 0x0, 0x1000, 0x1000, 0x0, 0x0, 0x18, 0x18, 0x0, 0x0, 0x1000, 0x1020, 0x0, 0x0, 0x1000, 0x1000,
	/*  130- 13f */	0x100, 0x118, 0x18, 0x18, 0x0, 0x0, 0x1000, 0x1000, 0x18, 0x8000, 0x8000, 0x1000, 0x1000, 0x8000, 0x8000, 0x18,
	/*  140- 14f */	0x18, 0x9018, 0x9018, 0x9000, 0x9020, 0x1000, 0x1000, 0x8000, 0x8020, 0x18, 0x18, 0x18, 0x1000, 0x1020, 0x0, 0x0,
	/*  150- 15f */	0x8000, 0x8000, 0xb1b, 0xb1b, 0x8000, 0x8000, 0x1000, 0x1000, 0x8000, 0x8000, 0x9000, 0x9000, 0x0, 0x0, 0x8100, 0x8100,
	/*  160- 16f */	0x9103, 0x9103, 0x8000, 0x8000, 0x8000, 0x8000, 0x18, 0x18, 0x0, 0x0, 0x1000, 0x1020, 0x0, 0x0, 0x8000, 0x8000,
	/*  170- 17f */	0x8000, 0x8000, 0x1000, 0x1000, 0x0, 0x0, 0x0, 0x0, 0x303, 0x9000, 0x9000, 0x9000, 0x9000, 0x9003, 0x9003, 0x0,
	/*  180- 18f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  190- 19f */	0x0, 0x0, 0xf83, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  1a0- 1af */	0x200, 0x200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x200,
	/*  1b0- 1bf */	0x200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  1c0- 1cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0,
	/*  1d0- 1df */	0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x20, 0x0, 0x0, 0x0,
	/*  1e0- 1ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  1f0- 1ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  200- 20f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  210- 21f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  220- 22f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  230- 23f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  240- 24f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  250- 25f */	0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  260- 26f */	0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  270- 27f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  280- 28f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  290- 29f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  2a0- 2af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  2b0- 2bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  2c0- 2cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf03, 0x9078, 0x0, 0x60, 0x60, 0x60, 0x0, 0x40, 0x0, 0x0,
	/*  2d0- 2df */	0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8018, 0x9078, 0x18, 0x9018, 0x703, 0x8018, 0x0, 0x0,
	/*  2e0- 2ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  2f0- 2ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  300- 30f */	0x200, 0x200, 0x0, 0x200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  310- 31f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  320- 32f */	0x0, 0x0, 0x0, 0x200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  330- 33f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  340- 34f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  350- 35f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  360- 36f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  370- 37f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  380- 38f */	0x0, 0x0, 0x0, 0x0, 0x80, 0x80, 0x80, 0x0, 0x80, 0x80, 0x80, 0x0, 0x80, 0x0, 0x80, 0x80,
	/*  390- 39f */	0x80, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
	/*  3a0- 3af */	0xfc, 0xfc, 0x0, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	/*  3b0- 3bf */	0x80, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
	/*  3c0- 3cf */	0xfc, 0xfc, 0x80, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x80, 0x80, 0x80, 0x80, 0x80, 0x0,
	/*  3d0- 3df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  3e0- 3ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  3f0- 3ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  400- 40f */	0x0, 0x203c, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0, 0x2000, 0x2000,
	/*  410- 41f */	0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c,
	/*  420- 42f */	0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c,
	/*  430- 43f */	0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c,
	/*  440- 44f */	0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c, 0x203c,
	/*  450- 45f */	0x0, 0x203c, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0, 0x2000, 0x2000,
	/*  460- 46f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  470- 47f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  480- 48f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  490- 49f */	0x2000, 0x2000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  4a0- 4af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  4b0- 4bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  4c0- 4cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  4d0- 4df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  4e0- 4ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  4f0- 4ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  500- 50f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  510- 51f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  520- 52f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  530- 53f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  540- 54f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  550- 55f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  560- 56f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  570- 57f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  580- 58f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  590- 59f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  5a0- 5af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  5b0- 5bf */	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	/*  5c0- 5cf */	0x400, 0x400, 0x400, 0x400, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  5d0- 5df */	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400,
	/*  5e0- 5ef */	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  5f0- 5ff */	0x400, 0x400, 0x400, 0x400, 0x400, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  600- 60f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x0, 0x0,
	/*  610- 61f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x0, 0x0, 0x800,
	/*  620- 62f */	0x0, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800,
	/*  630- 63f */	0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  640- 64f */	0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800, 0x800,
	/*  650- 65f */	0x800, 0x800, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  660- 66f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  670- 67f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0,
	/*  680- 68f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  690- 69f */	0x0, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  6a0- 6af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800,
	/*  6b0- 6bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x0, 0x0, 0x0, 0x800, 0x0,
	/*  6c0- 6cf */	0x0, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  6d0- 6df */	0x0, 0x0, 0x800, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  6e0- 6ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  6f0- 6ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  700- 70f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  710- 71f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  720- 72f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  730- 73f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  740- 74f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  750- 75f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  760- 76f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  770- 77f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  780- 78f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  790- 79f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  7a0- 7af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  7b0- 7bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  7c0- 7cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  7d0- 7df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  7e0- 7ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  7f0- 7ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  800- 80f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  810- 81f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  820- 82f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  830- 83f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  840- 84f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  850- 85f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  860- 86f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  870- 87f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  880- 88f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  890- 89f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  8a0- 8af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  8b0- 8bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  8c0- 8cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  8d0- 8df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  8e0- 8ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  8f0- 8ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  900- 90f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  910- 91f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  920- 92f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  930- 93f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  940- 94f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  950- 95f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  960- 96f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  970- 97f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  980- 98f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  990- 99f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  9a0- 9af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  9b0- 9bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  9c0- 9cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  9d0- 9df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  9e0- 9ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  9f0- 9ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a00- a0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a10- a1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a20- a2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a30- a3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a40- a4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a50- a5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a60- a6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a70- a7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a80- a8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  a90- a9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  aa0- aaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ab0- abf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ac0- acf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ad0- adf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ae0- aef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  af0- aff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b00- b0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b10- b1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b20- b2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b30- b3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b40- b4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b50- b5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b60- b6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b70- b7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b80- b8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  b90- b9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ba0- baf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  bb0- bbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  bc0- bcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  bd0- bdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  be0- bef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  bf0- bff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c00- c0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c10- c1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c20- c2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c30- c3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c40- c4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c50- c5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c60- c6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c70- c7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c80- c8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  c90- c9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ca0- caf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  cb0- cbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  cc0- ccf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  cd0- cdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ce0- cef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  cf0- cff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d00- d0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d10- d1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d20- d2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d30- d3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d40- d4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d50- d5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d60- d6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d70- d7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d80- d8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  d90- d9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  da0- daf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  db0- dbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  dc0- dcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  dd0- ddf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  de0- def */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  df0- dff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  e00- e0f */	0x0, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000,
	/*  e10- e1f */	0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000,
	/*  e20- e2f */	0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000,
	/*  e30- e3f */	0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0, 0x0, 0x0, 0x0, 0x4000,
	/*  e40- e4f */	0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000,
	/*  e50- e5f */	0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0, 0x0, 0x0, 0x0,
	/*  e60- e6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  e70- e7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  e80- e8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  e90- e9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ea0- eaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  eb0- ebf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ec0- ecf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ed0- edf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ee0- eef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ef0- eff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f00- f0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f10- f1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f20- f2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f30- f3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f40- f4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f50- f5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f60- f6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f70- f7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f80- f8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  f90- f9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  fa0- faf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  fb0- fbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  fc0- fcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  fd0- fdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  fe0- fef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/*  ff0- fff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1000-100f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1010-101f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1020-102f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1030-103f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1040-104f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1050-105f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1060-106f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1070-107f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1080-108f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1090-109f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 10a0-10af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 10b0-10bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 10c0-10cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 10d0-10df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 10e0-10ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 10f0-10ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1100-110f */	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	/* 1110-111f */	0x10, 0x10, 0x10, 0x0, 0x10, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x10, 0x10, 0x0,
	/* 1120-112f */	0x10, 0x0, 0x10, 0x10, 0x0, 0x0, 0x0, 0x10, 0x10, 0x0, 0x0, 0x10, 0x10, 0x10, 0x10, 0x10,
	/* 1130-113f */	0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1140-114f */	0x10, 0x0, 0x0, 0x0, 0x0, 0x10, 0x10, 0x10, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
	/* 1150-115f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x10, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
	/* 1160-116f */	0x0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	/* 1170-117f */	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1180-118f */	0x0, 0x0, 0x0, 0x0, 0x10, 0x10, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1190-119f */	0x0, 0x10, 0x10, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
	/* 11a0-11af */	0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	/* 11b0-11bf */	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	/* 11c0-11cf */	0x10, 0x10, 0x10, 0x0, 0x0, 0x0, 0x0, 0x10, 0x10, 0x0, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0,
	/* 11d0-11df */	0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0, 0x0, 0x0, 0x10, 0x0, 0x10,
	/* 11e0-11ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 11f0-11ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1200-120f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1210-121f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1220-122f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1230-123f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1240-124f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1250-125f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1260-126f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1270-127f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1280-128f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1290-129f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 12a0-12af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 12b0-12bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 12c0-12cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 12d0-12df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 12e0-12ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 12f0-12ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1300-130f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1310-131f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1320-132f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1330-133f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1340-134f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1350-135f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1360-136f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1370-137f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1380-138f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1390-139f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 13a0-13af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 13b0-13bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 13c0-13cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 13d0-13df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 13e0-13ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 13f0-13ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1400-140f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1410-141f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1420-142f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1430-143f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1440-144f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1450-145f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1460-146f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1470-147f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1480-148f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1490-149f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 14a0-14af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 14b0-14bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 14c0-14cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 14d0-14df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 14e0-14ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 14f0-14ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1500-150f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1510-151f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1520-152f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1530-153f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1540-154f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1550-155f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1560-156f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1570-157f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1580-158f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1590-159f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 15a0-15af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 15b0-15bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 15c0-15cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 15d0-15df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 15e0-15ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 15f0-15ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1600-160f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1610-161f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1620-162f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1630-163f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1640-164f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1650-165f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1660-166f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1670-167f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1680-168f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1690-169f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 16a0-16af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 16b0-16bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 16c0-16cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 16d0-16df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 16e0-16ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 16f0-16ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1700-170f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1710-171f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1720-172f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1730-173f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1740-174f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1750-175f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1760-176f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1770-177f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1780-178f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1790-179f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 17a0-17af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 17b0-17bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 17c0-17cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 17d0-17df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 17e0-17ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 17f0-17ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1800-180f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1810-181f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1820-182f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1830-183f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1840-184f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1850-185f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1860-186f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1870-187f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1880-188f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1890-189f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 18a0-18af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 18b0-18bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 18c0-18cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 18d0-18df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 18e0-18ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 18f0-18ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1900-190f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1910-191f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1920-192f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1930-193f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1940-194f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1950-195f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1960-196f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1970-197f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1980-198f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1990-199f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 19a0-19af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 19b0-19bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 19c0-19cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 19d0-19df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 19e0-19ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 19f0-19ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a00-1a0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a10-1a1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a20-1a2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a30-1a3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a40-1a4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a50-1a5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a60-1a6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a70-1a7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a80-1a8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1a90-1a9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1aa0-1aaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ab0-1abf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ac0-1acf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ad0-1adf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ae0-1aef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1af0-1aff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b00-1b0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b10-1b1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b20-1b2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b30-1b3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b40-1b4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b50-1b5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b60-1b6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b70-1b7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b80-1b8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1b90-1b9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ba0-1baf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1bb0-1bbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1bc0-1bcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1bd0-1bdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1be0-1bef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1bf0-1bff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c00-1c0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c10-1c1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c20-1c2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c30-1c3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c40-1c4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c50-1c5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c60-1c6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c70-1c7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c80-1c8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1c90-1c9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ca0-1caf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1cb0-1cbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1cc0-1ccf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1cd0-1cdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ce0-1cef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1cf0-1cff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d00-1d0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d10-1d1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d20-1d2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d30-1d3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d40-1d4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d50-1d5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d60-1d6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d70-1d7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d80-1d8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1d90-1d9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1da0-1daf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1db0-1dbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1dc0-1dcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1dd0-1ddf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1de0-1def */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1df0-1dff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e00-1e0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e10-1e1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e20-1e2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e30-1e3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e40-1e4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e50-1e5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e60-1e6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e70-1e7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e80-1e8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1e90-1e9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ea0-1eaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1eb0-1ebf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ec0-1ecf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ed0-1edf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ee0-1eef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ef0-1eff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f00-1f0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f10-1f1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f20-1f2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f30-1f3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f40-1f4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f50-1f5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f60-1f6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f70-1f7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f80-1f8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1f90-1f9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1fa0-1faf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1fb0-1fbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1fc0-1fcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1fd0-1fdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1fe0-1fef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 1ff0-1fff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2000-200f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800, 0x800, 0xc00, 0xc00,
	/* 2010-201f */	0x24, 0x0, 0x0, 0xffe3, 0xffe3, 0xbc, 0x20, 0x0, 0xffff, 0xffff, 0xbf83, 0x0, 0xffff, 0xffff, 0xbf83, 0x0,
	/* 2020-202f */	0xbf9f, 0xbf9f, 0xff83, 0x0, 0x0, 0x7c, 0xffff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2030-203f */	0xbfbf, 0x0, 0x7c, 0x3c, 0x0, 0x60, 0x0, 0x0, 0x0, 0xbf83, 0xbf83, 0x7c, 0x0, 0x0, 0x0, 0x0,
	/* 2040-204f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2050-205f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2060-206f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2070-207f */	0x0, 0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18,
	/* 2080-208f */	0x0, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2090-209f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 20a0-20af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x400, 0x200, 0xfffb, 0x0, 0x0, 0x0,
	/* 20b0-20bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 20c0-20cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 20d0-20df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 20e0-20ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 20f0-20ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2100-210f */	0x0, 0x0, 0x0, 0x7c, 0x0, 0x60, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2110-211f */	0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x203c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2120-212f */	0x0, 0x3c, 0xbf9b, 0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x0,
	/* 2130-213f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2140-214f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2150-215f */	0x0, 0x0, 0x0, 0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18, 0x18, 0x18, 0x18, 0x0,
	/* 2160-216f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x0, 0x0, 0x0, 0x0,
	/* 2170-217f */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2180-218f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2190-219f */	0x7c, 0x7c, 0x7c, 0x7c, 0x18, 0x18, 0x78, 0x78, 0x78, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 21a0-21af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 21b0-21bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 21c0-21cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 21d0-21df */	0x0, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 21e0-21ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 21f0-21ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2200-220f */	0x1c, 0x0, 0x1c, 0x1c, 0x0, 0x0, 0x0, 0x1c, 0x3c, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x38,
	/* 2210-221f */	0x0, 0x3c, 0x0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3c, 0x7c, 0x64,
	/* 2220-222f */	0x7c, 0x0, 0x0, 0x60, 0x0, 0x7c, 0x0, 0x3c, 0x3c, 0x7c, 0x7c, 0x7c, 0x1c, 0x0, 0x7c, 0x0,
	/* 2230-223f */	0x0, 0x0, 0x0, 0x0, 0x7c, 0x7c, 0x20, 0x20, 0x0, 0x0, 0x0, 0x0, 0x18, 0x3c, 0x0, 0x0,
	/* 2240-224f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0,
	/* 2250-225f */	0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2260-226f */	0x7c, 0x7c, 0x0, 0x0, 0x38, 0x38, 0x64, 0x64, 0x0, 0x0, 0x1c, 0x1c, 0x0, 0x0, 0x20, 0x20,
	/* 2270-227f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2280-228f */	0x0, 0x0, 0x1c, 0x1c, 0x0, 0x0, 0x1c, 0x1c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2290-229f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 22a0-22af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 22b0-22bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x64,
	/* 22c0-22cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 22d0-22df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 22e0-22ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 22f0-22ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2300-230f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2310-231f */	0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2320-232f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2330-233f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2340-234f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2350-235f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2360-236f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2370-237f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2380-238f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2390-239f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 23a0-23af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 23b0-23bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 23c0-23cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 23d0-23df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 23e0-23ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 23f0-23ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2400-240f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2410-241f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2420-242f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2430-243f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2440-244f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2450-245f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2460-246f */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x4,
	/* 2470-247f */	0x4, 0x4, 0x4, 0x4, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	/* 2480-248f */	0x38, 0x38, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 2490-249f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x18, 0x18, 0x18, 0x18,
	/* 24a0-24af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* 24b0-24bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 24c0-24cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 24d0-24df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* 24e0-24ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 24f0-24ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2500-250f */	0x7c, 0x3c, 0x7c, 0x3c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x38, 0x38, 0x3c,
	/* 2510-251f */	0x7c, 0x38, 0x38, 0x3c, 0x7c, 0x38, 0x38, 0x3c, 0x7c, 0x38, 0x38, 0x3c, 0x7c, 0x3c, 0x38, 0x38,
	/* 2520-252f */	0x3c, 0x38, 0x38, 0x3c, 0x7c, 0x3c, 0x38, 0x38, 0x3c, 0x38, 0x38, 0x3c, 0x7c, 0x38, 0x38, 0x3c,
	/* 2530-253f */	0x3c, 0x38, 0x38, 0x3c, 0x7c, 0x38, 0x38, 0x3c, 0x3c, 0x38, 0x38, 0x3c, 0x7c, 0x38, 0x38, 0x3c,
	/* 2540-254f */	0x38, 0x38, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3c, 0x0, 0x0, 0x0, 0x0,
	/* 2550-255f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 2560-256f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 2570-257f */	0x60, 0x60, 0x60, 0x60, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2580-258f */	0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 2590-259f */	0x0, 0x0, 0x18, 0x60, 0x60, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 25a0-25af */	0x7c, 0x7c, 0x0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 25b0-25bf */	0x0, 0x0, 0x7c, 0x7c, 0x0, 0x0, 0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x7c, 0x0, 0x0,
	/* 25c0-25cf */	0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x7c, 0x18, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x7c,
	/* 25d0-25df */	0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 25e0-25ef */	0x0, 0x0, 0x60, 0x60, 0x60, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
	/* 25f0-25ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2600-260f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x7c, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x18, 0x18,
	/* 2610-261f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18, 0x0, 0x18, 0x0,
	/* 2620-262f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2630-263f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2640-264f */	0x7c, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2650-265f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2660-266f */	0x18, 0x18, 0x0, 0x18, 0x18, 0x18, 0x0, 0x18, 0x18, 0x18, 0x1c, 0x0, 0x18, 0x1c, 0x0, 0x4,
	/* 2670-267f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2680-268f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2690-269f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 26a0-26af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 26b0-26bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 26c0-26cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 26d0-26df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 26e0-26ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 26f0-26ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2700-270f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2710-271f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2720-272f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2730-273f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2740-274f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2750-275f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2760-276f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2770-277f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2780-278f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2790-279f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 27a0-27af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 27b0-27bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 27c0-27cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 27d0-27df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 27e0-27ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 27f0-27ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2800-280f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2810-281f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2820-282f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2830-283f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2840-284f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2850-285f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2860-286f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2870-287f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2880-288f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2890-289f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 28a0-28af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 28b0-28bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 28c0-28cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 28d0-28df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 28e0-28ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 28f0-28ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2900-290f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2910-291f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2920-292f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2930-293f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2940-294f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2950-295f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2960-296f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2970-297f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2980-298f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2990-299f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 29a0-29af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 29b0-29bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 29c0-29cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 29d0-29df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 29e0-29ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 29f0-29ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a00-2a0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a10-2a1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a20-2a2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a30-2a3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a40-2a4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a50-2a5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a60-2a6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a70-2a7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a80-2a8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2a90-2a9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2aa0-2aaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ab0-2abf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ac0-2acf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ad0-2adf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ae0-2aef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2af0-2aff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b00-2b0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b10-2b1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b20-2b2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b30-2b3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b40-2b4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b50-2b5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b60-2b6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b70-2b7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b80-2b8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2b90-2b9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ba0-2baf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2bb0-2bbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2bc0-2bcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2bd0-2bdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2be0-2bef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2bf0-2bff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c00-2c0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c10-2c1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c20-2c2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c30-2c3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c40-2c4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c50-2c5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c60-2c6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c70-2c7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c80-2c8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2c90-2c9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ca0-2caf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2cb0-2cbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2cc0-2ccf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2cd0-2cdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ce0-2cef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2cf0-2cff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d00-2d0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d10-2d1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d20-2d2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d30-2d3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d40-2d4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d50-2d5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d60-2d6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d70-2d7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d80-2d8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2d90-2d9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2da0-2daf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2db0-2dbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2dc0-2dcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2dd0-2ddf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2de0-2def */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2df0-2dff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e00-2e0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e10-2e1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e20-2e2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e30-2e3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e40-2e4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e50-2e5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e60-2e6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e70-2e7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e80-2e8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2e90-2e9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ea0-2eaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2eb0-2ebf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ec0-2ecf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ed0-2edf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ee0-2eef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ef0-2eff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f00-2f0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f10-2f1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f20-2f2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f30-2f3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f40-2f4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f50-2f5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f60-2f6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f70-2f7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f80-2f8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2f90-2f9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2fa0-2faf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2fb0-2fbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2fc0-2fcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2fd0-2fdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2fe0-2fef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 2ff0-2fff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3000-300f */	0x7c, 0x7c, 0x7c, 0x7c, 0x0, 0x24, 0x24, 0x24, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* 3010-301f */	0x7c, 0x7c, 0x64, 0x3c, 0x7c, 0x7c, 0x20, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x64, 0x60, 0x4,
	/* 3020-302f */	0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3030-303f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3040-304f */	0x0, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 3050-305f */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 3060-306f */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 3070-307f */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 3080-308f */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 3090-309f */	0x3c, 0x3c, 0x3c, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x24, 0x24, 0x24, 0x24, 0x0,
	/* 30a0-30af */	0x0, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 30b0-30bf */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 30c0-30cf */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 30d0-30df */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 30e0-30ef */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c,
	/* 30f0-30ff */	0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x4, 0x24, 0x24, 0x24, 0x0,
	/* 3100-310f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 3110-311f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 3120-312f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3130-313f */	0x0, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
	/* 3140-314f */	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
	/* 3150-315f */	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
	/* 3160-316f */	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
	/* 3170-317f */	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
	/* 3180-318f */	0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x0,
	/* 3190-319f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 31a0-31af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 31b0-31bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 31c0-31cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 31d0-31df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 31e0-31ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 31f0-31ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3200-320f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* 3210-321f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0,
	/* 3220-322f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3230-323f */	0x0, 0x24, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3240-324f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3250-325f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3260-326f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* 3270-327f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0, 0x18,
	/* 3280-328f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3290-329f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 32a0-32af */	0x0, 0x0, 0x0, 0x60, 0x4, 0x4, 0x4, 0x4, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 32b0-32bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 32c0-32cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 32d0-32df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 32e0-32ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 32f0-32ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3300-330f */	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
	/* 3310-331f */	0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3320-332f */	0x0, 0x0, 0x4, 0x4, 0x0, 0x0, 0x4, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0,
	/* 3330-333f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0,
	/* 3340-334f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0x0, 0x0, 0x4, 0x0, 0x0,
	/* 3350-335f */	0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3360-336f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3370-337f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0x4, 0x4, 0x0,
	/* 3380-338f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7c, 0x7c,
	/* 3390-339f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7c, 0x7c, 0x7c, 0x18,
	/* 33a0-33af */	0x18, 0x7c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* 33b0-33bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* 33c0-33cf */	0x18, 0x18, 0x18, 0x18, 0x7c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x4, 0x60, 0x18,
	/* 33d0-33df */	0x18, 0x60, 0x60, 0x18, 0x0, 0x60, 0x18, 0x0, 0x18, 0x0, 0x0, 0x18, 0x18, 0x18, 0x0, 0x0,
	/* 33e0-33ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 33f0-33ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3400-340f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3410-341f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3420-342f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3430-343f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3440-344f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3450-345f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3460-346f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3470-347f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3480-348f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3490-349f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 34a0-34af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 34b0-34bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 34c0-34cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 34d0-34df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 34e0-34ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 34f0-34ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3500-350f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3510-351f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3520-352f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3530-353f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3540-354f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3550-355f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3560-356f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3570-357f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3580-358f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3590-359f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 35a0-35af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 35b0-35bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 35c0-35cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 35d0-35df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 35e0-35ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 35f0-35ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3600-360f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3610-361f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3620-362f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3630-363f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3640-364f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3650-365f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3660-366f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3670-367f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3680-368f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3690-369f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 36a0-36af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 36b0-36bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 36c0-36cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 36d0-36df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 36e0-36ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 36f0-36ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3700-370f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3710-371f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3720-372f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3730-373f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3740-374f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3750-375f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3760-376f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3770-377f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3780-378f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3790-379f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 37a0-37af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 37b0-37bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 37c0-37cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 37d0-37df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 37e0-37ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 37f0-37ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3800-380f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3810-381f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3820-382f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3830-383f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3840-384f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3850-385f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3860-386f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3870-387f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3880-388f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3890-389f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 38a0-38af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 38b0-38bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 38c0-38cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 38d0-38df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 38e0-38ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 38f0-38ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3900-390f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3910-391f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3920-392f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3930-393f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3940-394f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3950-395f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3960-396f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3970-397f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3980-398f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3990-399f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 39a0-39af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 39b0-39bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 39c0-39cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 39d0-39df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 39e0-39ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 39f0-39ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a00-3a0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a10-3a1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a20-3a2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a30-3a3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a40-3a4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a50-3a5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a60-3a6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a70-3a7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a80-3a8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3a90-3a9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3aa0-3aaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ab0-3abf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ac0-3acf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ad0-3adf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ae0-3aef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3af0-3aff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b00-3b0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b10-3b1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b20-3b2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b30-3b3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b40-3b4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b50-3b5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b60-3b6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b70-3b7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b80-3b8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3b90-3b9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ba0-3baf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3bb0-3bbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3bc0-3bcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3bd0-3bdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3be0-3bef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3bf0-3bff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c00-3c0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c10-3c1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c20-3c2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c30-3c3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c40-3c4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c50-3c5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c60-3c6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c70-3c7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c80-3c8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3c90-3c9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ca0-3caf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3cb0-3cbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3cc0-3ccf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3cd0-3cdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ce0-3cef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3cf0-3cff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d00-3d0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d10-3d1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d20-3d2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d30-3d3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d40-3d4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d50-3d5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d60-3d6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d70-3d7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d80-3d8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3d90-3d9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3da0-3daf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3db0-3dbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3dc0-3dcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3dd0-3ddf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3de0-3def */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3df0-3dff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e00-3e0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e10-3e1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e20-3e2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e30-3e3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e40-3e4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e50-3e5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e60-3e6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e70-3e7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e80-3e8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3e90-3e9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ea0-3eaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3eb0-3ebf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ec0-3ecf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ed0-3edf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ee0-3eef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ef0-3eff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f00-3f0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f10-3f1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f20-3f2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f30-3f3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f40-3f4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f50-3f5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f60-3f6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f70-3f7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f80-3f8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3f90-3f9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3fa0-3faf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3fb0-3fbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3fc0-3fcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3fd0-3fdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3fe0-3fef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 3ff0-3fff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4000-400f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4010-401f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4020-402f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4030-403f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4040-404f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4050-405f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4060-406f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4070-407f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4080-408f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4090-409f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 40a0-40af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 40b0-40bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 40c0-40cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 40d0-40df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 40e0-40ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 40f0-40ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4100-410f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4110-411f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4120-412f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4130-413f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4140-414f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4150-415f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4160-416f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4170-417f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4180-418f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4190-419f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 41a0-41af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 41b0-41bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 41c0-41cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 41d0-41df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 41e0-41ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 41f0-41ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4200-420f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4210-421f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4220-422f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4230-423f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4240-424f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4250-425f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4260-426f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4270-427f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4280-428f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4290-429f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 42a0-42af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 42b0-42bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 42c0-42cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 42d0-42df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 42e0-42ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 42f0-42ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4300-430f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4310-431f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4320-432f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4330-433f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4340-434f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4350-435f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4360-436f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4370-437f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4380-438f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4390-439f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 43a0-43af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 43b0-43bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 43c0-43cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 43d0-43df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 43e0-43ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 43f0-43ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4400-440f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4410-441f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4420-442f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4430-443f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4440-444f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4450-445f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4460-446f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4470-447f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4480-448f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4490-449f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 44a0-44af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 44b0-44bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 44c0-44cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 44d0-44df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 44e0-44ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 44f0-44ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4500-450f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4510-451f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4520-452f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4530-453f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4540-454f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4550-455f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4560-456f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4570-457f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4580-458f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4590-459f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 45a0-45af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 45b0-45bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 45c0-45cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 45d0-45df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 45e0-45ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 45f0-45ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4600-460f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4610-461f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4620-462f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4630-463f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4640-464f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4650-465f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4660-466f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4670-467f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4680-468f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4690-469f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 46a0-46af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 46b0-46bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 46c0-46cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 46d0-46df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 46e0-46ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 46f0-46ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4700-470f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4710-471f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4720-472f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4730-473f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4740-474f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4750-475f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4760-476f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4770-477f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4780-478f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4790-479f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 47a0-47af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 47b0-47bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 47c0-47cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 47d0-47df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 47e0-47ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 47f0-47ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4800-480f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4810-481f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4820-482f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4830-483f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4840-484f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4850-485f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4860-486f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4870-487f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4880-488f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4890-489f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 48a0-48af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 48b0-48bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 48c0-48cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 48d0-48df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 48e0-48ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 48f0-48ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4900-490f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4910-491f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4920-492f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4930-493f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4940-494f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4950-495f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4960-496f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4970-497f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4980-498f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4990-499f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 49a0-49af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 49b0-49bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 49c0-49cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 49d0-49df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 49e0-49ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 49f0-49ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a00-4a0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a10-4a1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a20-4a2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a30-4a3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a40-4a4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a50-4a5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a60-4a6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a70-4a7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a80-4a8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4a90-4a9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4aa0-4aaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4ab0-4abf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4ac0-4acf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4ad0-4adf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4ae0-4aef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4af0-4aff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b00-4b0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b10-4b1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b20-4b2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b30-4b3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b40-4b4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b50-4b5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b60-4b6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b70-4b7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b80-4b8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4b90-4b9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4ba0-4baf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4bb0-4bbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4bc0-4bcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4bd0-4bdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4be0-4bef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4bf0-4bff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c00-4c0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c10-4c1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c20-4c2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c30-4c3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c40-4c4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c50-4c5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c60-4c6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c70-4c7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c80-4c8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4c90-4c9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4ca0-4caf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4cb0-4cbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4cc0-4ccf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4cd0-4cdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4ce0-4cef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4cf0-4cff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d00-4d0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d10-4d1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d20-4d2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d30-4d3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d40-4d4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d50-4d5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d60-4d6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d70-4d7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d80-4d8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4d90-4d9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4da0-4daf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4db0-4dbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4dc0-4dcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4dd0-4ddf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4de0-4def */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4df0-4dff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 4e00-4e0f */	0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x64, 0x60,
	/* 4e10-4e1f */	0x64, 0x7c, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x24, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60,
	/* 4e20-4e2f */	0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x64, 0x20, 0x24, 0x20, 0x24, 0x60, 0x20, 0x7c, 0x60, 0x20,
	/* 4e30-4e3f */	0x60, 0x64, 0x7c, 0x60, 0x20, 0x20, 0x24, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x64, 0x20, 0x20, 0x24,
	/* 4e40-4e4f */	0x20, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x7c,
	/* 4e50-4e5f */	0x20, 0x20, 0x60, 0x60, 0x20, 0x24, 0x7c, 0x24, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c,
	/* 4e60-4e6f */	0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x38, 0x20, 0x38, 0x20, 0x20,
	/* 4e70-4e7f */	0x20, 0x24, 0x20, 0x7c, 0x20, 0x20, 0x38, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60,
	/* 4e80-4e8f */	0x24, 0x20, 0x7c, 0x60, 0x60, 0x24, 0x7c, 0x20, 0x7c, 0x24, 0x24, 0x7c, 0x7c, 0x60, 0x7c, 0x20,
	/* 4e90-4e9f */	0x38, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x3c, 0x64, 0x20, 0x7c, 0x24, 0x20, 0x7c, 0x64,
	/* 4ea0-4eaf */	0x24, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x20,
	/* 4eb0-4ebf */	0x24, 0x20, 0x20, 0x64, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 4ec0-4ecf */	0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x24, 0x24,
	/* 4ed0-4edf */	0x20, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x7c,
	/* 4ee0-4eef */	0x20, 0x64, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x24, 0x24, 0x20,
	/* 4ef0-4eff */	0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x24, 0x60, 0x20, 0x60,
	/* 4f00-4f0f */	0x64, 0x7c, 0x60, 0x24, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x78, 0x20, 0x7c, 0x7c, 0x7c,
	/* 4f10-4f1f */	0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x24, 0x20, 0x24, 0x64, 0x20, 0x20,
	/* 4f20-4f2f */	0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c,
	/* 4f30-4f3f */	0x64, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x24, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60,
	/* 4f40-4f4f */	0x20, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x7c, 0x78, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c,
	/* 4f50-4f5f */	0x7c, 0x7c, 0x60, 0x64, 0x60, 0x7c, 0x64, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x64, 0x60,
	/* 4f60-4f6f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c,
	/* 4f70-4f7f */	0x7c, 0x20, 0x20, 0x7c, 0x60, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x78, 0x64, 0x64, 0x60, 0x78, 0x7c,
	/* 4f80-4f8f */	0x60, 0x78, 0x60, 0x7c, 0x78, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x3c, 0x7c, 0x20, 0x7c, 0x20, 0x7c,
	/* 4f90-4f9f */	0x60, 0x7c, 0x64, 0x20, 0x64, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x20,
	/* 4fa0-4faf */	0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x24, 0x7c, 0x7c,
	/* 4fb0-4fbf */	0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x7c,
	/* 4fc0-4fcf */	0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x64, 0x7c, 0x60,
	/* 4fd0-4fdf */	0x64, 0x7c, 0x20, 0x78, 0x7c, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x7c,
	/* 4fe0-4fef */	0x78, 0x7c, 0x20, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x7c,
	/* 4ff0-4fff */	0x20, 0x78, 0x20, 0x7c, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x64, 0x24,
	/* 5000-500f */	0x60, 0x20, 0x38, 0x20, 0x20, 0x64, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x64,
	/* 5010-501f */	0x20, 0x7c, 0x7c, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x78, 0x20, 0x7c, 0x7c,
	/* 5020-502f */	0x60, 0x7c, 0x64, 0x7c, 0x3c, 0x64, 0x7c, 0x78, 0x7c, 0x64, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x60,
	/* 5030-503f */	0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x24, 0x60, 0x20, 0x24, 0x20, 0x38, 0x60, 0x20, 0x20, 0x20,
	/* 5040-504f */	0x64, 0x60, 0x24, 0x7c, 0x20, 0x60, 0x64, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 5050-505f */	0x24, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x24, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60,
	/* 5060-506f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x24, 0x60, 0x60, 0x60,
	/* 5070-507f */	0x64, 0x20, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x3c, 0x20, 0x60, 0x20, 0x20, 0x64, 0x20, 0x20,
	/* 5080-508f */	0x7c, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x20,
	/* 5090-509f */	0x20, 0x7c, 0x60, 0x20, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 50a0-50af */	0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60,
	/* 50b0-50bf */	0x60, 0x60, 0x7c, 0x7c, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60,
	/* 50c0-50cf */	0x20, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x24, 0x60, 0x7c,
	/* 50d0-50df */	0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x24, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x3c, 0x20,
	/* 50e0-50ef */	0x60, 0x20, 0x20, 0x64, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x60,
	/* 50f0-50ff */	0x60, 0x60, 0x20, 0x60, 0x24, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x78,
	/* 5100-510f */	0x7c, 0x3c, 0x64, 0x60, 0x7c, 0x60, 0x78, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20,
	/* 5110-511f */	0x60, 0x60, 0x7c, 0x60, 0x64, 0x64, 0x24, 0x60, 0x64, 0x20, 0x64, 0x20, 0x60, 0x20, 0x20, 0x7c,
	/* 5120-512f */	0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x20,
	/* 5130-513f */	0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x7c, 0x60, 0x20, 0x64,
	/* 5140-514f */	0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x24, 0x7c, 0x7c, 0x7c, 0x3c, 0x20,
	/* 5150-515f */	0x24, 0x20, 0x7c, 0x20, 0x64, 0x60, 0x20, 0x60, 0x20, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x60,
	/* 5160-516f */	0x20, 0x60, 0x7c, 0x60, 0x24, 0x7c, 0x20, 0x78, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x20,
	/* 5170-517f */	0x20, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x20,
	/* 5180-518f */	0x7c, 0x20, 0x24, 0x20, 0x20, 0x24, 0x3c, 0x60, 0x20, 0x64, 0x7c, 0x20, 0x24, 0x7c, 0x20, 0x64,
	/* 5190-519f */	0x24, 0x64, 0x7c, 0x64, 0x60, 0x7c, 0x24, 0x7c, 0x60, 0x24, 0x20, 0x20, 0x20, 0x24, 0x60, 0x20,
	/* 51a0-51af */	0x7c, 0x20, 0x64, 0x20, 0x64, 0x7c, 0x24, 0x20, 0x24, 0x24, 0x7c, 0x24, 0x7c, 0x20, 0x20, 0x20,
	/* 51b0-51bf */	0x64, 0x64, 0x24, 0x24, 0x24, 0x24, 0x7c, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x64, 0x20,
	/* 51c0-51cf */	0x20, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x7c, 0x20, 0x60, 0x3c, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x20,
	/* 51d0-51df */	0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x24, 0x60, 0x60, 0x20, 0x20, 0x24, 0x7c, 0x7c, 0x78, 0x20,
	/* 51e0-51ef */	0x64, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x24, 0x24, 0x20, 0x24, 0x24, 0x20, 0x24, 0x24, 0x20, 0x20,
	/* 51f0-51ff */	0x7c, 0x7c, 0x20, 0x60, 0x20, 0x64, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x24, 0x20,
	/* 5200-520f */	0x7c, 0x60, 0x20, 0x7c, 0x24, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x24, 0x60, 0x20, 0x7c, 0x20,
	/* 5210-521f */	0x60, 0x7c, 0x60, 0x60, 0x24, 0x24, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x20,
	/* 5220-522f */	0x20, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x20, 0x24, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x20,
	/* 5230-523f */	0x7c, 0x60, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20,
	/* 5240-524f */	0x20, 0x60, 0x20, 0x7c, 0x64, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x24,
	/* 5250-525f */	0x20, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x78, 0x64, 0x60,
	/* 5260-526f */	0x20, 0x78, 0x60, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 5270-527f */	0x24, 0x24, 0x7c, 0x24, 0x64, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c,
	/* 5280-528f */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x20,
	/* 5290-529f */	0x20, 0x7c, 0x3c, 0x60, 0x24, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x24, 0x20, 0x20, 0x7c,
	/* 52a0-52af */	0x7c, 0x20, 0x20, 0x7c, 0x38, 0x20, 0x64, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x64, 0x64, 0x60, 0x24,
	/* 52b0-52bf */	0x20, 0x24, 0x20, 0x20, 0x24, 0x24, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x64, 0x20, 0x7c, 0x20,
	/* 52c0-52cf */	0x64, 0x7c, 0x60, 0x7c, 0x20, 0x3c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20,
	/* 52d0-52df */	0x20, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x78, 0x64, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x7c,
	/* 52e0-52ef */	0x24, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x64, 0x24, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60,
	/* 52f0-52ff */	0x60, 0x60, 0x24, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x24, 0x7c, 0x78, 0x60, 0x20, 0x7c, 0x7c,
	/* 5300-530f */	0x24, 0x24, 0x24, 0x20, 0x20, 0x7c, 0x64, 0x24, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x7c,
	/* 5310-531f */	0x7c, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x64, 0x20, 0x60, 0x64, 0x20, 0x60,
	/* 5320-532f */	0x7c, 0x7c, 0x60, 0x7c, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x7c,
	/* 5330-533f */	0x60, 0x64, 0x20, 0x24, 0x60, 0x20, 0x20, 0x60, 0x24, 0x7c, 0x24, 0x24, 0x60, 0x60, 0x60, 0x7c,
	/* 5340-534f */	0x7c, 0x7c, 0x20, 0x7c, 0x78, 0x64, 0x24, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x20,
	/* 5350-535f */	0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x24, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20,
	/* 5360-536f */	0x7c, 0x60, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x38, 0x24, 0x20, 0x20, 0x60, 0x20, 0x64, 0x7c,
	/* 5370-537f */	0x7c, 0x7c, 0x64, 0x64, 0x3c, 0x7c, 0x20, 0x7c, 0x64, 0x60, 0x20, 0x64, 0x60, 0x38, 0x20, 0x7c,
	/* 5380-538f */	0x20, 0x20, 0x64, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 5390-539f */	0x20, 0x20, 0x60, 0x3c, 0x60, 0x20, 0x64, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x7c,
	/* 53a0-53af */	0x3c, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x3c, 0x60, 0x24, 0x24, 0x20, 0x20, 0x60, 0x7c, 0x24, 0x20,
	/* 53b0-53bf */	0x24, 0x20, 0x64, 0x24, 0x60, 0x20, 0x24, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20,
	/* 53c0-53cf */	0x20, 0x20, 0x24, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x24, 0x7c, 0x24, 0x20,
	/* 53d0-53df */	0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x24, 0x20, 0x7c, 0x20, 0x24, 0x20, 0x64,
	/* 53e0-53ef */	0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x64, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x7c,
	/* 53f0-53ff */	0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x60, 0x24, 0x24, 0x7c, 0x20, 0x24, 0x60, 0x60, 0x20, 0x20, 0x20,
	/* 5400-540f */	0x20, 0x64, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x64, 0x7c, 0x7c, 0x7c, 0x7c,
	/* 5410-541f */	0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x7c,
	/* 5420-542f */	0x7c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x64, 0x64, 0x64, 0x20,
	/* 5430-543f */	0x60, 0x60, 0x20, 0x78, 0x20, 0x60, 0x64, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x64, 0x7c, 0x20,
	/* 5440-544f */	0x64, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x64, 0x60, 0x7c, 0x24, 0x7c, 0x20, 0x20, 0x20, 0x64, 0x60,
	/* 5450-545f */	0x20, 0x3c, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24,
	/* 5460-546f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x3c, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 5470-547f */	0x64, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x64, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60,
	/* 5480-548f */	0x7c, 0x60, 0x60, 0x20, 0x64, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x24, 0x64, 0x7c, 0x60, 0x7c, 0x24,
	/* 5490-549f */	0x7c, 0x60, 0x64, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20,
	/* 54a0-54af */	0x60, 0x60, 0x64, 0x20, 0x3c, 0x64, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x64,
	/* 54b0-54bf */	0x60, 0x60, 0x24, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x64, 0x60,
	/* 54c0-54cf */	0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 54d0-54df */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20,
	/* 54e0-54ef */	0x60, 0x7c, 0x64, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x20,
	/* 54f0-54ff */	0x20, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x64,
	/* 5500-550f */	0x20, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x78, 0x64,
	/* 5510-551f */	0x7c, 0x60, 0x60, 0x20, 0x64, 0x20, 0x24, 0x60, 0x20, 0x20, 0x60, 0x20, 0x38, 0x20, 0x20, 0x20,
	/* 5520-552f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x60, 0x64, 0x7c,
	/* 5530-553f */	0x60, 0x7c, 0x60, 0x64, 0x60, 0x78, 0x60, 0x60, 0x64, 0x64, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x20,
	/* 5540-554f */	0x64, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x60, 0x24, 0x60, 0x60, 0x7c,
	/* 5550-555f */	0x60, 0x60, 0x60, 0x3c, 0x20, 0x60, 0x7c, 0x64, 0x20, 0x20, 0x20, 0x20, 0x64, 0x24, 0x78, 0x60,
	/* 5560-556f */	0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 5570-557f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x64, 0x7c, 0x60, 0x64, 0x60,
	/* 5580-558f */	0x7c, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x3c, 0x7c, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x60,
	/* 5590-559f */	0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x24, 0x64,
	/* 55a0-55af */	0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x3c, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x20,
	/* 55b0-55bf */	0x24, 0x60, 0x60, 0x60, 0x20, 0x60, 0x24, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60,
	/* 55c0-55cf */	0x60, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 55d0-55df */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x7c,
	/* 55e0-55ef */	0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60,
	/* 55f0-55ff */	0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x64, 0x20, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x60,
	/* 5600-560f */	0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60,
	/* 5610-561f */	0x60, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x7c, 0x24, 0x20, 0x20, 0x64, 0x60, 0x60, 0x20, 0x60,
	/* 5620-562f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x64, 0x60, 0x20, 0x60, 0x20, 0x60, 0x7c,
	/* 5630-563f */	0x60, 0x24, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 5640-564f */	0x60, 0x60, 0x64, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x64, 0x20, 0x64, 0x20,
	/* 5650-565f */	0x24, 0x20, 0x20, 0x78, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x24, 0x20, 0x20, 0x60, 0x20,
	/* 5660-566f */	0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x7c, 0x64, 0x60, 0x60, 0x60,
	/* 5670-567f */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x64, 0x60, 0x24, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 5680-568f */	0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x60, 0x64,
	/* 5690-569f */	0x60, 0x20, 0x20, 0x60, 0x24, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20,
	/* 56a0-56af */	0x24, 0x20, 0x24, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x78, 0x60, 0x7c, 0x20,
	/* 56b0-56bf */	0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x20,
	/* 56c0-56cf */	0x64, 0x64, 0x64, 0x64, 0x20, 0x60, 0x60, 0x20, 0x64, 0x60, 0x78, 0x60, 0x60, 0x78, 0x24, 0x20,
	/* 56d0-56df */	0x20, 0x7c, 0x20, 0x64, 0x60, 0x20, 0x20, 0x64, 0x24, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x60,
	/* 56e0-56ef */	0x7c, 0x60, 0x20, 0x24, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x64, 0x20,
	/* 56f0-56ff */	0x7c, 0x20, 0x24, 0x24, 0x20, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x20, 0x24, 0x20, 0x64,
	/* 5700-570f */	0x24, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x24,
	/* 5710-571f */	0x20, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x64, 0x20, 0x60, 0x7c,
	/* 5720-572f */	0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x24, 0x24, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60,
	/* 5730-573f */	0x7c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x24, 0x24, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x20,
	/* 5740-574f */	0x7c, 0x60, 0x3c, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x78, 0x7c, 0x64,
	/* 5750-575f */	0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 5760-576f */	0x20, 0x7c, 0x60, 0x20, 0x7c, 0x24, 0x7c, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x60, 0x38, 0x60,
	/* 5770-577f */	0x78, 0x60, 0x60, 0x60, 0x60, 0x78, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x78, 0x60, 0x20, 0x24,
	/* 5780-578f */	0x60, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x24, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x60,
	/* 5790-579f */	0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 57a0-57af */	0x7c, 0x20, 0x7c, 0x7c, 0x64, 0x60, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x24, 0x20, 0x60, 0x20,
	/* 57b0-57bf */	0x24, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60,
	/* 57c0-57cf */	0x24, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x64, 0x7c, 0x3c, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x60,
	/* 57d0-57df */	0x60, 0x20, 0x64, 0x24, 0x64, 0x60, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x20, 0x20, 0x7c,
	/* 57e0-57ef */	0x7c, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20,
	/* 57f0-57ff */	0x78, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x20,
	/* 5800-580f */	0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x78, 0x78, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x20,
	/* 5810-581f */	0x60, 0x20, 0x20, 0x20, 0x60, 0x24, 0x20, 0x20, 0x20, 0x64, 0x20, 0x60, 0x60, 0x64, 0x78, 0x20,
	/* 5820-582f */	0x60, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x78, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x7c,
	/* 5830-583f */	0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x3c, 0x60, 0x20, 0x64, 0x20, 0x60,
	/* 5840-584f */	0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x78,
	/* 5850-585f */	0x20, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x64, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x20,
	/* 5860-586f */	0x20, 0x38, 0x7c, 0x60, 0x78, 0x60, 0x20, 0x20, 0x60, 0x24, 0x20, 0x64, 0x20, 0x60, 0x20, 0x60,
	/* 5870-587f */	0x24, 0x60, 0x24, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x78, 0x60, 0x7c, 0x60,
	/* 5880-588f */	0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x78, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60,
	/* 5890-589f */	0x60, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x24, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x7c,
	/* 58a0-58af */	0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x78, 0x20, 0x64, 0x60, 0x20, 0x7c, 0x60,
	/* 58b0-58bf */	0x20, 0x60, 0x24, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x24, 0x24, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x60,
	/* 58c0-58cf */	0x20, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x24, 0x20, 0x24, 0x20, 0x78, 0x60,
	/* 58d0-58df */	0x20, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x24, 0x7c, 0x7c, 0x60, 0x60, 0x24, 0x60, 0x7c, 0x7c,
	/* 58e0-58ef */	0x20, 0x20, 0x60, 0x60, 0x7c, 0x24, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x24, 0x7c,
	/* 58f0-58ff */	0x24, 0x24, 0x24, 0x20, 0x60, 0x20, 0x20, 0x24, 0x20, 0x7c, 0x7c, 0x3c, 0x64, 0x7c, 0x60, 0x60,
	/* 5900-590f */	0x20, 0x20, 0x24, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x24, 0x24, 0x24, 0x60, 0x60, 0x60, 0x7c,
	/* 5910-591f */	0x24, 0x20, 0x60, 0x20, 0x78, 0x7c, 0x7c, 0x60, 0x24, 0x7c, 0x7c, 0x24, 0x7c, 0x20, 0x20, 0x20,
	/* 5920-592f */	0x60, 0x20, 0x7c, 0x20, 0x60, 0x64, 0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x64, 0x7c, 0x7c, 0x60,
	/* 5930-593f */	0x20, 0x7c, 0x24, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x20, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20,
	/* 5940-594f */	0x60, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x7c,
	/* 5950-595f */	0x7c, 0x7c, 0x20, 0x64, 0x7c, 0x7c, 0x20, 0x7c, 0x64, 0x20, 0x7c, 0x24, 0x60, 0x24, 0x20, 0x20,
	/* 5960-596f */	0x7c, 0x60, 0x7c, 0x24, 0x20, 0x24, 0x20, 0x7c, 0x24, 0x64, 0x7c, 0x78, 0x3c, 0x78, 0x7c, 0x20,
	/* 5970-597f */	0x60, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60,
	/* 5980-598f */	0x60, 0x64, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x64, 0x60, 0x60,
	/* 5990-599f */	0x60, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x78, 0x60, 0x7c, 0x20, 0x24, 0x20, 0x64, 0x60, 0x20,
	/* 59a0-59af */	0x60, 0x60, 0x60, 0x64, 0x64, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x3c, 0x20, 0x60, 0x60,
	/* 59b0-59bf */	0x20, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x64, 0x7c, 0x60, 0x60, 0x7c, 0x20,
	/* 59c0-59cf */	0x60, 0x60, 0x20, 0x78, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x3c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60,
	/* 59d0-59df */	0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x3c, 0x7c, 0x60, 0x7c, 0x78, 0x60, 0x20,
	/* 59e0-59ef */	0x60, 0x60, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x24, 0x78, 0x60, 0x78, 0x20,
	/* 59f0-59ff */	0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x38, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c,
	/* 5a00-5a0f */	0x60, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60,
	/* 5a10-5a1f */	0x20, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x24, 0x78, 0x7c, 0x20, 0x60, 0x7c,
	/* 5a20-5a2f */	0x7c, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x24,
	/* 5a30-5a3f */	0x20, 0x20, 0x20, 0x60, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x20,
	/* 5a40-5a4f */	0x64, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20,
	/* 5a50-5a5f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 5a60-5a6f */	0x60, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x64, 0x20, 0x64, 0x60, 0x20, 0x20,
	/* 5a70-5a7f */	0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x64,
	/* 5a80-5a8f */	0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 5a90-5a9f */	0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60,
	/* 5aa0-5aaf */	0x20, 0x20, 0x60, 0x20, 0x38, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x60,
	/* 5ab0-5abf */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x64, 0x64, 0x60,
	/* 5ac0-5acf */	0x60, 0x7c, 0x7c, 0x20, 0x78, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x20,
	/* 5ad0-5adf */	0x24, 0x20, 0x20, 0x20, 0x20, 0x60, 0x64, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 5ae0-5aef */	0x60, 0x7c, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 5af0-5aff */	0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x64, 0x20, 0x60, 0x20, 0x60,
	/* 5b00-5b0f */	0x20, 0x60, 0x60, 0x60, 0x20, 0x78, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x20, 0x60,
	/* 5b10-5b1f */	0x60, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20,
	/* 5b20-5b2f */	0x60, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x60,
	/* 5b30-5b3f */	0x64, 0x20, 0x64, 0x20, 0x60, 0x20, 0x24, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60,
	/* 5b40-5b4f */	0x7c, 0x20, 0x20, 0x7c, 0x20, 0x64, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 5b50-5b5f */	0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x64, 0x7c, 0x7c, 0x20, 0x7c, 0x64, 0x7c, 0x7c, 0x20, 0x7c,
	/* 5b60-5b6f */	0x20, 0x20, 0x60, 0x7c, 0x7c, 0x64, 0x24, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x20,
	/* 5b70-5b7f */	0x7c, 0x7c, 0x60, 0x64, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x38, 0x60, 0x20, 0x60,
	/* 5b80-5b8f */	0x24, 0x60, 0x20, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x24, 0x60, 0x7c,
	/* 5b90-5b9f */	0x20, 0x20, 0x60, 0x78, 0x20, 0x7c, 0x38, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x24, 0x20, 0x24,
	/* 5ba0-5baf */	0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x78, 0x60, 0x7c, 0x20,
	/* 5bb0-5bbf */	0x7c, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c,
	/* 5bc0-5bcf */	0x7c, 0x60, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x24, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20,
	/* 5bd0-5bdf */	0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x60, 0x38, 0x64, 0x60, 0x20, 0x24, 0x20, 0x24, 0x7c, 0x7c,
	/* 5be0-5bef */	0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x78,
	/* 5bf0-5bff */	0x64, 0x60, 0x60, 0x24, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x24, 0x24,
	/* 5c00-5c0f */	0x20, 0x7c, 0x24, 0x60, 0x7c, 0x24, 0x24, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x7c,
	/* 5c10-5c1f */	0x60, 0x7c, 0x60, 0x24, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x38, 0x64, 0x20, 0x20, 0x20, 0x24, 0x60,
	/* 5c20-5c2f */	0x24, 0x20, 0x64, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x24, 0x20, 0x20,
	/* 5c30-5c3f */	0x60, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x24, 0x7c, 0x7c,
	/* 5c40-5c4f */	0x7c, 0x64, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x24, 0x7c, 0x60, 0x7c, 0x7c, 0x64,
	/* 5c50-5c5f */	0x64, 0x7c, 0x20, 0x24, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x38, 0x60, 0x60, 0x24, 0x20,
	/* 5c60-5c6f */	0x7c, 0x24, 0x78, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x7c,
	/* 5c70-5c7f */	0x20, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20,
	/* 5c80-5c8f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60,
	/* 5c90-5c9f */	0x7c, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60,
	/* 5ca0-5caf */	0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60,
	/* 5cb0-5cbf */	0x60, 0x7c, 0x20, 0x7c, 0x20, 0x78, 0x64, 0x7c, 0x7c, 0x20, 0x3c, 0x24, 0x24, 0x20, 0x3c, 0x20,
	/* 5cc0-5ccf */	0x38, 0x20, 0x20, 0x20, 0x20, 0x24, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 5cd0-5cdf */	0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60,
	/* 5ce0-5cef */	0x3c, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x24, 0x64, 0x20, 0x60, 0x64, 0x60, 0x3c,
	/* 5cf0-5cff */	0x7c, 0x60, 0x20, 0x20, 0x78, 0x24, 0x7c, 0x60, 0x60, 0x60, 0x24, 0x7c, 0x20, 0x7c, 0x20, 0x60,
	/* 5d00-5d0f */	0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x64, 0x60, 0x78, 0x7c, 0x60,
	/* 5d10-5d1f */	0x20, 0x7c, 0x60, 0x20, 0x7c, 0x24, 0x7c, 0x7c, 0x24, 0x7c, 0x64, 0x64, 0x20, 0x60, 0x60, 0x64,
	/* 5d20-5d2f */	0x60, 0x20, 0x64, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20,
	/* 5d30-5d3f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60,
	/* 5d40-5d4f */	0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x64, 0x20,
	/* 5d50-5d5f */	0x7c, 0x60, 0x64, 0x24, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x24, 0x20, 0x60, 0x20,
	/* 5d60-5d6f */	0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x24, 0x20, 0x7c,
	/* 5d70-5d7f */	0x20, 0x60, 0x60, 0x24, 0x20, 0x20, 0x24, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60,
	/* 5d80-5d8f */	0x60, 0x60, 0x64, 0x20, 0x64, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x3c, 0x24, 0x60, 0x20, 0x20,
	/* 5d90-5d9f */	0x24, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60,
	/* 5da0-5daf */	0x78, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x78, 0x20, 0x64, 0x60, 0x64, 0x60,
	/* 5db0-5dbf */	0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x64, 0x7c, 0x24, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x20,
	/* 5dc0-5dcf */	0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x20, 0x64, 0x20, 0x60, 0x24, 0x7c, 0x20, 0x60,
	/* 5dd0-5ddf */	0x24, 0x60, 0x7c, 0x24, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x24, 0x20, 0x7c, 0x7c, 0x60,
	/* 5de0-5def */	0x60, 0x7c, 0x78, 0x24, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x20,
	/* 5df0-5dff */	0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x24, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x24, 0x20, 0x7c, 0x7c, 0x60,
	/* 5e00-5e0f */	0x20, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x24, 0x7c, 0x20, 0x60, 0x20,
	/* 5e10-5e1f */	0x20, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x7c, 0x20, 0x7c, 0x20, 0x60,
	/* 5e20-5e2f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x24,
	/* 5e30-5e3f */	0x24, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x64, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x38,
	/* 5e40-5e4f */	0x7c, 0x60, 0x20, 0x64, 0x7c, 0x7c, 0x20, 0x3c, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x60,
	/* 5e50-5e5f */	0x20, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c,
	/* 5e60-5e6f */	0x60, 0x7c, 0x7c, 0x7c, 0x24, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 5e70-5e7f */	0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x64, 0x64, 0x38, 0x7c, 0x7c, 0x24, 0x7c, 0x7c, 0x7c, 0x7c, 0x24,
	/* 5e80-5e8f */	0x60, 0x24, 0x60, 0x24, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c,
	/* 5e90-5e9f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x20,
	/* 5ea0-5eaf */	0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20,
	/* 5eb0-5ebf */	0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x78, 0x20,
	/* 5ec0-5ecf */	0x20, 0x64, 0x7c, 0x24, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x24,
	/* 5ed0-5edf */	0x3c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x64, 0x60, 0x7c,
	/* 5ee0-5eef */	0x7c, 0x64, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x64, 0x64, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x60,
	/* 5ef0-5eff */	0x24, 0x64, 0x60, 0x7c, 0x24, 0x20, 0x7c, 0x7c, 0x24, 0x20, 0x7c, 0x3c, 0x24, 0x20, 0x64, 0x64,
	/* 5f00-5f0f */	0x20, 0x7c, 0x60, 0x24, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x24, 0x7c, 0x64, 0x24, 0x24, 0x20, 0x7c,
	/* 5f10-5f1f */	0x24, 0x3c, 0x60, 0x7c, 0x7c, 0x7c, 0x24, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x7c,
	/* 5f20-5f2f */	0x20, 0x24, 0x60, 0x60, 0x60, 0x24, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x64, 0x60, 0x24,
	/* 5f30-5f3f */	0x60, 0x7c, 0x20, 0x60, 0x24, 0x7c, 0x60, 0x64, 0x64, 0x20, 0x38, 0x20, 0x7c, 0x20, 0x24, 0x20,
	/* 5f40-5f4f */	0x60, 0x24, 0x20, 0x60, 0x60, 0x24, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x7c, 0x60,
	/* 5f50-5f5f */	0x20, 0x24, 0x20, 0x24, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x38, 0x24, 0x64, 0x20, 0x20,
	/* 5f60-5f6f */	0x20, 0x24, 0x7c, 0x20, 0x60, 0x60, 0x3c, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x60,
	/* 5f70-5f7f */	0x7c, 0x7c, 0x20, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x7c,
	/* 5f80-5f8f */	0x7c, 0x7c, 0x64, 0x24, 0x24, 0x7c, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x20,
	/* 5f90-5f9f */	0x7c, 0x7c, 0x7c, 0x24, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x60,
	/* 5fa0-5faf */	0x7c, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x60,
	/* 5fb0-5fbf */	0x20, 0x20, 0x60, 0x24, 0x24, 0x78, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x60,
	/* 5fc0-5fcf */	0x60, 0x60, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x20, 0x60,
	/* 5fd0-5fdf */	0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x24, 0x64, 0x64, 0x20,
	/* 5fe0-5fef */	0x7c, 0x60, 0x20, 0x60, 0x64, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60,
	/* 5ff0-5fff */	0x24, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x20, 0x60, 0x64, 0x20, 0x7c, 0x20, 0x7c,
	/* 6000-600f */	0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x7c,
	/* 6010-601f */	0x64, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x64, 0x60, 0x64, 0x7c, 0x7c, 0x60, 0x20,
	/* 6020-602f */	0x7c, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x7c, 0x7c, 0x64, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x7c,
	/* 6030-603f */	0x20, 0x24, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 6040-604f */	0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x24, 0x24, 0x60, 0x7c, 0x20, 0x20,
	/* 6050-605f */	0x7c, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x20, 0x7c, 0x60, 0x64,
	/* 6060-606f */	0x24, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x64, 0x7c, 0x7c, 0x60, 0x7c,
	/* 6070-607f */	0x7c, 0x20, 0x60, 0x20, 0x20, 0x24, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60,
	/* 6080-608f */	0x60, 0x64, 0x20, 0x64, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x24, 0x7c, 0x7c, 0x60, 0x20,
	/* 6090-609f */	0x60, 0x20, 0x64, 0x20, 0x7c, 0x60, 0x7c, 0x64, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x7c,
	/* 60a0-60af */	0x7c, 0x20, 0x60, 0x7c, 0x38, 0x20, 0x24, 0x3c, 0x60, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 60b0-60bf */	0x78, 0x60, 0x7c, 0x3c, 0x7c, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60,
	/* 60c0-60cf */	0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 60d0-60df */	0x20, 0x7c, 0x20, 0x64, 0x60, 0x64, 0x20, 0x20, 0x64, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x24, 0x7c,
	/* 60e0-60ef */	0x7c, 0x7c, 0x60, 0x24, 0x60, 0x20, 0x60, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 60f0-60ff */	0x7c, 0x7c, 0x64, 0x7c, 0x64, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x60,
	/* 6100-610f */	0x64, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x7c,
	/* 6110-611f */	0x60, 0x24, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x7c,
	/* 6120-612f */	0x24, 0x24, 0x20, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x60, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60,
	/* 6130-613f */	0x3c, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x3c, 0x24, 0x7c, 0x7c,
	/* 6140-614f */	0x60, 0x60, 0x3c, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x64, 0x64, 0x60,
	/* 6150-615f */	0x20, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x3c, 0x64, 0x60, 0x20, 0x7c, 0x60, 0x7c,
	/* 6160-616f */	0x20, 0x60, 0x7c, 0x7c, 0x38, 0x64, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x24,
	/* 6170-617f */	0x7c, 0x64, 0x60, 0x64, 0x64, 0x64, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x60, 0x38, 0x7c, 0x20,
	/* 6180-618f */	0x60, 0x38, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x20,
	/* 6190-619f */	0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x64, 0x20, 0x3c, 0x3c, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60,
	/* 61a0-61af */	0x20, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x60,
	/* 61b0-61bf */	0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x60,
	/* 61c0-61cf */	0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x64, 0x20, 0x20,
	/* 61d0-61df */	0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 61e0-61ef */	0x60, 0x20, 0x20, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20,
	/* 61f0-61ff */	0x60, 0x60, 0x7c, 0x20, 0x24, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x64, 0x64, 0x7c,
	/* 6200-620f */	0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x78, 0x7c, 0x64, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x20,
	/* 6210-621f */	0x7c, 0x7c, 0x7c, 0x24, 0x64, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x64, 0x20, 0x24, 0x24, 0x7c,
	/* 6220-622f */	0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x24, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x24,
	/* 6230-623f */	0x7c, 0x38, 0x64, 0x64, 0x7c, 0x20, 0x78, 0x20, 0x24, 0x20, 0x60, 0x24, 0x20, 0x60, 0x78, 0x7c,
	/* 6240-624f */	0x7c, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x7c, 0x64, 0x20,
	/* 6250-625f */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x24, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x20, 0x64, 0x20,
	/* 6260-626f */	0x64, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60,
	/* 6270-627f */	0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x7c,
	/* 6280-628f */	0x7c, 0x60, 0x24, 0x64, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x60,
	/* 6290-629f */	0x20, 0x7c, 0x7c, 0x64, 0x64, 0x7c, 0x64, 0x7c, 0x7c, 0x20, 0x20, 0x3c, 0x24, 0x20, 0x24, 0x20,
	/* 62a0-62af */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x60,
	/* 62b0-62bf */	0x60, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x64, 0x7c, 0x7c, 0x60, 0x60,
	/* 62c0-62cf */	0x20, 0x20, 0x7c, 0x20, 0x60, 0x24, 0x64, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x7c,
	/* 62d0-62df */	0x7c, 0x64, 0x7c, 0x7c, 0x7c, 0x20, 0x78, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x24, 0x20, 0x20,
	/* 62e0-62ef */	0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x7c,
	/* 62f0-62ff */	0x60, 0x7c, 0x60, 0x7c, 0x60, 0x64, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c,
	/* 6300-630f */	0x60, 0x7c, 0x64, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x60, 0x60,
	/* 6310-631f */	0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24,
	/* 6320-632f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c,
	/* 6330-633f */	0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x78, 0x60, 0x7c, 0x7c, 0x24,
	/* 6340-634f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x7c,
	/* 6350-635f */	0x7c, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20,
	/* 6360-636f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x64, 0x20, 0x64, 0x20, 0x60, 0x7c, 0x60,
	/* 6370-637f */	0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x38,
	/* 6380-638f */	0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x64,
	/* 6390-639f */	0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x64,
	/* 63a0-63af */	0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x64, 0x60, 0x60, 0x60,
	/* 63b0-63bf */	0x60, 0x60, 0x24, 0x20, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x64, 0x20,
	/* 63c0-63cf */	0x7c, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 63d0-63df */	0x7c, 0x20, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x60,
	/* 63e0-63ef */	0x60, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20, 0x78, 0x7c, 0x60,
	/* 63f0-63ff */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x7c, 0x38, 0x20, 0x60, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 6400-640f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c,
	/* 6410-641f */	0x60, 0x20, 0x60, 0x64, 0x78, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60,
	/* 6420-642f */	0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60,
	/* 6430-643f */	0x60, 0x20, 0x20, 0x60, 0x64, 0x60, 0x64, 0x60, 0x20, 0x60, 0x3c, 0x20, 0x20, 0x60, 0x7c, 0x60,
	/* 6440-644f */	0x60, 0x60, 0x24, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x64, 0x20,
	/* 6450-645f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 6460-646f */	0x7c, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 6470-647f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x78, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60,
	/* 6480-648f */	0x20, 0x20, 0x60, 0x24, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 6490-649f */	0x60, 0x38, 0x7c, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x7c, 0x60,
	/* 64a0-64af */	0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x64, 0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x20,
	/* 64b0-64bf */	0x7c, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x7c, 0x64, 0x60, 0x60, 0x60,
	/* 64c0-64cf */	0x20, 0x7c, 0x64, 0x60, 0x78, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x78, 0x60, 0x20, 0x7c, 0x7c, 0x60,
	/* 64d0-64df */	0x60, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20,
	/* 64e0-64ef */	0x64, 0x3c, 0x7c, 0x64, 0x60, 0x38, 0x7c, 0x3c, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x64,
	/* 64f0-64ff */	0x60, 0x64, 0x7c, 0x60, 0x7c, 0x20, 0x24, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x60,
	/* 6500-650f */	0x7c, 0x60, 0x20, 0x60, 0x78, 0x24, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60,
	/* 6510-651f */	0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x20, 0x20,
	/* 6520-652f */	0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x7c,
	/* 6530-653f */	0x20, 0x20, 0x60, 0x60, 0x24, 0x24, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x7c,
	/* 6540-654f */	0x20, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x3c, 0x3c, 0x7c,
	/* 6550-655f */	0x20, 0x7c, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x7c, 0x64, 0x64, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x20,
	/* 6560-656f */	0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x38, 0x20, 0x60,
	/* 6570-657f */	0x24, 0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x38, 0x60,
	/* 6580-658f */	0x60, 0x60, 0x7c, 0x7c, 0x60, 0x38, 0x20, 0x7c, 0x24, 0x24, 0x20, 0x20, 0x7c, 0x20, 0x24, 0x20,
	/* 6590-659f */	0x7c, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c,
	/* 65a0-65af */	0x60, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x24, 0x60, 0x7c,
	/* 65b0-65bf */	0x7c, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x60,
	/* 65c0-65cf */	0x20, 0x7c, 0x60, 0x64, 0x64, 0x7c, 0x64, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c,
	/* 65d0-65df */	0x60, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x24, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60,
	/* 65e0-65ef */	0x3c, 0x64, 0x64, 0x38, 0x20, 0x7c, 0x7c, 0x24, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60,
	/* 65f0-65ff */	0x60, 0x7c, 0x60, 0x60, 0x78, 0x60, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x78, 0x78, 0x20, 0x38,
	/* 6600-660f */	0x64, 0x20, 0x64, 0x64, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x7c,
	/* 6610-661f */	0x78, 0x78, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x60, 0x3c, 0x7c,
	/* 6620-662f */	0x7c, 0x60, 0x60, 0x20, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x64, 0x7c,
	/* 6630-663f */	0x38, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x7c, 0x20, 0x20, 0x60, 0x78, 0x3c, 0x24, 0x20, 0x20, 0x24,
	/* 6640-664f */	0x20, 0x7c, 0x7c, 0x7c, 0x3c, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x3c, 0x60, 0x20, 0x20, 0x7c,
	/* 6650-665f */	0x20, 0x60, 0x64, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x7c, 0x60, 0x78, 0x60, 0x7c, 0x7c, 0x7c,
	/* 6660-666f */	0x20, 0x60, 0x64, 0x20, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x60, 0x38, 0x60, 0x20, 0x7c, 0x7c,
	/* 6670-667f */	0x64, 0x60, 0x60, 0x3c, 0x7c, 0x20, 0x7c, 0x78, 0x78, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x20,
	/* 6680-668f */	0x60, 0x24, 0x20, 0x24, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x3c, 0x20,
	/* 6690-669f */	0x78, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x64, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x60,
	/* 66a0-66af */	0x7c, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x60,
	/* 66b0-66bf */	0x60, 0x60, 0x7c, 0x38, 0x7c, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x78, 0x24, 0x60, 0x7c, 0x24,
	/* 66c0-66cf */	0x60, 0x24, 0x20, 0x20, 0x7c, 0x20, 0x78, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 66d0-66df */	0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x20,
	/* 66e0-66ef */	0x7c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 66f0-66ff */	0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x24, 0x60, 0x7c, 0x7c, 0x7c, 0x3c, 0x24, 0x7c, 0x24, 0x7c, 0x7c,
	/* 6700-670f */	0x7c, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x7c, 0x24, 0x64,
	/* 6710-671f */	0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x24, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x3c, 0x7c,
	/* 6720-672f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x20,
	/* 6730-673f */	0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x3c, 0x24, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x64,
	/* 6740-674f */	0x20, 0x24, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c,
	/* 6750-675f */	0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x64, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x7c,
	/* 6760-676f */	0x64, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x64, 0x20, 0x60, 0x7c, 0x20, 0x7c,
	/* 6770-677f */	0x7c, 0x7c, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x78, 0x64, 0x60, 0x7c, 0x7c,
	/* 6780-678f */	0x20, 0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x64, 0x60, 0x60, 0x38,
	/* 6790-679f */	0x7c, 0x60, 0x60, 0x78, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x60,
	/* 67a0-67af */	0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c,
	/* 67b0-67bf */	0x78, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x64, 0x20, 0x20, 0x38, 0x20,
	/* 67c0-67cf */	0x64, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x64, 0x7c,
	/* 67d0-67df */	0x7c, 0x7c, 0x78, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x60,
	/* 67e0-67ef */	0x20, 0x20, 0x64, 0x60, 0x64, 0x60, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x7c,
	/* 67f0-67ff */	0x78, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x78, 0x60, 0x60, 0x20, 0x60, 0x3c, 0x60, 0x20, 0x3c, 0x64,
	/* 6800-680f */	0x20, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 6810-681f */	0x20, 0x20, 0x78, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x24, 0x60,
	/* 6820-682f */	0x60, 0x7c, 0x3c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x64, 0x20, 0x60, 0x60, 0x78,
	/* 6830-683f */	0x20, 0x60, 0x64, 0x60, 0x64, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x20,
	/* 6840-684f */	0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x60,
	/* 6850-685f */	0x7c, 0x7c, 0x24, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x24, 0x24, 0x20, 0x24,
	/* 6860-686f */	0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x60, 0x20, 0x78, 0x60, 0x60,
	/* 6870-687f */	0x20, 0x60, 0x60, 0x20, 0x64, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x7c,
	/* 6880-688f */	0x60, 0x7c, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x24, 0x20, 0x7c,
	/* 6890-689f */	0x60, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x64, 0x60, 0x7c, 0x20, 0x7c,
	/* 68a0-68af */	0x64, 0x78, 0x7c, 0x60, 0x60, 0x20, 0x24, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c,
	/* 68b0-68bf */	0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x3c, 0x20, 0x20, 0x24, 0x24, 0x20, 0x24, 0x20, 0x20, 0x20,
	/* 68c0-68cf */	0x20, 0x20, 0x20, 0x20, 0x7c, 0x38, 0x64, 0x60, 0x64, 0x7c, 0x24, 0x7c, 0x60, 0x7c, 0x60, 0x24,
	/* 68d0-68df */	0x60, 0x60, 0x7c, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x7c,
	/* 68e0-68ef */	0x7c, 0x64, 0x20, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x78, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x64,
	/* 68f0-68ff */	0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20,
	/* 6900-690f */	0x3c, 0x24, 0x20, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x60, 0x64, 0x64, 0x7c, 0x7c, 0x64,
	/* 6910-691f */	0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20,
	/* 6920-692f */	0x20, 0x24, 0x24, 0x24, 0x20, 0x64, 0x24, 0x38, 0x24, 0x20, 0x64, 0x20, 0x20, 0x20, 0x20, 0x60,
	/* 6930-693f */	0x7c, 0x20, 0x60, 0x60, 0x64, 0x60, 0x24, 0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x7c,
	/* 6940-694f */	0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 6950-695f */	0x20, 0x60, 0x60, 0x7c, 0x7c, 0x3c, 0x60, 0x78, 0x60, 0x7c, 0x7c, 0x60, 0x64, 0x64, 0x7c, 0x60,
	/* 6960-696f */	0x7c, 0x3c, 0x7c, 0x78, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x7c,
	/* 6970-697f */	0x60, 0x60, 0x20, 0x24, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x24, 0x24, 0x24, 0x20,
	/* 6980-698f */	0x20, 0x24, 0x64, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x60, 0x64, 0x20,
	/* 6990-699f */	0x60, 0x64, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x60, 0x24, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x20,
	/* 69a0-69af */	0x64, 0x60, 0x20, 0x60, 0x60, 0x78, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60,
	/* 69b0-69bf */	0x60, 0x64, 0x24, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x64,
	/* 69c0-69cf */	0x20, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x24, 0x20, 0x60, 0x64, 0x7c, 0x7c, 0x7c, 0x64, 0x60,
	/* 69d0-69df */	0x7c, 0x20, 0x20, 0x64, 0x60, 0x20, 0x20, 0x20, 0x24, 0x64, 0x20, 0x20, 0x20, 0x24, 0x24, 0x20,
	/* 69e0-69ef */	0x20, 0x20, 0x64, 0x20, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x38, 0x64, 0x60, 0x64, 0x60, 0x20,
	/* 69f0-69ff */	0x20, 0x60, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x24, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x7c,
	/* 6a00-6a0f */	0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x24, 0x24, 0x60, 0x20, 0x60,
	/* 6a10-6a1f */	0x20, 0x78, 0x24, 0x7c, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x64, 0x20, 0x60, 0x7c, 0x7c,
	/* 6a20-6a2f */	0x60, 0x7c, 0x24, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x24, 0x24, 0x24, 0x20, 0x20, 0x24, 0x20,
	/* 6a30-6a3f */	0x24, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x24, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60,
	/* 6a40-6a4f */	0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x64, 0x64, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x60,
	/* 6a50-6a5f */	0x60, 0x60, 0x38, 0x38, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c,
	/* 6a60-6a6f */	0x60, 0x7c, 0x64, 0x20, 0x60, 0x20, 0x64, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x60,
	/* 6a70-6a7f */	0x20, 0x20, 0x24, 0x24, 0x20, 0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x64,
	/* 6a80-6a8f */	0x7c, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x78, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x20,
	/* 6a90-6a9f */	0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60,
	/* 6aa0-6aaf */	0x64, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x24, 0x20, 0x64, 0x60, 0x64, 0x60,
	/* 6ab0-6abf */	0x20, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x20,
	/* 6ac0-6acf */	0x20, 0x24, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60,
	/* 6ad0-6adf */	0x60, 0x64, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x64, 0x64,
	/* 6ae0-6aef */	0x60, 0x60, 0x24, 0x20, 0x24, 0x60, 0x20, 0x60, 0x64, 0x20, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 6af0-6aff */	0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x38, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x20, 0x20,
	/* 6b00-6b0f */	0x60, 0x20, 0x60, 0x60, 0x7c, 0x24, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x38, 0x20, 0x20, 0x60,
	/* 6b10-6b1f */	0x60, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x24, 0x60, 0x24,
	/* 6b20-6b2f */	0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x24, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60,
	/* 6b30-6b3f */	0x20, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x64, 0x64, 0x64, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60,
	/* 6b40-6b4f */	0x20, 0x60, 0x60, 0x64, 0x20, 0x60, 0x78, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x20,
	/* 6b50-6b5f */	0x7c, 0x60, 0x20, 0x24, 0x64, 0x60, 0x60, 0x20, 0x20, 0x64, 0x20, 0x64, 0x60, 0x20, 0x60, 0x7c,
	/* 6b60-6b6f */	0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x78, 0x7c, 0x60, 0x20, 0x24, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x24,
	/* 6b70-6b7f */	0x20, 0x20, 0x78, 0x24, 0x24, 0x20, 0x60, 0x78, 0x7c, 0x64, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x7c,
	/* 6b80-6b8f */	0x64, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x24, 0x60, 0x64, 0x60, 0x60,
	/* 6b90-6b9f */	0x20, 0x60, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x60,
	/* 6ba0-6baf */	0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20, 0x20, 0x64, 0x64, 0x20, 0x60, 0x78, 0x7c,
	/* 6bb0-6bbf */	0x60, 0x24, 0x7c, 0x64, 0x24, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x24, 0x7c, 0x60, 0x20, 0x7c,
	/* 6bc0-6bcf */	0x64, 0x38, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x24, 0x78,
	/* 6bd0-6bdf */	0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x78, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x24,
	/* 6be0-6bef */	0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x20, 0x20, 0x64,
	/* 6bf0-6bff */	0x60, 0x20, 0x60, 0x64, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 6c00-6c0f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c,
	/* 6c10-6c1f */	0x60, 0x7c, 0x20, 0x7c, 0x64, 0x60, 0x60, 0x24, 0x60, 0x60, 0x60, 0x64, 0x20, 0x60, 0x20, 0x60,
	/* 6c20-6c2f */	0x60, 0x60, 0x20, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 6c30-6c3f */	0x60, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x3c, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x64,
	/* 6c40-6c4f */	0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60,
	/* 6c50-6c5f */	0x7c, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x3c, 0x60, 0x64, 0x7c, 0x7c, 0x7c,
	/* 6c60-6c6f */	0x7c, 0x60, 0x24, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x78, 0x20, 0x64,
	/* 6c70-6c7f */	0x7c, 0x60, 0x7c, 0x64, 0x60, 0x20, 0x78, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x20,
	/* 6c80-6c8f */	0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x78, 0x7c, 0x78, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x60,
	/* 6c90-6c9f */	0x7c, 0x20, 0x7c, 0x7c, 0x78, 0x78, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x20,
	/* 6ca0-6caf */	0x20, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x20,
	/* 6cb0-6cbf */	0x60, 0x64, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x64, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* 6cc0-6ccf */	0x60, 0x7c, 0x78, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x60,
	/* 6cd0-6cdf */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x64, 0x64, 0x7c, 0x60, 0x64, 0x60, 0x20,
	/* 6ce0-6cef */	0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x24, 0x78, 0x60, 0x60, 0x78, 0x7c,
	/* 6cf0-6cff */	0x7c, 0x64, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 6d00-6d0f */	0x60, 0x60, 0x20, 0x60, 0x64, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60,
	/* 6d10-6d1f */	0x60, 0x78, 0x64, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x64,
	/* 6d20-6d2f */	0x60, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x78, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x60,
	/* 6d30-6d3f */	0x60, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x78, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60,
	/* 6d40-6d4f */	0x60, 0x7c, 0x60, 0x20, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 6d50-6d5f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x3c, 0x20, 0x60, 0x60,
	/* 6d60-6d6f */	0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x64,
	/* 6d70-6d7f */	0x60, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78,
	/* 6d80-6d8f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x78, 0x60, 0x60, 0x7c, 0x78, 0x7c, 0x20,
	/* 6d90-6d9f */	0x60, 0x78, 0x60, 0x7c, 0x60, 0x7c, 0x24, 0x60, 0x60, 0x24, 0x20, 0x24, 0x24, 0x20, 0x20, 0x20,
	/* 6da0-6daf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x20, 0x60, 0x7c,
	/* 6db0-6dbf */	0x20, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60,
	/* 6dc0-6dcf */	0x7c, 0x20, 0x60, 0x38, 0x78, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x20, 0x7c,
	/* 6dd0-6ddf */	0x60, 0x7c, 0x64, 0x60, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x7c, 0x78, 0x60, 0x60, 0x60, 0x7c, 0x60,
	/* 6de0-6def */	0x60, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x60,
	/* 6df0-6dff */	0x60, 0x7c, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x20, 0x20,
	/* 6e00-6e0f */	0x60, 0x20, 0x20, 0x60, 0x20, 0x64, 0x20, 0x24, 0x24, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x20,
	/* 6e10-6e1f */	0x20, 0x20, 0x20, 0x24, 0x20, 0x24, 0x20, 0x38, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x64, 0x20, 0x7c,
	/* 6e20-6e2f */	0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x24, 0x20, 0x7c, 0x7c, 0x7c, 0x64, 0x7c,
	/* 6e30-6e3f */	0x60, 0x60, 0x78, 0x60, 0x78, 0x60, 0x78, 0x20, 0x7c, 0x64, 0x7c, 0x60, 0x7c, 0x78, 0x7c, 0x60,
	/* 6e40-6e4f */	0x60, 0x60, 0x20, 0x7c, 0x78, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x64, 0x20,
	/* 6e50-6e5f */	0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x78, 0x7c,
	/* 6e60-6e6f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x7c,
	/* 6e70-6e7f */	0x20, 0x60, 0x7c, 0x78, 0x60, 0x20, 0x24, 0x60, 0x60, 0x60, 0x38, 0x20, 0x20, 0x20, 0x24, 0x24,
	/* 6e80-6e8f */	0x24, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x24, 0x60, 0x60, 0x64,
	/* 6e90-6e9f */	0x7c, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x7c,
	/* 6ea0-6eaf */	0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x78, 0x20, 0x20, 0x60, 0x7c,
	/* 6eb0-6ebf */	0x60, 0x78, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x64, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x64,
	/* 6ec0-6ecf */	0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x78, 0x60,
	/* 6ed0-6edf */	0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x24, 0x24, 0x20,
	/* 6ee0-6eef */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x64, 0x60, 0x60, 0x7c,
	/* 6ef0-6eff */	0x20, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c,
	/* 6f00-6f0f */	0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x20, 0x20, 0x60, 0x60, 0x7c,
	/* 6f10-6f1f */	0x20, 0x3c, 0x60, 0x64, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60,
	/* 6f20-6f2f */	0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60,
	/* 6f30-6f3f */	0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x64, 0x7c,
	/* 6f40-6f4f */	0x60, 0x7c, 0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 6f50-6f5f */	0x60, 0x78, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x78, 0x7c, 0x20, 0x78, 0x7c, 0x24, 0x60, 0x78, 0x7c,
	/* 6f60-6f6f */	0x60, 0x60, 0x78, 0x60, 0x7c, 0x20, 0x64, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x64,
	/* 6f70-6f7f */	0x7c, 0x20, 0x60, 0x60, 0x24, 0x20, 0x60, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x7c, 0x78, 0x78, 0x60,
	/* 6f80-6f8f */	0x64, 0x3c, 0x64, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x78, 0x7c, 0x20,
	/* 6f90-6f9f */	0x78, 0x24, 0x60, 0x60, 0x78, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20,
	/* 6fa0-6faf */	0x60, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x78, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x78, 0x78,
	/* 6fb0-6fbf */	0x60, 0x7c, 0x60, 0x7c, 0x60, 0x24, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x38, 0x60,
	/* 6fc0-6fcf */	0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x64, 0x60, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 6fd0-6fdf */	0x20, 0x20, 0x20, 0x20, 0x64, 0x7c, 0x20, 0x20, 0x64, 0x20, 0x38, 0x64, 0x60, 0x60, 0x60, 0x7c,
	/* 6fe0-6fef */	0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x78, 0x20, 0x7c, 0x7c, 0x60, 0x64, 0x7c,
	/* 6ff0-6fff */	0x60, 0x7c, 0x60, 0x24, 0x60, 0x24, 0x24, 0x60, 0x20, 0x20, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x60,
	/* 7000-700f */	0x60, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x78, 0x64, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c,
	/* 7010-701f */	0x20, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x78, 0x7c, 0x3c, 0x7c,
	/* 7020-702f */	0x60, 0x60, 0x60, 0x78, 0x60, 0x20, 0x64, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x24, 0x20, 0x20, 0x78,
	/* 7030-703f */	0x64, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20, 0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60,
	/* 7040-704f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20,
	/* 7050-705f */	0x38, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x78, 0x60, 0x60,
	/* 7060-706f */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x24,
	/* 7070-707f */	0x7c, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x20,
	/* 7080-708f */	0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x24, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x20,
	/* 7090-709f */	0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x78, 0x7c, 0x78, 0x20, 0x20, 0x20, 0x20, 0x60,
	/* 70a0-70af */	0x20, 0x78, 0x20, 0x20, 0x78, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x64, 0x7c,
	/* 70b0-70bf */	0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x78, 0x7c, 0x3c, 0x64, 0x24, 0x20, 0x20, 0x60, 0x20,
	/* 70c0-70cf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x7c,
	/* 70d0-70df */	0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x78, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x3c,
	/* 70e0-70ef */	0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60,
	/* 70f0-70ff */	0x60, 0x3c, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60,
	/* 7100-710f */	0x60, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x78, 0x60, 0x60, 0x24,
	/* 7110-711f */	0x60, 0x20, 0x20, 0x60, 0x24, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x64, 0x20, 0x78, 0x60,
	/* 7120-712f */	0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 7130-713f */	0x78, 0x60, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20,
	/* 7140-714f */	0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x64, 0x7c, 0x20, 0x7c, 0x38, 0x60, 0x7c, 0x60, 0x7c, 0x20,
	/* 7150-715f */	0x78, 0x20, 0x60, 0x60, 0x60, 0x24, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x78, 0x60,
	/* 7160-716f */	0x60, 0x60, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x7c, 0x20,
	/* 7170-717f */	0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x20,
	/* 7180-718f */	0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x24, 0x78, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c,
	/* 7190-719f */	0x60, 0x20, 0x78, 0x20, 0x7c, 0x24, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 71a0-71af */	0x60, 0x60, 0x38, 0x20, 0x60, 0x60, 0x20, 0x60, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x60,
	/* 71b0-71bf */	0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x38, 0x20, 0x60, 0x60, 0x7c, 0x60,
	/* 71c0-71cf */	0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x60,
	/* 71d0-71df */	0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c,
	/* 71e0-71ef */	0x64, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x64, 0x7c, 0x7c, 0x20,
	/* 71f0-71ff */	0x60, 0x60, 0x60, 0x20, 0x60, 0x24, 0x20, 0x20, 0x60, 0x64, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x7c,
	/* 7200-720f */	0x38, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x64, 0x20, 0x20,
	/* 7210-721f */	0x7c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60,
	/* 7220-722f */	0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x20,
	/* 7230-723f */	0x7c, 0x20, 0x3c, 0x20, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x24, 0x7c, 0x7c, 0x64,
	/* 7240-724f */	0x3c, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x20, 0x60,
	/* 7250-725f */	0x20, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x7c,
	/* 7260-726f */	0x60, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60,
	/* 7270-727f */	0x60, 0x20, 0x7c, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x64, 0x60,
	/* 7280-728f */	0x7c, 0x7c, 0x24, 0x20, 0x60, 0x60, 0x60, 0x24, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 7290-729f */	0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20,
	/* 72a0-72af */	0x24, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x7c,
	/* 72b0-72bf */	0x60, 0x24, 0x24, 0x20, 0x60, 0x60, 0x24, 0x20, 0x20, 0x24, 0x60, 0x20, 0x20, 0x60, 0x24, 0x60,
	/* 72c0-72cf */	0x78, 0x60, 0x7c, 0x64, 0x7c, 0x60, 0x64, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20,
	/* 72d0-72df */	0x7c, 0x60, 0x64, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x24, 0x60, 0x20, 0x20, 0x60,
	/* 72e0-72ef */	0x64, 0x7c, 0x24, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x24, 0x24, 0x20, 0x20,
	/* 72f0-72ff */	0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60,
	/* 7300-730f */	0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 7310-731f */	0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x24,
	/* 7320-732f */	0x20, 0x20, 0x60, 0x60, 0x24, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x3c, 0x3c, 0x20, 0x60, 0x24, 0x24,
	/* 7330-733f */	0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x7c,
	/* 7340-734f */	0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x64, 0x24,
	/* 7350-735f */	0x78, 0x60, 0x78, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 7360-736f */	0x60, 0x60, 0x60, 0x24, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 7370-737f */	0x7c, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x7c, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60,
	/* 7380-738f */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x78, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x78, 0x20,
	/* 7390-739f */	0x20, 0x20, 0x60, 0x60, 0x78, 0x60, 0x7c, 0x78, 0x38, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x78,
	/* 73a0-73af */	0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x38, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x78, 0x20, 0x20,
	/* 73b0-73bf */	0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78, 0x20, 0x64, 0x60, 0x24, 0x60, 0x60,
	/* 73c0-73cf */	0x7c, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x3c, 0x7c, 0x60, 0x78, 0x7c, 0x24, 0x38,
	/* 73d0-73df */	0x20, 0x20, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60, 0x78, 0x7c, 0x20,
	/* 73e0-73ef */	0x7c, 0x20, 0x20, 0x7c, 0x38, 0x7c, 0x38, 0x60, 0x60, 0x78, 0x7c, 0x60, 0x20, 0x7c, 0x64, 0x20,
	/* 73f0-73ff */	0x20, 0x24, 0x20, 0x20, 0x60, 0x64, 0x60, 0x38, 0x64, 0x38, 0x60, 0x20, 0x60, 0x78, 0x7c, 0x60,
	/* 7400-740f */	0x60, 0x78, 0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20,
	/* 7410-741f */	0x20, 0x20, 0x20, 0x38, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x78, 0x20, 0x60, 0x20, 0x20,
	/* 7420-742f */	0x78, 0x78, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x78, 0x64, 0x7c, 0x78, 0x78, 0x60, 0x7c, 0x78,
	/* 7430-743f */	0x78, 0x60, 0x64, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x38, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c,
	/* 7440-744f */	0x78, 0x7c, 0x60, 0x38, 0x78, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x78, 0x20, 0x60, 0x60, 0x60,
	/* 7450-745f */	0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x78, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x7c,
	/* 7460-746f */	0x3c, 0x20, 0x7c, 0x64, 0x7c, 0x38, 0x20, 0x60, 0x38, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x7c,
	/* 7470-747f */	0x64, 0x60, 0x60, 0x64, 0x20, 0x60, 0x24, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60,
	/* 7480-748f */	0x60, 0x60, 0x38, 0x7c, 0x20, 0x60, 0x60, 0x78, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20,
	/* 7490-749f */	0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x78, 0x20, 0x60, 0x20, 0x78, 0x20, 0x7c, 0x7c,
	/* 74a0-74af */	0x60, 0x78, 0x24, 0x78, 0x20, 0x78, 0x60, 0x7c, 0x78, 0x60, 0x78, 0x60, 0x20, 0x60, 0x20, 0x60,
	/* 74b0-74bf */	0x7c, 0x60, 0x78, 0x20, 0x20, 0x78, 0x60, 0x60, 0x60, 0x38, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x78,
	/* 74c0-74cf */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x38, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x7c,
	/* 74d0-74df */	0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x78, 0x60, 0x78, 0x60, 0x7c, 0x60, 0x60, 0x60,
	/* 74e0-74ef */	0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x24, 0x60, 0x64, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20,
	/* 74f0-74ff */	0x24, 0x24, 0x24, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x24, 0x20, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 7500-750f */	0x60, 0x3c, 0x60, 0x64, 0x7c, 0x24, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x64, 0x64, 0x24, 0x60,
	/* 7510-751f */	0x60, 0x7c, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x38, 0x64, 0x60, 0x24, 0x7c,
	/* 7520-752f */	0x20, 0x60, 0x60, 0x3c, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x64,
	/* 7530-753f */	0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x24, 0x24, 0x60, 0x60, 0x60,
	/* 7540-754f */	0x60, 0x20, 0x20, 0x20, 0x24, 0x20, 0x24, 0x78, 0x60, 0x24, 0x24, 0x64, 0x7c, 0x24, 0x60, 0x7c,
	/* 7550-755f */	0x20, 0x3c, 0x20, 0x38, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x7c, 0x7c, 0x7c, 0x20, 0x60,
	/* 7560-756f */	0x24, 0x20, 0x7c, 0x60, 0x64, 0x7c, 0x7c, 0x24, 0x20, 0x24, 0x7c, 0x64, 0x60, 0x24, 0x20, 0x7c,
	/* 7570-757f */	0x7c, 0x20, 0x20, 0x24, 0x24, 0x38, 0x7c, 0x64, 0x7c, 0x60, 0x38, 0x20, 0x20, 0x60, 0x60, 0x7c,
	/* 7580-758f */	0x60, 0x20, 0x24, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x24, 0x7c, 0x7c, 0x60, 0x20, 0x3c, 0x7c,
	/* 7590-759f */	0x60, 0x7c, 0x20, 0x20, 0x64, 0x60, 0x20, 0x20, 0x60, 0x60, 0x64, 0x20, 0x20, 0x7c, 0x20, 0x20,
	/* 75a0-75af */	0x20, 0x20, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20,
	/* 75b0-75bf */	0x60, 0x3c, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60,
	/* 75c0-75cf */	0x60, 0x60, 0x7c, 0x24, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60,
	/* 75d0-75df */	0x60, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x60,
	/* 75e0-75ef */	0x60, 0x60, 0x7c, 0x64, 0x60, 0x20, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60,
	/* 75f0-75ff */	0x7c, 0x60, 0x7c, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x64, 0x64,
	/* 7600-760f */	0x78, 0x64, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x64, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x60,
	/* 7610-761f */	0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 7620-762f */	0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x78, 0x64, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60,
	/* 7630-763f */	0x64, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x3c, 0x60, 0x60, 0x20, 0x20,
	/* 7640-764f */	0x20, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x64, 0x64, 0x64, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x38, 0x20,
	/* 7650-765f */	0x60, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x20, 0x64, 0x20, 0x20, 0x60,
	/* 7660-766f */	0x60, 0x7c, 0x64, 0x20, 0x78, 0x60, 0x20, 0x24, 0x24, 0x7c, 0x64, 0x20, 0x7c, 0x60, 0x60, 0x20,
	/* 7670-767f */	0x7c, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x24, 0x20, 0x7c, 0x60, 0x24, 0x7c, 0x7c, 0x7c, 0x7c, 0x60,
	/* 7680-768f */	0x24, 0x60, 0x64, 0x24, 0x7c, 0x20, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x64, 0x20, 0x20, 0x7c, 0x60,
	/* 7690-769f */	0x3c, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x20, 0x20, 0x64, 0x64, 0x64, 0x64, 0x60, 0x64, 0x20,
	/* 76a0-76af */	0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x64, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60,
	/* 76b0-76bf */	0x64, 0x20, 0x20, 0x20, 0x64, 0x60, 0x20, 0x24, 0x64, 0x24, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x7c,
	/* 76c0-76cf */	0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x64, 0x60, 0x20,
	/* 76d0-76df */	0x20, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x3c, 0x24, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x7c,
	/* 76e0-76ef */	0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x60,
	/* 76f0-76ff */	0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x78, 0x20, 0x7c, 0x20,
	/* 7700-770f */	0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x64, 0x7c, 0x7c, 0x60, 0x7c, 0x24, 0x20, 0x20, 0x20,
	/* 7710-771f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x20, 0x60, 0x3c, 0x64,
	/* 7720-772f */	0x7c, 0x20, 0x60, 0x60, 0x24, 0x64, 0x24, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60,
	/* 7730-773f */	0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x20,
	/* 7740-774f */	0x3c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x64, 0x20, 0x20, 0x60, 0x60, 0x60, 0x78, 0x60, 0x60,
	/* 7750-775f */	0x20, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x60, 0x60,
	/* 7760-776f */	0x60, 0x7c, 0x60, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60,
	/* 7770-777f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x7c,
	/* 7780-778f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x60,
	/* 7790-779f */	0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60,
	/* 77a0-77af */	0x64, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x20,
	/* 77b0-77bf */	0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x20, 0x24, 0x60, 0x7c, 0x7c, 0x64, 0x20, 0x7c,
	/* 77c0-77cf */	0x20, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x64, 0x20, 0x60, 0x60, 0x20, 0x60, 0x64, 0x60, 0x60,
	/* 77d0-77df */	0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x7c, 0x20, 0x60, 0x20,
	/* 77e0-77ef */	0x60, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x64, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c,
	/* 77f0-77ff */	0x60, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x20,
	/* 7800-780f */	0x20, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x64, 0x60, 0x60, 0x60,
	/* 7810-781f */	0x60, 0x60, 0x7c, 0x60, 0x64, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60,
	/* 7820-782f */	0x64, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x78, 0x60, 0x60, 0x60,
	/* 7830-783f */	0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x24,
	/* 7840-784f */	0x20, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x64, 0x38,
	/* 7850-785f */	0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x20,
	/* 7860-786f */	0x60, 0x20, 0x60, 0x20, 0x64, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x7c,
	/* 7870-787f */	0x60, 0x60, 0x24, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x60, 0x24, 0x60, 0x7c, 0x20, 0x60, 0x60,
	/* 7880-788f */	0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x3c, 0x7c, 0x60,
	/* 7890-789f */	0x20, 0x7c, 0x20, 0x64, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 78a0-78af */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x20, 0x24,
	/* 78b0-78bf */	0x60, 0x20, 0x60, 0x60, 0x60, 0x24, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x78, 0x7c, 0x20, 0x64, 0x20,
	/* 78c0-78cf */	0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x24, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x78, 0x60,
	/* 78d0-78df */	0x7c, 0x64, 0x20, 0x20, 0x64, 0x60, 0x20, 0x20, 0x20, 0x20, 0x64, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 78e0-78ef */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x7c,
	/* 78f0-78ff */	0x20, 0x20, 0x60, 0x60, 0x64, 0x38, 0x20, 0x60, 0x20, 0x60, 0x60, 0x78, 0x60, 0x64, 0x60, 0x60,
	/* 7900-790f */	0x20, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x24, 0x20, 0x60, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20,
	/* 7910-791f */	0x60, 0x64, 0x64, 0x60, 0x60, 0x20, 0x38, 0x60, 0x20, 0x64, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 7920-792f */	0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x60,
	/* 7930-793f */	0x24, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x24, 0x60, 0x7c, 0x60,
	/* 7940-794f */	0x7c, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 7950-795f */	0x7c, 0x60, 0x60, 0x64, 0x60, 0x64, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x78, 0x78, 0x7c, 0x7c, 0x64,
	/* 7960-796f */	0x7c, 0x60, 0x24, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20,
	/* 7970-797f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x24, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x7c,
	/* 7980-798f */	0x24, 0x7c, 0x60, 0x20, 0x24, 0x24, 0x20, 0x20, 0x60, 0x20, 0x64, 0x60, 0x20, 0x7c, 0x7c, 0x7c,
	/* 7990-799f */	0x60, 0x38, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x64, 0x60, 0x24, 0x20, 0x20,
	/* 79a0-79af */	0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x20,
	/* 79b0-79bf */	0x64, 0x78, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x20, 0x7c, 0x7c, 0x7c,
	/* 79c0-79cf */	0x7c, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x38, 0x7c, 0x20, 0x60, 0x60, 0x60,
	/* 79d0-79df */	0x20, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c,
	/* 79e0-79ef */	0x60, 0x24, 0x20, 0x64, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20,
	/* 79f0-79ff */	0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20,
	/* 7a00-7a0f */	0x7c, 0x20, 0x60, 0x60, 0x60, 0x78, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x24, 0x20,
	/* 7a10-7a1f */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x64, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c,
	/* 7a20-7a2f */	0x7c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x60,
	/* 7a30-7a3f */	0x60, 0x7c, 0x24, 0x20, 0x20, 0x20, 0x38, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x24, 0x7c,
	/* 7a40-7a4f */	0x7c, 0x20, 0x24, 0x24, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x3c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x24,
	/* 7a50-7a5f */	0x24, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 7a60-7a6f */	0x60, 0x7c, 0x7c, 0x24, 0x20, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x20,
	/* 7a70-7a7f */	0x7c, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x3c, 0x60, 0x7c,
	/* 7a80-7a8f */	0x60, 0x7c, 0x20, 0x24, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 7a90-7a9f */	0x60, 0x20, 0x7c, 0x3c, 0x60, 0x7c, 0x64, 0x64, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c,
	/* 7aa0-7aaf */	0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x7c,
	/* 7ab0-7abf */	0x24, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x64,
	/* 7ac0-7acf */	0x60, 0x60, 0x20, 0x24, 0x7c, 0x7c, 0x20, 0x7c, 0x24, 0x20, 0x7c, 0x7c, 0x20, 0x24, 0x20, 0x24,
	/* 7ad0-7adf */	0x20, 0x64, 0x24, 0x24, 0x20, 0x24, 0x20, 0x38, 0x60, 0x7c, 0x24, 0x20, 0x24, 0x3c, 0x20, 0x7c,
	/* 7ae0-7aef */	0x7c, 0x24, 0x24, 0x7c, 0x60, 0x7c, 0x64, 0x24, 0x20, 0x20, 0x3c, 0x64, 0x20, 0x7c, 0x60, 0x7c,
	/* 7af0-7aff */	0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x24, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x7c,
	/* 7b00-7b0f */	0x60, 0x60, 0x24, 0x20, 0x64, 0x60, 0x64, 0x20, 0x64, 0x60, 0x64, 0x24, 0x20, 0x20, 0x60, 0x7c,
	/* 7b10-7b1f */	0x60, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x64, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x20,
	/* 7b20-7b2f */	0x7c, 0x20, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x78, 0x60, 0x60,
	/* 7b30-7b3f */	0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x24, 0x20, 0x60, 0x3c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20,
	/* 7b40-7b4f */	0x60, 0x20, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c,
	/* 7b50-7b5f */	0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20,
	/* 7b60-7b6f */	0x78, 0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x64, 0x20, 0x60, 0x20, 0x20, 0x3c, 0x60, 0x7c, 0x20,
	/* 7b70-7b7f */	0x64, 0x64, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x38, 0x20, 0x20,
	/* 7b80-7b8f */	0x20, 0x20, 0x60, 0x20, 0x60, 0x60, 0x24, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x7c,
	/* 7b90-7b9f */	0x60, 0x60, 0x24, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x64, 0x64, 0x3c, 0x60, 0x64, 0x7c, 0x24, 0x24,
	/* 7ba0-7baf */	0x60, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x7c, 0x20, 0x60,
	/* 7bb0-7bbf */	0x20, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20,
	/* 7bc0-7bcf */	0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x64, 0x64, 0x20, 0x60, 0x24,
	/* 7bd0-7bdf */	0x20, 0x20, 0x38, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60,
	/* 7be0-7bef */	0x7c, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20,
	/* 7bf0-7bff */	0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x24, 0x64, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 7c00-7c0f */	0x64, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60,
	/* 7c10-7c1f */	0x60, 0x64, 0x3c, 0x24, 0x24, 0x20, 0x20, 0x24, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x78, 0x64,
	/* 7c20-7c2f */	0x60, 0x7c, 0x60, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x20,
	/* 7c30-7c3f */	0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x64, 0x64, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x7c,
	/* 7c40-7c4f */	0x64, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x24,
	/* 7c50-7c5f */	0x64, 0x20, 0x20, 0x60, 0x64, 0x20, 0x24, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x64,
	/* 7c60-7c6f */	0x7c, 0x20, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60,
	/* 7c70-7c7f */	0x20, 0x20, 0x60, 0x7c, 0x20, 0x64, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x24, 0x60,
	/* 7c80-7c8f */	0x60, 0x64, 0x24, 0x3c, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x24, 0x60, 0x64, 0x20, 0x20,
	/* 7c90-7c9f */	0x24, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x24, 0x20, 0x20, 0x60, 0x7c,
	/* 7ca0-7caf */	0x20, 0x64, 0x64, 0x60, 0x24, 0x7c, 0x20, 0x7c, 0x64, 0x20, 0x20, 0x24, 0x20, 0x24, 0x3c, 0x60,
	/* 7cb0-7cbf */	0x20, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x60,
	/* 7cc0-7ccf */	0x24, 0x20, 0x24, 0x20, 0x20, 0x64, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x64, 0x20,
	/* 7cd0-7cdf */	0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x24, 0x60, 0x20, 0x20, 0x64, 0x60, 0x7c, 0x7c,
	/* 7ce0-7cef */	0x7c, 0x20, 0x64, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x64,
	/* 7cf0-7cff */	0x60, 0x60, 0x64, 0x20, 0x64, 0x20, 0x64, 0x60, 0x64, 0x20, 0x24, 0x7c, 0x20, 0x60, 0x7c, 0x20,
	/* 7d00-7d0f */	0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x78, 0x78, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x60,
	/* 7d10-7d1f */	0x7c, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x60,
	/* 7d20-7d2f */	0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x7c,
	/* 7d30-7d3f */	0x7c, 0x60, 0x64, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x64,
	/* 7d40-7d4f */	0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x24, 0x20, 0x60, 0x24, 0x24, 0x20, 0x64, 0x64,
	/* 7d50-7d5f */	0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x20, 0x60, 0x20, 0x20, 0x64, 0x64, 0x20, 0x7c, 0x60,
	/* 7d60-7d6f */	0x20, 0x7c, 0x7c, 0x64, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x78, 0x60, 0x20, 0x60, 0x7c, 0x60,
	/* 7d70-7d7f */	0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x24, 0x3c, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x20, 0x78,
	/* 7d80-7d8f */	0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x24, 0x20, 0x20, 0x60, 0x60, 0x78, 0x7c,
	/* 7d90-7d9f */	0x20, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x20, 0x24, 0x24, 0x24, 0x7c, 0x60, 0x60, 0x64,
	/* 7da0-7daf */	0x7c, 0x60, 0x7c, 0x64, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x24, 0x7c, 0x7c, 0x64, 0x64,
	/* 7db0-7dbf */	0x64, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x7c,
	/* 7dc0-7dcf */	0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x24,
	/* 7dd0-7ddf */	0x20, 0x24, 0x64, 0x20, 0x20, 0x24, 0x3c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x24, 0x7c, 0x7c, 0x60,
	/* 7de0-7def */	0x7c, 0x7c, 0x20, 0x78, 0x24, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x7c,
	/* 7df0-7dff */	0x60, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20,
	/* 7e00-7e0f */	0x20, 0x24, 0x20, 0x60, 0x24, 0x24, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x60,
	/* 7e10-7e1f */	0x60, 0x60, 0x64, 0x60, 0x60, 0x78, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x78, 0x7c, 0x7c,
	/* 7e20-7e2f */	0x60, 0x7c, 0x64, 0x7c, 0x60, 0x60, 0x24, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x78,
	/* 7e30-7e3f */	0x60, 0x7c, 0x64, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x64, 0x64, 0x64, 0x60, 0x7c, 0x7c, 0x60,
	/* 7e40-7e4f */	0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x78, 0x60, 0x60, 0x24, 0x24, 0x60, 0x24, 0x20, 0x20,
	/* 7e50-7e5f */	0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x64, 0x64, 0x20, 0x60, 0x24, 0x7c, 0x60,
	/* 7e60-7e6f */	0x60, 0x78, 0x60, 0x60, 0x20, 0x20, 0x24, 0x24, 0x60, 0x7c, 0x7c, 0x78, 0x20, 0x7c, 0x20, 0x60,
	/* 7e70-7e7f */	0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x7c, 0x64, 0x60, 0x24,
	/* 7e80-7e8f */	0x60, 0x60, 0x7c, 0x24, 0x20, 0x20, 0x60, 0x60, 0x64, 0x24, 0x64, 0x60, 0x7c, 0x60, 0x24, 0x7c,
	/* 7e90-7e9f */	0x24, 0x60, 0x24, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x78, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x20,
	/* 7ea0-7eaf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7eb0-7ebf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7ec0-7ecf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7ed0-7edf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7ee0-7eef */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7ef0-7eff */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7f00-7f0f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7f10-7f1f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7f20-7f2f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 7f30-7f3f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60,
	/* 7f40-7f4f */	0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x20, 0x24, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x64, 0x24, 0x60,
	/* 7f50-7f5f */	0x7c, 0x64, 0x20, 0x20, 0x7c, 0x7c, 0x20, 0x20, 0x64, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64,
	/* 7f60-7f6f */	0x64, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x64, 0x64, 0x64, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x20,
	/* 7f70-7f7f */	0x7c, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x24, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 7f80-7f8f */	0x20, 0x20, 0x24, 0x64, 0x20, 0x7c, 0x64, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20,
	/* 7f90-7f9f */	0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x20,
	/* 7fa0-7faf */	0x60, 0x64, 0x60, 0x24, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x24, 0x64,
	/* 7fb0-7fbf */	0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60,
	/* 7fc0-7fcf */	0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x24, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x78, 0x60,
	/* 7fd0-7fdf */	0x60, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x78,
	/* 7fe0-7fef */	0x7c, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60,
	/* 7ff0-7fff */	0x7c, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x60,
	/* 8000-800f */	0x7c, 0x7c, 0x20, 0x7c, 0x64, 0x7c, 0x7c, 0x60, 0x20, 0x38, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x60,
	/* 8010-801f */	0x7c, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x64, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60,
	/* 8020-802f */	0x20, 0x64, 0x20, 0x20, 0x60, 0x20, 0x60, 0x20, 0x64, 0x60, 0x60, 0x20, 0x60, 0x38, 0x20, 0x20,
	/* 8030-803f */	0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x24, 0x20, 0x7c, 0x60, 0x7c,
	/* 8040-804f */	0x20, 0x20, 0x20, 0x78, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x60,
	/* 8050-805f */	0x60, 0x60, 0x64, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x24,
	/* 8060-806f */	0x20, 0x24, 0x24, 0x20, 0x60, 0x20, 0x20, 0x60, 0x24, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x7c,
	/* 8070-807f */	0x7c, 0x60, 0x7c, 0x7c, 0x24, 0x60, 0x64, 0x7c, 0x60, 0x64, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x7c,
	/* 8080-808f */	0x20, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x60,
	/* 8090-809f */	0x60, 0x20, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x20, 0x64, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x20, 0x20,
	/* 80a0-80af */	0x20, 0x7c, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x24, 0x64, 0x60, 0x7c,
	/* 80b0-80bf */	0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 80c0-80cf */	0x20, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x60,
	/* 80d0-80df */	0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x64, 0x7c, 0x7c, 0x60, 0x64, 0x7c, 0x20,
	/* 80e0-80ef */	0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x64,
	/* 80f0-80ff */	0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x20,
	/* 8100-810f */	0x60, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x7c, 0x3c, 0x7c, 0x24, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8110-811f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x78, 0x60, 0x3c, 0x7c, 0x20, 0x60, 0x60, 0x60,
	/* 8120-812f */	0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x78, 0x60, 0x60, 0x20, 0x7c,
	/* 8130-813f */	0x60, 0x24, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x20,
	/* 8140-814f */	0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x64, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60,
	/* 8150-815f */	0x7c, 0x7c, 0x60, 0x64, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x24,
	/* 8160-816f */	0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x64, 0x60,
	/* 8170-817f */	0x7c, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c,
	/* 8180-818f */	0x7c, 0x20, 0x64, 0x64, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c,
	/* 8190-819f */	0x20, 0x20, 0x20, 0x24, 0x20, 0x64, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60,
	/* 81a0-81af */	0x7c, 0x20, 0x60, 0x7c, 0x24, 0x20, 0x60, 0x60, 0x7c, 0x64, 0x20, 0x60, 0x60, 0x20, 0x60, 0x20,
	/* 81b0-81bf */	0x64, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x24, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x7c,
	/* 81c0-81cf */	0x7c, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x24, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x60,
	/* 81d0-81df */	0x60, 0x64, 0x60, 0x24, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x64, 0x60, 0x20, 0x60, 0x60, 0x7c,
	/* 81e0-81ef */	0x64, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x20,
	/* 81f0-81ff */	0x20, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x60,
	/* 8200-820f */	0x60, 0x64, 0x64, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x24, 0x20,
	/* 8210-821f */	0x64, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x64, 0x24, 0x24, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x7c,
	/* 8220-822f */	0x60, 0x78, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x24, 0x7c, 0x7c, 0x7c, 0x20, 0x24, 0x60,
	/* 8230-823f */	0x20, 0x20, 0x60, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x64, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60,
	/* 8240-824f */	0x7c, 0x20, 0x60, 0x20, 0x60, 0x78, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60,
	/* 8250-825f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x64, 0x60, 0x60, 0x24, 0x60, 0x64,
	/* 8260-826f */	0x20, 0x60, 0x24, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x64, 0x60, 0x24, 0x64, 0x60, 0x60, 0x7c, 0x7c,
	/* 8270-827f */	0x20, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x3c, 0x64, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60,
	/* 8280-828f */	0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x78, 0x60,
	/* 8290-829f */	0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x78, 0x60, 0x20, 0x7c, 0x60, 0x7c,
	/* 82a0-82af */	0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x3c, 0x60, 0x60, 0x78, 0x20, 0x64, 0x7c, 0x7c, 0x78, 0x7c,
	/* 82b0-82bf */	0x60, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x78, 0x7c, 0x7c, 0x60, 0x7c, 0x78, 0x7c, 0x60, 0x38,
	/* 82c0-82cf */	0x60, 0x20, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 82d0-82df */	0x20, 0x7c, 0x7c, 0x64, 0x7c, 0x78, 0x60, 0x7c, 0x20, 0x64, 0x20, 0x7c, 0x64, 0x20, 0x7c, 0x7c,
	/* 82e0-82ef */	0x60, 0x7c, 0x20, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x64, 0x60, 0x60, 0x20, 0x60,
	/* 82f0-82ff */	0x60, 0x7c, 0x60, 0x64, 0x64, 0x60, 0x60, 0x20, 0x20, 0x64, 0x64, 0x64, 0x20, 0x38, 0x78, 0x20,
	/* 8300-830f */	0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x24, 0x20,
	/* 8310-831f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x7c, 0x24, 0x60, 0x20, 0x60, 0x64, 0x20, 0x60, 0x20,
	/* 8320-832f */	0x60, 0x20, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c,
	/* 8330-833f */	0x20, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 8340-834f */	0x7c, 0x60, 0x60, 0x60, 0x60, 0x64, 0x20, 0x78, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 8350-835f */	0x64, 0x78, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8360-836f */	0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8370-837f */	0x20, 0x20, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x64,
	/* 8380-838f */	0x20, 0x60, 0x20, 0x60, 0x20, 0x24, 0x60, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60,
	/* 8390-839f */	0x60, 0x20, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x78, 0x60, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x24,
	/* 83a0-83af */	0x64, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x78, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x60,
	/* 83b0-83bf */	0x60, 0x24, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x60,
	/* 83c0-83cf */	0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x78, 0x7c, 0x60, 0x7c, 0x20, 0x64, 0x60,
	/* 83d0-83df */	0x20, 0x60, 0x20, 0x3c, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x64,
	/* 83e0-83ef */	0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x7c,
	/* 83f0-83ff */	0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x64, 0x24, 0x60, 0x78, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x60,
	/* 8400-840f */	0x20, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x64, 0x20, 0x60, 0x78, 0x64, 0x7c, 0x7c, 0x7c, 0x60,
	/* 8410-841f */	0x60, 0x60, 0x60, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20,
	/* 8420-842f */	0x24, 0x20, 0x24, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x24, 0x60, 0x7c, 0x60, 0x20, 0x60,
	/* 8430-843f */	0x60, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x60,
	/* 8440-844f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x24, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x64, 0x20,
	/* 8450-845f */	0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60,
	/* 8460-846f */	0x60, 0x7c, 0x24, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x7c, 0x7c, 0x64, 0x64, 0x7c,
	/* 8470-847f */	0x60, 0x24, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x64, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x20,
	/* 8480-848f */	0x20, 0x20, 0x64, 0x20, 0x24, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x60,
	/* 8490-849f */	0x7c, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x64,
	/* 84a0-84af */	0x60, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x24, 0x60, 0x60,
	/* 84b0-84bf */	0x60, 0x60, 0x7c, 0x20, 0x64, 0x20, 0x60, 0x20, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x7c,
	/* 84c0-84cf */	0x78, 0x64, 0x78, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x60,
	/* 84d0-84df */	0x64, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x64, 0x60, 0x20, 0x24, 0x3c, 0x60, 0x24, 0x20, 0x20, 0x20,
	/* 84e0-84ef */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60,
	/* 84f0-84ff */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x64,
	/* 8500-850f */	0x64, 0x20, 0x60, 0x20, 0x20, 0x20, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 8510-851f */	0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x78, 0x64,
	/* 8520-852f */	0x60, 0x7c, 0x20, 0x78, 0x60, 0x78, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x78,
	/* 8530-853f */	0x60, 0x60, 0x20, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x38,
	/* 8540-854f */	0x64, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x64, 0x24, 0x20, 0x60, 0x7c, 0x20,
	/* 8550-855f */	0x20, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x64, 0x64, 0x7c, 0x24, 0x60, 0x20, 0x60, 0x60, 0x20,
	/* 8560-856f */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x20,
	/* 8570-857f */	0x20, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x64, 0x20,
	/* 8580-858f */	0x64, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x78,
	/* 8590-859f */	0x64, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x24, 0x60, 0x64, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x60,
	/* 85a0-85af */	0x60, 0x60, 0x60, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x24, 0x24, 0x20, 0x24, 0x7c,
	/* 85b0-85bf */	0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60,
	/* 85c0-85cf */	0x60, 0x3c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x78, 0x7c,
	/* 85d0-85df */	0x64, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x60,
	/* 85e0-85ef */	0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60,
	/* 85f0-85ff */	0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x64, 0x7c, 0x7c, 0x20, 0x60, 0x64, 0x78,
	/* 8600-860f */	0x60, 0x60, 0x3c, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x20, 0x20, 0x20,
	/* 8610-861f */	0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x3c, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 8620-862f */	0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x24,
	/* 8630-863f */	0x24, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c,
	/* 8640-864f */	0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x20,
	/* 8650-865f */	0x7c, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x24, 0x78, 0x7c, 0x20, 0x7c, 0x7c,
	/* 8660-866f */	0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60,
	/* 8670-867f */	0x60, 0x64, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x20, 0x20, 0x20,
	/* 8680-868f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x64, 0x7c, 0x60, 0x60, 0x20,
	/* 8690-869f */	0x60, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20,
	/* 86a0-86af */	0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x64, 0x24, 0x20, 0x20, 0x20, 0x64,
	/* 86b0-86bf */	0x64, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 86c0-86cf */	0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x7c, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x24, 0x24, 0x20,
	/* 86d0-86df */	0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x7c,
	/* 86e0-86ef */	0x20, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x64, 0x60, 0x60, 0x64, 0x7c, 0x24, 0x24,
	/* 86f0-86ff */	0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x64, 0x64, 0x60, 0x64, 0x20, 0x20, 0x7c, 0x20,
	/* 8700-870f */	0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x64, 0x64, 0x60, 0x60, 0x64, 0x60, 0x20,
	/* 8710-871f */	0x20, 0x64, 0x64, 0x60, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x20,
	/* 8720-872f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20,
	/* 8730-873f */	0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x64, 0x60, 0x20, 0x60, 0x64, 0x60, 0x20, 0x60, 0x64,
	/* 8740-874f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x24, 0x20, 0x24, 0x64, 0x60, 0x7c, 0x60,
	/* 8750-875f */	0x60, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 8760-876f */	0x64, 0x60, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x60, 0x64, 0x60,
	/* 8770-877f */	0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x24,
	/* 8780-878f */	0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x60,
	/* 8790-879f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 87a0-87af */	0x20, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x64, 0x60, 0x60, 0x60, 0x64,
	/* 87b0-87bf */	0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x64, 0x60, 0x60,
	/* 87c0-87cf */	0x64, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x24, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x20, 0x20,
	/* 87d0-87df */	0x24, 0x60, 0x64, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 87e0-87ef */	0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x78, 0x60, 0x20, 0x7c,
	/* 87f0-87ff */	0x20, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x64, 0x64, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x60,
	/* 8800-880f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x24, 0x24,
	/* 8810-881f */	0x60, 0x64, 0x20, 0x60, 0x60, 0x64, 0x64, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x78,
	/* 8820-882f */	0x60, 0x64, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 8830-883f */	0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60,
	/* 8840-884f */	0x7c, 0x60, 0x24, 0x60, 0x64, 0x20, 0x3c, 0x20, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x20,
	/* 8850-885f */	0x20, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x7c, 0x24, 0x20,
	/* 8860-886f */	0x20, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x60,
	/* 8870-887f */	0x7c, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x7c,
	/* 8880-888f */	0x60, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x20,
	/* 8890-889f */	0x20, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x60,
	/* 88a0-88af */	0x20, 0x60, 0x64, 0x20, 0x64, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x24, 0x20,
	/* 88b0-88bf */	0x24, 0x64, 0x60, 0x20, 0x3c, 0x24, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x24,
	/* 88c0-88cf */	0x60, 0x7c, 0x7c, 0x24, 0x24, 0x24, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 88d0-88df */	0x60, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x7c,
	/* 88e0-88ef */	0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 88f0-88ff */	0x60, 0x60, 0x64, 0x7c, 0x7c, 0x3c, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x64, 0x7c, 0x64, 0x20,
	/* 8900-890f */	0x20, 0x60, 0x64, 0x20, 0x24, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x64, 0x20, 0x60, 0x20,
	/* 8910-891f */	0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x78, 0x78, 0x60, 0x20, 0x24, 0x24, 0x64, 0x60,
	/* 8920-892f */	0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x60,
	/* 8930-893f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x20,
	/* 8940-894f */	0x20, 0x7c, 0x60, 0x24, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x64, 0x24, 0x20, 0x60,
	/* 8950-895f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x7c,
	/* 8960-896f */	0x64, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x64, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x64,
	/* 8970-897f */	0x20, 0x60, 0x7c, 0x60, 0x64, 0x20, 0x60, 0x24, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x64, 0x7c,
	/* 8980-898f */	0x20, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x3c, 0x64, 0x20, 0x24, 0x7c, 0x20, 0x20, 0x20, 0x7c,
	/* 8990-899f */	0x20, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x64, 0x64, 0x20, 0x24, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 89a0-89af */	0x20, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x64, 0x24, 0x20, 0x3c, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x64,
	/* 89b0-89bf */	0x20, 0x20, 0x7c, 0x24, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x64,
	/* 89c0-89cf */	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 89d0-89df */	0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x64, 0x60, 0x64, 0x64, 0x20, 0x60,
	/* 89e0-89ef */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x24, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20,
	/* 89f0-89ff */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 8a00-8a0f */	0x7c, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x60,
	/* 8a10-8a1f */	0x64, 0x60, 0x64, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x60, 0x7c,
	/* 8a20-8a2f */	0x20, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x20,
	/* 8a30-8a3f */	0x60, 0x7c, 0x20, 0x24, 0x7c, 0x20, 0x7c, 0x24, 0x20, 0x60, 0x7c, 0x7c, 0x64, 0x20, 0x60, 0x60,
	/* 8a40-8a4f */	0x60, 0x64, 0x20, 0x20, 0x60, 0x60, 0x64, 0x20, 0x64, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60,
	/* 8a50-8a5f */	0x7c, 0x64, 0x64, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x20,
	/* 8a60-8a6f */	0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x64, 0x64, 0x7c, 0x7c, 0x20,
	/* 8a70-8a7f */	0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x78, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x20, 0x60,
	/* 8a80-8a8f */	0x20, 0x60, 0x64, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x20, 0x24, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x60,
	/* 8a90-8a9f */	0x20, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x20, 0x20, 0x20, 0x7c, 0x20,
	/* 8aa0-8aaf */	0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x7c, 0x20, 0x78, 0x60, 0x24, 0x24, 0x20, 0x20,
	/* 8ab0-8abf */	0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c,
	/* 8ac0-8acf */	0x60, 0x20, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x24, 0x7c, 0x20, 0x7c,
	/* 8ad0-8adf */	0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x24, 0x7c, 0x7c, 0x60, 0x64, 0x64,
	/* 8ae0-8aef */	0x64, 0x7c, 0x64, 0x20, 0x64, 0x20, 0x7c, 0x7c, 0x60, 0x20, 0x38, 0x7c, 0x20, 0x7c, 0x7c, 0x60,
	/* 8af0-8aff */	0x60, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x60,
	/* 8b00-8b0f */	0x7c, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x60, 0x24, 0x60, 0x7c, 0x60,
	/* 8b10-8b1f */	0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x20,
	/* 8b20-8b2f */	0x7c, 0x24, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x60,
	/* 8b30-8b3f */	0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x64, 0x20,
	/* 8b40-8b4f */	0x60, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x24, 0x20, 0x7c, 0x7c,
	/* 8b50-8b5f */	0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x7c, 0x24, 0x7c, 0x60, 0x20, 0x64,
	/* 8b60-8b6f */	0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x7c,
	/* 8b70-8b7f */	0x7c, 0x24, 0x24, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x64,
	/* 8b80-8b8f */	0x7c, 0x20, 0x60, 0x24, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x20, 0x64, 0x20,
	/* 8b90-8b9f */	0x3c, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x60,
	/* 8ba0-8baf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8bb0-8bbf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8bc0-8bcf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8bd0-8bdf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8be0-8bef */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8bf0-8bff */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8c00-8c0f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8c10-8c1f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8c20-8c2f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8c30-8c3f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x24, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 8c40-8c4f */	0x20, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x64, 0x60,
	/* 8c50-8c5f */	0x64, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x60,
	/* 8c60-8c6f */	0x20, 0x7c, 0x64, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x20, 0x60,
	/* 8c70-8c7f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x7c, 0x60, 0x24, 0x60, 0x20, 0x20,
	/* 8c80-8c8f */	0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x20, 0x20, 0x64, 0x7c, 0x20, 0x7c, 0x64, 0x24, 0x60,
	/* 8c90-8c9f */	0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x64, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x7c, 0x20,
	/* 8ca0-8caf */	0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x24, 0x24, 0x7c,
	/* 8cb0-8cbf */	0x7c, 0x20, 0x64, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c,
	/* 8cc0-8ccf */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x24, 0x24, 0x60,
	/* 8cd0-8cdf */	0x20, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x24, 0x7c, 0x60, 0x7c, 0x60,
	/* 8ce0-8cef */	0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x20,
	/* 8cf0-8cff */	0x64, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x7c, 0x7c, 0x60, 0x20,
	/* 8d00-8d0f */	0x60, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x24, 0x20, 0x7c, 0x20, 0x64,
	/* 8d10-8d1f */	0x64, 0x20, 0x24, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20,
	/* 8d20-8d2f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8d30-8d3f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8d40-8d4f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8d50-8d5f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8d60-8d6f */	0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x7c, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x60,
	/* 8d70-8d7f */	0x7c, 0x24, 0x60, 0x7c, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20,
	/* 8d80-8d8f */	0x60, 0x64, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60,
	/* 8d90-8d9f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 8da0-8daf */	0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 8db0-8dbf */	0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x60,
	/* 8dc0-8dcf */	0x20, 0x60, 0x64, 0x20, 0x20, 0x60, 0x78, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c,
	/* 8dd0-8ddf */	0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x64, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x20, 0x64,
	/* 8de0-8def */	0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x64, 0x60, 0x20, 0x60, 0x7c,
	/* 8df0-8dff */	0x60, 0x60, 0x60, 0x7c, 0x60, 0x24, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x64, 0x60, 0x60, 0x64,
	/* 8e00-8e0f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x24, 0x64, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x7c,
	/* 8e10-8e1f */	0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x64,
	/* 8e20-8e2f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x3c, 0x60, 0x20, 0x20, 0x60, 0x20,
	/* 8e30-8e3f */	0x7c, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60,
	/* 8e40-8e4f */	0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x20,
	/* 8e50-8e5f */	0x64, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 8e60-8e6f */	0x7c, 0x60, 0x60, 0x64, 0x64, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60,
	/* 8e70-8e7f */	0x20, 0x20, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x60, 0x64, 0x20, 0x20, 0x20,
	/* 8e80-8e8f */	0x20, 0x7c, 0x60, 0x20, 0x64, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x20,
	/* 8e90-8e9f */	0x60, 0x64, 0x60, 0x64, 0x64, 0x60, 0x60, 0x60, 0x60, 0x24, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60,
	/* 8ea0-8eaf */	0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x24,
	/* 8eb0-8ebf */	0x24, 0x24, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x24, 0x20,
	/* 8ec0-8ecf */	0x78, 0x20, 0x60, 0x20, 0x20, 0x24, 0x24, 0x20, 0x24, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x64,
	/* 8ed0-8edf */	0x20, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x64, 0x60, 0x60, 0x60, 0x7c,
	/* 8ee0-8eef */	0x60, 0x60, 0x24, 0x24, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x60, 0x60,
	/* 8ef0-8eff */	0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x24, 0x7c, 0x60,
	/* 8f00-8f0f */	0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x60, 0x24, 0x60, 0x60, 0x20,
	/* 8f10-8f1f */	0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x60, 0x24, 0x60, 0x7c, 0x7c, 0x7c, 0x78, 0x7c,
	/* 8f20-8f2f */	0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x38, 0x20, 0x7c, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x7c,
	/* 8f30-8f3f */	0x20, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x7c, 0x7c,
	/* 8f40-8f4f */	0x60, 0x20, 0x64, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x24, 0x7c, 0x7c, 0x60,
	/* 8f50-8f5f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x24, 0x78, 0x60, 0x7c,
	/* 8f60-8f6f */	0x60, 0x64, 0x7c, 0x64, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8f70-8f7f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8f80-8f8f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8f90-8f9f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x7c, 0x20, 0x24, 0x64,
	/* 8fa0-8faf */	0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x78, 0x24, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x7c,
	/* 8fb0-8fbf */	0x7c, 0x7c, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x24, 0x20, 0x20, 0x24, 0x24, 0x24, 0x20, 0x20, 0x64,
	/* 8fc0-8fcf */	0x20, 0x20, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x20,
	/* 8fd0-8fdf */	0x20, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 8fe0-8fef */	0x60, 0x60, 0x64, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x60, 0x24, 0x7c, 0x7c, 0x20, 0x7c, 0x60, 0x24,
	/* 8ff0-8fff */	0x7c, 0x20, 0x38, 0x20, 0x64, 0x60, 0x60, 0x7c, 0x64, 0x3c, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60,
	/* 9000-900f */	0x7c, 0x7c, 0x78, 0x7c, 0x60, 0x7c, 0x7c, 0x20, 0x38, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x24, 0x7c,
	/* 9010-901f */	0x7c, 0x7c, 0x20, 0x24, 0x7c, 0x7c, 0x64, 0x7c, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x7c,
	/* 9020-902f */	0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x60,
	/* 9030-903f */	0x20, 0x7c, 0x7c, 0x20, 0x60, 0x7c, 0x64, 0x20, 0x7c, 0x24, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x60,
	/* 9040-904f */	0x20, 0x7c, 0x7c, 0x20, 0x60, 0x24, 0x20, 0x7c, 0x20, 0x64, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x64,
	/* 9050-905f */	0x7c, 0x7c, 0x64, 0x7c, 0x7c, 0x7c, 0x24, 0x20, 0x64, 0x7c, 0x20, 0x60, 0x7c, 0x78, 0x7c, 0x20,
	/* 9060-906f */	0x7c, 0x3c, 0x60, 0x7c, 0x20, 0x24, 0x20, 0x64, 0x64, 0x7c, 0x20, 0x60, 0x20, 0x7c, 0x7c, 0x7c,
	/* 9070-907f */	0x60, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x64, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c,
	/* 9080-908f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x78, 0x24, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x7c,
	/* 9090-909f */	0x60, 0x7c, 0x20, 0x20, 0x60, 0x78, 0x20, 0x60, 0x60, 0x78, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60,
	/* 90a0-90af */	0x60, 0x60, 0x78, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x3c, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x7c,
	/* 90b0-90bf */	0x78, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60,
	/* 90c0-90cf */	0x20, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x20, 0x20, 0x64, 0x20,
	/* 90d0-90df */	0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x3c, 0x60,
	/* 90e0-90ef */	0x60, 0x7c, 0x64, 0x60, 0x64, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60,
	/* 90f0-90ff */	0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x24, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60,
	/* 9100-910f */	0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 9110-911f */	0x60, 0x60, 0x7c, 0x20, 0x60, 0x3c, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 9120-912f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60,
	/* 9130-913f */	0x64, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60,
	/* 9140-914f */	0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60,
	/* 9150-915f */	0x60, 0x20, 0x7c, 0x60, 0x24, 0x60, 0x64, 0x60, 0x64, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60,
	/* 9160-916f */	0x60, 0x60, 0x7c, 0x64, 0x60, 0x64, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60,
	/* 9170-917f */	0x20, 0x20, 0x64, 0x64, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9180-918f */	0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60,
	/* 9190-919f */	0x64, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60,
	/* 91a0-91af */	0x60, 0x60, 0x64, 0x60, 0x24, 0x60, 0x20, 0x60, 0x60, 0x20, 0x64, 0x7c, 0x78, 0x60, 0x78, 0x7c,
	/* 91b0-91bf */	0x60, 0x78, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x24, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x20,
	/* 91c0-91cf */	0x7c, 0x64, 0x60, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x24, 0x7c, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* 91d0-91df */	0x7c, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x24, 0x7c, 0x7c, 0x60, 0x64, 0x24, 0x7c, 0x7c, 0x24, 0x24,
	/* 91e0-91ef */	0x20, 0x24, 0x60, 0x7c, 0x64, 0x24, 0x64, 0x7c, 0x60, 0x60, 0x78, 0x60, 0x60, 0x64, 0x64, 0x20,
	/* 91f0-91ff */	0x20, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x24, 0x60, 0x60, 0x60, 0x20, 0x20, 0x24, 0x60, 0x20, 0x64,
	/* 9200-920f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x24, 0x60,
	/* 9210-921f */	0x7c, 0x7c, 0x78, 0x20, 0x64, 0x64, 0x60, 0x78, 0x20, 0x60, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x20,
	/* 9220-922f */	0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x24, 0x20, 0x20, 0x24, 0x60, 0x60, 0x20,
	/* 9230-923f */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x64, 0x7c, 0x20, 0x24, 0x60, 0x60, 0x7c,
	/* 9240-924f */	0x7c, 0x20, 0x20, 0x20, 0x24, 0x7c, 0x60, 0x20, 0x64, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x64, 0x60,
	/* 9250-925f */	0x64, 0x64, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x24, 0x64, 0x7c, 0x20, 0x20, 0x7c, 0x20,
	/* 9260-926f */	0x60, 0x60, 0x3c, 0x60, 0x7c, 0x78, 0x7c, 0x64, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60,
	/* 9270-927f */	0x60, 0x24, 0x60, 0x20, 0x20, 0x20, 0x60, 0x24, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60,
	/* 9280-928f */	0x7c, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 9290-929f */	0x20, 0x7c, 0x20, 0x7c, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x64, 0x64, 0x7c, 0x60, 0x20, 0x20,
	/* 92a0-92af */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x24, 0x20, 0x20,
	/* 92b0-92bf */	0x20, 0x20, 0x60, 0x78, 0x60, 0x60, 0x78, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20,
	/* 92c0-92cf */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78, 0x60, 0x60, 0x7c,
	/* 92d0-92df */	0x64, 0x60, 0x7c, 0x64, 0x20, 0x64, 0x20, 0x64, 0x60, 0x64, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60,
	/* 92e0-92ef */	0x64, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x64, 0x60, 0x64, 0x7c, 0x20, 0x20, 0x24, 0x60, 0x60,
	/* 92f0-92ff */	0x60, 0x60, 0x24, 0x24, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x64, 0x64, 0x64, 0x7c, 0x20, 0x60, 0x64,
	/* 9300-930f */	0x60, 0x60, 0x64, 0x20, 0x78, 0x20, 0x64, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64,
	/* 9310-931f */	0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x64, 0x7c, 0x60, 0x20, 0x64, 0x7c, 0x78,
	/* 9320-932f */	0x7c, 0x7c, 0x7c, 0x64, 0x78, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x24, 0x60, 0x7c, 0x7c,
	/* 9330-933f */	0x20, 0x20, 0x24, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x60, 0x24, 0x24, 0x60, 0x20, 0x20, 0x20,
	/* 9340-934f */	0x20, 0x20, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x3c, 0x60, 0x78, 0x7c, 0x60, 0x7c, 0x60, 0x60,
	/* 9350-935f */	0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x64, 0x64, 0x60, 0x60, 0x60, 0x7c, 0x64, 0x20, 0x60, 0x20,
	/* 9360-936f */	0x64, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x20, 0x64, 0x60, 0x3c, 0x20,
	/* 9370-937f */	0x64, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x20,
	/* 9380-938f */	0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60,
	/* 9390-939f */	0x20, 0x60, 0x60, 0x20, 0x7c, 0x60, 0x7c, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 93a0-93af */	0x20, 0x60, 0x60, 0x78, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x3c, 0x64, 0x60,
	/* 93b0-93bf */	0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 93c0-93cf */	0x60, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x24, 0x60, 0x64, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60,
	/* 93d0-93df */	0x64, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x64, 0x64, 0x64, 0x60, 0x60, 0x20, 0x60, 0x64, 0x7c, 0x60,
	/* 93e0-93ef */	0x20, 0x7c, 0x60, 0x60, 0x7c, 0x24, 0x60, 0x60, 0x64, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x20,
	/* 93f0-93ff */	0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x78, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 9400-940f */	0x60, 0x20, 0x20, 0x64, 0x38, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 9410-941f */	0x64, 0x60, 0x60, 0x64, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x64, 0x24, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9420-942f */	0x60, 0x24, 0x20, 0x20, 0x20, 0x38, 0x20, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x20,
	/* 9430-943f */	0x60, 0x64, 0x60, 0x60, 0x20, 0x7c, 0x64, 0x60, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20, 0x60,
	/* 9440-944f */	0x60, 0x24, 0x20, 0x20, 0x7c, 0x64, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 9450-945f */	0x60, 0x7c, 0x7c, 0x24, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x24, 0x3c, 0x20, 0x60, 0x64, 0x20,
	/* 9460-946f */	0x64, 0x20, 0x64, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x60, 0x60,
	/* 9470-947f */	0x64, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x60, 0x20, 0x20, 0x20, 0x64, 0x7c, 0x64, 0x7c,
	/* 9480-948f */	0x60, 0x64, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9490-949f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 94a0-94af */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 94b0-94bf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 94c0-94cf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 94d0-94df */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 94e0-94ef */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 94f0-94ff */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9500-950f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9510-951f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9520-952f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9530-953f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9540-954f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9550-955f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9560-956f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9570-957f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20,
	/* 9580-958f */	0x7c, 0x20, 0x64, 0x7c, 0x20, 0x20, 0x60, 0x24, 0x60, 0x7c, 0x24, 0x7c, 0x60, 0x60, 0x60, 0x7c,
	/* 9590-959f */	0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x24, 0x20, 0x7c, 0x24, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 95a0-95af */	0x24, 0x60, 0x24, 0x7c, 0x7c, 0x7c, 0x20, 0x24, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x20,
	/* 95b0-95bf */	0x60, 0x78, 0x24, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x64, 0x60,
	/* 95c0-95cf */	0x60, 0x20, 0x20, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x64, 0x20, 0x20,
	/* 95d0-95df */	0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x20, 0x24, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60,
	/* 95e0-95ef */	0x60, 0x7c, 0x7c, 0x60, 0x60, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 95f0-95ff */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9600-960f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9610-961f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x20,
	/* 9620-962f */	0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x64, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x64,
	/* 9630-963f */	0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c,
	/* 9640-964f */	0x7c, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x64,
	/* 9650-965f */	0x7c, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* 9660-966f */	0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x24, 0x24, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x64, 0x60, 0x20, 0x60,
	/* 9670-967f */	0x7c, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x24, 0x20, 0x60, 0x7c, 0x60, 0x20,
	/* 9680-968f */	0x60, 0x20, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x64, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x24,
	/* 9690-969f */	0x20, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x64, 0x7c, 0x7c, 0x20, 0x7c, 0x7c, 0x24, 0x60, 0x20,
	/* 96a0-96af */	0x24, 0x60, 0x60, 0x3c, 0x60, 0x20, 0x20, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x60, 0x24,
	/* 96b0-96bf */	0x64, 0x7c, 0x24, 0x60, 0x64, 0x20, 0x24, 0x3c, 0x64, 0x64, 0x20, 0x7c, 0x64, 0x20, 0x20, 0x60,
	/* 96c0-96cf */	0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x7c, 0x7c, 0x20,
	/* 96d0-96df */	0x20, 0x24, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x60,
	/* 96e0-96ef */	0x20, 0x60, 0x7c, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x7c, 0x78, 0x7c, 0x24, 0x20, 0x20, 0x20, 0x78,
	/* 96f0-96ff */	0x7c, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x20, 0x60,
	/* 9700-970f */	0x7c, 0x20, 0x60, 0x20, 0x64, 0x60, 0x7c, 0x7c, 0x64, 0x60, 0x24, 0x60, 0x20, 0x64, 0x64, 0x64,
	/* 9710-971f */	0x60, 0x7c, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x60,
	/* 9720-972f */	0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 9730-973f */	0x7c, 0x20, 0x7c, 0x24, 0x20, 0x60, 0x20, 0x20, 0x64, 0x7c, 0x60, 0x24, 0x20, 0x7c, 0x64, 0x60,
	/* 9740-974f */	0x20, 0x20, 0x7c, 0x64, 0x7c, 0x20, 0x64, 0x60, 0x7c, 0x64, 0x20, 0x60, 0x20, 0x24, 0x20, 0x24,
	/* 9750-975f */	0x20, 0x3c, 0x64, 0x20, 0x20, 0x24, 0x7c, 0x20, 0x60, 0x24, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x20,
	/* 9760-976f */	0x64, 0x7c, 0x7c, 0x20, 0x24, 0x20, 0x64, 0x20, 0x64, 0x7c, 0x60, 0x24, 0x60, 0x3c, 0x60, 0x20,
	/* 9770-977f */	0x60, 0x24, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x78, 0x60, 0x24, 0x7c, 0x60, 0x64, 0x60, 0x60, 0x60,
	/* 9780-978f */	0x60, 0x64, 0x60, 0x60, 0x64, 0x64, 0x24, 0x20, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x7c,
	/* 9790-979f */	0x24, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x64, 0x60, 0x60, 0x20, 0x64, 0x60, 0x60, 0x20,
	/* 97a0-97af */	0x7c, 0x60, 0x60, 0x64, 0x60, 0x60, 0x64, 0x20, 0x7c, 0x20, 0x60, 0x7c, 0x60, 0x7c, 0x60, 0x20,
	/* 97b0-97bf */	0x20, 0x20, 0x20, 0x64, 0x24, 0x20, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x60,
	/* 97c0-97cf */	0x20, 0x60, 0x20, 0x64, 0x60, 0x60, 0x7c, 0x60, 0x24, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60,
	/* 97d0-97df */	0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60,
	/* 97e0-97ef */	0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x64, 0x24, 0x20,
	/* 97f0-97ff */	0x60, 0x60, 0x24, 0x7c, 0x20, 0x24, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x7c,
	/* 9800-980f */	0x78, 0x7c, 0x7c, 0x7c, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x20, 0x78, 0x20, 0x7c, 0x60, 0x60, 0x64,
	/* 9810-981f */	0x7c, 0x7c, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x24, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 9820-982f */	0x60, 0x64, 0x20, 0x20, 0x64, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x24, 0x7c, 0x20, 0x60,
	/* 9830-983f */	0x78, 0x20, 0x60, 0x20, 0x24, 0x60, 0x20, 0x64, 0x7c, 0x78, 0x20, 0x7c, 0x24, 0x24, 0x20, 0x20,
	/* 9840-984f */	0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x24, 0x7c, 0x7c, 0x7c, 0x64,
	/* 9850-985f */	0x60, 0x60, 0x60, 0x60, 0x3c, 0x24, 0x20, 0x64, 0x7c, 0x60, 0x38, 0x64, 0x60, 0x60, 0x7c, 0x60,
	/* 9860-986f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x7c,
	/* 9870-987f */	0x64, 0x64, 0x60, 0x64, 0x64, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9880-988f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9890-989f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 98a0-98af */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x24, 0x20, 0x60, 0x60, 0x60, 0x7c,
	/* 98b0-98bf */	0x20, 0x7c, 0x60, 0x60, 0x20, 0x20, 0x64, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 98c0-98cf */	0x60, 0x60, 0x60, 0x24, 0x7c, 0x20, 0x64, 0x38, 0x20, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20,
	/* 98d0-98df */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x3c, 0x20, 0x20, 0x7c,
	/* 98e0-98ef */	0x20, 0x38, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x64, 0x60, 0x64, 0x20, 0x7c, 0x3c, 0x7c,
	/* 98f0-98ff */	0x20, 0x20, 0x64, 0x20, 0x7c, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x20, 0x7c, 0x7c, 0x7c, 0x20,
	/* 9900-990f */	0x60, 0x20, 0x60, 0x7c, 0x20, 0x64, 0x20, 0x60, 0x60, 0x7c, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x20,
	/* 9910-991f */	0x7c, 0x60, 0x64, 0x7c, 0x64, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x20, 0x24, 0x7c, 0x60,
	/* 9920-992f */	0x3c, 0x64, 0x20, 0x20, 0x64, 0x60, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x60,
	/* 9930-993f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x60, 0x64, 0x64, 0x60,
	/* 9940-994f */	0x20, 0x60, 0x24, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x7c, 0x20, 0x7c, 0x7c, 0x38, 0x60, 0x20,
	/* 9950-995f */	0x64, 0x7c, 0x7c, 0x60, 0x78, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60,
	/* 9960-996f */	0x20, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9970-997f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9980-998f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9990-999f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x64, 0x64, 0x7c, 0x20, 0x20, 0x60, 0x78, 0x64, 0x20,
	/* 99a0-99af */	0x20, 0x60, 0x20, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x7c, 0x7c, 0x7c, 0x60,
	/* 99b0-99bf */	0x60, 0x78, 0x60, 0x7c, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x78, 0x60, 0x60, 0x24, 0x60, 0x20, 0x20,
	/* 99c0-99cf */	0x20, 0x7c, 0x60, 0x60, 0x24, 0x24, 0x24, 0x60, 0x24, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 99d0-99df */	0x7c, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x64, 0x78, 0x20, 0x64, 0x60, 0x7c, 0x20, 0x7c,
	/* 99e0-99ef */	0x20, 0x20, 0x64, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x20,
	/* 99f0-99ff */	0x60, 0x7c, 0x24, 0x20, 0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x7c,
	/* 9a00-9a0f */	0x20, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x38, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x7c,
	/* 9a10-9a1f */	0x20, 0x60, 0x24, 0x24, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 9a20-9a2f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x24, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20,
	/* 9a30-9a3f */	0x7c, 0x60, 0x60, 0x20, 0x60, 0x60, 0x78, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x64, 0x60,
	/* 9a40-9a4f */	0x7c, 0x60, 0x64, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x64, 0x60,
	/* 9a50-9a5f */	0x60, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x7c, 0x7c, 0x20, 0x20, 0x60, 0x7c,
	/* 9a60-9a6f */	0x60, 0x20, 0x7c, 0x20, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x64, 0x20, 0x20, 0x20, 0x20,
	/* 9a70-9a7f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9a80-9a8f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9a90-9a9f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9aa0-9aaf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x64, 0x20, 0x60,
	/* 9ab0-9abf */	0x64, 0x60, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60,
	/* 9ac0-9acf */	0x64, 0x60, 0x60, 0x20, 0x24, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x20, 0x60, 0x20, 0x64,
	/* 9ad0-9adf */	0x60, 0x64, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x24, 0x20, 0x20, 0x64, 0x20, 0x24, 0x64,
	/* 9ae0-9aef */	0x20, 0x60, 0x24, 0x64, 0x20, 0x38, 0x64, 0x60, 0x20, 0x20, 0x24, 0x64, 0x60, 0x64, 0x7c, 0x64,
	/* 9af0-9aff */	0x20, 0x64, 0x60, 0x60, 0x24, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20,
	/* 9b00-9b0f */	0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 9b10-9b1f */	0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x64, 0x60, 0x7c, 0x20, 0x20, 0x20, 0x60, 0x64,
	/* 9b20-9b2f */	0x60, 0x20, 0x64, 0x64, 0x60, 0x64, 0x20, 0x7c, 0x64, 0x64, 0x3c, 0x60, 0x20, 0x20, 0x64, 0x64,
	/* 9b30-9b3f */	0x20, 0x7c, 0x64, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x64, 0x7c, 0x20, 0x60, 0x60,
	/* 9b40-9b4f */	0x20, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x64, 0x7c,
	/* 9b50-9b5f */	0x20, 0x64, 0x60, 0x20, 0x7c, 0x60, 0x60, 0x20, 0x64, 0x60, 0x7c, 0x60, 0x20, 0x20, 0x20, 0x60,
	/* 9b60-9b6f */	0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x7c,
	/* 9b70-9b7f */	0x60, 0x60, 0x24, 0x20, 0x64, 0x64, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 9b80-9b8f */	0x60, 0x20, 0x60, 0x24, 0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x24,
	/* 9b90-9b9f */	0x60, 0x7c, 0x64, 0x64, 0x20, 0x60, 0x24, 0x24, 0x20, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x3c,
	/* 9ba0-9baf */	0x64, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x20, 0x64, 0x20, 0x64, 0x7c, 0x20, 0x64, 0x7c, 0x60,
	/* 9bb0-9bbf */	0x20, 0x24, 0x20, 0x20, 0x24, 0x60, 0x60, 0x20, 0x60, 0x64, 0x20, 0x24, 0x20, 0x60, 0x20, 0x60,
	/* 9bc0-9bcf */	0x64, 0x60, 0x20, 0x60, 0x60, 0x20, 0x64, 0x60, 0x60, 0x7c, 0x64, 0x20, 0x20, 0x20, 0x20, 0x24,
	/* 9bd0-9bdf */	0x20, 0x24, 0x24, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x20, 0x60, 0x20,
	/* 9be0-9bef */	0x60, 0x64, 0x64, 0x24, 0x7c, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20,
	/* 9bf0-9bff */	0x64, 0x24, 0x24, 0x20, 0x20, 0x24, 0x20, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20,
	/* 9c00-9c0f */	0x24, 0x20, 0x20, 0x20, 0x24, 0x60, 0x64, 0x60, 0x64, 0x64, 0x24, 0x60, 0x24, 0x7c, 0x60, 0x20,
	/* 9c10-9c1f */	0x3c, 0x20, 0x7c, 0x64, 0x64, 0x3c, 0x20, 0x60, 0x20, 0x20, 0x20, 0x24, 0x60, 0x60, 0x20, 0x20,
	/* 9c20-9c2f */	0x20, 0x64, 0x20, 0x60, 0x64, 0x7c, 0x20, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x64, 0x24, 0x24,
	/* 9c30-9c3f */	0x24, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x60, 0x60, 0x20, 0x64, 0x24, 0x7c, 0x60, 0x60, 0x64, 0x60,
	/* 9c40-9c4f */	0x60, 0x60, 0x20, 0x20, 0x60, 0x20, 0x64, 0x3c, 0x64, 0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20,
	/* 9c50-9c5f */	0x60, 0x20, 0x64, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x24, 0x20, 0x20, 0x20, 0x60, 0x60,
	/* 9c60-9c6f */	0x64, 0x20, 0x60, 0x60, 0x20, 0x20, 0x60, 0x64, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x20,
	/* 9c70-9c7f */	0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x24, 0x60, 0x64, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9c80-9c8f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9c90-9c9f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9ca0-9caf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9cb0-9cbf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9cc0-9ccf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9cd0-9cdf */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9ce0-9cef */	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x24, 0x24, 0x60, 0x20, 0x20,
	/* 9cf0-9cff */	0x24, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x7c, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60,
	/* 9d00-9d0f */	0x60, 0x20, 0x20, 0x64, 0x60, 0x60, 0x64, 0x64, 0x64, 0x7c, 0x20, 0x20, 0x20, 0x20, 0x24, 0x20,
	/* 9d10-9d1f */	0x60, 0x20, 0x64, 0x20, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x64,
	/* 9d20-9d2f */	0x60, 0x20, 0x60, 0x64, 0x20, 0x60, 0x7c, 0x20, 0x7c, 0x60, 0x24, 0x24, 0x24, 0x60, 0x60, 0x60,
	/* 9d30-9d3f */	0x60, 0x60, 0x20, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x64, 0x64,
	/* 9d40-9d4f */	0x60, 0x64, 0x60, 0x60, 0x24, 0x60, 0x24, 0x20, 0x24, 0x20, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60,
	/* 9d50-9d5f */	0x24, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x64, 0x7c, 0x24, 0x60,
	/* 9d60-9d6f */	0x7c, 0x7c, 0x20, 0x20, 0x24, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x20, 0x64,
	/* 9d70-9d7f */	0x64, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x24, 0x60, 0x20, 0x60, 0x20, 0x60,
	/* 9d80-9d8f */	0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x60, 0x60, 0x60, 0x20, 0x20, 0x24,
	/* 9d90-9d9f */	0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 9da0-9daf */	0x60, 0x60, 0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x60, 0x7c, 0x60, 0x24, 0x60, 0x60, 0x20, 0x7c,
	/* 9db0-9dbf */	0x20, 0x60, 0x64, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x64, 0x60, 0x64, 0x64, 0x60, 0x20, 0x60, 0x60,
	/* 9dc0-9dcf */	0x20, 0x64, 0x64, 0x60, 0x3c, 0x60, 0x24, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64,
	/* 9dd0-9ddf */	0x60, 0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x78, 0x60, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* 9de0-9def */	0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x20, 0x60, 0x60, 0x64, 0x60, 0x64,
	/* 9df0-9dff */	0x60, 0x20, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x7c, 0x60, 0x20, 0x64, 0x60, 0x60,
	/* 9e00-9e0f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60, 0x20, 0x60,
	/* 9e10-9e1f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20, 0x64, 0x7c, 0x64, 0x20, 0x60, 0x7c, 0x20,
	/* 9e20-9e2f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9e30-9e3f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9e40-9e4f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9e50-9e5f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9e60-9e6f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	/* 9e70-9e7f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20, 0x24, 0x7c, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x7c,
	/* 9e80-9e8f */	0x60, 0x24, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x64, 0x60, 0x60, 0x64, 0x64, 0x60, 0x60, 0x20,
	/* 9e90-9e9f */	0x20, 0x64, 0x7c, 0x7c, 0x60, 0x24, 0x20, 0x7c, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x20, 0x7c,
	/* 9ea0-9eaf */	0x60, 0x60, 0x20, 0x20, 0x60, 0x7c, 0x24, 0x60, 0x20, 0x64, 0x24, 0x20, 0x20, 0x64, 0x60, 0x20,
	/* 9eb0-9ebf */	0x60, 0x20, 0x20, 0x20, 0x78, 0x78, 0x60, 0x60, 0x24, 0x24, 0x24, 0x7c, 0x64, 0x20, 0x7c, 0x24,
	/* 9ec0-9ecf */	0x60, 0x20, 0x60, 0x78, 0x24, 0x20, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x64, 0x7c, 0x7c, 0x64,
	/* 9ed0-9edf */	0x64, 0x7c, 0x24, 0x60, 0x7c, 0x60, 0x60, 0x20, 0x7c, 0x24, 0x60, 0x7c, 0x7c, 0x64, 0x7c, 0x60,
	/* 9ee0-9eef */	0x64, 0x20, 0x20, 0x20, 0x60, 0x64, 0x60, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x60, 0x60, 0x64,
	/* 9ef0-9eff */	0x60, 0x20, 0x60, 0x60, 0x7c, 0x60, 0x64, 0x64, 0x20, 0x64, 0x60, 0x64, 0x64, 0x64, 0x20, 0x60,
	/* 9f00-9f0f */	0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x60, 0x7c, 0x3c, 0x60, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x60,
	/* 9f10-9f1f */	0x60, 0x20, 0x60, 0x7c, 0x20, 0x64, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x20,
	/* 9f20-9f2f */	0x7c, 0x24, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x64, 0x60, 0x60, 0x60,
	/* 9f30-9f3f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x7c, 0x20, 0x60, 0x64, 0x20,
	/* 9f40-9f4f */	0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c, 0x7c, 0x60, 0x60, 0x7c, 0x64,
	/* 9f50-9f5f */	0x20, 0x20, 0x7c, 0x20, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x60, 0x60, 0x60, 0x60, 0x7c,
	/* 9f60-9f6f */	0x64, 0x7c, 0x24, 0x64, 0x60, 0x60, 0x64, 0x7c, 0x20, 0x20, 0x7c, 0x60, 0x7c, 0x20, 0x60, 0x60,
	/* 9f70-9f7f */	0x60, 0x60, 0x64, 0x20, 0x60, 0x60, 0x64, 0x7c, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x60, 0x20,
	/* 9f80-9f8f */	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x20, 0x20,
	/* 9f90-9f9f */	0x78, 0x60, 0x60, 0x20, 0x60, 0x7c, 0x20, 0x20, 0x60, 0x20, 0x20, 0x20, 0x7c, 0x24, 0x20, 0x20,
	/* 9fa0-9faf */	0x64, 0x20, 0x60, 0x20, 0x60, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 9fb0-9fbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 9fc0-9fcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 9fd0-9fdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 9fe0-9fef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* 9ff0-9fff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a000-a00f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a010-a01f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a020-a02f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a030-a03f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a040-a04f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a050-a05f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a060-a06f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a070-a07f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a080-a08f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a090-a09f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a0a0-a0af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a0b0-a0bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a0c0-a0cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a0d0-a0df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a0e0-a0ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a0f0-a0ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a100-a10f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a110-a11f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a120-a12f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a130-a13f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a140-a14f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a150-a15f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a160-a16f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a170-a17f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a180-a18f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a190-a19f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a1a0-a1af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a1b0-a1bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a1c0-a1cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a1d0-a1df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a1e0-a1ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a1f0-a1ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a200-a20f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a210-a21f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a220-a22f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a230-a23f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a240-a24f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a250-a25f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a260-a26f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a270-a27f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a280-a28f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a290-a29f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a2a0-a2af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a2b0-a2bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a2c0-a2cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a2d0-a2df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a2e0-a2ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a2f0-a2ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a300-a30f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a310-a31f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a320-a32f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a330-a33f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a340-a34f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a350-a35f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a360-a36f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a370-a37f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a380-a38f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a390-a39f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a3a0-a3af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a3b0-a3bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a3c0-a3cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a3d0-a3df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a3e0-a3ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a3f0-a3ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a400-a40f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a410-a41f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a420-a42f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a430-a43f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a440-a44f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a450-a45f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a460-a46f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a470-a47f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a480-a48f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a490-a49f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a4a0-a4af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a4b0-a4bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a4c0-a4cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a4d0-a4df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a4e0-a4ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a4f0-a4ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a500-a50f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a510-a51f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a520-a52f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a530-a53f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a540-a54f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a550-a55f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a560-a56f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a570-a57f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a580-a58f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a590-a59f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a5a0-a5af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a5b0-a5bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a5c0-a5cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a5d0-a5df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a5e0-a5ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a5f0-a5ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a600-a60f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a610-a61f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a620-a62f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a630-a63f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a640-a64f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a650-a65f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a660-a66f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a670-a67f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a680-a68f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a690-a69f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a6a0-a6af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a6b0-a6bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a6c0-a6cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a6d0-a6df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a6e0-a6ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a6f0-a6ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a700-a70f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a710-a71f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a720-a72f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a730-a73f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a740-a74f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a750-a75f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a760-a76f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a770-a77f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a780-a78f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a790-a79f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a7a0-a7af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a7b0-a7bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a7c0-a7cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a7d0-a7df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a7e0-a7ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a7f0-a7ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a800-a80f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a810-a81f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a820-a82f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a830-a83f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a840-a84f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a850-a85f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a860-a86f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a870-a87f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a880-a88f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a890-a89f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a8a0-a8af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a8b0-a8bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a8c0-a8cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a8d0-a8df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a8e0-a8ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a8f0-a8ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a900-a90f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a910-a91f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a920-a92f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a930-a93f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a940-a94f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a950-a95f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a960-a96f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a970-a97f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a980-a98f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a990-a99f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a9a0-a9af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a9b0-a9bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a9c0-a9cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a9d0-a9df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a9e0-a9ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* a9f0-a9ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa00-aa0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa10-aa1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa20-aa2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa30-aa3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa40-aa4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa50-aa5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa60-aa6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa70-aa7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa80-aa8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aa90-aa9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aaa0-aaaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aab0-aabf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aac0-aacf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aad0-aadf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aae0-aaef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aaf0-aaff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab00-ab0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab10-ab1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab20-ab2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab30-ab3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab40-ab4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab50-ab5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab60-ab6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab70-ab7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab80-ab8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ab90-ab9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* aba0-abaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* abb0-abbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* abc0-abcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* abd0-abdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* abe0-abef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* abf0-abff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ac00-ac0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac10-ac1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac20-ac2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac30-ac3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac40-ac4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac50-ac5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac60-ac6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac70-ac7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac80-ac8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ac90-ac9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aca0-acaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* acb0-acbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* acc0-accf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* acd0-acdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ace0-acef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* acf0-acff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad00-ad0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad10-ad1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad20-ad2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad30-ad3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad40-ad4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad50-ad5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad60-ad6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad70-ad7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad80-ad8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ad90-ad9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ada0-adaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* adb0-adbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* adc0-adcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* add0-addf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ade0-adef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* adf0-adff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae00-ae0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae10-ae1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae20-ae2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae30-ae3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae40-ae4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae50-ae5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae60-ae6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae70-ae7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae80-ae8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ae90-ae9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aea0-aeaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aeb0-aebf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aec0-aecf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aed0-aedf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aee0-aeef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aef0-aeff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af00-af0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af10-af1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af20-af2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af30-af3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af40-af4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af50-af5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af60-af6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af70-af7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af80-af8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* af90-af9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* afa0-afaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* afb0-afbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* afc0-afcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* afd0-afdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* afe0-afef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* aff0-afff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b000-b00f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b010-b01f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b020-b02f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b030-b03f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b040-b04f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b050-b05f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b060-b06f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b070-b07f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b080-b08f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b090-b09f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b0a0-b0af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b0b0-b0bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b0c0-b0cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b0d0-b0df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b0e0-b0ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b0f0-b0ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b100-b10f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b110-b11f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b120-b12f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b130-b13f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b140-b14f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b150-b15f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b160-b16f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b170-b17f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b180-b18f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b190-b19f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b1a0-b1af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b1b0-b1bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b1c0-b1cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b1d0-b1df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b1e0-b1ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b1f0-b1ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b200-b20f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b210-b21f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b220-b22f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b230-b23f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b240-b24f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b250-b25f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b260-b26f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b270-b27f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b280-b28f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b290-b29f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b2a0-b2af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b2b0-b2bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b2c0-b2cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b2d0-b2df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b2e0-b2ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b2f0-b2ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b300-b30f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b310-b31f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b320-b32f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b330-b33f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b340-b34f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b350-b35f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b360-b36f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b370-b37f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b380-b38f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b390-b39f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b3a0-b3af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b3b0-b3bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b3c0-b3cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b3d0-b3df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b3e0-b3ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b3f0-b3ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b400-b40f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b410-b41f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b420-b42f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b430-b43f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b440-b44f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b450-b45f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b460-b46f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b470-b47f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b480-b48f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b490-b49f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b4a0-b4af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b4b0-b4bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b4c0-b4cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b4d0-b4df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b4e0-b4ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b4f0-b4ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b500-b50f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b510-b51f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b520-b52f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b530-b53f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b540-b54f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b550-b55f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b560-b56f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b570-b57f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b580-b58f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b590-b59f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b5a0-b5af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b5b0-b5bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b5c0-b5cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b5d0-b5df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b5e0-b5ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b5f0-b5ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b600-b60f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b610-b61f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b620-b62f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b630-b63f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b640-b64f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b650-b65f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b660-b66f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b670-b67f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b680-b68f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b690-b69f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b6a0-b6af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b6b0-b6bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b6c0-b6cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b6d0-b6df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b6e0-b6ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b6f0-b6ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b700-b70f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b710-b71f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b720-b72f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b730-b73f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b740-b74f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b750-b75f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b760-b76f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b770-b77f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b780-b78f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b790-b79f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b7a0-b7af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b7b0-b7bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b7c0-b7cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b7d0-b7df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b7e0-b7ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b7f0-b7ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b800-b80f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b810-b81f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b820-b82f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b830-b83f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b840-b84f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b850-b85f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b860-b86f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b870-b87f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b880-b88f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b890-b89f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b8a0-b8af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b8b0-b8bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b8c0-b8cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b8d0-b8df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b8e0-b8ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b8f0-b8ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b900-b90f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b910-b91f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b920-b92f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b930-b93f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b940-b94f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b950-b95f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b960-b96f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b970-b97f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b980-b98f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b990-b99f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b9a0-b9af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b9b0-b9bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b9c0-b9cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b9d0-b9df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b9e0-b9ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* b9f0-b9ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba00-ba0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba10-ba1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba20-ba2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba30-ba3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba40-ba4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba50-ba5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba60-ba6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba70-ba7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba80-ba8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ba90-ba9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* baa0-baaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bab0-babf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bac0-bacf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bad0-badf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bae0-baef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* baf0-baff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb00-bb0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb10-bb1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb20-bb2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb30-bb3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb40-bb4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb50-bb5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb60-bb6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb70-bb7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb80-bb8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bb90-bb9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bba0-bbaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bbb0-bbbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bbc0-bbcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bbd0-bbdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bbe0-bbef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bbf0-bbff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc00-bc0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc10-bc1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc20-bc2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc30-bc3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc40-bc4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc50-bc5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc60-bc6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc70-bc7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc80-bc8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bc90-bc9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bca0-bcaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bcb0-bcbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bcc0-bccf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bcd0-bcdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bce0-bcef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bcf0-bcff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd00-bd0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd10-bd1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd20-bd2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd30-bd3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd40-bd4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd50-bd5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd60-bd6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd70-bd7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd80-bd8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bd90-bd9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bda0-bdaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bdb0-bdbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bdc0-bdcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bdd0-bddf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bde0-bdef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bdf0-bdff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be00-be0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be10-be1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be20-be2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be30-be3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be40-be4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be50-be5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be60-be6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be70-be7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be80-be8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* be90-be9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bea0-beaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* beb0-bebf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bec0-becf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bed0-bedf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bee0-beef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bef0-beff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf00-bf0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf10-bf1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf20-bf2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf30-bf3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf40-bf4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf50-bf5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf60-bf6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf70-bf7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf80-bf8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bf90-bf9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bfa0-bfaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bfb0-bfbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bfc0-bfcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bfd0-bfdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bfe0-bfef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* bff0-bfff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c000-c00f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c010-c01f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c020-c02f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c030-c03f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c040-c04f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c050-c05f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c060-c06f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c070-c07f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c080-c08f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c090-c09f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c0a0-c0af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c0b0-c0bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c0c0-c0cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c0d0-c0df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c0e0-c0ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c0f0-c0ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c100-c10f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c110-c11f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c120-c12f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c130-c13f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c140-c14f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c150-c15f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c160-c16f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c170-c17f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c180-c18f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c190-c19f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c1a0-c1af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c1b0-c1bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c1c0-c1cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c1d0-c1df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c1e0-c1ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c1f0-c1ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c200-c20f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c210-c21f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c220-c22f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c230-c23f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c240-c24f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c250-c25f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c260-c26f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c270-c27f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c280-c28f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c290-c29f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c2a0-c2af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c2b0-c2bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c2c0-c2cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c2d0-c2df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c2e0-c2ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c2f0-c2ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c300-c30f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c310-c31f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c320-c32f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c330-c33f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c340-c34f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c350-c35f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c360-c36f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c370-c37f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c380-c38f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c390-c39f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c3a0-c3af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c3b0-c3bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c3c0-c3cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c3d0-c3df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c3e0-c3ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c3f0-c3ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c400-c40f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c410-c41f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c420-c42f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c430-c43f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c440-c44f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c450-c45f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c460-c46f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c470-c47f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c480-c48f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c490-c49f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c4a0-c4af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c4b0-c4bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c4c0-c4cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c4d0-c4df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c4e0-c4ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c4f0-c4ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c500-c50f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c510-c51f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c520-c52f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c530-c53f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c540-c54f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c550-c55f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c560-c56f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c570-c57f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c580-c58f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c590-c59f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c5a0-c5af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c5b0-c5bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c5c0-c5cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c5d0-c5df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c5e0-c5ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c5f0-c5ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c600-c60f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c610-c61f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c620-c62f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c630-c63f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c640-c64f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c650-c65f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c660-c66f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c670-c67f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c680-c68f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c690-c69f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c6a0-c6af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c6b0-c6bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c6c0-c6cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c6d0-c6df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c6e0-c6ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c6f0-c6ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c700-c70f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c710-c71f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c720-c72f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c730-c73f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c740-c74f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c750-c75f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c760-c76f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c770-c77f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c780-c78f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c790-c79f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c7a0-c7af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c7b0-c7bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c7c0-c7cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c7d0-c7df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c7e0-c7ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c7f0-c7ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c800-c80f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c810-c81f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c820-c82f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c830-c83f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c840-c84f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c850-c85f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c860-c86f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c870-c87f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c880-c88f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c890-c89f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c8a0-c8af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c8b0-c8bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c8c0-c8cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c8d0-c8df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c8e0-c8ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c8f0-c8ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c900-c90f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c910-c91f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c920-c92f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c930-c93f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c940-c94f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c950-c95f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c960-c96f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c970-c97f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c980-c98f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c990-c99f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c9a0-c9af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c9b0-c9bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c9c0-c9cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c9d0-c9df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c9e0-c9ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* c9f0-c9ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca00-ca0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca10-ca1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca20-ca2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca30-ca3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca40-ca4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca50-ca5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca60-ca6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca70-ca7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca80-ca8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ca90-ca9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* caa0-caaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cab0-cabf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cac0-cacf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cad0-cadf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cae0-caef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* caf0-caff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb00-cb0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb10-cb1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb20-cb2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb30-cb3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb40-cb4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb50-cb5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb60-cb6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb70-cb7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb80-cb8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cb90-cb9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cba0-cbaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cbb0-cbbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cbc0-cbcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cbd0-cbdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cbe0-cbef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cbf0-cbff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc00-cc0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc10-cc1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc20-cc2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc30-cc3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc40-cc4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc50-cc5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc60-cc6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc70-cc7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc80-cc8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cc90-cc9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cca0-ccaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ccb0-ccbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ccc0-cccf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ccd0-ccdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cce0-ccef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ccf0-ccff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd00-cd0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd10-cd1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd20-cd2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd30-cd3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd40-cd4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd50-cd5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd60-cd6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd70-cd7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd80-cd8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cd90-cd9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cda0-cdaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cdb0-cdbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cdc0-cdcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cdd0-cddf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cde0-cdef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cdf0-cdff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce00-ce0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce10-ce1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce20-ce2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce30-ce3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce40-ce4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce50-ce5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce60-ce6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce70-ce7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce80-ce8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ce90-ce9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cea0-ceaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ceb0-cebf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cec0-cecf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* ced0-cedf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cee0-ceef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cef0-ceff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf00-cf0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf10-cf1f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf20-cf2f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf30-cf3f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf40-cf4f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf50-cf5f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf60-cf6f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf70-cf7f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf80-cf8f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cf90-cf9f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cfa0-cfaf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cfb0-cfbf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cfc0-cfcf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cfd0-cfdf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cfe0-cfef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* cff0-cfff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d000-d00f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d010-d01f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d020-d02f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d030-d03f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d040-d04f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d050-d05f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d060-d06f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d070-d07f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d080-d08f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d090-d09f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d0a0-d0af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d0b0-d0bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d0c0-d0cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d0d0-d0df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d0e0-d0ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d0f0-d0ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d100-d10f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d110-d11f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d120-d12f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d130-d13f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d140-d14f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d150-d15f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d160-d16f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d170-d17f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d180-d18f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d190-d19f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d1a0-d1af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d1b0-d1bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d1c0-d1cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d1d0-d1df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d1e0-d1ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d1f0-d1ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d200-d20f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d210-d21f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d220-d22f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d230-d23f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d240-d24f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d250-d25f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d260-d26f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d270-d27f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d280-d28f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d290-d29f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d2a0-d2af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d2b0-d2bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d2c0-d2cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d2d0-d2df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d2e0-d2ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d2f0-d2ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d300-d30f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d310-d31f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d320-d32f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d330-d33f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d340-d34f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d350-d35f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d360-d36f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d370-d37f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d380-d38f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d390-d39f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d3a0-d3af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d3b0-d3bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d3c0-d3cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d3d0-d3df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d3e0-d3ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d3f0-d3ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d400-d40f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d410-d41f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d420-d42f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d430-d43f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d440-d44f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d450-d45f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d460-d46f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d470-d47f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d480-d48f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d490-d49f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d4a0-d4af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d4b0-d4bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d4c0-d4cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d4d0-d4df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d4e0-d4ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d4f0-d4ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d500-d50f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d510-d51f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d520-d52f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d530-d53f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d540-d54f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d550-d55f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d560-d56f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d570-d57f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d580-d58f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d590-d59f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d5a0-d5af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d5b0-d5bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d5c0-d5cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d5d0-d5df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d5e0-d5ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d5f0-d5ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d600-d60f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d610-d61f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d620-d62f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d630-d63f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d640-d64f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d650-d65f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d660-d66f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d670-d67f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d680-d68f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d690-d69f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d6a0-d6af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d6b0-d6bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d6c0-d6cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d6d0-d6df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d6e0-d6ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d6f0-d6ff */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d700-d70f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d710-d71f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d720-d72f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d730-d73f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d740-d74f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d750-d75f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d760-d76f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d770-d77f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d780-d78f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d790-d79f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* d7a0-d7af */	0x18, 0x18, 0x18, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d7b0-d7bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d7c0-d7cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d7d0-d7df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d7e0-d7ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d7f0-d7ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d800-d80f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d810-d81f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d820-d82f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d830-d83f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d840-d84f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d850-d85f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d860-d86f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d870-d87f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d880-d88f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d890-d89f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d8a0-d8af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d8b0-d8bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d8c0-d8cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d8d0-d8df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d8e0-d8ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d8f0-d8ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d900-d90f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d910-d91f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d920-d92f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d930-d93f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d940-d94f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d950-d95f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d960-d96f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d970-d97f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d980-d98f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d990-d99f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d9a0-d9af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d9b0-d9bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d9c0-d9cf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d9d0-d9df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d9e0-d9ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* d9f0-d9ff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da00-da0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da10-da1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da20-da2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da30-da3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da40-da4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da50-da5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da60-da6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da70-da7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da80-da8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* da90-da9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* daa0-daaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dab0-dabf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dac0-dacf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dad0-dadf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dae0-daef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* daf0-daff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db00-db0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db10-db1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db20-db2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db30-db3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db40-db4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db50-db5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db60-db6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db70-db7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db80-db8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* db90-db9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dba0-dbaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dbb0-dbbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dbc0-dbcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dbd0-dbdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dbe0-dbef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dbf0-dbff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc00-dc0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc10-dc1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc20-dc2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc30-dc3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc40-dc4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc50-dc5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc60-dc6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc70-dc7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc80-dc8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dc90-dc9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dca0-dcaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dcb0-dcbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dcc0-dccf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dcd0-dcdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dce0-dcef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dcf0-dcff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd00-dd0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd10-dd1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd20-dd2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd30-dd3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd40-dd4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd50-dd5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd60-dd6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd70-dd7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd80-dd8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dd90-dd9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dda0-ddaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ddb0-ddbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ddc0-ddcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ddd0-dddf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dde0-ddef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ddf0-ddff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de00-de0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de10-de1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de20-de2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de30-de3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de40-de4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de50-de5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de60-de6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de70-de7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de80-de8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* de90-de9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dea0-deaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* deb0-debf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dec0-decf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ded0-dedf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dee0-deef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* def0-deff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df00-df0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df10-df1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df20-df2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df30-df3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df40-df4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df50-df5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df60-df6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df70-df7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df80-df8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* df90-df9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dfa0-dfaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dfb0-dfbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dfc0-dfcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dfd0-dfdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dfe0-dfef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* dff0-dfff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* e000-e00f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e010-e01f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e020-e02f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e030-e03f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e040-e04f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e050-e05f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e060-e06f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e070-e07f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e080-e08f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e090-e09f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e0a0-e0af */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* e0b0-e0bf */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x64, 0x64, 0x64, 0x64,
	/* e0c0-e0cf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e0d0-e0df */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e0e0-e0ef */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e0f0-e0ff */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e100-e10f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e110-e11f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e120-e12f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e130-e13f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e140-e14f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e150-e15f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e160-e16f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e170-e17f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e180-e18f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e190-e19f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e1a0-e1af */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e1b0-e1bf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e1c0-e1cf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e1d0-e1df */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e1e0-e1ef */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e1f0-e1ff */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e200-e20f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e210-e21f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e220-e22f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e230-e23f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e240-e24f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e250-e25f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e260-e26f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e270-e27f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e280-e28f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e290-e29f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e2a0-e2af */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e2b0-e2bf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e2c0-e2cf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e2d0-e2df */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e2e0-e2ef */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e2f0-e2ff */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e300-e30f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e310-e31f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e320-e32f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e330-e33f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e340-e34f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e350-e35f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e360-e36f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e370-e37f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e380-e38f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e390-e39f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e3a0-e3af */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e3b0-e3bf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e3c0-e3cf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e3d0-e3df */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e3e0-e3ef */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e3f0-e3ff */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e400-e40f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e410-e41f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e420-e42f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e430-e43f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e440-e44f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e450-e45f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e460-e46f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e470-e47f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e480-e48f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e490-e49f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e4a0-e4af */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e4b0-e4bf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e4c0-e4cf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e4d0-e4df */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e4e0-e4ef */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e4f0-e4ff */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e500-e50f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e510-e51f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e520-e52f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e530-e53f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e540-e54f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e550-e55f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e560-e56f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e570-e57f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e580-e58f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e590-e59f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e5a0-e5af */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e5b0-e5bf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e5c0-e5cf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e5d0-e5df */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e5e0-e5ef */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e5f0-e5ff */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e600-e60f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e610-e61f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e620-e62f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e630-e63f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e640-e64f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e650-e65f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e660-e66f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e670-e67f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e680-e68f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e690-e69f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e6a0-e6af */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e6b0-e6bf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e6c0-e6cf */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e6d0-e6df */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e6e0-e6ef */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e6f0-e6ff */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e700-e70f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e710-e71f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e720-e72f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e730-e73f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e740-e74f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64,
	/* e750-e75f */	0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e760-e76f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e770-e77f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e780-e78f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e790-e79f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e7a0-e7af */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e7b0-e7bf */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e7c0-e7cf */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e7d0-e7df */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e7e0-e7ef */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e7f0-e7ff */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e800-e80f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e810-e81f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e820-e82f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e830-e83f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e840-e84f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e850-e85f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* e860-e86f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e870-e87f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e880-e88f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e890-e89f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e8a0-e8af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e8b0-e8bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e8c0-e8cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e8d0-e8df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e8e0-e8ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e8f0-e8ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e900-e90f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e910-e91f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e920-e92f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e930-e93f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e940-e94f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e950-e95f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e960-e96f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e970-e97f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e980-e98f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e990-e99f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e9a0-e9af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e9b0-e9bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e9c0-e9cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e9d0-e9df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e9e0-e9ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* e9f0-e9ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea00-ea0f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea10-ea1f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea20-ea2f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea30-ea3f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea40-ea4f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea50-ea5f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea60-ea6f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea70-ea7f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea80-ea8f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ea90-ea9f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eaa0-eaaf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eab0-eabf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eac0-eacf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ead0-eadf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eae0-eaef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eaf0-eaff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb00-eb0f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb10-eb1f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb20-eb2f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb30-eb3f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb40-eb4f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb50-eb5f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb60-eb6f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb70-eb7f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb80-eb8f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eb90-eb9f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eba0-ebaf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ebb0-ebbf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ebc0-ebcf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ebd0-ebdf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ebe0-ebef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ebf0-ebff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec00-ec0f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec10-ec1f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec20-ec2f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec30-ec3f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec40-ec4f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec50-ec5f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec60-ec6f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec70-ec7f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec80-ec8f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ec90-ec9f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eca0-ecaf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ecb0-ecbf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ecc0-eccf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ecd0-ecdf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ece0-ecef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ecf0-ecff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed00-ed0f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed10-ed1f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed20-ed2f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed30-ed3f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed40-ed4f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed50-ed5f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed60-ed6f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed70-ed7f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed80-ed8f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ed90-ed9f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eda0-edaf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* edb0-edbf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* edc0-edcf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* edd0-eddf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ede0-edef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* edf0-edff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee00-ee0f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee10-ee1f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee20-ee2f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee30-ee3f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee40-ee4f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee50-ee5f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee60-ee6f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee70-ee7f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee80-ee8f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ee90-ee9f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eea0-eeaf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eeb0-eebf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eec0-eecf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eed0-eedf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eee0-eeef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eef0-eeff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef00-ef0f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef10-ef1f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef20-ef2f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef30-ef3f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef40-ef4f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef50-ef5f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef60-ef6f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef70-ef7f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef80-ef8f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* ef90-ef9f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* efa0-efaf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* efb0-efbf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* efc0-efcf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* efd0-efdf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* efe0-efef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* eff0-efff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f000-f00f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f010-f01f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f020-f02f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f030-f03f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f040-f04f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f050-f05f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f060-f06f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f070-f07f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f080-f08f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f090-f09f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f0a0-f0af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f0b0-f0bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f0c0-f0cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f0d0-f0df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f0e0-f0ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f0f0-f0ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f100-f10f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f110-f11f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f120-f12f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f130-f13f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f140-f14f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f150-f15f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f160-f16f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f170-f17f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f180-f18f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f190-f19f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f1a0-f1af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f1b0-f1bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f1c0-f1cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f1d0-f1df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f1e0-f1ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f1f0-f1ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f200-f20f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f210-f21f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f220-f22f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f230-f23f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f240-f24f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f250-f25f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f260-f26f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f270-f27f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f280-f28f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f290-f29f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f2a0-f2af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f2b0-f2bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f2c0-f2cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f2d0-f2df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f2e0-f2ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f2f0-f2ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f300-f30f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f310-f31f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f320-f32f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f330-f33f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f340-f34f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f350-f35f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f360-f36f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f370-f37f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f380-f38f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f390-f39f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f3a0-f3af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f3b0-f3bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f3c0-f3cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f3d0-f3df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f3e0-f3ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f3f0-f3ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f400-f40f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f410-f41f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f420-f42f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f430-f43f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f440-f44f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f450-f45f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f460-f46f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f470-f47f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f480-f48f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f490-f49f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f4a0-f4af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f4b0-f4bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f4c0-f4cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f4d0-f4df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f4e0-f4ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f4f0-f4ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f500-f50f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f510-f51f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f520-f52f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f530-f53f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f540-f54f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f550-f55f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f560-f56f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f570-f57f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f580-f58f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f590-f59f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f5a0-f5af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f5b0-f5bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f5c0-f5cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f5d0-f5df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f5e0-f5ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f5f0-f5ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f600-f60f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f610-f61f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f620-f62f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f630-f63f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f640-f64f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f650-f65f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f660-f66f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f670-f67f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f680-f68f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f690-f69f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f6a0-f6af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f6b0-f6bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f6c0-f6cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f6d0-f6df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f6e0-f6ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f6f0-f6ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f700-f70f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f710-f71f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f720-f72f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f730-f73f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f740-f74f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f750-f75f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f760-f76f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f770-f77f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f780-f78f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f790-f79f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f7a0-f7af */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f7b0-f7bf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f7c0-f7cf */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f7d0-f7df */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f7e0-f7ef */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f7f0-f7ff */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f800-f80f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f810-f81f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f820-f82f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f830-f83f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	/* f840-f84f */	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f850-f85f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f860-f86f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f870-f87f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f880-f88f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x400, 0x400, 0x400,
	/* f890-f89f */	0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x400, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f8a0-f8af */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f8b0-f8bf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f8c0-f8cf */	0x0, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f8d0-f8df */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* f8e0-f8ef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x10, 0x10, 0x10,
	/* f8f0-f8ff */	0x14, 0x14, 0x14, 0x14, 0x10, 0x30, 0x10, 0x8, 0x40, 0x80, 0x80, 0x80, 0x1000, 0x1000, 0x0, 0x0,
	/* f900-f90f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f910-f91f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f920-f92f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x18, 0x18, 0x38, 0x18, 0x18, 0x18,
	/* f930-f93f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f940-f94f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f950-f95f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f960-f96f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f970-f97f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f980-f98f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f990-f99f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f9a0-f9af */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f9b0-f9bf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f9c0-f9cf */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f9d0-f9df */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x18, 0x18, 0x18,
	/* f9e0-f9ef */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* f9f0-f9ff */	0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	/* fa00-fa0f */	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x60, 0x60, 0x24, 0x24,
	/* fa10-fa1f */	0x4, 0x24, 0x4, 0x24, 0x24, 0x4, 0x4, 0x4, 0x24, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x24,
	/* fa20-fa2f */	0x24, 0x24, 0x4, 0x24, 0x24, 0x4, 0x4, 0x24, 0x24, 0x24, 0x4, 0x4, 0x4, 0x4, 0x0, 0x0,
	/* fa30-fa3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fa40-fa4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fa50-fa5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fa60-fa6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fa70-fa7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fa80-fa8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fa90-fa9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* faa0-faaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fab0-fabf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fac0-facf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fad0-fadf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fae0-faef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* faf0-faff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb00-fb0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb10-fb1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb20-fb2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb30-fb3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb40-fb4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb50-fb5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb60-fb6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb70-fb7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb80-fb8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fb90-fb9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fba0-fbaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fbb0-fbbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fbc0-fbcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fbd0-fbdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fbe0-fbef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fbf0-fbff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc00-fc0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc10-fc1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc20-fc2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc30-fc3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc40-fc4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc50-fc5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc60-fc6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc70-fc7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc80-fc8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fc90-fc9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fca0-fcaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fcb0-fcbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fcc0-fccf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fcd0-fcdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fce0-fcef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fcf0-fcff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd00-fd0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd10-fd1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd20-fd2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd30-fd3f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd40-fd4f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd50-fd5f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd60-fd6f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd70-fd7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd80-fd8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fd90-fd9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fda0-fdaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fdb0-fdbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fdc0-fdcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fdd0-fddf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fde0-fdef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fdf0-fdff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fe00-fe0f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fe10-fe1f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fe20-fe2f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fe30-fe3f */	0x60, 0x60, 0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* fe40-fe4f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x0, 0x0, 0x0, 0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* fe50-fe5f */	0x60, 0x60, 0x60, 0x0, 0x60, 0x60, 0x60, 0x60, 0x0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	/* fe60-fe6f */	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x0, 0x60, 0x60, 0x60, 0x60, 0x0, 0x0, 0x0, 0x0,
	/* fe70-fe7f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fe80-fe8f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fe90-fe9f */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fea0-feaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* feb0-febf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fec0-fecf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fed0-fedf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fee0-feef */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fef0-feff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ff00-ff0f */	0x0, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* ff10-ff1f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* ff20-ff2f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* ff30-ff3f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x3c, 0x7c, 0x3c, 0x3c, 0x7c,
	/* ff40-ff4f */	0x3c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
	/* ff50-ff5f */	0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x0,
	/* ff60-ff6f */	0x0, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,
	/* ff70-ff7f */	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,
	/* ff80-ff8f */	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,
	/* ff90-ff9f */	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4,
	/* ffa0-ffaf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ffb0-ffbf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ffc0-ffcf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ffd0-ffdf */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* ffe0-ffef */	0x7c, 0x7c, 0x3c, 0x7c, 0x24, 0x7c, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	/* fff0-ffff */	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0xffff,	// _xZkqqHx_jEhKjHpBiCkKjAlDiClFiCkCiCkJiKgNjEeGiCmMiClNiCnPiCmJiCfAiCmCjCmHiJmBiBeC_xHqqkZx_
}; // static WORD s_wUnicodeToCharsetTable[0x10001].

static int s_iCharsetList[] =
{
	0,		// _xZkqqHx_iJhAiMoKiBeC_xHqqkZx_
	2,		// _xZkqqHx_iDfGiDjDiDhLiDiLiCmNiBeB_xHqqkZx_UNICODE<->MBCS_xZkqqHx_jFmPiKlHiCmFjHeMiMpIiCmJiLeAjEfMiClFiCmIiCkCiDgOiDfJiBeCjBoFiPoEjFhGiCkJiBeIiBgJjBePiCmNiCePiBeGiJhAiMoKiCpAjBoDjHhAiClFiCmEiClNiBgKiBeC_xHqqkZx_
	128,	// _xZkqqHx_jDpKjGhLiMoKiBeC_xHqqkZx_
	129,	// _xZkqqHx_iDgOiDjDiDePiDiLiBeC_xHqqkZx_
	130,	// _xZkqqHx_iKnIiNjBiMoK_xHqqkZx_(Johab)_xZkqqHx_iBeC_xHqqkZx_
	134,	// _xZkqqHx_iKmIjBmMiOjKjCiGiNjBiMoKiBeC_xHqqkZx_
	136,	// _xZkqqHx_jEmJjBmMiOjKjCiGiNjBiMoKiBeC_xHqqkZx_
	161,	// _xZkqqHx_iDeNiDiKiDfGiDeBiMoKiBeC_xHqqkZx_
	162,	// _xZkqqHx_iDgHiDiLiDfCiMoKiBeC_xHqqkZx_
	163,	// _xZkqqHx_iDhIiDgHiDgJiDiAiMoKiBeC_xHqqkZx_
	177,	// _xZkqqHx_iDhHiDhFiDiJiDeDiMoKiBeC_xHqqkZx_
	178,	// _xZkqqHx_iDeBiDiJiDhCiDeBiMoKiBeC_xHqqkZx_
	186,	// _xZkqqHx_iDgPiDiLiDgHiMoKiBeC_xHqqkZx_
	204,	// _xZkqqHx_iDeMiDiKiDiLiMoKiBeC_xHqqkZx_
	222,	// _xZkqqHx_iDfOiDeDiMoKiBeC_xHqqkZx_
	238,	// _xZkqqHx_jCiGiJjLiDiIiBfLiDiNiDgCiDhAiMlOiMoKiBeC_xHqqkZx_
}; // static int s_iCharsetList[].

static int s_iCharsetListSize = sizeof(s_iCharsetList) / sizeof(s_iCharsetList[0]);

static map<WORD, WORD>	s_mpCharsetToIndex;	// Charset -> Charset Index _xZkqqHx_iCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_

class FCLocal
{
public:
	FCLocal ()
		{
			ASSERT(s_wUnicodeToCharsetTable[0x10000] == 0xffff);
			ASSERT(sizeof(s_iCharsetList) / sizeof(s_iCharsetList[0]) == s_iCharsetListSize);
			// Charset_xZkqqHx_iCmM_xHqqkZx_Bit_xZkqqHx_iDhEiDeCiBfLiDiLiDgIiCpAiDiLiBfLiDhGiCmFiDfGiDhEiDgHiBeC_xHqqkZx_
			for (int iBit = 0; iBit != s_iCharsetListSize; iBit++)
				s_mpCharsetToIndex[s_iCharsetList[iBit]] = iBit;
		}
} s_local;

//----- 02.08.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsBasicLatinChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmM_xHqqkZx_UNICODE_xZkqqHx_jFlGiOjKiCkKiBeB_xHqqkZx_BASIC LATIN_xZkqqHx_iBgJiKoOjGhLjDeJiCmIiJhAiOjKiBgKiCkJiCmHiCkEiCkJiCpA_xHqqkZx_
 *			_xZkqqHx_jClCiCnHiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:UNICODE_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	BASIC LATIN _xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFIsBasicLatinChar (wchar_t wChar)
{
	if (FFUnicodeToSubset(wChar) == 0)
	//------ wChar_xZkqqHx_iCmM_xHqqkZx_UNICODE Subset _xZkqqHx_iCkK_xHqqkZx_ Basic Latin _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
	{
		// ANSI_CHARSET_xZkqqHx_iCmM_xHqqkZx_BIT_xZkqqHx_iDhEiDiJiDePiCpAiOoGjDlOiBeC_xHqqkZx_
		const WORD wFlagMask = 0x0001 << s_mpCharsetToIndex[ANSI_CHARSET];
		return (s_wUnicodeToCharsetTable[wChar] & wFlagMask) ? TRUE : FALSE;
	} else
	//------ wChar_xZkqqHx_iCmM_xHqqkZx_UNICODE Subset _xZkqqHx_iCkK_xHqqkZx_ Basic Latin _xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		return FALSE;
	}
} // FFIsBasicLatinChar (wchar_t wChar).

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsStdFontChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfCiBfLiDgIiCkKjFfHiPiAjFlGiOjKiDfKiDgCiDgHiCmJiKnMiCnMiCoKiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFIsStdFontChar (wchar_t wChar)
{
//----- 02.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
//	static WORD s_wStdFontCharset = WORD(-1);
//	static set<int> s_stUniSubset;
//	if (s_wStdFontCharset != g_pReg->GetStdFontCharset() || s_stUniSubset.empty())
//	{
//		s_wStdFontCharset = g_pReg->GetStdFontCharset();
//		s_stUniSubset.clear();
//		WString strTable;
//		strTable.LoadString(IDS_CHARSET_TO_UNISUBSET);
//		while (!strTable.IsEmpty())
//		{
//			WORD wCharset = wcstol(::FFExtractUntil(strTable, L"\n"), NULL, 10);
//			WString strSubset = ::FFExtractUntil(strTable, L"\n");
//			if (wCharset == s_wStdFontCharset)
//			{
//				const wchar_t* tcpHead = strSubset;
//				while (*tcpHead != L'\0')
//				{
//					int iSubset = wcstol(tcpHead, (wchar_t**)&tcpHead, 10);
//					s_stUniSubset.insert(iSubset);
//					tcpHead++;
//				}
//				break;
//			}
//		}
//	}
//	int iSubset = FFUnicodeToSubset(wChar);
//	return s_stUniSubset.find(iSubset) != s_stUniSubset.end();
//----- 02.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
	ASSERT(sizeof(s_iCharsetList) / sizeof(s_iCharsetList[0]) == s_iCharsetListSize);
	switch (g_pReg->GetStdFontCharset())
	{
	case ANSI_CHARSET:
	//----- _xZkqqHx_jFfHiPiAjFlGiOjKiDfKiDgCiDgHiCkKiJhAiOjKiCmMiPoKiNiH_xHqqkZx_ -----
		// wChar _xZkqqHx_iCkK_xHqqkZx_ Basic Latin _xZkqqHx_iCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
		return FFIsBasicLatinChar(wChar);

	case SYMBOL_CHARSET:
	//----- _xZkqqHx_jFfHiPiAjFlGiOjKiDfKiDgCiDgHiCkKiDfGiDjDiDhLiDiLiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// ANSI_CHARSET_xZkqqHx_iCmM_xHqqkZx_BIT_xZkqqHx_iDhEiDiJiDePiCpAiOoGjDlOiBeC_xHqqkZx_
		const WORD wFlagMask = 0x0001 << s_mpCharsetToIndex[ANSI_CHARSET];
		return (s_wUnicodeToCharsetTable[wChar] & wFlagMask) ? TRUE : FALSE;
	}

	case EASTEUROPE_CHARSET:
	//----- _xZkqqHx_jFfHiPiAjFlGiOjKiDfKiDgCiDgHiCkKjCiGiJjLiDiIiBfLiDiNiDgCiDhAiMlOiMoKiCmMiPoKiNiH_xHqqkZx_ -----
		if (FFIsBasicLatinChar(wChar))
		//----- wChar _xZkqqHx_iCkK_xHqqkZx_ Basic Latin _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// Basic Latin _xZkqqHx_iCmNiBeBiDgGiDhEiDeIiDiLiDgHiCmFjCiGiJjLiDiIiBfLiDiNiDgCiDhAiMlOiMoKiCmJiKnMiCnMiClJiCoJiBeC_xHqqkZx_
			// _xZkqqHx_jHoBiBeGiDgIiDeDiDgDiMoKiClOiCmGiBeB_xHqqkZx_Basic Latin _xZkqqHx_iCmGiDeFiDiAiDiJiDeFiDgHjFhEiCkLiCmM_xHqqkZx_
			//     Latin Extended-A _xZkqqHx_iCmMjBgHiCnNiNiHiCoNiClJiCmFjFlGiPjBiCpAiPjBiCkNiCmNiClIiBeC_xHqqkZx_
			return TRUE;
		} else
		//----- wChar _xZkqqHx_iCkK_xHqqkZx_ Basic Latin _xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// EASTEUROPE_CHARSET_xZkqqHx_iCmM_xHqqkZx_BIT_xZkqqHx_iDhEiDiJiDePiCpAiOoGjDlOiBeC_xHqqkZx_
			const WORD wFlagMask = 0x0001 << s_mpCharsetToIndex[EASTEUROPE_CHARSET];
			return (s_wUnicodeToCharsetTable[wChar] & wFlagMask) ? TRUE : FALSE;
		}

	default:
	//----- _xZkqqHx_jFfHiPiAjFlGiOjKiDfKiDgCiDgHiCkKiClLiCmMjBlMiCmMiPoKiNiH_xHqqkZx_ -----
		if (FFIsBasicLatinChar(wChar))
		//----- wChar _xZkqqHx_iCkK_xHqqkZx_ Basic Latin _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// Basic Latin _xZkqqHx_iCmNiBeBjFfHiPiAjFlGiOjKiDfKiDgCiDgHiCmJiKnMiCnMiClJiCmIiCkCiBeC_xHqqkZx_
			// _xZkqqHx_jHoBiBeGjDpKjGhLiMoKiCmFiBeBiJhAjFlGiOjKiCmM_xHqqkZx_ "ABC"_xZkqqHx_iCmIiCmHiCmNiBeBjDpKjGhLiMoKiDhEiDeIiDjDiDgHiCmF_xHqqkZx_
			//     _xZkqqHx_jFfMiOkGiClDiClJiClIiBeBiJhAiMoKiDhEiDeIiDjDiDgHiCmFjFfMiOkGiClDiClJiCoJiBeC_xHqqkZx_
			return FALSE;
		} else
		//----- wChar _xZkqqHx_iCkK_xHqqkZx_ Basic Latin _xZkqqHx_iImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jFfHiPiAjFlGiOjKiDfKiDgCiDgHiCmM_xHqqkZx_BIT_xZkqqHx_iDhEiDiJiDePiCpAiOoGjDlOiBeC_xHqqkZx_
			const WORD wFlagMask = 0x0001 << s_mpCharsetToIndex[g_pReg->GetStdFontCharset()];
			return (s_wUnicodeToCharsetTable[wChar] & wFlagMask) ? TRUE : FALSE;
		}
	}
//----- 02.08.12 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----
} // FFIsStdFontChar.

//----------</NOT EXPORT TO VIEWER>-----------

//----- 02.08.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFUnicodeToCharSet
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	UNICODE_xZkqqHx_jFlGiOjKiCpAiBeBiClLiCoKiCpAiDfEiDhMiBfLiDgHiClHiCoJ_xHqqkZx_ Charset _xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *			Charset _xZkqqHx_iCmNjFkBjAjEjHeMiCoIjDlOiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vCharSet	:Charset _xZkqqHx_iCmMiPfHiNiHiCpAjFnEiClHiBeC_xHqqkZx_
 *			wCode		:UNICODE_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			w1StCharSet	:_xZkqqHx_jHeEjAoGiClFiCmEiNmFiPiJiCmJjChFiCkJiCoKiCoJ_xHqqkZx_CharSet_xZkqqHx_iCpAiOhHjCoIiBeCiOgHiCoNiCmIiCkC_xHqqkZx_
 *						 _xZkqqHx_iPoKiNiHiCmN_xHqqkZx_WORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	NT_xZkqqHx_iMgO_xHqqkZx_OS_xZkqqHx_iCmF_xHqqkZx_ExtTextOutW_xZkqqHx_iCpAiOgHiCkEiPoKiNiHiCmNiBeBiDhEiDeIiDjDiDgHiCmM_xHqqkZx_Charset_xZkqqHx_iCmNiKnGiMfHiCmIiCkCiCkKiBeB_xHqqkZx_
 *			95_xZkqqHx_iMgO_xHqqkZx_OS_xZkqqHx_iCmF_xHqqkZx_ExtTextOutA_xZkqqHx_iCpAiOgHiCkEiPoKiNiHiCmNiBeBiPgPjHmNjFlGiOjKiCmJjDeLiNiHiClFiClN_xHqqkZx_Charset_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDjDiDgHiCmJjAnNjCoIiClFiCmIiCkCiCmGiBeBjAlDiClFiCkCiDePiDiKiDhEiCkKjFfMiOkGiClDiCoKiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFUnicodeToCharSet (WORDVector& vCharSet, wchar_t wCode, WORD w1StCharSet)
{
	ASSERT(sizeof(s_iCharsetList) / sizeof(s_iCharsetList[0]) == s_iCharsetListSize);
	// Charset_xZkqqHx_iPfHiNiHjFmPjAjEiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	vCharSet.clear();
	int iBit;
	for (iBit = 0; iBit != s_iCharsetListSize; iBit++)
	//----- Charset_xZkqqHx_iCmM_xHqqkZx_Bit_xZkqqHx_iDhEiDeCiBfLiDiLiDgIiCpAiDiLiBfLiDhGiCmFiDfGiDhEiDgH_xHqqkZx_ -----
	{
		const WORD wFlagMask = 0x0001 << iBit;
		if (s_wUnicodeToCharsetTable[wCode] & wFlagMask)
		{
			if (w1StCharSet == s_iCharsetList[iBit])
				vCharSet.insert(vCharSet.begin(), w1StCharSet);
			else
				vCharSet.push_back(s_iCharsetList[iBit]);
		}
	}
} // FFUnicodeToCharSet.

//----- 02.08.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDlPiBeBiDmKiCmIiCmHiCmMjFlGiOjKiCpAiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDfOiCmFjDpMjHmNiClFiBeBiDhEiDeIiDjDiDgHiCpA_xHqqkZx_Times New Roman_xZkqqHx_iCmJiClHiCoJiCmGiBeBjFfMiOkGiCkKiJlLiCkPiCoJ_xHqqkZx_)-----

//----- 03.06.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ( )-----

inline bool operator < (const FCErrFontInfo& v1, const FCErrFontInfo& v2)
{
	if (v1.m_byOldCharSet < v2.m_byOldCharSet) return true;
	if (v1.m_byOldCharSet > v2.m_byOldCharSet) return false;
	int iCmp = wcscmp(v1.m_wstrOldFaceName.c_str(), v2.m_wstrOldFaceName.c_str());
	if (iCmp < 0) return true;
	if (iCmp > 0) return false;

	if (v1.m_byNewCharSet < v2.m_byNewCharSet) return true;
	if (v1.m_byNewCharSet > v2.m_byNewCharSet) return false;
	iCmp = wcscmp(v1.m_wstrNewFaceName.c_str(), v2.m_wstrNewFaceName.c_str());
	if (iCmp < 0) return true;
	return false;
} // bool operator <.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAppendErrFontInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeCiDhEiDeIiDjDiDgHiCkKjBlGiNnNiClJiClIiBeBjBoDiCoNiCoIiCmM_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDjDiDgHiCmJjChFiCkLiKlHiCkGiClNiPoKiNiHiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byOldCharSet	:_xZkqqHx_iMmDiCkCiDhEiDeIiDjDiDgHiCmM_xHqqkZx_CharSet_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpOldFaceName	:_xZkqqHx_iMmDiCkCiDhEiDeIiDjDiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			byNewCharSet	:_xZkqqHx_jAfGiClFiCkCiDhEiDeIiDjDiDgHiCmM_xHqqkZx_CharSet_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			wcpNewFaceName	:_xZkqqHx_jAfGiClFiCkCiDhEiDeIiDjDiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFAppendErrFontInfo (BYTE byOldCharSet, const wchar_t* wcpOldFaceName,
							BYTE byNewCharSet, const wchar_t* wcpNewFaceName)
{
	FCErrFontInfo errFontInfo(byOldCharSet, wcpOldFaceName,
								byNewCharSet, wcpNewFaceName);
	if (s_stErrFontInfo.find(errFontInfo) == s_stErrFontInfo.end())
	{
		s_stErrFontInfo.insert(errFontInfo);
//----- 03.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		if (AfxGetMainWnd() != NULL)
//			AfxGetMainWnd()->PostMessage(WM_USER_FONT_NOT_FOUND);
//----- 03.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDhEiDeIiDjDiDgHjChFiKlHiMhIiNjAjFfMiOkGiCmMiDiBiDgCiDfKiBfLiDfHiCpAjChOjAmPiBeC_xHqqkZx_
//----- 05.06.27 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		FFPushPendingMessage(FCPendingMessage(FD_PMSG_MAIN_WND|FD_PMSG_IF_VISIBLE,
//											WM_USER_FONT_NOT_FOUND));
//----- 05.06.27 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		FFPushPendingMessage(FCPendingMessage(FD_PMSG_MAIN_WND|FD_PMSG_IF_VISIBLE,
											WM_USER_FONT_NOT_FOUND, NULL, NULL, FALSE));
//----- 05.06.27 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 03.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}
} // FFAppendErrFontInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFGetAndClearErrFontInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCpAiOoGiCoIiPgPiClFiCmEiBeBjDoAjFjEjFmPjAjEiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vFontInfo	:_xZkqqHx_iDeHiDiJiBfLiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFGetAndClearErrFontInfo (vector<FCErrFontInfo>& vFontInfo)
{
	set<FCErrFontInfo>::const_iterator i;
	for (i = s_stErrFontInfo.begin(); i != s_stErrFontInfo.end(); i++)
		vFontInfo.push_back(*i);
	s_stErrFontInfo.clear();
} // FFGetAndClearErrFontInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFIsErrFontInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.09.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL FFIsErrFontInfo ()
{
	return !s_stErrFontInfo.empty();
} // FFIsErrFontInfo.
//----- 03.06.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ( )-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCollectFontName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgH_xHqqkZx_(_xZkqqHx_jCmKiPoNiCmN_xHqqkZx_SJIS)_xZkqqHx_iBeBjFfHiPiAiImIiKePiCmMiDhEiDeIiDjDiDgHiCmJiKnGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iDhEiDeIiDjDiDgHjGlMiCmMiIoKjHjHiCpAiNoMjAkMiClHiCoJiBeCjFfHiPiAiImIiKePiCmMiDhEiDeIiDjDiDgHiCmJiKnGiClFiCmEiCmNiBeB_xHqqkZx_
 *			_xZkqqHx_iKgFiDhEiDeIiDjDiDgHiClCiCmGiCmJ_xHqqkZx_CharSet_xZkqqHx_iCmMiDiKiDfIiDgHiCoAiNoMjAkMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mpExtCodeFontMap	:_xZkqqHx_jFfHiPiAiImIiKePiCmMiDhEiDeIiDjDiDgHjGlMiIoKjHjHiCmG_xHqqkZx_CharSet_xZkqqHx_iIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *								 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			stStdCodeFontName	:_xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHjGlMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *								 _xZkqqHx_jFhDjHhGiCmMiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FFCollectFontName (FTFontCharSetMap* mpExtCodeFontMap, WStringSet* stStdCodeFontName)
{
	struct l_ {
		struct myFCData {
			FTFontCharSetMap* mpExtCodeFontMap;
			WStringSet* stStdCodeFontName;
		};
		static int CALLBACK myEnumFontNameProc (const ENUMLOGFONTEX* pLogFont,
												const NEWTEXTMETRICEX* pTm,
												DWORD FontType,
												LPARAM lParam)
		{
			// _xZkqqHx_iDeBiDeFiDgHiDiJiDeDiDjDiDhEiDeIiDjDiDgHiCmFiCmNiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
			if (!(FontType & TRUETYPE_FONTTYPE)) return 1;
			myFCData* data = (myFCData*)lParam;
			TStrToWStr wstr(pLogFont->elfLogFont.lfFaceName);
			if (data->stStdCodeFontName != NULL)
				data->stStdCodeFontName->insert(wstr);
			if (data->mpExtCodeFontMap != NULL)
				(*data->mpExtCodeFontMap)[wstr][pLogFont->elfLogFont.lfCharSet] = TStrToWStr((const _TCHAR*)pLogFont->elfScript);
			return 1;
		} // myEnumFontNameProc.
	};
	l_::myFCData data;
	HDC hAttribDC = ::CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	LOGFONT logFont;

	//----- _xZkqqHx_iCnMiClIiBeBjBfDiCmEiCmMiDhIiDeOiDgHiDiLiDhEiDeIiDjDiDgHiPoOjFpBiCpAiOoGjDlO_xHqqkZx_ -----
	if (mpExtCodeFontMap != NULL)
	//----- _xZkqqHx_jEpBjFfHiPiAiDhEiDeIiDjDiDgHiPfHiNiHiCkKiOhHjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		data.mpExtCodeFontMap = mpExtCodeFontMap;
		data.stStdCodeFontName = NULL;
		// CharSet_xZkqqHx_iCmJiDgGiDhEiDeIiDiLiDgHjFlGiOjKiDfKiDgCiDgHiCpAiOhHjCoIiBeCiClBiCoKiCmFiCnJiCmGiCpBiCmHiCmMiDhEiDeIiDjDiDgHiBeF_xHqqkZx_CharSet_xZkqqHx_iCkKjHpBiLjDiClDiCoKiCoJiBeC_xHqqkZx_
		logFont.lfCharSet = DEFAULT_CHARSET;
		logFont.lfPitchAndFamily = 0;		// Must be 0 for EnumFontFamiliesEx.
		logFont.lfFaceName[0] = _T('\0');
		// _xZkqqHx_iIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
		::EnumFontFamiliesEx(hAttribDC, &logFont, FONTENUMPROC(l_::myEnumFontNameProc),
							LPARAM(&data), 0);
	}

	//----- _xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfKiDgCiDgHiCmMiDhIiDeOiDgHiDiLiDhEiDeIiDjDiDgHiPoOjFpBiCpAiOoGjDlO_xHqqkZx_ -----

	// DEFAULT_CHARSET _xZkqqHx_iCmF_xHqqkZx_ EnumFontFamiliesEx _xZkqqHx_iCpAiOmAiNhDiClFiClNiPoKiNiHiBeBiOgEjHgMiPoDiCmN_xHqqkZx_
	// _xZkqqHx_jBfDiCmEiCmM_xHqqkZx_CharSet_xZkqqHx_iCkKjHpBiLjDiClDiCoKiCoJiDgOiDfJiClOiCkKiBeBiOmAiNnLiCmJiCmNiIoKjFjEjHpBiLjDiClDiCoKiCmIiCkC_xHqqkZx_
	// _xZkqqHx_iCoAiCmMiCkKiCkAiCoJiBeC_xHqqkZx_g_pReg->GetStdFontCharset()_xZkqqHx_iCmM_xHqqkZx_CharSet_xZkqqHx_iCmJiKnGiClFiCmE_xHqqkZx_
	// mpExtCodeFontMap _xZkqqHx_iCpAiOhHjCoIiClHiCoJiClBiCmGiCmFiBeBjHpBiLjDiClDiCoKiCmIiCkCiCoAiCmMiCpAjCmHiJmBiCmFiOoGjDlOiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_jEpBjFfHiPiAiDhEiDeIiDjDiDgHiPfHiNiHjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
	data.mpExtCodeFontMap = mpExtCodeFontMap;
	// _xZkqqHx_jFfHiPiAiDhEiDeIiDjDiDgHiPfHiNiHjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
	data.stStdCodeFontName = stStdCodeFontName;
	// CharSet_xZkqqHx_iCmJjFfHiPiAiDhEiDeIiDjDiDgHiCmMjFlGiOjKiDfKiDgCiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
	logFont.lfCharSet = g_pReg->GetStdFontCharset();
	logFont.lfPitchAndFamily = 0;		// Must be 0 for EnumFontFamiliesEx.
	logFont.lfFaceName[0] = _T('\0');
	// _xZkqqHx_iIoKjHjHiCpAiOoGjDlOiBeC_xHqqkZx_
	::EnumFontFamiliesEx(hAttribDC, &logFont, FONTENUMPROC(l_::myEnumFontNameProc),
						LPARAM(&data), 0);
	// HDC_xZkqqHx_iCpAiNoNiPjMiBeC_xHqqkZx_
	::DeleteDC(hAttribDC);
} // FFCollectFontName.
