#ifndef __UtilMisc_h
#define __UtilMisc_h

class FCPolyJoint;

#define	M_PI	3.14159265358979323846264338327950288419716939937510
#define M_PI_D	6.283185307179586476925286766558

// 06.11.15 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//#define FD_HIT_TEST_MARGIN	4
#define FD_HIT_TEST_MARGIN	5
// _xZkqqHx_iDgOiDjDiDgIiDiLiCkJiCoHiPfMjFkKiJjDiCkCiCmGjElLjCgGiClDiCoKiCoJiLjHjHkDiBgJiDhDiDeOiDfKiDiLiBgK_xHqqkZx_
#define FD_FAR_FROM_HANDLE	35

//;----- <EXPORT TO SERVER> -----;

#define FD_CRC_INIT_VALUE WORD(0xffff)

//;----- </EXPORT TO SERVER> -----;

//----------<NOT EXPORT TO VIEWER>-----------

////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iMgPiJnPiOjOiKnEiMhGjBkKiDhNiDeOiDiNiBeCiDgGiDgPiDgCiDePjHhAiBeC_xHqqkZx_

#ifdef _DEBUG

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCCheckTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOjOiKnEiMhGjBkKjHhAiCmMiDeOiDiJiDfIiBeCiDeDiDjDiDfIiDfOiDjDiDfIiNoMjAkMiOjOiCmJiMhGjBkKiCpAiOgOiCnPiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDeDiDjDiDfIiDfOiDjDiDfIiPmBjGmFiOjOiCmJiBeBiMgPiJnPiOjOiKnEiCpAiDgGiDgPiDgCiDePiDeFiDeCiDjDiDgIiDeFiCmJ_xHqqkZx_
 *			_xZkqqHx_iPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.11.29 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class FCCheckTime
{
public:
	FCCheckTime (const wchar_t* wcpMessage);
	~FCCheckTime ();

private:
	FDTIME		m_fdtmBegin;
	CString		m_strMessage;
}; // class FCCheckTime.

#define FD_BEGIN_CHECK_TIME(a) { FCCheckTime ___xcvb_time__bgn(a);
#define FD_END_CHECK_TIME }

#else //_DEBUG

#define FD_BEGIN_CHECK_TIME(a)
#define FD_END_CHECK_TIME

#endif//_DEBUG

////////////////////////////////////////////////////////////////////////////

//----------</NOT EXPORT TO VIEWER>-----------

//////////////////////////////////////////////////////////////////////////
// inline _xZkqqHx_iKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iJiJiOfKiOhB_xHqqkZx_>	<
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	GUID_xZkqqHx_iCmMjBoFiPkMjEoEiKhCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid1	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			guid2	:_xZkqqHx_jEoEiKhCjBmOiPnLiCmMiIpIjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	guid1 < guid2 _xZkqqHx_iCmIiCoHiCmO_xHqqkZx_ true_xZkqqHx_iBeBiClLiCoKiImIiKePiCmN_xHqqkZx_ false_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.09.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline bool operator < (const GUID& guid1, const GUID& guid2)
{
	if (guid1.Data1 < guid2.Data1) return true;
	if (guid1.Data1 > guid2.Data1) return false;
	if (guid1.Data2 < guid2.Data2) return true;
	if (guid1.Data2 > guid2.Data2) return false;
	if (guid1.Data3 < guid2.Data3) return true;
	if (guid1.Data3 > guid2.Data3) return false;
	return (memcmp(guid1.Data4, guid2.Data4, sizeof(guid1.Data4)) < 0);
} // operator <.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFMove
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpBiCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaTarg	:_xZkqqHx_iDhMiDeDiDjDiDgHjEhKjHpBiCpAiOhHjCoIiBeCiInKjDkOiMoDiCmMjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *			lTarg		:mmptaTarg_xZkqqHx_iCmMjEhKjHpBiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDx		:X_xZkqqHx_jFpLiMpMiCmMiInKjDkOiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmDy		:Y_xZkqqHx_jFpLiMpMiCmMiInKjDkOiLjHjHkDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline void FFMove (DBLPoint mmptaTarg[], long lTarg, mmetol mmDx, mmetol mmDy)
{
	while (0 < lTarg--)
		mmptaTarg[lTarg] += DBLPoint(mmDx, mmDy);
} // FFMove.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ShiftConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	X_xZkqqHx_iDfGiDhEiDgHjFmPiKlHiCmMiMoDiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptTarg	: _xZkqqHx_jFmPiKlHjBmOiPnLiCmMiNmAjFfH_xHqqkZx_
 *			mmRadiusY	: _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmMjBoFiCkLiClDiCmM_xHqqkZx_Y_xZkqqHx_jHhGjBgG_xHqqkZx_
 *			mmShiftX	: _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmMjBoFiCkLiClDiCmM_xHqqkZx_X_xZkqqHx_jHhGjBgG_xHqqkZx_
 *			mmCenterY	: _xZkqqHx_jAhNiMgAiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P217_xZkqqHx_iBgA_xHqqkZx_219_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
 *************************************************************************/
inline void ShiftConv (DBLPoint& mmptTarg, double mmRadiusY,
						double mmShiftX, double mmCenterY)
{
// 00.09.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (mmRadiusY == 0) return;
	if (almost0(mmRadiusY)) return;
	/*----- _xZkqqHx_iDfGiDhEiDgHjFmPiKlH_xHqqkZx_ -----*/
	mmptTarg.x += (mmptTarg.y - mmCenterY) * (mmShiftX / mmRadiusY);
} // ShiftConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	ShiftConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	X_xZkqqHx_iDfGiDhEiDgHjFmPiKlHiCmMiMoDiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaTarg	: _xZkqqHx_jFmPiKlHjBmOiPnLiCmMiNmAjFfH_xHqqkZx_(_xZkqqHx_jEhKjHpB_xHqqkZx_)
 *			lTarg		: mmptaTarg_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *			mmRadiusY	: _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmMjBoFiCkLiClDiCmM_xHqqkZx_Y_xZkqqHx_jHhGjBgG_xHqqkZx_
 *			mmShiftX	: _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmMjBoFiCkLiClDiCmM_xHqqkZx_X_xZkqqHx_jHhGjBgG_xHqqkZx_
 *			mmCenterY	: _xZkqqHx_jAhNiMgAiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P217_xZkqqHx_iBgA_xHqqkZx_219_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
 *************************************************************************/
inline void ShiftConv (DBLPoint mmptaTarg[], long lTarg, double mmRadiusY,
						double mmShiftX, double mmCenterY)
{
// 00.09.20 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (mmRadiusY == 0) return;
	if (almost0(mmRadiusY)) return;
	double dRatio = mmShiftX / mmRadiusY;
	/*----- _xZkqqHx_iDfGiDhEiDgHjFmPiKlH_xHqqkZx_ -----*/
	while (0 < lTarg--)
		mmptaTarg[lTarg].x += (mmptaTarg[lTarg].y - mmCenterY) * dRatio;
} // ShiftConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RotateConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNjFmPiKlHiCmMiMoDiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptTarg	: _xZkqqHx_jFmPiKlHjBmOiPnLiCmMiNmAjFfH_xHqqkZx_
 *			dSin		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_SIN_xZkqqHx_jCgM_xHqqkZx_
 *			dCos		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_COS_xZkqqHx_jCgM_xHqqkZx_
 *			mmRotCenterX: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmRotCenterY: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_217_xZkqqHx_iBgA_xHqqkZx_219_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
 *************************************************************************/
inline void RotateConv (DBLPoint& mmptTarg, double dSin, double dCos,
						double mmRotCenterX, double mmRotCenterY)
{
	/*----- RotCenter_xZkqqHx_iCkJiCoHiCmMjBiKjBmOiNmAjFfHiCmJjFmPiKlH_xHqqkZx_ -----*/
	double	mmSX = mmptTarg.x - mmRotCenterX;
	double	mmSY = mmptTarg.y - mmRotCenterY;
	/*----- _xZkqqHx_iJpBjDfNjFmPiKlHiMoDiBeBjAoCjBmOiNmAjFfHiCnGjFmPiKlH_xHqqkZx_ -----*/
	mmptTarg.x = mmSX * dCos - mmSY * dSin + mmRotCenterX;
	mmptTarg.y = mmSX * dSin + mmSY * dCos + mmRotCenterY;
} // RotateConv.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RotateConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNjFmPiKlHiCmMiMoDiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptTarg	: _xZkqqHx_jFmPiKlHjBmOiPnLiCmMiNmAjFfH_xHqqkZx_
 *			dSin		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_SIN_xZkqqHx_jCgM_xHqqkZx_
 *			dCos		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_COS_xZkqqHx_jCgM_xHqqkZx_
 *			mmptRotCenter: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmMiNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_217_xZkqqHx_iBgA_xHqqkZx_219_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
 *************************************************************************/
inline void RotateConv (DBLPoint& mmptTarg, double dSin, double dCos,
						const DBLPoint& mmptRotCenter)
{
	// RotCenter_xZkqqHx_iCkJiCoHiCmMjBiKjBmOiNmAjFfHiCmJjFmPiKlHiClFiBeBiJpBjDfNjFmPiKlHiMoDiBeBjAoCjBmOiNmAjFfHiCnGjFmPiKlHiBeC_xHqqkZx_
	mmptTarg = (mmptTarg - mmptRotCenter).RotatePoint(dSin, dCos) + mmptRotCenter;
} // RotateConv.

//----- 05.03.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RotateConv
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJpBjDfNjFmPiKlHiCmMiMoDiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaTarg	: _xZkqqHx_jFmPiKlHjBmOiPnLiCmMiNmAjFfH_xHqqkZx_(_xZkqqHx_jEhKjHpB_xHqqkZx_)
// *			lTarg		: mmptaTarg_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
// *			dSin		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_SIN_xZkqqHx_jCgM_xHqqkZx_
// *			dCos		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_COS_xZkqqHx_jCgM_xHqqkZx_
// *			mmRotCenterX: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
// *			mmRotCenterY: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_217_xZkqqHx_iBgA_xHqqkZx_219_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
// *			DBL_MAX_xZkqqHx_iCmMiPoKiNiHiCmNiBeBiClLiCmMiCnMiCnMiOgDiClHiBeC_xHqqkZx_
// *************************************************************************/
//inline void RotateConv (DBLPoint mmptaTarg[], long lTarg,
//						double dSin, double dCos, double mmRotCenterX,
//						double mmRotCenterY)
//{
//	while (0 < lTarg--)
//	{
//		if (mmptaTarg[lTarg].x != DBL_MAX)
//			RotateConv(mmptaTarg[lTarg], dSin, dCos, mmRotCenterX, mmRotCenterY);
//	}
//} // RotateConv.
//----- 05.03.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegulateAngle
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCpA_xHqqkZx_[0.0, 2.0)_xZkqqHx_iCmJjEfLiCnPiCoJiBgJjAlDiLeLiJlLiClHiCoJiBgKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR	:_xZkqqHx_jAlDiLeLiJlLiClHiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiLeLiJlLiClFiClNjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline double RegulateAngle (double dR)
{
	while (dR < 0.0) dR += 2.0;
	while (2.0 <= dR) dR -= 2.0;
	// 0_xZkqqHx_iCkJ_xHqqkZx_2.0_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_0_xZkqqHx_iCmJjFoCjAlDiBeCiClCiCkNiCnMiCoKiCmJ_xHqqkZx_ 2.0_xZkqqHx_iCmJiCmIiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
	if (almost0(dR) || almosteq(dR, 2.0)) dR = 0.0;
	return dR;
} // RegulateAngle.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFAngleMinusPitoPi
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKhAjDhIiCpA_xHqqkZx_[-_xZkqqHx_iDmO_xHqqkZx_, _xZkqqHx_iDmO_xHqqkZx_)_xZkqqHx_iCmJjEfLiCnPiCoJiBgJjAlDiLeLiJlLiClHiCoJiBgKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR	:_xZkqqHx_jAlDiLeLiJlLiClHiCoJiKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiLeLiJlLiClFiClNjCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline double FFAngleMinusPitoPi (double dR)
{
	while (dR < M_PI) dR += M_PI_D;
	while (M_PI <= dR) dR -= M_PI_D;
	return dR;
} // FFAngleMinusPitoPi.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFSin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	sin_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR	:_xZkqqHx_iKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	sin_xZkqqHx_jCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline double FFSin (angle dR)
{
	dR = RegulateAngle(dR);
	if (almost0(dR)) return 0.0;
	if (almosteq(dR, 0.5)) return 1.0;
	if (almosteq(dR, 1.0)) return 0.0;
	if (almosteq(dR, 1.5)) return -1.0;
	return sin(M_PI * dR);
} // FFSin.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCos
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	cos_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dR	:_xZkqqHx_iKhAjDhIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	cos_xZkqqHx_jCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.04.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline double FFCos (angle dR)
{
	dR = RegulateAngle(dR);
	if (almost0(dR)) return 1.0;
	if (almosteq(dR, 0.5)) return 0.0;
	if (almosteq(dR, 1.0)) return -1.0;
	if (almosteq(dR, 1.5)) return 0.0;
	return cos(M_PI * dR);
} // FFCos.

//----------<NOT EXPORT TO VIEWER>-----------

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CoordConv
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	X_xZkqqHx_iDfGiDhEiDgHjFmPiKlHiLhJiCnBiJpBjDfNjFmPiKlHiCmMiMoDiCmMiNmAjFfHjCgMiCpAiMhGiOfKiClHiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptaTarg	: _xZkqqHx_jFmPiKlHjBmOiPnLiCmMiNmAjFfH_xHqqkZx_(_xZkqqHx_jEhKjHpB_xHqqkZx_)
 *			lTarg		: mmptaTarg_xZkqqHx_iCmMiDfEiDeDiDfJ_xHqqkZx_.
 *			mmRadiusY	: _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmMjBoFiCkLiClDiCmM_xHqqkZx_Y_xZkqqHx_jHhGjBgG_xHqqkZx_
 *			mmShiftX	: _xZkqqHx_jAhNiMgAiCmMjAiCjClMiOlCiCmMjBoFiCkLiClDiCmM_xHqqkZx_X_xZkqqHx_jHhGjBgG_xHqqkZx_
 *			mmCenterY	: _xZkqqHx_jAhNiMgAiCmMjCiGjAfDjDfPiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			dSin		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_SIN_xZkqqHx_jCgM_xHqqkZx_
 *			dCos		: _xZkqqHx_iJpBjDfNiKhAiCmM_xHqqkZx_COS_xZkqqHx_jCgM_xHqqkZx_
 *			mmRotCenterX: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_X_xZkqqHx_iNmAjFfH_xHqqkZx_
 *			mmRotCenterY: _xZkqqHx_iJpBjDfNjFmPiMgAiCmMiJpBjDfNiOlCiCmM_xHqqkZx_Y_xZkqqHx_iNmAjFfH_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_217_xZkqqHx_iBgA_xHqqkZx_219_xZkqqHx_iCpAiOfBiPmG_xHqqkZx_.
 *************************************************************************/
inline void CoordConv (DBLPoint mmptaTarg[], long lTarg, double mmRadiusY,
						double mmShiftX, double mmCenterY,
						double dSin, double dCos, double mmRotCenterX,
						double mmRotCenterY)
{
	while (0 < lTarg--)
	{
		ShiftConv(mmptaTarg[lTarg], mmRadiusY, mmShiftX, mmCenterY);
		RotateConv(mmptaTarg[lTarg], dSin, dCos, mmRotCenterX, mmRotCenterY);
	}
} // CoordConv.

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDePiDiNiBfLiDgPiDiLiKnGjAjEjAoJiMlOiBeC_xHqqkZx_

//----- 05.05.28 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiPoOjFpBiBeC_xHqqkZx_
extern const OSVERSIONINFO& FFVersionInfo ();	// version information.
// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiDeMiDiDiDhGiDgAiDiDiKnGjIeBiBeC_xHqqkZx_
extern HWND FFGetCapture ();
extern void FFSetCapture (HWND hwnd);
extern void FFReleaseCapture ();
extern void FFUpdateCapture ();
extern HINSTANCE FFLoadLibrary (const wchar_t* wcpModuleName);
extern BOOL FFFreeLibrary (HINSTANCE hInstLib);
//----- 05.05.28 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----- 05.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- 02.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDgFiDfIiDgH_xHqqkZx_)-----
//extern void FFSmoothMm2Lg (CPointVector& vlgpt, const DBLPointVector& vmmpt,
//							BOOL bIsClose, const mmetol mmElemLen, double dZoom = g_->dZoom);
////----- 02.10.25 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDgFiDfIiDgH_xHqqkZx_)-----
//----- 05.05.28 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

extern void RotateConv (DBLPoint mmptaTarg[], long lTarg,
						double dSin, double dCos, double mmRotCenterX,
						double mmRotCenterY);

extern void FFResizePolygon (DBLPoint mmpt[],
							long lPolySize,
							const DBLRect& mmrtFrame,
							BOOL bXPosi, BOOL bYPosi,
							const DBLRect& mmrtResize);

// _xZkqqHx_iDhMiDiKiDfDiDjDjEhKjHpBiCpAiBeBjHfOiCkGiCoHiCoKiClNiDfEiDeDiDfJiCmJiCoGiCmBiCmEiDiKiDfEiDeDiDfJiClHiCoJ_xHqqkZx_.
extern void FFResizePolygon (CPoint lgptaPoly[],
							long lPolySize,
							const DBLPoint mmptaPoly[],
							const DBLRect& mmrtFrameOld,
							BOOL bXPosi, BOOL bYPosi,
							const DBLRect& mmrtFrameNew);

//----------</NOT EXPORT TO VIEWER>-----------

extern BOOL	IsPtInPolygon (const DBLPoint mmptaP[], long lP,
							const DBLPoint& mmptA);
extern double CalcPowDistance (DBLPoint& mmptS, const DBLPoint& mmptO,
								const DBLPoint& mmptA, const DBLPoint& mmptP);
extern double CalcPowDistance (DBLPoint& mmptS, const DBLPoint& mmptO,
								const DBLPoint& mmptA, const double& mmOAPowLen,
								const DBLPoint& mmptP);
extern double CalcPowDistance (DBLPoint& mmptS, const DBLPoint* mmptaH,
								long lH, const DBLPoint& mmptP);
extern double ArcTan (double dX, double dY);
extern double ArcTan (const DBLPoint& mmptL);
// 02.07.21 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (A3_xZkqqHx_iJkBjClH_xHqqkZx_,_xZkqqHx_jHfNjEjC_xHqqkZx_0_xZkqqHx_iCmJjAnNjCoIiClFiBeBjHhAiOiGiCkCiCmBiCmPiCkCiCmJjBoFiCkLiCkCiOgMiKhAiCmFjFfMiOkGiCkKjHjAiCoKiCoJ_xHqqkZx_)
//extern LONG PolyIntersect (const CPoint& ptPos, const CPoint aPoint[], LONG lPoint, SHORT nWidth);
extern long FFPolyIntersect (const DBLPoint& mmptPos, const DBLPoint mmptaPoint[], long lPoint, mmetol mmWidth);
//----------<NOT EXPORT TO VIEWER>-----------

extern void CalcRoundy (FCPolyJoint& pjTarget, const DBLPoint& mmptPrev,
						const DBLPoint& mmptNext, short nRound);

// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiFjFlNjApMiCmMiMpAjDfPiCmMiPfHiNiHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
extern void PolyCrossHoriz (const DBLPoint mmptaP[],
							long lP,
							BOOL bIsClose,
							double mmLY,
							doubleVector& mmvCrossX);
// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiCjClMjApMiCmMiMpAjDfPiCmMiPfHiNiHiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
extern void PolyCrossVert (	const DBLPoint mmptaP[],
							long lP,
							BOOL bIsClose,
							double mmLX,
							doubleVector& mmvCrossY);
// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiFjFlNjApMiCmMiMpAjDfPiCmMiPfHiNiHiCpAiLiBiCnPiCoJiBeCiMpAiNlHiCkJiCmHiCkEiCkJiCmMjElLjCgGiCmNjOeCjGiGiBeC_xHqqkZx_
extern void PolyAboutCrossHoriz (	const DBLPoint mmptaP[],
									long lP,
									BOOL bIsClose,
									mmetol mmLY,
									doubleVector& mmvCrossX);
// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjAiCjClMjApMiCmMiMpAjDfPiCmMiPfHiNiHiCpAiLiBiCnPiCoJiBeCiMpAiNlHiCkJiCmHiCkEiCkJiCmMjElLjCgGiCmNjOeCjGiGiBeC_xHqqkZx_
extern void PolyAboutCrossVert (const DBLPoint mmptaP[],
								long lP,
								BOOL bIsClose,
								mmetol mmLX,
								doubleVector& mmvCrossY);
// _xZkqqHx_iDhMiDiKiDfDiDjDiCmGjClMjApMiCmMiMpAjDfPiCmMiPfHiNiHiCpAiLiBiCnPiCoJ_xHqqkZx_.
extern void PolyCrossLine (	const DBLPoint mmptaP[],
							long lP,
							BOOL bIsClose,
							const DBLLine& mmlnL,
							DBLPointVector& mmptvCross);
// _xZkqqHx_iDhMiDiKiDiJiDeDiDjD_xHqqkZx_P_xZkqqHx_iCmGjClMjApM_xHqqkZx_AN_xZkqqHx_iCmMiMpAjDfP_xHqqkZx_F_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_F_xZkqqHx_iCmNiBeBiNmFiCoA_xHqqkZx_AN_xZkqqHx_jFpLiMpMiCmFiJjDiCkCiMpAjDfPiBeC_xHqqkZx_
extern BOOL CalcCrossPointLinePolyline (DBLPoint& mmptF,
										const DBLPoint mmptaP[],
										long lSizeP,
										BOOL bIsClose,
										const DBLPoint& mmptA,
										const DBLPoint& mmptN);

// _xZkqqHx_jFkBjAjEiCmMiMpAjDfPiPfHiNiHiBgJ_xHqqkZx_PolyCrossHoriz_xZkqqHx_iCmIiCmHiCmFiNoMjAkMiBgKiCpAiBeBiIoKiCmCiCmJiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
extern void FFMakeCommonInside (mmetolVector& mmvCommonInsideX,
								mmetolVector mmvaInsideX[],
								long lInsideXSize);


//----------</NOT EXPORT TO VIEWER>-----------
// _xZkqqHx_jDkPiClGiNmAjFfHiCpAiOjNiCmCjIeBjBlBiClFiClNiCfBiCmCiCmMjDfPiCpAiJpAiPmBiBeC_xHqqkZx_
extern void FFRemoveSamePoint (DBLPointVector& vPoly, BYTEVector& vIsJoint);
//----------<NOT EXPORT TO VIEWER>-----------

//;----- <EXPORT TO SDK> -----;

enum FDTurnTo
{
	TURN_TO_NONE,
	TURN_TO_RIGHT,
	TURN_TO_LEFT,
	TURN_TO_FRONT,
	TURN_TO_BACK
}; // enum FDTurnTo.

//;------ </EXPORT TO SDK> -----;

extern FDTurnTo TurnToWhich (DBLPoint A, DBLPoint B, DBLPoint C);
extern FDTurnTo TurnToWhich (const DBLPoint& A0, const DBLPoint& A1, const DBLPoint& B0, const DBLPoint& B1);

//----------</NOT EXPORT TO VIEWER>-----------
//;------ <EXPORT TO SDK> -----;
enum FDDirect
{
	DIR_NONE,
	DIR_UPPERRIGHT,
	DIR_JUSTUPPER,
	DIR_UPPERLEFT,
	DIR_JUSTLEFT,
	DIR_DOWNLEFT,
	DIR_JUSTDOWN,
	DIR_DOWNRIGHT,
	DIR_JUSTRIGHT,
}; // enum FDDirect.
//;------ </EXPORT TO SDK> -----;

extern FDDirect FFLineDir (const DBLPoint& O, const DBLPoint& A);

//----- 06.12.02 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
extern double FFCalcTriangleSpace (const DBLPoint& mmptP0, const DBLPoint& mmptP1, const DBLPoint& mmptP2);
extern double FFCalcPolygonSpace (const DBLPoint mmptP[], long lCount);
//----- 06.12.02 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

//----------<NOT EXPORT TO VIEWER>-----------

extern BOOL IsSameDirection (const DBLPoint& mmptA, const DBLPoint& mmptB, const DBLPoint& mmptC);
extern BOOL IsSameDirection (const DBLPoint& mmptA, const DBLPoint& mmptB, const DBLPoint& mmptC, const DBLPoint& mmptD);
extern FDTIME FFGetCurrentTime ();

extern FDMILLISECTIME FFGetCurrentMillisecTime ();
extern FDMILLISECTIME FdtimeToFdmillisec (FDTIME fdtm);

extern FDSECTIME FFGetCurrentSecTime ();
extern FDSECTIME FdtimeToFdsec (FDTIME fdtm);
//----------</NOT EXPORT TO VIEWER>-----------
extern FILETIME  FdtimeToFiletime (FDTIME fdtm);
//----------<NOT EXPORT TO VIEWER>-----------
extern FDTIME    FdsecToFdtime (FDSECTIME fdst);
extern FILETIME  FdsecToFiletime (FDSECTIME fdst);
extern FDTIME    FiletimeToFdtime (FILETIME ft);
extern FDTIME    COleDtToFdtime (const COleDateTime& otm);
extern FDSECTIME COleDtToFdsec (const COleDateTime& otm);

extern long FFWheelDeltaToScrollCount (short zDelta);

extern GUID FFCreateGuid ();
extern WORD FFGetGuidCheckCode (const GUID& guid);
extern WORD FFCalcCRC (flint fliCount, const void* pData, WORD crc = FD_CRC_INIT_VALUE);
extern void FFCalcFrame (CRect& rect, long lSize, const CPoint point[]);
extern void FFCalcFrame (DBLRect& rect, long lSize, const DBLPoint point[]);

extern BOOL FFLoadRegString (WString& strData, HKEY hKey,
							const wchar_t* wcpSubKey,
							const wchar_t* wcpName);

extern BOOL FFLoadRegDWORD (DWORD& dwData, HKEY hKey,
							const wchar_t* wcpSubKey,
							const wchar_t* wcpName);

extern long FFGetSmallerItemFromList (long lValue, const long* pList, long lListSize);
extern long FFGetLargerItemFromList (long lValue, const long* pList, long lListSize);
extern HANDLE FFCopyHandle (HANDLE h, UINT nFlags);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcCRC
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDhEiDeAiDeDiDiLiCmM_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file	:_xZkqqHx_iDhEiDeAiDeDiDiLiCpAiOhHjCoIiBeCiMhGiOfKiCpAiKeKiOgOiClHiCoJiImKjChFiCnGiDfGiBfLiDeOiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *			fliCount:CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiDgPiDeDiDgHjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
 *			crc		:_xZkqqHx_jBePiJpBiCnMiCmFiCmM_xHqqkZx_CRC_xZkqqHx_jCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	CRC_xZkqqHx_jCgMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T> WORD FFCalcCRC (T& file, flint fliCount, WORD crc = FD_CRC_INIT_VALUE)
{
	static WORD s_CCITT_16_POLYx1021[] =
	{
		0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
		0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
		0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
		0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
		0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
		0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
		0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
		0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
		0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
		0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
		0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
		0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
		0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
		0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
		0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
		0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
		0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
		0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
		0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
		0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
		0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
		0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
		0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
		0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
		0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
		0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
		0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
		0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
		0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
		0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
		0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
		0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
	};

	BYTE buff[0x1000];
	const BYTE* bypData = buff;
	const BYTE* bypDataEnd = buff;
	for (;;)
	{
		if (bypData == bypDataEnd)
		{
			flint fliTmp = (fliCount < sizeof(buff)) ? fliCount : sizeof(buff);
			fliTmp = file.Read64(buff, fliTmp);
			if (fliTmp == 0) break;
			fliCount -= fliTmp;
			bypData = buff;
			bypDataEnd = buff + fliTmp;
		}
		crc = (crc << 8) ^ s_CCITT_16_POLYx1021[(crc >> 8) ^ *bypData];
		bypData++;
	}
	return crc;
} // template<class T> WORD FFCalcCRC (T& file).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HitTest1
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iIoKiOjPiMlDiBgJjHoBiCkGiCmO_xHqqkZx_ _xZkqqHx_jAiFjFlNjApMiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHjCgMiBgKiCmFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a	:_xZkqqHx_jClCiNlIjBmOiPnLiCfAiCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			p	:_xZkqqHx_jClCiNlIjBmOiPnLiCfBiCmMjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	a_xZkqqHx_iCmG_xHqqkZx_p_xZkqqHx_iCmMiLjHjHkDiCkK_xHqqkZx_FD_HIT_TEST_MARGIN_xZkqqHx_jGkCjGjOiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeBiImIiPoDiCmIiCoH_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL HitTest1 (long a, long p)
{
	if (a - FD_HIT_TEST_MARGIN < p && p < a + FD_HIT_TEST_MARGIN) return TRUE;
	return FALSE;
} // HitTest1.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HitTest2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiOjPiMlDiBgJ_xHqqkZx_x,y_xZkqqHx_iNmAjFfHiBgKiCmFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bx	:_xZkqqHx_jClCiNlIjBmOiPnLiCfAiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			by	:_xZkqqHx_jClCiNlIjBmOiPnLiCfAiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			px	:_xZkqqHx_jClCiNlIjBmOiPnLiCfBiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			py	:_xZkqqHx_jClCiNlIjBmOiPnLiCfBiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wx	:_xZkqqHx_jClCiNlIjBmOiPnLiCmM_xHqqkZx_x_xZkqqHx_jFpLiMpMiCmMiKoOiPiAiLjHjHkDjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wy	:_xZkqqHx_jClCiNlIjBmOiPnLiCmM_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmMiKoOiPiAiLjHjHkDjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	b_xZkqqHx_iCmG_xHqqkZx_p_xZkqqHx_iCmMiLjHjHkDiCkKiKoOiPiAiLjHjHkDjGkCjGjOiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeBiImIiPoDiCmIiCoH_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL HitTest2 (long bx, long by, long px, long py, long wx, long wy)
{
	if ((bx - wx < px && px < bx + wx) && (by - wy < py && py < by + wy)) return TRUE;
	return FALSE;
} // HitTest2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	HitTest2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiOjPiMlDiBgJ_xHqqkZx_x,y_xZkqqHx_iNmAjFfHiBgKiCmFiCmMiDhBiDgCiDgHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bx	:_xZkqqHx_jClCiNlIjBmOiPnLiCfAiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			by	:_xZkqqHx_jClCiNlIjBmOiPnLiCfAiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			px	:_xZkqqHx_jClCiNlIjBmOiPnLiCfBiCmM_xHqqkZx_x_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			py	:_xZkqqHx_jClCiNlIjBmOiPnLiCfBiCmM_xHqqkZx_y_xZkqqHx_iNmAjFfHjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wx	:_xZkqqHx_jClCiNlIjBmOiPnLiCmM_xHqqkZx_x_xZkqqHx_jFpLiMpMiCmMiKoOiPiAiLjHjHkDjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wy	:_xZkqqHx_jClCiNlIjBmOiPnLiCmM_xHqqkZx_y_xZkqqHx_jFpLiMpMiCmMiKoOiPiAiLjHjHkDjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	b_xZkqqHx_iCmG_xHqqkZx_p_xZkqqHx_iCmMiLjHjHkDiCkKiKoOiPiAiLjHjHkDjGkCjGjOiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeBiImIiPoDiCmIiCoH_xHqqkZx_FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.03 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL HitTest2 (mmetol bx, mmetol by, mmetol px, mmetol py, mmetol wx, mmetol wy)
{
	if ((bx - wx < px && px < bx + wx) && (by - wy < py && py < by + wy)) return TRUE;
	return FALSE;
} // HitTest2.

inline BOOL HitTest (const DBLPoint& b, const DBLPoint& p, mmetol wx, mmetol wy)
{
	return HitTest2(b.x, b.y, p.x, p.y, wx, wy);
} // BOOL HitTest (T b, T p, int nx = FD_HIT_TEST_MARGIN, int ny = FD_HIT_TEST_MARGIN).

inline BOOL HitTest (CPoint b, CPoint p, int wx = FD_HIT_TEST_MARGIN, int wy = FD_HIT_TEST_MARGIN)
{
	return HitTest2(b.x, b.y, p.x, p.y, wx, wy);
} // BOOL HitTest (T b, T p, int nx = FD_HIT_TEST_MARGIN, int ny = FD_HIT_TEST_MARGIN).

//----------</NOT EXPORT TO VIEWER>-----------

//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FFCalcFrame
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClIjDfPiNmAjFfHiCmMjEhKjHpBiCkJiCoHiBeBiClLiCmMjAhNiMgAiCmJiKePjAnKiClHiCoJiLoJiMgAjHmMiIoGiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	rect	: _xZkqqHx_iLoJiMgAjHmMiIoGiCpAjFnEiClHiBeC_xHqqkZx_
// *			lSize	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpBiCmMiDfEiDeDiDfJ_xHqqkZx_.
// *			point	: _xZkqqHx_jClIjDfPiNmAjFfHjEhKjHpB_xHqqkZx_.
// *************************************************************************/
//template<class TPOINT, class TRECT>
//void FFCalcFrame (TRECT& rect, long lSize, const TPOINT point[])
//{
//	rect.SetRect(point[0].x, point[0].y, point[0].x, point[0].y);
//
//	long	l;
//	for (l = 1; l < lSize; l++)
//	{
//		SmallerOrLarger(rect.left, rect.right, point[l].x);
//		SmallerOrLarger(rect.top, rect.bottom, point[l].y);
//	}
//} // FFCalcFrame.
//----- 05.03.03 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCConstArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhKjHpBiCpAjEoEiKhCiClHiCoJjBiAiNoMiCpAiBeBiKmIjCfAiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T> class FCConstArray
{
public:
	FCConstArray (const T* pArray, long lArraySize) : m_pArray(pArray), m_lArraySize(lArraySize) {}
	long	Size () const
				{
					return m_lArraySize;
				}
	const T* Array () const
				{
					return m_pArray;
				}
	const T	At (long lIndex) const
				{
					return m_pArray[lIndex];
				}
	BOOL operator == (const FCConstArray<T>& a) const
				{
					if (Size() != a.Size()) return FALSE;
					for (long lC = 0; lC != Size(); lC++)
						if (At(lC) != a.At(lC)) return FALSE;
					return TRUE;
				}
	BOOL operator != (const FCConstArray<T>& a) const
				{
					return !(operator == (a));
				}
	BOOL almosteq (const FCConstArray<T>& a) const
				{
					if (Size() != a.Size()) return FALSE;
					for (long lC = 0; lC != Size(); lC++)
						if (!almosteq(At(lC), a.At(lC))) return FALSE;
					return TRUE;
				}

protected:
	const T*	m_pArray;
	long		m_lArraySize;
}; // class FCConstArray.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCArray
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jEhKjHpBiCmJjCgMiCpAjBhNjDpMiClFiClNiCoIjCgMiCpAjGjFiPmBiClHiCoJjBiAiNoMiCpAiBeBiKmIjCfAiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	----- _xZkqqHx_jHoB_xHqqkZx_ -----
 *			long lArraySz = 2;
 *			long* pArray = new long[lArraySz];
 *			pArray[0] = 1;
 *			pArray[1] = 2;
 *			FCArray(pArray, lArraySz).PushBack(10);		// pArray _xZkqqHx_iCmMiNmFiMoDiCmJ_xHqqkZx_10_xZkqqHx_iCpAjCmHiJmBiBeC_xHqqkZx_
 *			FCArray(pArray, lArraySz).Insert(2, 33);	// pArray[2] _xZkqqHx_iCmJ_xHqqkZx_33_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T> class FCArray
{
public:
	FCArray (T*& pArray, long& lArraySize) : m_pArray(pArray), m_lArraySize(lArraySize) {}
	void	Alloc (long lArraySize)
				{
					Clear();
					m_pArray = new T[lArraySize];
					m_lArraySize = lArraySize;
				}
	void	PushBack (T value)
				{
					Insert(Size(), value);
				}
	void	Insert (long lIndex, T value)
				{
					Insert(lIndex, &value, &value + 1);
				}
	void	Insert (long lIndex, const T* pArrayFirst, const T* pArrayEnd)
				{
					// m_lArraySize = 7_xZkqqHx_iBeB_xHqqkZx_lIndex = 5_xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
					// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
					// _xZkqqHx_iEkA_xHqqkZx_ 0_xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_ 5_xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_
					// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
					// pArrayFirst   pArrayEnd
					//     _xZkqqHx_iBkL_xHqqkZx_          _xZkqqHx_iBkL_xHqqkZx_
					//     _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
					//     _xZkqqHx_iEkA_xHqqkZx_ x_xZkqqHx_iEkA_xHqqkZx_ y_xZkqqHx_iEkA_xHqqkZx_ z_xZkqqHx_iEkA_xHqqkZx_
					//     _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
					// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiElLiEjPiElLiEjPiElLiEjPiElLiEjPiEkGiEjPiEkC_xHqqkZx_
					// _xZkqqHx_iEkA_xHqqkZx_ 0_xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkL_xHqqkZx_ x_xZkqqHx_iEkL_xHqqkZx_ y_xZkqqHx_iEkL_xHqqkZx_ z_xZkqqHx_iEkL_xHqqkZx_ 5_xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_
					// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiElNiEjPiElNiEjPiElNiEjPiElNiEjPiEkIiEjPiEkD_xHqqkZx_
					long lCopySize = pArrayEnd - pArrayFirst;
					if (lCopySize != 0)
					{
						T* pNewArray = new T[m_lArraySize + lCopySize];
						memcpy(pNewArray + lIndex, pArrayFirst, sizeof(T) * lCopySize);
						if (m_pArray != NULL)
						{
							memcpy(pNewArray, m_pArray, sizeof(T) * lIndex);
							memcpy(	pNewArray + lIndex + lCopySize,
									m_pArray + lIndex, sizeof(T) * (m_lArraySize - lIndex));
							delete[] m_pArray;
						}
						m_lArraySize += lCopySize;
						m_pArray = pNewArray;
					}
				}
	void	Assign (const T* pArrayFirst, const T* pArrayEnd)
				{
					Clear();
					Insert(0, pArrayFirst, pArrayEnd);
				}
	void	Erase (long lIndex)
				{
					// m_lArraySize = 8_xZkqqHx_iBeB_xHqqkZx_lIndex = 5 _xZkqqHx_iCmMiPoKiNiHiBeC_xHqqkZx_
					// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkC_xHqqkZx_
					// _xZkqqHx_iEkA_xHqqkZx_ 0_xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkA_xHqqkZx_ 5_xZkqqHx_iEkA_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_
					// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkD_xHqqkZx_
					// _xZkqqHx_iEkBiEjPiEkGiEjPiEkGiEjPiEkGiEjPiEkGiEjPiElLiEjPiEkGiEjPiEkC_xHqqkZx_
					// _xZkqqHx_iEkA_xHqqkZx_ 0_xZkqqHx_iEkA_xHqqkZx_ 1_xZkqqHx_iEkA_xHqqkZx_ 2_xZkqqHx_iEkA_xHqqkZx_ 3_xZkqqHx_iEkA_xHqqkZx_ 4_xZkqqHx_iEkL_xHqqkZx_ 6_xZkqqHx_iEkA_xHqqkZx_ 7_xZkqqHx_iEkA_xHqqkZx_
					// _xZkqqHx_iEkEiEjPiEkIiEjPiEkIiEjPiEkIiEjPiEkIiEjPiElNiEjPiEkIiEjPiEkD_xHqqkZx_
					ASSERT(m_pArray != NULL);
					T* pNewArray = NULL;
					if (m_lArraySize != 1)
					{
						pNewArray = new T[m_lArraySize - 1];
						memcpy(pNewArray, m_pArray, sizeof(T) * lIndex);
						memcpy(pNewArray + lIndex, m_pArray + lIndex + 1, sizeof(T) * (m_lArraySize - lIndex - 1));
					}
					delete[] m_pArray;
					m_lArraySize--;
					m_pArray = pNewArray;
				}
	void	Clear ()
				{
					if (m_pArray != NULL)
					{
						delete[] m_pArray;
						m_pArray = NULL;
						m_lArraySize = 0;
					}
				}
	void	operator = (const FCArray<T>& array)
				{
					Clear();
					Insert(0, array.Array(), array.Array() + array.Size());
				}
	void	operator = (const FCConstArray<T>& array)
				{
					Clear();
					Insert(0, array.Array(), array.Array() + array.Size());
				}
	long	Size () const
				{
					return m_lArraySize;
				}
	const T* Array () const
				{
					return m_pArray;
				}
	const T	At (long lIndex) const
				{
					return m_pArray[lIndex];
				}

protected:
	T*&		m_pArray;
	long&	m_lArraySize;
}; // class FCArray.

#endif //__UtilMisc_h

