#include "stdafx.h"
#include "DynamicDraw.h"	// For FFGetApp.
#include "UtilMath.h"	// For _wcstoi64.
#include "UtilStr.h"	// For FFAppendString.etc.
#include "UtilWin.h"	// For EnumWinTitle.etc.
#include "RegData.h"	// For GetLocalAppName.
#include "UtilRepair.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySaveFileStack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiBeBiPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCmJjFlGiOjKjHpBiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpStr	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySaveFileStack (const wchar_t* tcpStr)
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiBeC_xHqqkZx_
	FFGetApp()->WriteProfileStringW(strSect, L"FileStack", tcpStr);
} // mySaveFileStack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myLoadFileStack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiBeBiPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCkJiCoHjFlGiOjKjHpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	str	:_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myLoadFileStack (WString& str)
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	str = FFGetApp()->GetProfileStringW(strSect, L"FileStack");
} // myLoadFileStack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	mySaveRepairDocStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_PID_xZkqqHx_iDeMiBfLiCmJjFlGiOjKjHpBiCpAiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwPid	:_xZkqqHx_iDeMiBfL_xHqqkZx_PID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpStr	:_xZkqqHx_jFlGiOjKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void mySaveRepairDocStr (DWORD dwPid, const wchar_t* tcpStr)
{
	// _xZkqqHx_iDeMiBfLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo\\OpenDocs");
	// _xZkqqHx_iDgGiBfLiDfOjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strName;
	strName.Format(L"%x", dwPid);
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiBeC_xHqqkZx_
	FFGetApp()->WriteProfileStringW(strSect, strName, tcpStr);
} // mySaveRepairDocStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myLoadRepairDocStr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_PID_xZkqqHx_iDeMiBfLiCkJiCoHjFlGiOjKjHpBiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwPid	:_xZkqqHx_iDeMiBfL_xHqqkZx_PID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpStr	:_xZkqqHx_jFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void myLoadRepairDocStr (DWORD dwPid, WString& str)
{
	// _xZkqqHx_iDeMiBfLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo\\OpenDocs");
	// _xZkqqHx_iDgGiBfLiDfOjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strName;
	strName.Format(L"%x", dwPid);
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	str = FFGetApp()->GetProfileStringW(strSect, strName);
} // myLoadRepairDocStr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumRepairDocPid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjDgPjIfOiClDiCoKiCmEiCkCiCoJiBeBjFlGiPjBjFnCiPfHjCiGiCmMjDkPiOoNiDgDiBfLiDiLiCmM_xHqqkZx_PID_xZkqqHx_iCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	setdwPid	:PID_xZkqqHx_iCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void EnumRepairDocPid (DWORDSet& setdwPid)
{
	// _xZkqqHx_iDeMiBfLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
	WString strRegVarKey;
	strRegVarKey.Format(L"%s\\%s\\%s",
						REG_COMPAPP_NAME, GetLocalAppName(), L"RepairInfo\\OpenDocs");
	HKEY hKey;
//----- 01.08.09 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (RegOpenKeyEx(HKEY_CURRENT_USER, strRegVarKey, 0L,
//					 KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
//----- 01.08.09 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// KEY_ENUMERATE_SUB_KEYS_xZkqqHx_iCpAjGfJiCoKiCoJiCmG_xHqqkZx_NT_xZkqqHx_iCmF_xHqqkZx_RegEnumKeyEx_xZkqqHx_iCkKjDkOiNoMiClFiCmIiCkCiBeC_xHqqkZx_
	if (RegOpenKeyEx(HKEY_CURRENT_USER, WStrToTStr(strRegVarKey), 0L,
					 KEY_ENUMERATE_SUB_KEYS|KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS)
//----- 01.08.09 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	{
		_TCHAR tcsName[256];
		DWORD dwType;
		for (DWORD dwIdx = 0; ;dwIdx++)
		{
			DWORD dwName = sizeof(tcsName) / sizeof(tcsName[0]);
			if (RegEnumValue(hKey, dwIdx, tcsName, &dwName, NULL,
							&dwType, NULL, NULL) != ERROR_SUCCESS) break;
			setdwPid.insert(_tcstoul(tcsName, NULL, 16));
		}
		RegCloseKey(hKey);
	}
} // EnumRepairDocPid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RenameRepairDocData
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJiDgGiBfLiDfOiCmMjDgPjIfOjAoG_xHqqkZx_PID_xZkqqHx_iCpAiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFromPid	:_xZkqqHx_iInKjDkOiMlD_xHqqkZx_PID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwToPid		:_xZkqqHx_iInKjDkOjAoG_xHqqkZx_PID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static void RenameRepairDocData (DWORD dwFromPid, DWORD dwToPid)
{
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDfCiDhDiBfLiBeC_xHqqkZx_
	WString str;
	myLoadRepairDocStr(dwFromPid, str);
	mySaveRepairDocStr(dwToPid, str);
	// _xZkqqHx_iInKjDkOiMlDiCpAiNoNiPjMiBeC_xHqqkZx_
	DeleteRepairDocName(dwFromPid);
} // RenameRepairDocData.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetRepairDocPid
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiCkKjFeLjHhGiCmIjFlGiPjBiCmMjDgPjIfOiDeMiBfLiCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	setdwPid	:_xZkqqHx_jDgPjIfOiDeMiBfL_xHqqkZx_(PID)_xZkqqHx_iCmMiDiKiDfIiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void GetRepairDocPid (DWORDSet& setdwPid)
{
	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJjBfDiDeMiBfLiCpAjHpBiLjDiBeC_xHqqkZx_
	EnumRepairDocPid(setdwPid);
	// _xZkqqHx_jDkPiClGiDeFiDeCiDjDiDgIiDeFiDfOiDeDiDgHiDiLiCpAiOjNiCmCiDeFiDeCiDjDiDgIiDeFiCpAjBfDiCmEjHpBiLjDiBeC_xHqqkZx_
	FCWinTitleRecVector vWinTtl;	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiPfHiNiHiBeC_xHqqkZx_
	EnumWinTitle(vWinTtl);
	//----- _xZkqqHx_jDgPjIfOjBfDiDeMiBfLiCkJiCoHiMlLiNnNiLeOjDkOiClFiCmEiCkCiCoJiDeFiDeCiDjDiDgIiDeFiCpAiPjMiCkN_xHqqkZx_ -----
	FCWinTitleRecVector::iterator iWin;
	for (iWin = vWinTtl.begin(); iWin != vWinTtl.end(); iWin++)
	{
		DWORD dwProcID;	// _xZkqqHx_iDhGiDiNiDfKiDfI_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
		// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkJiCoHiBeBiClLiCoKiCpAiPiKjHeMiClHiCoJiDhGiDiNiDfKiDfIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		(void)GetWindowThreadProcessId((*iWin).hwndApp, &dwProcID);
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfOiClDiCoKiClN_xHqqkZx_PID_xZkqqHx_iCkJiCoHiMlLiNnNiLeOjDkOjCiGiCmM_xHqqkZx_PID_xZkqqHx_iCpAiPjMiCkNiBeC_xHqqkZx_
		setdwPid.erase(dwProcID);
	}
} // GetRepairDocPid.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	BackupRepairDocName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKpJiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiPeDjFjMiPoOjFpBiCkKiBeBiOhHjCoIiClDiCoKiClN_xHqqkZx_PID_xZkqqHx_iCmGiPgEjFkBiClFiCmEiCkCiCoJ_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNiBeBiLeMjIfOiClFiCmEiCkAiCoJiPoOjFpBiCpAiOgHiCoNiCoKiCmEiCkCiCmIiCkCjFmKiCmM_xHqqkZx_PID_xZkqqHx_iCmJiInKjDkOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwPid	:PID_xZkqqHx_iCpAiOhHjCoIiBeCiMlLiNnNiCmM_xHqqkZx_PID_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.02.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void BackupRepairDocName (DWORD dwPid)
{
	// _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	if (dwPid == DWORD(-1)) dwPid = GetCurrentProcessId();
	//----- _xZkqqHx_iKpJiCmJjDkPiDeMiBfLiCmFjDgPjIfOiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	// _xZkqqHx_jDgPjIfOiNmPiCnNiCkJiCmHiCkEiCkJiCpAiKgNjEeGiClHiCoJiClNiCnPiBeBjFlGiOjKjHpBiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
	WString str;
	myLoadRepairDocStr(dwPid, str);
	if (!str.IsEmpty())
	{
		//----- _xZkqqHx_jBePiDgGiBfLiDfOiCmMiInKjDkOiPiIjHjN_xHqqkZx_ -----
		// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCkCiCoJjBfDiDeMiBfLiCpAjHpBiLjDiBeC_xHqqkZx_
		DWORDSet setdwPid;
		EnumRepairDocPid(setdwPid);
		// _xZkqqHx_iLpDiCkLiCmMiDeMiBfLiBgJjDeLjDjGiBgKiCpAjCfEiClHiBeC_xHqqkZx_
		DWORD dwCpyPid;
		for (dwCpyPid = 0; setdwPid.find(dwCpyPid) != setdwPid.end(); dwCpyPid++);
		// _xZkqqHx_iMlLiNnNiCmMiDeMiBfLiCkJiCoHiLpDiCkLiDeMiBfLiCnGiInKjDkOiBeC_xHqqkZx_
		RenameRepairDocData(dwPid, dwCpyPid);
	}
} // BackupRepairDocName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SaveRepairDocName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFnCiPfHjCiGiCmMiDhEiDeAiDeDiDiLjGlMiCmG_xHqqkZx_Undo_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiBeBiLeMjIfOjAoG_xHqqkZx_PID_xZkqqHx_iCpAiOhHjCoI_xHqqkZx_
 *			_xZkqqHx_iClFiCmEiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpDoc	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeCjAfGiLeLiNoMjAkMiOjOiLhJiCnBjGjFiPmBiOjOiCmN_xHqqkZx_
 *					 _xZkqqHx_iLpDjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpFile	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeCjAfGiLeLiNoMjAkMiOjOiLhJiCnBjGjFiPmBiOjOiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpUndo	:Undo_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeCjGjFiPmBiOjOiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwPid	:_xZkqqHx_iLeMjIfOjAoGiCmM_xHqqkZx_PID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiNoMjAkMiOjOiBeFiDeJiBfLiDhGiDjDiOjOiCmJiDhEiDeAiDeDiDiLjGlMiCpAiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiDeOiDiNiBfLiDfJiOjOiCmJiLeMjIfOiCpAjGjFiPmBiClHiCoJiBeCjFnCiPfHiOjOiCmJiJlNiCoHiCkJiCmMjHjNjHfCiCmF_xHqqkZx_
 *			_xZkqqHx_iDeBiDhGiDiKiCkKjCiGjCgGiClFiClNiPoKiNiHiBeBiClBiCmMiDhEiDeAiDeDiDiLjGlMiCpAiMlDiCmJjFjMiLiMiNoMiLmGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SaveRepairDocName (const wchar_t* tcpDoc, const wchar_t* tcpFile, const wchar_t* tcpUndo, DWORD dwPid)
{
	// _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	if (dwPid == DWORD(-1)) dwPid = GetCurrentProcessId();

	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCpAiCfAiCmCiCmJiCnMiCmGiCnPiCoJiBeC_xHqqkZx_
	WString strData;
	FFAppendString(strData, tcpDoc);
	FFAppendString(strData, tcpFile);
	FFAppendString(strData, tcpUndo);
	// _xZkqqHx_iDeMiBfLiCpAiOhHjCoIiClFiBeBjFlGiOjKiDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiBeC_xHqqkZx_
	mySaveRepairDocStr(dwPid, strData);
} // SaveRepairDocName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LoadRepairDocName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjFnCiPfHjCiGiCmMiDhEiDeAiDeDiDiLjGlMiCmG_xHqqkZx_Undo_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strDoc	:_xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCjAfGiLeLiNoMjAkMiOjOiLhJiCnBjGjFiPmBiOjOiCmN_xHqqkZx_
 *					 _xZkqqHx_iLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_NULL_xZkqqHx_iCmIiCoHiCmOjAnNjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *			strFile	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCjAfGiLeLiNoMjAkMiOjOiLhJiCnBjGjFiPmBiOjOiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
 *			strUndo	:Undo_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeCjGjFiPmBiOjOiCmN_xHqqkZx_ _xZkqqHx_iLpDjFlGiOjKiCpAjFnEiClHiBeC_xHqqkZx_
 *					 _xZkqqHx_iCmIiCoHiCmOjAnNjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *			dwPid	:_xZkqqHx_iLeMjIfOjAoGiCmM_xHqqkZx_PID_xZkqqHx_iCpAiOhHjCoIiBeCiMlLiNnNiCmM_xHqqkZx_PID_xZkqqHx_iCmIiCoHiCmO_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *					 _xZkqqHx_iCmIiCoHiCmOjAnNjCoIiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiNoMjAkMiOjOiBeFiDeJiBfLiDhGiDjDiOjOiCmJiDhEiDeAiDeDiDiLjGlMiCpAiDiMiDfHiDfIiDgHiDiKiCmJiLeMjIfOiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iDhEiDeAiDeDiDiLiDeOiDiNiBfLiDfJiOjOiCmJiLeMjIfOiCpAjGjFiPmBiClHiCoJiBeCjFnCiPfHiOjOiCmJiJlNiCoHiCkJiCmMjHjNjHfCiCmF_xHqqkZx_
 *			_xZkqqHx_iDeBiDhGiDiKiCkKjCiGjCgGiClFiClNiPoKiNiHiBeBiClBiCmMiDhEiDeAiDeDiDiLjGlMiCpAiMlDiCmJjFjMiLiMiNoMiLmGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.22 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void LoadRepairDocName (WString* strDoc, WString* strFile, WString* strUndo, DWORD dwPid)
{
	// _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	if (dwPid == DWORD(-1)) dwPid = GetCurrentProcessId();
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCpAiOoGjDlOiBeC_xHqqkZx_
	WString strData;
	myLoadRepairDocStr(dwPid, strData);

	// _xZkqqHx_jDgPjIfOiClDiCoKiCmEiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (strData.IsEmpty())
	{
		if (strDoc != NULL) strDoc->Empty();
		if (strFile != NULL) strFile->Empty();
		if (strUndo != NULL) strUndo->Empty();
		return;
	}
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCpAiKgFjFlGiOjKjHpBiCmJjFkKiJpAiBeC_xHqqkZx_
	if (strDoc != NULL) *strDoc = FFExtractString(strData);
	if (strFile != NULL) *strFile = FFExtractString(strData);
	if (strUndo != NULL) *strUndo = FFExtractString(strData);
} // LoadRepairDocName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DeleteRepairDocName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PID_xZkqqHx_iCpAiDeMiBfLiCmJiDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiClDiCoKiClNjFlGiOjKiDgGiBfLiDfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwPid	:_xZkqqHx_jGjFiPmBiClHiCoJiDgGiBfLiDfOiCmMiDeMiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void DeleteRepairDocName (DWORD dwPid)
{
	// _xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDiBiDeDiDjDiDeFiDeCiDjDiDgIiDeFiCmMiDgOiDjDiDgIiDiLiCpAiOoGjDlOiBeC_xHqqkZx_
	if (dwPid == DWORD(-1)) dwPid = GetCurrentProcessId();
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHiNoNiPjMiBeC_xHqqkZx_
	mySaveRepairDocStr(dwPid, NULL);
} // DeleteRepairDocName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PushRepairFileStack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCmJiDhEiDeAiDeDiDiLjGlMiCpAjAmPiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpFile	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void PushRepairFileStack (const wchar_t* tcpFile)
{
	WString strStack;
	myLoadFileStack(strStack);
	FFInsTopString(strStack, tcpFile);
	mySaveFileStack(strStack);
} // PushRepairFileStack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SeeRepairFileStack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCmMiPoDiCmMiDhEiDeAiDeDiDiLjGlMiCpAiMkJiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pStrFile0	:_xZkqqHx_iIoKjEnEiPoDiCmMiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			pStrFile1	:_xZkqqHx_iCfBjEnEjGnKiCmMiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *			pStrFile2	:_xZkqqHx_iCfCjEnEjGnKiCmMiDhEiDeAiDeDiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFnEiClHiDhEiDeAiDeDiDiLjGlMiCmMjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int SeeRepairFileStack (WString* pStrFile0, WString* pStrFile1, WString* pStrFile2)
{
	WString strStack;
	myLoadFileStack(strStack);
	int iCount = 0;
	if (strStack.IsEmpty() || pStrFile0 == NULL) return iCount;
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCmMiNmFiPiJiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	*pStrFile0 = FFExtractString(strStack);
	iCount++;
	if (strStack.IsEmpty() || pStrFile1 == NULL) return iCount;
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCmMiNmFiPiJiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	*pStrFile1 = FFExtractString(strStack);
	iCount++;
	if (strStack.IsEmpty() || pStrFile2 == NULL) return iCount;
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCmMiNmFiPiJiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	*pStrFile2 = FFExtractString(strStack);
	iCount++;
	return iCount;
} // SeeRepairFileStack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	PopRepairFileStack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCmMiIoKjEnEiPoDiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGiCoIiPjMiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfIiDfOiDgCiDeOiCmJiDhEiDeAiDeDiDiLjGlMiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL PopRepairFileStack ()
{
	WString strStack;
	myLoadFileStack(strStack);
	if (strStack.IsEmpty()) return FALSE;
	// _xZkqqHx_jFlGiOjKiDgGiBfLiDfOiCmMiNmFiPiJiCmMjFlGiOjKjHpBiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
	(void)FFExtractString(strStack);
	mySaveFileStack(strStack);
	return TRUE;
} // PopRepairFileStack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DeleteRepairFileStack
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjCiGiCmMiPeDjFjMiDhEiDeAiDeDiDiLiDfIiDfOiDgCiDeOiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void DeleteRepairFileStack ()
{
	// _xZkqqHx_iDgGiBfLiDfOiCpAiNoNiPjMiBeC_xHqqkZx_
	mySaveFileStack(NULL);
} // DeleteRepairFileStack.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SaveRepairFilePtr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiPeDjFjMjCiGiCmMiBeBiChEiCiOiCiEiCiPiDhEiDeAiDeDiDiLiCmMiMlLiNnNiImKjChFiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fliPtr	:Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiMlLiNnNiImKjChFiCpAiOhHjCoIiBeCjCgMiCpAiDeOiDiKiDeBiClHiCoJiOjOiCmN_xHqqkZx_
 *					 DWORD(-1)_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCoAiClFiBeBiPeDjFjMjCiGiCmJiDeHiDiJiBfLiCmFjHiOiClPiClNiPoKiNiHiBeBiClBiCmMjCgMiCnMiCmFiCmNiPeDjFjMiJmCjEfMiClOiCmG_xHqqkZx_
 *			_xZkqqHx_iCkCiCkEiClBiCmGiCkKiCoNiCkJiCoJiCmMiCmFiBeBiOjPiCmMiPeDjFjMiCmNiClBiCmMjCgMiCnMiCmFiCmFiPeJiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.01.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//void SaveRepairFilePtr (DWORD dwPtr)
void SaveRepairFilePtr (flint fliPtr)
{
	// _xZkqqHx_iDeMiBfLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	// _xZkqqHx_jAjEiOjKiCpAiDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
//----- 02.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	FFGetApp()->WriteProfileInt(strSect, _T("FilePtr"), int(dwPtr));
//----- 02.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	FFGetApp()->WriteProfileStringW(strSect, L"FilePtr",
									_i64towcs(fliPtr, 10));
//----- 02.01.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // SaveRepairFilePtr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LoadRepairFilePtr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiPeDjFjMjCiGiCmMiBeBiChEiCiOiCiEiCiPiDhEiDeAiDeDiDiLiCmMiMlLiNnNiImKjChFiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Undo_xZkqqHx_iDhEiDeAiDeDiDiLiCmMiMlLiNnNiImKjChFiCpAjFnEiClHiBeCiPiJiKpKjCgMiCmN_xHqqkZx_flint(-1)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iCoAiClFiBeBiPeDjFjMjCiGiCmJiDeHiDiJiBfLiCmFjHiOiClPiClNiPoKiNiHiBeBiClBiCmMjCgMiCnMiCmFiCmNiPeDjFjMiJmCjEfMiClOiCmG_xHqqkZx_
 *			_xZkqqHx_iCkCiCkEiClBiCmGiCkKiCoNiCkJiCoJiCmMiCmFiBeBiOjPiCmMiPeDjFjMiCmNiClBiCmMjCgMiCnMiCmFiCmFiPeJiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
// 02.01.25 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//DWORD LoadRepairFilePtr ()
flint LoadRepairFilePtr ()
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	// _xZkqqHx_jAjEiOjKiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	return _wcstoi64(FFGetApp()->GetProfileStringW(strSect, L"FilePtr", L"-1"),
					NULL, 10);
} // LoadRepairFilePtr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DeleteRepairFilePtr
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	PID_xZkqqHx_iCpAiDeMiBfLiCmJiDiMiDfHiDfIiDgHiDiKiCmJjDgPjIfOiClDiCoKiClNjAjEiOjKiDgGiBfLiDfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void DeleteRepairFilePtr ()
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	//  _xZkqqHx_iDgGiBfLiDfOiCpAiNoNiPjMiBeC_xHqqkZx_
	FFGetApp()->WriteProfileStringW(strSect, L"FilePtr", NULL);
} // DeleteRepairFilePtr.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SaveRepairMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiPeDjFjMiDfOiDfIiDeOiCmMiPeDjFjMiMiLiJmKiDiBiDgCiDfKiBfLiDfHiCpAiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpMsg	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SaveRepairMessage (const wchar_t* tcpMsg)
{
	// _xZkqqHx_iDeMiBfLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmJiPjBiCkLiNjOiCnOiBeC_xHqqkZx_
	FFGetApp()->WriteProfileStringW(strSect, L"Message", tcpMsg);
} // SaveRepairMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	LoadRepairMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiPeDjFjMiDfOiDfIiDeOiCmMiPeDjFjMiMiLiJmKiDiBiDgCiDfKiBfLiDfHiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strMsg	:_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void LoadRepairMessage (WString& strMsg)
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	strMsg = FFGetApp()->GetProfileStringW(strSect, L"Message");
} // LoadRepairMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DeleteRepairMessage
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiPeDjFjMiDfOiDfIiDeOiCmMiPeDjFjMiMiLiJmKiDiBiDgCiDfKiBfLiDfHiCpAiPmBiLiOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void DeleteRepairMessage ()
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	//  _xZkqqHx_iDgGiBfLiDfOiCpAiNoNiPjMiBeC_xHqqkZx_
	FFGetApp()->WriteProfileStringW(strSect, L"Message", NULL);
} // DeleteRepairMessage.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetRepairFileProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKjBkOiClHiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDiLiDhAiDfIiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiPeDjFjMiCmFiCmMiCnNiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpPrjPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDiLiDhAiDfIjGlMiCpAiOhHjCoIiBeC_xHqqkZx_NULL_xZkqqHx_iCpAiOhHjCoIiClHiCoJiCmG_xHqqkZx_
 *						 _xZkqqHx_jDgPjIfOiDhEiDeAiDeDiDiLiDhAiDfIiCkKjGjFiPmBiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void SetRepairFileProject (const wchar_t* tcpPrjPath)
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	//  _xZkqqHx_iDgGiBfLiDfOiCpAjAnNjCoIiBeC_xHqqkZx_
	FFGetApp()->WriteProfileStringW(strSect, L"ProjectPath", tcpPrjPath);
} // SetRepairFileProject.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetRepairFileProject
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeDjFjMiDhEiDeAiDeDiDiLiCkKjBkOiClHiCoJiDhGiDiNiDfHiDeGiDeOiDgHiCmMiDhEiDiLiDhAiDfIiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jHjKjHpAjFlGiPjBiCmMiPeDjFjMiCmFiCmMiCnNiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	strPrjPath	:_xZkqqHx_iDhGiDiNiDfHiDeGiDeOiDgHiDhEiDiLiDhAiDfIjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.05.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void GetRepairFileProject (WString& strPrjPath)
{
	WString strSect;
	strSect.Format(L"%s\\%s", GetLocalAppName(), L"RepairInfo");
	// _xZkqqHx_iDgGiBfLiDfOiCpAiDiMiDfHiDfIiDgHiDiKiCkJiCoHjDmHiCnNiPgPiClHiBeC_xHqqkZx_
	strPrjPath = FFGetApp()->GetProfileStringW(strSect, L"ProjectPath");
} // GetRepairFileProject.

