#include "stdafx.h"
#include "UtilErr.h"		// For CFCDDFileException.
#include "UtilFile.h"		// For BYTEVector <<.
#include "UndoArchive.h"	// For FCUndoArchive.
#include "UtilVersion.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iDhHiDgCiDfPiDhEiDeAiDeDiDiLiMgAiOkO_xHqqkZx_>
 *
 *	CLSID/CLSID
 *	"MolipDraw.exe"/String
 *	_xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjD_xHqqkZx_/WORD  Major 5bit, Minor 5bit, LevelA 4bit, LevelB 2bit
 *	_xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiA_xHqqkZx_/BYTE  FDPL_WINDOWS
 *	_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhG_xHqqkZx_/BYTE  FD_DTP_STANDARD_FORMAT/FD_DTP_PORTABLE_FORMAT/FD_DTP_TEMPLATE_FORMAT
 *	_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjD_xHqqkZx_/WORD  Major 8bit, Minor 8bit
 *	_xZkqqHx_iNoMjAkMjDpK_xHqqkZx_/time_t
 *	_xZkqqHx_iNfIjAfGjDpK_xHqqkZx_/time_t
 *************************************************************************/

// _xZkqqHx_iClBiCmMjGlMjBePiCmNjFmPiNfIiClFiCmEiCmIiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
static const char*		s_cpAppName = "MolipDraw.exe";
static const long		s_szAppName = strlen(s_cpAppName);

//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//// 06.03.05 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
////static const wchar_t*	s_wcpAppVersion = L"4.0 A1";
//static const wchar_t*	s_wcpAppVersion = L"4.0 A1 Beta 7";
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// 06.05.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//static const wchar_t*	s_wcpAppBeta = L"Beta9";
static const wchar_t*	s_wcpAppBeta = L"";
static WString			s_wstrAppVersion;
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

//----- 06.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//static const WORD		s_wAppMajorVer = 4;				// [0 - 31]
//static const WORD		s_wAppMinorVer = 0;				// [0 - 31]
//static const char		s_acAppLevelA = L'A';			// [A - P]
//static const char		s_acAppLevelB = L'1';			// [1 - 4]
//----- 06.05.02 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDhEiDeAiDeDiDiLiMgAiOkOiCmMiDgPiBfLiDfHiDiHiDjDiBeCiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDiCmGjDkPiClGiCmGiCmNiMmAiCoHiCmIiCkCiBeC_xHqqkZx_
static const wchar_t*	s_tcpMolipDrawFileVersion = L"4.0";
static const WORD		s_wMolipDrawFileMajorVer = 4;	// [0 - 255]
static const WORD		s_wMolipDrawFileMinorVer = 0;	// [0 - 255]

// _xZkqqHx_iClBiCmM_xHqqkZx_ ID _xZkqqHx_iCmNiBeBiPiJjBoDiCmM_xHqqkZx_MolipDraw(FastDraw)_xZkqqHx_iNoMjAkMiOjOiCmJjAlGjAkMiClDiCoKiCnMiClFiClNiBeC_xHqqkZx_
// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCkKiPoDiCkKiCmBiCmEiCoAjFmPiNfIiClFiCmEiCmNiCkCiCkPiCnMiClJiCpBiBeC_xHqqkZx_

// {DC96FFA0-119F-11D0-B80C-444553540000}
static const CLSID s_clsid =
{ 0xdc96ffa0, 0x119f, 0x11d0, { 0xb8, 0xc, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0 } };

/////////////////////////////////////////////////////////////////////////////
// FCHeaderInf_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::FCHeaderInf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCmMiNfMjChKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCHeaderInf::FCHeaderInf ()
{
	Init();
	// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	InitCreateTime();
} // FCHeaderInf::FCHeaderInf.

//----- 02.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCpAiPmBiLiOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::Clear ()
{
//----- 03.07.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiPmBiLiOiBeC_xHqqkZx_
//	m_szAppName[0] = '\0';
//----- 03.07.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	m_wAppVersion = WORD(-1);
	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiBeC_xHqqkZx_
	m_byPlatform = BYTE(-1);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_
	m_byFileType = FD_DTP_NONE;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	m_wFileVersion = WORD(-1);
	// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
	m_tmUpdate = 0;
	// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	m_tmCreate = 0;
} // FCHeaderInf::Clear.
//----- 02.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::Init
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCpAiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiClFiCmEiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wFileType	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeCiImIiJlKiCmMjAjEjCgMiCmMiCkCiClIiCoKiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_DTP_STANDARD_FORMAT	:_xZkqqHx_iDiCiDiKiDhGiDgIiDiNiBfLiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *				FD_DTP_PORTABLE_FORMAT	:_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *				FD_DTP_TEMPLATE_FORMAT	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *				FD_DTP_WORK_FORMAT		:_xZkqqHx_iDiPiBfLiDeOiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::Init ()
{
//----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	m_szAppName[0] = '\0';
//	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//	m_wAppVersion = WORD(-1);
//	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiBeC_xHqqkZx_
//	m_byPlatform = BYTE(-1);
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_
//	m_byFileType = BYTE(-1);
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//	m_wFileVersion = WORD(-1);
//	// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
//	m_tmUpdate = 0;
//	// _xZkqqHx_iNoMjAkMjDpKiOjOiCmNiPiJiKpKiJlLiClFiCmIiCkCiBeC_xHqqkZx_
//----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 03.07.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
//	strcpy(m_szAppName, s_cpAppName);
//----- 03.07.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	m_wAppVersion = GetStcAppVersion();
	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiBeC_xHqqkZx_
	m_byPlatform = BYTE(FDPL_WINDOWS);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_
	m_byFileType = BYTE(FD_DTP_STANDARD_FORMAT);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	m_wFileVersion = GetStcFileVersion();
	// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
	m_tmUpdate = 0;
	// _xZkqqHx_iNoMjAkMjDpKiOjOiCmNiPiJiKpKiJlLiClFiCmIiCkCiBeC_xHqqkZx_
//----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHeaderInf::Init.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::InitCreateTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoMjAkMiOjOiKnEiCpAiMlLiNnNiOjOiKnEiCmJiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::InitCreateTime ()
{
	// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	m_tmCreate = CTime::GetCurrentTime().GetTime();
} // FCHeaderInf::InitCreateTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnNjHhAiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::InStream (FCUndoArchive& ar)
{
	//----- CLSID_xZkqqHx_iCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	CLSID clsid;
	ar.Read(&clsid, sizeof(CLSID));
	if (::memcmp(&s_clsid, &clsid, sizeof(s_clsid)))
	{
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	}
	//----- _xZkqqHx_iDeBiDhGiDiKjGlMiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	WORD wStrLen;
	ar >> wStrLen;
	if (FD_MAX_APP_NAME < wStrLen)
	{
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	}
	// _xZkqqHx_iDeBiDhGiDiKjGlMiBeC_xHqqkZx_
	char szAppName[FD_MAX_APP_NAME + 1];
	ar.Read(szAppName, wStrLen);
	szAppName[wStrLen] = '\0';
	if (strcmp(szAppName, s_cpAppName) != 0)
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar >> m_wAppVersion;
	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar >> m_byPlatform;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar >> m_byFileType;
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar >> m_wFileVersion;
	// _xZkqqHx_iNoMjAkMjDpKiOjOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar >> m_tmCreate;
	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar >> m_tmUpdate;
} // FCHeaderInf::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pData	:_xZkqqHx_jDmHiCnNiNjOiCnNjHhAiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::InStream (const BYTE*& pData)
{
	//----- CLSID_xZkqqHx_iCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	CLSID clsid;
	::FFReadData(clsid, pData);
	if (::memcmp(&s_clsid, &clsid, sizeof(s_clsid)))
	{
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	}
	//----- _xZkqqHx_iDeBiDhGiDiKjGlMiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	WORD wStrLen;
	::FFReadData(wStrLen, pData);
	if (FD_MAX_APP_NAME < wStrLen)
	{
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	}
	// _xZkqqHx_iDeBiDhGiDiKjGlMiBeC_xHqqkZx_
	char szAppName[FD_MAX_APP_NAME + 1];
	::FFReadStream(pData, szAppName, wStrLen);
	szAppName[wStrLen] = '\0';
	if (strcmp(szAppName, s_cpAppName) != 0)
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	::FFReadData(m_wAppVersion, pData);
	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	::FFReadData(m_byPlatform, pData);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	::FFReadData(m_byFileType, pData);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	::FFReadData(m_wFileVersion, pData);
	// _xZkqqHx_iNoMjAkMjDpKiOjOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	::FFReadData(m_tmCreate, pData);
	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	::FFReadData(m_tmUpdate, pData);
} // FCHeaderInf::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	file	:_xZkqqHx_jDmHiCnNiNjOiCnNjHhAiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.31 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::InStream (CFile& file)
{
	//----- CLSID_xZkqqHx_iCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	CLSID clsid;
	file.Read(&clsid, sizeof(CLSID));
	if (::memcmp(&s_clsid, &clsid, sizeof(s_clsid)))
	{
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	}
	//----- _xZkqqHx_iDeBiDhGiDiKjGlMiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	WORD wStrLen;
	file.Read(&wStrLen, sizeof(wStrLen));
	if (FD_MAX_APP_NAME < wStrLen)
	{
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	}
	// _xZkqqHx_iDeBiDhGiDiKjGlMiBeC_xHqqkZx_
	char szAppName[FD_MAX_APP_NAME + 1];
	file.Read(szAppName, wStrLen);
	szAppName[wStrLen] = '\0';
	if (strcmp(szAppName, s_cpAppName) != 0)
		AfxThrowArchiveException(CArchiveException::badIndex, NULL);
	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	file.Read(&m_wAppVersion, sizeof(m_wAppVersion));
	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	file.Read(&m_byPlatform, sizeof(m_byPlatform));
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	file.Read(&m_byFileType, sizeof(m_byFileType));
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	file.Read(&m_wFileVersion, sizeof(m_wFileVersion));
	// _xZkqqHx_iNoMjAkMjDpKiOjOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	file.Read(&m_tmCreate, sizeof(m_tmCreate));
	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	file.Read(&m_tmUpdate, sizeof(m_tmUpdate));
} // FCHeaderInf::InStream.

//----- 02.05.30 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::OutStream
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHeaderInf::OutStream (FCUndoArchive& ar) const
//{
//	// CLSID_xZkqqHx_iCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	ar.Write(&s_clsid, sizeof(s_clsid));
//	//----- _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
//	WORD wStrLen = strlen(m_szAppName);
//	ar << wStrLen;
//	ar.Write(m_szAppName, wStrLen);
//	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	ar << m_wAppVersion;
//	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	ar << m_byPlatform;
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	ar << m_byFileType;
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	ar << m_wFileVersion;
//	// _xZkqqHx_iNoMjAkMjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	ar << m_tmCreate;
////----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
////	ar << m_tmUpdate;
////----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	time_t tmUpdate = CTime::GetCurrentTime().GetTime();
//	ar << tmUpdate;
////----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCHeaderInf::OutStream.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::OutStream
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiDgGiBfLiDfOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vByteStream	:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiDfIiDgHiDiKiBfLiDiAiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHeaderInf::OutStream (BYTEVector& vByteStream) const
//{
//	// CLSID_xZkqqHx_iCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	vByteStream << s_clsid;
//	//----- _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
//	WORD wStrLen = strlen(m_szAppName);
//	vByteStream << wStrLen;
//	FFWriteStream(vByteStream, m_szAppName, wStrLen);
//	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	vByteStream << m_wAppVersion;
//	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	vByteStream << m_byPlatform;
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	vByteStream << m_byFileType;
//	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	vByteStream << m_wFileVersion;
//	// _xZkqqHx_iNoMjAkMjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	vByteStream << m_tmCreate;
////----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
////	vByteStream << m_tmUpdate;
////----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
//	time_t tmUpdate = CTime::GetCurrentTime().GetTime();
//	vByteStream << tmUpdate;
////----- 01.08.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//} // FCHeaderInf::OutStream.
//----- 02.05.30 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::OutStreamCurrent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wFileType	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeCiImIiJlKiCmMjAjEjCgMiCmMiCkCiClIiCoKiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_DTP_STANDARD_FORMAT	:_xZkqqHx_iDiCiDiKiDhGiDgIiDiNiBfLiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *				FD_DTP_PORTABLE_FORMAT	:_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *				FD_DTP_TEMPLATE_FORMAT	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *				FD_DTP_WORK_FORMAT		:_xZkqqHx_iDiPiBfLiDeOiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::OutStreamCurrent (FCUndoArchive& ar, WORD wFileType) const
{
	// CLSID_xZkqqHx_iCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
// 03.05.18 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ (_xZkqqHx_iDfCiDjDiDhNiCmFiDgGiBfLiDfOiCkKiInJiPoNiCmJiCmIiCoJiDgPiDeP_xHqqkZx_)
//	ar.Write(&s_clsid, sizeof(s_clsid));
	ar << s_clsid;
	//----- _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	const WORD wStrLen = WORD(strlen(s_cpAppName));
	ar << wStrLen;
	ar.Write(s_cpAppName, wStrLen * sizeof(s_cpAppName[0]));
	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar << GetStcAppVersion();
	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar << BYTE(FDPL_WINDOWS);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar << BYTE(wFileType);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar << GetStcFileVersion();
	// _xZkqqHx_iNoMjAkMjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar << m_tmCreate;
	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar << CTime::GetCurrentTime().GetTime();
} // FCHeaderInf::OutStreamCurrent.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::OutStreamCurrent
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vData		:_xZkqqHx_iPjBiCkLiPgPiClFjHhAiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wFileType	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeCiImIiJlKiCmMjAjEjCgMiCmMiCkCiClIiCoKiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_DTP_STANDARD_FORMAT	:_xZkqqHx_iDiCiDiKiDhGiDgIiDiNiBfLiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *				FD_DTP_PORTABLE_FORMAT	:_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
 *				FD_DTP_TEMPLATE_FORMAT	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiBeC_xHqqkZx_
 *				FD_DTP_WORK_FORMAT		:_xZkqqHx_iDiPiBfLiDeOiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::OutStreamCurrent (BYTEVector& vData, WORD wFileType) const
{
	// CLSID_xZkqqHx_iCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	vData << s_clsid;
	//----- _xZkqqHx_iDeBiDhGiDiKjGlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	const WORD wStrLen = WORD(strlen(s_cpAppName));
	vData << wStrLen;
	::FFWriteStream(vData, s_cpAppName, wStrLen * sizeof(s_cpAppName[0]));
	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	vData << GetStcAppVersion();
	// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	vData << BYTE(FDPL_WINDOWS);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	vData << BYTE(wFileType);
	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	vData << GetStcFileVersion();
	// _xZkqqHx_iNoMjAkMjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	vData << m_tmCreate;
	// _xZkqqHx_iNfIjAfGjDpKiOjOiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	vData << CTime::GetCurrentTime().GetTime();
} // FCHeaderInf::OutStreamCurrent.

//----- 01.01.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::SetFileType
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wFileType	:_xZkqqHx_iDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHeaderInf::SetFileType (WORD wFileType)
//{
//	m_byFileType = wFileType;
//} // FCHeaderInf::SetFileType.
//----- 01.01.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetCreateTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCkJiCoHiBeBiDhEiDeAiDeDiDiLiNoMjAkMjDpKiOjOiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiNoMjAkMjDpKiOjOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
time_t FCHeaderInf::GetCreateTime () const
{
	return m_tmCreate;
} // FCHeaderInf::GetCreateTime.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetUpdateTime
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCkJiCoHiBeBiDhEiDeAiDeDiDiLiNfIjAfGjDpKiOjOiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiNfIjAfGjDpKiOjOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
time_t FCHeaderInf::GetUpdateTime () const
{
	return m_tmUpdate;
} // FCHeaderInf::GetUpdateTime.

//----- 03.07.26 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetAppName
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNjFlGiPjBiCmMiDeBiDhGiDiKjGlMiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKjGlMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//const char* FCHeaderInf::GetAppName () const
//{
//	return m_szAppName;
//} // FCHeaderInf::GetAppName.
//----- 03.07.26 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 02.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetFileType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNjFlGiPjBiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	FD_DTP_NONE		:_xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
 *			FD_DTP_STANDARD_FORMAT	:Molip Draw _xZkqqHx_iDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *			FD_DTP_PORTABLE_FORMAT	:_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *			FD_DTP_TEMPLATE_FORMAT	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *			FD_DTP_WORK_FORMAT		:_xZkqqHx_iDiPiBfLiDeOiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
// *			FDFL_HISTDRAW	:Historic Draw _xZkqqHx_jHjKjHpAjFlGiPjBiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCHeaderInf::GetFileType () const
{
	return m_byFileType;
} // FCHeaderInf::GetFileType.
//----- 02.05.30 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeIiDiLiDfPjDoAiCmFiJeFiDeOiDiKiDgCiDeOiDiBiDgKiDiFiBfLiCkJiCoHjAfGiLeLiNoMjAkMiClFiClNiBhF_xHqqkZx_Dynamic Draw Document_xZkqqHx_iBhGiCmJiJlNiCkJiCpAjFgAiClBiCkEiCmGiClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::SetFileType
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNjFlGiPjBiCmMiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wFileType	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *				FD_DTP_NONE		:_xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
 *				FD_DTP_STANDARD_FORMAT	:Molip Draw _xZkqqHx_iDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *				FD_DTP_PORTABLE_FORMAT	:_xZkqqHx_iDfIiDhMiDgCiDgHiDgFiBfLiDhFiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *				FD_DTP_TEMPLATE_FORMAT	:_xZkqqHx_iDgFiDjDiDhGiDiMiBfLiDgHiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *				FD_DTP_WORK_FORMAT		:_xZkqqHx_iDiPiBfLiDeOiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::SetFileType (WORD wFileType)
{
	m_byFileType = wFileType;
} // FCHeaderInf::SetFileType.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::RegalCheck
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiPoOjFpBiCkKiBeBiClBiCmMiDeBiDhGiDiKiCmMiPoOjFpBiCmGiIoKjChGiClHiCoJiCkJiCmHiCkEiCkJiCpAiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wFileTypeN	:_xZkqqHx_iDgAiDeGiDgCiDeOiClHiCoJiDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iIoKjChGiClFiCmIiCkCiPoKiNiHiCmNiBeBjHoBiKePiCpAjEkNjAlGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::RegalCheck (	WORD wFileType1,
								WORD wFileType2,
								WORD wFileType3,
								WORD wFileType4) const
{
	// _xZkqqHx_iDeHiDiJiBfLiBhFiDhEiDeAiDeDiDiLiMgAiOkOiCkKiIoBiCkCiCnMiClHiBhGiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
	if (m_byPlatform != FDPL_WINDOWS)
		FFThrowDDFileException(IDS_ERR_FILE_WRONG_FORM, L"");

	// _xZkqqHx_iDeHiDiJiBfLiBhFiDhEiDeAiDeDiDiLiMgAiOkOiCkKiIoBiCkCiCnMiClHiBhGiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
//----- 03.05.19 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_iDfCiDjDiDhNiCmFiDgGiBfLiDfOiCkKiInJiPoNiCmJiCmIiCoJiDgPiDeP_xHqqkZx_)-----
//	if (m_byFileType != wFileType)
//		FFThrowDDFileException(IDS_ERR_FILE_WRONG_FORM, L"");
//----- 03.05.19 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_iDfCiDjDiDhNiCmFiDgGiBfLiDfOiCkKiInJiPoNiCmJiCmIiCoJiDgPiDeP_xHqqkZx_)-----
	if (m_byFileType == FD_DTP_NONE)
		FFThrowDDFileException(IDS_ERR_FILE_WRONG_FORM, L"");
	if (m_byFileType != wFileType1 &&
		m_byFileType != wFileType2 &&
		m_byFileType != wFileType3 &&
		m_byFileType != wFileType4)
		FFThrowDDFileException(IDS_ERR_FILE_WRONG_FORM, L"");
//----- 03.05.19 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_iDfCiDjDiDhNiCmFiDgGiBfLiDfOiCkKiInJiPoNiCmJiCmIiCoJiDgPiDeP_xHqqkZx_)-----
	// _xZkqqHx_iDeHiDiJiBfLiBhFiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCkKiIoBiCkCiCnMiClHiBhGiCpAiDfIiDiNiBfLiBeC_xHqqkZx_
//----- 01.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if (m_wFileVersion != GetStcFileVersion())
//		FFThrowDDFileException(IDS_ERR_FILE_WRONG_VERSION, L"");
//----- 01.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (m_wFileVersion != GetStcFileVersion())
	{
		WString strVersion;
		strVersion.Format(L"Version %s",
						(const wchar_t*)FileVersionToString(m_wFileVersion));
		FFThrowDDFileException(IDS_ERR_FILE_WRONG_VERSION, strVersion);
	}
//----- 01.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHeaderInf::RegalCheck.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetFileVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDmHiCnNiNjOiCnMiCoKiClNiBeBiMlLiNnNiCmMiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCHeaderInf::GetFileVersion () const
{
	return m_wFileVersion;
} // FCHeaderInf::GetFileVersion.

//----- 03.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetRelativeVersion
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgPiBfLiDfOiMgPjHfCiCmFjDmHiCnNiPjBiCkLiClDiCoKiClNiKnGiMfHiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKnGiMfHiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//WString FCHeaderInf::GetRelativeVersion () const
//{
//	return m_wstrRelativeVersion;
//} // FCHeaderInf::GetRelativeVersion.
//
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::SetRelativeVersion
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgPiBfLiDfOiMgPjHfCiCmFjDmHiCnNiPjBiCkLiClDiCoKiClNiKnGiMfHiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpA_xHqqkZx_
// *			_xZkqqHx_jAnNjCoIiClHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wstrVersion	:_xZkqqHx_iKnGiMfHiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.05.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//void FCHeaderInf::SetRelativeVersion (const wchar_t* wstrVersion)
//{
//	m_wstrRelativeVersion = wstrVersion;
//} // FCHeaderInf::SetRelativeVersion.
//----- 03.06.08 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	operator =
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPoOjFpBiCpAiDfCiDhDiBfLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	inf	:_xZkqqHx_iDfCiDhDiBfLiMlDiCmMiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::operator = (const FCHeaderInf& inf)
{
// 03.07.26 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	strcpy(m_szAppName, inf.m_szAppName);	// _xZkqqHx_iDeBiDhGiDiKjGlMiBeC_xHqqkZx_
	m_wAppVersion	= inf.m_wAppVersion;	// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	m_byPlatform	= inf.m_byPlatform;		// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiBeC_xHqqkZx_
	m_byFileType	= inf.m_byFileType;		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_
	m_wFileVersion	= inf.m_wFileVersion;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
	m_tmCreate		= inf.m_tmCreate;		// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
	m_tmUpdate		= inf.m_tmUpdate;		// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
// 03.06.08 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_wstrRelativeVersion = inf.m_wstrRelativeVersion;	// _xZkqqHx_iDfCiDjDiDgPiBfLiDfOiMgPjHfCiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
} // FCHeaderInf::operator = (const FCHeaderInf& inf).

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStcCLSID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDhHiDgCiDfPiCmJiLeMjIfOiClDiCoKiCoJ_xHqqkZx_CLSID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	CLSID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjCgMiCmNiBeBiDhHiDgCiDfPjAoGjDkKiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeCiDgPiBfLiDfHiDiHiDjDiCmJiCoGiCmBiCmE_xHqqkZx_
 *			_xZkqqHx_jFmPiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const CLSID& FCHeaderInf::GetStcCLSID ()
{
	return s_clsid;
} // FCHeaderInf::GetStcCLSID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStcAppName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDhHiDgCiDfPiCmJiLeMjIfOiClDiCoKiCoJiDeBiDhGiDiKjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeBiDhGiDiKjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iClBiCmMjCgMiCmNiBeBiDhHiDgCiDfPiCmJiLeMjIfOiClDiCoKiCmEiCkCiCoJiBeCiDgPiBfLiDfHiDiHiDjDiCmJiCoGiCmBiCmE_xHqqkZx_
 *			_xZkqqHx_jFmPiCoJiClBiCmGiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const char* FCHeaderInf::GetStcAppName ()
{
	return s_cpAppName;
} // FCHeaderInf::GetStcAppName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::FileVersionToString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiBeBjBmOiJjOiClHiCoJjFlGiOjKjHpBiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wVersion	:_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.08.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHeaderInf::FileVersionToString (WORD wVersion)
{
	union {
		WORD	wVersion;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		struct {
//----- 00.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			WORD	wMajor	: 8;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//			WORD	wMinor	: 8;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//----- 00.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			WORD	wMinor	: 8;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
			WORD	wMajor	: 8;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//----- 00.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		};
	} ver;
	ver.wVersion = wVersion;
	WString strVersion;
	if (ver.wMajor == 0 && ver.wMinor == 0)
		strVersion = L"1.0";
	else
	if (ver.wMajor == 0 && ver.wMinor == 2)
		strVersion = L"2.0";
	else
		strVersion.Format(L"%d.%d", ver.wMajor, ver.wMinor);
	return strVersion;
} // FCHeaderInf::FileVersionToString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStcAppVersionString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiBeCjHoBiBeG_xHqqkZx_"3.0 A1"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FCHeaderInf::GetStcAppVersionString ()
{
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return s_wcpAppVersion;
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (s_wstrAppVersion.empty())
	{
		if (s_wcpAppBeta == NULL || s_wcpAppBeta[0] == L'\0')
			s_wstrAppVersion.Format(L"%d.%d %c%c %s",
									FD_APP_MAJOR_VER,
									FD_APP_MINOR_VER,
									FD_APP_LEVEL_A,
									FD_APP_LEVEL_B,
									FD_APP_IS_UNICODE);
		else
			s_wstrAppVersion.Format(L"%d.%d %c%c %s %s",
									FD_APP_MAJOR_VER,
									FD_APP_MINOR_VER,
									FD_APP_LEVEL_A,
									FD_APP_LEVEL_B,
									FD_APP_IS_UNICODE,
									s_wcpAppBeta);
	}
	return s_wstrAppVersion.c_str();
//----- 06.05.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // FCHeaderInf::GetStcAppVersionString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStcAppMajorMinorString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCmMiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiBgJiDiBiDfHiDiDiBfL_xHqqkZx_._xZkqqHx_iDhNiDeDiDgJiBfLiBgKiCpA_xHqqkZx_
 *			_xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDfHiDiDiBfL_xHqqkZx_._xZkqqHx_iDhNiDeDiDgJiBfLiBeCjHoBiBeG_xHqqkZx_"3.0"
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString FCHeaderInf::GetStcAppMajorMinorString ()
{
	WString str;
	str.Format(L"%d.%d", FD_APP_MAJOR_VER, FD_APP_MINOR_VER);
	return str;
} // FCHeaderInf::GetStcAppMajorMinorString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStcFileVersionString
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmM_xHqqkZx_Molip Draw_xZkqqHx_iCmMiDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wFileType	:_xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* FCHeaderInf::GetStcFileVersionString ()
{
	return s_tcpMolipDrawFileVersion;
} // FCHeaderInf::GetStcFileVersionString.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStreamSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiCmMiDfIiDgHiDiKiBfLiDiAiPoDiCmFiCmMiDfEiDeDiDfJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhHiDgCiDfPiCmMiDfIiDgHiDiKiBfLiDiAiPoDiCmFiCmMiDfEiDeDiDfJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.07.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long FCHeaderInf::GetStreamSize ()
{
	return 
		// CLSID_xZkqqHx_iBeC_xHqqkZx_
		sizeof(CLSID) +
		// _xZkqqHx_iDeBiDhGiDiKjGlMiBeC_xHqqkZx_
		sizeof(WORD) + s_szAppName +
		// _xZkqqHx_iDeBiDhGiDiKiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		sizeof(((FCHeaderInf*)NULL)->m_wAppVersion) +
		// _xZkqqHx_iDhGiDiJiDgCiDgHiDhKiBfLiDiAiBeC_xHqqkZx_
		sizeof(((FCHeaderInf*)NULL)->m_byPlatform) +
		// _xZkqqHx_iDhEiDeAiDeDiDiLiDfOiDeDiDhGiBeC_xHqqkZx_
		sizeof(((FCHeaderInf*)NULL)->m_byFileType) +
		// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		sizeof(((FCHeaderInf*)NULL)->m_wFileVersion) +
		// _xZkqqHx_iNoMjAkMjDpKiOjOiBeC_xHqqkZx_
		sizeof(((FCHeaderInf*)NULL)->m_tmCreate) +
		// _xZkqqHx_iNfIjAfGjDpKiOjOiBeC_xHqqkZx_
		sizeof(((FCHeaderInf*)NULL)->m_tmUpdate);
} // FCHeaderInf::GetStreamSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStcAppVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeBiDhGiDiKiCmMiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCHeaderInf::GetStcAppVersion ()
{
//----- 06.06.24 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iKnEiIoBiCkCiCpAjGgIiCkOiClNiCnPiCmJjAnNjCoIiBeC_xHqqkZx_
// 06.06.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	if (FD_APP_LEVEL_A < 'A' || 'P' < FD_APP_LEVEL_A)
	if (FD_APP_LEVEL_A < 'K' || 'Z' < FD_APP_LEVEL_A)
		FFThrowMiscUnknown();
	if (FD_APP_LEVEL_B < '1' || '4' < FD_APP_LEVEL_B)
		FFThrowMiscUnknown();
//----- 06.06.24 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	FCAppVersion ver;
	ver.wMajor  = FD_APP_MAJOR_VER;
	ver.wMinor  = FD_APP_MINOR_VER;
// 06.06.30 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	ver.wLevelA = FD_APP_LEVEL_A - 'A';
	ver.wLevelA = FD_APP_LEVEL_A - 'K';
	ver.wLevelB = FD_APP_LEVEL_B - '1';
	return ver.wVersion;
} // FCHeaderInf::GetStcAppVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::GetStcFileVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeBiDhGiDiKiCkKiNoMjAkMiClHiCoJiDhEiDeAiDeDiDiLiCmMiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.03.07 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCHeaderInf::GetStcFileVersion ()
{
	union {
		WORD	wVersion;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		struct {
//----- 00.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			WORD	wMajor	: 8;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//			WORD	wMinor	: 8;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//----- 00.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			WORD	wMinor	: 8;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
			WORD	wMajor	: 8;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
//----- 00.11.23 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		};
	} ver;
	ver.wMajor = s_wMolipDrawFileMajorVer;
	ver.wMinor = s_wMolipDrawFileMinorVer;
	return ver.wVersion;
} // FCHeaderInf::GetStcFileVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::MajorMinorToFileVersion
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iJnPiLiOiCmMiDeBiDhGiDiKiCkKiNoMjAkMiClFiClNiDhEiDeAiDeDiDiLiCmMjDmBjCoIiCmMiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wMajorVer	:_xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wMinorVer	:_xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	1.0_xZkqqHx_iBeB_xHqqkZx_2.x_xZkqqHx_iCmFiCmNiBeBiDiBiDfHiDiDiBfLiCmGiDhNiDeDiDgJiBfLiCkKiLhEjDfNiClFiCmEiCkCiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCoKiCmNiBeB_xHqqkZx_3.0_xZkqqHx_iCkJiCoHiDgPiBfLiDfHiDiHiDjDiCmMjBoFiPkMiCmFjEoEiKhCiCmFiCkLiCoJiCoGiCkEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiClNiCnPiCmJiBeBiDiBiDfHiDiDiBfLiCmGiDhNiDeDiDgJiBfLiCmMiDhCiDgCiDgHjEhKjHpBiCpAiLhEiCmJ_xHqqkZx_
 *			_xZkqqHx_iClFiClNiClNiCnPiBeC_xHqqkZx_
 *
 *			_xZkqqHx_iJnPiLiOiCmM_xHqqkZx_Molip Draw_xZkqqHx_iCmMiDgPiBfLiDfHiDiHiDjDiCmMjBmOiJjOiCmNiImIiJlKiBeC_xHqqkZx_
 *								_xZkqqHx_iPoDiImK_xHqqkZx_8bit _xZkqqHx_iJlKiImK_xHqqkZx_8bit
 *			Molip Draw 1.0:			0		0
 *			Molip Draw 2.0:			0		2
 *			Molip Draw 3.0:			3		0
 *			Molip Draw 4.0:			4		0
 *			_xZkqqHx_iClBiCmMiClNiCnPiBeBiOmAiNnLiCmMiDiBiDfHiDiDiBfL_xHqqkZx_/_xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiCmG_xHqqkZx_
 *			_xZkqqHx_iIoBiCkEiDgPiBfLiDfHiDiHiDjDiBgJiImIiJlKiCmMiCoGiCkEiBgKiCmJjFmPiKlHiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 *			Molip Draw 1.0		Major	0
 *								Minor	0
 *			Molip Draw 2.x		Major	0
 *								Minor	2
 *			Dynamic Draw 3.x	Major	3
 *								Minor	0
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WORD FCHeaderInf::MajorMinorToFileVersion (WORD wMajorVer, WORD wMinorVer)
{
	union {
		WORD	wVersion;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		struct {
			WORD	wMinor	: 8;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
			WORD	wMajor	: 8;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		};
	} ver;
	if (wMajorVer == 1)
	{
		ver.wMajor = 0;
		ver.wMinor = 0;
	} else
	if (wMajorVer == 2)
	{
		ver.wMajor = 0;
		ver.wMinor = 2;
	} else
	{
		ver.wMajor = wMajorVer;
		ver.wMinor = wMinorVer;
	}
	return ver.wVersion;
} // FCHeaderInf::MajorMinorToFileVersion.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCHeaderInf::FileVersionMajorMinor
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCkJiCoHiDiBiDfHiDiDiBfL_xHqqkZx_/_xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wMajorVer	:_xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *			wMinorVer	:_xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiCpAjFnEiClHiBeC_xHqqkZx_
 *			wVersion	:_xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCHeaderInf::FileVersionMajorMinor (WORD& wMajorVer, WORD& wMinorVer, WORD wVersion)
{
	union {
		WORD	wVersion;	// _xZkqqHx_iDhEiDeAiDeDiDiLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		struct {
			WORD	wMinor	: 8;	// _xZkqqHx_iDhNiDeDiDgJiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
			WORD	wMajor	: 8;	// _xZkqqHx_iDiBiDfHiDiDiBfLiDgPiBfLiDfHiDiHiDjDiBeC_xHqqkZx_
		};
	} ver;
	ver.wVersion = wVersion;

	if (ver.wMajor == 0 && ver.wMinor == 0)
	{
		wMajorVer = 1;
		wMinorVer = 0;
	} else
	if (ver.wMajor == 0 && ver.wMinor == 2)
	{
		wMajorVer = 2;
		wMinorVer = 0;
	} else
	{
		wMajorVer = ver.wMajor;
		wMinorVer = ver.wMinor;
	}
} // FCHeaderInf::FileVersionMajorMinor.

