// VirtualTableManager.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "UtilErr.h"				// For FFThrowMiscUnknown.
#include "UtilFile.h"				// For ReadStream.
#include "VirtualWriteTable.h"		// For FCVirtualWriteTable.
#include "UtilVirtualTable.h"		// For FCTableIds.
#include "VirtualTableManager.h"	// This header.

//----- 05.12.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#ifdef _DEBUG
//#define new DEBUG_NEW
//#undef THIS_FILE
//static char THIS_FILE[] = __FILE__;
//#endif
//----- 05.12.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////////
// FCTableRec

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTableRec::FCTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec::FCTableRec ()
		:	m_pVirtualTable(NULL),
			m_tableOperation(FD_TABLE_OPE_NONE)
{
} // FCTableRec::FCTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTableRec::~FCTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec::~FCTableRec ()
{
	if (m_pVirtualTable != NULL)
		delete m_pVirtualTable;
} // FCTableRec::~FCTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTableRec::SetCreateFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCpAjAfGiLeLiNoMjAkMiClHiCoJiPoKiNiHiCmJiBeBiNoMjAkMiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClNiDhEiDiJiDePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFeLiClI_xHqqkZx_ FD_TABLE_OPE_CREATE _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiCoNiCkPiCmFiCmNiCmIiCkNiBeBiClLiCmMjBePiCmJ_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClDiCoKiClNiDgFiBfLiDhFiDiLiCmFiCkAiCoKiCmOiBeB_xHqqkZx_FD_TABLE_OPE_DELETE_AND_CREATE _xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTTableOperationFlag FCTableRec::SetCreateFlag ()
{
	switch (m_tableOperation)
	{
	case FD_TABLE_OPE_NONE:
		m_tableOperation = FD_TABLE_OPE_CREATE;
		break;
	case FD_TABLE_OPE_DELETE:
		m_tableOperation = FD_TABLE_OPE_DELETE_AND_CREATE;
		break;
	default:
		FFThrowMiscUnknown();
	}
	return m_tableOperation;
} // FCTableRec::SetCreateFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTableRec::SetDeleteFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoNiPjMiClHiCoJiPoKiNiHiCmJiBeBiNoNiPjMiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClNiDhEiDiJiDePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jFeLiClI_xHqqkZx_ FD_TABLE_OPE_DELETE _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiCoNiCkPiCmFiCmNiCmIiCkNiBeBiClLiCmMjBePiCmJ_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClDiCoKiClNiDgFiBfLiDhFiDiLiCmFiCkAiCoKiCmOiBeB_xHqqkZx_FD_TABLE_OPE_NONE _xZkqqHx_iCkK_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTTableOperationFlag FCTableRec::SetDeleteFlag ()
{
	switch (m_tableOperation)
	{
	case FD_TABLE_OPE_NONE:
		m_tableOperation = FD_TABLE_OPE_DELETE;
		break;
	case FD_TABLE_OPE_CREATE:
		m_tableOperation = FD_TABLE_OPE_NONE;
		break;
	case FD_TABLE_OPE_DELETE_AND_CREATE:
		m_tableOperation = FD_TABLE_OPE_DELETE;
		break;
	default:
		FFThrowMiscUnknown();
	}
	return m_tableOperation;
} // FCTableRec::SetDeleteFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTableRec::GetOperationFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMjBiAiNoMiDhEiDiJiDePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMjBiAiNoMiDhEiDiJiDePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTTableOperationFlag FCTableRec::GetOperationFlag () const
{
	return m_tableOperation;
} // FCTableRec::GetOperationFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCTableRec::SetOperationFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMjBiAiNoMiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	creationStat	:_xZkqqHx_jBiAiNoMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCgMiCkKjClMjAnKiCmJjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCTableRec::SetOperationFlag (FTTableOperationFlag creationStat)
{
	m_tableOperation = creationStat;
} // FCTableRec::SetOperationFlag.

/////////////////////////////////////////////////////////////////////////////
// FCGroupRec

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::FCGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGroupRec::FCGroupRec ()
		:	m_groupOperation(FD_GROUP_OPE_NONE)
{
} // FCGroupRec::FCGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::~FCGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGroupRec::~FCGroupRec ()
{
	// _xZkqqHx_iDfEiDhFiDgFiBfLiDhFiDiLiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	map<DWORD, FCTableRec*>::iterator iTrec;
	for (iTrec = m_mpTableIdToRec.begin(); iTrec != m_mpTableIdToRec.end(); iTrec++)
		delete iTrec->second;
	m_mpTableIdToRec.clear();
	// _xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
	map<DWORD, FCGroupRec*>::iterator iGrec;
	for (iGrec = m_mpGroupIdToRec.begin(); iGrec != m_mpGroupIdToRec.end(); iGrec++)
		delete iGrec->second;
	m_mpGroupIdToRec.clear();
} // FCGroupRec::~FCGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::SetCreateFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmJjAfGiLeLiNoMjAkMiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClNiDhEiDiJiDePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiPoKiNiHiCmGjDkPjHgMiBeBjFeLiClI_xHqqkZx_ FD_GROUP_OPE_CREATE _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iCoNiCkPiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMjBePiCmJiNoNiPjMiClDiCoKiClNiDePiDiLiBfLiDhGiCmFiCkAiCoKiCmOiBeB_xHqqkZx_FD_GROUP_OPE_NONE _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iCmCiCnMiCoI_xHqqkZx_ _xZkqqHx_iNoNiPjM_xHqqkZx_ -> _xZkqqHx_iNoMjAkM_xHqqkZx_ _xZkqqHx_iCmFiBeBiJlNiCoAjGlDiCkJiCmBiClNiClBiCmGiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTGroupOperationFlag FCGroupRec::SetCreateFlag ()
{
	switch (m_groupOperation)
	{
	case FD_GROUP_OPE_NONE:
		m_groupOperation = FD_GROUP_OPE_CREATE;
		break;
	case FD_GROUP_OPE_DELETE:
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiPoKiNiHiBeBiNoNiPjM_xHqqkZx_ -> _xZkqqHx_iNoMjAkM_xHqqkZx_ _xZkqqHx_iCmNiJlNiCoAjGlDiCkJiCmBiClNiClBiCmGiCmJiClHiCoJiBeC_xHqqkZx_
		m_groupOperation = FD_GROUP_OPE_NONE;
		break;
	default:
		FFThrowMiscUnknown();
	}
	return m_groupOperation;
} // FCGroupRec::SetCreateFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::SetDeleteFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmJiNoNiPjMiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAnNjCoIiClDiCoKiClNiDhEiDiJiDePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiCmMiPoKiNiHiCmGjDkPjHgMiBeBjFeLiClI_xHqqkZx_ FD_GROUP_OPE_DELETE _xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJ_xHqqkZx_
 *			_xZkqqHx_iCoNiCkPiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
 *			_xZkqqHx_iClLiCmMjBePiCmJiNoMjAkMiClDiCoKiClNiDePiDiLiBfLiDhGiCmFiCkAiCoKiCmOiBeB_xHqqkZx_FD_GROUP_OPE_NONE _xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *			_xZkqqHx_iCmCiCnMiCoI_xHqqkZx_ _xZkqqHx_iNoNiPjM_xHqqkZx_ -> _xZkqqHx_iNoNiPjM_xHqqkZx_ _xZkqqHx_iCmFiBeBiJlNiCoAjGlDiCkJiCmBiClNiClBiCmGiCmJiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTGroupOperationFlag FCGroupRec::SetDeleteFlag ()
{
	switch (m_groupOperation)
	{
	case FD_GROUP_OPE_NONE:
		m_groupOperation = FD_GROUP_OPE_DELETE;
		break;
	case FD_GROUP_OPE_CREATE:
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiPoKiNiHiBeBiNoMjAkM_xHqqkZx_ -> _xZkqqHx_iNoNiPjM_xHqqkZx_ _xZkqqHx_iCmNiJlNiCoAjGlDiCkJiCmBiClNiClBiCmGiCmJiClHiCoJiBeC_xHqqkZx_
		m_groupOperation = FD_GROUP_OPE_NONE;
		break;
	default:
		FFThrowMiscUnknown();
	}
	return m_groupOperation;
} // FCGroupRec::SetDeleteFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::GetOperationFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMjBiAiNoMiDhEiDiJiDePiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMjBiAiNoMiDhEiDiJiDePiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FTGroupOperationFlag FCGroupRec::GetOperationFlag () const
{
	return m_groupOperation;
} // FCGroupRec::GetOperationFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::SetOperationFlag
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMjBiAiNoMiDhEiDiJiDePiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	creationStat	:_xZkqqHx_jBiAiNoMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjCgMiCkKjClMjAnKiCmJjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCGroupRec::SetOperationFlag (FTGroupOperationFlag creationStat)
{
	m_groupOperation = creationStat;
} // FCGroupRec::SetOperationFlag.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::GetGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGroupIds	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vGroupIds_xZkqqHx_iCmNiBeBiClBiCmMiDePiDiLiBfLiDhGiCpAiKoOjDfPiCmJiClFiClNjBiKjBmOjDeJiCmI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGroupRec* FCGroupRec::GetGroupRec (const FCTableIds& vGroupIds)
{
	if (vGroupIds.GetSize() == 1)
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfAiCmCiClOiCkPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		map<DWORD, FCGroupRec*>::iterator iGrec = m_mpGroupIdToRec.find(vGroupIds[0]);
		if (iGrec != m_mpGroupIdToRec.end())
			return iGrec->second;
		else
			return NULL;
	} else
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfBiCmCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jClMiJlKiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiMkJiCmCiCkPiClOiClFiBeBiClLiCmMiDePiDiLiBfLiDhGiCmJiNmEiLeBjDeJiCmJiMjPiNpFiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
		map<DWORD, FCGroupRec*>::iterator iGrec = m_mpGroupIdToRec.find(vGroupIds[0]);
		if (iGrec != m_mpGroupIdToRec.end())
			return iGrec->second->GetGroupRec(FCTableIds(&vGroupIds[1], vGroupIds.End()));
		else
			return NULL;
	}
} // FCGroupRec::GetGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::GetGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGroupIds	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vGroupIds_xZkqqHx_iCmNiBeBiClBiCmMiDePiDiLiBfLiDhGiCpAiKoOjDfPiCmJiClFiClNjBiKjBmOjDeJiCmI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCGroupRec* FCGroupRec::GetGroupRec (const FCTableIds& vGroupIds) const
{
	if (vGroupIds.GetSize() == 1)
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfAiCmCiClOiCkPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		map<DWORD, FCGroupRec*>::const_iterator iGrec = m_mpGroupIdToRec.find(vGroupIds[0]);
		if (iGrec != m_mpGroupIdToRec.end())
			return iGrec->second;
		else
			return NULL;
	} else
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfBiCmCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jClMiJlKiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiMkJiCmCiCkPiClOiClFiBeBiClLiCmMiDePiDiLiBfLiDhGiCmJiNmEiLeBjDeJiCmJiMjPiNpFiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
		map<DWORD, FCGroupRec*>::const_iterator iGrec = m_mpGroupIdToRec.find(vGroupIds[0]);
		if (iGrec != m_mpGroupIdToRec.end())
			return iGrec->second->GetGroupRec(FCTableIds(&vGroupIds[1], vGroupIds.End()));
		else
			return NULL;
	}
} // FCGroupRec::GetGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::QueryGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGroupIds	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNjAfGiLeLiCmJiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vGroupIds_xZkqqHx_iCmNiBeBiClBiCmMiDePiDiLiBfLiDhGiCpAiKoOjDfPiCmJiClFiClNjBiKjBmOjDeJiCmI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			GetGroupRec_xZkqqHx_iKnGjAjEiCmGiInJiCmIiCoIiBeBiOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiBeFjDgPjIfOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGroupRec* FCGroupRec::QueryGroupRec (const FCTableIds& vGroupIds)
{
	if (vGroupIds.GetSize() == 1)
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfAiCmCiClOiCkPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCGroupRec* pGroupRec = m_mpGroupIdToRec[vGroupIds[0]];
		if (pGroupRec == NULL)
		//----- _xZkqqHx_jGkCjDgPjIfOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_jAfGiClFiCkNiNoMjAkMiClFiCmEjDgPjIfOiClHiCoJiBeC_xHqqkZx_
			pGroupRec = new FCGroupRec();
			m_mpGroupIdToRec[vGroupIds[0]] = pGroupRec;
		}
		return pGroupRec;
	} else
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfBiCmCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCGroupRec* pGroupRec = m_mpGroupIdToRec[vGroupIds[0]];
		if (pGroupRec == NULL)
		//----- _xZkqqHx_jGkCjDgPjIfOiCmMiPoKiNiH_xHqqkZx_ -----
		{
			pGroupRec = new FCGroupRec();
			m_mpGroupIdToRec[vGroupIds[0]] = pGroupRec;
		}
		return pGroupRec->QueryGroupRec(FCTableIds(&vGroupIds[1], vGroupIds.End()));
	}
} // FCGroupRec::QueryGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::GetTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIds	:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vTableIds_xZkqqHx_iCmNiBeBiClBiCmMiDePiDiLiBfLiDhGiCpAiKoOjDfPiCmJiClFiClNjBiKjBmOjDeJiCmI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec* FCGroupRec::GetTableRec (const FCTableIds& vTableIds)
{
	if (vTableIds.GetSize() == 1)
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfAiCmCiClOiCkPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		map<DWORD, FCTableRec*>::iterator iTrec = m_mpTableIdToRec.find(vTableIds[0]);
		if (iTrec != m_mpTableIdToRec.end())
			return iTrec->second;
		else
			return NULL;
	} else
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfBiCmCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jClMiJlKiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiMkJiCmCiCkPiClOiClFiBeBiClLiCmMiDePiDiLiBfLiDhGiCmJiNmEiLeBjDeJiCmJiMjPiNpFiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
		map<DWORD, FCGroupRec*>::iterator iGrec = m_mpGroupIdToRec.find(vTableIds[0]);
		if (iGrec != m_mpGroupIdToRec.end())
			return iGrec->second->GetTableRec(FCTableIds(&vTableIds[1], vTableIds.End()));
		else
			return NULL;
	}
} // FCGroupRec::GetTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::GetTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIds	:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vTableIds_xZkqqHx_iCmNiBeBiClBiCmMiDePiDiLiBfLiDhGiCpAiKoOjDfPiCmJiClFiClNjBiKjBmOjDeJiCmI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCTableRec* FCGroupRec::GetTableRec (const FCTableIds& vTableIds) const
{
	if (vTableIds.GetSize() == 1)
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfAiCmCiClOiCkPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		map<DWORD, FCTableRec*>::const_iterator iTrec = m_mpTableIdToRec.find(vTableIds[0]);
		if (iTrec != m_mpTableIdToRec.end())
			return iTrec->second;
		else
			return NULL;
	} else
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfBiCmCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jClMiJlKiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiMkJiCmCiCkPiClOiClFiBeBiClLiCmMiDePiDiLiBfLiDhGiCmJiNmEiLeBjDeJiCmJiMjPiNpFiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
		map<DWORD, FCGroupRec*>::const_iterator iGrec = m_mpGroupIdToRec.find(vTableIds[0]);
		if (iGrec != m_mpGroupIdToRec.end())
			return iGrec->second->GetTableRec(FCTableIds(&vTableIds[1], vTableIds.End()));
		else
			return NULL;
	}
} // FCGroupRec::GetTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCGroupRec::QueryTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIds	:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNjAfGiLeLiCmJiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	vTableIds_xZkqqHx_iCmNiBeBiClBiCmMiDePiDiLiBfLiDhGiCpAiKoOjDfPiCmJiClFiClNjBiKjBmOjDeJiCmI_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *			GetTableRec_xZkqqHx_iKnGjAjEiCmGiInJiCmIiCoIiBeBiDgFiBfLiDhFiDiLiCkKjGkCjDgPjIfOiCmMiPoKiNiHiCmNiBeBiNoMjAkMiBeFjDgPjIfO_xHqqkZx_
 *			_xZkqqHx_iClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec* FCGroupRec::QueryTableRec (const FCTableIds& vTableIds)
{
	if (vTableIds.GetSize() == 1)
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfAiCmCiClOiCkPiCmMiPoKiNiH_xHqqkZx_ -----
	{
		FCTableRec* pTableRec = m_mpTableIdToRec[vTableIds[0]];
		if (pTableRec == NULL)
		{
			pTableRec = new FCTableRec();
			m_mpTableIdToRec[vTableIds[0]] = pTableRec;
		}
		return pTableRec;
	} else
	//----- ID_xZkqqHx_iCmMjHhGjBgGiCkKiCfBiCmCiImIiPoDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jClMiJlKiCmMiDfEiDhFiDePiDiLiBfLiDhGiCpAiMkJiCmCiCkPiClOiClFiBeBiClLiCmMiDePiDiLiBfLiDhGiCmJiNmEiLeBjDeJiCmJiMjPiNpFiCpAiCkJiCkPiCoJiBeC_xHqqkZx_
		FCGroupRec* pGroupRec = m_mpGroupIdToRec[vTableIds[0]];
		if (pGroupRec == NULL)
		{
			pGroupRec = new FCGroupRec();
			m_mpGroupIdToRec[vTableIds[0]] = pGroupRec;
		}
		return pGroupRec->QueryTableRec(FCTableIds(&vTableIds[1], vTableIds.End()));
	}
} // FCGroupRec::QueryTableRec.

/////////////////////////////////////////////////////////////////////////////
// FCVirtualTableManager

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::FCVirtualTableManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hstrTopDirPath	:_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiKmHjHjNiClHiCoJiDgHiDgCiDhGiDePiDiLiBfLiDhGiCmM_xHqqkZx_
 *							 _xZkqqHx_iDhAiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCVirtualTableManager::FCVirtualTableManager (const HString& hstrTopDirPath)
					:	m_hstrTopDirPath(hstrTopDirPath),
						m_pGroupRecTop(new FCGroupRec())
{
} // FCVirtualTableManager::FCVirtualTableManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::~FCVirtualTableManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCVirtualTableManager::~FCVirtualTableManager ()
{
	Clear();
} // FCVirtualTableManager::~FCVirtualTableManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDoAjHgFiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::Clear ()
{
	m_hstrTopDirPath.Empty();
	if (m_pGroupRecTop != NULL)
	{
		delete m_pGroupRecTop;
		m_pGroupRecTop = NULL;
	}
} // FCVirtualTableManager::Clear.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::GetGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGroupIds	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGroupRec* FCVirtualTableManager::GetGroupRec (const FCTableIds& vGroupIds)
{
	if (vGroupIds.GetSize() == 0)
		FFThrowMiscUnknown();
	return m_pGroupRecTop->GetGroupRec(vGroupIds);
} // FCVirtualTableManager::GetGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::GetGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGroupIds	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCGroupRec* FCVirtualTableManager::GetGroupRec (const FCTableIds& vGroupIds) const
{
	if (vGroupIds.GetSize() == 0)
		FFThrowMiscUnknown();
	return m_pGroupRecTop->GetGroupRec(vGroupIds);
} // FCVirtualTableManager::GetGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::QueryGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vGroupIds	:_xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDePiDiLiBfLiDhGiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNjAfGiLeLiCmJiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetGroupRec_xZkqqHx_iKnGjAjEiCmGiInJiCmIiCoIiBeBiOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiBeFjDgPjIfOiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCGroupRec* FCVirtualTableManager::QueryGroupRec (const FCTableIds& vGroupIds)
{
	if (vGroupIds.GetSize() == 0)
		FFThrowMiscUnknown();
	return m_pGroupRecTop->QueryGroupRec(vGroupIds);
} // FCVirtualTableManager::QueryGroupRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::GetTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIds	:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec* FCVirtualTableManager::GetTableRec (const FCTableIds& vTableIds)
{
	if (vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	return m_pGroupRecTop->GetTableRec(vTableIds);
} // FCVirtualTableManager::GetTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::GetTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIds	:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const FCTableRec* FCVirtualTableManager::GetTableRec (const FCTableIds& vTableIds) const
{
	if (vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	return m_pGroupRecTop->GetTableRec(vTableIds);
} // FCVirtualTableManager::GetTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::QueryTableRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vTableIds	:_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiDeJiDhFiDfHiDeGiDeOiDgHiBeCiOhHjCoIiClDiCoKiClN_xHqqkZx_ID_xZkqqHx_iCmMiDgFiBfLiDhFiDiLiCkKjGlDiCkC_xHqqkZx_
 *			_xZkqqHx_iPoKiNiHiCmNjAfGiLeLiCmJiNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	GetTableRec_xZkqqHx_iKnGjAjEiCmGiInJiCmIiCoIiBeBiDgFiBfLiDhFiDiLiCkKjGkCjDgPjIfOiCmMiPoKiNiHiCmNiBeBiNoMjAkMiBeFjDgPjIfO_xHqqkZx_
 *			_xZkqqHx_iClFiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
FCTableRec* FCVirtualTableManager::QueryTableRec (const FCTableIds& vTableIds)
{
	if (vTableIds.GetSize() == 0)
		FFThrowMiscUnknown();
	return m_pGroupRecTop->QueryTableRec(vTableIds);
} // FCVirtualTableManager::QueryTableRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::AddTransaction
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCpAiOpDiCkPiOoGiCoIiBeBiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTransaction	:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			szTransaction	:pTransaction_xZkqqHx_iCmMiDgGiBfLiDfOiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmNiBeBiDgHiDgCiDhGiDePiDiLiBfLiDhGjCfAiImKiCmFiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iOpDiCkPiOoGiCmBiClNiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiCmNiBeBiJlMjBhKiDePiDiLiBfLiDhGiBeFiJlMjBhKiDgFiBfLiDhFiDiLiCmJ_xHqqkZx_
 *			_xZkqqHx_jElNiJgGiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::AddTransaction (const BYTE* pTransaction, size_t szTransaction)
{
	// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgPiDeDiDgHiDfIiDgHiDiKiBfLiDiAiCmMiPeJjCfLiBeC_xHqqkZx_
	const BYTE* pTransactionEnd = pTransaction + szTransaction;
	while (pTransaction != pTransactionEnd)
	{
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDfCiDhNiDjDiDgIiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		BYTE byCommand;
		FFReadData(byCommand, pTransaction);
		// _xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDfCiDhNiDjDiDgIiCmMiPiIjHjNiBeC_xHqqkZx_
		DoTransCommand(byCommand, pTransaction);
	}
} // FCVirtualTableManager::AddTransaction.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::DoTransCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfAiCmCiCmMiDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDfCiDhNiDjDiDgIiCpAiPiIjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	byCommand	:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDfCiDhNiDjDiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pTransaction:_xZkqqHx_iDgHiDiJiDjDiDfFiDeOiDfGiDiHiDjDiDgGiBfLiDfOiCpAiOhHjCoIiBeCiPiIjHjNiMoDiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::DoTransCommand (BYTE byCommand, const BYTE*& pTransaction)
{
	switch (byCommand)
	{
	case CMD_CREATE_GROUP:		// _xZkqqHx_iDePiDiLiBfLiDhGiCpAiNoMjAkMiBeC_xHqqkZx_
	  {
		// <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHmMiIoGiCgAiCmMiCoGiCkEiCmJiBeBiDePiDiLiBfLiDhGiCmMiDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCGroupRec_xZkqqHx_iBgKiCkKjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
		//
		//                                          _xZkqqHx_iBeG_xHqqkZx_
		//                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
		//                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
		//                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
		//                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
		//          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
		//          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgDiBeG_xHqqkZx_  _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfEiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
		//          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
		//                                                    _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
		//
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmM_xHqqkZx_ID_xZkqqHx_iBgJiDePiDiLiBfLiDhGiCfEiBgKiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FCTableIds vGroupIds;
		FFReadData(vGroupIds, pTransaction);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCfEiCmM_xHqqkZx_FCGroupRec_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		FCGroupRec* pGroupRec = QueryGroupRec(vGroupIds);
		// _xZkqqHx_jAfGiLeLiNoMjAkMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		pGroupRec->SetCreateFlag();
		break;
	  }
	case CMD_CREATE_TABLE:		// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
	  {
		// <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iJlKjAhNiCmMjHmMiIoGiCgAiCmMiCoGiCkEiCmJiBeBiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiBgJ_xHqqkZx_FCTableRec_xZkqqHx_iBgKiCkKjCmHiJmBiClDiCoKiCoJiBeC_xHqqkZx_
		//
		//                                          _xZkqqHx_iBeG_xHqqkZx_
		//                                    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_
		//                                    _xZkqqHx_iEkAiDePiDiLiBfLiDhGiCfAiEkA_xHqqkZx_
		//                                    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_
		//                  _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//                  _xZkqqHx_iEkA_xHqqkZx_              _xZkqqHx_iEkA_xHqqkZx_                _xZkqqHx_iEkA_xHqqkZx_        _xZkqqHx_iEkBiBgDiBgDiBgDiBgDiBeGiBgDiBgDiCgAiBgDiEkC_xHqqkZx_
		//          _xZkqqHx_iEkBiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEkCiEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_    _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkBiEjPiEjPiEkIiEjPiEjPiEkC_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
		//          _xZkqqHx_iEkAiKmHjHjNiDgFiBfLiDhFiDiLiCfBiEkAiEkAiDgFiBfLiDhFiDiLiCfCiEkAiBgDiBgDiEkAiDePiDiLiBfLiDhGiCfDiEkAiBgDiBeG_xHqqkZx_  _xZkqqHx_iEkAiDgFiBfLiDhFiDiLiCfEiEkA_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
		//          _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkDiEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_    _xZkqqHx_iEkEiEjPiEjPiEkGiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_  _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_  _xZkqqHx_iBeG_xHqqkZx_
		//                                                    _xZkqqHx_iBeG_xHqqkZx_        _xZkqqHx_iEkEiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkD_xHqqkZx_
		//
		// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iBgJiDgFiBfLiDhFiDiLiCfEiBgKiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FCTableIds vTableIds;
		FFReadData(vTableIds, pTransaction);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmM_xHqqkZx_GUID_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeCiDgFiBfLiDhFiDiLiCmMjAfGiLeLiNoMjAkMiCmFiCmNiBeB_xHqqkZx_
		// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCmNiDiNiDgCiDeOiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJiCmNjAnNjCoIiClDiCoKiClIiBeB_xHqqkZx_
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLjBkEiCmFiLeMjIfOiClDiCoKiCoJiBeCiDhEiDiJiDgCiDfGiDiFiOjOiCmJiPiJiCnPiCmE_xHqqkZx_
		// _xZkqqHx_iDiNiDgCiDeOiPiKjHeMiMkAiDhEiDeAiDeDiDiLiCmJjElNiJgGiClDiCoKiCoJiBeC_xHqqkZx_
		GUID guidTable;
		FFReadData(guidTable, pTransaction);
		if (GetTableRec(vTableIds) != NULL)
			FFThrowMiscUnknown();
		// _xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCpAiNoMjAkMiBeFiOoGjDlOiBeC_xHqqkZx_
		FCTableRec* pTableRec = QueryTableRec(vTableIds);
		// _xZkqqHx_jAfGiLeLiNoMjAkMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		pTableRec->SetCreateFlag();
		// _xZkqqHx_jAfGiLeLiNoMjAkMiCmIiCmMiCmFiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCmN_xHqqkZx_NULL_xZkqqHx_iCmMiCmNiClIiBeC_xHqqkZx_
		if (pTableRec->m_pVirtualTable != NULL)
			FFThrowMiscUnknown();
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCpAiNoMjAkMiBeC_xHqqkZx_
		pTableRec->m_pVirtualTable = CreateVirtualTable();
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmJiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iCpAjAnNjCoIiClFiBeBiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
		pTableRec->m_pVirtualTable->SetTableGuid(guidTable);
		pTableRec->m_pVirtualTable->ResetWriteRecordCache(0, 0, 0);
		break;
	  }
	case CMD_APPEND_RECORD:		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmJiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FCTableIds vTableIds;
		FFReadData(vTableIds, pTransaction);
		// _xZkqqHx_iDhGiDiJiDeDiDhNiDiKiBfL_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		flint fliPrimaryId;
		FFReadData(fliPrimaryId, pTransaction);
		// _xZkqqHx_iDiMiDfCiBfLiDgIiDgGiBfLiDfOiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		BYTEVector vDataBuff;
		FFReadData(vDataBuff, pTransaction);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCpAiNfIjAfGiBeFiOoGjDlOiBeC_xHqqkZx_
		FCTableRec* pTableRec = UpdateVirtualTable(vTableIds);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmJiDiMiDfCiBfLiDgIiCpAjCmHiJmBiBeC_xHqqkZx_
		pTableRec->m_pVirtualTable->AppendWriteRecord(	TRUE,
														fliPrimaryId,
														&vDataBuff[0],
														vDataBuff.size());
		break;
	  }
	case CMD_REDUCE_RECORD_COUNT:		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAiNoNiPjMiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FCTableIds vTableIds;
		FFReadData(vTableIds, pTransaction);
		// _xZkqqHx_iDiMiDfCiBfLiDgIjAjEiCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		DWORD dwNewCount;
		FFReadData(dwNewCount, pTransaction);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCpAiNfIjAfGiBeFiOoGjDlOiBeC_xHqqkZx_
		FCTableRec* pTableRec = UpdateVirtualTable(vTableIds);
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIjAjEiCpAjFmPiNfIiBeC_xHqqkZx_
		pTableRec->m_pVirtualTable->ReduceWriteRecordCount(dwNewCount);
		break;
	  }
	case CMD_DELETE_GROUP:	// _xZkqqHx_iDePiDiLiBfLiDhGiCpAiNoNiPjMiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FCTableIds vGroupIds;
		FFReadData(vGroupIds, pTransaction);
		// _xZkqqHx_iDePiDiLiBfLiDhGiCmM_xHqqkZx_FCGroupRec_xZkqqHx_iCpAiOoGjDlOiBeC_xHqqkZx_
		FCGroupRec* pGroupRec = QueryGroupRec(vGroupIds);
		// _xZkqqHx_iNoNiPjMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		pGroupRec->SetDeleteFlag();
		break;
	  }
	case CMD_DELETE_TABLE:		// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoNiPjMiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiPgPiClHiBeC_xHqqkZx_
		FCTableIds vTableIds;
		FFReadData(vTableIds, pTransaction);
		FCTableRec* pTableRec = QueryTableRec(vTableIds);
		// _xZkqqHx_iNoNiPjMiDhEiDiJiDePiCpAjAnNjCoIiBeC_xHqqkZx_
		pTableRec->SetDeleteFlag();
		break;
	  }
	default:
		FFThrowMiscUnknown();
	}
} // FCVirtualTableManager::DoTransCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::CalcRecordOperationGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCoGiCoIiJlKiCmJiCkAiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmJiKnGiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiMkJiClNiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCmMjFmPiNfIjDoAjHgFiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jBkGiClPiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClFiCmE_xHqqkZx_
 *			_xZkqqHx_iNhDiCmBiClNjBiAiNoMiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pGroupRec	:_xZkqqHx_jClCiCnHiCoJiDePiDiLiBfLiDhGiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeCiDiMiDfCiBfLiDgIjBiAiNoMiCpAjClCiCnHiCmEiBeBiMiLiJmKiCpA_xHqqkZx_
 *			m_recordOperation_xZkqqHx_iCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::CalcRecordOperationGroup (FCGroupRec* pGroupRec)
{
	// CalcRecordOperationGroup_xZkqqHx_iCmNiBeBiDePiDiLiBfLiDhGiBeBiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiPeDjAlDiPoOjFpBiCmMiOfKiPgPiCpAiNmEiLeBjDeJiCmJiNhDiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iNhDiCkLiCkKiCkPiCmJiBeBiDePiDiLiBfLiDhGiCkKiNoNiPjMiClDiCoKiClNiPoKiNiHiBeBiClLiCoKiCoGiCoIiJlKiCmMiDgFiBfLiDhFiDiLiCoC_xHqqkZx_
	// _xZkqqHx_iDePiDiLiBfLiDhGiCmMiPiIjHjNiCmNiClFiCmIiCkCiBeC_xHqqkZx_

	switch (pGroupRec->GetOperationFlag())
	{
	case FD_GROUP_OPE_DELETE:
	  {
		break;
	  }
	case FD_GROUP_OPE_CREATE:
	case FD_GROUP_OPE_NONE:
	  {
		map<DWORD, FCTableRec*>::iterator iTrec;
		for (iTrec = pGroupRec->m_mpTableIdToRec.begin();
			 iTrec != pGroupRec->m_mpTableIdToRec.end(); iTrec++)
		{
			CalcRecordOperationTable(iTrec->second);
		}

		map<DWORD, FCGroupRec*>::iterator iGrec;
		for (iGrec = pGroupRec->m_mpGroupIdToRec.begin();
			 iGrec != pGroupRec->m_mpGroupIdToRec.end(); iGrec++)
		{
			CalcRecordOperationGroup(iGrec->second);
		}
		break;
	  }
	default:
		FFThrowMiscUnknown();
	}
} // FCVirtualTableManager::CalcRecordOperationGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::CalcRecordOperationTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmJiKnGiClFiCmEiBeBjFkIjHjNiDgFiBfLiDhFiDiLiCkJiCoHiMkJiClNiBeBiJlMjBhKiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_jFmPiNfIjDoAjHgFiCpAjClCiCnHiCoJiBeCjBkGiClPiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCkJiCoHiJlMjBhKiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *			_xZkqqHx_iDiMiDfCiBfLiDgIiCmJjBmOiClFiCmEiNhDiCmBiClNjBiAiNoMiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTableRec	:_xZkqqHx_jClCiCnHiCoJiDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhEiDiJiDgCiDfGiDiFiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeCiDiMiDfCiBfLiDgIjBiAiNoMiCpAjClCiCnHiCmEiBeBiMiLiJmKiCpA_xHqqkZx_
 *			m_recordOperation_xZkqqHx_iCmJiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::CalcRecordOperationTable (FCTableRec* pTableRec)
{
	switch (pTableRec->GetOperationFlag())
	{
	case FD_TABLE_OPE_CREATE:
	case FD_TABLE_OPE_DELETE_AND_CREATE:
		if (pTableRec->m_pVirtualTable != NULL)
		//----- _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (pTableRec->m_pVirtualTable->GetWriteRecordEnd() != 0)
			//----- _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
				// _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjCmHiJmBiCmMiCnNiBeC_xHqqkZx_
				pTableRec->m_pVirtualTable->m_recordOperation = FD_RECORD_OPE_ADD;
			} else
			//----- _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
				// _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjFmPiNfIiCmIiCkCiBeC_xHqqkZx_
				pTableRec->m_pVirtualTable->m_recordOperation = FD_RECORD_OPE_NOT_CHANGE;
			}
		}
		break;

	case FD_TABLE_OPE_NONE:
		//--------------------------------------------------
		//       _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjFmPiNfIiCmIiCkCiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                                      _xZkqqHx_iBkK_xHqqkZx_
		//                    _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfLiBjFiJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_
		//
		//--------------------------------------------------
		//       _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjCmHiJmBiCmMiCnNiCmMiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkAiBkBiBkBiBkBiBkBiEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                                      _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
		//                          _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_   _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//
		//--------------------------------------------------
		//       _xZkqqHx_iHeC_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCkJiCoHiNoNiPjMiCmMiCnNiCmMiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                            _xZkqqHx_iBkK_xHqqkZx_
		//                    _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfLiBjFiJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_
		//
		//--------------------------------------------------
		//       _xZkqqHx_iHeD_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiH_xHqqkZx_
		//
		//                                 _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkAiBkBiBkBiBkBiBkBiBkBiBkBiBkBiBkBiEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//                            _xZkqqHx_iBkK_xHqqkZx_                _xZkqqHx_iBkK_xHqqkZx_
		//                     _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_   _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//
		//
		//                                 _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//                                      _xZkqqHx_iBkL_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiEkA_xHqqkZx_                      _xZkqqHx_iEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEjPiEkD_xHqqkZx_
		//              _xZkqqHx_iEkBiEjPiEjPiEjPiEjPiEjPiEjPiEkGiEjPiEjPiEkC_xHqqkZx_
		//  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiEkA_xHqqkZx_            _xZkqqHx_iEkAiBkBiBkBiEkA_xHqqkZx_
		//              _xZkqqHx_iEkEiEjPiEjPiEjPiEjPiEjPiEjPiEkIiEjPiEjPiEkD_xHqqkZx_
		//                            _xZkqqHx_iBkK_xHqqkZx_    _xZkqqHx_iBkK_xHqqkZx_
		//                _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgO_xHqqkZx_  _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_
		//
		//--------------------------------------------------

		// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ = pTableRec->m_pVirtualTable->GetRealRecordEnd()
		// _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgOiImKjChF_xHqqkZx_ = pTableRec->m_pVirtualTable->GetWriteRecordBegin()
		// _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ = pTableRec->m_pVirtualTable->GetWriteRecordEnd()

		if (pTableRec->m_pVirtualTable != NULL)
		//----- _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiDeJiDhFiDfHiDeGiDeOiDgHiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			if (pTableRec->m_pVirtualTable->GetRealRecordEnd() == pTableRec->m_pVirtualTable->GetWriteRecordBegin())
			//----- _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ _xZkqqHx_iBiB_xHqqkZx_ _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgOiImKjChF_xHqqkZx_ -----
			{
				if (pTableRec->m_pVirtualTable->GetWriteRecordBegin() == pTableRec->m_pVirtualTable->GetWriteRecordEnd())
				//----- _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgOiImKjChF_xHqqkZx_ _xZkqqHx_iBiB_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ -----
				{
					// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
					pTableRec->m_pVirtualTable->m_recordOperation = FD_RECORD_OPE_NOT_CHANGE;		// _xZkqqHx_iHeA_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjFmPiNfIiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
				} else
				//----- _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgOiImKjChF_xHqqkZx_ _xZkqqHx_iBiC_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ -----
				{
					// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
					pTableRec->m_pVirtualTable->m_recordOperation = FD_RECORD_OPE_ADD;				// _xZkqqHx_iHeB_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjCmHiJmBiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
				}
			} else
			//----- _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ _xZkqqHx_iBiC_xHqqkZx_ _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgOiImKjChF_xHqqkZx_ -----
			{
				if (pTableRec->m_pVirtualTable->GetWriteRecordBegin() == pTableRec->m_pVirtualTable->GetWriteRecordEnd())
				//----- _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgOiImKjChF_xHqqkZx_ _xZkqqHx_iBiB_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ -----
				{
					// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
					pTableRec->m_pVirtualTable->m_recordOperation = FD_RECORD_OPE_DEL;				// _xZkqqHx_iHeC_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCkJiCoHiNoNiPjMiCmMiCnNiCmMiPoKiNiHiBeC_xHqqkZx_
				} else
				//----- _xZkqqHx_iJlMjBhKiDiMiDfCiBfLiDgIiKeKiOgOiImKjChF_xHqqkZx_ _xZkqqHx_iBiC_xHqqkZx_ _xZkqqHx_iJlMjBhKiDgFiBfLiDhFiDiLiPeJjCfL_xHqqkZx_ -----
				{
					// _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJiJlMjBhKiDgFiBfLiDhFiDiLiCmMiDeJiDhJiDiMiBfLiDfGiDiHiDjDiBeC_xHqqkZx_
					pTableRec->m_pVirtualTable->m_recordOperation = FD_RECORD_OPE_DEL_AND_ADD;		// _xZkqqHx_iHeD_xHqqkZx_ _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCkJiCoHiNoNiPjMiClFiClNiMoDiCmJjCmHiJmBiCmMiPoKiNiHiBeC_xHqqkZx_
				}
			}
		}
		break;
	}
} // FCVirtualTableManager::CalcRecordOperationTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::GetModifiedTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCoGiCoIiJlKiCmJiCkAiCoJjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmJjBmOiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iPeDjAlDiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiIoKjHjHiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vDeletedTableName	:_xZkqqHx_iNoNiPjMiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *			vModifiedTableName	:_xZkqqHx_iNoMjAkMiBeFiPeDjAlDiClDiCoKiClNiDgFiBfLiDhFiDiLiCmMiIoKjHjHiCpAjFnEiClHiBeC_xHqqkZx_
 *			pGroupRec			:_xZkqqHx_iDePiDiLiBfLiDhGiCpAiOhHjCoIiBeCiClBiCmMiDePiDiLiBfLiDhGiImIiJlKiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *			vGroupIds			:pGroupRec_xZkqqHx_iCmMiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::GetModifiedTable (	vector<FCTableName>& vDeletedTableName,
												vector<FCTableName>& vModifiedTableName,
												FCGroupRec* pGroupRec,
												const FCTableIds& vGroupIds) const
{
	// GetModifiedTable_xZkqqHx_iCmNiBeBiPeDjAlDiCkKjDpMiCmBiClNiDgFiBfLiDhFiDiLiCmMiDiMiDfCiBfLiDgIiOpLiPfHiCpAiNmEiLeBjDeJiCmJiNhDiCkEiBeC_xHqqkZx_

	FCTableName tableName(m_hstrTopDirPath, FCTableIds(vGroupIds).PushBack(0));
	map<DWORD, FCTableRec*>::const_iterator iTrec;
	for (iTrec = pGroupRec->m_mpTableIdToRec.begin();
		 iTrec != pGroupRec->m_mpTableIdToRec.end(); iTrec++)
	//----- _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGjClMiJlKiCmMiDgFiBfLiDhFiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		tableName.SetLast(iTrec->first);
		const FCTableRec* pTableRec = iTrec->second;
		switch (pTableRec->GetOperationFlag())
		{
		case FD_TABLE_OPE_DELETE:				// _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiNoNiPjMiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iNoNiPjMiIoKjHjHiCmJjCmHiJmBiBeC_xHqqkZx_
			vDeletedTableName.push_back(tableName);
			break;
		case FD_TABLE_OPE_CREATE:				// _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiNoMjAkMiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
		case FD_TABLE_OPE_DELETE_AND_CREATE:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCkKiNoNiPjM_xHqqkZx_->_xZkqqHx_iNoMjAkMiClDiCoKiCmEiCkCiCoJiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iNoMjAkMiBeFiPeDjAlDiIoKjHjHiCmJjCmHiJmBiBeC_xHqqkZx_
			vModifiedTableName.push_back(tableName);
			break;
		case FD_TABLE_OPE_NONE:					// _xZkqqHx_iDgFiBfLiDhFiDiLiCmJjFmPiNfIiCkKiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
			// _xZkqqHx_iDiMiDfCiBfLiDgIiCmJjFmPiNfIiCkKiCkAiCoJiPoKiNiHiCmNiNoMjAkMiBeFiPeDjAlDiIoKjHjHiCmJjCmHiJmBiBeC_xHqqkZx_
			if (pTableRec->m_pVirtualTable != NULL &&
				pTableRec->m_pVirtualTable->m_recordOperation != FD_RECORD_OPE_NOT_CHANGE)
				vModifiedTableName.push_back(tableName);
			break;
		}
	}

	FCTableIds vSubGroupIds(vGroupIds);
	vSubGroupIds.PushBack(0);
	map<DWORD, FCGroupRec*>::const_iterator iGrec;
	for (iGrec = pGroupRec->m_mpGroupIdToRec.begin();
		 iGrec != pGroupRec->m_mpGroupIdToRec.end(); iGrec++)
	//----- _xZkqqHx_iClBiCmMiDePiDiLiBfLiDhGjClMiJlKiCmMiDePiDiLiBfLiDhGiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCmJjBmOiClFiCmEiNmEiLeBjDeJiCmJiPiIjHjNiCpAiOmAiNhDiBeC_xHqqkZx_
		vSubGroupIds.SetLast(iGrec->first);
		GetModifiedTable(vDeletedTableName, vModifiedTableName, iGrec->second, vSubGroupIds);
	}
} // FCVirtualTableManager::GetModifiedTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::UpdateGroupLockIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDePiDiLiBfLiDhGiCoGiCoIiJlKiCmMjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCmJiKnGiClFiCmEiBeB_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDiNiDgCiDeOiPoOjFpBiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmFiCoAjDkPjHgMiCmMiPiIjHjNiCkKiNhDiCoNiCoKiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiNoNiPjMiBeFjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjDkPiClGjCgMiCmJiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pGroupRec	:_xZkqqHx_iDePiDiLiBfLiDhGiCpAiOhHjCoIiBeCiClBiCmMiDePiDiLiBfLiDhGiImIiJlKiCmMiDgFiBfLiDhFiDiLiCmM_xHqqkZx_
 *						 _xZkqqHx_iDiNiDgCiDeOiPoOjFpBiCpAiNfIjAfGiBeC_xHqqkZx_
 *			vGroupIds	:pGroupRec_xZkqqHx_iCmMiDePiDiLiBfLiDhG_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::UpdateGroupLockIdentifier (FCGroupRec* pGroupRec, const FCTableIds& vGroupIds)
{
	FCTableIds vTableIds(vGroupIds);
	vTableIds.PushBack(0);
	map<DWORD, FCTableRec*>::iterator iTrec;
	for (iTrec = pGroupRec->m_mpTableIdToRec.begin();
		 iTrec != pGroupRec->m_mpTableIdToRec.end(); iTrec++)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjClMiJlKiCmMjBfDiCmEiCmMiDgFiBfLiDhFiDiLiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCpAiNfIjAfGiBeC_xHqqkZx_
		vTableIds.SetLast(iTrec->first);
		UpdateTableLockIdentifier(iTrec->second, vTableIds);
	}

	FCTableIds vSubGroupIds(vGroupIds);
	vSubGroupIds.PushBack(0);
	map<DWORD, FCGroupRec*>::iterator iGrec;
	for (iGrec = pGroupRec->m_mpGroupIdToRec.begin();
		 iGrec != pGroupRec->m_mpGroupIdToRec.end(); iGrec++)
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjClMiJlKiCmMjBfDiCmEiCmMiDePiDiLiBfLiDhGiCpAiDiLiBfLiDhG_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfEiDhFiDePiDiLiBfLiDhGiCmMiJlKiCmMiDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeCiNmEiLeBiPiIjHjNiBeC_xHqqkZx_
		vSubGroupIds.SetLast(iGrec->first);
		UpdateGroupLockIdentifier(iGrec->second, vSubGroupIds);
	}
} // FCVirtualTableManager::UpdateGroupLockIdentifier.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	FCVirtualTableManager::UpdateTableLockIdentifier
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDgFiBfLiDhFiDiLiCmJiKnGiClFiCmEiBeBiDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiDiNiDgCiDeOiPoOjFpBiCpA_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDfEiBfLiDgPiBfLiDfEiDeDiDgIiCmFiCoAjDkPjHgMiCmMiPiIjHjNiCkKiNhDiCoNiCoKiCmEiCkCiCoJiCmMiCmFiBeB_xHqqkZx_
 *			_xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiDfEiDeDiDgIiCmMiNoNiPjMiBeFjCmHiJmB_xHqqkZx_Identifier_xZkqqHx_iCpAjDkPiClGjCgMiCmJiClFiCmEiCkIiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pTableRec	:_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiOhHjCoIiBeCiClBiCmMiDgFiBfLiDhFiDiLiCmMiDiNiDgCiDeOiPoOjFpBiCpAiNfIjAfGiBeC_xHqqkZx_
 *			vGroupIds	:pTableRec_xZkqqHx_iCmMiDgFiBfLiDhFiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.02.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void FCVirtualTableManager::UpdateTableLockIdentifier (FCTableRec* pTableRec, const FCTableIds& vTableIds)
{
	switch (pTableRec->GetOperationFlag())
	{
	case FD_TABLE_OPE_CREATE:				// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoMjAkMiClFiClNiPoKiNiHiBeC_xHqqkZx_
	case FD_TABLE_OPE_DELETE_AND_CREATE:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoNiPjM_xHqqkZx_->_xZkqqHx_iNoMjAkMiClFiClNiPoKiNiHiBeC_xHqqkZx_
	  {
		// _xZkqqHx_iDgFiBfLiDhFiDiLiCmMiNoMjAkMiOjOiCmNiBeBiDiNiDgCiDeOiDhEiDeAiDeDiDiLiCpAiDiKiDfKiDgCiDgHiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iDgFiBfLiDhFiDiLiNoMjAkMiOjOiCmJiCmNiBeBiDgFiBfLiDhFiDiL_xHqqkZx_GUID_xZkqqHx_iBeB_xHqqkZx_Identifier_xZkqqHx_iCmNiDgFiBfLiDhFiDiLiCmJ_xHqqkZx_
		// _xZkqqHx_iLeMjIfOiClDiCoKiCmEiCkIiCoIiBeBiDiNiDgCiDeOiCmJiCmNiLeMjIfOiClDiCoKiCmEiCkCiCmIiCkCiBeC_xHqqkZx_
		SetLockGuidAndIdentifier(vTableIds, pTableRec->m_pVirtualTable->GetTableGuid(), 0, 0);
		break;
	  }
	}

	switch (pTableRec->GetOperationFlag())
	{
	case FD_TABLE_OPE_CREATE:				// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoMjAkMiClFiClNiPoKiNiHiBeC_xHqqkZx_
	case FD_TABLE_OPE_DELETE_AND_CREATE:	// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNoNiPjM_xHqqkZx_->_xZkqqHx_iNoMjAkMiClFiClNiPoKiNiHiBeC_xHqqkZx_
	case FD_TABLE_OPE_NONE:					// _xZkqqHx_iDgFiBfLiDhFiDiLiCpAjFmPiNfIiClFiCmEiCkCiCmIiCkCiPoKiNiHiBeC_xHqqkZx_
	  {
		if (pTableRec->m_pVirtualTable != NULL &&
			pTableRec->m_pVirtualTable->m_recordOperation != FD_RECORD_OPE_NOT_CHANGE)
		//----- _xZkqqHx_jFkIjHjNiDgFiBfLiDhFiDiLiDiMiDfCiBfLiDgIiCmJjBmOiClHiCoJjFmPiNfIiCkKiCkAiCoJiPoKiNiH_xHqqkZx_ -----
		{
			//----- _xZkqqHx_iDiNiDgCiDeOiDhEiDeAiDeDiDiLiCmMjCmHiJmBiBeFiNoNiPjMiOkPjFmKiOhBiCpAiNfIjAfG_xHqqkZx_ -----
			SetLockIdentifier(	vTableIds,
								pTableRec->m_pVirtualTable->GetWriteDeleteIdentifier(),
								pTableRec->m_pVirtualTable->GetWriteAppendIdentifier());
		}
		break;
	  }
	}
} // FCVirtualTableManager::UpdateTableLockIdentifier.
