#ifndef __DynamicMisc_h
#define __DynamicMisc_h

struct CPoint : public POINT
{
	CPoint () {}
	CPoint (long _x, long _y) { x = _x; y = _y; }
};

extern CPoint operator - (const CPoint& pt1, const CPoint& pt2);

struct CSize : public SIZE
{
	CSize () {}
	CSize (long _cx, long _cy) { cx = _cx; cy = _cy; }
};

struct CRect : public RECT
{
	CRect () {}
	CRect (const RECT& rect) { left = rect.left; top = rect.top; right = rect.right; bottom = rect.bottom; }
	CRect (long _l, long _t, long _r, long _b) { left = _l; top = _t; right = _r; bottom = _b; }
	operator LPRECT () { return this; }
	CPoint CenterPoint () const { return CPoint((left + right) / 2, (top + bottom) / 2); }
	void operator += (const CPoint& pt) { left += pt.x; top += pt.y; right += pt.x; bottom += pt.y; }
	void operator += (const CSize& sz) { left += sz.cx; top += sz.cy; right += sz.cx; bottom += sz.cy; }
	long Width () const { return right - left; }
	long Height () const { return bottom - top; }
};

extern CRect operator & (const CRect& rt1, const CRect& rt2);

struct FCRegData
{
	BOOL GetIsShowDlgNearMouse () { return TRUE; }
};

extern FCRegData* g_pReg;

#endif//__DynamicMisc_h
