#ifndef __General_h
#define __General_h

#include <windows.h>
#include <tchar.h>
#include <vector>			// For vector.
#include "FmRegExpNFA.h"	// _xZkqqHx_iKePiMpMiCkPjHeCiIoKiCmMiDhHiDgCiDfPiBeC_xHqqkZx_

// STL_xZkqqHx_iCmMjGlMjBePiLpDiKnEiCpAjAnNjCoIiBeC_xHqqkZx_
using namespace std;

#ifdef _UNICODE

#define WCH_ZEN_SPC		0x3000		// '_xZkqqHx_iBeA_xHqqkZx_'

enum WCHAR_KIND
{
	FDCK_NONE = 0,		// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
	FDCK_ANSI_BEGIN,	// _xZkqqHx_iClBiCoKiCoGiCoIiJlKiBgJiImIiPoDiCmMjCgMiBgKiCmN_xHqqkZx_ANSI_xZkqqHx_iLeMiNiGiBeC_xHqqkZx_
	FDCK_ANSI_MARK,		// _xZkqqHx_iLeMiNiG_xHqqkZx_.20-2f 3a-40 5b-60 7b-7e
	FDCK_ANSI_NUM_ALPHABET,	// _xZkqqHx_jAjEiOjKiCmGiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_30-39 41-5a 61-7a
	FDCK_ANSI_ETC,		// _xZkqqHx_iClLiCmMjBlM_xHqqkZx_.
	FDCK_ANSI_END,		// _xZkqqHx_iClBiCoKiCoGiCoIiPoDiBgJiImIiJlKiCmMjCgMiBgKiCmN_xHqqkZx_ANSI_xZkqqHx_iLeMiNiGiBeC_xHqqkZx_
	FDCK_ZENK_BEGIN,	// _xZkqqHx_iClBiCoKiCoGiCoIiJlKiBgJiImIiPoDiCmMjCgMiBgKiCmNjBfDiKhAiLeMiNiGiBeC_xHqqkZx_
	FDCK_ZENK_ALPHABET,	// _xZkqqHx_jBfDiKhAiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_
	FDCK_ZENK_END,		// _xZkqqHx_iClBiCoKiCoGiCoIiPoDiBgJiImIiJlKiCmMjCgMiBgKiCmNjBfDiKhAiLeMiNiGiBeC_xHqqkZx_
	FDCK_OTHER_BEGIN,	// _xZkqqHx_iClBiCoKiCoGiCoIiJlKiCmNiClLiCmMjBlMiCmMiDfCiBfLiDgIiBeC_xHqqkZx_
}; // enum WCHAR_KIND.

#else  // _UNICODE

#define WCH_ZEN_SPC		0x8140		// '_xZkqqHx_iBeA_xHqqkZx_'

enum WCHAR_KIND
{
	FDCK_NONE = 0,		// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
	FDCK_ANSI_NUM_ALPHABET,	// _xZkqqHx_jAjEiOjKiCmGiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_30-39 41-5a 61-7a
	FDCK_ANSI_ETC,		// _xZkqqHx_iClLiCmMjBlMiBeC_xHqqkZx_
	FDCK_HANK_MARK,		// _xZkqqHx_jElMiKhAiLeMiNiGiBeC_xHqqkZx_a1-a5 
	FDCK_HANK_KATAKANA,	// _xZkqqHx_jElMiKhAiDeKiDgJiBeC_xHqqkZx_a6-df
	FDCK_HANK_ETC,		// _xZkqqHx_jElMiKhAiClLiCmMjBlMiBeC_xHqqkZx_
	FDCK_ZENK_MARK,		// _xZkqqHx_jBfDiKhAiLeMiNiGiBeC_xHqqkZx_8140-81FC 84af-84be 8740-879c
	FDCK_ZENK_NUMBER,	// _xZkqqHx_jBfDiKhAjAjEiOjKiBeC_xHqqkZx_824F-8258
	FDCK_ZENK_ALPHABET,	// _xZkqqHx_jBfDiKhAiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_8260-8279 8281-829A
	FDCK_ZENK_HIRAGANA,	// _xZkqqHx_jBfDiKhAiCkJiCmIiBeC_xHqqkZx_829f-82f1
	FDCK_ZENK_KATAKANA,	// _xZkqqHx_jBfDiKhAiDeKiDgJiBeC_xHqqkZx_8340-8396
	FDCK_ZENK_GREEK,	// _xZkqqHx_jBfDiKhAiDeNiDiKiDfGiDiDiBeC_xHqqkZx_839f-83b6 83bf-83d6
	FDCK_ZENK_RUSSIAN,	// _xZkqqHx_jBfDiKhAiDiNiDfGiDeBiBeC_xHqqkZx_8440-8460 8470-8491
	FDCK_ZENK_KANJI,	// _xZkqqHx_jBfDiKhAiKlPiOjKiBeC_xHqqkZx_8890-
	FDCK_ZENK_ETC,		// _xZkqqHx_jBfDiKhAiClLiCmMjBlMiBeC_xHqqkZx_
	FDCK_ZENK_END,		// _xZkqqHx_iClBiCoKiCoGiCoIiPoDiBgJiImIiJlKiCmMjCgMiBgKiCmNjBfDiKhAiLeMiNiGiBeC_xHqqkZx_
}; // enum WCHAR_KIND.

#endif // _UNICODE

enum CHAR_KIND
{
	KND_NONE = 0,		// _xZkqqHx_jGlDiClFiBeC_xHqqkZx_
	KND_NULL_CHR,		// '\0' _xZkqqHx_iLpDjFlGiOjKiBeC_xHqqkZx_
	KND_QUANT_COD,		// +,*,? _xZkqqHx_jHmKiOhHjCoIiOhBiBeC_xHqqkZx_
	KND_ASSERT_COD,		// ^,$,\b _xZkqqHx_iMlOjGlOiOhBiBeC_xHqqkZx_
	KND_RANGE_COD,		// - _xZkqqHx_jEmNiImNiOhHjCoIiOhBiBeC_xHqqkZx_
	KND_ENUM_OPEN_COD,	// [ _xZkqqHx_iDeJiBfLiDhGiDjDjHpBiLjDiOhBiBeC_xHqqkZx_
	KND_ENUM_CLOSE_COD,	// ] _xZkqqHx_iDeOiDiNiBfLiDfJjHpBiLjDiOhBiBeC_xHqqkZx_
	KND_RPARE_OPEN_COD,	// ( _xZkqqHx_iDeJiBfLiDhGiDjDiKnLiKiHiMmKiBeC_xHqqkZx_
	KND_RPARE_CLOSE_COD,// ) _xZkqqHx_iDeOiDiNiBfLiDfJiKnLiKiHiMmKiBeC_xHqqkZx_
	KND_AMBIG_CHR,		// .,\d,\w,\s, _xZkqqHx_jOeCjGiGjFlGiOjKiBeC_xHqqkZx_
	KND_GENERAL_CHR,	// a,A,1,, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
	KND_INVALID_CHR,	// Error. _xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
}; // enum CHAR_KIND.

extern WORD GetWChar (CTCP& tcpStrNext, CTCP tcpStr, CTCP tcpStrEnd);

extern CHAR_KIND GetExpChar (CTCP& tcpStr, WORD& wChar);

extern WCHAR_KIND WCharKind (WORD wChar);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsDigit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAjEiOjKiCpAiNfMjAkMiClHiCoJjFlGiOjK_xHqqkZx_(0-9)_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wC	:_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfMjAkMiClHiCoJjFlGiOjKiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL IsDigit (WORD wC)
{
	return (_T('0') <= wC && wC <= _T('9'));
} // IsDigit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsWordAtom
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCfAiMoKiCpAiNfMjAkMiClHiCoJjFlGiOjK_xHqqkZx_(A-Z,a-z,0-9)_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wC	:_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfMjAkMiClHiCoJjFlGiOjKiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL IsWordAtom (WORD wC)
{
	return ((_T('A') <= wC && wC <= _T('Z')) ||
			(_T('a') <= wC && wC <= _T('z')) ||
			(_T('0') <= wC && wC <= _T('9')));
} // IsWordAtom.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsSpace
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iLpDjEjCiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeCiLpDjEjCiCmGiCmNiBeBiImIiJlKiCmMjFlGiOjKiBeC_xHqqkZx_
 *			_xZkqqHx_jElMiKhAiLpDjEjCiBeBiDfOiDhFiBeBiJpMiNhDiBeBjFjMiLeBiBeBjBfDiKhAiLpDjEjCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wC	:_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNfMjAkMiClHiCoJjFlGiOjKiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL IsSpace (WORD wC)
{
	return (wC == _T(' ') || wC == _T('\t') || wC == _T('\r') || wC == _T('\n') || wC == WCH_ZEN_SPC);
} // IsSpace.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsLineEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNhDjGjGiCkJiCmHiCkEiCkJjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wC	:_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iNhDjGjGjFlGiOjKiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL IsLineEnd (WORD wC)
{
	return (wC == _T('\r') || wC == _T('\n') || wC == _T('\0'));
} // IsLineEnd.

#endif//__General_h

