#ifndef __CBrush_h
#define __CBrush_h

class MfcBrush : public MfcGdiObject
{
public:
	static MfcBrush* New ();
	static void Delete (MfcBrush* pBrush);
	static MfcBrush* FromHandle (HBRUSH hBrush);
	BOOL CreateSolidBrush (COLORREF crColor);
	BOOL CreateHatchBrush (int nIndex, COLORREF crColor);
	BOOL CreateBrushIndirect (const LOGBRUSH* lpLogBrush);
	BOOL CreatePatternBrush (MfcBitmap* pBitmap);
	BOOL CreateDIBPatternBrush (HGLOBAL hPackedDIB, UINT nUsage);
	BOOL CreateDIBPatternBrush (const void* lpPackedDIB, UINT nUsage);
	BOOL CreateSysColorBrush (int nIndex);
	operator HBRUSH () const;
	int GetLogBrush (LOGBRUSH* pLogBrush);

	virtual MfcRuntimeClass* GetRuntimeClass() const;
	virtual ~MfcBrush();

#ifdef _DEBUG
	virtual void Dump(MfcDumpContext& dc) const;
#endif
};

#endif//__CBrush_h
