#ifndef __CDC_h
#define __CDC_h

class MfcDC : public MfcObject
{
public:
	static MfcDC* New ();
	static void Delete (MfcDC* pDC);
	operator HDC () const;
	HDC GetSafeHdc () const;
	MfcWnd* GetWindow () const;
	static MfcDC* FromHandle (HDC hDC);
	static void DeleteTempMap ();
	BOOL Attach (HDC hDC);
	HDC Detach ();
	BOOL IsPrinting () const;
	MfcPen* GetCurrentPen () const;
	MfcBrush* GetCurrentBrush () const;
	MfcPalette* GetCurrentPalette () const;
	MfcFont* GetCurrentFont () const;
	MfcBitmap* GetCurrentBitmap () const;
	DWORD GetLayout () const;
	DWORD SetLayout (DWORD dwLayout);
	BOOL CreateDC (LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData);
	BOOL CreateIC (LPCTSTR lpszDriverName, LPCTSTR lpszDeviceName, LPCTSTR lpszOutput, const void* lpInitData);
	BOOL CreateCompatibleDC (MfcDC* pDC);
	BOOL DeleteDC ();
	int GetDeviceCaps (int nIndex) const;
	UINT SetBoundsRect (LPCRECT lpRectBounds, UINT flags);
	UINT GetBoundsRect (LPRECT lpRectBounds, UINT flags);
	BOOL ResetDC (const DEVMODE* lpDevMode);
	MfcPoint GetBrushOrg () const;
	MfcPoint SetBrushOrg (int x, int y);
	MfcPoint SetBrushOrg (POINT point);
	int EnumObjects (int nObjectType, int (CALLBACK* lpfn) (LPVOID, LPARAM), LPARAM lpData);
	MfcPen* SelectObject (MfcPen* pPen);
	MfcBrush* SelectObject (MfcBrush* pBrush);
	MfcBitmap* SelectObject (MfcBitmap* pBitmap);
	int SelectObject (MfcRgn* pRgn);
	MfcGdiObject* SelectObject (MfcGdiObject* pObject);
	COLORREF GetNearestColor (COLORREF crColor) const;
	MfcPalette* SelectPalette (MfcPalette* pPalette, BOOL bForceBackground);
	UINT RealizePalette ();
	void UpdateColors ();
	COLORREF GetBkColor () const;
	int GetBkMode () const;
	int GetPolyFillMode () const;
	int GetROP2 () const;
	int GetStretchBltMode () const;
	COLORREF GetTextColor () const;
	int SetBkMode (int nBkMode);
	int SetPolyFillMode (int nPolyFillMode);
	int SetROP2 (int nDrawMode);
	int SetStretchBltMode (int nStretchMode);
	BOOL GetColorAdjustment (LPCOLORADJUSTMENT lpColorAdjust) const;
	BOOL SetColorAdjustment (const COLORADJUSTMENT* lpColorAdjust);
	int GetMapMode () const;
	MfcPoint GetViewportOrg () const;
	MfcPoint SetViewportOrg (POINT point);
	MfcSize GetViewportExt () const;
	MfcSize SetViewportExt (SIZE size);
	MfcPoint GetWindowOrg () const;
	MfcPoint SetWindowOrg (int x, int y);
	MfcPoint SetWindowOrg (POINT point);
	MfcPoint OffsetWindowOrg (int nWidth, int nHeight);
	MfcSize GetWindowExt () const;
	MfcSize SetWindowExt (SIZE size);
	void DPtoLP (LPPOINT lpPoints, int nCount = 1) const;
	void DPtoLP (LPRECT lpRect) const;
	void DPtoLP (LPSIZE lpSize) const;
	void LPtoDP (LPPOINT lpPoints, int nCount = 1) const;
	void LPtoDP (LPRECT lpRect) const;
	void LPtoDP (LPSIZE lpSize) const;
	void DPtoHIMETRIC (LPSIZE lpSize) const;
	void LPtoHIMETRIC (LPSIZE lpSize) const;
	void HIMETRICtoDP (LPSIZE lpSize) const;
	void HIMETRICtoLP (LPSIZE lpSize) const;
	BOOL FillRgn (MfcRgn* pRgn, MfcBrush* pBrush);
	BOOL FrameRgn (MfcRgn* pRgn, MfcBrush* pBrush, int nWidth, int nHeight);
	BOOL InvertRgn (MfcRgn* pRgn);
	BOOL PaintRgn (MfcRgn* pRgn);
	BOOL PtVisible (POINT point) const;
	int SelectClipRgn (MfcRgn* pRgn);
	int ExcludeClipRect (int x1, int y1, int x2, int y2);
	int ExcludeClipRect (LPCRECT lpRect);
	int ExcludeUpdateRgn (MfcWnd* pWnd);
	int IntersectClipRect (int x1, int y1, int x2, int y2);
	int IntersectClipRect (LPCRECT lpRect);
	int OffsetClipRgn (int x, int y);
	int OffsetClipRgn (SIZE size);
	int SelectClipRgn (MfcRgn* pRgn, int nMode);
	MfcPoint GetCurrentPosition () const;
	MfcPoint MoveTo (int x, int y);
	MfcPoint MoveTo (POINT point);
	BOOL LineTo (int x, int y);
	BOOL LineTo (POINT point);
	BOOL Arc (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	BOOL Arc (LPCRECT lpRect, POINT ptStart, POINT ptEnd);
	BOOL Polyline (LPPOINT lpPoints, int nCount);
	BOOL AngleArc (int x, int y, int nRadius, float fStartAngle, float fSweepAngle);
	BOOL ArcTo (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	BOOL ArcTo (LPCRECT lpRect, POINT ptStart, POINT ptEnd);
	int GetArcDirection () const;
	int SetArcDirection (int nArcDirection);
	BOOL PolyDraw (const POINT* lpPoints, const BYTE* lpTypes, int nCount);
	BOOL PolylineTo (const POINT* lpPoints, int nCount);
	BOOL PolyPolyline (const POINT* lpPoints, const DWORD* lpPolyPoints, int nCount);
	BOOL PolyBezier (const POINT* lpPoints, int nCount);
	BOOL PolyBezierTo (const POINT* lpPoints, int nCount);
	void FillRect (LPCRECT lpRect, MfcBrush* pBrush);
	void FrameRect (LPCRECT lpRect, MfcBrush* pBrush);
	void InvertRect (LPCRECT lpRect);
	BOOL DrawIcon (int x, int y, HICON hIcon);
	BOOL DrawIcon (POINT point, HICON hIcon);
	BOOL DrawState (MfcPoint pt, MfcSize size, HBITMAP hBitmap, UINT nFlags, HBRUSH hBrush = NULL);
	BOOL DrawState (MfcPoint pt, MfcSize size, MfcBitmap* pBitmap, UINT nFlags, MfcBrush* pBrush = NULL);
	BOOL DrawState (MfcPoint pt, MfcSize size, HICON hIcon, UINT nFlags, HBRUSH hBrush = NULL);
	BOOL DrawState (MfcPoint pt, MfcSize size, HICON hIcon, UINT nFlags, MfcBrush* pBrush = NULL);
	BOOL DrawState (MfcPoint pt, MfcSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText = TRUE, int nTextLen = 0, HBRUSH hBrush = NULL);
	BOOL DrawState (MfcPoint pt, MfcSize size, LPCTSTR lpszText, UINT nFlags, BOOL bPrefixText = TRUE, int nTextLen = 0, MfcBrush* pBrush = NULL);
	BOOL DrawState (MfcPoint pt, MfcSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, HBRUSH hBrush = NULL);
	BOOL DrawState (MfcPoint pt, MfcSize size, DRAWSTATEPROC lpDrawProc, LPARAM lData, UINT nFlags, MfcBrush* pBrush = NULL);
	BOOL Chord (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	BOOL Chord (LPCRECT lpRect, POINT ptStart, POINT ptEnd);
	void DrawFocusRect (LPCRECT lpRect);
	BOOL Ellipse (int x1, int y1, int x2, int y2);
	BOOL Ellipse (LPCRECT lpRect);
	BOOL Pie (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	BOOL Pie (LPCRECT lpRect, POINT ptStart, POINT ptEnd);
	BOOL Polygon (LPPOINT lpPoints, int nCount);
	BOOL PolyPolygon (LPPOINT lpPoints, LPINT lpPolyCounts, int nCount);
	BOOL Rectangle (int x1, int y1, int x2, int y2);
	BOOL Rectangle (LPCRECT lpRect);
	BOOL RoundRect (int x1, int y1, int x2, int y2, int x3, int y3);
	BOOL RoundRect (LPCRECT lpRect, POINT point);
	BOOL PatBlt (int x, int y, int nWidth, int nHeight, DWORD dwRop);
	BOOL BitBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, DWORD dwRop);
	BOOL StretchBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop);
	COLORREF GetPixel (int x, int y) const;
	COLORREF GetPixel (POINT point) const;
	COLORREF SetPixel (int x, int y, COLORREF crColor);
	COLORREF SetPixel (POINT point, COLORREF crColor);
	BOOL FloodFill (int x, int y, COLORREF crColor);
	BOOL ExtFloodFill (int x, int y, COLORREF crColor, UINT nFillType);
	BOOL MaskBlt (int x, int y, int nWidth, int nHeight, MfcDC* pSrcDC, int xSrc, int ySrc, MfcBitmap& maskBitmap, int xMask, int yMask, DWORD dwRop);
	BOOL PlgBlt (LPPOINT lpPoint, MfcDC* pSrcDC, int xSrc, int ySrc, int nWidth, int nHeight, MfcBitmap& maskBitmap, int xMask, int yMask);
	BOOL SetPixelV (int x, int y, COLORREF crColor);
	BOOL SetPixelV (POINT point, COLORREF crColor);
	BOOL TextOut (int x, int y, const MfcString& str);
	BOOL ExtTextOut (int x, int y, UINT nOptions, LPCRECT lpRect, const MfcString& str, LPINT lpDxWidths);
	MfcSize TabbedTextOut (int x, int y, const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions, int nTabOrigin);
	int DrawText (const MfcString& str, LPRECT lpRect, UINT nFormat);
	MfcSize GetTextExtent (LPCTSTR lpszString, int nCount) const;
	MfcSize GetTextExtent (const MfcString& str) const;
	MfcSize GetOutputTextExtent (LPCTSTR lpszString, int nCount) const;
	MfcSize GetOutputTextExtent (const MfcString& str) const;
	MfcSize GetTabbedTextExtent (LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const;
	MfcSize GetTabbedTextExtent (const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions) const;
	MfcSize GetOutputTabbedTextExtent (LPCTSTR lpszString, int nCount, int nTabPositions, LPINT lpnTabStopPositions) const;
	MfcSize GetOutputTabbedTextExtent (const MfcString& str, int nTabPositions, LPINT lpnTabStopPositions) const;
	UINT GetTextAlign () const;
	UINT SetTextAlign (UINT nFlags);
	int GetTextFace (int nCount, LPTSTR lpszFacename) const;
	int GetTextFace (MfcString& rString) const;
	BOOL GetTextMetrics (LPTEXTMETRIC lpMetrics) const;
	BOOL GetOutputTextMetrics (LPTEXTMETRIC lpMetrics) const;
	int SetTextJustification (int nBreakExtra, int nBreakCount);
	int GetTextCharacterExtra () const;
	int SetTextCharacterExtra (int nCharExtra);
	BOOL DrawEdge (LPRECT lpRect, UINT nEdge, UINT nFlags);
	BOOL DrawFrameControl (LPRECT lpRect, UINT nType, UINT nState);
	BOOL ScrollDC (int dx, int dy, LPCRECT lpRectScroll, LPCRECT lpRectClip, MfcRgn* pRgnUpdate, LPRECT lpRectUpdate);
	BOOL GetCharWidth (UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const;
	BOOL GetOutputCharWidth (UINT nFirstChar, UINT nLastChar, LPINT lpBuffer) const;
	DWORD SetMapperFlags (DWORD dwFlag);
	MfcSize GetAspectRatioFilter () const;
	BOOL GetCharABCWidths (UINT nFirstChar, UINT nLastChar, LPABC lpabc) const;
	DWORD GetFontData (DWORD dwTable, DWORD dwOffset, LPVOID lpData, DWORD cbData) const;
	int GetKerningPairs (int nPairs, LPKERNINGPAIR lpkrnpair) const;
	UINT GetOutlineTextMetrics (UINT cbData, LPOUTLINETEXTMETRIC lpotm) const;
	DWORD GetGlyphOutline (UINT nChar, UINT nFormat, LPGLYPHMETRICS lpgm, DWORD cbBuffer, LPVOID lpBuffer, const MAT2* lpmat2) const;
	BOOL GetCharABCWidths (UINT nFirstChar, UINT nLastChar, LPABCFLOAT lpABCF) const;
	BOOL GetCharWidth (UINT nFirstChar, UINT nLastChar, float* lpFloatBuffer) const;
	int Escape (int nEscape, int nInputSize, LPCSTR lpszInputData, int nOutputSize, LPSTR lpszOutputData);
	int DrawEscape (int nEscape, int nInputSize, LPCSTR lpszInputData);
	int StartDoc (LPCTSTR lpszDocName);
	int StartDoc (LPDOCINFO lpDocInfo);
	int StartPage ();
	int EndPage ();
	int SetAbortProc (BOOL (CALLBACK* lpfn) (HDC, int));
	int AbortDoc ();
	int EndDoc ();
	BOOL PlayMetaFile (HMETAFILE hMF);
	BOOL PlayMetaFile (HENHMETAFILE hEnhMetaFile, LPCRECT lpBounds);
	BOOL AddMetaFileComment (UINT nDataSize, const BYTE* pCommentData);
	BOOL AbortPath ();
	BOOL BeginPath ();
	BOOL CloseFigure ();
	BOOL EndPath ();
	BOOL FillPath ();
	BOOL FlattenPath ();
	BOOL StrokeAndFillPath ();
	BOOL StrokePath ();
	BOOL WidenPath ();
	float GetMiterLimit () const;
	BOOL SetMiterLimit (float fMiterLimit);
	int GetPath (LPPOINT lpPoints, LPBYTE lpTypes, int nCount) const;
	BOOL SelectClipPath (int nMode);
	static MfcBrush* GetHalftoneBrush ();
	void DrawDragRect (LPCRECT lpRect, SIZE size, LPCRECT lpRectLast, SIZE sizeLast, MfcBrush* pBrush = NULL, MfcBrush* pBrushLast = NULL);
	void FillSolidRect (LPCRECT lpRect, COLORREF clr);
	void FillSolidRect (int x, int y, int cx, int cy, COLORREF clr);
	void Draw3dRect (LPCRECT lpRect, COLORREF clrTopLeft, COLORREF clrBottomRight);
	void Draw3dRect (int x, int y, int cx, int cy, COLORREF clrTopLeft, COLORREF clrBottomRight);
	BOOL m_bPrinting;
	HGDIOBJ SelectObject (HGDIOBJ);

public:
	virtual void SetAttribDC (HDC hDC) = 0;  // Set the Attribute DC
	virtual void SetOutputDC (HDC hDC) = 0;  // Set the Output DC
	virtual void ReleaseAttribDC () = 0;     // Release the Attribute DC
	virtual void ReleaseOutputDC () = 0;     // Release the Output DC

	virtual int SaveDC  () = 0;
	virtual BOOL RestoreDC (int nSavedDC) = 0;

	virtual MfcGdiObject* SelectStockObject (int nIndex) = 0;
	virtual MfcFont* SelectObject (MfcFont* pFont) = 0;
	virtual COLORREF SetBkColor (COLORREF crColor) = 0;
	virtual COLORREF SetTextColor (COLORREF crColor) = 0;

	virtual int SetMapMode (int nMapMode) = 0;
	virtual MfcPoint SetViewportOrg (int x, int y) = 0;
	virtual MfcPoint OffsetViewportOrg (int nWidth, int nHeight) = 0;

	virtual MfcSize SetViewportExt (int cx, int cy) = 0;
	virtual MfcSize ScaleViewportExt (int xNum, int xDenom, int yNum, int yDenom) = 0;
	virtual MfcSize SetWindowExt (int cx, int cy) = 0;
	virtual MfcSize ScaleWindowExt (int xNum, int xDenom, int yNum, int yDenom) = 0;
	virtual int GetClipBox (LPRECT lpRect) const = 0;
	virtual BOOL PtVisible (int x, int y) const = 0;
	virtual BOOL RectVisible (LPCRECT lpRect) const = 0;
	virtual BOOL TextOut (int x, int y, LPCTSTR lpszString, int nCount) = 0;
	virtual BOOL ExtTextOut (int x, int y, UINT nOptions, LPCRECT lpRect,
				LPCTSTR lpszString, UINT nCount, LPINT lpDxWidths) = 0;
	virtual MfcSize TabbedTextOut (int x, int y, LPCTSTR lpszString, int nCount,
				int nTabPositions, LPINT lpnTabStopPositions, int nTabOrigin) = 0;
	virtual int DrawText (LPCTSTR lpszString, int nCount, LPRECT lpRect,
				UINT nFormat) = 0;
	virtual BOOL GrayString (MfcBrush* pBrush,
						BOOL (CALLBACK* lpfnOutput)(HDC, LPARAM, int), LPARAM lpData,
						int nCount, int x, int y, int nWidth, int nHeight) = 0;
	virtual int Escape (int nEscape, int nCount,
						LPCSTR lpszInData, LPVOID lpOutData) = 0;
	virtual ~MfcDC () = 0;

#ifdef _DEBUG
	virtual void AssertValid () const = 0;
	virtual void Dump (MfcDumpContext& dc) const = 0;
#endif
};

#endif//__CDC_h
