#ifndef __COleDocument_h
#define __COleDocument_h

class MfcOleDocument : public MfcDocument
{
	virtual MfcRuntimeClass* GetRuntimeClass() const;

// Constructors
public:

// Attributes
	virtual MfcOleClientItem* GetInPlaceActiveItem(MfcWnd* pWnd);
		// return in-place active item for this view or NULL if none

// Operations
	// iterating over existing items
	virtual MFC_POSITION GetStartPosition() const;
	virtual MfcDocItem* GetNextItem(MFC_POSITION& pos) const;

	// iterator helpers (helpers use virtual GetNextItem above)

	// adding new items - called from item constructors
	virtual void AddItem(MfcDocItem* pItem);
	virtual void RemoveItem(MfcDocItem* pItem);

	virtual void UpdateModifiedFlag();
		// scan for modified items -- mark document modified

// Overridables
	virtual MfcOleClientItem* GetPrimarySelectedItem(MfcView* pView);
		// return primary selected item or NULL if none
	virtual void OnShowViews(BOOL bVisible);
		// called during app-idle when visibility of a document has changed

// Implementation

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(MfcDumpContext& dc) const;
#endif

	// document handling overrides
	virtual void SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU = TRUE);
	virtual ~MfcOleDocument();
	virtual void DeleteContents(); // delete client items in list
	virtual void Serialize(MfcArchive& ar);   // serialize items to file
	virtual void PreCloseFrame(MfcFrameWnd* pFrame);
	virtual BOOL SaveModified();
	virtual void OnIdle();

	// compound file implementation
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual void OnCloseDocument();

	// minimal linking protocol
	virtual LPMONIKER GetMoniker(OLEGETMONIKER nAssign);
	virtual LPOLEITEMCONTAINER GetContainer();

protected:
	// document state implementation

	// implementation helpers
	virtual void LoadFromStorage();
	virtual void SaveToStorage(MfcObject* pObject = NULL);
// 05.05.12 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	MfcDocItem* GetNextItemOfKind(MFC_POSITION& pos, MfcRuntimeClass* pClass) const;

	// command handling
public:
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra,
		AFX_MFC_CMDHANDLERINFO* pHandlerInfo);
};

#endif//__COleDocument_h
