#ifndef __COleServerDoc_h
#define __COleServerDoc_h

class MfcOleServerDoc : public MfcOleLinkingDoc
{
	virtual MfcRuntimeClass* GetRuntimeClass() const;

// Constructors and Destructors
public:

// Attributes

public:
// Overridables for standard user interface (full server)
	virtual BOOL OnUpdateDocument(); // implementation of embedded update

protected:
// Overridables you must implement for yourself
	virtual MfcOleServerItem* OnGetEmbeddedItem() = 0;
		// return item representing entire (embedded) document

// Overridables you do not have to implement
	virtual void OnClose(OLECLOSE dwCloseOption);
	virtual void OnSetHostNames(LPCTSTR lpszHost, LPCTSTR lpszHostObj);
	virtual HRESULT OnExecOleCmd(const GUID* pguidCmdGroup, DWORD nCmdID,
		DWORD nCmdExecOpt, VARIANTARG* pvarargIn, VARIANTARG* pvarargOut);
	virtual MfcDocObjectServer* GetDocObjectServer(LPOLEDOCUMENTSITE pDocSite);

// Advanced overridables
	virtual void OnShowDocument(BOOL bShow);
		// show first frame for document or hide all frames for document

// Advanced overridables for in-place activation
public:
	virtual void OnDeactivate();
	virtual void OnDeactivateUI(BOOL bUndoable);

protected:
	virtual void OnSetItemRects(LPCRECT lpPosRect, LPCRECT lpClipRect);
	virtual BOOL OnReactivateAndUndo();

	virtual void OnFrameWindowActivate(BOOL bActivate);
	virtual void OnDocWindowActivate(BOOL bActivate);
	virtual void OnShowControlBars(MfcFrameWnd* pFrameWnd, BOOL bShow);
	virtual MfcOleIPFrameWnd* CreateInPlaceFrame(MfcWnd* pParentWnd);
	virtual void DestroyInPlaceFrame(MfcOleIPFrameWnd* pFrameWnd);
public:
	virtual void OnResizeBorder(LPCRECT lpRectBorder,
		LPOLEINPLACEUIWINDOW lpUIWindow, BOOL bFrame);

// Implementation
protected:

public:
	virtual ~MfcOleServerDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(MfcDumpContext& dc) const;
#endif

	// overridables for implementation
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual void OnCloseDocument();
	virtual void DeleteContents(); // delete auto-delete server items
	virtual LPMONIKER GetMoniker(OLEGETMONIKER nAssign);
	virtual MfcOleServerItem* OnGetLinkedItem(LPCTSTR lpszItemName);
		// return item for the named linked item (only if supporting links)
	virtual BOOL CanCloseFrame(MfcFrameWnd* pFrame);

protected:
	// overrides to handle server user-interface
	virtual BOOL SaveModified();        // return TRUE if ok to continue
	virtual HMENU GetDefaultMenu();     // return menu based on doc type
	virtual HACCEL GetDefaultAccelerator(); // return accel table based on doc type
	virtual BOOL GetFileTypeString(MfcString& rString);

	// IPersistStorage implementation
	virtual void OnNewEmbedding(LPSTORAGE lpStorage);
	virtual void OnOpenEmbedding(LPSTORAGE lpStorage);
	virtual void OnSaveEmbedding(LPSTORAGE lpStorage);

	// Implementation helpers
	virtual const AFX_MFC_MSGMAP* GetMessageMap() const;

// Interface Maps
public:
	virtual const AFX_MFC_INTERFACEMAP* GetInterfaceMap() const;
};

#endif//__COleServerDoc_h
