#include "stdafx.h"
#include <set>			// For set.
#include <algorithm>	// For find template.
#include  <math.h>		// For fabs.
#include "resource.h"	// For IDS_XX.
#include "2UtilFont.h"	// For MC2FontCharInfo.
#include "2NewFDObjAny.h"
#include "2ObjBase.h"	// For MC2ObjBase.
#include "2Env.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define CH_SPC	_T(0x20)


//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
////----- BYTEVector_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiKnGjIeB_xHqqkZx_ -----
//template <class T> void operator << (BYTEVector& vStream, const T data)
//{
//	vStream.insert(vStream.end(), (const BYTE*)(&data),
//					(const BYTE*)(&data) + sizeof(data));
//} // template <class T> void operator <<.
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/////////////////////////////////////////////////////////////////////////
// class MC2PenRegisterRec

MC2PenRegisterRec::MC2PenRegisterRec ()
{
	/*----- _xZkqqHx_jBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----*/
	m_psidPenStyle		= static_cast<PenStyleID>(-1);
	m_mmfPenWeight		= static_cast<float>(-1);
	m_scidPenBackSColor	= static_cast<SColorID>(-1);
	m_szName[0]			= L'\0';
} // MC2PenRegisterRec::MC2PenRegisterRec.

void MC2PenRegisterRec::InStreamV12 (MCARCHIVE& ar)
{
	BYTE byPenType;
	PatternIDV12 ptidPenPattern;
	SColorID scidPenForeSColor;
	SColorID scidPenBackSColor;
	PenStyleIDV12 psidPenStyle;
	fmmetol mmfPenWeight;
	ar >> byPenType;			// PEN_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	ar >> psidPenStyle;			// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	ar >> ptidPenPattern;		// PEN_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_.
	ar >> mmfPenWeight;			// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
	ar >> scidPenForeSColor;
	ar >> scidPenBackSColor;	// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	m_psidPenStyle = psidPenStyle;
	if (byPenType == FDPT_TRANSP)
	//----- _xZkqqHx_jDkHjGlOiDhJiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_scidPenBackSColor = FD_S_COLOR_TRANSPARENT;
		m_mmfPenWeight = 0.0;
		m_psidPenStyle = FD_PEN_STYLE_UNUSE;
	} else
	if (byPenType == FDPT_PATTERN)
	//----- _xZkqqHx_iDhAiDfOiBfLiDjDiDhJiDjDiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_scidPenBackSColor = scidPenBackSColor;	// _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
		m_mmfPenWeight = mmfPenWeight;				// _xZkqqHx_iDhJiDjDiCmMjFjNiBeC_xHqqkZx_4Byte_xZkqqHx_iBeC_xHqqkZx_
		m_psidPenStyle = psidPenStyle;				// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBeCjClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc_xZkqqHx_iBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
	} else
	//----- _xZkqqHx_jDgPjIfOiDhJiDjDiBeBjDkHjGlOiDhJiDjDiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_scidPenBackSColor = scidPenForeSColor;	// _xZkqqHx_iDhJiDjDiCmMjBePiMgJjAeGiBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
		m_mmfPenWeight = mmfPenWeight;				// _xZkqqHx_iDhJiDjDiCmMjFjNiBeC_xHqqkZx_4Byte_xZkqqHx_iBeC_xHqqkZx_
		m_psidPenStyle = psidPenStyle;				// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBeCjClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc_xZkqqHx_iBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
	}
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	FFInNameV12(ar, m_szName);
} // MC2PenRegisterRec::InStreamV12.

void MC2PenRegisterRec::OutStreamV3 (MCARCHIVE& ar) const
{
	ar << m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	ar << m_mmfPenWeight;		// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
	ar << m_scidPenBackSColor;	// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	const BYTE byNameLen = (BYTE)wcslen(m_szName);
	ar << byNameLen;
	ar.Write(m_szName, byNameLen * sizeof(m_szName[0]));
} // MC2PenRegisterRec::OutStreamV3.

/////////////////////////////////////////////////////////////////////////
// class MC2BrushRegisterRec

MC2BrushRegisterRec::MC2BrushRegisterRec ()
{
	/*----- _xZkqqHx_jBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----*/
	m_ptidBrushPattern = static_cast<PatternID>(-1);
	m_scidBrushForeSColor = static_cast<SColorID>(-1);
	m_scidBrushBackSColor = static_cast<SColorID>(-1);
	m_szName[0] = L'\0';
} // MC2BrushRegisterRec::MC2BrushRegisterRec.

void MC2BrushRegisterRec::InStreamV12 (MCARCHIVE& ar)
{
	BYTE byBrushType;
	PatternIDV12 ptidBrushPattern;
	SColorID scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	SColorID scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_

	ar >> byBrushType;			// BRUSH_xZkqqHx_iCmMiMfOiBeCjGhLjHiI_xHqqkZx_4bit.
	ar >> ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
	ar >> scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar >> scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	if (byBrushType == FDBT_TRANSP)
	//----- _xZkqqHx_jDkHjGlOiDhFiDiJiDfGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		m_ptidBrushPattern = FD_PATTERN_UNUSE;
		m_scidBrushForeSColor = FD_S_COLOR_TRANSPARENT;
		m_scidBrushBackSColor = FD_S_COLOR_TRANSPARENT;
	} else
	if (byBrushType == FDBT_PATTERN)
	//----- _xZkqqHx_iDhAiDfOiBfLiDjDiDhFiDiJiDfGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDhAiDfOiBfLiDjDiCmMiPoKiNiHiCmNiBeBjBePiMgJjAeGiBeFjEhHiMgJjAeGiCmMjDpMjBnGiCkGiCmNjGlDiClFiBeC_xHqqkZx_
		m_scidBrushForeSColor = scidBrushForeSColor;	// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
		m_scidBrushBackSColor = scidBrushBackSColor;	// _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
		switch (ptidBrushPattern)
		{
		case 0:		// "_xZkqqHx_jDfP_xHqqkZx_94%"
		case 1:		// "_xZkqqHx_jDfP_xHqqkZx_88%"
			m_ptidBrushPattern = 0;	// "_xZkqqHx_jDfP_xHqqkZx_99%"
			break;
		case 2:		// "_xZkqqHx_jDfP_xHqqkZx_81%"
		case 3:		// "_xZkqqHx_jDfP_xHqqkZx_75%"
			m_ptidBrushPattern = 1;	// "_xZkqqHx_jDfP_xHqqkZx_96%"
			break;
		case 4:		// "_xZkqqHx_jDfP_xHqqkZx_69%"
		case 5:		// "_xZkqqHx_jDfP_xHqqkZx_63%"
			m_ptidBrushPattern = 2;	// "_xZkqqHx_jDfP_xHqqkZx_82%"
			break;
		case 6:		// "_xZkqqHx_jDfP_xHqqkZx_56%"
		case 7:		// "_xZkqqHx_jDfP_xHqqkZx_50%"
			m_ptidBrushPattern = 3;	// "_xZkqqHx_jDfP_xHqqkZx_50%"
			break;
		case 8:		// "_xZkqqHx_jDfP_xHqqkZx_44%"
		case 9:		// "_xZkqqHx_jDfP_xHqqkZx_38%"
			m_ptidBrushPattern = 4;	// "_xZkqqHx_jDfP_xHqqkZx_22%"
			break;
		case 10:		// "_xZkqqHx_jDfP_xHqqkZx_31%"
		case 11:		// "_xZkqqHx_jDfP_xHqqkZx_25%"
			m_ptidBrushPattern = 5;	// "_xZkqqHx_jDfP_xHqqkZx_7%"
			break;
		case 12:		// "_xZkqqHx_jDfP_xHqqkZx_19%"
		case 13:		// "_xZkqqHx_jDfP_xHqqkZx_13%"
		case 14:		// "_xZkqqHx_jDfP_xHqqkZx_6%"
			m_ptidBrushPattern = 6;	// "_xZkqqHx_jDfP_xHqqkZx_3%"
			break;
		case 15:		// "_xZkqqHx_jBgFiPgDjApM_xHqqkZx_"
			m_ptidBrushPattern = 8;	// "_xZkqqHx_jFmAiNnHiPgDjApM_xHqqkZx_"
			break;
		case 16:		// "_xZkqqHx_jGkHiPgDjApM_xHqqkZx_"
			m_ptidBrushPattern = 9;	// "_xZkqqHx_jGkHiNnHiPgDjApM_xHqqkZx_"
			break;
		case 17:		// "_xZkqqHx_jBgFiJkBjApM_xHqqkZx_"
			m_ptidBrushPattern = 14;	// "_xZkqqHx_jFmAiNnHiJkBjApM_xHqqkZx_"
			break;
		case 18:		// "_xZkqqHx_jGkHiJkBjApM_xHqqkZx_"
			m_ptidBrushPattern = 15;	// "_xZkqqHx_jGkHiNnHiJkBjApM_xHqqkZx_"
			break;
		case 19:		// "_xZkqqHx_jBgFiJeFiOmOjApM_xHqqkZx_"
			m_ptidBrushPattern = 20;	// "_xZkqqHx_jFmAiNnHiJeFiOmOjApM_xHqqkZx_"
			break;
		case 20:		// "_xZkqqHx_jGkHiJeFiOmOjApM_xHqqkZx_"
			m_ptidBrushPattern = 21;	// "_xZkqqHx_jGkHiNnHiJeFiOmOjApM_xHqqkZx_"
			break;
		case 21:		// "_xZkqqHx_jBgFiNlGiOmOjApM_xHqqkZx_"
			m_ptidBrushPattern = 26;	// "_xZkqqHx_jFmAiNnHiNlGiOmOjApM_xHqqkZx_"
			break;
		case 22:		// "_xZkqqHx_jGkHiNlGiOmOjApM_xHqqkZx_"
			m_ptidBrushPattern = 27;	// "_xZkqqHx_jGkHiNnHiNlGiOmOjApM_xHqqkZx_"
			break;
		case 23:		// "_xZkqqHx_jBgFiKgJiOhB_xHqqkZx_"
			m_ptidBrushPattern = 32;	// "_xZkqqHx_jFmAiNnHiKgJiOhB_xHqqkZx_"
			break;
		case 24:		// "_xZkqqHx_jGkHiKgJiOhB_xHqqkZx_"
			m_ptidBrushPattern = 33;	// "_xZkqqHx_jGkHiNnHiKgJiOhB_xHqqkZx_"
			break;
		case 25:		// "_xZkqqHx_iOmOiKgJiOhB_xHqqkZx_"
			m_ptidBrushPattern = 39;	// "_xZkqqHx_jGkHiNnHiOmOiKgJiOhB_xHqqkZx_"
			break;
		case 26:		// "_xZkqqHx_jBgFiJkBjEgH_xHqqkZx_"
			m_ptidBrushPattern = 44;	// "_xZkqqHx_jFmAiNnHiJkBjEgH_xHqqkZx_"
			break;
		case 27:		// "_xZkqqHx_jGkHiJkBjEgH_xHqqkZx_"
			m_ptidBrushPattern = 45;	// "_xZkqqHx_jGkHiNnHiJkBjEgH_xHqqkZx_"
			break;
		case 28:		// "_xZkqqHx_jBgFiPgDjEgH_xHqqkZx_"
			m_ptidBrushPattern = 50;	// "_xZkqqHx_jFmAiNnHiPgDjEgH_xHqqkZx_"
			break;
		case 29:		// "_xZkqqHx_jGkHiPgDjEgH_xHqqkZx_"
			m_ptidBrushPattern = 51;	// "_xZkqqHx_jGkHiNnHiPgDjEgH_xHqqkZx_"
			break;
		case 30:		// "_xZkqqHx_jBgFiJeFiOmOjEgH_xHqqkZx_"
			m_ptidBrushPattern = 47;	// "_xZkqqHx_jFmAjBlOiJkBjEgH_xHqqkZx_"
			break;
		case 31:		// "_xZkqqHx_jGkHiJeFiOmOjEgH_xHqqkZx_"
			m_ptidBrushPattern = 48;	// "_xZkqqHx_jGkHjBlOiJkBjEgH_xHqqkZx_"
			break;
		case 32:		// "_xZkqqHx_jBgFiNlGiOmOjEgH_xHqqkZx_"
			m_ptidBrushPattern = 53;	// "_xZkqqHx_jFmAjBlOiPgDjEgH_xHqqkZx_"
			break;
		case 33:		// "_xZkqqHx_jGkHiNlGiOmOjEgH_xHqqkZx_"
			m_ptidBrushPattern = 54;	// "_xZkqqHx_jGkHjBlOiPgDjEgH_xHqqkZx_"
			break;
		}
	} else
	//----- _xZkqqHx_jDgPjIfOiBeBjDkHjGlOiBeBiDhAiDfOiBfLiDjDiDhFiDiJiDfGiImIiKePiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jEhHiMgJjAeGiCmNiLiMjBePiMgJjAeGiBeC_xHqqkZx_
		m_scidBrushForeSColor = FD_S_COLOR_UNUSE;			// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
		m_scidBrushBackSColor = scidBrushForeSColor;		// _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
		m_ptidBrushPattern = FD_PATTERN_UNUSE;				// _xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjDiBeC_xHqqkZx_2Byte_xZkqqHx_iBeC_xHqqkZx_
	}
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	FFInNameV12(ar, m_szName);
} // MC2BrushRegisterRec::InStreamV12.

void MC2BrushRegisterRec::OutStreamV3 (MCARCHIVE& ar) const
{
	ar << m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
	ar << m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar << m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	const BYTE byNameLen = (BYTE)wcslen(m_szName);
	ar << byNameLen;
	ar.Write(m_szName, byNameLen * sizeof(m_szName[0]));
} // MC2BrushRegisterRec::OutStreamV3.

/////////////////////////////////////////////////////////////////////////
// class MC2SFontRec

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRecV12::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjDpMjHmNjHhAiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SFontRecV12::InStream (MCARCHIVE& ar)
{
	ar.Read(this, sizeof(*this));
} // MC2SFontRecV12::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
MC2SFontRec::MC2SFontRec () {};

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci2	: _xZkqqHx_iPiJiKpKiJlLjHhAiCmM_xHqqkZx_MC2FontCharInfo_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2SFontRec::MC2SFontRec (const MC2FontCharInfo& fci2)
{
	Init(fci2);
} // MC2SFontRec::MC2SFontRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::operator =
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiPoOjFpBiCmMiDfCiDhDiBfL_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	prop	: MC2SFontRec
 *************************************************************************/
void MC2SFontRec::operator = (const MC2SFontRec& prop)
{
	memcpy(this, &prop, sizeof(*this));
} // MC2SFontRec::operator =.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::operator ==
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiPoOjFpBiCmMjEoEiKhCiBeC_xHqqkZx_RegisterFont_xZkqqHx_iKnGjAjEjCiGiCmM_xHqqkZx_find_xZkqqHx_iCmFiOgHjHhAiBeC_xHqqkZx_
 *			TEXTMETRIC_xZkqqHx_iPoOjFpBiCmNjEoEiKhCiClFiCmIiCkC_xHqqkZx_._xZkqqHx_iClBiCoKiCmN_xHqqkZx_FONT_xZkqqHx_jAlGjAkMiCmJjFeLjHhGiCmIiPoOjFpBiCmFiCmN_xHqqkZx_
 *			_xZkqqHx_iCmIiCkCiCkJiCoH_xHqqkZx_.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	prop	: MC2SFontRec
 *************************************************************************/
BOOL MC2SFontRec::operator == (const MC2SFontRec& prop) const
{
	return	(m_mmFontHeight == prop.m_mmFontHeight) &&
			(m_wWeight == prop.m_wWeight) &&
			(m_byItalic == prop.m_byItalic) &&
			(m_byCharSet == prop.m_byCharSet) &&
			(m_byPitchAndFamily == prop.m_byPitchAndFamily) &&
			(wcscmp(m_szFaceName, prop.m_szFaceName) == 0);
} // MC2SFontRec::operator ==.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::OutStreamV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAiPgPjHmNjHhAiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::OutStreamV3 (MCARCHIVE& ar) const
{
	ar << m_mmFontHeight;
	ar << m_wWeight;
	ar << m_byItalic;
	ar << m_byCharSet;
	ar << m_byPitchAndFamily;
	// _xZkqqHx_iDhEiDeIiDjDiDgHjGlMiBeC_xHqqkZx_
	const WORD wNameLen = (WORD)wcslen(m_szFaceName);
	ar << wNameLen;
	ar.Write(m_szFaceName, wNameLen * sizeof(m_szFaceName[0]));
} // MC2SFontRec::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::InStreamV12
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDfIiDgHiDiKiBfLiDiAjDpMjHmNjHhAiDeBiBfLiDeKiDeDiDhFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::InStreamV12 (MCARCHIVE& ar)
{
	MC2SFontRecV12 rec2;
	ar.Read(&rec2, sizeof(rec2));
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjCfLiCpAjBhNjDpMiBeCiDgGiBfLiDfOiCkKiJpDiCoKiCmEiCkCiCoJiBeFiDeJiBfLiDgPiBfLiDiJiDeDiDgHiCpAjGgIiCkOiClNiCnPiBeC_xHqqkZx_
	rec2.m_szFaceName[LF_FACESIZE - 1] = '\0';
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_jAlDjFiJiLhEjDfNiBeCiLiMiMgAiOkOiCmFiCmNjFiJiBeC_xHqqkZx_
	m_mmFontHeight = fabs(rec2.m_mmFontHeight);
	// m_dwEffects_xZkqqHx_iCmNjFlGiOjKiCmM_xHqqkZx_V2->V3_xZkqqHx_jFmPiKlHjHhAiCmJjFeLjHhGiBeC_xHqqkZx_
	m_dwEffects = rec2.m_dwEffects;
	m_wWeight = (rec2.m_dwEffects & CFE_BOLD) ? FW_BOLD : FW_NORMAL;
	m_byItalic = (rec2.m_dwEffects & CFE_ITALIC) ? TRUE : FALSE;
	m_byCharSet = rec2.m_byCharSet;
	m_byPitchAndFamily = rec2.m_byPitchAndFamily;
	wcscpy(m_szFaceName, AStrToWStr(rec2.m_szFaceName));
	// _xZkqqHx_iClLiCmMjBlMiCmMiPoOjFpBiCmMiOfKiPgPiBeC_xHqqkZx_
	InitMetric();
} // MC2SFontRec::InStreamV12.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::ReqInit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDhEiDeIiDjDiDgHiCmMiDhGiDiNiDhAiDgFiDeCiCmF_xHqqkZx_LOGFONT_xZkqqHx_iNfMjBkCjBmMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lf	:LOGFONT_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_
 *
 * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	g_dZoom	: logfont_xZkqqHx_iCmMiNiCiClDiCmMiMhGiOfKiCmJiOgHiCoNiCoKiCoJiBeCjFlGiOjKiCmM_xHqqkZx_V1->V2_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::ReqInit (LOGFONT& lf) const
{
	lf.lfHeight = -mm2lg(m_mmFontHeight);
	lf.lfWidth = 0;
	lf.lfEscapement = 0;
	lf.lfOrientation = 0;
	lf.lfWeight	= m_wWeight;
	lf.lfItalic	= m_byItalic;
	lf.lfUnderline	= 0;
	lf.lfStrikeOut	= 0;
	lf.lfCharSet	= m_byCharSet;
	lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lf.lfQuality	= DEFAULT_QUALITY;
	lf.lfPitchAndFamily = m_byPitchAndFamily;
	_tcscpy(lf.lfFaceName, WStrToTStr(m_szFaceName));
} // MC2SFontRec::ReqInit.

//----- 02.08.30 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (TrueType_xZkqqHx_iCmFiCmNiCmIiCkCiDhEiDeIiDjDiDgHiCkKiOgHiCoNiCoKiCmEiClFiCnMiCkEiPoKiNiHiCkKiCkAiCoJ_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::ReqInit
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDhEiDeIiDjDiDgHiCmMiDhGiDiNiDhAiDgFiDeCiCmF_xHqqkZx_MC2FontCharInfo_xZkqqHx_iNfMjBkCjBmMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci2	:MC2FontCharInfo_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::ReqInit (MC2FontCharInfo& fci2) const
{
	fci2.dwMask = FDFI_FLAG_HEIGHT | FDFI_FLAG_WEIGHT | FDFI_FLAG_ITALIC |
					FDFI_FLAG_CHARSET | FDFI_FLAG_FACENAME;
	fci2.mmHeight		= m_mmFontHeight;
	fci2.wWeight			= m_wWeight;
	fci2.byItalic		= m_byItalic;
	fci2.byCharSet		= m_byCharSet;
	fci2.byPitchAndFamily= m_byPitchAndFamily;
	::_tcscpy(fci2.szFaceName, WStrToTStr(m_szFaceName));
} // MC2SFontRec::ReqInit.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::ReqInitW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDhEiDeIiDjDiDgHiCmMiDhGiDiNiDhAiDgFiDeCiCmF_xHqqkZx_LOGFONTW_xZkqqHx_iNfMjBkCjBmMiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lf	:LOGFONTW_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_
 *
 * <_xZkqqHx_jFmPjAjE_xHqqkZx_>	g_dZoom	: logfont_xZkqqHx_iCmMiNiCiClDiCmMiMhGiOfKiCmJiOgHiCoNiCoKiCoJiBeCjFlGiOjKiCmM_xHqqkZx_V1->V2_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::ReqInitW (LOGFONTW& lf) const
{
	lf.lfHeight = -mm2lg(m_mmFontHeight);
	lf.lfWidth = 0;
	lf.lfEscapement = 0;
	lf.lfOrientation = 0;
	lf.lfWeight	= m_wWeight;
	lf.lfItalic	= m_byItalic;
	lf.lfUnderline	= 0;
	lf.lfStrikeOut	= 0;
	lf.lfCharSet	= m_byCharSet;
	lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lf.lfQuality	= DEFAULT_QUALITY;
	lf.lfPitchAndFamily = m_byPitchAndFamily;
	wcscpy(lf.lfFaceName, m_szFaceName);
} // MC2SFontRec::ReqInitW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::MC2SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	fci2	: _xZkqqHx_iPiJiKpKiJlLjHhAiCmM_xHqqkZx_MC2FontCharInfo_xZkqqHx_iNfMjBkCjBmMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.04.18 Fukushiro M. dZoom_xZkqqHx_jFmPjAjEiCpAjCmHiJmBiBeC_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::Init (const MC2FontCharInfo& fci2)
{
	// _xZkqqHx_jBfDiCmEiCmMiDhNiDfIiDeOiCkKjAnNjCoIiClDiCoKiCmEiCkCiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	ASSERT((fci2.dwMask & FDFI_FLAG_ALL) == FDFI_FLAG_ALL);
	m_mmFontHeight	= fci2.mmHeight;
	m_wWeight		= fci2.wWeight;
	m_byItalic		= fci2.byItalic;
	m_byCharSet		= fci2.byCharSet;
	m_byPitchAndFamily = fci2.byPitchAndFamily;
	::wcscpy(m_szFaceName, AStrToWStr(fci2.szFaceName));
} // MC2SFontRec::Init.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumTrueTypeFontProc
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumFontFamiliesEx_xZkqqHx_iCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_TrueType_xZkqqHx_iCmMiDhEiDeIiDjDiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpelfe		:logical-font data
 *			lpntme		:physical-font data
 *			FontType	:type of font
 *			lParam		:application-defined data
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	The return value must be a nonzero value to continue enumeration;
 *			to stop enumeration, the return value must be zero.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.27 Fukushiro M. FDExtern.cpp_xZkqqHx_iCkJiCoHiDfCiDhDiBfLiBeC_xHqqkZx_
 *************************************************************************/
static int CALLBACK EnumTrueTypeFontProc (
  ENUMLOGFONTEX *lpelfe,    // logical-font data
  NEWTEXTMETRICEX *lpntme,  // physical-font data
  DWORD FontType,           // type of font
  LPARAM lParam             // application-defined data
)
{
	if (FontType & TRUETYPE_FONTTYPE)
	{
		LOGFONT& lf = *((LOGFONT*)lParam);
		lf.lfCharSet = lpelfe->elfLogFont.lfCharSet;
		lf.lfPitchAndFamily = lpelfe->elfLogFont.lfPitchAndFamily;
		_tcscpy(lf.lfFaceName, lpelfe->elfLogFont.lfFaceName);
		// _xZkqqHx_iMhAjBlBiClFiCmE_xHqqkZx_Enum_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
		return 0;
	} else
	{
		// _xZkqqHx_iMhAjBlBiClFiCmE_xHqqkZx_Enum_xZkqqHx_iBeC_xHqqkZx_
		return 1;
	}
} // EnumTrueTypeFontProc.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	EnumTrueTypeFontProcW
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	EnumFontFamiliesExW_xZkqqHx_iCmMiDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiBeC_xHqqkZx_TrueType_xZkqqHx_iCmMiDhEiDeIiDjDiDgHiCpAiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lpelfe		:logical-font data
 *			lpntme		:physical-font data
 *			FontType	:type of font
 *			lParam		:application-defined data
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	The return value must be a nonzero value to continue enumeration;
 *			to stop enumeration, the return value must be zero.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.08.27 Fukushiro M. FDExtern.cpp_xZkqqHx_iCkJiCoHiDfCiDhDiBfLiBeC_xHqqkZx_
 *************************************************************************/
static int CALLBACK EnumTrueTypeFontProcW (
  ENUMLOGFONTEXW *lpelfe,    // logical-font data
  NEWTEXTMETRICEXW *lpntme,  // physical-font data
  DWORD FontType,           // type of font
  LPARAM lParam             // application-defined data
)
{
	if (FontType & TRUETYPE_FONTTYPE)
	{
		LOGFONTW& lf = *((LOGFONTW*)lParam);
		lf.lfCharSet = lpelfe->elfLogFont.lfCharSet;
		lf.lfPitchAndFamily = lpelfe->elfLogFont.lfPitchAndFamily;
		wcscpy(lf.lfFaceName, lpelfe->elfLogFont.lfFaceName);
		// _xZkqqHx_iMhAjBlBiClFiCmE_xHqqkZx_Enum_xZkqqHx_iClFiCmIiCkCiBeC_xHqqkZx_
		return 0;
	} else
	{
		// _xZkqqHx_iMhAjBlBiClFiCmE_xHqqkZx_Enum_xZkqqHx_iBeC_xHqqkZx_
		return 1;
	}
} // EnumTrueTypeFontProcW.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2SFontRec::InitMetric
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDfEiDeDiDfJiPoOjFpBiCpAiMhGiOfKiClFiCmEiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2SFontRec::InitMetric ()
{
	CDC dc;
	dc.CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	// _xZkqqHx_iCnMiClI_xHqqkZx_Zoom_xZkqqHx_iCpAiDgPiDgCiDeOiDeBiDgCiDhGiClFiBeBjFfHiPiAjCgMiCmJjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	const double dZoom = g_dZoom;
	g_dZoom = g_dDisplayPPM * 64.0;

#if defined(_MBCS)
	OSVERSIONINFO versionInfo = { sizeof(OSVERSIONINFO), 0, 0, 0, 0, { _T('\x00') } };
	::GetVersionEx(&versionInfo);
	if (versionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT)
	//----- NT_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
		// _xZkqqHx_iImIiJlKiCmM_xHqqkZx_ 3_xZkqqHx_iCmCiCmMiDfAiBfLiDfIiCpAiClBiClBiCmFiJpAiMiIiClHiCoJiBeC_xHqqkZx_
		// 1._xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_"X"_xZkqqHx_iCkKjFlGiPjBiCpAiNoMjAkMiClFiClNiKmCiLkLiCmFjBlGiNnNiClFiBeBiClBiCmMiKmCiLkLiCmFiCmNjBlGiNnNiClFiCmIiCkCiJmCjEfMjAkLiBeC_xHqqkZx_
		// 2._xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_"X"_xZkqqHx_iCkKjFlGiPjBiCpAiNoMjAkMiClFiClNiKmCiLkLiCmF_xHqqkZx_TrueType_xZkqqHx_iCmFiCoAiBeBiClBiCmMiKmCiLkLiCmFiCmN_xHqqkZx_
		//   _xZkqqHx_iDiJiDfIiDfOiBfLiDhEiDeIiDjDiDgHiCmMiJmCjEfMjAkLiBeC_xHqqkZx_
		// 3._xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_"_xZkqqHx_iCgMiChC_xHqqkZx_ _xZkqqHx_jGlOjCkJ_xHqqkZx_"_xZkqqHx_iCkKjFlGiPjBiCpAiNoMjAkMiClFiClNiMlOiMoKiKmCiLkLiCmFiCmMjGlMjBePiBeBiClBiCmMiKmCiLkLiCmFiCmN_xHqqkZx_
		//   "MS Mincho"_xZkqqHx_iCmFiCkAiCoJiJmCjEfMjAkLiBeC_xHqqkZx_
		LOGFONTW lfOrg;
		ReqInitW(lfOrg);
		LOGFONTW lfNew = { 0 };
		// lfOrg_xZkqqHx_iCkKjBlGiNnNiClFiBeBiKiOiCmC_xHqqkZx_TrueType_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCjAfOiCmMiPoKiNiHiCmN_xHqqkZx_lfNew_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		::EnumFontFamiliesExW(dc.m_hDC, &lfOrg, FONTENUMPROCW(EnumTrueTypeFontProcW), LPARAM(&lfNew), 0);
		if (lfNew.lfFaceName[0] != L'\0')
		//----- _xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgHiCkK_xHqqkZx_TrueType_xZkqqHx_iCmGiClFiCmEjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// The fonts for many East Asian languages have two typeface names:
			// an English name and a localized name.
			// EnumFontFamiliesEx _xZkqqHx_iCmFiBeB_xHqqkZx_system local _xZkqqHx_iCmJiPfNiCmBiClNjFmKjGlMiCpAiOoGiCoIiPgPiClJiCoJiBeC_xHqqkZx_
			wcscpy(m_szFaceName, lfNew.lfFaceName);
		} else
		//----- _xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBeBiIlNiCkCiCmN_xHqqkZx_TrueType_xZkqqHx_iCmGiClFiCmEjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmFiCoAiLnPiCkCiDhEiDeIiDjDiDgHiCpAjCfEiClFiPgPiClHiBeC_xHqqkZx_
			MC2FontCharInfo fci2;
			ReqInit(fci2);
			FCFontCharInfo fci;
			MFCopy(fci, fci2);
			FFUtilFontI->GetNearest(fci, NULL, NULL);
			MFCopy(fci2, fci);
			// _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			FFUtilFontI->AppendErrFontInfo(m_byCharSet, m_szFaceName,
											fci.byCharSet, fci.szFaceName);
			// _xZkqqHx_iNmFiCoAiLnPiCkCiDhEiDeIiDjDiDgHiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
			Init(fci2);
		}
	} else
	//----- 95_xZkqqHx_iDeKiBfLiDgMiDiLiCmMiPoKiNiH_xHqqkZx_ ------
	{
#endif // defined(_MBCS)
		// _xZkqqHx_iImIiJlKiCmM_xHqqkZx_ 3_xZkqqHx_iCmCiCmMiDfAiBfLiDfIiCpAiClBiClBiCmFiJpAiMiIiClHiCoJiBeC_xHqqkZx_
		// 1._xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_"X"_xZkqqHx_iCkKjFlGiPjBiCpAiNoMjAkMiClFiClNiKmCiLkLiCmFjBlGiNnNiClFiBeBiClBiCmMiKmCiLkLiCmFiCmNjBlGiNnNiClFiCmIiCkCiJmCjEfMjAkLiBeC_xHqqkZx_
		// 2._xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_"X"_xZkqqHx_iCkKjFlGiPjBiCpAiNoMjAkMiClFiClNiKmCiLkLiCmF_xHqqkZx_TrueType_xZkqqHx_iCmFiCoAiBeBiClBiCmMiKmCiLkLiCmFiCmN_xHqqkZx_
		//   _xZkqqHx_iDiJiDfIiDfOiBfLiDhEiDeIiDjDiDgHiCmMiJmCjEfMjAkLiBeC_xHqqkZx_
		// 3._xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_"_xZkqqHx_iCgMiChC_xHqqkZx_ _xZkqqHx_jGlOjCkJ_xHqqkZx_"_xZkqqHx_iCkKjFlGiPjBiCpAiNoMjAkMiClFiClNiMlOiMoKiKmCiLkLiCmFiCmMjGlMjBePiBeBiClBiCmMiKmCiLkLiCmFiCmN_xHqqkZx_
		//   "MS Mincho"_xZkqqHx_iCmFiCkAiCoJiJmCjEfMjAkLiBeC_xHqqkZx_
		LOGFONT lfOrg;
		ReqInit(lfOrg);
		LOGFONT lfNew = { 0 };
		// lfOrg_xZkqqHx_iCkKjBlGiNnNiClFiBeBiKiOiCmC_xHqqkZx_TrueType_xZkqqHx_iCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCjAfOiCmMiPoKiNiHiCmN_xHqqkZx_lfNew_xZkqqHx_iCkKjAnNjCoIiClDiCoKiCoJiBeC_xHqqkZx_
		::EnumFontFamiliesEx(dc.m_hDC, &lfOrg, FONTENUMPROC(EnumTrueTypeFontProc), LPARAM(&lfNew), 0);
		if (lfNew.lfFaceName[0] != _T('\0'))
		//----- _xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgHiCkK_xHqqkZx_TrueType_xZkqqHx_iCmGiClFiCmEjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// The fonts for many East Asian languages have two typeface names:
			// an English name and a localized name.
			// EnumFontFamiliesEx _xZkqqHx_iCmFiBeB_xHqqkZx_system local _xZkqqHx_iCmJiPfNiCmBiClNjFmKjGlMiCpAiOoGiCoIiPgPiClJiCoJiBeC_xHqqkZx_
			wcscpy(m_szFaceName, TStrToWStr(lfNew.lfFaceName));
		} else
		//----- _xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgHiCkKjBlGiNnNiClFiCmIiCkCiPoKiNiHiBeBiIlNiCkCiCmN_xHqqkZx_TrueType_xZkqqHx_iCmGiClFiCmEjBlGiNnNiClFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iNmFiCoAiLnPiCkCiDhEiDeIiDjDiDgHiCpAjCfEiClFiPgPiClHiBeC_xHqqkZx_
			MC2FontCharInfo fci2;
			ReqInit(fci2);
			FCFontCharInfo fci;
			MFCopy(fci, fci2);
			FFUtilFontI->GetNearest(fci, NULL, NULL);
			MFCopy(fci2, fci);
			// _xZkqqHx_iDhEiDeIiDjDiDgHiCmMiDeHiDiJiBfLiPoOjFpBiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
			FFUtilFontI->AppendErrFontInfo(m_byCharSet, m_szFaceName,
											fci.byCharSet, fci.szFaceName);
			// _xZkqqHx_iNmFiCoAiLnPiCkCiDhEiDeIiDjDiDgHiCmFiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
			Init(fci2);
		}
#if defined(_MBCS)
	}
#endif // defined(_MBCS)

	g_dZoom = dZoom;
} // MC2SFontRec::InitMetric.

/////////////////////////////////////////////////////////////////////////
// MC2ChipRec_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

MC2ChipRec::MC2ChipRec () : m_objpChipMaster(NULL)
{
	m_szName[0] = L'\0';
} // MC2ChipRec::MC2ChipRec.

MC2ChipRec::~MC2ChipRec ()
{
	Clear();
} // MC2ChipRec::~MC2ChipRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipRec::OutStreamV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDfIiDfOiBfLiDgAiDgCiDhGiCmMiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiCmM_xHqqkZx_MCARCHIVE.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ChipRec::OutStreamV3 (MCARCHIVE& ar) const
{
	m_objpChipMaster->OutByteTypeAndStream(ar);
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	const BYTE byNameLen = (BYTE)wcslen(m_szName);
	ar << byNameLen;
	ar.Write(m_szName, byNameLen * sizeof(wchar_t));
} // MC2ChipRec::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipRec::InStreamV12
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MC2ChipRec_xZkqqHx_jCiGiCmJiDhNiDfIiDfOiBfLiDgAiDgCiDhGjFjEjFgJiCpAjAlGjAkMiClFiBeBjBkOjAkLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDhEiDeAiDeDiDiLjCiGiCmM_xHqqkZx_InStreamV12_xZkqqHx_iKnGjAjEiBeB_xHqqkZx_InStreamSub_xZkqqHx_iKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnO_xHqqkZx_MCARCHIVE.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ChipRec::InStreamV12 (MCARCHIVE& ar)
{
	short nType;
	ar >> nType;
	MC2ObjBase* pMembObj = ::NewFDObjAny(static_cast<FTObjectType>(nType));
	pMembObj->InStream(ar);
	if (nType != FDOJ_CHIP_MASTER)
	//----- _xZkqqHx_iDgAiDgCiDhGiDhNiDfIiDfOiBfLjFjEjFgJiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		// V3_xZkqqHx_iImIiNhOiCmFiCmNiBeBjFeLiClIiDgAiDgCiDhGiDhNiDfIiDfOjFjEjFgJiCmFiDiJiDgCiDhGiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDhNiDfIiDfOjFjEjFgJiCpAjAlGjAkMiBeC_xHqqkZx_
		MC2ObjChipMaster* pChipObj = new MC2ObjChipMaster();
		// _xZkqqHx_iDhNiDfIiDfOjFjEjFgJiCmJiDgAiDgCiDhG_xHqqkZx_ID_xZkqqHx_iCpAjFhEiJmBiBeC_xHqqkZx_
		pChipObj->SetObjID(pMembObj->GetObjID() + 1);
		// _xZkqqHx_iDhNiDfIiDfOjFjEjFgJiCmJiMlLiNnNiCmMjFjEjFgJjBfDiCmEiCpAiDePiDiLiBfLiDhGjFjEjFgJiCmGiClFiCmEjDgPjIfOiBeC_xHqqkZx_
		MC2ObjBaseVector vMembObj;
		vMembObj.push_back(pMembObj);
		pChipObj->SetGroup(vMembObj);
		// _xZkqqHx_iDgAiDgCiDhGiOoNjFmKiCmMjAnNjCoIiBeC_xHqqkZx_
		pChipObj->SetChipKind(FDCM_OBJECT_CHIP);	// _xZkqqHx_jDmGjHkHjFjEjFgJiDgAiDgCiDhGiBeC_xHqqkZx_
		m_objpChipMaster = pChipObj;
	} else
	{
		m_objpChipMaster = pMembObj;
	}
	// _xZkqqHx_iChFiCfAiBeBiChFiCfBiCmFiCmNiBeBiDgAiDgCiDhGiCmMiCnN_xHqqkZx_ _xZkqqHx_jDgPjIfOjGlMiCmMjFnLjBlGiMgAiOkOiCkKiInJiCmIiCoJiBeC_xHqqkZx_
//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
//	_TCHAR szName[FD_ENV_NAME_LEN];
//	ar.Read(szName, FD_ENV_NAME_LEN);
//	szName[FD_ENV_NAME_LEN] = _T('\0');
//	wcscpy(m_szName, (const wchar_t*)TStrToWStr(szName));
//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	char szName[FD_ENV_NAME_LEN_V12];
	ar.Read(szName, FD_ENV_NAME_LEN_V12);
// 06.04.13 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	szName[FD_ENV_NAME_LEN_V12] = '\0';
	szName[FD_ENV_NAME_LEN_V12 - 1] = '\0';
	wcscpy(m_szName, (const wchar_t*)AStrToWStr(szName));
//----- 06.03.26 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // MC2ChipRec::InStreamV12.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipRec::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIjCiGiCmMjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ChipRec::Clear ()
{
	if (m_objpChipMaster != NULL)
	{
		delete m_objpChipMaster;
		m_objpChipMaster = NULL;
	}
	*m_szName = L'\0';
} // MC2ChipRec::Clear.

/////////////////////////////////////////////////////////////////////////
// MC2PictArrowRec_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

MC2PictArrowRec::MC2PictArrowRec () : m_objpPictArrowMaster1(NULL),
									m_objpPictArrowMaster2(NULL)
{
	m_szName[0] = L'\0';
} // MC2PictArrowRec::MC2PictArrowRec.

MC2PictArrowRec::~MC2PictArrowRec ()
{
	Clear();
} // MC2PictArrowRec::~MC2PictArrowRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2PictArrowRec::OutStreamV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDfIiDfOiBfLiDeBiDiNiBfLiCmMiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiCmM_xHqqkZx_MCARCHIVE.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2PictArrowRec::OutStreamV3 (MCARCHIVE& ar) const
{
	m_objpPictArrowMaster1->OutByteTypeAndStream(ar);
	if (m_objpPictArrowMaster2 == NULL)
	{
		ar << (BYTE)FDOJ_NONE;
	} else
	{
		m_objpPictArrowMaster2->OutByteTypeAndStream(ar);
	}
	// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
	const BYTE byNameLen = (BYTE)wcslen(m_szName);
	ar << byNameLen;
	ar.Write(m_szName, byNameLen * sizeof(wchar_t));
} // MC2PictArrowRec::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2PictArrowRec::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDfCiBfLiDgIjCiGiCmMjFmPjAjEiCpAiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2PictArrowRec::Clear ()
{
	if (m_objpPictArrowMaster1 != NULL)
	{
		delete m_objpPictArrowMaster1;
		m_objpPictArrowMaster1 = NULL;
	}
	if (m_objpPictArrowMaster2 != NULL)
	{
		delete m_objpPictArrowMaster2;
		m_objpPictArrowMaster2 = NULL;
	}
	*m_szName = L'\0';
} // MC2PictArrowRec::Clear.

/////////////////////////////////////////////////////////////////////////
// MC2Env_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::MC2Env
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2Env::MC2Env ()
{
} // MC2Env::MC2Env.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::~MC2Env
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2Env::~MC2Env ()
{
	ClearEnvTbl();
} // MC2Env::~MC2Env.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::ClearEnvTbl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.17 Fukushiro M. _xZkqqHx_iInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::ClearEnvTbl ()
{
	MC2SColorRecVector::iterator	iSColor;
	for	(iSColor = m_vSColor.begin(); iSColor != m_vSColor.end(); iSColor++)
		if (*iSColor !=	NULL) delete *iSColor;
	m_vSColor.clear();
	m_vFreqSColor.clear();

	MC2EmfImageRecVector::iterator iEmfImage;
	for	(iEmfImage = m_vEmfImage.begin(); iEmfImage	!= m_vEmfImage.end(); iEmfImage++)
		if (*iEmfImage != NULL)	delete *iEmfImage;
	m_vEmfImage.clear();
	m_vFreqEmfImage.clear();

	MC2BrushRegisterRecVector::iterator iBrushRegister;
	for	(iBrushRegister	= m_vBrushRegister.begin();	iBrushRegister != m_vBrushRegister.end(); iBrushRegister++)
		if (*iBrushRegister	!= NULL) delete	*iBrushRegister;
	m_vBrushRegister.clear();
	m_vFreqBrushRegister.clear();

	MC2PenRegisterRecVector::iterator iPenRegister;
	for	(iPenRegister =	m_vPenRegister.begin();	iPenRegister !=	m_vPenRegister.end(); iPenRegister++)
		if (*iPenRegister != NULL) delete *iPenRegister;
	m_vPenRegister.clear();
	m_vFreqPenRegister.clear();

	MC2PenStyleRecVector::iterator iPenStyle;
	for	(iPenStyle = m_vPenStyle.begin(); iPenStyle	!= m_vPenStyle.end(); iPenStyle++)
		if (*iPenStyle != NULL)	delete *iPenStyle;
	m_vPenStyle.clear();
	m_vFreqPenStyle.clear();

	MC2SFontRecVector::iterator iSFont;
	for	(iSFont	= m_vSFont.begin();	iSFont != m_vSFont.end(); iSFont++)
		if (*iSFont	!= NULL) delete	*iSFont;
	m_vSFont.clear();
	m_vFreqSFont.clear();

	MC2ChipGroupRecVector::iterator iChipGroup;
	for	(iChipGroup	= m_vChipGroup.begin();	iChipGroup != m_vChipGroup.end(); iChipGroup++)
		if (*iChipGroup	!= NULL) delete	*iChipGroup;
	m_vChipGroup.clear();
	m_vFreqChipGroup.clear();

	MC2ChipRecVector::iterator iChip;
	for	(iChip = m_vChip.begin(); iChip	!= m_vChip.end(); iChip++)
		if (*iChip != NULL)	delete *iChip;
	m_vChip.clear();
	m_vFreqChip.clear();

	MC2PictArrowRecVector::iterator iPictArrow;
	for	(iPictArrow	= m_vPictArrow.begin();	iPictArrow != m_vPictArrow.end(); iPictArrow++)
		if (*iPictArrow	!= NULL) delete	*iPictArrow;
	m_vPictArrow.clear();
	m_vFreqPictArrow.clear();
} // MC2Env::ClearEnvTbl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::OutStreamV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiDgFiBfLiDhFiDiLiCmMiPoOjFpBiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.07.10 Fukushiro M. _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMiPgPjHmNiBeC_xHqqkZx_
 *			99.12.16 Fukushiro M. OutEnvTbl_xZkqqHx_iCkJiCoHjFmPiNfIiBeC_xHqqkZx_
 *			00.04.05 Fukushiro M. _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMiPgPjHmNiCpA_xHqqkZx_CMolipDrawApp_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::OutStreamV3 (MCARCHIVE& ar)
{
	// _xZkqqHx_iJgFiCmMjClHiClDiCpAiPjBiCkLiPgPiClHiBeC_xHqqkZx_
	ar.Write(&m_mmptShadowLen, sizeof(m_mmptShadowLen));
	//----- _xZkqqHx_jHhAiOiGiBeFiDhGiDiKiDjDiDfOiPoOjFpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar << m_nDocPaperOrient;	// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	ar << m_nDocPaperType;		// _xZkqqHx_jCoIiMfOjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_A4,B5,etc.
	ar << m_mmDocPaperWidth;	// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar << m_mmDocPaperHeight;	// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	ar << m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar << m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar.Write(&m_mmrtSheet, sizeof(m_mmrtSheet));	// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar << m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	ar << m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar << m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

	//-----	S_xZkqqHx_jAeG_xHqqkZx_	-----
	FDSColorIDVector::const_iterator iSColorID;
	ar << long(m_vFreqSColor.size());
	for	(iSColorID = m_vFreqSColor.begin();	iSColorID != m_vFreqSColor.end(); iSColorID++)
	{
		ar.Write(&(*iSColorID),	sizeof(*iSColorID));
		m_vSColor[*iSColorID]->OutStreamV3(ar);
	}

	//-----	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_ -----
	FDEmfImageIDVector::const_iterator iEmfImageID;
	ar << long(m_vFreqEmfImage.size());
	for	(iEmfImageID = m_vFreqEmfImage.begin();	iEmfImageID	!= m_vFreqEmfImage.end(); iEmfImageID++)
	{
		ar.Write(&(*iEmfImageID), sizeof(*iEmfImageID));
		m_vEmfImage[*iEmfImageID]->OutStreamV3(ar);
	}

	//-----	_xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	FDBrushRegisterIDVector::const_iterator	iBrushRegisterID;
	ar << long(m_vFreqBrushRegister.size());
	for	(iBrushRegisterID =	m_vFreqBrushRegister.begin(); iBrushRegisterID != m_vFreqBrushRegister.end(); iBrushRegisterID++)
	{
		ar.Write(&(*iBrushRegisterID), sizeof(*iBrushRegisterID));
		m_vBrushRegister[*iBrushRegisterID]->OutStreamV3(ar);
	}

	//-----	_xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	FDPenRegisterIDVector::const_iterator iPenRegisterID;
	ar << long(m_vFreqPenRegister.size());
	for	(iPenRegisterID	= m_vFreqPenRegister.begin(); iPenRegisterID !=	m_vFreqPenRegister.end(); iPenRegisterID++)
	{
		ar.Write(&(*iPenRegisterID), sizeof(*iPenRegisterID));
		m_vPenRegister[*iPenRegisterID]->OutStreamV3(ar);
	}

	//-----	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc) -----
	FDPenStyleIDVector::const_iterator iPenStyleID;
	ar << long(m_vFreqPenStyle.size());
	for	(iPenStyleID = m_vFreqPenStyle.begin();	iPenStyleID	!= m_vFreqPenStyle.end(); iPenStyleID++)
	{
		ar.Write(&(*iPenStyleID), sizeof(*iPenStyleID));
		m_vPenStyle[*iPenStyleID]->OutStreamV3(ar);
	}

	//-----	S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ -----
	FDSFontIDVector::const_iterator	iSFontID;
	ar << long(m_vFreqSFont.size());
	for	(iSFontID =	m_vFreqSFont.begin(); iSFontID != m_vFreqSFont.end(); iSFontID++)
	{
		ar.Write(&(*iSFontID), sizeof(*iSFontID));
		m_vSFont[*iSFontID]->OutStreamV3(ar);
	}

	//-----	_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_ -----
	FDChipGroupIDVector::const_iterator	iChipGroupID;
	ar << long(m_vFreqChipGroup.size());
	for	(iChipGroupID =	m_vFreqChipGroup.begin(); iChipGroupID != m_vFreqChipGroup.end(); iChipGroupID++)
	{
		ar.Write(&(*iChipGroupID), sizeof(*iChipGroupID));
		if (*iChipGroupID != FD_CHIP_GROUP_UNSPECIFY)
			m_vChipGroup[*iChipGroupID]->OutStreamV3(ar);
	}
	//-----	_xZkqqHx_iDgAiDgCiDhG_xHqqkZx_ -----
	FDChipIDVector::const_iterator iChipID;
	ar << long(m_vFreqChip.size());
	for	(iChipID = m_vFreqChip.begin();	iChipID	!= m_vFreqChip.end(); iChipID++)
	{
		ar.Write(&(*iChipID), sizeof(*iChipID));
		if (*iChipID !=	FD_CHIP_UNSPECIFY)
			m_vChip[*iChipID]->OutStreamV3(ar);
	}
	//-----	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpD_xHqqkZx_ -----
	FDPictArrowIDVector::const_iterator	iPictArrowID;
	ar << long(m_vFreqPictArrow.size());
	for	(iPictArrowID =	m_vFreqPictArrow.begin(); iPictArrowID != m_vFreqPictArrow.end(); iPictArrowID++)
	{
		ar.Write(&(*iPictArrowID), sizeof(*iPictArrowID));
		m_vPictArrow[*iPictArrowID]->OutStreamV3(ar);
	}
} // MC2Env::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::InStreamV12
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iKmCiLkLiCpAiKmCiLkLiDgFiBfLiDhFiDiLiCnGjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.12.16 Fukushiro M. InEnvTbl_xZkqqHx_iCkJiCoHjFmPiNfIiBeC_xHqqkZx_
 *			00.04.05 Fukushiro M. _xZkqqHx_iDhGiDiKiDjDiDfOiPoOjFpBiCmMjDpMjHmNiCpA_xHqqkZx_CMolipDrawApp_xZkqqHx_iCnGiInKjDkOiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::InStreamV12 (MCARCHIVE& ar)
{
	// _xZkqqHx_iJgFiCmMjClHiClDiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
	ar.Read(&m_mmptShadowLen, sizeof(m_mmptShadowLen));
	//----- _xZkqqHx_jHhAiOiGiBeFiDhGiDiKiDjDiDfOiPoOjFpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar >> m_nDocPaperOrient;	// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	ar >> m_nDocPaperType;		// _xZkqqHx_jCoIiMfOjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_A4,B5,etc.
	ar >> m_mmDocPaperWidth;	// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar >> m_mmDocPaperHeight;	// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	ar >> m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar >> m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	ar.Read(&m_mmrtSheet, sizeof(m_mmrtSheet));	// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	ar >> m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	ar >> m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	ar >> m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

	//----- S_xZkqqHx_jAeG_xHqqkZx_ -----
	long lSColor;
	SColorID scid;
	ar >> lSColor;
	for (scid = 0; scid < lSColor; scid++)
	{
		MC2SColorRec* recSColor = new MC2SColorRec();
		recSColor->InStreamV12(ar);
		m_vSColor.push_back(recSColor);
		m_vFreqSColor.push_back(scid);
	}
	ar >> lSColor;
	while (0 < lSColor--) ar.Read(&scid, sizeof(scid));

	//----- _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_ -----
	long lEMFImage;
	EmfImageID emid;
	ar >> lEMFImage;
	for (emid = 0; emid < lEMFImage; emid++)
	{
		MC2EmfImageRec* recEMFImage = new MC2EmfImageRec();
		recEMFImage->InStreamV12(ar);
		m_vEmfImage.push_back(recEMFImage);
		m_vFreqEmfImage.push_back(emid);
	}
	ar >> lEMFImage;
	while (0 < lEMFImage--) ar.Read(&emid, sizeof(emid));

	//----- _xZkqqHx_jCfAjAeGiDhAiDfOiBfLiDjD_xHqqkZx_._xZkqqHx_jDgIjCnHiClFjHhA_xHqqkZx_ -----
	long lPattern;
	PatternIDV12 ptid;
	ar >> lPattern;
	while (0 < lPattern--)
	{
		MC2PatternRec recPattern;
		recPattern.InStreamV12(ar);
	}
	ar >> lPattern;
	while (0 < lPattern--) ar.Read(&ptid, sizeof(ptid));

	//----- _xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	long lBrushRegister;
	BrushRegisterID brid;
	ar >> lBrushRegister;
	for (brid = 0; brid < lBrushRegister; brid++)
	{
		MC2BrushRegisterRec* recBrushRegister = new MC2BrushRegisterRec();
		recBrushRegister->InStreamV12(ar);
		m_vBrushRegister.push_back(recBrushRegister);
		m_vFreqBrushRegister.push_back(brid);
	}
	ar >> lBrushRegister;
	while (0 < lBrushRegister--) ar.Read(&brid, sizeof(brid));

	//----- _xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_ -----
	long lPenRegister;
	PenRegisterID prid;
	ar >> lPenRegister;
	for (prid = 0; prid < lPenRegister; prid++)
	{
		MC2PenRegisterRec* recPenRegister = new MC2PenRegisterRec();
		recPenRegister->InStreamV12(ar);
		m_vPenRegister.push_back(recPenRegister);
		m_vFreqPenRegister.push_back(prid);
	}
	ar >> lPenRegister;
	while (0 < lPenRegister--) ar.Read(&prid, sizeof(prid));

	//-----	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_._xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc -----
	long lPenStyle;
	PenStyleIDV12 psid;
	ar >> lPenStyle;
	for (psid = 0; psid < lPenStyle; psid++)
	{
		MC2PenStyleRec* recPenStyle = new MC2PenStyleRec();
		recPenStyle->InStreamV12(ar);
		m_vPenStyle.push_back(recPenStyle);
		m_vFreqPenStyle.push_back(psid);
	}
	ar >> lPenStyle;
	while (0 < lPenStyle--) ar.Read(&psid, sizeof(psid));

	//----- S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ -----
	long lSFont;
	SFontID foid;
	ar >> lSFont;
	for (foid = 0; foid < lSFont; foid++)
	{
		MC2SFontRec* recSFont = new MC2SFontRec();
		recSFont->InStreamV12(ar);
		m_vSFont.push_back(recSFont);
		m_vFreqSFont.push_back(foid);
	}
} // MC2Env::InStreamV12.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::InStreamChipV12
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiPoOjFpBiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2Env::InStreamChipV12 (MCARCHIVE& ar)
{
	//----- _xZkqqHx_iDgAiDgCiDhGjAjEiCpAjDmHiCnNiNjOiCnN_xHqqkZx_ -----
	long lChip;
	ar >> lChip;
	if (lChip != 0)
	//----- _xZkqqHx_iDgAiDgCiDhGjAjEiCkKiCePiCmFiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		//----- _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiCpAiIoKiCmCiClOiCkPiNoMjAkM_xHqqkZx_ -----
		m_vFreqChipGroup.push_back(0);
		MC2ChipGroupRec*	pRecChipGroup =	new	MC2ChipGroupRec;
		CString strChipGroup;
		strChipGroup.LoadString(IDS_UNTITLED_CHIP_GROUP);
		wcscpy(pRecChipGroup->m_szName, TStrToWStr(strChipGroup));
		m_vChipGroup.push_back(pRecChipGroup);
	}
	//-----	_xZkqqHx_iDgAiDgCiDhG_xHqqkZx_ -----
	for (long lC = 0; lC < lChip; lC++)
	{
		m_vFreqChip.push_back(lC);
		MC2ChipRec* pRecChip = new MC2ChipRec;
		pRecChip->InStreamV12(ar);
		if ((long)m_vChip.size() <= lC)
			m_vChip.resize(lC + 1, NULL);
		m_vChip[lC] = pRecChip;
	}
} // MC2Env::InStreamChipV12.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::scid2cref
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	SColor_xZkqqHx_iCkJiCoH_xHqqkZx_COLORREF_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
COLORREF MC2Env::scid2cref (SColorID scidSColor) const
{
	return m_vSColor[scidSColor]->m_colRef;
} // MC2Env::scid2cref.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::FindSameFont
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDhEiDeIiDjDiDgH_xHqqkZx_ID(foid)_xZkqqHx_iCmGjDkPiClGiDhEiDeIiDjDiDgHiPoOjFpBiCpAiOjNiClPiBeBiKiOiCmCiNmFiCoA_xHqqkZx_
 *			_xZkqqHx_iPkMiClDiCkC_xHqqkZx_ID_xZkqqHx_iCmMiDhEiDeIiDjDiDgHiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.02.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
SFontID MC2Env::FindSameFont (SFontID foid) const
{
	MC2SFontRecVector::const_iterator i;
	i = find(m_vSFont.begin(), m_vSFont.end(), m_vSFont[foid]);
	return SFontID(i - m_vSFont.begin());
} // MC2Env::FindSameFont.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::OutStreamCanvasStatV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeMiDiDiDjDiDgPiDfIiCmMjFfMiOkGiPpDjBnEiCpAiPgPjHmNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2Env::OutStreamCanvasStatV3 (MCARCHIVE& ar) const
{
	// _xZkqqHx_iPgPjHmNiNiAjGnKiCmM_xHqqkZx_ID_xZkqqHx_iBeCiPiHjEnEiCpAjFmPiCkGiCmEiCmNiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iNiAjGnKiCpAjBjNiCoCiClHiPoKiNiHiCmNiBeBiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
	enum
	{
		FDGLST_NONE = 0,
		FDGLST_ZOOM,			// _xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
		FDGLST_VIEW_POSITION,	// _xZkqqHx_iDhCiDiFiBfLiImKjChFiBeC_xHqqkZx_
	};

	DBLPoint mmptCenter = m_mmrtSheet.CenterPoint();
	//----- _xZkqqHx_iDhCiDiFiBfLiCmMjFnCiPfHiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPgPjHmNiClHiCoJ_xHqqkZx_ -----
	BYTEVector vStream;
	//----- _xZkqqHx_jEhLjHkG_xHqqkZx_  ------
	vStream << BYTE(FDGLST_ZOOM);
	vStream << long(256);
	//----- _xZkqqHx_iDhCiDiFiBfLiImKjChF_xHqqkZx_ -----
	vStream << BYTE(FDGLST_VIEW_POSITION);
	vStream << SheetID(0);
	vStream << short(mmptCenter.x);
	vStream << short(mmptCenter.y);

	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << DWORD(vStream.size());
	// _xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiBeC_xHqqkZx_
	ar.Write(&vStream.front(), (long)vStream.size());
} // MC2Env::OutStreamCanvasStatV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2Env::GetDocPageSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiBfLiDfHiCmMjBoFiCkLiClDiCpAiMhGiOfKiClFiCmEjFnEiClHiBeCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmPageWidth		:_xZkqqHx_iDhJiBfLiDfHiCmMjFjNiCpAjFnEiClHiBeC_xHqqkZx_
 *			mmPageHeight	:_xZkqqHx_iDhJiBfLiDfHiCmMiNiCiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.12.15 Fukushiro M. FoundDoc_xZkqqHx_iCkJiCoHiInKjDkOiBeC_xHqqkZx_
 *			00.02.10 Fukushiro M. _xZkqqHx_iMhGiOfKiClFiCmEjFnEiClHiCoGiCkEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void MC2Env::GetDocPageSize (mmetol& mmPageWidth, mmetol& mmPageHeight) const
{
	mmPageWidth = m_dDocPageTimesX * (m_mmDocPaperWidth -
									m_mmDocPaperMarginL - m_mmDocPaperMarginR);
	mmPageHeight = m_dDocPageTimesY * (m_mmDocPaperHeight -
									m_mmDocPaperMarginT - m_mmDocPaperMarginB);
} // MC2Env::GetDocPageSize.
