#include "stdafx.h"
#include <set>				// For set.
#include <algorithm>		// For reverse.
#include "2ObjBase.h"		// For MC2ObjBase.
#include "2ZOrder.h"			// For MC2ZOrder.
#include "2NewFDObjAny.h"	// For NewFDObjAny.
#include "2LayerManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerRec::MC2LayerRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName	:_xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pvLayer	:_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2LayerRec::MC2LayerRec (const wchar_t* tcpName, WORD wFlag, MC2ObjBaseVector* pvLayer)
			: m_strName(tcpName), m_wFlag(wFlag), m_pvLayer(pvLayer)
{
} // MC2LayerRec::MC2LayerRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerRec::Delete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCmNiKePjFjEiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jHfOiCkGiCoHiCoKiCoJiCmMiCmFiBeBiNoNiPjMiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerRec::Delete ()
{
	delete m_pvLayer;
	m_pvLayer = NULL;
} // MC2LayerRec::Delete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::MC2LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName			:_xZkqqHx_iDfGiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpLZHash		:_xZkqqHx_iCgLiChJiDeJiBfLiDfPiBfL_xHqqkZx_->_xZkqqHx_iDiMiDeDiDiEiBfLiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vBottomLayer	:_xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vTopLayer		:_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2LayerManager::MC2LayerManager (const wchar_t* tcpName, MC2ObjectLZHashMap& mpLZHash,
						MC2ObjBaseVector& vBottomLayer, MC2ObjBaseVector& vTopLayer)
{
	m_strName = tcpName;
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	MC2LayerRec recBtm(L"Bottom Layer", FDOZ_ON_NONE, &vBottomLayer);
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	MC2LayerRec recTop(L"Top Layer", FDOZ_ON_NONE, &vTopLayer);
	// _xZkqqHx_iDgOiDgCiDfGiDiFiCpAjAnNjCoIiBeC_xHqqkZx_
	m_mpLZHash = &mpLZHash;
	// _xZkqqHx_iNmFiJlKiImKiBeBiNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_vLayerTable.push_back(recBtm);
	m_vLayerTable.push_back(recTop);
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiNmFiPoDiImKiDiMiDeDiDiEiBfLiCmJjAnNjCoIiBeC_xHqqkZx_
	m_dwCurLayerIdx = (DWORD)m_vLayerTable.size() - 1;
} // MC2LayerManager::MC2LayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::~MC2LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2LayerManager::~MC2LayerManager ()
{
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		m_vLayerTable[lC].Delete();
	}
	m_vLayerTable.clear();
	m_mpLZHash = NULL;
} // MC2LayerManager::~MC2LayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::DeleteAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiNoNiPjMiClFiBeBjDoAjHgFiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::DeleteAll ()
{
	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLjCiGiCmMiKgFiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
	MC2ObjBaseVector::iterator iObj;
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		MC2ObjBaseVector* pvObj = GetObjOrder(lC);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		for (iObj = pvObj->begin(); iObj != pvObj->end(); iObj++)
			delete *iObj;
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
		m_vLayerTable[lC].Delete();
	}
	// _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vLayerTable.clear();
	m_mpLZHash = NULL;
} // MC2LayerManager::DeleteAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::GetName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* MC2LayerManager::GetName () const
{
	return m_strName.c_str();
} // MC2LayerManager::GetName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::SetName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName	:_xZkqqHx_iDfGiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::SetName (const wchar_t* tcpName)
{
	m_strName = tcpName;
} // MC2LayerManager::SetName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::OutStreamV3 (MCARCHIVE& ar) const
{
	// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
	WriteString(ar, m_strName.c_str());
	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMiLeMjIfO_xHqqkZx_ -----
	MC2ObjBaseVector::iterator iObj;
	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << DWORD(m_vLayerTable.size() - 2);
	for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
	{
		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
		WriteString(ar, m_vLayerTable[dwC].m_strName.c_str());
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << m_vLayerTable[dwC].m_wFlag;
		// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << DWORD(m_vLayerTable[dwC].m_pvLayer->size());
		for (iObj = m_vLayerTable[dwC].m_pvLayer->begin();
			 iObj != m_vLayerTable[dwC].m_pvLayer->end(); iObj++)
		{
			// _xZkqqHx_jFjEjFgJiDfOiDeDiDhGiBjFjFjEjFgJiCpAiLeMjIfOiBeC_xHqqkZx_
			(*iObj)->OutByteTypeAndStream(ar);
		}
	}
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_vLayerTable.front().m_wFlag;
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_vLayerTable.back().m_wFlag;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_dwCurLayerIdx;
} // MC2LayerManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::InsertLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMiJlKiCmJiDiMiDeDiDiEiBfLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jBhNjDpMiClHiCoJiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCjBhNjDpMiMoDiBeBiClBiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJiCmIiCoJiBeC_xHqqkZx_
 *			tcpName, wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::InsertLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag)
{
	m_vLayerTable.insert(&m_vLayerTable.at(dwLayerIdx),
						MC2LayerRec(tcpName, wFlag, new MC2ObjBaseVector));
	// _xZkqqHx_jBhNjDpMiImKjChFiCkJiCoHiNmFiPoDiImKjBePiDiMiDeDiDiEiBfLiCnMiCmFiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNmEiMhGiOfKiBeC_xHqqkZx_
	UpdateLZHashTable(MC2LayerZOrder(dwLayerIdx, 0), MC2LayerZOrder(GetLayerSize() - 2));
} // MC2LayerManager::InsertLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::SetCurrentLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwIdx	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::SetCurrentLayerIdx (DWORD dwIdx)
{
	m_dwCurLayerIdx = dwIdx;
} // MC2LayerManager::SetCurrentLayerIdx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFnCiPfHiJmCjEfMiCmIiDiMiDeDiDiEiBfLiCmFiBeBiDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmJiNmFiCoAiLnPiCkCiDiMiDeDiDiEiBfLiCmJ_xHqqkZx_
 *			_xZkqqHx_jFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::AppendToLZOrder (MC2ObjBase* pObj)
{
	AppendToLZOrder(FirstLayerIdx(GetCurrentLayerIdx(), FDOZ_ON_EDIT), pObj);
} // MC2LayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jCmHiJmBiClHiCoJiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::AppendToLZOrder (DWORD dwLayerIdx, MC2ObjBase* pObj)
{
	// _xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCmM_xHqqkZx_ZOrder_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	DWORD dwZOrder = (DWORD)GetObjOrder(dwLayerIdx)->size();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(dwLayerIdx)->push_back(pObj);
	// _xZkqqHx_jCmHiJmBiClFiClNjFjEjFgJiCmMiDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(MC2LayerZOrder(dwLayerIdx, dwZOrder));
} // MC2LayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::InsertToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjBhNjDpMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jBhNjDpMiClHiCoJiImKjChFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj	:_xZkqqHx_jBhNjDpMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::InsertToLZOrder (const MC2LayerZOrder& lzorder, MC2ObjBase* pObj)
{
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(lzorder.dwLayerIdx)->insert(GetObjOrder(lzorder.dwLayerIdx)->begin() +
													lzorder.dwZOrder, pObj);
	// _xZkqqHx_jBhNjDpMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(lzorder, MC2LayerZOrder(DWORD(-1), DWORD(-1)));
} // MC2LayerManager::InsertToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::RemoveFromLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCkJiCoHjFjEjFgJiCpAiPjMiCkNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iPjMiCkNjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::RemoveFromLZOrder (MC2ObjBase* pObj)
{
	// _xZkqqHx_jFjEjFgJiCmMiImKjChFiCpAiOoGjDlOiBeC_xHqqkZx_
	MC2LayerZOrder lzorder = ObjBaseToLZOrder(pObj);
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHiBeBiClBiCmMjFjEjFgJiCmJiKnGiClHiCoJiDiMiDfCiBfLiDgIiCpAjGjFiPmBiBeC_xHqqkZx_
	EraseFromLZHashTable(pObj);
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiOhHjCoIiImKjChFiCpAjGjFiPmBiBeC_xHqqkZx_
	GetObjOrder(lzorder.dwLayerIdx)->erase(GetObjOrder(lzorder.dwLayerIdx)->begin() +
												lzorder.dwZOrder);
	// _xZkqqHx_iNoNiPjMiImKjChFiImIiNhOiCmMjFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiNfIjAfGiBeC_xHqqkZx_
	UpdateLZHashTable(lzorder, MC2LayerZOrder(DWORD(-1), DWORD(-1)));
} // MC2LayerManager::RemoveFromLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::ObjBaseToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkJiCoH_xHqqkZx_LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_jFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2LayerZOrder MC2LayerManager::ObjBaseToLZOrder (const MC2ObjBase* pObj) const
{
	// ZHash_xZkqqHx_jCgMiBgJ_xHqqkZx_Layer,_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmMiJlKiCfBiDgPiDeDiDgHiBgKiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	MC2ObjectLZHashMap::const_iterator i = m_mpLZHash->find(pObj);
	DWORD dwLayerIdx = (*i).second >> 16;
	if (dwLayerIdx == 0x0000ffff)
	{
		for (DWORD dwZOrder = (*i).second & 0x0000ffff;
			 dwZOrder < GetTopObjOrder()->size(); dwZOrder += 0x10000)
			if (GetTopObjOrder()->at(dwZOrder) == pObj)
				return MC2LayerZOrder(GetLayerSize() - 1, dwZOrder);
	}
	for (; dwLayerIdx < GetLayerSize(); dwLayerIdx += 0x10000)
	{
		for (DWORD dwZOrder = (*i).second & 0x0000ffff;
			 dwZOrder < GetObjOrder(dwLayerIdx)->size(); dwZOrder += 0x10000)
			if (GetObjOrder(dwLayerIdx)->at(dwZOrder) == pObj)
				return MC2LayerZOrder(dwLayerIdx, dwZOrder);
	}
	return MC2LayerZOrder(DWORD(-1), DWORD(-1));
} // MC2LayerManager::ObjBaseToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::LZOrderToObjBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCkJiCoHjFjEjFgJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2ObjBase* MC2LayerManager::LZOrderToObjBase (const MC2LayerZOrder& lzorder) const
{
	return GetObjOrder(lzorder.dwLayerIdx)->at(lzorder.dwZOrder);
} // MC2LayerManager::LZOrderToObjBase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::GetCurrentLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD MC2LayerManager::GetCurrentLayerIdx () const
{
	return m_dwCurLayerIdx;
} // MC2LayerManager::GetCurrentLayerIdx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::GetZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiPpAiMiPiCmJiIoKjChGiClHiCoJiChJiDeJiBfLiDfPiBfLiCpAjBgHiCnNjHkHiCmEiCmEjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	zOrder		:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCpAiOpDiCkPiOoGiCoJiBeC_xHqqkZx_
 *			wOption		:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPpAiMiPiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwFromIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiKeKiOgOiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *			dwUntilIdx	:_xZkqqHx_iChJiDeJiBfLiDfPiBfLiCmJjBgHiCnNiNjOiCnOiDiMiDeDiDiEiBfLiCmMiPeJjHlJiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iKeKjAnN_xHqqkZx_>	[dwFromIdx, dwUntilIdx]_xZkqqHx_iCpAiMjPiNpFiBeC_xHqqkZx_dwUntilIdx == DWORD(-1)_xZkqqHx_iCmIiCoHiCmOiBeB_xHqqkZx_
 *			_xZkqqHx_iNmFiMoDiCnMiCmFiMjPiNpFiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.08 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::GetZOrder (MC2ZOrder& zOrder, WORD wOption, DWORD dwFromIdx, DWORD dwUntilIdx) const
{
	if (dwUntilIdx == DWORD(-1))
		dwUntilIdx = GetLayerSize() - 1;
	for (DWORD dwIdx = dwFromIdx; dwIdx <= dwUntilIdx; dwIdx++)
	{
		if ((m_vLayerTable[dwIdx].m_wFlag & wOption) == wOption)
		{
			zOrder.PushBack(GetObjOrder(dwIdx));
		}
	}
} // MC2LayerManager::GetZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::FirstLayerIdx
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiImIiJlK_xHqqkZx_(_xZkqqHx_jBkGiClPiImIiJlKiCmM_xHqqkZx_Idx)_xZkqqHx_iCmMiBeBiOhHjCoIiCmMiDeJiDhGiDfGiDiHiDjDiCmJiIoKjChG_xHqqkZx_
 *			_xZkqqHx_iClHiCoJiNmFiPiJiCmMiDiMiDeDiDiEiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwFromIdx	:_xZkqqHx_iMjPiNpFiKeKiOgOiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wOption		:_xZkqqHx_iMjPiNpFjHhAiCmMiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_Idx_xZkqqHx_iCpAjFnEiClHiBeCiMkJiCmCiCkJiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_DWORD(-1)_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD MC2LayerManager::FirstLayerIdx (DWORD dwFromIdx, WORD wOption) const
{
	if (dwFromIdx == DWORD(-1))
		dwFromIdx = GetLayerSize() - 1;
	for (;;)
	{
		if ((m_vLayerTable[dwFromIdx].m_wFlag & wOption) == wOption)
		{
			return dwFromIdx;
		}
		if (dwFromIdx == 0) break;
		dwFromIdx--;
	}
	return DWORD(-1);
} // MC2LayerManager::FirstLayerIdx.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::GetObjOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2ObjBaseVector* MC2LayerManager::GetObjOrder (DWORD dwLayerIdx) const
{
	return m_vLayerTable[dwLayerIdx].m_pvLayer;
} // MC2LayerManager::GetObjOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::GetLayerSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD MC2LayerManager::GetLayerSize () const
{
	return (DWORD)m_vLayerTable.size();
} // MC2LayerManager::GetLayerSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::GetTopObjOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2ObjBaseVector* MC2LayerManager::GetTopObjOrder () const
{
	return m_vLayerTable.back().m_pvLayer;
} // MC2LayerManager::GetTopObjOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::NextLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	lzorder_xZkqqHx_iCpAiIoKiCmCiPoDiCmJiBgJiMoDiCoLiCmJiBgKjAgJiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_jAgJiCnPiCoJjCgMiCpAiOhHjCoIiBeCjAgJiCnPiClNjCgMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iClBiCoKiImIiPoDjAgJiCnPiCoHiCoKiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL MC2LayerManager::NextLZOrder (MC2LayerZOrder& lzorder) const
{
	lzorder.dwZOrder++;
	if (GetObjOrder(lzorder.dwLayerIdx)->size() <= lzorder.dwZOrder)
	{
		lzorder.dwZOrder = 0;
		do
		{
			lzorder.dwLayerIdx++;
			if (GetLayerSize() <= lzorder.dwLayerIdx) return FALSE;
		} while (GetObjOrder(lzorder.dwLayerIdx)->empty());
	}
	return TRUE;
} // MC2LayerManager::NextLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::UpdateLZHashTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCmMjCgMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorder	:_xZkqqHx_iNfIjAfGiClHiCoJjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::UpdateLZHashTable (const MC2LayerZOrder& lzorder)
{
	// _xZkqqHx_jBlGiNnNiClFiCmIiCkC_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (GetObjOrder(lzorder.dwLayerIdx)->size() <= lzorder.dwZOrder) return;
	DWORD dwLZHash;
	if (lzorder.dwLayerIdx == long(GetLayerSize()) - 1)
		dwLZHash = 0xffff0000;
	else
		dwLZHash = DWORD(lzorder.dwLayerIdx & 0x0000ffff) << 16;
	dwLZHash |= lzorder.dwZOrder & 0x0000ffff;
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCmJjCmHiJmBiBeC_xHqqkZx_
	(*m_mpLZHash)[LZOrderToObjBase(lzorder)] = dwLZHash;
} // MC2LayerManager::UpdateLZHashTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::UpdateLZHashTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCmMjCgMiCpAiNfIjAfGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lzorderFrom	:_xZkqqHx_iNfIjAfGiClHiCoJjEmNiImNiCmMiNmFiPiJiCpAiOhHjCoIiBeC_xHqqkZx_
 *			lzorderUntil:_xZkqqHx_iNfIjAfGiClHiCoJjEmNiImNiCmMiNmFiMoDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	[lzorderFrom, lzorderUntil]_xZkqqHx_iCpAiNfIjAfGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::UpdateLZHashTable (MC2LayerZOrder lzorderFrom,
										MC2LayerZOrder lzorderUntil)
{
	while (lzorderFrom <= lzorderUntil)
	{
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCmJjCmHiJmBiBeC_xHqqkZx_
		UpdateLZHashTable(lzorderFrom);
		if (!NextLZOrder(lzorderFrom)) break;
	}
} // MC2LayerManager::UpdateLZHashTable.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2LayerManager::EraseFromLZHashTable
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgOiDgCiDfGiDiFiDgFiBfLiDhFiDiLiCkJiCoHjFjEjFgJiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pObj	:_xZkqqHx_iNoNiPjMiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2LayerManager::EraseFromLZHashTable (const MC2ObjBase* pObj)
{
	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->ZHash_xZkqqHx_iDgFiBfLiDhFiDiLiCkJiCoHiBeBiClBiCmMjFjEjFgJiCmJiKnGiClHiCoJiDiMiDfCiBfLiDgIiCpAjGjFiPmBiBeC_xHqqkZx_
	m_mpLZHash->erase(pObj);
} // MC2LayerManager::EraseFromLZHashTable.
