#ifndef __3Env_h
#define __3Env_h

#include "3NewFDObjAny.h"	// For NewFDObjAny.

#define FD_ENV_NAME_LEN	32		// _xZkqqHx_iKmCiLkL_xHqqkZx_(_xZkqqHx_jAeGiBeFiDhAiDfOiBfLiDjDjDjJ_xHqqkZx_)_xZkqqHx_iCmMjGlMjBePiCmMjClHiClD_xHqqkZx_(_xZkqqHx_iPeJjCfLiCpAiKnMiCnO_xHqqkZx_).

class MCARCHIVE;

class MC3SColorRec;
class MC3EmfImageRec;
class MC3PatternRec;
class MC3BrushRegisterRec;
class MC3PenRegisterRec;
class MC3PenStyleRec;
class MC3SFontRec;
class MC3ChipGroupRec;
class MC3ChipRec;
class MC3PictArrowRec;
class MC3ObjBase;

#define	FD_EMF_IMAGE_UNSPECIFY	EmfImageID(-1)
#define	FD_EMF_IMAGE_UNUSE		EmfImageID(-2)

// S_xZkqqHx_jAeGiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3SColorRec*> MC3SColorRecVector;
// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjDiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3EmfImageRec*> MC3EmfImageRecVector;
// _xZkqqHx_jDgIjCnHiClFjHhAjCfAjAeGiDhAiDfOiBfLiDjD_xHqqkZx_(_xZkqqHx_iOmOjApM_xHqqkZx_,etc)_xZkqqHx_iBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3PatternRec*> MC3PatternRecVector;
// _xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlMiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3BrushRegisterRec*>	MC3BrushRegisterRecVector;
// _xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlMiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3PenRegisterRec*> MC3PenRegisterRecVector;
// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)_xZkqqHx_iBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3PenStyleRec*> MC3PenStyleRecVector;
// S_xZkqqHx_iDhEiDeIiDjDiDgHiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3SFontRec*>	MC3SFontRecVector;
// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3ChipGroupRec*>	MC3ChipGroupRecVector;
// _xZkqqHx_iDgAiDgCiDhGiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3ChipRec*> MC3ChipRecVector;
// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiBeCiDiMiDfCiBfLiDgIiCmG_xHqqkZx_ID_xZkqqHx_iDeJiBfLiDfPiBfLiBeC_xHqqkZx_
typedef	vector<MC3PictArrowRec*>	MC3PictArrowRecVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3SColorRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOjAeGiCmMiKmHjHjNiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC3SColorRec
{
public:
	MC3SColorRec ()  { memset(this, 0, sizeof(*this)); }
	void OutStream (MCARCHIVE& ar) const
		{
			ar << m_crRef;
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		}
	void InStream (MCARCHIVE& ar)
		{
			ar >> m_crRef;
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		}
public:
	ColorRefID	m_crRef;
	wchar_t		m_szName[FD_ENV_NAME_LEN];
}; // class MC3SColorRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3EmfImageRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiKmHjHjNjHhAiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.01 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC3EmfImageRec
{
public:
	MC3EmfImageRec ()
		{
			m_bypEmfBits = NULL;
			m_lEmfBitsSz = 0;
			m_szName[0] = L'\0';
		}
	MC3EmfImageRec (const BYTE* bypBits, long lBitSize, const wchar_t* pName)
		{
			m_bypEmfBits = NULL;
			m_lEmfBitsSz = 0;
			m_szName[0] = L'\0';
			Init(bypBits, lBitSize, pName);
		}
	~MC3EmfImageRec ()
		{
			Clear();
		}
	void OutStream (MCARCHIVE& ar) const
		{
			ar << m_lEmfBitsSz;					// m_bypEmfBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
			ar.Write(m_bypEmfBits, m_lEmfBitsSz);	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		}
	void InStream (MCARCHIVE& ar)
		{
			ar >> m_lEmfBitsSz;					// m_bypEmfBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
			if (m_bypEmfBits != NULL) delete[] m_bypEmfBits;
			m_bypEmfBits = new BYTE[m_lEmfBitsSz];
			ar.Read(m_bypEmfBits, m_lEmfBitsSz);		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		}
	void Clear ()
		{
			if (m_bypEmfBits != NULL) delete[] m_bypEmfBits;
			m_bypEmfBits = NULL;
			m_lEmfBitsSz = 0;
		}
private:
	void Init (const BYTE* bypBits, long lBitSize, const wchar_t* pName)
		{
			if (m_bypEmfBits != bypBits)
			{
				if (m_bypEmfBits != NULL) delete[] m_bypEmfBits;
				m_bypEmfBits = NULL;
				if (bypBits != NULL)
				{
					m_bypEmfBits = new BYTE[lBitSize];
					memcpy(m_bypEmfBits, bypBits, lBitSize);
				}
				m_lEmfBitsSz = lBitSize;
			}
			if (m_szName != pName)
			{
				int iLen = (int)wcslen(pName);
				if (FD_ENV_NAME_LEN <= iLen) iLen = FD_ENV_NAME_LEN - 1;
				wcsncpy(m_szName, pName, iLen);
				m_szName[iLen] = L'\0';
			}
		}
public:
	BYTE*	m_bypEmfBits;				// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiCmMiDhCiDgCiDgHjHpBiDgPiDgCiDhEiDeAiBeC_xHqqkZx_
	long	m_lEmfBitsSz;				// m_bypEmfBits_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiBeC_xHqqkZx_
	wchar_t	m_szName[FD_ENV_NAME_LEN];	// _xZkqqHx_iClBiCmMiDiBiDfOiDhEiDeAiDeDiDiLiCmMjDgPjIfOjGlMiBeC_xHqqkZx_
}; // class MC3EmfImageRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3BrushRegisterRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiDhFiDiJiDfGiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC3BrushRegisterRec
{
public:
	MC3BrushRegisterRec ()
		{
			//----- _xZkqqHx_jBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----
			m_ptidBrushPattern = FD_PATTERN_UNUSE;
			m_scidBrushForeSColor = FD_S_COLOR_UNUSE;
			m_scidBrushBackSColor = FD_S_COLOR_UNUSE;
			m_szName[0] = L'\0';
		}
	void OutStream (MCARCHIVE& ar) const
		{
			ar << m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
			ar << m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
			ar << m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		} // MC3BrushRegisterRec::OutStream.

	void InStream (MCARCHIVE& ar)
		{
			ar >> m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
			ar >> m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
			ar >> m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		} // MC3BrushRegisterRec::InStream.
public:
	PatternID	m_ptidBrushPattern;		// BRUSH_xZkqqHx_iCmMiDiCiDgNiDhAiDfOiBfLiDjD_xHqqkZx_
	SColorID	m_scidBrushForeSColor;	// BRUSH_xZkqqHx_iCmMjBePiMgJjAeGiBeC_xHqqkZx_
	SColorID	m_scidBrushBackSColor;	// BRUSH_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	wchar_t		m_szName[FD_ENV_NAME_LEN];	// _xZkqqHx_iClBiCmMjDgPjIfO_xHqqkZx_BRUSH_xZkqqHx_iCmMjGlMjBePiBeC_xHqqkZx_
}; // class MC3BrushRegisterRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3PenRegisterRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDgPjIfOiDhJiDjDiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *************************************************************************/
class MC3PenRegisterRec
{
public:
	MC3PenRegisterRec ()
		{
			//----- _xZkqqHx_jBfDiCmEiCmMjFmPjAjEiCpAiPiJiKpKiJlL_xHqqkZx_ -----
			m_psidPenStyle		= FD_PEN_STYLE_UNUSE;
			m_mmfPenWeight		= FD_PEN_WEIGHT_UNUSE;
			m_scidPenBackSColor	= FD_S_COLOR_UNUSE;
			m_szName[0]			= L'\0';
		} // MC3PenRegisterRec::MC3PenRegisterRec.

	void OutStream (MCARCHIVE& ar) const
		{
			ar << m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
			ar << m_mmfPenWeight;			// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
			ar << m_scidPenBackSColor;	// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		} // MC3PenRegisterRec::OutStream.

	void InStream (MCARCHIVE& ar)
		{
			ar >> m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
			ar >> m_mmfPenWeight;		// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
			ar >> m_scidPenBackSColor;	// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		} // MC3PenRegisterRec::InStream.

public:
	PenStyleID	m_psidPenStyle;		// PEN_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiBeC_xHqqkZx_
	fmmetol		m_mmfPenWeight;		// PEN_xZkqqHx_iCmMjFjNiBeC_xHqqkZx_
	SColorID	m_scidPenBackSColor;// PEN_xZkqqHx_iCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	wchar_t		m_szName[FD_ENV_NAME_LEN];
									// _xZkqqHx_iClBiCmMjDgPjIfO_xHqqkZx_PEN_xZkqqHx_iCmMjGlMjBePiBeC_xHqqkZx_
}; // class MC3PenRegisterRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3PenStyleRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBgJjIeBjBlBjApMiBeBjDfPjApMjDjJiBgKiCpAiKmHjHjNiClHiCoJiDiMiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.30 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkMiBeC_xHqqkZx_
 *			99.06.29 Fukushiro M. _xZkqqHx_iDhAiDfOiBfLiDjDiCpAiOmAiNmAjFfHiMgOiCnGjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
class MC3PenStyleRec
{
public:
	MC3PenStyleRec () { memset(this, 0, sizeof(*this)); }
	void OutStream (MCARCHIVE& ar) const
		{
			ar.Write(m_mmfaData, sizeof(m_mmfaData));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		}
	void InStream (MCARCHIVE& ar)
		{
			ar.Read(m_mmfaData, sizeof(m_mmfaData));
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		}
public:
	fmmetol	m_mmfaData[4];
	wchar_t	m_szName[FD_ENV_NAME_LEN];
}; // class MC3PenStyleRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3SFontRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iChCiDhEiDeIiDjDiDgHiPoOjFpBiCpAiKmHjHjNiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.06 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC3SFontRec
{
public:
	MC3SFontRec () {};
	void	OutStream (MCARCHIVE& ar) const
		{
			ar << m_mmFontHeight;
			ar << m_wWeight;
			ar << m_byItalic;
			ar << m_byCharSet;
			ar << m_byPitchAndFamily;
			// _xZkqqHx_iDhEiDeIiDjDiDgHjGlMiBeC_xHqqkZx_
			const WORD wNameLen = (WORD)wcslen(m_szFaceName);
			ar << wNameLen;
			ar.Write(m_szFaceName, wNameLen * sizeof(wchar_t));
		} // MC3SFontRec::OutStream.

	void	InStream (MCARCHIVE& ar)
		{
			ar >> m_mmFontHeight;
			ar >> m_wWeight;
			ar >> m_byItalic;
			ar >> m_byCharSet;
			ar >> m_byPitchAndFamily;
			// _xZkqqHx_iDhEiDeIiDjDiDgHjGlMiBeC_xHqqkZx_
			WORD wNameLen;
			ar >> wNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (LF_FACESIZE <= wNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szFaceName, wNameLen * sizeof(wchar_t));
			m_szFaceName[wNameLen] = L'\0';
		} // MC3SFontRec::InStream.

protected:
	mmetol	m_mmFontHeight;	// FONT_xZkqqHx_jAlGjAkMiCmFiOhHjCoIiClHiCoJiNiCiClD_xHqqkZx_(mm)._xZkqqHx_jGhLjDjGiCmMiNiCiClDiCmFiCmNiCmIiCkC_xHqqkZx_.
	WORD	m_wWeight;
	BYTE	m_byItalic;
	BYTE	m_byCharSet;
	BYTE	m_byPitchAndFamily;
	BYTE	dummy1;
	wchar_t	m_szFaceName[LF_FACESIZE];
}; // class MC3SFontRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3ChipGroupRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhGiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC3ChipGroupRec
{
public:
	// _xZkqqHx_iImIiJlKiCmMiKnGjAjEiMfBiCmFiCmNiBeB_xHqqkZx_m_vFreqChip _xZkqqHx_iCmNiCkCiCmBiClDiCkCiIlFiCoNiCmIiCkCiBeC_xHqqkZx_
	// m_vFreqChip _xZkqqHx_iCmNiBeB_xHqqkZx_DistributeChipToGroup/CollectChipToGroup_xZkqqHx_iCmFiCmMiCnN_xHqqkZx_
	// _xZkqqHx_jFmPiNfIiClDiCoKiCoJiCoAiCmMiCmGiClHiCoJiBeC_xHqqkZx_
	MC3ChipGroupRec ()  { memset(this, 0, sizeof(*this)); }
	void OutStream (MCARCHIVE& ar) const
		{
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		}
	void InStream (MCARCHIVE& ar)
		{
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		}
public:
	FDChipIDVector	m_vFreqChip;
	wchar_t			m_szName[FD_ENV_NAME_LEN];
}; // class MC3ChipGroupRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3ChipRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC3ChipRec
{
public:
	MC3ChipRec ()
		{
			m_objpChipMaster = NULL;
			m_szName[0] = L'\0';
		} // MC3ChipRec::MC3ChipRec.

	~MC3ChipRec ()
		{
			Clear();
		} // MC3ChipRec::~MC3ChipRec.

	void OutStream (MCARCHIVE& ar) const
		{
			ar << (BYTE)(m_objpChipMaster->Type());
			m_objpChipMaster->OutStream(ar);
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		} // MC3ChipRec::OutStream.

	void InStream (MCARCHIVE& ar)
		{
			BYTE byType;
			ar >> byType;
			m_objpChipMaster = ::NewFDObjAny(static_cast<FTObjectType>(byType));
			m_objpChipMaster->InStream(ar);
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		} // MC3ChipRec::InStream.

	void Clear ()
		{
			if (m_objpChipMaster != NULL)
			{
				delete m_objpChipMaster;
				m_objpChipMaster = NULL;
			}
			*m_szName = L'\0';
		} // MC3ChipRec::Clear.

public:
	MC3ObjBase*	m_objpChipMaster;
	wchar_t		m_szName[FD_ENV_NAME_LEN];
}; // class MC3ChipRec.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3PictArrowRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpDiPoOjFpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.07 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC3PictArrowRec
{
public:
	MC3PictArrowRec ()
		{
			m_objpPictArrowMaster1 = NULL;
			m_objpPictArrowMaster2 = NULL;
			m_szName[0] = L'\0';
		} // MC3PictArrowRec::MC3PictArrowRec.

	~MC3PictArrowRec ()
		{
			Clear();
		} // MC3PictArrowRec::~MC3PictArrowRec.

	void OutStream (MCARCHIVE& ar) const
		{
			ar << (BYTE)(m_objpPictArrowMaster1->Type());
			m_objpPictArrowMaster1->OutStream(ar);
			if (m_objpPictArrowMaster2 == NULL)
			{
				ar << (BYTE)FDOJ_NONE;
			} else
			{
				ar << (BYTE)(m_objpPictArrowMaster2->Type());
				m_objpPictArrowMaster2->OutStream(ar);
			}
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			const BYTE byNameLen = (BYTE)wcslen(m_szName);
			ar << byNameLen;
			ar.Write(m_szName, byNameLen * sizeof(wchar_t));
		} // MC3PictArrowRec::OutStream.

	void InStream (MCARCHIVE& ar)
		{
			BYTE byType;
			ar >> byType;
			m_objpPictArrowMaster1 = ::NewFDObjAny(static_cast<FTObjectType>(byType));
			m_objpPictArrowMaster1->InStream(ar);
			ar >> byType;
			if (byType == (BYTE)FDOJ_NONE)
			{
				m_objpPictArrowMaster2 = NULL;
			} else
			{
				m_objpPictArrowMaster2 = ::NewFDObjAny(static_cast<FTObjectType>(byType));
				m_objpPictArrowMaster2->InStream(ar);
			}
			// _xZkqqHx_jDgPjIfOjGlMiBeC_xHqqkZx_
			BYTE byNameLen;
			ar >> byNameLen;
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
			// _xZkqqHx_jAkHiMmAjClHiCpAjClEiCkGiCoJiPoKiNiHiCmNiBeBjEgKjBlJiBeC_xHqqkZx_
			if (FD_ENV_NAME_LEN <= byNameLen)
				FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
//----- 06.03.26 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
			ar.Read(m_szName, byNameLen * sizeof(wchar_t));
			m_szName[byNameLen] = L'\0';
		} // MC3PictArrowRec::InStream.

	void Clear ()
		{
			if (m_objpPictArrowMaster1 != NULL)
			{
				delete m_objpPictArrowMaster1;
				m_objpPictArrowMaster1 = NULL;
			}
			if (m_objpPictArrowMaster2 != NULL)
			{
				delete m_objpPictArrowMaster2;
				m_objpPictArrowMaster2 = NULL;
			}
			*m_szName = L'\0';
		} // MC3PictArrowRec::Clear.

public:
	MC3ObjBase*	m_objpPictArrowMaster1;
	MC3ObjBase*	m_objpPictArrowMaster2;
	wchar_t		m_szName[FD_ENV_NAME_LEN];
}; // class MC3PictArrowRec.


class MC3Env
{
public:
	MC3Env ();
	~MC3Env ();
	void	ClearEnvTbl ();
	void	InStream (MCARCHIVE& ar);
	void	OutStream (MCARCHIVE& ar);

	void	InEmfImage (MCARCHIVE& ar);
	void	OutEmfImage (MCARCHIVE& ar,
						const set<EmfImageID>& stEmfImageID);

	const MC3EmfImageRec* GetEmfImageRec (EmfImageID emid) const;
	EmfImageID	AddEmfImageRec (MC3EmfImageRec* pRec);


protected:
	DBLPoint	m_mmptShadowLen;		// _xZkqqHx_iJgFiCmMjClHiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_jHhAiOiGiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	short		m_nDocPaperOrient;		// _xZkqqHx_jHhAiOiGiCmMjFpLiMpMiBeC_xHqqkZx_
	short		m_nDocPaperType;		// _xZkqqHx_jCoIiMgAjHhAiOiGiCmMiDfOiDeDiDhGiBeC_xHqqkZx_ A4,B5,etc.
	mmetol		m_mmDocPaperWidth;		// _xZkqqHx_jHhAiOiGiCmMjFjNiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	mmetol		m_mmDocPaperHeight;		// _xZkqqHx_jHhAiOiGiCmMiNiCiClDiBeCjHhAiOiGiCmMjFpLiMpMiCmNjAeEiCoIiNjOiCnNiNmPiBeC_xHqqkZx_
	mmetol		m_mmDocPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	mmetol		m_mmDocPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	mmetol		m_mmDocPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	mmetol		m_mmDocPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_
	double		m_dDocPageTimesX;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_X_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	double		m_dDocPageTimesY;		// _xZkqqHx_jHhAiOiGjBmOiDhJiBfLiDfHiCmM_xHqqkZx_Y_xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
	DBLRect		m_mmrtSheet;			// _xZkqqHx_iDfGiBfLiDgHiCmMjBoFiCkLiClDiBeC_xHqqkZx_
	//----- _xZkqqHx_iDhGiDiKiDjDiDfOiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----
	BOOL		m_bUseDocMarginAsPrn;	// _xZkqqHx_jHhAiOiGiCmMjHfNjEjCjCgMiCpAiOgHiCkEiCkJiBeI_xHqqkZx_
	mmetol		m_mmPrnPaperMarginL;	// _xZkqqHx_jHhAiOiGiCmMiNlGjHfNjEjCiBeC_xHqqkZx_
	mmetol		m_mmPrnPaperMarginT;	// _xZkqqHx_jHhAiOiGiCmMiPoDjHfNjEjCiBeC_xHqqkZx_
	mmetol		m_mmPrnPaperMarginR;	// _xZkqqHx_jHhAiOiGiCmMiJeFjHfNjEjCiBeC_xHqqkZx_
	mmetol		m_mmPrnPaperMarginB;	// _xZkqqHx_jHhAiOiGiCmMiJlKjHfNjEjCiBeC_xHqqkZx_

	//----- _xZkqqHx_iDhJiBfLiDfHiCmMiDhGiDiNiDhAiDgFiDeC_xHqqkZx_ -----

	// _xZkqqHx_iKmCiLkLiDgFiBfLiDhFiDiL_xHqqkZx_
	// _xZkqqHx_iCoGiCkNiOgHiCkEiDiMiDfCiBfLiDgIiCmM_xHqqkZx_ID_xZkqqHx_iDiKiDfIiDgH_xHqqkZx_.
	// S_xZkqqHx_jAeG_xHqqkZx_
	MC3SColorRecVector	m_vSColor;
	FDSColorIDVector	m_vFreqSColor;

	// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiDhAiDfOiBfLiDjD_xHqqkZx_
	MC3EmfImageRecVector	m_vEmfImage;
	FDEmfImageIDVector	m_vFreqEmfImage;

	// _xZkqqHx_iDhFiDiJiDfGiCmMjDgPjIfOjGlM_xHqqkZx_
	MC3BrushRegisterRecVector	m_vBrushRegister;
	FDBrushRegisterIDVector	m_vFreqBrushRegister;

	// _xZkqqHx_iDhJiDjDiCmMjDgPjIfOjGlM_xHqqkZx_
	MC3PenRegisterRecVector	m_vPenRegister;
	FDPenRegisterIDVector	m_vFreqPenRegister;

	// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiL_xHqqkZx_(_xZkqqHx_jClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc)
	MC3PenStyleRecVector	m_vPenStyle;
	FDPenStyleIDVector	m_vFreqPenStyle;

	// S_xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_
	MC3SFontRecVector	m_vSFont;
	FDSFontIDVector	m_vFreqSFont;

	// _xZkqqHx_iDgAiDgCiDhGiDePiDiLiBfLiDhG_xHqqkZx_
	MC3ChipGroupRecVector	m_vChipGroup;
	FDChipGroupIDVector	m_vFreqChipGroup;

	// _xZkqqHx_iDgAiDgCiDhG_xHqqkZx_
	MC3ChipRecVector	m_vChip;
	FDChipIDVector	m_vFreqChip;

	// _xZkqqHx_iDhDiDeOiDgAiDiDjGoOiIpD_xHqqkZx_
	MC3PictArrowRecVector	m_vPictArrow;
	FDPictArrowIDVector	m_vFreqPictArrow;
}; // class MC3Env.

#endif//__3Env_h
