/*
 * PgSVGExport.cpp
 *
 *   first source from Fukushiro Masayuki
 *   ver 0.1  2001-08-14 by HIROSAWA Masashi
 */

/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/


#include "stdafx.h"
#include <float.h>					// For DBL_MAX.
#include <assert.h>					// For assert.
#include <tchar.h>					// For _TCHAR.
#include <AFXPRIV.H>
// 06.06.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "MpgExtern.h"				// For Global.
#include "Module.h"					// For FMpgGetModule().
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#include "DBLMath.h"				// For DBLPoint.
//#include "DBLPoint.h"				// For DBLPoint.
//#include "DBLRect.h"				// For DBLRect.
//#include "FCLinkManagerExpType.h"	// For FCLinkRecVector.
//#include "FCEnvExpType.h"			// For FCEnvExp.h.
//#include "FCEnvExp.h"				// For FCEnvExp.
//#include "FCObjectExp.h"			// For FCObjectExp.
//#include "FCTextEditorExpType.h"	// For FCRichTextExp.h.
//#include "FCRichTextExpType.h"		// For FCStatChar.etc.
//#include "FCRichTextExp.h"			// For FCRichTextExp.
//#include "MpgClasses.h"				// For FCSFontRec.
//#include "FCObjectExpType.h"
//#include "FCViewExp.h"				// For FCViewExp.
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#include <stdio.h>
#include <htmlhelp.h>

#include "SvgExportOption.h"
#include "SvgExportInfo.h"
#include "resource.h"
#include "OptionDlg.h"

extern void printSvgHeader( FILE *fptr );

static const wchar_t* s_wcpAuthorName =
	L"Copyright (C) 2001,2002  HIROSAWA Masashi\r\n"
	L"All Rights Reserved.";

// A CLSID for the Component-0.
// Each Component must have a unique CLSID.
// You can get the unique CLSID using 'guidgen.exe'.
// Caution!
// This CLSID must be different from the value of PG_MODULE_CLSID.
#ifdef _DEBUG
// {EB245438-22E2-4B2E-8D3A-FD85996C957B}
static const GUID PG_COMPONENT_CLSID = FMpgGuid(0xeb245438, 0x22e2, 0x4b2e, 0x8d, 0x3a, 0xfd, 0x85, 0x99, 0x6c, 0x95, 0x7b);
#else
// {DFC668BC-72CB-4E28-A9A3-B38EF0FD8F14}
static const GUID PG_COMPONENT_CLSID = FMpgGuid(0xdfc668bc, 0x72cb, 0x4e28, 0xa9, 0xa3, 0xb3, 0x8e, 0xf0, 0xfd, 0x8f, 0x14);
#endif

// Component name.
#ifdef _DEBUG
static const wchar_t*	s_wcpComponentName = L"SVG Export (Debug)";
#else
static const wchar_t*	s_wcpComponentName = L"SVG Export";
#endif

// Component version.
static const wchar_t*	s_wcpComponentVersion = SVG_EXPORT_VERSION_L;

#ifdef PG_JP
#include "JP.DATA"
#else//PG_JP
#include "ENG.DATA"
#endif//PG_JP

// _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiBeC_xHqqkZx_
static const wchar_t s_wcComponentShortcut = L'S';
// _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiDiBiDgKiDiFiBfLjGlMiBeC_xHqqkZx_
static const wchar_t* s_tcpMenu[] =
{
	L"Option...",
	L"Help",
	L"Version...",
};
// _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiDiBiDgKiDiFiBfLiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiBeC_xHqqkZx_
static const wchar_t s_tcpMenuShortcut[] =
{
	L'G',
	L'B',
	L'A',
};

#define PG_FORMAT_SVG	0

static const wchar_t* s_tcpFileFormatName[] =
{
	L"SVG file (*.svg)",
};
static const wchar_t* s_tcpFileFormatExt[] =
{
	L".svg",
};

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::GetComponentCLSID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmM_xHqqkZx_CLSID_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	CLSID_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const GUID& CA0::GetComponentCLSID () const
{
	return PG_COMPONENT_CLSID;
} // CA0::GetComponentCLSID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::GetAuthorName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiNoMiOnCjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiNoMiOnCjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.12.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA0::GetAuthorName () const
{
	return s_wcpAuthorName;
} // CA0::GetAuthorName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::GetComponentName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMiCmNiBeBiDiBiDgKiDiFiBfLiCmMiDfEiDhFiDiBiDgKiDiFiBfLjGlMiCmIiCmHiCmFiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iMlOiMoKiDfCiBfLiDgIiCmJjCiNiInDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA0::GetComponentName () const
{
	return s_wcpComponentName;
} // CA0::GetComponentName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::GetVersionName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgPiBfLiDfHiDiHiDjDjGlMjFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA0::GetVersionName () const
{
	return s_wcpComponentVersion;
} // CA0::GetVersionName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::GetComment
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfCiDjDiDhMiBfLiDgFiDjDiDgHiCmMiJpAjAoAiDfCiDiBiDjDiDgHiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ NULL_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
const wchar_t* CA0::GetComment () const
{
	return s_wcpComment;
} // CA0::GetComment.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::GetComponentShortcut
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiDiBiDgKiDiFiBfLiCmJjDgPjIfOiClHiCoJiCmGiCkLiCmMiDfGiDiHiBfLiDgHiDeKiDgCiDgHiDeMiBfLiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeMiBfLiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClFiClNiDeMiBfLiCkKjFeLiClIjDgPjIfOiCmFiCkLiCoJiCoNiCkPiCmFiCmNiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
wchar_t CA0::GetComponentShortcut () const
{
	return s_wcComponentShortcut;
} // CA0::GetComponentShortcut.

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pI	:Molip Draw_xZkqqHx_jBkEiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA0::Initialize (IMpgMolipMain* pI)
{
	// Molip Draw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
	if (FAILED(IMpgInterface::Initialize(pI))) return E_FAIL;
	// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKiDfEiDhMiBfLiDgHiClHiCoJiDfCiDhNiDjDiDgIiCpAjDgPjIfOiBeC_xHqqkZx_
	int iC;
	for (iC = 0; iC < sizeof(s_tcpMenu) / sizeof(s_tcpMenu[0]); iC++)
	{
		m_adwCommandId[iC] = GetMolipMainI()->
				RegisterCommand(TRUE, s_tcpMenu[iC], s_tcpMenuShortcut[iC]);
	}
	// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKiDfEiDhMiBfLiDgHiClHiCoJiDhEiDeAiDeDiDiLiDhEiDeIiBfLiDhNiDgCiDgHiCpAjDgPjIfOiBeC_xHqqkZx_
	// _xZkqqHx_iClBiClBiCmMjDgPjIfOiCkKiBeBiDhEiDeAiDeDiDiLiDiBiDgKiDiFiBfL_xHqqkZx_ -> _xZkqqHx_jBeJjBpAjFjEjFgJiCpAjBlMiMgAiOkOiCmFjFnLjBlG_xHqqkZx_ _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmFjFfMiOkGiBeC_xHqqkZx_
	for (iC = 0; iC < sizeof(s_tcpFileFormatName) / sizeof(s_tcpFileFormatName[0]); iC++)
	{
		m_adwFormatId[iC] = GetMolipMainI()->RegisterSelObjSaveFormat(
									s_tcpFileFormatName[iC], s_tcpFileFormatExt[iC]);
	}

	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCkJiCoHjAnNjCoIiPpDjBnEiCpAiOoGjDlO_xHqqkZx_ -----
	HRESULT hr = GetMolipMainI()->GetProfileBinary(	L"SvgExportOption",
														(BYTE*)&SvgExportInfo::svgExportOption,
														sizeof(SvgExportOption));
	if (SvgExportInfo::svgExportOption._version != SVG_EXPORT_VERSION_NUM)
	{
		// _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCmMiDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClFiCmIiCkCiCmMiCmFiDgGiDhEiDeIiDiLiDgHiCmJiClHiCoJ_xHqqkZx_
		if (0.0 != SvgExportInfo::svgExportOption._version)
		{
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//			::AfxMessageBox( "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhGiDiNiDePiDiJiDiAiCmMiDgPiBfLiDfHiDiHiDjDiCmGiLeMjIfOiClDiCoKiCmEiCkCiCoJiDeJiDhGiDfGiDiHiDjDiCmM_xHqqkZx_\n_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClFiCmIiCkCiCmMiCmFiBeBiDeJiDhGiDfGiDiHiDjDiCmMjCgMiCpA_xHqqkZx_\n_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmJjAnNjCoIiClFjClMiClFiCnMiClFiClN_xHqqkZx_" );
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
			//  "SVGExport_xZkqqHx_iDhGiDiJiDePiDeDiDjD_xHqqkZx_ _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_\n\n_xZkqqHx_iDhGiDiNiDePiDiJiDiAiCmMiDgPiBfLiDfHiDiHiDjDiCmGiLeMjIfOiClDiCoKiCmEiCkCiCoJiDeJiDhGiDfGiDiHiDjDiCmM_xHqqkZx_\n_xZkqqHx_iDgPiBfLiDfHiDiHiDjDiCkKiIoKjChGiClFiCmIiCkCiCmMiCmFiBeBiDeJiDhGiDfGiDiHiDjDiCmMjCgMiCpA_xHqqkZx_\n_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmJjAnNjCoIiClFjClMiClFiCnMiClFiClN_xHqqkZx_" );
			::AfxMessageBox(FFLoadString(IDS_ERRMSG_VERSION_INCONSISTENCY));
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		}
		SvgExportInfo::svgExportOption.setDefault();
	}
	return S_OK;
} // CA0::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::Terminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiPeJjHlJiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA0::Terminate ()
{
	//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiCpAiLeMjIfO_xHqqkZx_ -----
	HRESULT hr = GetMolipMainI()->SetProfileBinary(	L"SvgExportOption",
														(BYTE*)&SvgExportInfo::svgExportOption,
														sizeof(SvgExportOption));
	// Molip Draw_xZkqqHx_iCmMiDiBiDeDiDjDiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiKeKjFpKiBeC_xHqqkZx_
	return IMpgInterface::Terminate();
} // CA0::Terminate.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::OnCommand
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiCkKiOmAiNhDiClDiCoKiClNiCmGiCkLiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nCmdID	:_xZkqqHx_iOmAiNhDiClDiCoKiClNiDfCiDhNiDjDiDgIiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA0::OnCommand (UINT nCmdID)
{
	if (nCmdID == m_adwCommandId[0])
	{
		//----- Option_xZkqqHx_jAnNjCoIiDfPiDeDiDeBiDiNiDeP_xHqqkZx_ -----
		HINSTANCE hInstOld = ::AfxGetResourceHandle();
		AfxSetResourceHandle((HINSTANCE)FMpgGetModule()->GetModuleHandle());
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		COptionDlg optionDlg;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		COptionDlg optionDlg(CWnd::FromHandle(FFGetMolipBaseI()->GetMainWindow()));
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

		optionDlg.getSvgExportOption(&SvgExportInfo::svgExportOption);
		int result = optionDlg.DoModal();
		if ( IDOK == result )
		{
			optionDlg.setSvgExportOption(&SvgExportInfo::svgExportOption);
		}
		AfxSetResourceHandle(hInstOld);
	} else if (nCmdID == m_adwCommandId[1])
	{
		//----- _xZkqqHx_iDhHiDiLiDhGiDfCiDhNiDjDiDgI_xHqqkZx_ -----
		// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKjFhEiCkLjGlMjBePiBgJiKgHjCkDiOhBjGlDiClFiBgKiCpAiOoGjDlOiBeC_xHqqkZx_
		_TCHAR tcsModule[_MAX_PATH];
		FMpgGetModule()->GetModulePathName(tcsModule, _MAX_PATH);
		_tcscat(tcsModule, _T(".chm"));
		HtmlHelp( FFGetMolipBaseI()->GetMainWindow(), tcsModule, HH_HELP_FINDER,(DWORD)0);
	} else if (nCmdID == m_adwCommandId[2])
	{
		// _xZkqqHx_iDgPiBfLiDfHiDiHiDjDiDfPiDeDiDeBiDiNiDeP_xHqqkZx_
		GetMolipMainI()->ShowAboutDialog();
	}
	return S_OK;
} // CA0::OnCommand.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::OnUpdateCommandUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCkKjAnNjCoIiClFiClNiDfCiDhNiDjDiDgIiCmMiDiBiDgKiDiFiBfLiCkKjFfMiOkGiClDiCoKiClNiCmGiCkLiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pCmdUI	:_xZkqqHx_iDfCiDhNiDjDiDgIjFfMiOkGiPpDjBnEiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeBiOlIjEhDiClFiClNiPoKiNiHiCmNiDeHiDiJiBfLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
HRESULT CA0::OnUpdateCommandUI (MfcCmdUI* pCmdUI)
{
	// _xZkqqHx_iDfEiDhFiDiBiDgKiDiFiBfLiCmMiPoKiNiHiBgJiDfEiDhFiDiBiDgKiDiFiBfLiCmFiCoAiClBiClBiCkKiMmEiCmOiCoKiCoJiBgKiCmNiBeBjFjMiLeBiBeC_xHqqkZx_
	if (pCmdUI->m_pSubMenu != NULL) return S_OK;
	if (pCmdUI->m_nID == m_adwCommandId[0])
	//----- _xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgH_xHqqkZx_0_xZkqqHx_jAnNjCoIiDfCiDhNiDjDiDgI_xHqqkZx_ -----
	{
		pCmdUI->Enable(TRUE);
	}
	return S_OK;
} // CA0::OnUpdateCommandUI.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::OnSelectedObjectSave
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjAnNjCoIiClFiClNiDhEiDeIiBfLiDhNiDgCiDgHiCmFiDhEiDeAiDeDiDiLjFnLjBlGiCmMiOjOiCmJiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nFormatId		:_xZkqqHx_iDhEiDeIiBfLiDhNiDgCiDgH_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpFileName		:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginLeft	:_xZkqqHx_iNlGjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginTop		:_xZkqqHx_iPoDjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginRight	:_xZkqqHx_iJeFjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mmMarginBottom	:_xZkqqHx_iJlKjBkEiCmMjHfNjEjCiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *          2001-08-14 _xZkqqHx_jCmHiJmBiBeFiPeDjAlD_xHqqkZx_ HIROSAWA Masashi
 *
 *************************************************************************/
HRESULT CA0::OnSelectedObjectSave (	UINT nFormatId, const wchar_t* wcpFileName,
									mmetol mmMarginLeft, mmetol mmMarginTop,
									mmetol mmMarginRight, mmetol mmMarginBottom)
{
	if (nFormatId == m_adwFormatId[PG_FORMAT_SVG])
	{
		return exportSelectedObjToSVGFile(	wcpFileName,
											mmMarginLeft, mmMarginTop,
											mmMarginRight, mmMarginBottom);
	}
	return S_OK;
} // CA0::OnSelectedObjectSave.

/////////////////////////////////////////////////////////////////////////////////

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::CA0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeCiDeKiDeFiDjDiDfOiCpAiJmBiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CA0::CA0 ()
{
} // CA0::CA0.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::~CA0
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeCiDeKiDeFiDjDiDfOiCpAiMlIiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CA0::~CA0 ()
{
} // CA0::~CA0.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CA0::ExtractChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgFiDeMiDfIiDgHiCpAiOoGiCoIiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pRich	:_xZkqqHx_iOoGiCoIiPgPiClHjBmOiPnLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CA0::ExtractChar (FCRichText* pRich)
{
	if (pRich->GetTextRect().Height() - pRich->GetMarginB() <
			pRich->GetTextData().front().m_mmY +
			pRich->GetTextData().front().m_mmfTMHeight +
			pRich->GetTextData().front().m_mmfTMExternalLeading) return;

	mmetol	mmX;
	mmetol	mmBaseLine;

	mmetol		mmTMAscent;		// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	mmetol		mmTMDescent;	// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	SFontID		foidCur = FD_S_FONT_UNSPECIFY;	// _xZkqqHx_iDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	COLORREF	crefCur = FD_COLOR_REF_UNSPECIFY;	// S_xZkqqHx_jAeG_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	WORD		wOffset = WORD(-1);	// Font_xZkqqHx_iDfEiDeDiDfJiPoOjFpBiBeC_xHqqkZx_
	BYTE		byCrossStat = BYTE(-1);	// _xZkqqHx_jFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
	short		nAfterSpace = short(MINSHORT);
	BYTE		byUnderline = BYTE(-1);
	BYTE		byStrikeOut = BYTE(-1);
	const FCSFontRec*	pFontRec = NULL;

	long	lLine;
	long	lChar;
	const FCStatChar* pChar;
	for (pChar = pRich->CharFirst(lLine, lChar, mmX, nAfterSpace, mmBaseLine);
		 pChar != NULL;
		 pChar = pRich->CharNext(lLine, lChar, mmX, nAfterSpace, mmBaseLine))
	{
		switch (pChar->m_wChar)
		{
		case FDRCH_RETURN:		// _xZkqqHx_iJpMiNhDiLeMiNiGiBeC_xHqqkZx_
		case FDRCH_CONTINUE:	// _xZkqqHx_iMhAjBlBiNhDiLeMiNiGiBeC_xHqqkZx_
			break;

		case FDRCH_FONT_AND_OFFSET:		// FONT,Offset_xZkqqHx_jAnNjCoI_xHqqkZx_.
			// _xZkqqHx_iMlLiNnNiCmMiDhEiDeIiDjDiDgHjAnNjCoIiBeC_xHqqkZx_
			foidCur = pChar->m_foidFont;
			// _xZkqqHx_iDeJiDhEiDfKiDgCiDgHjAnNjCoIiBeC_xHqqkZx_
			wOffset = pChar->m_wOffset;
			pFontRec = FFGetMolipBaseI()->GetEnv()->GetSFontRec(foidCur);
			mmTMAscent = FFGetMolipBaseI()->GetEnv()->GetSFontRec(foidCur)->m_mmAscent;
			mmTMDescent = FFGetMolipBaseI()->GetEnv()->GetSFontRec(foidCur)->m_mmDescent;
			break;

		case FDRCH_COLORREF:			// COLORREF_xZkqqHx_jAnNjCoI_xHqqkZx_.
			// _xZkqqHx_iMlLiNnNiCmMjFlGiOjKjAeGiCpAjAnNjCoIiBeC_xHqqkZx_
			crefCur = pChar->m_crColor;
			break;

		case FDRCH_AFTERSPACE:		// AfterSpace_xZkqqHx_jAnNjCoI_xHqqkZx_.
			break;

		case FDRCH_LINES_AND_CROSSSTAT:	// _xZkqqHx_iOoGiPmBiClFjApMiBeBiJlKjApMiBeBjFlGiOjKiIoMiCoKiPpDjBnEiBeC_xHqqkZx_
			byUnderline = pChar->m_byUnderline;
			byStrikeOut = pChar->m_byStrikeOut;
			byCrossStat = pChar->m_byCrossStat;
			break;

		case FDRCH_PRESPACE:	// _xZkqqHx_jFlGiOjKjBePjHfNjEjC_xHqqkZx_.
			break;

		case L'\t':	// _xZkqqHx_iDfOiDhF_xHqqkZx_.
			break;

		default:	// WCH_SPC, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
		  {
			// _xZkqqHx_iClBiCoKiImIiPoDiJeFjBkEiCmJiPjBiCkNiInDjGkBiCmNiCmIiCkCiBeC_xHqqkZx_
			if (byCrossStat == FDWR_CROSS_OUTSIDE || pRich->GetTextRect().right < mmX)
				break;
			// _xZkqqHx_jFlGiOjKiImKjChFiBeC_xHqqkZx_
			mmetol mmY = mmBaseLine - mmTMAscent;
			mmetol mmLeft = mmX + pChar->m_mmfAbcA;
			mmetol mmRight = mmX + pChar->m_mmfWidth - pChar->m_mmfAbcC;
		  }
		}
	}
} // CA0::ExtractChar.
