/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.config;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.springframework.core.env.Environment;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigManager {
    private static Path CONFIG_PATH = null;
    private static final String CERTIFICATE_ALIAS = "webshell-cert";
    private static final String CERTIFICATE_ALGORITHM = "RSA";
    private static final String CERTIFICATE_DN = "CN=easy.webshell.app, O=easy.webshell.app, L=easy.webshell.app, ST=il, C=c";
    private static final int CERTIFICATE_BITS = 2048;

    static {
        Path configPath = null;
        String configPathStr = System.getenv("EASY_WEB_SHELL_CONFIG_DIR");
        configPath = configPathStr == null || configPathStr.length() < 1 ? Paths.get(System.getProperty("user.home"), ".easy-web-shell") : Paths.get(configPathStr, ".easy-web-shell");
        CONFIG_PATH = configPath;
        try {
            Files.createDirectories(configPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void saveUserDetails() throws FileNotFoundException, IOException {
        Path userConfigPath = CONFIG_PATH.resolve("users.properties");
        Properties prop = new Properties();
        prop.put("app.default-user", System.getProperty("app.default-user"));
        prop.put("app.default-pass", System.getProperty("app.default-pass"));
        prop.put("app.default-shell", System.getProperty("app.default-shell"));
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream out = new FileOutputStream(userConfigPath.toFile());){
            prop.store(out, "User details");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void loadUserDetails(Environment env) {
        Path userConfigPath = CONFIG_PATH.resolve("users.properties");
        Properties prop = new Properties();
        if (Files.exists(userConfigPath, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Iterator<String> iterator = null;
                try (FileInputStream in = new FileInputStream(userConfigPath.toFile());){
                    prop.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (prop.size() < 1) {
            prop.put("app.default-user", env.getProperty("app.default-admin-user"));
            prop.put("app.default-pass", env.getProperty("app.default-admin-pass"));
            prop.put("app.default-shell", "auto");
        }
        for (String propName : prop.stringPropertyNames()) {
            System.setProperty(propName, prop.getProperty(propName));
        }
    }

    public static void checkAndConfigureSSL() {
        try {
            Path certPath = CONFIG_PATH.resolve("cert.p12");
            Path certConf = CONFIG_PATH.resolve("cert.properties");
            if (!Files.exists(certConf, new LinkOption[0])) {
                ConfigManager.createSelfSignedCertificate((Path)certPath, (Path)certConf);
            }
            System.out.println("Loading existing certificate");
            Properties certProp = new Properties();
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream in = new FileInputStream(certConf.toFile());){
                certProp.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            System.setProperty("server.ssl.key-store-password", certProp.getProperty("key-store-password"));
            System.setProperty("server.ssl.key-alias", certProp.getProperty("key-alias"));
            System.setProperty("server.ssl.key-store", certPath.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void createSelfSignedCertificate(Path certPath, Path certConf) throws IOException, NoSuchAlgorithmException, OperatorCreationException, CertificateException, KeyStoreException {
        String keystorePassword = UUID.randomUUID().toString();
        X509Certificate cert = null;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(new X500Name("CN=easy.webshell.app, O=easy.webshell.app, L=easy.webshell.app, ST=il, C=c"), BigInteger.valueOf(System.currentTimeMillis()), new Date(System.currentTimeMillis() - 86400000L), new Date(System.currentTimeMillis() + 315360000000L), new X500Name("CN=easy.webshell.app, O=easy.webshell.app, L=easy.webshell.app, ST=il, C=c"), SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder("SHA256withRSA");
        ContentSigner signer = builder.build(keyPair.getPrivate());
        byte[] certBytes = certBuilder.build(signer).getEncoded();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry("webshell-cert", keyPair.getPrivate(), keystorePassword.toCharArray(), new Certificate[]{cert});
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (FileOutputStream out = new FileOutputStream(certPath.toFile());){
            keyStore.store(out, keystorePassword.toCharArray());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Properties certProps = new Properties();
        certProps.setProperty("key-store-password", keystorePassword);
        certProps.setProperty("key-alias", "webshell-cert");
        certProps.setProperty("key-store", certPath.toString());
        throwable2 = null;
        Object var14_17 = null;
        try (FileOutputStream out = new FileOutputStream(certConf.toFile());){
            certProps.store(out, "Easy webshell self signed certificate details");
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        System.out.println("Self signed certificate created");
    }
}

