/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.files;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webshell.app.files.FileInfo;
import webshell.app.files.FileTypeDetector;
import webshell.app.files.SearchOperations;
import webshell.app.files.search.SearchResult;

@Service
public class FileService {
    private boolean posix = !System.getProperty("os.name").toLowerCase().contains("windows");
    @Autowired
    private SearchOperations searchOp;
    @Autowired
    private FileTypeDetector typeDetector;

    public String createSearch(String folder, String searchText) {
        return this.searchOp.createSearchTask(folder, searchText);
    }

    public void cancelSearch(String id) {
        this.searchOp.cancelSearch(id);
    }

    public SearchResult getSearchResult(String id, int fileIndex, int folderIndex) {
        return this.searchOp.getSearchResult(id, fileIndex, folderIndex);
    }

    private String getFileType(File f) {
        return this.typeDetector.getType(f);
    }

    public List<FileInfo> list(String path) {
        System.out.println("Listing file: " + path);
        File[] files = new File(path).listFiles();
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        if (files == null) {
            return list;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            FileInfo info = new FileInfo(f.getName(), f.getAbsolutePath(), null, null, f.isDirectory() ? "Directory" : this.getFileType(f), f.length(), -1L, new Date(f.lastModified()), this.posix);
            Set<PosixFilePermission> filePerm = null;
            try {
                filePerm = Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]);
                String permission = PosixFilePermissions.toString(filePerm);
                info.setPermissionString(permission);
                FileOwnerAttributeView fv = Files.getFileAttributeView(f.toPath(), FileOwnerAttributeView.class, new LinkOption[0]);
                info.setUser(fv.getOwner().getName());
            }
            catch (Exception e) {
                info.setPermissionString("---");
            }
            list.add(info);
            ++n2;
        }
        list.sort((a, b) -> {
            String type1 = a.getType();
            String type2 = b.getType();
            if (type1.equals("Directory") && type2.equals("Directory")) {
                return 0;
            }
            if (type1.equals("Directory")) {
                return -1;
            }
            if (type2.equals("Directory")) {
                return 1;
            }
            return 0;
        });
        return list;
    }

    public void setText(String path, String text) throws Exception {
        Files.writeString(Paths.get(path, new String[0]), (CharSequence)text, new OpenOption[0]);
    }

    public String getText(String path) throws Exception {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])), "utf-8");
    }
}

