/*
 * Decompiled with CFR 0.152.
 */
package webshell.app.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class WebshellUserDetailsService
implements UserDetailsService {
    Properties users = new Properties();

    public WebshellUserDetailsService() {
        this.loadProperties();
    }

    private void loadProperties() {
        File f;
        this.users.clear();
        String propertyPath = System.getenv("easy-web-shell.config-path");
        if (propertyPath == null) {
            propertyPath = System.getProperty("user.home");
        }
        if ((f = new File(propertyPath, ".users")).exists()) {
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (FileInputStream in = new FileInputStream(f);){
                    this.users.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.users.size() < 1) {
            this.users.put("admin", "admin");
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (!this.users.containsKey(username)) {
            return null;
        }
        String password = this.users.getProperty(username);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        return new User(username, password, authorities);
    }
}

