/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class StrAfter
implements Function {
    public String getURI() {
        return ((Object)FN.SUBSTRING_AFTER).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for STRAFTER: " + args.length);
        }
        Value leftArg = args[0];
        Value rightArg = args[1];
        if (leftArg instanceof Literal && rightArg instanceof Literal) {
            Literal leftLit = (Literal)leftArg;
            Literal rightLit = (Literal)rightArg;
            String leftLanguage = leftLit.getLanguage();
            String rightLanguage = rightLit.getLanguage();
            URI leftDt = leftLit.getDatatype();
            URI rightDt = rightLit.getDatatype();
            if (!(leftLanguage == null && leftDt != null && !((Object)XMLSchema.STRING).equals(leftDt) || rightLanguage != null && !rightLanguage.equals(leftLanguage) || rightDt != null && !((Object)XMLSchema.STRING).equals(rightDt))) {
                String lexicalValue = leftLit.getLabel();
                String substring = rightLit.getLabel();
                int index = lexicalValue.indexOf(substring);
                String substringAfter = "";
                if (index > -1) {
                    substringAfter = lexicalValue.substring((index += substring.length() - 1) + 1, lexicalValue.length());
                }
                if (leftLanguage != null) {
                    return valueFactory.createLiteral(substringAfter, leftLanguage);
                }
                if (leftDt != null) {
                    return valueFactory.createLiteral(substringAfter, leftDt);
                }
                return valueFactory.createLiteral(substringAfter);
            }
            throw new ValueExprEvaluationException("incompatible operands for STRAFTER: " + leftArg + ", " + rightArg);
        }
        throw new ValueExprEvaluationException("incompatible operands for STRAFTER: " + leftArg + ", " + rightArg);
    }
}

