/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import org.openjena.atlas.logging.Log;

public class AggCount
extends AggregatorBase {
    @Override
    public Aggregator copy(Expr expr) {
        if (expr != null) {
            Log.warn(this, "Copying non-null expression for COUNT(*)");
        }
        return new AggCount();
    }

    @Override
    public Expr getExpr() {
        return null;
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCount();
    }

    @Override
    public String toString() {
        return "count(*)";
    }

    @Override
    public String toPrefixString() {
        return "(count)";
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    @Override
    public int hashCode() {
        return 370;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AggCount;
    }

    static class AccCount
    implements Accumulator {
        private long count = 0L;

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

