/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.graph.GraphBase2;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GraphMemSimple2
extends GraphBase2 {
    private Set<Triple> triples = new HashSet<Triple>();

    @Override
    public void performAdd(Triple t) {
        this.triples.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.triples.remove(t);
    }

    @Override
    public QueryHandler queryHandler() {
        return new SimpleQueryHandler((Graph)this);
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return new PrefixMappingImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean graphBaseContains(Triple t) {
        if (t.isConcrete()) {
            return this.triples.contains(t);
        }
        ExtendedIterator<Triple> it = this.find((TripleMatch)t);
        try {
            while (it.hasNext()) {
                Triple t2 = (Triple)it.next();
                if (!GraphMemSimple2.tripleContained(t, t2)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            it.close();
        }
        return false;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        Iterator<Triple> iter = this.triples.iterator();
        return SimpleEventManager.notifyingRemove((Graph)this, iter).filterKeep((Filter)new TripleMatchFilterEquality(m.asTriple()));
    }

    static boolean tripleContained(Triple patternTriple, Triple dataTriple) {
        return GraphMemSimple2.equalNode(patternTriple.getSubject(), dataTriple.getSubject()) && GraphMemSimple2.equalNode(patternTriple.getPredicate(), dataTriple.getPredicate()) && GraphMemSimple2.equalNode(patternTriple.getObject(), dataTriple.getObject());
    }

    private static boolean equalNode(Node m, Node n) {
        n = GraphMemSimple2.fixupNode(n);
        return (m = GraphMemSimple2.fixupNode(m)) == null || m == Node.ANY || m.equals((Object)n);
    }

    private static Node fixupNode(Node node) {
        String lang;
        if (node == null || node == Node.ANY) {
            return node;
        }
        if (node.isLiteral() && (lang = node.getLiteralLanguage()) != null && !lang.equals("")) {
            node = Node.createLiteral((String)node.getLiteralLexicalForm(), (String)lang.toLowerCase(), (RDFDatatype)node.getLiteralDatatype());
        }
        return node;
    }

    static class TripleMatchFilterEquality
    extends Filter<Triple> {
        protected final Triple tMatch;

        public TripleMatchFilterEquality(Triple tMatch) {
            this.tMatch = tMatch;
        }

        public boolean accept(Triple t) {
            return GraphMemSimple2.tripleContained(this.tMatch, t);
        }
    }
}

