/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.data;

import org.openjena.atlas.data.ThresholdPolicy;

public class ThresholdPolicyCount<T>
implements ThresholdPolicy<T> {
    protected final long threshold;
    protected long count;

    public ThresholdPolicyCount(long threshold) {
        if (threshold < 0L) {
            throw new IllegalArgumentException("Threshold must be greater than or equal to zero");
        }
        this.threshold = threshold;
        this.reset();
    }

    @Override
    public void increment(T item) {
        ++this.count;
    }

    @Override
    public boolean isThresholdExceeded() {
        return this.count >= this.threshold;
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public long getCount() {
        return this.count;
    }

    public String toString() {
        return "ThresholdPolicyCount:  Threshold=" + this.threshold + "  Count=" + this.count;
    }
}

