/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io;

import java.util.Stack;
import org.openjena.atlas.json.JsonArray;
import org.openjena.atlas.json.JsonBoolean;
import org.openjena.atlas.json.JsonNull;
import org.openjena.atlas.json.JsonNumber;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.json.JsonString;
import org.openjena.atlas.json.JsonValue;
import org.openjena.atlas.json.io.JSONHandler;
import org.openjena.atlas.lib.InternalErrorException;
import org.openjena.atlas.logging.Log;

public class JSONMaker
implements JSONHandler {
    private JsonValue value = null;
    private Stack<JsonArray> arrays = new Stack();
    private Stack<JsonObject> objects = new Stack();
    private Stack<String> keys = new Stack();

    public JsonValue jsonValue() {
        return this.value;
    }

    @Override
    public void startParse(long currLine, long currCol) {
    }

    @Override
    public void finishParse(long currLine, long currCol) {
    }

    @Override
    public void startObject(long currLine, long currCol) {
        this.objects.push(new JsonObject());
    }

    @Override
    public void finishObject(long currLine, long currCol) {
        this.value = this.objects.pop();
    }

    @Override
    public void startArray(long currLine, long currCol) {
        this.arrays.push(new JsonArray());
    }

    @Override
    public void element(long currLine, long currCol) {
        this.arrays.peek().add(this.value);
        this.value = null;
    }

    @Override
    public void finishArray(long currLine, long currCol) {
        this.value = this.arrays.pop();
    }

    @Override
    public void startPair(long currLine, long currCol) {
    }

    @Override
    public void keyPair(long currLine, long currCol) {
        this.keys.push(this.value.getAsString().value());
    }

    @Override
    public void finishPair(long currLine, long currCol) {
        if (this.value == null) {
            throw new InternalErrorException("null for 'value' (bad finishPair() allignment)");
        }
        String k = this.keys.pop();
        JsonObject obj = this.objects.peek();
        if (obj.hasKey(k)) {
            Log.warn("JSON", "Duplicate key '" + k + "' for object [" + currLine + "," + currCol + "]");
        }
        obj.put(k, this.value);
        this.value = null;
    }

    @Override
    public void valueBoolean(boolean b, long currLine, long currCol) {
        this.value = new JsonBoolean(b);
    }

    @Override
    public void valueDecimal(String image, long currLine, long currCol) {
        this.value = JsonNumber.valueDecimal(image);
    }

    @Override
    public void valueDouble(String image, long currLine, long currCol) {
        this.value = JsonNumber.valueDouble(image);
    }

    @Override
    public void valueInteger(String image, long currLine, long currCol) {
        this.value = JsonNumber.valueInteger(image);
    }

    @Override
    public void valueNull(long currLine, long currCol) {
        this.value = JsonNull.instance;
    }

    @Override
    public void valueString(String image, long currLine, long currCol) {
        this.value = new JsonString(image);
    }
}

