/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.nio.IntBuffer;
import java.util.Comparator;
import java.util.List;

public class Alg {
    static int linearSearch(IntBuffer buff, int key) {
        return Alg.linearSearch(buff, 0, buff.limit(), key);
    }

    static int linearSearch(IntBuffer buff, int low, int high, int key) {
        int len = buff.limit();
        Alg.check(len, low, high);
        for (int i = low; i < high; ++i) {
            int k2 = buff.get(i);
            if (k2 == key) {
                return i;
            }
            if (k2 <= key) continue;
            return Alg.encodeIndex(i);
        }
        return Alg.encodeIndex(high);
    }

    public static final int encodeIndex(int i) {
        return -(i + 1);
    }

    public static final int decodeIndex(int i) {
        return -(i + 1);
    }

    public static int binarySearch(IntBuffer buff, int value) {
        return Alg.binarySearch(buff, 0, buff.limit(), value);
    }

    public static int binarySearch(IntBuffer buff, int low, int high, int value) {
        Alg.check(buff.limit(), low, high);
        --high;
        while (low <= high) {
            int mid = low + high >>> 1;
            int k = buff.get(mid);
            if (k < value) {
                low = mid + 1;
                continue;
            }
            if (k > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Alg.encodeIndex(low);
    }

    private static void check(int len, int low, int high) {
        if (low > high) {
            throw new IllegalArgumentException("Low index (" + low + ") is not less than high index (" + high + ")");
        }
        if (low < 0) {
            throw new ArrayIndexOutOfBoundsException("Low index is negative: " + low);
        }
        if (high > len) {
            throw new ArrayIndexOutOfBoundsException("High index is too large: " + high);
        }
    }

    public static <T> int binarySearch(List<T> array, int low, int high, T value, Comparator<T> comparator) {
        Alg.check(array.size(), low, high);
        --high;
        while (low <= high) {
            int mid = low + high >>> 1;
            T k = array.get(mid);
            int x = comparator.compare(k, value);
            if (x < 0) {
                low = mid + 1;
                continue;
            }
            if (x > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Alg.encodeIndex(low);
    }

    public static <T extends Comparable<? super T>> int binarySearch(T[] array, int low, int high, T value) {
        Alg.check(array.length, low, high);
        --high;
        while (low <= high) {
            int mid = low + high >>> 1;
            T k = array[mid];
            int x = k.compareTo(value);
            if (x < 0) {
                low = mid + 1;
                continue;
            }
            if (x > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Alg.encodeIndex(low);
    }
}

